import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [workspaces](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspaces.html).
 *
 * @experimental
 */
export declare class Workspaces extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [workspaces](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspaces.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate connection aliases with directories.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_AssociateConnectionAlias.html
     *
     * @experimental
     */
    toAssociateConnectionAlias(): this;
    /**
     * (experimental) Grants permission to associate IP access control groups with directories.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_AssociateIpGroups.html
     *
     * @experimental
     */
    toAssociateIpGroups(): this;
    /**
     * (experimental) Grants permission to add rules to IP access control groups.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_AuthorizeIpRules.html
     *
     * @experimental
     */
    toAuthorizeIpRules(): this;
    /**
     * (experimental) Grants permission to copy a WorkSpace image.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - workspaces:DescribeWorkspaceImages
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CopyWorkspaceImage.html
     *
     * @experimental
     */
    toCopyWorkspaceImage(): this;
    /**
     * (experimental) Grants permission to create connection aliases for use with cross-Region redirection.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateConnectionAlias.html
     *
     * @experimental
     */
    toCreateConnectionAlias(): this;
    /**
     * (experimental) Grants permission to create IP access control groups.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateIpGroup.html
     *
     * @experimental
     */
    toCreateIpGroup(): this;
    /**
     * (experimental) Grants permission to create tags for WorkSpaces resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateTags.html
     *
     * @experimental
     */
    toCreateTags(): this;
    /**
     * (experimental) Grants permission to create a WorkSpace bundle.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - workspaces:CreateTags
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateWorkspaceBundle.html
     *
     * @experimental
     */
    toCreateWorkspaceBundle(): this;
    /**
     * (experimental) Grants permission to create one or more WorkSpaces.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateWorkspaces.html
     *
     * @experimental
     */
    toCreateWorkspaces(): this;
    /**
     * (experimental) Grants permission to delete connection aliases.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteConnectionAlias.html
     *
     * @experimental
     */
    toDeleteConnectionAlias(): this;
    /**
     * (experimental) Grants permission to delete IP access control groups.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteIpGroup.html
     *
     * @experimental
     */
    toDeleteIpGroup(): this;
    /**
     * (experimental) Grants permission to delete tags from WorkSpaces resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteTags.html
     *
     * @experimental
     */
    toDeleteTags(): this;
    /**
     * (experimental) Grants permission to delete WorkSpace bundles.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteWorkspaceBundle.html
     *
     * @experimental
     */
    toDeleteWorkspaceBundle(): this;
    /**
     * (experimental) Grants permission to delete WorkSpace images.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteWorkspaceImage.html
     *
     * @experimental
     */
    toDeleteWorkspaceImage(): this;
    /**
     * (experimental) Grants permission to deregister directories from use with Amazon WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeregisterWorkspaceDirectory.html
     *
     * @experimental
     */
    toDeregisterWorkspaceDirectory(): this;
    /**
     * (experimental) Grants permission to retrieve the configuration of Bring Your Own License (BYOL) for WorkSpaces accounts.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeAccount.html
     *
     * @experimental
     */
    toDescribeAccount(): this;
    /**
     * (experimental) Grants permission to retrieve modifications to the configuration of Bring Your Own License (BYOL) for WorkSpaces accounts.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeAccountModifications.html
     *
     * @experimental
     */
    toDescribeAccountModifications(): this;
    /**
     * (experimental) Grants permission to retrieve information about WorkSpaces clients.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeClientProperties.html
     *
     * @experimental
     */
    toDescribeClientProperties(): this;
    /**
     * (experimental) Grants permission to retrieve the permissions that the owners of connection aliases have granted to other AWS accounts for connection aliases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliasPermissions.html
     *
     * @experimental
     */
    toDescribeConnectionAliasPermissions(): this;
    /**
     * (experimental) Grants permission to retrieve a list that describes the connection aliases used for cross-Region redirection.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html
     *
     * @experimental
     */
    toDescribeConnectionAliases(): this;
    /**
     * (experimental) Grants permission to retrieve information about IP access control groups.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeIpGroups.html
     *
     * @experimental
     */
    toDescribeIpGroups(): this;
    /**
     * (experimental) Grants permission to describe the tags for WorkSpaces resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeTags.html
     *
     * @experimental
     */
    toDescribeTags(): this;
    /**
     * (experimental) Grants permission to obtain information about WorkSpace bundles.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceBundles.html
     *
     * @experimental
     */
    toDescribeWorkspaceBundles(): this;
    /**
     * (experimental) Grants permission to retrieve information about directories that are registered with WorkSpaces.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html
     *
     * @experimental
     */
    toDescribeWorkspaceDirectories(): this;
    /**
     * (experimental) Grants permission to retrieve information about WorkSpace image permissions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html
     *
     * @experimental
     */
    toDescribeWorkspaceImagePermissions(): this;
    /**
     * (experimental) Grants permission to retrieve information about WorkSpace images.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html
     *
     * @experimental
     */
    toDescribeWorkspaceImages(): this;
    /**
     * (experimental) Grants permission to retrieve information about WorkSpace snapshots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceSnapshots.html
     *
     * @experimental
     */
    toDescribeWorkspaceSnapshots(): this;
    /**
     * (experimental) Grants permission to obtain information about WorkSpaces.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html
     *
     * @experimental
     */
    toDescribeWorkspaces(): this;
    /**
     * (experimental) Grants permission to obtain the connection status of WorkSpaces.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspacesConnectionStatus.html
     *
     * @experimental
     */
    toDescribeWorkspacesConnectionStatus(): this;
    /**
     * (experimental) Grants permission to disassociate connection aliases from directories.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DisassociateConnectionAlias.html
     *
     * @experimental
     */
    toDisassociateConnectionAlias(): this;
    /**
     * (experimental) Grants permission to disassociate IP access control groups from directories.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DisassociateIpGroups.html
     *
     * @experimental
     */
    toDisassociateIpGroups(): this;
    /**
     * (experimental) Grants permission to import Bring Your Own License (BYOL) images into Amazon WorkSpaces.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeImages
     * - ec2:ModifyImageAttribute
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ImportWorkspaceImage.html
     *
     * @experimental
     */
    toImportWorkspaceImage(): this;
    /**
     * (experimental) Grants permission to list the available CIDR ranges for enabling Bring Your Own License (BYOL) for WorkSpaces accounts.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ListAvailableManagementCidrRanges.html
     *
     * @experimental
     */
    toListAvailableManagementCidrRanges(): this;
    /**
     * (experimental) Grants permission to migrate WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_MigrateWorkspace.html
     *
     * @experimental
     */
    toMigrateWorkspace(): this;
    /**
     * (experimental) Grants permission to modify the configuration of Bring Your Own License (BYOL) for WorkSpaces accounts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyAccount.html
     *
     * @experimental
     */
    toModifyAccount(): this;
    /**
     * (experimental) Grants permission to modify the properties of WorkSpaces clients.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyClientProperties.html
     *
     * @experimental
     */
    toModifyClientProperties(): this;
    /**
     * (experimental) Grants permission to modify the self-service WorkSpace management capabilities for your users.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifySelfservicePermissions.html
     *
     * @experimental
     */
    toModifySelfservicePermissions(): this;
    /**
     * (experimental) Grants permission to specify which devices and operating systems users can use to access their WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyWorkspaceAccessProperties.html
     *
     * @experimental
     */
    toModifyWorkspaceAccessProperties(): this;
    /**
     * (experimental) Grants permission to modify the default properties used to create WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyWorkspaceCreationProperties.html
     *
     * @experimental
     */
    toModifyWorkspaceCreationProperties(): this;
    /**
     * (experimental) Grants permission to modify WorkSpace properties, including the running mode and the AutoStop period.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyWorkspaceProperties.html
     *
     * @experimental
     */
    toModifyWorkspaceProperties(): this;
    /**
     * (experimental) Grants permission to modify the state of WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyWorkspaceState.html
     *
     * @experimental
     */
    toModifyWorkspaceState(): this;
    /**
     * (experimental) Grants permission to reboot WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RebootWorkspaces.html
     *
     * @experimental
     */
    toRebootWorkspaces(): this;
    /**
     * (experimental) Grants permission to rebuild WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RebuildWorkspaces.html
     *
     * @experimental
     */
    toRebuildWorkspaces(): this;
    /**
     * (experimental) Grants permission to register directories for use with Amazon WorkSpaces.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RegisterWorkspaceDirectory.html
     *
     * @experimental
     */
    toRegisterWorkspaceDirectory(): this;
    /**
     * (experimental) Grants permission to restore WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RestoreWorkspace.html
     *
     * @experimental
     */
    toRestoreWorkspace(): this;
    /**
     * (experimental) Grants permission to remove rules from IP access control groups.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RevokeIpRules.html
     *
     * @experimental
     */
    toRevokeIpRules(): this;
    /**
     * (experimental) Grants permission to start AutoStop WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_StartWorkspaces.html
     *
     * @experimental
     */
    toStartWorkspaces(): this;
    /**
     * (experimental) Grants permission to stop AutoStop WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_StopWorkspaces.html
     *
     * @experimental
     */
    toStopWorkspaces(): this;
    /**
     * (experimental) Grants permission to terminate WorkSpaces.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_TerminateWorkspaces.html
     *
     * @experimental
     */
    toTerminateWorkspaces(): this;
    /**
     * (experimental) Grants permission to share or unshare connection aliases with other accounts.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateConnectionAliasPermission.html
     *
     * @experimental
     */
    toUpdateConnectionAliasPermission(): this;
    /**
     * (experimental) Grants permission to replace rules for IP access control groups.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateRulesOfIpGroup.html
     *
     * @experimental
     */
    toUpdateRulesOfIpGroup(): this;
    /**
     * (experimental) Grants permission to update the WorkSpace images used in WorkSpace bundles.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateWorkspaceBundle.html
     *
     * @experimental
     */
    toUpdateWorkspaceBundle(): this;
    /**
     * (experimental) Grants permission to share or unshare WorkSpace images with other accounts by specifying whether other accounts have permission to copy the image.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateWorkspaceImagePermission.html
     *
     * @experimental
     */
    toUpdateWorkspaceImagePermission(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type directoryid to the statement.
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/manage-workspaces-directory.html
     *
     * @param directoryId - Identifier for the directoryId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDirectoryid(directoryId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type workspacebundle to the statement.
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/bundles.html
     *
     * @param bundleId - Identifier for the bundleId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkspacebundle(bundleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type workspaceid to the statement.
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/wsp_workspace_management.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkspaceid(workspaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type workspaceimage to the statement.
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/bundles.html
     *
     * @param imageId - Identifier for the imageId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkspaceimage(imageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type workspaceipgroup to the statement.
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-ip-access-control-groups.html
     *
     * @param groupId - Identifier for the groupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkspaceipgroup(groupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type connectionalias to the statement.
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html
     *
     * @param connectionAliasId - Identifier for the connectionAliasId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onConnectionalias(connectionAliasId: string, account?: string, region?: string, partition?: string): this;
}
