# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-01-28 18:20

from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [("comms", "0016_auto_20180925_1735")]

    operations = [
        migrations.AlterField(
            model_name="channeldb",
            name="db_account_subscriptions",
            field=models.ManyToManyField(
                blank=True,
                db_index=True,
                related_name="account_subscription_set",
                to=settings.AUTH_USER_MODEL,
                verbose_name="account subscriptions",
            ),
        ),
        migrations.AlterField(
            model_name="channeldb",
            name="db_attributes",
            field=models.ManyToManyField(
                help_text="attributes on this object. An attribute can hold any pickle-able python object (see docs for special cases).",
                to="typeclasses.Attribute",
            ),
        ),
        migrations.AlterField(
            model_name="channeldb",
            name="db_date_created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="creation date"),
        ),
        migrations.AlterField(
            model_name="channeldb",
            name="db_key",
            field=models.CharField(db_index=True, max_length=255, verbose_name="key"),
        ),
        migrations.AlterField(
            model_name="channeldb",
            name="db_lock_storage",
            field=models.TextField(
                blank=True,
                help_text="locks limit access to an entity. A lock is defined as a 'lock string' on the form 'type:lockfunctions', defining what functionality is locked and how to determine access. Not defining a lock means no access is granted.",
                verbose_name="locks",
            ),
        ),
        migrations.AlterField(
            model_name="channeldb",
            name="db_object_subscriptions",
            field=models.ManyToManyField(
                blank=True,
                db_index=True,
                related_name="object_subscription_set",
                to="objects.ObjectDB",
                verbose_name="object subscriptions",
            ),
        ),
        migrations.AlterField(
            model_name="channeldb",
            name="db_tags",
            field=models.ManyToManyField(
                help_text="tags on this object. Tags are simple string markers to identify, group and alias objects.",
                to="typeclasses.Tag",
            ),
        ),
        migrations.AlterField(
            model_name="channeldb",
            name="db_typeclass_path",
            field=models.CharField(
                help_text="this defines what 'type' of entity this is. This variable holds a Python path to a module with a valid Evennia Typeclass.",
                max_length=255,
                null=True,
                verbose_name="typeclass",
            ),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_date_created",
            field=models.DateTimeField(auto_now_add=True, db_index=True, verbose_name="date sent"),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_header",
            field=models.TextField(blank=True, null=True, verbose_name="header"),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_lock_storage",
            field=models.TextField(
                blank=True, help_text="access locks on this message.", verbose_name="locks"
            ),
        ),
        migrations.AlterField(
            model_name="msg", name="db_message", field=models.TextField(verbose_name="message")
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_receivers_accounts",
            field=models.ManyToManyField(
                blank=True,
                help_text="account receivers",
                related_name="receiver_account_set",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_receivers_channels",
            field=models.ManyToManyField(
                blank=True,
                help_text="channel recievers",
                related_name="channel_set",
                to="comms.ChannelDB",
            ),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_receivers_objects",
            field=models.ManyToManyField(
                blank=True,
                help_text="object receivers",
                related_name="receiver_object_set",
                to="objects.ObjectDB",
            ),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_receivers_scripts",
            field=models.ManyToManyField(
                blank=True,
                help_text="script_receivers",
                related_name="receiver_script_set",
                to="scripts.ScriptDB",
            ),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_sender_accounts",
            field=models.ManyToManyField(
                blank=True,
                db_index=True,
                related_name="sender_account_set",
                to=settings.AUTH_USER_MODEL,
                verbose_name="sender(account)",
            ),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_sender_external",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="identifier for external sender, for example a sender over an IRC connection (i.e. someone who doesn't have an exixtence in-game).",
                max_length=255,
                null=True,
                verbose_name="external sender",
            ),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_sender_objects",
            field=models.ManyToManyField(
                blank=True,
                db_index=True,
                related_name="sender_object_set",
                to="objects.ObjectDB",
                verbose_name="sender(object)",
            ),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_sender_scripts",
            field=models.ManyToManyField(
                blank=True,
                db_index=True,
                related_name="sender_script_set",
                to="scripts.ScriptDB",
                verbose_name="sender(script)",
            ),
        ),
        migrations.AlterField(
            model_name="msg",
            name="db_tags",
            field=models.ManyToManyField(
                blank=True,
                help_text="tags on this message. Tags are simple string markers to identify, group and alias messages.",
                to="typeclasses.Tag",
            ),
        ),
    ]
