# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-01-28 18:20

import re

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [("objects", "0009_remove_objectdb_db_player")]

    operations = [
        migrations.AlterField(
            model_name="objectdb",
            name="db_account",
            field=models.ForeignKey(
                help_text="an Account connected to this object, if any.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
                verbose_name="account",
            ),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_attributes",
            field=models.ManyToManyField(
                help_text="attributes on this object. An attribute can hold any pickle-able python object (see docs for special cases).",
                to="typeclasses.Attribute",
            ),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_cmdset_storage",
            field=models.CharField(
                blank=True,
                help_text="optional python path to a cmdset class.",
                max_length=255,
                null=True,
                verbose_name="cmdset",
            ),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_date_created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="creation date"),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_destination",
            field=models.ForeignKey(
                blank=True,
                help_text="a destination, used only by exit objects.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="destinations_set",
                to="objects.ObjectDB",
                verbose_name="destination",
            ),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_home",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="homes_set",
                to="objects.ObjectDB",
                verbose_name="home location",
            ),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_key",
            field=models.CharField(db_index=True, max_length=255, verbose_name="key"),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_location",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="locations_set",
                to="objects.ObjectDB",
                verbose_name="game location",
            ),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_lock_storage",
            field=models.TextField(
                blank=True,
                help_text="locks limit access to an entity. A lock is defined as a 'lock string' on the form 'type:lockfunctions', defining what functionality is locked and how to determine access. Not defining a lock means no access is granted.",
                verbose_name="locks",
            ),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_sessid",
            field=models.CharField(
                help_text="csv list of session ids of connected Account, if any.",
                max_length=32,
                null=True,
                validators=[
                    django.core.validators.RegexValidator(
                        re.compile("^\\d+(?:\\,\\d+)*\\Z", 32),
                        code="invalid",
                        message="Enter only digits separated by commas.",
                    )
                ],
                verbose_name="session id",
            ),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_tags",
            field=models.ManyToManyField(
                help_text="tags on this object. Tags are simple string markers to identify, group and alias objects.",
                to="typeclasses.Tag",
            ),
        ),
        migrations.AlterField(
            model_name="objectdb",
            name="db_typeclass_path",
            field=models.CharField(
                help_text="this defines what 'type' of entity this is. This variable holds a Python path to a module with a valid Evennia Typeclass.",
                max_length=255,
                null=True,
                verbose_name="typeclass",
            ),
        ),
    ]
