# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-07-05 17:27


import django.db.models.deletion
from django.db import connection, migrations, models


def _table_exists(db_cursor, tablename):
    "Returns bool if table exists or not"
    return tablename in connection.introspection.table_names()


class Migration(migrations.Migration):

    dependencies = [
        ("accounts", "0007_copy_player_to_account"),
        ("scripts", "0008_auto_20170606_1731"),
    ]

    db_cursor = connection.cursor()
    operations = []
    if _table_exists(db_cursor, "players_playerdb"):
        # OBS - this is run BEFORE migrations even start, so if we have a player table
        # here we are not starting from scratch.
        operations = [
            migrations.AddField(
                model_name="scriptdb",
                name="db_account",
                field=models.ForeignKey(
                    blank=True,
                    help_text="the account to store this script on (should not be set if db_obj is set)",
                    null=True,
                    on_delete=django.db.models.deletion.CASCADE,
                    to="accounts.AccountDB",
                    verbose_name="scripted account",
                ),
            )
        ]
