# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-07-05 17:36


from django.db import migrations


def forwards(apps, schema_editor):

    try:
        apps.get_model("accounts", "AccountDB")
    except LookupError:
        return
    AccountDB = apps.get_model("accounts", "AccountDB")
    ScriptDB = apps.get_model("scripts", "ScriptDB")

    for script in ScriptDB.objects.all():
        account = script.db_account
        if account:
            account = AccountDB.objects.get(id=account.id)
            script.db_account = account
            script.save(update_fields=["db_account"])


class Migration(migrations.Migration):

    dependencies = [("scripts", "0009_scriptdb_db_account")]

    operations = [migrations.RunPython(forwards)]
