
from typing import Any
from typing import Callable
from typing import Optional
from typing import overload

from gi.repository import GLib
from gi.repository import GObject

AsyncReadyCallbackU = Callable[[Any, AsyncResult, Any], None]
AsyncReadyCallback = Callable[[Any, AsyncResult], None]


DBUS_METHOD_INVOCATION_HANDLED: bool = ...
DBUS_METHOD_INVOCATION_UNHANDLED = ...
DESKTOP_APP_INFO_LOOKUP_EXTENSION_POINT_NAME: str = ...
DRIVE_IDENTIFIER_KIND_UNIX_DEVICE: str = ...
FILE_ATTRIBUTE_ACCESS_CAN_DELETE: str = ...
FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE: str = ...
FILE_ATTRIBUTE_ACCESS_CAN_READ: str = ...
FILE_ATTRIBUTE_ACCESS_CAN_RENAME: str = ...
FILE_ATTRIBUTE_ACCESS_CAN_TRASH: str = ...
FILE_ATTRIBUTE_ACCESS_CAN_WRITE: str = ...
FILE_ATTRIBUTE_DOS_IS_ARCHIVE: str = ...
FILE_ATTRIBUTE_DOS_IS_MOUNTPOINT: str = ...
FILE_ATTRIBUTE_DOS_IS_SYSTEM: str = ...
FILE_ATTRIBUTE_DOS_REPARSE_POINT_TAG: str = ...
FILE_ATTRIBUTE_ETAG_VALUE: str = ...
FILE_ATTRIBUTE_FILESYSTEM_FREE: str = ...
FILE_ATTRIBUTE_FILESYSTEM_READONLY: str = ...
FILE_ATTRIBUTE_FILESYSTEM_REMOTE: str = ...
FILE_ATTRIBUTE_FILESYSTEM_SIZE: str = ...
FILE_ATTRIBUTE_FILESYSTEM_TYPE: str = ...
FILE_ATTRIBUTE_FILESYSTEM_USED: str = ...
FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW: str = ...
FILE_ATTRIBUTE_GVFS_BACKEND: str = ...
FILE_ATTRIBUTE_ID_FILE: str = ...
FILE_ATTRIBUTE_ID_FILESYSTEM: str = ...
FILE_ATTRIBUTE_MOUNTABLE_CAN_EJECT: str = ...
FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT: str = ...
FILE_ATTRIBUTE_MOUNTABLE_CAN_POLL: str = ...
FILE_ATTRIBUTE_MOUNTABLE_CAN_START: str = ...
FILE_ATTRIBUTE_MOUNTABLE_CAN_START_DEGRADED: str = ...
FILE_ATTRIBUTE_MOUNTABLE_CAN_STOP: str = ...
FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT: str = ...
FILE_ATTRIBUTE_MOUNTABLE_HAL_UDI: str = ...
FILE_ATTRIBUTE_MOUNTABLE_IS_MEDIA_CHECK_AUTOMATIC: str = ...
FILE_ATTRIBUTE_MOUNTABLE_START_STOP_TYPE: str = ...
FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE: str = ...
FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE_FILE: str = ...
FILE_ATTRIBUTE_OWNER_GROUP: str = ...
FILE_ATTRIBUTE_OWNER_USER: str = ...
FILE_ATTRIBUTE_OWNER_USER_REAL: str = ...
FILE_ATTRIBUTE_PREVIEW_ICON: str = ...
FILE_ATTRIBUTE_RECENT_MODIFIED: str = ...
FILE_ATTRIBUTE_SELINUX_CONTEXT: str = ...
FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE: str = ...
FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE: str = ...
FILE_ATTRIBUTE_STANDARD_COPY_NAME: str = ...
FILE_ATTRIBUTE_STANDARD_DESCRIPTION: str = ...
FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME: str = ...
FILE_ATTRIBUTE_STANDARD_EDIT_NAME: str = ...
FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE: str = ...
FILE_ATTRIBUTE_STANDARD_ICON: str = ...
FILE_ATTRIBUTE_STANDARD_IS_BACKUP: str = ...
FILE_ATTRIBUTE_STANDARD_IS_HIDDEN: str = ...
FILE_ATTRIBUTE_STANDARD_IS_SYMLINK: str = ...
FILE_ATTRIBUTE_STANDARD_IS_VIRTUAL: str = ...
FILE_ATTRIBUTE_STANDARD_IS_VOLATILE: str = ...
FILE_ATTRIBUTE_STANDARD_NAME: str = ...
FILE_ATTRIBUTE_STANDARD_SIZE: str = ...
FILE_ATTRIBUTE_STANDARD_SORT_ORDER: str = ...
FILE_ATTRIBUTE_STANDARD_SYMBOLIC_ICON: str = ...
FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET: str = ...
FILE_ATTRIBUTE_STANDARD_TARGET_URI: str = ...
FILE_ATTRIBUTE_STANDARD_TYPE: str = ...
FILE_ATTRIBUTE_THUMBNAILING_FAILED: str = ...
FILE_ATTRIBUTE_THUMBNAIL_IS_VALID: str = ...
FILE_ATTRIBUTE_THUMBNAIL_PATH: str = ...
FILE_ATTRIBUTE_TIME_ACCESS: str = ...
FILE_ATTRIBUTE_TIME_ACCESS_USEC: str = ...
FILE_ATTRIBUTE_TIME_CHANGED: str = ...
FILE_ATTRIBUTE_TIME_CHANGED_USEC: str = ...
FILE_ATTRIBUTE_TIME_CREATED: str = ...
FILE_ATTRIBUTE_TIME_CREATED_USEC: str = ...
FILE_ATTRIBUTE_TIME_MODIFIED: str = ...
FILE_ATTRIBUTE_TIME_MODIFIED_USEC: str = ...
FILE_ATTRIBUTE_TRASH_DELETION_DATE: str = ...
FILE_ATTRIBUTE_TRASH_ITEM_COUNT: str = ...
FILE_ATTRIBUTE_TRASH_ORIG_PATH: str = ...
FILE_ATTRIBUTE_UNIX_BLOCKS: str = ...
FILE_ATTRIBUTE_UNIX_BLOCK_SIZE: str = ...
FILE_ATTRIBUTE_UNIX_DEVICE: str = ...
FILE_ATTRIBUTE_UNIX_GID: str = ...
FILE_ATTRIBUTE_UNIX_INODE: str = ...
FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT: str = ...
FILE_ATTRIBUTE_UNIX_MODE: str = ...
FILE_ATTRIBUTE_UNIX_NLINK: str = ...
FILE_ATTRIBUTE_UNIX_RDEV: str = ...
FILE_ATTRIBUTE_UNIX_UID: str = ...
MEMORY_MONITOR_EXTENSION_POINT_NAME: str = ...
MENU_ATTRIBUTE_ACTION: str = ...
MENU_ATTRIBUTE_ACTION_NAMESPACE: str = ...
MENU_ATTRIBUTE_ICON: str = ...
MENU_ATTRIBUTE_LABEL: str = ...
MENU_ATTRIBUTE_TARGET: str = ...
MENU_LINK_SECTION: str = ...
MENU_LINK_SUBMENU: str = ...
NATIVE_VOLUME_MONITOR_EXTENSION_POINT_NAME: str = ...
NETWORK_MONITOR_EXTENSION_POINT_NAME: str = ...
PROXY_EXTENSION_POINT_NAME: str = ...
PROXY_RESOLVER_EXTENSION_POINT_NAME: str = ...
SETTINGS_BACKEND_EXTENSION_POINT_NAME: str = ...
TLS_BACKEND_EXTENSION_POINT_NAME: str = ...
TLS_DATABASE_PURPOSE_AUTHENTICATE_CLIENT: str = ...
TLS_DATABASE_PURPOSE_AUTHENTICATE_SERVER: str = ...
VFS_EXTENSION_POINT_NAME: str = ...
VOLUME_IDENTIFIER_KIND_CLASS: str = ...
VOLUME_IDENTIFIER_KIND_HAL_UDI: str = ...
VOLUME_IDENTIFIER_KIND_LABEL: str = ...
VOLUME_IDENTIFIER_KIND_NFS_MOUNT: str = ...
VOLUME_IDENTIFIER_KIND_UNIX_DEVICE: str = ...
VOLUME_IDENTIFIER_KIND_UUID: str = ...
VOLUME_MONITOR_EXTENSION_POINT_NAME: str = ...
_introspection_module = ...
_namespace: str = ...
_overrides_module = ...
_version: str = ...

def action_name_is_valid(*args, **kwargs): ...
def action_parse_detailed_name(*args, **kwargs): ...
def action_print_detailed_name(*args, **kwargs): ...
def app_info_create_from_commandline(*args, **kwargs): ...
def app_info_get_all(*args, **kwargs): ...
def app_info_get_all_for_type(*args, **kwargs): ...
def app_info_get_default_for_type(*args, **kwargs): ...
def app_info_get_default_for_uri_scheme(*args, **kwargs): ...
def app_info_get_fallback_for_type(*args, **kwargs): ...
def app_info_get_recommended_for_type(*args, **kwargs): ...
def app_info_launch_default_for_uri(*args, **kwargs): ...
def app_info_launch_default_for_uri_async(*args, **kwargs): ...
def app_info_launch_default_for_uri_finish(*args, **kwargs): ...
def app_info_reset_type_associations(*args, **kwargs): ...
def async_initable_newv_async(*args, **kwargs): ...
def bus_get(*args, **kwargs): ...
def bus_get_finish(*args, **kwargs): ...
def bus_get_sync(bus_type: BusType, cancellable: Optional[Cancellable] = ...) -> DBusConnection: ...
def bus_own_name(*args, **kwargs): ...
def bus_own_name_on_connection(connection: DBusConnection, name: str, flags: BusNameOwnerFlags, name_acquired_closure: Optional[GObject.Closure], name_lost_closure: Optional[GObject.Closure]) -> int: ...
def bus_unown_name(*args, **kwargs): ...
def bus_unwatch_name(*args, **kwargs): ...
def bus_watch_name(bus_type: BusType, name: str, flags: BusNameWatcherFlags, name_appeared_closure: Optional[Callable[..., Any]] = ..., name_vanished_closure: Optional[Callable[..., Any]] = ...) -> int: ...
def bus_watch_name_on_connection(*args, **kwargs): ...
def content_type_can_be_executable(*args, **kwargs): ...
def content_type_equals(*args, **kwargs): ...
def content_type_from_mime_type(*args, **kwargs): ...
def content_type_get_description(*args, **kwargs): ...
def content_type_get_generic_icon_name(*args, **kwargs): ...
def content_type_get_icon(type: str) -> Icon: ...
def content_type_get_mime_dirs(*args, **kwargs): ...
def content_type_get_mime_type(*args, **kwargs): ...
def content_type_get_symbolic_icon(*args, **kwargs): ...
def content_type_guess(filename: Optional[str], data: Optional[bytes]) -> tuple[str, bool]: ...
def content_type_guess_for_tree(*args, **kwargs): ...
def content_type_is_a(*args, **kwargs): ...
def content_type_is_mime_type(*args, **kwargs): ...
def content_type_is_unknown(*args, **kwargs): ...
def content_type_set_mime_dirs(*args, **kwargs): ...
def content_types_get_registered(*args, **kwargs): ...
def dbus_address_escape_value(*args, **kwargs): ...
def dbus_address_get_for_bus_sync(*args, **kwargs): ...
def dbus_address_get_stream(*args, **kwargs): ...
def dbus_address_get_stream_finish(*args, **kwargs): ...
def dbus_address_get_stream_sync(*args, **kwargs): ...
def dbus_annotation_info_lookup(*args, **kwargs): ...
def dbus_error_encode_gerror(*args, **kwargs): ...
def dbus_error_get_remote_error(*args, **kwargs): ...
def dbus_error_is_remote_error(*args, **kwargs): ...
def dbus_error_new_for_dbus_error(*args, **kwargs): ...
def dbus_error_quark(*args, **kwargs): ...
def dbus_error_register_error(*args, **kwargs): ...
def dbus_error_register_error_domain(*args, **kwargs): ...
def dbus_error_strip_remote_error(*args, **kwargs): ...
def dbus_error_unregister_error(*args, **kwargs): ...
def dbus_escape_object_path(*args, **kwargs): ...
def dbus_escape_object_path_bytestring(*args, **kwargs): ...
def dbus_generate_guid(*args, **kwargs): ...
def dbus_gvalue_to_gvariant(*args, **kwargs): ...
def dbus_gvariant_to_gvalue(*args, **kwargs): ...
def dbus_is_address(*args, **kwargs): ...
def dbus_is_guid(*args, **kwargs): ...
def dbus_is_interface_name(*args, **kwargs): ...
def dbus_is_member_name(*args, **kwargs): ...
def dbus_is_name(*args, **kwargs): ...
def dbus_is_supported_address(*args, **kwargs): ...
def dbus_is_unique_name(*args, **kwargs): ...
def dbus_unescape_object_path(*args, **kwargs): ...
def dtls_client_connection_new(*args, **kwargs): ...
def dtls_server_connection_new(*args, **kwargs): ...
def file_new_for_commandline_arg(*args, **kwargs): ...
def file_new_for_commandline_arg_and_cwd(*args, **kwargs): ...
def file_new_for_path(*args, **kwargs): ...
def file_new_for_uri(*args, **kwargs): ...
def file_new_tmp(*args, **kwargs): ...
def file_parse_name(*args, **kwargs): ...
def icon_deserialize(*args, **kwargs): ...
def icon_hash(*args, **kwargs): ...
def icon_new_for_string(*args, **kwargs): ...
def initable_newv(*args, **kwargs): ...
def io_error_from_errno(*args, **kwargs): ...
def io_error_quark(*args, **kwargs): ...
def io_extension_point_implement(*args, **kwargs): ...
def io_extension_point_lookup(*args, **kwargs): ...
def io_extension_point_register(*args, **kwargs): ...
def io_modules_load_all_in_directory(*args, **kwargs): ...
def io_modules_load_all_in_directory_with_scope(*args, **kwargs): ...
def io_modules_scan_all_in_directory(*args, **kwargs): ...
def io_modules_scan_all_in_directory_with_scope(*args, **kwargs): ...
def io_scheduler_cancel_all_jobs(*args, **kwargs): ...
def io_scheduler_push_job(*args, **kwargs): ...
def keyfile_settings_backend_new(*args, **kwargs): ...
def memory_monitor_dup_default(*args, **kwargs): ...
def memory_settings_backend_new(*args, **kwargs): ...
def network_monitor_get_default(*args, **kwargs): ...
def networking_init(*args, **kwargs): ...
def null_settings_backend_new(*args, **kwargs): ...
def pollable_source_new(*args, **kwargs): ...
def pollable_source_new_full(*args, **kwargs): ...
def pollable_stream_read(*args, **kwargs): ...
def pollable_stream_write(*args, **kwargs): ...
def pollable_stream_write_all(*args, **kwargs): ...
def proxy_get_default_for_protocol(*args, **kwargs): ...
def proxy_resolver_get_default(*args, **kwargs): ...
def resolver_error_quark(*args, **kwargs): ...
def resource_error_quark(*args, **kwargs): ...
def resource_load(*args, **kwargs): ...
def resources_enumerate_children(*args, **kwargs): ...
def resources_get_info(*args, **kwargs): ...
def resources_lookup_data(path: str, lookup_flags: ResourceLookupFlags) -> Optional[GLib.Bytes]: ...
def resources_open_stream(*args, **kwargs): ...
def resources_register(*args, **kwargs): ...
def resources_unregister(*args, **kwargs): ...
def settings_schema_source_get_default(*args, **kwargs): ...
def simple_async_report_gerror_in_idle(*args, **kwargs): ...
def tls_backend_get_default(*args, **kwargs): ...
def tls_channel_binding_error_quark(*args, **kwargs): ...
def tls_client_connection_new(*args, **kwargs): ...
def tls_error_quark(*args, **kwargs): ...
def tls_file_database_new(*args, **kwargs): ...
def tls_server_connection_new(*args, **kwargs): ...
def unix_is_mount_path_system_internal(*args, **kwargs): ...
def unix_is_system_device_path(*args, **kwargs): ...
def unix_is_system_fs_type(*args, **kwargs): ...
def unix_mount_at(*args, **kwargs): ...
def unix_mount_compare(*args, **kwargs): ...
def unix_mount_copy(*args, **kwargs): ...
def unix_mount_for(*args, **kwargs): ...
def unix_mount_free(*args, **kwargs): ...
def unix_mount_get_device_path(*args, **kwargs): ...
def unix_mount_get_fs_type(*args, **kwargs): ...
def unix_mount_get_mount_path(*args, **kwargs): ...
def unix_mount_get_options(*args, **kwargs): ...
def unix_mount_get_root_path(*args, **kwargs): ...
def unix_mount_guess_can_eject(*args, **kwargs): ...
def unix_mount_guess_icon(*args, **kwargs): ...
def unix_mount_guess_name(*args, **kwargs): ...
def unix_mount_guess_should_display(*args, **kwargs): ...
def unix_mount_guess_symbolic_icon(*args, **kwargs): ...
def unix_mount_is_readonly(*args, **kwargs): ...
def unix_mount_is_system_internal(*args, **kwargs): ...
def unix_mount_point_at(*args, **kwargs): ...
def unix_mount_points_changed_since(*args, **kwargs): ...
def unix_mount_points_get(*args, **kwargs): ...
def unix_mounts_changed_since(*args, **kwargs): ...
def unix_mounts_get(*args, **kwargs): ...


class Action(GObject.GInterface):
    def activate(self, parameter: Optional[GLib.Variant]) -> None: ...
    def change_state(self, value: GLib.Variant) -> None: ...
    def get_enabled(self) -> bool: ...
    def get_name(self) -> str: ...
    def get_parameter_type(*args, **kwargs): ...
    def get_state(self) -> Optional[GLib.Variant]: ...
    def get_state_hint(*args, **kwargs): ...
    def get_state_type(*args, **kwargs): ...
    @classmethod
    def name_is_valid(cls, action_name: str) -> bool: ...
    @classmethod
    def parse_detailed_name(cls, detailed_name: str) -> tuple[bool, GLib.Variant]: ...
    def print_detailed_name(*args, **kwargs): ...
    

class ActionEntry:
    activate = ...
    change_state = ...
    name = ...
    padding = ...
    parameter_type = ...
    state = ...
    

class ActionGroup(GObject.GInterface):
    def action_added(self, action_name: str) -> None: ...
    def action_enabled_changed(self, action_name: str, enabled: bool) -> None: ...
    def action_removed(self, action_name: str) -> None: ...
    def action_state_changed(self, action_name: str, state: GLib.Variant) -> None: ...
    def activate_action(self, action_name: str, parameter: Optional[GLib.Variant]) -> None: ...
    def change_action_state(self, action_name: str, value: GLib.Variant) -> None: ...
    def get_action_enabled(self, action_name: str) -> bool: ...
    def get_action_parameter_type(self, action_name: str) -> Optional[GLib.VariantType]: ...
    def get_action_state(self, action_name: str) -> Optional[GLib.Variant]: ...
    def get_action_state_hint(self, action_name: str) -> Optional[GLib.Variant]: ...
    def get_action_state_type(self, action_name: str) -> Optional[GLib.VariantType]: ...
    def has_action(self, action_name: str) -> bool: ...
    def list_actions(self) -> list[str]: ...
    def query_action(self, action_name: str) -> tuple[bool, GLib.VariantType, GLib.VariantType, GLib.Variant, GLib.Variant]: ...
    

class ActionGroupInterface:
    action_added = ...
    action_enabled_changed = ...
    action_removed = ...
    action_state_changed = ...
    activate_action = ...
    change_action_state = ...
    g_iface = ...
    get_action_enabled = ...
    get_action_parameter_type = ...
    get_action_state = ...
    get_action_state_hint = ...
    get_action_state_type = ...
    has_action = ...
    list_actions = ...
    query_action = ...
    

class ActionInterface:
    activate = ...
    change_state = ...
    g_iface = ...
    get_enabled = ...
    get_name = ...
    get_parameter_type = ...
    get_state = ...
    get_state_hint = ...
    get_state_type = ...


class ActionMap(GObject.GInterface):
    def add_action(self, action: Action) -> None: ...
    def add_action_entries(*args, **kwargs): ...
    def lookup_action(self, action: str) -> Optional[SimpleAction]: ...
    def remove_action(self, action_name: str) -> None: ...
    

class ActionMapInterface:
    add_action = ...
    g_iface = ...
    lookup_action = ...
    remove_action = ...
    

class AppInfo:
    def add_supports_type(*args, **kwargs): ...
    def can_delete(*args, **kwargs): ...
    def can_remove_supports_type(*args, **kwargs): ...
    def create_from_commandline(*args, **kwargs): ...
    def delete(*args, **kwargs): ...
    def dup(*args, **kwargs): ...
    def equal(*args, **kwargs): ...
    def get_all(*args, **kwargs): ...
    def get_all_for_type(*args, **kwargs): ...
    def get_commandline(*args, **kwargs): ...
    def get_default_for_type(*args, **kwargs): ...
    @classmethod
    def get_default_for_uri_scheme(cls, uri_scheme: str) -> Optional[AppInfo]: ...
    def get_description(*args, **kwargs): ...
    def get_display_name(*args, **kwargs): ...
    def get_executable(*args, **kwargs): ...
    def get_fallback_for_type(*args, **kwargs): ...
    def get_icon(*args, **kwargs): ...
    def get_id(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_recommended_for_type(*args, **kwargs): ...
    def get_supported_types(*args, **kwargs): ...
    def launch(*args, **kwargs): ...
    @classmethod
    def launch_default_for_uri(cls, uri: str, context: AppLaunchContext = ...) -> bool: ...
    def launch_default_for_uri_async(*args, **kwargs): ...
    def launch_default_for_uri_finish(*args, **kwargs): ...
    def launch_uris(*args, **kwargs): ...
    def launch_uris_async(*args, **kwargs): ...
    def launch_uris_finish(*args, **kwargs): ...
    def remove_supports_type(*args, **kwargs): ...
    def reset_type_associations(*args, **kwargs): ...
    def set_as_default_for_extension(*args, **kwargs): ...
    def set_as_default_for_type(*args, **kwargs): ...
    def set_as_last_used_for_type(*args, **kwargs): ...
    def should_show(*args, **kwargs): ...
    def supports_files(*args, **kwargs): ...
    def supports_uris(*args, **kwargs): ...
    

class AppInfoMonitor:
    def get(*args, **kwargs): ...
    

class AppLaunchContext:
    parent_instance = ...
    priv = ...
    
    def get_display(*args, **kwargs): ...
    def get_environment(*args, **kwargs): ...
    def get_startup_notify_id(*args, **kwargs): ...
    def launch_failed(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def setenv(*args, **kwargs): ...
    def unsetenv(*args, **kwargs): ...
    
    def do_get_display(self, *args, **kwargs): ...
    def do_get_startup_notify_id(self, *args, **kwargs): ...
    def do_launch_failed(self, *args, **kwargs): ...
    def do_launched(self, *args, **kwargs): ...
    

class Application(GObject.Object, ActionGroup, ActionMap):
    parent_instance = ...
    priv = ...

    def activate(self) -> None: ...
    def add_main_option(self, long_name: str, short_name: int, flags: GLib.OptionFlags, arg: GLib.OptionArg, description: str, arg_description: Optional[str] = None) -> None: ...
    def add_main_option_entries(self, entries: list[GLib.OptionEntry]) -> None: ...
    def add_option_group(self, group: GLib.OptionGroup) -> None: ...
    def bind_busy_property(self, object: GObject.Object, property: str) -> None: ...
    def get_application_id(self) -> str: ...
    def get_dbus_connection(self) -> Optional[DBusConnection]: ...
    def get_dbus_object_path(self) -> Optional[str]: ...
    @classmethod
    def get_default(cls) -> Application: ...
    def get_flags(self) -> ApplicationFlags: ...
    def get_inactivity_timeout(self) -> int: ...
    def get_is_busy(self) -> bool: ...
    def get_is_registered(self) -> bool: ...
    def get_is_remote(self) -> bool: ...
    def get_resource_base_path(self) -> Optional[str]: ...
    def hold(self) -> None: ...
    @classmethod
    def id_is_valid(cls, application_id: str) -> bool: ...
    def mark_busy(self) -> None: ...
    @classmethod
    def new(cls, application_id: str, flags: ApplicationFlags) -> Application: ...
    def open(self, files: list[File], hint: str) -> None: ...
    def quit(self) -> None: ...
    def register(self, cancellable: Optional[Cancellable] = ...) -> bool: ...
    def release(self) -> None: ...
    def run(self, argv: Optional[list[str]]) -> int: ...
    def send_notification(self, id: Optional[str], notification: Notification) -> None: ...
    def set_action_group(self, action_group: Optional[ActionGroup]) -> None: ...
    def set_application_id(self, id: Optional[str]) -> None: ...
    def set_default(self) -> None: ...
    def set_flags(self, flags: ApplicationFlags) -> None: ...
    def set_inactivity_timeout(self, inactivity_timeout: int) -> None: ...
    def set_option_context_description(self, description: Optional[str]) -> None: ...
    def set_option_context_parameter_string(self, parameter_string: Optional[str]) -> None: ...
    def set_option_context_summary(self, summary: Optional[str]) -> None: ...
    def set_resource_base_path(self, resource_path: Optional[str]) -> None: ...
    def unbind_busy_property(self, object: GObject.Object, property: str) -> None: ...
    def unmark_busy(self) -> None: ...
    def withdraw_notification(self, id: str) -> None: ...
    
    def do_activate(self) -> None: ...
    def do_add_platform_data(self, *args, **kwargs): ...
    def do_after_emit(self, *args, **kwargs): ...
    def do_before_emit(self, *args, **kwargs): ...
    def do_command_line(self, *args, **kwargs): ...
    def do_dbus_register(self, *args, **kwargs): ...
    def do_dbus_unregister(self, *args, **kwargs): ...
    def do_handle_local_options(self, *args, **kwargs): ...
    def do_local_command_line(self, *args, **kwargs): ...
    def do_name_lost(self) -> bool: ...
    def do_open(self, *args, **kwargs): ...
    def do_quit_mainloop(self) -> None: ...
    def do_run_mainloop(self) -> None: ...
    def do_shutdown(self, obj: Application) -> None: ...
    def do_startup(self) -> None: ...


class ApplicationCommandLine(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def create_file_for_arg(*args, **kwargs): ...
    def get_arguments(*args, **kwargs): ...
    def get_cwd(*args, **kwargs): ...
    def get_environ(*args, **kwargs): ...
    def get_exit_status(*args, **kwargs): ...
    def get_is_remote(*args, **kwargs): ...
    def get_options_dict(self) -> GLib.VariantDict: ...
    def get_platform_data(*args, **kwargs): ...
    def get_stdin(*args, **kwargs): ...
    def getenv(*args, **kwargs): ...
    def set_exit_status(*args, **kwargs): ...
    
    def do_get_stdin(self, *args, **kwargs): ...
    def do_print_literal(self, *args, **kwargs): ...
    def do_printerr_literal(self, *args, **kwargs): ...
    

class AsyncInitable:
    def init_async(*args, **kwargs): ...
    def init_finish(*args, **kwargs): ...
    def new_finish(*args, **kwargs): ...
    def newv_async(*args, **kwargs): ...
    

class AsyncResult:
    def get_source_object(*args, **kwargs): ...
    def get_user_data(*args, **kwargs): ...
    def is_tagged(*args, **kwargs): ...
    def legacy_propagate_error(*args, **kwargs): ...
    

class BufferedInputStream:
    def fill(*args, **kwargs): ...
    def fill_async(*args, **kwargs): ...
    def fill_finish(*args, **kwargs): ...
    def get_available(*args, **kwargs): ...
    def get_buffer_size(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_sized(*args, **kwargs): ...
    def peek(*args, **kwargs): ...
    def peek_buffer(*args, **kwargs): ...
    def read_byte(*args, **kwargs): ...
    def set_buffer_size(*args, **kwargs): ...
    
    def do_fill(self, *args, **kwargs): ...
    def do_fill_async(self, *args, **kwargs): ...
    def do_fill_finish(self, *args, **kwargs): ...
    

class BufferedOutputStream:
    def get_auto_grow(*args, **kwargs): ...
    def get_buffer_size(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_sized(*args, **kwargs): ...
    def set_auto_grow(*args, **kwargs): ...
    def set_buffer_size(*args, **kwargs): ...
    

class BytesIcon:
    def get_bytes(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class Cancellable:
    parent_instance = ...
    priv = ...
    
    def cancel(self) -> None: ...
    def get_current(*args, **kwargs): ...
    def get_fd(*args, **kwargs): ...
    def is_cancelled(self) -> bool: ...
    def make_pollfd(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def pop_current(*args, **kwargs): ...
    def push_current(*args, **kwargs): ...
    def release_fd(*args, **kwargs): ...
    def reset(*args, **kwargs): ...
    def set_error_if_cancelled(*args, **kwargs): ...
    def source_new(*args, **kwargs): ...
    
    def do_cancelled(self, *args, **kwargs): ...
    

class CharsetConverter:
    def get_num_fallbacks(*args, **kwargs): ...
    def get_use_fallback(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_use_fallback(*args, **kwargs): ...
    

class Converter:
    def convert(*args, **kwargs): ...
    def reset(*args, **kwargs): ...
    

class ConverterInputStream:
    def get_converter(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class ConverterOutputStream:
    def get_converter(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class Credentials:
    def get_unix_pid(*args, **kwargs): ...
    def get_unix_user(*args, **kwargs): ...
    def is_same_user(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_native(*args, **kwargs): ...
    def set_unix_user(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    

class DBusActionGroup:
    def get(*args, **kwargs): ...
    

class DBusAnnotationInfo:
    annotations = ...
    key = ...
    ref_count = ...
    value = ...
    
    def lookup(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class DBusArgInfo:
    annotations: list[DBusAnnotationInfo] = ...
    name: str = ...
    ref_count: int = ...
    signature: str = ...
    
    def ref(self) -> DBusArgInfo: ...
    def unref(self) -> None: ...
    

class DBusAuthObserver:
    def allow_mechanism(*args, **kwargs): ...
    def authorize_authenticated_peer(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class DBusConnection:
    def add_filter(*args, **kwargs): ...
    def call(*args, **kwargs): ...
    def call_finish(*args, **kwargs): ...
    def call_sync(*args, **kwargs): ...
    def call_with_unix_fd_list(*args, **kwargs): ...
    def call_with_unix_fd_list_finish(*args, **kwargs): ...
    def call_with_unix_fd_list_sync(self, bus_name: Optional[str], object_path: str, interface_name: str, method_name: str, parameters: Optional[GLib.Variant], reply_type: Optional[GLib.VariantType], flags: DBusCallFlags, timeout_msec: int, fd_list: Optional[UnixFDList], cancellable: Optional[Cancellable]) -> Optional[tuple[GLib.Variant, UnixFDList]]: ...
    def close(*args, **kwargs): ...
    def close_finish(*args, **kwargs): ...
    def close_sync(*args, **kwargs): ...
    def emit_signal(self, destination_bus_name: Optional[str], object_path: str, interface_name: str, signal_name: str, parameters: Optional[GLib.Variant]) -> bool: ...
    def export_action_group(*args, **kwargs): ...
    def export_menu_model(*args, **kwargs): ...
    def flush(*args, **kwargs): ...
    def flush_finish(*args, **kwargs): ...
    def flush_sync(*args, **kwargs): ...
    def get_capabilities(*args, **kwargs): ...
    def get_exit_on_close(*args, **kwargs): ...
    def get_flags(*args, **kwargs): ...
    def get_guid(*args, **kwargs): ...
    def get_last_serial(*args, **kwargs): ...
    def get_peer_credentials(*args, **kwargs): ...
    def get_stream(*args, **kwargs): ...
    def get_unique_name(*args, **kwargs): ...
    def is_closed(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_for_address(*args, **kwargs): ...
    def new_for_address_finish(*args, **kwargs): ...
    def new_for_address_sync(*args, **kwargs): ...
    def new_sync(*args, **kwargs): ...
    def register_object(self, object_path: str, interface_info: DBusInterfaceInfo, method_call_closure: Optional[Callable[..., Any]] = ..., get_property_closure: Optional[Callable[..., Any]] = ..., set_property_closure: Optional[Callable[..., Any]] = ...) -> int: ...
    def register_subtree(*args, **kwargs): ...
    def remove_filter(*args, **kwargs): ...
    def send_message(*args, **kwargs): ...
    def send_message_with_reply(*args, **kwargs): ...
    def send_message_with_reply_finish(*args, **kwargs): ...
    def send_message_with_reply_sync(*args, **kwargs): ...
    def set_exit_on_close(*args, **kwargs): ...
    def signal_subscribe(self, sender: Optional[str], interface_name: Optional[str], member: Optional[str], object_path: Optional[str], arg0: Optional[str], flags: DBusSignalFlags, callback: Callable[..., Any], user_data: Optional[Any] = ...) -> int: ...
    def signal_unsubscribe(self, subscription_id: int) -> None: ...
    def start_message_processing(*args, **kwargs): ...
    def unexport_action_group(*args, **kwargs): ...
    def unexport_menu_model(*args, **kwargs): ...
    def unregister_object(*args, **kwargs): ...
    def unregister_subtree(*args, **kwargs): ...
    

class DBusErrorEntry:
    dbus_error_name = ...
    error_code = ...
    

class DBusInterface:
    def get_info(*args, **kwargs): ...
    def get_object(*args, **kwargs): ...
    def set_object(*args, **kwargs): ...
    

class DBusInterfaceInfo:
    annotations: list[DBusAnnotationInfo] = ...
    methods: list[DBusMethodInfo] = ...
    name: str = ...
    properties: list[DBusPropertyInfo] = ...
    ref_count: int = ...
    signals: [DBusSignalInfo] = ...
    
    def cache_build(*args, **kwargs): ...
    def cache_release(*args, **kwargs): ...
    def generate_xml(*args, **kwargs): ...
    def lookup_method(*args, **kwargs): ...
    def lookup_property(*args, **kwargs): ...
    def lookup_signal(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class DBusInterfaceSkeleton:
    parent_instance = ...
    priv = ...
    
    def export(*args, **kwargs): ...
    def flush(*args, **kwargs): ...
    def get_connection(*args, **kwargs): ...
    def get_connections(*args, **kwargs): ...
    def get_flags(*args, **kwargs): ...
    def get_object_path(*args, **kwargs): ...
    def has_connection(*args, **kwargs): ...
    def set_flags(*args, **kwargs): ...
    def unexport(*args, **kwargs): ...
    def unexport_from_connection(*args, **kwargs): ...
    
    def do_flush(self, *args, **kwargs): ...
    def do_g_authorize_method(self, *args, **kwargs): ...
    def do_get_info(self, *args, **kwargs): ...
    def do_get_properties(self, *args, **kwargs): ...
    

class DBusInterfaceVTable:
    get_property = ...
    method_call = ...
    padding = ...
    set_property = ...
    

class DBusMenuModel:
    def get(*args, **kwargs): ...
    

class DBusMessage:
    def bytes_needed(*args, **kwargs): ...
    def copy(*args, **kwargs): ...
    def get_arg0(*args, **kwargs): ...
    def get_body(*args, **kwargs): ...
    def get_byte_order(*args, **kwargs): ...
    def get_destination(*args, **kwargs): ...
    def get_error_name(*args, **kwargs): ...
    def get_flags(*args, **kwargs): ...
    def get_header(*args, **kwargs): ...
    def get_header_fields(*args, **kwargs): ...
    def get_interface(*args, **kwargs): ...
    def get_locked(*args, **kwargs): ...
    def get_member(*args, **kwargs): ...
    def get_message_type(*args, **kwargs): ...
    def get_num_unix_fds(*args, **kwargs): ...
    def get_path(*args, **kwargs): ...
    def get_reply_serial(*args, **kwargs): ...
    def get_sender(*args, **kwargs): ...
    def get_serial(*args, **kwargs): ...
    def get_signature(*args, **kwargs): ...
    def get_unix_fd_list(self) -> UnixFDList: ...
    def lock(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_blob(*args, **kwargs): ...
    def new_method_call(*args, **kwargs): ...
    def new_method_error_literal(*args, **kwargs): ...
    def new_method_reply(*args, **kwargs): ...
    def new_signal(*args, **kwargs): ...
    def print_(*args, **kwargs): ...
    def set_body(*args, **kwargs): ...
    def set_byte_order(*args, **kwargs): ...
    def set_destination(*args, **kwargs): ...
    def set_error_name(*args, **kwargs): ...
    def set_flags(*args, **kwargs): ...
    def set_header(*args, **kwargs): ...
    def set_interface(*args, **kwargs): ...
    def set_member(*args, **kwargs): ...
    def set_message_type(*args, **kwargs): ...
    def set_num_unix_fds(*args, **kwargs): ...
    def set_path(*args, **kwargs): ...
    def set_reply_serial(*args, **kwargs): ...
    def set_sender(*args, **kwargs): ...
    def set_serial(*args, **kwargs): ...
    def set_signature(*args, **kwargs): ...
    def set_unix_fd_list(*args, **kwargs): ...
    def to_blob(*args, **kwargs): ...
    def to_gerror(*args, **kwargs): ...
    

class DBusMethodInfo:
    annotations: list[DBusAnnotationInfo] = ...
    in_args: list[DBusArgInfo] = ...
    name: str = ...
    out_args: list[DBusArgInfo] = ...
    ref_count: int = ...
    
    def ref(self) -> DBusMethodInfo: ...
    def unref(self) -> None: ...
    

class DBusMethodInvocation:
    def get_connection(self) -> DBusConnection: ...
    def get_interface_name(self) -> str: ...
    def get_message(self) -> DBusMessage: ...
    def get_method_info(self) -> DBusMethodInfo: ...
    def get_method_name(self) -> str: ...
    def get_object_path(self) -> str: ...
    def get_parameters(self) -> GLib.Variant: ...
    def get_property_info(self) -> DBusPropertyInfo: ...
    def get_sender(self) -> str: ...
    def return_dbus_error(*args, **kwargs): ...
    def return_error_literal(*args, **kwargs): ...
    def return_gerror(*args, **kwargs): ...
    def return_value(self, parameters: Optional[GLib.Variant]) -> None: ...
    def return_value_with_unix_fd_list(*args, **kwargs): ...
    

class DBusNodeInfo:
    annotations: list[DBusAnnotationInfo] = ...
    interfaces: list[DBusInterfaceInfo] = ...
    nodes: list[DBusNodeInfo] = ...
    path: str = ...
    ref_count: int = ...
    
    def generate_xml(self, indent: int, string_builder: GLib.String) -> None: ...
    def lookup_interface(self, name: str) -> DBusInterfaceInfo: ...
    @classmethod
    def new_for_xml(cls, xml_data: str) -> DBusNodeInfo: ...
    def ref(self) -> DBusNodeInfo: ...
    def unref(self) -> None: ...
    

class DBusObject:
    def get_interface(*args, **kwargs): ...
    def get_interfaces(*args, **kwargs): ...
    def get_object_path(*args, **kwargs): ...
    

class DBusObjectManager:
    def get_interface(*args, **kwargs): ...
    def get_object(*args, **kwargs): ...
    def get_object_path(*args, **kwargs): ...
    def get_objects(*args, **kwargs): ...
    

class DBusObjectManagerClient:
    parent_instance = ...
    priv = ...
    
    def get_connection(*args, **kwargs): ...
    def get_flags(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_name_owner(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_for_bus(*args, **kwargs): ...
    def new_for_bus_finish(*args, **kwargs): ...
    def new_for_bus_sync(*args, **kwargs): ...
    def new_sync(*args, **kwargs): ...
    
    def do_interface_proxy_properties_changed(self, *args, **kwargs): ...
    def do_interface_proxy_signal(self, *args, **kwargs): ...
    

class DBusObjectManagerServer:
    parent_instance = ...
    priv = ...
    
    def export(*args, **kwargs): ...
    def export_uniquely(*args, **kwargs): ...
    def get_connection(*args, **kwargs): ...
    def is_exported(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_connection(*args, **kwargs): ...
    def unexport(*args, **kwargs): ...
    

class DBusObjectProxy:
    parent_instance = ...
    priv = ...
    
    def get_connection(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class DBusObjectSkeleton:
    parent_instance = ...
    priv = ...
    
    def add_interface(*args, **kwargs): ...
    def flush(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def remove_interface(*args, **kwargs): ...
    def remove_interface_by_name(*args, **kwargs): ...
    def set_object_path(*args, **kwargs): ...
    
    def do_authorize_method(self, *args, **kwargs): ...
    

class DBusPropertyInfo:
    annotations = ...
    flags = ...
    name = ...
    ref_count = ...
    signature = ...
    
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...


class DBusProxy(GObject.Object, AsyncInitable, DBusInterface, Initable):
    parent_instance = ...
    priv = ...
    
    def call(self, method_name: str, parameters: Optional[GLib.Variant], flags: DBusCallFlags, timeout_msec: int, cancellable: Optional[Cancellable], callback: Optional[AsyncReadyCallback], user_data: Optional[Any] = ...) -> None: ...
    def call_finish(self, res: AsyncResult) -> Optional[GLib.Variant]: ...
    def call_sync(self, method_name: str, parameters: Optional[GLib.Variant], flags: DBusCallFlags, timeout_msec: int, cancellable: Optional[Cancellable]) -> GLib.Variant: ...
    def call_with_unix_fd_list(*args, **kwargs): ...
    def call_with_unix_fd_list_finish(*args, **kwargs): ...
    def call_with_unix_fd_list_sync(*args, **kwargs): ...
    def get_cached_property(self, property_name: str) -> Optional[GLib.Variant]: ...
    def get_cached_property_names(self) -> list[str]: ...
    def get_connection(self) -> DBusConnection: ...
    def get_default_timeout(self) -> int: ...
    def get_flags(self) -> DBusProxyFlags: ...
    def get_interface_info(self) -> Optional[DBusInterfaceInfo]: ...
    def get_interface_name(self) -> str: ...
    def get_name(self) -> str: ...
    def get_name_owner(self) -> Optional[str]: ...
    def get_object_path(self) -> str: ...
    @overload
    @classmethod
    def new(cls, connection: DBusConnection, flags: DBusProxyFlags, info: Optional[DBusInterfaceInfo], name: str, object_path: str, interface_name: str, cancellable: Optional[Cancellable], callback: Optional[AsyncReadyCallback]) -> None: ...
    @overload
    @classmethod
    def new(cls, connection: DBusConnection, flags: DBusProxyFlags, info: Optional[DBusInterfaceInfo], name: str, object_path: str, interface_name: str, cancellable: Optional[Cancellable], callback: Optional[AsyncReadyCallbackU], user_data: Optional[Any]) -> None: ...
    @classmethod
    def new_finish(cls, res: AsyncResult) -> DBusProxy: ...
    @overload
    @classmethod
    def new_for_bus(cls, bus_type: BusType, flags: DBusProxyFlags, info: Optional[DBusInterfaceInfo], name: str, object_path: str, interface_name: str, cancellable: Optional[Cancellable], callback: Optional[AsyncReadyCallback]) -> None: ...
    @overload
    @classmethod
    def new_for_bus(cls, bus_type: BusType, flags: DBusProxyFlags, info: Optional[DBusInterfaceInfo], name: str, object_path: str, interface_name: str, cancellable: Optional[Cancellable], callback: Optional[AsyncReadyCallbackU], user_data: Optional[Any]) -> None: ...
    @classmethod
    def new_for_bus_finish(cls, res: AsyncResult) -> DBusProxy: ...
    @classmethod
    def new_for_bus_sync(cls, bus_type: BusType, flags: DBusProxyFlags, info: Optional[DBusInterfaceInfo], name: str, object_path: str, interface_name: str, cancellable: Optional[Cancellable]) -> DBusProxy: ...
    @classmethod
    def new_sync(cls, connection: DBusConnection, flags: DBusProxyFlags, info: Optional[DBusInterfaceInfo], name: str, object_path: str, interface_name: str, cancellable: Optional[Cancellable]) -> DBusProxy: ...
    def set_cached_property(self, property_name: str, value: Optional[GLib.Variant]) -> None: ...
    def set_default_timeout(self, timeout_msec: int) -> None: ...
    def set_interface_info(self, info: Optional[DBusInterfaceInfo]) -> None: ...
    
    def do_g_properties_changed(self, *args, **kwargs): ...
    def do_g_signal(self, *args, **kwargs): ...
    

class DBusServer:
    def get_client_address(*args, **kwargs): ...
    def get_flags(*args, **kwargs): ...
    def get_guid(*args, **kwargs): ...
    def is_active(*args, **kwargs): ...
    def new_sync(*args, **kwargs): ...
    def start(*args, **kwargs): ...
    def stop(*args, **kwargs): ...
    

class DBusSignalInfo:
    annotations = ...
    args = ...
    name = ...
    ref_count = ...
    
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class DBusSubtreeVTable:
    dispatch = ...
    enumerate = ...
    introspect = ...
    padding = ...
    

class DataInputStream:
    def get_byte_order(*args, **kwargs): ...
    def get_newline_type(*args, **kwargs): ...
    def read_int16(*args, **kwargs): ...
    def read_int32(*args, **kwargs): ...
    def read_int64(*args, **kwargs): ...
    def read_line(*args, **kwargs): ...
    def read_line_async(*args, **kwargs): ...
    def read_line_finish(*args, **kwargs): ...
    def read_line_finish_utf8(*args, **kwargs): ...
    def read_line_utf8(*args, **kwargs): ...
    def read_uint16(*args, **kwargs): ...
    def read_uint32(*args, **kwargs): ...
    def read_uint64(*args, **kwargs): ...
    def read_until(*args, **kwargs): ...
    def read_until_async(*args, **kwargs): ...
    def read_until_finish(*args, **kwargs): ...
    def read_upto(*args, **kwargs): ...
    def read_upto_async(*args, **kwargs): ...
    def read_upto_finish(*args, **kwargs): ...
    def set_byte_order(*args, **kwargs): ...
    def set_newline_type(*args, **kwargs): ...
    

class DataOutputStream:
    def get_byte_order(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def put_byte(*args, **kwargs): ...
    def put_int16(*args, **kwargs): ...
    def put_int32(*args, **kwargs): ...
    def put_int64(*args, **kwargs): ...
    def put_string(*args, **kwargs): ...
    def put_uint16(*args, **kwargs): ...
    def put_uint32(*args, **kwargs): ...
    def put_uint64(*args, **kwargs): ...
    def set_byte_order(*args, **kwargs): ...
    

class DatagramBased:
    def condition_check(*args, **kwargs): ...
    def condition_wait(*args, **kwargs): ...
    def create_source(*args, **kwargs): ...
    def receive_messages(*args, **kwargs): ...
    def send_messages(*args, **kwargs): ...
    

class DatagramBasedInterface:
    condition_check = ...
    condition_wait = ...
    create_source = ...
    g_iface = ...
    receive_messages = ...
    send_messages = ...
    

class DesktopAppInfo:
    def get_action_name(*args, **kwargs): ...
    def get_boolean(*args, **kwargs): ...
    def get_categories(*args, **kwargs): ...
    def get_filename(*args, **kwargs): ...
    def get_generic_name(*args, **kwargs): ...
    def get_implementations(*args, **kwargs): ...
    def get_is_hidden(*args, **kwargs): ...
    def get_keywords(*args, **kwargs): ...
    def get_locale_string(*args, **kwargs): ...
    def get_nodisplay(*args, **kwargs): ...
    def get_show_in(*args, **kwargs): ...
    def get_startup_wm_class(*args, **kwargs): ...
    def get_string(*args, **kwargs): ...
    def get_string_list(*args, **kwargs): ...
    def has_key(*args, **kwargs): ...
    def launch_action(*args, **kwargs): ...
    def launch_uris_as_manager(*args, **kwargs): ...
    def launch_uris_as_manager_with_fds(*args, **kwargs): ...
    def list_actions(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_filename(*args, **kwargs): ...
    def new_from_keyfile(*args, **kwargs): ...
    def search(*args, **kwargs): ...
    def set_desktop_env(*args, **kwargs): ...
    

class DesktopAppInfoLookup:
    def get_default_for_uri_scheme(*args, **kwargs): ...
    

class Drive:
    def can_eject(*args, **kwargs): ...
    def can_poll_for_media(*args, **kwargs): ...
    def can_start(*args, **kwargs): ...
    def can_start_degraded(*args, **kwargs): ...
    def can_stop(*args, **kwargs): ...
    def eject(*args, **kwargs): ...
    def eject_finish(*args, **kwargs): ...
    def eject_with_operation(*args, **kwargs): ...
    def eject_with_operation_finish(*args, **kwargs): ...
    def enumerate_identifiers(*args, **kwargs): ...
    def get_icon(*args, **kwargs): ...
    def get_identifier(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_sort_key(*args, **kwargs): ...
    def get_start_stop_type(*args, **kwargs): ...
    def get_symbolic_icon(*args, **kwargs): ...
    def get_volumes(*args, **kwargs): ...
    def has_media(*args, **kwargs): ...
    def has_volumes(*args, **kwargs): ...
    def is_media_check_automatic(*args, **kwargs): ...
    def is_media_removable(*args, **kwargs): ...
    def is_removable(*args, **kwargs): ...
    def poll_for_media(*args, **kwargs): ...
    def poll_for_media_finish(*args, **kwargs): ...
    def start(*args, **kwargs): ...
    def start_finish(*args, **kwargs): ...
    def stop(*args, **kwargs): ...
    def stop_finish(*args, **kwargs): ...
    

class DtlsClientConnection:
    def get_accepted_cas(*args, **kwargs): ...
    def get_server_identity(*args, **kwargs): ...
    def get_validation_flags(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_server_identity(*args, **kwargs): ...
    def set_validation_flags(*args, **kwargs): ...
    

class DtlsClientConnectionInterface:
    g_iface = ...
    

class DtlsConnection:
    def close(*args, **kwargs): ...
    def close_async(*args, **kwargs): ...
    def close_finish(*args, **kwargs): ...
    def emit_accept_certificate(*args, **kwargs): ...
    def get_certificate(*args, **kwargs): ...
    def get_channel_binding_data(*args, **kwargs): ...
    def get_database(*args, **kwargs): ...
    def get_interaction(*args, **kwargs): ...
    def get_negotiated_protocol(*args, **kwargs): ...
    def get_peer_certificate(*args, **kwargs): ...
    def get_peer_certificate_errors(*args, **kwargs): ...
    def get_rehandshake_mode(*args, **kwargs): ...
    def get_require_close_notify(*args, **kwargs): ...
    def handshake(*args, **kwargs): ...
    def handshake_async(*args, **kwargs): ...
    def handshake_finish(*args, **kwargs): ...
    def set_advertised_protocols(*args, **kwargs): ...
    def set_certificate(*args, **kwargs): ...
    def set_database(*args, **kwargs): ...
    def set_interaction(*args, **kwargs): ...
    def set_rehandshake_mode(*args, **kwargs): ...
    def set_require_close_notify(*args, **kwargs): ...
    def shutdown(*args, **kwargs): ...
    def shutdown_async(*args, **kwargs): ...
    def shutdown_finish(*args, **kwargs): ...
    

class DtlsConnectionInterface:
    accept_certificate = ...
    g_iface = ...
    get_binding_data = ...
    get_negotiated_protocol = ...
    handshake = ...
    handshake_async = ...
    handshake_finish = ...
    set_advertised_protocols = ...
    shutdown = ...
    shutdown_async = ...
    shutdown_finish = ...
    

class DtlsServerConnection:
    def new(*args, **kwargs): ...
    

class DtlsServerConnectionInterface:
    g_iface = ...
    

class Emblem:
    def get_icon(*args, **kwargs): ...
    def get_origin(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_origin(*args, **kwargs): ...
    

class EmblemedIcon:
    parent_instance = ...
    priv = ...
    
    def add_emblem(*args, **kwargs): ...
    def clear_emblems(*args, **kwargs): ...
    def get_emblems(*args, **kwargs): ...
    def get_icon(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class File:
    def append_to(*args, **kwargs): ...
    def append_to_async(*args, **kwargs): ...
    def append_to_finish(*args, **kwargs): ...
    def build_attribute_list_for_copy(*args, **kwargs): ...
    def copy(*args, **kwargs): ...
    def copy_async(*args, **kwargs): ...
    def copy_attributes(*args, **kwargs): ...
    def copy_finish(*args, **kwargs): ...
    def create(*args, **kwargs): ...
    @overload
    def create_async(self, flags: FileCreateFlags, io_priority: int, cancellable: Optional[Cancellable] = None, callback: Optional[AsyncReadyCallback] = None) -> None: ...
    @overload
    def create_async(self, flags: FileCreateFlags, io_priority: int, cancellable: Optional[Cancellable] = None, callback: Optional[AsyncReadyCallbackU] = None, user_data: Optional[Any] = None) -> None: ...
    def create_finish(self, res: AsyncResult) -> OutputStream: ...
    def create_readwrite(*args, **kwargs): ...
    def create_readwrite_async(*args, **kwargs): ...
    def create_readwrite_finish(*args, **kwargs): ...
    def delete(*args, **kwargs): ...
    def delete_async(*args, **kwargs): ...
    def delete_finish(*args, **kwargs): ...
    def dup(*args, **kwargs): ...
    def eject_mountable(*args, **kwargs): ...
    def eject_mountable_finish(*args, **kwargs): ...
    def eject_mountable_with_operation(*args, **kwargs): ...
    def eject_mountable_with_operation_finish(*args, **kwargs): ...
    def enumerate_children(*args, **kwargs): ...
    def enumerate_children_async(*args, **kwargs): ...
    def enumerate_children_finish(*args, **kwargs): ...
    def equal(*args, **kwargs): ...
    def find_enclosing_mount(*args, **kwargs): ...
    def find_enclosing_mount_async(*args, **kwargs): ...
    def find_enclosing_mount_finish(*args, **kwargs): ...
    def get_basename(*args, **kwargs): ...
    def get_child(*args, **kwargs): ...
    def get_child_for_display_name(*args, **kwargs): ...
    def get_parent(*args, **kwargs): ...
    def get_parse_name(*args, **kwargs): ...
    def get_path(*args, **kwargs): ...
    def get_relative_path(*args, **kwargs): ...
    def get_uri(*args, **kwargs): ...
    def get_uri_scheme(*args, **kwargs): ...
    def has_parent(*args, **kwargs): ...
    def has_prefix(*args, **kwargs): ...
    def has_uri_scheme(*args, **kwargs): ...
    def hash(*args, **kwargs): ...
    def is_native(*args, **kwargs): ...
    def load_bytes(*args, **kwargs): ...
    def load_bytes_async(*args, **kwargs): ...
    def load_bytes_finish(*args, **kwargs): ...
    def load_contents(self, cancellable: Optional[Cancellable]) -> tuple[bool, bytes, str]: ...
    @overload
    def load_contents_async(self, cancellable: Optional[Cancellable], callback: AsyncReadyCallback) -> None: ...
    @overload
    def load_contents_async(self, cancellable: Optional[Cancellable], callback: AsyncReadyCallbackU, user_data: Any) -> None: ...
    def load_contents_finish(self, res: AsyncResult) ->  tuple[bool, bytes, str]: ...
    def load_partial_contents_finish(*args, **kwargs): ...
    def make_directory(*args, **kwargs): ...
    def make_directory_async(*args, **kwargs): ...
    def make_directory_finish(*args, **kwargs): ...
    def make_directory_with_parents(*args, **kwargs): ...
    def make_symbolic_link(*args, **kwargs): ...
    def measure_disk_usage_finish(*args, **kwargs): ...
    def monitor(*args, **kwargs): ...
    def monitor_directory(*args, **kwargs): ...
    def monitor_file(*args, **kwargs): ...
    def mount_enclosing_volume(*args, **kwargs): ...
    def mount_enclosing_volume_finish(*args, **kwargs): ...
    def mount_mountable(*args, **kwargs): ...
    def mount_mountable_finish(*args, **kwargs): ...
    def move(*args, **kwargs): ...
    def new_for_commandline_arg(*args, **kwargs): ...
    def new_for_commandline_arg_and_cwd(*args, **kwargs): ...
    @classmethod
    def new_for_path(cls, path: str) -> File: ...
    def new_for_uri(*args, **kwargs): ...
    def new_tmp(*args, **kwargs): ...
    def open_readwrite(*args, **kwargs): ...
    def open_readwrite_async(*args, **kwargs): ...
    def open_readwrite_finish(*args, **kwargs): ...
    def parse_name(*args, **kwargs): ...
    def peek_path(*args, **kwargs): ...
    def poll_mountable(*args, **kwargs): ...
    def poll_mountable_finish(*args, **kwargs): ...
    def query_default_handler(*args, **kwargs): ...
    def query_default_handler_async(*args, **kwargs): ...
    def query_default_handler_finish(*args, **kwargs): ...
    def query_exists(*args, **kwargs): ...
    def query_file_type(*args, **kwargs): ...
    def query_filesystem_info(*args, **kwargs): ...
    def query_filesystem_info_async(*args, **kwargs): ...
    def query_filesystem_info_finish(*args, **kwargs): ...
    def query_info(*args, **kwargs): ...
    def query_info_async(*args, **kwargs): ...
    def query_info_finish(*args, **kwargs): ...
    def query_settable_attributes(*args, **kwargs): ...
    def query_writable_namespaces(*args, **kwargs): ...
    def read(*args, **kwargs): ...
    def read_async(*args, **kwargs): ...
    def read_finish(*args, **kwargs): ...
    def replace(*args, **kwargs): ...
    def replace_async(*args, **kwargs): ...
    def replace_contents(*args, **kwargs): ...
    def replace_contents_async(*args, **kwargs): ...
    def replace_contents_bytes_async(*args, **kwargs): ...
    def replace_contents_finish(*args, **kwargs): ...
    def replace_finish(*args, **kwargs): ...
    def replace_readwrite(*args, **kwargs): ...
    def replace_readwrite_async(*args, **kwargs): ...
    def replace_readwrite_finish(*args, **kwargs): ...
    def resolve_relative_path(*args, **kwargs): ...
    def set_attribute(*args, **kwargs): ...
    def set_attribute_byte_string(*args, **kwargs): ...
    def set_attribute_int32(*args, **kwargs): ...
    def set_attribute_int64(*args, **kwargs): ...
    def set_attribute_string(*args, **kwargs): ...
    def set_attribute_uint32(*args, **kwargs): ...
    def set_attribute_uint64(*args, **kwargs): ...
    def set_attributes_async(*args, **kwargs): ...
    def set_attributes_finish(*args, **kwargs): ...
    def set_attributes_from_info(*args, **kwargs): ...
    def set_display_name(*args, **kwargs): ...
    def set_display_name_async(*args, **kwargs): ...
    def set_display_name_finish(*args, **kwargs): ...
    def start_mountable(*args, **kwargs): ...
    def start_mountable_finish(*args, **kwargs): ...
    def stop_mountable(*args, **kwargs): ...
    def stop_mountable_finish(*args, **kwargs): ...
    def supports_thread_contexts(*args, **kwargs): ...
    def trash(*args, **kwargs): ...
    def trash_async(*args, **kwargs): ...
    def trash_finish(*args, **kwargs): ...
    def unmount_mountable(*args, **kwargs): ...
    def unmount_mountable_finish(*args, **kwargs): ...
    def unmount_mountable_with_operation(*args, **kwargs): ...
    def unmount_mountable_with_operation_finish(*args, **kwargs): ...
    

class FileAttributeInfo:
    flags = ...
    name = ...
    type = ...
    

class FileAttributeInfoList:
    infos = ...
    n_infos = ...
    
    def add(*args, **kwargs): ...
    def dup(*args, **kwargs): ...
    def lookup(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class FileAttributeMatcher:
    def enumerate_namespace(*args, **kwargs): ...
    def enumerate_next(*args, **kwargs): ...
    def matches(*args, **kwargs): ...
    def matches_only(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def subtract(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class FileDescriptorBased:
    def get_fd(*args, **kwargs): ...
    

class FileEnumerator:
    parent_instance = ...
    priv = ...
    
    def close(*args, **kwargs): ...
    def close_async(*args, **kwargs): ...
    def close_finish(*args, **kwargs): ...
    def get_child(*args, **kwargs): ...
    def get_container(*args, **kwargs): ...
    def has_pending(*args, **kwargs): ...
    def is_closed(*args, **kwargs): ...
    def iterate(*args, **kwargs): ...
    def next(*args, **kwargs): ...
    def next_file(*args, **kwargs): ...
    def next_files_async(*args, **kwargs): ...
    def next_files_finish(*args, **kwargs): ...
    def set_pending(*args, **kwargs): ...
    
    def do_close_async(self, *args, **kwargs): ...
    def do_close_finish(self, *args, **kwargs): ...
    def do_close_fn(self, *args, **kwargs): ...
    def do_next_file(self, *args, **kwargs): ...
    def do_next_files_async(self, *args, **kwargs): ...
    def do_next_files_finish(self, *args, **kwargs): ...
    

class FileIOStream:
    def get_etag(*args, **kwargs): ...
    def query_info(*args, **kwargs): ...
    def query_info_async(*args, **kwargs): ...
    def query_info_finish(*args, **kwargs): ...
    
    def do_can_seek(self, *args, **kwargs): ...
    def do_can_truncate(self, *args, **kwargs): ...
    def do_get_etag(self, *args, **kwargs): ...
    def do_query_info(self, *args, **kwargs): ...
    def do_query_info_async(self, *args, **kwargs): ...
    def do_query_info_finish(self, *args, **kwargs): ...
    def do_seek(self, *args, **kwargs): ...
    def do_tell(self, *args, **kwargs): ...
    def do_truncate_fn(self, *args, **kwargs): ...
    

class FileIcon:
    def get_file(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class FileInfo:
    def clear_status(*args, **kwargs): ...
    def copy_into(*args, **kwargs): ...
    def dup(*args, **kwargs): ...
    def get_attribute_as_string(*args, **kwargs): ...
    def get_attribute_boolean(*args, **kwargs): ...
    def get_attribute_byte_string(*args, **kwargs): ...
    def get_attribute_data(*args, **kwargs): ...
    def get_attribute_int32(*args, **kwargs): ...
    def get_attribute_int64(*args, **kwargs): ...
    def get_attribute_object(*args, **kwargs): ...
    def get_attribute_status(*args, **kwargs): ...
    def get_attribute_string(*args, **kwargs): ...
    def get_attribute_stringv(*args, **kwargs): ...
    def get_attribute_type(*args, **kwargs): ...
    def get_attribute_uint32(*args, **kwargs): ...
    def get_attribute_uint64(*args, **kwargs): ...
    def get_content_type(*args, **kwargs): ...
    def get_deletion_date(*args, **kwargs): ...
    def get_display_name(*args, **kwargs): ...
    def get_edit_name(*args, **kwargs): ...
    def get_etag(*args, **kwargs): ...
    def get_file_type(*args, **kwargs): ...
    def get_icon(*args, **kwargs): ...
    def get_is_backup(*args, **kwargs): ...
    def get_is_hidden(*args, **kwargs): ...
    def get_is_symlink(*args, **kwargs): ...
    def get_modification_date_time(*args, **kwargs): ...
    def get_modification_time(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_sort_order(*args, **kwargs): ...
    def get_symbolic_icon(*args, **kwargs): ...
    def get_symlink_target(*args, **kwargs): ...
    def has_attribute(*args, **kwargs): ...
    def has_namespace(*args, **kwargs): ...
    def list_attributes(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def remove_attribute(*args, **kwargs): ...
    def set_attribute(*args, **kwargs): ...
    def set_attribute_boolean(*args, **kwargs): ...
    def set_attribute_byte_string(*args, **kwargs): ...
    def set_attribute_int32(*args, **kwargs): ...
    def set_attribute_int64(*args, **kwargs): ...
    def set_attribute_mask(*args, **kwargs): ...
    def set_attribute_object(*args, **kwargs): ...
    def set_attribute_status(*args, **kwargs): ...
    def set_attribute_string(*args, **kwargs): ...
    def set_attribute_stringv(*args, **kwargs): ...
    def set_attribute_uint32(*args, **kwargs): ...
    def set_attribute_uint64(*args, **kwargs): ...
    def set_content_type(*args, **kwargs): ...
    def set_display_name(*args, **kwargs): ...
    def set_edit_name(*args, **kwargs): ...
    def set_file_type(*args, **kwargs): ...
    def set_icon(*args, **kwargs): ...
    def set_is_hidden(*args, **kwargs): ...
    def set_is_symlink(*args, **kwargs): ...
    def set_modification_date_time(*args, **kwargs): ...
    def set_modification_time(*args, **kwargs): ...
    def set_name(*args, **kwargs): ...
    def set_size(*args, **kwargs): ...
    def set_sort_order(*args, **kwargs): ...
    def set_symbolic_icon(*args, **kwargs): ...
    def set_symlink_target(*args, **kwargs): ...
    def unset_attribute_mask(*args, **kwargs): ...
    

class FileInputStream:
    def query_info(*args, **kwargs): ...
    def query_info_async(*args, **kwargs): ...
    def query_info_finish(*args, **kwargs): ...
    
    def do_can_seek(self, *args, **kwargs): ...
    def do_query_info(self, *args, **kwargs): ...
    def do_query_info_async(self, *args, **kwargs): ...
    def do_query_info_finish(self, *args, **kwargs): ...
    def do_seek(self, *args, **kwargs): ...
    def do_tell(self, *args, **kwargs): ...
    

class FileMonitor:
    parent_instance = ...
    priv = ...
    
    def cancel(*args, **kwargs): ...
    def emit_event(*args, **kwargs): ...
    def is_cancelled(*args, **kwargs): ...
    def set_rate_limit(*args, **kwargs): ...
    
    def do_cancel(self, *args, **kwargs): ...
    def do_changed(self, *args, **kwargs): ...
    

class FileOutputStream:
    def get_etag(*args, **kwargs): ...
    def query_info(*args, **kwargs): ...
    def query_info_async(*args, **kwargs): ...
    def query_info_finish(*args, **kwargs): ...
    
    def do_can_seek(self, *args, **kwargs): ...
    def do_can_truncate(self, *args, **kwargs): ...
    def do_get_etag(self, *args, **kwargs): ...
    def do_query_info(self, *args, **kwargs): ...
    def do_query_info_async(self, *args, **kwargs): ...
    def do_query_info_finish(self, *args, **kwargs): ...
    def do_seek(self, *args, **kwargs): ...
    def do_tell(self, *args, **kwargs): ...
    def do_truncate_fn(self, *args, **kwargs): ...
    

class FilenameCompleter:
    def get_completion_suffix(*args, **kwargs): ...
    def get_completions(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_dirs_only(*args, **kwargs): ...
    
    def do_got_completion_data(self, *args, **kwargs): ...
    

class FilterInputStream:
    base_stream = ...
    
    def get_base_stream(*args, **kwargs): ...
    def get_close_base_stream(*args, **kwargs): ...
    def set_close_base_stream(*args, **kwargs): ...
    

class FilterOutputStream:
    base_stream = ...
    
    def get_base_stream(*args, **kwargs): ...
    def get_close_base_stream(*args, **kwargs): ...
    def set_close_base_stream(*args, **kwargs): ...
    

class IOExtension:
    def get_name(*args, **kwargs): ...
    def get_priority(*args, **kwargs): ...
    def get_type(*args, **kwargs): ...
    

class IOExtensionPoint:
    def get_extension_by_name(*args, **kwargs): ...
    def get_extensions(*args, **kwargs): ...
    def get_required_type(*args, **kwargs): ...
    def implement(*args, **kwargs): ...
    def lookup(*args, **kwargs): ...
    def register(*args, **kwargs): ...
    def set_required_type(*args, **kwargs): ...
    

class IOModule:
    def load(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def query(*args, **kwargs): ...
    def unload(*args, **kwargs): ...
    

class IOModuleScope:
    def block(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    

class IOSchedulerJob:
    def send_to_mainloop(*args, **kwargs): ...
    def send_to_mainloop_async(*args, **kwargs): ...
    

class IOStream(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def clear_pending(*args, **kwargs): ...
    def close(*args, **kwargs): ...
    def close_async(*args, **kwargs): ...
    def close_finish(*args, **kwargs): ...
    def get_input_stream(self) -> InputStream: ...
    def get_output_stream(self) -> OutputStream: ...
    def has_pending(self) -> bool: ...
    def is_closed(*args, **kwargs): ...
    def set_pending(*args, **kwargs): ...
    def splice_async(*args, **kwargs): ...
    def splice_finish(*args, **kwargs): ...
    
    def do_close_async(self, *args, **kwargs): ...
    def do_close_finish(self, *args, **kwargs): ...
    def do_close_fn(self, *args, **kwargs): ...
    def do_get_input_stream(self, *args, **kwargs): ...
    def do_get_output_stream(self, *args, **kwargs): ...
    

class IOStreamAdapter: ...


class Icon(GObject.GInterface):
    @classmethod
    def deserialize(cls, value: GLib.Variant) -> Optional[Icon]: ...
    def equal(self, icon2: Optional[Icon]) -> bool: ...
    @classmethod
    def hash(cls, icon: Icon) -> int: ...
    @classmethod
    def new_for_string(cls, string: str) -> Icon: ...
    def serialize(self) -> Optional[GLib.Variant]: ...
    def to_string(self) -> Optional[str]: ...
    

class InetAddress:
    parent_instance = ...
    priv = ...
    
    def equal(*args, **kwargs): ...
    def get_family(*args, **kwargs): ...
    def get_is_any(*args, **kwargs): ...
    def get_is_link_local(*args, **kwargs): ...
    def get_is_loopback(*args, **kwargs): ...
    def get_is_mc_global(*args, **kwargs): ...
    def get_is_mc_link_local(*args, **kwargs): ...
    def get_is_mc_node_local(*args, **kwargs): ...
    def get_is_mc_org_local(*args, **kwargs): ...
    def get_is_mc_site_local(*args, **kwargs): ...
    def get_is_multicast(*args, **kwargs): ...
    def get_is_site_local(*args, **kwargs): ...
    def get_native_size(*args, **kwargs): ...
    def new_any(*args, **kwargs): ...
    def new_from_bytes(*args, **kwargs): ...
    def new_from_string(*args, **kwargs): ...
    def new_loopback(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    
    def do_to_string(self, *args, **kwargs): ...
    

class InetAddressMask:
    parent_instance = ...
    priv = ...
    
    def equal(*args, **kwargs): ...
    def get_address(*args, **kwargs): ...
    def get_family(*args, **kwargs): ...
    def get_length(*args, **kwargs): ...
    def matches(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_string(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    

class InetSocketAddress(SocketAddress):
    priv = ...
    
    def get_address(*args, **kwargs): ...
    def get_flowinfo(*args, **kwargs): ...
    def get_port(self) -> int: ...
    def get_scope_id(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_string(*args, **kwargs): ...
    

class Initable:
    def init(*args, **kwargs): ...
    def newv(*args, **kwargs): ...
    

class InputMessage:
    address = ...
    bytes_received = ...
    control_messages = ...
    flags = ...
    num_control_messages = ...
    num_vectors = ...
    vectors = ...
    

class InputStream:
    parent_instance = ...
    priv = ...
    
    def clear_pending(*args, **kwargs): ...
    def close(*args, **kwargs): ...
    def close_async(*args, **kwargs): ...
    def close_finish(*args, **kwargs): ...
    def has_pending(*args, **kwargs): ...
    def is_closed(*args, **kwargs): ...
    def read(*args, **kwargs): ...
    def read_all(*args, **kwargs): ...
    def read_all_async(*args, **kwargs): ...
    def read_all_finish(*args, **kwargs): ...
    def read_async(*args, **kwargs): ...
    def read_bytes(*args, **kwargs): ...
    def read_bytes_async(self, count: int, io_priority: int, cancellable: Optional[Cancellable] = ..., callback: Optional[AsyncReadyCallbackU] = ..., *user_data: Optional[Any]) -> None: ...
    def read_bytes_finish(self, result: AsyncResult) -> GLib.Bytes: ... 
    def read_finish(*args, **kwargs): ...
    def set_pending(*args, **kwargs): ...
    def skip(*args, **kwargs): ...
    def skip_async(*args, **kwargs): ...
    def skip_finish(*args, **kwargs): ...
    
    def do_close_async(self, *args, **kwargs): ...
    def do_close_finish(self, *args, **kwargs): ...
    def do_close_fn(self, *args, **kwargs): ...
    def do_read_async(self, *args, **kwargs): ...
    def do_read_finish(self, *args, **kwargs): ...
    def do_read_fn(self, *args, **kwargs): ...
    def do_skip(self, *args, **kwargs): ...
    def do_skip_async(self, *args, **kwargs): ...
    def do_skip_finish(self, *args, **kwargs): ...
    

class InputVector:
    buffer = ...
    size = ...
    

class ListModel:
    def get_item(*args, **kwargs): ...
    def get_item_type(*args, **kwargs): ...
    def get_n_items(*args, **kwargs): ...
    def items_changed(*args, **kwargs): ...
    

class ListModelInterface:
    g_iface = ...
    get_item = ...
    get_item_type = ...
    get_n_items = ...
    

class ListStore:
    def append(*args, **kwargs): ...
    def find(*args, **kwargs): ...
    def find_with_equal_func(*args, **kwargs): ...
    def insert(*args, **kwargs): ...
    def insert_sorted(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def remove(*args, **kwargs): ...
    def remove_all(*args, **kwargs): ...
    def sort(*args, **kwargs): ...
    def splice(*args, **kwargs): ...
    

class LoadableIcon:
    def load(self, size: int, cancellable: Optional[Cancellable]) -> tuple[InputStream, str]: ...
    @overload
    def load_async(self, size: int, cancellable: Optional[Cancellable], callback: Optional[AsyncReadyCallback]) -> None: ...
    @overload
    def load_async(self, size: int, cancellable: Optional[Cancellable], callback: Optional[AsyncReadyCallbackU], user_data: Any) -> None: ...
    def load_finish(self, res: AsyncResult) -> tuple[InputStream, str]: ...
    

class MemoryInputStream:
    def add_bytes(*args, **kwargs): ...
    def add_data(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_bytes(*args, **kwargs): ...
    def new_from_data(*args, **kwargs): ...
    

class MemoryMonitor:
    def dup_default(*args, **kwargs): ...
    

class MemoryMonitorInterface:
    g_iface = ...
    low_memory_warning = ...
    

class MemoryOutputStream:
    def get_data_size(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def new_resizable(*args, **kwargs): ...
    def steal_as_bytes(*args, **kwargs): ...
    

class Menu(MenuModel):
    def append(self, label: Optional[str], detailed_action: Optional[str]) -> None: ...
    def append_item(self, item: MenuItem) -> None: ...
    def append_section(self, label: Optional[str], section: MenuModel) -> None: ...
    def append_submenu(self, label: Optional[str], submenu: MenuModel) -> None: ...
    def freeze(self) -> None: ...
    def insert(self, position: int, label: Optional[str], detailed_action: Optional[str]) -> None: ...
    def insert_item(self, position: int, item: MenuItem) -> None: ...
    def insert_section(self, position: int, label: Optional[str], section: MenuModel) -> None: ...
    def insert_submenu(self, position: int, label: Optional[str], submenu: MenuModel) -> None: ...
    @classmethod
    def new(cls) -> Menu: ...
    def prepend(self, label: Optional[str], detailed_action: Optional[str]) -> None: ...
    def prepend_item(self, item: MenuItem) -> None: ...
    def prepend_section(self, label: Optional[str], section: MenuModel) -> None: ...
    def prepend_submenu(self, label: Optional[str], submenu: MenuModel) -> None: ...
    def remove(self, position: int) -> None: ...
    def remove_all(self) -> None: ...
    

class MenuAttributeIter:
    parent_instance = ...
    priv = ...
    
    def get_name(*args, **kwargs): ...
    def get_next(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def next(*args, **kwargs): ...
    
    def do_get_next(self, *args, **kwargs): ...


class MenuItem:
    def get_attribute_value(self, attribute: str, expected_type: Optional[GLib.VariantType] = ...) -> Optional[GLib.Variant]: ...
    def get_link(self, link: str) -> MenuModel: ...
    @classmethod
    def new(cls, label: Optional[str] = None, action: Optional[str] = None) -> MenuItem: ...
    @classmethod
    def new_from_model(cls, model: MenuModel, item_index: int) -> MenuItem: ...
    @classmethod
    def new_section(cls, label: Optional[str], section: MenuModel) -> MenuItem: ...
    @classmethod
    def new_submenu(cls, label: Optional[str], submenu: MenuModel) -> MenuItem: ...
    def set_action_and_target_value(self, action: Optional[str], target_value: Optional[GLib.Variant]) -> None: ...
    def set_attribute(self, attributes: list[tuple[str, str, Any]]) -> None: ...
    def set_attribute_value(self, attribute: str, value: Optional[GLib.Variant]) -> None: ...
    def set_detailed_action(self, detailed_action: str) -> None: ...
    def set_icon(self, icon: Icon) -> None: ...
    def set_label(self, label: Optional[str]) -> None: ...
    def set_link(self, link: str, model: Optional[MenuModel]) -> None: ...
    def set_section(self, section: Optional[MenuModel]) -> None: ...
    def set_submenu(self, submenu: Optional[MenuModel]) -> None: ...
    

class MenuLinkIter:
    parent_instance = ...
    priv = ...
    
    def get_name(*args, **kwargs): ...
    def get_next(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def next(*args, **kwargs): ...
    
    def do_get_next(self, *args, **kwargs): ...
    

class MenuModel(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def get_item_attribute_value(self, item_index: int, attribute: str, expected_type: Optional[GLib.VariantType] = ...) -> GLib.Variant: ...
    def get_item_link(self, item_index: int, link: str) -> MenuModel: ...
    def get_n_items(self) -> int: ...
    def is_mutable(*args, **kwargs): ...
    def items_changed(*args, **kwargs): ...
    def iterate_item_attributes(*args, **kwargs): ...
    def iterate_item_links(*args, **kwargs): ...
    
    def do_get_item_attribute_value(self, *args, **kwargs): ...
    def do_get_item_attributes(self, *args, **kwargs): ...
    def do_get_item_link(self, *args, **kwargs): ...
    def do_get_item_links(self, *args, **kwargs): ...
    def do_get_n_items(self, *args, **kwargs): ...
    def do_is_mutable(self, *args, **kwargs): ...
    def do_iterate_item_attributes(self, *args, **kwargs): ...
    def do_iterate_item_links(self, *args, **kwargs): ...
    

class Mount:
    def can_eject(*args, **kwargs): ...
    def can_unmount(*args, **kwargs): ...
    def eject(*args, **kwargs): ...
    def eject_finish(*args, **kwargs): ...
    def eject_with_operation(*args, **kwargs): ...
    def eject_with_operation_finish(*args, **kwargs): ...
    def get_default_location(*args, **kwargs): ...
    def get_drive(*args, **kwargs): ...
    def get_icon(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_root(*args, **kwargs): ...
    def get_sort_key(*args, **kwargs): ...
    def get_symbolic_icon(*args, **kwargs): ...
    def get_uuid(*args, **kwargs): ...
    def get_volume(*args, **kwargs): ...
    def guess_content_type(*args, **kwargs): ...
    def guess_content_type_finish(*args, **kwargs): ...
    def guess_content_type_sync(*args, **kwargs): ...
    def is_shadowed(*args, **kwargs): ...
    def remount(*args, **kwargs): ...
    def remount_finish(*args, **kwargs): ...
    def shadow(*args, **kwargs): ...
    def unmount(*args, **kwargs): ...
    def unmount_finish(*args, **kwargs): ...
    def unmount_with_operation(*args, **kwargs): ...
    def unmount_with_operation_finish(*args, **kwargs): ...
    def unshadow(*args, **kwargs): ...
    

class MountOperation:
    parent_instance = ...
    priv = ...
    
    def get_anonymous(*args, **kwargs): ...
    def get_choice(*args, **kwargs): ...
    def get_domain(*args, **kwargs): ...
    def get_is_tcrypt_hidden_volume(*args, **kwargs): ...
    def get_is_tcrypt_system_volume(*args, **kwargs): ...
    def get_password(*args, **kwargs): ...
    def get_password_save(*args, **kwargs): ...
    def get_pim(*args, **kwargs): ...
    def get_username(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def reply(*args, **kwargs): ...
    def set_anonymous(*args, **kwargs): ...
    def set_choice(*args, **kwargs): ...
    def set_domain(*args, **kwargs): ...
    def set_is_tcrypt_hidden_volume(*args, **kwargs): ...
    def set_is_tcrypt_system_volume(*args, **kwargs): ...
    def set_password(*args, **kwargs): ...
    def set_password_save(*args, **kwargs): ...
    def set_pim(*args, **kwargs): ...
    def set_username(*args, **kwargs): ...
    
    def do_aborted(self, *args, **kwargs): ...
    def do_ask_password(self, *args, **kwargs): ...
    def do_ask_question(self, *args, **kwargs): ...
    def do_reply(self, *args, **kwargs): ...
    def do_show_processes(self, *args, **kwargs): ...
    def do_show_unmount_progress(self, *args, **kwargs): ...
    

class NativeSocketAddress:
    priv = ...
    
    def new(*args, **kwargs): ...
    

class NativeVolumeMonitor: ...

class NetworkAddress(SocketConnectable):
    parent_instance = ...
    priv = ...
    
    def get_hostname(*args, **kwargs): ...
    def get_port(*args, **kwargs): ...
    def get_scheme(*args, **kwargs): ...
    @classmethod
    def new(cls, hostname: str, port: int) -> NetworkAddress: ...
    def new_loopback(*args, **kwargs): ...
    def parse(*args, **kwargs): ...
    def parse_uri(*args, **kwargs): ...
    

class NetworkMonitor(GObject.GInterface, GObject.Object):
    def can_reach(self, connectable: SocketConnectable, cancellable: Optional[Cancellable]) -> bool: ...
    def can_reach_async(self, connectable: SocketConnectable, cancellable: Optional[Cancellable], callback: Optional[AsyncReadyCallback], *user_data: Any) -> None: ...
    def can_reach_finish(self, result: AsyncResult) -> bool: ...
    def get_connectivity(self) -> NetworkConnectivity: ...
    @classmethod
    def get_default(cls) -> NetworkMonitor: ...
    def get_network_available(self) -> bool: ...
    def get_network_metered(self) -> bool: ...
    

class NetworkMonitorInterface:
    can_reach = ...
    can_reach_async = ...
    can_reach_finish = ...
    g_iface = ...
    network_changed = ...
    

class NetworkService(SocketConnectable):
    parent_instance = ...
    priv = ...
    
    def get_domain(*args, **kwargs): ...
    def get_protocol(*args, **kwargs): ...
    def get_scheme(*args, **kwargs): ...
    def get_service(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_scheme(*args, **kwargs): ...
    

class Notification(GObject.Object):
    def add_button(self, label: str, detailed_action: str) -> None: ...
    def add_button_with_target(self, label: str, action: str, target: Optional[GLib.Variant]) -> None: ...
    @classmethod
    def new(cls, title: str) -> Notification: ...
    def set_body(self, body: Optional[str]) -> None: ...
    def set_default_action(self, default_action: str) -> None: ...
    def set_default_action_and_target(self, action: str, target: Optional[GLib.Variant]) -> None: ...
    def set_icon(self, icon: Icon) -> None: ...
    def set_priority(self, priority: NotificationPriority) -> None: ...
    def set_title(self, title: str) -> None: ...
    def set_urgent(self, urgent: bool) -> None: ...
    

class OutputMessage:
    address = ...
    bytes_sent = ...
    control_messages = ...
    num_control_messages = ...
    num_vectors = ...
    vectors = ...
    

class OutputStream:
    parent_instance = ...
    priv = ...
    
    def clear_pending(*args, **kwargs): ...
    def close(*args, **kwargs): ...
    def close_async(*args, **kwargs): ...
    def close_finish(*args, **kwargs): ...
    def flush(*args, **kwargs): ...
    def flush_async(*args, **kwargs): ...
    def flush_finish(*args, **kwargs): ...
    def has_pending(self) -> bool: ...
    def is_closed(*args, **kwargs): ...
    def is_closing(*args, **kwargs): ...
    def set_pending(*args, **kwargs): ...
    def splice(*args, **kwargs): ...
    def splice_async(*args, **kwargs): ...
    def splice_finish(*args, **kwargs): ...
    def write(*args, **kwargs): ...
    def write_all(*args, **kwargs): ...
    @overload
    def write_all_async(self, buffer: bytes, io_priority: int, cancellable: Optional[Cancellable] = ..., callback: Optional[AsyncReadyCallback] = ... ) -> None: ...
    @overload
    def write_all_async(self, buffer: bytes, io_priority: int, cancellable: Optional[Cancellable] = ..., callback: Optional[AsyncReadyCallbackU] = ..., *user_data: Optional[Any]) -> None: ...
    def write_all_finish(self, result: AsyncResult) -> tuple[bool, int]: ...
    def write_async(*args, **kwargs): ...
    def write_bytes(*args, **kwargs): ...
    def write_bytes_async(*args, **kwargs): ...
    def write_bytes_finish(*args, **kwargs): ...
    def write_finish(*args, **kwargs): ...
    def writev(*args, **kwargs): ...
    def writev_all(*args, **kwargs): ...
    def writev_all_async(*args, **kwargs): ...
    def writev_all_finish(*args, **kwargs): ...
    def writev_async(*args, **kwargs): ...
    def writev_finish(*args, **kwargs): ...
    
    def do_close_async(self, *args, **kwargs): ...
    def do_close_finish(self, *args, **kwargs): ...
    def do_close_fn(self, *args, **kwargs): ...
    def do_flush(self, *args, **kwargs): ...
    def do_flush_async(self, *args, **kwargs): ...
    def do_flush_finish(self, *args, **kwargs): ...
    def do_splice(self, *args, **kwargs): ...
    def do_splice_async(self, *args, **kwargs): ...
    def do_splice_finish(self, *args, **kwargs): ...
    def do_write_async(self, *args, **kwargs): ...
    def do_write_finish(self, *args, **kwargs): ...
    def do_write_fn(self, *args, **kwargs): ...
    def do_writev_async(self, *args, **kwargs): ...
    def do_writev_finish(self, *args, **kwargs): ...
    def do_writev_fn(self, *args, **kwargs): ...
    

class OutputVector:
    buffer = ...
    size = ...
    

class Permission:
    parent_instance = ...
    priv = ...
    
    def acquire(*args, **kwargs): ...
    def acquire_async(*args, **kwargs): ...
    def acquire_finish(*args, **kwargs): ...
    def get_allowed(*args, **kwargs): ...
    def get_can_acquire(*args, **kwargs): ...
    def get_can_release(*args, **kwargs): ...
    def impl_update(*args, **kwargs): ...
    def release(*args, **kwargs): ...
    def release_async(*args, **kwargs): ...
    def release_finish(*args, **kwargs): ...
    
    def do_acquire(self, *args, **kwargs): ...
    def do_acquire_async(self, *args, **kwargs): ...
    def do_acquire_finish(self, *args, **kwargs): ...
    def do_release(self, *args, **kwargs): ...
    def do_release_async(self, *args, **kwargs): ...
    def do_release_finish(self, *args, **kwargs): ...
    

class PollableInputStream:
    def can_poll(*args, **kwargs): ...
    def create_source(*args, **kwargs): ...
    def is_readable(*args, **kwargs): ...
    def read_nonblocking(*args, **kwargs): ...
    

class PollableInputStreamInterface:
    can_poll = ...
    create_source = ...
    g_iface = ...
    is_readable = ...
    read_nonblocking = ...
    

class PollableOutputStream:
    def can_poll(*args, **kwargs): ...
    def create_source(*args, **kwargs): ...
    def is_writable(*args, **kwargs): ...
    def write_nonblocking(*args, **kwargs): ...
    def writev_nonblocking(*args, **kwargs): ...
    

class PollableOutputStreamInterface:
    can_poll = ...
    create_source = ...
    g_iface = ...
    is_writable = ...
    write_nonblocking = ...
    writev_nonblocking = ...
    

class PropertyAction:
    def new(*args, **kwargs): ...
    

class Proxy:
    def connect(*args, **kwargs): ...
    def connect_async(*args, **kwargs): ...
    def connect_finish(*args, **kwargs): ...
    def get_default_for_protocol(*args, **kwargs): ...
    def supports_hostname(*args, **kwargs): ...
    

class ProxyAddress:
    def get_destination_hostname(*args, **kwargs): ...
    def get_destination_port(*args, **kwargs): ...
    def get_destination_protocol(*args, **kwargs): ...
    def get_password(*args, **kwargs): ...
    def get_protocol(*args, **kwargs): ...
    def get_uri(*args, **kwargs): ...
    def get_username(*args, **kwargs): ...
    

class ProxyAddressEnumerator:
    priv = ...
    

class ProxyInterface:
    connect = ...
    connect_async = ...
    connect_finish = ...
    g_iface = ...
    supports_hostname = ...
    

class ProxyResolver:
    def get_default(*args, **kwargs): ...
    def is_supported(*args, **kwargs): ...
    def lookup(*args, **kwargs): ...
    def lookup_async(*args, **kwargs): ...
    def lookup_finish(*args, **kwargs): ...
    

class ProxyResolverInterface:
    g_iface = ...
    is_supported = ...
    lookup = ...
    lookup_async = ...
    lookup_finish = ...
    

class RemoteActionGroup:
    def activate_action_full(*args, **kwargs): ...
    def change_action_state_full(*args, **kwargs): ...
    

class RemoteActionGroupInterface:
    activate_action_full = ...
    change_action_state_full = ...
    g_iface = ...
    

class Resolver:
    parent_instance = ...
    priv = ...

    @classmethod
    def get_default(cls) -> Resolver: ...
    def lookup_by_address(*args, **kwargs): ...
    def lookup_by_address_async(*args, **kwargs): ...
    def lookup_by_address_finish(*args, **kwargs): ...
    def lookup_by_name(*args, **kwargs): ...
    def lookup_by_name_async(*args, **kwargs): ...
    def lookup_by_name_finish(*args, **kwargs): ...
    def lookup_by_name_with_flags(*args, **kwargs): ...
    def lookup_by_name_with_flags_async(*args, **kwargs): ...
    def lookup_by_name_with_flags_finish(*args, **kwargs): ...
    def lookup_records(*args, **kwargs): ...
    def lookup_records_async(self, rrname: str, record_type: ResolverRecordType, cancellable: Optional[Any] = ..., callback: AsyncReadyCallbackU = ..., user_data: Any = ...) -> None: ...
    def lookup_records_finish(self, result: AsyncResult) -> list[GLib.Variant]: ...
    def lookup_service(*args, **kwargs): ...
    def lookup_service_async(*args, **kwargs): ...
    def lookup_service_finish(*args, **kwargs): ...
    def set_default(*args, **kwargs): ...
    
    def do_lookup_by_address(self, *args, **kwargs): ...
    def do_lookup_by_address_async(self, *args, **kwargs): ...
    def do_lookup_by_address_finish(self, *args, **kwargs): ...
    def do_lookup_by_name(self, *args, **kwargs): ...
    def do_lookup_by_name_async(self, *args, **kwargs): ...
    def do_lookup_by_name_finish(self, *args, **kwargs): ...
    def do_lookup_by_name_with_flags(self, *args, **kwargs): ...
    def do_lookup_by_name_with_flags_async(self, *args, **kwargs): ...
    def do_lookup_by_name_with_flags_finish(self, *args, **kwargs): ...
    def do_lookup_records(self, *args, **kwargs): ...
    def do_lookup_records_async(self, *args, **kwargs): ...
    def do_lookup_records_finish(self, *args, **kwargs): ...
    def do_lookup_service_async(self, *args, **kwargs): ...
    def do_lookup_service_finish(self, *args, **kwargs): ...
    def do_reload(self, *args, **kwargs): ...
    

class Resource:
    def enumerate_children(*args, **kwargs): ...
    def get_info(*args, **kwargs): ...
    def load(*args, **kwargs): ...
    def lookup_data(*args, **kwargs): ...
    def new_from_data(*args, **kwargs): ...
    def open_stream(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class Seekable:
    def can_seek(*args, **kwargs): ...
    def can_truncate(*args, **kwargs): ...
    def seek(*args, **kwargs): ...
    def tell(*args, **kwargs): ...
    def truncate(*args, **kwargs): ...
    

class Settings:
    parent_instance = ...
    priv = ...
    
    def apply(*args, **kwargs): ...
    def bind(*args, **kwargs): ...
    def bind_writable(*args, **kwargs): ...
    def create_action(*args, **kwargs): ...
    def delay(*args, **kwargs): ...
    def get_boolean(*args, **kwargs): ...
    def get_child(*args, **kwargs): ...
    def get_default_value(*args, **kwargs): ...
    def get_double(*args, **kwargs): ...
    def get_enum(*args, **kwargs): ...
    def get_flags(*args, **kwargs): ...
    def get_has_unapplied(*args, **kwargs): ...
    def get_int(*args, **kwargs): ...
    def get_int64(*args, **kwargs): ...
    def get_mapped(*args, **kwargs): ...
    def get_range(*args, **kwargs): ...
    def get_string(*args, **kwargs): ...
    def get_strv(*args, **kwargs): ...
    def get_uint(*args, **kwargs): ...
    def get_uint64(*args, **kwargs): ...
    def get_user_value(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def is_writable(*args, **kwargs): ...
    def keys(*args, **kwargs): ...
    def list_children(*args, **kwargs): ...
    def list_keys(*args, **kwargs): ...
    def list_relocatable_schemas(*args, **kwargs): ...
    def list_schemas(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_full(*args, **kwargs): ...
    def new_with_backend(*args, **kwargs): ...
    def new_with_backend_and_path(*args, **kwargs): ...
    def new_with_path(*args, **kwargs): ...
    def range_check(*args, **kwargs): ...
    def reset(*args, **kwargs): ...
    def revert(*args, **kwargs): ...
    def set_boolean(*args, **kwargs): ...
    def set_double(*args, **kwargs): ...
    def set_enum(*args, **kwargs): ...
    def set_flags(*args, **kwargs): ...
    def set_int(*args, **kwargs): ...
    def set_int64(*args, **kwargs): ...
    def set_string(*args, **kwargs): ...
    def set_strv(*args, **kwargs): ...
    def set_uint(*args, **kwargs): ...
    def set_uint64(*args, **kwargs): ...
    def set_value(*args, **kwargs): ...
    def sync(*args, **kwargs): ...
    def unbind(*args, **kwargs): ...
    
    def do_change_event(self, *args, **kwargs): ...
    def do_changed(self, *args, **kwargs): ...
    def do_writable_change_event(self, *args, **kwargs): ...
    def do_writable_changed(self, *args, **kwargs): ...
    

class SettingsBackend:
    parent_instance = ...
    priv = ...
    
    def changed(*args, **kwargs): ...
    def changed_tree(*args, **kwargs): ...
    def flatten_tree(*args, **kwargs): ...
    def get_default(*args, **kwargs): ...
    def keys_changed(*args, **kwargs): ...
    def path_changed(*args, **kwargs): ...
    def path_writable_changed(*args, **kwargs): ...
    def writable_changed(*args, **kwargs): ...
    
    def do_get_writable(self, *args, **kwargs): ...
    def do_read(self, *args, **kwargs): ...
    def do_read_user_value(self, *args, **kwargs): ...
    def do_reset(self, *args, **kwargs): ...
    def do_subscribe(self, *args, **kwargs): ...
    def do_sync(self, *args, **kwargs): ...
    def do_unsubscribe(self, *args, **kwargs): ...
    def do_write(self, *args, **kwargs): ...
    def do_write_tree(self, *args, **kwargs): ...
    

class SettingsSchema:
    def get_id(*args, **kwargs): ...
    def get_key(*args, **kwargs): ...
    def get_path(*args, **kwargs): ...
    def has_key(*args, **kwargs): ...
    def list_children(*args, **kwargs): ...
    def list_keys(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class SettingsSchemaKey:
    def get_default_value(*args, **kwargs): ...
    def get_description(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_range(*args, **kwargs): ...
    def get_summary(*args, **kwargs): ...
    def get_value_type(*args, **kwargs): ...
    def range_check(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class SettingsSchemaSource:
    def get_default(*args, **kwargs): ...
    def list_schemas(*args, **kwargs): ...
    def lookup(*args, **kwargs): ...
    def new_from_directory(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...


class SimpleAction(Action, GObject.Object):
    @classmethod
    def new(cls, name: str, parameter_type: Optional[GLib.VariantType]) -> SimpleAction: ...
    @classmethod
    def new_stateful(cls, name: str, parameter_type: Optional[GLib.VariantType], state: GLib.Variant) -> SimpleAction: ...
    def set_enabled(self, enabled: bool) -> None: ...
    def set_state(self, value: GLib.Variant) -> None: ...
    def set_state_hint(*args, **kwargs): ...
    

class SimpleActionGroup:
    parent_instance = ...
    priv = ...
    
    def add_entries(*args, **kwargs): ...
    def insert(*args, **kwargs): ...
    def lookup(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def remove(*args, **kwargs): ...
    

class SimpleAsyncResult:
    def complete(*args, **kwargs): ...
    def complete_in_idle(*args, **kwargs): ...
    def get_op_res_gboolean(*args, **kwargs): ...
    def get_op_res_gssize(*args, **kwargs): ...
    def is_valid(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_error(*args, **kwargs): ...
    def propagate_error(*args, **kwargs): ...
    def set_check_cancellable(*args, **kwargs): ...
    def set_from_error(*args, **kwargs): ...
    def set_handle_cancellation(*args, **kwargs): ...
    def set_op_res_gboolean(*args, **kwargs): ...
    def set_op_res_gssize(*args, **kwargs): ...
    

class SimpleIOStream:
    def new(*args, **kwargs): ...
    

class SimplePermission:
    def new(*args, **kwargs): ...


class SimpleProxyResolver(ProxyResolver):
    parent_instance = ...
    priv = ...
    
    @classmethod
    def new(cls, default_proxy: Optional[str], ignore_hosts: Optional[str]) -> SimpleProxyResolver: ...
    def set_default_proxy(*args, **kwargs): ...
    def set_ignore_hosts(*args, **kwargs): ...
    def set_uri_proxy(*args, **kwargs): ...
    

class Socket:
    parent_instance = ...
    priv = ...
    
    def accept(*args, **kwargs): ...
    def bind(*args, **kwargs): ...
    def check_connect_result(*args, **kwargs): ...
    def close(*args, **kwargs): ...
    def condition_timed_wait(*args, **kwargs): ...
    def connection_factory_create_connection(*args, **kwargs): ...
    def get_available_bytes(*args, **kwargs): ...
    def get_blocking(*args, **kwargs): ...
    def get_broadcast(*args, **kwargs): ...
    def get_credentials(*args, **kwargs): ...
    def get_family(*args, **kwargs): ...
    def get_fd(*args, **kwargs): ...
    def get_keepalive(*args, **kwargs): ...
    def get_listen_backlog(*args, **kwargs): ...
    def get_local_address(*args, **kwargs): ...
    def get_multicast_loopback(*args, **kwargs): ...
    def get_multicast_ttl(*args, **kwargs): ...
    def get_option(*args, **kwargs): ...
    def get_protocol(*args, **kwargs): ...
    def get_remote_address(*args, **kwargs): ...
    def get_socket_type(*args, **kwargs): ...
    def get_timeout(*args, **kwargs): ...
    def get_ttl(*args, **kwargs): ...
    def is_closed(*args, **kwargs): ...
    def is_connected(*args, **kwargs): ...
    def join_multicast_group(*args, **kwargs): ...
    def join_multicast_group_ssm(*args, **kwargs): ...
    def leave_multicast_group(*args, **kwargs): ...
    def leave_multicast_group_ssm(*args, **kwargs): ...
    def listen(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_fd(*args, **kwargs): ...
    def receive(*args, **kwargs): ...
    def receive_from(*args, **kwargs): ...
    def receive_message(*args, **kwargs): ...
    def receive_with_blocking(*args, **kwargs): ...
    def send(*args, **kwargs): ...
    def send_message(*args, **kwargs): ...
    def send_message_with_timeout(*args, **kwargs): ...
    def send_to(*args, **kwargs): ...
    def send_with_blocking(*args, **kwargs): ...
    def set_blocking(*args, **kwargs): ...
    def set_broadcast(*args, **kwargs): ...
    def set_keepalive(self, keepalive: bool) -> None: ...
    def set_listen_backlog(*args, **kwargs): ...
    def set_multicast_loopback(*args, **kwargs): ...
    def set_multicast_ttl(*args, **kwargs): ...
    def set_option(*args, **kwargs): ...
    def set_ttl(*args, **kwargs): ...
    def set_timeout(self, timeout: int) -> None: ...
    def shutdown(self, shutdown_read: bool, shutdown_write: bool) -> bool: ...
    def speaks_ipv4(*args, **kwargs): ...
    

class SocketAddress(SocketConnectable):
    parent_instance = ...
    
    def get_family(*args, **kwargs): ...
    def get_native_size(*args, **kwargs): ...
    def new_from_native(*args, **kwargs): ...
    def to_native(*args, **kwargs): ...
    
    def do_get_family(self, *args, **kwargs): ...
    def do_get_native_size(self, *args, **kwargs): ...
    def do_to_native(self, *args, **kwargs): ...
    

class SocketAddressEnumerator:
    parent_instance = ...
    
    def next(*args, **kwargs): ...
    def next_async(*args, **kwargs): ...
    def next_finish(*args, **kwargs): ...
    
    def do_next(self, *args, **kwargs): ...
    def do_next_async(self, *args, **kwargs): ...
    def do_next_finish(self, *args, **kwargs): ...


class SocketClient:
    parent_instance = ...
    priv = ...
    
    def add_application_proxy(*args, **kwargs): ...
    def connect_async(*args, **kwargs): ...
    def connect_finish(*args, **kwargs): ...
    def connect_to_host(*args, **kwargs): ...
    def connect_to_host_async(self, host_and_port: str, default_port: int, cancellable: Optional[Cancellable] = ..., callback: Optional[AsyncReadyCallbackU] = ..., *user_data: Any) -> None: ...
    def connect_to_host_finish(self, result: AsyncResult) -> TcpConnection: ...
    def connect_to_service(*args, **kwargs): ...
    def connect_to_service_async(self, domain: str, service: str, cancellable: Optional[Cancellable] = ..., callback: Optional[AsyncReadyCallbackU] = ..., *user_data: Any) -> None: ...
    def connect_to_service_finish(self, result: AsyncResult) -> TcpConnection: ...
    def connect_to_uri(*args, **kwargs): ...
    def connect_to_uri_async(*args, **kwargs): ...
    def connect_to_uri_finish(*args, **kwargs): ...
    def get_enable_proxy(*args, **kwargs): ...
    def get_family(*args, **kwargs): ...
    def get_local_address(*args, **kwargs): ...
    def get_protocol(*args, **kwargs): ...
    def get_proxy_resolver(*args, **kwargs): ...
    def get_socket_type(*args, **kwargs): ...
    def get_timeout(*args, **kwargs): ...
    def get_tls(*args, **kwargs): ...
    def get_tls_validation_flags(*args, **kwargs): ...
    @classmethod
    def new(cls) -> SocketClient: ...
    def set_enable_proxy(*args, **kwargs): ...
    def set_family(*args, **kwargs): ...
    def set_local_address(*args, **kwargs): ...
    def set_protocol(*args, **kwargs): ...
    def set_proxy_resolver(self, proxy_resolver: Optional[ProxyResolver]) -> None: ...
    def set_socket_type(*args, **kwargs): ...
    def set_timeout(self, timeout: int) -> None: ...
    def set_tls(*args, **kwargs): ...
    def set_tls_validation_flags(*args, **kwargs): ...
    
    def do_event(self, *args, **kwargs): ...
    

class SocketConnectable:
    def enumerate(*args, **kwargs): ...
    def proxy_enumerate(*args, **kwargs): ...
    def to_string(self) -> str: ...


class SocketConnection(IOStream):
    def connect_async(*args, **kwargs): ...
    def connect_finish(*args, **kwargs): ...
    def factory_lookup_type(*args, **kwargs): ...
    def factory_register_type(*args, **kwargs): ...
    def get_local_address(self) -> SocketAddress: ...
    def get_remote_address(self) -> InetSocketAddress: ...
    def get_socket(self) -> Socket: ...
    def is_connected(*args, **kwargs): ...
    

class SocketControlMessage:
    parent_instance = ...
    priv = ...
    
    def deserialize(*args, **kwargs): ...
    def get_level(*args, **kwargs): ...
    def get_msg_type(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def serialize(*args, **kwargs): ...
    
    def do_get_level(self, *args, **kwargs): ...
    def do_get_size(self, *args, **kwargs): ...
    def do_get_type(self, *args, **kwargs): ...
    def do_serialize(self, *args, **kwargs): ...
    

class SocketListener:
    parent_instance = ...
    priv = ...
    
    def accept(*args, **kwargs): ...
    def accept_async(*args, **kwargs): ...
    def accept_finish(*args, **kwargs): ...
    def accept_socket(*args, **kwargs): ...
    def accept_socket_async(*args, **kwargs): ...
    def accept_socket_finish(*args, **kwargs): ...
    def add_address(*args, **kwargs): ...
    def add_any_inet_port(*args, **kwargs): ...
    def add_inet_port(*args, **kwargs): ...
    def add_socket(*args, **kwargs): ...
    def close(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_backlog(*args, **kwargs): ...
    
    def do_changed(self, *args, **kwargs): ...
    def do_event(self, *args, **kwargs): ...
    

class SocketService:
    def is_active(*args, **kwargs): ...
    def start(*args, **kwargs): ...
    def stop(*args, **kwargs): ...
    
    def do_incoming(self, *args, **kwargs): ...
    

class SrvTarget:
    def free(*args, **kwargs): ...
    def get_hostname(*args, **kwargs): ...
    def get_port(*args, **kwargs): ...
    def get_priority(*args, **kwargs): ...
    def get_weight(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class StaticResource:
    data = ...
    data_len = ...
    next = ...
    padding = ...
    resource = ...
    
    def fini(*args, **kwargs): ...
    def get_resource(*args, **kwargs): ...
    def init(*args, **kwargs): ...
    

class Subprocess:
    def communicate(*args, **kwargs): ...
    def communicate_async(*args, **kwargs): ...
    def communicate_finish(*args, **kwargs): ...
    def communicate_utf8(*args, **kwargs): ...
    def communicate_utf8_async(*args, **kwargs): ...
    def communicate_utf8_finish(*args, **kwargs): ...
    def force_exit(*args, **kwargs): ...
    def get_exit_status(*args, **kwargs): ...
    def get_identifier(*args, **kwargs): ...
    def get_if_exited(*args, **kwargs): ...
    def get_if_signaled(*args, **kwargs): ...
    def get_status(*args, **kwargs): ...
    def get_stderr_pipe(*args, **kwargs): ...
    def get_stdin_pipe(*args, **kwargs): ...
    def get_stdout_pipe(*args, **kwargs): ...
    def get_successful(*args, **kwargs): ...
    def get_term_sig(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def send_signal(*args, **kwargs): ...
    def wait(*args, **kwargs): ...
    def wait_async(*args, **kwargs): ...
    def wait_check(*args, **kwargs): ...
    def wait_check_async(*args, **kwargs): ...
    def wait_check_finish(*args, **kwargs): ...
    def wait_finish(*args, **kwargs): ...
    

class SubprocessLauncher:
    def close(*args, **kwargs): ...
    def getenv(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_cwd(*args, **kwargs): ...
    def set_environ(*args, **kwargs): ...
    def set_flags(*args, **kwargs): ...
    def set_stderr_file_path(*args, **kwargs): ...
    def set_stdin_file_path(*args, **kwargs): ...
    def set_stdout_file_path(*args, **kwargs): ...
    def setenv(*args, **kwargs): ...
    def spawnv(*args, **kwargs): ...
    def take_fd(*args, **kwargs): ...
    def take_stderr_fd(*args, **kwargs): ...
    def take_stdin_fd(*args, **kwargs): ...
    def take_stdout_fd(*args, **kwargs): ...
    def unsetenv(*args, **kwargs): ...
    

class Task:
    def get_cancellable(*args, **kwargs): ...
    def get_check_cancellable(*args, **kwargs): ...
    def get_completed(*args, **kwargs): ...
    def get_context(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_priority(*args, **kwargs): ...
    def get_return_on_cancel(*args, **kwargs): ...
    def get_source_tag(*args, **kwargs): ...
    def get_task_data(*args, **kwargs): ...
    def had_error(*args, **kwargs): ...
    def is_valid(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def propagate_boolean(*args, **kwargs): ...
    def propagate_int(*args, **kwargs): ...
    def propagate_pointer(*args, **kwargs): ...
    def propagate_value(*args, **kwargs): ...
    def report_error(*args, **kwargs): ...
    def return_boolean(*args, **kwargs): ...
    def return_error(*args, **kwargs): ...
    def return_error_if_cancelled(*args, **kwargs): ...
    def return_int(*args, **kwargs): ...
    def return_pointer(*args, **kwargs): ...
    def return_value(*args, **kwargs): ...
    def run_in_thread(*args, **kwargs): ...
    def run_in_thread_sync(*args, **kwargs): ...
    def set_check_cancellable(*args, **kwargs): ...
    def set_name(*args, **kwargs): ...
    def set_priority(*args, **kwargs): ...
    def set_return_on_cancel(*args, **kwargs): ...
    def set_source_tag(*args, **kwargs): ...
    def set_task_data(*args, **kwargs): ...
    

class TcpConnection(SocketConnection):
    def get_graceful_disconnect(*args, **kwargs): ...
    def set_graceful_disconnect(self, graceful_disconnect: bool) -> None: ...
    

class TcpWrapperConnection(TcpConnection):
    def get_base_io_stream(*args, **kwargs): ...
    @classmethod
    def new(cls, base_io_stream: IOStream, socket: Socket) -> TcpWrapperConnection: ...
    

class TestDBus:
    def add_service_dir(*args, **kwargs): ...
    def down(*args, **kwargs): ...
    def get_bus_address(*args, **kwargs): ...
    def get_flags(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def stop(*args, **kwargs): ...
    def unset(*args, **kwargs): ...
    def up(*args, **kwargs): ...
    

class ThemedIcon(Icon, GObject.Object):
    def append_name(self, iconname) -> str: ...
    def get_names(self) -> list[str]: ...
    @classmethod
    def new(cls, iconname: str) -> ThemedIcon: ...
    @classmethod
    def new_from_names(cls, iconnames: list[str]) -> ThemedIcon: ...
    @classmethod
    def new_with_default_fallbacks(cls, iconname: str) -> ThemedIcon: ...
    def prepend_name(self, iconname: str): ...
    

class ThreadedSocketService:
    def do_run(self, *args, **kwargs): ...
    

class TlsBackend:
    def get_certificate_type(*args, **kwargs): ...
    def get_client_connection_type(*args, **kwargs): ...
    def get_default(*args, **kwargs): ...
    def get_default_database(*args, **kwargs): ...
    def get_dtls_client_connection_type(*args, **kwargs): ...
    def get_dtls_server_connection_type(*args, **kwargs): ...
    def get_file_database_type(*args, **kwargs): ...
    def get_server_connection_type(*args, **kwargs): ...
    def set_default_database(*args, **kwargs): ...
    def supports_dtls(*args, **kwargs): ...
    def supports_tls(*args, **kwargs): ...
    

class TlsBackendInterface:
    g_iface = ...
    get_certificate_type = ...
    get_client_connection_type = ...
    get_default_database = ...
    get_dtls_client_connection_type = ...
    get_dtls_server_connection_type = ...
    get_file_database_type = ...
    get_server_connection_type = ...
    supports_dtls = ...
    supports_tls = ...
    

class TlsCertificate:
    parent_instance = ...
    priv = ...

    class Props:
        certificate: GLib.ByteArray
        certificate_pem: str
        issuer: TlsCertificate
        private_key: GLib.ByteArray
        private_key_pem: str

    props: Props
    
    def get_issuer(*args, **kwargs): ...
    def is_same(self, certificate: TlsCertificate) -> bool: ...
    def list_new_from_file(*args, **kwargs): ...
    @classmethod
    def new_from_file(cls, file: str) -> TlsCertificate: ...
    def new_from_files(*args, **kwargs): ...
    def new_from_pem(*args, **kwargs): ...
    def new_from_pkcs11_uris(*args, **kwargs): ...
    def verify(*args, **kwargs): ...
    
    def do_verify(self, *args, **kwargs): ...
    

class TlsClientConnection(TlsConnection):
    def copy_session_state(*args, **kwargs): ...
    def get_accepted_cas(*args, **kwargs): ...
    def get_server_identity(*args, **kwargs): ...
    def get_use_ssl3(*args, **kwargs): ...
    def get_validation_flags(*args, **kwargs): ...
    @classmethod
    def new(cls, base_io_stream: IOStream, server_identity: SocketConnectable) -> TlsClientConnection: ...
    def set_server_identity(*args, **kwargs): ...
    def set_use_ssl3(*args, **kwargs): ...
    def set_validation_flags(self, flags: TlsCertificateFlags) -> None: ...
    

class TlsClientConnectionInterface:
    copy_session_state = ...
    g_iface = ...
    

class TlsConnection(IOStream):
    def emit_accept_certificate(*args, **kwargs): ...
    def get_certificate(*args, **kwargs): ...
    def get_channel_binding_data(*args, **kwargs): ...
    def get_database(*args, **kwargs): ...
    def get_interaction(*args, **kwargs): ...
    def get_negotiated_protocol(*args, **kwargs): ...
    def get_peer_certificate(self) -> TlsCertificate: ...
    def get_peer_certificate_errors(self) -> TlsCertificateFlags: ...
    def get_rehandshake_mode(*args, **kwargs): ...
    def get_require_close_notify(*args, **kwargs): ...
    def get_use_system_certdb(*args, **kwargs): ...
    def handshake(*args, **kwargs): ...
    def handshake_async(*args, **kwargs): ...
    def handshake_finish(*args, **kwargs): ...
    def set_advertised_protocols(self, protocols: Optional[list[str]]) -> None: ...
    def set_certificate(*args, **kwargs): ...
    def set_database(*args, **kwargs): ...
    def set_interaction(*args, **kwargs): ...
    def set_rehandshake_mode(*args, **kwargs): ...
    def set_require_close_notify(*args, **kwargs): ...
    def set_use_system_certdb(*args, **kwargs): ...
    
    def do_accept_certificate(self, *args, **kwargs): ...
    def do_get_binding_data(self, *args, **kwargs): ...
    def do_handshake(self, *args, **kwargs): ...
    def do_handshake_async(self, *args, **kwargs): ...
    def do_handshake_finish(self, *args, **kwargs): ...
    

class TlsDatabase:
    parent_instance = ...
    priv = ...
    
    def create_certificate_handle(*args, **kwargs): ...
    def lookup_certificate_for_handle(*args, **kwargs): ...
    def lookup_certificate_for_handle_async(*args, **kwargs): ...
    def lookup_certificate_for_handle_finish(*args, **kwargs): ...
    def lookup_certificate_issuer(*args, **kwargs): ...
    def lookup_certificate_issuer_async(*args, **kwargs): ...
    def lookup_certificate_issuer_finish(*args, **kwargs): ...
    def lookup_certificates_issued_by(*args, **kwargs): ...
    def lookup_certificates_issued_by_async(*args, **kwargs): ...
    def lookup_certificates_issued_by_finish(*args, **kwargs): ...
    def verify_chain(*args, **kwargs): ...
    def verify_chain_async(*args, **kwargs): ...
    def verify_chain_finish(*args, **kwargs): ...
    
    def do_create_certificate_handle(self, *args, **kwargs): ...
    def do_lookup_certificate_for_handle(self, *args, **kwargs): ...
    def do_lookup_certificate_for_handle_async(self, *args, **kwargs): ...
    def do_lookup_certificate_for_handle_finish(self, *args, **kwargs): ...
    def do_lookup_certificate_issuer(self, *args, **kwargs): ...
    def do_lookup_certificate_issuer_async(self, *args, **kwargs): ...
    def do_lookup_certificate_issuer_finish(self, *args, **kwargs): ...
    def do_lookup_certificates_issued_by(self, *args, **kwargs): ...
    def do_lookup_certificates_issued_by_async(self, *args, **kwargs): ...
    def do_lookup_certificates_issued_by_finish(self, *args, **kwargs): ...
    def do_verify_chain(self, *args, **kwargs): ...
    def do_verify_chain_async(self, *args, **kwargs): ...
    def do_verify_chain_finish(self, *args, **kwargs): ...
    

class TlsFileDatabase:
    def new(*args, **kwargs): ...
    

class TlsFileDatabaseInterface:
    g_iface = ...
    padding = ...
    

class TlsInteraction:
    parent_instance = ...
    priv = ...
    
    def ask_password(*args, **kwargs): ...
    def ask_password_async(*args, **kwargs): ...
    def ask_password_finish(*args, **kwargs): ...
    def invoke_ask_password(*args, **kwargs): ...
    def invoke_request_certificate(*args, **kwargs): ...
    def request_certificate(*args, **kwargs): ...
    def request_certificate_async(*args, **kwargs): ...
    def request_certificate_finish(*args, **kwargs): ...
    
    def do_ask_password(self, *args, **kwargs): ...
    def do_ask_password_async(self, *args, **kwargs): ...
    def do_ask_password_finish(self, *args, **kwargs): ...
    def do_request_certificate(self, *args, **kwargs): ...
    def do_request_certificate_async(self, *args, **kwargs): ...
    def do_request_certificate_finish(self, *args, **kwargs): ...
    

class TlsPassword:
    parent_instance = ...
    priv = ...
    
    def get_description(*args, **kwargs): ...
    def get_flags(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def get_warning(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_description(*args, **kwargs): ...
    def set_flags(*args, **kwargs): ...
    def set_value(*args, **kwargs): ...
    def set_value_full(*args, **kwargs): ...
    def set_warning(*args, **kwargs): ...
    
    def do_get_default_warning(self, *args, **kwargs): ...
    def do_get_value(self, *args, **kwargs): ...
    def do_set_value(self, *args, **kwargs): ...
    

class TlsServerConnection:
    def new(*args, **kwargs): ...
    

class TlsServerConnectionInterface:
    g_iface = ...
    

class UnixConnection:
    def receive_credentials(*args, **kwargs): ...
    def receive_credentials_async(*args, **kwargs): ...
    def receive_credentials_finish(*args, **kwargs): ...
    def receive_fd(*args, **kwargs): ...
    def send_credentials(*args, **kwargs): ...
    def send_credentials_async(*args, **kwargs): ...
    def send_credentials_finish(*args, **kwargs): ...
    def send_fd(*args, **kwargs): ...
    

class UnixCredentialsMessage:
    def get_credentials(*args, **kwargs): ...
    def is_supported(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_credentials(*args, **kwargs): ...
    

class UnixFDList(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def append(*args, **kwargs): ...
    def get(self, index_: int) -> int: ...
    def get_length(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_array(*args, **kwargs): ...
    def peek_fds(*args, **kwargs): ...
    def steal_fds(*args, **kwargs): ...
    

class UnixFDMessage:
    def append_fd(*args, **kwargs): ...
    def get_fd_list(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_fd_list(*args, **kwargs): ...
    def steal_fds(*args, **kwargs): ...
    

class UnixInputStream:
    def get_close_fd(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_close_fd(*args, **kwargs): ...
    

class UnixMountEntry: ...

class UnixMountMonitor:
    def get(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_rate_limit(*args, **kwargs): ...
    

class UnixMountPoint:
    def at(*args, **kwargs): ...
    def compare(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_device_path(*args, **kwargs): ...
    def get_fs_type(*args, **kwargs): ...
    def get_mount_path(*args, **kwargs): ...
    def get_options(*args, **kwargs): ...
    def guess_can_eject(*args, **kwargs): ...
    def guess_icon(*args, **kwargs): ...
    def guess_name(*args, **kwargs): ...
    def guess_symbolic_icon(*args, **kwargs): ...
    def is_loopback(*args, **kwargs): ...
    def is_readonly(*args, **kwargs): ...
    def is_user_mountable(*args, **kwargs): ...
    

class UnixOutputStream:
    def get_close_fd(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_close_fd(*args, **kwargs): ...
    

class UnixSocketAddress:
    priv = ...
    
    def abstract_names_supported(*args, **kwargs): ...
    def get_address_type(*args, **kwargs): ...
    def get_is_abstract(*args, **kwargs): ...
    def get_path(*args, **kwargs): ...
    def get_path_len(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_abstract(*args, **kwargs): ...
    def new_with_type(*args, **kwargs): ...
    

class Vfs:
    parent_instance = ...
    
    def get_default(*args, **kwargs): ...
    def get_file_for_path(*args, **kwargs): ...
    def get_file_for_uri(*args, **kwargs): ...
    def get_local(*args, **kwargs): ...
    def get_supported_uri_schemes(*args, **kwargs): ...
    def is_active(*args, **kwargs): ...
    def parse_name(*args, **kwargs): ...
    def register_uri_scheme(*args, **kwargs): ...
    def unregister_uri_scheme(*args, **kwargs): ...
    
    def do_add_writable_namespaces(self, *args, **kwargs): ...
    def do_get_file_for_path(self, *args, **kwargs): ...
    def do_get_file_for_uri(self, *args, **kwargs): ...
    def do_get_supported_uri_schemes(self, *args, **kwargs): ...
    def do_is_active(self, *args, **kwargs): ...
    def do_local_file_add_info(self, *args, **kwargs): ...
    def do_local_file_moved(self, *args, **kwargs): ...
    def do_local_file_removed(self, *args, **kwargs): ...
    def do_local_file_set_attributes(self, *args, **kwargs): ...
    def do_parse_name(self, *args, **kwargs): ...
    

class Volume:
    def can_eject(*args, **kwargs): ...
    def can_mount(*args, **kwargs): ...
    def eject(*args, **kwargs): ...
    def eject_finish(*args, **kwargs): ...
    def eject_with_operation(*args, **kwargs): ...
    def eject_with_operation_finish(*args, **kwargs): ...
    def enumerate_identifiers(*args, **kwargs): ...
    def get_activation_root(*args, **kwargs): ...
    def get_drive(*args, **kwargs): ...
    def get_icon(*args, **kwargs): ...
    def get_identifier(*args, **kwargs): ...
    def get_mount(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_sort_key(*args, **kwargs): ...
    def get_symbolic_icon(*args, **kwargs): ...
    def get_uuid(*args, **kwargs): ...
    def mount(*args, **kwargs): ...
    def mount_finish(*args, **kwargs): ...
    def should_automount(*args, **kwargs): ...
    

class VolumeMonitor:
    parent_instance = ...
    priv = ...
    
    def adopt_orphan_mount(*args, **kwargs): ...
    def get(*args, **kwargs): ...
    def get_connected_drives(*args, **kwargs): ...
    def get_mount_for_uuid(*args, **kwargs): ...
    def get_mounts(*args, **kwargs): ...
    def get_volume_for_uuid(*args, **kwargs): ...
    def get_volumes(*args, **kwargs): ...
    
    def do_drive_changed(self, *args, **kwargs): ...
    def do_drive_connected(self, *args, **kwargs): ...
    def do_drive_disconnected(self, *args, **kwargs): ...
    def do_drive_eject_button(self, *args, **kwargs): ...
    def do_drive_stop_button(self, *args, **kwargs): ...
    def do_get_connected_drives(self, *args, **kwargs): ...
    def do_get_mount_for_uuid(self, *args, **kwargs): ...
    def do_get_mounts(self, *args, **kwargs): ...
    def do_get_volume_for_uuid(self, *args, **kwargs): ...
    def do_get_volumes(self, *args, **kwargs): ...
    def do_mount_added(self, *args, **kwargs): ...
    def do_mount_changed(self, *args, **kwargs): ...
    def do_mount_pre_unmount(self, *args, **kwargs): ...
    def do_mount_removed(self, *args, **kwargs): ...
    def do_volume_added(self, *args, **kwargs): ...
    def do_volume_changed(self, *args, **kwargs): ...
    def do_volume_removed(self, *args, **kwargs): ...
    

class ZlibCompressor:
    def get_file_info(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_file_info(*args, **kwargs): ...
    

class ZlibDecompressor:
    def get_file_info(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class AppInfoCreateFlags(GObject.GFlags):
    NONE = ...
    NEEDS_TERMINAL = ...
    SUPPORTS_URIS = ...
    SUPPORTS_STARTUP_NOTIFICATION = ...

class ApplicationFlags(GObject.GFlags):
    FLAGS_NONE = ...
    IS_SERVICE = ...
    IS_LAUNCHER = ...
    HANDLES_OPEN = ...
    HANDLES_COMMAND_LINE = ...
    SEND_ENVIRONMENT = ...
    NON_UNIQUE = ...
    CAN_OVERRIDE_APP_ID = ...
    ALLOW_REPLACEMENT = ...
    REPLACE = ...

class AskPasswordFlags(GObject.GFlags):
    NEED_PASSWORD = ...
    NEED_USERNAME = ...
    NEED_DOMAIN = ...
    SAVING_SUPPORTED = ...
    ANONYMOUS_SUPPORTED = ...
    TCRYPT = ...

class BusNameOwnerFlags(GObject.GFlags):
    NONE = ...
    ALLOW_REPLACEMENT = ...
    REPLACE = ...
    DO_NOT_QUEUE = ...

class BusNameWatcherFlags(GObject.GFlags):
    NONE = ...
    AUTO_START = ...

class ConverterFlags(GObject.GFlags):
    NONE = ...
    INPUT_AT_END = ...
    FLUSH = ...

class DBusCallFlags(GObject.GFlags):
    NONE = ...
    NO_AUTO_START = ...
    ALLOW_INTERACTIVE_AUTHORIZATION = ...

class DBusCapabilityFlags(GObject.GFlags):
    NONE = ...
    UNIX_FD_PASSING = ...

class DBusConnectionFlags(GObject.GFlags):
    NONE = ...
    AUTHENTICATION_CLIENT = ...
    AUTHENTICATION_SERVER = ...
    AUTHENTICATION_ALLOW_ANONYMOUS = ...
    MESSAGE_BUS_CONNECTION = ...
    DELAY_MESSAGE_PROCESSING = ...
    AUTHENTICATION_REQUIRE_SAME_USER = ...

class DBusInterfaceSkeletonFlags(GObject.GFlags):
    NONE = ...
    HANDLE_METHOD_INVOCATIONS_IN_THREAD = ...

class DBusMessageFlags(GObject.GFlags):
    NONE = ...
    NO_REPLY_EXPECTED = ...
    NO_AUTO_START = ...
    ALLOW_INTERACTIVE_AUTHORIZATION = ...

class DBusObjectManagerClientFlags(GObject.GFlags):
    NONE = ...
    DO_NOT_AUTO_START = ...

class DBusPropertyInfoFlags(GObject.GFlags):
    NONE = ...
    READABLE = ...
    WRITABLE = ...

class DBusProxyFlags(GObject.GFlags):
    NONE = ...
    DO_NOT_LOAD_PROPERTIES = ...
    DO_NOT_CONNECT_SIGNALS = ...
    DO_NOT_AUTO_START = ...
    GET_INVALIDATED_PROPERTIES = ...
    DO_NOT_AUTO_START_AT_CONSTRUCTION = ...

class DBusSendMessageFlags(GObject.GFlags):
    NONE = ...
    PRESERVE_SERIAL = ...

class DBusServerFlags(GObject.GFlags):
    NONE = ...
    RUN_IN_THREAD = ...
    AUTHENTICATION_ALLOW_ANONYMOUS = ...
    AUTHENTICATION_REQUIRE_SAME_USER = ...

class DBusSignalFlags(GObject.GFlags):
    NONE = ...
    NO_MATCH_RULE = ...
    MATCH_ARG0_NAMESPACE = ...
    MATCH_ARG0_PATH = ...

class DBusSubtreeFlags(GObject.GFlags):
    NONE = ...
    DISPATCH_TO_UNENUMERATED_NODES = ...

class DriveStartFlags(GObject.GFlags):
    NONE = ...

class FileAttributeInfoFlags(GObject.GFlags):
    NONE = ...
    COPY_WITH_FILE = ...
    COPY_WHEN_MOVED = ...

class FileCopyFlags(GObject.GFlags):
    NONE = ...
    OVERWRITE = ...
    BACKUP = ...
    NOFOLLOW_SYMLINKS = ...
    ALL_METADATA = ...
    NO_FALLBACK_FOR_MOVE = ...
    TARGET_DEFAULT_PERMS = ...

class FileCreateFlags(GObject.GFlags):
    NONE = ...
    PRIVATE = ...
    REPLACE_DESTINATION = ...

class FileMeasureFlags(GObject.GFlags):
    NONE = ...
    REPORT_ANY_ERROR = ...
    APPARENT_SIZE = ...
    NO_XDEV = ...

class FileMonitorFlags(GObject.GFlags):
    NONE = ...
    WATCH_MOUNTS = ...
    SEND_MOVED = ...
    WATCH_HARD_LINKS = ...
    WATCH_MOVES = ...

class FileQueryInfoFlags(GObject.GFlags):
    NONE = ...
    NOFOLLOW_SYMLINKS = ...

class IOStreamSpliceFlags(GObject.GFlags):
    NONE = ...
    CLOSE_STREAM1 = ...
    CLOSE_STREAM2 = ...
    WAIT_FOR_BOTH = ...

class MountMountFlags(GObject.GFlags):
    NONE = ...

class MountUnmountFlags(GObject.GFlags):
    NONE = ...
    FORCE = ...

class OutputStreamSpliceFlags(GObject.GFlags):
    NONE = ...
    CLOSE_SOURCE = ...
    CLOSE_TARGET = ...

class ResolverNameLookupFlags(GObject.GFlags):
    DEFAULT = ...
    IPV4_ONLY = ...
    IPV6_ONLY = ...

class ResourceFlags(GObject.GFlags):
    NONE = ...
    COMPRESSED = ...

class ResourceLookupFlags(GObject.GFlags):
    NONE = ...

class SettingsBindFlags(GObject.GFlags):
    DEFAULT = ...
    GET = ...
    SET = ...
    NO_SENSITIVITY = ...
    GET_NO_CHANGES = ...
    INVERT_BOOLEAN = ...

class SocketMsgFlags(GObject.GFlags):
    NONE = ...
    OOB = ...
    PEEK = ...
    DONTROUTE = ...

class SubprocessFlags(GObject.GFlags):
    NONE = ...
    STDIN_PIPE = ...
    STDIN_INHERIT = ...
    STDOUT_PIPE = ...
    STDOUT_SILENCE = ...
    STDERR_PIPE = ...
    STDERR_SILENCE = ...
    STDERR_MERGE = ...
    INHERIT_FDS = ...

class TestDBusFlags(GObject.GFlags):
    NONE = ...

class TlsCertificateFlags(GObject.GFlags):
    UNKNOWN_CA = ...
    BAD_IDENTITY = ...
    NOT_ACTIVATED = ...
    EXPIRED = ...
    REVOKED = ...
    INSECURE = ...
    GENERIC_ERROR = ...
    VALIDATE_ALL = ...

class TlsDatabaseVerifyFlags(GObject.GFlags):
    NONE = ...

class TlsPasswordFlags(GObject.GFlags):
    NONE = ...
    RETRY = ...
    MANY_TRIES = ...
    FINAL_TRY = ...

class BusType(GObject.GEnum):
    STARTER = ...
    NONE = ...
    SYSTEM = ...
    SESSION = ...

class ConverterResult(GObject.GEnum):
    ERROR = ...
    CONVERTED = ...
    FINISHED = ...
    FLUSHED = ...

class CredentialsType(GObject.GEnum):
    INVALID = ...
    LINUX_UCRED = ...
    FREEBSD_CMSGCRED = ...
    OPENBSD_SOCKPEERCRED = ...
    SOLARIS_UCRED = ...
    NETBSD_UNPCBID = ...
    APPLE_XUCRED = ...

class DBusError(GObject.GEnum):
    FAILED = ...
    NO_MEMORY = ...
    SERVICE_UNKNOWN = ...
    NAME_HAS_NO_OWNER = ...
    NO_REPLY = ...
    IO_ERROR = ...
    BAD_ADDRESS = ...
    NOT_SUPPORTED = ...
    LIMITS_EXCEEDED = ...
    ACCESS_DENIED = ...
    AUTH_FAILED = ...
    NO_SERVER = ...
    TIMEOUT = ...
    NO_NETWORK = ...
    ADDRESS_IN_USE = ...
    DISCONNECTED = ...
    INVALID_ARGS = ...
    FILE_NOT_FOUND = ...
    FILE_EXISTS = ...
    UNKNOWN_METHOD = ...
    TIMED_OUT = ...
    MATCH_RULE_NOT_FOUND = ...
    MATCH_RULE_INVALID = ...
    SPAWN_EXEC_FAILED = ...
    SPAWN_FORK_FAILED = ...
    SPAWN_CHILD_EXITED = ...
    SPAWN_CHILD_SIGNALED = ...
    SPAWN_FAILED = ...
    SPAWN_SETUP_FAILED = ...
    SPAWN_CONFIG_INVALID = ...
    SPAWN_SERVICE_INVALID = ...
    SPAWN_SERVICE_NOT_FOUND = ...
    SPAWN_PERMISSIONS_INVALID = ...
    SPAWN_FILE_INVALID = ...
    SPAWN_NO_MEMORY = ...
    UNIX_PROCESS_ID_UNKNOWN = ...
    INVALID_SIGNATURE = ...
    INVALID_FILE_CONTENT = ...
    SELINUX_SECURITY_CONTEXT_UNKNOWN = ...
    ADT_AUDIT_DATA_UNKNOWN = ...
    OBJECT_PATH_IN_USE = ...
    UNKNOWN_OBJECT = ...
    UNKNOWN_INTERFACE = ...
    UNKNOWN_PROPERTY = ...
    PROPERTY_READ_ONLY = ...
    encode_gerror = ...
    get_remote_error = ...
    is_remote_error = ...
    new_for_dbus_error = ...
    quark = ...
    register_error = ...
    register_error_domain = ...
    strip_remote_error = ...
    unregister_error = ...

class DBusMessageByteOrder(GObject.GEnum):
    BIG_ENDIAN = ...
    LITTLE_ENDIAN = ...

class DBusMessageHeaderField(GObject.GEnum):
    INVALID = ...
    PATH = ...
    INTERFACE = ...
    MEMBER = ...
    ERROR_NAME = ...
    REPLY_SERIAL = ...
    DESTINATION = ...
    SENDER = ...
    SIGNATURE = ...
    NUM_UNIX_FDS = ...

class DBusMessageType(GObject.GEnum):
    INVALID = ...
    METHOD_CALL = ...
    METHOD_RETURN = ...
    ERROR = ...
    SIGNAL = ...

class DataStreamByteOrder(GObject.GEnum):
    BIG_ENDIAN = ...
    LITTLE_ENDIAN = ...
    HOST_ENDIAN = ...

class DataStreamNewlineType(GObject.GEnum):
    LF = ...
    CR = ...
    CR_LF = ...
    ANY = ...

class DriveStartStopType(GObject.GEnum):
    UNKNOWN = ...
    SHUTDOWN = ...
    NETWORK = ...
    MULTIDISK = ...
    PASSWORD = ...

class EmblemOrigin(GObject.GEnum):
    UNKNOWN = ...
    DEVICE = ...
    LIVEMETADATA = ...
    TAG = ...

class FileAttributeStatus(GObject.GEnum):
    UNSET = ...
    SET = ...
    ERROR_SETTING = ...

class FileAttributeType(GObject.GEnum):
    INVALID = ...
    STRING = ...
    BYTE_STRING = ...
    BOOLEAN = ...
    UINT32 = ...
    INT32 = ...
    UINT64 = ...
    INT64 = ...
    OBJECT = ...
    STRINGV = ...

class FileMonitorEvent(GObject.GEnum):
    CHANGED = ...
    CHANGES_DONE_HINT = ...
    DELETED = ...
    CREATED = ...
    ATTRIBUTE_CHANGED = ...
    PRE_UNMOUNT = ...
    UNMOUNTED = ...
    MOVED = ...
    RENAMED = ...
    MOVED_IN = ...
    MOVED_OUT = ...

class FileType(GObject.GEnum):
    UNKNOWN = ...
    REGULAR = ...
    DIRECTORY = ...
    SYMBOLIC_LINK = ...
    SPECIAL = ...
    SHORTCUT = ...
    MOUNTABLE = ...

class FilesystemPreviewType(GObject.GEnum):
    IF_ALWAYS = ...
    IF_LOCAL = ...
    NEVER = ...

class IOErrorEnum(GObject.GEnum):
    FAILED = ...
    NOT_FOUND = ...
    EXISTS = ...
    IS_DIRECTORY = ...
    NOT_DIRECTORY = ...
    NOT_EMPTY = ...
    NOT_REGULAR_FILE = ...
    NOT_SYMBOLIC_LINK = ...
    NOT_MOUNTABLE_FILE = ...
    FILENAME_TOO_LONG = ...
    INVALID_FILENAME = ...
    TOO_MANY_LINKS = ...
    NO_SPACE = ...
    INVALID_ARGUMENT = ...
    PERMISSION_DENIED = ...
    NOT_SUPPORTED = ...
    NOT_MOUNTED = ...
    ALREADY_MOUNTED = ...
    CLOSED = ...
    CANCELLED = ...
    PENDING = ...
    READ_ONLY = ...
    CANT_CREATE_BACKUP = ...
    WRONG_ETAG = ...
    TIMED_OUT = ...
    WOULD_RECURSE = ...
    BUSY = ...
    WOULD_BLOCK = ...
    HOST_NOT_FOUND = ...
    WOULD_MERGE = ...
    FAILED_HANDLED = ...
    TOO_MANY_OPEN_FILES = ...
    NOT_INITIALIZED = ...
    ADDRESS_IN_USE = ...
    PARTIAL_INPUT = ...
    INVALID_DATA = ...
    DBUS_ERROR = ...
    HOST_UNREACHABLE = ...
    NETWORK_UNREACHABLE = ...
    CONNECTION_REFUSED = ...
    PROXY_FAILED = ...
    PROXY_AUTH_FAILED = ...
    PROXY_NEED_AUTH = ...
    PROXY_NOT_ALLOWED = ...
    BROKEN_PIPE = ...
    CONNECTION_CLOSED = ...
    NOT_CONNECTED = ...
    MESSAGE_TOO_LARGE = ...

class IOModuleScopeFlags(GObject.GEnum):
    NONE = ...
    BLOCK_DUPLICATES = ...

class MemoryMonitorWarningLevel(GObject.GEnum):
    LOW = ...
    MEDIUM = ...
    CRITICAL = ...

class MountOperationResult(GObject.GEnum):
    HANDLED = ...
    ABORTED = ...
    UNHANDLED = ...

class NetworkConnectivity(GObject.GEnum):
    LOCAL = ...
    LIMITED = ...
    PORTAL = ...
    FULL = ...

class NotificationPriority(GObject.GEnum):
    NORMAL = ...
    LOW = ...
    HIGH = ...
    URGENT = ...

class PasswordSave(GObject.GEnum):
    NEVER = ...
    FOR_SESSION = ...
    PERMANENTLY = ...

class PollableReturn(GObject.GEnum):
    FAILED = ...
    OK = ...
    WOULD_BLOCK = ...

class ResolverError(GObject.GEnum):
    NOT_FOUND = ...
    TEMPORARY_FAILURE = ...
    INTERNAL = ...
    quark = ...

class ResolverRecordType(GObject.GEnum):
    SRV = ...
    MX = ...
    TXT = ...
    SOA = ...
    NS = ...

class ResourceError(GObject.GEnum):
    NOT_FOUND = ...
    INTERNAL = ...
    quark = ...

class SocketClientEvent(GObject.GEnum):
    RESOLVING = ...
    RESOLVED = ...
    CONNECTING = ...
    CONNECTED = ...
    PROXY_NEGOTIATING = ...
    PROXY_NEGOTIATED = ...
    TLS_HANDSHAKING = ...
    TLS_HANDSHAKED = ...
    COMPLETE = ...

class SocketFamily(GObject.GEnum):
    INVALID = ...
    UNIX = ...
    IPV4 = ...
    IPV6 = ...

class SocketListenerEvent(GObject.GEnum):
    BINDING = ...
    BOUND = ...
    LISTENING = ...
    LISTENED = ...

class SocketProtocol(GObject.GEnum):
    UNKNOWN = ...
    DEFAULT = ...
    TCP = ...
    UDP = ...
    SCTP = ...

class SocketType(GObject.GEnum):
    INVALID = ...
    STREAM = ...
    DATAGRAM = ...
    SEQPACKET = ...

class TlsAuthenticationMode(GObject.GEnum):
    NONE = ...
    REQUESTED = ...
    REQUIRED = ...

class TlsCertificateRequestFlags(GObject.GEnum):
    NONE = ...

class TlsChannelBindingError(GObject.GEnum):
    NOT_IMPLEMENTED = ...
    INVALID_STATE = ...
    NOT_AVAILABLE = ...
    NOT_SUPPORTED = ...
    GENERAL_ERROR = ...
    quark = ...

class TlsChannelBindingType(GObject.GEnum):
    UNIQUE = ...
    SERVER_END_POINT = ...

class TlsDatabaseLookupFlags(GObject.GEnum):
    NONE = ...
    KEYPAIR = ...

class TlsError(GObject.GEnum):
    UNAVAILABLE = ...
    MISC = ...
    BAD_CERTIFICATE = ...
    NOT_TLS = ...
    HANDSHAKE = ...
    CERTIFICATE_REQUIRED = ...
    EOF = ...
    INAPPROPRIATE_FALLBACK = ...
    quark = ...

class TlsInteractionResult(GObject.GEnum):
    UNHANDLED = ...
    HANDLED = ...
    FAILED = ...

class TlsRehandshakeMode(GObject.GEnum):
    NEVER = ...
    SAFELY = ...
    UNSAFELY = ...

class UnixSocketAddressType(GObject.GEnum):
    INVALID = ...
    ANONYMOUS = ...
    PATH = ...
    ABSTRACT = ...
    ABSTRACT_PADDED = ...

class ZlibCompressorFormat(GObject.GEnum):
    ZLIB = ...
    GZIP = ...
    RAW = ...
