
from typing import Optional
from typing import Tuple

from gi.repository import GLib
from gi.repository import GObject


ALLOCATOR_SYSMEM: str = ...
BUFFER_COPY_ALL = ...
BUFFER_COPY_METADATA = ...
BUFFER_OFFSET_NONE: int = ...
CAN_INLINE: int = ...
CAPS_FEATURE_MEMORY_SYSTEM_MEMORY: str = ...
CLOCK_TIME_NONE: int = ...
DEBUG_BG_MASK: int = ...
DEBUG_FG_MASK: int = ...
DEBUG_FORMAT_MASK: int = ...
ELEMENT_FACTORY_KLASS_DECODER: str = ...
ELEMENT_FACTORY_KLASS_DECRYPTOR: str = ...
ELEMENT_FACTORY_KLASS_DEMUXER: str = ...
ELEMENT_FACTORY_KLASS_DEPAYLOADER: str = ...
ELEMENT_FACTORY_KLASS_ENCODER: str = ...
ELEMENT_FACTORY_KLASS_ENCRYPTOR: str = ...
ELEMENT_FACTORY_KLASS_FORMATTER: str = ...
ELEMENT_FACTORY_KLASS_HARDWARE: str = ...
ELEMENT_FACTORY_KLASS_MEDIA_AUDIO: str = ...
ELEMENT_FACTORY_KLASS_MEDIA_IMAGE: str = ...
ELEMENT_FACTORY_KLASS_MEDIA_METADATA: str = ...
ELEMENT_FACTORY_KLASS_MEDIA_SUBTITLE: str = ...
ELEMENT_FACTORY_KLASS_MEDIA_VIDEO: str = ...
ELEMENT_FACTORY_KLASS_MUXER: str = ...
ELEMENT_FACTORY_KLASS_PARSER: str = ...
ELEMENT_FACTORY_KLASS_PAYLOADER: str = ...
ELEMENT_FACTORY_KLASS_SINK: str = ...
ELEMENT_FACTORY_KLASS_SRC: str = ...
ELEMENT_FACTORY_TYPE_ANY: int = ...
ELEMENT_FACTORY_TYPE_AUDIOVIDEO_SINKS: int = ...
ELEMENT_FACTORY_TYPE_AUDIO_ENCODER: int = ...
ELEMENT_FACTORY_TYPE_DECODABLE: int = ...
ELEMENT_FACTORY_TYPE_DECODER: int = ...
ELEMENT_FACTORY_TYPE_DECRYPTOR: int = ...
ELEMENT_FACTORY_TYPE_DEMUXER: int = ...
ELEMENT_FACTORY_TYPE_DEPAYLOADER: int = ...
ELEMENT_FACTORY_TYPE_ENCODER: int = ...
ELEMENT_FACTORY_TYPE_ENCRYPTOR: int = ...
ELEMENT_FACTORY_TYPE_FORMATTER: int = ...
ELEMENT_FACTORY_TYPE_HARDWARE: int = ...
ELEMENT_FACTORY_TYPE_MAX_ELEMENTS: int = ...
ELEMENT_FACTORY_TYPE_MEDIA_ANY: int = ...
ELEMENT_FACTORY_TYPE_MEDIA_AUDIO: int = ...
ELEMENT_FACTORY_TYPE_MEDIA_IMAGE: int = ...
ELEMENT_FACTORY_TYPE_MEDIA_METADATA: int = ...
ELEMENT_FACTORY_TYPE_MEDIA_SUBTITLE: int = ...
ELEMENT_FACTORY_TYPE_MEDIA_VIDEO: int = ...
ELEMENT_FACTORY_TYPE_MUXER: int = ...
ELEMENT_FACTORY_TYPE_PARSER: int = ...
ELEMENT_FACTORY_TYPE_PAYLOADER: int = ...
ELEMENT_FACTORY_TYPE_SINK: int = ...
ELEMENT_FACTORY_TYPE_SRC: int = ...
ELEMENT_FACTORY_TYPE_VIDEO_ENCODER: int = ...
ELEMENT_METADATA_AUTHOR: str = ...
ELEMENT_METADATA_DESCRIPTION: str = ...
ELEMENT_METADATA_DOC_URI: str = ...
ELEMENT_METADATA_ICON_NAME: str = ...
ELEMENT_METADATA_KLASS: str = ...
ELEMENT_METADATA_LONGNAME: str = ...
EVENT_NUM_SHIFT: int = ...
EVENT_TYPE_BOTH = ...
FLAG_SET_MASK_EXACT: int = ...
FORMAT_PERCENT_MAX: int = ...
FORMAT_PERCENT_SCALE: int = ...
GROUP_ID_INVALID = ...
LICENSE_UNKNOWN: str = ...
LOCK_FLAG_READWRITE = ...
MAP_READWRITE = ...
META_TAG_MEMORY_STR: str = ...
MSECOND: int = ...
NSECOND: int = ...
PARAM_CONDITIONALLY_AVAILABLE: int = ...
PARAM_CONTROLLABLE: int = ...
PARAM_DOC_SHOW_DEFAULT: int = ...
PARAM_MUTABLE_PAUSED: int = ...
PARAM_MUTABLE_PLAYING: int = ...
PARAM_MUTABLE_READY: int = ...
PARAM_USER_SHIFT: int = ...
PROTECTION_SYSTEM_ID_CAPS_FIELD: str = ...
PROTECTION_UNSPECIFIED_SYSTEM_ID: str = ...
QUERY_NUM_SHIFT: int = ...
QUERY_TYPE_BOTH = ...
SECOND: int = ...
SEGMENT_INSTANT_FLAGS: int = ...
SEQNUM_INVALID = ...
TAG_ALBUM: str = ...
TAG_ALBUM_ARTIST: str = ...
TAG_ALBUM_ARTIST_SORTNAME: str = ...
TAG_ALBUM_GAIN: str = ...
TAG_ALBUM_PEAK: str = ...
TAG_ALBUM_SORTNAME: str = ...
TAG_ALBUM_VOLUME_COUNT: str = ...
TAG_ALBUM_VOLUME_NUMBER: str = ...
TAG_APPLICATION_DATA: str = ...
TAG_APPLICATION_NAME: str = ...
TAG_ARTIST: str = ...
TAG_ARTIST_SORTNAME: str = ...
TAG_ATTACHMENT: str = ...
TAG_AUDIO_CODEC: str = ...
TAG_BEATS_PER_MINUTE: str = ...
TAG_BITRATE: str = ...
TAG_CODEC: str = ...
TAG_COMMENT: str = ...
TAG_COMPOSER: str = ...
TAG_COMPOSER_SORTNAME: str = ...
TAG_CONDUCTOR: str = ...
TAG_CONTACT: str = ...
TAG_CONTAINER_FORMAT: str = ...
TAG_COPYRIGHT: str = ...
TAG_COPYRIGHT_URI: str = ...
TAG_DATE: str = ...
TAG_DATE_TIME: str = ...
TAG_DESCRIPTION: str = ...
TAG_DEVICE_MANUFACTURER: str = ...
TAG_DEVICE_MODEL: str = ...
TAG_DURATION: str = ...
TAG_ENCODED_BY: str = ...
TAG_ENCODER: str = ...
TAG_ENCODER_VERSION: str = ...
TAG_EXTENDED_COMMENT: str = ...
TAG_GENRE: str = ...
TAG_GEO_LOCATION_CAPTURE_DIRECTION: str = ...
TAG_GEO_LOCATION_CITY: str = ...
TAG_GEO_LOCATION_COUNTRY: str = ...
TAG_GEO_LOCATION_ELEVATION: str = ...
TAG_GEO_LOCATION_HORIZONTAL_ERROR: str = ...
TAG_GEO_LOCATION_LATITUDE: str = ...
TAG_GEO_LOCATION_LONGITUDE: str = ...
TAG_GEO_LOCATION_MOVEMENT_DIRECTION: str = ...
TAG_GEO_LOCATION_MOVEMENT_SPEED: str = ...
TAG_GEO_LOCATION_NAME: str = ...
TAG_GEO_LOCATION_SUBLOCATION: str = ...
TAG_GROUPING: str = ...
TAG_HOMEPAGE: str = ...
TAG_IMAGE: str = ...
TAG_IMAGE_ORIENTATION: str = ...
TAG_INTERPRETED_BY: str = ...
TAG_ISRC: str = ...
TAG_KEYWORDS: str = ...
TAG_LANGUAGE_CODE: str = ...
TAG_LANGUAGE_NAME: str = ...
TAG_LICENSE: str = ...
TAG_LICENSE_URI: str = ...
TAG_LOCATION: str = ...
TAG_LYRICS: str = ...
TAG_MAXIMUM_BITRATE: str = ...
TAG_MIDI_BASE_NOTE: str = ...
TAG_MINIMUM_BITRATE: str = ...
TAG_NOMINAL_BITRATE: str = ...
TAG_ORGANIZATION: str = ...
TAG_PERFORMER: str = ...
TAG_PREVIEW_IMAGE: str = ...
TAG_PRIVATE_DATA: str = ...
TAG_PUBLISHER: str = ...
TAG_REFERENCE_LEVEL: str = ...
TAG_SERIAL: str = ...
TAG_SHOW_EPISODE_NUMBER: str = ...
TAG_SHOW_NAME: str = ...
TAG_SHOW_SEASON_NUMBER: str = ...
TAG_SHOW_SORTNAME: str = ...
TAG_SUBTITLE_CODEC: str = ...
TAG_TITLE: str = ...
TAG_TITLE_SORTNAME: str = ...
TAG_TRACK_COUNT: str = ...
TAG_TRACK_GAIN: str = ...
TAG_TRACK_NUMBER: str = ...
TAG_TRACK_PEAK: str = ...
TAG_USER_RATING: str = ...
TAG_VERSION: str = ...
TAG_VIDEO_CODEC: str = ...
TOC_REPEAT_COUNT_INFINITE: int = ...
URI_NO_PORT = ...
USECOND: int = ...
VALUE_EQUAL = ...
VALUE_GREATER_THAN: int = ...
VALUE_LESS_THAN: int = ...
VALUE_UNORDERED: int = ...
VERSION_MAJOR: int = ...
VERSION_MICRO: int = ...
VERSION_MINOR: int = ...
VERSION_NANO = ...
_namespace: str = ...
_version: str = ...

def buffer_get_max_memory(*args, **kwargs): ...
def caps_features_from_string(*args, **kwargs): ...
def caps_from_string(*args, **kwargs): ...
def core_error_quark(*args, **kwargs): ...
def debug_add_log_function(*args, **kwargs): ...
def debug_add_ring_buffer_logger(*args, **kwargs): ...
def debug_bin_to_dot_data(*args, **kwargs): ...
def debug_bin_to_dot_file(*args, **kwargs): ...
def debug_bin_to_dot_file_with_ts(*args, **kwargs): ...
def debug_construct_term_color(*args, **kwargs): ...
def debug_construct_win_color(*args, **kwargs): ...
def debug_get_all_categories(*args, **kwargs): ...
def debug_get_color_mode(*args, **kwargs): ...
def debug_get_default_threshold(*args, **kwargs): ...
def debug_get_stack_trace(*args, **kwargs): ...
def debug_is_active(*args, **kwargs): ...
def debug_is_colored(*args, **kwargs): ...
def debug_level_get_name(*args, **kwargs): ...
def debug_log_default(*args, **kwargs): ...
def debug_log_get_line(*args, **kwargs): ...
def debug_print_stack_trace(*args, **kwargs): ...
def debug_remove_log_function(*args, **kwargs): ...
def debug_remove_log_function_by_data(*args, **kwargs): ...
def debug_remove_ring_buffer_logger(*args, **kwargs): ...
def debug_ring_buffer_logger_get_logs(*args, **kwargs): ...
def debug_set_active(*args, **kwargs): ...
def debug_set_color_mode(*args, **kwargs): ...
def debug_set_color_mode_from_string(*args, **kwargs): ...
def debug_set_colored(*args, **kwargs): ...
def debug_set_default_threshold(*args, **kwargs): ...
def debug_set_threshold_for_name(*args, **kwargs): ...
def debug_set_threshold_from_string(*args, **kwargs): ...
def debug_unset_threshold_for_name(*args, **kwargs): ...
def deinit(*args, **kwargs): ...
def dynamic_type_register(*args, **kwargs): ...
def error_get_message(*args, **kwargs): ...
def event_type_get_flags(*args, **kwargs): ...
def event_type_get_name(*args, **kwargs): ...
def event_type_to_quark(*args, **kwargs): ...
def filename_to_uri(*args, **kwargs): ...
def flow_get_name(*args, **kwargs): ...
def flow_to_quark(*args, **kwargs): ...
def format_get_by_nick(*args, **kwargs): ...
def format_get_details(*args, **kwargs): ...
def format_get_name(*args, **kwargs): ...
def format_iterate_definitions(*args, **kwargs): ...
def format_register(*args, **kwargs): ...
def format_to_quark(*args, **kwargs): ...
def formats_contains(*args, **kwargs): ...
def get_main_executable_path(*args, **kwargs): ...
def init(self, argv: Optional[list[str]]) -> list[str]: ...
def init_check(self, argv: Optional[list[str]] = None) -> tuple[bool, list[str]]: ...
def is_caps_features(*args, **kwargs): ...
def is_initialized(*args, **kwargs): ...
def library_error_quark(*args, **kwargs): ...
def message_type_get_name(*args, **kwargs): ...
def message_type_to_quark(*args, **kwargs): ...
def meta_api_type_get_tags(*args, **kwargs): ...
def meta_api_type_has_tag(*args, **kwargs): ...
def meta_api_type_register(*args, **kwargs): ...
def meta_get_info(*args, **kwargs): ...
def meta_register(*args, **kwargs): ...
def mini_object_replace(*args, **kwargs): ...
def mini_object_take(*args, **kwargs): ...
def pad_mode_get_name(*args, **kwargs): ...
def param_spec_array(*args, **kwargs): ...
def param_spec_fraction(*args, **kwargs): ...
def parent_buffer_meta_api_get_type(*args, **kwargs): ...
def parent_buffer_meta_get_info(*args, **kwargs): ...
def parse_bin_from_description(bin_description: str, ghost_unlinked_pads: bool) -> Optional[Bin]: ...
def parse_bin_from_description_full(*args, **kwargs): ...
def parse_error_quark(*args, **kwargs): ...
def parse_launch(*args, **kwargs): ...
def parse_launch_full(*args, **kwargs): ...
def parse_launchv(*args, **kwargs): ...
def parse_launchv_full(*args, **kwargs): ...
def plugin_error_quark(*args, **kwargs): ...
def preset_get_app_dir(*args, **kwargs): ...
def preset_set_app_dir(*args, **kwargs): ...
def protection_filter_systems_by_available_decryptors(*args, **kwargs): ...
def protection_meta_api_get_type(*args, **kwargs): ...
def protection_meta_get_info(*args, **kwargs): ...
def protection_select_system(*args, **kwargs): ...
def query_type_get_flags(*args, **kwargs): ...
def query_type_get_name(*args, **kwargs): ...
def query_type_to_quark(*args, **kwargs): ...
def reference_timestamp_meta_api_get_type(*args, **kwargs): ...
def reference_timestamp_meta_get_info(*args, **kwargs): ...
def resource_error_quark(*args, **kwargs): ...
def segtrap_is_enabled(*args, **kwargs): ...
def segtrap_set_enabled(*args, **kwargs): ...
def state_change_get_name(*args, **kwargs): ...
def static_caps_get_type(*args, **kwargs): ...
def static_pad_template_get_type(*args, **kwargs): ...
def stream_error_quark(*args, **kwargs): ...
def stream_type_get_name(*args, **kwargs): ...
def structure_take(*args, **kwargs): ...
def tag_exists(*args, **kwargs): ...
def tag_get_description(*args, **kwargs): ...
def tag_get_flag(*args, **kwargs): ...
def tag_get_nick(*args, **kwargs): ...
def tag_get_type(*args, **kwargs): ...
def tag_is_fixed(*args, **kwargs): ...
def tag_list_copy_value(*args, **kwargs): ...
def tag_merge_strings_with_comma(*args, **kwargs): ...
def tag_merge_use_first(*args, **kwargs): ...
def toc_entry_type_get_nick(*args, **kwargs): ...
def tracing_get_active_tracers(*args, **kwargs): ...
def tracing_register_hook(*args, **kwargs): ...
def type_find_get_type(*args, **kwargs): ...
def type_find_register(*args, **kwargs): ...
def type_is_plugin_api(*args, **kwargs): ...
def type_mark_as_plugin_api(*args, **kwargs): ...
def update_registry(*args, **kwargs): ...
def uri_construct(*args, **kwargs): ...
def uri_error_quark(*args, **kwargs): ...
def uri_from_string(*args, **kwargs): ...
def uri_from_string_escaped(*args, **kwargs): ...
def uri_get_location(*args, **kwargs): ...
def uri_get_protocol(*args, **kwargs): ...
def uri_has_protocol(*args, **kwargs): ...
def uri_is_valid(*args, **kwargs): ...
def uri_join_strings(*args, **kwargs): ...
def uri_protocol_is_supported(*args, **kwargs): ...
def uri_protocol_is_valid(*args, **kwargs): ...
def util_array_binary_search(*args, **kwargs): ...
def util_double_to_fraction(*args, **kwargs): ...
def util_dump_buffer(*args, **kwargs): ...
def util_dump_mem(*args, **kwargs): ...
def util_fraction_add(*args, **kwargs): ...
def util_fraction_compare(*args, **kwargs): ...
def util_fraction_multiply(*args, **kwargs): ...
def util_fraction_to_double(*args, **kwargs): ...
def util_gdouble_to_guint64(*args, **kwargs): ...
def util_get_object_array(*args, **kwargs): ...
def util_get_timestamp(*args, **kwargs): ...
def util_greatest_common_divisor(*args, **kwargs): ...
def util_greatest_common_divisor_int64(*args, **kwargs): ...
def util_group_id_next(*args, **kwargs): ...
def util_guint64_to_gdouble(*args, **kwargs): ...
def util_seqnum_compare(*args, **kwargs): ...
def util_seqnum_next(*args, **kwargs): ...
def util_set_object_arg(*args, **kwargs): ...
def util_set_object_array(*args, **kwargs): ...
def util_set_value_from_string(*args, **kwargs): ...
def util_uint64_scale(*args, **kwargs): ...
def util_uint64_scale_ceil(*args, **kwargs): ...
def util_uint64_scale_int(*args, **kwargs): ...
def util_uint64_scale_int_ceil(*args, **kwargs): ...
def util_uint64_scale_int_round(*args, **kwargs): ...
def util_uint64_scale_round(*args, **kwargs): ...
def value_can_compare(*args, **kwargs): ...
def value_can_intersect(*args, **kwargs): ...
def value_can_subtract(*args, **kwargs): ...
def value_can_union(*args, **kwargs): ...
def value_compare(*args, **kwargs): ...
def value_deserialize(*args, **kwargs): ...
def value_fixate(*args, **kwargs): ...
def value_fraction_multiply(*args, **kwargs): ...
def value_fraction_subtract(*args, **kwargs): ...
def value_get_bitmask(*args, **kwargs): ...
def value_get_caps(*args, **kwargs): ...
def value_get_caps_features(*args, **kwargs): ...
def value_get_double_range_max(*args, **kwargs): ...
def value_get_double_range_min(*args, **kwargs): ...
def value_get_flagset_flags(*args, **kwargs): ...
def value_get_flagset_mask(*args, **kwargs): ...
def value_get_fraction_denominator(*args, **kwargs): ...
def value_get_fraction_numerator(*args, **kwargs): ...
def value_get_fraction_range_max(*args, **kwargs): ...
def value_get_fraction_range_min(*args, **kwargs): ...
def value_get_int64_range_max(*args, **kwargs): ...
def value_get_int64_range_min(*args, **kwargs): ...
def value_get_int64_range_step(*args, **kwargs): ...
def value_get_int_range_max(*args, **kwargs): ...
def value_get_int_range_min(*args, **kwargs): ...
def value_get_int_range_step(*args, **kwargs): ...
def value_get_structure(*args, **kwargs): ...
def value_init_and_copy(*args, **kwargs): ...
def value_intersect(*args, **kwargs): ...
def value_is_fixed(*args, **kwargs): ...
def value_is_subset(*args, **kwargs): ...
def value_register(*args, **kwargs): ...
def value_serialize(*args, **kwargs): ...
def value_set_bitmask(*args, **kwargs): ...
def value_set_caps(*args, **kwargs): ...
def value_set_caps_features(*args, **kwargs): ...
def value_set_double_range(*args, **kwargs): ...
def value_set_flagset(*args, **kwargs): ...
def value_set_fraction(*args, **kwargs): ...
def value_set_fraction_range(*args, **kwargs): ...
def value_set_fraction_range_full(*args, **kwargs): ...
def value_set_int64_range(*args, **kwargs): ...
def value_set_int64_range_step(*args, **kwargs): ...
def value_set_int_range(*args, **kwargs): ...
def value_set_int_range_step(*args, **kwargs): ...
def value_set_structure(*args, **kwargs): ...
def value_subtract(*args, **kwargs): ...
def value_union(*args, **kwargs): ...
def version(*args, **kwargs): ...
def version_string(*args, **kwargs): ...

class AllocationParams:
    _gst_reserved = ...
    align = ...
    flags = ...
    padding = ...
    prefix = ...
    
    def free(*args, **kwargs): ...
    def init(*args, **kwargs): ...
    

class Allocator:
    mem_copy = ...
    mem_is_span = ...
    mem_map = ...
    mem_map_full = ...
    mem_share = ...
    mem_type = ...
    mem_unmap = ...
    mem_unmap_full = ...
    priv = ...
    
    def alloc(*args, **kwargs): ...
    def find(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def register(*args, **kwargs): ...
    def set_default(*args, **kwargs): ...
    
    def do_alloc(self, *args, **kwargs): ...
    def do_free(self, *args, **kwargs): ...
    

class AtomicQueue:
    def length(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def peek(*args, **kwargs): ...
    def pop(*args, **kwargs): ...
    def push(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...


class Bin(ChildProxy, Element):
    child_bus = ...
    children = ...
    children_cookie = ...
    clock_dirty = ...
    clock_provider = ...
    element = ...
    messages = ...
    numchildren = ...
    polling = ...
    priv = ...
    provided_clock = ...
    state_dirty = ...
    
    def add(self, element: Element) -> bool: ...
    def find_unlinked_pad(*args, **kwargs): ...
    def get_by_interface(*args, **kwargs): ...
    def get_by_name(*args, **kwargs): ...
    def get_by_name_recurse_up(*args, **kwargs): ...
    def get_suppressed_flags(*args, **kwargs): ...
    def iterate_all_by_element_factory_name(*args, **kwargs): ...
    def iterate_all_by_interface(*args, **kwargs): ...
    def iterate_elements(*args, **kwargs): ...
    def iterate_recurse(*args, **kwargs): ...
    def iterate_sinks(*args, **kwargs): ...
    def iterate_sorted(*args, **kwargs): ...
    def iterate_sources(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def recalculate_latency(*args, **kwargs): ...
    def remove(self, element: Element) -> bool: ...
    def set_suppressed_flags(*args, **kwargs): ...
    def sync_children_states(*args, **kwargs): ...
    
    def do_add_element(self, *args, **kwargs): ...
    def do_deep_element_added(self, *args, **kwargs): ...
    def do_deep_element_removed(self, *args, **kwargs): ...
    def do_do_latency(self, *args, **kwargs): ...
    def do_element_added(self, *args, **kwargs): ...
    def do_element_removed(self, *args, **kwargs): ...
    def do_handle_message(self, *args, **kwargs): ...
    def do_remove_element(self, *args, **kwargs): ...
    

class Bitmask: ...

class Buffer:
    dts = ...
    duration = ...
    mini_object = ...
    offset = ...
    offset_end = ...
    pool = ...
    pts = ...
    
    def add_meta(*args, **kwargs): ...
    def add_parent_buffer_meta(*args, **kwargs): ...
    def add_protection_meta(*args, **kwargs): ...
    def add_reference_timestamp_meta(*args, **kwargs): ...
    def append(*args, **kwargs): ...
    def append_memory(*args, **kwargs): ...
    def append_region(*args, **kwargs): ...
    def copy_deep(*args, **kwargs): ...
    def copy_into(*args, **kwargs): ...
    def copy_region(*args, **kwargs): ...
    def extract(*args, **kwargs): ...
    def extract_dup(*args, **kwargs): ...
    def fill(*args, **kwargs): ...
    def find_memory(*args, **kwargs): ...
    def foreach_meta(*args, **kwargs): ...
    def get_all_memory(*args, **kwargs): ...
    def get_flags(*args, **kwargs): ...
    def get_max_memory(*args, **kwargs): ...
    def get_memory(*args, **kwargs): ...
    def get_memory_range(*args, **kwargs): ...
    def get_meta(*args, **kwargs): ...
    def get_n_meta(*args, **kwargs): ...
    def get_reference_timestamp_meta(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_sizes(*args, **kwargs): ...
    def get_sizes_range(*args, **kwargs): ...
    def has_flags(*args, **kwargs): ...
    def insert_memory(*args, **kwargs): ...
    def is_all_memory_writable(*args, **kwargs): ...
    def is_memory_range_writable(*args, **kwargs): ...
    def map(*args, **kwargs): ...
    def map_range(*args, **kwargs): ...
    def memcmp(*args, **kwargs): ...
    def memset(*args, **kwargs): ...
    def n_memory(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_allocate(*args, **kwargs): ...
    def new_wrapped(*args, **kwargs): ...
    def new_wrapped_bytes(*args, **kwargs): ...
    def new_wrapped_full(*args, **kwargs): ...
    def peek_memory(*args, **kwargs): ...
    def prepend_memory(*args, **kwargs): ...
    def remove_all_memory(*args, **kwargs): ...
    def remove_memory(*args, **kwargs): ...
    def remove_memory_range(*args, **kwargs): ...
    def remove_meta(*args, **kwargs): ...
    def replace_all_memory(*args, **kwargs): ...
    def replace_memory(*args, **kwargs): ...
    def replace_memory_range(*args, **kwargs): ...
    def resize(*args, **kwargs): ...
    def resize_range(*args, **kwargs): ...
    def set_flags(*args, **kwargs): ...
    def set_size(*args, **kwargs): ...
    def unmap(*args, **kwargs): ...
    def unset_flags(*args, **kwargs): ...
    

class BufferList:
    def calculate_size(*args, **kwargs): ...
    def copy_deep(*args, **kwargs): ...
    def foreach(*args, **kwargs): ...
    def get(*args, **kwargs): ...
    def get_writable(*args, **kwargs): ...
    def insert(*args, **kwargs): ...
    def length(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_sized(*args, **kwargs): ...
    def remove(*args, **kwargs): ...
    

class BufferPool:
    flushing = ...
    priv = ...
    
    def acquire_buffer(*args, **kwargs): ...
    def config_add_option(*args, **kwargs): ...
    def config_get_allocator(*args, **kwargs): ...
    def config_get_option(*args, **kwargs): ...
    def config_get_params(*args, **kwargs): ...
    def config_has_option(*args, **kwargs): ...
    def config_n_options(*args, **kwargs): ...
    def config_set_allocator(*args, **kwargs): ...
    def config_set_params(*args, **kwargs): ...
    def config_validate_params(*args, **kwargs): ...
    def get_config(*args, **kwargs): ...
    def get_options(*args, **kwargs): ...
    def has_option(*args, **kwargs): ...
    def is_active(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def release_buffer(*args, **kwargs): ...
    def set_active(*args, **kwargs): ...
    def set_config(*args, **kwargs): ...
    def set_flushing(*args, **kwargs): ...
    
    def do_acquire_buffer(self, *args, **kwargs): ...
    def do_alloc_buffer(self, *args, **kwargs): ...
    def do_flush_start(self, *args, **kwargs): ...
    def do_flush_stop(self, *args, **kwargs): ...
    def do_free_buffer(self, *args, **kwargs): ...
    def do_get_options(self, *args, **kwargs): ...
    def do_release_buffer(self, *args, **kwargs): ...
    def do_reset_buffer(self, *args, **kwargs): ...
    def do_set_config(self, *args, **kwargs): ...
    def do_start(self, *args, **kwargs): ...
    def do_stop(self, *args, **kwargs): ...
    

class BufferPoolAcquireParams:
    _gst_reserved = ...
    flags = ...
    format = ...
    start = ...
    stop = ...
    

class Bus(Object):
    priv = ...
    
    def add_signal_watch(self) -> None: ...
    def add_signal_watch_full(*args, **kwargs): ...
    def add_watch(*args, **kwargs): ...
    def async_signal_func(*args, **kwargs): ...
    def create_watch(*args, **kwargs): ...
    def disable_sync_message_emission(*args, **kwargs): ...
    def enable_sync_message_emission(*args, **kwargs): ...
    def get_pollfd(*args, **kwargs): ...
    def have_pending(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def peek(*args, **kwargs): ...
    def poll(*args, **kwargs): ...
    def pop(*args, **kwargs): ...
    def pop_filtered(*args, **kwargs): ...
    def post(*args, **kwargs): ...
    def remove_signal_watch(*args, **kwargs): ...
    def remove_watch(*args, **kwargs): ...
    def set_flushing(*args, **kwargs): ...
    def set_sync_handler(*args, **kwargs): ...
    def sync_signal_handler(*args, **kwargs): ...
    def timed_pop(*args, **kwargs): ...
    def timed_pop_filtered(*args, **kwargs): ...
    
    def do_message(self, *args, **kwargs): ...
    def do_sync_message(self, *args, **kwargs): ...
    

class Caps:
    mini_object = ...
    
    def append(*args, **kwargs): ...
    def append_structure(*args, **kwargs): ...
    def append_structure_full(*args, **kwargs): ...
    def can_intersect(*args, **kwargs): ...
    def copy_nth(*args, **kwargs): ...
    def filter_and_map_in_place(*args, **kwargs): ...
    def fixate(*args, **kwargs): ...
    def foreach(*args, **kwargs): ...
    def from_string(*args, **kwargs): ...
    def get_features(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_structure(*args, **kwargs): ...
    def intersect(*args, **kwargs): ...
    def intersect_full(*args, **kwargs): ...
    def is_always_compatible(*args, **kwargs): ...
    def is_any(*args, **kwargs): ...
    def is_empty(*args, **kwargs): ...
    def is_equal(*args, **kwargs): ...
    def is_equal_fixed(*args, **kwargs): ...
    def is_fixed(*args, **kwargs): ...
    def is_strictly_equal(*args, **kwargs): ...
    def is_subset(*args, **kwargs): ...
    def is_subset_structure(*args, **kwargs): ...
    def is_subset_structure_full(*args, **kwargs): ...
    def map_in_place(*args, **kwargs): ...
    def merge(*args, **kwargs): ...
    def merge_structure(*args, **kwargs): ...
    def merge_structure_full(*args, **kwargs): ...
    def new_any(*args, **kwargs): ...
    def new_empty(*args, **kwargs): ...
    def new_empty_simple(*args, **kwargs): ...
    def normalize(*args, **kwargs): ...
    def remove_structure(*args, **kwargs): ...
    def set_features(*args, **kwargs): ...
    def set_features_simple(*args, **kwargs): ...
    def set_value(*args, **kwargs): ...
    def simplify(*args, **kwargs): ...
    def steal_structure(*args, **kwargs): ...
    def subtract(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    def truncate(*args, **kwargs): ...
    

class CapsFeatures:
    def add(*args, **kwargs): ...
    def add_id(*args, **kwargs): ...
    def contains(*args, **kwargs): ...
    def contains_id(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def from_string(*args, **kwargs): ...
    def get_nth(*args, **kwargs): ...
    def get_nth_id(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def is_any(*args, **kwargs): ...
    def is_equal(*args, **kwargs): ...
    def new_any(*args, **kwargs): ...
    def new_empty(*args, **kwargs): ...
    def remove(*args, **kwargs): ...
    def remove_id(*args, **kwargs): ...
    def set_parent_refcount(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    

class ChildProxy(GObject.GInterface):
    def child_added(*args, **kwargs): ...
    def child_removed(*args, **kwargs): ...
    def get_child_by_index(*args, **kwargs): ...
    def get_child_by_name(*args, **kwargs): ...
    def get_children_count(*args, **kwargs): ...
    def get_property(*args, **kwargs): ...
    def lookup(*args, **kwargs): ...
    def set_property(*args, **kwargs): ...
    

class ChildProxyInterface:
    _gst_reserved = ...
    child_added = ...
    child_removed = ...
    get_child_by_index = ...
    get_child_by_name = ...
    get_children_count = ...
    parent = ...
    

class Clock:
    priv = ...
    
    def add_observation(*args, **kwargs): ...
    def add_observation_unapplied(*args, **kwargs): ...
    def adjust_unlocked(*args, **kwargs): ...
    def adjust_with_calibration(*args, **kwargs): ...
    def get_calibration(*args, **kwargs): ...
    def get_internal_time(*args, **kwargs): ...
    def get_master(*args, **kwargs): ...
    def get_resolution(*args, **kwargs): ...
    def get_time(*args, **kwargs): ...
    def get_timeout(*args, **kwargs): ...
    def id_compare_func(*args, **kwargs): ...
    def id_get_clock(*args, **kwargs): ...
    def id_get_time(*args, **kwargs): ...
    def id_ref(*args, **kwargs): ...
    def id_unref(*args, **kwargs): ...
    def id_unschedule(*args, **kwargs): ...
    def id_uses_clock(*args, **kwargs): ...
    def id_wait(*args, **kwargs): ...
    def id_wait_async(*args, **kwargs): ...
    def is_synced(*args, **kwargs): ...
    def new_periodic_id(*args, **kwargs): ...
    def new_single_shot_id(*args, **kwargs): ...
    def periodic_id_reinit(*args, **kwargs): ...
    def set_calibration(*args, **kwargs): ...
    def set_master(*args, **kwargs): ...
    def set_resolution(*args, **kwargs): ...
    def set_synced(*args, **kwargs): ...
    def set_timeout(*args, **kwargs): ...
    def single_shot_id_reinit(*args, **kwargs): ...
    def unadjust_unlocked(*args, **kwargs): ...
    def unadjust_with_calibration(*args, **kwargs): ...
    def wait_for_sync(*args, **kwargs): ...
    
    def do_change_resolution(self, *args, **kwargs): ...
    def do_get_internal_time(self, *args, **kwargs): ...
    def do_get_resolution(self, *args, **kwargs): ...
    def do_unschedule(self, *args, **kwargs): ...
    def do_wait(self, *args, **kwargs): ...
    def do_wait_async(self, *args, **kwargs): ...
    

class ClockEntry:
    _gst_reserved = ...
    clock = ...
    destroy_data = ...
    func = ...
    interval = ...
    refcount = ...
    status = ...
    time = ...
    type = ...
    unscheduled = ...
    user_data = ...
    woken_up = ...
    

class Context:
    def get_context_type(*args, **kwargs): ...
    def get_structure(*args, **kwargs): ...
    def has_context_type(*args, **kwargs): ...
    def is_persistent(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def writable_structure(*args, **kwargs): ...
    

class ControlBinding:
    disabled = ...
    pspec = ...
    
    def is_disabled(*args, **kwargs): ...
    def set_disabled(*args, **kwargs): ...
    
    def do_get_g_value_array(self, *args, **kwargs): ...
    def do_get_value(self, *args, **kwargs): ...
    def do_sync_values(self, *args, **kwargs): ...
    

class ControlSource:
    get_value_array = ...
    
    def control_source_get_value(*args, **kwargs): ...
    def control_source_get_value_array(*args, **kwargs): ...
    

class DateTime:
    def get_day(*args, **kwargs): ...
    def get_hour(*args, **kwargs): ...
    def get_microsecond(*args, **kwargs): ...
    def get_minute(*args, **kwargs): ...
    def get_month(*args, **kwargs): ...
    def get_second(*args, **kwargs): ...
    def get_time_zone_offset(*args, **kwargs): ...
    def get_year(*args, **kwargs): ...
    def has_day(*args, **kwargs): ...
    def has_month(*args, **kwargs): ...
    def has_second(*args, **kwargs): ...
    def has_time(*args, **kwargs): ...
    def has_year(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_g_date_time(*args, **kwargs): ...
    def new_from_iso8601_string(*args, **kwargs): ...
    def new_from_unix_epoch_local_time(*args, **kwargs): ...
    def new_from_unix_epoch_local_time_usecs(*args, **kwargs): ...
    def new_from_unix_epoch_utc(*args, **kwargs): ...
    def new_from_unix_epoch_utc_usecs(*args, **kwargs): ...
    def new_local_time(*args, **kwargs): ...
    def new_now_local_time(*args, **kwargs): ...
    def new_now_utc(*args, **kwargs): ...
    def new_y(*args, **kwargs): ...
    def new_ym(*args, **kwargs): ...
    def new_ymd(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def to_g_date_time(*args, **kwargs): ...
    def to_iso8601_string(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class DebugCategory:
    color = ...
    description = ...
    name = ...
    threshold = ...
    
    def free(*args, **kwargs): ...
    def get_color(*args, **kwargs): ...
    def get_description(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_threshold(*args, **kwargs): ...
    def reset_threshold(*args, **kwargs): ...
    def set_threshold(*args, **kwargs): ...
    

class DebugMessage:
    def get(*args, **kwargs): ...
    

class Device:
    priv = ...
    
    def create_element(*args, **kwargs): ...
    def get_caps(*args, **kwargs): ...
    def get_device_class(*args, **kwargs): ...
    def get_display_name(*args, **kwargs): ...
    def has_classes(*args, **kwargs): ...
    def has_classesv(*args, **kwargs): ...
    def reconfigure_element(*args, **kwargs): ...
    
    def do_create_element(self, *args, **kwargs): ...
    def do_reconfigure_element(self, *args, **kwargs): ...
    

class DeviceMonitor:
    priv = ...
    
    def add_filter(*args, **kwargs): ...
    def get_bus(*args, **kwargs): ...
    def get_devices(*args, **kwargs): ...
    def get_providers(*args, **kwargs): ...
    def get_show_all_devices(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def remove_filter(*args, **kwargs): ...
    def set_show_all_devices(*args, **kwargs): ...
    def start(*args, **kwargs): ...
    def stop(*args, **kwargs): ...
    

class DeviceProvider:
    devices = ...
    priv = ...
    
    def add_metadata(*args, **kwargs): ...
    def add_static_metadata(*args, **kwargs): ...
    def can_monitor(*args, **kwargs): ...
    def device_add(*args, **kwargs): ...
    def device_changed(*args, **kwargs): ...
    def device_remove(*args, **kwargs): ...
    def get_bus(*args, **kwargs): ...
    def get_devices(*args, **kwargs): ...
    def get_factory(*args, **kwargs): ...
    def get_hidden_providers(*args, **kwargs): ...
    def get_metadata(*args, **kwargs): ...
    def hide_provider(*args, **kwargs): ...
    def register(*args, **kwargs): ...
    def set_metadata(*args, **kwargs): ...
    def set_static_metadata(*args, **kwargs): ...
    def start(*args, **kwargs): ...
    def stop(*args, **kwargs): ...
    def unhide_provider(*args, **kwargs): ...
    
    def do_start(self, *args, **kwargs): ...
    def do_stop(self, *args, **kwargs): ...
    

class DeviceProviderFactory:
    def find(*args, **kwargs): ...
    def get(*args, **kwargs): ...
    def get_by_name(*args, **kwargs): ...
    def get_device_provider_type(*args, **kwargs): ...
    def get_metadata(*args, **kwargs): ...
    def get_metadata_keys(*args, **kwargs): ...
    def has_classes(*args, **kwargs): ...
    def has_classesv(*args, **kwargs): ...
    def list_get_device_providers(*args, **kwargs): ...
    

class DoubleRange: ...

class DynamicTypeFactory: ...

class Element(Object):
    base_time: int = ...
    bus: Bus = ...
    clock: Clock = ...
    contexts: list[Context] = ...
    current_state: State = ...
    last_return: StateChangeReturn = ...
    next_state: State = ...
    numpads: int = ...
    numsinkpads: int = ...
    numsrcpads: int = ...
    pads: list[Pad] = ...
    pads_cookie: int = ...
    pending_state: State = ...
    sinkpads: Pad = ...
    srcpads: Pad = ...
    start_time: int = ...
    state_cond: GLib.Cond = ...
    state_cookie: int = ...
    state_lock: GLib.RecMutex = ...
    target_state: State = ...


    def abort_state(*args, **kwargs): ...
    def add_metadata(*args, **kwargs): ...
    def add_pad(*args, **kwargs): ...
    def add_pad_template(*args, **kwargs): ...
    def add_property_deep_notify_watch(*args, **kwargs): ...
    def add_property_notify_watch(*args, **kwargs): ...
    def add_static_metadata(*args, **kwargs): ...
    def add_static_pad_template(*args, **kwargs): ...
    def add_static_pad_template_with_gtype(*args, **kwargs): ...
    def call_async(*args, **kwargs): ...
    def change_state(*args, **kwargs): ...
    def continue_state(*args, **kwargs): ...
    def create_all_pads(*args, **kwargs): ...
    def foreach_pad(*args, **kwargs): ...
    def foreach_sink_pad(*args, **kwargs): ...
    def foreach_src_pad(*args, **kwargs): ...
    def get_base_time(*args, **kwargs): ...
    def get_bus(self) -> Optional[Bus]: ...
    def get_clock(*args, **kwargs): ...
    def get_compatible_pad(*args, **kwargs): ...
    def get_compatible_pad_template(*args, **kwargs): ...
    def get_context(*args, **kwargs): ...
    def get_context_unlocked(*args, **kwargs): ...
    def get_contexts(*args, **kwargs): ...
    def get_current_clock_time(*args, **kwargs): ...
    def get_current_running_time(*args, **kwargs): ...
    def get_factory(*args, **kwargs): ...
    def get_metadata(*args, **kwargs): ...
    def get_pad_template(*args, **kwargs): ...
    def get_pad_template_list(*args, **kwargs): ...
    def get_request_pad(*args, **kwargs): ...
    def get_start_time(*args, **kwargs): ...
    def get_state(self, timeout: int) -> Tuple[StateChangeReturn, State, State]: ...
    def get_static_pad(*args, **kwargs): ...
    def is_locked_state(*args, **kwargs): ...
    def iterate_pads(*args, **kwargs): ...
    def iterate_sink_pads(*args, **kwargs): ...
    def iterate_src_pads(*args, **kwargs): ...
    def link(self, dest: Element) -> bool: ...
    def link_filtered(*args, **kwargs): ...
    def link_pads(*args, **kwargs): ...
    def link_pads_filtered(*args, **kwargs): ...
    def link_pads_full(*args, **kwargs): ...
    def lost_state(*args, **kwargs): ...
    def make_from_uri(*args, **kwargs): ...
    def message_full(*args, **kwargs): ...
    def message_full_with_details(*args, **kwargs): ...
    def no_more_pads(*args, **kwargs): ...
    def post_message(*args, **kwargs): ...
    def provide_clock(*args, **kwargs): ...
    def query(self, query: Query) -> bool: ...
    def query_convert(*args, **kwargs): ...
    def query_duration(self, format: Format) -> Tuple[bool, Optional[int]]: ...
    def query_position(*args, **kwargs): ...
    def register(*args, **kwargs): ...
    def release_request_pad(*args, **kwargs): ...
    def remove_pad(*args, **kwargs): ...
    def remove_property_notify_watch(*args, **kwargs): ...
    def request_pad(*args, **kwargs): ...
    def seek(*args, **kwargs): ...
    def seek_simple(self, format: Format, seek_flags: SeekFlags, seek_pos: int) -> bool: ...
    def send_event(*args, **kwargs): ...
    def set_base_time(*args, **kwargs): ...
    def set_bus(*args, **kwargs): ...
    def set_clock(*args, **kwargs): ...
    def set_context(*args, **kwargs): ...
    def set_locked_state(*args, **kwargs): ...
    def set_metadata(*args, **kwargs): ...
    def set_start_time(*args, **kwargs): ...
    def set_state(self, state: State) -> StateChangeReturn: ...
    def set_static_metadata(*args, **kwargs): ...
    def state_change_return_get_name(*args, **kwargs): ...
    def state_get_name(*args, **kwargs): ...
    def sync_state_with_parent(*args, **kwargs): ...
    def unlink(*args, **kwargs): ...
    def unlink_pads(*args, **kwargs): ...
    
    def do_change_state(self, *args, **kwargs): ...
    def do_get_state(self, *args, **kwargs): ...
    def do_no_more_pads(self, *args, **kwargs): ...
    def do_pad_added(self, *args, **kwargs): ...
    def do_pad_removed(self, *args, **kwargs): ...
    def do_post_message(self, *args, **kwargs): ...
    def do_provide_clock(self, *args, **kwargs): ...
    def do_query(self, *args, **kwargs): ...
    def do_release_pad(self, *args, **kwargs): ...
    def do_request_new_pad(self, *args, **kwargs): ...
    def do_send_event(self, *args, **kwargs): ...
    def do_set_bus(self, *args, **kwargs): ...
    def do_set_clock(self, *args, **kwargs): ...
    def do_set_context(self, *args, **kwargs): ...
    def do_set_state(self, *args, **kwargs): ...
    def do_state_changed(self, *args, **kwargs): ...


class ElementFactory(PluginFeature):
    def can_sink_all_caps(*args, **kwargs): ...
    def can_sink_any_caps(*args, **kwargs): ...
    def can_src_all_caps(*args, **kwargs): ...
    def can_src_any_caps(*args, **kwargs): ...
    def create(*args, **kwargs): ...
    @classmethod
    def find(cls, name: str) -> Optional[ElementFactory]: ...
    def get_element_type(*args, **kwargs): ...
    def get_metadata(*args, **kwargs): ...
    def get_metadata_keys(*args, **kwargs): ...
    def get_num_pad_templates(*args, **kwargs): ...
    def get_static_pad_templates(*args, **kwargs): ...
    def get_uri_protocols(*args, **kwargs): ...
    def get_uri_type(*args, **kwargs): ...
    def has_interface(*args, **kwargs): ...
    def list_filter(*args, **kwargs): ...
    def list_get_elements(*args, **kwargs): ...
    def list_is_type(*args, **kwargs): ...
    @classmethod
    def make(cls, factoryname: str, name: Optional[str]) -> Optional[Element]: ...
    

class Event:
    mini_object = ...
    seqnum = ...
    timestamp = ...
    type = ...
    
    def copy_segment(*args, **kwargs): ...
    def get_running_time_offset(*args, **kwargs): ...
    def get_seqnum(*args, **kwargs): ...
    def get_structure(*args, **kwargs): ...
    def has_name(*args, **kwargs): ...
    def has_name_id(*args, **kwargs): ...
    def new_buffer_size(*args, **kwargs): ...
    def new_caps(*args, **kwargs): ...
    def new_custom(*args, **kwargs): ...
    def new_eos(*args, **kwargs): ...
    def new_flush_start(*args, **kwargs): ...
    def new_flush_stop(*args, **kwargs): ...
    def new_gap(*args, **kwargs): ...
    def new_instant_rate_change(*args, **kwargs): ...
    def new_instant_rate_sync_time(*args, **kwargs): ...
    def new_latency(*args, **kwargs): ...
    def new_navigation(*args, **kwargs): ...
    def new_protection(*args, **kwargs): ...
    def new_qos(*args, **kwargs): ...
    def new_reconfigure(*args, **kwargs): ...
    def new_seek(*args, **kwargs): ...
    def new_segment(*args, **kwargs): ...
    def new_segment_done(*args, **kwargs): ...
    def new_select_streams(*args, **kwargs): ...
    def new_sink_message(*args, **kwargs): ...
    def new_step(*args, **kwargs): ...
    def new_stream_collection(*args, **kwargs): ...
    def new_stream_group_done(*args, **kwargs): ...
    def new_stream_start(*args, **kwargs): ...
    def new_tag(*args, **kwargs): ...
    def new_toc(*args, **kwargs): ...
    def new_toc_select(*args, **kwargs): ...
    def parse_buffer_size(*args, **kwargs): ...
    def parse_caps(*args, **kwargs): ...
    def parse_flush_stop(*args, **kwargs): ...
    def parse_gap(*args, **kwargs): ...
    def parse_group_id(*args, **kwargs): ...
    def parse_instant_rate_change(*args, **kwargs): ...
    def parse_instant_rate_sync_time(*args, **kwargs): ...
    def parse_latency(*args, **kwargs): ...
    def parse_protection(*args, **kwargs): ...
    def parse_qos(*args, **kwargs): ...
    def parse_seek(*args, **kwargs): ...
    def parse_seek_trickmode_interval(*args, **kwargs): ...
    def parse_segment(*args, **kwargs): ...
    def parse_segment_done(*args, **kwargs): ...
    def parse_select_streams(*args, **kwargs): ...
    def parse_sink_message(*args, **kwargs): ...
    def parse_step(*args, **kwargs): ...
    def parse_stream(*args, **kwargs): ...
    def parse_stream_collection(*args, **kwargs): ...
    def parse_stream_flags(*args, **kwargs): ...
    def parse_stream_group_done(*args, **kwargs): ...
    def parse_stream_start(*args, **kwargs): ...
    def parse_tag(*args, **kwargs): ...
    def parse_toc(*args, **kwargs): ...
    def parse_toc_select(*args, **kwargs): ...
    def set_group_id(*args, **kwargs): ...
    def set_running_time_offset(*args, **kwargs): ...
    def set_seek_trickmode_interval(*args, **kwargs): ...
    def set_seqnum(*args, **kwargs): ...
    def set_stream(*args, **kwargs): ...
    def set_stream_flags(*args, **kwargs): ...
    def writable_structure(*args, **kwargs): ...
    

class FlagSet:
    def register(*args, **kwargs): ...
    

class FormatDefinition:
    description = ...
    nick = ...
    quark = ...
    value = ...
    

class Fraction: ...

class FractionRange: ...

class GhostPad:
    def activate_mode_default(*args, **kwargs): ...
    def construct(*args, **kwargs): ...
    def get_target(*args, **kwargs): ...
    def internal_activate_mode_default(*args, **kwargs): ...
    def new_no_target(*args, **kwargs): ...
    def new_no_target_from_template(*args, **kwargs): ...
    def set_target(*args, **kwargs): ...
    

class Int64Range: ...

class IntRange: ...

class Iterator:
    _gst_reserved = ...
    cookie = ...
    item = ...
    lock = ...
    master_cookie = ...
    pushed = ...
    size = ...
    type = ...
    
    def filter(*args, **kwargs): ...
    def find_custom(*args, **kwargs): ...
    def fold(*args, **kwargs): ...
    def foreach(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def new_single(*args, **kwargs): ...
    def next(*args, **kwargs): ...
    def push(*args, **kwargs): ...
    def resync(*args, **kwargs): ...
    

class MapInfo:
    _gst_reserved = ...
    data = ...
    flags = ...
    maxsize = ...
    memory = ...
    size = ...
    user_data = ...
    

class Memory:
    align = ...
    allocator = ...
    maxsize = ...
    mini_object = ...
    offset = ...
    parent = ...
    size = ...
    
    def get_sizes(*args, **kwargs): ...
    def is_span(*args, **kwargs): ...
    def is_type(*args, **kwargs): ...
    def make_mapped(*args, **kwargs): ...
    def map(*args, **kwargs): ...
    def new_wrapped(*args, **kwargs): ...
    def resize(*args, **kwargs): ...
    def share(*args, **kwargs): ...
    def unmap(*args, **kwargs): ...
    

class Message:
    cond: GLib.Cond = ...
    lock: GLib.Mutex = ...
    mini_object: MiniObject = ...
    seqnum: int = ...
    src: Object = ...
    timestamp: int = ...
    type: MessageType = ...
    
    def add_redirect_entry(*args, **kwargs): ...
    def get_num_redirect_entries(*args, **kwargs): ...
    def get_seqnum(*args, **kwargs): ...
    def get_stream_status_object(*args, **kwargs): ...
    def get_structure(*args, **kwargs): ...
    def has_name(*args, **kwargs): ...
    def new_application(*args, **kwargs): ...
    def new_async_done(*args, **kwargs): ...
    def new_async_start(*args, **kwargs): ...
    def new_buffering(*args, **kwargs): ...
    def new_clock_lost(*args, **kwargs): ...
    def new_clock_provide(*args, **kwargs): ...
    def new_custom(*args, **kwargs): ...
    def new_device_added(*args, **kwargs): ...
    def new_device_changed(*args, **kwargs): ...
    def new_device_removed(*args, **kwargs): ...
    def new_duration_changed(*args, **kwargs): ...
    def new_element(*args, **kwargs): ...
    def new_eos(*args, **kwargs): ...
    def new_error(*args, **kwargs): ...
    def new_error_with_details(*args, **kwargs): ...
    def new_have_context(*args, **kwargs): ...
    def new_info(*args, **kwargs): ...
    def new_info_with_details(*args, **kwargs): ...
    def new_instant_rate_request(*args, **kwargs): ...
    def new_latency(*args, **kwargs): ...
    def new_need_context(*args, **kwargs): ...
    def new_new_clock(*args, **kwargs): ...
    def new_progress(*args, **kwargs): ...
    def new_property_notify(*args, **kwargs): ...
    def new_qos(*args, **kwargs): ...
    def new_redirect(*args, **kwargs): ...
    def new_request_state(*args, **kwargs): ...
    def new_reset_time(*args, **kwargs): ...
    def new_segment_done(*args, **kwargs): ...
    def new_segment_start(*args, **kwargs): ...
    def new_state_changed(*args, **kwargs): ...
    def new_state_dirty(*args, **kwargs): ...
    def new_step_done(*args, **kwargs): ...
    def new_step_start(*args, **kwargs): ...
    def new_stream_collection(*args, **kwargs): ...
    def new_stream_start(*args, **kwargs): ...
    def new_stream_status(*args, **kwargs): ...
    def new_streams_selected(*args, **kwargs): ...
    def new_structure_change(*args, **kwargs): ...
    def new_tag(*args, **kwargs): ...
    def new_toc(*args, **kwargs): ...
    def new_warning(*args, **kwargs): ...
    def new_warning_with_details(*args, **kwargs): ...
    def parse_async_done(*args, **kwargs): ...
    def parse_buffering(*args, **kwargs): ...
    def parse_buffering_stats(*args, **kwargs): ...
    def parse_clock_lost(*args, **kwargs): ...
    def parse_clock_provide(*args, **kwargs): ...
    def parse_context_type(*args, **kwargs): ...
    def parse_device_added(*args, **kwargs): ...
    def parse_device_changed(*args, **kwargs): ...
    def parse_device_removed(*args, **kwargs): ...
    def parse_error(*args, **kwargs): ...
    def parse_error_details(*args, **kwargs): ...
    def parse_group_id(*args, **kwargs): ...
    def parse_have_context(*args, **kwargs): ...
    def parse_info(*args, **kwargs): ...
    def parse_info_details(*args, **kwargs): ...
    def parse_instant_rate_request(*args, **kwargs): ...
    def parse_new_clock(*args, **kwargs): ...
    def parse_progress(*args, **kwargs): ...
    def parse_property_notify(*args, **kwargs): ...
    def parse_qos(*args, **kwargs): ...
    def parse_qos_stats(*args, **kwargs): ...
    def parse_qos_values(*args, **kwargs): ...
    def parse_redirect_entry(*args, **kwargs): ...
    def parse_request_state(*args, **kwargs): ...
    def parse_reset_time(*args, **kwargs): ...
    def parse_segment_done(*args, **kwargs): ...
    def parse_segment_start(*args, **kwargs): ...
    def parse_state_changed(*args, **kwargs): ...
    def parse_step_done(*args, **kwargs): ...
    def parse_step_start(*args, **kwargs): ...
    def parse_stream_collection(*args, **kwargs): ...
    def parse_stream_status(*args, **kwargs): ...
    def parse_streams_selected(*args, **kwargs): ...
    def parse_structure_change(*args, **kwargs): ...
    def parse_tag(*args, **kwargs): ...
    def parse_toc(*args, **kwargs): ...
    def parse_warning(*args, **kwargs): ...
    def parse_warning_details(*args, **kwargs): ...
    def set_buffering_stats(*args, **kwargs): ...
    def set_group_id(*args, **kwargs): ...
    def set_qos_stats(*args, **kwargs): ...
    def set_qos_values(*args, **kwargs): ...
    def set_seqnum(*args, **kwargs): ...
    def set_stream_status_object(*args, **kwargs): ...
    def streams_selected_add(*args, **kwargs): ...
    def streams_selected_get_size(*args, **kwargs): ...
    def streams_selected_get_stream(*args, **kwargs): ...
    def writable_structure(*args, **kwargs): ...
    

class Meta:
    flags = ...
    info = ...
    
    def api_type_get_tags(*args, **kwargs): ...
    def api_type_has_tag(*args, **kwargs): ...
    def api_type_register(*args, **kwargs): ...
    def compare_seqnum(*args, **kwargs): ...
    def get_info(*args, **kwargs): ...
    def get_seqnum(*args, **kwargs): ...
    def register(*args, **kwargs): ...
    

class MetaInfo:
    api = ...
    free_func = ...
    init_func = ...
    size = ...
    transform_func = ...
    type = ...
    

class MetaTransformCopy:
    offset = ...
    region = ...
    size = ...
    

class MiniObject:
    copy = ...
    dispose = ...
    flags = ...
    free = ...
    lockstate = ...
    priv_pointer = ...
    priv_uint = ...
    refcount = ...
    type = ...
    
    def add_parent(*args, **kwargs): ...
    def get_qdata(*args, **kwargs): ...
    def is_writable(*args, **kwargs): ...
    def lock(*args, **kwargs): ...
    def remove_parent(*args, **kwargs): ...
    def replace(*args, **kwargs): ...
    def set_qdata(*args, **kwargs): ...
    def steal_qdata(*args, **kwargs): ...
    def take(*args, **kwargs): ...
    def unlock(*args, **kwargs): ...
    

class Object(GObject.Object):
    _gst_reserved = ...
    control_bindings = ...
    control_rate = ...
    flags = ...
    last_sync = ...
    lock = ...
    name = ...
    object = ...
    parent = ...
    
    def add_control_binding(*args, **kwargs): ...
    def check_uniqueness(*args, **kwargs): ...
    def default_deep_notify(*args, **kwargs): ...
    def default_error(*args, **kwargs): ...
    def get_control_binding(*args, **kwargs): ...
    def get_control_rate(*args, **kwargs): ...
    def get_g_value_array(*args, **kwargs): ...
    def get_name(self) -> str: ...
    def get_parent(*args, **kwargs): ...
    def get_path_string(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def has_active_control_bindings(*args, **kwargs): ...
    def has_ancestor(*args, **kwargs): ...
    def has_as_ancestor(*args, **kwargs): ...
    def has_as_parent(*args, **kwargs): ...
    def remove_control_binding(*args, **kwargs): ...
    def replace(*args, **kwargs): ...
    def set_control_binding_disabled(*args, **kwargs): ...
    def set_control_bindings_disabled(*args, **kwargs): ...
    def set_control_rate(*args, **kwargs): ...
    def set_name(*args, **kwargs): ...
    def set_parent(*args, **kwargs): ...
    def suggest_next_sync(*args, **kwargs): ...
    def sync_values(*args, **kwargs): ...
    def unparent(*args, **kwargs): ...
    
    def do_deep_notify(self, *args, **kwargs): ...
    

class Pad:
    activatedata = ...
    activatefunc = ...
    activatemodedata = ...
    activatemodefunc = ...
    activatemodenotify = ...
    activatenotify = ...
    block_cond = ...
    chaindata = ...
    chainfunc = ...
    chainlistdata = ...
    chainlistfunc = ...
    chainlistnotify = ...
    chainnotify = ...
    direction = ...
    element_private = ...
    eventdata = ...
    eventfunc = ...
    eventnotify = ...
    getrangedata = ...
    getrangefunc = ...
    getrangenotify = ...
    iterintlinkdata = ...
    iterintlinkfunc = ...
    iterintlinknotify = ...
    linkdata = ...
    linkfunc = ...
    linknotify = ...
    mode = ...
    num_blocked = ...
    num_probes = ...
    offset = ...
    padtemplate = ...
    peer = ...
    priv = ...
    probes = ...
    querydata = ...
    queryfunc = ...
    querynotify = ...
    stream_rec_lock = ...
    task = ...
    unlinkdata = ...
    unlinkfunc = ...
    unlinknotify = ...
    
    def activate_mode(*args, **kwargs): ...
    def add_probe(*args, **kwargs): ...
    def can_link(*args, **kwargs): ...
    def chain_list(*args, **kwargs): ...
    def check_reconfigure(*args, **kwargs): ...
    def create_stream_id(*args, **kwargs): ...
    def event_default(*args, **kwargs): ...
    def forward(*args, **kwargs): ...
    def get_allowed_caps(*args, **kwargs): ...
    def get_current_caps(*args, **kwargs): ...
    def get_direction(*args, **kwargs): ...
    def get_element_private(*args, **kwargs): ...
    def get_last_flow_return(*args, **kwargs): ...
    def get_offset(*args, **kwargs): ...
    def get_pad_template(*args, **kwargs): ...
    def get_pad_template_caps(*args, **kwargs): ...
    def get_parent_element(*args, **kwargs): ...
    def get_peer(*args, **kwargs): ...
    def get_range(*args, **kwargs): ...
    def get_single_internal_link(*args, **kwargs): ...
    def get_sticky_event(*args, **kwargs): ...
    def get_stream(*args, **kwargs): ...
    def get_stream_id(*args, **kwargs): ...
    def get_task_state(*args, **kwargs): ...
    def has_current_caps(*args, **kwargs): ...
    def is_active(*args, **kwargs): ...
    def is_blocked(*args, **kwargs): ...
    def is_blocking(*args, **kwargs): ...
    def is_linked(*args, **kwargs): ...
    def iterate_internal_links(*args, **kwargs): ...
    def iterate_internal_links_default(*args, **kwargs): ...
    def link(*args, **kwargs): ...
    def link_full(*args, **kwargs): ...
    def link_get_name(*args, **kwargs): ...
    def link_maybe_ghosting(*args, **kwargs): ...
    def link_maybe_ghosting_full(*args, **kwargs): ...
    def mark_reconfigure(*args, **kwargs): ...
    def needs_reconfigure(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_static_template(*args, **kwargs): ...
    def new_from_template(*args, **kwargs): ...
    def pause_task(*args, **kwargs): ...
    def peer_query(*args, **kwargs): ...
    def peer_query_accept_caps(*args, **kwargs): ...
    def peer_query_caps(*args, **kwargs): ...
    def peer_query_convert(*args, **kwargs): ...
    def peer_query_duration(*args, **kwargs): ...
    def peer_query_position(*args, **kwargs): ...
    def proxy_query_accept_caps(*args, **kwargs): ...
    def proxy_query_caps(*args, **kwargs): ...
    def pull_range(*args, **kwargs): ...
    def push(*args, **kwargs): ...
    def push_event(*args, **kwargs): ...
    def push_list(*args, **kwargs): ...
    def query(*args, **kwargs): ...
    def query_accept_caps(*args, **kwargs): ...
    def query_caps(*args, **kwargs): ...
    def query_convert(*args, **kwargs): ...
    def query_default(*args, **kwargs): ...
    def query_duration(*args, **kwargs): ...
    def query_position(*args, **kwargs): ...
    def remove_probe(*args, **kwargs): ...
    def send_event(*args, **kwargs): ...
    def set_activate_function_full(*args, **kwargs): ...
    def set_activatemode_function_full(*args, **kwargs): ...
    def set_active(*args, **kwargs): ...
    def set_chain_function_full(*args, **kwargs): ...
    def set_chain_list_function_full(*args, **kwargs): ...
    def set_element_private(*args, **kwargs): ...
    def set_event_full_function_full(*args, **kwargs): ...
    def set_event_function_full(*args, **kwargs): ...
    def set_getrange_function_full(*args, **kwargs): ...
    def set_iterate_internal_links_function_full(*args, **kwargs): ...
    def set_link_function_full(*args, **kwargs): ...
    def set_offset(*args, **kwargs): ...
    def set_query_function_full(*args, **kwargs): ...
    def set_unlink_function_full(*args, **kwargs): ...
    def start_task(*args, **kwargs): ...
    def sticky_events_foreach(*args, **kwargs): ...
    def stop_task(*args, **kwargs): ...
    def store_sticky_event(*args, **kwargs): ...
    def unlink(*args, **kwargs): ...
    def use_fixed_caps(*args, **kwargs): ...
    
    def do_linked(self, *args, **kwargs): ...
    def do_unlinked(self, *args, **kwargs): ...
    

class PadProbeInfo:
    data = ...
    id = ...
    offset = ...
    size = ...
    type = ...
    
    def get_buffer(*args, **kwargs): ...
    def get_buffer_list(*args, **kwargs): ...
    def get_event(*args, **kwargs): ...
    def get_query(*args, **kwargs): ...
    

class PadTemplate:
    caps = ...
    direction = ...
    name_template = ...
    presence = ...
    
    def get_caps(*args, **kwargs): ...
    def get_documentation_caps(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_static_pad_template_with_gtype(*args, **kwargs): ...
    def new_with_gtype(*args, **kwargs): ...
    def pad_created(*args, **kwargs): ...
    def set_documentation_caps(*args, **kwargs): ...
    
    def do_pad_created(self, *args, **kwargs): ...
    

class ParamArray: ...

class ParamFraction: ...

class ParamSpecArray:
    element_spec = ...
    parent_instance = ...
    

class ParamSpecFraction:
    def_den = ...
    def_num = ...
    max_den = ...
    max_num = ...
    min_den = ...
    min_num = ...
    parent_instance = ...
    

class ParentBufferMeta:
    buffer = ...
    parent = ...
    
    def get_info(*args, **kwargs): ...
    

class ParseContext:
    def free(*args, **kwargs): ...
    def get_missing_elements(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class Pipeline(Bin):
    bin = ...
    delay = ...
    fixed_clock = ...
    stream_time = ...
    
    def auto_clock(*args, **kwargs): ...
    def get_auto_flush_bus(*args, **kwargs): ...
    def get_delay(*args, **kwargs): ...
    def get_latency(*args, **kwargs): ...
    def get_pipeline_clock(*args, **kwargs): ...
    @classmethod
    def new(cls, name: Optional[str]) -> Pipeline: ...
    def set_auto_flush_bus(*args, **kwargs): ...
    def set_delay(*args, **kwargs): ...
    def set_latency(*args, **kwargs): ...
    def use_clock(*args, **kwargs): ...
    

class Plugin(Object):
    def add_dependency(*args, **kwargs): ...
    def add_dependency_simple(*args, **kwargs): ...
    def get_cache_data(*args, **kwargs): ...
    def get_description(*args, **kwargs): ...
    def get_filename(*args, **kwargs): ...
    def get_license(*args, **kwargs): ...
    def get_origin(*args, **kwargs): ...
    def get_package(*args, **kwargs): ...
    def get_release_date_string(*args, **kwargs): ...
    def get_source(*args, **kwargs): ...
    def get_version(self) -> str: ...
    def is_loaded(*args, **kwargs): ...
    def list_free(*args, **kwargs): ...
    def load(*args, **kwargs): ...
    def load_by_name(*args, **kwargs): ...
    def load_file(*args, **kwargs): ...
    def register_static(*args, **kwargs): ...
    def register_static_full(*args, **kwargs): ...
    def set_cache_data(*args, **kwargs): ...
    

class PluginDesc:
    _gst_reserved = ...
    description = ...
    license = ...
    major_version = ...
    minor_version = ...
    name = ...
    origin = ...
    package = ...
    plugin_init = ...
    release_datetime = ...
    source = ...
    version = ...
    

class PluginFeature(Object):
    def check_version(*args, **kwargs): ...
    def get_plugin(*args, **kwargs): ...
    def get_plugin_name(*args, **kwargs): ...
    def get_rank(*args, **kwargs): ...
    def list_copy(*args, **kwargs): ...
    def list_debug(*args, **kwargs): ...
    def list_free(*args, **kwargs): ...
    def load(*args, **kwargs): ...
    def rank_compare_func(*args, **kwargs): ...
    def set_rank(*args, **kwargs): ...
    

class Poll:
    def add_fd(*args, **kwargs): ...
    def fd_can_read(*args, **kwargs): ...
    def fd_can_write(*args, **kwargs): ...
    def fd_ctl_pri(*args, **kwargs): ...
    def fd_ctl_read(*args, **kwargs): ...
    def fd_ctl_write(*args, **kwargs): ...
    def fd_has_closed(*args, **kwargs): ...
    def fd_has_error(*args, **kwargs): ...
    def fd_has_pri(*args, **kwargs): ...
    def fd_ignored(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_read_gpollfd(*args, **kwargs): ...
    def read_control(*args, **kwargs): ...
    def remove_fd(*args, **kwargs): ...
    def restart(*args, **kwargs): ...
    def set_controllable(*args, **kwargs): ...
    def set_flushing(*args, **kwargs): ...
    def wait(*args, **kwargs): ...
    def write_control(*args, **kwargs): ...
    

class PollFD:
    fd = ...
    idx = ...
    
    def init(*args, **kwargs): ...
    

class Preset:
    def delete_preset(*args, **kwargs): ...
    def get_app_dir(*args, **kwargs): ...
    def get_meta(*args, **kwargs): ...
    def get_preset_names(*args, **kwargs): ...
    def get_property_names(*args, **kwargs): ...
    def is_editable(*args, **kwargs): ...
    def load_preset(*args, **kwargs): ...
    def rename_preset(*args, **kwargs): ...
    def save_preset(*args, **kwargs): ...
    def set_app_dir(*args, **kwargs): ...
    def set_meta(*args, **kwargs): ...
    

class PresetInterface:
    _gst_reserved = ...
    delete_preset = ...
    get_meta = ...
    get_preset_names = ...
    get_property_names = ...
    load_preset = ...
    parent = ...
    rename_preset = ...
    save_preset = ...
    set_meta = ...
    

class Promise:
    parent = ...
    
    def expire(*args, **kwargs): ...
    def get_reply(*args, **kwargs): ...
    def interrupt(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_change_func(*args, **kwargs): ...
    def reply(*args, **kwargs): ...
    def wait(*args, **kwargs): ...
    

class ProtectionMeta:
    info = ...
    meta = ...
    
    def get_info(*args, **kwargs): ...
    

class ProxyPad:
    pad = ...
    
    def chain_default(*args, **kwargs): ...
    def chain_list_default(*args, **kwargs): ...
    def get_internal(*args, **kwargs): ...
    def getrange_default(*args, **kwargs): ...
    

class Query:
    mini_object = ...
    type = ...
    
    def add_allocation_meta(*args, **kwargs): ...
    def add_allocation_param(*args, **kwargs): ...
    def add_allocation_pool(*args, **kwargs): ...
    def add_buffering_range(*args, **kwargs): ...
    def add_scheduling_mode(*args, **kwargs): ...
    def find_allocation_meta(*args, **kwargs): ...
    def get_n_allocation_metas(*args, **kwargs): ...
    def get_n_allocation_params(*args, **kwargs): ...
    def get_n_allocation_pools(*args, **kwargs): ...
    def get_n_buffering_ranges(*args, **kwargs): ...
    def get_n_scheduling_modes(*args, **kwargs): ...
    def get_structure(*args, **kwargs): ...
    def has_scheduling_mode(*args, **kwargs): ...
    def has_scheduling_mode_with_flags(*args, **kwargs): ...
    def new_accept_caps(*args, **kwargs): ...
    def new_allocation(*args, **kwargs): ...
    def new_bitrate(*args, **kwargs): ...
    def new_buffering(*args, **kwargs): ...
    def new_caps(*args, **kwargs): ...
    def new_context(*args, **kwargs): ...
    def new_convert(*args, **kwargs): ...
    def new_custom(*args, **kwargs): ...
    def new_drain(*args, **kwargs): ...
    def new_duration(*args, **kwargs): ...
    def new_formats(*args, **kwargs): ...
    def new_latency(*args, **kwargs): ...
    @classmethod
    def new_position(cls, format: Format) -> Query: ...
    def new_scheduling(*args, **kwargs): ...
    def new_seeking(*args, **kwargs): ...
    def new_segment(*args, **kwargs): ...
    def new_uri(*args, **kwargs): ...
    def parse_accept_caps(*args, **kwargs): ...
    def parse_accept_caps_result(*args, **kwargs): ...
    def parse_allocation(*args, **kwargs): ...
    def parse_bitrate(*args, **kwargs): ...
    def parse_buffering_percent(*args, **kwargs): ...
    def parse_buffering_range(*args, **kwargs): ...
    def parse_buffering_stats(*args, **kwargs): ...
    def parse_caps(*args, **kwargs): ...
    def parse_caps_result(*args, **kwargs): ...
    def parse_context(*args, **kwargs): ...
    def parse_context_type(*args, **kwargs): ...
    def parse_convert(*args, **kwargs): ...
    def parse_duration(*args, **kwargs): ...
    def parse_latency(*args, **kwargs): ...
    def parse_n_formats(*args, **kwargs): ...
    def parse_nth_allocation_meta(*args, **kwargs): ...
    def parse_nth_allocation_param(*args, **kwargs): ...
    def parse_nth_allocation_pool(*args, **kwargs): ...
    def parse_nth_buffering_range(*args, **kwargs): ...
    def parse_nth_format(*args, **kwargs): ...
    def parse_nth_scheduling_mode(*args, **kwargs): ...
    def parse_position(self) -> Tuple[Optional[Format], Optional[int]]: ...
    def parse_scheduling(*args, **kwargs): ...
    def parse_seeking(*args, **kwargs): ...
    def parse_segment(*args, **kwargs): ...
    def parse_uri(*args, **kwargs): ...
    def parse_uri_redirection(*args, **kwargs): ...
    def parse_uri_redirection_permanent(*args, **kwargs): ...
    def remove_nth_allocation_meta(*args, **kwargs): ...
    def remove_nth_allocation_param(*args, **kwargs): ...
    def remove_nth_allocation_pool(*args, **kwargs): ...
    def set_accept_caps_result(*args, **kwargs): ...
    def set_bitrate(*args, **kwargs): ...
    def set_buffering_percent(*args, **kwargs): ...
    def set_buffering_range(*args, **kwargs): ...
    def set_buffering_stats(*args, **kwargs): ...
    def set_caps_result(*args, **kwargs): ...
    def set_context(*args, **kwargs): ...
    def set_convert(*args, **kwargs): ...
    def set_duration(*args, **kwargs): ...
    def set_formatsv(*args, **kwargs): ...
    def set_latency(*args, **kwargs): ...
    def set_nth_allocation_param(*args, **kwargs): ...
    def set_nth_allocation_pool(*args, **kwargs): ...
    def set_position(*args, **kwargs): ...
    def set_scheduling(*args, **kwargs): ...
    def set_seeking(*args, **kwargs): ...
    def set_segment(*args, **kwargs): ...
    def set_uri(*args, **kwargs): ...
    def set_uri_redirection(*args, **kwargs): ...
    def set_uri_redirection_permanent(*args, **kwargs): ...
    def writable_structure(*args, **kwargs): ...
    

class ReferenceTimestampMeta:
    duration = ...
    parent = ...
    reference = ...
    timestamp = ...
    
    def get_info(*args, **kwargs): ...
    

class Registry:
    priv = ...
    
    def add_feature(*args, **kwargs): ...
    def add_plugin(*args, **kwargs): ...
    def check_feature_version(*args, **kwargs): ...
    def feature_filter(*args, **kwargs): ...
    def find_feature(*args, **kwargs): ...
    def find_plugin(*args, **kwargs): ...
    def fork_is_enabled(*args, **kwargs): ...
    def fork_set_enabled(*args, **kwargs): ...
    @classmethod
    def get(cls) -> Registry: ...
    def get_feature_list(*args, **kwargs): ...
    def get_feature_list_by_plugin(*args, **kwargs): ...
    def get_feature_list_cookie(*args, **kwargs): ...
    def get_plugin_list(self) -> list[Plugin]: ...
    def lookup(*args, **kwargs): ...
    def lookup_feature(*args, **kwargs): ...
    def plugin_filter(*args, **kwargs): ...
    def remove_feature(*args, **kwargs): ...
    def remove_plugin(*args, **kwargs): ...
    def scan_path(*args, **kwargs): ...
    

class Sample:
    def get_buffer(*args, **kwargs): ...
    def get_buffer_list(*args, **kwargs): ...
    def get_caps(*args, **kwargs): ...
    def get_info(*args, **kwargs): ...
    def get_segment(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_buffer(*args, **kwargs): ...
    def set_buffer_list(*args, **kwargs): ...
    def set_caps(*args, **kwargs): ...
    def set_info(*args, **kwargs): ...
    def set_segment(*args, **kwargs): ...
    

class Segment:
    _gst_reserved = ...
    applied_rate = ...
    base = ...
    duration = ...
    flags = ...
    format = ...
    offset = ...
    position = ...
    rate = ...
    start = ...
    stop = ...
    time = ...
    
    def clip(*args, **kwargs): ...
    def copy_into(*args, **kwargs): ...
    def do_seek(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def init(*args, **kwargs): ...
    def is_equal(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def offset_running_time(*args, **kwargs): ...
    def position_from_running_time(*args, **kwargs): ...
    def position_from_running_time_full(*args, **kwargs): ...
    def position_from_stream_time(*args, **kwargs): ...
    def position_from_stream_time_full(*args, **kwargs): ...
    def set_running_time(*args, **kwargs): ...
    def to_position(*args, **kwargs): ...
    def to_running_time(*args, **kwargs): ...
    def to_running_time_full(*args, **kwargs): ...
    def to_stream_time(*args, **kwargs): ...
    def to_stream_time_full(*args, **kwargs): ...
    

class StaticCaps:
    _gst_reserved = ...
    caps = ...
    string = ...
    
    def cleanup(*args, **kwargs): ...
    def get(*args, **kwargs): ...
    

class StaticPadTemplate:
    direction = ...
    name_template = ...
    presence = ...
    static_caps = ...
    
    def get(*args, **kwargs): ...
    def get_caps(*args, **kwargs): ...
    

class Stream:
    priv = ...
    stream_id = ...
    
    def get_caps(*args, **kwargs): ...
    def get_stream_flags(*args, **kwargs): ...
    def get_stream_id(*args, **kwargs): ...
    def get_stream_type(*args, **kwargs): ...
    def get_tags(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_caps(*args, **kwargs): ...
    def set_stream_flags(*args, **kwargs): ...
    def set_stream_type(*args, **kwargs): ...
    def set_tags(*args, **kwargs): ...
    

class StreamCollection:
    priv = ...
    upstream_id = ...
    
    def add_stream(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_stream(*args, **kwargs): ...
    def get_upstream_id(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    
    def do_stream_notify(self, *args, **kwargs): ...
    

class Structure:
    name = ...
    type = ...
    
    def can_intersect(*args, **kwargs): ...
    def filter_and_map_in_place(*args, **kwargs): ...
    def fixate(*args, **kwargs): ...
    def fixate_field(*args, **kwargs): ...
    def fixate_field_boolean(*args, **kwargs): ...
    def fixate_field_nearest_double(*args, **kwargs): ...
    def fixate_field_nearest_fraction(*args, **kwargs): ...
    def fixate_field_nearest_int(*args, **kwargs): ...
    def fixate_field_string(*args, **kwargs): ...
    def foreach(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def from_string(*args, **kwargs): ...
    def get_array(*args, **kwargs): ...
    def get_boolean(*args, **kwargs): ...
    def get_clock_time(*args, **kwargs): ...
    def get_date(*args, **kwargs): ...
    def get_date_time(*args, **kwargs): ...
    def get_double(*args, **kwargs): ...
    def get_enum(*args, **kwargs): ...
    def get_field_type(*args, **kwargs): ...
    def get_flagset(*args, **kwargs): ...
    def get_fraction(*args, **kwargs): ...
    def get_int(*args, **kwargs): ...
    def get_int64(*args, **kwargs): ...
    def get_list(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_name_id(*args, **kwargs): ...
    def get_string(*args, **kwargs): ...
    def get_uint(*args, **kwargs): ...
    def get_uint64(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def has_field(*args, **kwargs): ...
    def has_field_typed(*args, **kwargs): ...
    def has_name(*args, **kwargs): ...
    def id_get_value(*args, **kwargs): ...
    def id_has_field(*args, **kwargs): ...
    def id_has_field_typed(*args, **kwargs): ...
    def id_set_value(*args, **kwargs): ...
    def id_take_value(*args, **kwargs): ...
    def intersect(*args, **kwargs): ...
    def is_equal(*args, **kwargs): ...
    def is_subset(*args, **kwargs): ...
    def map_in_place(*args, **kwargs): ...
    def n_fields(*args, **kwargs): ...
    def new_empty(*args, **kwargs): ...
    def new_from_string(*args, **kwargs): ...
    def new_id_empty(*args, **kwargs): ...
    def nth_field_name(*args, **kwargs): ...
    def remove_all_fields(*args, **kwargs): ...
    def remove_field(*args, **kwargs): ...
    def set_array(*args, **kwargs): ...
    def set_list(*args, **kwargs): ...
    def set_name(*args, **kwargs): ...
    def set_parent_refcount(*args, **kwargs): ...
    def set_value(*args, **kwargs): ...
    def take(*args, **kwargs): ...
    def take_value(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    

class SystemClock:
    clock = ...
    
    def obtain(*args, **kwargs): ...
    def set_default(*args, **kwargs): ...
    

class TagList:
    mini_object = ...
    
    def add_value(*args, **kwargs): ...
    def copy_value(*args, **kwargs): ...
    def foreach(*args, **kwargs): ...
    def get_boolean(*args, **kwargs): ...
    def get_boolean_index(*args, **kwargs): ...
    def get_date(*args, **kwargs): ...
    def get_date_index(*args, **kwargs): ...
    def get_date_time(*args, **kwargs): ...
    def get_date_time_index(*args, **kwargs): ...
    def get_double(*args, **kwargs): ...
    def get_double_index(*args, **kwargs): ...
    def get_float(*args, **kwargs): ...
    def get_float_index(*args, **kwargs): ...
    def get_int(*args, **kwargs): ...
    def get_int64(*args, **kwargs): ...
    def get_int64_index(*args, **kwargs): ...
    def get_int_index(*args, **kwargs): ...
    def get_pointer(*args, **kwargs): ...
    def get_pointer_index(*args, **kwargs): ...
    def get_sample(*args, **kwargs): ...
    def get_sample_index(*args, **kwargs): ...
    def get_scope(*args, **kwargs): ...
    def get_string(*args, **kwargs): ...
    def get_string_index(*args, **kwargs): ...
    def get_tag_size(*args, **kwargs): ...
    def get_uint(*args, **kwargs): ...
    def get_uint64(*args, **kwargs): ...
    def get_uint64_index(*args, **kwargs): ...
    def get_uint_index(*args, **kwargs): ...
    def get_value_index(*args, **kwargs): ...
    def insert(*args, **kwargs): ...
    def is_empty(*args, **kwargs): ...
    def is_equal(*args, **kwargs): ...
    def merge(*args, **kwargs): ...
    def n_tags(*args, **kwargs): ...
    def new_empty(*args, **kwargs): ...
    def new_from_string(*args, **kwargs): ...
    def nth_tag_name(*args, **kwargs): ...
    def peek_string_index(*args, **kwargs): ...
    def remove_tag(*args, **kwargs): ...
    def set_scope(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    

class TagSetter:
    def add_tag_value(*args, **kwargs): ...
    def get_tag_list(*args, **kwargs): ...
    def get_tag_merge_mode(*args, **kwargs): ...
    def merge_tags(*args, **kwargs): ...
    def reset_tags(*args, **kwargs): ...
    def set_tag_merge_mode(*args, **kwargs): ...
    

class TagSetterInterface:
    g_iface = ...
    

class Task:
    cond = ...
    func = ...
    priv = ...
    running = ...
    state = ...
    thread = ...
    user_data = ...
    
    def cleanup_all(*args, **kwargs): ...
    def get_pool(*args, **kwargs): ...
    def get_state(*args, **kwargs): ...
    def join(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def pause(*args, **kwargs): ...
    def resume(*args, **kwargs): ...
    def set_enter_callback(*args, **kwargs): ...
    def set_leave_callback(*args, **kwargs): ...
    def set_lock(*args, **kwargs): ...
    def set_pool(*args, **kwargs): ...
    def set_state(*args, **kwargs): ...
    def start(*args, **kwargs): ...
    def stop(*args, **kwargs): ...
    

class TaskPool:
    pool = ...
    
    def cleanup(*args, **kwargs): ...
    def join(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def prepare(*args, **kwargs): ...
    def push(*args, **kwargs): ...
    
    def do_cleanup(self, *args, **kwargs): ...
    def do_join(self, *args, **kwargs): ...
    def do_prepare(self, *args, **kwargs): ...
    def do_push(self, *args, **kwargs): ...
    

class TimedValue:
    timestamp = ...
    value = ...
    

class Toc:
    def append_entry(*args, **kwargs): ...
    def dump(*args, **kwargs): ...
    def find_entry(*args, **kwargs): ...
    def get_entries(*args, **kwargs): ...
    def get_scope(*args, **kwargs): ...
    def get_tags(*args, **kwargs): ...
    def merge_tags(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_tags(*args, **kwargs): ...
    

class TocEntry:
    def append_sub_entry(*args, **kwargs): ...
    def get_entry_type(*args, **kwargs): ...
    def get_loop(*args, **kwargs): ...
    def get_parent(*args, **kwargs): ...
    def get_start_stop_times(*args, **kwargs): ...
    def get_sub_entries(*args, **kwargs): ...
    def get_tags(*args, **kwargs): ...
    def get_toc(*args, **kwargs): ...
    def get_uid(*args, **kwargs): ...
    def is_alternative(*args, **kwargs): ...
    def is_sequence(*args, **kwargs): ...
    def merge_tags(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_loop(*args, **kwargs): ...
    def set_start_stop_times(*args, **kwargs): ...
    def set_tags(*args, **kwargs): ...
    

class TocSetter:
    def get_toc(*args, **kwargs): ...
    def reset(*args, **kwargs): ...
    def set_toc(*args, **kwargs): ...
    

class TocSetterInterface:
    g_iface = ...
    

class Tracer:
    priv = ...
    
    def register(*args, **kwargs): ...
    

class TracerFactory:
    def get_list(*args, **kwargs): ...
    def get_tracer_type(*args, **kwargs): ...
    

class TracerRecord: ...

class TypeFind:
    _gst_reserved = ...
    data = ...
    
    def get_length(*args, **kwargs): ...
    def peek(*args, **kwargs): ...
    def register(*args, **kwargs): ...
    def suggest(*args, **kwargs): ...
    

class TypeFindFactory:
    def call_function(*args, **kwargs): ...
    def get_caps(*args, **kwargs): ...
    def get_extensions(*args, **kwargs): ...
    def get_list(*args, **kwargs): ...
    def has_function(*args, **kwargs): ...
    

class URIHandler:
    def get_protocols(*args, **kwargs): ...
    def get_uri(*args, **kwargs): ...
    def get_uri_type(*args, **kwargs): ...
    def set_uri(*args, **kwargs): ...
    

class URIHandlerInterface:
    get_protocols = ...
    get_type = ...
    get_uri = ...
    parent = ...
    set_uri = ...
    

class Uri:
    def append_path(*args, **kwargs): ...
    def append_path_segment(*args, **kwargs): ...
    def construct(*args, **kwargs): ...
    def equal(*args, **kwargs): ...
    def from_string(*args, **kwargs): ...
    def from_string_escaped(*args, **kwargs): ...
    def from_string_with_base(*args, **kwargs): ...
    def get_fragment(*args, **kwargs): ...
    def get_host(*args, **kwargs): ...
    def get_location(*args, **kwargs): ...
    def get_media_fragment_table(*args, **kwargs): ...
    def get_path(*args, **kwargs): ...
    def get_path_segments(*args, **kwargs): ...
    def get_path_string(*args, **kwargs): ...
    def get_port(*args, **kwargs): ...
    def get_protocol(*args, **kwargs): ...
    def get_query_keys(*args, **kwargs): ...
    def get_query_string(*args, **kwargs): ...
    def get_query_table(*args, **kwargs): ...
    def get_query_value(*args, **kwargs): ...
    def get_scheme(*args, **kwargs): ...
    def get_userinfo(*args, **kwargs): ...
    def has_protocol(*args, **kwargs): ...
    def is_normalized(*args, **kwargs): ...
    def is_valid(*args, **kwargs): ...
    def is_writable(*args, **kwargs): ...
    def join(*args, **kwargs): ...
    def join_strings(*args, **kwargs): ...
    def make_writable(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_base(*args, **kwargs): ...
    def normalize(*args, **kwargs): ...
    def protocol_is_supported(*args, **kwargs): ...
    def protocol_is_valid(*args, **kwargs): ...
    def query_has_key(*args, **kwargs): ...
    def remove_query_key(*args, **kwargs): ...
    def set_fragment(*args, **kwargs): ...
    def set_host(*args, **kwargs): ...
    def set_path(*args, **kwargs): ...
    def set_path_segments(*args, **kwargs): ...
    def set_path_string(*args, **kwargs): ...
    def set_port(*args, **kwargs): ...
    def set_query_string(*args, **kwargs): ...
    def set_query_table(*args, **kwargs): ...
    def set_query_value(*args, **kwargs): ...
    def set_scheme(*args, **kwargs): ...
    def set_userinfo(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    

class ValueArray:
    def append_and_take_value(*args, **kwargs): ...
    def append_value(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def init(*args, **kwargs): ...
    def prepend_value(*args, **kwargs): ...
    

class ValueList:
    def append_and_take_value(*args, **kwargs): ...
    def append_value(*args, **kwargs): ...
    def concat(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def init(*args, **kwargs): ...
    def merge(*args, **kwargs): ...
    def prepend_value(*args, **kwargs): ...
    

class ValueTable:
    _gst_reserved = ...
    compare = ...
    deserialize = ...
    serialize = ...
    type = ...
    

class AllocatorFlags(GObject.GFlags):
    CUSTOM_ALLOC = ...
    LAST = ...

class BinFlags(GObject.GFlags):
    NO_RESYNC = ...
    STREAMS_AWARE = ...
    LAST = ...

class BufferCopyFlags(GObject.GFlags):
    NONE = ...
    FLAGS = ...
    TIMESTAMPS = ...
    META = ...
    MEMORY = ...
    MERGE = ...
    DEEP = ...

class BufferFlags(GObject.GFlags):
    LIVE = ...
    DECODE_ONLY = ...
    DISCONT = ...
    RESYNC = ...
    CORRUPTED = ...
    MARKER = ...
    HEADER = ...
    GAP = ...
    DROPPABLE = ...
    DELTA_UNIT = ...
    TAG_MEMORY = ...
    SYNC_AFTER = ...
    NON_DROPPABLE = ...
    LAST = ...

class BufferPoolAcquireFlags(GObject.GFlags):
    NONE = ...
    KEY_UNIT = ...
    DONTWAIT = ...
    DISCONT = ...
    LAST = ...

class BusFlags(GObject.GFlags):
    FLUSHING = ...
    FLAG_LAST = ...

class CapsFlags(GObject.GFlags):
    ANY = ...

class ClockFlags(GObject.GFlags):
    CAN_DO_SINGLE_SYNC = ...
    CAN_DO_SINGLE_ASYNC = ...
    CAN_DO_PERIODIC_SYNC = ...
    CAN_DO_PERIODIC_ASYNC = ...
    CAN_SET_RESOLUTION = ...
    CAN_SET_MASTER = ...
    NEEDS_STARTUP_SYNC = ...
    LAST = ...

class DebugColorFlags(GObject.GFlags):
    FG_BLACK = ...
    FG_RED = ...
    FG_GREEN = ...
    FG_YELLOW = ...
    FG_BLUE = ...
    FG_MAGENTA = ...
    FG_CYAN = ...
    FG_WHITE = ...
    BG_BLACK = ...
    BG_RED = ...
    BG_GREEN = ...
    BG_YELLOW = ...
    BG_BLUE = ...
    BG_MAGENTA = ...
    BG_CYAN = ...
    BG_WHITE = ...
    BOLD = ...
    UNDERLINE = ...

class DebugGraphDetails(GObject.GFlags):
    MEDIA_TYPE = ...
    CAPS_DETAILS = ...
    NON_DEFAULT_PARAMS = ...
    STATES = ...
    FULL_PARAMS = ...
    ALL = ...
    VERBOSE = ...

class ElementFlags(GObject.GFlags):
    LOCKED_STATE = ...
    SINK = ...
    SOURCE = ...
    PROVIDE_CLOCK = ...
    REQUIRE_CLOCK = ...
    INDEXABLE = ...
    LAST = ...

class EventTypeFlags(GObject.GFlags):
    UPSTREAM = ...
    DOWNSTREAM = ...
    SERIALIZED = ...
    STICKY = ...
    STICKY_MULTI = ...

class LockFlags(GObject.GFlags):
    READ = ...
    WRITE = ...
    EXCLUSIVE = ...
    LAST = ...

class MapFlags(GObject.GFlags):
    READ = ...
    WRITE = ...
    FLAG_LAST = ...

class MemoryFlags(GObject.GFlags):
    READONLY = ...
    NO_SHARE = ...
    ZERO_PREFIXED = ...
    ZERO_PADDED = ...
    PHYSICALLY_CONTIGUOUS = ...
    NOT_MAPPABLE = ...
    LAST = ...

class MessageType(GObject.GFlags):
    UNKNOWN = ...
    EOS = ...
    ERROR = ...
    WARNING = ...
    INFO = ...
    TAG = ...
    BUFFERING = ...
    STATE_CHANGED = ...
    STATE_DIRTY = ...
    STEP_DONE = ...
    CLOCK_PROVIDE = ...
    CLOCK_LOST = ...
    NEW_CLOCK = ...
    STRUCTURE_CHANGE = ...
    STREAM_STATUS = ...
    APPLICATION = ...
    ELEMENT = ...
    SEGMENT_START = ...
    SEGMENT_DONE = ...
    DURATION_CHANGED = ...
    LATENCY = ...
    ASYNC_START = ...
    ASYNC_DONE = ...
    REQUEST_STATE = ...
    STEP_START = ...
    QOS = ...
    PROGRESS = ...
    TOC = ...
    RESET_TIME = ...
    STREAM_START = ...
    NEED_CONTEXT = ...
    HAVE_CONTEXT = ...
    EXTENDED = ...
    DEVICE_ADDED = ...
    DEVICE_REMOVED = ...
    PROPERTY_NOTIFY = ...
    STREAM_COLLECTION = ...
    STREAMS_SELECTED = ...
    REDIRECT = ...
    DEVICE_CHANGED = ...
    INSTANT_RATE_REQUEST = ...
    ANY = ...
    get_name = ...
    to_quark = ...

class MetaFlags(GObject.GFlags):
    NONE = ...
    READONLY = ...
    POOLED = ...
    LOCKED = ...
    LAST = ...

class MiniObjectFlags(GObject.GFlags):
    LOCKABLE = ...
    LOCK_READONLY = ...
    MAY_BE_LEAKED = ...
    LAST = ...

class ObjectFlags(GObject.GFlags):
    MAY_BE_LEAKED = ...
    LAST = ...

class PadFlags(GObject.GFlags):
    BLOCKED = ...
    FLUSHING = ...
    EOS = ...
    BLOCKING = ...
    NEED_PARENT = ...
    NEED_RECONFIGURE = ...
    PENDING_EVENTS = ...
    FIXED_CAPS = ...
    PROXY_CAPS = ...
    PROXY_ALLOCATION = ...
    PROXY_SCHEDULING = ...
    ACCEPT_INTERSECT = ...
    ACCEPT_TEMPLATE = ...
    LAST = ...

class PadLinkCheck(GObject.GFlags):
    NOTHING = ...
    HIERARCHY = ...
    TEMPLATE_CAPS = ...
    CAPS = ...
    NO_RECONFIGURE = ...
    DEFAULT = ...

class PadProbeType(GObject.GFlags):
    INVALID = ...
    IDLE = ...
    BLOCK = ...
    BUFFER = ...
    BUFFER_LIST = ...
    EVENT_DOWNSTREAM = ...
    EVENT_UPSTREAM = ...
    EVENT_FLUSH = ...
    QUERY_DOWNSTREAM = ...
    QUERY_UPSTREAM = ...
    PUSH = ...
    PULL = ...
    BLOCKING = ...
    DATA_DOWNSTREAM = ...
    DATA_UPSTREAM = ...
    DATA_BOTH = ...
    BLOCK_DOWNSTREAM = ...
    BLOCK_UPSTREAM = ...
    EVENT_BOTH = ...
    QUERY_BOTH = ...
    ALL_BOTH = ...
    SCHEDULING = ...

class PadTemplateFlags(GObject.GFlags):
    LAST = ...

class ParseFlags(GObject.GFlags):
    NONE = ...
    FATAL_ERRORS = ...
    NO_SINGLE_ELEMENT_BINS = ...
    PLACE_IN_BIN = ...

class PipelineFlags(GObject.GFlags):
    FIXED_CLOCK = ...
    LAST = ...

class PluginAPIFlags(GObject.GFlags):
    MEMBERS = ...

class PluginDependencyFlags(GObject.GFlags):
    NONE = ...
    RECURSE = ...
    PATHS_ARE_DEFAULT_ONLY = ...
    FILE_NAME_IS_SUFFIX = ...
    FILE_NAME_IS_PREFIX = ...
    PATHS_ARE_RELATIVE_TO_EXE = ...

class PluginFlags(GObject.GFlags):
    CACHED = ...
    BLACKLISTED = ...

class QueryTypeFlags(GObject.GFlags):
    UPSTREAM = ...
    DOWNSTREAM = ...
    SERIALIZED = ...

class SchedulingFlags(GObject.GFlags):
    SEEKABLE = ...
    SEQUENTIAL = ...
    BANDWIDTH_LIMITED = ...

class SeekFlags(GObject.GFlags):
    NONE = ...
    FLUSH = ...
    ACCURATE = ...
    KEY_UNIT = ...
    SEGMENT = ...
    TRICKMODE = ...
    SKIP = ...
    SNAP_BEFORE = ...
    SNAP_AFTER = ...
    SNAP_NEAREST = ...
    TRICKMODE_KEY_UNITS = ...
    TRICKMODE_NO_AUDIO = ...
    TRICKMODE_FORWARD_PREDICTED = ...
    INSTANT_RATE_CHANGE = ...

class SegmentFlags(GObject.GFlags):
    NONE = ...
    RESET = ...
    TRICKMODE = ...
    SKIP = ...
    SEGMENT = ...
    TRICKMODE_KEY_UNITS = ...
    TRICKMODE_FORWARD_PREDICTED = ...
    TRICKMODE_NO_AUDIO = ...

class StackTraceFlags(GObject.GFlags):
    NONE = ...
    FULL = ...

class StreamFlags(GObject.GFlags):
    NONE = ...
    SPARSE = ...
    SELECT = ...
    UNSELECT = ...

class StreamType(GObject.GFlags):
    UNKNOWN = ...
    AUDIO = ...
    VIDEO = ...
    CONTAINER = ...
    TEXT = ...
    get_name = ...

class TracerValueFlags(GObject.GFlags):
    NONE = ...
    OPTIONAL = ...
    AGGREGATED = ...

class BufferingMode(GObject.GEnum):
    STREAM = ...
    DOWNLOAD = ...
    TIMESHIFT = ...
    LIVE = ...

class BusSyncReply(GObject.GEnum):
    DROP = ...
    PASS = ...
    ASYNC = ...

class CapsIntersectMode(GObject.GEnum):
    ZIG_ZAG = ...
    FIRST = ...

class ClockEntryType(GObject.GEnum):
    SINGLE = ...
    PERIODIC = ...

class ClockReturn(GObject.GEnum):
    OK = ...
    EARLY = ...
    UNSCHEDULED = ...
    BUSY = ...
    BADTIME = ...
    ERROR = ...
    UNSUPPORTED = ...
    DONE = ...

class ClockType(GObject.GEnum):
    REALTIME = ...
    MONOTONIC = ...
    OTHER = ...
    TAI = ...

class CoreError(GObject.GEnum):
    FAILED = ...
    TOO_LAZY = ...
    NOT_IMPLEMENTED = ...
    STATE_CHANGE = ...
    PAD = ...
    THREAD = ...
    NEGOTIATION = ...
    EVENT = ...
    SEEK = ...
    CAPS = ...
    TAG = ...
    MISSING_PLUGIN = ...
    CLOCK = ...
    DISABLED = ...
    NUM_ERRORS = ...
    quark = ...

class DebugColorMode(GObject.GEnum):
    OFF = ...
    ON = ...
    UNIX = ...

class DebugLevel(GObject.GEnum):
    NONE = ...
    ERROR = ...
    WARNING = ...
    FIXME = ...
    INFO = ...
    DEBUG = ...
    LOG = ...
    TRACE = ...
    MEMDUMP = ...
    COUNT = ...
    get_name = ...

class EventType(GObject.GEnum):
    UNKNOWN = ...
    FLUSH_START = ...
    FLUSH_STOP = ...
    STREAM_START = ...
    CAPS = ...
    SEGMENT = ...
    STREAM_COLLECTION = ...
    TAG = ...
    BUFFERSIZE = ...
    SINK_MESSAGE = ...
    STREAM_GROUP_DONE = ...
    EOS = ...
    TOC = ...
    PROTECTION = ...
    SEGMENT_DONE = ...
    GAP = ...
    INSTANT_RATE_CHANGE = ...
    QOS = ...
    SEEK = ...
    NAVIGATION = ...
    LATENCY = ...
    STEP = ...
    RECONFIGURE = ...
    TOC_SELECT = ...
    SELECT_STREAMS = ...
    INSTANT_RATE_SYNC_TIME = ...
    CUSTOM_UPSTREAM = ...
    CUSTOM_DOWNSTREAM = ...
    CUSTOM_DOWNSTREAM_OOB = ...
    CUSTOM_DOWNSTREAM_STICKY = ...
    CUSTOM_BOTH = ...
    CUSTOM_BOTH_OOB = ...
    get_flags = ...
    get_name = ...
    to_quark = ...

class FlowReturn(GObject.GEnum):
    CUSTOM_SUCCESS_2 = ...
    CUSTOM_SUCCESS_1 = ...
    CUSTOM_SUCCESS = ...
    OK = ...
    NOT_LINKED = ...
    FLUSHING = ...
    EOS = ...
    NOT_NEGOTIATED = ...
    ERROR = ...
    NOT_SUPPORTED = ...
    CUSTOM_ERROR = ...
    CUSTOM_ERROR_1 = ...
    CUSTOM_ERROR_2 = ...

class Format(GObject.GEnum):
    UNDEFINED = ...
    DEFAULT = ...
    BYTES = ...
    TIME = ...
    BUFFERS = ...
    PERCENT = ...
    get_by_nick = ...
    get_details = ...
    get_name = ...
    iterate_definitions = ...
    register = ...
    to_quark = ...

class IteratorItem(GObject.GEnum):
    SKIP = ...
    PASS = ...
    END = ...

class IteratorResult(GObject.GEnum):
    DONE = ...
    OK = ...
    RESYNC = ...
    ERROR = ...

class LibraryError(GObject.GEnum):
    FAILED = ...
    TOO_LAZY = ...
    INIT = ...
    SHUTDOWN = ...
    SETTINGS = ...
    ENCODE = ...
    NUM_ERRORS = ...
    quark = ...

class PadDirection(GObject.GEnum):
    UNKNOWN = ...
    SRC = ...
    SINK = ...

class PadLinkReturn(GObject.GEnum):
    OK = ...
    WRONG_HIERARCHY = ...
    WAS_LINKED = ...
    WRONG_DIRECTION = ...
    NOFORMAT = ...
    NOSCHED = ...
    REFUSED = ...

class PadMode(GObject.GEnum):
    NONE = ...
    PUSH = ...
    PULL = ...
    get_name = ...

class PadPresence(GObject.GEnum):
    ALWAYS = ...
    SOMETIMES = ...
    REQUEST = ...

class PadProbeReturn(GObject.GEnum):
    DROP = ...
    OK = ...
    REMOVE = ...
    PASS = ...
    HANDLED = ...

class ParseError(GObject.GEnum):
    SYNTAX = ...
    NO_SUCH_ELEMENT = ...
    NO_SUCH_PROPERTY = ...
    LINK = ...
    COULD_NOT_SET_PROPERTY = ...
    EMPTY_BIN = ...
    EMPTY = ...
    DELAYED_LINK = ...
    quark = ...

class PluginError(GObject.GEnum):
    MODULE = ...
    DEPENDENCIES = ...
    NAME_MISMATCH = ...
    quark = ...

class ProgressType(GObject.GEnum):
    START = ...
    CONTINUE = ...
    COMPLETE = ...
    CANCELED = ...
    ERROR = ...

class PromiseResult(GObject.GEnum):
    PENDING = ...
    INTERRUPTED = ...
    REPLIED = ...
    EXPIRED = ...

class QOSType(GObject.GEnum):
    OVERFLOW = ...
    UNDERFLOW = ...
    THROTTLE = ...

class QueryType(GObject.GEnum):
    UNKNOWN = ...
    POSITION = ...
    DURATION = ...
    LATENCY = ...
    JITTER = ...
    RATE = ...
    SEEKING = ...
    SEGMENT = ...
    CONVERT = ...
    FORMATS = ...
    BUFFERING = ...
    CUSTOM = ...
    URI = ...
    ALLOCATION = ...
    SCHEDULING = ...
    ACCEPT_CAPS = ...
    CAPS = ...
    DRAIN = ...
    CONTEXT = ...
    BITRATE = ...
    get_flags = ...
    get_name = ...
    to_quark = ...

class Rank(GObject.GEnum):
    NONE = ...
    MARGINAL = ...
    SECONDARY = ...
    PRIMARY = ...

class ResourceError(GObject.GEnum):
    FAILED = ...
    TOO_LAZY = ...
    NOT_FOUND = ...
    BUSY = ...
    OPEN_READ = ...
    OPEN_WRITE = ...
    OPEN_READ_WRITE = ...
    CLOSE = ...
    READ = ...
    WRITE = ...
    SEEK = ...
    SYNC = ...
    SETTINGS = ...
    NO_SPACE_LEFT = ...
    NOT_AUTHORIZED = ...
    NUM_ERRORS = ...
    quark = ...

class SearchMode(GObject.GEnum):
    EXACT = ...
    BEFORE = ...
    AFTER = ...

class SeekType(GObject.GEnum):
    NONE = ...
    SET = ...
    END = ...

class State(GObject.GEnum):
    VOID_PENDING = ...
    NULL = ...
    READY = ...
    PAUSED = ...
    PLAYING = ...

class StateChange(GObject.GEnum):
    NULL_TO_READY = ...
    READY_TO_PAUSED = ...
    PAUSED_TO_PLAYING = ...
    PLAYING_TO_PAUSED = ...
    PAUSED_TO_READY = ...
    READY_TO_NULL = ...
    NULL_TO_NULL = ...
    READY_TO_READY = ...
    PAUSED_TO_PAUSED = ...
    PLAYING_TO_PLAYING = ...
    get_name = ...

class StateChangeReturn(GObject.GEnum):
    FAILURE = ...
    SUCCESS = ...
    ASYNC = ...
    NO_PREROLL = ...

class StreamError(GObject.GEnum):
    FAILED = ...
    TOO_LAZY = ...
    NOT_IMPLEMENTED = ...
    TYPE_NOT_FOUND = ...
    WRONG_TYPE = ...
    CODEC_NOT_FOUND = ...
    DECODE = ...
    ENCODE = ...
    DEMUX = ...
    MUX = ...
    FORMAT = ...
    DECRYPT = ...
    DECRYPT_NOKEY = ...
    NUM_ERRORS = ...
    quark = ...

class StreamStatusType(GObject.GEnum):
    CREATE = ...
    ENTER = ...
    LEAVE = ...
    DESTROY = ...
    START = ...
    PAUSE = ...
    STOP = ...

class StructureChangeType(GObject.GEnum):
    LINK = ...
    UNLINK = ...

class TagFlag(GObject.GEnum):
    UNDEFINED = ...
    META = ...
    ENCODED = ...
    DECODED = ...
    COUNT = ...

class TagMergeMode(GObject.GEnum):
    UNDEFINED = ...
    REPLACE_ALL = ...
    REPLACE = ...
    APPEND = ...
    PREPEND = ...
    KEEP = ...
    KEEP_ALL = ...
    COUNT = ...

class TagScope(GObject.GEnum):
    STREAM = ...
    GLOBAL = ...

class TaskState(GObject.GEnum):
    STARTED = ...
    STOPPED = ...
    PAUSED = ...

class TocEntryType(GObject.GEnum):
    ANGLE = ...
    VERSION = ...
    EDITION = ...
    INVALID = ...
    TITLE = ...
    TRACK = ...
    CHAPTER = ...
    get_nick = ...

class TocLoopType(GObject.GEnum):
    NONE = ...
    FORWARD = ...
    REVERSE = ...
    PING_PONG = ...

class TocScope(GObject.GEnum):
    GLOBAL = ...
    CURRENT = ...

class TracerValueScope(GObject.GEnum):
    PROCESS = ...
    THREAD = ...
    ELEMENT = ...
    PAD = ...

class TypeFindProbability(GObject.GEnum):
    NONE = ...
    MINIMUM = ...
    POSSIBLE = ...
    LIKELY = ...
    NEARLY_CERTAIN = ...
    MAXIMUM = ...

class URIError(GObject.GEnum):
    UNSUPPORTED_PROTOCOL = ...
    BAD_URI = ...
    BAD_STATE = ...
    BAD_REFERENCE = ...
    quark = ...

class URIType(GObject.GEnum):
    UNKNOWN = ...
    SINK = ...
    SRC = ...
