
from __future__ import annotations

from typing import Any, TypeVar
from typing import Callable
from typing import Iterator
from typing import Literal
from typing import Optional
from typing import Tuple
from typing import Union
from typing import overload

from gi.repository import Atk
from gi.repository import Gdk
from gi.repository import GdkPixbuf
from gi.repository import Gio
from gi.repository import GLib
from gi.repository import GObject
from gi.repository import Pango
import cairo

BINARY_AGE: int = ...
INPUT_ERROR: int = ...
INTERFACE_AGE: int = ...
LEVEL_BAR_OFFSET_FULL: str = ...
LEVEL_BAR_OFFSET_HIGH: str = ...
LEVEL_BAR_OFFSET_LOW: str = ...
MAJOR_VERSION: int = ...
MAX_COMPOSE_LEN: int = ...
MICRO_VERSION: int = ...
MINOR_VERSION: int = ...
PAPER_NAME_A3: str = ...
PAPER_NAME_A4: str = ...
PAPER_NAME_A5: str = ...
PAPER_NAME_B5: str = ...
PAPER_NAME_EXECUTIVE: str = ...
PAPER_NAME_LEGAL: str = ...
PAPER_NAME_LETTER: str = ...
PATH_PRIO_MASK: int = ...
PRINT_SETTINGS_COLLATE: str = ...
PRINT_SETTINGS_DEFAULT_SOURCE: str = ...
PRINT_SETTINGS_DITHER: str = ...
PRINT_SETTINGS_DUPLEX: str = ...
PRINT_SETTINGS_FINISHINGS: str = ...
PRINT_SETTINGS_MEDIA_TYPE: str = ...
PRINT_SETTINGS_NUMBER_UP: str = ...
PRINT_SETTINGS_NUMBER_UP_LAYOUT: str = ...
PRINT_SETTINGS_N_COPIES: str = ...
PRINT_SETTINGS_ORIENTATION: str = ...
PRINT_SETTINGS_OUTPUT_BASENAME: str = ...
PRINT_SETTINGS_OUTPUT_BIN: str = ...
PRINT_SETTINGS_OUTPUT_DIR: str = ...
PRINT_SETTINGS_OUTPUT_FILE_FORMAT: str = ...
PRINT_SETTINGS_OUTPUT_URI: str = ...
PRINT_SETTINGS_PAGE_RANGES: str = ...
PRINT_SETTINGS_PAGE_SET: str = ...
PRINT_SETTINGS_PAPER_FORMAT: str = ...
PRINT_SETTINGS_PAPER_HEIGHT: str = ...
PRINT_SETTINGS_PAPER_WIDTH: str = ...
PRINT_SETTINGS_PRINTER: str = ...
PRINT_SETTINGS_PRINTER_LPI: str = ...
PRINT_SETTINGS_PRINT_PAGES: str = ...
PRINT_SETTINGS_QUALITY: str = ...
PRINT_SETTINGS_RESOLUTION: str = ...
PRINT_SETTINGS_RESOLUTION_X: str = ...
PRINT_SETTINGS_RESOLUTION_Y: str = ...
PRINT_SETTINGS_REVERSE: str = ...
PRINT_SETTINGS_SCALE: str = ...
PRINT_SETTINGS_USE_COLOR: str = ...
PRINT_SETTINGS_WIN32_DRIVER_EXTRA: str = ...
PRINT_SETTINGS_WIN32_DRIVER_VERSION: str = ...
PRIORITY_RESIZE: int = ...
STOCK_ABOUT: str = ...
STOCK_ADD: str = ...
STOCK_APPLY: str = ...
STOCK_BOLD: str = ...
STOCK_CANCEL: str = ...
STOCK_CAPS_LOCK_WARNING: str = ...
STOCK_CDROM: str = ...
STOCK_CLEAR: str = ...
STOCK_CLOSE: str = ...
STOCK_COLOR_PICKER: str = ...
STOCK_CONNECT: str = ...
STOCK_CONVERT: str = ...
STOCK_COPY: str = ...
STOCK_CUT: str = ...
STOCK_DELETE: str = ...
STOCK_DIALOG_AUTHENTICATION: str = ...
STOCK_DIALOG_ERROR: str = ...
STOCK_DIALOG_INFO: str = ...
STOCK_DIALOG_QUESTION: str = ...
STOCK_DIALOG_WARNING: str = ...
STOCK_DIRECTORY: str = ...
STOCK_DISCARD: str = ...
STOCK_DISCONNECT: str = ...
STOCK_DND: str = ...
STOCK_DND_MULTIPLE: str = ...
STOCK_EDIT: str = ...
STOCK_EXECUTE: str = ...
STOCK_FILE: str = ...
STOCK_FIND: str = ...
STOCK_FIND_AND_REPLACE: str = ...
STOCK_FLOPPY: str = ...
STOCK_FULLSCREEN: str = ...
STOCK_GOTO_BOTTOM: str = ...
STOCK_GOTO_FIRST: str = ...
STOCK_GOTO_LAST: str = ...
STOCK_GOTO_TOP: str = ...
STOCK_GO_BACK: str = ...
STOCK_GO_DOWN: str = ...
STOCK_GO_FORWARD: str = ...
STOCK_GO_UP: str = ...
STOCK_HARDDISK: str = ...
STOCK_HELP: str = ...
STOCK_HOME: str = ...
STOCK_INDENT: str = ...
STOCK_INDEX: str = ...
STOCK_INFO: str = ...
STOCK_ITALIC: str = ...
STOCK_JUMP_TO: str = ...
STOCK_JUSTIFY_CENTER: str = ...
STOCK_JUSTIFY_FILL: str = ...
STOCK_JUSTIFY_LEFT: str = ...
STOCK_JUSTIFY_RIGHT: str = ...
STOCK_LEAVE_FULLSCREEN: str = ...
STOCK_MEDIA_FORWARD: str = ...
STOCK_MEDIA_NEXT: str = ...
STOCK_MEDIA_PAUSE: str = ...
STOCK_MEDIA_PLAY: str = ...
STOCK_MEDIA_PREVIOUS: str = ...
STOCK_MEDIA_RECORD: str = ...
STOCK_MEDIA_REWIND: str = ...
STOCK_MEDIA_STOP: str = ...
STOCK_MISSING_IMAGE: str = ...
STOCK_NETWORK: str = ...
STOCK_NEW: str = ...
STOCK_NO: str = ...
STOCK_OK: str = ...
STOCK_OPEN: str = ...
STOCK_ORIENTATION_LANDSCAPE: str = ...
STOCK_ORIENTATION_PORTRAIT: str = ...
STOCK_ORIENTATION_REVERSE_LANDSCAPE: str = ...
STOCK_ORIENTATION_REVERSE_PORTRAIT: str = ...
STOCK_PAGE_SETUP: str = ...
STOCK_PASTE: str = ...
STOCK_PREFERENCES: str = ...
STOCK_PRINT: str = ...
STOCK_PRINT_ERROR: str = ...
STOCK_PRINT_PAUSED: str = ...
STOCK_PRINT_PREVIEW: str = ...
STOCK_PRINT_REPORT: str = ...
STOCK_PRINT_WARNING: str = ...
STOCK_PROPERTIES: str = ...
STOCK_QUIT: str = ...
STOCK_REDO: str = ...
STOCK_REFRESH: str = ...
STOCK_REMOVE: str = ...
STOCK_REVERT_TO_SAVED: str = ...
STOCK_SAVE: str = ...
STOCK_SAVE_AS: str = ...
STOCK_SELECT_ALL: str = ...
STOCK_SELECT_COLOR: str = ...
STOCK_SELECT_FONT: str = ...
STOCK_SORT_ASCENDING: str = ...
STOCK_SORT_DESCENDING: str = ...
STOCK_SPELL_CHECK: str = ...
STOCK_STOP: str = ...
STOCK_STRIKETHROUGH: str = ...
STOCK_UNDELETE: str = ...
STOCK_UNDERLINE: str = ...
STOCK_UNDO: str = ...
STOCK_UNINDENT: str = ...
STOCK_YES: str = ...
STOCK_ZOOM_100: str = ...
STOCK_ZOOM_FIT: str = ...
STOCK_ZOOM_IN: str = ...
STOCK_ZOOM_OUT: str = ...
STYLE_CLASS_ACCELERATOR: str = ...
STYLE_CLASS_ARROW: str = ...
STYLE_CLASS_BACKGROUND: str = ...
STYLE_CLASS_BOTTOM: str = ...
STYLE_CLASS_BUTTON: str = ...
STYLE_CLASS_CALENDAR: str = ...
STYLE_CLASS_CELL: str = ...
STYLE_CLASS_CHECK: str = ...
STYLE_CLASS_COMBOBOX_ENTRY: str = ...
STYLE_CLASS_CONTEXT_MENU: str = ...
STYLE_CLASS_CSD: str = ...
STYLE_CLASS_CURSOR_HANDLE: str = ...
STYLE_CLASS_DEFAULT: str = ...
STYLE_CLASS_DESTRUCTIVE_ACTION: str = ...
STYLE_CLASS_DIM_LABEL: str = ...
STYLE_CLASS_DND: str = ...
STYLE_CLASS_DOCK: str = ...
STYLE_CLASS_ENTRY: str = ...
STYLE_CLASS_ERROR: str = ...
STYLE_CLASS_EXPANDER: str = ...
STYLE_CLASS_FLAT: str = ...
STYLE_CLASS_FRAME: str = ...
STYLE_CLASS_GRIP: str = ...
STYLE_CLASS_HEADER: str = ...
STYLE_CLASS_HIGHLIGHT: str = ...
STYLE_CLASS_HORIZONTAL: str = ...
STYLE_CLASS_IMAGE: str = ...
STYLE_CLASS_INFO: str = ...
STYLE_CLASS_INLINE_TOOLBAR: str = ...
STYLE_CLASS_INSERTION_CURSOR: str = ...
STYLE_CLASS_LABEL: str = ...
STYLE_CLASS_LEFT: str = ...
STYLE_CLASS_LEVEL_BAR: str = ...
STYLE_CLASS_LINKED: str = ...
STYLE_CLASS_LIST: str = ...
STYLE_CLASS_LIST_ROW: str = ...
STYLE_CLASS_MARK: str = ...
STYLE_CLASS_MENU: str = ...
STYLE_CLASS_MENUBAR: str = ...
STYLE_CLASS_MENUITEM: str = ...
STYLE_CLASS_MESSAGE_DIALOG: str = ...
STYLE_CLASS_MONOSPACE: str = ...
STYLE_CLASS_NEEDS_ATTENTION: str = ...
STYLE_CLASS_NOTEBOOK: str = ...
STYLE_CLASS_OSD: str = ...
STYLE_CLASS_OVERSHOOT: str = ...
STYLE_CLASS_PANE_SEPARATOR: str = ...
STYLE_CLASS_PAPER: str = ...
STYLE_CLASS_POPOVER: str = ...
STYLE_CLASS_POPUP: str = ...
STYLE_CLASS_PRIMARY_TOOLBAR: str = ...
STYLE_CLASS_PROGRESSBAR: str = ...
STYLE_CLASS_PULSE: str = ...
STYLE_CLASS_QUESTION: str = ...
STYLE_CLASS_RADIO: str = ...
STYLE_CLASS_RAISED: str = ...
STYLE_CLASS_READ_ONLY: str = ...
STYLE_CLASS_RIGHT: str = ...
STYLE_CLASS_RUBBERBAND: str = ...
STYLE_CLASS_SCALE: str = ...
STYLE_CLASS_SCALE_HAS_MARKS_ABOVE: str = ...
STYLE_CLASS_SCALE_HAS_MARKS_BELOW: str = ...
STYLE_CLASS_SCROLLBAR: str = ...
STYLE_CLASS_SCROLLBARS_JUNCTION: str = ...
STYLE_CLASS_SEPARATOR: str = ...
STYLE_CLASS_SIDEBAR: str = ...
STYLE_CLASS_SLIDER: str = ...
STYLE_CLASS_SPINBUTTON: str = ...
STYLE_CLASS_SPINNER: str = ...
STYLE_CLASS_STATUSBAR: str = ...
STYLE_CLASS_SUBTITLE: str = ...
STYLE_CLASS_SUGGESTED_ACTION: str = ...
STYLE_CLASS_TITLE: str = ...
STYLE_CLASS_TITLEBAR: str = ...
STYLE_CLASS_TOOLBAR: str = ...
STYLE_CLASS_TOOLTIP: str = ...
STYLE_CLASS_TOP: str = ...
STYLE_CLASS_TOUCH_SELECTION: str = ...
STYLE_CLASS_TROUGH: str = ...
STYLE_CLASS_UNDERSHOOT: str = ...
STYLE_CLASS_VERTICAL: str = ...
STYLE_CLASS_VIEW: str = ...
STYLE_CLASS_WARNING: str = ...
STYLE_CLASS_WIDE: str = ...
STYLE_PROPERTY_BACKGROUND_COLOR: str = ...
STYLE_PROPERTY_BACKGROUND_IMAGE: str = ...
STYLE_PROPERTY_BORDER_COLOR: str = ...
STYLE_PROPERTY_BORDER_RADIUS: str = ...
STYLE_PROPERTY_BORDER_STYLE: str = ...
STYLE_PROPERTY_BORDER_WIDTH: str = ...
STYLE_PROPERTY_COLOR: str = ...
STYLE_PROPERTY_FONT: str = ...
STYLE_PROPERTY_MARGIN: str = ...
STYLE_PROPERTY_PADDING: str = ...
STYLE_PROVIDER_PRIORITY_APPLICATION: int = ...
STYLE_PROVIDER_PRIORITY_FALLBACK: int = ...
STYLE_PROVIDER_PRIORITY_SETTINGS: int = ...
STYLE_PROVIDER_PRIORITY_THEME: int = ...
STYLE_PROVIDER_PRIORITY_USER: int = ...
STYLE_REGION_COLUMN: str = ...
STYLE_REGION_COLUMN_HEADER: str = ...
STYLE_REGION_ROW: str = ...
STYLE_REGION_TAB: str = ...
TEXT_VIEW_PRIORITY_VALIDATE: int = ...
TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID: int = ...
TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID: int = ...
_introspection_module = ...
_namespace: str = ...
_overrides_module = ...
_version: str = ...

AccelGroupFindFunc = Callable[..., bool]
PageSetupDoneFunc = Callable[..., None]

def accel_groups_activate(object: GObject.Object, accel_key: int, accel_mods: Gdk.ModifierType) -> bool: ...
def accel_groups_from_object(object: GObject.Object) -> list[AccelGroup]: ...
def accelerator_get_default_mod_mask() -> Gdk.ModifierType: ...
def accelerator_get_label(accelerator_key: int, accelerator_mods: Gdk.ModifierType) -> str: ...
def accelerator_get_label_with_keycode(display: Optional[Gdk.Display], accelerator_key: int, keycode: int, accelerator_mods: Gdk.ModifierType) -> str: ...
def accelerator_name(accelerator_key: int, accelerator_mods: Gdk.ModifierType) -> str: ...
def accelerator_name_with_keycode(display: Optional[Gdk.Display], accelerator_key: int, keycode: int, accelerator_mods: Gdk.ModifierType) -> str: ...
def accelerator_parse(accelerator: str) -> 	tuple[int, Gdk.ModifierType]: ...
def accelerator_parse_with_keycode(accelerator: str) -> tuple[int, list[int], Gdk.ModifierType]: ...
def accelerator_set_default_mod_mask(default_mod_mask: Gdk.ModifierType) -> None: ...
def accelerator_valid(keyval: int, modifiers: Gdk.ModifierType) -> bool: ...
def alternative_dialog_button_order(screen: Optional[Gdk.Screen]) -> bool: ...
def binding_entry_add_signal_from_string(binding_set: BindingSet, signal_desc: str) -> GLib.TokenType: ...
def binding_entry_add_signall(binding_set: BindingSet, keyval: int, modifiers: Gdk.ModifierType, signal_name: str, binding_args: list[BindingArg]) -> None: ...
def binding_entry_remove(binding_set: BindingSet, keyval: int, modifiers: Gdk.ModifierType) -> None: ...
def binding_entry_skip(binding_set: BindingSet, keyval: int, modifiers: Gdk.ModifierType) -> None: ...
def binding_set_find(set_name: str) -> Optional[BindingSet]: ...
def bindings_activate(object: GObject.Object, keyval: int, modifiers: Gdk.ModifierType) -> bool: ...
def bindings_activate_event(object: GObject.Object, event: Gdk.EventKey) -> bool: ...
def builder_error_quark() -> int: ...
def cairo_should_draw_window(cr: cairo.Context, window: Gdk.Window) -> bool: ...
def cairo_transform_to_window(cr: cairo.Context, widget: Widget, window: Gdk.Window) -> None: ...
def check_version(required_major: int, required_minor: int, required_micro: int) -> Optional[str]: ...
def css_provider_error_quark() -> int: ...
def device_grab_add(widget: Widget, device: Gdk.Device, block_others: bool) -> None: ...
def device_grab_remove(widget: Widget, device: Gdk.Device) -> None: ...
def disable_setlocale() -> None: ...
def distribute_natural_allocation(extra_space: int, n_requested_sizes: int, sizes: RequestedSize) -> int: ...
def drag_cancel(context: Gdk.DragContext) -> None: ...
def drag_finish(context: Gdk.DragContext, success: bool, delete: bool, time: int) -> None: ...
def drag_get_source_widget(context: Gdk.DragContext) -> Optional[Widget]: ...
def drag_set_icon_default(context: Gdk.DragContext) -> None: ...
def drag_set_icon_gicon(context: Gdk.DragContext, icon: Gio.Icon, hot_x: int, hot_y: int) -> None: ...
def drag_set_icon_name(context: Gdk.DragContext, icon_name: str, hot_x: int, hot_y: int) -> None: ...
def drag_set_icon_pixbuf(context: Gdk.DragContext, pixbuf: GdkPixbuf.Pixbuf, hot_x: int, hot_y: int) -> None: ...
def drag_set_icon_stock(context: Gdk.DragContext, stock_id: str, hot_x: int, hot_y: int) -> None: ...
def drag_set_icon_surface(context: Gdk.DragContext, surface: cairo.Surface) -> None: ...
def drag_set_icon_widget(context: Gdk.DragContext, widget: Widget, hot_x: int, hot_y: int) -> None: ...
def draw_insertion_cursor(widget: Widget, cr: cairo.Context, location: Gdk.Rectangle, is_primary: bool, direction: TextDirection, draw_arrow: bool) -> None: ...
def events_pending() -> bool: ...
def false() -> False: ...
def file_chooser_error_quark() -> int: ...
def get_binary_age() -> int: ...
def get_current_event() -> Optional[Gdk.Event]: ...
def get_current_event_device() -> Optional[Gdk.Device]: ...
def get_current_event_state() -> bool: ...
def get_current_event_time() -> int: ...
def get_debug_flags() -> int: ...
def get_default_language() -> Pango.Language: ...
def get_event_widget(event: Gdk.Event) -> Optional[Widget]: ...
def get_interface_age() -> int: ...
def get_locale_direction() -> TextDirection: ...
def get_major_version() -> int: ...
def get_micro_version() -> int: ...
def get_minor_version() -> int: ...
def get_option_group(open_default_display: bool) -> GLib.OptionGroup: ...
def grab_get_current() -> Optional[Widget]: ...
def icon_size_from_name(name: str) -> int: ...
def icon_size_get_name(size: int) -> str: ...
def icon_size_lookup(size: int): ...
def icon_size_lookup_for_settings(settings: Settings, size: int) -> tuple[bool, int, int]: ...
def icon_size_register(name: str, width: int, height: int) -> int: ...
def icon_size_register_alias(alias: str, target: int) -> None: ...
def icon_theme_error_quark() -> int: ...
def init(argv: Optional[list[str]]) -> str: ...
def init_check(argv: Optional[list[str]]) -> tuple[bool, list[int]]: ...
def init_with_args(argv: Optional[list[str]], parameter_string: Optional[str], entries: Optional[list[GLib.OptionEntry]], translation_domain: Optional[str]) -> tuple[bool, list[str]]: ...
def key_snooper_remove(snooper_handler_id: int) -> None: ...
def main() -> None: ...
def main_do_event(event: Gdk.Event) -> None: ...
def main_iteration() -> bool: ...
def main_iteration_do(blocking: bool) -> bool: ...
def main_level() -> int: ...
def main_quit() -> None: ...
def paint_arrow(*args, **kwargs): ...
def paint_box(*args, **kwargs): ...
def paint_box_gap(*args, **kwargs): ...
def paint_check(*args, **kwargs): ...
def paint_diamond(*args, **kwargs): ...
def paint_expander(*args, **kwargs): ...
def paint_extension(*args, **kwargs): ...
def paint_flat_box(*args, **kwargs): ...
def paint_focus(*args, **kwargs): ...
def paint_handle(*args, **kwargs): ...
def paint_hline(*args, **kwargs): ...
def paint_layout(*args, **kwargs): ...
def paint_option(*args, **kwargs): ...
def paint_resize_grip(*args, **kwargs): ...
def paint_shadow(*args, **kwargs): ...
def paint_shadow_gap(*args, **kwargs): ...
def paint_slider(*args, **kwargs): ...
def paint_spinner(*args, **kwargs): ...
def paint_tab(*args, **kwargs): ...
def paint_vline(*args, **kwargs): ...
def paper_size_get_default() -> str: ...
def paper_size_get_paper_sizes(include_custom: bool) -> list[PaperSize]: ...
def parse_args(argv: list[str]) -> tuple[bool, list[str]]: ...
def print_error_quark() -> int: ...
def print_run_page_setup_dialog(parent: Optional[Window], page_setup: Optional[PageSetup], settings: PrintSettings) -> PageSetup: ...
def print_run_page_setup_dialog_async(parent: Optional[Window], page_setup: Optional[PageSetup], settings: PrintSettings, done_cb: PageSetupDoneFunc, *data: Optional[object]) -> None: ...
def propagate_event(widget: Widget, event: Gdk.Event) -> None: ...
def rc_add_default_file(*args, **kwargs): ...
def rc_find_module_in_path(*args, **kwargs): ...
def rc_find_pixmap_in_path(*args, **kwargs): ...
def rc_get_default_files(*args, **kwargs): ...
def rc_get_im_module_file(*args, **kwargs): ...
def rc_get_im_module_path(*args, **kwargs): ...
def rc_get_module_dir(*args, **kwargs): ...
def rc_get_style(*args, **kwargs): ...
def rc_get_style_by_paths(*args, **kwargs): ...
def rc_get_theme_dir(*args, **kwargs): ...
def rc_parse(*args, **kwargs): ...
def rc_parse_color(*args, **kwargs): ...
def rc_parse_color_full(*args, **kwargs): ...
def rc_parse_priority(*args, **kwargs): ...
def rc_parse_state(*args, **kwargs): ...
def rc_parse_string(*args, **kwargs): ...
def rc_property_parse_border(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> bool: ...
def rc_property_parse_color(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> bool: ...
def rc_property_parse_enum(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> bool: ...
def rc_property_parse_flags(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> bool: ...
def rc_property_parse_requisition(pspec: GObject.ParamSpec, gstring: GLib.String, property_value: GObject.Value) -> bool: ...
def rc_reparse_all(*args, **kwargs): ...
def rc_reparse_all_for_settings(*args, **kwargs): ...
def rc_reset_styles(*args, **kwargs): ...
def rc_set_default_files(*args, **kwargs): ...
def recent_chooser_error_quark() -> int: ...
def recent_manager_error_quark() -> int: ...
def render_activity(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float) -> None: ...
def render_arrow(context: StyleContext, cr: cairo.Context, angle: float, x: float, y: float, size: float) -> None: ...
def render_background(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float) -> None: ...
def render_background_get_clip(cr: cairo.Context, x: float, y: float, width: float, height: float) -> Gdk.Rectangle: ...
def render_check(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float) -> None: ...
def render_expander(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float) -> None: ...
def render_extension(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float, gap_side: PositionType) -> None: ...
def render_focus(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float) -> None: ...
def render_frame(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float) -> None: ...
def render_frame_gap(*args, **kwargs): ...
def render_handle(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float) -> None: ...
def render_icon(context: StyleContext, cr: cairo.Context, pixbuf: GdkPixbuf.Pixbuf, x: float, y: float) -> None: ...
def render_icon_pixbuf(*args, **kwargs): ...
def render_icon_surface(context: StyleContext, cr: cairo.Context, surface: cairo.Surface, x: float, y: float) -> None: ...
def render_insertion_cursor(context: StyleContext, cr: cairo.Context, x: float, y: float, layout: Pango.Layout, index: int, direction: Pango.Direction) -> None: ...
def render_layout(context: StyleContext, cr: cairo.Context, x: float, y: float, layout: Pango.Layout) -> None: ...
def render_line(context: StyleContext, cr: cairo.Context, x0: float, y0: float, x1: float, y1: float) -> None: ...
def render_option(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float) -> None: ...
def render_slider(context: StyleContext, cr: cairo.Context, x: float, y: float, width: float, height: float, orientation: Orientation) -> None: ...
def rgb_to_hsv(r: float, g: float, b: float) -> tuple[float, float, float]: ...
def selection_add_target(widget: Widget, selection: Gdk.Atom, target: Gdk.Atom, info: int) -> None: ...
def selection_add_targets(widget: Widget, selection: Gdk.Atom, targets: list[TargetEntry]) -> None: ...
def selection_clear_targets(widget: Widget, selection: Gdk.Atom) -> None: ...
def selection_convert(widget: Widget, selection: Gdk.Atom, target: Gdk.Atom, time: int) -> bool: ...
def selection_owner_set(widget: Optional[Widget], selection: Gdk.Atom, time: int) -> bool: ...
def selection_owner_set_for_display(display: Gdk.Display, widget: Optional[Widget], selection: Gdk.Atom, time: int) -> bool: ...
def selection_remove_all(widget: Widget) -> None: ...
def set_debug_flags(flags: int) -> None: ...
def show_uri(*args, **kwrags): ...
def show_uri_on_window(parent: Optional[Window], uri: str, timestamp: int) -> bool: ...
def stock_add(*args, **kwargs): ...
def stock_add_static(*args, **kwargs): ...
def stock_list_ids(*args, **kwargs): ...
def stock_lookup(*args, **kwargs): ...
def stock_set_translate_func(*args, **kwargs): ...
def target_table_free(targets: list[TargetEntry]) -> None: ...
def target_table_new_from_list(list: TargetList) -> list[TargetEntry]: ...
def targets_include_image(targets: list[Gdk.Atom], writable: bool) -> bool: ...
def targets_include_rich_text(targets: list[Gdk.Atom], buffer: TextBuffer) -> bool: ...
def targets_include_text(targets: list[Gdk.Atom]) -> bool: ...
def targets_include_uri(targets: list[Gdk.Atom]) -> bool: ...
def test_create_simple_window(*args, **kwargs): ...
def test_find_label(widget: Widget, label_pattern: str) -> Widget: ...
def test_find_sibling(base_widget: Widget, widget_type: GObject.GType) -> Widget: ...
def test_find_widget(widget: Widget, label_pattern: str, widget_type: GObject.GType) -> Optional[Widget]: ...
def test_list_all_types() -> list[GObject.GType]: ...
def test_register_all_types() -> None: ...
def test_slider_get_value(*args, **kwargs): ...
def test_slider_set_perc(*args, **kwargs): ...
def test_spin_button_click(*args, **kwargs): ...
def test_text_get(*args, **kwargs): ...
def test_text_set(*args, **kwargs): ...
def test_widget_click(*args, **kwargs): ...
def test_widget_send_key(widget: Widget, keyval: int, modifiers: Gdk.ModifierType) -> bool: ...
def test_widget_wait_for_draw(widget: Widget) -> None: ...
def tree_get_row_drag_data(selection_data: SelectionData) -> tuple[bool, Optional[TreeModel], Optional[TreePath]]: ...
def tree_row_reference_deleted(proxy: GObject.Object, path: TreePath) -> None: ...
def tree_row_reference_inserted(proxy: GObject.Object, path: TreePath) -> None: ...
def tree_set_row_drag_data(selection_data: SelectionData, tree_model: TreeModel, path: TreePath) -> bool: ...
def true() -> bool: ...


class AboutDialog(Dialog):
    def add_credit_section(self, section_name: str, people: list[str]) -> None: ...
    def get_artists(self) -> list[str]: ...
    def get_authors(self) -> list[str]: ...
    def get_comments(self) -> str: ...
    def get_copyright(self) -> str: ...
    def get_documenters(self) -> list[str]: ...
    def get_license(self) -> str: ...
    def get_license_type(self) -> License: ...
    def get_logo(self) -> GdkPixbuf.Pixbuf: ...
    def get_logo_icon_name(self) -> str: ...
    def get_program_name(self) -> str: ...
    def get_translator_credits(self) -> str: ...
    def get_version(self) -> str: ...
    def get_website(self) -> str: ...
    def get_website_label(self) -> str: ...
    def get_wrap_license(self) -> bool: ...
    def set_artists(self, artists: list[str]) -> None: ...
    def set_authors(self, authors: list[str]) -> None: ...
    def set_comments(self, comments: Optional[str]) -> None: ...
    def set_copyright(self, copyright: Optional[str]) -> None: ...
    def set_documenters(self, documenters: list[str]) -> None: ...
    def set_license(self, license: Optional[str]) -> None: ...
    def set_license_type(self, license_type: License) -> None: ...
    def set_logo(self, logo: Optional[GdkPixbuf.Pixbuf]) -> None: ...
    def set_logo_icon_name(self, logo_icon_name: Optional[str]) -> None: ...
    def set_program_name(self, name: str) -> None: ...
    def set_translator_credits(self, translator_credits: Optional[str]) -> None: ...
    def set_version(self, version: Optional[str]) -> None: ...
    def set_website(self, website: Optional[str]) -> None: ...
    def set_website_label(self, website_label: str) -> None: ...
    def set_wrap_license(self, wrap_license: bool) -> None: ...

    def do_activate_link(self, uri: str) -> bool: ...
    

class AccelGroup(GObject.Object):
    parent = ...
    priv = ...
    
    def activate(self, accel_quark: int, acceleratable: GObject.Object, accel_key: int, accel_mods: Gdk.ModifierType) -> bool: ...
    def connect(self, accel_key: int, accel_mods: Gdk.ModifierType, accel_flags: AccelFlags, closure: GObject.Closure) -> None: ...
    def connect_by_path(self, accel_path: str, closure: GObject.Closure) -> None: ...
    def disconnect(self, closure: Optional[GObject.Closure]) -> bool: ...
    def disconnect_key(self, accel_key: int, accel_mods: Gdk.ModifierType) -> bool: ...
    def find(self, ind_func: AccelGroupFindFunc, *data: Optional[object]) -> AccelKey: ...
    def get_is_locked(self) -> bool: ...
    def get_modifier_mask(self) -> Gdk.ModifierType: ...
    def lock(self) -> None: ...
    def query(self, accel_key: int, accel_mods: Gdk.ModifierType) -> Optional[list[AccelGroupEntry]]: ...
    def unlock(self) -> None: ...
    
    def do_accel_changed(self, keyval: int, modifier: Gdk.ModifierType, accel_closure: GObject.Closure) -> None: ...
    

class AccelGroupEntry:
    accel_path_quark = ...
    closure = ...
    key = ...
    

class AccelKey:
    accel_flags = ...
    accel_key = ...
    accel_mods = ...
    

class AccelLabel(Label):
    label: Label = ...
    
    def get_accel(self) -> 	tuple[int, Gdk.ModifierType]: ...
    def get_accel_widget(self) -> Optional[Widget]: ...
    def get_accel_width(self) -> int: ...
    def refetch(self) -> bool: ...
    def set_accel(self, accelerator_key: int, accelerator_mods: Gdk.ModifierType) -> None: ...
    def set_accel_closure(self, accel_closure: GObject.Closure) -> None: ...
    def set_accel_widget(accel_widget: Optional[Widget]) -> None: ...
    

class AccelMap(GObject.Object):
    def add_entry(*args, **kwargs): ...
    def add_filter(*args, **kwargs): ...
    def change_entry(*args, **kwargs): ...
    def foreach(*args, **kwargs): ...
    def foreach_unfiltered(*args, **kwargs): ...
    def get(*args, **kwargs): ...
    def load(*args, **kwargs): ...
    def load_fd(*args, **kwargs): ...
    def load_scanner(*args, **kwargs): ...
    def lock_path(*args, **kwargs): ...
    def lookup_entry(*args, **kwargs): ...
    def save(*args, **kwargs): ...
    def save_fd(*args, **kwargs): ...
    def unlock_path(*args, **kwargs): ...
    

class Action(Buildable, GObject.Object):
    object = ...
    private_data = ...
    
    def activate(*args, **kwargs): ...
    def block_activate(*args, **kwargs): ...
    def connect_accelerator(*args, **kwargs): ...
    def create_icon(*args, **kwargs): ...
    def create_menu(*args, **kwargs): ...
    def create_menu_item(*args, **kwargs): ...
    def create_tool_item(*args, **kwargs): ...
    def disconnect_accelerator(*args, **kwargs): ...
    def get_accel_closure(*args, **kwargs): ...
    def get_accel_path(*args, **kwargs): ...
    def get_always_show_image(*args, **kwargs): ...
    def get_gicon(*args, **kwargs): ...
    def get_icon_name(*args, **kwargs): ...
    def get_is_important(*args, **kwargs): ...
    def get_label(*args, **kwargs): ...
    def get_proxies(*args, **kwargs): ...
    def get_sensitive(*args, **kwargs): ...
    def get_short_label(*args, **kwargs): ...
    def get_stock_id(*args, **kwargs): ...
    def get_tooltip(*args, **kwargs): ...
    def get_visible(*args, **kwargs): ...
    def get_visible_horizontal(*args, **kwargs): ...
    def get_visible_vertical(*args, **kwargs): ...
    def is_sensitive(*args, **kwargs): ...
    def is_visible(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_accel_group(*args, **kwargs): ...
    def set_accel_path(*args, **kwargs): ...
    def set_always_show_image(*args, **kwargs): ...
    def set_gicon(*args, **kwargs): ...
    def set_icon_name(*args, **kwargs): ...
    def set_is_important(*args, **kwargs): ...
    def set_label(*args, **kwargs): ...
    def set_sensitive(*args, **kwargs): ...
    def set_short_label(*args, **kwargs): ...
    def set_stock_id(*args, **kwargs): ...
    def set_tooltip(*args, **kwargs): ...
    def set_visible(*args, **kwargs): ...
    def set_visible_horizontal(*args, **kwargs): ...
    def set_visible_vertical(*args, **kwargs): ...
    def unblock_activate(*args, **kwargs): ...
    
    def do_activate(self, *args, **kwargs): ...
    def do_connect_proxy(self, *args, **kwargs): ...
    def do_create_menu(self, *args, **kwargs): ...
    def do_create_menu_item(self, *args, **kwargs): ...
    def do_create_tool_item(self, *args, **kwargs): ...
    def do_disconnect_proxy(self, *args, **kwargs): ...
    

class ActionBar(Bin):
    bin = ...
    
    def get_center_widget(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def pack_end(self, child: Widget) -> None: ...
    def pack_start(self, child: Widget) -> None: ...
    def set_center_widget(*args, **kwargs): ...
    

class ActionEntry:
    accelerator = str
    callback = ...
    label = str
    name = str
    stock_id = str
    tooltip = str
    

class ActionGroup(Buildable, GObject.Object):
    parent = ...
    priv = ...
    
    def add_action(*args, **kwargs): ...
    def add_action_with_accel(*args, **kwargs): ...
    def add_actions(*args, **kwargs): ...
    def add_radio_actions(*args, **kwargs): ...
    def add_toggle_actions(*args, **kwargs): ...
    def get_accel_group(*args, **kwargs): ...
    def get_action(*args, **kwargs): ...
    def get_sensitive(*args, **kwargs): ...
    def get_visible(*args, **kwargs): ...
    def list_actions(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def remove_action(*args, **kwargs): ...
    def set_accel_group(*args, **kwargs): ...
    def set_sensitive(*args, **kwargs): ...
    def set_translate_func(*args, **kwargs): ...
    def set_translation_domain(*args, **kwargs): ...
    def set_visible(*args, **kwargs): ...
    def translate_string(*args, **kwargs): ...
    
    def do_get_action(self, *args, **kwargs): ...


class Actionable(GObject.GInterface):
    def get_action_name(*args, **kwargs): ...
    def get_action_target_value(*args, **kwargs): ...
    def set_action_name(self, name: Optional[str]) -> None: ...
    def set_action_target_value(self, target_value: Optional[GLib.Variant]) -> None: ...
    def set_detailed_action_name(self, detailed_action_name: str) -> None: ...
    

class ActionableInterface:
    g_iface = ...
    get_action_name = ...
    get_action_target_value = ...
    set_action_name = ...
    set_action_target_value = ...
    

class Activatable(GObject.GInterface):
    def do_set_related_action(*args, **kwargs): ...
    def get_related_action(*args, **kwargs): ...
    def get_use_action_appearance(*args, **kwargs): ...
    def set_related_action(*args, **kwargs): ...
    def set_use_action_appearance(*args, **kwargs): ...
    def sync_action_properties(*args, **kwargs): ...


class Adjustment(GObject.InitiallyUnowned):
    parent_instance = ...
    priv = ...

    def __init__(self, value: float = 0.0, lower: float = 0.0, upper: float = 0.0, step_increment: float = 0.0, page_increment: float = 0.0, page_size: float = 0.0) -> None: ...
    def changed(*args, **kwargs): ...
    def clamp_page(*args, **kwargs): ...
    def configure(*args, **kwargs): ...
    def get_lower(self) -> float: ...
    def get_minimum_increment(*args, **kwargs): ...
    def get_page_increment(*args, **kwargs): ...
    def get_page_size(self) -> float: ...
    def get_step_increment(*args, **kwargs): ...
    def get_upper(self) -> float: ...
    def get_value(self) -> float: ...
    def new(*args, **kwargs): ...
    def set_lower(*args, **kwargs): ...
    def set_page_increment(*args, **kwargs): ...
    def set_page_size(*args, **kwargs): ...
    def set_step_increment(*args, **kwargs): ...
    def set_upper(*args, **kwargs): ...
    def set_value(self, value: float) -> None: ...
    def value_changed(*args, **kwargs): ...
    
    def do_changed(self, *args, **kwargs): ...
    def do_value_changed(self, *args, **kwargs): ...
    

class Alignment(Bin):
    bin = ...
    
    def get_padding(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set(*args, **kwargs): ...
    def set_padding(*args, **kwargs): ...
    

class AppChooser(GObject.GInterface):
    def get_app_info(*args, **kwargs): ...
    def get_content_type(*args, **kwargs): ...
    def refresh(*args, **kwargs): ...
    

class AppChooserButton(AppChooser, ComboBox):
    parent = ...
    
    def append_custom_item(*args, **kwargs): ...
    def append_separator(*args, **kwargs): ...
    def get_heading(*args, **kwargs): ...
    def get_show_default_item(*args, **kwargs): ...
    def get_show_dialog_item(*args, **kwargs): ...
    def set_active_custom_item(*args, **kwargs): ...
    def set_heading(*args, **kwargs): ...
    def set_show_default_item(*args, **kwargs): ...
    def set_show_dialog_item(*args, **kwargs): ...
    
    def do_custom_item_activated(self, *args, **kwargs): ...
    

class AppChooserDialog(AppChooser, Dialog):
    parent = ...
    
    def get_heading(*args, **kwargs): ...
    def get_widget(*args, **kwargs): ...
    def new_for_content_type(*args, **kwargs): ...
    def set_heading(*args, **kwargs): ...
    

class AppChooserWidget(AppChooser, Box):
    parent = ...
    
    def get_default_text(*args, **kwargs): ...
    def get_show_all(*args, **kwargs): ...
    def get_show_default(*args, **kwargs): ...
    def get_show_fallback(*args, **kwargs): ...
    def get_show_other(*args, **kwargs): ...
    def get_show_recommended(*args, **kwargs): ...
    def set_default_text(*args, **kwargs): ...
    def set_show_all(*args, **kwargs): ...
    def set_show_default(*args, **kwargs): ...
    def set_show_fallback(*args, **kwargs): ...
    def set_show_other(*args, **kwargs): ...
    def set_show_recommended(*args, **kwargs): ...
    
    def do_application_activated(self, *args, **kwargs): ...
    def do_application_selected(self, *args, **kwargs): ...
    def do_populate_popup(self, *args, **kwargs): ...
    

class Application(Gio.Application):
    parent = ...

    class Props:
        active_window: Window
        app_menu: Gio.MenuModel
        menubar: Gio.MenuModel
        register_session: bool
        screensaver_active: bool

    props: Props

    def __init__(self, application_id: Optional[str] = None, flags: Optional[Gio.ApplicationFlags] = None) -> None: ...
    def add_accelerator(*args, **kwargs): ...
    def add_window(*args, **kwargs): ...
    def get_accels_for_action(*args, **kwargs): ...
    def get_actions_for_accel(*args, **kwargs): ...
    def get_active_window(self) -> Optional[Window]: ...
    def get_app_menu(self) -> Optional[Gio.MenuModel]: ...
    def get_menu_by_id(*args, **kwargs): ...
    def get_menubar(self) -> Gio.MenuModel: ...
    def get_window_by_id(*args, **kwargs): ...
    def get_windows(self) -> list[Window]: ...
    def inhibit(*args, **kwargs): ...
    def is_inhibited(*args, **kwargs): ...
    def list_action_descriptions(*args, **kwargs): ...
    def prefers_app_menu(self) -> bool: ...
    def remove_accelerator(*args, **kwargs): ...
    def remove_window(*args, **kwargs): ...
    def set_accels_for_action(self, detailed_action_name: str, accels: list[str]) -> None: ...
    def set_app_menu(*args, **kwargs): ...
    def set_menubar(self, menubar: Optional[Gio.MenuModel]) -> None: ...
    def uninhibit(*args, **kwargs): ...
    
    def do_window_added(self, *args, **kwargs): ...
    def do_window_removed(self, *args, **kwargs): ...


class ApplicationWindow(Gio.ActionGroup, Gio.ActionMap, Window):
    def get_help_overlay(*args, **kwargs): ...
    def get_id(*args, **kwargs): ...
    def get_show_menubar(*args, **kwargs): ...
    def set_help_overlay(*args, **kwargs): ...
    def set_show_menubar(self, show_menubar: bool) -> None: ...
    

class Arrow(Misc):
    misc = ...
    
    def new(*args, **kwargs): ...
    def set(*args, **kwargs): ...
    

class AspectFrame(Frame):
    frame = ...
    
    def set(*args, **kwargs): ...
    

class Assistant(Window):
    parent = ...
    
    def add_action_widget(*args, **kwargs): ...
    def append_page(*args, **kwargs): ...
    def commit(*args, **kwargs): ...
    def get_current_page(*args, **kwargs): ...
    def get_n_pages(*args, **kwargs): ...
    def get_nth_page(*args, **kwargs): ...
    def get_page_complete(*args, **kwargs): ...
    def get_page_has_padding(*args, **kwargs): ...
    def get_page_header_image(*args, **kwargs): ...
    def get_page_side_image(*args, **kwargs): ...
    def get_page_title(*args, **kwargs): ...
    def get_page_type(*args, **kwargs): ...
    def insert_page(*args, **kwargs): ...
    def next_page(*args, **kwargs): ...
    def prepend_page(*args, **kwargs): ...
    def previous_page(*args, **kwargs): ...
    def remove_action_widget(*args, **kwargs): ...
    def remove_page(*args, **kwargs): ...
    def set_current_page(self, page_num: int) -> None: ...
    def set_forward_page_func(*args, **kwargs): ...
    def set_page_complete(*args, **kwargs): ...
    def set_page_has_padding(*args, **kwargs): ...
    def set_page_header_image(*args, **kwargs): ...
    def set_page_side_image(*args, **kwargs): ...
    def set_page_title(*args, **kwargs): ...
    def set_page_type(*args, **kwargs): ...
    def update_buttons_state(*args, **kwargs): ...
    
    def do_apply(self, *args, **kwargs): ...
    def do_cancel(self, *args, **kwargs): ...
    def do_close(self, *args, **kwargs): ...
    def do_prepare(self, *args, **kwargs): ...
    

class Bin(Container):
    container = ...
    
    def get_child(self) -> Any: ...
    

class BindingArg:
    arg_type = GObject.GType
    

class BindingEntry:
    binding_set = BindingSet
    destroyed = int
    hash_next = BindingEntry
    in_emission = int
    keyval = int
    marks_unbound = int
    modifiers = Gdk.ModifierType
    set_next = BindingEntry
    signals = BindingSignal
    
    def add_signal_from_string(*args, **kwargs): ...
    def add_signall(*args, **kwargs): ...
    def remove(*args, **kwargs): ...
    def skip(*args, **kwargs): ...
    

class BindingSet:
    class_branch_pspecs = list[object]
    current = BindingEntry
    entries = BindingEntry
    parsed = int
    priority = int
    set_name = str
    widget_class_pspecs = list[object]
    widget_path_pspecs = list[object]
    
    def activate(*args, **kwargs): ...
    def add_path(*args, **kwargs): ...
    def find(*args, **kwargs): ...
    

class BindingSignal:
    args = list[BindingArg]
    n_args = int
    next = BindingSignal
    signal_name = str    

class Border:
    bottom = int
    left = int
    right = int
    top = int
    
    def free(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class Box(Orientable, Container):
    container = ...

    def __init__(self, orientation: Optional[Orientation] = None, spacing: Optional[int] = None) -> None: ...
    def get_baseline_position(*args, **kwargs): ...
    def get_center_widget(*args, **kwargs): ...
    def get_homogeneous(self) -> bool: ...
    def get_spacing(self) -> int: ...
    def new(*args, **kwargs): ...
    def pack_end(self, child: Widget, expand: bool, fill: bool, padding: int) -> None: ...
    def pack_start(self, child: Widget, expand: bool, fill: bool, padding: int) -> None: ...
    def query_child_packing(*args, **kwargs): ...
    def reorder_child(self, child: Widget, position: int) -> None: ...
    def set_baseline_position(*args, **kwargs): ...
    def set_center_widget(self, widget: Optional[Widget]) -> None: ...
    def set_child_packing(*args, **kwargs): ...
    def set_homogeneous(self, homogeneous: bool) -> None: ...
    def set_spacing(self, spacing: int) -> None: ...


class Buildable(GObject.GInterface):
    def add_child(*args, **kwargs): ...
    def construct_child(*args, **kwargs): ...
    def custom_finished(*args, **kwargs): ...
    def custom_tag_end(*args, **kwargs): ...
    def custom_tag_start(*args, **kwargs): ...
    def get_internal_child(*args, **kwargs): ...
    @classmethod
    def get_name(cls, obj: GObject.Object) -> str: ...
    def parser_finished(*args, **kwargs): ...
    def set_buildable_property(*args, **kwargs): ...
    def set_name(*args, **kwargs): ...


class Builder(GObject.Object):
    parent_instance = ...
    priv = ...

    def add_callback_symbol(*args, **kwargs): ...
    def add_from_file(*args, **kwargs): ...
    def add_from_resource(*args, **kwargs): ...
    def add_from_string(self, buffer: str, length: int = ...) -> None: ...
    def add_objects_from_file(*args, **kwargs): ...
    def add_objects_from_resource(*args, **kwargs): ...
    def add_objects_from_string(self, buffer: str, object_ids: list[str]) -> int: ...
    def connect_signals(self, obj_or_map: Any) -> None: ...
    def connect_signals_full(*args, **kwargs): ...
    def expose_object(*args, **kwargs): ...
    def extend_with_template(*args, **kwargs): ...
    def get_application(*args, **kwargs): ...
    def get_object(self, name: str) -> GObject.Object: ...
    def get_objects(*args, **kwargs): ...
    def get_translation_domain(*args, **kwargs): ...
    def get_type_from_name(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_file(*args, **kwargs): ...
    def new_from_resource(*args, **kwargs): ...
    def new_from_string(*args, **kwargs): ...
    def set_application(*args, **kwargs): ...
    def set_translation_domain(self, domain: Optional[str]) -> None: ...
    def value_from_string(*args, **kwargs): ...
    def value_from_string_type(*args, **kwargs): ...
    
    def do_get_type_from_name(self, *args, **kwargs): ...
    

class Button(Actionable, Activatable, Bin):
    bin = ...

    def __init__(self, label: Optional[str] = None, **kwargs: Any) -> None: ...
    def clicked(*args, **kwargs): ...
    def enter(*args, **kwargs): ...
    def get_alignment(*args, **kwargs): ...
    def get_always_show_image(*args, **kwargs): ...
    def get_event_window(*args, **kwargs): ...
    def get_image(*args, **kwargs): ...
    def get_image_position(*args, **kwargs): ...
    def get_label(self) -> str: ...
    def get_relief(*args, **kwargs): ...
    def get_use_stock(*args, **kwargs): ...
    def get_use_underline(*args, **kwargs): ...
    def leave(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    @classmethod
    def new_from_icon_name(cls, icon_name: Optional[str], size: IconSize) -> Button: ...
    @classmethod
    def new_from_stock(cls, *args, **kwargs): ...
    @classmethod
    def new_with_label(cls, label: str) -> Button: ...
    @classmethod
    def new_with_mnemonic(cls, label: str) -> Button: ...
    def pressed(*args, **kwargs): ...
    def released(*args, **kwargs): ...
    def set_alignment(*args, **kwargs): ...
    def set_always_show_image(*args, **kwargs): ...
    def set_image(self, image: Optional[Widget]) -> None: ...
    def set_image_position(*args, **kwargs): ...
    def set_label(self, label: str) -> None: ...
    def set_relief(self, relief: ReliefStyle) -> None: ...
    def set_use_stock(*args, **kwargs): ...
    def set_use_underline(*args, **kwargs): ...
    
    def do_activate(self, *args, **kwargs): ...
    def do_clicked(self, *args, **kwargs): ...
    def do_enter(self, *args, **kwargs): ...
    def do_leave(self, *args, **kwargs): ...
    def do_pressed(self, *args, **kwargs): ...
    def do_released(self, *args, **kwargs): ...
    

class ButtonBox(Box):
    box = ...
    
    def get_child_non_homogeneous(*args, **kwargs): ...
    def get_child_secondary(*args, **kwargs): ...
    def get_layout(*args, **kwargs): ...
    def set_child_non_homogeneous(*args, **kwargs): ...
    def set_child_secondary(*args, **kwargs): ...
    def set_layout(*args, **kwargs): ...
    

class Calendar(Widget):
    widget = ...
    
    def __init__(self, day: int = 0, month: int = 0, year: int = 0) -> None: ...
    def clear_marks(self) -> None: ...
    def get_date(self) -> tuple[int, int, int]: ...
    def get_day_is_marked(self, day: int) -> bool: ...
    def get_detail_height_rows(self) -> int: ...
    def get_detail_width_chars(self) -> int: ...
    def get_display_options(self) -> CalendarDisplayOptions: ...
    def mark_day(self, day: int) -> None: ...
    def new(*args, **kwargs): ...
    def select_day(self, day: int) -> None: ...
    def select_month(self, month: int, year: int) -> None: ...
    def set_detail_func(*args, **kwargs): ...
    def set_detail_height_rows(self, rows: int) -> None: ...
    def set_detail_width_chars(self, chars: int) -> None: ...
    def set_display_options(self, flags: CalendarDisplayOptions) -> None: ...
    def unmark_day(self, day: int) -> None: ...
    
    def do_day_selected(self, *args, **kwargs): ...
    def do_day_selected_double_click(self, *args, **kwargs): ...
    def do_month_changed(self, *args, **kwargs): ...
    def do_next_month(self, *args, **kwargs): ...
    def do_next_year(self, *args, **kwargs): ...
    def do_prev_month(self, *args, **kwargs): ...
    def do_prev_year(self, *args, **kwargs): ...
    

class CellArea(Buildable, CellLayout, GObject.InitiallyUnowned):
    parent_instance = ...
    priv = ...
    
    def activate(*args, **kwargs): ...
    def activate_cell(*args, **kwargs): ...
    def add(*args, **kwargs): ...
    def add_focus_sibling(*args, **kwargs): ...
    def apply_attributes(*args, **kwargs): ...
    def attribute_connect(*args, **kwargs): ...
    def attribute_disconnect(*args, **kwargs): ...
    def attribute_get_column(*args, **kwargs): ...
    def cell_get_property(*args, **kwargs): ...
    def cell_set_property(*args, **kwargs): ...
    def copy_context(*args, **kwargs): ...
    def create_context(*args, **kwargs): ...
    def event(*args, **kwargs): ...
    def find_cell_property(*args, **kwargs): ...
    def focus(*args, **kwargs): ...
    def foreach(*args, **kwargs): ...
    def foreach_alloc(*args, **kwargs): ...
    def get_cell_allocation(*args, **kwargs): ...
    def get_cell_at_position(*args, **kwargs): ...
    def get_current_path_string(*args, **kwargs): ...
    def get_edit_widget(*args, **kwargs): ...
    def get_edited_cell(*args, **kwargs): ...
    def get_focus_cell(*args, **kwargs): ...
    def get_focus_from_sibling(*args, **kwargs): ...
    def get_focus_siblings(*args, **kwargs): ...
    def get_preferred_height(*args, **kwargs): ...
    def get_preferred_height_for_width(*args, **kwargs): ...
    def get_preferred_width(*args, **kwargs): ...
    def get_preferred_width_for_height(*args, **kwargs): ...
    def get_request_mode(*args, **kwargs): ...
    def has_renderer(*args, **kwargs): ...
    def inner_cell_area(*args, **kwargs): ...
    def install_cell_property(*args, **kwargs): ...
    def is_activatable(*args, **kwargs): ...
    def is_focus_sibling(*args, **kwargs): ...
    def list_cell_properties(*args, **kwargs): ...
    def remove(*args, **kwargs): ...
    def remove_focus_sibling(*args, **kwargs): ...
    def render(*args, **kwargs): ...
    def request_renderer(*args, **kwargs): ...
    def set_focus_cell(*args, **kwargs): ...
    def stop_editing(*args, **kwargs): ...
    
    def do_activate(self, *args, **kwargs): ...
    def do_add(self, *args, **kwargs): ...
    def do_apply_attributes(self, *args, **kwargs): ...
    def do_copy_context(self, *args, **kwargs): ...
    def do_create_context(self, *args, **kwargs): ...
    def do_event(self, *args, **kwargs): ...
    def do_focus(self, *args, **kwargs): ...
    def do_foreach(self, *args, **kwargs): ...
    def do_foreach_alloc(self, *args, **kwargs): ...
    def do_get_cell_property(self, *args, **kwargs): ...
    def do_get_preferred_height(self, *args, **kwargs): ...
    def do_get_preferred_height_for_width(self, *args, **kwargs): ...
    def do_get_preferred_width(self, context: CellAreaContext, widget: Widget) -> tuple[int, int]: ...
    def do_get_preferred_width_for_height(self, *args, **kwargs): ...
    def do_get_request_mode(self, *args, **kwargs): ...
    def do_is_activatable(self, *args, **kwargs): ...
    def do_remove(self, *args, **kwargs): ...
    def do_render(self, *args, **kwargs): ...
    def do_set_cell_property(self, *args, **kwargs): ...
    

class CellAreaBox(Orientable, CellArea):
    def get_spacing(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_spacing(*args, **kwargs): ...
    

class CellAreaContext(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def allocate(*args, **kwargs): ...
    def get_allocation(*args, **kwargs): ...
    def get_area(*args, **kwargs): ...
    def get_preferred_height(*args, **kwargs): ...
    def get_preferred_height_for_width(*args, **kwargs): ...
    def get_preferred_width(*args, **kwargs): ...
    def get_preferred_width_for_height(*args, **kwargs): ...
    def push_preferred_height(*args, **kwargs): ...
    def push_preferred_width(*args, **kwargs): ...
    def reset(*args, **kwargs): ...
    
    def do_allocate(self, *args, **kwargs): ...
    def do_get_preferred_height_for_width(self, *args, **kwargs): ...
    def do_get_preferred_width_for_height(self, *args, **kwargs): ...
    def do_reset(self, *args, **kwargs): ...
    

class CellEditable(GObject.GInterface):
    def editing_done(*args, **kwargs): ...
    def remove_widget(*args, **kwargs): ...
    def start_editing(*args, **kwargs): ...
    

class CellLayout:
    def add_attribute(self, cell: CellRenderer, attribute: str, column: int) -> None: ...
    def clear(*args, **kwargs): ...
    def clear_attributes(*args, **kwargs): ...
    def get_area(*args, **kwargs): ...
    def get_cells(self) -> list[CellRenderer]: ...
    def pack_end(self, cell: CellRenderer, expand: bool) -> None: ...
    def pack_start(self, cell: CellRenderer, expand: bool) -> None: ...
    def reorder(*args, **kwargs): ...
    

class CellRenderer(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def activate(*args, **kwargs): ...
    def get_aligned_area(*args, **kwargs): ...
    def get_alignment(*args, **kwargs): ...
    def get_fixed_size(*args, **kwargs): ...
    def get_padding(*args, **kwargs): ...
    def get_preferred_height(*args, **kwargs): ...
    def get_preferred_height_for_width(*args, **kwargs): ...
    def get_preferred_size(*args, **kwargs): ...
    def get_preferred_width(*args, **kwargs): ...
    def get_preferred_width_for_height(*args, **kwargs): ...
    def get_request_mode(*args, **kwargs): ...
    def get_sensitive(self) -> bool: ...
    def get_size(*args, **kwargs): ...
    def get_state(*args, **kwargs): ...
    def get_visible(self) -> bool: ...
    def is_activatable(*args, **kwargs): ...
    def render(*args, **kwargs): ...
    def set_accessible_type(*args, **kwargs): ...
    def set_alignment(*args, **kwargs): ...
    def set_fixed_size(*args, **kwargs): ...
    def set_padding(*args, **kwargs): ...
    def set_sensitive(self, sensitive: bool) -> None: ...
    def set_visible(self, visible: bool) -> None: ...
    def start_editing(*args, **kwargs): ...
    def stop_editing(*args, **kwargs): ...
    
    def do_activate(self, *args, **kwargs): ...
    def do_editing_canceled(self, *args, **kwargs): ...
    def do_editing_started(self, *args, **kwargs): ...
    def do_get_aligned_area(self, *args, **kwargs): ...
    def do_get_preferred_height(self, *args, **kwargs): ...
    def do_get_preferred_height_for_width(self, *args, **kwargs): ...
    def do_get_preferred_width(self, widget: Widget) -> tuple[int, int]: ...
    def do_get_preferred_width_for_height(self, *args, **kwargs): ...
    def do_get_request_mode(self, *args, **kwargs): ...
    def do_get_size(self, *args, **kwargs): ...
    def do_render(self, *args, **kwargs): ...
    def do_start_editing(self, *args, **kwargs): ...
    

class CellRendererAccel(CellRendererText):
    def do_accel_cleared(self, *args, **kwargs): ...
    def do_accel_edited(self, *args, **kwargs): ...
    

class CellRendererCombo(CellRendererText): ...

class CellRendererPixbuf(CellRenderer):
    parent = ...
    
    def new(*args, **kwargs): ...
    

class CellRendererProgress(Orientable, CellRenderer):
    def new(*args, **kwargs): ...
    

class CellRendererSpin(CellRendererText): ...

class CellRendererSpinner(CellRenderer):
    parent = ...
    
    def new(*args, **kwargs): ...
    

class CellRendererText(CellRenderer):
    parent = ...
    
    def new(*args, **kwargs): ...
    def set_fixed_height_from_font(*args, **kwargs): ...
    
    def do_edited(self, *args, **kwargs): ...
    

class CellRendererToggle(CellRenderer):
    parent = ...
    
    def get_activatable(self) -> bool: ...
    def get_active(self) -> bool: ...
    def get_radio(self) -> bool: ...
    def new(*args, **kwargs): ...
    def set_activatable(self, setting: bool) -> None: ...
    def set_active(self, setting: bool) -> None: ...
    def set_radio(self, radio: bool) -> None: ...
    
    def do_toggled(self, path: str) -> None: ...
    

class CellView(CellLayout, Orientable, Widget):
    def get_displayed_row(*args, **kwargs): ...
    def get_draw_sensitive(*args, **kwargs): ...
    def get_fit_model(*args, **kwargs): ...
    def get_model(*args, **kwargs): ...
    def get_size_of_row(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_context(*args, **kwargs): ...
    def new_with_markup(*args, **kwargs): ...
    def new_with_pixbuf(*args, **kwargs): ...
    def new_with_text(*args, **kwargs): ...
    def set_background_color(*args, **kwargs): ...
    def set_background_rgba(*args, **kwargs): ...
    def set_displayed_row(*args, **kwargs): ...
    def set_draw_sensitive(*args, **kwargs): ...
    def set_fit_model(*args, **kwargs): ...
    def set_model(*args, **kwargs): ...
    

class CheckButton(ToggleButton):
    toggle_button = ...
    
    def do_draw_indicator(self, *args, **kwargs): ...
    

class CheckMenuItem(MenuItem):
    menu_item = ...

    def get_active(self) -> bool: ...
    def get_draw_as_radio(self) -> bool: ...
    def get_inconsistent(self) -> bool: ...
    @classmethod
    def new(cls) -> CheckMenuItem: ...
    @classmethod
    def new_with_label(cls, label: str) -> CheckMenuItem: ...
    @classmethod
    def new_with_mnemonic(cls, label: str) -> CheckMenuItem: ...
    def set_active(self, is_active: bool) -> None: ...
    def set_draw_as_radio(self, draw_as_radio: bool) -> None: ...
    def set_inconsistent(self, setting: bool) -> None: ...
    def toggled(self) -> None: ...
    
    def do_draw_indicator(self, *args, **kwargs): ...
    def do_toggled(self, *args, **kwargs): ...


class Clipboard(GObject.Object):
    def clear(*args, **kwargs): ...
    @classmethod
    def get(cls, selection: Gdk.Atom) -> Clipboard: ...
    @classmethod
    def get_default(cls, display: Gdk.Display) -> Clipboard: ...
    def get_display(*args, **kwargs): ...
    @classmethod
    def get_for_display(cls, *args, **kwargs): ...
    def get_owner(*args, **kwargs): ...
    def request_contents(*args, **kwargs): ...
    def request_image(*args, **kwargs): ...
    def request_rich_text(*args, **kwargs): ...
    def request_targets(*args, **kwargs): ...
    def request_text(*args, **kwargs): ...
    def request_uris(*args, **kwargs): ...
    def set_can_store(*args, **kwargs): ...
    def set_image(self, pixbuf: GdkPixbuf.Pixbuf) -> None: ...
    def set_text(self, text: str, len: int) -> None: ...
    def store(*args, **kwargs): ...
    def wait_for_contents(*args, **kwargs): ...
    def wait_for_image(self) -> Optional[GdkPixbuf.Pixbuf]: ...
    def wait_for_rich_text(*args, **kwargs): ...
    def wait_for_targets(*args, **kwargs): ...
    def wait_for_text(self) -> Optional[str]: ...
    def wait_for_uris(*args, **kwargs): ...
    def wait_is_image_available(*args, **kwargs): ...
    def wait_is_rich_text_available(*args, **kwargs): ...
    def wait_is_target_available(*args, **kwargs): ...
    def wait_is_text_available(*args, **kwargs): ...
    def wait_is_uris_available(*args, **kwargs): ...
    

class ColorButton(Button, ColorChooser):
    button = ...
    
    def get_alpha(*args, **kwargs): ...
    def get_color(*args, **kwargs): ...
    def get_title(*args, **kwargs): ...
    def new_with_color(*args, **kwargs): ...
    def new_with_rgba(*args, **kwargs): ...
    def set_alpha(*args, **kwargs): ...
    def set_color(*args, **kwargs): ...
    def set_title(*args, **kwargs): ...
    
    def do_color_set(self, *args, **kwargs): ...


class ColorChooser(GObject.GInterface):
    def add_palette(*args, **kwargs): ...
    def get_rgba(self) -> Gdk.RGBA: ...
    def get_use_alpha(*args, **kwargs): ...
    def set_rgba(self, rgba: Gdk.RGBA) -> None: ...
    def set_use_alpha(*args, **kwargs): ...
    

class ColorChooserDialog(ColorChooser, Dialog): ...

class ColorChooserInterface:
    add_palette = ...
    base_interface = ...
    color_activated = ...
    get_rgba = ...
    padding = ...
    set_rgba = ...
    

class ColorChooserWidget(ColorChooser, Box): ...

class ColorSelection(Box):
    private_data = ...
    
    def get_current_alpha(*args, **kwargs): ...
    def get_current_color(*args, **kwargs): ...
    def get_current_rgba(*args, **kwargs): ...
    def get_has_opacity_control(*args, **kwargs): ...
    def get_has_palette(*args, **kwargs): ...
    def get_previous_alpha(*args, **kwargs): ...
    def get_previous_color(*args, **kwargs): ...
    def get_previous_rgba(*args, **kwargs): ...
    def is_adjusting(*args, **kwargs): ...
    def palette_from_string(*args, **kwargs): ...
    def palette_to_string(*args, **kwargs): ...
    def set_current_alpha(*args, **kwargs): ...
    def set_current_color(*args, **kwargs): ...
    def set_current_rgba(*args, **kwargs): ...
    def set_has_opacity_control(*args, **kwargs): ...
    def set_has_palette(*args, **kwargs): ...
    def set_previous_alpha(*args, **kwargs): ...
    def set_previous_color(*args, **kwargs): ...
    def set_previous_rgba(*args, **kwargs): ...
    
    def do_color_changed(self, *args, **kwargs): ...
    

class ColorSelectionDialog(Dialog):
    def get_color_selection(*args, **kwargs): ...


class ComboBox(CellEditable, CellLayout, Bin):
    def get_active(self) -> int: ...
    def get_active_id(self) -> Optional[str]: ...
    def get_active_iter(self) -> Optional[TreeIter]: ...
    def get_add_tearoffs(*args, **kwargs): ...
    def get_button_sensitivity(*args, **kwargs): ...
    def get_column_span_column(*args, **kwargs): ...
    def get_entry_text_column(*args, **kwargs): ...
    def get_has_entry(*args, **kwargs): ...
    def get_id_column(*args, **kwargs): ...
    def get_model(self) -> TreeModel: ...
    def get_popup_accessible(*args, **kwargs): ...
    def get_popup_fixed_width(*args, **kwargs): ...
    def get_row_span_column(*args, **kwargs): ...
    def get_title(*args, **kwargs): ...
    def get_wrap_width(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_area(*args, **kwargs): ...
    def new_with_area_and_entry(*args, **kwargs): ...
    def new_with_entry(*args, **kwargs): ...
    @classmethod
    def new_with_model(cls, model: TreeModel) -> ComboBox: ...
    def new_with_model_and_entry(*args, **kwargs): ...
    def popdown(*args, **kwargs): ...
    def popup(*args, **kwargs): ...
    def popup_for_device(*args, **kwargs): ...
    def set_active(self, index: int) -> None: ...
    def set_active_id(self, active_id: Optional[str]) -> bool: ...
    def set_active_iter(*args, **kwargs): ...
    def set_add_tearoffs(*args, **kwargs): ...
    def set_button_sensitivity(*args, **kwargs): ...
    def set_column_span_column(*args, **kwargs): ...
    def set_entry_text_column(*args, **kwargs): ...
    def set_id_column(*args, **kwargs): ...
    def set_model(self, model: Optional[TreeModel]) -> None: ...
    def set_popup_fixed_width(*args, **kwargs): ...
    def set_row_separator_func(*args, **kwargs): ...
    def set_row_span_column(*args, **kwargs): ...
    def set_title(*args, **kwargs): ...
    def set_wrap_width(*args, **kwargs): ...

    def do_changed(self, *args, **kwargs): ...
    def do_format_entry_text(self, *args, **kwargs): ...
    

class ComboBoxText(ComboBox):
    def append(self, id: Optional[str], text: str) -> None: ...
    def append_text(self, text: str) -> None: ...
    def get_active_text(self) -> Optional[str]: ...
    def insert(*args, **kwargs): ...
    def insert_text(*args, **kwargs): ...
    def prepend(*args, **kwargs): ...
    def prepend_text(*args, **kwargs): ...
    def remove_all(*args, **kwargs): ...


class Container(Widget):
    widget = ...

    def add(self, widget: Widget) -> None: ...
    def check_resize(*args, **kwargs): ...
    def child_get(*args, **kwargs): ...
    def child_get_property(*args, **kwargs): ...
    def child_notify_by_pspec(*args, **kwargs): ...
    def child_set(*args, **kwargs): ...
    def child_set_property(*args, **kwargs): ...
    def child_type(*args, **kwargs): ...
    def find_child_property(*args, **kwargs): ...
    def forall(*args, **kwargs): ...
    def foreach(self, callback: Callable[..., Any], callback_data: Optional[Any] = None) -> None: ...
    def get_border_width(*args, **kwargs): ...
    def get_children(self) -> list[Widget]: ...
    def get_focus_chain(*args, **kwargs): ...
    def get_focus_child(*args, **kwargs): ...
    def get_focus_hadjustment(*args, **kwargs): ...
    def get_focus_vadjustment(*args, **kwargs): ...
    def get_path_for_child(*args, **kwargs): ...
    def get_resize_mode(*args, **kwargs): ...
    def handle_border_width(*args, **kwargs): ...
    def install_child_properties(*args, **kwargs): ...
    def install_child_property(*args, **kwargs): ...
    def list_child_properties(*args, **kwargs): ...
    def propagate_draw(*args, **kwargs): ...
    def remove(self, widget: Widget) -> None: ...
    def resize_children(*args, **kwargs): ...
    def set_border_width(self, border_width: int) -> None: ...
    def set_focus_chain(*args, **kwargs): ...
    def set_focus_child(*args, **kwargs): ...
    def set_focus_hadjustment(*args, **kwargs): ...
    def set_focus_vadjustment(self, adjustment: Adjustment) -> None: ...
    def set_reallocate_redraws(*args, **kwargs): ...
    def set_resize_mode(*args, **kwargs): ...
    def unset_focus_chain(*args, **kwargs): ...
    
    def do_add(self, *args, **kwargs): ...
    def do_check_resize(self, *args, **kwargs): ...
    def do_child_type(self, *args, **kwargs): ...
    def do_composite_name(self, *args, **kwargs): ...
    def do_forall(self, *args, **kwargs): ...
    def do_get_child_property(self, *args, **kwargs): ...
    def do_get_path_for_child(self, *args, **kwargs): ...
    def do_remove(self, *args, **kwargs): ...
    def do_set_child_property(self, *args, **kwargs): ...
    def do_set_focus_child(self, *args, **kwargs): ...
    

class CssProvider(GObject.Object, StyleProvider):
    parent_instance = ...
    priv = ...
    
    def get_default(*args, **kwargs): ...
    def get_named(*args, **kwargs): ...
    def load_from_data(self, data: bytes) -> bool: ...
    def load_from_file(*args, **kwargs): ...
    def load_from_path(*args, **kwargs): ...
    def load_from_resource(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    
    def do_parsing_error(self, *args, **kwargs): ...
    

class CssSection:
    def get_end_line(*args, **kwargs): ...
    def get_end_position(*args, **kwargs): ...
    def get_file(*args, **kwargs): ...
    def get_parent(*args, **kwargs): ...
    def get_section_type(*args, **kwargs): ...
    def get_start_line(*args, **kwargs): ...
    def get_start_position(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class Dialog(Window):
    _old_arg_names = ...
    action_area = ...
    vbox = ...
    window = ...
    
    def __init__(self, title: Optional[str] = None, **kwargs: Any) -> None: ...
    def add_action_widget(*args, **kwargs): ...
    def add_button(self, buton_text: str, response_id: int) -> Widget: ...
    def add_buttons(*args: Any) -> None: ...
    def get_action_area(self) -> Box: ...
    def get_content_area(self) -> Box: ...
    def get_header_bar(*args, **kwargs): ...
    def get_response_for_widget(self, widget: Widget) -> int: ...
    def get_widget_for_response(self, response_id: int) -> Optional[Widget]: ...
    def response(self, response_id: int) -> None: ...
    def run(self) -> int: ...
    def set_alternative_button_order_from_array(*args, **kwargs): ...
    def set_default_response(self, response_id: int) -> None: ...
    def set_response_sensitive(*args, **kwargs): ...
    
    def do_close(self, *args, **kwargs): ...
    def do_response(self, *args, **kwargs): ...
    

class DrawingArea(Widget):
    dummy = ...
    widget = ...
    
    def new(*args, **kwargs): ...
    

class Editable(GObject.GInterface):
    def copy_clipboard(*args, **kwargs): ...
    def cut_clipboard(*args, **kwargs): ...
    def delete_selection(*args, **kwargs): ...
    def delete_text(*args, **kwargs): ...
    def get_chars(*args, **kwargs): ...
    def get_editable(*args, **kwargs): ...
    def get_position(*args, **kwargs): ...
    def get_selection_bounds(*args, **kwargs): ...
    def insert_text(*args, **kwargs): ...
    def paste_clipboard(*args, **kwargs): ...
    def select_region(self, start_pos: int, end_pos: int) -> None: ...
    def set_editable(self, is_editable: bool) -> None: ...
    def set_position(*args, **kwargs): ...
    

class EditableInterface:
    base_iface = ...
    changed = ...
    delete_text = ...
    do_delete_text = ...
    do_insert_text = ...
    get_chars = ...
    get_position = ...
    get_selection_bounds = ...
    insert_text = ...
    set_position = ...
    set_selection_bounds = ...
    

class Entry(Widget, CellEditable, Editable):
    def get_activates_default(*args, **kwargs): ...
    def get_alignment(*args, **kwargs): ...
    def get_attributes(*args, **kwargs): ...
    def get_buffer(self) -> EntryBuffer: ...
    def get_completion(self) -> EntryCompletion: ...
    def get_current_icon_drag_source(*args, **kwargs): ...
    def get_cursor_hadjustment(*args, **kwargs): ...
    def get_has_frame(*args, **kwargs): ...
    def get_icon_activatable(*args, **kwargs): ...
    def get_icon_area(*args, **kwargs): ...
    def get_icon_at_pos(*args, **kwargs): ...
    def get_icon_gicon(*args, **kwargs): ...
    def get_icon_name(*args, **kwargs): ...
    def get_icon_pixbuf(*args, **kwargs): ...
    def get_icon_sensitive(*args, **kwargs): ...
    def get_icon_stock(*args, **kwargs): ...
    def get_icon_storage_type(*args, **kwargs): ...
    def get_icon_tooltip_markup(*args, **kwargs): ...
    def get_icon_tooltip_text(*args, **kwargs): ...
    def get_inner_border(*args, **kwargs): ...
    def get_input_hints(*args, **kwargs): ...
    def get_input_purpose(*args, **kwargs): ...
    def get_invisible_char(*args, **kwargs): ...
    def get_layout(*args, **kwargs): ...
    def get_layout_offsets(*args, **kwargs): ...
    def get_max_length(*args, **kwargs): ...
    def get_max_width_chars(*args, **kwargs): ...
    def get_overwrite_mode(*args, **kwargs): ...
    def get_placeholder_text(*args, **kwargs): ...
    def get_progress_fraction(*args, **kwargs): ...
    def get_progress_pulse_step(*args, **kwargs): ...
    def get_tabs(*args, **kwargs): ...
    def get_text(self) -> str: ...
    def get_text_area(*args, **kwargs): ...
    def get_text_length(*args, **kwargs): ...
    def get_visibility(*args, **kwargs): ...
    def get_width_chars(*args, **kwargs): ...
    def grab_focus_without_selecting(self) -> None: ...
    def im_context_filter_keypress(*args, **kwargs): ...
    def layout_index_to_text_index(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_buffer(*args, **kwargs): ...
    def progress_pulse(*args, **kwargs): ...
    def reset_im_context(*args, **kwargs): ...
    def set_activates_default(self, setting: bool) -> None: ...
    def set_alignment(self, xalign: float) -> None: ...
    def set_attributes(*args, **kwargs): ...
    def set_buffer(*args, **kwargs): ...
    def set_completion(self, completion: Optional[EntryCompletion]) -> None: ...
    def set_cursor_hadjustment(*args, **kwargs): ...
    def set_has_frame(*args, **kwargs): ...
    def set_icon_activatable(*args, **kwargs): ...
    def set_icon_drag_source(*args, **kwargs): ...
    def set_icon_from_gicon(*args, **kwargs): ...
    def set_icon_from_icon_name(self, icon_pos: EntryIconPosition, icon_name: Optional[str]) -> None: ...
    def set_icon_from_pixbuf(*args, **kwargs): ...
    def set_icon_from_stock(*args, **kwargs): ...
    def set_icon_sensitive(*args, **kwargs): ...
    def set_icon_tooltip_markup(*args, **kwargs): ...
    def set_icon_tooltip_text(self, icon_pos: EntryIconPosition, tooltip: Optional[str]) -> None: ...
    def set_inner_border(*args, **kwargs): ...
    def set_input_hints(*args, **kwargs): ...
    def set_input_purpose(self, purpose: InputPurpose) -> None: ...
    def set_invisible_char(self, ch: str) -> None: ...
    def set_max_length(*args, **kwargs): ...
    def set_max_width_chars(self, n_chars: int) -> None: ...
    def set_overwrite_mode(*args, **kwargs): ...
    def set_placeholder_text(self, text: Optional[str]) -> None: ...
    def set_progress_fraction(*args, **kwargs): ...
    def set_progress_pulse_step(*args, **kwargs): ...
    def set_tabs(*args, **kwargs): ...
    def set_text(self, text: str) -> None: ...
    def set_visibility(self, visible: bool) -> None: ...
    def set_width_chars(self, n_chars: int) -> None: ...
    def text_index_to_layout_index(*args, **kwargs): ...
    def unset_invisible_char(*args, **kwargs): ...
    
    def do_activate(self, *args, **kwargs): ...
    def do_backspace(self, *args, **kwargs): ...
    def do_copy_clipboard(self, *args, **kwargs): ...
    def do_cut_clipboard(self, *args, **kwargs): ...
    def do_delete_from_cursor(self, *args, **kwargs): ...
    def do_get_frame_size(self, *args, **kwargs): ...
    def do_get_text_area_size(self, *args, **kwargs): ...
    def do_insert_at_cursor(self, *args, **kwargs): ...
    def do_insert_emoji(self, *args, **kwargs): ...
    def do_move_cursor(self, *args, **kwargs): ...
    def do_paste_clipboard(self, *args, **kwargs): ...
    def do_populate_popup(self, *args, **kwargs): ...
    def do_toggle_overwrite(self, *args, **kwargs): ...
    

class EntryBuffer(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def delete_text(*args, **kwargs): ...
    def emit_deleted_text(*args, **kwargs): ...
    def emit_inserted_text(*args, **kwargs): ...
    def get_bytes(*args, **kwargs): ...
    def get_length(*args, **kwargs): ...
    def get_max_length(*args, **kwargs): ...
    def get_text(*args, **kwargs): ...
    def insert_text(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_max_length(*args, **kwargs): ...
    def set_text(*args, **kwargs): ...
    
    def do_delete_text(self, *args, **kwargs): ...
    def do_deleted_text(self, *args, **kwargs): ...
    def do_get_length(self, *args, **kwargs): ...
    def do_get_text(self, *args, **kwargs): ...
    def do_insert_text(self, *args, **kwargs): ...
    def do_inserted_text(self, *args, **kwargs): ...
    

class EntryCompletion(Buildable, CellLayout, GObject.Object):
    parent_instance = ...
    priv = ...
    
    def complete(*args, **kwargs): ...
    def compute_prefix(*args, **kwargs): ...
    def delete_action(*args, **kwargs): ...
    def get_completion_prefix(*args, **kwargs): ...
    def get_entry(*args, **kwargs): ...
    def get_inline_completion(*args, **kwargs): ...
    def get_inline_selection(*args, **kwargs): ...
    def get_minimum_key_length(*args, **kwargs): ...
    def get_model(self) -> Optional[TreeModel]: ...
    def get_popup_completion(*args, **kwargs): ...
    def get_popup_set_width(*args, **kwargs): ...
    def get_popup_single_match(self, popup_single_match: bool) -> None: ...
    def get_text_column(*args, **kwargs): ...
    def insert_action_markup(*args, **kwargs): ...
    def insert_action_text(*args, **kwargs): ...
    def insert_prefix(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_area(*args, **kwargs): ...
    def set_inline_completion(self, inline_completion: bool) -> None: ...
    def set_inline_selection(*args, **kwargs): ...
    def set_match_func(*args, **kwargs): ...
    def set_minimum_key_length(*args, **kwargs): ...
    def set_model(self, mode: TreeModel) -> None: ...
    def set_popup_completion(*args, **kwargs): ...
    def set_popup_set_width(*args, **kwargs): ...
    def set_popup_single_match(self, popup_single_match: bool) -> None: ...
    def set_text_column(self, column: int) -> None: ...
    
    def do_action_activated(self, *args, **kwargs): ...
    def do_cursor_on_match(self, *args, **kwargs): ...
    def do_insert_prefix(self, *args, **kwargs): ...
    def do_match_selected(self, *args, **kwargs): ...
    def do_no_matches(self, *args, **kwargs): ...
    

class EventBox(Bin):
    bin = ...
    
    def get_above_child(*args, **kwargs): ...
    def get_visible_window(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_above_child(*args, **kwargs): ...
    def set_visible_window(*args, **kwargs): ...
    

class EventController(GObject.Object):
    def get_propagation_phase(*args, **kwargs): ...
    def get_widget(*args, **kwargs): ...
    def handle_event(*args, **kwargs): ...
    def reset(*args, **kwargs): ...
    def set_propagation_phase(*args, **kwargs): ...
    

class EventControllerKey(EventController):
    def forward(*args, **kwargs): ...
    def get_group(*args, **kwargs): ...
    def get_im_context(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_im_context(*args, **kwargs): ...
    

class EventControllerMotion(EventController):
    def new(*args, **kwargs): ...
    

class EventControllerScroll(EventController):
    def get_flags(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_flags(*args, **kwargs): ...
    

class Expander(Bin):
    bin = ...
    
    def get_expanded(*args, **kwargs): ...
    def get_label(*args, **kwargs): ...
    def get_label_fill(*args, **kwargs): ...
    def get_label_widget(*args, **kwargs): ...
    def get_resize_toplevel(*args, **kwargs): ...
    def get_spacing(*args, **kwargs): ...
    def get_use_markup(*args, **kwargs): ...
    def get_use_underline(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_mnemonic(*args, **kwargs): ...
    def set_expanded(*args, **kwargs): ...
    def set_label(*args, **kwargs): ...
    def set_label_fill(*args, **kwargs): ...
    def set_label_widget(*args, **kwargs): ...
    def set_resize_toplevel(*args, **kwargs): ...
    def set_spacing(*args, **kwargs): ...
    def set_use_markup(*args, **kwargs): ...
    def set_use_underline(*args, **kwargs): ...
    
    def do_activate(self, *args, **kwargs): ...


class FileChooser(GObject.GInterface):

    def __init__(self, action: FileChooserAction = FileChooserAction.OPEN, **kwargs: Any) -> None: ...
    def add_choice(*args, **kwargs): ...
    def add_filter(self, filter: FileFilter) -> None: ...
    def add_shortcut_folder(*args, **kwargs): ...
    def add_shortcut_folder_uri(*args, **kwargs): ...
    def get_action(*args, **kwargs): ...
    def get_choice(*args, **kwargs): ...
    def get_create_folders(*args, **kwargs): ...
    def get_current_folder(self) -> Optional[str]: ...
    def get_current_folder_file(*args, **kwargs): ...
    def get_current_folder_uri(*args, **kwargs): ...
    def get_current_name(*args, **kwargs): ...
    def get_do_overwrite_confirmation(*args, **kwargs): ...
    def get_extra_widget(*args, **kwargs): ...
    def get_file(self) -> Gio.File: ...
    def get_filename(self) -> Optional[str]: ...
    def get_filenames(self) -> list[str]: ...
    def get_files(self) -> list[Gio.File]: ...
    def get_filter(self) -> Optional[FileFilter]: ...
    def get_local_only(self) -> bool: ...
    def get_preview_file(self) -> Optional[Gio.File]: ...
    def get_preview_filename(self) -> Optional[str]: ...
    def get_preview_uri(self) -> Optional[str]: ...
    def get_preview_widget(self) -> Optional[Widget]: ...
    def get_preview_widget_active(*args, **kwargs): ...
    def get_select_multiple(self) -> bool: ...
    def get_show_hidden(self) -> bool: ...
    def get_uri(self) -> Optional[str]: ...
    def get_uris(self) -> list[str]: ...
    def get_use_preview_label(self) -> bool: ...
    def list_filters(*args, **kwargs): ...
    def list_shortcut_folder_uris(*args, **kwargs): ...
    def list_shortcut_folders(*args, **kwargs): ...
    def remove_choice(*args, **kwargs): ...
    def remove_filter(*args, **kwargs): ...
    def remove_shortcut_folder(*args, **kwargs): ...
    def remove_shortcut_folder_uri(*args, **kwargs): ...
    def select_all(*args, **kwargs): ...
    def select_file(*args, **kwargs): ...
    def select_filename(*args, **kwargs): ...
    def select_uri(*args, **kwargs): ...
    def set_action(*args, **kwargs): ...
    def set_choice(*args, **kwargs): ...
    def set_create_folders(*args, **kwargs): ...
    def set_current_folder(self, filename: str) -> bool: ...
    def set_current_folder_file(*args, **kwargs): ...
    def set_current_folder_uri(*args, **kwargs): ...
    def set_current_name(self, name: str) -> None: ...
    def set_do_overwrite_confirmation(self, do_overwrite_confirmation: bool) -> None: ...
    def set_extra_widget(*args, **kwargs): ...
    def set_file(*args, **kwargs): ...
    def set_filename(self, filename: str) -> bool: ...
    def set_filter(self, filter: FileFilter) -> None: ...
    def set_local_only(*args, **kwargs): ...
    def set_preview_widget(self, preview_widget: Widget) -> None: ...
    def set_preview_widget_active(*args, **kwargs): ...
    def set_select_multiple(self, select_multiple: bool) -> None: ...
    def set_show_hidden(*args, **kwargs): ...
    def set_uri(*args, **kwargs): ...
    def set_use_preview_label(self, use_label: bool) -> None: ...
    def unselect_all(self) -> None: ...
    def unselect_file(*args, **kwargs): ...
    def unselect_filename(*args, **kwargs): ...
    def unselect_uri(*args, **kwargs): ...
    

class FileChooserButton(FileChooser, Box):
    parent = ...
    
    def __init__(self, dialog: Optional[FileChooser] = None, title: str = 'Select a file', width_chars: int = -1, **kwargs: Any) -> None: ...
    def get_title(*args, **kwargs): ...
    def get_width_chars(*args, **kwargs): ...
    def new_with_dialog(*args, **kwargs): ...
    def set_title(*args, **kwargs): ...
    def set_width_chars(*args, **kwargs): ...
    
    def do_file_set(self, *args, **kwargs): ...
    

class FileChooserDialog(FileChooser, Dialog): ...

class FileChooserNative(FileChooser, NativeDialog):
    def __init__(self, **kwargs: Any) -> None: ...
    def get_accept_label(*args, **kwargs): ...
    def get_cancel_label(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_accept_label(*args, **kwargs): ...
    def set_cancel_label(*args, **kwargs): ...
    

class FileChooserWidget(FileChooser, Box): ...


class FileFilter(Buildable, GObject.InitiallyUnowned):
    def add_custom(*args, **kwargs): ...
    def add_mime_type(self, mime_type: str) -> None: ...
    def add_pattern(self, pattern: str) -> None: ...
    def add_pixbuf_formats(*args, **kwargs): ...
    def filter(*args, **kwargs): ...
    def get_needed(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_gvariant(*args, **kwargs): ...
    def set_name(self, name: Optional[str]) -> None: ...
    def to_gvariant(*args, **kwargs): ...
    

class FileFilterInfo:
    contains = FileFilterFlags
    display_name = str
    filename = str
    mime_type = str
    uri = str
    

class Fixed(Container):
    container = ...
    
    def move(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def put(*args, **kwargs): ...
    

class FixedChild:
    widget = Widget
    x = int
    y = int
    

class FlowBox(Orientable, Container):
    container = ...
    
    def bind_model(*args, **kwargs): ...
    def get_activate_on_single_click(*args, **kwargs): ...
    def get_child_at_index(self, idx: int) -> Optional[FlowBoxChild]: ...
    def get_child_at_pos(*args, **kwargs): ...
    def get_column_spacing(*args, **kwargs): ...
    def get_homogeneous(*args, **kwargs): ...
    def get_max_children_per_line(*args, **kwargs): ...
    def get_min_children_per_line(*args, **kwargs): ...
    def get_row_spacing(*args, **kwargs): ...
    def get_selected_children(*args, **kwargs): ...
    def get_selection_mode(self, mode: SelectionMode) -> None: ...
    def insert(*args, **kwargs): ...
    def invalidate_filter(*args, **kwargs): ...
    def invalidate_sort(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def select_all(*args, **kwargs): ...
    def select_child(*args, **kwargs): ...
    def selected_foreach(*args, **kwargs): ...
    def set_activate_on_single_click(*args, **kwargs): ...
    def set_column_spacing(self, spacing: int) -> None: ...
    def set_filter_func(*args, **kwargs): ...
    def set_hadjustment(*args, **kwargs): ...
    def set_homogeneous(*args, **kwargs): ...
    def set_max_children_per_line(*args, **kwargs): ...
    def set_min_children_per_line(*args, **kwargs): ...
    def set_row_spacing(self, spacing: int) -> None: ...
    def set_selection_mode(self, mode: SelectionMode) -> None: ...
    def set_sort_func(*args, **kwargs): ...
    def set_vadjustment(*args, **kwargs): ...
    def unselect_all(*args, **kwargs): ...
    def unselect_child(*args, **kwargs): ...
    
    def do_activate_cursor_child(self, *args, **kwargs): ...
    def do_child_activated(self, *args, **kwargs): ...
    def do_move_cursor(self, *args, **kwargs): ...
    def do_select_all(self, *args, **kwargs): ...
    def do_selected_children_changed(self, *args, **kwargs): ...
    def do_toggle_cursor_child(self, *args, **kwargs): ...
    def do_unselect_all(self, *args, **kwargs): ...
    

class FlowBoxChild(Bin):
    def changed(*args, **kwargs): ...
    def get_index(*args, **kwargs): ...
    def is_selected(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    
    def do_activate(self, *args, **kwargs): ...
    

class FontButton(Button, FontChooser):
    button = ...
    
    def get_font_name(*args, **kwargs): ...
    def get_show_size(*args, **kwargs): ...
    def get_show_style(*args, **kwargs): ...
    def get_title(*args, **kwargs): ...
    def get_use_font(*args, **kwargs): ...
    def get_use_size(*args, **kwargs): ...
    def new_with_font(*args, **kwargs): ...
    def set_font_name(*args, **kwargs): ...
    def set_show_size(*args, **kwargs): ...
    def set_show_style(*args, **kwargs): ...
    def set_title(*args, **kwargs): ...
    def set_use_font(*args, **kwargs): ...
    def set_use_size(*args, **kwargs): ...
    
    def do_font_set(self, *args, **kwargs): ...
    

class FontChooser(GObject.GInterface):
    def get_font(*args, **kwargs): ...
    def get_font_desc(self) -> Optional[Pango.FontDescription]: ...
    def get_font_face(*args, **kwargs): ...
    def get_font_family(*args, **kwargs): ...
    def get_font_features(*args, **kwargs): ...
    def get_font_map(*args, **kwargs): ...
    def get_font_size(*args, **kwargs): ...
    def get_language(*args, **kwargs): ...
    def get_level(*args, **kwargs): ...
    def get_preview_text(*args, **kwargs): ...
    def get_show_preview_entry(*args, **kwargs): ...
    def set_filter_func(*args, **kwargs): ...
    def set_font(*args, **kwargs): ...
    def set_font_desc(self, font_desc: Pango.FontDescription) -> None: ...
    def set_font_map(*args, **kwargs): ...
    def set_language(*args, **kwargs): ...
    def set_level(*args, **kwargs): ...
    def set_preview_text(*args, **kwargs): ...
    def set_show_preview_entry(*args, **kwargs): ...
    

class FontChooserDialog(FontChooser, Dialog): ...

class FontChooserWidget(FontChooser, Box): ...

class FontSelection(Box):
    def get_face(*args, **kwargs): ...
    def get_face_list(*args, **kwargs): ...
    def get_family(*args, **kwargs): ...
    def get_family_list(*args, **kwargs): ...
    def get_font_name(*args, **kwargs): ...
    def get_preview_entry(*args, **kwargs): ...
    def get_preview_text(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_size_entry(*args, **kwargs): ...
    def get_size_list(*args, **kwargs): ...
    def set_font_name(*args, **kwargs): ...
    def set_preview_text(*args, **kwargs): ...
    

class FontSelectionDialog(Dialog):
    def get_cancel_button(*args, **kwargs): ...
    def get_font_name(*args, **kwargs): ...
    def get_font_selection(*args, **kwargs): ...
    def get_ok_button(*args, **kwargs): ...
    def get_preview_text(*args, **kwargs): ...
    def set_font_name(*args, **kwargs): ...
    def set_preview_text(*args, **kwargs): ...
    

class Frame(Bin):
    bin = ...
    
    def get_label(*args, **kwargs): ...
    def get_label_align(*args, **kwargs): ...
    def get_label_widget(*args, **kwargs): ...
    def get_shadow_type(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_label(*args, **kwargs): ...
    def set_label_align(*args, **kwargs): ...
    def set_label_widget(*args, **kwargs): ...
    def set_shadow_type(*args, **kwargs): ...
    
    def do_compute_child_allocation(self, *args, **kwargs): ...
    

class GLArea(Widget):
    def attach_buffers(*args, **kwargs): ...
    def get_auto_render(*args, **kwargs): ...
    def get_context(*args, **kwargs): ...
    def get_error(*args, **kwargs): ...
    def get_has_alpha(*args, **kwargs): ...
    def get_has_depth_buffer(*args, **kwargs): ...
    def get_has_stencil_buffer(*args, **kwargs): ...
    def get_required_version(*args, **kwargs): ...
    def get_use_es(*args, **kwargs): ...
    def make_current(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def queue_render(*args, **kwargs): ...
    def set_auto_render(*args, **kwargs): ...
    def set_error(*args, **kwargs): ...
    def set_has_alpha(*args, **kwargs): ...
    def set_has_depth_buffer(*args, **kwargs): ...
    def set_has_stencil_buffer(*args, **kwargs): ...
    def set_required_version(*args, **kwargs): ...
    def set_use_es(*args, **kwargs): ...
    
    def do_render(self, *args, **kwargs): ...
    def do_resize(self, *args, **kwargs): ...
    

class Gesture(EventController):
    def get_bounding_box(*args, **kwargs): ...
    def get_bounding_box_center(*args, **kwargs): ...
    def get_device(*args, **kwargs): ...
    def get_group(*args, **kwargs): ...
    def get_last_event(*args, **kwargs): ...
    def get_last_updated_sequence(*args, **kwargs): ...
    def get_point(*args, **kwargs): ...
    def get_sequence_state(*args, **kwargs): ...
    def get_sequences(*args, **kwargs): ...
    def get_window(*args, **kwargs): ...
    def group(*args, **kwargs): ...
    def handles_sequence(*args, **kwargs): ...
    def is_active(*args, **kwargs): ...
    def is_grouped_with(*args, **kwargs): ...
    def is_recognized(*args, **kwargs): ...
    def set_sequence_state(*args, **kwargs): ...
    def set_state(*args, **kwargs): ...
    def set_window(*args, **kwargs): ...
    def ungroup(*args, **kwargs): ...
    

class GestureDrag(GestureSingle):
    def get_offset(*args, **kwargs): ...
    def get_start_point(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class GestureLongPress(GestureSingle):
    def new(*args, **kwargs): ...
    

class GestureMultiPress(GestureSingle):
    def get_area(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_area(*args, **kwargs): ...
    

class GesturePan(GestureDrag):
    def get_orientation(*args, **kwargs): ...
    def set_orientation(*args, **kwargs): ...
    

class GestureRotate(Gesture):
    def get_angle_delta(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class GestureSingle(Gesture):
    def get_button(*args, **kwargs): ...
    def get_current_button(*args, **kwargs): ...
    def get_current_sequence(*args, **kwargs): ...
    def get_exclusive(*args, **kwargs): ...
    def get_touch_only(*args, **kwargs): ...
    def set_button(*args, **kwargs): ...
    def set_exclusive(*args, **kwargs): ...
    def set_touch_only(*args, **kwargs): ...
    

class GestureStylus(GestureSingle):
    def get_axes(*args, **kwargs): ...
    def get_axis(*args, **kwargs): ...
    def get_device_tool(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class GestureSwipe(GestureSingle):
    def get_velocity(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class GestureZoom(Gesture):
    def get_scale_delta(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class Gradient:
    def add_color_stop(*args, **kwargs): ...
    def new_linear(*args, **kwargs): ...
    def new_radial(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def resolve(*args, **kwargs): ...
    def resolve_for_context(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class Grid(Container, Orientable):
    container = ...

    def __init__(self, row_spacing: int = 0, column_spacing: int = 0) -> None: ...
    def attach(self, child: Widget, left: int, top: int, width: int, height: int) -> None: ...
    def attach_next_to(self, child: Widget, sibling: Optional[Widget], side: PositionType, width: int, height: int) -> None: ...
    def get_baseline_row(self) -> int: ...
    def get_child_at(self, left: int, top: int) -> Optional[Widget]: ...
    def get_column_homogeneous(self) -> bool: ...
    def get_column_spacing(self) -> int: ...
    def get_row_baseline_position(self) -> BaselinePosition: ...
    def get_row_homogeneous(self) -> bool: ...
    def get_row_spacing(self) -> int: ...
    def insert_column(self, position: int) -> None: ...
    def insert_next_to(self, sibling: Widget, side: PositionType) -> None: ...
    def insert_row(self, position: int) -> None: ...
    @classmethod
    def new(cls) -> Grid: ...
    def remove_column(self, position: int) -> None: ...
    def remove_row(self, position: int) -> None: ...
    def set_baseline_row(self, row: int) -> None: ...
    def set_column_homogeneous(self, homogeneous: bool) -> None: ...
    def set_column_spacing(self, spacing: int) -> None: ...
    def set_row_baseline_position(self, row: int, pos: BaselinePosition) -> None: ...
    def set_row_homogeneous(self, homogeneous: bool) -> None: ...
    def set_row_spacing(self, spacing: int) -> None: ...
    

class HBox(Box):
    box = ...
    

class HButtonBox(ButtonBox):
    button_box = ...
    

class HPaned(Paned):
    paned = ...
    

class HSV(Widget):
    def get_color(*args, **kwargs): ...
    def get_metrics(*args, **kwargs): ...
    def is_adjusting(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_color(*args, **kwargs): ...
    def set_metrics(*args, **kwargs): ...
    def to_rgb(*args, **kwargs): ...
    
    def do_changed(self, *args, **kwargs): ...
    def do_move(self, *args, **kwargs): ...
    

class HScale(Scale):
    scale = ...
    

class HScrollbar(Scrollbar):
    scrollbar = ...
    

class HSeparator(Separator):
    separator = ...
    

class HandleBox(Bin):
    bin = ...
    
    def get_child_detached(*args, **kwargs): ...
    def get_handle_position(*args, **kwargs): ...
    def get_shadow_type(*args, **kwargs): ...
    def get_snap_edge(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_handle_position(*args, **kwargs): ...
    def set_shadow_type(*args, **kwargs): ...
    def set_snap_edge(*args, **kwargs): ...
    
    def do_child_attached(self, *args, **kwargs): ...
    def do_child_detached(self, *args, **kwargs): ...
    

class HeaderBar(Container):
    container = ...
    
    def get_custom_title(*args, **kwargs): ...
    def get_decoration_layout(*args, **kwargs): ...
    def get_has_subtitle(*args, **kwargs): ...
    def get_show_close_button(*args, **kwargs): ...
    def get_subtitle(*args, **kwargs): ...
    def get_title(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def pack_end(*args, **kwargs): ...
    def pack_start(*args, **kwargs): ...
    def set_custom_title(*args, **kwargs): ...
    def set_decoration_layout(*args, **kwargs): ...
    def set_has_subtitle(*args, **kwargs): ...
    def set_show_close_button(*args, **kwargs): ...
    def set_subtitle(self, subtitle: Optional[str]) -> None: ...
    def set_title(*args, **kwargs): ...
    

class IMContext(GObject.Object):
    parent_instance = ...
    
    def delete_surrounding(*args, **kwargs): ...
    def filter_keypress(*args, **kwargs): ...
    def focus_in(*args, **kwargs): ...
    def focus_out(*args, **kwargs): ...
    def get_preedit_string(*args, **kwargs): ...
    def get_surrounding(*args, **kwargs): ...
    def reset(*args, **kwargs): ...
    def set_client_window(*args, **kwargs): ...
    def set_cursor_location(*args, **kwargs): ...
    def set_surrounding(*args, **kwargs): ...
    def set_use_preedit(*args, **kwargs): ...
    
    def do_commit(self, *args, **kwargs): ...
    def do_delete_surrounding(self, *args, **kwargs): ...
    def do_filter_keypress(self, *args, **kwargs): ...
    def do_focus_in(self, *args, **kwargs): ...
    def do_focus_out(self, *args, **kwargs): ...
    def do_get_preedit_string(self, *args, **kwargs): ...
    def do_get_surrounding(self, *args, **kwargs): ...
    def do_preedit_changed(self, *args, **kwargs): ...
    def do_preedit_end(self, *args, **kwargs): ...
    def do_preedit_start(self, *args, **kwargs): ...
    def do_reset(self, *args, **kwargs): ...
    def do_retrieve_surrounding(self, *args, **kwargs): ...
    def do_set_client_window(self, *args, **kwargs): ...
    def do_set_cursor_location(self, *args, **kwargs): ...
    def do_set_surrounding(self, *args, **kwargs): ...
    def do_set_use_preedit(self, *args, **kwargs): ...
    

class IMContextInfo:
    context_id = ...
    context_name = ...
    default_locales = ...
    domain = ...
    domain_dirname = ...
    

class IMContextSimple:
    object = ...
    priv = ...
    
    def add_compose_file(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class IMMulticontext:
    object = ...
    priv = ...
    
    def append_menuitems(*args, **kwargs): ...
    def get_context_id(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_context_id(*args, **kwargs): ...
    

class IconFactory:
    parent_instance = ...
    priv = ...
    
    def add(*args, **kwargs): ...
    def add_default(*args, **kwargs): ...
    def lookup(*args, **kwargs): ...
    def lookup_default(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def remove_default(*args, **kwargs): ...


class IconInfo(GObject.Object):
    def get_attach_points(*args, **kwargs): ...
    def get_base_scale(*args, **kwargs): ...
    def get_base_size(*args, **kwargs): ...
    def get_builtin_pixbuf(*args, **kwargs): ...
    def get_display_name(*args, **kwargs): ...
    def get_embedded_rect(*args, **kwargs): ...
    def get_filename(*args, **kwargs): ...
    def is_symbolic(*args, **kwargs): ...
    def load_icon(self) -> GdkPixbuf.Pixbuf: ...
    def load_icon_async(*args, **kwargs): ...
    def load_icon_finish(*args, **kwargs): ...
    def load_surface(self, for_window: Optional[Gdk.Window]) -> cairo.Surface: ...
    def load_symbolic(*args, **kwargs): ...
    def load_symbolic_async(*args, **kwargs): ...
    def load_symbolic_finish(*args, **kwargs): ...
    def load_symbolic_for_context(*args, **kwargs): ...
    def load_symbolic_for_context_async(*args, **kwargs): ...
    def load_symbolic_for_context_finish(*args, **kwargs): ...
    def load_symbolic_for_style(*args, **kwargs): ...
    def new_for_pixbuf(*args, **kwargs): ...
    def set_raw_coordinates(*args, **kwargs): ...
    

class IconSet:
    def add_source(*args, **kwargs): ...
    def get_sizes(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_pixbuf(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def render_icon(*args, **kwargs): ...
    def render_icon_pixbuf(*args, **kwargs): ...
    def render_icon_surface(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class IconSource:
    def free(*args, **kwargs): ...
    def get_direction(*args, **kwargs): ...
    def get_direction_wildcarded(*args, **kwargs): ...
    def get_filename(*args, **kwargs): ...
    def get_icon_name(*args, **kwargs): ...
    def get_pixbuf(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_size_wildcarded(*args, **kwargs): ...
    def get_state(*args, **kwargs): ...
    def get_state_wildcarded(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_direction(*args, **kwargs): ...
    def set_direction_wildcarded(*args, **kwargs): ...
    def set_filename(*args, **kwargs): ...
    def set_icon_name(*args, **kwargs): ...
    def set_pixbuf(*args, **kwargs): ...
    def set_size(*args, **kwargs): ...
    def set_size_wildcarded(*args, **kwargs): ...
    def set_state(*args, **kwargs): ...
    def set_state_wildcarded(*args, **kwargs): ...
    

class IconTheme:
    parent_instance = ...
    priv = ...

    @classmethod
    def add_builtin_icon(cls, icon_name: str, size: int, pixbuf: GdkPixbuf.Pixbuf) -> None: ...
    def add_resource_path(self, path: str) -> None: ...
    def append_search_path(self, path: str) -> None: ...
    def choose_icon(self, icon_name: str, size: int, flags: IconLookupFlags) -> Optional[IconInfo]: ...
    def choose_icon_for_scale(self, icon_name: str, size: int, scale: int, flags: IconLookupFlags) -> Optional[IconInfo]: ...
    @classmethod
    def get_default(cls) -> IconTheme: ...
    def get_example_icon_name(self) -> Optional[str]: ...
    @classmethod
    def get_for_screen(cls, screen: Gdk.Screen) -> IconTheme: ...
    def get_icon_sizes(self, icon_name: str) -> list[int]: ...
    def get_search_path(self) -> list[str]: ...
    def has_icon(self, icon_name: str) -> bool: ...
    def list_contexts(self) -> list[str]: ...
    def list_icons(self, context: Optional[str]) -> list[str]: ...
    def load_icon(self, icon_name: str, size: int, flags: IconLookupFlags) -> Optional[GdkPixbuf.Pixbuf]: ...
    def load_icon_for_scale(self, icon_name: str, size: int, scale: int, flags: IconLookupFlags) -> Optional[GdkPixbuf.Pixbuf]: ...
    def load_surface(self, icon_name: str, size: int, scale: int, for_window: Optional[Gdk.Window], flags: IconLookupFlags) -> Optional[cairo.Surface]: ...
    def lookup_by_gicon(self, icon: Gio.Icon, size: int, flags: IconLookupFlags) -> Optional[IconInfo]: ...
    def lookup_by_gicon_for_scale(self, icon: Gio.Icon, size: int, scale: int, flags: IconLookupFlags) -> Optional[IconInfo]: ...
    def lookup_icon(self, icon_name: str, size: int, flags: IconLookupFlags) -> Optional[IconInfo]: ...
    def lookup_icon_for_scale(self, icon_name: str, size: int, scale: int, flags: IconLookupFlags) -> Optional[IconInfo]: ...
    @classmethod
    def new(cls) -> IconTheme: ...
    def prepend_search_path(self, path: str) -> None: ...
    def rescan_if_needed(self) -> bool: ...
    def set_custom_theme(self, theme_name: Optional[str]) -> None: ...
    def set_screen(self, screen: Gdk.Screen) -> None: ...
    def set_search_path(self, path: list[str]) -> None: ...
    
    def do_changed(self) -> None: ...
    

class IconView:
    parent = ...
    
    def convert_widget_to_bin_window_coords(*args, **kwargs): ...
    def create_drag_icon(*args, **kwargs): ...
    def enable_model_drag_dest(*args, **kwargs): ...
    def enable_model_drag_source(*args, **kwargs): ...
    def get_activate_on_single_click(*args, **kwargs): ...
    def get_cell_rect(*args, **kwargs): ...
    def get_column_spacing(*args, **kwargs): ...
    def get_columns(*args, **kwargs): ...
    def get_cursor(*args, **kwargs): ...
    def get_dest_item_at_pos(*args, **kwargs): ...
    def get_drag_dest_item(*args, **kwargs): ...
    def get_item_at_pos(*args, **kwargs): ...
    def get_item_column(*args, **kwargs): ...
    def get_item_orientation(*args, **kwargs): ...
    def get_item_padding(*args, **kwargs): ...
    def get_item_row(*args, **kwargs): ...
    def get_item_width(*args, **kwargs): ...
    def get_margin(*args, **kwargs): ...
    def get_markup_column(*args, **kwargs): ...
    def get_model(*args, **kwargs): ...
    def get_path_at_pos(*args, **kwargs): ...
    def get_pixbuf_column(*args, **kwargs): ...
    def get_reorderable(*args, **kwargs): ...
    def get_row_spacing(*args, **kwargs): ...
    def get_selected_items(*args, **kwargs): ...
    def get_selection_mode(*args, **kwargs): ...
    def get_spacing(*args, **kwargs): ...
    def get_text_column(*args, **kwargs): ...
    def get_tooltip_column(*args, **kwargs): ...
    def get_tooltip_context(*args, **kwargs): ...
    def get_visible_range(*args, **kwargs): ...
    def item_activated(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_area(*args, **kwargs): ...
    def new_with_model(*args, **kwargs): ...
    def path_is_selected(*args, **kwargs): ...
    def scroll_to_path(*args, **kwargs): ...
    def select_all(*args, **kwargs): ...
    def select_path(*args, **kwargs): ...
    def selected_foreach(*args, **kwargs): ...
    def set_activate_on_single_click(*args, **kwargs): ...
    def set_column_spacing(*args, **kwargs): ...
    def set_columns(*args, **kwargs): ...
    def set_cursor(*args, **kwargs): ...
    def set_drag_dest_item(*args, **kwargs): ...
    def set_item_orientation(*args, **kwargs): ...
    def set_item_padding(*args, **kwargs): ...
    def set_item_width(*args, **kwargs): ...
    def set_margin(*args, **kwargs): ...
    def set_markup_column(*args, **kwargs): ...
    def set_model(*args, **kwargs): ...
    def set_pixbuf_column(*args, **kwargs): ...
    def set_reorderable(*args, **kwargs): ...
    def set_row_spacing(*args, **kwargs): ...
    def set_selection_mode(*args, **kwargs): ...
    def set_spacing(*args, **kwargs): ...
    def set_text_column(*args, **kwargs): ...
    def set_tooltip_cell(*args, **kwargs): ...
    def set_tooltip_column(*args, **kwargs): ...
    def set_tooltip_item(*args, **kwargs): ...
    def unselect_all(*args, **kwargs): ...
    def unselect_path(*args, **kwargs): ...
    def unset_model_drag_dest(*args, **kwargs): ...
    def unset_model_drag_source(*args, **kwargs): ...
    
    def do_activate_cursor_item(self, *args, **kwargs): ...
    def do_item_activated(self, *args, **kwargs): ...
    def do_move_cursor(self, *args, **kwargs): ...
    def do_select_all(self, *args, **kwargs): ...
    def do_select_cursor_item(self, *args, **kwargs): ...
    def do_selection_changed(self, *args, **kwargs): ...
    def do_toggle_cursor_item(self, *args, **kwargs): ...
    def do_unselect_all(self, *args, **kwargs): ...
    

class Image(Widget):
    misc = ...

    def clear(self) -> None: ...
    def get_animation(*args, **kwargs): ...
    def get_gicon(*args, **kwargs): ...
    def get_icon_name(*args, **kwargs): ...
    def get_icon_set(*args, **kwargs): ...
    def get_pixbuf(*args, **kwargs): ...
    def get_pixel_size(*args, **kwargs): ...
    def get_stock(*args, **kwargs): ...
    def get_storage_type(*args, **kwargs): ...
    @classmethod
    def new(cls) -> Widget: ...
    @classmethod
    def new_from_animation(cls, animation: GdkPixbuf.PixbufAnimation) -> Widget: ...
    @classmethod
    def new_from_file(cls, filename: str) -> Image: ...
    @classmethod
    def new_from_gicon(cls, icon: Gio.Icon, size: IconSize) -> Widget: ...
    @classmethod
    def new_from_icon_name(cls, icon_name: Optional[str], size: IconSize) -> Image: ...
    @classmethod
    def new_from_icon_set(cls, *args, **kwargs): ...
    @classmethod
    def new_from_pixbuf(cls, pixbuf: Optional[GdkPixbuf.Pixbuf]) -> Widget: ...
    @classmethod
    def new_from_resource(cls, *args, **kwargs): ...
    @classmethod
    def new_from_stock(cls, *args, **kwargs): ...
    @classmethod
    def new_from_surface(cls, surface: Optional[cairo.Surface]) -> Image: ...
    def set_from_animation(self, animation: GdkPixbuf.PixbufAnimation) -> None: ...
    def set_from_file(self, filename: Optional[str]) -> None: ...
    def set_from_gicon(self, icon: Gio.Icon, size: int) -> None: ...
    def set_from_icon_name(self, icon_name: Optional[str], size: IconSize) -> None: ...
    def set_from_icon_set(*args, **kwargs): ...
    def set_from_pixbuf(self, pixbuf: Optional[GdkPixbuf.Pixbuf]) -> None: ...
    def set_from_resource(*args, **kwargs): ...
    def set_from_stock(*args, **kwargs): ...
    def set_from_surface(self, surface: Optional[cairo.Surface]) -> None: ...
    def set_pixel_size(*args, **kwargs): ...
    

class ImageMenuItem(MenuItem):
    menu_item = ...
    
    def get_always_show_image(*args, **kwargs): ...
    def get_image(*args, **kwargs): ...
    def get_use_stock(*args, **kwargs): ...
    def new_from_stock(*args, **kwargs): ...
    def set_accel_group(*args, **kwargs): ...
    def set_always_show_image(*args, **kwargs): ...
    def set_image(*args, **kwargs): ...
    def set_use_stock(*args, **kwargs): ...
    

class InfoBar(Box):
    parent = ...
    
    def add_action_widget(*args, **kwargs): ...
    def add_button(*args, **kwargs): ...
    def get_action_area(*args, **kwargs): ...
    def get_content_area(*args, **kwargs): ...
    def get_message_type(*args, **kwargs): ...
    def get_revealed(self) -> bool: ...
    def get_show_close_button(*args, **kwargs): ...
    def response(*args, **kwargs): ...
    def set_default_response(*args, **kwargs): ...
    def set_message_type(*args, **kwargs): ...
    def set_response_sensitive(*args, **kwargs): ...
    def set_revealed(self, revealed: bool) -> None: ...
    def set_show_close_button(*args, **kwargs): ...
    
    def do_close(self, *args, **kwargs): ...
    def do_response(self, *args, **kwargs): ...
    

class Invisible:
    widget = ...
    
    def new(*args, **kwargs): ...
    def new_for_screen(*args, **kwargs): ...
    def set_screen(*args, **kwargs): ...


class Label(Misc):
    misc = ...

    def __init__(self, label: str = '', use_markup: bool = False) -> None: ...
    def get_angle(self) -> float: ...
    def get_attributes(self) -> Optional[Pango.AttrList]: ...
    def get_current_uri(self) -> str: ...
    def get_ellipsize(self) -> Pango.EllipsizeMode: ...
    def get_justify(self) -> Justification: ...
    def get_label(self) -> str: ...
    def get_layout(self) -> Pango.Layout: ...
    def get_layout_offsets(self) -> tuple[int, int]: ...
    def get_line_wrap(self) -> bool: ...
    def get_line_wrap_mode(self) -> Pango.WrapMode: ...
    def get_lines(self) -> int: ...
    def get_max_width_chars(self) -> int: ...
    def get_mnemonic_keyval(self) -> int: ...
    def get_mnemonic_widget(self) -> Optional[Widget]: ...
    def get_selectable(self) -> bool: ...
    def get_selection_bounds(self) -> tuple[bool, int, int]: ...
    def get_single_line_mode(self) -> bool: ...
    def get_text(self) -> str: ...
    def get_track_visited_links(self) -> bool: ...
    def get_use_markup(self) -> bool: ...
    def get_use_underline(self) -> bool: ...
    def get_width_chars(self) -> int: ...
    def get_xalign(self) -> int: ...
    def get_yalign(self) -> int: ...
    @classmethod
    def new(cls, str: str) -> Label: ...
    @classmethod
    def new_with_mnemonic(cls, str: str) -> Label: ...
    def select_region(self, start_offset: int, end_offset: int) -> None: ...
    def set_angle(self, angle: float) -> None: ...
    def set_attributes(self, attrs: Optional[Pango.AttrList]) -> None: ...
    def set_ellipsize(self, mode: Pango.EllipsizeMode) -> None: ...
    def set_justify(self, jtype: Justification) -> None: ...
    def set_label(self, label: str) -> None: ...
    def set_line_wrap(self, wrap: bool) -> None: ...
    def set_line_wrap_mode(self, wrap_mode: Pango.WrapMode) -> None: ...
    def set_lines(self, lines: int) -> None: ...
    def set_markup(self, str: str) -> None: ...
    def set_markup_with_mnemonic(self, str: str) -> None: ...
    def set_max_width_chars(self, n_chars: int) -> None: ...
    def set_mnemonic_widget(self, widget: Optional[Widget]) -> None: ...
    def set_pattern(self, pattern: str) -> None: ...
    def set_selectable(self, setting: bool) -> None: ...
    def set_single_line_mode(self, single_line_mode: bool) -> None: ...
    def set_text(self, str: str) -> None: ...
    def set_text_with_mnemonic(self, str: str) -> None: ...
    def set_track_visited_links(self, track_links: bool) -> None: ...
    def set_use_markup(self, setting: bool) -> None: ...
    def set_use_underline(self, setting: bool) -> None: ...
    def set_width_chars(self, n_chars: int) -> None: ...
    def set_xalign(self, xalign: float) -> None: ...
    def set_yalign(self, yalign: float) -> None: ...
    
    def do_activate_link(self, *args, **kwargs): ...
    def do_copy_clipboard(self, *args, **kwargs): ...
    def do_move_cursor(self, *args, **kwargs): ...
    def do_populate_popup(self, *args, **kwargs): ...
    

class LabelSelectionInfo: ...

class Layout:
    container = ...
    
    def get_bin_window(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def move(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def put(*args, **kwargs): ...
    def set_size(*args, **kwargs): ...
    

class LevelBar:
    parent = ...
    
    def add_offset_value(*args, **kwargs): ...
    def get_inverted(*args, **kwargs): ...
    def get_max_value(*args, **kwargs): ...
    def get_min_value(*args, **kwargs): ...
    def get_mode(*args, **kwargs): ...
    def get_offset_value(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_for_interval(*args, **kwargs): ...
    def remove_offset_value(*args, **kwargs): ...
    def set_inverted(*args, **kwargs): ...
    def set_max_value(*args, **kwargs): ...
    def set_min_value(*args, **kwargs): ...
    def set_mode(*args, **kwargs): ...
    def set_value(*args, **kwargs): ...
    
    def do_offset_changed(self, *args, **kwargs): ...
    

class LinkButton(Button):
    def get_uri(self) -> str: ...
    def get_visited(*args, **kwargs): ...
    def set_uri(self, uri: str) -> None: ...
    def set_visited(*args, **kwargs): ...
    
    def do_activate_link(self, *args, **kwargs): ...


class ListBox(Container):
    def bind_model(self, model: Optional[Gio.ListModel], create_widget_func: Optional[Callable[..., Any]], *user_data: Optional[Any]) -> None: ...
    def drag_highlight_row(self, row: ListBoxRow) -> None: ...
    def drag_unhighlight_row(self) -> None: ...
    def get_activate_on_single_click(self) -> bool: ...
    def get_adjustment(self) -> Adjustment: ...
    def get_row_at_index(self, index: int) -> Optional[ListBoxRow]: ...
    def get_row_at_y(self, y: int) -> Optional[ListBoxRow]: ...
    def get_selected_row(self) -> ListBoxRow: ...
    def get_selected_rows(self) -> list[ListBoxRow]: ...
    def get_selection_mode(self) -> SelectionMode: ...
    def insert(self, child: Widget, position: int) -> None: ...
    def invalidate_filter(self) -> None: ...
    def invalidate_headers(self) -> None: ...
    def invalidate_sort(self) -> None: ...
    @classmethod
    def new(cls) -> ListBox: ...
    def prepend(self, widget: Widget) -> None: ...
    def select_all(self) -> None: ...
    def select_row(self, row: Optional[Widget]) -> None: ...
    def selected_foreach(*args, **kwargs): ...
    def set_activate_on_single_click(self, single: bool) -> None: ...
    def set_adjustment(self, adjustment: Optional[Adjustment]) -> None: ...
    def set_filter_func(self, filter_func: Optional[Callable[..., Any]], user_data: Optional[Any] = None) -> None: ...
    def set_header_func(self, update_header: Optional[Callable[..., Any]], user_data: Optional[Any] = None) -> None: ...
    def set_placeholder(self, placeholder: Optional[Widget]) -> None: ...
    def set_selection_mode(self, mode: SelectionMode) -> None: ...
    def set_sort_func(self, sort_func: Optional[Callable[..., Any]], user_data: Optional[Any] = None) -> None: ...
    def unselect_all(self) -> None: ...
    def unselect_row(self, row: Widget) -> None: ...
    
    def do_activate_cursor_row(self, *args, **kwargs): ...
    def do_move_cursor(self, *args, **kwargs): ...
    def do_row_activated(self, *args, **kwargs): ...
    def do_row_selected(self, *args, **kwargs): ...
    def do_select_all(self, *args, **kwargs): ...
    def do_selected_rows_changed(self, *args, **kwargs): ...
    def do_toggle_cursor_row(self, *args, **kwargs): ...
    def do_unselect_all(self, *args, **kwargs): ...


class ListBoxRow(Bin, Actionable):
    def changed(self) -> None: ...
    def get_activatable(self) -> bool: ...
    def get_header(self) -> Optional[Widget]: ...
    def get_index(self) -> int: ...
    def get_selectable(self) -> bool: ...
    def is_selected(self) -> bool: ...
    def new(*args, **kwargs): ...
    def set_activatable(self, activatable: bool) -> None: ...
    def set_header(self, header: Optional[Widget]) -> None: ...
    def set_selectable(self, selectable: bool) -> None: ...
    
    def do_activate(self, *args, **kwargs): ...
    

class ListStore(GObject.Object, TreeModel, TreeSortable, TreeDragDest, TreeDragSource):
    parent = ...
    priv = ...
    
    def __init__(self, *args: Any) -> None: ...
    def append(self, row: Optional[list[Any]] = None) -> TreeIter: ...
    def clear(self) -> None: ...
    def insert(*args, **kwargs): ...
    def insert_after(*args, **kwargs): ...
    def insert_before(*args, **kwargs): ...
    def insert_with_valuesv(*args, **kwargs): ...
    def iter_is_valid(*args, **kwargs): ...
    def move_after(*args, **kwargs): ...
    def move_before(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def prepend(self, row: Optional[list[Any]] = None) -> TreeIter: ...
    def remove(self, iter: TreeIter) -> bool: ...
    def reorder(*args, **kwargs): ...
    def set(self, iter: TreeIter, columns: list[int], values: list[Any]) -> None: ...
    def set_column_types(*args, **kwargs): ...
    def set_value(self, iter: TreeIter, column: int, value: Any) -> None: ...
    def swap(*args, **kwargs): ...
    

class LockButton:
    parent = ...
    
    def get_permission(*args, **kwargs): ...
    def set_permission(*args, **kwargs): ...


class Menu(MenuShell):
    menu_shell = ...
    
    def attach(*args, **kwargs): ...
    def attach_to_widget(self, attach_widget: Widget, detacher: Optional[Callable[[Widget, Menu], Any]]) -> None: ...
    def detach(*args, **kwargs): ...
    def get_accel_group(*args, **kwargs): ...
    def get_accel_path(*args, **kwargs): ...
    def get_active(*args, **kwargs): ...
    def get_attach_widget(*args, **kwargs): ...
    def get_for_attach_widget(*args, **kwargs): ...
    def get_monitor(*args, **kwargs): ...
    def get_reserve_toggle_size(*args, **kwargs): ...
    def get_tearoff_state(*args, **kwargs): ...
    def get_title(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_model(*args, **kwargs): ...
    def place_on_monitor(*args, **kwargs): ...
    def popdown(*args, **kwargs): ...
    def popup(self, parent_menu_shell: Optional[Widget], parent_menu_item: Optional[Widget], func: Optional[Callable[..., Any]], data: Optional[Any], button: int, activate_time: int) -> None: ...
    def popup_at_pointer(self, trigger_event: Optional[Gdk.Event] = None) -> None: ...
    def popup_at_rect(*args, **kwargs): ...
    def popup_at_widget(*args, **kwargs): ...
    def popup_for_device(*args, **kwargs): ...
    def reorder_child(*args, **kwargs): ...
    def reposition(*args, **kwargs): ...
    def set_accel_group(*args, **kwargs): ...
    def set_active(*args, **kwargs): ...
    def set_monitor(*args, **kwargs): ...
    def set_reserve_toggle_size(*args, **kwargs): ...
    def set_screen(*args, **kwargs): ...
    def set_tearoff_state(*args, **kwargs): ...
    def set_title(*args, **kwargs): ...
    

class MenuBar:
    menu_shell = ...
    
    def get_child_pack_direction(*args, **kwargs): ...
    def get_pack_direction(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_model(*args, **kwargs): ...
    def set_child_pack_direction(*args, **kwargs): ...
    def set_pack_direction(*args, **kwargs): ...


class MenuButton(ToggleButton):
    parent = ...
    def get_align_widget(self) -> Optional[Widget]: ...
    def get_direction(self) -> ArrowType: ...
    def get_menu_model(self) -> Optional[Gio.MenuModel]: ...
    def get_popover(self) -> Optional[Popover]: ...
    def get_popup(self) -> Optional[Menu]: ...
    def get_use_popover(self) -> bool: ...
    @classmethod
    def new(cls) -> MenuButton: ...
    def set_align_widget(self, align_widget: Optional[Widget]) -> None: ...
    def set_direction(self, direction: ArrowType) -> None: ...
    def set_menu_model(self, menu_model: Optional[Gio.MenuModel]) -> None: ...
    def set_popover(self, popover: Optional[Popover]) -> None: ...
    def set_popup(self, popup: Optional[Menu]) -> None: ...
    def set_use_popover(self, use_popover: bool) -> None: ...


class MenuItem(Bin, Actionable):
    bin = ...

    def __init__(self, label: Optional[str] = None) -> MenuItem: ...
    def deselect(*args, **kwargs): ...
    def get_accel_path(*args, **kwargs): ...
    def get_label(*args, **kwargs): ...
    def get_reserve_indicator(*args, **kwargs): ...
    def get_right_justified(*args, **kwargs): ...
    def get_submenu(*args, **kwargs): ...
    def get_use_underline(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    @classmethod
    def new_with_label(cls, label: str) -> MenuItem: ...
    @classmethod
    def new_with_mnemonic(cls, label: str) -> MenuItem: ...
    def select(*args, **kwargs): ...
    def set_label(self, label: str) -> None: ...
    def set_reserve_indicator(*args, **kwargs): ...
    def set_right_justified(*args, **kwargs): ...
    def set_submenu(self, submenu: Optional[Menu]) -> None: ...
    def set_use_underline(*args, **kwargs): ...
    def toggle_size_allocate(*args, **kwargs): ...
    def toggle_size_request(*args, **kwargs): ...
    
    def do_activate(self, *args, **kwargs): ...
    def do_activate_item(self, *args, **kwargs): ...
    def do_deselect(self, *args, **kwargs): ...
    def do_get_label(self, *args, **kwargs): ...
    def do_select(self, *args, **kwargs): ...
    def do_set_label(self, *args, **kwargs): ...
    def do_toggle_size_allocate(self, *args, **kwargs): ...
    def do_toggle_size_request(self, *args, **kwargs): ...
    

class MenuShell(Container):
    container = ...
    
    def activate_item(*args, **kwargs): ...
    def append(self, child: MenuItem) -> None: ...
    def bind_model(*args, **kwargs): ...
    def cancel(*args, **kwargs): ...
    def deactivate(*args, **kwargs): ...
    def deselect(*args, **kwargs): ...
    def get_parent_shell(*args, **kwargs): ...
    def get_selected_item(*args, **kwargs): ...
    def get_take_focus(*args, **kwargs): ...
    def insert(*args, **kwargs): ...
    def prepend(self, child: MenuItem) -> None: ...
    def select_first(*args, **kwargs): ...
    def select_item(*args, **kwargs): ...
    def set_take_focus(*args, **kwargs): ...
    
    def do_activate_current(self, *args, **kwargs): ...
    def do_cancel(self, *args, **kwargs): ...
    def do_deactivate(self, *args, **kwargs): ...
    def do_get_popup_delay(self, *args, **kwargs): ...
    def do_insert(self, *args, **kwargs): ...
    def do_move_current(self, *args, **kwargs): ...
    def do_move_selected(self, *args, **kwargs): ...
    def do_select_item(self, *args, **kwargs): ...
    def do_selection_done(self, *args, **kwargs): ...
    

class MenuToolButton:
    def get_menu(*args, **kwargs): ...
    def set_arrow_tooltip_markup(*args, **kwargs): ...
    def set_arrow_tooltip_text(*args, **kwargs): ...
    def set_menu(*args, **kwargs): ...
    
    def do_show_menu(self, *args, **kwargs): ...
    

class MessageDialog(Dialog):
    def format_secondary_markup(self, message_format: str) -> None: ...
    def format_secondary_text(*args, **kwargs): ...
    def get_image(*args, **kwargs): ...
    def get_message_area(*args, **kwargs): ...
    def set_image(*args, **kwargs): ...
    def set_markup(*args, **kwargs): ...
    

class Misc(Widget):
    widget = ...
    
    def get_alignment(*args, **kwargs): ...
    def get_padding(*args, **kwargs): ...
    def set_alignment(*args, **kwargs): ...
    def set_padding(*args, **kwargs): ...
    

class ModelButton(Button): ...

class MountOperation:
    def get_parent(*args, **kwargs): ...
    def get_screen(*args, **kwargs): ...
    def is_showing(*args, **kwargs): ...
    def set_parent(*args, **kwargs): ...
    def set_screen(*args, **kwargs): ...
    

class NativeDialog(GObject.Object):
    parent_instance = ...
    
    def destroy(self) -> None: ...
    def get_modal(self) -> bool: ...
    def get_title(self) -> Optional[str]: ...
    def get_transient_for(self) -> Optional[Window]: ...
    def get_visible(self) -> bool: ...
    def hide(self) -> None: ...
    def run(self) -> int: ...
    def set_modal(self, modal: bool) -> None: ...
    def set_title(self, title: str) -> None: ...
    def set_transient_for(self, parent: Optional[Window]) -> None: ...
    def show(self) -> None: ...
    
    def do_hide(self, *args, **kwargs): ...
    def do_response(self, *args, **kwargs): ...
    def do_show(self, *args, **kwargs): ...
    

class Notebook(Container):
    container = ...
    
    def append_page(*args, **kwargs): ...
    def append_page_menu(*args, **kwargs): ...
    def detach_tab(*args, **kwargs): ...
    def get_action_widget(*args, **kwargs): ...
    def get_current_page(*args, **kwargs): ...
    def get_group_name(*args, **kwargs): ...
    def get_menu_label(*args, **kwargs): ...
    def get_menu_label_text(*args, **kwargs): ...
    def get_n_pages(*args, **kwargs): ...
    def get_nth_page(*args, **kwargs): ...
    def get_scrollable(*args, **kwargs): ...
    def get_show_border(*args, **kwargs): ...
    def get_show_tabs(*args, **kwargs): ...
    def get_tab_detachable(*args, **kwargs): ...
    def get_tab_hborder(*args, **kwargs): ...
    def get_tab_label(*args, **kwargs): ...
    def get_tab_label_text(*args, **kwargs): ...
    def get_tab_pos(*args, **kwargs): ...
    def get_tab_reorderable(*args, **kwargs): ...
    def get_tab_vborder(*args, **kwargs): ...
    def insert_page(*args, **kwargs): ...
    def insert_page_menu(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def next_page(*args, **kwargs): ...
    def page_num(*args, **kwargs): ...
    def popup_disable(*args, **kwargs): ...
    def popup_enable(*args, **kwargs): ...
    def prepend_page(*args, **kwargs): ...
    def prepend_page_menu(*args, **kwargs): ...
    def prev_page(*args, **kwargs): ...
    def remove_page(*args, **kwargs): ...
    def reorder_child(*args, **kwargs): ...
    def set_action_widget(*args, **kwargs): ...
    def set_current_page(self, page_num: int) -> None: ...
    def set_group_name(*args, **kwargs): ...
    def set_menu_label(*args, **kwargs): ...
    def set_menu_label_text(*args, **kwargs): ...
    def set_scrollable(*args, **kwargs): ...
    def set_show_border(*args, **kwargs): ...
    def set_show_tabs(*args, **kwargs): ...
    def set_tab_detachable(*args, **kwargs): ...
    def set_tab_label(*args, **kwargs): ...
    def set_tab_label_text(*args, **kwargs): ...
    def set_tab_pos(*args, **kwargs): ...
    def set_tab_reorderable(*args, **kwargs): ...
    
    def do_change_current_page(self, *args, **kwargs): ...
    def do_focus_tab(self, *args, **kwargs): ...
    def do_insert_page(self, *args, **kwargs): ...
    def do_move_focus_out(self, *args, **kwargs): ...
    def do_page_added(self, *args, **kwargs): ...
    def do_page_removed(self, *args, **kwargs): ...
    def do_page_reordered(self, *args, **kwargs): ...
    def do_reorder_tab(self, *args, **kwargs): ...
    def do_select_page(self, *args, **kwargs): ...
    def do_switch_page(self, *args, **kwargs): ...
    

class NumerableIcon:
    parent = ...
    
    def get_background_gicon(*args, **kwargs): ...
    def get_background_icon_name(*args, **kwargs): ...
    def get_count(*args, **kwargs): ...
    def get_label(*args, **kwargs): ...
    def get_style_context(*args, **kwargs): ...
    def new_with_style_context(*args, **kwargs): ...
    def set_background_gicon(*args, **kwargs): ...
    def set_background_icon_name(*args, **kwargs): ...
    def set_count(*args, **kwargs): ...
    def set_label(*args, **kwargs): ...
    def set_style_context(*args, **kwargs): ...
    

class OffscreenWindow:
    parent_object = ...
    
    def get_pixbuf(*args, **kwargs): ...
    def get_surface(*args, **kwargs): ...


class Orientable(GObject.GInterface):
    def get_orientation(self) -> Orientation: ...
    def set_orientation(self, orientation: Orientation) -> None: ...
    

class Overlay(Bin):
    parent = ...
    
    def add_overlay(self, widget: Widget) -> None: ...
    def get_overlay_pass_through(self, widget: Widget) -> bool: ...
    @classmethod
    def new(cls) -> Overlay: ...
    def reorder_overlay(self, child: Widget, index: int) -> None: ...
    def set_overlay_pass_through(self, widget: Widget, pass_through: bool) -> None: ...
    
    def do_get_child_position(self, widget: Widget, allocation: Gdk.Rectangle) -> bool: ...


class PadActionEntry:
    action_name = ...
    index = ...
    label = ...
    mode = ...
    type = ...
    

class PadController:
    def new(*args, **kwargs): ...
    def set_action(*args, **kwargs): ...
    def set_action_entries(*args, **kwargs): ...
    

class PageRange:
    end = ...
    start = ...
    

class PageSetup:
    def copy(*args, **kwargs): ...
    def get_bottom_margin(*args, **kwargs): ...
    def get_left_margin(*args, **kwargs): ...
    def get_orientation(*args, **kwargs): ...
    def get_page_height(*args, **kwargs): ...
    def get_page_width(*args, **kwargs): ...
    def get_paper_height(*args, **kwargs): ...
    def get_paper_size(*args, **kwargs): ...
    def get_paper_width(*args, **kwargs): ...
    def get_right_margin(*args, **kwargs): ...
    def get_top_margin(*args, **kwargs): ...
    def load_file(*args, **kwargs): ...
    def load_key_file(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_file(*args, **kwargs): ...
    def new_from_gvariant(*args, **kwargs): ...
    def new_from_key_file(*args, **kwargs): ...
    def set_bottom_margin(*args, **kwargs): ...
    def set_left_margin(*args, **kwargs): ...
    def set_orientation(*args, **kwargs): ...
    def set_paper_size(*args, **kwargs): ...
    def set_paper_size_and_default_margins(*args, **kwargs): ...
    def set_right_margin(*args, **kwargs): ...
    def set_top_margin(*args, **kwargs): ...
    def to_file(*args, **kwargs): ...
    def to_gvariant(*args, **kwargs): ...
    def to_key_file(*args, **kwargs): ...
    

class Paned(Container):
    container = ...

    def add1(self, child: Widget) -> None: ...
    def add2(self, child: Widget) -> None: ...
    def get_child1(self) -> Optional[Widget]: ...
    def get_child2(self) -> Optional[Widget]: ...
    def get_handle_window(self) -> Gdk.Window: ...
    def get_position(self) -> int: ...
    def get_wide_handle(self) -> bool: ...
    def new(*args, **kwargs): ...
    def pack1(self, child: Widget, resize: bool, shrink: bool) -> None: ...
    def pack2(self, child: Widget, resize: bool, shrink: bool) -> None: ...
    def set_position(self, position: int) -> None: ...
    def set_wide_handle(self, wide: bool) -> None: ...
    
    def do_accept_position(self, *args, **kwargs): ...
    def do_cancel_position(self, *args, **kwargs): ...
    def do_cycle_child_focus(self, *args, **kwargs): ...
    def do_cycle_handle_focus(self, *args, **kwargs): ...
    def do_move_handle(self, *args, **kwargs): ...
    def do_toggle_handle_focus(self, *args, **kwargs): ...
    

class PaperSize:
    def free(*args, **kwargs): ...
    def get_default(*args, **kwargs): ...
    def get_default_bottom_margin(*args, **kwargs): ...
    def get_default_left_margin(*args, **kwargs): ...
    def get_default_right_margin(*args, **kwargs): ...
    def get_default_top_margin(*args, **kwargs): ...
    def get_display_name(*args, **kwargs): ...
    def get_height(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def get_paper_sizes(*args, **kwargs): ...
    def get_ppd_name(*args, **kwargs): ...
    def get_width(*args, **kwargs): ...
    def is_custom(*args, **kwargs): ...
    def is_equal(*args, **kwargs): ...
    def is_ipp(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_custom(*args, **kwargs): ...
    def new_from_gvariant(*args, **kwargs): ...
    def new_from_ipp(*args, **kwargs): ...
    def new_from_key_file(*args, **kwargs): ...
    def new_from_ppd(*args, **kwargs): ...
    def set_size(*args, **kwargs): ...
    def to_gvariant(*args, **kwargs): ...
    def to_key_file(*args, **kwargs): ...
    

class PlacesSidebar:
    def add_shortcut(*args, **kwargs): ...
    def get_local_only(*args, **kwargs): ...
    def get_location(*args, **kwargs): ...
    def get_nth_bookmark(*args, **kwargs): ...
    def get_open_flags(*args, **kwargs): ...
    def get_show_connect_to_server(*args, **kwargs): ...
    def get_show_desktop(*args, **kwargs): ...
    def get_show_enter_location(*args, **kwargs): ...
    def get_show_other_locations(*args, **kwargs): ...
    def get_show_recent(*args, **kwargs): ...
    def get_show_starred_location(*args, **kwargs): ...
    def get_show_trash(*args, **kwargs): ...
    def list_shortcuts(*args, **kwargs): ...
    def remove_shortcut(*args, **kwargs): ...
    def set_drop_targets_visible(*args, **kwargs): ...
    def set_local_only(*args, **kwargs): ...
    def set_location(*args, **kwargs): ...
    def set_open_flags(*args, **kwargs): ...
    def set_show_connect_to_server(*args, **kwargs): ...
    def set_show_desktop(*args, **kwargs): ...
    def set_show_enter_location(*args, **kwargs): ...
    def set_show_other_locations(*args, **kwargs): ...
    def set_show_recent(*args, **kwargs): ...
    def set_show_starred_location(*args, **kwargs): ...
    def set_show_trash(*args, **kwargs): ...
    

class Plug:
    window = ...
    
    def construct(*args, **kwargs): ...
    def construct_for_display(*args, **kwargs): ...
    def get_embedded(*args, **kwargs): ...
    def get_id(*args, **kwargs): ...
    def get_socket_window(*args, **kwargs): ...
    def new_for_display(*args, **kwargs): ...
    
    def do_embedded(self, *args, **kwargs): ...
    

class Popover(Bin):
    def bind_model(self, model: Optional[Gio.MenuModel], action_namespace: Optional[str] = ...) -> None: ...
    def get_constrain_to(*args, **kwargs): ...
    def get_default_widget(*args, **kwargs): ...
    def get_modal(*args, **kwargs): ...
    def get_pointing_to(*args, **kwargs): ...
    def get_position(*args, **kwargs): ...
    def get_relative_to(*args, **kwargs): ...
    def get_transitions_enabled(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    @classmethod
    def new_from_model(cls, relative_to: Optional[Widget], model: Gio.MenuModel) -> Popover: ...
    def popdown(self) -> None: ...
    def popup(self) -> None: ...
    def set_constrain_to(*args, **kwargs): ...
    def set_default_widget(self, widget: Optional[Widget]) -> None: ...
    def set_modal(self, modal: bool) -> None: ...
    def set_pointing_to(self, rect: Gdk.Rectangle) -> None: ...
    def set_position(self, position: PositionType) -> None: ...
    def set_relative_to(self, relative_to: Optional[Widget]) -> None: ...
    def set_transitions_enabled(*args, **kwargs): ...
    
    def do_closed(self, *args, **kwargs): ...
    

class PopoverMenu(Popover):
    def open_submenu(*args, **kwargs): ...
    

class PrintContext:
    def create_pango_context(*args, **kwargs): ...
    def create_pango_layout(*args, **kwargs): ...
    def get_cairo_context(*args, **kwargs): ...
    def get_dpi_x(*args, **kwargs): ...
    def get_dpi_y(*args, **kwargs): ...
    def get_hard_margins(*args, **kwargs): ...
    def get_height(*args, **kwargs): ...
    def get_page_setup(*args, **kwargs): ...
    def get_pango_fontmap(*args, **kwargs): ...
    def get_width(*args, **kwargs): ...
    def set_cairo_context(*args, **kwargs): ...
    

class PrintOperation:
    parent_instance = ...
    priv = ...
    
    def cancel(*args, **kwargs): ...
    def draw_page_finish(*args, **kwargs): ...
    def get_default_page_setup(*args, **kwargs): ...
    def get_embed_page_setup(*args, **kwargs): ...
    def get_error(*args, **kwargs): ...
    def get_has_selection(*args, **kwargs): ...
    def get_n_pages_to_print(*args, **kwargs): ...
    def get_print_settings(*args, **kwargs): ...
    def get_status(*args, **kwargs): ...
    def get_status_string(*args, **kwargs): ...
    def get_support_selection(*args, **kwargs): ...
    def is_finished(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def run(*args, **kwargs): ...
    def set_allow_async(*args, **kwargs): ...
    def set_current_page(*args, **kwargs): ...
    def set_custom_tab_label(*args, **kwargs): ...
    def set_default_page_setup(*args, **kwargs): ...
    def set_defer_drawing(*args, **kwargs): ...
    def set_embed_page_setup(*args, **kwargs): ...
    def set_export_filename(*args, **kwargs): ...
    def set_has_selection(*args, **kwargs): ...
    def set_job_name(*args, **kwargs): ...
    def set_n_pages(*args, **kwargs): ...
    def set_print_settings(*args, **kwargs): ...
    def set_show_progress(*args, **kwargs): ...
    def set_support_selection(*args, **kwargs): ...
    def set_track_print_status(*args, **kwargs): ...
    def set_unit(*args, **kwargs): ...
    def set_use_full_page(*args, **kwargs): ...
    
    def do_begin_print(self, *args, **kwargs): ...
    def do_custom_widget_apply(self, *args, **kwargs): ...
    def do_done(self, *args, **kwargs): ...
    def do_draw_page(self, *args, **kwargs): ...
    def do_end_print(self, *args, **kwargs): ...
    def do_paginate(self, *args, **kwargs): ...
    def do_preview(self, *args, **kwargs): ...
    def do_request_page_setup(self, *args, **kwargs): ...
    def do_status_changed(self, *args, **kwargs): ...
    def do_update_custom_widget(self, *args, **kwargs): ...
    

class PrintOperationPreview:
    def end_preview(*args, **kwargs): ...
    def is_selected(*args, **kwargs): ...
    def render_page(*args, **kwargs): ...
    

class PrintSettings:
    def copy(*args, **kwargs): ...
    def foreach(*args, **kwargs): ...
    def get(*args, **kwargs): ...
    def get_bool(*args, **kwargs): ...
    def get_collate(*args, **kwargs): ...
    def get_default_source(*args, **kwargs): ...
    def get_dither(*args, **kwargs): ...
    def get_double(*args, **kwargs): ...
    def get_double_with_default(*args, **kwargs): ...
    def get_duplex(*args, **kwargs): ...
    def get_finishings(*args, **kwargs): ...
    def get_int(*args, **kwargs): ...
    def get_int_with_default(*args, **kwargs): ...
    def get_length(*args, **kwargs): ...
    def get_media_type(*args, **kwargs): ...
    def get_n_copies(*args, **kwargs): ...
    def get_number_up(*args, **kwargs): ...
    def get_number_up_layout(*args, **kwargs): ...
    def get_orientation(*args, **kwargs): ...
    def get_output_bin(*args, **kwargs): ...
    def get_page_ranges(*args, **kwargs): ...
    def get_page_set(*args, **kwargs): ...
    def get_paper_height(*args, **kwargs): ...
    def get_paper_size(*args, **kwargs): ...
    def get_paper_width(*args, **kwargs): ...
    def get_print_pages(*args, **kwargs): ...
    def get_printer(*args, **kwargs): ...
    def get_printer_lpi(*args, **kwargs): ...
    def get_quality(*args, **kwargs): ...
    def get_resolution(*args, **kwargs): ...
    def get_resolution_x(*args, **kwargs): ...
    def get_resolution_y(*args, **kwargs): ...
    def get_reverse(*args, **kwargs): ...
    def get_scale(*args, **kwargs): ...
    def get_use_color(*args, **kwargs): ...
    def has_key(*args, **kwargs): ...
    def load_file(*args, **kwargs): ...
    def load_key_file(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_from_file(*args, **kwargs): ...
    def new_from_gvariant(*args, **kwargs): ...
    def new_from_key_file(*args, **kwargs): ...
    def set(*args, **kwargs): ...
    def set_bool(*args, **kwargs): ...
    def set_collate(*args, **kwargs): ...
    def set_default_source(*args, **kwargs): ...
    def set_dither(*args, **kwargs): ...
    def set_double(*args, **kwargs): ...
    def set_duplex(*args, **kwargs): ...
    def set_finishings(*args, **kwargs): ...
    def set_int(*args, **kwargs): ...
    def set_length(*args, **kwargs): ...
    def set_media_type(*args, **kwargs): ...
    def set_n_copies(*args, **kwargs): ...
    def set_number_up(*args, **kwargs): ...
    def set_number_up_layout(*args, **kwargs): ...
    def set_orientation(*args, **kwargs): ...
    def set_output_bin(*args, **kwargs): ...
    def set_page_ranges(*args, **kwargs): ...
    def set_page_set(*args, **kwargs): ...
    def set_paper_height(*args, **kwargs): ...
    def set_paper_size(*args, **kwargs): ...
    def set_paper_width(*args, **kwargs): ...
    def set_print_pages(*args, **kwargs): ...
    def set_printer(*args, **kwargs): ...
    def set_printer_lpi(*args, **kwargs): ...
    def set_quality(*args, **kwargs): ...
    def set_resolution(*args, **kwargs): ...
    def set_resolution_xy(*args, **kwargs): ...
    def set_reverse(*args, **kwargs): ...
    def set_scale(*args, **kwargs): ...
    def set_use_color(*args, **kwargs): ...
    def to_file(*args, **kwargs): ...
    def to_gvariant(*args, **kwargs): ...
    def to_key_file(*args, **kwargs): ...
    def unset(*args, **kwargs): ...
    

class ProgressBar(Widget, Orientable):
    parent = ...
    
    def get_ellipsize(self) -> Pango.EllipsizeMode: ...
    def get_fraction(self) -> float: ...
    def get_inverted(self) -> bool: ...
    def get_pulse_step(self) -> float: ...
    def get_show_text(self) -> bool: ...
    def get_text(self) -> Optional[str]: ...
    def new(cls) -> ProgressBar: ...
    def pulse(self) -> None: ...
    def set_ellipsize(self, mode: Pango.EllipsizeMode) -> None: ...
    def set_fraction(self, fraction: float) -> None: ...
    def set_inverted(self, inverted: bool) -> None: ...
    def set_pulse_step(self, fraction: float) -> None: ...
    def set_show_text(self, show_text: bool) -> None: ...
    def set_text(self, text: Optional[str]) -> None: ...
    

class PyGTKDeprecationWarning:
    args = ...
    
    def with_traceback(self, *args, **kwargs): ...
    

class RadioAction:
    def get_current_value(*args, **kwargs): ...
    def get_group(*args, **kwargs): ...
    def join_group(*args, **kwargs): ...
    def set_current_value(*args, **kwargs): ...
    def set_group(*args, **kwargs): ...
    
    def do_changed(self, *args, **kwargs): ...
    

class RadioActionEntry:
    accelerator = ...
    label = ...
    name = ...
    stock_id = ...
    tooltip = ...
    value = ...
    

class RadioButton(CheckButton):
    check_button = ...
    
    def get_group(*args, **kwargs): ...
    def join_group(*args, **kwargs): ...
    def new_from_widget(*args, **kwargs): ...
    def new_with_label_from_widget(*args, **kwargs): ...
    def new_with_mnemonic_from_widget(*args, **kwargs): ...
    def set_group(*args, **kwargs): ...
    
    def do_group_changed(self, *args, **kwargs): ...
    

class RadioMenuItem(CheckMenuItem):
    check_menu_item = ...
    
    def get_group(*args, **kwargs): ...
    def join_group(*args, **kwargs): ...
    def new_from_widget(*args, **kwargs): ...
    def new_with_label_from_widget(*args, **kwargs): ...
    def new_with_mnemonic_from_widget(*args, **kwargs): ...
    def set_group(*args, **kwargs): ...
    
    def do_group_changed(self, *args, **kwargs): ...


class RadioToolButton(ToggleToolButton):
    def get_group(*args, **kwargs): ...
    @classmethod
    def new_from_widget(cls, group: Optional[RadioToolButton]) -> RadioToolButton: ...
    def new_with_stock_from_widget(*args, **kwargs): ...
    def set_group(*args, **kwargs): ...
    

class Range(Orientable, Widget):
    widget = ...
    
    def __init__(self, orientation: Optional[Orientation] = Orientation.HORIZONTAL) -> None: ...
    def get_adjustment(*args, **kwargs): ...
    def get_fill_level(*args, **kwargs): ...
    def get_flippable(*args, **kwargs): ...
    def get_inverted(*args, **kwargs): ...
    def get_lower_stepper_sensitivity(*args, **kwargs): ...
    def get_min_slider_size(*args, **kwargs): ...
    def get_range_rect(*args, **kwargs): ...
    def get_restrict_to_fill_level(*args, **kwargs): ...
    def get_round_digits(*args, **kwargs): ...
    def get_show_fill_level(*args, **kwargs): ...
    def get_slider_range(*args, **kwargs): ...
    def get_slider_size_fixed(*args, **kwargs): ...
    def get_upper_stepper_sensitivity(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def set_adjustment(*args, **kwargs): ...
    def set_fill_level(*args, **kwargs): ...
    def set_flippable(*args, **kwargs): ...
    def set_increments(*args, **kwargs): ...
    def set_inverted(*args, **kwargs): ...
    def set_lower_stepper_sensitivity(*args, **kwargs): ...
    def set_min_slider_size(*args, **kwargs): ...
    def set_range(self, min: float, max: float) -> None: ...
    def set_restrict_to_fill_level(*args, **kwargs): ...
    def set_round_digits(*args, **kwargs): ...
    def set_show_fill_level(*args, **kwargs): ...
    def set_slider_size_fixed(*args, **kwargs): ...
    def set_upper_stepper_sensitivity(*args, **kwargs): ...
    def set_value(self, value: float) -> None: ...
    
    def do_adjust_bounds(self, *args, **kwargs): ...
    def do_change_value(self, *args, **kwargs): ...
    def do_get_range_border(self, *args, **kwargs): ...
    def do_get_range_size_request(self, *args, **kwargs): ...
    def do_move_slider(self, *args, **kwargs): ...
    def do_value_changed(self, *args, **kwargs): ...
    

class RcContext: ...

class RcProperty:
    origin = ...
    property_name = ...
    type_name = ...
    value = ...
    
    def parse_border(*args, **kwargs): ...
    def parse_color(*args, **kwargs): ...
    def parse_enum(*args, **kwargs): ...
    def parse_flags(*args, **kwargs): ...
    def parse_requisition(*args, **kwargs): ...
    

class RcStyle:
    base = ...
    bg = ...
    bg_pixmap_name = ...
    color_flags = ...
    engine_specified = ...
    fg = ...
    font_desc = ...
    icon_factories = ...
    name = ...
    parent_instance = ...
    rc_properties = ...
    rc_style_lists = ...
    text = ...
    xthickness = ...
    ythickness = ...
    
    def copy(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    
    def do_merge(self, *args, **kwargs): ...
    def do_parse(self, *args, **kwargs): ...
    

class RecentAction:
    parent_instance = ...
    priv = ...
    
    def get_show_numbers(*args, **kwargs): ...
    def new_for_manager(*args, **kwargs): ...
    def set_show_numbers(*args, **kwargs): ...
    

class RecentChooser:
    def add_filter(*args, **kwargs): ...
    def get_current_item(*args, **kwargs): ...
    def get_current_uri(*args, **kwargs): ...
    def get_filter(*args, **kwargs): ...
    def get_items(*args, **kwargs): ...
    def get_limit(*args, **kwargs): ...
    def get_local_only(*args, **kwargs): ...
    def get_select_multiple(*args, **kwargs): ...
    def get_show_icons(*args, **kwargs): ...
    def get_show_not_found(*args, **kwargs): ...
    def get_show_private(*args, **kwargs): ...
    def get_show_tips(*args, **kwargs): ...
    def get_sort_type(*args, **kwargs): ...
    def get_uris(*args, **kwargs): ...
    def list_filters(*args, **kwargs): ...
    def remove_filter(*args, **kwargs): ...
    def select_all(*args, **kwargs): ...
    def select_uri(*args, **kwargs): ...
    def set_current_uri(*args, **kwargs): ...
    def set_filter(*args, **kwargs): ...
    def set_limit(*args, **kwargs): ...
    def set_local_only(*args, **kwargs): ...
    def set_select_multiple(*args, **kwargs): ...
    def set_show_icons(*args, **kwargs): ...
    def set_show_not_found(*args, **kwargs): ...
    def set_show_private(*args, **kwargs): ...
    def set_show_tips(*args, **kwargs): ...
    def set_sort_func(*args, **kwargs): ...
    def set_sort_type(*args, **kwargs): ...
    def unselect_all(*args, **kwargs): ...
    def unselect_uri(*args, **kwargs): ...
    

class RecentChooserDialog: ...

class RecentChooserMenu:
    def get_show_numbers(*args, **kwargs): ...
    def new_for_manager(*args, **kwargs): ...
    def set_show_numbers(*args, **kwargs): ...
    

class RecentChooserWidget:
    def new_for_manager(*args, **kwargs): ...
    

class RecentData:
    app_exec = ...
    app_name = ...
    description = ...
    display_name = ...
    groups = ...
    is_private = ...
    mime_type = ...
    

class RecentFilter:
    def add_age(*args, **kwargs): ...
    def add_application(*args, **kwargs): ...
    def add_custom(*args, **kwargs): ...
    def add_group(*args, **kwargs): ...
    def add_mime_type(*args, **kwargs): ...
    def add_pattern(*args, **kwargs): ...
    def add_pixbuf_formats(*args, **kwargs): ...
    def filter(*args, **kwargs): ...
    def get_needed(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    

class RecentFilterInfo:
    age = ...
    applications = ...
    contains = ...
    display_name = ...
    groups = ...
    mime_type = ...
    uri = ...
    

class RecentInfo:
    def create_app_info(*args, **kwargs): ...
    def exists(*args, **kwargs): ...
    def get_added(*args, **kwargs): ...
    def get_age(*args, **kwargs): ...
    def get_application_info(*args, **kwargs): ...
    def get_applications(*args, **kwargs): ...
    def get_description(*args, **kwargs): ...
    def get_display_name(*args, **kwargs): ...
    def get_gicon(*args, **kwargs): ...
    def get_groups(*args, **kwargs): ...
    def get_icon(*args, **kwargs): ...
    def get_mime_type(*args, **kwargs): ...
    def get_modified(*args, **kwargs): ...
    def get_private_hint(*args, **kwargs): ...
    def get_short_name(*args, **kwargs): ...
    def get_uri(*args, **kwargs): ...
    def get_uri_display(*args, **kwargs): ...
    def get_visited(*args, **kwargs): ...
    def has_application(*args, **kwargs): ...
    def has_group(*args, **kwargs): ...
    def is_local(*args, **kwargs): ...
    def last_application(*args, **kwargs): ...
    def match(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class RecentManager:
    parent_instance = ...
    priv = ...
    
    def add_full(*args, **kwargs): ...
    def add_item(*args, **kwargs): ...
    def get_default(*args, **kwargs): ...
    def get_items(*args, **kwargs): ...
    def has_item(*args, **kwargs): ...
    def lookup_item(*args, **kwargs): ...
    def move_item(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def purge_items(*args, **kwargs): ...
    def remove_item(*args, **kwargs): ...
    
    def do_changed(self, *args, **kwargs): ...
    

class RequestedSize:
    data = ...
    minimum_size = ...
    natural_size = ...
    

class Requisition:
    height = ...
    width = ...
    
    def free(*args, **kwargs): ...
    def new(*args, **kwargs): ...


class Revealer(Bin):
    def get_child_revealed(self) -> bool: ...
    def get_reveal_child(self) -> bool: ...
    def get_transition_duration(*args, **kwargs): ...
    def get_transition_type(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_reveal_child(self, reveal_child: bool) -> None: ...
    def set_transition_duration(*args, **kwargs): ...
    def set_transition_type(self, transition: RevealerTransitionType) -> None: ...
    

class Scale(Range):
    range = ...
    
    def add_mark(*args, **kwargs): ...
    def clear_marks(*args, **kwargs): ...
    def get_digits(*args, **kwargs): ...
    def get_draw_value(*args, **kwargs): ...
    def get_has_origin(*args, **kwargs): ...
    def get_layout(*args, **kwargs): ...
    def get_layout_offsets(*args, **kwargs): ...
    def get_value_pos(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_range(*args, **kwargs): ...
    def set_digits(*args, **kwargs): ...
    def set_draw_value(*args, **kwargs): ...
    def set_has_origin(*args, **kwargs): ...
    def set_value_pos(self, pos: PositionType) -> None: ...
    
    def do_draw_value(self, *args, **kwargs): ...
    def do_format_value(self, *args, **kwargs): ...
    def do_get_layout_offsets(self, *args, **kwargs): ...
    

class ScaleButton:
    parent = ...
    
    def get_adjustment(*args, **kwargs): ...
    def get_minus_button(*args, **kwargs): ...
    def get_plus_button(*args, **kwargs): ...
    def get_popup(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def set_adjustment(*args, **kwargs): ...
    def set_icons(*args, **kwargs): ...
    def set_value(self, value: float) -> None: ...
    
    def do_value_changed(self, *args, **kwargs): ...
    

class Scrollable:
    def get_border(*args, **kwargs): ...
    def get_hadjustment(*args, **kwargs): ...
    def get_hscroll_policy(*args, **kwargs): ...
    def get_vadjustment(*args, **kwargs): ...
    def get_vscroll_policy(*args, **kwargs): ...
    def set_hadjustment(*args, **kwargs): ...
    def set_hscroll_policy(*args, **kwargs): ...
    def set_vadjustment(*args, **kwargs): ...
    def set_vscroll_policy(*args, **kwargs): ...
    

class ScrollableInterface:
    base_iface = ...
    get_border = ...
    

class Scrollbar(Range):
    range = ...
    
    def new(*args, **kwargs): ...


class ScrolledWindow(Bin):
    def add_with_viewport(*args, **kwargs): ...
    def get_capture_button_press(self) -> bool: ...
    def get_hadjustment(self) -> Adjustment: ...
    def get_hscrollbar(self) -> Scrollbar: ...
    def get_kinetic_scrolling(self) -> bool: ...
    def get_max_content_height(self) -> int: ...
    def get_max_content_width(self) -> int: ...
    def get_min_content_height(self) -> int: ...
    def get_min_content_width(self) -> int: ...
    def get_overlay_scrolling(self) -> bool: ...
    def get_placement(self) -> CornerType: ...
    def get_policy(self) -> tuple[PolicyType, PolicyType]: ...
    def get_propagate_natural_height(self) -> bool: ...
    def get_propagate_natural_width(self) -> bool: ...
    def get_shadow_type(self) -> ShadowType: ...
    def get_vadjustment(self) -> Adjustment: ...
    def get_vscrollbar(self) -> Scrollbar: ...
    def new(*args, **kwargs): ...
    def set_capture_button_press(*args, **kwargs): ...
    def set_hadjustment(*args, **kwargs): ...
    def set_kinetic_scrolling(self, kinetic_scrolling: bool) -> None: ...
    def set_max_content_height(self, height: int) -> None: ...
    def set_max_content_width(self, width: int) -> None:  ...
    def set_min_content_height(self, height: int) -> None: ...
    def set_min_content_width(*args, **kwargs): ...
    def set_overlay_scrolling(self, overlay_scrolling: bool) -> None: ...
    def set_placement(*args, **kwargs): ...
    def set_policy(self, hscrollbar_policy: PolicyType, vscrollbar_policy: PolicyType) -> None: ...
    def set_propagate_natural_height(self, height: int) -> None: ...
    def set_propagate_natural_width(self, width: int) -> None: ...
    def set_shadow_type(self, shadow_type: ShadowType) -> None: ...
    def set_vadjustment(*args, **kwargs): ...
    def unset_placement(*args, **kwargs): ...
    
    def do_move_focus_out(self, *args, **kwargs): ...
    def do_scroll_child(self, *args, **kwargs): ...
    

class SearchBar:
    parent = ...
    
    def connect_entry(*args, **kwargs): ...
    def get_search_mode(*args, **kwargs): ...
    def get_show_close_button(*args, **kwargs): ...
    def handle_event(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_search_mode(*args, **kwargs): ...
    def set_show_close_button(*args, **kwargs): ...
    

class SearchEntry(Entry):
    parent = ...
    
    def handle_event(*args, **kwargs): ...
    
    def do_next_match(self, *args, **kwargs): ...
    def do_previous_match(self, *args, **kwargs): ...
    def do_search_changed(self, *args, **kwargs): ...
    def do_stop_search(self, *args, **kwargs): ...


class SelectionData:
    def free(*args, **kwargs): ...
    def get_data(self) -> bytes: ...
    def get_data_type(self) -> Gdk.Atom: ...
    def get_display(*args, **kwargs): ...
    def get_format(*args, **kwargs): ...
    def get_length(*args, **kwargs): ...
    def get_pixbuf(*args, **kwargs): ...
    def get_selection(*args, **kwargs): ...
    def get_target(*args, **kwargs): ...
    def get_targets(*args, **kwargs): ...
    def get_text(*args, **kwargs): ...
    def get_uris(self) -> list[str]: ...
    def set(self, type: Gdk.Atom, format: int, data: bytes) -> None: ...
    def set_pixbuf(*args, **kwargs): ...
    def set_text(*args, **kwargs): ...
    def set_uris(*args, **kwargs): ...
    def targets_include_image(*args, **kwargs): ...
    def targets_include_rich_text(*args, **kwargs): ...
    def targets_include_text(*args, **kwargs): ...
    def targets_include_uri(*args, **kwargs): ...
    

class Separator(Orientable, Widget):
    widget = ...
    
    def new(*args, **kwargs): ...
    

class SeparatorMenuItem(MenuItem):
    menu_item = ...
    

class SeparatorToolItem:
    def get_draw(*args, **kwargs): ...
    def set_draw(*args, **kwargs): ...
    

class Settings(GObject.Object, StyleProvider):
    parent_instance = ...
    priv = ...

    @classmethod
    def get_default(cls) -> Optional[Settings]: ...
    def get_for_screen(*args, **kwargs): ...
    def install_property_parser(*args, **kwargs): ...
    def reset_property(self, name: str) -> None: ...
    def set_double_property(*args, **kwargs): ...
    def set_long_property(*args, **kwargs): ...
    def set_property_value(*args, **kwargs): ...
    def set_string_property(*args, **kwargs): ...
    

class SettingsValue:
    origin = ...
    value = ...
    

class ShortcutLabel:
    def get_accelerator(*args, **kwargs): ...
    def get_disabled_text(*args, **kwargs): ...
    def set_accelerator(*args, **kwargs): ...
    def set_disabled_text(*args, **kwargs): ...
    

class ShortcutsGroup: ...

class ShortcutsSection: ...

class ShortcutsShortcut: ...

class ShortcutsWindow:
    window = ...
    
    def do_close(self, *args, **kwargs): ...
    def do_search(self, *args, **kwargs): ...
    

class SizeGroup:
    parent_instance = ...
    priv = ...
    
    def add_widget(*args, **kwargs): ...
    def get_ignore_hidden(*args, **kwargs): ...
    def get_mode(*args, **kwargs): ...
    def get_widgets(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def remove_widget(*args, **kwargs): ...
    def set_ignore_hidden(*args, **kwargs): ...
    def set_mode(*args, **kwargs): ...
    

class Socket:
    container = ...
    
    def add_id(*args, **kwargs): ...
    def get_id(*args, **kwargs): ...
    def get_plug_window(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    
    def do_plug_added(self, *args, **kwargs): ...
    def do_plug_removed(self, *args, **kwargs): ...
    

class SpinButton(Entry, Orientable):
    entry = ...
    
    def configure(*args, **kwargs): ...
    def get_adjustment(*args, **kwargs): ...
    def get_digits(*args, **kwargs): ...
    def get_increments(*args, **kwargs): ...
    def get_numeric(*args, **kwargs): ...
    def get_range(*args, **kwargs): ...
    def get_snap_to_ticks(*args, **kwargs): ...
    def get_update_policy(*args, **kwargs): ...
    def get_value(*args, **kwargs): ...
    def get_value_as_int(self) -> int: ...
    def get_wrap(*args, **kwargs): ...
    def new_with_range(*args, **kwargs): ...
    def set_adjustment(self, adjustment: Adjustment) -> None: ...
    def set_digits(*args, **kwargs): ...
    def set_increments(*args, **kwargs): ...
    def set_numeric(self, numeric: bool) -> None: ...
    def set_range(*args, **kwargs): ...
    def set_snap_to_ticks(*args, **kwargs): ...
    def set_update_policy(self, update_policy: SpinButtonUpdatePolicy) -> None: ...
    def set_value(self, value: float) -> None: ...
    def set_wrap(*args, **kwargs): ...
    def spin(*args, **kwargs): ...
    def update(*args, **kwargs): ...
    
    def do_change_value(self, *args, **kwargs): ...
    def do_input(self, *args, **kwargs): ...
    def do_output(self, *args, **kwargs): ...
    def do_value_changed(self, *args, **kwargs): ...
    def do_wrapped(self, *args, **kwargs): ...


class Spinner(Widget):
    parent = ...
    
    def new(*args, **kwargs): ...
    def start(self) -> None: ...
    def stop(self) -> None: ...


class Stack(Container):
    def __init__(self, vhomogeneous: bool = True) -> None: ...
    def add_named(self, child: Widget, name: str) -> None: ...
    def add_titled(self, child: Widget, name: str, title: str) -> None: ...
    def get_child_by_name(self, name: str) -> Widget: ...
    def get_hhomogeneous(self) -> bool: ...
    def get_homogeneous(self) -> bool: ...
    def get_interpolate_size(self) -> bool: ...
    def get_transition_duration(self) -> int: ...
    def get_transition_running(self) -> bool: ...
    def get_transition_type(self) -> StackTransitionType: ...
    def get_vhomogeneous(self) -> bool: ...
    def get_visible_child(self) -> Optional[Widget]: ...
    def get_visible_child_name(self) -> Optional[str]: ...
    @classmethod
    def new(cls) -> Stack: ...
    def set_hhomogeneous(self, hhomogeneous: bool) -> None: ...
    def set_homogeneous(self, homogeneous: bool) -> None: ...
    def set_interpolate_size(self, interpolate_size: bool) -> None: ...
    def set_transition_duration(self, duration: int) -> None: ...
    def set_transition_type(self, transition: StackTransitionType) -> None: ...
    def set_vhomogeneous(self, vhomogeneous: bool) -> None: ...
    def set_visible_child(self, child: Widget) -> None: ...
    def set_visible_child_full(self, name: str, transition: StackTransitionType) -> None: ...
    def set_visible_child_name(self, name: str) -> None: ...

    @overload
    def child_get_property(self, widget: Widget, property_name: Literal['icon-name'], value: Optional[GObject.Value] = None) -> Optional[str]: ...
    @overload
    def child_get_property(self, widget: Widget, property_name: Literal['name'], value: Optional[GObject.Value] = None) -> Optional[str]: ...
    @overload
    def child_get_property(self, widget: Widget, property_name: Literal['needs-attention'], value: Optional[GObject.Value] = None) -> bool: ...
    @overload
    def child_get_property(self, widget: Widget, property_name: Literal['position'], value: Optional[GObject.Value] = None) -> int: ...
    @overload
    def child_get_property(self, widget: Widget, property_name: Literal['title'], value: Optional[GObject.Value] = None) -> Optional[str]: ...


class StackSidebar:
    parent = ...
    
    def get_stack(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_stack(*args, **kwargs): ...
    

class StackSwitcher:
    def get_stack(*args, **kwargs): ...
    def set_stack(*args, **kwargs): ...
    

class StatusIcon(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def get_geometry(self) -> tuple[bool, Gdk.Screen, Gdk.Rectangle, Orientation]: ...
    def get_gicon(self) -> Optional[Gio.Icon]: ...
    def get_has_tooltip(self) -> bool: ...
    def get_icon_name(self) -> Optional[str]: ...
    def get_pixbuf(self) -> Optional[GdkPixbuf.Pixbuf]: ...
    def get_screen(self) -> Gdk.Screen: ...
    def get_size(self) -> int: ...
    def get_stock(self) -> Optional[str]: ...
    def get_storage_type(*args, **kwargs) -> ImageType: ...
    def get_title(self) -> str: ...
    def get_tooltip_markup(self) -> Optional[str]: ...
    def get_tooltip_text(self) -> Optional[str]: ...
    def get_visible(self) -> bool: ...
    def get_x11_window_id(self) -> int: ...
    def is_embedded(self) -> bool: ...
    def new(*args, **kwargs): ...
    def new_from_file(*args, **kwargs): ...
    def new_from_gicon(*args, **kwargs): ...
    def new_from_icon_name(*args, **kwargs): ...
    def new_from_pixbuf(*args, **kwargs): ...
    def new_from_stock(*args, **kwargs): ...
    def position_menu(*args, **kwargs): ...
    def set_from_file(self, filename: str) -> None: ...
    def set_from_gicon(*args, **kwargs): ...
    def set_from_icon_name(self, icon_name: str) -> None: ...
    def set_from_pixbuf(*args, **kwargs): ...
    def set_from_stock(*args, **kwargs): ...
    def set_has_tooltip(self, has_tooltip: bool) -> None: ...
    def set_name(self, name: str) -> None: ...
    def set_screen(self, screen: Gdk.Screen) -> None: ...
    def set_title(self, title: str) -> None: ...
    def set_tooltip_markup(self, markup: Optional[str]): ...
    def set_tooltip_text(self, text: str) -> None: ...
    def set_visible(self, visible: bool) -> None: ...
    
    def do_activate(self, *args, **kwargs): ...
    def do_button_press_event(self, *args, **kwargs): ...
    def do_button_release_event(self, *args, **kwargs): ...
    def do_popup_menu(self, *args, **kwargs): ...
    def do_query_tooltip(self, *args, **kwargs): ...
    def do_scroll_event(self, *args, **kwargs): ...
    def do_size_changed(self, *args, **kwargs): ...
    

class Statusbar:
    parent_widget = ...
    
    def get_context_id(*args, **kwargs): ...
    def get_message_area(*args, **kwargs): ...
    def pop(*args, **kwargs): ...
    def push(*args, **kwargs): ...
    def remove_all(*args, **kwargs): ...
    
    def do_text_popped(self, *args, **kwargs): ...
    def do_text_pushed(self, *args, **kwargs): ...
    

class StockItem:
    keyval = ...
    label = ...
    modifier = ...
    stock_id = ...
    translation_domain = ...
    
    def free(*args, **kwargs): ...
    

class Style:
    attach_count = ...
    background = ...
    base = ...
    bg = ...
    black = ...
    dark = ...
    fg = ...
    font_desc = ...
    icon_factories = ...
    light = ...
    mid = ...
    parent_instance = ...
    private_font_desc = ...
    property_cache = ...
    rc_style = ...
    styles = ...
    text = ...
    text_aa = ...
    visual = ...
    white = ...
    xthickness = ...
    ythickness = ...
    
    def apply_default_background(*args, **kwargs): ...
    def copy(*args, **kwargs): ...
    def detach(*args, **kwargs): ...
    def get_style_property(*args, **kwargs): ...
    def has_context(*args, **kwargs): ...
    def lookup_color(*args, **kwargs): ...
    def lookup_icon_set(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def render_icon(*args, **kwargs): ...
    def set_background(*args, **kwargs): ...
    
    def do_copy(self, *args, **kwargs): ...
    def do_draw_arrow(self, *args, **kwargs): ...
    def do_draw_box(self, *args, **kwargs): ...
    def do_draw_box_gap(self, *args, **kwargs): ...
    def do_draw_check(self, *args, **kwargs): ...
    def do_draw_diamond(self, *args, **kwargs): ...
    def do_draw_expander(self, *args, **kwargs): ...
    def do_draw_extension(self, *args, **kwargs): ...
    def do_draw_flat_box(self, *args, **kwargs): ...
    def do_draw_focus(self, *args, **kwargs): ...
    def do_draw_handle(self, *args, **kwargs): ...
    def do_draw_hline(self, *args, **kwargs): ...
    def do_draw_layout(self, *args, **kwargs): ...
    def do_draw_option(self, *args, **kwargs): ...
    def do_draw_resize_grip(self, *args, **kwargs): ...
    def do_draw_shadow(self, *args, **kwargs): ...
    def do_draw_shadow_gap(self, *args, **kwargs): ...
    def do_draw_slider(self, *args, **kwargs): ...
    def do_draw_spinner(self, *args, **kwargs): ...
    def do_draw_tab(self, *args, **kwargs): ...
    def do_draw_vline(self, *args, **kwargs): ...
    def do_init_from_rc(self, *args, **kwargs): ...
    def do_realize(self, *args, **kwargs): ...
    def do_render_icon(self, *args, **kwargs): ...
    def do_set_background(self, *args, **kwargs): ...
    def do_unrealize(self, *args, **kwargs): ...


class ColorResult(Tuple[bool, Gdk.RGBA]):
    color: Gdk.RGBA


class RunningResult(Tuple[bool, float]):
    progress: float


class StyleContext(GObject.Object):
    parent_object = ...
    priv = ...

    def add_class(self, class_name: str) -> None: ...
    def add_provider(self, provider: StyleProvider, priority: int) -> None: ...
    @classmethod
    def add_provider_for_screen(cls,
                                screen: Gdk.Screen,
                                provider: StyleProvider,
                                priority: int) -> None: ...
    def add_region(self, region_name: str, flags: RegionFlags) -> None: ...
    def cancel_animations(self, region_id: Optional[object]) -> None: ...
    def get_background_color(self, state: StateFlags) -> Gdk.RGBA: ...
    def get_border(self, state: StateFlags) -> Border: ...
    def get_border_color(self, state: StateFlags) -> Gdk.RGBA: ...
    def get_color(self, state: StateFlags) -> Gdk.RGBA: ...
    def get_direction(self) -> TextDirection: ...
    def get_font(self, state: StateFlags) -> Pango.FontDescription: ...
    def get_frame_clock(self) -> Optional[Gdk.FrameClock]: ...
    def get_junction_sides(self) -> JunctionSides: ...
    def get_margin(self, state: StateFlags) -> Border: ...
    def get_padding(self, state: StateFlags) -> Border: ...
    def get_parent(self) -> Optional[StyleContext]: ...
    def get_path(self) -> WidgetPath: ...
    def get_property(self,
                     property: str,
                     state: StateFlags) -> GObject.Value: ...
    def get_scale(self) -> int: ...
    def get_screen(self) -> Gdk.Screen: ...
    def get_section(self, property: str) -> Optional[CssSection]: ...
    def get_state(self) -> StateFlags: ...
    def get_style_property(self,
                           property_name: str,
                           value: GObject.Value) -> None: ...
    def has_class(self, class_name: str) -> bool: ...
    def has_region(self, region_name: str) -> bool: ...
    def invalidate(self) -> None: ...
    def list_classes(self) -> list[str]: ...
    def list_regions(self) -> list[str]: ...
    def lookup_color(self, color_name: str) -> ColorResult: ...
    def lookup_icon_set(self, stock_id: str) -> Optional[IconSet]: ...
    @classmethod
    def new(cls) -> StyleContext: ...
    def notify_state_change(self,
                            window: Gdk.Window,
                            region_id: Optional[object],
                            state: StateType,
                            state_value: bool) -> None: ...
    def pop_animatable_region(self) -> None: ...
    def push_animatable_region(self, region_id: Optional[object]) -> None: ...
    def remove_class(self, class_name: str) -> None: ...
    def remove_provider(self, provider: StyleProvider) -> None: ...
    @classmethod
    def remove_provider_for_screen(cls,
                                   screen: Gdk.Screen,
                                   provider: StyleProvider) -> None: ...
    def remove_region(self, region_name: str) -> None: ...
    @classmethod
    def reset_widgets(cls, screen: Gdk.Screen) -> None: ...
    def restore(self) -> None: ...
    def save(self) -> None: ...
    def scroll_animations(self,
                          window: Gdk.Window,
                          dx: int,
                          dy: int) -> None: ...
    def set_background(self, window: Gdk.Window) -> None: ...
    def set_direction(self, direction: TextDirection) -> None: ...
    def set_frame_clock(self, frame_clock: Gdk.FrameClock) -> None: ...
    def set_junction_sides(self, sides: JunctionSides) -> None: ...
    def set_parent(self, parent: Optional[StyleContext]) -> None: ...
    def set_path(self, path: WidgetPath): ...
    def set_scale(self, scale: int) -> None: ...
    def set_screen(self, screen: Gdk.Screen) -> None: ...
    def set_state(self, flags: StateFlags) -> None: ...
    def state_is_running(self, state: StateType) -> RunningResult: ...
    def to_string(self, flags: StyleContextPrintFlags) -> str: ...

    def do_changed(self) -> None: ...


class StyleProperties:
    parent_object = ...
    priv = ...
    
    def clear(*args, **kwargs): ...
    def lookup_color(*args, **kwargs): ...
    def map_color(*args, **kwargs): ...
    def merge(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def unset_property(*args, **kwargs): ...
    

class StyleProvider:
    def get_icon_factory(*args, **kwargs): ...
    def get_style(*args, **kwargs): ...
    def get_style_property(*args, **kwargs): ...


class Switch(Widget, Activatable, Actionable):
    def get_active(self) -> bool: ...
    def get_state(self) -> bool: ...
    @classmethod
    def new(cls) -> Switch: ...
    def set_active(self, is_active: bool) -> None: ...
    def set_state(self, state: bool) -> None: ...
    def do_activate(self, *args, **kwargs): ...
    def do_state_set(self, *args, **kwargs): ...
    

class SymbolicColor:
    def new_alpha(*args, **kwargs): ...
    def new_literal(*args, **kwargs): ...
    def new_mix(*args, **kwargs): ...
    def new_name(*args, **kwargs): ...
    def new_shade(*args, **kwargs): ...
    def new_win32(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def resolve(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class Table:
    container = ...
    
    def attach(*args, **kwargs): ...
    def attach_defaults(*args, **kwargs): ...
    def get_col_spacing(*args, **kwargs): ...
    def get_default_col_spacing(*args, **kwargs): ...
    def get_default_row_spacing(*args, **kwargs): ...
    def get_homogeneous(*args, **kwargs): ...
    def get_row_spacing(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def resize(*args, **kwargs): ...
    def set_col_spacing(*args, **kwargs): ...
    def set_col_spacings(*args, **kwargs): ...
    def set_homogeneous(*args, **kwargs): ...
    def set_row_spacing(*args, **kwargs): ...
    def set_row_spacings(*args, **kwargs): ...
    

class TableChild:
    bottom_attach = ...
    left_attach = ...
    right_attach = ...
    top_attach = ...
    widget = ...
    xexpand = ...
    xfill = ...
    xpadding = ...
    xshrink = ...
    yexpand = ...
    yfill = ...
    ypadding = ...
    yshrink = ...
    

class TableRowCol:
    allocation = ...
    empty = ...
    expand = ...
    need_expand = ...
    need_shrink = ...
    requisition = ...
    shrink = ...
    spacing = ...


class TargetEntry:
    flags = ...
    info = ...
    target = ...
    
    def free(*args, **kwargs): ...
    @classmethod
    def new(cls, target: str, flags: TargetFlags, info: int) -> TargetEntry: ...
    

class TargetList:
    def add(*args, **kwargs): ...
    def add_image_targets(*args, **kwargs): ...
    def add_rich_text_targets(*args, **kwargs): ...
    def add_table(*args, **kwargs): ...
    def add_text_targets(self, info: int) -> None: ...
    def add_uri_targets(*args, **kwargs): ...
    def find(*args, **kwargs): ...
    @classmethod
    def new(cls, targets: Optional[list[TargetEntry]]) -> TargetList: ...
    def ref(*args, **kwargs): ...
    def remove(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class TargetPair:
    flags = ...
    info = ...
    target = ...
    

class TearoffMenuItem(MenuItem):
    menu_item = ...
    

class Template:
    def from_file(self, *args, **kwargs): ...
    def from_resource(self, *args, **kwargs): ...
    def from_string(self, *args, **kwargs): ...
    
    class Callback: ...
    
    class Child: ...
    

class TextAppearance:
    bg_color = ...
    draw_bg = ...
    fg_color = ...
    inside_selection = ...
    is_text = ...
    rise = ...
    strikethrough = ...
    underline = ...
    

class TextAttributes:
    appearance = ...
    bg_full_height = ...
    direction = ...
    editable = ...
    font = ...
    font_scale = ...
    indent = ...
    invisible = ...
    justification = ...
    language = ...
    left_margin = ...
    letter_spacing = ...
    no_fallback = ...
    pg_bg_color = ...
    pg_bg_rgba = ...
    pixels_above_lines = ...
    pixels_below_lines = ...
    pixels_inside_wrap = ...
    refcount = ...
    right_margin = ...
    tabs = ...
    wrap_mode = ...
    
    def copy_values(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class TextBTree: ...


class TextBuffer(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def add_mark(self, mark: TextMark, where: TextIter) -> None: ...
    def add_selection_clipboard(*args, **kwargs): ...
    def apply_tag(*args, **kwargs): ...
    def apply_tag_by_name(self, name: str, start: TextIter, end: TextIter) -> None: ...
    def backspace(*args, **kwargs): ...
    def begin_user_action(*args, **kwargs): ...
    def copy_clipboard(*args, **kwargs): ...
    def create_child_anchor(self, iter: TextIter) -> TextChildAnchor: ...
    def create_mark(self, mark_name: Optional[str], where: TextIter, left_gravity: bool) -> TextMark: ...
    def create_tag(self, tag_name: Optional[str] = None, **kwargs: Any) -> TextTag: ...
    def cut_clipboard(*args, **kwargs): ...
    def delete(self, start: TextIter, end: TextIter) -> None: ...
    def delete_interactive(*args, **kwargs): ...
    def delete_mark(self, mark: TextMark) -> None: ...
    def delete_mark_by_name(*args, **kwargs): ...
    def delete_selection(*args, **kwargs): ...
    def deserialize(*args, **kwargs): ...
    def deserialize_get_can_create_tags(*args, **kwargs): ...
    def deserialize_set_can_create_tags(*args, **kwargs): ...
    def end_user_action(*args, **kwargs): ...
    def get_bounds(self) -> tuple[TextIter, TextIter]: ...
    def get_char_count(self) -> int: ...
    def get_copy_target_list(*args, **kwargs): ...
    def get_deserialize_formats(*args, **kwargs): ...
    def get_end_iter(self) -> TextIter: ...
    def get_has_selection(*args, **kwargs): ...
    def get_insert(self) -> TextMark: ...
    def get_iter_at_child_anchor(*args, **kwargs): ...
    def get_iter_at_line(*args, **kwargs): ...
    def get_iter_at_line_index(*args, **kwargs): ...
    def get_iter_at_line_offset(*args, **kwargs): ...
    def get_iter_at_mark(self, mark: TextMark) -> TextIter: ...
    def get_iter_at_offset(self, char_offset: int) -> TextIter: ...
    def get_line_count(self) -> int: ...
    def get_mark(self, name: str) -> Optional[TextMark]: ...
    def get_modified(self) -> bool: ...
    def get_paste_target_list(self) -> TargetList: ...
    def get_selection_bound(self) -> TextMark: ...
    def get_selection_bounds(self) -> Optional[tuple[TextIter, TextIter]]: ...
    def get_serialize_formats(*args, **kwargs): ...
    def get_slice(*args, **kwargs): ...
    def get_start_iter(self) -> TextIter: ...
    def get_tag_table(self) -> TextTagTable: ...
    def get_text(self, start: TextIter, end: TextIter, include_hidden_chars: bool) -> str: ...
    def insert(self, iter: TextIter, text: str, length: int = ...) -> None: ...
    def insert_at_cursor(self, text: str, length: int = -1) -> None: ...
    def insert_child_anchor(*args, **kwargs): ...
    def insert_interactive(*args, **kwargs): ...
    def insert_interactive_at_cursor(*args, **kwargs): ...
    def insert_markup(*args, **kwargs): ...
    def insert_pixbuf(*args, **kwargs): ...
    def insert_range(*args, **kwargs): ...
    def insert_range_interactive(*args, **kwargs): ...
    def insert_with_tags(*args, **kwargs): ...
    def insert_with_tags_by_name(self, iter: TextIter, text: str, *tags: Any) -> None: ...
    def move_mark(*args, **kwargs): ...
    def move_mark_by_name(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def paste_clipboard(*args, **kwargs): ...
    def place_cursor(*args, **kwargs): ...
    def register_deserialize_format(*args, **kwargs): ...
    def register_deserialize_tagset(*args, **kwargs): ...
    def register_serialize_format(*args, **kwargs): ...
    def register_serialize_tagset(*args, **kwargs): ...
    def remove_all_tags(self, start: TextIter, end: TextIter) -> None: ...
    def remove_selection_clipboard(*args, **kwargs): ...
    def remove_tag(self, tag: TextTag, start: TextIter, end: TextIter) -> None: ...
    def remove_tag_by_name(*args, **kwargs): ...
    def select_range(self, ins: TextIter, bound: TextIter) -> None: ...
    def serialize(*args, **kwargs): ...
    def set_modified(*args, **kwargs): ...
    def set_text(self, text: str, length: int = -1) -> None: ...
    def unregister_deserialize_format(*args, **kwargs): ...
    def unregister_serialize_format(*args, **kwargs): ...
    
    def do_apply_tag(self, *args, **kwargs): ...
    def do_begin_user_action(self, *args, **kwargs): ...
    def do_changed(self, *args, **kwargs): ...
    def do_delete_range(self, *args, **kwargs): ...
    def do_end_user_action(self, *args, **kwargs): ...
    def do_insert_child_anchor(self, *args, **kwargs): ...
    def do_insert_pixbuf(self, *args, **kwargs): ...
    def do_insert_text(self, *args, **kwargs): ...
    def do_mark_deleted(self, *args, **kwargs): ...
    def do_mark_set(self, *args, **kwargs): ...
    def do_modified_changed(self, *args, **kwargs): ...
    def do_paste_done(self, *args, **kwargs): ...
    def do_remove_tag(self, *args, **kwargs): ...
    

class TextChildAnchor:
    parent_instance = ...
    segment = ...
    
    def get_deleted(*args, **kwargs): ...
    def get_widgets(self) -> list[Widget]: ...
    def new(*args, **kwargs): ...
    

class TextIter:
    dummy1 = ...
    dummy10 = ...
    dummy11 = ...
    dummy12 = ...
    dummy13 = ...
    dummy14 = ...
    dummy2 = ...
    dummy3 = ...
    dummy4 = ...
    dummy5 = ...
    dummy6 = ...
    dummy7 = ...
    dummy8 = ...
    dummy9 = ...

    def assign(*args, **kwargs): ...
    def backward_char(self) -> bool: ...
    def backward_chars(self, count: int) -> bool: ...
    def backward_cursor_position(self) -> bool: ...
    def backward_cursor_positions(*args, **kwargs): ...
    def backward_find_char(*args, **kwargs): ...
    def backward_line(*args, **kwargs): ...
    def backward_lines(*args, **kwargs): ...
    def backward_search(self, str: str, flags: TextSearchFlags, limit: Optional[TextIter]) -> Optional[tuple[TextIter, TextIter]]: ...
    def backward_sentence_start(*args, **kwargs): ...
    def backward_sentence_starts(*args, **kwargs): ...
    def backward_to_tag_toggle(*args, **kwargs): ...
    def backward_visible_cursor_position(*args, **kwargs): ...
    def backward_visible_cursor_positions(*args, **kwargs): ...
    def backward_visible_line(*args, **kwargs): ...
    def backward_visible_lines(*args, **kwargs): ...
    def backward_visible_word_start(*args, **kwargs): ...
    def backward_visible_word_starts(*args, **kwargs): ...
    def backward_word_start(self) -> bool: ...
    def backward_word_starts(*args, **kwargs): ...
    def begins_tag(*args, **kwargs): ...
    def can_insert(*args, **kwargs): ...
    def compare(*args, **kwargs): ...
    def copy(self) -> TextIter: ...
    def editable(*args, **kwargs): ...
    def ends_line(*args, **kwargs): ...
    def ends_sentence(*args, **kwargs): ...
    def ends_tag(self, tag: Optional[TextTag]) -> bool: ...
    def ends_word(self) -> bool: ...
    def equal(self, rhs: TextIter) -> bool: ...
    def forward_char(self) -> bool: ...
    def forward_chars(self, count: int) -> bool: ...
    def forward_cursor_position(*args, **kwargs): ...
    def forward_cursor_positions(*args, **kwargs): ...
    def forward_find_char(*args, **kwargs): ...
    def forward_line(*args, **kwargs): ...
    def forward_lines(*args, **kwargs): ...
    def forward_search(self, str: str, flags: TextSearchFlags, limit: Optional[TextIter]) -> Optional[tuple[TextIter, TextIter]]: ...
    def forward_sentence_end(*args, **kwargs): ...
    def forward_sentence_ends(*args, **kwargs): ...
    def forward_to_end(*args, **kwargs): ...
    def forward_to_line_end(*args, **kwargs): ...
    def forward_to_tag_toggle(*args, **kwargs): ...
    def forward_visible_cursor_position(*args, **kwargs): ...
    def forward_visible_cursor_positions(*args, **kwargs): ...
    def forward_visible_line(*args, **kwargs): ...
    def forward_visible_lines(*args, **kwargs): ...
    def forward_visible_word_end(*args, **kwargs): ...
    def forward_visible_word_ends(*args, **kwargs): ...
    def forward_word_end(self) -> bool: ...
    def forward_word_ends(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_attributes(*args, **kwargs): ...
    def get_buffer(*args, **kwargs): ...
    def get_bytes_in_line(*args, **kwargs): ...
    def get_char(self) -> str: ...
    def get_chars_in_line(*args, **kwargs): ...
    def get_child_anchor(self) -> TextChildAnchor: ...
    def get_language(*args, **kwargs): ...
    def get_line(*args, **kwargs): ...
    def get_line_index(*args, **kwargs): ...
    def get_line_offset(*args, **kwargs): ...
    def get_marks(*args, **kwargs): ...
    def get_offset(self) -> int: ...
    def get_pixbuf(*args, **kwargs): ...
    def get_slice(*args, **kwargs): ...
    def get_tags(self) -> list[TextTag]: ...
    def get_text(*args, **kwargs): ...
    def get_toggled_tags(*args, **kwargs): ...
    def get_visible_line_index(*args, **kwargs): ...
    def get_visible_line_offset(*args, **kwargs): ...
    def get_visible_slice(*args, **kwargs): ...
    def get_visible_text(*args, **kwargs): ...
    def has_tag(*args, **kwargs): ...
    def in_range(*args, **kwargs): ...
    def inside_sentence(*args, **kwargs): ...
    def inside_word(*args, **kwargs): ...
    def is_cursor_position(*args, **kwargs): ...
    def is_end(*args, **kwargs): ...
    def is_start(*args, **kwargs): ...
    def order(*args, **kwargs): ...
    def set_line(*args, **kwargs): ...
    def set_line_index(*args, **kwargs): ...
    def set_line_offset(*args, **kwargs): ...
    def set_offset(*args, **kwargs): ...
    def set_visible_line_index(*args, **kwargs): ...
    def set_visible_line_offset(*args, **kwargs): ...
    def starts_line(*args, **kwargs): ...
    def starts_sentence(*args, **kwargs): ...
    def starts_tag(self, tag: Optional[TextTag]) -> bool: ...
    def starts_word(self) -> bool: ...
    def toggles_tag(*args, **kwargs): ...
    

class TextMark:
    parent_instance = ...
    segment = ...
    
    def get_buffer(*args, **kwargs): ...
    def get_deleted(*args, **kwargs): ...
    def get_left_gravity(*args, **kwargs): ...
    def get_name(self) -> Optional[str]: ...
    def get_visible(*args, **kwargs): ...
    @classmethod
    def new(cls, name: Optional[str], left_gravity: bool) -> TextMark: ...
    def set_visible(*args, **kwargs): ...
    

class TextTag(GObject.Object):
    parent_instance = ...
    priv = ...
    
    def changed(*args, **kwargs): ...
    def event(*args, **kwargs): ...
    def get_priority(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_priority(self, priority: int) -> None: ...
    
    def do_event(self, *args, **kwargs): ...


class TextTagTable(GObject.Object, Buildable):
    parent_instance = ...
    priv = ...
    
    def add(*args, **kwargs): ...
    def foreach(self, func: Callable[[TextTag], None]) -> None: ...
    def get_size(self) -> int: ...
    def lookup(self, name: str) -> Optional[TextTag]: ...
    def new(*args, **kwargs): ...
    def remove(*args, **kwargs): ...
    
    def do_tag_added(self, *args, **kwargs): ...
    def do_tag_changed(self, *args, **kwargs): ...
    def do_tag_removed(self, *args, **kwargs): ...


class TextView(Container, Scrollable):
    def add_child_at_anchor(self, child: Widget, anchor: TextChildAnchor) -> None: ...
    def add_child_in_window(*args, **kwargs): ...
    def backward_display_line(*args, **kwargs): ...
    def backward_display_line_start(*args, **kwargs): ...
    def buffer_to_window_coords(*args, **kwargs): ...
    def forward_display_line(*args, **kwargs): ...
    def forward_display_line_end(*args, **kwargs): ...
    def get_accepts_tab(*args, **kwargs): ...
    def get_border_window_size(*args, **kwargs): ...
    def get_bottom_margin(*args, **kwargs): ...
    def get_buffer(self) -> TextBuffer: ...
    def get_cursor_locations(*args, **kwargs): ...
    def get_cursor_visible(*args, **kwargs): ...
    def get_default_attributes(*args, **kwargs): ...
    def get_editable(*args, **kwargs): ...
    def get_indent(*args, **kwargs): ...
    def get_input_hints(*args, **kwargs): ...
    def get_input_purpose(*args, **kwargs): ...
    def get_iter_at_location(self, x: int, y: int) -> tuple[bool, TextIter]: ...
    def get_iter_at_position(self, x: int, y: int) -> tuple[bool, TextIter]: ...
    def get_iter_location(self, iter: TextIter) -> Gdk.Rectangle: ...
    def get_justification(*args, **kwargs): ...
    def get_left_margin(*args, **kwargs): ...
    def get_line_at_y(*args, **kwargs): ...
    def get_line_yrange(*args, **kwargs): ...
    def get_monospace(*args, **kwargs): ...
    def get_overwrite(*args, **kwargs): ...
    def get_pixels_above_lines(*args, **kwargs): ...
    def get_pixels_below_lines(*args, **kwargs): ...
    def get_pixels_inside_wrap(*args, **kwargs): ...
    def get_right_margin(*args, **kwargs): ...
    def get_tabs(*args, **kwargs): ...
    def get_top_margin(*args, **kwargs): ...
    def get_visible_rect(*args, **kwargs): ...
    def get_window(self, win: TextWindowType) -> Optional[Gdk.Window]: ...
    def get_window_type(*args, **kwargs): ...
    def get_wrap_mode(*args, **kwargs): ...
    def im_context_filter_keypress(*args, **kwargs): ...
    def move_child(*args, **kwargs): ...
    def move_mark_onscreen(*args, **kwargs): ...
    def move_visually(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_buffer(*args, **kwargs): ...
    def place_cursor_onscreen(*args, **kwargs): ...
    def reset_cursor_blink(*args, **kwargs): ...
    def reset_im_context(*args, **kwargs): ...
    def scroll_mark_onscreen(*args, **kwargs): ...
    def scroll_to_iter(*args, **kwargs): ...
    def scroll_to_mark(self, mark: TextMark, within_margin: float, use_align: bool, xalign: float, yalign: float) -> None: ...
    def set_accepts_tab(self, accepts_tab: bool) -> None: ...
    def set_border_window_size(*args, **kwargs): ...
    def set_bottom_margin(self, bottom_margin: int) -> None: ...
    def set_buffer(*args, **kwargs): ...
    def set_cursor_visible(self, setting: bool) -> None: ...
    def set_editable(self, setting: bool) -> None: ...
    def set_indent(*args, **kwargs): ...
    def set_input_hints(*args, **kwargs): ...
    def set_input_purpose(*args, **kwargs): ...
    def set_justification(*args, **kwargs): ...
    def set_left_margin(self, left_margin: int) -> None: ...
    def set_monospace(self, monospace: bool) -> None: ...
    def set_overwrite(*args, **kwargs): ...
    def set_pixels_above_lines(self, pixels_above_lines: int) -> None: ...
    def set_pixels_below_lines(self, pixels_below_lines: int) -> None: ...
    def set_pixels_inside_wrap(*args, **kwargs): ...
    def set_right_margin(self, right_margin: int) -> None: ...
    def set_tabs(*args, **kwargs): ...
    def set_top_margin(self, top_margin: int) -> None: ...
    def set_wrap_mode(self, wrap_mode: WrapMode) -> None: ...
    def starts_display_line(*args, **kwargs): ...
    def window_to_buffer_coords(self, win: TextWindowType, window_x: int, window_y: int) -> tuple[int, int]: ...
    
    def do_backspace(self, *args, **kwargs): ...
    def do_copy_clipboard(self, *args, **kwargs): ...
    def do_cut_clipboard(self, *args, **kwargs): ...
    def do_delete_from_cursor(self, *args, **kwargs): ...
    def do_draw_layer(self, *args, **kwargs): ...
    def do_extend_selection(self, *args, **kwargs): ...
    def do_insert_at_cursor(self, *args, **kwargs): ...
    def do_insert_emoji(self, *args, **kwargs): ...
    def do_move_cursor(self, *args, **kwargs): ...
    def do_paste_clipboard(self, *args, **kwargs): ...
    def do_populate_popup(self, *args, **kwargs): ...
    def do_set_anchor(self, *args, **kwargs): ...
    def do_toggle_overwrite(self, *args, **kwargs): ...
    

class ThemeEngine: ...

class ThemingEngine:
    parent_object = ...
    priv = ...
    
    def get_background_color(*args, **kwargs): ...
    def get_border(*args, **kwargs): ...
    def get_border_color(*args, **kwargs): ...
    def get_color(*args, **kwargs): ...
    def get_direction(*args, **kwargs): ...
    def get_font(*args, **kwargs): ...
    def get_junction_sides(*args, **kwargs): ...
    def get_margin(*args, **kwargs): ...
    def get_padding(*args, **kwargs): ...
    def get_path(*args, **kwargs): ...
    def get_screen(*args, **kwargs): ...
    def get_state(*args, **kwargs): ...
    def get_style_property(*args, **kwargs): ...
    def has_class(*args, **kwargs): ...
    def has_region(*args, **kwargs): ...
    def load(*args, **kwargs): ...
    def lookup_color(*args, **kwargs): ...
    def state_is_running(*args, **kwargs): ...
    
    def do_render_activity(self, *args, **kwargs): ...
    def do_render_arrow(self, *args, **kwargs): ...
    def do_render_background(self, *args, **kwargs): ...
    def do_render_check(self, *args, **kwargs): ...
    def do_render_expander(self, *args, **kwargs): ...
    def do_render_extension(self, *args, **kwargs): ...
    def do_render_focus(self, *args, **kwargs): ...
    def do_render_frame(self, *args, **kwargs): ...
    def do_render_frame_gap(self, *args, **kwargs): ...
    def do_render_handle(self, *args, **kwargs): ...
    def do_render_icon(self, *args, **kwargs): ...
    def do_render_icon_surface(self, *args, **kwargs): ...
    def do_render_layout(self, *args, **kwargs): ...
    def do_render_line(self, *args, **kwargs): ...
    def do_render_option(self, *args, **kwargs): ...
    def do_render_slider(self, *args, **kwargs): ...
    

class ToggleAction:
    parent = ...
    
    def get_active(*args, **kwargs): ...
    def get_draw_as_radio(*args, **kwargs): ...
    def set_active(*args, **kwargs): ...
    def set_draw_as_radio(*args, **kwargs): ...
    def toggled(*args, **kwargs): ...
    
    def do_toggled(self, *args, **kwargs): ...
    

class ToggleActionEntry:
    accelerator = ...
    callback = ...
    is_active = ...
    label = ...
    name = ...
    stock_id = ...
    tooltip = ...


class ToggleButton(Button):
    button = ...
    
    @classmethod
    def new_with_mnemonic(cls, label: str) -> ToggleButton: ...
    def get_active(self) -> bool: ...
    def get_inconsistent(*args, **kwargs): ...
    def get_mode(*args, **kwargs): ...
    def set_active(self, is_active: bool) -> None: ...
    def set_inconsistent(*args, **kwargs): ...
    def set_mode(*args, **kwargs): ...
    def toggled(*args, **kwargs): ...
    
    def do_toggled(self, *args, **kwargs): ...
    

class ToggleToolButton(ToolButton):
    def get_active(self) -> bool: ...
    def set_active(self, is_active: bool) -> None: ...
    
    def do_toggled(self, *args, **kwargs): ...


class ToolButton(ToolItem):
    def get_icon_name(*args, **kwargs): ...
    def get_icon_widget(*args, **kwargs): ...
    def get_label(*args, **kwargs): ...
    def get_label_widget(*args, **kwargs): ...
    def get_stock_id(*args, **kwargs): ...
    def get_use_underline(*args, **kwargs): ...
    def new_from_stock(*args, **kwargs): ...
    def set_icon_name(self, icon_name: Optional[str]) -> None: ...
    def set_icon_widget(*args, **kwargs): ...
    def set_label(self, label: Optional[str]) -> None: ...
    def set_label_widget(*args, **kwargs): ...
    def set_stock_id(*args, **kwargs): ...
    def set_use_underline(*args, **kwargs): ...
    
    def do_clicked(self, *args, **kwargs): ...
    

class ToolItem(Actionable, Activatable, Bin):
    parent = ...
    def get_ellipsize_mode(*args, **kwargs): ...
    def get_expand(*args, **kwargs): ...
    def get_homogeneous(*args, **kwargs): ...
    def get_icon_size(*args, **kwargs): ...
    def get_is_important(*args, **kwargs): ...
    def get_orientation(*args, **kwargs): ...
    def get_proxy_menu_item(*args, **kwargs): ...
    def get_relief_style(*args, **kwargs): ...
    def get_text_alignment(*args, **kwargs): ...
    def get_text_orientation(*args, **kwargs): ...
    def get_text_size_group(*args, **kwargs): ...
    def get_toolbar_style(*args, **kwargs): ...
    def get_use_drag_window(*args, **kwargs): ...
    def get_visible_horizontal(*args, **kwargs): ...
    def get_visible_vertical(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def rebuild_menu(*args, **kwargs): ...
    def retrieve_proxy_menu_item(*args, **kwargs): ...
    def set_expand(*args, **kwargs): ...
    def set_homogeneous(*args, **kwargs): ...
    def set_is_important(*args, **kwargs): ...
    def set_proxy_menu_item(*args, **kwargs): ...
    def set_tooltip_text(self, text: str) -> None: ...
    def set_use_drag_window(*args, **kwargs): ...
    def set_visible_horizontal(*args, **kwargs): ...
    def set_visible_vertical(*args, **kwargs): ...
    def toolbar_reconfigured(*args, **kwargs): ...
    
    def do_create_menu_proxy(self, *args, **kwargs): ...
    def do_toolbar_reconfigured(self, *args, **kwargs): ...
    

class ToolItemGroup:
    def get_collapsed(*args, **kwargs): ...
    def get_drop_item(*args, **kwargs): ...
    def get_ellipsize(*args, **kwargs): ...
    def get_header_relief(*args, **kwargs): ...
    def get_item_position(*args, **kwargs): ...
    def get_label(*args, **kwargs): ...
    def get_label_widget(*args, **kwargs): ...
    def get_n_items(*args, **kwargs): ...
    def get_nth_item(*args, **kwargs): ...
    def insert(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_collapsed(*args, **kwargs): ...
    def set_ellipsize(*args, **kwargs): ...
    def set_header_relief(*args, **kwargs): ...
    def set_item_position(*args, **kwargs): ...
    def set_label(*args, **kwargs): ...
    def set_label_widget(*args, **kwargs): ...
    

class ToolPalette:
    def add_drag_dest(*args, **kwargs): ...
    def get_drag_item(*args, **kwargs): ...
    def get_drag_target_group(*args, **kwargs): ...
    def get_drag_target_item(*args, **kwargs): ...
    def get_drop_group(*args, **kwargs): ...
    def get_drop_item(*args, **kwargs): ...
    def get_exclusive(*args, **kwargs): ...
    def get_expand(*args, **kwargs): ...
    def get_group_position(*args, **kwargs): ...
    def get_icon_size(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_drag_source(*args, **kwargs): ...
    def set_exclusive(*args, **kwargs): ...
    def set_expand(*args, **kwargs): ...
    def set_group_position(*args, **kwargs): ...
    def set_icon_size(*args, **kwargs): ...
    def unset_icon_size(*args, **kwargs): ...
    def unset_style(*args, **kwargs): ...
    

class ToolShell:
    def get_ellipsize_mode(*args, **kwargs): ...
    def get_icon_size(*args, **kwargs): ...
    def get_orientation(*args, **kwargs): ...
    def get_relief_style(*args, **kwargs): ...
    def get_style(*args, **kwargs): ...
    def get_text_alignment(*args, **kwargs): ...
    def get_text_orientation(*args, **kwargs): ...
    def get_text_size_group(*args, **kwargs): ...
    def rebuild_menu(*args, **kwargs): ...
    

class Toolbar(Container):
    container = ...
    
    def get_drop_index(*args, **kwargs): ...
    def get_item_index(*args, **kwargs): ...
    def get_n_items(*args, **kwargs): ...
    def get_nth_item(*args, **kwargs): ...
    def get_show_arrow(*args, **kwargs): ...
    def insert(self, item: ToolItem, pos: int) -> None: ...
    def new(*args, **kwargs): ...
    def set_drop_highlight_item(*args, **kwargs): ...
    def set_icon_size(self, icon_size: IconSize) -> None: ...
    def set_show_arrow(*args, **kwargs): ...
    def unset_icon_size(*args, **kwargs): ...
    def unset_style(*args, **kwargs): ...
    
    def do_orientation_changed(self, *args, **kwargs): ...
    def do_popup_context_menu(self, *args, **kwargs): ...
    def do_style_changed(self, *args, **kwargs): ...


class Tooltip:
    def set_custom(self, custom_widget: Optional[Widget]) -> None: ...
    def set_icon(*args, **kwargs): ...
    def set_icon_from_gicon(*args, **kwargs): ...
    def set_icon_from_icon_name(*args, **kwargs): ...
    def set_icon_from_stock(*args, **kwargs): ...
    def set_markup(*args, **kwargs): ...
    def set_text(self, text: Optional[str]) -> None: ...
    def set_tip_area(*args, **kwargs): ...
    def trigger_tooltip_query(*args, **kwargs): ...
    

class TreeDragDest:
    def drag_data_received(*args, **kwargs): ...
    def row_drop_possible(*args, **kwargs): ...
    

class TreeDragSource:
    def drag_data_delete(*args, **kwargs): ...
    def drag_data_get(*args, **kwargs): ...
    def row_draggable(*args, **kwargs): ...
    

class TreeIter:
    stamp = ...
    user_data = ...
    user_data2 = ...
    user_data3 = ...
    
    def free(*args, **kwargs): ...


class TreeModel(GObject.GInterface):
    def __getitem__(self, item: Union[TreeIter, TreePath, str, int]) -> TreeModelRow: ...
    def __delitem__(self, item: Union[TreeIter, TreePath, str, int]) -> None: ...
    def filter_new(self, root: Optional[TreePath] = None) -> TreeModelFilter: ...
    def foreach(self, func: Callable[..., Any], *user_data: Optional[Any]) -> None: ...
    def get(self, treeiter: TreeIter, *columns: list[str]) -> tuple[Any, ...]: ...
    def get_column_type(self, index) -> GObject.GType: ...
    def get_flags(self) -> TreeModelFlags: ...
    def get_iter(self, path: Union[str, TreePath]) -> TreeIter: ...
    def get_iter_first(self) -> Optional[TreeIter]: ...
    def get_iter_from_string(self, path_string: str) -> TreeIter: ...
    def get_n_columns(self) -> int: ...
    def get_path(self, iter: TreeIter) -> TreePath: ...
    def get_string_from_iter(self, iter: TreeIter) -> str: ...
    def get_value(self, iter: TreeIter, column: int) -> Any: ...
    def iter_children(self, parent: Optional[TreeIter]) -> Optional[TreeIter]: ...
    def iter_has_child(self, iter: TreeIter) -> bool: ...
    def iter_n_children(self, iter: Optional[TreeIter]) -> int: ...
    def iter_next(self, iter: TreeIter) -> Optional[TreeIter]: ...
    def iter_nth_child(self, parent: Optional[TreeIter], n: int) -> Optional[TreeIter]: ...
    def iter_parent(self, child: TreeIter) -> Optional[TreeIter]: ...
    def iter_previous(self, iter: TreeIter) -> Optional[TreeIter]: ...
    def ref_node(self, iter: TreeIter) -> None: ...
    def row_changed(self, path: TreePath, iter: TreeIter) -> None: ...
    def row_deleted(self, path: TreePath) -> None: ...
    def row_has_child_toggled(self, path: TreePath, iter: TreeIter) -> None: ...
    def row_inserted(self, path: TreePath, iter: TreeIter) -> None: ...
    def rows_reordered(self, path: TreePath, iter: Optional[TreeIter], new_order: list[int]) -> None: ...
    def set_row(self, treeiter: TreeIter, row: list[Any]): ...
    def sort_new_with_model(self) -> TreeModelSort: ...
    def unref_node(self, iter: TreeIter) -> None: ...
    

class TreeModelFilter(GObject.Object, TreeDragSource, TreeModel):
    parent = ...
    priv = ...
    
    def clear_cache(*args, **kwargs): ...
    def convert_child_iter_to_iter(*args, **kwargs): ...
    def convert_child_path_to_path(*args, **kwargs): ...
    def convert_iter_to_child_iter(*args, **kwargs): ...
    def convert_path_to_child_path(self, filter_path: TreePath) -> Optional[TreePath]: ...
    def get_model(*args, **kwargs): ...
    def refilter(self) -> None: ...
    def set_modify_func(*args, **kwargs): ...
    def set_value(*args, **kwargs): ...
    def set_visible_column(self, column: int) -> None: ...
    def set_visible_func(self, func: Callable[[TreeModelFilter, TreeIter, Any], bool], data: Optional[Any] = ...) -> None: ...
    
    def do_modify(self, *args, **kwargs): ...
    def do_visible(self, *args, **kwargs): ...


class TreeModelRow:
    iter: TreeIter
    model: TreeModel
    next = ...
    parent = ...
    path = ...
    previous = ...
    
    def __getitem__(self, key: int) -> Any: ...
    def __setitem__(self, key: int, value: Any) -> None: ...
    def get_next(*args, **kwargs): ...
    def get_parent(*args, **kwargs): ...
    def get_previous(*args, **kwargs): ...
    def iterchildren(self) -> Iterator[TreeModelRow]: ...
    

class TreeModelRowIter:
    def next(*args, **kwargs): ...
    

class TreeModelSort(GObject.Object, TreeDragSource, TreeModel, TreeSortable):
    parent = ...
    priv = ...
    
    def clear_cache(*args, **kwargs): ...
    def convert_child_iter_to_iter(*args, **kwargs): ...
    def convert_child_path_to_path(*args, **kwargs): ...
    def convert_iter_to_child_iter(*args, **kwargs): ...
    def convert_path_to_child_path(self, filter_path: TreePath) -> Optional[TreePath]: ...
    def get_model(*args, **kwargs): ...
    def iter_is_valid(*args, **kwargs): ...
    def new_with_model(*args, **kwargs): ...
    def reset_default_sort_func(*args, **kwargs): ...
    

class TreePath:
    def append_index(*args, **kwargs): ...
    def compare(*args, **kwargs): ...
    def down(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_depth(*args, **kwargs): ...
    def get_indices(*args, **kwargs): ...
    def is_ancestor(*args, **kwargs): ...
    def is_descendant(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_first(*args, **kwargs): ...
    def new_from_indices(*args, **kwargs): ...
    @classmethod
    def new_from_string(cls, path: str) -> TreePath: ...
    def next(*args, **kwargs): ...
    def prepend_index(*args, **kwargs): ...
    def prev(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    def up(*args, **kwargs): ...


class TreeRowReference:
    def __init__(self, model: TreeModel, path: TreePath) -> None: ...
    def deleted(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_model(*args, **kwargs): ...
    def get_path(self) -> Optional[TreePath]: ...
    def inserted(*args, **kwargs): ...
    @classmethod
    def new(cls, model: TreeModel, path: TreePath) -> TreeRowReference: ...
    def new_proxy(*args, **kwargs): ...
    def valid(*args, **kwargs): ...
    

class TreeSelection(GObject.Object):
    parent = ...
    priv = ...
    
    def count_selected_rows(self) -> int: ...
    def get_mode(*args, **kwargs): ...
    def get_selected(self) -> tuple[TreeModel, Optional[TreeIter]]: ...
    def get_selected_rows(self) -> tuple[TreeModel, list[TreePath]]: ...
    def get_tree_view(*args, **kwargs): ...
    def iter_is_selected(*args, **kwargs): ...
    def path_is_selected(*args, **kwargs): ...
    def select_all(*args, **kwargs): ...
    def select_iter(self, iter: TreeIter) -> None: ...
    def select_path(self, path: TreePath) -> None: ...
    def select_range(*args, **kwargs): ...
    def selected_foreach(*args, **kwargs): ...
    def set_mode(self, type: SelectionMode) -> None: ...
    def set_select_function(*args, **kwargs): ...
    def unselect_all(self) -> None: ...
    def unselect_iter(*args, **kwargs): ...
    def unselect_path(*args, **kwargs): ...
    def unselect_range(*args, **kwargs): ...
    
    def do_changed(self, *args, **kwargs): ...
    

class TreeSortable:
    def get_sort_column_id(*args, **kwargs): ...
    def has_default_sort_func(*args, **kwargs): ...
    def set_default_sort_func(*args, **kwargs): ...
    def set_sort_column_id(self, sort_column_id: int, order: SortType) -> None: ...
    def set_sort_func(self, sort_column_id: int, sort_func: Callable[[TreeModel, TreeIter, TreeIter, Any], Any], user_data: Optional[Any] = None) -> None: ...
    def sort_column_changed(*args, **kwargs): ...
    

class TreeStore(GObject.Object, TreeModel, TreeSortable):
    parent = ...
    priv = ...

    def __init__(self, *args: Any) -> None: ...
    def append(self, parent: Optional[TreeIter], row: Optional[list[Any]] = None) -> TreeIter: ...
    def clear(self) -> None: ...
    def insert(*args, **kwargs): ...
    def insert_after(*args, **kwargs): ...
    def insert_before(*args, **kwargs): ...
    def insert_with_values(*args, **kwargs): ...
    def is_ancestor(*args, **kwargs): ...
    def iter_depth(*args, **kwargs): ...
    def iter_is_valid(*args, **kwargs): ...
    def move_after(*args, **kwargs): ...
    def move_before(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def prepend(*args, **kwargs): ...
    def remove(self, iter: TreeIter) -> bool: ...
    def set(*args, **kwargs): ...
    def set_column_types(*args, **kwargs): ...
    def set_value(*args, **kwargs): ...
    def swap(*args, **kwargs): ...


class TreeView(Container):
    parent = ...

    def append_column(self, column: TreeViewColumn) -> int: ...
    def collapse_all(*args, **kwargs): ...
    def collapse_row(*args, **kwargs): ...
    def columns_autosize(*args, **kwargs): ...
    def convert_bin_window_to_tree_coords(*args, **kwargs): ...
    def convert_bin_window_to_widget_coords(*args, **kwargs): ...
    def convert_tree_to_bin_window_coords(*args, **kwargs): ...
    def convert_tree_to_widget_coords(*args, **kwargs): ...
    def convert_widget_to_bin_window_coords(*args, **kwargs): ...
    def convert_widget_to_tree_coords(*args, **kwargs): ...
    def create_row_drag_icon(*args, **kwargs): ...
    def enable_model_drag_dest(self, targets: list[TargetEntry], actions: Gdk.DragAction) -> None: ...
    def enable_model_drag_source(self, start_button_mask: Gdk.ModifierType, targets: list[TargetEntry], actions: Gdk.DragAction) -> None: ...
    def expand_all(self) -> None: ...
    def expand_row(self, path: TreePath, open_all: bool) -> bool: ...
    def expand_to_path(*args, **kwargs): ...
    def get_activate_on_single_click(*args, **kwargs): ...
    def get_background_area(*args, **kwargs): ...
    def get_bin_window(*args, **kwargs): ...
    def get_cell_area(*args, **kwargs): ...
    def get_column(self, n: int) -> Optional[TreeViewColumn]: ...
    def get_columns(self) -> list[TreeViewColumn]: ...
    def get_cursor(*args, **kwargs): ...
    def get_dest_row_at_pos(self, drag_x: int, drag_y: int) -> Optional[tuple[TreePath, TreeViewDropPosition]]: ...
    def get_drag_dest_row(*args, **kwargs): ...
    def get_enable_search(*args, **kwargs): ...
    def get_enable_tree_lines(*args, **kwargs): ...
    def get_expander_column(*args, **kwargs): ...
    def get_fixed_height_mode(*args, **kwargs): ...
    def get_grid_lines(*args, **kwargs): ...
    def get_headers_clickable(*args, **kwargs): ...
    def get_headers_visible(*args, **kwargs): ...
    def get_hover_expand(*args, **kwargs): ...
    def get_hover_selection(*args, **kwargs): ...
    def get_level_indentation(*args, **kwargs): ...
    def get_model(self) -> Optional[TreeModel]: ...
    def get_n_columns(*args, **kwargs): ...
    def get_path_at_pos(self, x: int, y: int) -> Optional[tuple[Optional[TreePath], Optional[TreeViewColumn], int, int]]: ...
    def get_reorderable(*args, **kwargs): ...
    def get_rubber_banding(*args, **kwargs): ...
    def get_rules_hint(*args, **kwargs): ...
    def get_search_column(*args, **kwargs): ...
    def get_search_entry(*args, **kwargs): ...
    def get_selection(self) -> TreeSelection: ...
    def get_show_expanders(*args, **kwargs): ...
    def get_tooltip_column(*args, **kwargs): ...
    def get_tooltip_context(self, x: int, y:int, keyboard_tip: bool) -> tuple[bool, int, int, Optional[TreeModel], TreePath, TreeIter]: ...
    def get_visible_range(*args, **kwargs): ...
    def get_visible_rect(*args, **kwargs): ...
    def insert_column(self, column: TreeViewColumn, position: int) -> int: ...
    def insert_column_with_attributes(self, position: int, title: str, cell: CellRenderer, **kwargs: Any) -> None: ...
    def insert_column_with_data_func(*args, **kwargs): ...
    def is_blank_at_pos(*args, **kwargs): ...
    def is_rubber_banding_active(*args, **kwargs): ...
    def map_expanded_rows(*args, **kwargs): ...
    def move_column_after(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_model(*args, **kwargs): ...
    def remove_column(*args, **kwargs): ...
    def row_activated(*args, **kwargs): ...
    def row_expanded(*args, **kwargs): ...
    def scroll_to_cell(self, path: Optional[TreePath], column: Optional[TreeViewColumn], use_align: bool, row_align: float, col_align: float) -> None: ...
    def scroll_to_point(*args, **kwargs): ...
    def set_activate_on_single_click(*args, **kwargs): ...
    def set_column_drag_function(*args, **kwargs): ...
    def set_cursor(self, path: TreePath, focus_column: Optional[TreeViewColumn] = None, start_editing: bool = True) -> None: ...
    def set_cursor_on_cell(*args, **kwargs): ...
    def set_destroy_count_func(*args, **kwargs): ...
    def set_drag_dest_row(*args, **kwargs): ...
    def set_enable_search(*args, **kwargs): ...
    def set_enable_tree_lines(*args, **kwargs): ...
    def set_expander_column(*args, **kwargs): ...
    def set_fixed_height_mode(*args, **kwargs): ...
    def set_grid_lines(*args, **kwargs): ...
    def set_headers_clickable(*args, **kwargs): ...
    def set_headers_visible(*args, **kwargs): ...
    def set_hover_expand(*args, **kwargs): ...
    def set_hover_selection(*args, **kwargs): ...
    def set_level_indentation(*args, **kwargs): ...
    def set_model(self, model: Optional[TreeModel]) -> None: ...
    def set_reorderable(*args, **kwargs): ...
    def set_row_separator_func(*args, **kwargs): ...
    def set_rubber_banding(*args, **kwargs): ...
    def set_rules_hint(*args, **kwargs): ...
    def set_search_column(*args, **kwargs): ...
    def set_search_entry(*args, **kwargs): ...
    def set_search_equal_func(self, search_equal_func: Callable[[TreeModel, int, str, TreeIter], Any], search_user_data: Optional[Any] = None) -> None: ...
    def set_search_position_func(*args, **kwargs): ...
    def set_show_expanders(*args, **kwargs): ...
    def set_tooltip_cell(*args, **kwargs): ...
    def set_tooltip_column(*args, **kwargs): ...
    def set_tooltip_row(*args, **kwargs): ...
    def unset_rows_drag_dest(*args, **kwargs): ...
    def unset_rows_drag_source(*args, **kwargs): ...
    
    def do_columns_changed(self, *args, **kwargs): ...
    def do_cursor_changed(self, *args, **kwargs): ...
    def do_expand_collapse_cursor_row(self, *args, **kwargs): ...
    def do_move_cursor(self, *args, **kwargs): ...
    def do_row_activated(self, *args, **kwargs): ...
    def do_row_collapsed(self, *args, **kwargs): ...
    def do_row_expanded(self, *args, **kwargs): ...
    def do_select_all(self, *args, **kwargs): ...
    def do_select_cursor_parent(self, *args, **kwargs): ...
    def do_select_cursor_row(self, *args, **kwargs): ...
    def do_start_interactive_search(self, *args, **kwargs): ...
    def do_test_collapse_row(self, *args, **kwargs): ...
    def do_test_expand_row(self, *args, **kwargs): ...
    def do_toggle_cursor_row(self, *args, **kwargs): ...
    def do_unselect_all(self, *args, **kwargs): ...


class TreeViewColumn(Buildable, CellLayout, GObject.InitiallyUnowned):
    parent_instance = ...
    priv = ...
    
    def __init__(self, title: str = '', cell_renderer: CellRenderer = None, **attrs: Any) -> None: ...
    def cell_get_position(*args, **kwargs): ...
    def cell_get_size(*args, **kwargs): ...
    def cell_is_visible(*args, **kwargs): ...
    def cell_set_cell_data(*args, **kwargs): ...
    def clicked(*args, **kwargs): ...
    def focus_cell(*args, **kwargs): ...
    def get_alignment(*args, **kwargs): ...
    def get_button(*args, **kwargs): ...
    def get_clickable(*args, **kwargs): ...
    def get_expand(*args, **kwargs): ...
    def get_fixed_width(*args, **kwargs): ...
    def get_max_width(*args, **kwargs): ...
    def get_min_width(*args, **kwargs): ...
    def get_reorderable(*args, **kwargs): ...
    def get_resizable(*args, **kwargs): ...
    def get_sizing(*args, **kwargs): ...
    def get_sort_column_id(*args, **kwargs): ...
    def get_sort_indicator(*args, **kwargs): ...
    def get_sort_order(*args, **kwargs): ...
    def get_spacing(*args, **kwargs): ...
    def get_title(*args, **kwargs): ...
    def get_tree_view(*args, **kwargs): ...
    def get_visible(*args, **kwargs): ...
    def get_widget(*args, **kwargs): ...
    def get_width(*args, **kwargs): ...
    def get_x_offset(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_with_area(*args, **kwargs): ...
    def queue_resize(*args, **kwargs): ...
    def set_alignment(*args, **kwargs): ...
    def set_attributes(*args, **kwargs): ...
    def set_cell_data_func(self, cell_renderer: CellRendererT, func: Callable[[TreeViewColumn, CellRendererT, TreeModel, TreeIter, Any], Any], func_data: Optional[object] = None) -> None: ...
    def set_clickable(*args, **kwargs): ...
    def set_expand(self, expand: bool) -> None: ...
    def set_fixed_width(self, fixed_width: int) -> None: ...
    def set_max_width(*args, **kwargs): ...
    def set_min_width(*args, **kwargs): ...
    def set_reorderable(*args, **kwargs): ...
    def set_resizable(self, resizable: bool) -> None: ...
    def set_sizing(self, type: TreeViewColumnSizing) -> None: ...
    def set_sort_column_id(self, sort_column_id: int) -> None: ...
    def set_sort_indicator(*args, **kwargs): ...
    def set_sort_order(*args, **kwargs): ...
    def set_spacing(*args, **kwargs): ...
    def set_title(*args, **kwargs): ...
    def set_visible(*args, **kwargs): ...
    def set_widget(*args, **kwargs): ...
    
    def do_clicked(self, *args, **kwargs): ...
    

class UIManager:
    parent = ...
    private_data = ...
    
    def add_ui(*args, **kwargs): ...
    def add_ui_from_file(*args, **kwargs): ...
    def add_ui_from_resource(*args, **kwargs): ...
    def add_ui_from_string(*args, **kwargs): ...
    def ensure_update(*args, **kwargs): ...
    def get_accel_group(*args, **kwargs): ...
    def get_action(*args, **kwargs): ...
    def get_action_groups(*args, **kwargs): ...
    def get_add_tearoffs(*args, **kwargs): ...
    def get_toplevels(*args, **kwargs): ...
    def get_ui(*args, **kwargs): ...
    def get_widget(*args, **kwargs): ...
    def insert_action_group(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def new_merge_id(*args, **kwargs): ...
    def remove_action_group(*args, **kwargs): ...
    def remove_ui(*args, **kwargs): ...
    def set_add_tearoffs(*args, **kwargs): ...
    
    def do_actions_changed(self, *args, **kwargs): ...
    def do_add_widget(self, *args, **kwargs): ...
    def do_connect_proxy(self, *args, **kwargs): ...
    def do_disconnect_proxy(self, *args, **kwargs): ...
    def do_get_action(self, *args, **kwargs): ...
    def do_get_widget(self, *args, **kwargs): ...
    def do_post_activate(self, *args, **kwargs): ...
    def do_pre_activate(self, *args, **kwargs): ...
    

class VBox:
    box = ...
    

class VButtonBox:
    button_box = ...
    

class VPaned:
    paned = ...
    

class VScale:
    scale = ...
    

class VScrollbar:
    scrollbar = ...
    

class VSeparator:
    separator = ...
    

class Viewport(Bin, Scrollable):
    bin = ...
    
    def get_bin_window(*args, **kwargs): ...
    def get_shadow_type(*args, **kwargs): ...
    def get_view_window(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_shadow_type(*args, **kwargs): ...
    

class VolumeButton(ScaleButton): ...

class Widget(GObject.Object):
    parent_instance = ...
    priv = ...

    def __init__(self, can_default: bool = False, no_show_all: bool = False) -> None: ...
    def activate(self) -> bool: ...
    def add_accelerator(*args, **kwargs): ...
    def add_device_events(*args, **kwargs): ...
    def add_events(self, events: int) -> None: ...
    def add_mnemonic_label(*args, **kwargs): ...
    def add_tick_callback(*args, **kwargs): ...
    def bind_template_callback_full(*args, **kwargs): ...
    def bind_template_child_full(*args, **kwargs): ...
    def can_activate_accel(*args, **kwargs): ...
    def child_focus(*args, **kwargs): ...
    def child_notify(*args, **kwargs): ...
    def class_path(*args, **kwargs): ...
    def compute_expand(*args, **kwargs): ...
    def create_pango_context(*args, **kwargs): ...
    def create_pango_layout(*args, **kwargs): ...
    def destroy(self) -> None: ...
    def destroyed(self, widget_pointer: Widget) -> Widget: ...
    def device_is_shadowed(*args, **kwargs): ...
    def drag_begin(*args, **kwargs): ...
    def drag_begin_with_coordinates(*args, **kwargs): ...
    def drag_check_threshold(*args, **kwargs): ...
    def drag_dest_add_image_targets(*args, **kwargs): ...
    def drag_dest_add_text_targets(*args, **kwargs): ...
    def drag_dest_add_uri_targets(*args, **kwargs): ...
    def drag_dest_find_target(self, context: Gdk.DragContext, target_list: Optional[TargetList]) -> Gdk.Atom: ...
    def drag_dest_get_target_list(self) -> Optional[TargetList]: ...
    def drag_dest_get_track_motion(*args, **kwargs): ...
    def drag_dest_set(self, flags: DestDefaults, targets: Optional[list[TargetEntry]], actions: Gdk.DragAction) -> None: ...
    def drag_dest_set_proxy(*args, **kwargs): ...
    def drag_dest_set_target_list(self, targets: Optional[TargetList]) -> None: ...
    def drag_dest_set_track_motion(*args, **kwargs): ...
    def drag_dest_unset(self) -> None: ...
    def drag_get_data(self, context: Gdk.DragContext, target: Gdk.Atom, time: int) -> None: ...
    def drag_highlight(*args, **kwargs): ...
    def drag_source_add_image_targets(*args, **kwargs): ...
    def drag_source_add_text_targets(*args, **kwargs): ...
    def drag_source_add_uri_targets(*args, **kwargs): ...
    def drag_source_get_target_list(*args, **kwargs): ...
    def drag_source_set(self, start_button_mask: Gdk.ModifierType, targets: Optional[list[TargetEntry]], actions: Gdk.DragAction) -> None: ...
    def drag_source_set_icon_gicon(*args, **kwargs): ...
    def drag_source_set_icon_name(*args, **kwargs): ...
    def drag_source_set_icon_pixbuf(*args, **kwargs): ...
    def drag_source_set_icon_stock(*args, **kwargs): ...
    def drag_source_set_target_list(*args, **kwargs): ...
    def drag_source_unset(*args, **kwargs): ...
    def drag_unhighlight(*args, **kwargs): ...
    def draw(self, cr: cairo.Context) -> None: ...
    def ensure_style(*args, **kwargs): ...
    def error_bell(*args, **kwargs): ...
    def event(*args, **kwargs): ...
    def find_style_property(*args, **kwargs): ...
    def freeze_child_notify(*args, **kwargs): ...
    def get_accessible(self) -> Atk.Object: ...
    def get_action_group(self, prefix: str) -> Optional[Gio.ActionGroup]: ...
    def get_allocated_baseline(self) -> int: ...
    def get_allocated_height(self) -> int: ...
    def get_allocated_size(self) -> tuple[Gdk.Rectangle, int]: ...
    def get_allocated_width(self) -> int: ...
    def get_allocation(self) -> Gdk.Rectangle: ...
    def get_ancestor(self, widget_type: GObject.GType) -> Optional[Widget]: ...
    def get_app_paintable(self) -> bool: ...
    def get_can_default(self) -> bool: ...
    def get_can_focus(self) -> bool: ...
    def get_child_requisition(self) -> Requisition: ...
    def get_child_visible(self) -> bool: ...
    def get_clip(self) -> Gdk.Rectangle: ...
    def get_clipboard(self, selection: Gdk.Atom) -> Clipboard: ...
    def get_composite_name(self) -> Optional[str]: ...
    @classmethod
    def get_css_name(cls) -> str: ...
    @classmethod
    def get_default_direction(cls) -> TextDirection: ...
    @classmethod
    def get_default_style(cls) -> Style: ...
    def get_device_enabled(self, device: Gdk.Device) -> bool: ...
    def get_device_events(self, device: Gdk.Device) -> Gdk.EventMask: ...
    def get_direction(self) -> TextDirection: ...
    def get_display(self) -> Gdk.Display: ...
    def get_double_buffered(self) -> bool: ...
    def get_events(self) -> int: ...
    def get_focus_on_click(self) -> bool: ...
    def get_font_map(self) -> Optional[Pango.FontMap]: ...
    def get_font_options(self) -> Optional[cairo.FontOptions]: ...
    def get_frame_clock(self) -> Optional[Gdk.FrameClock]: ...
    def get_halign(self) -> Align: ...
    def get_has_tooltip(self) -> bool: ...
    def get_has_window(self) -> bool: ...
    def get_hexpand(self) -> bool: ...
    def get_hexpand_set(self) -> bool: ...
    def get_mapped(self) -> bool: ...
    def get_margin_bottom(self) -> int: ...
    def get_margin_end(self) -> int: ...
    def get_margin_left(self) -> int: ...
    def get_margin_right(self) -> int: ...
    def get_margin_start(self) -> int: ...
    def get_margin_top(self) -> int: ...
    def get_modifier_mask(self, intent: Gdk.ModifierIntent) -> Gdk.ModifierType: ...
    def get_modifier_style(self) -> RcStyle: ...
    def get_name(self) -> str: ...
    def get_no_show_all(self) -> bool: ...
    def get_opacity(self) -> float: ...
    def get_pango_context(self) -> Pango.Context: ...
    def get_parent(self) -> Optional[Widget]: ...
    def get_parent_window(self) -> Optional[Gdk.Window]: ...
    def get_path(self) -> WidgetPath: ...
    def get_pointer(self) -> tuple[int, int]: ...
    def get_preferred_height(self) -> tuple[Optional[int], Optional[int]]: ...
    def get_preferred_height_and_baseline_for_width(self, width: int) -> tuple[Optional[int], Optional[int], Optional[int], Optional[int]]: ...
    def get_preferred_height_for_width(self, width: int) -> tuple[Optional[int], Optional[int]]: ...
    def get_preferred_size(self) -> tuple[Optional[Requisition], Optional[Requisition]]: ...
    def get_preferred_width(self) -> tuple[Optional[int], Optional[int]]: ...
    def get_preferred_width_for_height(self, height: int) -> tuple[Optional[int], Optional[int]]: ...
    def get_realized(self) -> bool: ...
    def get_receives_default(self) -> bool: ...
    def get_request_mode(self) -> SizeRequestMode: ...
    def get_requisition(self) -> Requisition: ...
    def get_root_window(self) -> Gdk.Window: ...
    def get_scale_factor(self) -> int: ...
    def get_screen(self) -> Gdk.Screen: ...
    def get_sensitive(self) -> bool: ...
    def get_settings(self) -> Settings: ...
    def get_size_request(self) -> tuple[int, int]: ...
    def get_state(self) -> StateType: ...
    def get_state_flags(self) -> StateFlags: ...
    def get_style(self) -> Style: ...
    def get_style_context(self) -> StyleContext: ...
    def get_support_multidevice(self) -> bool: ...
    def get_template_child(self, widget: GObject.GType, name: str) -> GObject.Object: ...
    def get_tooltip_markup(self) -> Optional[str]: ...
    def get_tooltip_text(self) -> Optional[str]: ...
    def get_tooltip_window(self) -> Gdk.Window: ...
    def get_toplevel(self) -> Widget: ...
    def get_valign(self) -> Align: ...
    def get_valign_with_baseline(self) -> Align: ...
    def get_vexpand(self) -> bool: ...
    def get_vexpand_set(self) -> bool: ...
    def get_visible(self) -> bool: ...
    def get_visual(self) -> Gdk.Visual: ...
    def get_window(self) -> Optional[Gdk.Window]: ...
    def grab_add(self) -> None: ...
    def grab_default(self) -> None: ...
    def grab_focus(self) -> None: ...
    def grab_remove(self) -> None: ...
    def has_default(self) -> bool: ...
    def has_focus(self) -> bool: ...
    def has_grab(self) -> bool: ...
    def has_rc_style(self) -> bool: ...
    def has_screen(self) -> bool: ...
    def has_visible_focus(self) -> bool: ...
    def hide(self) -> None: ...
    def hide_on_delete(self) -> bool: ...
    def in_destruction(self) -> bool: ...
    def init_template(self) -> None: ...
    def input_shape_combine_region(self, region: Optional[cairo.Region]) -> None: ...
    def insert_action_group(self, name: str, group: Optional[Gio.ActionGroup]) -> None: ...
    @classmethod
    def install_style_property(cls, pspec: GObject.ParamSpec) -> None: ...
    def intersect(self, area: Gdk.Rectangle) -> tuple[bool, Gdk.Rectangle]: ...
    def is_ancestor(self, ancestor: Widget) -> bool: ...
    def is_composited(self) -> bool: ...
    def is_drawable(self) -> bool: ...
    def is_focus(self) -> bool: ...
    def is_sensitive(self) -> bool: ...
    def is_toplevel(self) -> bool: ...
    def is_visible(self) -> bool: ...
    def keynav_failed(self, direction: DirectionType) -> bool: ...
    def list_accel_closures(*args, **kwargs): ...
    def list_action_prefixes(*args, **kwargs): ...
    def list_mnemonic_labels(*args, **kwargs): ...
    def list_style_properties(*args, **kwargs): ...
    def map(*args, **kwargs): ...
    def mnemonic_activate(*args, **kwargs): ...
    def modify_base(*args, **kwargs): ...
    def modify_bg(*args, **kwargs): ...
    def modify_cursor(*args, **kwargs): ...
    def modify_fg(*args, **kwargs): ...
    def modify_font(*args, **kwargs): ...
    def modify_style(*args, **kwargs): ...
    def modify_text(*args, **kwargs): ...
    def override_background_color(*args, **kwargs): ...
    def override_color(*args, **kwargs): ...
    def override_cursor(*args, **kwargs): ...
    def override_font(*args, **kwargs): ...
    def override_symbolic_color(*args, **kwargs): ...
    def path(*args, **kwargs): ...
    def pop_composite_child(*args, **kwargs): ...
    def push_composite_child(*args, **kwargs): ...
    def queue_allocate(*args, **kwargs): ...
    def queue_compute_expand(*args, **kwargs): ...
    def queue_draw(self) -> None: ...
    def queue_draw_area(self, x: int, y: int, width: int, height: int) -> None: ...
    def queue_draw_region(*args, **kwargs): ...
    def queue_resize(self) -> None: ...
    def queue_resize_no_redraw(*args, **kwargs): ...
    def realize(*args, **kwargs): ...
    def region_intersect(*args, **kwargs): ...
    def register_window(*args, **kwargs): ...
    def remove_accelerator(*args, **kwargs): ...
    def remove_mnemonic_label(*args, **kwargs): ...
    def remove_tick_callback(*args, **kwargs): ...
    def render_icon(*args, **kwargs): ...
    def render_icon_pixbuf(*args, **kwargs): ...
    def reparent(*args, **kwargs): ...
    def reset_rc_styles(*args, **kwargs): ...
    def reset_style(*args, **kwargs): ...
    def send_expose(*args, **kwargs): ...
    def send_focus_change(*args, **kwargs): ...
    def set_accel_path(*args, **kwargs): ...
    def set_accessible_role(*args, **kwargs): ...
    def set_accessible_type(*args, **kwargs): ...
    def set_allocation(*args, **kwargs): ...
    def set_app_paintable(*args, **kwargs): ...
    def set_can_default(self, can_default: bool) -> None: ...
    def set_can_focus(self, can_focus: bool) -> None: ...
    def set_child_visible(self, is_visible: bool) -> None: ...
    def set_clip(self, clip: Gdk.Rectangle) -> None: ...
    def set_composite_name(self, name: str) -> None: ...
    def set_connect_func(*args, **kwargs) -> None: ...
    def set_css_name(*args, **kwargs) -> None: ...
    def set_default_direction(*args, **kwargs) -> None: ...
    def set_device_enabled(self, device: Gdk.Device, enabled: bool) -> None: ...
    def set_device_events(self, device: Gdk.Device, events: Gdk.EventMask) -> None: ...
    def set_direction(self, dir: TextDirection) -> None: ...
    def set_double_buffered(self, double_buffered: bool) -> None: ...
    def set_events(self, events: Gdk.EventMask) -> None: ...
    def set_focus_on_click(self, focus_on_click: bool) -> None: ...
    def set_font_map(*args, **kwargs): ...
    def set_font_options(*args, **kwargs): ...
    def set_halign(self, align: Align) -> None: ...
    def set_has_tooltip(self, has_tooltip: bool) -> None: ...
    def set_has_window(*args, **kwargs): ...
    def set_hexpand(self, expand: bool) -> None: ...
    def set_hexpand_set(*args, **kwargs): ...
    def set_mapped(*args, **kwargs): ...
    def set_margin_bottom(self, margin: int) -> None: ...
    def set_margin_end(self, margin: int) -> None: ...
    def set_margin_left(self, margin: int) -> None: ...
    def set_margin_right(self, margin: int) -> None: ...
    def set_margin_start(self, margin: int) -> None: ...
    def set_margin_top(self, margin: int) -> None: ...
    def set_name(self, name: str) -> None: ...
    def set_no_show_all(self, no_show_all: bool) -> None: ...
    def set_opacity(self, opacity: float) -> None: ...
    def set_parent(*args, **kwargs): ...
    def set_parent_window(*args, **kwargs): ...
    def set_realized(*args, **kwargs): ...
    def set_receives_default(self, receives_default: bool) -> None: ...
    def set_redraw_on_allocate(*args, **kwargs): ...
    def set_sensitive(self, sensitive: bool) -> None: ...
    def set_size_request(self, width: int, height: int) -> None: ...
    def set_state(*args, **kwargs): ...
    def set_state_flags(self, flags: StateFlags, clear: bool) -> None: ...
    def set_style(*args, **kwargs): ...
    def set_support_multidevice(*args, **kwargs): ...
    def set_template(*args, **kwargs): ...
    def set_template_from_resource(*args, **kwargs): ...
    def set_tooltip_markup(self, markup: Optional[str]) -> None: ...
    def set_tooltip_text(self, text: Optional[str]) -> None: ...
    def set_tooltip_window(*args, **kwargs): ...
    def set_valign(self, align: Align) -> None: ...
    def set_vexpand(self, expand: bool) -> None: ...
    def set_vexpand_set(*args, **kwargs): ...
    def set_visible(self, visible: bool) -> None: ...
    def set_visual(*args, **kwargs): ...
    def set_window(*args, **kwargs): ...
    def shape_combine_region(*args, **kwargs): ...
    def show(self) -> None: ...
    def show_all(self) -> None: ...
    def show_now(self) -> None: ...
    def size_allocate(*args, **kwargs): ...
    def size_allocate_with_baseline(*args, **kwargs): ...
    def size_request(*args, **kwargs): ...
    def style_attach(*args, **kwargs): ...
    def style_get_property(*args, **kwargs): ...
    def thaw_child_notify(*args, **kwargs): ...
    def translate_coordinates(self, dest_widget: Widget, src_x: int, src_y: int) -> Optional[tuple[int, int]]: ...
    def trigger_tooltip_query(*args, **kwargs): ...
    def unmap(*args, **kwargs): ...
    def unparent(*args, **kwargs): ...
    def unrealize(*args, **kwargs): ...
    def unregister_window(*args, **kwargs): ...
    def unset_state_flags(self, flags: StateFlags) -> None: ...

    def do_adjust_baseline_allocation(self, *args, **kwargs): ...
    def do_adjust_baseline_request(self, *args, **kwargs): ...
    def do_adjust_size_allocation(self, *args, **kwargs): ...
    def do_adjust_size_request(self, *args, **kwargs): ...
    def do_button_press_event(self, *args, **kwargs): ...
    def do_button_release_event(self, *args, **kwargs): ...
    def do_can_activate_accel(self, *args, **kwargs): ...
    def do_child_notify(self, *args, **kwargs): ...
    def do_composited_changed(self, *args, **kwargs): ...
    def do_compute_expand(self, *args, **kwargs): ...
    def do_configure_event(self, *args, **kwargs): ...
    def do_damage_event(self, *args, **kwargs): ...
    def do_delete_event(self, *args, **kwargs): ...
    def do_destroy(self, *args, **kwargs): ...
    def do_destroy_event(self, *args, **kwargs): ...
    def do_direction_changed(self, *args, **kwargs): ...
    def do_dispatch_child_properties_changed(self, *args, **kwargs): ...
    def do_drag_begin(self, *args, **kwargs): ...
    def do_drag_data_delete(self, *args, **kwargs): ...
    def do_drag_data_get(self, *args, **kwargs): ...
    def do_drag_data_received(self, *args, **kwargs): ...
    def do_drag_drop(self, *args, **kwargs): ...
    def do_drag_end(self, *args, **kwargs): ...
    def do_drag_failed(self, *args, **kwargs): ...
    def do_drag_leave(self, *args, **kwargs): ...
    def do_drag_motion(self, *args, **kwargs): ...
    def do_draw(self, *args, **kwargs): ...
    def do_enter_notify_event(self, *args, **kwargs): ...
    def do_event(self, *args, **kwargs): ...
    def do_focus(self, *args, **kwargs): ...
    def do_focus_in_event(self, *args, **kwargs): ...
    def do_focus_out_event(self, *args, **kwargs): ...
    def do_get_accessible(self, *args, **kwargs): ...
    def do_get_preferred_height(self, *args, **kwargs): ...
    def do_get_preferred_height_and_baseline_for_width(self, *args, **kwargs): ...
    def do_get_preferred_height_for_width(self, *args, **kwargs): ...
    def do_get_preferred_width(self) -> tuple[int, int]: ...
    def do_get_preferred_width_for_height(self, *args, **kwargs): ...
    def do_get_request_mode(self, *args, **kwargs): ...
    def do_grab_broken_event(self, *args, **kwargs): ...
    def do_grab_focus(self, *args, **kwargs): ...
    def do_grab_notify(self, *args, **kwargs): ...
    def do_hide(self, *args, **kwargs): ...
    def do_hierarchy_changed(self, *args, **kwargs): ...
    def do_key_press_event(self, *args, **kwargs): ...
    def do_key_release_event(self, *args, **kwargs): ...
    def do_keynav_failed(self, *args, **kwargs): ...
    def do_leave_notify_event(self, *args, **kwargs): ...
    def do_map(self, *args, **kwargs): ...
    def do_map_event(self, *args, **kwargs): ...
    def do_mnemonic_activate(self, *args, **kwargs): ...
    def do_motion_notify_event(self, *args, **kwargs): ...
    def do_move_focus(self, *args, **kwargs): ...
    def do_parent_set(self, *args, **kwargs): ...
    def do_popup_menu(self, *args, **kwargs): ...
    def do_property_notify_event(self, *args, **kwargs): ...
    def do_proximity_in_event(self, *args, **kwargs): ...
    def do_proximity_out_event(self, *args, **kwargs): ...
    def do_query_tooltip(self, *args, **kwargs): ...
    def do_queue_draw_region(self, *args, **kwargs): ...
    def do_realize(self, *args, **kwargs): ...
    def do_screen_changed(self, *args, **kwargs): ...
    def do_scroll_event(self, *args, **kwargs): ...
    def do_selection_clear_event(self, *args, **kwargs): ...
    def do_selection_get(self, *args, **kwargs): ...
    def do_selection_notify_event(self, *args, **kwargs): ...
    def do_selection_received(self, *args, **kwargs): ...
    def do_selection_request_event(self, *args, **kwargs): ...
    def do_show(self, *args, **kwargs): ...
    def do_show_all(self, *args, **kwargs): ...
    def do_show_help(self, *args, **kwargs): ...
    def do_size_allocate(self, *args, **kwargs): ...
    def do_state_changed(self, *args, **kwargs): ...
    def do_state_flags_changed(self, *args, **kwargs): ...
    def do_style_set(self, *args, **kwargs): ...
    def do_style_updated(self, *args, **kwargs): ...
    def do_touch_event(self, *args, **kwargs): ...
    def do_unmap(self, *args, **kwargs): ...
    def do_unmap_event(self, *args, **kwargs): ...
    def do_unrealize(self, *args, **kwargs): ...
    def do_visibility_notify_event(self, *args, **kwargs): ...
    def do_window_state_event(self, *args, **kwargs): ...
    

class WidgetPath:
    def append_for_widget(*args, **kwargs): ...
    def append_type(*args, **kwargs): ...
    def append_with_siblings(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_object_type(*args, **kwargs): ...
    def has_parent(*args, **kwargs): ...
    def is_type(*args, **kwargs): ...
    def iter_add_class(*args, **kwargs): ...
    def iter_add_region(*args, **kwargs): ...
    def iter_clear_classes(*args, **kwargs): ...
    def iter_clear_regions(*args, **kwargs): ...
    def iter_get_name(*args, **kwargs): ...
    def iter_get_object_name(*args, **kwargs): ...
    def iter_get_object_type(*args, **kwargs): ...
    def iter_get_sibling_index(*args, **kwargs): ...
    def iter_get_siblings(*args, **kwargs): ...
    def iter_get_state(*args, **kwargs): ...
    def iter_has_class(*args, **kwargs): ...
    def iter_has_name(*args, **kwargs): ...
    def iter_has_qclass(*args, **kwargs): ...
    def iter_has_qname(*args, **kwargs): ...
    def iter_has_qregion(*args, **kwargs): ...
    def iter_has_region(*args, **kwargs): ...
    def iter_list_classes(*args, **kwargs): ...
    def iter_list_regions(*args, **kwargs): ...
    def iter_remove_class(*args, **kwargs): ...
    def iter_remove_region(*args, **kwargs): ...
    def iter_set_name(*args, **kwargs): ...
    def iter_set_object_name(*args, **kwargs): ...
    def iter_set_object_type(*args, **kwargs): ...
    def iter_set_state(*args, **kwargs): ...
    def length(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def prepend_type(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    def unref(*args, **kwargs): ...


class Window(Bin):
    bin = ...

    class Props:
        accept_focus: bool
        application: Application
        attached_to: Widget
        decorated: bool
        default_height: int
        default_width: int
        deletable: bool
        destroy_with_parent: bool
        focus_on_map: bool
        focus_visible: bool
        gravity: Gdk.Gravity
        has_resize_grip: bool
        has_toplevel_focus: bool
        hide_titlebar_when_maximized: bool
        icon: GdkPixbuf.Pixbuf
        icon_name: str
        is_active: bool
        is_maximized: bool
        mnemonics_visible: bool
        modal: bool
        resizeable: bool
        resize_grip_visible: bool
        role: str
        screen: Gdk.Screen
        skip_pager_hint: bool
        skip_taskbar_hint: bool
        startup_id: str
        title: str
        transient_for: Window
        type: WindowType
        type_hint: Gdk.WindowTypeHint
        urgency_hint: bool
        window_position: WindowPosition

    props: Props

    def __init__(self,
                 accept_focus: bool = ...,
                 application: Application = ...,
                 attached_to: Widget = ...,
                 decorated: bool = ...,
                 default_height: int = ...,
                 default_width: int = ...,
                 deletable: bool = ...,
                 destroy_with_parent: bool = ...,
                 focus_on_map: bool = ...,
                 focus_visible: bool = ...,
                 gravity: Gdk.Gravity = ...,
                 has_resize_grip: bool = ...,
                 hide_titlebar_when_maximized: bool = ...,
                 icon: GdkPixbuf.Pixbuf = ...,
                 icon_name: str = ...,
                 mnemonics_visible: bool = ...,
                 modal: bool = ...,
                 resizeable: bool = ...,
                 role: str = ...,
                 screen: Gdk.Screen = ...,
                 skip_pager_hint: bool = ...,
                 skip_taskbar_hint: bool = ...,
                 startup_id: str = ...,
                 title: str = ...,
                 transient_for: Window = ...,
                 type: WindowType = ...,
                 type_hint: Gdk.WindowTypeHint = ...,
                 urgency_hint: bool = ...,
                 window_position: WindowPosition = ...) -> None: ...

    def activate_default(self) -> bool: ...
    def activate_focus(self) -> bool: ...
    def activate_key(self, event: Gdk.EventKey) -> bool: ...
    def add_accel_group(self, accel_group: AccelGroup) -> None: ...
    def add_mnemonic(self, keyval: int, target: Widget) -> None: ...
    def begin_move_drag(self, button: int, root_x: int, root_y: int, timestamp: int) -> None: ...
    def begin_resize_drag(self, edge: Gdk.WindowEdge, button: int, root_x: int, root_y: int, timestamp: int) -> None: ...
    def close(self) -> None: ...
    def deiconify(self) -> None: ...
    def fullscreen(self) -> None: ...
    def fullscreen_on_monitor(self, screen: Gdk.Screen, monitor: int) -> None: ...
    def get_accept_focus(self) -> bool: ...
    def get_application(self) -> Optional[Application]: ...
    def get_attached_to(self) -> Optional[Widget]: ...
    def get_decorated(self) -> bool: ...
    def get_default_icon_list(self) -> list[GdkPixbuf.Pixbuf]: ...
    def get_default_icon_name(self) -> str: ...
    def get_default_size(self) -> tuple[int, int]: ...
    def get_default_widget(self) -> Optional[Widget]: ...
    def get_deletable(self) -> bool: ...
    def get_destroy_with_parent(self) -> bool: ...
    def get_focus(self) -> Optional[Widget]: ...
    def get_focus_on_map(self) -> bool: ...
    def get_focus_visible(self) -> bool: ...
    def get_gravity(self) -> Gdk.Gravity: ...
    def get_group(self) -> WindowGroup: ...
    def get_has_resize_grip(self) -> bool: ...
    def get_hide_titlebar_when_maximized(self) -> bool: ...
    def get_icon(self) -> Optional[GdkPixbuf.Pixbuf]: ...
    def get_icon_list(self) -> list[GdkPixbuf.Pixbuf]: ...
    def get_icon_name(self) -> Optional[str]: ...
    def get_mnemonic_modifier(self) -> Gdk.ModifierType: ...
    def get_mnemonics_visible(self) -> bool: ...
    def get_modal(self) -> bool: ...
    def get_position(self) -> tuple[int, int]: ...
    def get_resizable(self) -> bool: ...
    def get_resize_grip_area(self) -> tuple[bool, Gdk.Rectangle]: ...
    def get_role(self) -> Optional[str]: ...
    def get_screen(self) -> Gdk.Screen: ...
    def get_size(self) -> tuple[int, int]: ...
    def get_skip_pager_hint(self) -> bool: ...
    def get_skip_taskbar_hint(self) -> bool: ...
    def get_title(self) -> Optional[str]: ...
    def get_titlebar(self) -> Optional[Widget]: ...
    def get_transient_for(self) -> Optional[Window]: ...
    def get_type_hint(self) -> Gdk.WindowTypeHint: ...
    def get_urgency_hint(self) -> bool: ...
    def get_window_type(self) -> WindowType: ...
    def has_group(self) -> bool: ...
    def has_toplevel_focus(self) -> bool: ...
    def iconify(self) -> None: ...
    def is_active(self) -> bool: ...
    def is_maximized(self) -> bool: ...
    def list_toplevels(self) -> list[Widget]: ...
    def maximize(self) -> None: ...
    def move(self, x: int, y: int) -> None: ...
    @classmethod
    def new(cls, type: WindowType) -> Window: ...
    def parse_geometry(self, geometry: str) -> bool: ...
    def present(self) -> None: ...
    def present_with_time(self, timestamp: int) -> None: ...
    def propagate_key_event(self, event: Gdk.EventKey) -> bool: ...
    def remove_accel_group(self, accel_group: AccelGroup) -> None: ...
    def remove_mnemonic(self, keyval: int, target: Widget) -> None: ...
    def reshow_with_initial_size(self) -> None: ...
    def resize(self, width: int, height: int) -> None: ...
    def resize_grip_is_visible(self) -> bool: ...
    def resize_to_geometry(self, width: int, height: int) -> None: ...
    def set_accept_focus(self, setting: bool) -> None: ...
    def set_application(self, application: Optional[Application]) -> None: ...
    def set_attached_to(self, attach_widget: Optional[Widget]) -> None: ...
    def set_auto_startup_notification(self, setting: bool) -> None: ...
    def set_cursor(self, cursor: Optional[Gdk.Cursor]) -> None: ...
    def set_decorated(self, setting: bool) -> None: ...
    def set_default(self, default_widget: Optional[Widget]) -> None: ...
    def set_default_geometry(self, width: int, height: int) -> None: ...
    def set_default_icon(self, icon: GdkPixbuf.Pixbuf) -> None: ...
    def set_default_icon_from_file(self, filename: str) -> bool: ...
    def set_default_icon_list(self, list: list[GdkPixbuf.Pixbuf]) -> None: ...
    def set_default_icon_name(self, name: str) -> None: ...
    def set_default_size(self, width: int, height: int) -> None: ...
    def set_deletable(self, setting: bool) -> None: ...
    def set_destroy_with_parent(self, setting: bool) -> None: ...
    def set_focus(self, focus: Optional[Widget]) -> None: ...
    def set_focus_on_map(self, setting: bool) -> None: ...
    def set_focus_visible(self, setting: bool) -> None: ...
    def set_geometry_hints(self, geometry_widget: Optional[Widget], geometry: Optional[Gdk.Geometry], geom_mask: Gdk.WindowHints) -> None: ...
    def set_gravity(self, gravity: Gdk.Gravity) -> None: ...
    def set_has_resize_grip(self, value: bool) -> None: ...
    def set_has_user_ref_count(self, setting: bool) -> None: ...
    def set_hide_titlebar_when_maximized(self, setting: bool) -> None: ...
    def set_icon(self, icon: Optional[GdkPixbuf.Pixbuf]) -> None: ...
    def set_icon_from_file(self, filename: str) -> bool: ...
    def set_icon_list(self, list: list[GdkPixbuf.Pixbuf]) -> None: ...
    def set_icon_name(self, name: str) -> None: ...
    def set_interactive_debugging(self, enable: bool) -> None: ...
    def set_keep_above(self, setting: bool) -> None: ...
    def set_keep_below(self, setting: bool) -> None: ...
    def set_mnemonic_modifier(self, modifier: Gdk.ModifierType) -> None: ...
    def set_mnemonics_visible(self, setting: bool) -> None: ...
    def set_modal(self, modal: bool) -> None: ...
    def set_position(self, position: WindowPosition) -> None: ...
    def set_resizable(self, resizable: bool) -> None: ...
    def set_role(self, role: str) -> None: ...
    def set_screen(self, screen: Gdk.Screen) -> None: ...
    def set_skip_pager_hint(self, setting: bool) -> None: ...
    def set_skip_taskbar_hint(self, setting: bool) -> None: ...
    def set_startup_id(self, startup_id: str) -> None: ...
    def set_title(self, title: str) -> None: ...
    def set_titlebar(self, titlebar: Optional[Widget]) -> None: ...
    def set_transient_for(self, parent: Optional[Window]) -> None: ...
    def set_type_hint(self, hint: Gdk.WindowTypeHint) -> None: ...
    def set_urgency_hint(self, setting: bool) -> None: ...
    def set_wmclass(self, wmclass_name: str, wmclass_class: str) -> None: ...
    def stick(self) -> None: ...
    def unfullscreen(self) -> None: ...
    def unmaximize(self) -> None: ...
    def unstick(self) -> None: ...
    
    def do_activate_default(self, *args, **kwargs): ...
    def do_activate_focus(self, *args, **kwargs): ...
    def do_enable_debugging(self, *args, **kwargs): ...
    def do_keys_changed(self, *args, **kwargs): ...
    def do_set_focus(self, *args, **kwargs): ...
    

class WindowGeometryInfo: ...

class WindowGroup:
    parent_instance = ...
    priv = ...
    
    def add_window(*args, **kwargs): ...
    def get_current_device_grab(*args, **kwargs): ...
    def get_current_grab(*args, **kwargs): ...
    def list_windows(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def remove_window(*args, **kwargs): ...
    

class AccelFlags(GObject.GFlags):
    VISIBLE = ...
    LOCKED = ...
    MASK = ...

class ApplicationInhibitFlags(GObject.GFlags):
    LOGOUT = ...
    SWITCH = ...
    SUSPEND = ...
    IDLE = ...

class AttachOptions(GObject.GFlags):
    EXPAND = ...
    SHRINK = ...
    FILL = ...

class CalendarDisplayOptions(GObject.GFlags):
    SHOW_HEADING = ...
    SHOW_DAY_NAMES = ...
    NO_MONTH_CHANGE = ...
    SHOW_WEEK_NUMBERS = ...
    SHOW_DETAILS = ...

class CellRendererState(GObject.GFlags):
    SELECTED = ...
    PRELIT = ...
    INSENSITIVE = ...
    SORTED = ...
    FOCUSED = ...
    EXPANDABLE = ...
    EXPANDED = ...

class DebugFlag(GObject.GFlags):
    MISC = ...
    PLUGSOCKET = ...
    TEXT = ...
    TREE = ...
    UPDATES = ...
    KEYBINDINGS = ...
    MULTIHEAD = ...
    MODULES = ...
    GEOMETRY = ...
    ICONTHEME = ...
    PRINTING = ...
    BUILDER = ...
    SIZE_REQUEST = ...
    NO_CSS_CACHE = ...
    BASELINES = ...
    PIXEL_CACHE = ...
    NO_PIXEL_CACHE = ...
    INTERACTIVE = ...
    TOUCHSCREEN = ...
    ACTIONS = ...
    RESIZE = ...
    LAYOUT = ...

class DestDefaults(GObject.GFlags):
    MOTION = ...
    HIGHLIGHT = ...
    DROP = ...
    ALL = ...

class DialogFlags(GObject.GFlags):
    MODAL = ...
    DESTROY_WITH_PARENT = ...
    USE_HEADER_BAR = ...

class EventControllerScrollFlags(GObject.GFlags):
    NONE = ...
    VERTICAL = ...
    HORIZONTAL = ...
    DISCRETE = ...
    KINETIC = ...
    BOTH_AXES = ...

class FileFilterFlags(GObject.GFlags):
    FILENAME = ...
    URI = ...
    DISPLAY_NAME = ...
    MIME_TYPE = ...

class FontChooserLevel(GObject.GFlags):
    FAMILY = ...
    STYLE = ...
    SIZE = ...
    VARIATIONS = ...
    FEATURES = ...

class IconLookupFlags(GObject.GFlags):
    NO_SVG = ...
    FORCE_SVG = ...
    USE_BUILTIN = ...
    GENERIC_FALLBACK = ...
    FORCE_SIZE = ...
    FORCE_REGULAR = ...
    FORCE_SYMBOLIC = ...
    DIR_LTR = ...
    DIR_RTL = ...

class InputHints(GObject.GFlags):
    NONE = ...
    SPELLCHECK = ...
    NO_SPELLCHECK = ...
    WORD_COMPLETION = ...
    LOWERCASE = ...
    UPPERCASE_CHARS = ...
    UPPERCASE_WORDS = ...
    UPPERCASE_SENTENCES = ...
    INHIBIT_OSK = ...
    VERTICAL_WRITING = ...
    EMOJI = ...
    NO_EMOJI = ...

class JunctionSides(GObject.GFlags):
    NONE = ...
    CORNER_TOPLEFT = ...
    CORNER_TOPRIGHT = ...
    CORNER_BOTTOMLEFT = ...
    CORNER_BOTTOMRIGHT = ...
    TOP = ...
    BOTTOM = ...
    LEFT = ...
    RIGHT = ...

class PlacesOpenFlags(GObject.GFlags):
    NORMAL = ...
    NEW_TAB = ...
    NEW_WINDOW = ...

class RcFlags(GObject.GFlags):
    FG = ...
    BG = ...
    TEXT = ...
    BASE = ...

class RecentFilterFlags(GObject.GFlags):
    URI = ...
    DISPLAY_NAME = ...
    MIME_TYPE = ...
    APPLICATION = ...
    GROUP = ...
    AGE = ...

class RegionFlags(GObject.GFlags):
    EVEN = ...
    ODD = ...
    FIRST = ...
    LAST = ...
    ONLY = ...
    SORTED = ...

class StateFlags(GObject.GFlags):
    NORMAL = ...
    ACTIVE = ...
    PRELIGHT = ...
    SELECTED = ...
    INSENSITIVE = ...
    INCONSISTENT = ...
    FOCUSED = ...
    BACKDROP = ...
    DIR_LTR = ...
    DIR_RTL = ...
    LINK = ...
    VISITED = ...
    CHECKED = ...
    DROP_ACTIVE = ...

class StyleContextPrintFlags(GObject.GFlags):
    NONE = ...
    RECURSE = ...
    SHOW_STYLE = ...

class TargetFlags(GObject.GFlags):
    SAME_APP = ...
    SAME_WIDGET = ...
    OTHER_APP = ...
    OTHER_WIDGET = ...

class TextSearchFlags(GObject.GFlags):
    VISIBLE_ONLY = ...
    TEXT_ONLY = ...
    CASE_INSENSITIVE = ...

class ToolPaletteDragTargets(GObject.GFlags):
    ITEMS = ...
    GROUPS = ...

class TreeModelFlags(GObject.GFlags):
    ITERS_PERSIST = ...
    LIST_ONLY = ...

class UIManagerItemType(GObject.GFlags):
    AUTO = ...
    MENUBAR = ...
    MENU = ...
    TOOLBAR = ...
    PLACEHOLDER = ...
    POPUP = ...
    MENUITEM = ...
    TOOLITEM = ...
    SEPARATOR = ...
    ACCELERATOR = ...
    POPUP_WITH_ACCELS = ...

class Align(GObject.GEnum):
    FILL = ...
    START = ...
    END = ...
    CENTER = ...
    BASELINE = ...

class ArrowPlacement(GObject.GEnum):
    BOTH = ...
    START = ...
    END = ...

class ArrowType(GObject.GEnum):
    UP = ...
    DOWN = ...
    LEFT = ...
    RIGHT = ...
    NONE = ...

class AssistantPageType(GObject.GEnum):
    CONTENT = ...
    INTRO = ...
    CONFIRM = ...
    SUMMARY = ...
    PROGRESS = ...
    CUSTOM = ...

class BaselinePosition(GObject.GEnum):
    TOP = ...
    CENTER = ...
    BOTTOM = ...

class BorderStyle(GObject.GEnum):
    NONE = ...
    SOLID = ...
    INSET = ...
    OUTSET = ...
    HIDDEN = ...
    DOTTED = ...
    DASHED = ...
    DOUBLE = ...
    GROOVE = ...
    RIDGE = ...

class BuilderError(GObject.GEnum):
    INVALID_TYPE_FUNCTION = ...
    UNHANDLED_TAG = ...
    MISSING_ATTRIBUTE = ...
    INVALID_ATTRIBUTE = ...
    INVALID_TAG = ...
    MISSING_PROPERTY_VALUE = ...
    INVALID_VALUE = ...
    VERSION_MISMATCH = ...
    DUPLICATE_ID = ...
    OBJECT_TYPE_REFUSED = ...
    TEMPLATE_MISMATCH = ...
    INVALID_PROPERTY = ...
    INVALID_SIGNAL = ...
    INVALID_ID = ...
    quark = ...

class ButtonBoxStyle(GObject.GEnum):
    SPREAD = ...
    EDGE = ...
    START = ...
    END = ...
    CENTER = ...
    EXPAND = ...

class ButtonRole(GObject.GEnum):
    NORMAL = ...
    CHECK = ...
    RADIO = ...

class ButtonsType(GObject.GEnum):
    NONE = ...
    OK = ...
    CLOSE = ...
    CANCEL = ...
    YES_NO = ...
    OK_CANCEL = ...

class CellRendererAccelMode(GObject.GEnum):
    GTK = ...
    OTHER = ...
    MODIFIER_TAP = ...

class CellRendererMode(GObject.GEnum):
    INERT = ...
    ACTIVATABLE = ...
    EDITABLE = ...

class CornerType(GObject.GEnum):
    TOP_LEFT = ...
    BOTTOM_LEFT = ...
    TOP_RIGHT = ...
    BOTTOM_RIGHT = ...

class CssProviderError(GObject.GEnum):
    FAILED = ...
    SYNTAX = ...
    IMPORT = ...
    NAME = ...
    DEPRECATED = ...
    UNKNOWN_VALUE = ...
    quark = ...

class CssSectionType(GObject.GEnum):
    DOCUMENT = ...
    IMPORT = ...
    COLOR_DEFINITION = ...
    BINDING_SET = ...
    RULESET = ...
    SELECTOR = ...
    DECLARATION = ...
    VALUE = ...
    KEYFRAMES = ...

class DeleteType(GObject.GEnum):
    CHARS = ...
    WORD_ENDS = ...
    WORDS = ...
    DISPLAY_LINES = ...
    DISPLAY_LINE_ENDS = ...
    PARAGRAPH_ENDS = ...
    PARAGRAPHS = ...
    WHITESPACE = ...

class DirectionType(GObject.GEnum):
    TAB_FORWARD = ...
    TAB_BACKWARD = ...
    UP = ...
    DOWN = ...
    LEFT = ...
    RIGHT = ...

class DragResult(GObject.GEnum):
    SUCCESS = ...
    NO_TARGET = ...
    USER_CANCELLED = ...
    TIMEOUT_EXPIRED = ...
    GRAB_BROKEN = ...
    ERROR = ...

class EntryIconPosition(GObject.GEnum):
    PRIMARY = ...
    SECONDARY = ...

class EventSequenceState(GObject.GEnum):
    NONE = ...
    CLAIMED = ...
    DENIED = ...

class ExpanderStyle(GObject.GEnum):
    COLLAPSED = ...
    SEMI_COLLAPSED = ...
    SEMI_EXPANDED = ...
    EXPANDED = ...

class FileChooserAction(GObject.GEnum):
    OPEN = ...
    SAVE = ...
    SELECT_FOLDER = ...
    CREATE_FOLDER = ...

class FileChooserConfirmation(GObject.GEnum):
    CONFIRM = ...
    ACCEPT_FILENAME = ...
    SELECT_AGAIN = ...

class FileChooserError(GObject.GEnum):
    NONEXISTENT = ...
    BAD_FILENAME = ...
    ALREADY_EXISTS = ...
    INCOMPLETE_HOSTNAME = ...
    quark = ...

class IMPreeditStyle(GObject.GEnum):
    NOTHING = ...
    CALLBACK = ...
    NONE = ...

class IMStatusStyle(GObject.GEnum):
    NOTHING = ...
    CALLBACK = ...
    NONE = ...

class IconSize(GObject.GEnum):
    INVALID = ...
    MENU = ...
    SMALL_TOOLBAR = ...
    LARGE_TOOLBAR = ...
    BUTTON = ...
    DND = ...
    DIALOG = ...
    from_name = ...
    get_name = ...
    lookup = ...
    lookup_for_settings = ...
    register = ...
    register_alias = ...

class IconThemeError(GObject.GEnum):
    NOT_FOUND = ...
    FAILED = ...
    quark = ...

class IconViewDropPosition(GObject.GEnum):
    NO_DROP = ...
    DROP_INTO = ...
    DROP_LEFT = ...
    DROP_RIGHT = ...
    DROP_ABOVE = ...
    DROP_BELOW = ...

class ImageType(GObject.GEnum):
    EMPTY = ...
    PIXBUF = ...
    STOCK = ...
    ICON_SET = ...
    ANIMATION = ...
    ICON_NAME = ...
    GICON = ...
    SURFACE = ...

class InputPurpose(GObject.GEnum):
    FREE_FORM = ...
    ALPHA = ...
    DIGITS = ...
    NUMBER = ...
    PHONE = ...
    URL = ...
    EMAIL = ...
    NAME = ...
    PASSWORD = ...
    PIN = ...
    TERMINAL = ...

class Justification(GObject.GEnum):
    LEFT = ...
    RIGHT = ...
    CENTER = ...
    FILL = ...

class LevelBarMode(GObject.GEnum):
    CONTINUOUS = ...
    DISCRETE = ...

class License(GObject.GEnum):
    UNKNOWN = ...
    CUSTOM = ...
    GPL_2_0 = ...
    GPL_3_0 = ...
    LGPL_2_1 = ...
    LGPL_3_0 = ...
    BSD = ...
    MIT_X11 = ...
    ARTISTIC = ...
    GPL_2_0_ONLY = ...
    GPL_3_0_ONLY = ...
    LGPL_2_1_ONLY = ...
    LGPL_3_0_ONLY = ...
    AGPL_3_0 = ...
    AGPL_3_0_ONLY = ...
    BSD_3 = ...
    APACHE_2_0 = ...
    MPL_2_0 = ...

class MenuDirectionType(GObject.GEnum):
    PARENT = ...
    CHILD = ...
    NEXT = ...
    PREV = ...

class MessageType(GObject.GEnum):
    INFO = ...
    WARNING = ...
    QUESTION = ...
    ERROR = ...
    OTHER = ...

class MovementStep(GObject.GEnum):
    LOGICAL_POSITIONS = ...
    VISUAL_POSITIONS = ...
    WORDS = ...
    DISPLAY_LINES = ...
    DISPLAY_LINE_ENDS = ...
    PARAGRAPHS = ...
    PARAGRAPH_ENDS = ...
    PAGES = ...
    BUFFER_ENDS = ...
    HORIZONTAL_PAGES = ...

class NotebookTab(GObject.GEnum):
    FIRST = ...
    LAST = ...

class NumberUpLayout(GObject.GEnum):
    LRTB = ...
    LRBT = ...
    RLTB = ...
    RLBT = ...
    TBLR = ...
    TBRL = ...
    BTLR = ...
    BTRL = ...

class Orientation(GObject.GEnum):
    HORIZONTAL = ...
    VERTICAL = ...

class PackDirection(GObject.GEnum):
    LTR = ...
    RTL = ...
    TTB = ...
    BTT = ...

class PackType(GObject.GEnum):
    START = ...
    END = ...

class PadActionType(GObject.GEnum):
    BUTTON = ...
    RING = ...
    STRIP = ...

class PageOrientation(GObject.GEnum):
    PORTRAIT = ...
    LANDSCAPE = ...
    REVERSE_PORTRAIT = ...
    REVERSE_LANDSCAPE = ...

class PageSet(GObject.GEnum):
    ALL = ...
    EVEN = ...
    ODD = ...

class PanDirection(GObject.GEnum):
    LEFT = ...
    RIGHT = ...
    UP = ...
    DOWN = ...

class PathPriorityType(GObject.GEnum):
    LOWEST = ...
    GTK = ...
    APPLICATION = ...
    THEME = ...
    RC = ...
    HIGHEST = ...

class PathType(GObject.GEnum):
    WIDGET = ...
    WIDGET_CLASS = ...
    CLASS = ...

class PolicyType(GObject.GEnum):
    ALWAYS = ...
    AUTOMATIC = ...
    NEVER = ...
    EXTERNAL = ...

class PopoverConstraint(GObject.GEnum):
    NONE = ...
    WINDOW = ...

class PositionType(GObject.GEnum):
    LEFT = ...
    RIGHT = ...
    TOP = ...
    BOTTOM = ...

class PrintDuplex(GObject.GEnum):
    SIMPLEX = ...
    HORIZONTAL = ...
    VERTICAL = ...

class PrintError(GObject.GEnum):
    GENERAL = ...
    INTERNAL_ERROR = ...
    NOMEM = ...
    INVALID_FILE = ...
    quark = ...

class PrintOperationAction(GObject.GEnum):
    PRINT_DIALOG = ...
    PRINT = ...
    PREVIEW = ...
    EXPORT = ...

class PrintOperationResult(GObject.GEnum):
    ERROR = ...
    APPLY = ...
    CANCEL = ...
    IN_PROGRESS = ...

class PrintPages(GObject.GEnum):
    ALL = ...
    CURRENT = ...
    RANGES = ...
    SELECTION = ...

class PrintQuality(GObject.GEnum):
    LOW = ...
    NORMAL = ...
    HIGH = ...
    DRAFT = ...

class PrintStatus(GObject.GEnum):
    INITIAL = ...
    PREPARING = ...
    GENERATING_DATA = ...
    SENDING_DATA = ...
    PENDING = ...
    PENDING_ISSUE = ...
    PRINTING = ...
    FINISHED = ...
    FINISHED_ABORTED = ...

class PropagationPhase(GObject.GEnum):
    NONE = ...
    CAPTURE = ...
    BUBBLE = ...
    TARGET = ...

class RcTokenType(GObject.GEnum):
    INVALID = ...
    INCLUDE = ...
    NORMAL = ...
    ACTIVE = ...
    PRELIGHT = ...
    SELECTED = ...
    INSENSITIVE = ...
    FG = ...
    BG = ...
    TEXT = ...
    BASE = ...
    XTHICKNESS = ...
    YTHICKNESS = ...
    FONT = ...
    FONTSET = ...
    FONT_NAME = ...
    BG_PIXMAP = ...
    PIXMAP_PATH = ...
    STYLE = ...
    BINDING = ...
    BIND = ...
    WIDGET = ...
    WIDGET_CLASS = ...
    CLASS = ...
    LOWEST = ...
    GTK = ...
    APPLICATION = ...
    THEME = ...
    RC = ...
    HIGHEST = ...
    ENGINE = ...
    MODULE_PATH = ...
    IM_MODULE_PATH = ...
    IM_MODULE_FILE = ...
    STOCK = ...
    LTR = ...
    RTL = ...
    COLOR = ...
    UNBIND = ...
    LAST = ...

class RecentChooserError(GObject.GEnum):
    NOT_FOUND = ...
    INVALID_URI = ...
    quark = ...

class RecentManagerError(GObject.GEnum):
    NOT_FOUND = ...
    INVALID_URI = ...
    INVALID_ENCODING = ...
    NOT_REGISTERED = ...
    READ = ...
    WRITE = ...
    UNKNOWN = ...
    quark = ...

class RecentSortType(GObject.GEnum):
    NONE = ...
    MRU = ...
    LRU = ...
    CUSTOM = ...

class ReliefStyle(GObject.GEnum):
    NORMAL = ...
    HALF = ...
    NONE = ...

class ResizeMode(GObject.GEnum):
    PARENT = ...
    QUEUE = ...
    IMMEDIATE = ...

class ResponseType(GObject.GEnum):
    NONE = ...
    REJECT = ...
    ACCEPT = ...
    DELETE_EVENT = ...
    OK = ...
    CANCEL = ...
    CLOSE = ...
    YES = ...
    NO = ...
    APPLY = ...
    HELP = ...

class RevealerTransitionType(GObject.GEnum):
    NONE = ...
    CROSSFADE = ...
    SLIDE_RIGHT = ...
    SLIDE_LEFT = ...
    SLIDE_UP = ...
    SLIDE_DOWN = ...

class ScrollStep(GObject.GEnum):
    STEPS = ...
    PAGES = ...
    ENDS = ...
    HORIZONTAL_STEPS = ...
    HORIZONTAL_PAGES = ...
    HORIZONTAL_ENDS = ...

class ScrollType(GObject.GEnum):
    NONE = ...
    JUMP = ...
    STEP_BACKWARD = ...
    STEP_FORWARD = ...
    PAGE_BACKWARD = ...
    PAGE_FORWARD = ...
    STEP_UP = ...
    STEP_DOWN = ...
    PAGE_UP = ...
    PAGE_DOWN = ...
    STEP_LEFT = ...
    STEP_RIGHT = ...
    PAGE_LEFT = ...
    PAGE_RIGHT = ...
    START = ...
    END = ...

class ScrollablePolicy(GObject.GEnum):
    MINIMUM = ...
    NATURAL = ...

class SelectionMode(GObject.GEnum):
    NONE = ...
    SINGLE = ...
    BROWSE = ...
    MULTIPLE = ...

class SensitivityType(GObject.GEnum):
    AUTO = ...
    ON = ...
    OFF = ...

class ShadowType(GObject.GEnum):
    NONE = ...
    IN = ...
    OUT = ...
    ETCHED_IN = ...
    ETCHED_OUT = ...

class ShortcutType(GObject.GEnum):
    ACCELERATOR = ...
    GESTURE_PINCH = ...
    GESTURE_STRETCH = ...
    GESTURE_ROTATE_CLOCKWISE = ...
    GESTURE_ROTATE_COUNTERCLOCKWISE = ...
    GESTURE_TWO_FINGER_SWIPE_LEFT = ...
    GESTURE_TWO_FINGER_SWIPE_RIGHT = ...
    GESTURE = ...

class SizeGroupMode(GObject.GEnum):
    NONE = ...
    HORIZONTAL = ...
    VERTICAL = ...
    BOTH = ...

class SizeRequestMode(GObject.GEnum):
    HEIGHT_FOR_WIDTH = ...
    WIDTH_FOR_HEIGHT = ...
    CONSTANT_SIZE = ...

class SortType(GObject.GEnum):
    ASCENDING = ...
    DESCENDING = ...

class SpinButtonUpdatePolicy(GObject.GEnum):
    ALWAYS = ...
    IF_VALID = ...

class SpinType(GObject.GEnum):
    STEP_FORWARD = ...
    STEP_BACKWARD = ...
    PAGE_FORWARD = ...
    PAGE_BACKWARD = ...
    HOME = ...
    END = ...
    USER_DEFINED = ...

class StackTransitionType(GObject.GEnum):
    NONE = ...
    CROSSFADE = ...
    SLIDE_RIGHT = ...
    SLIDE_LEFT = ...
    SLIDE_UP = ...
    SLIDE_DOWN = ...
    SLIDE_LEFT_RIGHT = ...
    SLIDE_UP_DOWN = ...
    OVER_UP = ...
    OVER_DOWN = ...
    OVER_LEFT = ...
    OVER_RIGHT = ...
    UNDER_UP = ...
    UNDER_DOWN = ...
    UNDER_LEFT = ...
    UNDER_RIGHT = ...
    OVER_UP_DOWN = ...
    OVER_DOWN_UP = ...
    OVER_LEFT_RIGHT = ...
    OVER_RIGHT_LEFT = ...

class StateType(GObject.GEnum):
    NORMAL = ...
    ACTIVE = ...
    PRELIGHT = ...
    SELECTED = ...
    INSENSITIVE = ...
    INCONSISTENT = ...
    FOCUSED = ...

class TextBufferTargetInfo(GObject.GEnum):
    BUFFER_CONTENTS = ...
    RICH_TEXT = ...
    TEXT = ...

class TextDirection(GObject.GEnum):
    NONE = ...
    LTR = ...
    RTL = ...

class TextExtendSelection(GObject.GEnum):
    WORD = ...
    LINE = ...

class TextViewLayer(GObject.GEnum):
    BELOW = ...
    ABOVE = ...
    BELOW_TEXT = ...
    ABOVE_TEXT = ...

class TextWindowType(GObject.GEnum):
    PRIVATE = ...
    WIDGET = ...
    TEXT = ...
    LEFT = ...
    RIGHT = ...
    TOP = ...
    BOTTOM = ...

class ToolbarSpaceStyle(GObject.GEnum):
    EMPTY = ...
    LINE = ...

class ToolbarStyle(GObject.GEnum):
    ICONS = ...
    TEXT = ...
    BOTH = ...
    BOTH_HORIZ = ...

class TreeViewColumnSizing(GObject.GEnum):
    GROW_ONLY = ...
    AUTOSIZE = ...
    FIXED = ...

class TreeViewDropPosition(GObject.GEnum):
    BEFORE = ...
    AFTER = ...
    INTO_OR_BEFORE = ...
    INTO_OR_AFTER = ...

class TreeViewGridLines(GObject.GEnum):
    NONE = ...
    HORIZONTAL = ...
    VERTICAL = ...
    BOTH = ...

class Unit(GObject.GEnum):
    NONE = ...
    POINTS = ...
    INCH = ...
    MM = ...

class WidgetHelpType(GObject.GEnum):
    TOOLTIP = ...
    WHATS_THIS = ...

class WindowPosition(GObject.GEnum):
    NONE = ...
    CENTER = ...
    MOUSE = ...
    CENTER_ALWAYS = ...
    CENTER_ON_PARENT = ...

class WindowType(GObject.GEnum):
    TOPLEVEL = ...
    POPUP = ...

class WrapMode(GObject.GEnum):
    NONE = ...
    CHAR = ...
    WORD = ...
    WORD_CHAR = ...


CellRendererT = TypeVar('CellRendererT',
                        CellRendererCombo,
                        CellRendererPixbuf,
                        CellRendererProgress,
                        CellRendererSpin,
                        CellRendererSpinner,
                        CellRendererText,
                        CellRendererToggle)
