
from typing import Optional

from gi.repository import GObject

ANALYSIS_FLAG_CENTERED_BASELINE: int = ...
ANALYSIS_FLAG_IS_ELLIPSIS: int = ...
ANALYSIS_FLAG_NEED_HYPHEN: int = ...
ATTR_INDEX_FROM_TEXT_BEGINNING = ...
ATTR_INDEX_TO_TEXT_END: int = ...
GLYPH_EMPTY: int = ...
GLYPH_INVALID_INPUT: int = ...
GLYPH_UNKNOWN_FLAG: int = ...
SCALE: int = ...
VERSION_MAJOR: int = ...
VERSION_MICRO: int = ...
VERSION_MINOR: int = ...
VERSION_STRING: str = ...
_introspection_module = ...
_namespace: str = ...
_overrides_module = ...
_version: str = ...


def attr_allow_breaks_new(*args, **kwargs): ...
def attr_background_alpha_new(*args, **kwargs): ...
def attr_background_new(*args, **kwargs): ...
def attr_fallback_new(*args, **kwargs): ...
def attr_family_new(family: str) -> Attribute: ...
def attr_font_desc_new(*args, **kwargs): ...
def attr_font_features_new(*args, **kwargs): ...
def attr_foreground_alpha_new(*args, **kwargs): ...
def attr_foreground_new(*args, **kwargs): ...
def attr_gravity_hint_new(*args, **kwargs): ...
def attr_gravity_new(*args, **kwargs): ...
def attr_insert_hyphens_new(*args, **kwargs): ...
def attr_language_new(*args, **kwargs): ...
def attr_letter_spacing_new(*args, **kwargs): ...
def attr_overline_color_new(*args, **kwargs): ...
def attr_overline_new(*args, **kwargs): ...
def attr_rise_new(*args, **kwargs): ...
def attr_scale_new(*args, **kwargs): ...
def attr_shape_new(*args, **kwargs): ...
def attr_shape_new_with_data(*args, **kwargs): ...
def attr_show_new(*args, **kwargs): ...
def attr_size_new(*args, **kwargs): ...
def attr_size_new_absolute(*args, **kwargs): ...
def attr_stretch_new(*args, **kwargs): ...
def attr_strikethrough_color_new(*args, **kwargs): ...
def attr_strikethrough_new(strikethrough: bool) -> Attribute: ...
def attr_style_new(style: Style) -> Attribute: ...
def attr_type_get_name(*args, **kwargs): ...
def attr_type_register(*args, **kwargs): ...
def attr_underline_color_new(*args, **kwargs): ...
def attr_underline_new(*args, **kwargs): ...
def attr_variant_new(*args, **kwargs): ...
def attr_weight_new(weight: Weight) -> Attribute: ...
def bidi_type_for_unichar(*args, **kwargs): ...
def break_(*args, **kwargs): ...
def default_break(*args, **kwargs): ...
def extents_to_pixels(*args, **kwargs): ...
def find_base_dir(*args, **kwargs): ...
def find_paragraph_boundary(*args, **kwargs): ...
def font_description_from_string(*args, **kwargs): ...
def get_log_attrs(*args, **kwargs): ...
def get_mirror_char(*args, **kwargs): ...
def gravity_get_for_matrix(*args, **kwargs): ...
def gravity_get_for_script(*args, **kwargs): ...
def gravity_get_for_script_and_width(*args, **kwargs): ...
def gravity_to_rotation(*args, **kwargs): ...
def is_zero_width(*args, **kwargs): ...
def itemize(*args, **kwargs): ...
def itemize_with_base_dir(*args, **kwargs): ...
def language_from_string(*args, **kwargs): ...
def language_get_default(*args, **kwargs): ...
def language_get_preferred(*args, **kwargs): ...
def log2vis_get_embedding_levels(*args, **kwargs): ...
def markup_parser_finish(*args, **kwargs): ...
def markup_parser_new(*args, **kwargs): ...
def parse_enum(*args, **kwargs): ...
def parse_markup(*args, **kwargs): ...
def parse_stretch(*args, **kwargs): ...
def parse_style(*args, **kwargs): ...
def parse_variant(*args, **kwargs): ...
def parse_weight(*args, **kwargs): ...
def quantize_line_geometry(*args, **kwargs): ...
def read_line(*args, **kwargs): ...
def reorder_items(*args, **kwargs): ...
def scan_int(*args, **kwargs): ...
def scan_string(*args, **kwargs): ...
def scan_word(*args, **kwargs): ...
def script_for_unichar(*args, **kwargs): ...
def script_get_sample_language(*args, **kwargs): ...
def shape(*args, **kwargs): ...
def shape_full(*args, **kwargs): ...
def shape_with_flags(*args, **kwargs): ...
def skip_space(*args, **kwargs): ...
def split_file_list(*args, **kwargs): ...
def tailor_break(*args, **kwargs): ...
def trim_string(*args, **kwargs): ...
def unichar_direction(*args, **kwargs): ...
def units_from_double(*args, **kwargs): ...
def units_to_double(*args, **kwargs): ...
def version(*args, **kwargs): ...
def version_check(*args, **kwargs): ...
def version_string(*args, **kwargs): ...

class Analysis:
    extra_attrs = ...
    flags = ...
    font = ...
    gravity = ...
    lang_engine = ...
    language = ...
    level = ...
    script = ...
    shape_engine = ...
    

class AttrColor:
    attr = ...
    color = ...
    

class AttrFloat:
    attr = ...
    value = ...
    

class AttrFontDesc:
    attr = ...
    desc = ...
    
    def new(*args, **kwargs): ...
    

class AttrFontFeatures:
    attr = ...
    features = ...
    
    def new(*args, **kwargs): ...
    

class AttrInt:
    attr = ...
    value = ...
    

class AttrIterator:
    def destroy(*args, **kwargs): ...
    def get(*args, **kwargs): ...
    def get_attrs(*args, **kwargs): ...
    def get_font(*args, **kwargs): ...
    def next(*args, **kwargs): ...
    def range(*args, **kwargs): ...
    

class AttrLanguage:
    attr = ...
    value = ...
    
    def new(*args, **kwargs): ...


class AttrList:
    def change(*args, **kwargs): ...
    def equal(*args, **kwargs): ...
    def filter(*args, **kwargs): ...
    def get_attributes(*args, **kwargs): ...
    def get_iterator(*args, **kwargs): ...
    def insert(self, attr: Attribute) -> None: ...
    def insert_before(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def splice(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    def update(*args, **kwargs): ...
    

class AttrShape:
    attr = ...
    copy_func = ...
    data = ...
    destroy_func = ...
    ink_rect = ...
    logical_rect = ...
    
    def new(*args, **kwargs): ...
    def new_with_data(*args, **kwargs): ...
    

class AttrSize:
    absolute = ...
    attr = ...
    size = ...
    
    def new(*args, **kwargs): ...
    def new_absolute(*args, **kwargs): ...
    

class AttrString:
    attr = ...
    value = ...
    

class Attribute:
    end_index = ...
    klass = ...
    start_index = ...
    
    def destroy(*args, **kwargs): ...
    def equal(*args, **kwargs): ...
    def init(*args, **kwargs): ...
    

class Color:
    blue = ...
    green = ...
    red = ...
    
    def free(*args, **kwargs): ...
    def parse(*args, **kwargs): ...
    def parse_with_alpha(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    

class Context:
    def changed(*args, **kwargs): ...
    def get_base_dir(*args, **kwargs): ...
    def get_base_gravity(*args, **kwargs): ...
    def get_font_description(*args, **kwargs): ...
    def get_font_map(*args, **kwargs): ...
    def get_gravity(*args, **kwargs): ...
    def get_gravity_hint(*args, **kwargs): ...
    def get_language(*args, **kwargs): ...
    def get_matrix(*args, **kwargs): ...
    def get_metrics(*args, **kwargs): ...
    def get_round_glyph_positions(*args, **kwargs): ...
    def get_serial(*args, **kwargs): ...
    def list_families(*args, **kwargs): ...
    def load_font(*args, **kwargs): ...
    def load_fontset(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_base_dir(*args, **kwargs): ...
    def set_base_gravity(*args, **kwargs): ...
    def set_font_description(*args, **kwargs): ...
    def set_font_map(*args, **kwargs): ...
    def set_gravity_hint(*args, **kwargs): ...
    def set_language(*args, **kwargs): ...
    def set_matrix(*args, **kwargs): ...
    def set_round_glyph_positions(*args, **kwargs): ...
    

class Coverage:
    def copy(*args, **kwargs): ...
    def from_bytes(*args, **kwargs): ...
    def get(*args, **kwargs): ...
    def max(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set(*args, **kwargs): ...
    def to_bytes(*args, **kwargs): ...
    

class Font:
    parent_instance = ...
    
    def describe(*args, **kwargs): ...
    def describe_with_absolute_size(*args, **kwargs): ...
    def descriptions_free(*args, **kwargs): ...
    def get_coverage(*args, **kwargs): ...
    def get_face(*args, **kwargs): ...
    def get_features(*args, **kwargs): ...
    def get_font_map(*args, **kwargs): ...
    def get_glyph_extents(*args, **kwargs): ...
    def get_metrics(*args, **kwargs): ...
    def has_char(*args, **kwargs): ...
    
    def do_create_hb_font(self, *args, **kwargs): ...
    def do_describe(self, *args, **kwargs): ...
    def do_describe_absolute(self, *args, **kwargs): ...
    def do_get_coverage(self, *args, **kwargs): ...
    def do_get_features(self, *args, **kwargs): ...
    def do_get_font_map(self, *args, **kwargs): ...
    def do_get_glyph_extents(self, *args, **kwargs): ...
    def do_get_metrics(self, *args, **kwargs): ...
    

class FontDescription:
    def better_match(*args, **kwargs): ...
    def copy_static(*args, **kwargs): ...
    def equal(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def from_string(*args, **kwargs): ...
    def get_family(self) -> Optional[str]: ...
    def get_gravity(*args, **kwargs): ...
    def get_set_fields(*args, **kwargs): ...
    def get_size(self) -> int: ...
    def get_size_is_absolute(*args, **kwargs): ...
    def get_stretch(*args, **kwargs): ...
    def get_style(self) -> Style: ...
    def get_variant(*args, **kwargs): ...
    def get_variations(*args, **kwargs): ...
    def get_weight(self) -> Weight: ...
    def hash(*args, **kwargs): ...
    def merge(*args, **kwargs): ...
    def merge_static(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_absolute_size(*args, **kwargs): ...
    def set_family(self, family: str) -> None: ...
    def set_family_static(*args, **kwargs): ...
    def set_gravity(*args, **kwargs): ...
    def set_size(self, size: int) -> None: ...
    def set_stretch(*args, **kwargs): ...
    def set_style(self, style: Style) -> None: ...
    def set_variant(*args, **kwargs): ...
    def set_variations(*args, **kwargs): ...
    def set_variations_static(*args, **kwargs): ...
    def set_weight(self, weight: Weight) -> None: ...
    def to_filename(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    def unset_fields(*args, **kwargs): ...
    

class FontFace:
    parent_instance = ...
    
    def describe(*args, **kwargs): ...
    def get_face_name(*args, **kwargs): ...
    def get_family(*args, **kwargs): ...
    def is_synthesized(*args, **kwargs): ...
    def list_sizes(*args, **kwargs): ...
    
    def do_describe(self, *args, **kwargs): ...
    def do_get_face_name(self, *args, **kwargs): ...
    def do_get_family(self, *args, **kwargs): ...
    def do_is_synthesized(self, *args, **kwargs): ...
    def do_list_sizes(self, *args, **kwargs): ...
    

class FontFamily:
    parent_instance = ...
    
    def get_face(*args, **kwargs): ...
    def get_name(*args, **kwargs): ...
    def is_monospace(*args, **kwargs): ...
    def is_variable(*args, **kwargs): ...
    def list_faces(*args, **kwargs): ...
    
    def do_get_face(self, *args, **kwargs): ...
    def do_get_name(self, *args, **kwargs): ...
    def do_is_monospace(self, *args, **kwargs): ...
    def do_is_variable(self, *args, **kwargs): ...
    def do_list_faces(self, *args, **kwargs): ...
    

class FontMap:
    parent_instance = ...
    
    def changed(*args, **kwargs): ...
    def create_context(*args, **kwargs): ...
    def get_family(*args, **kwargs): ...
    def get_serial(*args, **kwargs): ...
    def list_families(*args, **kwargs): ...
    def load_font(*args, **kwargs): ...
    def load_fontset(*args, **kwargs): ...
    
    def do_changed(self, *args, **kwargs): ...
    def do_get_family(self, *args, **kwargs): ...
    def do_get_serial(self, *args, **kwargs): ...
    def do_list_families(self, *args, **kwargs): ...
    def do_load_font(self, *args, **kwargs): ...
    def do_load_fontset(self, *args, **kwargs): ...
    

class FontMetrics:
    approximate_char_width = ...
    approximate_digit_width = ...
    ascent = ...
    descent = ...
    height = ...
    ref_count = ...
    strikethrough_position = ...
    strikethrough_thickness = ...
    underline_position = ...
    underline_thickness = ...
    
    def get_approximate_char_width(*args, **kwargs): ...
    def get_approximate_digit_width(*args, **kwargs): ...
    def get_ascent(*args, **kwargs): ...
    def get_descent(*args, **kwargs): ...
    def get_height(*args, **kwargs): ...
    def get_strikethrough_position(*args, **kwargs): ...
    def get_strikethrough_thickness(*args, **kwargs): ...
    def get_underline_position(*args, **kwargs): ...
    def get_underline_thickness(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    

class Fontset:
    parent_instance = ...
    
    def foreach(*args, **kwargs): ...
    def get_font(*args, **kwargs): ...
    def get_metrics(*args, **kwargs): ...
    
    def do_foreach(self, *args, **kwargs): ...
    def do_get_font(self, *args, **kwargs): ...
    def do_get_language(self, *args, **kwargs): ...
    def do_get_metrics(self, *args, **kwargs): ...
    

class FontsetSimple:
    def append(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def size(*args, **kwargs): ...
    

class GlyphGeometry:
    width = ...
    x_offset = ...
    y_offset = ...
    

class GlyphInfo:
    attr = ...
    geometry = ...
    glyph = ...
    

class GlyphItem:
    glyphs = ...
    item = ...
    
    def apply_attrs(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_logical_widths(*args, **kwargs): ...
    def letter_space(*args, **kwargs): ...
    def split(*args, **kwargs): ...
    

class GlyphItemIter:
    end_char = ...
    end_glyph = ...
    end_index = ...
    glyph_item = ...
    start_char = ...
    start_glyph = ...
    start_index = ...
    text = ...
    
    def free(*args, **kwargs): ...
    def init_end(*args, **kwargs): ...
    def init_start(*args, **kwargs): ...
    def next_cluster(*args, **kwargs): ...
    def prev_cluster(*args, **kwargs): ...
    

class GlyphString:
    glyphs = ...
    log_clusters = ...
    num_glyphs = ...
    space = ...
    
    def extents(*args, **kwargs): ...
    def extents_range(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_logical_widths(*args, **kwargs): ...
    def get_width(*args, **kwargs): ...
    def index_to_x(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_size(*args, **kwargs): ...
    def x_to_index(*args, **kwargs): ...
    

class GlyphVisAttr:
    is_cluster_start = ...
    

class Item:
    analysis = ...
    length = ...
    num_chars = ...
    offset = ...
    
    def apply_attrs(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def split(*args, **kwargs): ...
    

class Language:
    def from_string(*args, **kwargs): ...
    def get_default(*args, **kwargs): ...
    def get_preferred(*args, **kwargs): ...
    def get_sample_string(*args, **kwargs): ...
    def get_scripts(*args, **kwargs): ...
    def includes_script(*args, **kwargs): ...
    def matches(*args, **kwargs): ...
    def to_string(*args, **kwargs): ...
    

class Layout:
    def context_changed(*args, **kwargs): ...
    def copy(*args, **kwargs): ...
    def get_alignment(*args, **kwargs): ...
    def get_attributes(*args, **kwargs): ...
    def get_auto_dir(*args, **kwargs): ...
    def get_baseline(*args, **kwargs): ...
    def get_character_count(*args, **kwargs): ...
    def get_context(*args, **kwargs): ...
    def get_cursor_pos(*args, **kwargs): ...
    def get_direction(*args, **kwargs): ...
    def get_ellipsize(*args, **kwargs): ...
    def get_extents(*args, **kwargs): ...
    def get_font_description(*args, **kwargs): ...
    def get_height(*args, **kwargs): ...
    def get_indent(*args, **kwargs): ...
    def get_iter(*args, **kwargs): ...
    def get_justify(*args, **kwargs): ...
    def get_line(*args, **kwargs): ...
    def get_line_count(*args, **kwargs): ...
    def get_line_readonly(*args, **kwargs): ...
    def get_line_spacing(*args, **kwargs): ...
    def get_lines(*args, **kwargs): ...
    def get_lines_readonly(*args, **kwargs): ...
    def get_log_attrs(*args, **kwargs): ...
    def get_log_attrs_readonly(*args, **kwargs): ...
    def get_pixel_extents(*args, **kwargs): ...
    def get_pixel_size(*args, **kwargs): ...
    def get_serial(*args, **kwargs): ...
    def get_single_paragraph_mode(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_spacing(*args, **kwargs): ...
    def get_tabs(*args, **kwargs): ...
    def get_text(*args, **kwargs): ...
    def get_unknown_glyphs_count(*args, **kwargs): ...
    def get_width(*args, **kwargs): ...
    def get_wrap(*args, **kwargs): ...
    def index_to_line_x(*args, **kwargs): ...
    def index_to_pos(*args, **kwargs): ...
    def is_ellipsized(*args, **kwargs): ...
    def is_wrapped(*args, **kwargs): ...
    def move_cursor_visually(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def set_alignment(*args, **kwargs): ...
    def set_attributes(*args, **kwargs): ...
    def set_auto_dir(*args, **kwargs): ...
    def set_ellipsize(*args, **kwargs): ...
    def set_font_description(*args, **kwargs): ...
    def set_height(*args, **kwargs): ...
    def set_indent(*args, **kwargs): ...
    def set_justify(*args, **kwargs): ...
    def set_line_spacing(*args, **kwargs): ...
    def set_markup(*args, **kwargs): ...
    def set_markup_with_accel(*args, **kwargs): ...
    def set_single_paragraph_mode(*args, **kwargs): ...
    def set_spacing(*args, **kwargs): ...
    def set_tabs(*args, **kwargs): ...
    def set_text(*args, **kwargs): ...
    def set_width(*args, **kwargs): ...
    def set_wrap(*args, **kwargs): ...
    def xy_to_index(*args, **kwargs): ...
    

class LayoutIter:
    def at_last_line(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_baseline(*args, **kwargs): ...
    def get_char_extents(*args, **kwargs): ...
    def get_cluster_extents(*args, **kwargs): ...
    def get_index(*args, **kwargs): ...
    def get_layout(*args, **kwargs): ...
    def get_layout_extents(*args, **kwargs): ...
    def get_line(*args, **kwargs): ...
    def get_line_extents(*args, **kwargs): ...
    def get_line_readonly(*args, **kwargs): ...
    def get_line_yrange(*args, **kwargs): ...
    def get_run(*args, **kwargs): ...
    def get_run_extents(*args, **kwargs): ...
    def get_run_readonly(*args, **kwargs): ...
    def next_char(*args, **kwargs): ...
    def next_cluster(*args, **kwargs): ...
    def next_line(*args, **kwargs): ...
    def next_run(*args, **kwargs): ...
    

class LayoutLine:
    is_paragraph_start = ...
    layout = ...
    length = ...
    resolved_dir = ...
    runs = ...
    start_index = ...
    
    def get_extents(*args, **kwargs): ...
    def get_height(*args, **kwargs): ...
    def get_pixel_extents(*args, **kwargs): ...
    def get_x_ranges(*args, **kwargs): ...
    def index_to_x(*args, **kwargs): ...
    def ref(*args, **kwargs): ...
    def unref(*args, **kwargs): ...
    def x_to_index(*args, **kwargs): ...
    

class LogAttr:
    backspace_deletes_character = ...
    is_char_break = ...
    is_cursor_position = ...
    is_expandable_space = ...
    is_line_break = ...
    is_mandatory_break = ...
    is_sentence_boundary = ...
    is_sentence_end = ...
    is_sentence_start = ...
    is_white = ...
    is_word_boundary = ...
    is_word_end = ...
    is_word_start = ...
    

class Matrix:
    x0 = ...
    xx = ...
    xy = ...
    y0 = ...
    yx = ...
    yy = ...
    
    def concat(*args, **kwargs): ...
    def free(*args, **kwargs): ...
    def get_font_scale_factor(*args, **kwargs): ...
    def get_font_scale_factors(*args, **kwargs): ...
    def rotate(*args, **kwargs): ...
    def scale(*args, **kwargs): ...
    def transform_distance(*args, **kwargs): ...
    def transform_pixel_rectangle(*args, **kwargs): ...
    def transform_point(*args, **kwargs): ...
    def transform_rectangle(*args, **kwargs): ...
    def translate(*args, **kwargs): ...
    

class Rectangle:
    height = ...
    width = ...
    x = ...
    y = ...
    

class Renderer:
    active_count = ...
    matrix = ...
    parent_instance = ...
    priv = ...
    strikethrough = ...
    underline = ...
    
    def activate(*args, **kwargs): ...
    def deactivate(*args, **kwargs): ...
    def draw_error_underline(*args, **kwargs): ...
    def draw_glyph(*args, **kwargs): ...
    def draw_glyph_item(*args, **kwargs): ...
    def draw_glyphs(*args, **kwargs): ...
    def draw_layout(*args, **kwargs): ...
    def draw_layout_line(*args, **kwargs): ...
    def draw_rectangle(*args, **kwargs): ...
    def draw_trapezoid(*args, **kwargs): ...
    def get_alpha(*args, **kwargs): ...
    def get_color(*args, **kwargs): ...
    def get_layout(*args, **kwargs): ...
    def get_layout_line(*args, **kwargs): ...
    def get_matrix(*args, **kwargs): ...
    def part_changed(*args, **kwargs): ...
    def set_alpha(*args, **kwargs): ...
    def set_color(*args, **kwargs): ...
    def set_matrix(*args, **kwargs): ...
    
    def do_begin(self, *args, **kwargs): ...
    def do_draw_error_underline(self, *args, **kwargs): ...
    def do_draw_glyph(self, *args, **kwargs): ...
    def do_draw_glyph_item(self, *args, **kwargs): ...
    def do_draw_glyphs(self, *args, **kwargs): ...
    def do_draw_rectangle(self, *args, **kwargs): ...
    def do_draw_shape(self, *args, **kwargs): ...
    def do_draw_trapezoid(self, *args, **kwargs): ...
    def do_end(self, *args, **kwargs): ...
    def do_part_changed(self, *args, **kwargs): ...
    def do_prepare_run(self, *args, **kwargs): ...
    

class ScriptIter:
    def free(*args, **kwargs): ...
    def get_range(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def next(*args, **kwargs): ...
    

class TabArray:
    def free(*args, **kwargs): ...
    def get_positions_in_pixels(*args, **kwargs): ...
    def get_size(*args, **kwargs): ...
    def get_tab(*args, **kwargs): ...
    def get_tabs(*args, **kwargs): ...
    def new(*args, **kwargs): ...
    def resize(*args, **kwargs): ...
    def set_tab(*args, **kwargs): ...
    

class FontMask(GObject.GFlags):
    FAMILY = ...
    STYLE = ...
    VARIANT = ...
    WEIGHT = ...
    STRETCH = ...
    SIZE = ...
    GRAVITY = ...
    VARIATIONS = ...

class ShapeFlags(GObject.GFlags):
    NONE = ...
    ROUND_POSITIONS = ...

class ShowFlags(GObject.GFlags):
    NONE = ...
    SPACES = ...
    LINE_BREAKS = ...
    IGNORABLES = ...

class Alignment(GObject.GEnum):
    LEFT = ...
    CENTER = ...
    RIGHT = ...

class AttrType(GObject.GEnum):
    INVALID = ...
    LANGUAGE = ...
    FAMILY = ...
    STYLE = ...
    WEIGHT = ...
    VARIANT = ...
    STRETCH = ...
    SIZE = ...
    FONT_DESC = ...
    FOREGROUND = ...
    BACKGROUND = ...
    UNDERLINE = ...
    STRIKETHROUGH = ...
    RISE = ...
    SHAPE = ...
    SCALE = ...
    FALLBACK = ...
    LETTER_SPACING = ...
    UNDERLINE_COLOR = ...
    STRIKETHROUGH_COLOR = ...
    ABSOLUTE_SIZE = ...
    GRAVITY = ...
    GRAVITY_HINT = ...
    FONT_FEATURES = ...
    FOREGROUND_ALPHA = ...
    BACKGROUND_ALPHA = ...
    ALLOW_BREAKS = ...
    SHOW = ...
    INSERT_HYPHENS = ...
    OVERLINE = ...
    OVERLINE_COLOR = ...
    get_name = ...
    register = ...

class BidiType(GObject.GEnum):
    L = ...
    LRE = ...
    LRO = ...
    R = ...
    AL = ...
    RLE = ...
    RLO = ...
    PDF = ...
    EN = ...
    ES = ...
    ET = ...
    AN = ...
    CS = ...
    NSM = ...
    BN = ...
    B = ...
    S = ...
    WS = ...
    ON = ...
    LRI = ...
    RLI = ...
    FSI = ...
    PDI = ...
    for_unichar = ...

class CoverageLevel(GObject.GEnum):
    NONE = ...
    FALLBACK = ...
    APPROXIMATE = ...
    EXACT = ...

class Direction(GObject.GEnum):
    LTR = ...
    RTL = ...
    TTB_LTR = ...
    TTB_RTL = ...
    WEAK_LTR = ...
    WEAK_RTL = ...
    NEUTRAL = ...

class EllipsizeMode(GObject.GEnum):
    NONE = ...
    START = ...
    MIDDLE = ...
    END = ...

class Gravity(GObject.GEnum):
    SOUTH = ...
    EAST = ...
    NORTH = ...
    WEST = ...
    AUTO = ...
    get_for_matrix = ...
    get_for_script = ...
    get_for_script_and_width = ...
    to_rotation = ...

class GravityHint(GObject.GEnum):
    NATURAL = ...
    STRONG = ...
    LINE = ...

class Overline(GObject.GEnum):
    NONE = ...
    SINGLE = ...

class RenderPart(GObject.GEnum):
    FOREGROUND = ...
    BACKGROUND = ...
    UNDERLINE = ...
    STRIKETHROUGH = ...
    OVERLINE = ...

class Script(GObject.GEnum):
    INVALID_CODE = ...
    COMMON = ...
    INHERITED = ...
    ARABIC = ...
    ARMENIAN = ...
    BENGALI = ...
    BOPOMOFO = ...
    CHEROKEE = ...
    COPTIC = ...
    CYRILLIC = ...
    DESERET = ...
    DEVANAGARI = ...
    ETHIOPIC = ...
    GEORGIAN = ...
    GOTHIC = ...
    GREEK = ...
    GUJARATI = ...
    GURMUKHI = ...
    HAN = ...
    HANGUL = ...
    HEBREW = ...
    HIRAGANA = ...
    KANNADA = ...
    KATAKANA = ...
    KHMER = ...
    LAO = ...
    LATIN = ...
    MALAYALAM = ...
    MONGOLIAN = ...
    MYANMAR = ...
    OGHAM = ...
    OLD_ITALIC = ...
    ORIYA = ...
    RUNIC = ...
    SINHALA = ...
    SYRIAC = ...
    TAMIL = ...
    TELUGU = ...
    THAANA = ...
    THAI = ...
    TIBETAN = ...
    CANADIAN_ABORIGINAL = ...
    YI = ...
    TAGALOG = ...
    HANUNOO = ...
    BUHID = ...
    TAGBANWA = ...
    BRAILLE = ...
    CYPRIOT = ...
    LIMBU = ...
    OSMANYA = ...
    SHAVIAN = ...
    LINEAR_B = ...
    TAI_LE = ...
    UGARITIC = ...
    NEW_TAI_LUE = ...
    BUGINESE = ...
    GLAGOLITIC = ...
    TIFINAGH = ...
    SYLOTI_NAGRI = ...
    OLD_PERSIAN = ...
    KHAROSHTHI = ...
    UNKNOWN = ...
    BALINESE = ...
    CUNEIFORM = ...
    PHOENICIAN = ...
    PHAGS_PA = ...
    NKO = ...
    KAYAH_LI = ...
    LEPCHA = ...
    REJANG = ...
    SUNDANESE = ...
    SAURASHTRA = ...
    CHAM = ...
    OL_CHIKI = ...
    VAI = ...
    CARIAN = ...
    LYCIAN = ...
    LYDIAN = ...
    BATAK = ...
    BRAHMI = ...
    MANDAIC = ...
    CHAKMA = ...
    MEROITIC_CURSIVE = ...
    MEROITIC_HIEROGLYPHS = ...
    MIAO = ...
    SHARADA = ...
    SORA_SOMPENG = ...
    TAKRI = ...
    BASSA_VAH = ...
    CAUCASIAN_ALBANIAN = ...
    DUPLOYAN = ...
    ELBASAN = ...
    GRANTHA = ...
    KHOJKI = ...
    KHUDAWADI = ...
    LINEAR_A = ...
    MAHAJANI = ...
    MANICHAEAN = ...
    MENDE_KIKAKUI = ...
    MODI = ...
    MRO = ...
    NABATAEAN = ...
    OLD_NORTH_ARABIAN = ...
    OLD_PERMIC = ...
    PAHAWH_HMONG = ...
    PALMYRENE = ...
    PAU_CIN_HAU = ...
    PSALTER_PAHLAVI = ...
    SIDDHAM = ...
    TIRHUTA = ...
    WARANG_CITI = ...
    AHOM = ...
    ANATOLIAN_HIEROGLYPHS = ...
    HATRAN = ...
    MULTANI = ...
    OLD_HUNGARIAN = ...
    SIGNWRITING = ...
    for_unichar = ...
    get_sample_language = ...

class Stretch(GObject.GEnum):
    ULTRA_CONDENSED = ...
    EXTRA_CONDENSED = ...
    CONDENSED = ...
    SEMI_CONDENSED = ...
    NORMAL = ...
    SEMI_EXPANDED = ...
    EXPANDED = ...
    EXTRA_EXPANDED = ...
    ULTRA_EXPANDED = ...

class Style(GObject.GEnum):
    NORMAL = ...
    OBLIQUE = ...
    ITALIC = ...

class TabAlign(GObject.GEnum):
    LEFT = ...

class Underline(GObject.GEnum):
    NONE = ...
    SINGLE = ...
    DOUBLE = ...
    LOW = ...
    ERROR = ...
    SINGLE_LINE = ...
    DOUBLE_LINE = ...
    ERROR_LINE = ...

class Variant(GObject.GEnum):
    NORMAL = ...
    SMALL_CAPS = ...

class Weight(GObject.GEnum):
    THIN = ...
    ULTRALIGHT = ...
    LIGHT = ...
    SEMILIGHT = ...
    BOOK = ...
    NORMAL = ...
    MEDIUM = ...
    SEMIBOLD = ...
    BOLD = ...
    ULTRABOLD = ...
    HEAVY = ...
    ULTRAHEAVY = ...

class WrapMode(GObject.GEnum):
    WORD = ...
    CHAR = ...
    WORD_CHAR = ...
