/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.BookingType;
import net.sf.mpxj.ChildResourceContainer;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldContainerDependencies;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectEntityWithID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ResourceFieldLists;
import net.sf.mpxj.listener.FieldListener;

public final class Resource
extends ProjectEntity
implements Comparable<Resource>,
ProjectEntityWithID,
FieldContainer,
ChildResourceContainer {
    private final Object[] m_array = new Object[ResourceField.MAX_VALUE];
    private final List<ResourceAssignment> m_assignments = new ArrayList<ResourceAssignment>();
    private final List<Resource> m_children = new ArrayList<Resource>();
    private boolean m_eventsEnabled = true;
    private boolean m_null;
    private String m_activeDirectoryGUID;
    private final CostRateTable[] m_costRateTables;
    private final AvailabilityTable m_availability = new AvailabilityTable();
    private List<FieldListener> m_listeners;
    private static final Map<FieldType, Function<Resource, Object>> CALCULATED_FIELD_MAP = new HashMap<FieldType, Function<Resource, Object>>();
    private static final Map<FieldType, List<FieldType>> DEPENDENCY_MAP;

    Resource(ProjectFile file) {
        super(file);
        this.setType(ResourceType.WORK);
        this.setRole(Boolean.FALSE);
        ProjectConfig config = file.getProjectConfig();
        if (config.getAutoResourceUniqueID()) {
            this.setUniqueID(config.getNextResourceUniqueID());
        }
        if (config.getAutoResourceID()) {
            this.setID(config.getNextResourceID());
        }
        this.m_costRateTables = new CostRateTable[5];
        for (int index = 0; index < this.m_costRateTables.length; ++index) {
            CostRateTable table = new CostRateTable();
            table.add(CostRateTableEntry.DEFAULT_ENTRY);
            this.m_costRateTables[index] = table;
        }
    }

    @Override
    public Resource addResource() {
        ProjectFile parent = this.getParentFile();
        Resource resource = new Resource(parent);
        resource.setParentResource(this);
        this.m_children.add(resource);
        parent.getResources().add(resource);
        return resource;
    }

    public void addChildResource(Resource child) {
        child.setParentResource(this);
        this.m_children.add(child);
    }

    @Override
    public List<Resource> getChildResources() {
        return this.m_children;
    }

    public void setName(String val) {
        this.set((FieldType)ResourceField.NAME, val);
    }

    public String getName() {
        return (String)this.get(ResourceField.NAME);
    }

    public void setType(ResourceType type) {
        this.set((FieldType)ResourceField.TYPE, type);
    }

    public ResourceType getType() {
        return (ResourceType)this.get(ResourceField.TYPE);
    }

    public void setIsNull(boolean isNull) {
        this.m_null = isNull;
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setInitials(String val) {
        this.set((FieldType)ResourceField.INITIALS, val);
    }

    public String getInitials() {
        return (String)this.get(ResourceField.INITIALS);
    }

    public void setPhonetics(String phonetics) {
        this.set((FieldType)ResourceField.PHONETICS, phonetics);
    }

    public String getPhonetics() {
        return (String)this.get(ResourceField.PHONETICS);
    }

    public void setNtAccount(String ntAccount) {
        this.set((FieldType)ResourceField.WINDOWS_USER_ACCOUNT, ntAccount);
    }

    public String getNtAccount() {
        return (String)this.get(ResourceField.WINDOWS_USER_ACCOUNT);
    }

    public void setMaterialLabel(String materialLabel) {
        this.set((FieldType)ResourceField.MATERIAL_LABEL, materialLabel);
    }

    public String getMaterialLabel() {
        return (String)this.get(ResourceField.MATERIAL_LABEL);
    }

    public void setCode(String val) {
        this.set((FieldType)ResourceField.CODE, val);
    }

    public String getCode() {
        return (String)this.get(ResourceField.CODE);
    }

    public void setGroup(String val) {
        this.set((FieldType)ResourceField.GROUP, val);
    }

    public String getGroup() {
        return (String)this.get(ResourceField.GROUP);
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.set((FieldType)ResourceField.WORKGROUP, workGroup);
    }

    public WorkGroup getWorkGroup() {
        return (WorkGroup)this.get(ResourceField.WORKGROUP);
    }

    public void setEmailAddress(String emailAddress) {
        this.set((FieldType)ResourceField.EMAIL_ADDRESS, emailAddress);
    }

    public String getEmailAddress() {
        return (String)this.get(ResourceField.EMAIL_ADDRESS);
    }

    public void setHyperlink(String hyperlink) {
        this.set((FieldType)ResourceField.HYPERLINK, hyperlink);
    }

    public String getHyperlink() {
        return (String)this.get(ResourceField.HYPERLINK);
    }

    public void setHyperlinkAddress(String hyperlinkAddress) {
        this.set((FieldType)ResourceField.HYPERLINK_ADDRESS, hyperlinkAddress);
    }

    public String getHyperlinkAddress() {
        return (String)this.get(ResourceField.HYPERLINK_ADDRESS);
    }

    public void setHyperlinkSubAddress(String hyperlinkSubAddress) {
        this.set((FieldType)ResourceField.HYPERLINK_SUBADDRESS, hyperlinkSubAddress);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.get(ResourceField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlinkScreenTip(String text) {
        this.set((FieldType)ResourceField.HYPERLINK_SCREEN_TIP, text);
    }

    public String getHyperlinkScreenTip() {
        return (String)this.get(ResourceField.HYPERLINK_SCREEN_TIP);
    }

    public void setMaxUnits(Number maxUnits) {
        this.set((FieldType)ResourceField.MAX_UNITS, maxUnits);
    }

    public Number getMaxUnits() {
        return (Number)this.get(ResourceField.MAX_UNITS);
    }

    public void setPeakUnits(Number peakUnits) {
        this.set((FieldType)ResourceField.PEAK, peakUnits);
    }

    public Number getPeakUnits() {
        return (Number)this.get(ResourceField.PEAK);
    }

    public void setOverAllocated(boolean overallocated) {
        this.set((FieldType)ResourceField.OVERALLOCATED, overallocated);
    }

    public boolean getOverAllocated() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.OVERALLOCATED));
    }

    public Date getAvailableFrom() {
        return (Date)this.get(ResourceField.AVAILABLE_FROM);
    }

    public void setAvailableFrom(Date date) {
        this.set((FieldType)ResourceField.AVAILABLE_FROM, date);
    }

    public Date getAvailableTo() {
        return (Date)this.get(ResourceField.AVAILABLE_TO);
    }

    public void setAvailableTo(Date date) {
        this.set((FieldType)ResourceField.AVAILABLE_TO, date);
    }

    public Date getStart() {
        Date result = null;
        for (ResourceAssignment assignment : this.m_assignments) {
            if (result != null && DateHelper.compare(result, assignment.getStart()) <= 0) continue;
            result = assignment.getStart();
        }
        return result;
    }

    public Date getFinish() {
        Date result = null;
        for (ResourceAssignment assignment : this.m_assignments) {
            if (result != null && DateHelper.compare(result, assignment.getFinish()) >= 0) continue;
            result = assignment.getFinish();
        }
        return result;
    }

    public void setCanLevel(boolean canLevel) {
        this.set((FieldType)ResourceField.CAN_LEVEL, canLevel);
    }

    public boolean getCanLevel() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.CAN_LEVEL));
    }

    public void setAccrueAt(AccrueType type) {
        this.set((FieldType)ResourceField.ACCRUE_AT, type);
    }

    public AccrueType getAccrueAt() {
        return (AccrueType)this.get(ResourceField.ACCRUE_AT);
    }

    public void setWork(Duration val) {
        this.set((FieldType)ResourceField.WORK, val);
    }

    public Duration getWork() {
        return (Duration)this.get(ResourceField.WORK);
    }

    public Duration getRegularWork() {
        return (Duration)this.get(ResourceField.REGULAR_WORK);
    }

    public void setRegularWork(Duration duration) {
        this.set((FieldType)ResourceField.REGULAR_WORK, duration);
    }

    public void setActualWork(Duration val) {
        this.set((FieldType)ResourceField.ACTUAL_WORK, val);
    }

    public Duration getActualWork() {
        return (Duration)this.get(ResourceField.ACTUAL_WORK);
    }

    public void setOvertimeWork(Duration overtimeWork) {
        this.set((FieldType)ResourceField.OVERTIME_WORK, overtimeWork);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.get(ResourceField.OVERTIME_WORK);
    }

    public void setRemainingWork(Duration val) {
        this.set((FieldType)ResourceField.REMAINING_WORK, val);
    }

    public Duration getRemainingWork() {
        return (Duration)this.get(ResourceField.REMAINING_WORK);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.get(ResourceField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_WORK, duration);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.get(ResourceField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_WORK, duration);
    }

    public void setPercentWorkComplete(Number percentWorkComplete) {
        this.set((FieldType)ResourceField.PERCENT_WORK_COMPLETE, percentWorkComplete);
    }

    public Number getPercentWorkComplete() {
        return (Number)this.get(ResourceField.PERCENT_WORK_COMPLETE);
    }

    @Deprecated
    public void setStandardRate(Rate val) {
    }

    public Rate getStandardRate() {
        return (Rate)this.get(ResourceField.STANDARD_RATE);
    }

    @Deprecated
    public void setStandardRateUnits(TimeUnit units) {
    }

    @Deprecated
    public TimeUnit getStandardRateUnits() {
        Rate rate = this.getStandardRate();
        return rate == null ? TimeUnit.HOURS : rate.getUnits();
    }

    public void setCost(Number cost) {
        this.set((FieldType)ResourceField.COST, cost);
    }

    public Number getCost() {
        return (Number)this.get(ResourceField.COST);
    }

    @Deprecated
    public void setOvertimeRate(Rate overtimeRate) {
    }

    public Rate getOvertimeRate() {
        return (Rate)this.get(ResourceField.OVERTIME_RATE);
    }

    @Deprecated
    public void setOvertimeRateUnits(TimeUnit units) {
    }

    @Deprecated
    public TimeUnit getOvertimeRateUnits() {
        Rate rate = this.getOvertimeRate();
        return rate == null ? TimeUnit.HOURS : rate.getUnits();
    }

    public Number getOvertimeCost() {
        return (Number)this.get(ResourceField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number currency) {
        this.set((FieldType)ResourceField.OVERTIME_COST, currency);
    }

    @Deprecated
    public void setCostPerUse(Number costPerUse) {
    }

    public Number getCostPerUse() {
        return (Number)this.get(ResourceField.COST_PER_USE);
    }

    public void setActualCost(Number actualCost) {
        this.set((FieldType)ResourceField.ACTUAL_COST, actualCost);
    }

    public Number getActualCost() {
        return (Number)this.get(ResourceField.ACTUAL_COST);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.get(ResourceField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number actualOvertimeCost) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_COST, actualOvertimeCost);
    }

    public void setRemainingCost(Number remainingCost) {
        this.set((FieldType)ResourceField.REMAINING_COST, remainingCost);
    }

    public Number getRemainingCost() {
        return (Number)this.get(ResourceField.REMAINING_COST);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.get(ResourceField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number remainingOvertimeCost) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_COST, remainingOvertimeCost);
    }

    public void setWorkVariance(Duration workVariance) {
        this.set((FieldType)ResourceField.WORK_VARIANCE, workVariance);
    }

    public Duration getWorkVariance() {
        return (Duration)this.get(ResourceField.WORK_VARIANCE);
    }

    public void setCostVariance(Number costVariance) {
        this.set((FieldType)ResourceField.COST_VARIANCE, costVariance);
    }

    public Number getCostVariance() {
        return (Number)this.get(ResourceField.COST_VARIANCE);
    }

    public void setSV(Number sv) {
        this.set((FieldType)ResourceField.SV, sv);
    }

    public Number getSV() {
        return (Number)this.get(ResourceField.SV);
    }

    public void setCV(Number cv) {
        this.set((FieldType)ResourceField.CV, cv);
    }

    public Number getCV() {
        return (Number)this.get(ResourceField.CV);
    }

    public void setACWP(Number acwp) {
        this.set((FieldType)ResourceField.ACWP, acwp);
    }

    public Number getACWP() {
        return (Number)this.get(ResourceField.ACWP);
    }

    public void setNotes(String notes) {
        this.set((FieldType)ResourceField.NOTES, notes == null ? null : new Notes(notes));
    }

    public String getNotes() {
        Object notes = this.get(ResourceField.NOTES);
        return notes == null ? "" : notes.toString();
    }

    public void setNotesObject(Notes notes) {
        this.set((FieldType)ResourceField.NOTES, notes);
    }

    public Notes getNotesObject() {
        return (Notes)this.get(ResourceField.NOTES);
    }

    public void setBCWS(Number bcws) {
        this.set((FieldType)ResourceField.BCWS, bcws);
    }

    public Number getBCWS() {
        return (Number)this.get(ResourceField.BCWS);
    }

    public void setBCWP(Number bcwp) {
        this.set((FieldType)ResourceField.BCWP, bcwp);
    }

    public Number getBCWP() {
        return (Number)this.get(ResourceField.BCWP);
    }

    public void setGeneric(boolean value) {
        this.set((FieldType)ResourceField.GENERIC, value);
    }

    public boolean getGeneric() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.GENERIC));
    }

    public void setActive(boolean value) {
        this.set((FieldType)ResourceField.ACTIVE, value);
    }

    public boolean getActive() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.ACTIVE));
    }

    public void setActveDirectoryGUID(String guid) {
        this.m_activeDirectoryGUID = guid;
    }

    public String getActiveDirectoryGUID() {
        return this.m_activeDirectoryGUID;
    }

    public void setActualOvertimeWorkProtected(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_WORK_PROTECTED, duration);
    }

    public Duration getActualOvertimeWorkProtected() {
        return (Duration)this.get(ResourceField.ACTUAL_OVERTIME_WORK_PROTECTED);
    }

    public void setActualWorkProtected(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_WORK_PROTECTED, duration);
    }

    public Duration getActualWorkProtected() {
        return (Duration)this.get(ResourceField.ACTUAL_WORK_PROTECTED);
    }

    public void setBookingType(BookingType bookingType) {
        this.set((FieldType)ResourceField.BOOKING_TYPE, bookingType);
    }

    public BookingType getBookingType() {
        return (BookingType)this.get(ResourceField.BOOKING_TYPE);
    }

    public void setCreationDate(Date creationDate) {
        this.set((FieldType)ResourceField.CREATED, creationDate);
    }

    public Date getCreationDate() {
        return (Date)this.get(ResourceField.CREATED);
    }

    public void setEnterprise(boolean enterprise) {
        this.set((FieldType)ResourceField.ENTERPRISE, enterprise);
    }

    public boolean getEnterprise() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.ENTERPRISE));
    }

    public Integer getCalendarUniqueID() {
        return (Integer)this.get(ResourceField.CALENDAR_UNIQUE_ID);
    }

    public void setCalendarUniqueID(Integer id) {
        this.set((FieldType)ResourceField.CALENDAR_UNIQUE_ID, id);
    }

    public ProjectCalendar getCalendar() {
        return (ProjectCalendar)this.getParentFile().getCalendars().getByUniqueID(this.getCalendarUniqueID());
    }

    public void setCalendar(ProjectCalendar calendar) {
        if (calendar == null) {
            this.setCalendarUniqueID(null);
        } else {
            this.setCalendarUniqueID(calendar.getUniqueID());
        }
    }

    @Deprecated
    public ProjectCalendar getResourceCalendar() {
        return this.getCalendar();
    }

    @Deprecated
    public void setResourceCalendar(ProjectCalendar calendar) {
        this.setCalendar(calendar);
    }

    @Deprecated
    public void setResourceCalendarUniqueID(Integer id) {
        this.setCalendarUniqueID(id);
    }

    @Deprecated
    public Integer getResourceCalendarUniqueID() {
        return this.getCalendarUniqueID();
    }

    public ProjectCalendar addCalendar() throws MPXJException {
        if (this.getCalendar() != null) {
            throw new MPXJException("Maximum number of records of this type exist");
        }
        ProjectCalendar calendar = this.getParentFile().addCalendar();
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            name = "Unnamed Resource";
        }
        calendar.setName(name);
        this.setCalendar(calendar);
        return calendar;
    }

    @Deprecated
    public ProjectCalendar addResourceCalendar() throws MPXJException {
        return this.addCalendar();
    }

    public void setBaseCalendar(String val) {
        this.set((FieldType)ResourceField.BASE_CALENDAR, val == null || val.length() == 0 ? "Standard" : val);
    }

    public void setBaselineCost(Number val) {
        this.set((FieldType)ResourceField.BASELINE_COST, val);
    }

    public void setBaselineWork(Duration val) {
        this.set((FieldType)ResourceField.BASELINE_WORK, val);
    }

    @Override
    public void setID(Integer val) {
        ProjectFile parent = this.getParentFile();
        Integer previous = this.getID();
        if (previous != null) {
            parent.getResources().unmapID(previous);
        }
        parent.getResources().mapID(val, this);
        this.set((FieldType)ResourceField.ID, val);
    }

    public void setLinkedFields(boolean val) {
        this.set((FieldType)ResourceField.LINKED_FIELDS, val);
    }

    public void setObjects(Integer val) {
        this.set((FieldType)ResourceField.OBJECTS, val);
    }

    public void setText(int index, String value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_TEXT, index), value);
    }

    public String getText(int index) {
        return (String)this.get(this.selectField(ResourceFieldLists.CUSTOM_TEXT, index));
    }

    @Override
    public void setUniqueID(Integer val) {
        this.set((FieldType)ResourceField.UNIQUE_ID, val);
    }

    public String getBaseCalendar() {
        return (String)this.get(ResourceField.BASE_CALENDAR);
    }

    public Number getBaselineCost() {
        return (Number)this.get(ResourceField.BASELINE_COST);
    }

    public Duration getBaselineWork() {
        return (Duration)this.get(ResourceField.BASELINE_WORK);
    }

    @Override
    public Integer getID() {
        return (Integer)this.get(ResourceField.ID);
    }

    public boolean getLinkedFields() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.LINKED_FIELDS));
    }

    public Integer getObjects() {
        return (Integer)this.get(ResourceField.OBJECTS);
    }

    @Override
    public Integer getUniqueID() {
        return (Integer)this.get(ResourceField.UNIQUE_ID);
    }

    @Deprecated
    public Integer getParentID() {
        return this.getParentResourceUniqueID();
    }

    @Deprecated
    public void setParentID(Integer val) {
        this.setParentResourceUniqueID(val);
    }

    public Integer getParentResourceUniqueID() {
        return (Integer)this.get(ResourceField.PARENT_ID);
    }

    public void setParentResourceUniqueID(Integer id) {
        this.set((FieldType)ResourceField.PARENT_ID, id);
    }

    public Resource getParentResource() {
        return this.getParentFile().getResourceByUniqueID(this.getParentResourceUniqueID());
    }

    public void setParentResource(Resource resource) {
        this.setParentResourceUniqueID(resource.getUniqueID());
    }

    public void setStart(int index, Date value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_START, index), value);
    }

    public Date getStart(int index) {
        return (Date)this.get(this.selectField(ResourceFieldLists.CUSTOM_START, index));
    }

    public void setFinish(int index, Date value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_FINISH, index), value);
    }

    public Date getFinish(int index) {
        return (Date)this.get(this.selectField(ResourceFieldLists.CUSTOM_FINISH, index));
    }

    public void setNumber(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_NUMBER, index), value);
    }

    public Number getNumber(int index) {
        return (Number)this.get(this.selectField(ResourceFieldLists.CUSTOM_NUMBER, index));
    }

    public void setDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_DURATION, index), value);
    }

    public Duration getDuration(int index) {
        return (Duration)this.get(this.selectField(ResourceFieldLists.CUSTOM_DURATION, index));
    }

    public void setDate(int index, Date value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_DATE, index), value);
    }

    public Date getDate(int index) {
        return (Date)this.get(this.selectField(ResourceFieldLists.CUSTOM_DATE, index));
    }

    public void setCost(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_COST, index), value);
    }

    public Number getCost(int index) {
        return (Number)this.get(this.selectField(ResourceFieldLists.CUSTOM_COST, index));
    }

    public void setFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_FLAG, index), value);
    }

    public boolean getFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.get(this.selectField(ResourceFieldLists.CUSTOM_FLAG, index)));
    }

    public void setOutlineCode(int index, String value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_OUTLINE_CODE, index), value);
    }

    public String getOutlineCode(int index) {
        return (String)this.get(this.selectField(ResourceFieldLists.CUSTOM_OUTLINE_CODE, index));
    }

    @Deprecated
    public void setOutlineCode1(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE1, value);
    }

    @Deprecated
    public String getOutlineCode1() {
        return (String)this.get(ResourceField.OUTLINE_CODE1);
    }

    @Deprecated
    public void setOutlineCode2(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE2, value);
    }

    @Deprecated
    public String getOutlineCode2() {
        return (String)this.get(ResourceField.OUTLINE_CODE2);
    }

    @Deprecated
    public void setOutlineCode3(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE3, value);
    }

    @Deprecated
    public String getOutlineCode3() {
        return (String)this.get(ResourceField.OUTLINE_CODE3);
    }

    @Deprecated
    public void setOutlineCode4(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE4, value);
    }

    @Deprecated
    public String getOutlineCode4() {
        return (String)this.get(ResourceField.OUTLINE_CODE4);
    }

    @Deprecated
    public void setOutlineCode5(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE5, value);
    }

    @Deprecated
    public String getOutlineCode5() {
        return (String)this.get(ResourceField.OUTLINE_CODE5);
    }

    @Deprecated
    public void setOutlineCode6(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE6, value);
    }

    @Deprecated
    public String getOutlineCode6() {
        return (String)this.get(ResourceField.OUTLINE_CODE6);
    }

    @Deprecated
    public void setOutlineCode7(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE7, value);
    }

    @Deprecated
    public String getOutlineCode7() {
        return (String)this.get(ResourceField.OUTLINE_CODE7);
    }

    @Deprecated
    public void setOutlineCode8(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE8, value);
    }

    @Deprecated
    public String getOutlineCode8() {
        return (String)this.get(ResourceField.OUTLINE_CODE8);
    }

    @Deprecated
    public void setOutlineCode9(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE9, value);
    }

    @Deprecated
    public String getOutlineCode9() {
        return (String)this.get(ResourceField.OUTLINE_CODE9);
    }

    @Deprecated
    public void setOutlineCode10(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE10, value);
    }

    @Deprecated
    public String getOutlineCode10() {
        return (String)this.get(ResourceField.OUTLINE_CODE10);
    }

    public void remove() {
        this.getParentFile().removeResource(this);
    }

    public Object getFieldByAlias(String alias) {
        return this.get(this.getParentFile().getResources().getFieldTypeByAlias(alias));
    }

    public void setFieldByAlias(String alias, Object value) {
        this.set(this.getParentFile().getResources().getFieldTypeByAlias(alias), value);
    }

    public void addResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.add(assignment);
    }

    void removeResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.remove(assignment);
    }

    public List<ResourceAssignment> getTaskAssignments() {
        return this.m_assignments;
    }

    public Integer getSubprojectResourceUniqueID() {
        return (Integer)this.get(ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID);
    }

    public void setSubprojectResourceUniqueID(Integer subprojectUniqueResourceID) {
        this.set((FieldType)ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID, subprojectUniqueResourceID);
    }

    public Number getEnterpriseCost(int index) {
        return (Number)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_COST, index));
    }

    public void setEnterpriseCost(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_COST, index), value);
    }

    public Date getEnterpriseDate(int index) {
        return (Date)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_DATE, index));
    }

    public void setEnterpriseDate(int index, Date value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_DATE, index), value);
    }

    public Duration getEnterpriseDuration(int index) {
        return (Duration)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_DURATION, index));
    }

    public void setEnterpriseDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_DURATION, index), value);
    }

    public boolean getEnterpriseFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_FLAG, index)));
    }

    public void setEnterpriseFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_FLAG, index), value);
    }

    public Number getEnterpriseNumber(int index) {
        return (Number)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_NUMBER, index));
    }

    public void setEnterpriseNumber(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_NUMBER, index), value);
    }

    public String getEnterpriseText(int index) {
        return (String)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_TEXT, index));
    }

    public void setEnterpriseText(int index, String value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_TEXT, index), value);
    }

    public Object getEnterpriseCustomField(int index) {
        return this.get(this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_FIELD, index));
    }

    public void setEnterpriseCustomField(int index, byte[] value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_FIELD, index), value);
    }

    public void setBaselineCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_COSTS, baselineNumber), value);
    }

    public void setBaselineWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_WORKS, baselineNumber), value);
    }

    public Number getBaselineCost(int baselineNumber) {
        return (Number)this.get(this.selectField(ResourceFieldLists.BASELINE_COSTS, baselineNumber));
    }

    public Duration getBaselineWork(int baselineNumber) {
        return (Duration)this.get(this.selectField(ResourceFieldLists.BASELINE_WORKS, baselineNumber));
    }

    public boolean getBudget() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.BUDGET));
    }

    public void setBudget(boolean budget) {
        this.set((FieldType)ResourceField.BUDGET, budget);
    }

    public UUID getGUID() {
        return (UUID)this.get(ResourceField.GUID);
    }

    public void setUnit(String value) {
        this.set((FieldType)ResourceField.UNIT, value);
    }

    public String getUnit() {
        return (String)this.get(ResourceField.UNIT);
    }

    public void setSupplyReference(String value) {
        this.set((FieldType)ResourceField.SUPPLY_REFERENCE, value);
    }

    public String getSupplyReference() {
        return (String)this.get(ResourceField.SUPPLY_REFERENCE);
    }

    public void setDescription(String value) {
        this.set((FieldType)ResourceField.DESCRIPTION, value);
    }

    public String getDescription() {
        return (String)this.get(ResourceField.DESCRIPTION);
    }

    public void setResourceID(String value) {
        this.set((FieldType)ResourceField.RESOURCE_ID, value);
    }

    public String getResourceID() {
        return (String)this.get(ResourceField.RESOURCE_ID);
    }

    public void setModifyOnIntegrate(Boolean value) {
        this.set((FieldType)ResourceField.MODIFY_ON_INTEGRATE, value);
    }

    public Boolean getModifyOnIntegrate() {
        return (Boolean)this.get(ResourceField.MODIFY_ON_INTEGRATE);
    }

    public void setExpensesOnly(Boolean value) {
        this.set((FieldType)ResourceField.EXPENSES_ONLY, value);
    }

    public Boolean getExpensesOnly() {
        return (Boolean)this.get(ResourceField.EXPENSES_ONLY);
    }

    public void setPeriodDur(Number value) {
        this.set((FieldType)ResourceField.PERIOD_DUR, value);
    }

    public Number getPeriodDur() {
        return (Number)this.get(ResourceField.PERIOD_DUR);
    }

    public void setPriority(Number value) {
        this.set((FieldType)ResourceField.PRIORITY, value);
    }

    public Number getPriority() {
        return (Number)this.get(ResourceField.PRIORITY);
    }

    public void setRate(Number value) {
        this.set((FieldType)ResourceField.RATE, value);
    }

    public Number getRate() {
        return (Number)this.get(ResourceField.RATE);
    }

    public void setPool(Number value) {
        this.set((FieldType)ResourceField.POOL, value);
    }

    public Number getPool() {
        return (Number)this.get(ResourceField.POOL);
    }

    public void setPerDay(Number value) {
        this.set((FieldType)ResourceField.PER_DAY, value);
    }

    public Number getPerDay() {
        return (Number)this.get(ResourceField.PER_DAY);
    }

    public void setPhone(String value) {
        this.set((FieldType)ResourceField.PHONE, value);
    }

    public String getPhone() {
        return (String)this.get(ResourceField.PHONE);
    }

    public void setRole(Boolean value) {
        this.set((FieldType)ResourceField.ROLE, value);
    }

    public Boolean getRole() {
        return (Boolean)this.get(ResourceField.ROLE);
    }

    public void setGUID(UUID value) {
        this.set((FieldType)ResourceField.GUID, value);
    }

    public void setCostRateTable(int index, CostRateTable crt) {
        this.m_costRateTables[index] = crt;
    }

    public CostRateTable getCostRateTable(int index) {
        return index < 0 || index >= 5 ? null : this.m_costRateTables[index];
    }

    public CostRateTableEntry getCurrentCostRateTableEntry(int costRateTable) {
        return this.getCostRateTable(costRateTable).getEntryByDate(new Date());
    }

    public AvailabilityTable getAvailability() {
        return this.m_availability;
    }

    public Number getBudgetCost() {
        return (Number)this.get(ResourceField.BUDGET_COST);
    }

    public void setBudgetCost(Number value) {
        this.set((FieldType)ResourceField.BUDGET_COST, value);
    }

    public Duration getBudgetWork() {
        return (Duration)this.get(ResourceField.BUDGET_WORK);
    }

    public void setBudgetWork(Duration value) {
        this.set((FieldType)ResourceField.BUDGET_WORK, value);
    }

    public Number getBaselineBudgetCost() {
        return (Number)this.get(ResourceField.BASELINE_BUDGET_COST);
    }

    public void setBaselineBudgetCost(Number value) {
        this.set((FieldType)ResourceField.BASELINE_BUDGET_COST, value);
    }

    public Duration getBaselineBudgetWork() {
        return (Duration)this.get(ResourceField.BASELINE_BUDGET_WORK);
    }

    public void setBaselineBudgetWork(Duration value) {
        this.set((FieldType)ResourceField.BASELINE_BUDGET_WORK, value);
    }

    public Number getBaselineBudgetCost(int baselineNumber) {
        return (Number)this.get(this.selectField(ResourceFieldLists.BASELINE_BUDGET_COSTS, baselineNumber));
    }

    public void setBaselineBudgetCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_BUDGET_COSTS, baselineNumber), value);
    }

    public Duration getBaselineBudgetWork(int baselineNumber) {
        return (Duration)this.get(this.selectField(ResourceFieldLists.BASELINE_BUDGET_WORKS, baselineNumber));
    }

    public void setBaselineBudgetWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_BUDGET_WORKS, baselineNumber), value);
    }

    public String getCostCenter() {
        return (String)this.get(ResourceField.COST_CENTER);
    }

    public void setCostCenter(String value) {
        this.set((FieldType)ResourceField.COST_CENTER, value);
    }

    private ResourceField selectField(ResourceField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return field == null ? null : this.m_array[field.getValue()];
    }

    @Override
    @Deprecated
    public Object getCurrentValue(FieldType field) {
        return this.get(field);
    }

    @Override
    public Object get(FieldType field) {
        Function<Resource, Object> f;
        if (!(field instanceof ResourceField)) {
            return null;
        }
        switch ((ResourceField)field) {
            case STANDARD_RATE: {
                return this.calculateStandardRate();
            }
            case OVERTIME_RATE: {
                return this.calculateOvertimeRate();
            }
            case COST_PER_USE: {
                return this.calculateCostPerUse();
            }
        }
        Object result = this.m_array[field.getValue()];
        if (result == null && (f = CALCULATED_FIELD_MAP.get(field)) != null && (result = f.apply(this)) != null) {
            this.set(field, result);
        }
        return result;
    }

    @Override
    public void set(FieldType field, Object value) {
        if (field != null) {
            int index = field.getValue();
            if (this.m_eventsEnabled) {
                this.invalidateCache(field, value);
                this.fireFieldChangeEvent(field, this.m_array[index], value);
            }
            this.m_array[index] = value;
        }
    }

    private void invalidateCache(FieldType field, Object newValue) {
        if (field == ResourceField.UNIQUE_ID) {
            this.getParentFile().getResources().clearUniqueIDMap();
            if (!this.m_assignments.isEmpty()) {
                for (ResourceAssignment assignment : this.m_assignments) {
                    assignment.setResourceUniqueID((Integer)newValue);
                }
            }
            return;
        }
        DEPENDENCY_MAP.getOrDefault(field, Collections.emptyList()).forEach(f -> this.set((FieldType)f, null));
    }

    private void fireFieldChangeEvent(FieldType field, Object oldValue, Object newValue) {
        if (this.m_listeners != null) {
            this.m_listeners.forEach(l -> l.fieldChange(this, field, oldValue, newValue));
        }
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    private Double calculateCostVariance() {
        Double variance = null;
        Number cost = this.getCost();
        Number baselineCost = this.getBaselineCost();
        if (cost != null && baselineCost != null) {
            variance = NumberHelper.getDouble(cost.doubleValue() - baselineCost.doubleValue());
        }
        return variance;
    }

    private Duration calculateWorkVariance() {
        Duration variance = null;
        Duration work = this.getWork();
        Duration baselineWork = this.getBaselineWork();
        if (work != null && baselineWork != null) {
            variance = Duration.getInstance(work.getDuration() - baselineWork.convertUnits(work.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), work.getUnits());
        }
        return variance;
    }

    private Double calculateCV() {
        return NumberHelper.getDouble(this.getBCWP()) - NumberHelper.getDouble(this.getACWP());
    }

    private Boolean calculateOverallocated() {
        Number peakUnits = this.getPeakUnits();
        Number maxUnits = this.getMaxUnits();
        return NumberHelper.getDouble(peakUnits) > NumberHelper.getDouble(maxUnits);
    }

    private Double calculateSV() {
        Double variance = null;
        Number bcwp = this.getBCWP();
        Number bcws = this.getBCWS();
        if (bcwp != null && bcws != null) {
            variance = NumberHelper.getDouble(bcwp.doubleValue() - bcws.doubleValue());
        }
        return variance;
    }

    private Rate calculateStandardRate() {
        CostRateTableEntry entry = this.getCurrentCostRateTableEntry(0);
        if (entry == null) {
            return null;
        }
        return entry.getStandardRate();
    }

    private Rate calculateOvertimeRate() {
        CostRateTableEntry entry = this.getCurrentCostRateTableEntry(0);
        if (entry == null) {
            return null;
        }
        return entry.getOvertimeRate();
    }

    private Number calculateCostPerUse() {
        CostRateTableEntry entry = this.getCurrentCostRateTableEntry(0);
        if (entry == null) {
            return null;
        }
        return entry.getCostPerUse();
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }

    @Override
    public int compareTo(Resource o) {
        int id1 = NumberHelper.getInt(this.getID());
        int id2 = NumberHelper.getInt(o.getID());
        return Integer.compare(id1, id2);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Resource) {
            result = this.compareTo((Resource)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return NumberHelper.getInt(this.getID());
    }

    public String toString() {
        return "[Resource id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + "]";
    }

    static {
        CALCULATED_FIELD_MAP.put(ResourceField.COST_VARIANCE, Resource::calculateCostVariance);
        CALCULATED_FIELD_MAP.put(ResourceField.WORK_VARIANCE, Resource::calculateWorkVariance);
        CALCULATED_FIELD_MAP.put(ResourceField.CV, Resource::calculateCV);
        CALCULATED_FIELD_MAP.put(ResourceField.SV, Resource::calculateSV);
        CALCULATED_FIELD_MAP.put(ResourceField.OVERALLOCATED, Resource::calculateOverallocated);
        DEPENDENCY_MAP = new HashMap<FieldType, List<FieldType>>();
        FieldContainerDependencies<FieldType> dependencies = new FieldContainerDependencies<FieldType>(DEPENDENCY_MAP);
        dependencies.calculatedField(ResourceField.COST_VARIANCE).dependsOn((FieldType[])new FieldType[]{ResourceField.COST, ResourceField.BASELINE_COST});
        dependencies.calculatedField(ResourceField.CV).dependsOn((FieldType[])new FieldType[]{ResourceField.BCWP, ResourceField.ACWP});
        dependencies.calculatedField(ResourceField.SV).dependsOn((FieldType[])new FieldType[]{ResourceField.BCWP, ResourceField.BCWS});
        dependencies.calculatedField(ResourceField.OVERALLOCATED).dependsOn((FieldType[])new FieldType[]{ResourceField.PEAK, ResourceField.MAX_UNITS});
    }
}

