/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ActivityCodeValue;
import net.sf.mpxj.ActivityStatus;
import net.sf.mpxj.ActivityType;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.ExpenseItem;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldContainerDependencies;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Notes;
import net.sf.mpxj.PercentCompleteType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectEntityWithID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.TaskFieldLists;
import net.sf.mpxj.listener.FieldListener;

public final class Task
extends ProjectEntity
implements Comparable<Task>,
ProjectEntityWithID,
FieldContainer,
ChildTaskContainer {
    private final Object[] m_array = new Object[TaskField.MAX_VALUE];
    private Task m_parent;
    private final List<Task> m_children = new ArrayList<Task>();
    private final List<ResourceAssignment> m_assignments = new ArrayList<ResourceAssignment>();
    private RecurringTask m_recurringTask;
    private boolean m_eventsEnabled = true;
    private boolean m_null;
    private boolean m_resumeValid;
    private String m_externalTaskProject;
    private boolean m_expanded = true;
    private List<FieldListener> m_listeners;
    private static final Map<FieldType, Function<Task, Object>> CALCULATED_FIELD_MAP = new HashMap<FieldType, Function<Task, Object>>();
    private static final Map<FieldType, List<FieldType>> DEPENDENCY_MAP;

    Task(ProjectFile file, Task parent) {
        super(file);
        this.setType(TaskType.FIXED_UNITS);
        this.setConstraintType(ConstraintType.AS_SOON_AS_POSSIBLE);
        this.setTaskMode(TaskMode.AUTO_SCHEDULED);
        this.setActive(true);
        this.set((FieldType)TaskField.PREDECESSORS, new ArrayList());
        this.set((FieldType)TaskField.SUCCESSORS, new ArrayList());
        this.m_parent = parent;
        ProjectConfig config = file.getProjectConfig();
        if (config.getAutoTaskUniqueID()) {
            this.setUniqueID(config.getNextTaskUniqueID());
        }
        if (config.getAutoTaskID()) {
            this.setID(config.getNextTaskID());
        }
        if (config.getAutoWBS()) {
            this.generateWBS(parent);
        }
        if (config.getAutoOutlineNumber()) {
            this.generateOutlineNumber(parent);
        }
        if (config.getAutoOutlineLevel()) {
            if (parent == null) {
                this.setOutlineLevel(1);
            } else {
                this.setOutlineLevel(NumberHelper.getInt(parent.getOutlineLevel()) + 1);
            }
        }
    }

    public void generateWBS(Task parent) {
        String wbs;
        if (parent == null) {
            wbs = NumberHelper.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTasks().size() + 1);
        } else {
            wbs = parent.getWBS();
            int childTaskCount = parent.getChildTasks().size() + 1;
            wbs = wbs.equals("0") ? Integer.toString(childTaskCount) : wbs + "." + childTaskCount;
        }
        this.setWBS(wbs);
    }

    public void generateOutlineNumber(Task parent) {
        String outline;
        if (parent == null) {
            outline = NumberHelper.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTasks().size() + 1);
        } else {
            outline = parent.getOutlineNumber();
            int index = outline.lastIndexOf(".0");
            if (index != -1) {
                outline = outline.substring(0, index);
            }
            int childTaskCount = parent.getChildTasks().size() + 1;
            outline = outline.equals("0") ? Integer.toString(childTaskCount) : outline + "." + childTaskCount;
        }
        this.setOutlineNumber(outline);
    }

    public void setNotes(String notes) {
        this.set((FieldType)TaskField.NOTES, notes == null ? null : new Notes(notes));
    }

    public void setNotesObject(Notes notes) {
        this.set((FieldType)TaskField.NOTES, notes);
    }

    @Override
    public Task addTask() {
        ProjectFile parent = this.getParentFile();
        Task task = new Task(parent, this);
        this.m_children.add(task);
        parent.getTasks().add(task);
        this.setSummary(true);
        return task;
    }

    public void addChildTask(Task child, int childOutlineLevel) {
        int outlineLevel = NumberHelper.getInt(this.getOutlineLevel());
        if (outlineLevel + 1 == childOutlineLevel) {
            this.m_children.add(child);
            this.setSummary(true);
        } else if (!this.m_children.isEmpty()) {
            this.m_children.get(this.m_children.size() - 1).addChildTask(child, childOutlineLevel);
        }
    }

    public void addChildTask(Task child) {
        child.m_parent = this;
        this.m_children.add(child);
        this.setSummary(true);
        if (this.getParentFile().getProjectConfig().getAutoOutlineLevel()) {
            child.setOutlineLevel(NumberHelper.getInt(this.getOutlineLevel()) + 1);
        }
    }

    public void addChildTaskBefore(Task child, Task previousSibling) {
        int index = this.m_children.indexOf(previousSibling);
        if (index == -1) {
            this.m_children.add(child);
        } else {
            this.m_children.add(index, child);
        }
        child.m_parent = this;
        this.setSummary(true);
        if (this.getParentFile().getProjectConfig().getAutoOutlineLevel()) {
            child.setOutlineLevel(NumberHelper.getInt(this.getOutlineLevel()) + 1);
        }
    }

    public void removeChildTask(Task child) {
        if (this.m_children.remove(child)) {
            child.m_parent = null;
        }
        this.setSummary(!this.m_children.isEmpty());
    }

    public void clearChildTasks() {
        if (!this.m_children.isEmpty()) {
            this.m_children.clear();
            this.setSummary(false);
        }
    }

    public RecurringTask addRecurringTask() {
        if (this.m_recurringTask == null) {
            this.m_recurringTask = new RecurringTask();
        }
        return this.m_recurringTask;
    }

    public RecurringTask getRecurringTask() {
        return this.m_recurringTask;
    }

    public List<ActivityCodeValue> getActivityCodes() {
        List result = (List)this.getCachedValue(TaskField.ACTIVITY_CODES);
        return result == null ? Collections.emptyList() : result;
    }

    public void addActivityCode(ActivityCodeValue value) {
        ArrayList<ActivityCodeValue> list = (ArrayList<ActivityCodeValue>)this.getCachedValue(TaskField.ACTIVITY_CODES);
        if (list == null) {
            list = new ArrayList<ActivityCodeValue>();
            this.set((FieldType)TaskField.ACTIVITY_CODES, list);
        }
        list.add(value);
    }

    public ResourceAssignment addResourceAssignment(Resource resource) {
        ResourceAssignment assignment = new ResourceAssignment(this.getParentFile(), this);
        assignment.setTaskUniqueID(this.getUniqueID());
        assignment.setResourceUniqueID(resource == null ? null : resource.getUniqueID());
        assignment.setWork(this.getDuration());
        assignment.setUnits(ResourceAssignment.DEFAULT_UNITS);
        this.addResourceAssignment(assignment);
        return assignment;
    }

    public void addResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.add(assignment);
        this.getParentFile().getResourceAssignments().add(assignment);
        Resource resource = assignment.getResource();
        if (resource != null) {
            resource.addResourceAssignment(assignment);
        }
    }

    public ResourceAssignment getExistingResourceAssignment(Resource resource) {
        Predicate<ResourceAssignment> filter = a -> resource == null && a.getResource() == null || resource != null && NumberHelper.equals(resource.getUniqueID(), a.getResourceUniqueID());
        return this.m_assignments.stream().filter(filter).findFirst().orElse(null);
    }

    public List<ResourceAssignment> getResourceAssignments() {
        return this.m_assignments;
    }

    void removeResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.remove(assignment);
    }

    public Relation addPredecessor(Task targetTask, RelationType type, Duration lag) {
        if (lag == null) {
            lag = Duration.getInstance(0, TimeUnit.DAYS);
        }
        List predecessorList = (List)this.getCachedValue(TaskField.PREDECESSORS);
        Relation predecessorRelation2 = null;
        for (Relation predecessorRelation2 : predecessorList) {
            if (predecessorRelation2.getTargetTask() == targetTask) {
                if (predecessorRelation2.getType() == type && predecessorRelation2.getLag().compareTo(lag) == 0) break;
                predecessorRelation2 = null;
                break;
            }
            predecessorRelation2 = null;
        }
        if (predecessorRelation2 == null) {
            predecessorRelation2 = new Relation(this, targetTask, type, lag);
            predecessorList.add(predecessorRelation2);
        }
        List successorList = (List)targetTask.getCachedValue(TaskField.SUCCESSORS);
        Relation successorRelation2 = null;
        for (Relation successorRelation2 : successorList) {
            if (successorRelation2.getTargetTask() == this) {
                if (successorRelation2.getType() == type && successorRelation2.getLag().compareTo(lag) == 0) break;
                successorRelation2 = null;
                break;
            }
            successorRelation2 = null;
        }
        if (successorRelation2 == null) {
            successorRelation2 = new Relation(targetTask, this, type, lag);
            successorList.add(successorRelation2);
        }
        return predecessorRelation2;
    }

    public void setPercentageComplete(Number val) {
        this.set((FieldType)TaskField.PERCENT_COMPLETE, val);
    }

    public void setPercentageWorkComplete(Number val) {
        this.set((FieldType)TaskField.PERCENT_WORK_COMPLETE, val);
    }

    public void setActualCost(Number val) {
        this.set((FieldType)TaskField.ACTUAL_COST, val);
    }

    public void setActualDuration(Duration val) {
        this.set((FieldType)TaskField.ACTUAL_DURATION, val);
    }

    public void setActualFinish(Date val) {
        this.set((FieldType)TaskField.ACTUAL_FINISH, val);
    }

    public void setActualStart(Date val) {
        this.set((FieldType)TaskField.ACTUAL_START, val);
    }

    public void setActualWork(Duration val) {
        this.set((FieldType)TaskField.ACTUAL_WORK, val);
    }

    public void setBaselineCost(Number val) {
        this.set((FieldType)TaskField.BASELINE_COST, val);
    }

    public void setBaselineDuration(Duration val) {
        this.set((FieldType)TaskField.BASELINE_DURATION, val);
    }

    public void setBaselineFinish(Date val) {
        this.set((FieldType)TaskField.BASELINE_FINISH, val);
    }

    public void setBaselineStart(Date val) {
        this.set((FieldType)TaskField.BASELINE_START, val);
    }

    public void setBaselineWork(Duration val) {
        this.set((FieldType)TaskField.BASELINE_WORK, val);
    }

    public void setBCWP(Number val) {
        this.set((FieldType)TaskField.BCWP, val);
    }

    public void setBCWS(Number val) {
        this.set((FieldType)TaskField.BCWS, val);
    }

    public void setConfirmed(boolean val) {
        this.set((FieldType)TaskField.CONFIRMED, val);
    }

    public void setConstraintDate(Date val) {
        this.set((FieldType)TaskField.CONSTRAINT_DATE, val);
    }

    public void setSecondaryConstraintDate(Date date) {
        this.set((FieldType)TaskField.SECONDARY_CONSTRAINT_DATE, date);
    }

    public void setConstraintType(ConstraintType type) {
        this.set((FieldType)TaskField.CONSTRAINT_TYPE, type);
    }

    public void setSecondaryConstraintType(ConstraintType type) {
        this.set((FieldType)TaskField.SECONDARY_CONSTRAINT_TYPE, type);
    }

    public void setContact(String val) {
        this.set((FieldType)TaskField.CONTACT, val);
    }

    public void setCost(Number val) {
        this.set((FieldType)TaskField.COST, val);
    }

    public void setCost(int index, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_COST, index), value);
    }

    public Number getCost(int index) {
        return (Number)this.get(this.selectField(TaskFieldLists.CUSTOM_COST, index));
    }

    public void setCostVariance(Number val) {
        this.set((FieldType)TaskField.COST_VARIANCE, val);
    }

    public void setCreateDate(Date val) {
        this.set((FieldType)TaskField.CREATED, val);
    }

    public void setCritical(boolean val) {
        this.set((FieldType)TaskField.CRITICAL, val);
    }

    public void setCV(Number val) {
        this.set((FieldType)TaskField.CV, val);
    }

    public void setLevelingDelay(Duration val) {
        this.set((FieldType)TaskField.LEVELING_DELAY, val);
    }

    public void setDuration(Duration val) {
        this.set((FieldType)TaskField.DURATION, val);
    }

    public void setDurationText(String val) {
        this.set((FieldType)TaskField.DURATION_TEXT, val);
    }

    public void setManualDuration(Duration dur) {
        this.set((FieldType)TaskField.MANUAL_DURATION, dur);
    }

    public Duration getManualDuration() {
        return (Duration)this.get(TaskField.MANUAL_DURATION);
    }

    public void setDurationVariance(Duration duration) {
        this.set((FieldType)TaskField.DURATION_VARIANCE, duration);
    }

    public void setEarlyFinish(Date date) {
        this.set((FieldType)TaskField.EARLY_FINISH, date);
    }

    public void setRemainingEarlyFinish(Date date) {
        this.set((FieldType)TaskField.REMAINING_EARLY_FINISH, date);
    }

    public void setEarlyStart(Date date) {
        this.set((FieldType)TaskField.EARLY_START, date);
    }

    public void setRemainingEarlyStart(Date date) {
        this.set((FieldType)TaskField.REMAINING_EARLY_START, date);
    }

    public void setFinish(Date date) {
        this.set((FieldType)TaskField.FINISH, date);
    }

    public void setFinishText(String val) {
        this.set((FieldType)TaskField.FINISH_TEXT, val);
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)TaskField.FINISH_VARIANCE, duration);
    }

    public void setFixedCost(Number val) {
        this.set((FieldType)TaskField.FIXED_COST, val);
    }

    public void setFreeSlack(Duration duration) {
        this.set((FieldType)TaskField.FREE_SLACK, duration);
    }

    public void setHideBar(boolean flag) {
        this.set((FieldType)TaskField.HIDE_BAR, flag);
    }

    @Override
    public void setID(Integer val) {
        ProjectFile parent = this.getParentFile();
        Integer previous = this.getID();
        if (previous != null) {
            parent.getTasks().unmapID(previous);
        }
        parent.getTasks().mapID(val, this);
        this.set((FieldType)TaskField.ID, val);
    }

    public void setLateFinish(Date date) {
        this.set((FieldType)TaskField.LATE_FINISH, date);
    }

    public void setRemainingLateFinish(Date date) {
        this.set((FieldType)TaskField.REMAINING_LATE_FINISH, date);
    }

    public void setLateStart(Date date) {
        this.set((FieldType)TaskField.LATE_START, date);
    }

    public void setRemainingLateStart(Date date) {
        this.set((FieldType)TaskField.REMAINING_LATE_START, date);
    }

    public void setLinkedFields(boolean flag) {
        this.set((FieldType)TaskField.LINKED_FIELDS, flag);
    }

    public void setMarked(boolean flag) {
        this.set((FieldType)TaskField.MARKED, flag);
    }

    public void setMilestone(boolean flag) {
        this.set((FieldType)TaskField.MILESTONE, flag);
    }

    public void setName(String name) {
        this.set((FieldType)TaskField.NAME, name);
    }

    public void setObjects(Integer val) {
        this.set((FieldType)TaskField.OBJECTS, val);
    }

    public void setOutlineLevel(Integer val) {
        this.set((FieldType)TaskField.OUTLINE_LEVEL, val);
    }

    public void setOutlineNumber(String val) {
        this.set((FieldType)TaskField.OUTLINE_NUMBER, val);
    }

    public void setPriority(Priority priority) {
        this.set((FieldType)TaskField.PRIORITY, priority);
    }

    public void setProject(String val) {
        this.set((FieldType)TaskField.PROJECT, val);
    }

    public void setRemainingCost(Number val) {
        this.set((FieldType)TaskField.REMAINING_COST, val);
    }

    public void setRemainingDuration(Duration val) {
        this.set((FieldType)TaskField.REMAINING_DURATION, val);
    }

    public void setRemainingWork(Duration val) {
        this.set((FieldType)TaskField.REMAINING_WORK, val);
    }

    public void setResourceGroup(String val) {
        this.set((FieldType)TaskField.RESOURCE_GROUP, val);
    }

    public void setResourceInitials(String val) {
        this.set((FieldType)TaskField.RESOURCE_INITIALS, val);
    }

    public void setResourceNames(String val) {
        this.set((FieldType)TaskField.RESOURCE_NAMES, val);
    }

    public void setResume(Date val) {
        this.set((FieldType)TaskField.RESUME, val);
    }

    public void setRollup(boolean val) {
        this.set((FieldType)TaskField.ROLLUP, val);
    }

    public void setStart(Date val) {
        this.set((FieldType)TaskField.START, val);
    }

    public void setStartText(String val) {
        this.set((FieldType)TaskField.START_TEXT, val);
    }

    public void setStartVariance(Duration val) {
        this.set((FieldType)TaskField.START_VARIANCE, val);
    }

    public void setStop(Date val) {
        this.set((FieldType)TaskField.STOP, val);
    }

    public void setSubprojectName(String val) {
        this.set((FieldType)TaskField.SUBPROJECT_FILE, val);
    }

    public void setSummary(boolean val) {
        this.set((FieldType)TaskField.SUMMARY, val);
    }

    public void setSV(Number val) {
        this.set((FieldType)TaskField.SV, val);
    }

    public void setTotalSlack(Duration val) {
        this.set((FieldType)TaskField.TOTAL_SLACK, val);
    }

    @Override
    public void setUniqueID(Integer val) {
        this.set((FieldType)TaskField.UNIQUE_ID, val);
    }

    public void setUpdateNeeded(boolean val) {
        this.set((FieldType)TaskField.UPDATE_NEEDED, val);
    }

    public void setWBS(String val) {
        this.set((FieldType)TaskField.WBS, val);
    }

    public void setWork(Duration val) {
        this.set((FieldType)TaskField.WORK, val);
    }

    public void setWorkVariance(Duration val) {
        this.set((FieldType)TaskField.WORK_VARIANCE, val);
    }

    public Number getPercentageComplete() {
        return (Number)this.get(TaskField.PERCENT_COMPLETE);
    }

    public Number getPercentageWorkComplete() {
        return (Number)this.get(TaskField.PERCENT_WORK_COMPLETE);
    }

    public Number getActualCost() {
        return (Number)this.get(TaskField.ACTUAL_COST);
    }

    public Duration getActualDuration() {
        return (Duration)this.get(TaskField.ACTUAL_DURATION);
    }

    public Date getActualFinish() {
        return (Date)this.get(TaskField.ACTUAL_FINISH);
    }

    public Date getActualStart() {
        return (Date)this.get(TaskField.ACTUAL_START);
    }

    public Duration getActualWork() {
        return (Duration)this.get(TaskField.ACTUAL_WORK);
    }

    public Number getBaselineCost() {
        return (Number)this.get(TaskField.BASELINE_COST);
    }

    public Duration getBaselineDuration() {
        Object result = this.get(TaskField.BASELINE_DURATION);
        if (!(result instanceof Duration)) {
            result = null;
        }
        return (Duration)result;
    }

    public String getBaselineDurationText() {
        Object result = this.get(TaskField.BASELINE_DURATION);
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineDurationText(String value) {
        this.set((FieldType)TaskField.BASELINE_DURATION, value);
    }

    public Date getBaselineFinish() {
        Object result = this.get(TaskField.BASELINE_FINISH);
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineFinishText() {
        Object result = this.get(TaskField.BASELINE_FINISH);
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineFinishText(String value) {
        this.set((FieldType)TaskField.BASELINE_FINISH, value);
    }

    public Date getBaselineStart() {
        Object result = this.get(TaskField.BASELINE_START);
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineStartText() {
        Object result = this.get(TaskField.BASELINE_START);
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineStartText(String value) {
        this.set((FieldType)TaskField.BASELINE_START, value);
    }

    public Duration getBaselineWork() {
        return (Duration)this.get(TaskField.BASELINE_WORK);
    }

    public Number getBCWP() {
        return (Number)this.get(TaskField.BCWP);
    }

    public Number getBCWS() {
        return (Number)this.get(TaskField.BCWS);
    }

    public boolean getConfirmed() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.CONFIRMED));
    }

    public Date getConstraintDate() {
        return (Date)this.get(TaskField.CONSTRAINT_DATE);
    }

    public Date getSecondaryConstraintDate() {
        return (Date)this.get(TaskField.SECONDARY_CONSTRAINT_DATE);
    }

    public ConstraintType getConstraintType() {
        return (ConstraintType)this.get(TaskField.CONSTRAINT_TYPE);
    }

    public ConstraintType getSecondaryConstraintType() {
        return (ConstraintType)this.get(TaskField.SECONDARY_CONSTRAINT_TYPE);
    }

    public String getContact() {
        return (String)this.get(TaskField.CONTACT);
    }

    public Number getCost() {
        return (Number)this.get(TaskField.COST);
    }

    public Number getCostVariance() {
        return (Number)this.get(TaskField.COST_VARIANCE);
    }

    public Date getCreateDate() {
        return (Date)this.get(TaskField.CREATED);
    }

    public boolean getCritical() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.CRITICAL));
    }

    public Number getCV() {
        return (Number)this.get(TaskField.CV);
    }

    public Duration getLevelingDelay() {
        return (Duration)this.get(TaskField.LEVELING_DELAY);
    }

    public Duration getDuration() {
        return (Duration)this.get(TaskField.DURATION);
    }

    public String getDurationText() {
        return (String)this.get(TaskField.DURATION_TEXT);
    }

    public void setDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_DURATION, index), value);
    }

    public Duration getDuration(int index) {
        return (Duration)this.get(this.selectField(TaskFieldLists.CUSTOM_DURATION, index));
    }

    public Duration getDurationVariance() {
        return (Duration)this.get(TaskField.DURATION_VARIANCE);
    }

    public Date getEarlyFinish() {
        return (Date)this.get(TaskField.EARLY_FINISH);
    }

    public Date getRemainingEarlyFinish() {
        return (Date)this.get(TaskField.REMAINING_EARLY_FINISH);
    }

    public Date getEarlyStart() {
        return (Date)this.get(TaskField.EARLY_START);
    }

    public Date getRemainingEarlyStart() {
        return (Date)this.get(TaskField.REMAINING_EARLY_START);
    }

    public Date getFinish() {
        return (Date)this.get(TaskField.FINISH);
    }

    public String getFinishText() {
        return (String)this.get(TaskField.FINISH_TEXT);
    }

    public void setFinish(int index, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_FINISH, index), value);
    }

    public Date getFinish(int index) {
        return (Date)this.get(this.selectField(TaskFieldLists.CUSTOM_FINISH, index));
    }

    public Duration getFinishVariance() {
        return (Duration)this.get(TaskField.FINISH_VARIANCE);
    }

    public Number getFixedCost() {
        return (Number)this.get(TaskField.FIXED_COST);
    }

    public void setFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_FLAG, index), value);
    }

    public boolean getFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.get(this.selectField(TaskFieldLists.CUSTOM_FLAG, index)));
    }

    public Duration getFreeSlack() {
        return (Duration)this.get(TaskField.FREE_SLACK);
    }

    public boolean getHideBar() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.HIDE_BAR));
    }

    @Override
    public Integer getID() {
        return (Integer)this.get(TaskField.ID);
    }

    public Date getLateFinish() {
        return (Date)this.get(TaskField.LATE_FINISH);
    }

    public Date getRemainingLateFinish() {
        return (Date)this.get(TaskField.REMAINING_LATE_FINISH);
    }

    public Date getLateStart() {
        return (Date)this.get(TaskField.LATE_START);
    }

    public Date getRemainingLateStart() {
        return (Date)this.get(TaskField.REMAINING_LATE_START);
    }

    public boolean getLinkedFields() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.LINKED_FIELDS));
    }

    public boolean getMarked() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.MARKED));
    }

    public boolean getMilestone() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.MILESTONE));
    }

    public String getName() {
        return (String)this.get(TaskField.NAME);
    }

    public String getNotes() {
        Object notes = this.get(TaskField.NOTES);
        return notes == null ? "" : notes.toString();
    }

    public Notes getNotesObject() {
        Object notes = this.get(TaskField.NOTES);
        return notes == null ? null : (Notes)notes;
    }

    public void setNumber(int index, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_NUMBER, index), value);
    }

    public Number getNumber(int index) {
        return (Number)this.get(this.selectField(TaskFieldLists.CUSTOM_NUMBER, index));
    }

    public Integer getObjects() {
        return (Integer)this.get(TaskField.OBJECTS);
    }

    public Integer getOutlineLevel() {
        return (Integer)this.get(TaskField.OUTLINE_LEVEL);
    }

    public String getOutlineNumber() {
        return (String)this.get(TaskField.OUTLINE_NUMBER);
    }

    public List<Relation> getPredecessors() {
        return (List)this.get(TaskField.PREDECESSORS);
    }

    public List<Relation> getSuccessors() {
        return (List)this.get(TaskField.SUCCESSORS);
    }

    public Priority getPriority() {
        return (Priority)this.get(TaskField.PRIORITY);
    }

    public String getProject() {
        return (String)this.get(TaskField.PROJECT);
    }

    public Number getRemainingCost() {
        return (Number)this.get(TaskField.REMAINING_COST);
    }

    public Duration getRemainingDuration() {
        return (Duration)this.get(TaskField.REMAINING_DURATION);
    }

    public Duration getRemainingWork() {
        return (Duration)this.get(TaskField.REMAINING_WORK);
    }

    public String getResourceGroup() {
        return (String)this.get(TaskField.RESOURCE_GROUP);
    }

    public String getResourceInitials() {
        return (String)this.get(TaskField.RESOURCE_INITIALS);
    }

    public String getResourceNames() {
        return (String)this.get(TaskField.RESOURCE_NAMES);
    }

    public Date getResume() {
        return (Date)this.get(TaskField.RESUME);
    }

    public boolean getRollup() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.ROLLUP));
    }

    public Date getStart() {
        return (Date)this.get(TaskField.START);
    }

    public String getStartText() {
        return (String)this.get(TaskField.START_TEXT);
    }

    public void setStart(int index, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_START, index), value);
    }

    public Date getStart(int index) {
        return (Date)this.get(this.selectField(TaskFieldLists.CUSTOM_START, index));
    }

    public Duration getStartVariance() {
        return (Duration)this.get(TaskField.START_VARIANCE);
    }

    public Date getStop() {
        return (Date)this.get(TaskField.STOP);
    }

    public String getSubprojectName() {
        return (String)this.get(TaskField.SUBPROJECT_FILE);
    }

    public boolean getSummary() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.SUMMARY));
    }

    public Number getSV() {
        return (Number)this.get(TaskField.SV);
    }

    public void setText(int index, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_TEXT, index), value);
    }

    public String getText(int index) {
        return (String)this.get(this.selectField(TaskFieldLists.CUSTOM_TEXT, index));
    }

    public void setOutlineCode(int index, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_OUTLINE_CODE, index), value);
    }

    public String getOutlineCode(int index) {
        return (String)this.get(this.selectField(TaskFieldLists.CUSTOM_OUTLINE_CODE, index));
    }

    public Duration getTotalSlack() {
        return (Duration)this.get(TaskField.TOTAL_SLACK);
    }

    @Override
    public Integer getUniqueID() {
        return (Integer)this.get(TaskField.UNIQUE_ID);
    }

    public boolean getUpdateNeeded() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.UPDATE_NEEDED));
    }

    public String getWBS() {
        return (String)this.get(TaskField.WBS);
    }

    public Duration getWork() {
        return (Duration)this.get(TaskField.WORK);
    }

    public Duration getWorkVariance() {
        return (Duration)this.get(TaskField.WORK_VARIANCE);
    }

    public Task getParentTask() {
        return this.m_parent;
    }

    @Override
    public List<Task> getChildTasks() {
        return this.m_children;
    }

    @Override
    public int compareTo(Task o) {
        int id1 = NumberHelper.getInt(this.getID());
        int id2 = NumberHelper.getInt(o.getID());
        return Integer.compare(id1, id2);
    }

    public boolean getEstimated() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.ESTIMATED));
    }

    public void setEstimated(boolean estimated) {
        this.set((FieldType)TaskField.ESTIMATED, estimated);
    }

    public Date getDeadline() {
        return (Date)this.get(TaskField.DEADLINE);
    }

    public void setDeadline(Date deadline) {
        this.set((FieldType)TaskField.DEADLINE, deadline);
    }

    public TaskType getType() {
        return (TaskType)this.get(TaskField.TYPE);
    }

    public void setType(TaskType type) {
        this.set((FieldType)TaskField.TYPE, type);
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setNull(boolean isNull) {
        this.m_null = isNull;
    }

    public boolean getResumeValid() {
        return this.m_resumeValid;
    }

    public void setResumeValid(boolean resumeValid) {
        this.m_resumeValid = resumeValid;
    }

    public boolean getRecurring() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.RECURRING));
    }

    public void setRecurring(boolean recurring) {
        this.set((FieldType)TaskField.RECURRING, recurring);
    }

    public boolean getOverAllocated() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.OVERALLOCATED));
    }

    public void setOverAllocated(boolean overAllocated) {
        this.set((FieldType)TaskField.OVERALLOCATED, overAllocated);
    }

    public Integer getSubprojectTaskUniqueID() {
        return (Integer)this.get(TaskField.SUBPROJECT_UNIQUE_TASK_ID);
    }

    public void setSubprojectTaskUniqueID(Integer subprojectUniqueTaskID) {
        this.set((FieldType)TaskField.SUBPROJECT_UNIQUE_TASK_ID, subprojectUniqueTaskID);
    }

    public Integer getSubprojectTaskID() {
        return (Integer)this.get(TaskField.SUBPROJECT_TASK_ID);
    }

    public void setSubprojectTaskID(Integer subprojectTaskID) {
        this.set((FieldType)TaskField.SUBPROJECT_TASK_ID, subprojectTaskID);
    }

    public void setSubprojectTasksUniqueIDOffset(Integer offset) {
        this.set((FieldType)TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET, offset);
    }

    public Integer getSubprojectTasksUniqueIDOffset() {
        return (Integer)this.get(TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET);
    }

    public boolean getSubprojectReadOnly() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.SUBPROJECT_READ_ONLY));
    }

    public void setSubprojectReadOnly(boolean subprojectReadOnly) {
        this.set((FieldType)TaskField.SUBPROJECT_READ_ONLY, subprojectReadOnly);
    }

    public boolean getExternalTask() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.EXTERNAL_TASK));
    }

    public void setExternalTask(boolean externalTask) {
        this.set((FieldType)TaskField.EXTERNAL_TASK, externalTask);
    }

    public String getExternalTaskProject() {
        return this.m_externalTaskProject;
    }

    public void setExternalTaskProject(String externalTaskProject) {
        this.m_externalTaskProject = externalTaskProject;
    }

    public Number getACWP() {
        return (Number)this.get(TaskField.ACWP);
    }

    public void setACWP(Number acwp) {
        this.set((FieldType)TaskField.ACWP, acwp);
    }

    public TimeUnit getLevelingDelayFormat() {
        return (TimeUnit)this.get(TaskField.LEVELING_DELAY_UNITS);
    }

    public void setLevelingDelayFormat(TimeUnit levelingDelayFormat) {
        this.set((FieldType)TaskField.LEVELING_DELAY_UNITS, levelingDelayFormat);
    }

    public boolean getIgnoreResourceCalendar() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.IGNORE_RESOURCE_CALENDAR));
    }

    public void setIgnoreResourceCalendar(boolean ignoreResourceCalendar) {
        this.set((FieldType)TaskField.IGNORE_RESOURCE_CALENDAR, ignoreResourceCalendar);
    }

    public Number getPhysicalPercentComplete() {
        return (Number)this.get(TaskField.PHYSICAL_PERCENT_COMPLETE);
    }

    public void setPhysicalPercentComplete(Number physicalPercentComplete) {
        this.set((FieldType)TaskField.PHYSICAL_PERCENT_COMPLETE, physicalPercentComplete);
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return (EarnedValueMethod)this.get(TaskField.EARNED_VALUE_METHOD);
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.set((FieldType)TaskField.EARNED_VALUE_METHOD, earnedValueMethod);
    }

    public Duration getActualWorkProtected() {
        return (Duration)this.get(TaskField.ACTUAL_WORK_PROTECTED);
    }

    public void setActualWorkProtected(Duration actualWorkProtected) {
        this.set((FieldType)TaskField.ACTUAL_WORK_PROTECTED, actualWorkProtected);
    }

    public Duration getActualOvertimeWorkProtected() {
        return (Duration)this.get(TaskField.ACTUAL_OVERTIME_WORK_PROTECTED);
    }

    public void setActualOvertimeWorkProtected(Duration actualOvertimeWorkProtected) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_WORK_PROTECTED, actualOvertimeWorkProtected);
    }

    public Duration getRegularWork() {
        return (Duration)this.get(TaskField.REGULAR_WORK);
    }

    public void setRegularWork(Duration regularWork) {
        this.set((FieldType)TaskField.REGULAR_WORK, regularWork);
    }

    public void setEffortDriven(boolean flag) {
        this.set((FieldType)TaskField.EFFORT_DRIVEN, flag);
    }

    public boolean getEffortDriven() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.EFFORT_DRIVEN));
    }

    public void setDate(int index, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_DATE, index), value);
    }

    public Date getDate(int index) {
        return (Date)this.get(this.selectField(TaskFieldLists.CUSTOM_DATE, index));
    }

    public Number getOvertimeCost() {
        return (Number)this.get(TaskField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number number) {
        this.set((FieldType)TaskField.OVERTIME_COST, number);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.get(TaskField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number cost) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_COST, cost);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.get(TaskField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_WORK, work);
    }

    public AccrueType getFixedCostAccrual() {
        return (AccrueType)this.get(TaskField.FIXED_COST_ACCRUAL);
    }

    public void setFixedCostAccrual(AccrueType type) {
        this.set((FieldType)TaskField.FIXED_COST_ACCRUAL, type);
    }

    public String getHyperlink() {
        return (String)this.get(TaskField.HYPERLINK);
    }

    public String getHyperlinkAddress() {
        return (String)this.get(TaskField.HYPERLINK_ADDRESS);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.get(TaskField.HYPERLINK_SUBADDRESS);
    }

    public String getHyperlinkScreenTip() {
        return (String)this.get(TaskField.HYPERLINK_SCREEN_TIP);
    }

    public void setHyperlink(String text) {
        this.set((FieldType)TaskField.HYPERLINK, text);
    }

    public void setHyperlinkAddress(String text) {
        this.set((FieldType)TaskField.HYPERLINK_ADDRESS, text);
    }

    public void setHyperlinkSubAddress(String text) {
        this.set((FieldType)TaskField.HYPERLINK_SUBADDRESS, text);
    }

    public void setHyperlinkScreenTip(String text) {
        this.set((FieldType)TaskField.HYPERLINK_SCREEN_TIP, text);
    }

    public boolean getLevelAssignments() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.LEVEL_ASSIGNMENTS));
    }

    public void setLevelAssignments(boolean flag) {
        this.set((FieldType)TaskField.LEVEL_ASSIGNMENTS, flag);
    }

    public boolean getLevelingCanSplit() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.LEVELING_CAN_SPLIT));
    }

    public void setLevelingCanSplit(boolean flag) {
        this.set((FieldType)TaskField.LEVELING_CAN_SPLIT, flag);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.get(TaskField.OVERTIME_WORK);
    }

    public void setOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.OVERTIME_WORK, work);
    }

    public Date getPreleveledStart() {
        return (Date)this.get(TaskField.PRELEVELED_START);
    }

    public Date getPreleveledFinish() {
        return (Date)this.get(TaskField.PRELEVELED_FINISH);
    }

    public void setPreleveledStart(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_START, date);
    }

    public void setPreleveledFinish(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_FINISH, date);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.get(TaskField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_WORK, work);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.get(TaskField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number cost) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_COST, cost);
    }

    public ProjectCalendar getCalendar() {
        return (ProjectCalendar)this.getParentFile().getCalendars().getByUniqueID(this.getCalendarUniqueID());
    }

    public void setCalendarUniqueID(Integer id) {
        this.set((FieldType)TaskField.CALENDAR_UNIQUE_ID, id);
    }

    public Integer getCalendarUniqueID() {
        return (Integer)this.get(TaskField.CALENDAR_UNIQUE_ID);
    }

    public void setCalendar(ProjectCalendar calendar) {
        this.setCalendarUniqueID(calendar == null ? null : calendar.getUniqueID());
    }

    public boolean getExpanded() {
        return this.m_expanded;
    }

    public void setExpanded(boolean expanded) {
        this.m_expanded = expanded;
    }

    public void setStartSlack(Duration duration) {
        this.set((FieldType)TaskField.START_SLACK, duration);
    }

    public void setFinishSlack(Duration duration) {
        this.set((FieldType)TaskField.FINISH_SLACK, duration);
    }

    public Duration getStartSlack() {
        return (Duration)this.get(TaskField.START_SLACK);
    }

    public Duration getFinishSlack() {
        return (Duration)this.get(TaskField.FINISH_SLACK);
    }

    public Object getFieldByAlias(String alias) {
        return this.get(this.getParentFile().getTasks().getFieldTypeByAlias(alias));
    }

    public void setFieldByAlias(String alias, Object value) {
        this.set(this.getParentFile().getTasks().getFieldTypeByAlias(alias), value);
    }

    public List<DateRange> getSplits() {
        return (List)this.get(TaskField.SPLITS);
    }

    public void setSplits(List<DateRange> splits) {
        this.set((FieldType)TaskField.SPLITS, splits);
    }

    @Deprecated
    public Date getSplitCompleteDuration() {
        return this.getCompleteThrough();
    }

    @Deprecated
    void setSplitCompleteDuration(Date splitsComplete) {
        this.setCompleteThrough(splitsComplete);
    }

    public void remove() {
        this.getParentFile().removeTask(this);
    }

    public SubProject getSubProject() {
        return (SubProject)this.get(TaskField.SUBPROJECT);
    }

    public void setSubProject(SubProject subProject) {
        this.set((FieldType)TaskField.SUBPROJECT, subProject);
    }

    public Number getEnterpriseCost(int index) {
        return (Number)this.get(this.selectField(TaskFieldLists.ENTERPRISE_COST, index));
    }

    public void setEnterpriseCost(int index, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_COST, index), value);
    }

    public Date getEnterpriseDate(int index) {
        return (Date)this.get(this.selectField(TaskFieldLists.ENTERPRISE_DATE, index));
    }

    public void setEnterpriseDate(int index, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_DATE, index), value);
    }

    public Duration getEnterpriseDuration(int index) {
        return (Duration)this.get(this.selectField(TaskFieldLists.ENTERPRISE_DURATION, index));
    }

    public void setEnterpriseDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_DURATION, index), value);
    }

    public boolean getEnterpriseFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.get(this.selectField(TaskFieldLists.ENTERPRISE_FLAG, index)));
    }

    public void setEnterpriseFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_FLAG, index), value);
    }

    public Number getEnterpriseNumber(int index) {
        return (Number)this.get(this.selectField(TaskFieldLists.ENTERPRISE_NUMBER, index));
    }

    public void setEnterpriseNumber(int index, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_NUMBER, index), value);
    }

    public String getEnterpriseText(int index) {
        return (String)this.get(this.selectField(TaskFieldLists.ENTERPRISE_TEXT, index));
    }

    public void setEnterpriseText(int index, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_TEXT, index), value);
    }

    public Object getEnterpriseCustomField(int index) {
        return this.get(this.selectField(TaskFieldLists.ENTERPRISE_CUSTOM_FIELD, index));
    }

    public void setEnterpriseCustomField(int index, byte[] value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_CUSTOM_FIELD, index), value);
    }

    public void setBaselineCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_COSTS, baselineNumber), value);
    }

    public void setBaselineDuration(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_DURATIONS, baselineNumber), value);
    }

    public void setBaselineFinish(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FINISHES, baselineNumber), value);
    }

    public void setBaselineStart(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_STARTS, baselineNumber), value);
    }

    public void setBaselineWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_WORKS, baselineNumber), value);
    }

    public Number getBaselineCost(int baselineNumber) {
        return (Number)this.get(this.selectField(TaskFieldLists.BASELINE_COSTS, baselineNumber));
    }

    public Duration getBaselineDuration(int baselineNumber) {
        Object result = this.get(this.selectField(TaskFieldLists.BASELINE_DURATIONS, baselineNumber));
        if (!(result instanceof Duration)) {
            result = null;
        }
        return (Duration)result;
    }

    public String getBaselineDurationText(int baselineNumber) {
        Object result = this.get(this.selectField(TaskFieldLists.BASELINE_DURATIONS, baselineNumber));
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineDurationText(int baselineNumber, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_DURATIONS, baselineNumber), value);
    }

    public Date getBaselineFinish(int baselineNumber) {
        Object result = this.get(this.selectField(TaskFieldLists.BASELINE_FINISHES, baselineNumber));
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineFinishText(int baselineNumber) {
        Object result = this.get(this.selectField(TaskFieldLists.BASELINE_FINISHES, baselineNumber));
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineFinishText(int baselineNumber, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FINISHES, baselineNumber), value);
    }

    public Date getBaselineStart(int baselineNumber) {
        Object result = this.get(this.selectField(TaskFieldLists.BASELINE_STARTS, baselineNumber));
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineStartText(int baselineNumber) {
        Object result = this.get(this.selectField(TaskFieldLists.BASELINE_STARTS, baselineNumber));
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineStartText(int baselineNumber, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_STARTS, baselineNumber), value);
    }

    public Duration getBaselineWork(int baselineNumber) {
        return (Duration)this.get(this.selectField(TaskFieldLists.BASELINE_WORKS, baselineNumber));
    }

    public Date getCompleteThrough() {
        return (Date)this.get(TaskField.COMPLETE_THROUGH);
    }

    public void setCompleteThrough(Date value) {
        this.set((FieldType)TaskField.COMPLETE_THROUGH, value);
    }

    public Date getSummaryProgress() {
        return (Date)this.get(TaskField.SUMMARY_PROGRESS);
    }

    public void setSummaryProgress(Date value) {
        this.set((FieldType)TaskField.SUMMARY_PROGRESS, value);
    }

    public UUID getGUID() {
        return (UUID)this.get(TaskField.GUID);
    }

    public void setGUID(UUID value) {
        this.set((FieldType)TaskField.GUID, value);
    }

    public TaskMode getTaskMode() {
        return (TaskMode)this.get(TaskField.TASK_MODE);
    }

    public void setTaskMode(TaskMode mode) {
        this.set((FieldType)TaskField.TASK_MODE, mode);
    }

    public boolean getActive() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.ACTIVE));
    }

    public void setActive(boolean active) {
        this.set((FieldType)TaskField.ACTIVE, active);
    }

    public Duration getBaselineEstimatedDuration() {
        return (Duration)this.get(TaskField.BASELINE_ESTIMATED_DURATION);
    }

    public void setBaselineEstimatedDuration(Duration duration) {
        this.set((FieldType)TaskField.BASELINE_ESTIMATED_DURATION, duration);
    }

    public void setBaselineEstimatedDuration(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, baselineNumber), value);
    }

    public Duration getBaselineEstimatedDuration(int baselineNumber) {
        Object result = this.get(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, baselineNumber));
        if (!(result instanceof Duration)) {
            result = null;
        }
        return (Duration)result;
    }

    public Date getBaselineEstimatedStart() {
        return (Date)this.get(TaskField.BASELINE_ESTIMATED_START);
    }

    public void setBaselineEstimatedStart(Date date) {
        this.set((FieldType)TaskField.BASELINE_ESTIMATED_START, date);
    }

    public Date getBaselineEstimatedStart(int baselineNumber) {
        Object result = this.get(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, baselineNumber));
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public void setBaselineEstimatedStart(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, baselineNumber), value);
    }

    public Date getBaselineEstimatedFinish() {
        return (Date)this.get(TaskField.BASELINE_ESTIMATED_FINISH);
    }

    public void setBaselineEstimatedFinish(Date date) {
        this.set((FieldType)TaskField.BASELINE_ESTIMATED_FINISH, date);
    }

    public Date getBaselineEstimatedFinish(int baselineNumber) {
        Object result = this.get(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, baselineNumber));
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public void setBaselineEstimatedFinish(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, baselineNumber), value);
    }

    public void setBaselineFixedCost(Number val) {
        this.set((FieldType)TaskField.BASELINE_FIXED_COST, val);
    }

    public Number getBaselineFixedCost() {
        return (Number)this.get(TaskField.BASELINE_FIXED_COST);
    }

    public void setBaselineFixedCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FIXED_COSTS, baselineNumber), value);
    }

    public Number getBaselineFixedCost(int baselineNumber) {
        return (Number)this.get(this.selectField(TaskFieldLists.BASELINE_FIXED_COSTS, baselineNumber));
    }

    public AccrueType getBaselineFixedCostAccrual() {
        return (AccrueType)this.get(TaskField.BASELINE_FIXED_COST_ACCRUAL);
    }

    public void setBaselineFixedCostAccrual(AccrueType type) {
        this.set((FieldType)TaskField.BASELINE_FIXED_COST_ACCRUAL, type);
    }

    public void setBaselineFixedCostAccrual(int baselineNumber, AccrueType value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FIXED_COST_ACCRUALS, baselineNumber), value);
    }

    public AccrueType getBaselineFixedCostAccrual(int baselineNumber) {
        return (AccrueType)this.get(this.selectField(TaskFieldLists.BASELINE_FIXED_COST_ACCRUALS, baselineNumber));
    }

    public List<ExpenseItem> getExpenseItems() {
        return (List)this.get(TaskField.EXPENSE_ITEMS);
    }

    public void setExpenseItems(List<ExpenseItem> items) {
        this.set((FieldType)TaskField.EXPENSE_ITEMS, items);
    }

    public void setStoredMaterial(Number value) {
        this.set((FieldType)TaskField.STORED_MATERIAL, value);
    }

    public Number getStoredMaterial() {
        return (Number)this.get(TaskField.STORED_MATERIAL);
    }

    public void setFeatureOfWork(String value) {
        this.set((FieldType)TaskField.FEATURE_OF_WORK, value);
    }

    public String getFeatureOfWork() {
        return (String)this.get(TaskField.FEATURE_OF_WORK);
    }

    public void setCategoryOfWork(String value) {
        this.set((FieldType)TaskField.CATEGORY_OF_WORK, value);
    }

    public String getCategoryOfWork() {
        return (String)this.get(TaskField.CATEGORY_OF_WORK);
    }

    public void setPhaseOfWork(String value) {
        this.set((FieldType)TaskField.PHASE_OF_WORK, value);
    }

    public String getPhaseOfWork() {
        return (String)this.get(TaskField.PHASE_OF_WORK);
    }

    public void setBidItem(String value) {
        this.set((FieldType)TaskField.BID_ITEM, value);
    }

    public String getBidItem() {
        return (String)this.get(TaskField.BID_ITEM);
    }

    public void setModOrClaimNumber(String value) {
        this.set((FieldType)TaskField.MOD_OR_CLAIM_NUMBER, value);
    }

    public String getModOrClaimNumber() {
        return (String)this.get(TaskField.MOD_OR_CLAIM_NUMBER);
    }

    public void setWorkAreaCode(String value) {
        this.set((FieldType)TaskField.WORK_AREA_CODE, value);
    }

    public String getWorkAreaCode() {
        return (String)this.get(TaskField.WORK_AREA_CODE);
    }

    public void setResponsibilityCode(String value) {
        this.set((FieldType)TaskField.RESPONSIBILITY_CODE, value);
    }

    public String getResponsibilityCode() {
        return (String)this.get(TaskField.RESPONSIBILITY_CODE);
    }

    public void setWorkersPerDay(Integer value) {
        this.set((FieldType)TaskField.WORKERS_PER_DAY, value);
    }

    public Integer getWorkersPerDay() {
        return (Integer)this.get(TaskField.WORKERS_PER_DAY);
    }

    public void setHammockCode(Boolean value) {
        this.set((FieldType)TaskField.HAMMOCK_CODE, value);
    }

    public Boolean getHammockCode() {
        return (Boolean)this.get(TaskField.HAMMOCK_CODE);
    }

    public void setMail(String value) {
        this.set((FieldType)TaskField.MAIL, value);
    }

    public String getMail() {
        return (String)this.get(TaskField.MAIL);
    }

    public void setSection(String value) {
        this.set((FieldType)TaskField.SECTION, value);
    }

    public String getSection() {
        return (String)this.get(TaskField.SECTION);
    }

    public void setManager(String value) {
        this.set((FieldType)TaskField.MANAGER, value);
    }

    public String getManager() {
        return (String)this.get(TaskField.MANAGER);
    }

    public void setDepartment(String value) {
        this.set((FieldType)TaskField.DEPARTMENT, value);
    }

    public String getDepartment() {
        return (String)this.get(TaskField.DEPARTMENT);
    }

    public void setOverallPercentComplete(Number value) {
        this.set((FieldType)TaskField.OVERALL_PERCENT_COMPLETE, value);
    }

    public Number getOverallPercentComplete() {
        return (Number)this.get(TaskField.OVERALL_PERCENT_COMPLETE);
    }

    public void setPlannedFinish(Date value) {
        this.set((FieldType)TaskField.PLANNED_FINISH, value);
    }

    public Date getPlannedFinish() {
        return (Date)this.get(TaskField.PLANNED_FINISH);
    }

    public void setPlannedStart(Date value) {
        this.set((FieldType)TaskField.PLANNED_START, value);
    }

    public Date getPlannedStart() {
        return (Date)this.get(TaskField.PLANNED_START);
    }

    public void setPlannedDuration(Duration value) {
        this.set((FieldType)TaskField.PLANNED_DURATION, value);
    }

    public Duration getPlannedDuration() {
        return (Duration)this.get(TaskField.PLANNED_DURATION);
    }

    public void setPlannedWork(Duration value) {
        this.set((FieldType)TaskField.PLANNED_WORK, value);
    }

    public Duration getPlannedWork() {
        return (Duration)this.get(TaskField.PLANNED_WORK);
    }

    public void setPlannedCost(Number value) {
        this.set((FieldType)TaskField.PLANNED_COST, value);
    }

    public Number getPlannedCost() {
        return (Number)this.get(TaskField.PLANNED_COST);
    }

    public void setSuspendDate(Date value) {
        this.set((FieldType)TaskField.SUSPEND_DATE, value);
    }

    public Date getSuspendDate() {
        return (Date)this.get(TaskField.SUSPEND_DATE);
    }

    public void setPrimaryResourceID(Integer value) {
        this.set((FieldType)TaskField.PRIMARY_RESOURCE_ID, value);
    }

    public Integer getPrimaryResourceID() {
        return (Integer)this.get(TaskField.PRIMARY_RESOURCE_ID);
    }

    public void setActivityID(String value) {
        this.set((FieldType)TaskField.ACTIVITY_ID, value);
    }

    public String getCanonicalActivityID() {
        String projectID;
        String activityID = this.getActivityID();
        if (this.getSummary() && activityID != null && (projectID = this.getParentFile().getProjectProperties().getProjectID()) != null && activityID.startsWith(projectID)) {
            activityID = "PROJECT" + activityID.substring(projectID.length());
        }
        return activityID;
    }

    public String getActivityID() {
        return (String)this.get(TaskField.ACTIVITY_ID);
    }

    public void setPercentCompleteType(PercentCompleteType value) {
        this.set((FieldType)TaskField.PERCENT_COMPLETE_TYPE, (Object)value);
    }

    public PercentCompleteType getPercentCompleteType() {
        return (PercentCompleteType)((Object)this.get(TaskField.PERCENT_COMPLETE_TYPE));
    }

    public ActivityStatus getActivityStatus() {
        return (ActivityStatus)((Object)this.get(TaskField.ACTIVITY_STATUS));
    }

    public void setActivityStatus(ActivityStatus value) {
        this.set((FieldType)TaskField.ACTIVITY_STATUS, (Object)value);
    }

    public ActivityType getActivityType() {
        return (ActivityType)((Object)this.get(TaskField.ACTIVITY_TYPE));
    }

    public void setActivityType(ActivityType value) {
        this.set((FieldType)TaskField.ACTIVITY_TYPE, (Object)value);
    }

    public Boolean getLongestPath() {
        return (Boolean)this.get(TaskField.LONGEST_PATH);
    }

    public void setLongestPath(Boolean value) {
        this.set((FieldType)TaskField.LONGEST_PATH, value);
    }

    public Date getExternalEarlyStart() {
        return (Date)this.get(TaskField.EXTERNAL_EARLY_START);
    }

    public void setExternalEarlyStart(Date value) {
        this.set((FieldType)TaskField.EXTERNAL_EARLY_START, value);
    }

    public Date getExternalLateFinish() {
        return (Date)this.get(TaskField.EXTERNAL_LATE_FINISH);
    }

    public void setExternalLateFinish(Date value) {
        this.set((FieldType)TaskField.EXTERNAL_LATE_FINISH, value);
    }

    public Integer getSprintID() {
        return (Integer)this.get(TaskField.SPRINT_ID);
    }

    public void setSprintID(Integer value) {
        this.set((FieldType)TaskField.SPRINT_ID, value);
    }

    public Integer getBoardStatusID() {
        return (Integer)this.get(TaskField.BOARD_STATUS_ID);
    }

    public void setBoardStatusID(Integer value) {
        this.set((FieldType)TaskField.BOARD_STATUS_ID, value);
    }

    public boolean getResponsePending() {
        return BooleanHelper.getBoolean((Boolean)this.get(TaskField.RESPONSE_PENDING));
    }

    public void setResponsePending(boolean value) {
        this.set((FieldType)TaskField.RESPONSE_PENDING, value);
    }

    public Date getScheduledStart() {
        return (Date)this.get(TaskField.SCHEDULED_START);
    }

    public void setScheduledStart(Date value) {
        this.set((FieldType)TaskField.SCHEDULED_START, value);
    }

    public Date getScheduledFinish() {
        return (Date)this.get(TaskField.SCHEDULED_FINISH);
    }

    public void setScheduledFinish(Date value) {
        this.set((FieldType)TaskField.SCHEDULED_FINISH, value);
    }

    public Duration getScheduledDuration() {
        return (Duration)this.get(TaskField.SCHEDULED_DURATION);
    }

    public void setScheduledDuration(Duration value) {
        this.set((FieldType)TaskField.SCHEDULED_DURATION, value);
    }

    public Number getBudgetCost() {
        return (Number)this.get(TaskField.BUDGET_COST);
    }

    public void setBudgetCost(Number value) {
        this.set((FieldType)TaskField.BUDGET_COST, value);
    }

    public Duration getBudgetWork() {
        return (Duration)this.get(TaskField.BUDGET_WORK);
    }

    public void setBudgetWork(Duration value) {
        this.set((FieldType)TaskField.BUDGET_WORK, value);
    }

    public Number getBaselineBudgetCost() {
        return (Number)this.get(TaskField.BASELINE_BUDGET_COST);
    }

    public void setBaselineBudgetCost(Number value) {
        this.set((FieldType)TaskField.BASELINE_BUDGET_COST, value);
    }

    public Duration getBaselineBudgetWork() {
        return (Duration)this.get(TaskField.BASELINE_BUDGET_WORK);
    }

    public void setBaselineBudgetWork(Duration value) {
        this.set((FieldType)TaskField.BASELINE_BUDGET_WORK, value);
    }

    public Number getBaselineBudgetCost(int baselineNumber) {
        return (Number)this.get(this.selectField(TaskFieldLists.BASELINE_BUDGET_COSTS, baselineNumber));
    }

    public void setBaselineBudgetCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_BUDGET_COSTS, baselineNumber), value);
    }

    public Duration getBaselineBudgetWork(int baselineNumber) {
        return (Duration)this.get(this.selectField(TaskFieldLists.BASELINE_BUDGET_WORKS, baselineNumber));
    }

    public void setBaselineBudgetWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_BUDGET_WORKS, baselineNumber), value);
    }

    public ProjectCalendar getEffectiveCalendar() {
        ProjectCalendar result = this.getCalendar();
        if (result == null) {
            result = this.getParentFile().getDefaultCalendar();
        }
        return result;
    }

    public boolean removePredecessor(Task targetTask, RelationType type, Duration lag) {
        boolean matchFound = false;
        List<Relation> predecessorList = this.getPredecessors();
        if (!predecessorList.isEmpty()) {
            List<Relation> successorList;
            if (lag == null) {
                lag = Duration.getInstance(0, TimeUnit.DAYS);
            }
            if ((matchFound = this.removeRelation(predecessorList, targetTask, type, lag)) && !(successorList = targetTask.getSuccessors()).isEmpty()) {
                this.removeRelation(successorList, this, type, lag);
            }
        }
        return matchFound;
    }

    private boolean removeRelation(List<Relation> relationList, Task targetTask, RelationType type, Duration lag) {
        boolean matchFound = false;
        for (Relation relation : relationList) {
            if (relation.getTargetTask() != targetTask || relation.getType() != type || relation.getLag().compareTo(lag) != 0) continue;
            matchFound = relationList.remove(relation);
            break;
        }
        return matchFound;
    }

    private TaskField selectField(TaskField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return field == null ? null : this.m_array[field.getValue()];
    }

    @Override
    @Deprecated
    public Object getCurrentValue(FieldType field) {
        return this.get(field);
    }

    @Override
    public Object get(FieldType field) {
        Function<Task, Object> f;
        if (field == null) {
            return null;
        }
        if (field == TaskField.PARENT_TASK_UNIQUE_ID) {
            return this.getParentTaskUniqueID();
        }
        Object result = this.m_array[field.getValue()];
        if (result == null && (f = CALCULATED_FIELD_MAP.get(field)) != null && (result = f.apply(this)) != null) {
            this.set(field, result);
        }
        return result;
    }

    @Override
    public void set(FieldType field, Object value) {
        if (field != null) {
            int index = field.getValue();
            if (this.m_eventsEnabled) {
                this.invalidateCache(field);
                this.fireFieldChangeEvent(field, this.m_array[index], value);
            }
            this.m_array[index] = value;
        }
    }

    private void invalidateCache(FieldType field) {
        if (field == TaskField.UNIQUE_ID) {
            this.getParentFile().getTasks().clearUniqueIDMap();
            return;
        }
        DEPENDENCY_MAP.getOrDefault(field, Collections.emptyList()).forEach(f -> this.set((FieldType)f, null));
    }

    private void fireFieldChangeEvent(FieldType field, Object oldValue, Object newValue) {
        if (this.m_listeners != null) {
            this.m_listeners.forEach(l -> l.fieldChange(this, field, oldValue, newValue));
        }
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public String toString() {
        return "[Task id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + (this.getExternalTask() ? " [EXTERNAL uid=" + this.getSubprojectTaskUniqueID() + " id=" + this.getSubprojectTaskID() + "]" : "]") + (this.getSubProject() == null ? "" : " project=" + this.getSubProject());
    }

    public boolean isPredecessor(Task task) {
        return this.isRelated(task, this.getPredecessors());
    }

    public boolean isSucessor(Task task) {
        return this.isRelated(task, this.getSuccessors());
    }

    public boolean hasChildTasks() {
        return !this.m_children.isEmpty();
    }

    private boolean isRelated(Task task, List<Relation> list) {
        boolean result = false;
        for (Relation relation : list) {
            if (relation.getTargetTask().getUniqueID().intValue() != task.getUniqueID().intValue()) continue;
            result = true;
            break;
        }
        return result;
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }

    private Integer getParentTaskUniqueID() {
        return this.m_parent == null ? null : this.m_parent.getUniqueID();
    }

    private Duration calculateStartVariance() {
        TimeUnit format = this.getParentFile().getProjectProperties().getDefaultDurationUnits();
        return DateHelper.getVariance(this, this.getBaselineStart(), this.getStart(), format);
    }

    private Duration calculateFinishVariance() {
        TimeUnit format = this.getParentFile().getProjectProperties().getDefaultDurationUnits();
        return DateHelper.getVariance(this, this.getBaselineFinish(), this.getFinish(), format);
    }

    private Duration calculateStartSlack() {
        Duration duration = this.getDuration();
        Date lateStart = this.getLateStart();
        Date earlyStart = this.getEarlyStart();
        if (duration == null || lateStart == null || earlyStart == null) {
            return null;
        }
        return DateHelper.getVariance(this, earlyStart, lateStart, duration.getUnits());
    }

    private Duration calculateFinishSlack() {
        Duration duration = this.getDuration();
        Date earlyFinish = this.getEarlyFinish();
        Date lateFinish = this.getLateFinish();
        if (duration == null || earlyFinish == null || lateFinish == null) {
            return null;
        }
        return DateHelper.getVariance(this, earlyFinish, lateFinish, duration.getUnits());
    }

    private Double calculateCostVariance() {
        Number cost = this.getCost();
        Number baselineCost = this.getBaselineCost();
        if (cost == null || baselineCost == null) {
            return null;
        }
        return NumberHelper.getDouble(cost.doubleValue() - baselineCost.doubleValue());
    }

    private Duration calculateDurationVariance() {
        Duration duration = this.getDuration();
        Duration baselineDuration = this.getBaselineDuration();
        if (duration == null || baselineDuration == null) {
            return null;
        }
        return Duration.getInstance(duration.getDuration() - baselineDuration.convertUnits(duration.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), duration.getUnits());
    }

    private Duration calculateWorkVariance() {
        Duration work = this.getWork();
        Duration baselineWork = this.getBaselineWork();
        if (work == null || baselineWork == null) {
            return null;
        }
        return Duration.getInstance(work.getDuration() - baselineWork.convertUnits(work.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), work.getUnits());
    }

    private Double calculateCV() {
        return NumberHelper.getDouble(this.getBCWP()) - NumberHelper.getDouble(this.getACWP());
    }

    private Double calculateSV() {
        Number bcwp = this.getBCWP();
        Number bcws = this.getBCWS();
        if (bcwp == null || bcws == null) {
            return null;
        }
        return NumberHelper.getDouble(bcwp.doubleValue() - bcws.doubleValue());
    }

    private Duration calculateTotalSlack() {
        Duration duration = this.getDuration();
        if (duration == null) {
            return null;
        }
        Duration startSlack = this.getStartSlack();
        Duration finishSlack = this.getFinishSlack();
        if (startSlack == null && finishSlack == null) {
            return null;
        }
        TimeUnit units = duration.getUnits();
        if (startSlack == null) {
            startSlack = Duration.getInstance(0, units);
        } else if (startSlack.getUnits() != units) {
            startSlack = startSlack.convertUnits(units, this.getParentFile().getProjectProperties());
        }
        if (finishSlack == null) {
            finishSlack = Duration.getInstance(0, units);
        } else if (finishSlack.getUnits() != units) {
            finishSlack = finishSlack.convertUnits(units, this.getParentFile().getProjectProperties());
        }
        double startSlackDuration = startSlack.getDuration();
        double finishSlackDuration = finishSlack.getDuration();
        Duration totalSlack = startSlackDuration == 0.0 || finishSlackDuration == 0.0 ? (startSlackDuration != 0.0 ? startSlack : finishSlack) : (startSlackDuration < finishSlackDuration ? startSlack : finishSlack);
        return totalSlack;
    }

    private Boolean calculateCritical() {
        Duration totalSlack = this.getTotalSlack();
        if (totalSlack == null) {
            return Boolean.FALSE;
        }
        int criticalSlackLimit = NumberHelper.getInt(this.getParentFile().getProjectProperties().getCriticalSlackLimit());
        if (criticalSlackLimit != 0 && totalSlack.getDuration() != 0.0 && totalSlack.getUnits() != TimeUnit.DAYS) {
            totalSlack = totalSlack.convertUnits(TimeUnit.DAYS, this.getEffectiveCalendar());
        }
        return totalSlack.getDuration() <= (double)criticalSlackLimit && NumberHelper.getInt(this.getPercentageComplete()) != 100 && (this.getTaskMode() == TaskMode.AUTO_SCHEDULED || this.getDurationText() == null && this.getStartText() == null && this.getFinishText() == null);
    }

    private Date calculateCompleteThrough() {
        Date value = null;
        int percentComplete = NumberHelper.getInt(this.getPercentageComplete());
        switch (percentComplete) {
            case 0: {
                break;
            }
            case 100: {
                value = this.getActualFinish();
                break;
            }
            default: {
                Date actualStart = this.getActualStart();
                Duration duration = this.getDuration();
                if (actualStart == null || duration == null) break;
                double durationValue = duration.getDuration() * (double)percentComplete / 100.0;
                duration = Duration.getInstance(durationValue, duration.getUnits());
                ProjectCalendar calendar = this.getEffectiveCalendar();
                value = calendar.getDate(actualStart, duration, this.getParentFile().getProjectConfig().getCompleteThroughIsNextWorkStart());
                break;
            }
        }
        return value;
    }

    static {
        CALCULATED_FIELD_MAP.put(TaskField.PARENT_TASK_UNIQUE_ID, Task::getParentTaskUniqueID);
        CALCULATED_FIELD_MAP.put(TaskField.START_VARIANCE, Task::calculateStartVariance);
        CALCULATED_FIELD_MAP.put(TaskField.FINISH_VARIANCE, Task::calculateFinishVariance);
        CALCULATED_FIELD_MAP.put(TaskField.START_SLACK, Task::calculateStartSlack);
        CALCULATED_FIELD_MAP.put(TaskField.FINISH_SLACK, Task::calculateFinishSlack);
        CALCULATED_FIELD_MAP.put(TaskField.COST_VARIANCE, Task::calculateCostVariance);
        CALCULATED_FIELD_MAP.put(TaskField.DURATION_VARIANCE, Task::calculateDurationVariance);
        CALCULATED_FIELD_MAP.put(TaskField.WORK_VARIANCE, Task::calculateWorkVariance);
        CALCULATED_FIELD_MAP.put(TaskField.CV, Task::calculateCV);
        CALCULATED_FIELD_MAP.put(TaskField.SV, Task::calculateSV);
        CALCULATED_FIELD_MAP.put(TaskField.TOTAL_SLACK, Task::calculateTotalSlack);
        CALCULATED_FIELD_MAP.put(TaskField.CRITICAL, Task::calculateCritical);
        CALCULATED_FIELD_MAP.put(TaskField.COMPLETE_THROUGH, Task::calculateCompleteThrough);
        DEPENDENCY_MAP = new HashMap<FieldType, List<FieldType>>();
        FieldContainerDependencies<FieldType> dependencies = new FieldContainerDependencies<FieldType>(DEPENDENCY_MAP);
        dependencies.calculatedField(TaskField.START_VARIANCE).dependsOn((FieldType[])new FieldType[]{TaskField.START, TaskField.BASELINE_START});
        dependencies.calculatedField(TaskField.FINISH_VARIANCE).dependsOn((FieldType[])new FieldType[]{TaskField.FINISH, TaskField.BASELINE_FINISH});
        dependencies.calculatedField(TaskField.START_SLACK).dependsOn((FieldType[])new FieldType[]{TaskField.EARLY_START, TaskField.LATE_START});
        dependencies.calculatedField(TaskField.FINISH_SLACK).dependsOn((FieldType[])new FieldType[]{TaskField.EARLY_FINISH, TaskField.LATE_FINISH});
        dependencies.calculatedField(TaskField.COST_VARIANCE).dependsOn((FieldType[])new FieldType[]{TaskField.COST, TaskField.BASELINE_COST});
        dependencies.calculatedField(TaskField.DURATION_VARIANCE).dependsOn((FieldType[])new FieldType[]{TaskField.DURATION, TaskField.BASELINE_DURATION});
        dependencies.calculatedField(TaskField.WORK_VARIANCE).dependsOn((FieldType[])new FieldType[]{TaskField.WORK, TaskField.BASELINE_WORK});
        dependencies.calculatedField(TaskField.CV).dependsOn((FieldType[])new FieldType[]{TaskField.BCWP, TaskField.ACWP});
        dependencies.calculatedField(TaskField.SV).dependsOn((FieldType[])new FieldType[]{TaskField.BCWP, TaskField.BCWS});
        dependencies.calculatedField(TaskField.TOTAL_SLACK).dependsOn((FieldType[])new FieldType[]{TaskField.START_SLACK, TaskField.FINISH_SLACK});
        dependencies.calculatedField(TaskField.CRITICAL).dependsOn((FieldType[])new FieldType[]{TaskField.TOTAL_SLACK});
        dependencies.calculatedField(TaskField.COMPLETE_THROUGH).dependsOn((FieldType[])new FieldType[]{TaskField.DURATION, TaskField.ACTUAL_START, TaskField.PERCENT_COMPLETE});
    }
}

