/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.ArrayList;
import java.util.List;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkContainer;
import net.sf.mpxj.common.TimephasedWorkNormaliser;

public class DefaultTimephasedWorkContainer
implements TimephasedWorkContainer {
    private final List<TimephasedWork> m_data;
    private boolean m_raw;
    private final TimephasedWorkNormaliser m_normaliser;
    private final ProjectCalendar m_calendar;

    public DefaultTimephasedWorkContainer(ProjectCalendar calendar, TimephasedWorkNormaliser normaliser, List<TimephasedWork> data, boolean raw) {
        this.m_data = data;
        this.m_raw = raw;
        this.m_calendar = calendar;
        this.m_normaliser = normaliser;
    }

    private DefaultTimephasedWorkContainer(DefaultTimephasedWorkContainer source, double perDayFactor, double totalFactor) {
        this.m_data = new ArrayList<TimephasedWork>();
        this.m_raw = source.m_raw;
        this.m_calendar = source.m_calendar;
        this.m_normaliser = source.m_normaliser;
        for (TimephasedWork sourceItem : source.m_data) {
            this.m_data.add(new TimephasedWork(sourceItem, totalFactor, perDayFactor));
        }
    }

    @Override
    public List<TimephasedWork> getData() {
        if (this.m_raw) {
            this.m_normaliser.normalise(this.m_calendar, this.m_data);
            this.m_raw = false;
        }
        return this.m_data;
    }

    @Override
    public boolean hasData() {
        return !this.m_data.isEmpty();
    }

    @Override
    public TimephasedWorkContainer applyFactor(double perDayFactor, double totalFactor) {
        return new DefaultTimephasedWorkContainer(this, perDayFactor, totalFactor);
    }
}

