/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.ganttdesigner;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.Day;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDays;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Task;
import net.sf.mpxj.common.UnmarshalHelper;
import net.sf.mpxj.ganttdesigner.schema.Gantt;
import net.sf.mpxj.ganttdesigner.schema.GanttDesignerRemark;
import net.sf.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.SAXException;

public final class GanttDesignerReader
extends AbstractProjectStreamReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    Map<String, Task> m_taskMap;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_taskMap = new HashMap<String, Task>();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("GanttDesigner");
            this.m_projectFile.getProjectProperties().setFileType("GNT");
            this.addListenersToProject(this.m_projectFile);
            Gantt gantt = (Gantt)UnmarshalHelper.unmarshal(CONTEXT, stream);
            this.readProjectProperties(gantt);
            this.readCalendar(gantt);
            this.readTasks(gantt);
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (JAXBException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
            this.m_taskMap = null;
        }
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Collections.singletonList(this.read(inputStream));
    }

    private void readProjectProperties(Gantt gantt) {
        Gantt.File file = gantt.getFile();
        ProjectProperties props = this.m_projectFile.getProjectProperties();
        props.setLastSaved(file.getSaved());
        props.setCreationDate(file.getCreated());
        props.setName(file.getName());
    }

    private void readCalendar(Gantt gantt) {
        Gantt.Calendar ganttCalendar = gantt.getCalendar();
        this.m_projectFile.getProjectProperties().setWeekStartDay(ganttCalendar.getWeekStart());
        ProjectCalendar calendar = this.m_projectFile.addCalendar();
        calendar.setName("Standard");
        this.m_projectFile.setDefaultCalendar(calendar);
        String workingDays = ganttCalendar.getWorkDays();
        calendar.setWorkingDay(Day.SUNDAY, workingDays.charAt(0) == '1');
        calendar.setWorkingDay(Day.MONDAY, workingDays.charAt(1) == '1');
        calendar.setWorkingDay(Day.TUESDAY, workingDays.charAt(2) == '1');
        calendar.setWorkingDay(Day.WEDNESDAY, workingDays.charAt(3) == '1');
        calendar.setWorkingDay(Day.THURSDAY, workingDays.charAt(4) == '1');
        calendar.setWorkingDay(Day.FRIDAY, workingDays.charAt(5) == '1');
        calendar.setWorkingDay(Day.SATURDAY, workingDays.charAt(6) == '1');
        for (int i = 1; i <= 7; ++i) {
            Day day = Day.getInstance(i);
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            if (!calendar.isWorkingDay(day)) continue;
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_MORNING);
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_AFTERNOON);
        }
        for (Gantt.Holidays.Holiday holiday : gantt.getHolidays().getHoliday()) {
            ProjectCalendarException exception = calendar.addCalendarException(holiday.getDate());
            exception.setName(holiday.getContent());
        }
        this.m_eventManager.fireCalendarReadEvent(calendar);
    }

    private void readTasks(Gantt gantt) {
        this.processTasks(gantt);
        this.processPredecessors(gantt);
        this.processRemarks(gantt);
    }

    private void processTasks(Gantt gantt) {
        ProjectCalendar calendar = this.m_projectFile.getDefaultCalendar();
        for (Gantt.Tasks.Task ganttTask : gantt.getTasks().getTask()) {
            String wbs = ganttTask.getID();
            ChildTaskContainer parentTask = this.getParentTask(wbs);
            Task task = parentTask.addTask();
            task.setCost(ganttTask.getC());
            task.setName(ganttTask.getContent());
            task.setDuration(ganttTask.getD());
            task.setDeadline(ganttTask.getDL());
            task.setWBS(wbs);
            task.setPercentageComplete(ganttTask.getPC());
            task.setStart(ganttTask.getS());
            task.setFinish(calendar.getDate(task.getStart(), task.getDuration(), false));
            this.m_taskMap.put(wbs, task);
            this.m_eventManager.fireTaskReadEvent(task);
        }
    }

    private void processPredecessors(Gantt gantt) {
        for (Gantt.Tasks.Task ganttTask : gantt.getTasks().getTask()) {
            String predecessors = ganttTask.getP();
            if (predecessors == null || predecessors.isEmpty()) continue;
            String wbs = ganttTask.getID();
            Task task = this.m_taskMap.get(wbs);
            for (String predecessor : predecessors.split(";")) {
                Task predecessorTask = this.m_projectFile.getTaskByID(Integer.valueOf(predecessor));
                Relation relation = task.addPredecessor(predecessorTask, RelationType.FINISH_START, ganttTask.getL());
                this.m_eventManager.fireRelationReadEvent(relation);
            }
        }
    }

    private void processRemarks(Gantt gantt) {
        this.processRemarks(gantt.getRemarks());
        this.processRemarks(gantt.getRemarks1());
        this.processRemarks(gantt.getRemarks2());
        this.processRemarks(gantt.getRemarks3());
        this.processRemarks(gantt.getRemarks4());
    }

    private void processRemarks(GanttDesignerRemark remark) {
        for (GanttDesignerRemark.Task remarkTask : remark.getTask()) {
            Integer id = remarkTask.getRow();
            Task task = this.m_projectFile.getTaskByID(id);
            String notes = task.getNotes();
            notes = notes.isEmpty() ? remarkTask.getContent() : notes + '\n' + remarkTask.getContent();
            task.setNotes(notes);
        }
    }

    private String getParentWBS(String wbs) {
        int index = wbs.lastIndexOf(46);
        String result = index == -1 ? null : wbs.substring(0, index);
        return result;
    }

    private ChildTaskContainer getParentTask(String wbs) {
        String parentWbs = this.getParentWBS(wbs);
        ChildTaskContainer result = parentWbs == null ? this.m_projectFile : (ChildTaskContainer)this.m_taskMap.get(parentWbs);
        return result;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.ganttdesigner.schema", (ClassLoader)GanttDesignerReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

