/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.TableContainer;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.View;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.AvailabilityFactory;
import net.sf.mpxj.mpp.ConstraintFactory;
import net.sf.mpxj.mpp.CostRateTableFactory;
import net.sf.mpxj.mpp.CustomFieldReader14;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.CustomFieldValueReader14;
import net.sf.mpxj.mpp.DataLinkFactory;
import net.sf.mpxj.mpp.DocumentInputStreamFactory;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FieldMap14;
import net.sf.mpxj.mpp.FilterReader14;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GraphicalIndicatorReader;
import net.sf.mpxj.mpp.GroupReader14;
import net.sf.mpxj.mpp.HyperlinkReader;
import net.sf.mpxj.mpp.MPP14CalendarFactory;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.MppBitFlag;
import net.sf.mpxj.mpp.ProjectPropertiesReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props14;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.ResourceAssignmentFactory;
import net.sf.mpxj.mpp.TableFactory14;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;
import net.sf.mpxj.mpp.VarMeta12;
import net.sf.mpxj.mpp.ViewFactory14;
import net.sf.mpxj.mpp.ViewStateReader12;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class MPP14Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private EventManager m_eventManager;
    private DirectoryEntry m_root;
    private HashMap<Integer, ProjectCalendar> m_resourceMap;
    private Var2Data m_outlineCodeVarData;
    private VarMeta m_outlineCodeVarMeta;
    private FixedData m_outlineCodeFixedData;
    private FixedData m_outlineCodeFixedData2;
    private Props m_projectProps;
    private Map<Integer, FontBase> m_fontBases;
    private Map<Integer, SubProject> m_taskSubProjects;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private Map<Long, Integer> m_taskOrder;
    private Map<Integer, Integer> m_nullTaskOrder;
    private DocumentInputStreamFactory m_inputStreamFactory;
    private Map<Integer, Integer> m_parentTasks;
    private static final int SUBPROJECT_TASKUNIQUEID0 = 0;
    private static final int SUBPROJECT_TASKUNIQUEID1 = 187957248;
    private static final int SUBPROJECT_TASKUNIQUEID2 = 0xABB0000;
    private static final int SUBPROJECT_TASKUNIQUEID3 = 94437376;
    private static final int SUBPROJECT_TASKUNIQUEID4 = 198508544;
    private static final int SUBPROJECT_TASKUNIQUEID5 = 64356352;
    private static final int SUBPROJECT_TASKUNIQUEID6 = 108986368;
    private static final int SUBPROJECT_TASKUNIQUEID7 = 108855296;
    private static final int SUBPROJECT_TASKUNIQUEID8 = 0x540000;
    private static final Integer TABLE_COLUMN_DATA_STANDARD = 6;
    private static final Integer TABLE_COLUMN_DATA_ENTERPRISE = 7;
    private static final Integer TABLE_COLUMN_DATA_BASELINE = 8;
    private static final Integer OUTLINECODE_DATA = 22;
    private static final int VALUE_LIST_MASK = 1792;
    private static final int DURATION_CONFIRMED_MASK = 32;
    private static final Integer RESOURCE_FIELD_NAME_ALIASES = 0x4400001;
    private static final Integer TASK_FIELD_NAME_ALIASES = 0x4400001;
    private static final int TASK_UNIQUE_ID_FIXED_OFFSET = 0;
    private static final int TASK_ID_FIXED_OFFSET = 4;
    private static final int NULL_TASK_BLOCK_SIZE = 16;
    private static final MppBitFlag[] PROJECT2010_TASK_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.FLAG1, 35, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG2, 35, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG3, 35, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG4, 35, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG5, 35, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG6, 35, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG7, 35, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG8, 35, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG9, 35, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG10, 35, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG11, 35, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG12, 35, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG13, 35, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG14, 35, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG15, 35, 0x100000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG16, 35, 0x200000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG17, 35, 0x400000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG18, 35, 0x800000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG19, 35, 0x1000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG20, 35, 0x2000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MILESTONE, 8, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MARKED, 9, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.IGNORE_RESOURCE_CALENDAR, 10, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.ROLLUP, 10, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.HIDE_BAR, 10, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.EFFORT_DRIVEN, 11, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVEL_ASSIGNMENTS, 13, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVELING_CAN_SPLIT, 13, 2, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2013_TASK_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.FLAG1, 24, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG2, 24, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG3, 24, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG4, 24, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG5, 24, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG6, 24, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG7, 24, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG8, 24, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG9, 24, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG10, 24, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG11, 33, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG12, 33, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG13, 33, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG14, 33, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG15, 33, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG16, 33, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG17, 33, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG18, 33, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG19, 33, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG20, 33, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MILESTONE, 10, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MARKED, 12, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.ROLLUP, 12, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.HIDE_BAR, 12, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.EFFORT_DRIVEN, 13, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVEL_ASSIGNMENTS, 16, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVELING_CAN_SPLIT, 16, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.IGNORE_RESOURCE_CALENDAR, 17, 32, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2010_TASK_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.ACTIVE, 8, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.TASK_MODE, 8, 8, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2013_TASK_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.ACTIVE, 8, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.TASK_MODE, 8, 128, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2010_RESOURCE_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(ResourceField.BUDGET, 8, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.TYPE, 8, 16, ResourceType.MATERIAL, ResourceType.COST), new MppBitFlag(ResourceField.GENERIC, 32, 0x4000000, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2013_RESOURCE_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(ResourceField.BUDGET, 8, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.TYPE, 8, 16, ResourceType.MATERIAL, ResourceType.COST), new MppBitFlag(ResourceField.GENERIC, 32, 0x10000000, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2010_RESOURCE_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(ResourceField.FLAG10, 28, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG1, 28, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG2, 28, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG3, 28, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG4, 28, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG5, 28, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG6, 28, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG7, 28, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG8, 28, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG9, 28, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG11, 28, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG12, 28, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG13, 28, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG14, 28, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG15, 28, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG16, 28, 0x100000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG17, 28, 0x200000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG18, 28, 0x400000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG19, 28, 0x800000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG20, 28, 0x1000000, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2013_RESOURCE_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(ResourceField.FLAG10, 19, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG1, 19, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG2, 19, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG3, 19, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG4, 19, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG5, 19, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG6, 19, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG7, 19, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG8, 19, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG9, 19, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG11, 24, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG12, 24, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG13, 24, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG14, 24, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG15, 24, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG16, 24, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG17, 24, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG18, 24, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG19, 24, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG20, 24, 65536, Boolean.FALSE, Boolean.TRUE)};

    MPP14Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader reader, ProjectFile file, DirectoryEntry root) throws MPXJException, IOException {
        try {
            this.populateMemberData(reader, file, root);
            this.processProjectProperties();
            if (!reader.getReadPropertiesOnly()) {
                this.processSubProjectData();
                this.processGraphicalIndicators();
                this.processCustomValueLists();
                this.processCalendarData();
                this.processResourceData();
                this.processTaskData();
                this.processConstraintData();
                this.processAssignmentData();
                this.postProcessTasks();
                this.processDataLinks();
                if (reader.getReadPresentationData()) {
                    this.processViewPropertyData();
                    this.processTableData();
                    this.processViewData();
                    this.processFilterData();
                    this.processGroupData();
                    this.processSavedViewState();
                }
            }
        }
        finally {
            this.clearMemberData();
        }
    }

    private void populateMemberData(MPPReader reader, ProjectFile file, DirectoryEntry root) throws IOException, MPXJException {
        boolean encryptionXmlPresent;
        this.m_reader = reader;
        this.m_file = file;
        this.m_eventManager = file.getEventManager();
        this.m_root = root;
        Props14 props = new Props14((InputStream)new DocumentInputStream((DocumentEntry)root.getEntry("Props14")));
        file.getProjectProperties().setProjectFilePath(props.getUnicodeString(Props.PROJECT_FILE_PATH));
        this.m_inputStreamFactory = new DocumentInputStreamFactory(props);
        byte passwordProtectionFlag = props.getByte(Props.PASSWORD_FLAG);
        boolean passwordRequiredToRead = (passwordProtectionFlag & 1) != 0;
        boolean bl = encryptionXmlPresent = props.getByteArray(Props.PROTECTION_PASSWORD_HASH) != null;
        if (passwordRequiredToRead && encryptionXmlPresent) {
            throw new MPXJException("File is password protected");
        }
        this.m_resourceMap = new HashMap();
        this.m_projectDir = (DirectoryEntry)root.getEntry("   114");
        this.m_viewDir = (DirectoryEntry)root.getEntry("   214");
        DirectoryEntry outlineCodeDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
        this.m_outlineCodeVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("VarMeta")));
        this.m_outlineCodeVarData = new Var2Data(this.m_outlineCodeVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("Var2Data")));
        FixedMeta outlineCodeFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("FixedMeta")), 10);
        this.m_outlineCodeFixedData = new FixedData(outlineCodeFixedMeta, (InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("FixedData")));
        FixedMeta outlineCodeFixedMeta2 = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("Fixed2Meta")), 10);
        this.m_outlineCodeFixedData2 = new FixedData(outlineCodeFixedMeta2, (InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("Fixed2Data")));
        this.m_projectProps = new Props14(this.m_inputStreamFactory.getInstance(this.m_projectDir, "Props"));
        this.m_fontBases = new HashMap<Integer, FontBase>();
        this.m_taskSubProjects = new HashMap<Integer, SubProject>();
        this.m_taskOrder = new TreeMap<Long, Integer>();
        this.m_nullTaskOrder = new TreeMap<Integer, Integer>();
        this.m_parentTasks = new HashMap<Integer, Integer>();
        this.m_file.getProjectProperties().setMppFileType(14);
        this.m_file.getProjectProperties().setAutoFilter(props.getBoolean(Props.AUTO_FILTER));
    }

    private void clearMemberData() {
        this.m_reader = null;
        this.m_file = null;
        this.m_eventManager = null;
        this.m_root = null;
        this.m_resourceMap = null;
        this.m_projectDir = null;
        this.m_viewDir = null;
        this.m_outlineCodeVarData = null;
        this.m_fontBases = null;
        this.m_taskOrder = null;
        this.m_nullTaskOrder = null;
        this.m_taskSubProjects = null;
        this.m_outlineCodeVarMeta = null;
        this.m_projectProps = null;
        this.m_inputStreamFactory = null;
        this.m_parentTasks = null;
    }

    private void processCustomValueLists() throws IOException {
        this.processCustomValueLists((DirectoryEntry)this.m_projectDir.getEntry("TBkndTask"));
        this.processCustomValueLists((DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc"));
    }

    private void processCustomValueLists(DirectoryEntry dir) throws IOException {
        if (dir.hasEntry("Props")) {
            Props14 taskProps = new Props14(this.m_inputStreamFactory.getInstance(dir, "Props"));
            CustomFieldValueReader14 reader = new CustomFieldValueReader14(this.m_file.getProjectProperties(), this.m_file.getCustomFields(), this.m_outlineCodeVarMeta, this.m_outlineCodeVarData, this.m_outlineCodeFixedData, this.m_outlineCodeFixedData2, taskProps);
            reader.process();
        }
    }

    private void processProjectProperties() throws MPXJException {
        ProjectPropertiesReader reader = new ProjectPropertiesReader();
        reader.process(this.m_file, this.m_projectProps, this.m_root);
    }

    private void processGraphicalIndicators() {
        GraphicalIndicatorReader graphicalIndicatorReader = new GraphicalIndicatorReader();
        graphicalIndicatorReader.process(this.m_file.getCustomFields(), this.m_file.getProjectProperties(), this.m_projectProps);
    }

    private void processSubProjectData() {
        byte[] subProjData = this.m_projectProps.getByteArray(Props.SUBPROJECT_DATA);
        if (subProjData != null) {
            int index = 0;
            int offset = 0;
            byte[] itemHeader = new byte[20];
            offset += 4;
            int itemCountOffset = MPPUtility.getInt(subProjData, offset += 4);
            offset += 4;
            block16: while (offset < itemCountOffset) {
                ++index;
                int itemHeaderOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                offset += 4;
                MPPUtility.getByteArray(subProjData, itemHeaderOffset, itemHeader.length, itemHeader, 0);
                byte subProjectType = itemHeader[16];
                switch (subProjectType) {
                    case 0: 
                    case 16: {
                        offset += 8;
                        continue block16;
                    }
                    case -103: 
                    case 9: 
                    case 11: 
                    case 13: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        offset += 4;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -111: 
                    case 3: 
                    case 17: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -127: 
                    case -125: 
                    case 65: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 1: 
                    case 8: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -64: {
                        int uniqueIDOffset = itemHeaderOffset;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 5: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.m_file.getSubProjects().setResourceSubProject(this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index));
                        continue block16;
                    }
                    case 69: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        offset += 4;
                        this.m_file.getSubProjects().setResourceSubProject(this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index));
                        continue block16;
                    }
                    case 2: {
                        offset += 4;
                        offset += 4;
                        continue block16;
                    }
                    case 4: {
                        int filePathOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.m_file.getSubProjects().setResourceSubProject(this.readSubProject(subProjData, -1, filePathOffset, fileNameOffset, index));
                        continue block16;
                    }
                    case -119: 
                    case -115: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 8);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 8);
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 10: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 68: {
                        int filePathOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        offset += 4;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.readSubProjects(subProjData, -1, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -128: {
                        offset += 12;
                        continue block16;
                    }
                }
                offset += 12;
            }
        }
    }

    private void readSubProjects(byte[] data, int uniqueIDOffset, int filePathOffset, int fileNameOffset, int subprojectIndex) {
        while (uniqueIDOffset < filePathOffset) {
            this.readSubProject(data, uniqueIDOffset, filePathOffset, fileNameOffset, subprojectIndex++);
            uniqueIDOffset += 4;
        }
    }

    private SubProject readSubProject(byte[] data, int uniqueIDOffset, int filePathOffset, int fileNameOffset, int subprojectIndex) {
        try {
            SubProject sp = new SubProject();
            int type = 0;
            if (uniqueIDOffset != -1) {
                Integer taskUniqueID;
                int value = MPPUtility.getInt(data, uniqueIDOffset);
                type = MPPUtility.getInt(data, uniqueIDOffset + 4);
                Integer n = taskUniqueID = value == 0 || value > 0x1FFFFF ? null : Integer.valueOf(value);
                if (taskUniqueID != null) {
                    switch (type) {
                        case 0: 
                        case 0x540000: 
                        case 64356352: 
                        case 94437376: 
                        case 108855296: 
                        case 108986368: 
                        case 0xABB0000: 
                        case 187957248: 
                        case 198508544: {
                            sp.setTaskUniqueID(taskUniqueID);
                            this.m_taskSubProjects.put(taskUniqueID, sp);
                            break;
                        }
                        default: {
                            if (value == 0) break;
                            sp.addExternalTaskUniqueID(taskUniqueID);
                            this.m_taskSubProjects.put(taskUniqueID, sp);
                        }
                    }
                    value = 0x800000 + (subprojectIndex - 1) * 0x400000;
                    sp.setUniqueIDOffset(value);
                }
            }
            if (type == 198508544) {
                sp.setFullPath(MPPUtility.getUnicodeString(data, filePathOffset));
            } else {
                filePathOffset += 18;
                sp.setDosFullPath(MPPUtility.getString(data, filePathOffset += 4));
                filePathOffset += sp.getDosFullPath().length() + 1;
                int size = MPPUtility.getInt(data, filePathOffset += 24);
                filePathOffset += 4;
                if (size == 0) {
                    sp.setFullPath(sp.getDosFullPath());
                } else {
                    size = MPPUtility.getInt(data, filePathOffset);
                    filePathOffset += 4;
                    sp.setFullPath(MPPUtility.getUnicodeString(data, filePathOffset += 2, size));
                }
                fileNameOffset += 18;
                sp.setDosFileName(MPPUtility.getString(data, fileNameOffset += 4));
                fileNameOffset += sp.getDosFileName().length() + 1;
                size = MPPUtility.getInt(data, fileNameOffset += 24);
                fileNameOffset += 4;
                if (size == 0) {
                    sp.setFileName(sp.getDosFileName());
                } else {
                    size = MPPUtility.getInt(data, fileNameOffset);
                    fileNameOffset += 4;
                    sp.setFileName(MPPUtility.getUnicodeString(data, fileNameOffset += 2, size));
                }
            }
            this.m_file.getSubProjects().add(sp);
            return sp;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    private void processViewPropertyData() throws IOException {
        if (this.m_viewDir.hasEntry("Props")) {
            Props14 props = new Props14(this.m_inputStreamFactory.getInstance(this.m_viewDir, "Props"));
            byte[] data = props.getByteArray(Props.FONT_BASES);
            if (data != null) {
                this.processBaseFonts(data);
            }
            ProjectProperties properties = this.m_file.getProjectProperties();
            properties.setShowProjectSummaryTask(props.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
        }
    }

    private void processBaseFonts(byte[] data) {
        int offset = 0;
        int blockCount = MPPUtility.getShort(data, 0);
        offset += 2;
        for (int loop = 0; loop < blockCount; ++loop) {
            int size = MPPUtility.getShort(data, offset += 2);
            String name = MPPUtility.getUnicodeString(data, offset += 2);
            offset += 64;
            if (name.length() == 0) continue;
            FontBase fontBase = new FontBase(loop, name, size);
            this.m_fontBases.put(fontBase.getIndex(), fontBase);
        }
    }

    private TreeMap<Integer, Integer> createTaskMap(FieldMap fieldMap, FixedMeta taskFixedMeta, FixedData taskFixedData, FixedData taskFixed2Data, Var2Data taskVarData) {
        TreeMap<Integer, Integer> taskMap = new TreeMap<Integer, Integer>();
        int uniqueIdOffset = fieldMap.getFixedDataOffset(TaskField.UNIQUE_ID);
        int itemCount = taskFixedMeta.getAdjustedItemCount();
        for (int loop = itemCount - 1; loop > 2; --loop) {
            Integer key;
            int uniqueID;
            byte[] data = taskFixedData.getByteArrayValue(loop);
            byte[] data2 = taskFixed2Data.getByteArrayValue(loop);
            if (data == null || data2 == null) continue;
            byte[] metaData = taskFixedMeta.getByteArrayValue(loop);
            int flags = MPPUtility.getInt(metaData, 0);
            if ((flags & 2) != 0) {
                uniqueID = MPPUtility.getShort(data, 0);
                key = uniqueID;
                if (taskMap.containsKey(key)) continue;
                taskMap.put(key, null);
                continue;
            }
            if (data.length == 16) {
                uniqueID = MPPUtility.getInt(data, 0);
                key = uniqueID;
                if (taskMap.containsKey(key)) continue;
                taskMap.put(key, loop);
                continue;
            }
            int maxSize = fieldMap.getMaxFixedDataSize(0);
            if (maxSize != 0 && data.length * 100 / maxSize <= 75 || taskMap.containsKey(key = Integer.valueOf(uniqueID = MPPUtility.getInt(data, uniqueIdOffset))) && taskVarData.getVarMeta().getTypes(key).isEmpty() || taskMap.containsKey(key) && (flags & 4) != 0) continue;
            taskMap.put(key, loop);
        }
        return taskMap;
    }

    private TreeMap<Integer, Integer> createResourceMap(FieldMap fieldMap, FixedMeta rscFixedMeta, FixedData rscFixedData) {
        TreeMap<Integer, Integer> resourceMap = new TreeMap<Integer, Integer>();
        int itemCount = rscFixedMeta.getAdjustedItemCount();
        int maxFixedDataSize = fieldMap.getMaxFixedDataSize(0);
        int uniqueIdOffset = fieldMap.getFixedDataOffset(ResourceField.UNIQUE_ID);
        for (int loop = 0; loop < itemCount; ++loop) {
            Integer uniqueID;
            byte[] data = rscFixedData.getByteArrayValue(loop);
            if (data == null || data.length < maxFixedDataSize || resourceMap.containsKey(uniqueID = Integer.valueOf(MPPUtility.getShort(data, uniqueIdOffset)))) continue;
            resourceMap.put(uniqueID, loop);
        }
        return resourceMap;
    }

    private void processCalendarData() throws IOException {
        MPP14CalendarFactory factory = new MPP14CalendarFactory(this.m_file);
        factory.processCalendarData(this.m_projectDir, this.m_projectProps, this.m_inputStreamFactory, this.m_resourceMap);
    }

    private void processTaskData() throws IOException {
        MppBitFlag[] metaData2BitFlags;
        MppBitFlag[] metaDataBitFlags;
        FieldMap14 fieldMap = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap.createTaskFieldMap(this.m_projectProps);
        FieldMap14 enterpriseCustomFieldMap = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        enterpriseCustomFieldMap.createEnterpriseCustomFieldMap(this.m_projectProps, TaskField.class);
        DirectoryEntry taskDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        VarMeta12 taskVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("VarMeta")));
        Var2Data taskVarData = new Var2Data(taskVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("Var2Data")));
        FixedMeta taskFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixedMeta")), 47);
        FixedData taskFixedData = new FixedData(taskFixedMeta, (InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixedData")), fieldMap.getMaxFixedDataSize(0));
        FixedMeta taskFixed2Meta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("Fixed2Meta")), taskFixedData, 92, 93, 94, 95, 96);
        FixedData taskFixed2Data = new FixedData(taskFixed2Meta, (InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("Fixed2Data")));
        if (taskDir.hasEntry("Props")) {
            Props14 props = new Props14(this.m_inputStreamFactory.getInstance(taskDir, "Props"));
            new CustomFieldReader14(this.m_file.getCustomFields(), props.getByteArray(TASK_FIELD_NAME_ALIASES)).process();
        }
        TreeMap<Integer, Integer> taskMap = this.createTaskMap(fieldMap, taskFixedMeta, taskFixedData, taskFixed2Data, taskVarData);
        Integer[] uniqueIdArray = taskMap.keySet().toArray(new Integer[0]);
        boolean autoWBS = true;
        ArrayList<Task> externalTasks = new ArrayList<Task>();
        RecurringTaskReader recurringTaskReader = null;
        HyperlinkReader hyperlinkReader = new HyperlinkReader();
        if (NumberHelper.getInt(this.m_file.getProjectProperties().getApplicationVersion()) > 14) {
            metaDataBitFlags = PROJECT2013_TASK_META_DATA_BIT_FLAGS;
            metaData2BitFlags = PROJECT2013_TASK_META_DATA2_BIT_FLAGS;
        } else {
            metaDataBitFlags = PROJECT2010_TASK_META_DATA_BIT_FLAGS;
            metaData2BitFlags = PROJECT2010_TASK_META_DATA2_BIT_FLAGS;
        }
        for (Integer uniqueID : uniqueIdArray) {
            Integer calendarID;
            Task task;
            Integer offset = taskMap.get(uniqueID);
            if (!taskFixedData.isValidOffset(offset)) continue;
            byte[] data = taskFixedData.getByteArrayValue(offset);
            byte[] metaData = taskFixedMeta.getByteArrayValue(offset);
            Integer id = MPPUtility.getInt(data, fieldMap.getFixedDataOffset(TaskField.ID));
            if (data.length == 16) {
                Integer nullTaskID = MPPUtility.getInt(data, 4);
                if (this.m_nullTaskOrder.containsKey(nullTaskID)) continue;
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(MPPUtility.getInt(data, 0));
                task.setID(nullTaskID);
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
                continue;
            }
            if (data.length < fieldMap.getMaxFixedDataSize(0)) {
                byte[] newData = new byte[fieldMap.getMaxFixedDataSize(0) + 8];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            byte[] metaData2 = taskFixed2Meta.getByteArrayValue(offset);
            byte[] data2 = taskFixed2Data.getByteArrayValue(offset);
            byte[] recurringData = taskVarData.getByteArray(uniqueID, fieldMap.getVarDataKey(TaskField.RECURRING_DATA));
            Task temp = this.m_file.getTaskByID(id);
            if (temp != null) {
                if (!taskVarMeta.getUniqueIdentifierSet().contains(uniqueID)) continue;
                if (temp.getName() == null) {
                    this.m_file.removeTask(temp);
                }
            }
            task = this.m_file.addTask();
            task.disableEvents();
            fieldMap.populateContainer(TaskField.class, task, uniqueID, new byte[][]{data, data2}, taskVarData);
            enterpriseCustomFieldMap.populateContainer(TaskField.class, task, uniqueID, null, taskVarData);
            task.enableEvents();
            task.setEstimated(this.getDurationEstimated(MPPUtility.getShort(data, fieldMap.getFixedDataOffset(TaskField.ACTUAL_DURATION_UNITS))));
            Integer externalTaskID = task.getSubprojectTaskID();
            if (externalTaskID != null && externalTaskID != 0) {
                task.setExternalTask(true);
                externalTasks.add(task);
            }
            hyperlinkReader.read(task, taskVarData.getByteArray(uniqueID, fieldMap.getVarDataKey(TaskField.HYPERLINK_DATA)));
            task.setID(id);
            task.setOutlineCode(1, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE1_INDEX)));
            task.setOutlineCode(2, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE2_INDEX)));
            task.setOutlineCode(3, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE3_INDEX)));
            task.setOutlineCode(4, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE4_INDEX)));
            task.setOutlineCode(5, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE5_INDEX)));
            task.setOutlineCode(6, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE6_INDEX)));
            task.setOutlineCode(7, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE7_INDEX)));
            task.setOutlineCode(8, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE8_INDEX)));
            task.setOutlineCode(9, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE9_INDEX)));
            task.setOutlineCode(10, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, uniqueID, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE10_INDEX)));
            task.setRecurring(MPPUtility.getShort(data, 40) == 2);
            task.setUniqueID(uniqueID);
            task.setExpanded((metaData[12] & 2) == 0);
            this.readBitFields(metaDataBitFlags, task, metaData);
            this.readBitFields(metaData2BitFlags, task, metaData2);
            task.setTaskMode(BooleanHelper.getBoolean((Boolean)task.getCachedValue(TaskField.TASK_MODE)) ? TaskMode.MANUALLY_SCHEDULED : TaskMode.AUTO_SCHEDULED);
            this.m_parentTasks.put(task.getUniqueID(), (Integer)task.getCachedValue(TaskField.PARENT_TASK_UNIQUE_ID));
            if (task.getStart() == null || task.getCachedValue(TaskField.SCHEDULED_START) != null && task.getTaskMode() == TaskMode.AUTO_SCHEDULED) {
                task.setStart((Date)task.getCachedValue(TaskField.SCHEDULED_START));
            }
            if (task.getFinish() == null || task.getCachedValue(TaskField.SCHEDULED_FINISH) != null && task.getTaskMode() == TaskMode.AUTO_SCHEDULED) {
                task.setFinish((Date)task.getCachedValue(TaskField.SCHEDULED_FINISH));
            }
            if (task.getDuration() == null || task.getCachedValue(TaskField.SCHEDULED_DURATION) != null && task.getTaskMode() == TaskMode.AUTO_SCHEDULED) {
                task.setDuration((Duration)task.getCachedValue(TaskField.SCHEDULED_DURATION));
            }
            switch (task.getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    if (DateHelper.compare(task.getStart(), task.getLateStart()) < 0) {
                        task.setStart(task.getLateStart());
                    }
                    if (DateHelper.compare(task.getFinish(), task.getLateFinish()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
                case START_NO_LATER_THAN: 
                case FINISH_NO_LATER_THAN: {
                    if (DateHelper.compare(task.getFinish(), task.getStart()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
            }
            if (recurringData != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file.getProjectProperties());
                }
                recurringTaskReader.processRecurringTask(task, recurringData);
                task.setRecurring(true);
            }
            if ((calendarID = (Integer)task.getCachedValue(TaskField.CALENDAR_UNIQUE_ID)) != null) {
                if (calendarID == -1) {
                    task.setCalendarUniqueID(null);
                } else {
                    ProjectCalendar calendar = this.m_file.getCalendarByUniqueID(calendarID);
                    if (calendar != null) {
                        task.setCalendar(calendar);
                    }
                }
            }
            SubProject sp = this.m_taskSubProjects.get(task.getUniqueID());
            task.setSubProject(sp);
            if (sp != null) {
                task.setExternalTask(sp.isExternalTask(task.getUniqueID()));
                if (task.getExternalTask()) {
                    task.setExternalTaskProject(sp.getFullPath());
                }
            }
            if (task.getWBS() != null) {
                autoWBS = false;
            }
            if (task.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
                task.setDuration(task.getManualDuration());
            } else {
                task.setManualDuration(null);
            }
            this.processTaskEnterpriseColumns(task, metaData2);
            if (task.getName() == null && (task.getStart() == null || task.getStart().getTime() == MPPUtility.getEpochDate().getTime() || task.getFinish() == null || task.getFinish().getTime() == MPPUtility.getEpochDate().getTime() || task.getCreateDate() == null || task.getCreateDate().getTime() == MPPUtility.getEpochDate().getTime())) {
                this.m_file.removeTask(task);
                Integer nullTaskID = MPPUtility.getInt(data, 4);
                if (this.m_nullTaskOrder.containsKey(nullTaskID)) continue;
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(MPPUtility.getInt(data, 0));
                task.setID(nullTaskID);
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
                continue;
            }
            if (data2 == null || data2.length < 24) {
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
            } else {
                Long key = MPPUtility.getLong(data2, 16);
                this.m_taskOrder.put(key, task.getUniqueID());
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.m_file.getProjectConfig().setAutoWBS(autoWBS);
        if (!externalTasks.isEmpty()) {
            this.processExternalTasks(externalTasks);
        }
    }

    private void postProcessTasks() throws MPXJException {
        TreeMap<Integer, Integer> taskMap = new TreeMap<Integer, Integer>();
        int nextIDIncrement = (this.m_nullTaskOrder.size() / 1000 + 1) * 2000;
        int nextID = this.m_file.getTaskByUniqueID(0) == null ? nextIDIncrement : 0;
        for (Map.Entry<Long, Integer> entry : this.m_taskOrder.entrySet()) {
            taskMap.put(nextID, entry.getValue());
            nextID += nextIDIncrement;
        }
        int insertionCount = 0;
        HashMap<Integer, Integer> offsetMap = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : this.m_nullTaskOrder.entrySet()) {
            int baseTargetIdValue;
            int idValue = entry.getKey();
            int targetIDValue = baseTargetIdValue = (idValue - insertionCount) * nextIDIncrement;
            Integer previousOffsetKey = baseTargetIdValue;
            Integer previousOffset = (Integer)offsetMap.get(previousOffsetKey);
            int offset = previousOffset == null ? 0 : previousOffset + 1;
            ++insertionCount;
            while (taskMap.containsKey(targetIDValue)) {
                if (++offset == nextIDIncrement) {
                    throw new MPXJException("Unable to fix task order");
                }
                targetIDValue = baseTargetIdValue - (nextIDIncrement - offset);
            }
            offsetMap.put(previousOffsetKey, offset);
            taskMap.put(targetIDValue, entry.getValue());
        }
        nextID = this.m_file.getTaskByUniqueID(0) == null ? 1 : 0;
        for (Map.Entry<Integer, Integer> entry : taskMap.entrySet()) {
            Task task = this.m_file.getTaskByUniqueID(entry.getValue());
            if (task != null) {
                task.setID(nextID);
            }
            ++nextID;
        }
    }

    private void processTaskEnterpriseColumns(Task task, byte[] metaData2) {
        if (metaData2 != null) {
            int bits = MPPUtility.getInt(metaData2, 29);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG1, (bits & 0x800) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG2, (bits & 0x1000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG3, (bits & 0x2000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG4, (bits & 0x4000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG5, (bits & 0x8000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG6, (bits & 0x1000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG7, (bits & 0x2000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG8, (bits & 0x4000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG9, (bits & 0x8000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG10, (bits & 0x10000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG11, (bits & 0x20000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG12, (bits & 0x40000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG13, (bits & 0x80000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG14, (bits & 0x100000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG15, (bits & 0x200000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG16, (bits & 0x400000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG17, (bits & 0x800000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG18, (bits & 0x1000000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG19, (bits & 0x2000000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG20, (bits & 0x4000000) != 0 ? 1 : 0);
        }
    }

    private void processResourceEnterpriseColumns(Resource resource, byte[] metaData2) {
        if (metaData2 != null) {
            int bits = MPPUtility.getInt(metaData2, 16);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG1, (bits & 0x10) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG2, (bits & 0x20) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG3, (bits & 0x40) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG4, (bits & 0x80) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG5, (bits & 0x100) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG6, (bits & 0x200) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG7, (bits & 0x400) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG8, (bits & 0x800) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG9, (bits & 0x1000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG10, (bits & 0x2000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG11, (bits & 0x4000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG12, (bits & 0x8000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG13, (bits & 0x10000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG14, (bits & 0x20000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG15, (bits & 0x40000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG16, (bits & 0x80000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG17, (bits & 0x100000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG18, (bits & 0x200000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG19, (bits & 0x400000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG20, (bits & 0x800000) != 0 ? 1 : 0);
            bits = MPPUtility.getShort(metaData2, 48);
            resource.set((FieldType)ResourceField.ENTERPRISE, (bits & 0x20) != 0 ? 1 : 0);
        }
    }

    private void processExternalTasks(List<Task> externalTasks) {
        Collections.sort(externalTasks);
        SubProject currentSubProject = null;
        for (Task currentTask : externalTasks) {
            SubProject sp = currentTask.getSubProject();
            if (sp == null) {
                currentTask.setSubProject(currentSubProject);
                if (currentSubProject != null) {
                    currentTask.setExternalTaskProject(currentSubProject.getFullPath());
                }
            } else {
                currentSubProject = sp;
            }
            if (currentSubProject == null) continue;
            currentTask.setProject(currentSubProject.getFullPath());
        }
    }

    private void processConstraintData() throws IOException {
        ConstraintFactory factory = new ConstraintFactory();
        factory.process(this.m_projectDir, this.m_file, this.m_inputStreamFactory);
    }

    private void processResourceData() throws IOException {
        MppBitFlag[] metaData2BitFlags;
        MppBitFlag[] metaDataBitFlags;
        int resourceTypeMask;
        int resourceTypeOffset;
        FieldMap14 fieldMap = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap.createResourceFieldMap(this.m_projectProps);
        FieldMap14 enterpriseCustomFieldMap = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        enterpriseCustomFieldMap.createEnterpriseCustomFieldMap(this.m_projectProps, ResourceField.class);
        DirectoryEntry rscDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        VarMeta12 rscVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("VarMeta")));
        Var2Data rscVarData = new Var2Data(rscVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("Var2Data")));
        FixedMeta rscFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("FixedMeta")), 37);
        FixedData rscFixedData = new FixedData(rscFixedMeta, this.m_inputStreamFactory.getInstance(rscDir, "FixedData"));
        FixedMeta rscFixed2Meta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("Fixed2Meta")), 50);
        FixedData rscFixed2Data = new FixedData(rscFixed2Meta, this.m_inputStreamFactory.getInstance(rscDir, "Fixed2Data"));
        if (rscDir.hasEntry("Props")) {
            Props14 props = new Props14(this.m_inputStreamFactory.getInstance(rscDir, "Props"));
            new CustomFieldReader14(this.m_file.getCustomFields(), props.getByteArray(RESOURCE_FIELD_NAME_ALIASES)).process();
        }
        TreeMap<Integer, Integer> resourceMap = this.createResourceMap(fieldMap, rscFixedMeta, rscFixedData);
        Integer[] uniqueid = rscVarMeta.getUniqueIdentifierArray();
        HyperlinkReader hyperlinkReader = new HyperlinkReader();
        if (NumberHelper.getInt(this.m_file.getProjectProperties().getApplicationVersion()) > 14) {
            resourceTypeOffset = 12;
            resourceTypeMask = 16;
            metaDataBitFlags = PROJECT2013_RESOURCE_META_DATA_BIT_FLAGS;
            metaData2BitFlags = PROJECT2013_RESOURCE_META_DATA2_BIT_FLAGS;
        } else {
            resourceTypeOffset = 9;
            resourceTypeMask = 2;
            metaDataBitFlags = PROJECT2010_RESOURCE_META_DATA_BIT_FLAGS;
            metaData2BitFlags = PROJECT2010_RESOURCE_META_DATA2_BIT_FLAGS;
        }
        for (Integer id : uniqueid) {
            Integer offset = resourceMap.get(id);
            if (offset == null) continue;
            byte[] data = rscFixedData.getByteArrayValue(offset);
            byte[] metaData2 = rscFixed2Meta.getByteArrayValue(offset);
            byte[] data2 = rscFixed2Data.getByteArrayValue(offset);
            Resource resource = this.m_file.addResource();
            resource.disableEvents();
            fieldMap.populateContainer(ResourceField.class, resource, id, new byte[][]{data, data2}, rscVarData);
            enterpriseCustomFieldMap.populateContainer(ResourceField.class, resource, id, null, rscVarData);
            resource.enableEvents();
            hyperlinkReader.read(resource, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.HYPERLINK_DATA)));
            resource.setID(MPPUtility.getInt(data, fieldMap.getFixedDataOffset(ResourceField.ID)));
            resource.setOutlineCode(1, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE1_INDEX)));
            resource.setOutlineCode(2, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE2_INDEX)));
            resource.setOutlineCode(3, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE3_INDEX)));
            resource.setOutlineCode(4, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE4_INDEX)));
            resource.setOutlineCode(5, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE5_INDEX)));
            resource.setOutlineCode(6, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE6_INDEX)));
            resource.setOutlineCode(7, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE7_INDEX)));
            resource.setOutlineCode(8, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE8_INDEX)));
            resource.setOutlineCode(9, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE9_INDEX)));
            resource.setOutlineCode(10, this.getCustomFieldOutlineCodeValue(rscVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE10_INDEX)));
            byte[] metaData = rscFixedMeta.getByteArrayValue(offset);
            this.readBitFields(metaDataBitFlags, resource, metaData);
            this.readBitFields(metaData2BitFlags, resource, metaData2);
            resource.setUniqueID(id);
            resource.setCalendar(this.m_resourceMap.get(id));
            this.processResourceEnterpriseColumns(resource, metaData2);
            MPPUtility.convertRateFromHours(this.m_file, resource, ResourceField.STANDARD_RATE, ResourceField.STANDARD_RATE_UNITS);
            MPPUtility.convertRateFromHours(this.m_file, resource, ResourceField.OVERTIME_RATE, ResourceField.OVERTIME_RATE_UNITS);
            CostRateTableFactory crt = new CostRateTableFactory(this.m_file);
            crt.process(resource, 0, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_A)));
            crt.process(resource, 1, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_B)));
            crt.process(resource, 2, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_C)));
            crt.process(resource, 3, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_D)));
            crt.process(resource, 4, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_E)));
            AvailabilityFactory af = new AvailabilityFactory();
            af.process(resource.getAvailability(), rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.AVAILABILITY_DATA)));
            if ((metaData[resourceTypeOffset] & resourceTypeMask) != 0) {
                resource.setType(ResourceType.WORK);
            } else if ((metaData2[8] & 0x10) != 0) {
                resource.setType(ResourceType.COST);
            } else {
                resource.setType(ResourceType.MATERIAL);
            }
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        FieldMap14 fieldMap = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap.createAssignmentFieldMap(this.m_projectProps);
        FieldMap14 enterpriseCustomFieldMap = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        enterpriseCustomFieldMap.createEnterpriseCustomFieldMap(this.m_projectProps, AssignmentField.class);
        DirectoryEntry assnDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        VarMeta12 assnVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("VarMeta")));
        Var2Data assnVarData = new Var2Data(assnVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("Var2Data")));
        FixedMeta assnFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("FixedMeta")), 34);
        FixedData assnFixedData = new FixedData(110, this.m_inputStreamFactory.getInstance(assnDir, "FixedData"));
        FixedData assnFixedData2 = new FixedData(48, this.m_inputStreamFactory.getInstance(assnDir, "Fixed2Data"));
        ResourceAssignmentFactory factory = new ResourceAssignmentFactory();
        factory.process(this.m_file, fieldMap, enterpriseCustomFieldMap, this.m_reader.getUseRawTimephasedData(), assnVarMeta, assnVarData, assnFixedMeta, assnFixedData, assnFixedData2, assnFixedMeta.getItemCount());
    }

    private boolean getDurationEstimated(int type) {
        return (type & 0x20) != 0;
    }

    private void processViewData() throws IOException {
        if (this.m_viewDir.hasEntry("CV_iew")) {
            DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
            VarMeta12 viewVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
            Var2Data viewVarData = new Var2Data(viewVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
            FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
            FixedData fixedData = new FixedData(138, this.m_inputStreamFactory.getInstance(dir, "FixedData"));
            int items = fixedMeta.getAdjustedItemCount();
            ViewFactory14 factory = new ViewFactory14();
            int lastOffset = -1;
            for (int loop = 0; loop < items; ++loop) {
                byte[] fm = fixedMeta.getByteArrayValue(loop);
                int offset = MPPUtility.getShort(fm, 4);
                if (offset <= lastOffset) continue;
                byte[] fd = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(offset));
                if (fd != null) {
                    View view = factory.createView(this.m_file, fm, fd, viewVarData, this.m_fontBases);
                    this.m_file.getViews().add(view);
                }
                lastOffset = offset;
            }
        }
    }

    private void processTableData() throws IOException {
        if (this.m_viewDir.hasEntry("CTable")) {
            DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
            VarMeta12 varMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
            Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
            FixedData fixedData = new FixedData(230, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedData")));
            TableContainer container = this.m_file.getTables();
            TableFactory14 factory = new TableFactory14(TABLE_COLUMN_DATA_STANDARD, TABLE_COLUMN_DATA_ENTERPRISE, TABLE_COLUMN_DATA_BASELINE);
            int items = fixedData.getItemCount();
            for (int loop = 0; loop < items; ++loop) {
                byte[] data = fixedData.getByteArrayValue(loop);
                Table table = factory.createTable(this.m_file, data, varMeta, varData);
                container.add(table);
            }
        }
    }

    private void processFilterData() throws IOException {
        if (this.m_viewDir.hasEntry("CFilter")) {
            Var2Data varData;
            FixedData fixedData;
            DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CFilter");
            try {
                FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
                fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(dir, "FixedData"));
                VarMeta12 varMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
                varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
            }
            catch (IOException | IndexOutOfBoundsException | NoSuchElementException ex) {
                return;
            }
            FilterReader14 reader = new FilterReader14();
            reader.process(this.m_file.getProjectProperties(), this.m_file.getFilters(), fixedData, varData);
        }
    }

    private void processSavedViewState() throws IOException {
        if (this.m_viewDir.hasEntry("CEdl")) {
            DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
            VarMeta12 varMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
            Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
            DocumentInputStream is = new DocumentInputStream((DocumentEntry)dir.getEntry("FixedData"));
            byte[] fixedData = InputStreamHelper.read((InputStream)is, is.available());
            is.close();
            ViewStateReader12 reader = new ViewStateReader12();
            reader.process(this.m_file, varData, fixedData);
        }
    }

    private void processGroupData() throws IOException {
        if (this.m_viewDir.hasEntry("CGrouping")) {
            DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CGrouping");
            FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
            FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(dir, "FixedData"));
            VarMeta12 varMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
            Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
            GroupReader14 reader = new GroupReader14();
            reader.process(this.m_file, fixedData, varData, this.m_fontBases);
        }
    }

    private void processDataLinks() throws IOException {
        if (this.m_viewDir.hasEntry("CEdl")) {
            DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
            FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 11);
            FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(dir, "FixedData"));
            VarMeta12 varMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
            Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
            DataLinkFactory factory = new DataLinkFactory(this.m_file, fixedData, varData);
            factory.process();
        }
    }

    private String getCustomFieldOutlineCodeValue(Var2Data varData, Var2Data outlineCodeVarData, Integer id, Integer type) {
        String result = null;
        int mask = varData.getShort(id, type);
        if ((mask & 0xFF00) != 1792) {
            result = outlineCodeVarData.getUnicodeString(varData.getInt(id, 2, type), OUTLINECODE_DATA);
        } else {
            int uniqueId = varData.getInt(id, 2, type);
            CustomFieldValueItem item = this.m_file.getCustomFields().getCustomFieldValueItemByUniqueID(uniqueId);
            if (item != null) {
                Object value = item.getValue();
                if (value instanceof String) {
                    result = (String)value;
                }
                String result2 = this.getCustomFieldOutlineCodeValue(varData, outlineCodeVarData, item.getParent());
                if (result != null && result2 != null && !result2.isEmpty()) {
                    result = result2 + "." + result;
                }
            }
        }
        return result;
    }

    private String getCustomFieldOutlineCodeValue(Var2Data varData, Var2Data outlineCodeVarData, Integer id) {
        String result = null;
        int uniqueId = id;
        if (uniqueId == 0) {
            return "";
        }
        CustomFieldValueItem item = this.m_file.getCustomFields().getCustomFieldValueItemByUniqueID(uniqueId);
        if (item != null) {
            String result2;
            Object value = item.getValue();
            if (value instanceof String) {
                result = (String)value;
            }
            if (result != null && !NumberHelper.equals(id, item.getParent()) && (result2 = this.getCustomFieldOutlineCodeValue(varData, outlineCodeVarData, item.getParent())) != null && !result2.isEmpty()) {
                result = result2 + "." + result;
            }
        }
        return result;
    }

    private void readBitFields(MppBitFlag[] flags, FieldContainer container, byte[] data) {
        for (MppBitFlag flag : flags) {
            flag.setValue(container, data);
        }
    }
}

