/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.mpp.MPPAbstractTimephasedWorkNormaliser;

public class MPPTimephasedBaselineWorkNormaliser
extends MPPAbstractTimephasedWorkNormaliser {
    @Override
    protected void mergeSameDay(ProjectCalendar calendar, List<TimephasedWork> list) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        TimephasedItem previousAssignment = null;
        for (TimephasedWork assignment : list) {
            if (previousAssignment != null) {
                Date previousAssignmentStart = previousAssignment.getStart();
                Date previousAssignmentStartDay = DateHelper.getDayStartDate(previousAssignmentStart);
                Date assignmentStart = assignment.getStart();
                Date assignmentStartDay = DateHelper.getDayStartDate(assignmentStart);
                if (previousAssignmentStartDay.getTime() == assignmentStartDay.getTime()) {
                    result.remove(result.size() - 1);
                    double work = ((Duration)previousAssignment.getTotalAmount()).getDuration();
                    Duration totalWork = Duration.getInstance(work += ((Duration)assignment.getTotalAmount()).getDuration(), TimeUnit.MINUTES);
                    TimephasedWork merged = new TimephasedWork();
                    merged.setStart(previousAssignment.getStart());
                    merged.setFinish(assignment.getFinish());
                    merged.setTotalAmount(totalWork);
                    assignment = merged;
                }
            }
            assignment.setAmountPerDay(assignment.getTotalAmount());
            result.add(assignment);
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }
}

