/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.CalendarType;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.CustomFieldValueDataType;
import net.sf.mpxj.CustomFieldValueMask;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.DefaultTimephasedWorkContainer;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.MPPAssignmentField;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.common.SplitTaskFactory;
import net.sf.mpxj.common.TimephasedWorkNormaliser;
import net.sf.mpxj.common.UnmarshalHelper;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.MSPDITimephasedWorkNormaliser;
import net.sf.mpxj.mspdi.NamespaceFilter;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MSPDIReader
extends AbstractProjectStreamReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private boolean m_compatibleInput = true;
    private String m_encoding;
    private Charset m_charset;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Map<UUID, FieldType> m_lookupTableMap;
    private Map<FieldType, Map<BigInteger, CustomFieldValueItem>> m_customFieldValueItems;
    private static final RecurrenceType[] RECURRENCE_TYPES;
    private static final boolean[] RELATIVE_MAP;
    private static final int[] DAY_MASKS;

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    @Override
    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    private Charset getCharset() {
        Charset result = this.m_charset;
        if (result == null) {
            result = this.m_encoding == null ? CharsetHelper.UTF8 : Charset.forName(this.m_encoding);
        }
        return result;
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_lookupTableMap = new HashMap<UUID, FieldType>();
            this.m_customFieldValueItems = new HashMap<FieldType, Map<BigInteger, CustomFieldValueItem>>();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoTaskID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            this.addListenersToProject(this.m_projectFile);
            DatatypeConverter.setParentFile(this.m_projectFile);
            Project project = (Project)UnmarshalHelper.unmarshal(CONTEXT, new InputSource(new InputStreamReader(stream, this.getCharset())), new NamespaceFilter(), !this.m_compatibleInput);
            HashMap<BigInteger, ProjectCalendar> calendarMap = new HashMap<BigInteger, ProjectCalendar>();
            this.readProjectProperties(project);
            this.readExtendedAttributeDefinitions(project);
            this.readOutlineCodeDefinitions(project);
            this.readCalendars(project, calendarMap);
            this.readResources(project, calendarMap);
            this.readTasks(project);
            this.readAssignments(project);
            config.updateUniqueCounters();
            this.m_projectFile.getCalendars().removeIf(c -> c.isDerived() && c.getResourceCount() == 0);
            for (Resource resource : this.m_projectFile.getResources()) {
                ProjectCalendar calendar = resource.getCalendar();
                if (calendar == null) continue;
                if (calendar.isDerived()) {
                    calendar.setType(CalendarType.RESOURCE);
                    calendar.setPersonal(calendar.getResourceCount() == 1);
                }
                if (calendar.getName() != null && !calendar.getName().isEmpty()) continue;
                String name = resource.getName();
                if (name == null || name.isEmpty()) {
                    name = "Unnamed Resource";
                }
                calendar.setName(name);
            }
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_lookupTableMap = null;
            this.m_customFieldValueItems = null;
        }
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Collections.singletonList(this.read(inputStream));
    }

    private void readProjectProperties(Project project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setActualsInSync(BooleanHelper.getBoolean(project.isActualsInSync()));
        properties.setAdminProject(BooleanHelper.getBoolean(project.isAdminProject()));
        properties.setApplicationVersion(NumberHelper.getInteger(project.getSaveVersion()));
        properties.setAuthor(project.getAuthor());
        properties.setAutoAddNewResourcesAndTasks(BooleanHelper.getBoolean(project.isAutoAddNewResourcesAndTasks()));
        properties.setAutolink(BooleanHelper.getBoolean(project.isAutolink()));
        properties.setBaselineForEarnedValue(NumberHelper.getInteger(project.getBaselineForEarnedValue()));
        properties.setCategory(project.getCategory());
        properties.setCompany(project.getCompany());
        properties.setCreationDate(project.getCreationDate());
        properties.setCriticalSlackLimit(NumberHelper.getInteger(project.getCriticalSlackLimit()));
        properties.setCurrencyDigits(NumberHelper.getInteger(project.getCurrencyDigits()));
        properties.setCurrencyCode(project.getCurrencyCode());
        properties.setCurrencySymbol(project.getCurrencySymbol());
        properties.setCurrentDate(project.getCurrentDate());
        properties.setDaysPerMonth(NumberHelper.getInteger(project.getDaysPerMonth()));
        properties.setDefaultDurationUnits(DatatypeConverter.parseDurationTimeUnits(project.getDurationFormat()));
        properties.setDefaultEndTime(project.getDefaultFinishTime());
        properties.setDefaultFixedCostAccrual(project.getDefaultFixedCostAccrual());
        properties.setDefaultOvertimeRate(DatatypeConverter.parseRate(project.getDefaultOvertimeRate(), TimeUnit.HOURS));
        properties.setDefaultStandardRate(DatatypeConverter.parseRate(project.getDefaultStandardRate(), TimeUnit.HOURS));
        properties.setDefaultStartTime(project.getDefaultStartTime());
        properties.setDefaultTaskEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getDefaultTaskEVMethod()));
        properties.setDefaultTaskType(project.getDefaultTaskType());
        properties.setDefaultWorkUnits(DatatypeConverter.parseWorkUnits(project.getWorkFormat()));
        properties.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getEarnedValueMethod()));
        properties.setEditableActualCosts(BooleanHelper.getBoolean(project.isEditableActualCosts()));
        properties.setExtendedCreationDate(project.getExtendedCreationDate());
        properties.setFinishDate(project.getFinishDate());
        properties.setFiscalYearStart(BooleanHelper.getBoolean(project.isFiscalYearStart()));
        properties.setFiscalYearStartMonth(NumberHelper.getInteger(project.getFYStartDate()));
        properties.setGUID(project.getGUID());
        properties.setHonorConstraints(BooleanHelper.getBoolean(project.isHonorConstraints()));
        properties.setInsertedProjectsLikeSummary(BooleanHelper.getBoolean(project.isInsertedProjectsLikeSummary()));
        properties.setLastSaved(project.getLastSaved());
        properties.setManager(project.getManager());
        properties.setMicrosoftProjectServerURL(BooleanHelper.getBoolean(project.isMicrosoftProjectServerURL()));
        properties.setMinutesPerDay(NumberHelper.getInteger(project.getMinutesPerDay()));
        properties.setMinutesPerWeek(NumberHelper.getInteger(project.getMinutesPerWeek()));
        properties.setMoveCompletedEndsBack(BooleanHelper.getBoolean(project.isMoveCompletedEndsBack()));
        properties.setMoveCompletedEndsForward(BooleanHelper.getBoolean(project.isMoveCompletedEndsForward()));
        properties.setMoveRemainingStartsBack(BooleanHelper.getBoolean(project.isMoveRemainingStartsBack()));
        properties.setMoveRemainingStartsForward(BooleanHelper.getBoolean(project.isMoveRemainingStartsForward()));
        properties.setMultipleCriticalPaths(BooleanHelper.getBoolean(project.isMultipleCriticalPaths()));
        properties.setName(project.getName());
        properties.setNewTasksEffortDriven(BooleanHelper.getBoolean(project.isNewTasksEffortDriven()));
        properties.setNewTasksEstimated(BooleanHelper.getBoolean(project.isNewTasksEstimated()));
        properties.setNewTaskStartIsProjectStart(NumberHelper.getInt(project.getNewTaskStartDate()) == 0);
        properties.setNewTasksAreManual(BooleanHelper.getBoolean(project.isNewTasksAreManual()));
        properties.setProjectExternallyEdited(BooleanHelper.getBoolean(project.isProjectExternallyEdited()));
        properties.setProjectTitle(project.getTitle());
        properties.setRemoveFileProperties(BooleanHelper.getBoolean(project.isRemoveFileProperties()));
        properties.setRevision(NumberHelper.getInteger(project.getRevision()));
        properties.setScheduleFrom(BooleanHelper.getBoolean(project.isScheduleFromStart()) ? ScheduleFrom.START : ScheduleFrom.FINISH);
        properties.setSubject(project.getSubject());
        properties.setSplitInProgressTasks(BooleanHelper.getBoolean(project.isSplitsInProgressTasks()));
        properties.setSpreadActualCost(BooleanHelper.getBoolean(project.isSpreadActualCost()));
        properties.setSpreadPercentComplete(BooleanHelper.getBoolean(project.isSpreadPercentComplete()));
        properties.setStartDate(project.getStartDate());
        properties.setStatusDate(project.getStatusDate());
        properties.setSymbolPosition(project.getCurrencySymbolPosition());
        properties.setUpdatingTaskStatusUpdatesResourceStatus(BooleanHelper.getBoolean(project.isTaskUpdatesResource()));
        properties.setWeekStartDay(DatatypeConverter.parseDay(project.getWeekStartDay()));
        this.updateScheduleSource(properties);
    }

    private void updateScheduleSource(ProjectProperties properties) {
        if (properties.getCompany() != null && properties.getCompany().equals("Synchro Software Ltd")) {
            properties.setFileApplication("Synchro");
        } else if (properties.getAuthor() != null && properties.getAuthor().equals("SG Project")) {
            properties.setFileApplication("Simple Genius");
        } else {
            properties.setFileApplication("Microsoft");
        }
        properties.setFileType("MSPDI");
    }

    private void readCalendars(Project project, HashMap<BigInteger, ProjectCalendar> map) {
        ProjectCalendar defaultCalendar;
        Project.Calendars calendars = project.getCalendars();
        if (calendars != null) {
            ArrayList<Pair<ProjectCalendar, BigInteger>> baseCalendars = new ArrayList<Pair<ProjectCalendar, BigInteger>>();
            for (Project.Calendars.Calendar cal : calendars.getCalendar()) {
                this.readCalendar(cal, map, baseCalendars);
            }
            MSPDIReader.updateBaseCalendarNames(baseCalendars, map);
        }
        if ((defaultCalendar = map.get(project.getCalendarUID())) == null) {
            defaultCalendar = this.m_projectFile.getCalendars().findOrCreateDefaultCalendar();
        }
        this.m_projectFile.setDefaultCalendar(defaultCalendar);
    }

    private static void updateBaseCalendarNames(List<Pair<ProjectCalendar, BigInteger>> baseCalendars, HashMap<BigInteger, ProjectCalendar> map) {
        for (Pair<ProjectCalendar, BigInteger> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            BigInteger baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = map.get(baseCalendarID);
            if (baseCal == null) continue;
            cal.setParent(baseCal);
        }
    }

    private void readCalendar(Project.Calendars.Calendar calendar, HashMap<BigInteger, ProjectCalendar> map, List<Pair<ProjectCalendar, BigInteger>> baseCalendars) {
        ProjectCalendar bc = this.m_projectFile.addCalendar();
        bc.setUniqueID(NumberHelper.getInteger(calendar.getUID()));
        bc.setName(calendar.getName());
        BigInteger baseCalendarID = calendar.getBaseCalendarUID();
        if (baseCalendarID != null) {
            baseCalendars.add(new Pair<ProjectCalendar, BigInteger>(bc, baseCalendarID));
        }
        this.readExceptions(calendar, bc);
        boolean readExceptionsFromDays = bc.getCalendarExceptions().isEmpty();
        Project.Calendars.Calendar.WeekDays days = calendar.getWeekDays();
        if (days != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay weekDay : days.getWeekDay()) {
                this.readDay(bc, weekDay, readExceptionsFromDays);
            }
        } else {
            bc.setCalendarDayType(Day.SUNDAY, DayType.DEFAULT);
            bc.setCalendarDayType(Day.MONDAY, DayType.DEFAULT);
            bc.setCalendarDayType(Day.TUESDAY, DayType.DEFAULT);
            bc.setCalendarDayType(Day.WEDNESDAY, DayType.DEFAULT);
            bc.setCalendarDayType(Day.THURSDAY, DayType.DEFAULT);
            bc.setCalendarDayType(Day.FRIDAY, DayType.DEFAULT);
            bc.setCalendarDayType(Day.SATURDAY, DayType.DEFAULT);
        }
        this.readWorkWeeks(calendar, bc);
        map.put(calendar.getUID(), bc);
        this.m_eventManager.fireCalendarReadEvent(bc);
    }

    private void readDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay day, boolean readExceptionsFromDays) {
        BigInteger dayType = day.getDayType();
        if (dayType != null) {
            if (dayType.intValue() == 0) {
                if (readExceptionsFromDays) {
                    this.readExceptionDay(calendar, day);
                }
            } else {
                this.readNormalDay(calendar, day);
            }
        }
    }

    private void readNormalDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay) {
        int dayNumber = weekDay.getDayType().intValue();
        Day day = Day.getInstance(dayNumber);
        calendar.setWorkingDay(day, BooleanHelper.getBoolean(weekDay.isDayWorking()));
        ProjectCalendarHours hours = calendar.addCalendarHours(day);
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = weekDay.getWorkingTimes();
        if (times != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime period : times.getWorkingTime()) {
                Date startTime = period.getFromTime();
                Date endTime = period.getToTime();
                if (startTime == null || endTime == null) continue;
                if (startTime.getTime() >= endTime.getTime()) {
                    endTime = DateHelper.addDays(endTime, 1);
                }
                hours.add(new DateRange(startTime, endTime));
            }
        }
    }

    private void readExceptionDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay day) {
        Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod timePeriod = day.getTimePeriod();
        Date fromDate = timePeriod.getFromDate();
        Date toDate = timePeriod.getToDate();
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = day.getWorkingTimes();
        ProjectCalendarException exception = calendar.addCalendarException(fromDate, toDate);
        if (times != null) {
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> time = times.getWorkingTime();
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime period : time) {
                Date startTime = period.getFromTime();
                Date endTime = period.getToTime();
                if (startTime == null || endTime == null) continue;
                if (startTime.getTime() >= endTime.getTime()) {
                    endTime = DateHelper.addDays(endTime, 1);
                }
                exception.add(new DateRange(startTime, endTime));
            }
        }
    }

    private void readExceptions(Project.Calendars.Calendar calendar, ProjectCalendar bc) {
        Project.Calendars.Calendar.Exceptions exceptions = calendar.getExceptions();
        if (exceptions != null) {
            for (Project.Calendars.Calendar.Exceptions.Exception exception : exceptions.getException()) {
                this.readException(bc, exception);
            }
        }
    }

    private void readException(ProjectCalendar bc, Project.Calendars.Calendar.Exceptions.Exception exception) {
        Date fromDate = exception.getTimePeriod().getFromDate();
        Date toDate = exception.getTimePeriod().getToDate();
        if (fromDate == null && toDate == null) {
            return;
        }
        RecurringData recurringData = this.readRecurringData(exception, fromDate, toDate);
        if (recurringData != null && !recurringData.isValid()) {
            return;
        }
        ProjectCalendarException bce = recurringData == null ? bc.addCalendarException(fromDate, toDate) : bc.addCalendarException(recurringData);
        bce.setName(exception.getName());
        Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes times = exception.getWorkingTimes();
        if (times != null) {
            List<Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime> time = times.getWorkingTime();
            for (Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime period : time) {
                Date startTime = period.getFromTime();
                Date endTime = period.getToTime();
                if (startTime == null || endTime == null) continue;
                if (startTime.getTime() >= endTime.getTime()) {
                    endTime = DateHelper.addDays(endTime, 1);
                }
                bce.add(new DateRange(startTime, endTime));
            }
        }
    }

    private RecurringData readRecurringData(Project.Calendars.Calendar.Exceptions.Exception exception, Date fromDate, Date toDate) {
        RecurringData rd = null;
        RecurrenceType rt = this.getRecurrenceType(NumberHelper.getInt(exception.getType()));
        if (rt != null) {
            rd = new RecurringData();
            rd.setStartDate(fromDate);
            rd.setFinishDate(toDate);
            rd.setRecurrenceType(rt);
            rd.setRelative(this.getRelative(NumberHelper.getInt(exception.getType())));
            rd.setOccurrences(NumberHelper.getInteger(exception.getOccurrences()));
            switch (rd.getRecurrenceType()) {
                case DAILY: {
                    rd.setFrequency(this.getFrequency(exception));
                    break;
                }
                case WEEKLY: {
                    rd.setWeeklyDaysFromBitmap(NumberHelper.getInteger(exception.getDaysOfWeek()), DAY_MASKS);
                    rd.setFrequency(this.getFrequency(exception));
                    break;
                }
                case MONTHLY: {
                    if (rd.getRelative()) {
                        rd.setDayOfWeek(Day.getInstance(NumberHelper.getInt(exception.getMonthItem()) - 2));
                        rd.setDayNumber(NumberHelper.getInt(exception.getMonthPosition()) + 1);
                    } else {
                        rd.setDayNumber(NumberHelper.getInteger(exception.getMonthDay()));
                    }
                    rd.setFrequency(this.getFrequency(exception));
                    break;
                }
                case YEARLY: {
                    if (rd.getRelative()) {
                        rd.setDayOfWeek(Day.getInstance(NumberHelper.getInt(exception.getMonthItem()) - 2));
                        rd.setDayNumber(NumberHelper.getInt(exception.getMonthPosition()) + 1);
                    } else {
                        rd.setDayNumber(NumberHelper.getInteger(exception.getMonthDay()));
                    }
                    rd.setMonthNumber(NumberHelper.getInt(exception.getMonth()) + 1);
                }
            }
            if (rd.getRecurrenceType() == RecurrenceType.DAILY && NumberHelper.getInt(rd.getFrequency()) == 1) {
                rd = null;
            }
        }
        return rd;
    }

    private RecurrenceType getRecurrenceType(int value) {
        RecurrenceType result = value < 0 || value >= RECURRENCE_TYPES.length ? null : RECURRENCE_TYPES[value];
        return result;
    }

    private boolean getRelative(int value) {
        boolean result = value < 0 || value >= RELATIVE_MAP.length ? false : RELATIVE_MAP[value];
        return result;
    }

    private Integer getFrequency(Project.Calendars.Calendar.Exceptions.Exception exception) {
        Integer period = NumberHelper.getInteger(exception.getPeriod());
        if (period == null) {
            period = 1;
        }
        return period;
    }

    private void readWorkWeeks(Project.Calendars.Calendar xmlCalendar, ProjectCalendar mpxjCalendar) {
        Project.Calendars.Calendar.WorkWeeks ww = xmlCalendar.getWorkWeeks();
        if (ww != null) {
            for (Project.Calendars.Calendar.WorkWeeks.WorkWeek xmlWeek : ww.getWorkWeek()) {
                this.readWorkWeek(mpxjCalendar, xmlWeek);
            }
        }
    }

    private void readWorkWeek(ProjectCalendar mpxjCalendar, Project.Calendars.Calendar.WorkWeeks.WorkWeek xmlWeek) {
        ProjectCalendarWeek week = mpxjCalendar.addWorkWeek();
        week.setName(xmlWeek.getName());
        week.setDateRange(new DateRange(xmlWeek.getTimePeriod().getFromDate(), xmlWeek.getTimePeriod().getToDate()));
        Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays xmlWeekDays = xmlWeek.getWeekDays();
        if (xmlWeekDays != null) {
            Map<Day, Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay> map = xmlWeekDays.getWeekDay().stream().collect(Collectors.toMap(d -> Day.getInstance(d.getDayType().intValue()), d -> d));
            for (Day day : Day.values()) {
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay xmlWeekDay = map.get(day);
                if (xmlWeekDay == null) {
                    week.setWorkingDay(day, false);
                    continue;
                }
                this.readWorkWeekDay(week, day, xmlWeekDay);
            }
        }
    }

    private void readWorkWeekDay(ProjectCalendarWeek week, Day day, Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay xmlWeekDay) {
        week.setWorkingDay(day, BooleanHelper.getBoolean(xmlWeekDay.isDayWorking()));
        ProjectCalendarHours hours = week.addCalendarHours(day);
        Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes times = xmlWeekDay.getWorkingTimes();
        if (times != null) {
            for (Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime period : times.getWorkingTime()) {
                Date startTime = period.getFromTime();
                Date endTime = period.getToTime();
                if (startTime == null || endTime == null) continue;
                if (startTime.getTime() >= endTime.getTime()) {
                    endTime = DateHelper.addDays(endTime, 1);
                }
                hours.add(new DateRange(startTime, endTime));
            }
        }
    }

    private void readExtendedAttributeDefinitions(Project project) {
        Project.ExtendedAttributes attributes = project.getExtendedAttributes();
        if (attributes != null) {
            for (Project.ExtendedAttributes.ExtendedAttribute ea : attributes.getExtendedAttribute()) {
                this.readExtendedAttributeDefinition(ea);
            }
        }
    }

    private void readExtendedAttributeDefinition(Project.ExtendedAttributes.ExtendedAttribute attribute) {
        FieldType field = FieldTypeHelper.getInstance(Integer.parseInt(attribute.getFieldID()));
        this.m_lookupTableMap.put(attribute.getLtuid(), field);
        String alias = attribute.getAlias();
        if (alias != null && alias.length() != 0) {
            this.m_projectFile.getCustomFields().getOrCreate(field).setAlias(attribute.getAlias());
        }
    }

    private void readResources(Project project, HashMap<BigInteger, ProjectCalendar> calendarMap) {
        Project.Resources resources = project.getResources();
        if (resources != null) {
            for (Project.Resources.Resource resource : resources.getResource()) {
                this.readResource(resource, calendarMap);
            }
        }
    }

    private void readResource(Project.Resources.Resource xml, HashMap<BigInteger, ProjectCalendar> calendarMap) {
        Resource mpx = this.m_projectFile.addResource();
        mpx.setAccrueAt(xml.getAccrueAt());
        mpx.setActveDirectoryGUID(xml.getActiveDirectoryGUID());
        mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
        mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
        mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWork()));
        mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWorkProtected()));
        mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWorkProtected()));
        mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
        mpx.setAvailableFrom(xml.getAvailableFrom());
        mpx.setAvailableTo(xml.getAvailableTo());
        mpx.setBCWS(DatatypeConverter.parseCurrency(xml.getBCWS()));
        mpx.setBCWP(DatatypeConverter.parseCurrency(xml.getBCWP()));
        mpx.setBookingType(xml.getBookingType());
        mpx.setBudget(BooleanHelper.getBoolean(xml.isIsBudget()));
        mpx.setCanLevel(BooleanHelper.getBoolean(xml.isCanLevel()));
        mpx.setCode(xml.getCode());
        mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
        mpx.setCostCenter(xml.getCostCenter());
        mpx.setCostVariance(DatatypeConverter.parseCurrency(xml.getCostVariance()));
        mpx.setCreationDate(xml.getCreationDate());
        mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
        mpx.setEmailAddress(xml.getEmailAddress());
        mpx.setGroup(xml.getGroup());
        mpx.setGUID(xml.getGUID());
        mpx.setHyperlink(xml.getHyperlink());
        mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
        mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
        mpx.setID(NumberHelper.getInteger(xml.getID()));
        mpx.setInitials(xml.getInitials());
        mpx.setEnterprise(BooleanHelper.getBoolean(xml.isIsEnterprise()));
        mpx.setGeneric(BooleanHelper.getBoolean(xml.isIsGeneric()));
        mpx.setActive(!BooleanHelper.getBoolean(xml.isIsInactive()));
        mpx.setIsNull(BooleanHelper.getBoolean(xml.isIsNull()));
        mpx.setMaterialLabel(xml.getMaterialLabel());
        mpx.setMaxUnits(DatatypeConverter.parseUnits(xml.getMaxUnits()));
        mpx.setName(xml.getName());
        if (xml.getNotes() != null && xml.getNotes().length() != 0) {
            mpx.setNotes(xml.getNotes());
        }
        mpx.setNtAccount(xml.getNTAccount());
        mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
        mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getOvertimeWork()));
        mpx.setPeakUnits(DatatypeConverter.parseUnits(xml.getPeakUnits()));
        mpx.setPhonetics(xml.getPhonetics());
        mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRegularWork()));
        mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
        mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
        mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingOvertimeWork()));
        mpx.setSV(DatatypeConverter.parseCurrency(xml.getSV()));
        mpx.setType(xml.getType());
        mpx.setUniqueID(NumberHelper.getInteger(xml.getUID()));
        mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getWork()));
        mpx.setWorkGroup(xml.getWorkGroup());
        mpx.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(xml.getWorkVariance()));
        if (mpx.getType() == ResourceType.MATERIAL && BooleanHelper.getBoolean(xml.isIsCostResource())) {
            mpx.setType(ResourceType.COST);
        }
        mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWork()));
        mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingWork()));
        mpx.setPercentWorkComplete(xml.getPercentWorkComplete());
        this.readResourceExtendedAttributes(xml, mpx);
        this.readResourceOutlineCodes(xml, mpx);
        this.readResourceBaselines(xml, mpx);
        mpx.setCalendar(calendarMap.get(xml.getCalendarUID()));
        mpx.setOverAllocated(BooleanHelper.getBoolean(xml.isOverAllocated()));
        Rate standardRate = DatatypeConverter.parseRate(xml.getStandardRate(), DatatypeConverter.parseTimeUnit(xml.getStandardRateFormat()));
        Rate overtimeRate = DatatypeConverter.parseRate(xml.getOvertimeRate(), DatatypeConverter.parseTimeUnit(xml.getOvertimeRateFormat()));
        Double costPerUse = DatatypeConverter.parseCurrency(xml.getCostPerUse());
        this.readCostRateTables(mpx, standardRate, overtimeRate, costPerUse, xml.getRates());
        this.readAvailabilityTable(mpx, xml.getAvailabilityPeriods());
        this.m_eventManager.fireResourceReadEvent(mpx);
    }

    private void readResourceBaselines(Project.Resources.Resource xmlResource, Resource mpxjResource) {
        for (Project.Resources.Resource.Baseline baseline : xmlResource.getBaseline()) {
            int number = NumberHelper.getInt(baseline.getNumber());
            Double cost = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpxjResource.setBaselineCost(cost);
                mpxjResource.setBaselineWork(work);
                continue;
            }
            mpxjResource.setBaselineCost(number, cost);
            mpxjResource.setBaselineWork(number, work);
        }
    }

    private void readResourceExtendedAttributes(Project.Resources.Resource xml, Resource mpx) {
        for (Project.Resources.Resource.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            ResourceField mpxFieldID = MPPResourceField.getInstance(xmlFieldID);
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(attrib.getDurationFormat(), null);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID, durationFormat);
        }
    }

    private void readResourceOutlineCodes(Project.Resources.Resource xml, Resource mpx) {
        for (Project.Resources.Resource.OutlineCode attrib : xml.getOutlineCode()) {
            if (attrib.getFieldID() == null) continue;
            ResourceField mpxFieldID = MPPResourceField.getInstance(Integer.parseInt(attrib.getFieldID()) & 0xFFFF);
            mpx.set((FieldType)mpxFieldID, this.getOutlineCodeValue(mpxFieldID, attrib.getValueID()));
        }
    }

    private void readCostRateTables(Resource resource, Rate defaultStandardRate, Rate defaultOvertimeRate, Number defaultCostPerUse, Project.Resources.Resource.Rates rates) {
        if (rates == null) {
            for (int index = 0; index < 5; ++index) {
                CostRateTable table = new CostRateTable();
                if (index == 0) {
                    Date startDate = CostRateTableEntry.DEFAULT_ENTRY.getStartDate();
                    Date endDate = CostRateTableEntry.DEFAULT_ENTRY.getEndDate();
                    table.add(new CostRateTableEntry(startDate, endDate, defaultCostPerUse, defaultStandardRate, defaultOvertimeRate));
                } else {
                    table.add(CostRateTableEntry.DEFAULT_ENTRY);
                }
                resource.setCostRateTable(index, table);
            }
        } else {
            CostRateTable[] tables = new CostRateTable[5];
            Calendar cal = DateHelper.popCalendar();
            for (Project.Resources.Resource.Rates.Rate rate : rates.getRate()) {
                int tableIndex;
                if (rate.getRateTable() == null || (tableIndex = rate.getRateTable().intValue()) < 0 || tableIndex >= 5) continue;
                TimeUnit standardRateFormat = DatatypeConverter.parseTimeUnit(rate.getStandardRateFormat());
                Rate standardRate = DatatypeConverter.parseRate(rate.getStandardRate(), standardRateFormat);
                TimeUnit overtimeRateFormat = DatatypeConverter.parseTimeUnit(rate.getOvertimeRateFormat());
                Rate overtimeRate = DatatypeConverter.parseRate(rate.getOvertimeRate(), overtimeRateFormat);
                Double costPerUse = DatatypeConverter.parseCurrency(rate.getCostPerUse());
                Date startDate = rate.getRatesFrom();
                Date endDate = rate.getRatesTo();
                if (startDate.getTime() < DateHelper.START_DATE_NA.getTime()) {
                    startDate = DateHelper.START_DATE_NA;
                }
                if (endDate.getTime() > DateHelper.END_DATE_NA.getTime()) {
                    endDate = DateHelper.END_DATE_NA;
                }
                cal.setTime(endDate);
                int minutes = cal.get(12);
                if (minutes % 5 == 0) {
                    cal.add(12, -1);
                    endDate = cal.getTime();
                }
                CostRateTableEntry entry = new CostRateTableEntry(startDate, endDate, costPerUse, standardRate, overtimeRate);
                CostRateTable table = tables[tableIndex];
                if (table == null) {
                    tables[tableIndex] = table = new CostRateTable();
                }
                table.add(entry);
            }
            DateHelper.pushCalendar(cal);
            for (int tableIndex = 0; tableIndex < tables.length; ++tableIndex) {
                CostRateTable table = tables[tableIndex];
                if (table == null) continue;
                Collections.sort(table);
                resource.setCostRateTable(tableIndex, table);
            }
        }
    }

    private void readAvailabilityTable(Resource resource, Project.Resources.Resource.AvailabilityPeriods periods) {
        if (periods != null) {
            AvailabilityTable table = resource.getAvailability();
            List<Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod> list = periods.getAvailabilityPeriod();
            for (Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod period : list) {
                Date start = period.getAvailableFrom();
                Date end = period.getAvailableTo();
                Number units = DatatypeConverter.parseUnits(period.getAvailableUnits());
                if (start == null || start.getTime() < DateHelper.START_DATE_NA.getTime()) {
                    start = DateHelper.START_DATE_NA;
                }
                if (end == null || end.getTime() > DateHelper.END_DATE_NA.getTime()) {
                    end = DateHelper.END_DATE_NA;
                }
                Availability availability = new Availability(start, end, units);
                table.add(availability);
            }
            Collections.sort(table);
        }
    }

    private void readTasks(Project project) {
        Project.Tasks tasks = project.getTasks();
        if (tasks != null) {
            int tasksWithoutIDCount = 0;
            for (Project.Tasks.Task task : tasks.getTask()) {
                Task mpxjTask = this.readTask(task);
                if (mpxjTask.getID() != null) continue;
                ++tasksWithoutIDCount;
            }
            for (Project.Tasks.Task task : tasks.getTask()) {
                this.readPredecessors(task);
            }
            if (tasksWithoutIDCount == tasks.getTask().size()) {
                this.m_projectFile.getTasks().renumberIDs();
            }
        }
        this.m_projectFile.updateStructure();
    }

    private Task readTask(Project.Tasks.Task xml) {
        Task mpx = this.m_projectFile.addTask();
        mpx.setNull(BooleanHelper.getBoolean(xml.isIsNull()));
        mpx.setID(NumberHelper.getInteger(xml.getID()));
        mpx.setUniqueID(NumberHelper.getInteger(xml.getUID()));
        if (!mpx.getNull()) {
            double duration;
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(xml.getDurationFormat());
            mpx.setActive(xml.isActive() == null || BooleanHelper.getBoolean(xml.isActive()));
            mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
            mpx.setActualDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualDuration()));
            mpx.setActualFinish(xml.getActualFinish());
            mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
            mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualOvertimeWork()));
            mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualOvertimeWorkProtected()));
            mpx.setActualStart(xml.getActualStart());
            mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualWork()));
            mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualWorkProtected()));
            mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
            mpx.setCalendar(this.getTaskCalendar(xml));
            mpx.setConstraintDate(xml.getConstraintDate());
            mpx.setConstraintType(DatatypeConverter.parseConstraintType(xml.getConstraintType()));
            mpx.setContact(xml.getContact());
            mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
            mpx.setCreateDate(xml.getCreateDate());
            mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
            mpx.setDeadline(xml.getDeadline());
            mpx.setDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getDuration()));
            mpx.setDurationText(xml.getDurationText());
            mpx.setEarlyFinish(xml.getEarlyFinish());
            mpx.setEarlyStart(xml.getEarlyStart());
            mpx.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(xml.getEarnedValueMethod()));
            mpx.setEffortDriven(BooleanHelper.getBoolean(xml.isEffortDriven()));
            mpx.setEstimated(BooleanHelper.getBoolean(xml.isEstimated()));
            mpx.setExternalTask(BooleanHelper.getBoolean(xml.isExternalTask()));
            mpx.setProject(xml.getExternalTaskProject());
            mpx.setFinish(xml.getFinish());
            mpx.setFinishText(xml.getFinishText());
            mpx.setFinishVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(xml.getFinishVariance()));
            mpx.setFixedCost(DatatypeConverter.parseCurrency(xml.getFixedCost()));
            mpx.setFixedCostAccrual(xml.getFixedCostAccrual());
            mpx.setGUID(xml.getGUID());
            mpx.setHideBar(BooleanHelper.getBoolean(xml.isHideBar()));
            mpx.setHyperlink(xml.getHyperlink());
            mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
            mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
            mpx.setIgnoreResourceCalendar(BooleanHelper.getBoolean(xml.isIgnoreResourceCalendar()));
            mpx.setLateFinish(xml.getLateFinish());
            mpx.setLateStart(xml.getLateStart());
            mpx.setLevelAssignments(BooleanHelper.getBoolean(xml.isLevelAssignments()));
            mpx.setLevelingCanSplit(BooleanHelper.getBoolean(xml.isLevelingCanSplit()));
            mpx.setLevelingDelayFormat(DatatypeConverter.parseDurationTimeUnits(xml.getLevelingDelayFormat()));
            if (xml.getLevelingDelay() != null && mpx.getLevelingDelayFormat() != null && (duration = xml.getLevelingDelay().doubleValue()) != 0.0) {
                mpx.setLevelingDelay(Duration.convertUnits(duration / 10.0, TimeUnit.MINUTES, mpx.getLevelingDelayFormat(), this.m_projectFile.getProjectProperties()));
            }
            mpx.setMilestone(BooleanHelper.getBoolean(xml.isMilestone()));
            mpx.setName(xml.getName());
            if (xml.getNotes() != null && xml.getNotes().length() != 0) {
                mpx.setNotes(xml.getNotes());
            }
            mpx.setOutlineLevel(NumberHelper.getInteger(xml.getOutlineLevel()));
            mpx.setOutlineNumber(xml.getOutlineNumber());
            mpx.setOverAllocated(BooleanHelper.getBoolean(xml.isOverAllocated()));
            mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
            mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getOvertimeWork()));
            mpx.setPercentageComplete(xml.getPercentComplete());
            mpx.setPercentageWorkComplete(xml.getPercentWorkComplete());
            mpx.setPhysicalPercentComplete(NumberHelper.getInteger(xml.getPhysicalPercentComplete()));
            mpx.setPreleveledFinish(xml.getPreLeveledFinish());
            mpx.setPreleveledStart(xml.getPreLeveledStart());
            mpx.setPriority(DatatypeConverter.parsePriority(xml.getPriority()));
            mpx.setRecurring(BooleanHelper.getBoolean(xml.isRecurring()));
            mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRegularWork()));
            mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
            mpx.setRemainingDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRemainingDuration()));
            mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
            mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRemainingOvertimeWork()));
            mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRemainingWork()));
            mpx.setResume(xml.getResume());
            mpx.setResumeValid(BooleanHelper.getBoolean(xml.isResumeValid()));
            mpx.setRollup(BooleanHelper.getBoolean(xml.isRollup()));
            mpx.setStart(xml.getStart());
            mpx.setStartText(xml.getStartText());
            mpx.setStartVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(xml.getStartVariance()));
            mpx.setStop(xml.getStop());
            mpx.setSubProject(BooleanHelper.getBoolean(xml.isIsSubproject()) ? new SubProject() : null);
            mpx.setSubprojectName(xml.getSubprojectName());
            mpx.setSubprojectReadOnly(BooleanHelper.getBoolean(xml.isIsSubprojectReadOnly()));
            mpx.setTaskMode(BooleanHelper.getBoolean(xml.isManual()) ? TaskMode.MANUALLY_SCHEDULED : TaskMode.AUTO_SCHEDULED);
            mpx.setType(xml.getType());
            mpx.setWBS(xml.getWBS());
            mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getWork()));
            mpx.setWorkVariance(Duration.getInstance(NumberHelper.getDouble(xml.getWorkVariance()) / 1000.0, TimeUnit.MINUTES));
            this.validateFinishDate(mpx);
            mpx.setStartSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getStartSlack()));
            mpx.setFinishSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getFinishSlack()));
            mpx.setFreeSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getFreeSlack()));
            mpx.setTotalSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getTotalSlack()));
            mpx.setCritical(BooleanHelper.getBoolean(xml.isCritical()));
            this.readTaskExtendedAttributes(xml, mpx);
            this.readTaskOutlineCodes(xml, mpx);
            this.readTaskBaselines(xml, mpx, durationFormat);
            if (mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
                mpx.setManualDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getManualDuration()));
            }
            if (mpx.getActualDuration() != null) {
                mpx.set((FieldType)TaskField.ACTUAL_DURATION_UNITS, mpx.getActualDuration().getUnits());
            }
            if (NumberHelper.getInt(mpx.getUniqueID()) == 0) {
                mpx.setSummary(true);
                this.updateProjectProperties(mpx);
            }
        }
        this.m_eventManager.fireTaskReadEvent(mpx);
        return mpx;
    }

    private void updateProjectProperties(Task task) {
        ProjectProperties props = this.m_projectFile.getProjectProperties();
        props.setComments(task.getNotes());
    }

    private void validateFinishDate(Task task) {
        Date startDate;
        if (task.getFinish() == null && (startDate = task.getStart()) != null) {
            if (task.getMilestone()) {
                task.setFinish(startDate);
            } else {
                Duration duration = task.getDuration();
                if (duration != null) {
                    ProjectCalendar calendar = task.getEffectiveCalendar();
                    task.setFinish(calendar.getDate(startDate, duration, false));
                }
            }
        }
    }

    private void readTaskBaselines(Project.Tasks.Task xmlTask, Task mpxjTask, TimeUnit durationFormat) {
        for (Project.Tasks.Task.Baseline baseline : xmlTask.getBaseline()) {
            int number = NumberHelper.getInt(baseline.getNumber());
            if (number < 0 || number > 10) continue;
            Double cost = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, baseline.getDuration());
            Date finish = baseline.getFinish();
            Date start = baseline.getStart();
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpxjTask.setBaselineCost(cost);
                mpxjTask.setBaselineDuration(duration);
                mpxjTask.setBaselineFinish(finish);
                mpxjTask.setBaselineStart(start);
                mpxjTask.setBaselineWork(work);
                continue;
            }
            mpxjTask.setBaselineCost(number, cost);
            mpxjTask.setBaselineDuration(number, duration);
            mpxjTask.setBaselineFinish(number, finish);
            mpxjTask.setBaselineStart(number, start);
            mpxjTask.setBaselineWork(number, work);
        }
    }

    private void readTaskExtendedAttributes(Project.Tasks.Task xml, Task mpx) {
        for (Project.Tasks.Task.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            TaskField mpxFieldID = MPPTaskField.getInstance(xmlFieldID);
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(attrib.getDurationFormat(), null);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID, durationFormat);
        }
    }

    private void readTaskOutlineCodes(Project.Tasks.Task xml, Task mpx) {
        for (Project.Tasks.Task.OutlineCode attrib : xml.getOutlineCode()) {
            if (attrib.getFieldID() == null) continue;
            TaskField mpxFieldID = MPPTaskField.getInstance(Integer.parseInt(attrib.getFieldID()) & 0xFFFF);
            mpx.set((FieldType)mpxFieldID, this.getOutlineCodeValue(mpxFieldID, attrib.getValueID()));
        }
    }

    private String getOutlineCodeValue(FieldType mpxFieldID, BigInteger valueID) {
        String result = null;
        CustomFieldValueItem item = this.getValueItem(mpxFieldID, valueID);
        if (item != null && item.getValue() != null) {
            String parentResult;
            result = item.getValue().toString();
            Integer parentID = item.getParent();
            if (parentID != null && (parentResult = this.getOutlineCodeValue(mpxFieldID, BigInteger.valueOf(parentID.longValue()))) != null) {
                result = parentResult + "." + result;
            }
        }
        return result;
    }

    private CustomFieldValueItem getValueItem(FieldType fieldType, BigInteger valueID) {
        CustomFieldLookupTable items;
        CustomFieldValueItem result = null;
        CustomField field = this.m_projectFile.getCustomFields().get(fieldType);
        if (field != null && !(items = field.getLookupTable()).isEmpty()) {
            result = (CustomFieldValueItem)((Map)this.m_customFieldValueItems.getOrDefault(fieldType, this.getCustomFieldValueItemMap(items))).get(valueID);
        }
        return result;
    }

    private HashMap<BigInteger, CustomFieldValueItem> getCustomFieldValueItemMap(List<CustomFieldValueItem> items) {
        HashMap<BigInteger, CustomFieldValueItem> result = new HashMap<BigInteger, CustomFieldValueItem>();
        items.forEach(item -> result.put(BigInteger.valueOf(item.getUniqueID().intValue()), (CustomFieldValueItem)item));
        return result;
    }

    private ProjectCalendar getTaskCalendar(Project.Tasks.Task task) {
        ProjectCalendar calendar = null;
        BigInteger calendarID = task.getCalendarUID();
        if (calendarID != null) {
            calendar = this.m_projectFile.getCalendarByUniqueID(calendarID.intValue());
        }
        return calendar;
    }

    private void readPredecessors(Project.Tasks.Task task) {
        Task currTask;
        Integer uid = task.getUID();
        if (uid != null && (currTask = this.m_projectFile.getTaskByUniqueID(uid)) != null) {
            for (Project.Tasks.Task.PredecessorLink link : task.getPredecessorLink()) {
                this.readPredecessor(currTask, link);
            }
        }
    }

    private void readPredecessor(Task currTask, Project.Tasks.Task.PredecessorLink link) {
        Task prevTask;
        BigInteger uid = link.getPredecessorUID();
        if (uid != null && (prevTask = this.m_projectFile.getTaskByUniqueID(uid.intValue())) != null) {
            RelationType type = link.getType() != null ? RelationType.getInstance(link.getType().intValue()) : RelationType.FINISH_START;
            TimeUnit lagUnits = DatatypeConverter.parseDurationTimeUnits(link.getLagFormat());
            int lag = NumberHelper.getInt(link.getLinkLag());
            Duration lagDuration = lag == 0 ? Duration.getInstance(0, lagUnits) : (lagUnits == TimeUnit.PERCENT || lagUnits == TimeUnit.ELAPSED_PERCENT ? Duration.getInstance(lag, lagUnits) : Duration.convertUnits((double)lag / 10.0, TimeUnit.MINUTES, lagUnits, this.m_projectFile.getProjectProperties()));
            Relation relation = currTask.addPredecessor(prevTask, type, lagDuration);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void readAssignments(Project project) {
        Project.Assignments assignments = project.getAssignments();
        if (assignments != null) {
            SplitTaskFactory splitFactory = new SplitTaskFactory();
            MSPDITimephasedWorkNormaliser normaliser = new MSPDITimephasedWorkNormaliser();
            for (Project.Assignments.Assignment assignment : assignments.getAssignment()) {
                this.readAssignment(assignment, splitFactory, normaliser);
            }
        }
    }

    private void readOutlineCodeDefinitions(Project project) {
        Project.OutlineCodes outlineCodes = project.getOutlineCodes();
        if (outlineCodes != null) {
            for (Project.OutlineCodes.OutlineCode outlineCode : outlineCodes.getOutlineCode()) {
                this.readOutlineCodeDefinition(outlineCode);
            }
        }
    }

    private void readOutlineCodeDefinition(Project.OutlineCodes.OutlineCode outlineCode) {
        String fieldID = outlineCode.getFieldID();
        FieldType fieldType = fieldID == null ? this.m_lookupTableMap.get(outlineCode.getGuid()) : FieldTypeHelper.getInstance(NumberHelper.getInt(outlineCode.getFieldID()));
        if (fieldType != null) {
            String newAlias = outlineCode.getAlias();
            if (newAlias != null && !newAlias.isEmpty()) {
                String currentAlias;
                CustomField field = this.m_projectFile.getCustomFields().get(fieldType);
                String string = currentAlias = field == null ? null : field.getAlias();
                if (currentAlias == null || currentAlias.isEmpty()) {
                    if (field == null) {
                        field = this.m_projectFile.getCustomFields().getOrCreate(fieldType);
                    }
                    field.setAlias(newAlias);
                }
            }
            this.readOutlineCodeValues(outlineCode, fieldType);
            this.readOutlineCodeMasks(outlineCode, fieldType);
        }
    }

    private void readOutlineCodeValues(Project.OutlineCodes.OutlineCode outlineCode, FieldType fieldType) {
        Project.OutlineCodes.OutlineCode.Values values = outlineCode.getValues();
        if (values != null) {
            CustomField field = this.m_projectFile.getCustomFields().getOrCreate(fieldType);
            CustomFieldLookupTable table = field.getLookupTable();
            table.setEnterprise(BooleanHelper.getBoolean(outlineCode.isEnterprise()));
            table.setAllLevelsRequired(BooleanHelper.getBoolean(outlineCode.isAllLevelsRequired()));
            table.setGUID(outlineCode.getGuid());
            table.setLeafOnly(BooleanHelper.getBoolean(outlineCode.isLeafOnly()));
            table.setOnlyTableValuesAllowed(BooleanHelper.getBoolean(outlineCode.isOnlyTableValuesAllowed()));
            table.setResourceSubstitutionEnabled(BooleanHelper.getBoolean(outlineCode.isResourceSubstitutionEnabled()));
            table.setShowIndent(BooleanHelper.getBoolean(outlineCode.isShowIndent()));
            for (Project.OutlineCodes.OutlineCode.Values.Value value : values.getValue()) {
                CustomFieldValueItem item = new CustomFieldValueItem(NumberHelper.getInteger(value.getValueID()));
                item.setDescription(value.getDescription());
                item.setGUID(value.getFieldGUID());
                item.setCollapsed(BooleanHelper.getBoolean(value.isIsCollapsed()));
                item.setParent(NumberHelper.getInteger(value.getParentValueID()));
                item.setType(CustomFieldValueDataType.getInstance(NumberHelper.getInt(value.getType())));
                item.setValue(DatatypeConverter.parseOutlineCodeValue(value.getValue(), field.getFieldType().getDataType()));
                table.add(item);
            }
        }
    }

    private void readOutlineCodeMasks(Project.OutlineCodes.OutlineCode outlineCode, FieldType fieldType) {
        Project.OutlineCodes.OutlineCode.Masks masks = outlineCode.getMasks();
        if (masks != null && !masks.getMask().isEmpty()) {
            CustomField field = this.m_projectFile.getCustomFields().getOrCreate(fieldType);
            List<CustomFieldValueMask> maskList = field.getMasks();
            for (Project.OutlineCodes.OutlineCode.Masks.Mask mask : masks.getMask()) {
                int length = NumberHelper.getInt(mask.getLength());
                int level = NumberHelper.getInt(mask.getLevel());
                String separator = mask.getSeparator();
                CustomFieldValueDataType type = CustomFieldValueDataType.getInstanceByMaskValue(NumberHelper.getInt(mask.getType()));
                if (type == null) {
                    type = CustomFieldValueDataType.TEXT;
                }
                CustomFieldValueMask item = new CustomFieldValueMask(length, level, separator, type);
                maskList.add(item);
            }
        }
    }

    private void readAssignment(Project.Assignments.Assignment assignment, SplitTaskFactory splitFactory, TimephasedWorkNormaliser normaliser) {
        Task task;
        BigInteger taskUID = assignment.getTaskUID();
        BigInteger resourceUID = assignment.getResourceUID();
        if (taskUID != null && resourceUID != null && (task = this.m_projectFile.getTaskByUniqueID(taskUID.intValue())) != null) {
            Resource resource = this.m_projectFile.getResourceByUniqueID(resourceUID.intValue());
            ProjectCalendar calendar = null;
            if (resource != null) {
                calendar = resource.getCalendar();
            }
            if (calendar == null || task.getIgnoreResourceCalendar()) {
                calendar = task.getEffectiveCalendar();
            }
            List<TimephasedWork> timephasedComplete = this.readTimephasedAssignment(calendar, assignment, 2);
            List<TimephasedWork> timephasedPlanned = this.readTimephasedAssignment(calendar, assignment, 1);
            boolean raw = true;
            if (this.isSplit(calendar, timephasedComplete) || this.isSplit(calendar, timephasedPlanned)) {
                normaliser.normalise(calendar, timephasedComplete);
                normaliser.normalise(calendar, timephasedPlanned);
                splitFactory.processSplitData(task, timephasedComplete, timephasedPlanned);
                raw = false;
            }
            DefaultTimephasedWorkContainer timephasedCompleteData = new DefaultTimephasedWorkContainer(calendar, normaliser, timephasedComplete, raw);
            DefaultTimephasedWorkContainer timephasedPlannedData = new DefaultTimephasedWorkContainer(calendar, normaliser, timephasedPlanned, raw);
            ResourceAssignment mpx = task.addResourceAssignment(resource);
            mpx.setActualCost(DatatypeConverter.parseCurrency(assignment.getActualCost()));
            mpx.setActualFinish(assignment.getActualFinish());
            mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(assignment.getActualOvertimeCost()));
            mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualOvertimeWork()));
            mpx.setActualStart(assignment.getActualStart());
            mpx.setACWP(DatatypeConverter.parseCurrency(assignment.getACWP()));
            mpx.setBCWP(DatatypeConverter.parseCurrency(assignment.getBCWP()));
            mpx.setBCWS(DatatypeConverter.parseCurrency(assignment.getBCWS()));
            mpx.setBudgetCost(DatatypeConverter.parseCurrency(assignment.getBudgetCost()));
            mpx.setBudgetWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getBudgetWork()));
            mpx.setCost(DatatypeConverter.parseCurrency(assignment.getCost()));
            mpx.setCostRateTableIndex(NumberHelper.getInt(assignment.getCostRateTable()));
            mpx.setCreateDate(assignment.getCreationDate());
            mpx.setCV(DatatypeConverter.parseCurrency(assignment.getCV()));
            mpx.setDelay(DatatypeConverter.parseDurationInTenthsOfMinutes(assignment.getDelay()));
            mpx.setFinish(assignment.getFinish());
            mpx.setVariableRateUnits(BooleanHelper.getBoolean(assignment.isHasFixedRateUnits()) ? null : DatatypeConverter.parseTimeUnit(assignment.getRateScale()));
            mpx.setGUID(assignment.getGUID());
            mpx.setHyperlink(assignment.getHyperlink());
            mpx.setHyperlinkAddress(assignment.getHyperlinkAddress());
            mpx.setHyperlinkSubAddress(assignment.getHyperlinkSubAddress());
            mpx.setLevelingDelay(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getLevelingDelay(), DatatypeConverter.parseDurationTimeUnits(assignment.getLevelingDelayFormat())));
            mpx.setNotes(assignment.getNotes());
            mpx.setOvertimeCost(DatatypeConverter.parseCurrency(assignment.getOvertimeCost()));
            mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getOvertimeWork()));
            mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRegularWork()));
            mpx.setRemainingCost(DatatypeConverter.parseCurrency(assignment.getRemainingCost()));
            mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(assignment.getRemainingOvertimeCost()));
            mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingOvertimeWork()));
            mpx.setResume(assignment.getResume());
            mpx.setStart(assignment.getStart());
            mpx.setStop(assignment.getStop());
            mpx.setSV(DatatypeConverter.parseCurrency(assignment.getSV()));
            mpx.setUniqueID(NumberHelper.getInteger(assignment.getUID()));
            mpx.setUnits(DatatypeConverter.parseUnits(assignment.getUnits()));
            mpx.setVAC(DatatypeConverter.parseCurrency(assignment.getVAC()));
            mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getWork()));
            mpx.setWorkContour(assignment.getWorkContour());
            mpx.setTimephasedActualWork(timephasedCompleteData);
            mpx.setTimephasedWork(timephasedPlannedData);
            this.readAssignmentExtendedAttributes(assignment, mpx);
            this.readAssignmentBaselines(assignment, mpx);
            mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualWork()));
            mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingWork()));
            mpx.setPercentageWorkComplete(assignment.getPercentWorkComplete());
            mpx.setCostVariance(DatatypeConverter.parseCurrency(assignment.getCostVariance()));
            mpx.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getWorkVariance(), TimeUnit.HOURS));
            mpx.setStartVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getStartVariance(), TimeUnit.DAYS));
            mpx.setFinishVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getFinishVariance(), TimeUnit.DAYS));
            this.m_eventManager.fireAssignmentReadEvent(mpx);
        }
    }

    private void readAssignmentBaselines(Project.Assignments.Assignment assignment, ResourceAssignment mpx) {
        for (Project.Assignments.Assignment.Baseline baseline : assignment.getBaseline()) {
            int number = NumberHelper.getInt(baseline.getNumber());
            Number cost = DatatypeConverter.parseExtendedAttributeCurrency(baseline.getCost());
            Date finish = DatatypeConverter.parseExtendedAttributeDate(baseline.getFinish());
            Date start = DatatypeConverter.parseExtendedAttributeDate(baseline.getStart());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpx.setBaselineCost(cost);
                mpx.setBaselineFinish(finish);
                mpx.setBaselineStart(start);
                mpx.setBaselineWork(work);
                continue;
            }
            mpx.setBaselineCost(number, cost);
            mpx.setBaselineWork(number, work);
            mpx.setBaselineStart(number, start);
            mpx.setBaselineFinish(number, finish);
        }
    }

    private void readAssignmentExtendedAttributes(Project.Assignments.Assignment xml, ResourceAssignment mpx) {
        for (Project.Assignments.Assignment.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            AssignmentField mpxFieldID = MPPAssignmentField.getInstance(xmlFieldID);
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(attrib.getDurationFormat(), null);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID, durationFormat);
        }
    }

    private boolean isSplit(ProjectCalendar calendar, List<TimephasedWork> list) {
        boolean result = false;
        for (TimephasedWork assignment : list) {
            Duration calendarWork;
            if (calendar == null || ((Duration)assignment.getTotalAmount()).getDuration() != 0.0 || (calendarWork = calendar.getWork(assignment.getStart(), assignment.getFinish(), TimeUnit.MINUTES)).getDuration() == 0.0) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<TimephasedWork> readTimephasedAssignment(ProjectCalendar calendar, Project.Assignments.Assignment assignment, int type) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        for (TimephasedDataType item : assignment.getTimephasedData()) {
            if (NumberHelper.getInt(item.getType()) != type) continue;
            Date startDate = item.getStart();
            Date finishDate = item.getFinish();
            if (startDate == null && finishDate == null) continue;
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.MINUTES, item.getValue());
            work = work == null ? Duration.getInstance(0, TimeUnit.MINUTES) : Duration.getInstance(NumberHelper.round(work.getDuration(), 2.0), TimeUnit.MINUTES);
            TimephasedWork tra = new TimephasedWork();
            tra.setStart(startDate);
            tra.setFinish(finishDate);
            tra.setTotalAmount(work);
            result.add(tra);
        }
        return result;
    }

    public void setMicrosoftProjectCompatibleInput(boolean flag) {
        this.m_compatibleInput = flag;
    }

    public boolean getMicrosoftProjectCompatibleInput() {
        return this.m_compatibleInput;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.mspdi.schema", (ClassLoader)MSPDIReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        RECURRENCE_TYPES = new RecurrenceType[]{null, RecurrenceType.DAILY, RecurrenceType.YEARLY, RecurrenceType.YEARLY, RecurrenceType.MONTHLY, RecurrenceType.MONTHLY, RecurrenceType.WEEKLY, RecurrenceType.DAILY};
        RELATIVE_MAP = new boolean[]{false, false, false, true, false, true};
        DAY_MASKS = new int[]{0, 1, 2, 4, 8, 16, 32, 64};
    }
}

