/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.phoenix;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.mpxj.ActivityCode;
import net.sf.mpxj.ActivityCodeScope;
import net.sf.mpxj.ActivityCodeValue;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDays;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.AlphanumComparator;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.DebugLogPrintWriter;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.UnmarshalHelper;
import net.sf.mpxj.phoenix.SkipNulInputStream;
import net.sf.mpxj.phoenix.schema.phoenix4.Project;
import net.sf.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.SAXException;

final class Phoenix4Reader
extends AbstractProjectStreamReader {
    private PrintWriter m_log;
    private ProjectFile m_projectFile;
    private Map<String, Task> m_activityMap;
    private Map<UUID, ActivityCodeValue> m_activityCodeValues;
    private Map<Project.Storepoints.Storepoint.Activities.Activity, Map<UUID, UUID>> m_activityCodeCache;
    private EventManager m_eventManager;
    List<UUID> m_codeSequence;
    private final boolean m_useActivityCodesForTaskHierarchy;
    private int m_activityCodeUniqueID;
    private int m_activityCodeValueUniqueID;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    public Phoenix4Reader(boolean useActivityCodesForTaskHierarchy) {
        this.m_useActivityCodesForTaskHierarchy = useActivityCodesForTaskHierarchy;
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        this.openLogFile();
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = new ProjectFile();
            this.m_activityMap = new HashMap<String, Task>();
            this.m_activityCodeValues = new HashMap<UUID, ActivityCodeValue>();
            this.m_activityCodeCache = new HashMap<Project.Storepoints.Storepoint.Activities.Activity, Map<UUID, UUID>>();
            this.m_codeSequence = new ArrayList<UUID>();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceUniqueID(true);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Phoenix");
            this.m_projectFile.getProjectProperties().setFileType("PPX");
            this.addListenersToProject(this.m_projectFile);
            Project phoenixProject = (Project)UnmarshalHelper.unmarshal(CONTEXT, new SkipNulInputStream(stream));
            Project.Storepoints.Storepoint storepoint = this.getCurrentStorepoint(phoenixProject);
            this.readProjectProperties(phoenixProject.getSettings(), storepoint);
            this.readCalendars(storepoint);
            this.readActivityCodes(storepoint);
            this.readTasks(phoenixProject, storepoint);
            this.readResources(storepoint);
            this.readRelationships(storepoint);
            config.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (JAXBException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_activityMap = null;
            this.m_activityCodeValues = null;
            this.m_activityCodeCache = null;
            this.m_codeSequence = null;
            this.closeLogFile();
        }
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Collections.singletonList(this.read(inputStream));
    }

    private void readProjectProperties(Project.Settings phoenixSettings, Project.Storepoints.Storepoint storepoint) {
        ProjectProperties mpxjProperties = this.m_projectFile.getProjectProperties();
        mpxjProperties.setName(phoenixSettings.getTitle());
        mpxjProperties.setDefaultDurationUnits(phoenixSettings.getBaseunit());
        mpxjProperties.setStatusDate(storepoint.getDataDate());
    }

    private void readActivityCodes(Project.Storepoints.Storepoint phoenixProject) {
        int activityCodeSequence = 0;
        Project.Storepoints.Storepoint.ActivityCodes activityCodes = phoenixProject.getActivityCodes();
        if (activityCodes != null) {
            for (Project.Storepoints.Storepoint.ActivityCodes.Code code : activityCodes.getCode()) {
                this.readActivityCode(code, ++activityCodeSequence);
            }
        }
    }

    private void readActivityCode(Project.Storepoints.Storepoint.ActivityCodes.Code code, Integer activityCodeSequence) {
        ActivityCode activityCode = new ActivityCode(++this.m_activityCodeUniqueID, ActivityCodeScope.GLOBAL, null, activityCodeSequence, code.getName());
        UUID codeUUID = this.getCodeUUID(code.getUuid(), code.getName());
        int activityCodeValueSequence = 0;
        for (Project.Storepoints.Storepoint.ActivityCodes.Code.Value typeValue : code.getValue()) {
            ActivityCodeValue activityCodeValue = activityCode.addValue(++this.m_activityCodeValueUniqueID, ++activityCodeValueSequence, typeValue.getName(), typeValue.getName(), null);
            String name = typeValue.getName();
            UUID uuid = this.getValueUUID(codeUUID, typeValue.getUuid(), name);
            this.m_activityCodeValues.put(uuid, activityCodeValue);
        }
    }

    private void readCalendars(Project.Storepoints.Storepoint phoenixProject) {
        Project.Storepoints.Storepoint.Calendars calendars = phoenixProject.getCalendars();
        if (calendars != null) {
            for (Project.Storepoints.Storepoint.Calendars.Calendar calendar : calendars.getCalendar()) {
                this.readCalendar(calendar);
            }
            ProjectCalendar defaultCalendar = this.m_projectFile.getCalendarByName(phoenixProject.getDefaultCalendar());
            if (defaultCalendar != null) {
                this.m_projectFile.getProjectProperties().setDefaultCalendar(defaultCalendar);
            }
        }
    }

    private void readCalendar(Project.Storepoints.Storepoint.Calendars.Calendar calendar) {
        ProjectCalendar mpxjCalendar = this.m_projectFile.addCalendar();
        mpxjCalendar.setName(calendar.getName());
        for (Day day : Day.values()) {
            mpxjCalendar.setWorkingDay(day, true);
        }
        List<Project.Storepoints.Storepoint.Calendars.Calendar.NonWork> nonWorkingDays = calendar.getNonWork();
        for (Project.Storepoints.Storepoint.Calendars.Calendar.NonWork nonWorkingDay : nonWorkingDays) {
            if (!nonWorkingDay.getType().equals("internal_weekly")) continue;
            mpxjCalendar.setWorkingDay(nonWorkingDay.getWeekday(), false);
        }
        for (Day day : Day.values()) {
            ProjectCalendarHours hours = mpxjCalendar.addCalendarHours(day);
            if (!mpxjCalendar.isWorkingDay(day)) continue;
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_MORNING);
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_AFTERNOON);
        }
    }

    private void readResources(Project.Storepoints.Storepoint phoenixProject) {
        Project.Storepoints.Storepoint.Resources resources = phoenixProject.getResources();
        if (resources != null) {
            for (Project.Storepoints.Storepoint.Resources.Resource res : resources.getResource()) {
                Resource resource = this.readResource(res);
                this.readAssignments(resource, res);
            }
        }
    }

    private Resource readResource(Project.Storepoints.Storepoint.Resources.Resource phoenixResource) {
        Resource mpxjResource = this.m_projectFile.addResource();
        TimeUnit rateUnits = phoenixResource.getMonetarybase();
        if (rateUnits == null) {
            rateUnits = TimeUnit.HOURS;
        }
        mpxjResource.setName(phoenixResource.getName());
        mpxjResource.setType(phoenixResource.getType());
        mpxjResource.setMaterialLabel(phoenixResource.getUnitslabel());
        mpxjResource.setGUID(phoenixResource.getUuid());
        CostRateTable costRateTable = new CostRateTable();
        costRateTable.add(new CostRateTableEntry(DateHelper.START_DATE_NA, DateHelper.END_DATE_NA, phoenixResource.getMonetarycostperuse(), new Rate(phoenixResource.getMonetaryrate(), rateUnits)));
        mpxjResource.setCostRateTable(0, costRateTable);
        this.m_eventManager.fireResourceReadEvent(mpxjResource);
        return mpxjResource;
    }

    private void readTasks(Project phoenixProject, Project.Storepoints.Storepoint storepoint) {
        this.processLayouts(phoenixProject);
        this.processActivities(storepoint);
        this.updateDates();
    }

    private void processLayouts(Project phoenixProject) {
        Project.Layouts.Layout activeLayout = this.getActiveLayout(phoenixProject);
        Project.Layouts.Layout.CodeOptions codeOptions = activeLayout.getCodeOptions();
        if (codeOptions != null) {
            for (Project.Layouts.Layout.CodeOptions.CodeOption option : codeOptions.getCodeOption()) {
                if (!option.isShown().booleanValue()) continue;
                this.m_codeSequence.add(this.getCodeUUID(option.getCodeUuid(), option.getCode()));
            }
        }
    }

    private Project.Layouts.Layout getActiveLayout(Project phoenixProject) {
        Project.Layouts.Layout activeLayout = phoenixProject.getLayouts().getLayout().get(0);
        if (!activeLayout.isActive().booleanValue()) {
            for (Project.Layouts.Layout layout : phoenixProject.getLayouts().getLayout()) {
                if (!layout.isActive().booleanValue()) continue;
                activeLayout = layout;
                break;
            }
        }
        return activeLayout;
    }

    private void processActivities(Project.Storepoints.Storepoint phoenixProject) {
        List<Project.Storepoints.Storepoint.Activities.Activity> activities;
        AlphanumComparator comparator = new AlphanumComparator();
        List<Project.Storepoints.Storepoint.Activities.Activity> list = activities = phoenixProject.getActivities() == null ? Collections.emptyList() : phoenixProject.getActivities().getActivity();
        if (this.m_log != null) {
            this.m_log.println("{");
            StringJoiner codeJoiner = new StringJoiner(",");
            this.m_codeSequence.forEach(code -> codeJoiner.add("\"" + code + "\""));
            this.m_log.println("\"codeSequence\": [" + codeJoiner + "],");
            StringJoiner sequenceJoiner = new StringJoiner(",");
            this.m_activityCodeValues.forEach((key, value) -> sequenceJoiner.add("\"" + key + "\": " + value.getSequenceNumber() + ""));
            this.m_log.println("\"activityCodeSequence\": {" + sequenceJoiner + "},");
            StringJoiner activityJoiner = new StringJoiner(",");
            for (Project.Storepoints.Storepoint.Activities.Activity activity : activities) {
                Map<UUID, UUID> codes = this.getActivityCodes(activity);
                StringJoiner activityCodeJoiner = new StringJoiner(",");
                codes.forEach((key, value) -> activityCodeJoiner.add("\"" + key + "\": \"" + value + "\""));
                activityJoiner.add("\"" + activity.getId() + "\": {" + activityCodeJoiner + "}");
            }
            this.m_log.println("\"activityCodes\": {" + activityJoiner + "}}");
        }
        activities.sort((o1, o2) -> comparator.compare(o1.getId(), o2.getId()));
        activities.sort((o1, o2) -> {
            Map<UUID, UUID> codes1 = this.getActivityCodes((Project.Storepoints.Storepoint.Activities.Activity)o1);
            Map<UUID, UUID> codes2 = this.getActivityCodes((Project.Storepoints.Storepoint.Activities.Activity)o2);
            for (UUID code : this.m_codeSequence) {
                UUID codeValue1 = codes1.get(code);
                UUID codeValue2 = codes2.get(code);
                if (codeValue1 == null || codeValue2 == null) {
                    if (codeValue1 == null && codeValue2 == null) continue;
                    if (codeValue1 == null) {
                        return -1;
                    }
                    if (codeValue2 == null) {
                        return 1;
                    }
                }
                if (codeValue1.equals(codeValue2)) continue;
                Integer sequence1 = this.m_activityCodeValues.get(codeValue1) != null ? this.m_activityCodeValues.get(codeValue1).getSequenceNumber() : null;
                Integer sequence2 = this.m_activityCodeValues.get(codeValue2) != null ? this.m_activityCodeValues.get(codeValue2).getSequenceNumber() : null;
                return NumberHelper.compare(sequence1, sequence2);
            }
            return comparator.compare(o1.getId(), o2.getId());
        });
        for (Project.Storepoints.Storepoint.Activities.Activity activity : activities) {
            this.processActivity(activity);
        }
    }

    private void processActivity(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Task task;
        if (this.m_useActivityCodesForTaskHierarchy) {
            task = this.getParentTask(activity).addTask();
        } else {
            task = this.m_projectFile.addTask();
            this.populateActivityCodes(task, this.getActivityCodes(activity));
        }
        task.setActivityID(activity.getId());
        task.setActualDuration(activity.getActualDuration());
        task.setActualFinish(activity.getActualFinish());
        task.setActualStart(activity.getActualStart());
        task.setCalendar(this.m_projectFile.getCalendarByName(activity.getCalendar()));
        task.setCreateDate(activity.getCreationTime());
        task.setFinish(activity.getCurrentFinish());
        task.setStart(activity.getCurrentStart());
        task.setName(activity.getDescription());
        task.setDuration(activity.getDurationAtCompletion());
        task.setEarlyFinish(activity.getEarlyFinish());
        task.setEarlyStart(activity.getEarlyStart());
        task.setFreeSlack(activity.getFreeFloat());
        task.setLateFinish(activity.getLateFinish());
        task.setLateStart(activity.getLateStart());
        task.setNotes(activity.getNotes());
        task.setBaselineDuration(activity.getOriginalDuration());
        task.setPhysicalPercentComplete(activity.getPhysicalPercentComplete());
        task.setRemainingDuration(activity.getRemainingDuration());
        task.setCost(activity.getTotalCost());
        task.setTotalSlack(activity.getTotalFloat());
        task.setMilestone(this.activityIsMilestone(activity));
        task.setGUID(activity.getUuid());
        if (task.getMilestone()) {
            if (this.activityIsStartMilestone(activity)) {
                task.setFinish(task.getStart());
            } else {
                task.setStart(task.getFinish());
            }
        }
        if (task.getDuration().getDuration() == 0.0) {
            if (DateHelper.compare(task.getStart(), task.getFinish()) > 0) {
                task.setFinish(task.getStart());
            }
            if (task.getActualStart() != null && task.getActualFinish() != null && DateHelper.compare(task.getActualStart(), task.getActualFinish()) > 0) {
                task.setActualFinish(task.getActualStart());
            }
        }
        if (task.getActualStart() == null) {
            task.setPercentageComplete(0);
        } else if (task.getActualFinish() != null) {
            task.setPercentageComplete(100);
        } else {
            Duration remaining = activity.getRemainingDuration();
            Duration total = activity.getDurationAtCompletion();
            if (remaining != null && total != null && total.getDuration() != 0.0) {
                double percentComplete = (total.getDuration() - remaining.getDuration()) * 100.0 / total.getDuration();
                task.setPercentageComplete(percentComplete);
            }
        }
        this.m_activityMap.put(activity.getId(), task);
    }

    private void populateActivityCodes(Task task, Map<UUID, UUID> codeAssignments) {
        for (UUID valueUUID : codeAssignments.values()) {
            ActivityCodeValue value = this.m_activityCodeValues.get(valueUUID);
            if (value == null) continue;
            task.addActivityCode(value);
        }
    }

    private boolean activityIsMilestone(Project.Storepoints.Storepoint.Activities.Activity activity) {
        String type = activity.getType();
        return type != null && type.contains("Milestone");
    }

    private boolean activityIsStartMilestone(Project.Storepoints.Storepoint.Activities.Activity activity) {
        String type = activity.getType();
        return type != null && type.contains("StartMilestone");
    }

    private ChildTaskContainer getParentTask(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Map<UUID, UUID> map = this.getActivityCodes(activity);
        ChildTaskContainer parent = this.m_projectFile;
        StringBuilder uniqueIdentifier = new StringBuilder();
        for (UUID activityCode : this.m_codeSequence) {
            UUID valueUUID = map.get(activityCode);
            String activityCodeText = this.m_activityCodeValues.get(valueUUID) != null ? this.m_activityCodeValues.get(valueUUID).getName() : null;
            if (activityCodeText == null) continue;
            if (uniqueIdentifier.length() != 0) {
                uniqueIdentifier.append('>');
            }
            uniqueIdentifier.append(valueUUID.toString());
            UUID uuid = UUID.nameUUIDFromBytes(uniqueIdentifier.toString().getBytes());
            Task newParent = this.findChildTaskByUUID(parent, uuid);
            if (newParent == null) {
                newParent = parent.addTask();
                newParent.setGUID(uuid);
                newParent.setName(activityCodeText);
            }
            parent = newParent;
        }
        return parent;
    }

    private Task findChildTaskByUUID(ChildTaskContainer parent, UUID uuid) {
        Task result = null;
        for (Task task : parent.getChildTasks()) {
            if (!uuid.equals(task.getGUID())) continue;
            result = task;
            break;
        }
        return result;
    }

    private void readAssignments(Resource mpxjResource, Project.Storepoints.Storepoint.Resources.Resource res) {
        for (Project.Storepoints.Storepoint.Resources.Resource.Assignment assignment : res.getAssignment()) {
            this.readAssignment(mpxjResource, assignment);
        }
    }

    private void readAssignment(Resource resource, Project.Storepoints.Storepoint.Resources.Resource.Assignment assignment) {
        Task task = this.m_activityMap.get(assignment.getActivity());
        if (task != null) {
            task.addResourceAssignment(resource);
        }
    }

    private void readRelationships(Project.Storepoints.Storepoint phoenixProject) {
        Project.Storepoints.Storepoint.Relationships relationships = phoenixProject.getRelationships();
        if (relationships != null) {
            for (Project.Storepoints.Storepoint.Relationships.Relationship relation : relationships.getRelationship()) {
                this.readRelation(relation);
            }
        }
    }

    private void readRelation(Project.Storepoints.Storepoint.Relationships.Relationship relation) {
        Task predecessor = this.m_activityMap.get(relation.getPredecessor());
        Task successor = this.m_activityMap.get(relation.getSuccessor());
        if (predecessor != null && successor != null) {
            Duration lag = relation.getLag();
            RelationType type = relation.getType();
            successor.addPredecessor(predecessor, type, lag);
        }
    }

    Map<UUID, UUID> getActivityCodes(Project.Storepoints.Storepoint.Activities.Activity activity) {
        return this.m_activityCodeCache.computeIfAbsent(activity, this::getActivityCodesForCache);
    }

    private Map<UUID, UUID> getActivityCodesForCache(Project.Storepoints.Storepoint.Activities.Activity activity) {
        HashMap<UUID, UUID> map = new HashMap<UUID, UUID>();
        for (Project.Storepoints.Storepoint.Activities.Activity.CodeAssignment ca : activity.getCodeAssignment()) {
            UUID code = this.getCodeUUID(ca.getCodeUuid(), ca.getCode());
            UUID value = this.getValueUUID(code, ca.getValueUuid(), ca.getValue());
            map.put(code, value);
        }
        return map;
    }

    private Project.Storepoints.Storepoint getCurrentStorepoint(Project phoenixProject) {
        List storepoints = phoenixProject.getStorepoints() == null ? Collections.emptyList() : phoenixProject.getStorepoints().getStorepoint();
        storepoints.sort((o1, o2) -> DateHelper.compare(o2.getCreationTime(), o1.getCreationTime()));
        return (Project.Storepoints.Storepoint)storepoints.get(0);
    }

    private UUID getCodeUUID(UUID uuid, String name) {
        return uuid == null ? UUID.nameUUIDFromBytes(name.getBytes()) : uuid;
    }

    private UUID getValueUUID(UUID parent, UUID uuid, String name) {
        UUID result = uuid == null ? UUID.nameUUIDFromBytes((parent.toString() + ":" + name).getBytes()) : uuid;
        return result;
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            Date plannedStartDate = parentTask.getStart();
            Date plannedFinishDate = parentTask.getFinish();
            Date actualStartDate = parentTask.getActualStart();
            Date actualFinishDate = parentTask.getActualFinish();
            Date earlyStartDate = parentTask.getEarlyStart();
            Date earlyFinishDate = parentTask.getEarlyFinish();
            Date lateStartDate = parentTask.getLateStart();
            Date lateFinishDate = parentTask.getLateFinish();
            boolean critical = false;
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                plannedStartDate = DateHelper.min(plannedStartDate, task.getStart());
                plannedFinishDate = DateHelper.max(plannedFinishDate, task.getFinish());
                actualStartDate = DateHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = DateHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = DateHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = DateHelper.max(earlyFinishDate, task.getEarlyFinish());
                lateStartDate = DateHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = DateHelper.max(lateFinishDate, task.getLateFinish());
                if (task.getActualFinish() != null) {
                    ++finished;
                }
                critical = critical || task.getCritical();
            }
            parentTask.setStart(plannedStartDate);
            parentTask.setFinish(plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            if (plannedStartDate != null && plannedFinishDate != null) {
                Duration duration = this.m_projectFile.getDefaultCalendar().getWork(plannedStartDate, plannedFinishDate, TimeUnit.DAYS);
                parentTask.setDuration(duration);
            }
            parentTask.getTotalSlack();
            parentTask.setCritical(critical);
        }
    }

    private void openLogFile() {
        this.m_log = DebugLogPrintWriter.getInstance();
    }

    private void closeLogFile() {
        if (this.m_log != null) {
            this.m_log.flush();
            this.m_log.close();
        }
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.phoenix.schema.phoenix4", (ClassLoader)Phoenix4Reader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

