/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.common.JdbcOdbcHelper;

public final class DataExportUtility {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) {
        if (argv.length != 2) {
            System.out.println("DataExport <filename> <output directory>");
            return;
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(JdbcOdbcHelper.getMicrosoftAccessJdbcUrl(argv[0]));
            DataExportUtility dx = new DataExportUtility();
            dx.process(connection, argv[1]);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                AutoCloseableHelper.closeQuietly(connection);
                throw throwable;
            }
            AutoCloseableHelper.closeQuietly(connection);
            return;
        }
        AutoCloseableHelper.closeQuietly(connection);
        return;
    }

    public void process(Connection connection, String directory) throws Exception {
        connection.setAutoCommit(true);
        DatabaseMetaData dmd = connection.getMetaData();
        String[] types = new String[]{"TABLE"};
        FileWriter fw = new FileWriter(directory);
        PrintWriter pw = new PrintWriter(fw);
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println();
        pw.println("<database>");
        ResultSet tables = dmd.getTables(null, null, null, types);
        while (tables.next()) {
            this.processTable(pw, connection, tables.getString("TABLE_NAME"));
        }
        pw.println("</database>");
        pw.close();
        tables.close();
    }

    private void processTable(PrintWriter pw, Connection connection, String name) throws Exception {
        int index;
        System.out.println("Processing " + name);
        PreparedStatement ps = connection.prepareStatement("select * from " + name);
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rmd = ps.getMetaData();
        int columnCount = rmd.getColumnCount();
        String[] columnNames = new String[columnCount];
        int[] columnTypes = new int[columnCount];
        for (index = 0; index < columnCount; ++index) {
            columnNames[index] = rmd.getColumnName(index + 1);
            columnTypes[index] = rmd.getColumnType(index + 1);
        }
        pw.println("<table name=\"" + name + "\">");
        StringBuilder buffer = new StringBuilder(255);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm", Locale.UK);
        while (rs.next()) {
            pw.println(" <row>");
            for (index = 0; index < columnCount; ++index) {
                pw.print("  <column name=\"" + columnNames[index] + "\" type=\"" + columnTypes[index] + "\">");
                switch (columnTypes[index]) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        pw.println("[BINARY DATA]");
                        break;
                    }
                    case 91: 
                    case 92: {
                        Object data = rs.getDate(index + 1);
                        if (data == null) break;
                        pw.print(df.format((Date)data));
                        break;
                    }
                    case 93: {
                        Object data = rs.getTimestamp(index + 1);
                        if (data == null) break;
                        pw.print(data);
                        break;
                    }
                    default: {
                        Object data = rs.getString(index + 1);
                        if (data == null) break;
                        pw.print(this.escapeText(buffer, (String)data));
                        break;
                    }
                }
                pw.println("</column>");
            }
            pw.println(" </row>");
        }
        pw.println("</table>");
        ps.close();
    }

    private String escapeText(StringBuilder sb, String text) {
        int length = text.length();
        sb.setLength(0);
        block5: for (int loop = 0; loop < length; ++loop) {
            char c = text.charAt(loop);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    if (!this.validXMLCharacter(c)) continue block5;
                    if (c > '\u007f') {
                        sb.append("&#").append((int)c).append(";");
                        continue block5;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private boolean validXMLCharacter(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }
}

