from setuptools import find_packages, setup

setup(
    name='django-user-sessions',
    use_scm_version={"version_scheme": "post-release"},
    setup_requires=["setuptools_scm"],
    description='Django sessions with a foreign key to the user',
    long_description=open('README.rst').read(),
    author='Bouke Haarsma',
    author_email='bouke@haarsma.eu',
    url='http://github.com/jazzband/django-user-sessions',
    download_url='https://pypi.python.org/pypi/django-user-sessions',
    license='MIT',
    packages=find_packages(exclude=('example', 'tests',)),
    install_requires=['Django>=3.2'],
    include_package_data=True,
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Framework :: Django :: 3.2',
        'Framework :: Django :: 4.0',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Topic :: Security',
    ],
)
