# -*- coding: utf-8 -*-
# (c) Ansible Project
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function
__metaclass__ = type

from mock import MagicMock

from ansible.module_utils.common.locale import get_best_parsable_locale


class TestLocale:
    """Tests for get_best_paresable_locale"""

    mock_module = MagicMock()
    mock_module.get_bin_path = MagicMock(return_value='/usr/bin/locale')

    def test_finding_best(self):
        self.mock_module.run_command = MagicMock(return_value=(0, "C.utf8\nen_US.utf8\nC\nPOSIX\n", ''))
        locale = get_best_parsable_locale(self.mock_module)
        assert locale == 'C.utf8'

    def test_finding_last(self):
        self.mock_module.run_command = MagicMock(return_value=(0, "fr_FR.utf8\nen_UK.utf8\nC\nPOSIX\n", ''))
        locale = get_best_parsable_locale(self.mock_module)
        assert locale == 'C'

    def test_finding_middle(self):
        self.mock_module.run_command = MagicMock(return_value=(0, "fr_FR.utf8\nen_US.utf8\nC\nPOSIX\n", ''))
        locale = get_best_parsable_locale(self.mock_module)
        assert locale == 'en_US.utf8'

    def test_finding_prefered(self):
        self.mock_module.run_command = MagicMock(return_value=(0, "es_ES.utf8\nMINE\nC\nPOSIX\n", ''))
        locale = get_best_parsable_locale(self.mock_module, preferences=['MINE', 'C.utf8'])
        assert locale == 'MINE'

    def test_finding_C_on_no_match(self):
        self.mock_module.run_command = MagicMock(return_value=(0, "fr_FR.UTF8\nMINE\n", ''))
        locale = get_best_parsable_locale(self.mock_module)
        assert locale == 'C'
