# Generated by Django 5.0.2 on 2024-02-14 12:29

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("artd_customer", "0002_customergroup_customer_customer_group_and_more"),
        ("artd_partner", "0001_initial"),
        ("artd_product", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Coupon",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Designates whether this record is active or not.",
                        verbose_name="status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date time on which the object was created.",
                        verbose_name="created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date time on which the object was last updated.",
                        verbose_name="updated at",
                    ),
                ),
                (
                    "code",
                    models.SlugField(
                        help_text="Coupon code.", unique=True, verbose_name="code"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Coupon name.", max_length=100, verbose_name="name"
                    ),
                ),
                (
                    "start_date",
                    models.DateTimeField(
                        help_text="Coupon start date.", verbose_name="start date"
                    ),
                ),
                (
                    "end_date",
                    models.DateTimeField(
                        help_text="Coupon end date.", verbose_name="end date"
                    ),
                ),
                (
                    "is_percentage",
                    models.BooleanField(
                        default=True,
                        help_text="Designates whether this coupon is percentage or not.",
                        verbose_name="is percentage",
                    ),
                ),
                (
                    "value",
                    models.FloatField(
                        default=0, help_text="Coupon value.", verbose_name="value"
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner.",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="partner",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PromotionRule",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "categories",
                    models.ManyToManyField(
                        help_text="Product categories.",
                        to="artd_product.category",
                        verbose_name="product categories",
                    ),
                ),
                (
                    "coupon",
                    models.ForeignKey(
                        help_text="Coupon.",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_promotion.coupon",
                        verbose_name="coupon",
                    ),
                ),
                (
                    "customer_groups",
                    models.ManyToManyField(
                        help_text="Customer types.",
                        to="artd_customer.customergroup",
                        verbose_name="customer types",
                    ),
                ),
                (
                    "products",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Selected products.",
                        to="artd_product.product",
                        verbose_name="selected products",
                    ),
                ),
            ],
        ),
    ]
