from gbd_mapping import causes
from gbd_mapping.base_template import Restrictions
from gbd_mapping.id import rei_id

from .alternative_risk_factor_template import (
    AlternativeRiskFactor,
    AlternativeRiskFactors,
)

alternative_risk_factors = AlternativeRiskFactors(
    child_underweight=AlternativeRiskFactor(
        name="child_underweight",
        kind="alternative_risk_factor",
        gbd_id=rei_id(94),
        level=4,
        most_detailed=True,
        distribution="ensemble",
        population_attributable_fraction_calculation_type="categorical",
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        affected_causes=(
            causes.all_causes,
            causes.communicable_maternal_neonatal_and_nutritional_diseases,
            causes.diarrheal_diseases,
            causes.lower_respiratory_infections,
            causes.measles,
            causes.nutritional_deficiencies,
            causes.protein_energy_malnutrition,
            causes.respiratory_infections_and_tuberculosis,
            causes.enteric_infections,
            causes.other_infectious_diseases,
            causes.all_causes,
            causes.communicable_maternal_neonatal_and_nutritional_diseases,
            causes.diarrheal_diseases,
            causes.lower_respiratory_infections,
            causes.measles,
            causes.nutritional_deficiencies,
            causes.protein_energy_malnutrition,
            causes.respiratory_infections_and_tuberculosis,
            causes.enteric_infections,
            causes.other_infectious_diseases,
        ),
        population_attributable_fraction_of_one_causes=(causes.protein_energy_malnutrition,),
    ),
    child_wasting=AlternativeRiskFactor(
        name="child_wasting",
        kind="alternative_risk_factor",
        gbd_id=rei_id(240),
        level=4,
        most_detailed=True,
        distribution="ensemble",
        population_attributable_fraction_calculation_type="categorical",
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        affected_causes=(
            causes.all_causes,
            causes.communicable_maternal_neonatal_and_nutritional_diseases,
            causes.diarrheal_diseases,
            causes.lower_respiratory_infections,
            causes.measles,
            causes.nutritional_deficiencies,
            causes.protein_energy_malnutrition,
            causes.respiratory_infections_and_tuberculosis,
            causes.enteric_infections,
            causes.other_infectious_diseases,
            causes.all_causes,
            causes.communicable_maternal_neonatal_and_nutritional_diseases,
            causes.diarrheal_diseases,
            causes.lower_respiratory_infections,
            causes.measles,
            causes.nutritional_deficiencies,
            causes.protein_energy_malnutrition,
            causes.respiratory_infections_and_tuberculosis,
            causes.enteric_infections,
            causes.other_infectious_diseases,
        ),
        population_attributable_fraction_of_one_causes=(causes.protein_energy_malnutrition,),
    ),
    child_stunting=AlternativeRiskFactor(
        name="child_stunting",
        kind="alternative_risk_factor",
        gbd_id=rei_id(241),
        level=4,
        most_detailed=True,
        distribution="ensemble",
        population_attributable_fraction_calculation_type="categorical",
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=5,
            yld_age_group_id_start=4,
            yld_age_group_id_end=5,
        ),
        affected_causes=(
            causes.all_causes,
            causes.communicable_maternal_neonatal_and_nutritional_diseases,
            causes.diarrheal_diseases,
            causes.lower_respiratory_infections,
            causes.measles,
            causes.respiratory_infections_and_tuberculosis,
            causes.enteric_infections,
            causes.other_infectious_diseases,
            causes.all_causes,
            causes.communicable_maternal_neonatal_and_nutritional_diseases,
            causes.diarrheal_diseases,
            causes.lower_respiratory_infections,
            causes.measles,
            causes.respiratory_infections_and_tuberculosis,
            causes.enteric_infections,
            causes.other_infectious_diseases,
        ),
        population_attributable_fraction_of_one_causes=(),
    ),
)
