# Credentials Safe

<badges>![version](https://img.shields.io/pypi/v/credsafe.svg)
![license](https://img.shields.io/pypi/l/credsafe.svg)
![pyversions](https://img.shields.io/pypi/pyversions/credsafe.svg)
![powered](https://img.shields.io/badge/Powered%20by-UTF8-red.svg)
![made](https://img.shields.io/badge/Made%20with-PyCharm-red.svg)
</badges>

<i>Store application credentials in keyring with RSA.</i>

# Hierarchy

```
credsafe
'---- Agent()
    |---- set()
    |---- get()
    '---- rm()
```

# Example

## python
```python
from credsafe import *

# initialize an agent
kp = {  # check easyrsa for more info
    "private_key": b"...",
    "public_key": b"..."
}
import os
# remember this key otherwise you cannot get credentials
key = os.urandom(64)
credsafe_agent = Agent(app_name="my app", key_pair=kp, hmac_key=key)

# set something for a user
credsafe_agent.set(id="username", pw="password", k="phone", v=123456789)
credsafe_agent.set(id="username", pw="password", k="config", v={"something": "secret"})

# get something for a user
print(credsafe_agent.get(id="username", pw="password", k="phone"))
# 123456789
print(credsafe_agent.get(id="username", pw="password", k="config"))
# {"something": "secret"}

# remove something for a user
credsafe_agent.rm(id="username", pw="password", k="config")
print(credsafe_agent.get(id="username", pw="password", k="config"))
# KeyError
```

## shell
```shell script

```