# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bt_dualboot',
 'bt_dualboot.bt_linux',
 'bt_dualboot.bt_sync_manager',
 'bt_dualboot.bt_windows',
 'bt_dualboot.cli',
 'bt_dualboot.windows_registry']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['bt-dualboot = bt_dualboot.cli.app:main']}

setup_kwargs = {
    'name': 'bt-dualboot',
    'version': '1.0.0',
    'description': 'Sync Bluetooth for dualboot Linux and Windows',
    'long_description': '\nSync Bluetooth for dualboot Linux and Windows\n=============================================\n\nUser-friendly tool making your bluetooth devices working both in Windows and Linux without re-pairing chore.\n  [more about dualboot Bluetooth issue](#dualboot-bluetooth-issue)\n\n### bt-dualboot\n  * doesn\'t require to reboot 3 times\n  * ask you as much fewer details as possible\n  * ... [see all advantages and alternatives](#advantages-and-alternatives)\n\n[How to install](#prerequisites)\n\n**For developers**: checkout the [Developer insights](README-dev.md) for useful development and testings tips.\n\n### Usage: shortest way\n\nAssuming you have paired devices in Windows already, boot to Linux and paired them too.\nSyncing would be simple as following 2 steps:\n\n**1. Mount Windows partition**\n\nApplication will probe and use mounted Windows partition automatically. Otherwise use [--win /mnt/win/path/](#--win-mntwinpath).\nPartition should be mounted with [write access](#troubleshooting-windows-partition-write-access).\n\n**2. Sync all devices available for sync**\n\n```console\n$ sudo bt-dualboot --sync-all\n\nSyncing...\n==========\n [C2:9E:1D:E2:3D:A5] Keyboard K380\n...done\n\n```\n\nNOTES:\n  (i) **sudo** tip: this tool needs read-only access to bluetooth devices configuration files which is inaccessible for regular user.\n  (ii) [--backup vs --no-backup](#--backup-vs---no-backup): you will be asked about your Windows Registry backup strategy\n  (iii) use `--dry-run` to preview any command effects\n\n### Usage: choose device manually\n\n1. List devices info\n\n```console\n$ sudo bt-dualboot -l\n\nWorks both in Linux and Windows\n===============================\n [A4:BF:C6:D0:E5:FF] WH-1000XM4\n\nNeeds sync\n==========\n\nFollowing devices available for sync with `--sync-all` or `--sync MAC` options.\n\n [C2:9E:1D:E2:3D:A5] Keyboard K380\n\nHave to be paired in Windows\n============================\n\nFollowing devices unavailable for sync unless you boot Windows and pair them\n\n [E9:1D:FE:2A:C3:C8] JBL GO\n\n```\n\n\n2. Sync devices using MAC\n\n```console\n$ sudo bt-dualboot --sync C2:9E:1D:E2:3D:A5\n\nSyncing...\n==========\n [C2:9E:1D:E2:3D:A5] Keyboard K380\n...done\n\n```\n\nSee [`bt-dualboot -h`](#cli-reference) and chapters below for details.\n\n## Prerequisites \n\n* Python 3.6+ installed.\n\n* `chntpw` package installed:\n\n```console\nUbuntu $ sudo apt install chntpw\n...\n```\n\nsee https://pogostick.net/~pnh/ntpasswd/\n\n\n## Install\n\n```console\n$ sudo pip install bt-dualboot\n```\n\nNOTES: **sudo** - application requires read-only access to bluetooth devices configuration files which is inaccessible for regular user. Native OS packages will be added in next releases.\n\n### Supported OS\n\nTested with Linux Mint 19.3, 20.3 (Ubutntu 18.04 bionic, 20.04 focal), Windows 10\n\nSupported: \n\n* Potentially any Linux-based systems keeping bluetooth configuration in similar format as Ubuntu\n* Windows 10+\n\nWith next releases more OSes will be tested, Mac OS support will be added.\n\n\n## Advanced usage\n\n### --backup vs --no-backup\n\nWindows Registry update performed in the safe way using `chntpw/reged` without changing Hive-file\'s size (`reged -N -E`). Nevertheless `chntpw` is non-official tool hence backup is not bad idea. Application would perform it as you prefer.\n\nYou have to choose your backup strategy explicitly.\n\n```console\n$ sudo bt-dualboot --sync-all \nusage: ....\nbt-dualboot: error: Neither backup option given!\n\n    Windows Registry Hive file will be updated!\n    chntpw/reged tool is non-official and hackish Hive file editing tool.\n    It is recommended to do backup prior writing into Hive file.\n\n    Use:\n      -b [path], --backup [path]    [default: /var/backup/bt-dualboot]\n      -n, --no-backup               process without backup\n\n    WARNING:\n        Windows Registry Hive file may contain sensitive data. You shouldn\'t keep this file\n        on a storage which may be accessed by others. Consider to remove backup files as soon\n        as possible after ensure Windows boots and works correctly.\n```\n\n### --win /mnt/win/path/\n\nBy default application will recognize and use mounted Windows partition. In case when it didn\'t found or more than single Windows partition exist you have to provide mount point with `--win` paramter.\n\nUse `--list-win-mounts` to list recognized Windows partitions.\n\n```console\n$ bt-dualboot --lsit-win-mounts\n\nWindows locations:\n==================\n /media/user/win_foo\n /media/user/win_bar\n \n$ sudo bt-dualboot --win /media/user/win_foo -l\n```\n\n#### Troubleshooting: Windows partition write access\n\nIn case when Windows partition mounted in read-only mode, you have to remount it for read-write:\n\n```console\n$ sudo mount -o remount,rw /mnt/win/path\n```\n\n### Machine processing\n\n`--bot` flag enables better parsable output for usage in scripts.\n\n\n## Dualboot Bluetooth issue\n\nEvery time when a Bluetooth device paired in one dualboot OS it stop working in another one. It happens because both OS uses the same Bluetooth adapter with the same MAC. Each pairing process generates new pairing keys for adapter\'s MAC. This way previous pairing key which saved in another OS becomes obsolete.\n\nThe solution is to sync saved pairing keys for both OS. This answer describes ways to handle this manually: https://unix.stackexchange.com/a/255510/411221\n\nThis application implements the way suggested by the [comment](https://unix.stackexchange.com/questions/255509/bluetooth-pairing-on-dual-boot-of-windows-linux-mint-ubuntu-stop-having-to-p#comment545967_255510) which copies pairng keys directly from Linux to Windows avoiding multiple reboots.\n\n\n## Advantages and alternatives\n\n**bt-dualboot**:\n\n* doesn\'t require to reboot multiple times\n* [simple install](#prerequisites)\n* provides single [simple cli](#cli-reference), doesn\'t require invoke additional scripts\n* discower mounted Windows partition automatically\n* safe update of Windows Registry without changing file size (rewrite only)\n* [backup Windows Registry](#--backup-vs---no-backup) prior update\n* doesn\'t require import/export files, handle encoding issues\n* allows `--dry-run` prior actual changes\n\n### alternatives\n\ncheckout ["bluetooth dualboot" on github](https://github.com/search?q=bluetooth+dualboot&type=repositories)\n\n**solved by invoke single tool under Linux: sync keys from Linux into Windows registry**: \n\n(similar approach to bt-dualboot)\n\n* (anounced) https://github.com/nbrideau/bluetooth-key-sync\n\n**solved by invoke multiple tools under Windows and Linux: sync keys from Windows registry into Linux configs**:\n\n(requires more steps and reboots, involves using windows tools, manage import/export files)\n\nMost soulutions is kind of import tool of Windows `*.reg` file into Linux bluetooth configuration.\n\n* [UI] https://github.com/nagi1999a/BluetoothDualBootHelper\n* [simple cli] https://github.com/ademlabs/synckeys\n* https://github.com/Krakenus/bluetooth-dualboot-fixer\n* https://github.com/LondonAppDev/dual-boot-bluetooth-pair\n* https://github.com/heyzec/dual-boot-mouse\n* https://github.com/arunpandian7/DuoPair-Bluetooth\n* https://github.com/luismaf/bluetooth-dual-boot\n* [repeative arguments] https://github.com/aryklein/dualBootMouse\n\n\n**Mac OS**:\n\n* https://github.com/HenrySeed/macosDualBootingBluetoothKeys\n* https://github.com/sarneeh/mac-win-dualboot-bt\n\n\n## Cli reference\n\n```console\n$ bt-dualboot -h\nusage: bt-dualboot [-h] [-l] [--list-win-mounts] [--bot] [--dry-run] [--win MOUNT] [--sync MAC [MAC ...]] [--sync-all] [-n] [-b [path]]\n\nSync bluetooth keys from Linux to Windows.\n\noptional arguments:\n  -h, --help            show this help message and exit\n\nList resources:\n  -l, --list            [root required] list bluetooth devices\n  --list-win-mounts     list mounted Windows locations\n  --bot                 parsable output for robots (supported: -l)\n\nSync keys:\n  --dry-run             print actions to do without invocation\n  --win MOUNT           Windows mount point (advanced usage)\n  --sync MAC [MAC ...]  [root required] sync specified device\n  --sync-all            [root required] sync all paired devices\n\nBackup Windows Registry:\n  -n, --no-backup       process without backup\n  -b [path], --backup [path]\n                        path to backup directory, default: /var/backup/bt-dualboot\n```\n\n## Next releases\n\nFirst priority is to extend list of tested and supported OS.\n\nGeneral roadmap assumes creating GUI and background service versions, adding sync Linux to Linux ability.\n\n',
    'author': 'Konstantin Ivanov',
    'author_email': 'KEIvanov@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/x2es/bt-dualboot.git',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
