#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['hepfile']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['numpy >=1.13.3', 'h5py', 'awkward >= 1.4', 'pre-commit']

extras_require = \
{":python_version<'3.5'": ['typing'],
 'awkward': ['awkward >= 1.4'],
 'dev': ['pytest >=6'],
 'docs': ['Sphinx >=3.0.0',
          'myst_parser>=0.13',
          'sphinx-book-theme>=0.0.33',
          'sphinx_copybutton'],
 'test': ['pytest >=6']}

setup(name='hepfile',
      version='0.1.3',
      description='A file description modeled after the ROOT analysis toolkit and common use-cases in High Energy Physics. Implemented in HDF5, hepfile stands for Heterogeneous Entries in Parallel-file. ',
      author='Matt Bellis',
      author_email='matthew.bellis@gmail.com',
      url='https://github.com/mattbellis/hepfile',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
