"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class MessagingResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const MessagingResourceProvider = new cr.Provider(this, 'MessagingResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.messagingCustomResource = new aws_cdk_lib_1.CustomResource(this, 'messagingCustomResource', {
            serviceToken: MessagingResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = cdk.Stack.of(this);
        const constructName = 'MessagingResources';
        const existing = stack.node.tryFindChild(constructName);
        if (existing) {
            return existing;
        }
        const messagingCustomResourceRole = new iam.Role(this, 'messagingCustomResourceRole', {
            description: 'Amazon Chime SDK Messaging Resources',
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:CreateAppInstance',
                                'chime:CreateChannelFlow',
                                'chime:DeleteChannelFlow',
                                'chime:DescribeAppInstance',
                                'chime:ListAppInstances',
                                'chime:UpdateAppInstance',
                                'chime:DeleteAppInstance',
                                'chime:CreateAppInstanceUser',
                                'chime:DeleteAppInstanceUser',
                                'chime:ListAppInstanceUsers',
                                'chime:UpdateAppInstanceUser',
                                'chime:DescribeAppInstanceUser',
                                'chime:CreateAppInstanceAdmin',
                                'chime:DescribeAppInstanceAdmin',
                                'chime:ListAppInstanceAdmins',
                                'chime:DeleteAppInstanceAdmin',
                                'chime:PutAppInstanceRetentionSettings',
                                'chime:GetAppInstanceRetentionSettings',
                                'chime:PutAppInstanceStreamingConfigurations',
                                'chime:GetAppInstanceStreamingConfigurations',
                                'chime:DeleteAppInstanceStreamingConfigurations',
                                'chime:TagResource',
                                'chime:UntagResource',
                                'chime:ListTagsForResource',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                            ],
                        }),
                    ],
                }),
                ['kinesisPolicy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            resources: [
                                `arn:aws:kinesis:${stack.region}:${stack.account}:stream/chime-messaging-*`,
                            ],
                            actions: ['kinesis:DescribeStream'],
                        }),
                    ],
                }),
                ['ssmPolicy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new lambda.Function(stack, constructName, {
            runtime: lambda.Runtime.PYTHON_3_9,
            code: lambda.Code.fromAsset(path.join(__dirname, '../../resources/messaging')),
            handler: 'index.handler',
            architecture: lambda.Architecture.ARM_64,
            role: messagingCustomResourceRole,
            timeout: cdk.Duration.minutes(1),
        });
        return fn;
    }
}
exports.MessagingResources = MessagingResources;
_a = JSII_RTTI_SYMBOL_1;
MessagingResources[_a] = { fqn: "cdk-amazon-chime-resources.MessagingResources", version: "0.1.115" };
//# sourceMappingURL=data:application/json;base64,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