# -*- coding: utf-8 -*-

import sys
import os
import sphinx_bootstrap_theme
import matplotlib
from unittest import TestCase, TestResult
matplotlib.use('Agg')  # Force matplotlib to not use any Xwindows backend.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath('../../'))

# -- Project information -----------------------------------------------------

project = 'sknrf'
copyright = '2017, Scikit-NRF Team'
author = 'Dylan T Bespalko'

split_version = "0.0.0"
with open('../../sknrf/__init__.py') as fid:
    for line in fid:
        if line.startswith('__version__'):
            split_version = line.strip().split()[-1].strip("'").split(".")
            break
# The short X.Y version.
version = ".".join(split_version[0:-1])
# The full version, including alpha/beta/rc tags.
release = ".".join(split_version)


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinxcontrib.plantuml',
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.coverage',
    'sphinx.ext.todo',
    'sphinx.ext.mathjax',
    'sphinx.ext.ifconfig',
    'numpydoc',
    'sphinx.ext.todo',
    'sphinx.ext.githubpages',
    "sphinxcontrib.drawio",
    "myst_parser"
]
mathjax_path = "https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.1/MathJax.js?config=TeX-AMS-MML_HTMLorMML"
numpydoc_show_class_members = False

unittest_TestCase_methods = ", ".join(list(TestCase.__dict__.keys()))
unittest_TestResult_methods = ", ".join(list(TestResult.__dict__.keys()))

autodoc_default_options = {
    'member-order': 'bysource',
    'special-members': '',
    'undoc-members': False,
    'inherited-members': False,
    'exclude-members': ", ".join(('__weakref__', unittest_TestCase_methods, unittest_TestResult_methods)),
    'show-inheritance': False
}

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = {
    '.rst': 'restructuredtext',
   '.txt': 'markdown',
   '.md': 'markdown',
}

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = ["**/*.rst.rst", '**tests**', '**sknrf.tutorial**', '**/README.md']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
modindex_common_prefix = ["sknrf.device.",
                          "sknrf.model.",
                          "sknrf.view.desktop.",
                          "sknrf."]

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
sys.path.append(os.path.abspath('_themes'))
html_theme = 'bootstrap'
html_theme_options = {
    'navbar_title': "scikit-nrf",
    'source_link_position': "nav",
    'navbar_sidebarrel': True,
    'navbar_pagenav': False,
    'navbar_pagenav_name': "Page",
    'globaltoc_includehidden': "true",
    'navbar_class': "navbar navbar",
    'navbar_fixed_top': "true",
    'globaltoc_depth': 2,
    'bootstrap_version': "3",
    'bootswatch_theme': "sandstone",
    'navbar_links': [
       ("Drivers", "./drivers.html", True),
    ],
    }

html_sidebars = {'**': ['localtoc.html']}

# # Theme options are theme-specific and customize the look and feel of a theme
# # further.  For a list of options available for each theme, see the
# # documentation.
# html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = ['_themes']

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
html_short_title = "scikit-nrf Documentation"

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
# html_logo = "_images/ICO/sknrf_logo_icon.ico"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "_images/ICO/sknrf_logo_icon.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
#html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_domain_indices = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
#html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Language to be used for generating the HTML full-text search index.
# Sphinx supports the following languages:
#   'da', 'de', 'en', 'es', 'fi', 'fr', 'hu', 'it', 'ja'
#   'nl', 'no', 'pt', 'ro', 'ru', 'sv', 'tr'
#html_search_language = 'en'

# A dictionary with options for the search language support, empty by default.
# Now only 'ja' uses this config value
#html_search_options = {'type': 'default'}

# The name of a javascript file (relative to the configuration directory) that
# implements a search results scorer. If empty, the default will be used.
#html_search_scorer = 'scorer.js'

# Output file base name for HTML help builder.
htmlhelp_basename = 'sknrfdoc'

