filename = strrep(strcat(pwd, '\mipi.csv'), '\', '\\');
delete(filename);
close all;
clear all;
config_filename = strrep(strcat(pwd, '\mipi_config.csv'), '\', '\\');
et = qti.rffe.drivers.ModulatorQET5100v1p0(4);
mipi = qti.instruments.mipi.LatticeMIPI('LTC::1::INSTR;', '', '');
et.load();
et.initialise(mipi);
fileID = fopen(config_filename,'rt');
mipi_config = textscan(fileID, '%s%s%s%s%s%s%[^\n\r]', 'Delimiter', ',', 'TextType', 'string',  'ReturnOnError', false);
fclose(fileID);
et.portStr = char(mipi_config{1});
et.techStr = char(mipi_config{2});
et.modeStr = char(mipi_config{3});
et.bandStr = char(mipi_config{4});
et.chanBwStr = char(mipi_config{5});
et.signalBwStr = char(mipi_config{6});
prog = et.getProgram();
mipi.actionImmediate(prog);