import os
import sipconfig
from PyQt4 import pyqtconfig

# The name of the SIP build file generated by SIP and used by the build
# system.
build_file = "foolib.sbf"

# Get the PyQt4 configuration information.
config = pyqtconfig.Configuration()
PYTHON_DIR = "/Users/dylanbespalko/anaconda/envs/py34"
PYTHON_PACKAGES = PYTHON_DIR + "/lib/python3.4/site-packages"

SRC_DIR = "../src"
QT_DIR = "/usr/local/Trolltech/Qt-4.8.7"
QT_INC = QT_DIR + "/include"
QTCORE_INC = QT_DIR + "/include/QtCore"
QTGUI_INC = QT_DIR + "/include/QtGui"

# Get the extra SIP flags needed by the imported PyQt4 modules.  Note that
# this normally only includes those flags (-x and -t) that relate to SIP's
# versioning system.
pyqt_sip_flags = config.pyqt_sip_flags

# Run SIP to generate the code.  Note that we tell SIP where to find the qt
# module's specification files using the -I flag.
os.system(" ".join([config.sip_bin, "-c", ".", "-b", build_file, "-I", config.pyqt_sip_dir, pyqt_sip_flags, "foolib.sip"]))

# Create the Makefile.
makefile = sipconfig.SIPModuleMakefile(config, build_file)

# Add the library we are wrapping.  The name doesn't include any platform
# specific prefixes or extensions (e.g. the "lib" prefix on UNIX, or the
# ".dll" extension on Windows).
makefile.extra_lib_dirs = [SRC_DIR, PYTHON_DIR + "/lib", QT_DIR + "/lib"]
makefile.extra_libs = ["FooLib", "python3.4m", "QtCore", "QtGui"]
makefile.extra_include_dirs = [SRC_DIR, QT_INC, QTCORE_INC, QTGUI_INC]

# Generate the Makefile itself.
makefile.generate()