"use strict";
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const queue_base_1 = require("./queue-base");
queue_base_1.QueueBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/SQS',
        metricName,
        dimensions: { QueueName: this.queueName },
        ...props
    }).attachTo(this);
};
queue_base_1.QueueBase.prototype.metricApproximateAgeOfOldestMessage = function (props) {
    return this.metric('ApproximateAgeOfOldestMessage', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricApproximateNumberOfMessagesDelayed = function (props) {
    return this.metric('ApproximateNumberOfMessagesDelayed', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricApproximateNumberOfMessagesNotVisible = function (props) {
    return this.metric('ApproximateNumberOfMessagesNotVisible', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricApproximateNumberOfMessagesVisible = function (props) {
    return this.metric('ApproximateNumberOfMessagesVisible', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfEmptyReceives = function (props) {
    return this.metric('NumberOfEmptyReceives', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfMessagesDeleted = function (props) {
    return this.metric('NumberOfMessagesDeleted', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfMessagesReceived = function (props) {
    return this.metric('NumberOfMessagesReceived', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfMessagesSent = function (props) {
    return this.metric('NumberOfMessagesSent', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricSentMessageSize = function (props) {
    return this.metric('SentMessageSize', { statistic: 'Average', ...props });
};
//# sourceMappingURL=data:application/json;base64,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