#!/usr/bin/env python
# -*- coding: utf-8 -*-
from setuptools import find_packages, setup

extras_require = {
    "test": [
        "pytest>=6.2.5,<7",
        "pytest-xdist>=2.4.0,<3",
        "tox==3.14.6",
        "hypothesis==4.54.0",
        "mypy-extensions>=0.4.1,<1.0.0",
    ],
    "yaml": [
        "ruamel.yaml==0.17.21",
    ],
    "lint": [
        "black>=22.6.0,<23",
        "flake8==3.7.9",
        "isort>=5.10.1,<6",
        "pydocstyle>=5.0.0,<6",
    ],
    "doc": [
        "Sphinx>=1.6.5,<2",
        "sphinx_rtd_theme>=0.1.9,<1",
        "Jinja2<3",
        "MarkupSafe<2",
        "towncrier>=21,<22",
    ],
    "dev": [
        "bumpversion>=0.5.3,<1",
        "wheel",
        "twine",
        "ipython",
        "pre-commit==1.18.3",
        "pytest-watch>=4.1.0,<5",
    ],
}

extras_require["dev"] = (
    extras_require["dev"]
    + extras_require["test"]
    + extras_require["lint"]
    + extras_require["doc"]
    + extras_require["yaml"]
)

with open("./README.md") as readme:
    long_description = readme.read()


setup(
    name="pulse-ssz",
    # *IMPORTANT*: Don't manually change the version here. Use `make bump`, as described in readme
    version="0.4.0",
    description="""pulse-ssz: Python implementation of the Simple Serialization encoding and decoding""",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="PulseChain team",
    author_email="aggris2@gmail.com",
    url="https://gitlab.com/aggris2/py-pulse-ssz",
    include_package_data=True,
    install_requires=[
        "eth-utils>=1,<2",
        "lru-dict>=1.1.6",
        # When updating to a newer version of pyrsistent, please check that the interface
        # `transform` expects has not changed (see https://github.com/tobgu/pyrsistent/issues/180)
        "pyrsistent>=0.16.0,<0.17",
    ],
    setup_requires=[],
    python_requires=">=3.7, <4",
    extras_require=extras_require,
    py_modules=["pulse-ssz"],
    license="MIT",
    zip_safe=False,
    keywords="pulsechain",
    packages=find_packages(exclude=["tests", "tests.*"]),
    package_data={"pulse-ssz": ["py.typed"]},
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: MacOS",
        "Operating System :: POSIX",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: Implementation :: PyPy",
    ],
)
