"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedInstanceRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class ManagedInstanceRole extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        var managedPolicies = props.managedPolicies === undefined ? [] : props.managedPolicies;
        props.domainJoinEnabled = props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true;
        props.ssmManagementEnabled = props.ssmManagementEnabled === undefined ||
            props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true ||
            props.ssmManagementEnabled === true;
        if (props.ssmManagementEnabled) {
            managedPolicies.push(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        }
        ;
        if (props.domainJoinEnabled) {
            managedPolicies.push(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMDirectoryServiceAccess'));
        }
        ;
        const role = new iam.Role(this, 'role', {
            assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com'),
            managedPolicies,
        });
        this.instanceProfile = new iam.CfnInstanceProfile(this, 'instanceProfile', {
            roles: [role.roleName],
        });
    }
}
exports.ManagedInstanceRole = ManagedInstanceRole;
_a = JSII_RTTI_SYMBOL_1;
ManagedInstanceRole[_a] = { fqn: "@renovosolutions/aws-cdk-managed-instance-role.ManagedInstanceRole", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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