>>> from nessvec.indexers import Index
... import pandas as pd
... from nessvec.files import load_embeddings
... df = load_embeddings('word2vec')
... small = df.iloc[:300_000]
... index = Index(small)
... docvector = index.get_doc_vector("This is a planet.")
... nearest = index.get_nearest(docvector)
...
>>> index.get('a')
array([-0.01709237, -0.28644821, -0.22127849,  0.3607651 ,  1.7157621 ,
        0.14059832,  0.63868086,  1.24874334,  0.43179559,  0.46157876,
        0.17006469,  0.40910414, -1.64711065,  0.25743477,  0.79914145,
       -1.51572273,  0.03737058, -2.39876997,  0.80178743, -0.63415395,
        0.27704545, -1.2525016 , -2.07742619, -0.60759051,  1.10985719,
       -1.3895296 , -0.52473758,  0.68650388,  0.01256952,  0.3971336 ,
       -0.73703008,  1.07751164, -0.63137304,  0.31532058,  1.81155013,
        1.08598802,  0.89523615, -0.13255137,  2.00480694, -0.64576643,
        1.10225489,  0.84353617, -1.40858185, -0.81585466,  1.73998601,
       -0.75097225,  0.16502129,  1.01106987,  0.93417299, -0.22430595,
        0.41556684,  0.09315313,  0.89470955, -0.89219764,  0.99602541,
        0.7376439 , -0.61215625,  0.27270249,  1.46284576, -0.93540164,
        0.17423099,  0.73638914,  0.06891257, -1.36091389, -0.43371414,
       -0.57782192, -1.71281984, -0.21035519,  0.36713408,  0.67569982,
       -1.54703115,  0.46786708,  0.18227984,  0.11912151, -0.68580531,
       -1.34131289, -0.91404236,  0.75742366,  1.20976135,  0.51690041,
        0.38538527,  0.72593605, -0.25392316, -1.2453739 , -1.23616393,
        0.80184418, -0.11210733, -0.13833663,  1.9238361 , -0.59687251,
       -0.3396524 ,  0.02432202,  0.18958508, -0.76954979, -1.24572826,
       -0.51013215, -1.19442037,  0.26825158, -0.52757041, -0.13552411,
        0.20575983,  0.17049547,  0.29340055, -0.47628274, -0.98397219,
       -0.61675813,  0.64113926, -0.49755361,  0.65560995,  0.55363668,
        0.99703513,  1.51556831, -0.36661936, -1.01392332,  0.25455009,
       -0.64502382,  1.30422173,  2.34334954,  0.91945266, -1.64222938,
       -0.41646523,  1.24945382, -1.03891033,  0.74149716, -0.59388228,
        0.33726756,  2.28584548,  0.08492731, -0.79618364, -0.89927153,
       -1.13389983, -0.51188166, -0.07068825, -0.5225368 , -0.34408234,
       -0.04304491,  1.56834181, -0.6048591 ,  0.85947353, -0.41267923,
        0.88097971,  0.1286126 , -0.36203008,  0.08797882,  0.43830633,
       -0.50251054, -0.54229866, -0.48783502,  0.12364678, -0.29082033,
       -2.00789956, -0.94783278, -0.09110568, -0.73780336, -0.30847423,
        1.45394778,  0.18180503, -0.1777716 , -0.33225173, -0.57386394,
       -0.85248549,  1.71841561, -0.52402497,  1.70310831, -1.1458438 ,
        0.30429916,  0.77711284, -0.06591411, -0.15462875, -1.34088442,
       -1.09915804, -0.81829494, -0.44220778,  0.2561074 , -0.2534165 ,
        0.91093136,  0.76046749,  1.13939035,  0.16323419,  0.89238663,
        1.89112508, -0.74371294, -1.02113903,  0.82022482, -0.53233754,
       -0.35488673, -0.23754814,  0.61715831,  0.14083679,  0.87681856,
        0.18919851, -0.31494811,  0.8472167 , -0.82169426,  0.37668725,
        2.18340703, -1.06496578,  1.51183063, -1.79738934, -1.77773324,
        1.25743936, -0.30412144,  0.33170049, -1.23524808,  0.73056995,
       -0.75169916, -0.47375424,  1.72436473, -0.26766405, -0.68797853,
        0.24101611, -1.07744765,  0.48203579, -0.05710892, -0.70235327,
        0.7330519 ,  1.34308929,  0.38885822,  0.67625119,  2.5193115 ,
       -1.36135276,  0.89625085,  0.35207509,  1.25826632,  0.33427536,
        0.22274182,  0.81281001, -0.95112283,  2.41233218, -1.1707785 ,
       -0.09726436, -1.03538288, -0.14666969, -0.14372124, -0.30697297,
       -1.14528565,  0.17052835,  1.45451396,  0.2622176 , -1.89104412,
        0.28794898, -0.66190553, -0.05404354, -0.5494156 ,  0.7521273 ,
       -2.18615985,  0.16298421, -0.40981844,  2.52695681, -0.8571787 ,
       -0.85168545,  1.75574963, -0.81734642, -1.19034452, -1.36239434,
       -0.0207515 , -1.30193308, -0.31735279,  0.44566478, -0.21746313,
        0.15382784, -1.74404738, -0.48452277,  0.37785041,  0.56302475,
       -0.59807803,  2.56066493, -0.59220228, -0.2118884 ,  1.96043602,
        0.41528392,  0.5182651 , -2.97079358, -0.54759537,  1.3478256 ,
        0.18291416, -0.39967842,  0.85366829, -0.27090927, -0.11067979,
        1.6516408 ,  0.49491716, -0.00926665,  1.71165926,  0.42472203,
       -0.39915168, -0.39565984,  0.39255105, -1.95317039, -2.25435067,
       -1.00976335,  0.47079598,  0.24988311,  1.52652328, -1.30332812,
        0.96984181, -0.18089382,  0.70626829,  0.62412996, -0.45880285])
>>> index.get('a')
array([-0.01709237, -0.28644821, -0.22127849,  0.3607651 ,  1.7157621 ,
        0.14059832,  0.63868086,  1.24874334,  0.43179559,  0.46157876,
        0.17006469,  0.40910414, -1.64711065,  0.25743477,  0.79914145,
       -1.51572273,  0.03737058, -2.39876997,  0.80178743, -0.63415395,
        0.27704545, -1.2525016 , -2.07742619, -0.60759051,  1.10985719,
       -1.3895296 , -0.52473758,  0.68650388,  0.01256952,  0.3971336 ,
       -0.73703008,  1.07751164, -0.63137304,  0.31532058,  1.81155013,
        1.08598802,  0.89523615, -0.13255137,  2.00480694, -0.64576643,
        1.10225489,  0.84353617, -1.40858185, -0.81585466,  1.73998601,
       -0.75097225,  0.16502129,  1.01106987,  0.93417299, -0.22430595,
        0.41556684,  0.09315313,  0.89470955, -0.89219764,  0.99602541,
        0.7376439 , -0.61215625,  0.27270249,  1.46284576, -0.93540164,
        0.17423099,  0.73638914,  0.06891257, -1.36091389, -0.43371414,
       -0.57782192, -1.71281984, -0.21035519,  0.36713408,  0.67569982,
       -1.54703115,  0.46786708,  0.18227984,  0.11912151, -0.68580531,
       -1.34131289, -0.91404236,  0.75742366,  1.20976135,  0.51690041,
        0.38538527,  0.72593605, -0.25392316, -1.2453739 , -1.23616393,
        0.80184418, -0.11210733, -0.13833663,  1.9238361 , -0.59687251,
       -0.3396524 ,  0.02432202,  0.18958508, -0.76954979, -1.24572826,
       -0.51013215, -1.19442037,  0.26825158, -0.52757041, -0.13552411,
        0.20575983,  0.17049547,  0.29340055, -0.47628274, -0.98397219,
       -0.61675813,  0.64113926, -0.49755361,  0.65560995,  0.55363668,
        0.99703513,  1.51556831, -0.36661936, -1.01392332,  0.25455009,
       -0.64502382,  1.30422173,  2.34334954,  0.91945266, -1.64222938,
       -0.41646523,  1.24945382, -1.03891033,  0.74149716, -0.59388228,
        0.33726756,  2.28584548,  0.08492731, -0.79618364, -0.89927153,
       -1.13389983, -0.51188166, -0.07068825, -0.5225368 , -0.34408234,
       -0.04304491,  1.56834181, -0.6048591 ,  0.85947353, -0.41267923,
        0.88097971,  0.1286126 , -0.36203008,  0.08797882,  0.43830633,
       -0.50251054, -0.54229866, -0.48783502,  0.12364678, -0.29082033,
       -2.00789956, -0.94783278, -0.09110568, -0.73780336, -0.30847423,
        1.45394778,  0.18180503, -0.1777716 , -0.33225173, -0.57386394,
       -0.85248549,  1.71841561, -0.52402497,  1.70310831, -1.1458438 ,
        0.30429916,  0.77711284, -0.06591411, -0.15462875, -1.34088442,
       -1.09915804, -0.81829494, -0.44220778,  0.2561074 , -0.2534165 ,
        0.91093136,  0.76046749,  1.13939035,  0.16323419,  0.89238663,
        1.89112508, -0.74371294, -1.02113903,  0.82022482, -0.53233754,
       -0.35488673, -0.23754814,  0.61715831,  0.14083679,  0.87681856,
        0.18919851, -0.31494811,  0.8472167 , -0.82169426,  0.37668725,
        2.18340703, -1.06496578,  1.51183063, -1.79738934, -1.77773324,
        1.25743936, -0.30412144,  0.33170049, -1.23524808,  0.73056995,
       -0.75169916, -0.47375424,  1.72436473, -0.26766405, -0.68797853,
        0.24101611, -1.07744765,  0.48203579, -0.05710892, -0.70235327,
        0.7330519 ,  1.34308929,  0.38885822,  0.67625119,  2.5193115 ,
       -1.36135276,  0.89625085,  0.35207509,  1.25826632,  0.33427536,
        0.22274182,  0.81281001, -0.95112283,  2.41233218, -1.1707785 ,
       -0.09726436, -1.03538288, -0.14666969, -0.14372124, -0.30697297,
       -1.14528565,  0.17052835,  1.45451396,  0.2622176 , -1.89104412,
        0.28794898, -0.66190553, -0.05404354, -0.5494156 ,  0.7521273 ,
       -2.18615985,  0.16298421, -0.40981844,  2.52695681, -0.8571787 ,
       -0.85168545,  1.75574963, -0.81734642, -1.19034452, -1.36239434,
       -0.0207515 , -1.30193308, -0.31735279,  0.44566478, -0.21746313,
        0.15382784, -1.74404738, -0.48452277,  0.37785041,  0.56302475,
       -0.59807803,  2.56066493, -0.59220228, -0.2118884 ,  1.96043602,
        0.41528392,  0.5182651 , -2.97079358, -0.54759537,  1.3478256 ,
        0.18291416, -0.39967842,  0.85366829, -0.27090927, -0.11067979,
        1.6516408 ,  0.49491716, -0.00926665,  1.71165926,  0.42472203,
       -0.39915168, -0.39565984,  0.39255105, -1.95317039, -2.25435067,
       -1.00976335,  0.47079598,  0.24988311,  1.52652328, -1.30332812,
        0.96984181, -0.18089382,  0.70626829,  0.62412996, -0.45880285])
>>> nearest
delivering    0.786526
providing     0.802981
supporting    0.812965
weighing      0.814483
toying        0.815222
saver         0.816671
taking        0.817018
pushing       0.817878
promoting     0.818740
brining       0.821360
dtype: float64
>>> vector
>>> docvector
array([ 8.68634515e-02, -1.07293593e-01, -2.25073877e-01, -2.01750633e-01,
       -7.41365422e-02, -1.26203883e-02,  3.57249381e-01,  1.96726012e-01,
       -3.13259751e-02,  8.75947123e-02,  8.41527950e-02, -3.05469119e-01,
       -6.21887138e-02, -3.55463594e-01,  4.95425406e-02, -1.51088283e-01,
       -2.14852317e-01, -6.65729345e-01,  1.68716720e-02, -4.48308555e-02,
       -1.93282966e-01, -3.27573242e-01, -7.09786552e-01, -3.44835470e-02,
        4.27517699e-01, -4.45861019e-01,  4.21586725e-02,  5.96723442e-01,
       -3.10847300e-01,  5.32236519e-01,  1.26852124e-01,  3.21194030e-01,
       -2.61058465e-01, -6.15892356e-02,  1.13467235e-01,  4.11981120e-01,
        1.57055190e-01, -3.23407470e-01,  4.36111781e-01,  6.69275875e-02,
       -8.40492628e-03,  1.96747023e-01, -2.42938680e-01, -2.11817607e-01,
        2.08592539e-02, -5.08043419e-02, -2.16621543e-01,  4.68021511e-01,
        2.44200175e-01, -2.28801428e-01,  2.59794251e-01,  1.76130992e-02,
       -9.24238452e-02, -1.03775782e-01,  4.42704931e-01,  2.98303802e-01,
        1.68862794e-01, -4.05355830e-01,  4.75177522e-01,  7.33043371e-02,
       -1.06058980e-01,  1.05837078e-01, -2.52684147e-02, -3.90678621e-01,
        8.47280757e-02, -4.02522415e-01, -3.99366761e-01, -1.36697988e-01,
        2.71529867e-01,  2.47245189e-01, -4.28622356e-01,  2.72955577e-01,
       -1.48021043e-01, -1.01430314e-01,  2.07269751e-01, -5.46083613e-01,
       -4.07880369e-02,  8.00592051e-02,  6.98952912e-02,  2.21648815e-01,
        4.36503785e-01,  2.29521232e-01,  3.09236497e-01, -5.64603886e-01,
       -6.87384943e-04, -7.43360553e-02, -5.06569507e-02,  9.98801897e-02,
        8.55165762e-01, -3.57719134e-01,  1.46554438e-01,  6.36636182e-02,
       -3.03166765e-01, -1.56920342e-01, -1.78444207e-01, -1.32555612e-01,
       -8.01369897e-02,  3.50913247e-02, -1.35601839e-01,  2.24755119e-01,
       -1.93254308e-01, -1.66858144e-01, -5.16416806e-02, -1.19336269e-01,
       -4.43644675e-01, -2.90366286e-01,  9.11259134e-03, -6.62411360e-02,
       -7.94062834e-02,  2.15347266e-01,  1.80542749e-01,  2.87225428e-01,
        3.43997418e-02,  3.03435554e-01,  6.31620859e-02,  4.78766713e-02,
        2.88196662e-01,  4.16206692e-01, -7.84234777e-02, -1.52111549e-01,
       -1.29019772e-01,  8.52131498e-02, -4.23003819e-01,  4.43265116e-01,
        3.11274961e-02, -3.47803058e-01,  5.42595819e-01,  9.36190163e-03,
       -1.55410748e-01, -1.70938494e-01, -2.24983722e-01,  4.43793096e-01,
       -3.11212326e-01, -2.36839952e-01, -4.39343972e-01, -4.33935812e-01,
        2.33165128e-01, -4.70284016e-01,  2.98910643e-01,  1.75607475e-01,
        6.24044199e-02,  1.59465082e-01, -9.41172805e-02, -1.90380726e-01,
       -1.32577783e-02, -6.59952460e-02, -1.52518882e-01, -1.08059815e-01,
        3.51825530e-01, -1.53364516e-01, -3.68206347e-01, -3.86794585e-01,
        2.29422539e-02, -2.48924522e-01,  1.72520257e-02,  3.33950217e-01,
        1.30331750e-01, -3.62791347e-01,  5.17998815e-02, -1.72843341e-01,
       -4.50954237e-01,  6.15169364e-01,  2.03715905e-01,  4.51855929e-01,
        1.96112452e-01, -2.03807062e-01,  1.99932273e-01, -1.33512147e-01,
        1.00227169e-01, -1.22249625e-01, -6.50179464e-01, -1.33786626e-01,
        1.41516917e-01,  1.80368829e-01, -2.00139457e-01,  2.65714310e-01,
        2.72859836e-01, -8.21551269e-02, -1.84438939e-02, -1.18492780e-03,
        2.23340284e-01, -1.16220345e-02, -1.09486485e-01,  3.29477971e-01,
        1.06179485e-01, -3.95968016e-01,  7.49300083e-02,  5.13404987e-01,
        1.07129069e-01,  1.61010891e-01,  3.30482470e-01,  2.09602918e-01,
        5.63668026e-01, -3.13562427e-01,  1.33718991e-03,  4.52742682e-01,
       -1.67875351e-01,  4.06393372e-01, -5.58088367e-01, -3.33962170e-01,
        1.15554564e-01, -8.41905549e-02,  3.14438689e-01, -3.48115340e-01,
        2.19059806e-01, -1.64984658e-01, -2.96327938e-01,  6.74953374e-01,
        7.12003372e-02, -2.30193665e-01,  3.23106188e-01, -2.56508659e-02,
        2.75184318e-01,  2.27519979e-01, -1.91337650e-01,  1.69892560e-01,
        3.53404908e-01,  1.32116098e-01, -1.85648897e-01,  7.47648411e-01,
       -5.14981853e-01,  9.33120328e-02,  3.61727742e-03,  2.11191760e-01,
       -2.64125968e-01,  2.33019302e-02,  1.39396426e-01, -1.46722653e-01,
        2.68573579e-01,  1.62199457e-01, -1.52194743e-02, -4.57737574e-01,
        1.53826066e-01, -1.83381515e-01, -2.16609602e-01, -4.77102398e-01,
        1.07097357e-01,  3.00567697e-01,  5.85719034e-01, -3.55152707e-01,
       -1.04458620e-01, -1.85061647e-01, -4.33370586e-02, -2.54815262e-01,
        2.20431950e-01, -4.04758142e-01,  9.42452276e-02,  1.43048543e-01,
        4.33931082e-01, -4.47301622e-02, -2.34301735e-01, -1.32977503e-01,
       -5.04276887e-01, -2.95010004e-01, -4.40443237e-01, -1.46483935e-01,
       -1.70767454e-01, -4.33725997e-01,  7.16047955e-02, -4.16309575e-01,
        1.93888422e-01, -5.06474791e-01, -4.73039389e-02, -3.30905124e-01,
       -2.29397438e-01,  2.19650868e-01,  2.35953410e-01, -3.37112605e-01,
        1.87458145e-02,  6.26289223e-01, -5.14985117e-01,  3.55082817e-01,
       -4.00361758e-01,  1.05291804e-02,  2.00764338e-01, -3.47211872e-01,
        1.30489096e-01, -2.63109878e-01, -1.81952734e-01,  1.50157322e-01,
        1.59038863e-01, -9.50371573e-02, -6.19296640e-02,  1.58073137e-01,
        2.36203741e-01,  4.33856427e-01, -1.49988165e-01, -2.97241156e-01,
       -1.80775467e-02, -4.06195837e-01, -2.28744248e-01, -7.41913503e-02,
        1.78281909e-01, -1.03814377e-01, -1.22514975e-01,  3.91304427e-01,
       -2.48955274e-01,  5.80216580e-02,  9.46002737e-02, -2.36707100e-01])
>>> docvector2 = index.get_doc_vector("This is a planet.", use_idf=True)
... nearest2 = index.get_nearest(docvector2)
...
>>> nearest2
planet       0.000145
Earth        0.285711
earth        0.319553
planetary    0.355832
galaxy       0.366312
planets      0.368870
universe     0.383573
cosmos       0.389313
oceans       0.402645
mankind      0.408567
dtype: float64
>>> docvector2 = index.get_doc_vector("This is a cold planet.", use_idf=True)
... nearest2 = index.get_nearest(docvector2)
...
>>> nearest2
planet       0.063318
Earth        0.334656
earth        0.335314
planetary    0.401216
planets      0.417077
oceans       0.421447
earths       0.426143
cosmos       0.426156
mankind      0.428779
universe     0.432932
dtype: float64
>>> docvector2 = index.get_doc_vector("This is a far away planet at edge of solar system cold planet.", use_idf=True)
... nearest2 = index.get_nearest(docvector2)
...
>>> nearest2
planet       0.091789
Earth        0.307978
earth        0.349947
planets      0.354390
planetary    0.360511
galaxy       0.399206
cosmos       0.405898
universe     0.411032
earths       0.419014
oceans       0.431974
dtype: float64
>>> docvector2 = index.get_doc_vector("This is a far away planet at edge of solar system cold planet asteroid.", use_idf=True)
... nearest2 = index.get_nearest(docvector2)
...
>>> nearest2
asteroid     0.023249
asteroids    0.178557
comet        0.233420
comets       0.312257
Apophis      0.315169
planets      0.318906
Asteroid     0.341509
meteor       0.344470
planet       0.349801
orbiting     0.368915
dtype: float64
>>> hist -o -p -f ch06_extreme_summarization_word2vec_index_use_idf_planet_pluto_asteroid.hist.md
