```python
>>> rnn_infos = hh.list_datasets()
>>> hh = huggingface_hub
>>> hist ~2/
>>> hist ~3/
>>> hist ~4/
>>> import huggingface_hub
... import pandas as pd
... 
... hh = huggingface_hub
... infos = hh.list_datasets()
... df = pd.DataFrame()
... df['description'] = [info.description for info in infos]
... df['name'] = [info.name for info in infos]
... df['id'] = None
... df['author']
...
>>> df['name'] = [info.id for info in infos]
>>> df
                                            description                             name
0     Acronym identification training and developmen...           acronym_identification
1      ADE-Corpus-V2  Dataset: Adverse Drug Reaction...                    ade_corpus_v2
2     AdversarialQA is a Reading Comprehension datas...                   adversarial_qa
3     A collection of email messages of employees in...                            aeslc
4     Named entity annotated data from the NCHLT Tex...             afrikaans_ner_corpus
...                                                 ...                              ...
5657                                               None              davanstrien/testhmd
5658                                               None  sounakray1997/CoNLLU_WikiNEuRal
5659                                               None    adamlin/question_augmentation
5660                                               None                   sudo-s/herbier
5661                                               None                  sudo-s/herbier2

[5662 rows x 2 columns]
>>> info
>>> infos[10]
DatasetInfo: {
	id: allocine
	sha: e0c900e68d80102013c2094185fbd0563f864a88
	lastModified: 2022-05-12T21:03:46.000Z
	tags: ['annotations_creators:no-annotation', 'language_creators:found', 'languages:fr', 'licenses:mit', 'multilinguality:monolingual', 'size_categories:100K<n<1M', 'source_datasets:original', 'task_categories:text-classification', 'task_ids:sentiment-classification', 'pretty_name:Allociné']
	private: False
	author: None
	description:  Allocine Dataset: A Large-Scale French Movie Reviews Dataset.
 This is a dataset for binary sentiment classification, made of user reviews scraped from Allocine.fr.
 It contains 100k positive and 100k negative reviews divided into 3 balanced splits: train (160k reviews), val (20k) and test (20k).
	citation: @misc{blard2019allocine,
  author = {Blard, Theophile},
  title = {french-sentiment-analysis-with-bert},
  year = {2020},
  publisher = {GitHub},
  journal = {GitHub repository},
  howpublished={\\url{https://github.com/TheophileBlard/french-sentiment-analysis-with-bert}},
}
	cardData: None
	siblings: None
	gated: False
	paperswithcode_id: allocine
	downloads: 295
}
>>> infos[10].keys()
>>> vars(infos[10])
{'id': 'allocine',
 'sha': 'e0c900e68d80102013c2094185fbd0563f864a88',
 'lastModified': '2022-05-12T21:03:46.000Z',
 'tags': ['annotations_creators:no-annotation',
  'language_creators:found',
  'languages:fr',
  'licenses:mit',
  'multilinguality:monolingual',
  'size_categories:100K<n<1M',
  'source_datasets:original',
  'task_categories:text-classification',
  'task_ids:sentiment-classification',
  'pretty_name:Allociné'],
 'private': False,
 'author': None,
 'description': ' Allocine Dataset: A Large-Scale French Movie Reviews Dataset.\n This is a dataset for binary sentiment classification, made of user reviews scraped from Allocine.fr.\n It contains 100k positive and 100k negative reviews divided into 3 balanced splits: train (160k reviews), val (20k) and test (20k).',
 'citation': '@misc{blard2019allocine,\n  author = {Blard, Theophile},\n  title = {french-sentiment-analysis-with-bert},\n  year = {2020},\n  publisher = {GitHub},\n  journal = {GitHub repository},\n  howpublished={\\\\url{https://github.com/TheophileBlard/french-sentiment-analysis-with-bert}},\n}',
 'cardData': None,
 'siblings': None,
 'gated': False,
 'paperswithcode_id': 'allocine',
 'downloads': 295}
>>> keys = 'tags gated paperswithcode_id downloads author citation'.split()
>>> for k in keys:
...     df[k] = [i.getattr(k) for i in infos]
...
>>> for k in keys:
...     df[k] = [getattr(i, k) for i in infos]
...
>>> keys = 'tags gated paperswithcode_id downloads author citation'.split()
>>> for k in keys:
...     print(k)
...     df[k] = [getattr(i, k, None) for i in infos]
...
>>> df
                                            description  ...                                           citation
0     Acronym identification training and developmen...  ...  @inproceedings{veyseh-et-al-2020-what,\n   tit...
1      ADE-Corpus-V2  Dataset: Adverse Drug Reaction...  ...  @article{GURULINGAPPA2012885,\ntitle = "Develo...
2     AdversarialQA is a Reading Comprehension datas...  ...  @article{bartolo2020beat,\n    author = {Barto...
3     A collection of email messages of employees in...  ...  @misc{zhang2019email,\n    title={This Email C...
4     Named entity annotated data from the NCHLT Tex...  ...  @inproceedings{afrikaans_ner_corpus,\n  author...
...                                                 ...  ...                                                ...
5657                                               None  ...                                               None
5658                                               None  ...                                               None
5659                                               None  ...                                               None
5660                                               None  ...                                               None
5661                                               None  ...                                               None

[5662 rows x 8 columns]
>>> df.index
RangeIndex(start=0, stop=5662, step=1)
>>> is_email = pd.Series([('email' in d.lower().replace('-', '')) for d in df['description']])
>>> is_email = pd.Series(['email' in d.lower().replace('-', '') if d else False for d in df['description']])
>>> df[is_email.values]
                                            description  ...                                           citation
3     A collection of email messages of employees in...  ...  @misc{zhang2019email,\n    title={This Email C...
39    This dataset provides the template sentences a...  ...  @article{Sap2019ATOMICAA,\n  title={ATOMIC: An...
1142  PharmaCoNER: Pharmacological Substances, Compo...  ...  @inproceedings{,\n    title = "PharmaCoNER: Ph...

[3 rows x 8 columns]
>>> df[is_email.values].iloc[0]
description          A collection of email messages of employees in...
name                                                             aeslc
tags                 [arxiv:1906.03497, languages:en, pretty_name:A...
gated                                                            False
paperswithcode_id                                                aeslc
downloads                                                         2738
author                                                            None
citation             @misc{zhang2019email,\n    title={This Email C...
Name: 3, dtype: object
>>> df[is_email.values].iloc[0]['description']
'A collection of email messages of employees in the Enron Corporation.\n\nThere are two features:\n  - email_body: email body text.\n  - subject_line: email subject text.'
>>> df[is_email.values].iloc[1]['description']
'This dataset provides the template sentences and\nrelationships defined in the ATOMIC common sense dataset. There are\nthree splits - train, test, and dev.\n\nFrom the authors.\n\nDisclaimer/Content warning: the events in atomic have been\nautomatically extracted from blogs, stories and books written at\nvarious times. The events might depict violent or problematic actions,\nwhich we left in the corpus for the sake of learning the (probably\nnegative but still important) commonsense implications associated with\nthe events. We removed a small set of truly out-dated events, but\nmight have missed some so please email us (msap@cs.washington.edu) if\nyou have any concerns.'
>>> for d in df['description'][is_email]:
...     print(d)
...
>>> for i in df[is_email]:
...     print(i.name)
...     print(i.description)
...
>>> for row in df[is_email]:
...     print(row['name'])
...     print(row['description'])
...
>>> for row in df[is_email].iterrows():
...     print(row['name'])
...     print(row['description'])
...
>>> for i, row in df[is_email].iterrows():
...     print(row['name'])
...     print(row['description'])
...
>>> for i, row in df[is_email].iterrows():
...     print(i, row['name'])
...     print(row['description'])
...
>>> df.iloc[3]
description          A collection of email messages of employees in...
name                                                             aeslc
tags                 [arxiv:1906.03497, languages:en, pretty_name:A...
gated                                                            False
paperswithcode_id                                                aeslc
downloads                                                         2738
author                                                            None
citation             @misc{zhang2019email,\n    title={This Email C...
Name: 3, dtype: object
>>> df.iloc[3]['name']
'aeslc'
>>> ds.load_dataset(path=df.iloc[3]['name'])
>>> import datasets as ds
>>> ds.load_dataset(path=df.iloc[3]['name'])
DatasetDict({
    train: Dataset({
        features: ['email_body', 'subject_line'],
        num_rows: 14436
    })
    validation: Dataset({
        features: ['email_body', 'subject_line'],
        num_rows: 1960
    })
    test: Dataset({
        features: ['email_body', 'subject_line'],
        num_rows: 1906
    })
})
>>> enron_emails = _
>>> enron_emails['test']
Dataset({
    features: ['email_body', 'subject_line'],
    num_rows: 1906
})
>>> enron_emails['test'].data
MemoryMappedTable
email_body: string
subject_line: string
----
email_body: [["Phillip,   Could you please do me a favor?
I would like  to read your current title policy to see what it says about easements.
You  should have received a copy during your closing.
I don't know how many  pages it will be but let me know how you want to handle getting a copy  made.
I'll be happy to make the copy, or whatever makes it easy for  you.
Thanks,
","The following reports have been waiting for your approval for more than 4 days.
Please review.
Owner: James W Reitmeyer Report Name: JReitmeyer 10/24/01 Days In Mgr.
Queue: 5
","We have for the last couple of weeks started to compile the Re-start/Integration Plans for Netco.
So far, we have primarily focussed on the mid/back plans where the technology requirements have been the driving factors.
Several plans are in the final stages of completion including:-  +	Infrastructure		Jenny Rub +	Development		Jay Webb +	EnronOnline		Webb / Forster +	HR			David Oxley +	Cash Management	Tom Myers +	Credit			Debbie Brackett  The rest will be completed shortly.
We now need to focus on the commercial plans which have a slightly different focus.
John and I would like to receive the plans "Re-start/Integration"  plans by January 7th, 2002 in order to go through them individually with each of you or in groups.
The focus should be to ensure that we have as much of the business up and running in the shortest time possible.
I have a suggested outline which you do not have to use but I thought it might help.
Please decide within yourselves the areas you will cover together or individually.
Customer Side	 +	Customers		Phase  1 - First Week (eg top 10) 				Phase  2 - First Month (eg top 50) 				Phase  3 - First Quarter (eg top 100) +	Action Plan		Phase  1 Customers 				Phase  2 Customers 				Phase  3 Customers +	Contracts by customers (pre-prepared with credit terms etc) +	Customer visit schedule  Product Side +	List of Products	Phase 1 - First Week 				Phase 2 - First Month 				Phase 3 - First Quarter  Target Number of Transactions +	Phase 1 +	Phase 2 +	Phase 3  IT transfer   Louise
","Michelle Here are my very minor comments.
However we still need to wait on any additions, based on meeting with SME's today.
One concern is the firing of the learner who performs  bad in the final two scenarios.
Do we face any copyright issues using the CNN type themes?
In addition, I think we need to stay clear of anything that remotely seems like California or anything that really happen with Enron?
(i.e.
So-cal Waha) In addition, comments on regulatory issues may be a problem (i.e.
California Legislature).
Sheri  When you read all the scripts together and due to the similar mechanics being taught it appears very repetitious.
Thus I do believe we need to maybe use a "Dateline" type theme for one, and a "60 Minute" type theme for another scenario vice just the CNN type theme.
In the last two scenarios can we include a promotion out of the associate program for the stellar performers (i.e.
title change to manager)?
Cheers Kirk
","For purposes of an accelerated distribution from the PSA,  a "single sum distribution," in Section 6.2 means that a PSA account is distributed all at once, as distinguished from another form of payout as may have been selected by a participant in his or her deferral agreement.
Section 6.2 is clear in that the account balance shall be determined as of the last day of the month preceding the date on which the Committee receives the written request of the Participant.
A PSA account balance is reflected in shares of stock since the form of distribution is shares of stock.
Additionally, any portion of a PSA balance attributable to deferral of restricted stock is administered under Sections 3.5 and 3.6 and Exhibit A of the Plan.
This section is applicable now as we are accelerating the distribution of PSA balances created with deferrals of restricted stock.
The Plan indicates that upon death, disability, retirement or termination, the share units are converted to shares which are issued to the executive according to the payment election made by the executive at the time of the deferral election.
Therefore the distribution you will receive in shares is correct and we do not agree with your interpretation of the plan.
",...,"Andy,  Stephanie Sever has contacted ICE and has requested forms.
We can expect them soon.
Kevin has already given me his list of who will get access to ICE.
Send me a list when you know who should get access.
","The following was developed in an effort to assist with your evaluation of  Non-Exempt employees.
Please let me know if you have any additional questions.
Thanks,
","REMINDER:  Your weekly update for Philippe and Greg is due to me by noon on Thursday.
NOTE:  PLEASE SEND YOUR REPORTS TO LISA COSTELLO.
Thank you,
","Please find attached the latest, and what should be the final for the immediate period of time, copy of the marketing list.
Please filter the PA column by your name to double-check against the list you are currently working off of.
There are some smaller subsids of larger companies previously assigned now listed.
I pulled these subs in from the credit pre-approval list.
I will be passing out draft contracts folders for these counterparties tomorrow to the people responsible for the respective parent companies.
There are some companies on your lists that do not have draft packets.
These companies have NOT been pre-approved by credit, but credit is working on them now.
Continue to call these customers regarding password applications, but do not promise that the ISDA documents, etc.
are immediately forthcoming until we receive those worksheets from credit.
Please continue to pass on both the pa information and the draft packets as you receive the correct contact info.
If you have any questions at all, please call me at 5-3614 or come by my desk at 06541 in the rotunda.
Thank you,
","John,  Further to our conversation last week, this is written notification that the Power Pool was required to modify PetroCanada's direct sales/forward contracts with Enron Canada Power due to the sale of the Sundance 3 unit effective December 29 HE 1 2001.
The details of these changes are provided below.
*********************************** Original Contract Number: 138 Terminated: December 28 HE 24 Source:  Enron Sundance 3 (Enron's metered asset) Sink: PO1U  New Contract Number: 2048 Begin Date: December 29 HE 1 Expiry Date: December 31 HE 24 Source:  Enron ECP- (Enron's unmetered asset) Sink: PO1U *********************************** Original Contract Number: 1287 Terminated: December 28 HE 24 Source:  Enron Sundance 3 (Enron's metered asset) Sink: PO1U  New Contract Number: 2052 Begin Date: December 29 HE 1 Expiry Date: December 31 HE 24 Source:  Enron ECP- (Enron's unmetered asset) Sink: PO1U ***********************************  If you have any questions relating to this matter, please give me a call.
"]]
subject_line: [["Huntley/question
","Expense Reports Awaiting Your Approval
","Re-start/Integration Planning
","RM Simulation Storyline Scripts - Ready for Legal Review
","Answer
",...,"ICE
","Non-Exempt Scorecard
","Weekly Reports are Due
","Latest Marketing List
","Power Pool
"]]
>>> help(enron_emails['test'])
>>> vars(enron_emails['test'])
{'_info': DatasetInfo(description='\nA collection of email messages of employees in the Enron Corporation.\n\nThere are two features:\n  - email_body: email body text.\n  - subject_line: email subject text.\n', citation='\n@misc{zhang2019email,\n    title={This Email Could Save Your Life: Introducing the Task of Email Subject Line Generation},\n    author={Rui Zhang and Joel Tetreault},\n    year={2019},\n    eprint={1906.03497},\n    archivePrefix={arXiv},\n    primaryClass={cs.CL}\n}\n', homepage='https://github.com/ryanzhumich/AESLC', license='', features={'email_body': Value(dtype='string', id=None), 'subject_line': Value(dtype='string', id=None)}, post_processed=None, supervised_keys=SupervisedKeysData(input='email_body', output='subject_line'), task_templates=None, builder_name='aeslc', config_name='default', version=1.0.0, splits={'train': SplitInfo(name='train', num_bytes=11897245, num_examples=14436, dataset_name='aeslc'), 'validation': SplitInfo(name='validation', num_bytes=1659987, num_examples=1960, dataset_name='aeslc'), 'test': SplitInfo(name='test', num_bytes=1383452, num_examples=1906, dataset_name='aeslc')}, download_checksums={'https://github.com/ryanzhumich/AESLC/archive/master.zip': {'num_bytes': 11643743, 'checksum': 'b5ea2ffb837c5cfb9b033d62b3940a8a2330a9eb69bd2a39a9f55db6a23a40a4'}}, download_size=11643743, post_processing_size=None, dataset_size=14940684, size_in_bytes=26584427),
 '_split': NamedSplit('test'),
 '_indexes': {},
 '_data': MemoryMappedTable
 email_body: string
 subject_line: string
 ----
 email_body: [["Phillip,   Could you please do me a favor?
 I would like  to read your current title policy to see what it says about easements.
 You  should have received a copy during your closing.
 I don't know how many  pages it will be but let me know how you want to handle getting a copy  made.
 I'll be happy to make the copy, or whatever makes it easy for  you.
 Thanks,
 ","The following reports have been waiting for your approval for more than 4 days.
 Please review.
 Owner: James W Reitmeyer Report Name: JReitmeyer 10/24/01 Days In Mgr.
 Queue: 5
 ","We have for the last couple of weeks started to compile the Re-start/Integration Plans for Netco.
 So far, we have primarily focussed on the mid/back plans where the technology requirements have been the driving factors.
 Several plans are in the final stages of completion including:-  +	Infrastructure		Jenny Rub +	Development		Jay Webb +	EnronOnline		Webb / Forster +	HR			David Oxley +	Cash Management	Tom Myers +	Credit			Debbie Brackett  The rest will be completed shortly.
 We now need to focus on the commercial plans which have a slightly different focus.
 John and I would like to receive the plans "Re-start/Integration"  plans by January 7th, 2002 in order to go through them individually with each of you or in groups.
 The focus should be to ensure that we have as much of the business up and running in the shortest time possible.
 I have a suggested outline which you do not have to use but I thought it might help.
 Please decide within yourselves the areas you will cover together or individually.
 Customer Side	 +	Customers		Phase  1 - First Week (eg top 10) 				Phase  2 - First Month (eg top 50) 				Phase  3 - First Quarter (eg top 100) +	Action Plan		Phase  1 Customers 				Phase  2 Customers 				Phase  3 Customers +	Contracts by customers (pre-prepared with credit terms etc) +	Customer visit schedule  Product Side +	List of Products	Phase 1 - First Week 				Phase 2 - First Month 				Phase 3 - First Quarter  Target Number of Transactions +	Phase 1 +	Phase 2 +	Phase 3  IT transfer   Louise
 ","Michelle Here are my very minor comments.
 However we still need to wait on any additions, based on meeting with SME's today.
 One concern is the firing of the learner who performs  bad in the final two scenarios.
 Do we face any copyright issues using the CNN type themes?
 In addition, I think we need to stay clear of anything that remotely seems like California or anything that really happen with Enron?
 (i.e.
 So-cal Waha) In addition, comments on regulatory issues may be a problem (i.e.
 California Legislature).
 Sheri  When you read all the scripts together and due to the similar mechanics being taught it appears very repetitious.
 Thus I do believe we need to maybe use a "Dateline" type theme for one, and a "60 Minute" type theme for another scenario vice just the CNN type theme.
 In the last two scenarios can we include a promotion out of the associate program for the stellar performers (i.e.
 title change to manager)?
 Cheers Kirk
 ","For purposes of an accelerated distribution from the PSA,  a "single sum distribution," in Section 6.2 means that a PSA account is distributed all at once, as distinguished from another form of payout as may have been selected by a participant in his or her deferral agreement.
 Section 6.2 is clear in that the account balance shall be determined as of the last day of the month preceding the date on which the Committee receives the written request of the Participant.
 A PSA account balance is reflected in shares of stock since the form of distribution is shares of stock.
 Additionally, any portion of a PSA balance attributable to deferral of restricted stock is administered under Sections 3.5 and 3.6 and Exhibit A of the Plan.
 This section is applicable now as we are accelerating the distribution of PSA balances created with deferrals of restricted stock.
 The Plan indicates that upon death, disability, retirement or termination, the share units are converted to shares which are issued to the executive according to the payment election made by the executive at the time of the deferral election.
 Therefore the distribution you will receive in shares is correct and we do not agree with your interpretation of the plan.
 ",...,"Andy,  Stephanie Sever has contacted ICE and has requested forms.
 We can expect them soon.
 Kevin has already given me his list of who will get access to ICE.
 Send me a list when you know who should get access.
 ","The following was developed in an effort to assist with your evaluation of  Non-Exempt employees.
 Please let me know if you have any additional questions.
 Thanks,
 ","REMINDER:  Your weekly update for Philippe and Greg is due to me by noon on Thursday.
 NOTE:  PLEASE SEND YOUR REPORTS TO LISA COSTELLO.
 Thank you,
 ","Please find attached the latest, and what should be the final for the immediate period of time, copy of the marketing list.
 Please filter the PA column by your name to double-check against the list you are currently working off of.
 There are some smaller subsids of larger companies previously assigned now listed.
 I pulled these subs in from the credit pre-approval list.
 I will be passing out draft contracts folders for these counterparties tomorrow to the people responsible for the respective parent companies.
 There are some companies on your lists that do not have draft packets.
 These companies have NOT been pre-approved by credit, but credit is working on them now.
 Continue to call these customers regarding password applications, but do not promise that the ISDA documents, etc.
 are immediately forthcoming until we receive those worksheets from credit.
 Please continue to pass on both the pa information and the draft packets as you receive the correct contact info.
 If you have any questions at all, please call me at 5-3614 or come by my desk at 06541 in the rotunda.
 Thank you,
 ","John,  Further to our conversation last week, this is written notification that the Power Pool was required to modify PetroCanada's direct sales/forward contracts with Enron Canada Power due to the sale of the Sundance 3 unit effective December 29 HE 1 2001.
 The details of these changes are provided below.
 *********************************** Original Contract Number: 138 Terminated: December 28 HE 24 Source:  Enron Sundance 3 (Enron's metered asset) Sink: PO1U  New Contract Number: 2048 Begin Date: December 29 HE 1 Expiry Date: December 31 HE 24 Source:  Enron ECP- (Enron's unmetered asset) Sink: PO1U *********************************** Original Contract Number: 1287 Terminated: December 28 HE 24 Source:  Enron Sundance 3 (Enron's metered asset) Sink: PO1U  New Contract Number: 2052 Begin Date: December 29 HE 1 Expiry Date: December 31 HE 24 Source:  Enron ECP- (Enron's unmetered asset) Sink: PO1U ***********************************  If you have any questions relating to this matter, please give me a call.
 "]]
 subject_line: [["Huntley/question
 ","Expense Reports Awaiting Your Approval
 ","Re-start/Integration Planning
 ","RM Simulation Storyline Scripts - Ready for Legal Review
 ","Answer
 ",...,"ICE
 ","Non-Exempt Scorecard
 ","Weekly Reports are Due
 ","Latest Marketing List
 ","Power Pool
 "]],
 '_indices': None,
 '_format_type': None,
 '_format_kwargs': {},
 '_format_columns': None,
 '_output_all_columns': False,
 '_fingerprint': 'd4bc9cb4518e64fe'}
>>> vars(enron_emails['test']).keys()
dict_keys(['_info', '_split', '_indexes', '_data', '_indices', '_format_type', '_format_kwargs', '_format_columns', '_output_all_columns', '_fingerprint'])
>>> vars(enron_emails['test'])['data']
>>> vars(enron_emails['test'])['_data']
MemoryMappedTable
email_body: string
subject_line: string
----
email_body: [["Phillip,   Could you please do me a favor?
I would like  to read your current title policy to see what it says about easements.
You  should have received a copy during your closing.
I don't know how many  pages it will be but let me know how you want to handle getting a copy  made.
I'll be happy to make the copy, or whatever makes it easy for  you.
Thanks,
","The following reports have been waiting for your approval for more than 4 days.
Please review.
Owner: James W Reitmeyer Report Name: JReitmeyer 10/24/01 Days In Mgr.
Queue: 5
","We have for the last couple of weeks started to compile the Re-start/Integration Plans for Netco.
So far, we have primarily focussed on the mid/back plans where the technology requirements have been the driving factors.
Several plans are in the final stages of completion including:-  +	Infrastructure		Jenny Rub +	Development		Jay Webb +	EnronOnline		Webb / Forster +	HR			David Oxley +	Cash Management	Tom Myers +	Credit			Debbie Brackett  The rest will be completed shortly.
We now need to focus on the commercial plans which have a slightly different focus.
John and I would like to receive the plans "Re-start/Integration"  plans by January 7th, 2002 in order to go through them individually with each of you or in groups.
The focus should be to ensure that we have as much of the business up and running in the shortest time possible.
I have a suggested outline which you do not have to use but I thought it might help.
Please decide within yourselves the areas you will cover together or individually.
Customer Side	 +	Customers		Phase  1 - First Week (eg top 10) 				Phase  2 - First Month (eg top 50) 				Phase  3 - First Quarter (eg top 100) +	Action Plan		Phase  1 Customers 				Phase  2 Customers 				Phase  3 Customers +	Contracts by customers (pre-prepared with credit terms etc) +	Customer visit schedule  Product Side +	List of Products	Phase 1 - First Week 				Phase 2 - First Month 				Phase 3 - First Quarter  Target Number of Transactions +	Phase 1 +	Phase 2 +	Phase 3  IT transfer   Louise
","Michelle Here are my very minor comments.
However we still need to wait on any additions, based on meeting with SME's today.
One concern is the firing of the learner who performs  bad in the final two scenarios.
Do we face any copyright issues using the CNN type themes?
In addition, I think we need to stay clear of anything that remotely seems like California or anything that really happen with Enron?
(i.e.
So-cal Waha) In addition, comments on regulatory issues may be a problem (i.e.
California Legislature).
Sheri  When you read all the scripts together and due to the similar mechanics being taught it appears very repetitious.
Thus I do believe we need to maybe use a "Dateline" type theme for one, and a "60 Minute" type theme for another scenario vice just the CNN type theme.
In the last two scenarios can we include a promotion out of the associate program for the stellar performers (i.e.
title change to manager)?
Cheers Kirk
","For purposes of an accelerated distribution from the PSA,  a "single sum distribution," in Section 6.2 means that a PSA account is distributed all at once, as distinguished from another form of payout as may have been selected by a participant in his or her deferral agreement.
Section 6.2 is clear in that the account balance shall be determined as of the last day of the month preceding the date on which the Committee receives the written request of the Participant.
A PSA account balance is reflected in shares of stock since the form of distribution is shares of stock.
Additionally, any portion of a PSA balance attributable to deferral of restricted stock is administered under Sections 3.5 and 3.6 and Exhibit A of the Plan.
This section is applicable now as we are accelerating the distribution of PSA balances created with deferrals of restricted stock.
The Plan indicates that upon death, disability, retirement or termination, the share units are converted to shares which are issued to the executive according to the payment election made by the executive at the time of the deferral election.
Therefore the distribution you will receive in shares is correct and we do not agree with your interpretation of the plan.
",...,"Andy,  Stephanie Sever has contacted ICE and has requested forms.
We can expect them soon.
Kevin has already given me his list of who will get access to ICE.
Send me a list when you know who should get access.
","The following was developed in an effort to assist with your evaluation of  Non-Exempt employees.
Please let me know if you have any additional questions.
Thanks,
","REMINDER:  Your weekly update for Philippe and Greg is due to me by noon on Thursday.
NOTE:  PLEASE SEND YOUR REPORTS TO LISA COSTELLO.
Thank you,
","Please find attached the latest, and what should be the final for the immediate period of time, copy of the marketing list.
Please filter the PA column by your name to double-check against the list you are currently working off of.
There are some smaller subsids of larger companies previously assigned now listed.
I pulled these subs in from the credit pre-approval list.
I will be passing out draft contracts folders for these counterparties tomorrow to the people responsible for the respective parent companies.
There are some companies on your lists that do not have draft packets.
These companies have NOT been pre-approved by credit, but credit is working on them now.
Continue to call these customers regarding password applications, but do not promise that the ISDA documents, etc.
are immediately forthcoming until we receive those worksheets from credit.
Please continue to pass on both the pa information and the draft packets as you receive the correct contact info.
If you have any questions at all, please call me at 5-3614 or come by my desk at 06541 in the rotunda.
Thank you,
","John,  Further to our conversation last week, this is written notification that the Power Pool was required to modify PetroCanada's direct sales/forward contracts with Enron Canada Power due to the sale of the Sundance 3 unit effective December 29 HE 1 2001.
The details of these changes are provided below.
*********************************** Original Contract Number: 138 Terminated: December 28 HE 24 Source:  Enron Sundance 3 (Enron's metered asset) Sink: PO1U  New Contract Number: 2048 Begin Date: December 29 HE 1 Expiry Date: December 31 HE 24 Source:  Enron ECP- (Enron's unmetered asset) Sink: PO1U *********************************** Original Contract Number: 1287 Terminated: December 28 HE 24 Source:  Enron Sundance 3 (Enron's metered asset) Sink: PO1U  New Contract Number: 2052 Begin Date: December 29 HE 1 Expiry Date: December 31 HE 24 Source:  Enron ECP- (Enron's unmetered asset) Sink: PO1U ***********************************  If you have any questions relating to this matter, please give me a call.
"]]
subject_line: [["Huntley/question
","Expense Reports Awaiting Your Approval
","Re-start/Integration Planning
","RM Simulation Storyline Scripts - Ready for Legal Review
","Answer
",...,"ICE
","Non-Exempt Scorecard
","Weekly Reports are Due
","Latest Marketing List
","Power Pool
"]]
>>> vars(enron_emails['test']).data
>>> enron_emails['test']['data']
>>> enron_emails['test']['subject']
>>> enron_emails['test'].keys()
>>> enron_emails['test'].data
MemoryMappedTable
email_body: string
subject_line: string
----
email_body: [["Phillip,   Could you please do me a favor?
I would like  to read your current title policy to see what it says about easements.
You  should have received a copy during your closing.
I don't know how many  pages it will be but let me know how you want to handle getting a copy  made.
I'll be happy to make the copy, or whatever makes it easy for  you.
Thanks,
","The following reports have been waiting for your approval for more than 4 days.
Please review.
Owner: James W Reitmeyer Report Name: JReitmeyer 10/24/01 Days In Mgr.
Queue: 5
","We have for the last couple of weeks started to compile the Re-start/Integration Plans for Netco.
So far, we have primarily focussed on the mid/back plans where the technology requirements have been the driving factors.
Several plans are in the final stages of completion including:-  +	Infrastructure		Jenny Rub +	Development		Jay Webb +	EnronOnline		Webb / Forster +	HR			David Oxley +	Cash Management	Tom Myers +	Credit			Debbie Brackett  The rest will be completed shortly.
We now need to focus on the commercial plans which have a slightly different focus.
John and I would like to receive the plans "Re-start/Integration"  plans by January 7th, 2002 in order to go through them individually with each of you or in groups.
The focus should be to ensure that we have as much of the business up and running in the shortest time possible.
I have a suggested outline which you do not have to use but I thought it might help.
Please decide within yourselves the areas you will cover together or individually.
Customer Side	 +	Customers		Phase  1 - First Week (eg top 10) 				Phase  2 - First Month (eg top 50) 				Phase  3 - First Quarter (eg top 100) +	Action Plan		Phase  1 Customers 				Phase  2 Customers 				Phase  3 Customers +	Contracts by customers (pre-prepared with credit terms etc) +	Customer visit schedule  Product Side +	List of Products	Phase 1 - First Week 				Phase 2 - First Month 				Phase 3 - First Quarter  Target Number of Transactions +	Phase 1 +	Phase 2 +	Phase 3  IT transfer   Louise
","Michelle Here are my very minor comments.
However we still need to wait on any additions, based on meeting with SME's today.
One concern is the firing of the learner who performs  bad in the final two scenarios.
Do we face any copyright issues using the CNN type themes?
In addition, I think we need to stay clear of anything that remotely seems like California or anything that really happen with Enron?
(i.e.
So-cal Waha) In addition, comments on regulatory issues may be a problem (i.e.
California Legislature).
Sheri  When you read all the scripts together and due to the similar mechanics being taught it appears very repetitious.
Thus I do believe we need to maybe use a "Dateline" type theme for one, and a "60 Minute" type theme for another scenario vice just the CNN type theme.
In the last two scenarios can we include a promotion out of the associate program for the stellar performers (i.e.
title change to manager)?
Cheers Kirk
","For purposes of an accelerated distribution from the PSA,  a "single sum distribution," in Section 6.2 means that a PSA account is distributed all at once, as distinguished from another form of payout as may have been selected by a participant in his or her deferral agreement.
Section 6.2 is clear in that the account balance shall be determined as of the last day of the month preceding the date on which the Committee receives the written request of the Participant.
A PSA account balance is reflected in shares of stock since the form of distribution is shares of stock.
Additionally, any portion of a PSA balance attributable to deferral of restricted stock is administered under Sections 3.5 and 3.6 and Exhibit A of the Plan.
This section is applicable now as we are accelerating the distribution of PSA balances created with deferrals of restricted stock.
The Plan indicates that upon death, disability, retirement or termination, the share units are converted to shares which are issued to the executive according to the payment election made by the executive at the time of the deferral election.
Therefore the distribution you will receive in shares is correct and we do not agree with your interpretation of the plan.
",...,"Andy,  Stephanie Sever has contacted ICE and has requested forms.
We can expect them soon.
Kevin has already given me his list of who will get access to ICE.
Send me a list when you know who should get access.
","The following was developed in an effort to assist with your evaluation of  Non-Exempt employees.
Please let me know if you have any additional questions.
Thanks,
","REMINDER:  Your weekly update for Philippe and Greg is due to me by noon on Thursday.
NOTE:  PLEASE SEND YOUR REPORTS TO LISA COSTELLO.
Thank you,
","Please find attached the latest, and what should be the final for the immediate period of time, copy of the marketing list.
Please filter the PA column by your name to double-check against the list you are currently working off of.
There are some smaller subsids of larger companies previously assigned now listed.
I pulled these subs in from the credit pre-approval list.
I will be passing out draft contracts folders for these counterparties tomorrow to the people responsible for the respective parent companies.
There are some companies on your lists that do not have draft packets.
These companies have NOT been pre-approved by credit, but credit is working on them now.
Continue to call these customers regarding password applications, but do not promise that the ISDA documents, etc.
are immediately forthcoming until we receive those worksheets from credit.
Please continue to pass on both the pa information and the draft packets as you receive the correct contact info.
If you have any questions at all, please call me at 5-3614 or come by my desk at 06541 in the rotunda.
Thank you,
","John,  Further to our conversation last week, this is written notification that the Power Pool was required to modify PetroCanada's direct sales/forward contracts with Enron Canada Power due to the sale of the Sundance 3 unit effective December 29 HE 1 2001.
The details of these changes are provided below.
*********************************** Original Contract Number: 138 Terminated: December 28 HE 24 Source:  Enron Sundance 3 (Enron's metered asset) Sink: PO1U  New Contract Number: 2048 Begin Date: December 29 HE 1 Expiry Date: December 31 HE 24 Source:  Enron ECP- (Enron's unmetered asset) Sink: PO1U *********************************** Original Contract Number: 1287 Terminated: December 28 HE 24 Source:  Enron Sundance 3 (Enron's metered asset) Sink: PO1U  New Contract Number: 2052 Begin Date: December 29 HE 1 Expiry Date: December 31 HE 24 Source:  Enron ECP- (Enron's unmetered asset) Sink: PO1U ***********************************  If you have any questions relating to this matter, please give me a call.
"]]
subject_line: [["Huntley/question
","Expense Reports Awaiting Your Approval
","Re-start/Integration Planning
","RM Simulation Storyline Scripts - Ready for Legal Review
","Answer
",...,"ICE
","Non-Exempt Scorecard
","Weekly Reports are Due
","Latest Marketing List
","Power Pool
"]]
>>> enron_emails['test'].data['subject_line']
<pyarrow.lib.ChunkedArray object at 0x7f220c9b6db0>
[
  [
    "Huntley/question
",
    "Expense Reports Awaiting Your Approval
",
    "Re-start/Integration Planning
",
    "RM Simulation Storyline Scripts - Ready for Legal Review
",
    "Answer
",
    ...
    "ICE
",
    "Non-Exempt Scorecard
",
    "Weekly Reports are Due
",
    "Latest Marketing List
",
    "Power Pool
"
  ]
]
>>> enron_emails['test'].data['email']
>>> enron_emails['test'].data.keys()
>>> dir(enron_emails['test'].data)
['__class__',
 '__deepcopy__',
 '__delattr__',
 '__dict__',
 '__dir__',
 '__doc__',
 '__eq__',
 '__format__',
 '__ge__',
 '__getattribute__',
 '__getitem__',
 '__getstate__',
 '__gt__',
 '__hash__',
 '__init__',
 '__init_subclass__',
 '__le__',
 '__len__',
 '__lt__',
 '__module__',
 '__ne__',
 '__new__',
 '__reduce__',
 '__reduce_ex__',
 '__repr__',
 '__setattr__',
 '__setstate__',
 '__sizeof__',
 '__str__',
 '__subclasshook__',
 '__weakref__',
 '_append_replay',
 '_apply_replays',
 '_batches',
 '_offsets',
 '_schema',
 'add_column',
 'append_column',
 'cast',
 'column',
 'column_names',
 'columns',
 'combine_chunks',
 'drop',
 'equals',
 'fast_gather',
 'fast_slice',
 'field',
 'filter',
 'flatten',
 'from_file',
 'itercolumns',
 'nbytes',
 'num_columns',
 'num_rows',
 'path',
 'remove_column',
 'rename_columns',
 'replace_schema_metadata',
 'replays',
 'schema',
 'select_columns',
 'set_column',
 'shape',
 'slice',
 'table',
 'to_batches',
 'to_pandas',
 'to_pydict',
 'to_string',
 'validate']
>>> enron_emails['test'].columns
>>> enron_emails['test']['columns']
>>> enron_emails['test']['email_body']
["Phillip,   Could you please do me a favor?\nI would like  to read your current title policy to see what it says about easements.\nYou  should have received a copy during your closing.\nI don't know how many  pages it will be but let me know how you want to handle getting a copy  made.\nI'll be happy to make the copy, or whatever makes it easy for  you.\nThanks,\n",
 'The following reports have been waiting for your approval for more than 4 days.\nPlease review.\nOwner: James W Reitmeyer Report Name: JReitmeyer 10/24/01 Days In Mgr.\nQueue: 5\n',
 'We have for the last couple of weeks started to compile the Re-start/Integration Plans for Netco.\nSo far, we have primarily focussed on the mid/back plans where the technology requirements have been the driving factors.\nSeveral plans are in the final stages of completion including:-  +\tInfrastructure\t\tJenny Rub +\tDevelopment\t\tJay Webb +\tEnronOnline\t\tWebb / Forster +\tHR\t\t\tDavid Oxley +\tCash Management\tTom Myers +\tCredit\t\t\tDebbie Brackett  The rest will be completed shortly.\nWe now need to focus on the commercial plans which have a slightly different focus.\nJohn and I would like to receive the plans "Re-start/Integration"  plans by January 7th, 2002 in order to go through them individually with each of you or in groups.\nThe focus should be to ensure that we have as much of the business up and running in the shortest time possible.\nI have a suggested outline which you do not have to use but I thought it might help.\nPlease decide within yourselves the areas you will cover together or individually.\nCustomer Side\t +\tCustomers\t\tPhase  1 - First Week (eg top 10) \t\t\t\tPhase  2 - First Month (eg top 50) \t\t\t\tPhase  3 - First Quarter (eg top 100) +\tAction Plan\t\tPhase  1 Customers \t\t\t\tPhase  2 Customers \t\t\t\tPhase  3 Customers +\tContracts by customers (pre-prepared with credit terms etc) +\tCustomer visit schedule  Product Side +\tList of Products\tPhase 1 - First Week \t\t\t\tPhase 2 - First Month \t\t\t\tPhase 3 - First Quarter  Target Number of Transactions +\tPhase 1 +\tPhase 2 +\tPhase 3  IT transfer   Louise\n',
 'Michelle Here are my very minor comments.\nHowever we still need to wait on any additions, based on meeting with SME\'s today.\nOne concern is the firing of the learner who performs  bad in the final two scenarios.\nDo we face any copyright issues using the CNN type themes?\nIn addition, I think we need to stay clear of anything that remotely seems like California or anything that really happen with Enron?\n(i.e.\nSo-cal Waha) In addition, comments on regulatory issues may be a problem (i.e.\nCalifornia Legislature).\nSheri  When you read all the scripts together and due to the similar mechanics being taught it appears very repetitious.\nThus I do believe we need to maybe use a "Dateline" type theme for one, and a "60 Minute" type theme for another scenario vice just the CNN type theme.\nIn the last two scenarios can we include a promotion out of the associate program for the stellar performers (i.e.\ntitle change to manager)?\nCheers Kirk\n',
 'For purposes of an accelerated distribution from the PSA,  a "single sum distribution," in Section 6.2 means that a PSA account is distributed all at once, as distinguished from another form of payout as may have been selected by a participant in his or her deferral agreement.\nSection 6.2 is clear in that the account balance shall be determined as of the last day of the month preceding the date on which the Committee receives the written request of the Participant.\nA PSA account balance is reflected in shares of stock since the form of distribution is shares of stock.\nAdditionally, any portion of a PSA balance attributable to deferral of restricted stock is administered under Sections 3.5 and 3.6 and Exhibit A of the Plan.\nThis section is applicable now as we are accelerating the distribution of PSA balances created with deferrals of restricted stock.\nThe Plan indicates that upon death, disability, retirement or termination, the share units are converted to shares which are issued to the executive according to the payment election made by the executive at the time of the deferral election.\nTherefore the distribution you will receive in shares is correct and we do not agree with your interpretation of the plan.\n',
 'All:  Attached you will find a list that reflects your seat assignments for Business Continuity Planning (BCP).\nThese seats are located on the 30th and 31st Floors of Enron Center North (ECN).\nAs previously communicated, you will report to these designated seats in the event of an outage in ECS.\nThe exception to this is as follows: If your seat assignment is located on the 31st Floor, you will report to your original location that you occupied prior to your move into ECS.\nThis will hold true until the Monday after Thanksgiving, as we will have the 31st floor seats set up at that time.\nTesting: Once you have moved to ECS, if you would like to test your BCP location, you will be able to test your seat for functionality every Thursday from 3-6pm.\nTesting is not required, but is highly recommended.\nIf anyone has any questions or concerns about these procedures, please feel free to contact me at any time.\nRegards,\n',
 "As our last day is Friday, November 30th, we would love to toast the good times and special memories that we have shared with you over the past five years.\nPlease join us at Teala's (W. Dallas) on Thursday, November 29th, beginning at 5pm.\nLooking forward to being with you,   Lara and Janel     Lara Leibman\n",
 'Hi John,  I was wondering if you had a chance to put together that slide for us.\nI know you are really busy and we appreciate your help.\nThanks.\nSavita\n',
 "All,  The below Analyst & Associate recruiting dates require ENA participation at Manager level at above.\nIn order to resource each of your departments it is important to have ENA's involvement and participation in the interviews and debrief sessions on Fantastic Friday and Super Saturday events.\nThese de-brief sessions will allow you the opportunity to select candidates you wish to join your groups.\nThe target  is to assign potential candidates to business units and departments from the outset.\nAs ENA has the highest percentage of A&A rotating in its business unit, the participation of ENA at interview should reflect this.\nTherefore, please encourage your direct reports and managers to participate in the below events in order to secure candidates for your business area.\nAssociate Recruiting:\t\tSaturday November 3\t\t\t\t\t\tTotal - 70 Candidates for Interview Analyst Recruiting:\t\tFriday, November 16\t\t\t\t\t\tTotal - 70 Candidates for Interivew Associate Recruiting:\t\tSaturday, December 1\t\t\t\t\t\tTotal - 70 Candidates for Interview  The above spreadsheet represents ENA's particpation today which I believe highlights the need for much additional support in these efforts.\nPlease confirm by return participation of your respective groups.\nRegards,\n",
 'Late on October 25th, we received information about a nonspecific threat to the Enron Center.\nWe communicated with law enforcement officials who found the threat unsubstantiated and without merit.\nNonetheless we take all threats seriously and have increased the security presence at the Enron Center still further.\nOnce again, if you observe suspicious behavior, please call security at 3-6200.\n',
 "Hi John,  The events surrounding the Enron demise are quite disturbing not only to me but to many of us over here.\nOur hearts go out to all the employees who will not only loose their employment but also most, if not all, of their savings.\nAs you know, I've always thought a lot of you; not only for your trading skills, but also as a person.\nYou are one of the largest and most influential traders in the market, yet do not have the annoying ego so often found in traders of your stature.\nI'm absolutely sure that you'll do well no matter where your career takes you.\nI just wanted you to know that if there is ever anything I can do for you, please don't hesitate to call.\nThis is not a solicitation for employment.\nThis is from a person who always felt you treated me honestly and fairly and if the occasion arises, would like to reciprocate.\n",
 'Kevin Presto is requesting that you attend a meeting regarding Organizing an Action Plan for the Start-up of Netco.\nThe meeting will be held in ECS 06716 at 9:30 am, Wednesday, January 2, 2002.\nFor Tim and Chris, could you please call 713-584-2067.\nThis is the telephone number in the conference room.\nIf you should have any questions, please call T Jae Black at 3-5800.\nThanks\n',
 "Harry - I got kicked out of the system, so I'm sending this from Tom's account.\nHe can fill you in on the potential deal with STEAG.\nI left my resume on your chair.\nI'll e-mail a copy when I have my home account running.\nMy contact info is:\n",
 "Harry:  Got the bid documents for ConEd's offering of peaking capacity for PJM East (Lakewood, New Jersey).\nCan't imagine they would entertain an Enron bid right now without confiscatory credit pricing.\nDo you want to bid anyway?\nLet me know.\n",
 'Thank you for allowing me to explain the UBS relocation policy.\nI have included a repayment agreement that must be printed out, signed and faxed back to 203-205-3934 at your earliest convenience.\nI look forward to working with you in the future.\nThanks\n',
 "PLEASE READ THIS IMPORTANT INFORMATION CONCERNING THE ENRON STOCK FUND IN THE ENRON CORP. SAVINGS AND ESOP PLANS  On Friday, January 11, trading of Enron stock was suspended on the New York Stock Exchange (NYSE).\nAll Savings and ESOP Plan transactions, including 401(k) payroll contributions,  involving this fund were placed in a pending status until trading resumed.\nAs announced by Enron's Office of the Chair on Wednesday, January 16, Enron stock would now be traded Over The Counter (OTC).\nUpon receiving this information, work began immediately to develop a process that allows for OTC trades in the plans.\nOn Thursday, January 17, Enron initiated a process to facilitate OTC trades of Enron stock inside the 401(k) and ESOP and all pending transactions were processed using Thursday's closing price.\nNow that trading has resumed, we urge you to review your investment elections to ensure that they are consistent with your investment goals.\nAs things change, we will continue to update you.\nEnron Benefits Department\n",
 '1) The enforceability of my existing contract with Enron, namely section 16.\nWhat happens to my contract with Enron and will I be forced to repay both my sign on bonus and my retention bonus to Enron?\n2) Section 1(f) and the last sentence of section 1(c) seem redundant.\nWill I get paid the retention bonus absent voluntary termination (i.e.\nfor both with cause and without cause involuntary termination) ?\n3) Who will be my employer?\nAnd will all stock and stock option grants be in UBS AG stock?\n4) What happens to the Restricted Stock grant referenced in Section 2 and again in Exhibit I if UBS terminates me with or without cause?\nAs a follow up,  if the stock is lost then what is the consideration for signing this contract (non - compete)?\n5) In Section 9(a), the non - compete clause is set up for a 12 month period after my employment begins and continues regardless of termination both voluntarily and involuntarily.\nWhat is to stop UBS from terminating me or anyone else for that matter immediately after signing this agreement?\nAll they are out is the Retention portion of the contract (since contract is at will).\n',
 "It appears that the following email may not have been clear.\nYou have to copy all documents yourself.\nThis is my cheat sheet if it helps:    H Drives: 1.\nEach person will have to move any data over personally from the old H drive (which is now Z:) drive to their new H drive.\n2.\nThe Z: drive (old H:) will be removed from UBS employees on Thursday night.\nO Drives: 1.\nFor the old O or M drives go to O:\\ESTATE\\ O (or M ?\npending location of data) and copy to the new common O.\nThe Estate O and M will be removed from UBS employees on Thursday night.\nDo not delete anything and only copy information which is complies with the policy.\nPlease make sure that those people who are not in the office are contacted and comply.\nLouise      To:\t\tAll Enron Employees Transferring to UBS Warburg Energy (or its affiliates)  Under the terms of the various agreements among certain Enron entities and UBS AG, certain Enron data and documents may be provided to UBS.\nTo ensure compliance with those agreements, Enron's document retention policy, as well as directives of various investigative agencies, the attached protocol regarding the process for migration of any information or data to UBS has been developed.\nPlease review the protocol carefully.\nThen, complete the attached Certification and return it, with attachments, to Linda Guinn at EB 3829a no later than February 11, 2002.\nQuestions about this matter may be directed to Michelle Cash at (713) 853-6401 or Francisco Pinto-Leite at (713) 345-7942 .\nProtocol Document and Data Copy Instructions      Certification Document\n",
 "Dear Members:  NESA is pleased to be holding its 3rd Annual Benefit Golf Tournament on Monday, March 18th, 2002 at the prestigious Champions Golf Club.\nProceeds will again benefit The Sunshine Kids Foundation.\nThis is your opportunity to secure a corporate ($2000) or individual ($500) sponsorship which includes a foursome or a single tee time, respectively for this outstanding tournament and great cause.\nAttached are registration forms.\nNESA has been proud to donate over $50,000 in the last two years to local charities through this tournament, and we need your help to continue to do so.\nIf you have any questions, please feel free to email me or call me at 713/856-6525.\nDon't forget about our mixer on Thursday, January 31st at the Boaka Bar downtown.\nNo cover, first drink free - can't beat it!\nRSVP to me if you can make it.\nVisit their website for directions at www.mercuryroom.com/boaka/boaka.html\n",
 'This is a notice to inform you that the server where your Outlook mailbox resides is scheduled for an outage tonight.\nYour mailbox will be temporarily unavailable starting anytime after 8pm and may continue to be unavailable until 12 a.m., when all server maintenance work have been completed.\nOutlook Web Access (OWA) will also be unavailable during this time.\nBlackberry users:  Message delivery may be delayed for a few minutes.\nIf you have any questions, please call the Resolution Center at x31411.\n',
 "As you know, Enron has signed a merger agreement by which Dynegy will acquire Enron.\nWe expect the transaction to close following shareholder and regulatory approvals and various conditions to closing.\nEven though Enron has entered into this agreement, U.S. and foreign antitrust laws require that Enron and Dynegy continue to operate independently of each other.\nIn particular, to the extent that Enron and Dynegy are competitors in various businesses or markets, their respective activities must be undertaken at arm's length until the transaction has closed.\nTherefore, for antitrust purposes you should treat Dynegy as you would any other unaffiliated company notwithstanding the merger agreement.\nIn addition, all information, documents and communications related to the merger between Enron and Dynegy should be coordinated through and approved by Mark Muller, Lance Schuler, Robert Eickenroht, Mark Haedicke, Rob Walls or Greg Whalley of Enron.\nIt is absolutely critical that this procedure be maintained.\nTo the extent that information is required to be disclosed to Dynegy under the merger agreement, then such disclosure should be approved by one of the foregoing individuals.\nIf you have any questions concerning this notice, please contact Lance Schuler (713/853-5419), Robert Eickenroht (713/853-3155), Mark Haedicke (713/853-6544) or Rob Walls (713/646-6017).\nThank you for your help in this matter.\n",
 'You have received this message because someone has attempted to send you an e-mail from outside of Enron with an attachment type that Enron does not allow into our messaging environment.\nYour e-mail has been quarantined and is being held at the MailSweeper server.\nSender:  daphneco64@alltel.net\n',
 "Hey Rob,  I am trying to create index products for Feb and I don't see the Jan products  to copy.\nI need HPL HSCX, HPL HSCX E, HPL Agua Dulce, HPL Thompsonville, and  Corpus Christi Pool.\nThanks,\n",
 'Now I see how you guys have been winning all of your games - through  cheating.\nYou are supposed to have at least one player on IR each week.\nA  designated IR player cannot play.\nThere are no IR moves during the week.\nThat means that at least one person on your team should score no points each  week.\nout\n',
 'I have not received your dues yet.\nI am giving you a one week reprieve.\nIf  I do not receive your dues ($110) by this Sunday, you will forfeit.\nMy address is:  2302 Travis St.. #8225 Houston  77006\n',
 'Please e-mail me who you want to add and drop.\nCheck you roster to make sure that it is legal.\nI still need your dues by Sunday or you forfeit.\nI have only received dues from Dave and Steve!\n',
 'I would like to trade for your 2nd pick in the draft.\nI can offer you a 2nd  round pick and a 9th round pick.\nWhat do you think?\nEric\n',
 'By unanimous vote we will pre-determine the draft order.\nSo, if nobidy has  any objections, I will pick the draft order here at work under the scrutinhy  of several other players ( Dave B, O. Winfree, M. Lenhart, M. Walters).\nAlso, by majority vote, will have a required tight end posn.\nMeaning the  starting lineups will include 1QB, 2 RBs, 3 WRs, 1 TE, 1 K, 1 Def.\nPlease e-mail back if you are ok with me picking the draft order.\nEric\n',
 'There are some conflicts with the draft date, so we will probably need to  have it on a different date.\nPlease tell me if you prefer 9/2 ( the day  before the season starts) or 8/20.\nWe could also do it during the week, but  it will probably takle 3 or 4 hrs.\nLet me know suggestions.\n',
 "I don't know the YMCA's policy on rain outs so  I will assume that we still  have a game tonight.\nOur game is at 7:45 tonight.\nPlease let me know if you  will be there.\nEric\n",
 "Hey Lisa,  Long time no hear!\nI guess you are too cool for all of us little people now.\nBrenda is looking for someone to fill Bryan Hull's spot in risk when he  leaves.\nI know that you are looking for a rotation, so I was wondering if  you have an interest.\nLet me know.\nEric\n",
 "You may notice that 9911 PMA's are $(208,881) or approx 10% to the final  P&L.\nYou will also notice that the detail following the majority of the  adjustments is Unaccounted For Gas.\nAt the close of business for the 991  P&L, we saw a gain of approx.\n$250,000 because of a blowout in UA4.\nWe  thought that it would be prudent to top level this amount and use it to  offset the PMA's we would take as a result of this UA4 blowout.\nTherefore,  the net impact of 9911 PMA's is $41,119 or 2% of last day P&L.\nI just wanted to congratulate the team on a great P&L for the month of  November.\n",
 'As required by the Houston Fire Department, a fire drill has been scheduled for the Enron Center Campus.\nEnron Center North, 1400 Smith St., approximately  3:15 PM on Thursday, December 20th, 2001  \tEnron Center South, 1500 Louisiana St., approximately 3:45 PM on Thursday, December 20th, 2001  Please advise all clients, contractors, and visitors that this will be a fire drill only.\nThe fire alarm will sound at 3:15 PM in Enron Center North and 3:45 PM in Enron Center South.\nYou will be asked to go to the stairwell and standby.\nDo not go into the stairwell.\nFurther instructions will be given over the public address system.\nIf you experience any difficulties in hearing either the fire alarm or any announcements over the public address system, please notify the Facilities Help Desk by e-mail at facilitieshelpdesk1@enron.com.\nAnyone that is mobility impaired or medically disabled may be excused from participating in this drill by sending an e-mail to Harry Grubbs.\nIf you have any questions or need any additional information, please contact Harry Grubbs at 713-853-5417.\n',
 'Your mailbox has exceeded one or more size limits set by your administrator.\nYour mailbox size is 112231 KB.\nMailbox size limits: \tYou will receive a warning when your mailbox reaches 75000 KB.\nYou cannot send mail when your mailbox reaches 100000 KB.You may not be able to send or receive new mail until you reduce your mailbox size.\nTo make more space available, delete any items that you are no longer using or move them to your personal folder file (.pst).\nItems in all of your mailbox folders including the Deleted Items and Sent Items folders count against your size limit.\nYou must empty the Deleted Items folder after deleting items or the space will not be freed.\nSee client Help for more information.\n',
 'Your mailbox has exceeded one or more size limits set by your administrator.\nYour mailbox size is 112312 KB.\nMailbox size limits: \tYou will receive a warning when your mailbox reaches 75000 KB.\nYou cannot send mail when your mailbox reaches 100000 KB.You may not be able to send or receive new mail until you reduce your mailbox size.\nTo make more space available, delete any items that you are no longer using or move them to your personal folder file (.pst).\nItems in all of your mailbox folders including the Deleted Items and Sent Items folders count against your size limit.\nYou must empty the Deleted Items folder after deleting items or the space will not be freed.\nSee client Help for more information.\n',
 '******************************************* Save $10 Today and Get Free Shipping!\nShop now!\nOffer expires December 31, 2001 *******************************************  Dear Barnes & Noble.com Customer:  Order now.\nThere are only 5 DAYS in this special End-of-Holidays sale.\nFor a limited time you can save $10 off your order of $40 or more, and if you order two or more items, you will qualify for FREE SHIPPING*!\n',
 'Your mailbox has exceeded one or more size limits set by your administrator.\nYour mailbox size is 113195 KB.\nMailbox size limits: \tYou will receive a warning when your mailbox reaches 75000 KB.\nYou cannot send mail when your mailbox reaches 100000 KB.You may not be able to send or receive new mail until you reduce your mailbox size.\nTo make more space available, delete any items that you are no longer using or move them to your personal folder file (.pst).\nItems in all of your mailbox folders including the Deleted Items and Sent Items folders count against your size limit.\nYou must empty the Deleted Items folder after deleting items or the space will not be freed.\nSee client Help for more information.\n',
 "The following is the information need for the arch set up.\nIf you would like to volunteer to help fill out the attachment form* and drop by 1906 CLaiborne.\nIf you would like to email me that you will help please email your NAME, ADDRESS, AND PHONE to ccvca@ev1.net  *(Note:  We do not send attachments through ccvevents, because of viruses.\nCraig will get the form to me in text form and I will email it to you later.\nYou may not be aware, but I have received several virus from people on the ccvevents list.\nLuckily, I caught them before they attached my system  Happy emailing.)\nAt this time I will need a hard copy of the for for set up .\nAll should be receiving a for on your door this week.\nThey are due before November 17th.\nArch Committee Report  Setup December 1st - Takedown January 5th  Arch Setup is scheduled for Saturday (December 1) with completion on Sunday (December 2) if needed.\nI have a few volunteers that have stated they willing to help on those days but as always could use more.\nI will have a short meeting with the volunteers at my house on Thursday before setup.\nThe more help the faster we can complete the Holiday Decorations.\nLast year we where able to setup the arches in one day.\nI would like to do the same this your.\nMen ,Women, and Teens are asked to help.\nThe process consists of assembly of the arch (men needed), tie the light onto the arch with plastic ties (anyone) and then erecting the Arch (4 men).\nWe will divide up in to due teams that will move down the street performing their part.\nClean holes if needed, assemble arches, check lights, attach lights to arches, retest lights and stand arch At least one experiences arch volunteer from last year will be on each team as the lead .\nIf we get an early star we can complete the setup in one day.\nI would like to start at 8:30 am on Saturday (Dec.1).\nWe can meet at the Church at 8:00 am and delegate duties to groups We will leave from the Church at 8:30 am and start the setups.\nThose helping may want to bring a pair of gloves and wire cutters or side cutters for the ties.\nO' yes, for those that helped last year, we will have the chicken gumbo again.\nI hope that is OK.  We would like to have all setup fees in before setup day.\nI will have a mailbox in front of my house to drop the fee in with your setup form.\nIf you do not send in your form and would like to have your arch setup we will except the fee on Saturday of setup.\nThis fee collection is time consuming and would like not have to deal the fee on setup day.\nIt is the residents responsibility to have the arch parts accessible by 8:30am on the setup Saturday.\nWe will have extra light strings for those that need to purchase replacements.\nIf you would like to have your Arch set up please have the following items completed and ready by Saturday (December 1).\nRequirement for Setup of existing Arches:  All Arch holes will need to be cleaned, by washing out with water prior to setup day.\nAll Arch pieces will need to be places at Arch hole of the resident (Arch Partner) that will plug in the lights.\nAll lights are to be tested and bad lights replaced.\nBulbs available at Hobby Lobby.\nExtension cord laid out for light check prior to Arch Erection.\nAll arch parts accessible by 8:30am Saturday Dec.1.\nI cannot believe that it is already November and we need to be ready for Chirstmas in the Village.\nCraig and the arch team can use our help.\nLet him know if you can lend a hand.\nMary G. Strickland\n",
 "As many of you know, I have a provision in my employment contract which provides for a payment of $20 million per year for the remaining term of my contract in the event of a change of control of Enron.\nThe merger with Dynegy, or a similar transaction with any other company, would trigger this provision on closing.\nAssuming the merger with Dynegy is closed within 6-9 months, as we expect, this provision would entitle me to total payments of slightly more than $60 million.\nMany CEOs have change of control provisions in their employment contracts and mine has been in place since 1989.\nBut given the current circumstances facing the company and our employees, I have been giving a lot of thought these last few days to what to do about this payment.\nInitially, I thought I would use part of the funds for a foundation for our employees and take the remainder in stock and cash.\nHowever, after talking to a number of employees this afternoon, I have decided that the best course of action would be for me to waive my right to any of this payment.\nTherefore, at closing, I will receive no payments under this provision.\nI know this action does not remedy the uncertainty that you and your families face.\nBut please know that I will continue to do everything in my power to serve the best interests of Enron's employees and shareholders.\nI am still very proud of what we have built at Enron, and I want to continue working with all of you to correct the problems and restore Enron to its rightful place in the energy industry.\nThank you.\n",
 'Due to a variety of circumstances we did not migrate employees to the UBSWE environment tonight (Monday, February 4, 2002).\nWe will communicate further details of the migration plan on Tuesday, February 5, 2002.\nThank you for your cooperation in advance, please contact the Resolution Center at x 3-1411 should you have any questions.\nUBSW Energy Global Infrastructure\n',
 'Hello Everyone,   Well, I looked around again for another inexpensive  ski trip for us to take this year.\nThe path has seemed to lead the same  direction as it did last year.\nLake Tahoe is by far the cheapest  package deal I can find.\nI have already spoken to most of you who went  last year and everyone seems to agree it was a good time and great  atmosphere.\nThe dates for this adventure are leaving the evening of  January 30th (Wed.) and returning on Febuary 3rd (Sun.).\nThe vacation package is through Southwest Airlines  Vacations.\nWe will stay at the Horizon Casino for 4  nights.\nWe will depart: Houston Hobby Airport @ 4:50 pm with a short stop  in Las Vegas and arrive into Reno at 9:20 pm.\nWe will then go by Charter  bus to Lake Tahoe.\nLeaving Lake Tahoe: Our plane will depart Reno at 12:10 pm on direct  route to Houston arriving at 6:50 pm.\nAnd you ask how much for all this  excitement?\nThis can be all yours for 359.75 per person.\nThis price is for two people per room.\nI will need to know who would like  to go no later than Wednesday  afternoon so I can set up reservations.\nThese  trips are booking fast.\nWe will be able to do like last year.\nI will  call in the reservations and then each individual person will be able to call  Southwest directly and bill the trip to their own credit card.\nThe only  other expenses to be prepaid are for ski lift tickets and roundtrip transfer  from the airport to the hotel and back.\nThis cost is $30.\nI figure  we will discuss the lift ticket options.\nSome people may want to  Snowmobile a day or do something else.\nWe will discuss these options  further after the trip is set.\nHope to see everyone there.\nThe snow is  looking good up there so far.\nThey had 24" on the mountain  yesterday.\nMason is going.\nI just don\'t have his e-mail  address but he said to count him in.\nScott Tichavsky\n',
 "There is a pretty large group of us going to the  Firehouse for New Year's eve this year.\nMost of the people that attended  the Christmas party and most of the people who went to Schroeder Hall last  year.\nAnyway just wanted to spread the word to a few of you who may not  have gotten the word.\nTickets are $25 apiece and probably need to be  purchased before the end of next week.\nRoger thinks it will sell out  before Christmas.\nHope everyone has a great day.\nJoe if you would  like for us to buy you a ticket let me know.\nThanks\n",
 'Please see the below message from Kevin Sweeney.\nSally  Per our conversation yesterday, below is a list of EGM employees that we would like to reinstate.\nPlease use this for changes to the budget and I will provide a justification memo by lunch time today.\n1.)\nBill Kasemervisz - Manager  2.)\nMarilyn Schoppe - Staff  3.)\nTara Bryce - Staff or Specialist 4.)\nPaula Lacour - Staff or Specialist  5.)\nElizabeth Hernandez - Sr.\nSpecialist   6.)\nLinda Ewing - Specialist   Thanks\n',
 "Sally, The attached file shows the detail of plan headcount for December 31, 1998 through 2001.\nThe only number that I still have a question about, is for EGM December 2001, the number I have in the file only represents the people moving into Networks from EGM (Brent's group).\nI left a message with Tom Myers, to get the correct number.\nI have also added the graphs that we discussed, which show increase in headcount along with increase in deal counts.\nIf you have any questions, let me know.\nThanks,\n",
 'Version 2.0 of the ClickAtHome Portal is now available!\nLog into www.clickathome.net now, from work or home!\nAccess the PEP System through the portal!\nChoose your reviewers and fill out your evaluations in the comfort and privacy of your home!\nOutlook Web Access and eHRonline will be available SOON!\nThe ClickAtHome portal is fully customizable for you!\nYOU choose the content on each page, as well as the look and feel!\nNote: the ClickAtHome portal must be launched through an Internet Explorer browser, 5.0 or higher.\n',
 'During the morning meeting today Rick Buy commented on what a good job EGM has done in the officialization process.\nHe took your names because he wanted to know who to thank for this.\nHis comments are based on the summary graph - his words - EGM has by far the most books but never shows up on the log - who can we thank for that?\n',
 'When: Thursday, May 31, 2001 9:00 AM-10:00 AM (GMT-06:00) Central Time (US & Canada).\nWhere: EB3270  *~*~*~*~*~*~*~*~*~*  Due to this past Memorial Holiday our EA Staff Meeting has been rescheduled this week at the indicated time.\nIf you have any questions or concerns, please call me at x33278.\nThank you,\n',
 'Attached please find the weekly summary report for the week of 05/28-06/01.\nAdditionally, the daily log for 06/04 is attached her with.\nIf you have any questions or comments please advise.\nRegards,\n',
 'JUST A REMINDER!\nGlobal Risk Management Operations Mid-Year PRC Meeting Will be held on Friday, June 8, 2001 8:00am* - ?\nDoubleTree Hotel Granger A Room  Breakfast and Lunch will be provided.\n*Sally Beck, Wes Colwell, & Greg Piper will join meeting at 10:00 AM\n',
 'As you may recall, the SAP system response time was slow during the September Quarter-end close period.\nThe Integrated Solutions Center (ISC) has been working diligently to address the root causes of this issue and can report that significant progress has been made.\nWith the October month-end close fast approaching, we want to provide you with an update as to the progress made in identifying and addressing the root causes for slow system response.\nPoor Performing Programs The ISC has identified a number of poor performing programs.\nSome program redesign has already occurred with continued efforts proceeding through year end.\nIn addition, system and data base parameters as well as indexes have been tuned.\nThese actions have resulted in improvements that should enable Enron to realize better system response in the upcoming close.\nWorkload Distribution The ISC has identified jobs, both scheduled and user submitted, that result in system "bottlenecks".\nWe have accelerated the purchase of system hardware to provide additional capacity and expect this upgrade to occur prior to year-end close.\nIn addition, the ISC has implemented a plan to provide business users with more information regarding efficient methods of report execution.\nWorkshops are currently being conducted with key "close-users" from the various business units to provide techniques that will enable more efficient report execution during the close process.\nImproved Close Monitoring The ISC has been working to heighten the monitoring of key close jobs in order to more effectively identify and resolve close related issues.\nAn initiative is underway to improve the utilization of automated tools to better monitor, identify, and escalate close-related problems.\nCommunication Strategy Implement The ISC has established a plan to more effectively communicate to our customers in the event of future system performance issues.\nThis plan will ensure that information will be provided to users regarding system performance and resolution status in a timely manner.\nPlease feel free to contact me if you would like additional details regarding our efforts to improve overall system performance.\n',
 "We are getting closer to finishing up the agreement to sale a license to use POPS and its source code to AEP.\nIt looks like we agree in principal but I'm not comfortable with some of the language proposed by AEP.\nSince Barbara Gary is out until next Tuesday I don't anticipate us finishing up the agreement until the end of next week at the earliest.\nGiven the timing we need to be able to turn around and deliver the application & documentation by the end of November in order to receive all of the funds this year.\nI will be setting up a meeting with the application, DBA, DA and technical writing teams to make sure we are all on the same page and ready to deliver the application by the end of November.\n-  Tommy\n",
 "Sally - Lloyd Will and I would like to swing by and make a quick introduction.\nAlso....we would love to talk you out of a high level org chart of your organization.\nI work for Ozzie Pagan in EES and am tasked with getting the EES Retail Operation Center (ROC) off the ground.\nMy technology guys report in to Anthony Dayao (thru Mike Fink).\nWe have linked up with Lloyd Will in ENA so that we don't have to hire operators and re-create the functions he has already pioneered with the hourly and cash desks.\nI'm also working with Evan Hughes and Murray O'Neal in Beth Apollo's group to define roles/interface points for DG and Load Curtailment products (on the billing/settlement side).\nFinally, I'm working with the team that is attempting to define consolodated Risk Systems (Dayao/Accencur et all)  a)  could Lloyd and I get a high level org chart for your org so we recognize/understand/get to know your folks?\nb)  Lloyd and I would like to come by for 10 minutes and introduce ourselves - we will attempt to schedule thru Christina  Regards\n",
 'Good morning Sally.\nPlease find attached the executive summary for Project Green Light.\nPlease let me know if you have any questions/changes.\nThanks.\n- Tom\n',
 'Hi everyone -  It looks as though the best date for the Management Committee Extended Meeting is Wednesday, January 23 beginning at 12:00 noon and extending until approximately 5:00 p.m.\nThe meeting will be in 50M Dining Room and lunch will be provided.\nKen hopes that everyone will be able to attend.\nPlease let me know for planning purposes.\nRosie\n',
 'To set the record straight, EES are maintaining their business as usual stance.\nThis means that Anthony does NOT have to cut any people if he so wishes.\nHe may, however, take this opportunity to sever low performers as part of the bigger severance plan if necessary.\nRegards\n',
 'Sally and Kevin,  Fariba Karimi does the Accounting for Equity Trading.\nShe has been in our group for about a year as a Senior Specialist.\nShe will be released from her current role at the end of January.\nShe is very interested in finding another spot at Enron.\nIf you are aware of anything in either Operations or Accounting, please give me or her a call at 5-2510.\nThanks,\n',
 'Congratulations on the birth of your daughter!\nMeagan called this afternoon  to tell me the news.\nI will perhaps get more details when I get home  tonight.\nI hope that Laura and the baby are doing well.\nLet us know what we  can do to help.\nI am sure that Jackson is a proud brother.\nWe will be  anxious to meet our newest neighbor.\n--Sally\n',
 "I didn't get back from the meeting with Causey and Buy until just before 6:00  today - not that the meeting was long - Rick Causey was just running late so  we cooled our heels outside his office for quite a while before getting  started.\nI decided that midnight would be outside the bounds of office  dedication, so I did not call!\nEnjoy your time off tomorrow and on Monday.\nMy plans are to take off next week, and to be back in the office to work the  week between Christmas and New Years.\nI wouldn't recommend taking your time  during your day off to call, but if you finish your Christmas shopping and do  want to call, my calendar is free all afternoon after lunch tomorrow.\nWish I  could send you with a shopping list for me!\n!\n",
 'Thanks in advance for agreeing to speak at the Global Operations Controller  Forum.\nI know that we are catching you before a tee time on Monday, so I  especially appreciate your joining us to kick off the event that morning.\nDress for the forum is casual, so feel free to do the same.\nThere will be  approximately 30 Enron business controllers present at the meeting.\nAll have  responsibility for mid and back office operations for the following Enron  entities:  Enron North America, Enron Europe, Enron South America, Enron  Global Markets, Enron Industrial Markets, Enron Broadband Services and Enron  Energy Services.\nAttendees will be here from Houston, Calgary, Tokyo,  Sydney, London and New York (metals business).\nAttached for your reference is the agenda.\nThere may be some slight changes  before the forum begins, but this will give you a good idea of the topics to  be covered and the other speakers who will address the group.\nYou are scheduled to address the group as follows:\n',
 'Thanks in advance for agreeing to speak at the Global Operations Controller  Forum.\nThere will be approximately 30 Enron business controllers present at  the meeting.\nAll have responsibility for mid and back office operations for  the following Enron entities:  Enron North America, Enron Europe, Enron South  America, Enron Global Markets, Enron Industrial Markets, Enron Broadband  Services and Enron Energy Services.\nAttendees will be here from Houston,  Calgary, Tokyo, Sydney, London and New York (metals business).\nAttached for your reference is the agenda.\nThere may be some slight changes  before the forum begins, but this will give you a good idea of the topics to  be covered and the other speakers who will address the group.\nYou are scheduled to address the group as follows:\n',
 'I sent an e:mail message yesterday saying that I could make dinner in Austin  on Wednesday, October 25.\nThat date does not work for me now.\nI need to  attend a get together for the CommodityLogic team that evening, that was just  set up today.\nAs of last week, I am now co-leading CommodityLogic (under  Enron Networks) along with Tom Gros.\nThis is in addition to my role within  ENA.\nAs a new lead over the group, it is important for me to join the team  for their team building next Wednesday.\nLet me know whether or not you have enough takers for dinner in Austin next  week.\nIf you are short, let me know and I will see what I can do on another  night that week.\n--Sally\n',
 'I always compile a contact list for Energy Operations during the holidays  (Thanksgiving, Christmas and New Years).\nJust let me know who appropriate  contacts will be, especially for the DPR and MPR, during the dates that you  are out.\nSounds as if you should see a white Christmas!\n--Sally\n',
 'Attached is a memo that I have sent to Mike Jordan regarding the Operations  Controller forum set for October 22, 23 and 24.\nI want to send the official  invitation early next week.\nI have conferred with Mike on attendees from  EEL.\nSince I do not know all of the reporting relationships in London, I  did want to share this list with you and get your input as well before it is  finalized.\nPlease let me know your thoughts on attendees per the attached.\nMike was not sure that you would want to be included, but I certainly want to  invite you and would very much welcome your attendance.\nIf you can come, I  would be great for you to address the group if you would like to do so.\nJust  let me know.\nJeff Skilling, Rick Causey, Ted Murphy and Bill Bradford are  confirmed as speakers, and I am waiting to hear from Mark Frevert on his  participation.\nI expect to sent a preliminary agenda out for review next  week as well, and would welcome your comments on that.\nHope you have a great weekend.\n--Sally\n',
 'Diana,  Here\'s info you requested.\nPer our conversation earlier, please try to  arrange someone with experience/knowledge of Jornada device for training for  Sally & me both.\nSally is not very technical & will need to be walked thru.\nIf she doesn\'t learn how to properly use it, she will not use it, if you know  what I mean.\nAny help you can give me in setting up training w/ someone that  will be able to answer our questions is greatly appreciated.\nPlease have  person contact me directly as I keep Sally\'s calendar.\nShe will be in  training all day Thursday & Friday, so Monday would be the soonest she is  available.\nID:    sbeck Password:   balc33balc Lotus password:   balc33balc H:\\ drive mapping:  "nahou-uv3"  I submitted SRRS for "in sync" two or three weeks ago.\nLet me know if you need anything else.\nPatti Thompson x39106\n',
 'Thanks for you message.\nI am glad to know that you like what you see in the  office to date.\nI am planning a trip to Chicago soon, so I will look forward  to seeing you there.\n',
 'Great job, as usual, on the United Way kick off today.\nI saw Amy Leeand  Eylesse Kalmans as I left the Hyatt and I told them.\nPlease pass the kudos  along to the rest of your team.\nThe theme was timely, the staging was great,  the questions on the gameshow were even educational for newer Enron  employees, giving a little histsory and folklore about Enron.\n(I knew the  WLEC 1 answer!)\nI especially enjoyed the breakfast at Depelchin last Friday.\nTheir programs  are important to all of us and the tour was very moving as we met some of the  children in the shelter.\n',
 "The United Way Executive Solicitiation is underway.\nYou should have received  an e:mail message about a week or ten days ago which let you know that you  this year pledges should be made on line.\nMark Frevert reminded everyone at  today's ENA staff meeting to complete their pledges by Tuesday, August 8.\nIf  you have not already done so, I would encourage you to complete your pledges  before Tuesday.\nPatti Thompson can tell you where to go on line to do this.\nPeggy:  United Way may not apply in Canada, so ignore this if not  appropriate.\n",
 "Attached are my accomplishments for the first half of 2000.\nI should have  had these for you on Tuesday for your PRC.\nHopefully, better late than  never.\nI am not certain how the coporate-wide PRC process will work in late  July for VP's.\nI have provided a copy of this to Dave Delainey for the ENA  PRC which will take place on July 7.\nI thought that I would provide you a  copy as well.\nI will also have Patti deliver a hard copy to Sharron next week.\n",
 "I asked my new hire to suggest names of people that she knows that would be  good for to consider hiring.\nHere is her response.\nTony Vasut had called  her and asked for this list as well.\nDo you have him keyed in on our blitz  effort for hiring of risk personnel?\nOr is he working on some other  initiative?\nI have not reviewed the names nor Shona's comments in detail  yet, but I wanted to pass these along for inclusion in our efforts.\n--Sally\n",
 "Hi Ted,  It's Patti.\nAn all day meeting has been scheduled for Wednesday, May 31 -  the day you and Sally were scheduled for lunch.\nAny possibility of  rescheduling to another day?\nSally is available Thursday, June 1.\nJust let me know.\nThanks,\n",
 "Congratulations on your added role of Chairman and CEO of ENA.\nI didn't  realize that when I said hello in the elevator last week that we would be  seeing more of you in Houston.\nI look forward to working with you when you  arrive.\n",
 'Below is the name and phone number of the woman that I worked with to arrange  our tour of Enron  Field.\nShe may not be the person to talk with regarding  displaying a boat, but  will very likely be able to give the correct  contact.\nIt was nice to meet you.\nI have enjoyed getting to know Bethany  through NCL.\nGood luck!\n',
 'Below is an announcement that was sent to employees within Enron Europe tod= ay=20 from Fernley Dyson and me.\nMost of you have probably become aware of the= =20 assignment that Brent will have over the next few months in London.\nWe=20 anticipate that he will be back in the Houston office by the end of the=20 second quarter.\nI thought that you would like to see how we have described= =20 the role that he will play in London.\n=20  Brent will retain his current role within North America, and will be=20 conducting his Houston staff meetings via conference call from London.\nSus= an=20 Harrison and Steve Jackson will play leadership roles for his gas team whil= e=20 he is in London;  Susan with a focus on operations and Steve with a focus o= n=20 risk and interfacing with Jeff Shankman\'s on daily p&l and position=20 information.\nneeds.\n=20  Please wish Brent well in this additional assignment in London.\nI would as= k=20 that you help defeat the "out of sight, out of mind" syndrome, and that you= =20 keep Brent informed of ENA issues as you would if he were in town, via e:ma= il=20 or telephone.\nAlso, please work closely with Susan and Steve when you are= =20 dealing with issues that cut across commodity lines.\nSusan will be attendi= ng=20 the Monday afternoon staff meeting.\n=20\n',
 'Ted Murphy, Tom Bauer, Jim Brown and I met yesterday to schedule the next  series of operations/controls reviews of Enron offices or certain companies  in which Enron holds an ownership interest.\nAttached is a copy of that  schedule.\nPlease contact Ted or me if you have any questions.\nYou will note  that the full make-up of the teams is being worked on currently.\nWe have  identified the lead on each review, however, from RAC, Operations and AA.\n',
 'Barry, Sally asked me to forward this to you FYI.\nA lot of people will be tied up  all day Feb 29 at this offsite.\nShe would, however, like to set up time to  meet with you in Houston on Wednesday, March 1.\nSally is available from 1:30  - 5:00 in the afternoon.\nPlease let me know if there is a one hour slot that  will work for you.\nThanks,\n',
 "FYI - I had included Diane Seib and Melinda Whalen (from Calgary) in my  promotion memo from Energy Operations.\nI believe that they both work under  Peggy Hedstrom in operational roles.\nI am sure that they didn't mind having  their names included twice in promotional memos!\nPeggy says that you and Juanita are headed to Calgary next week, and she  wondered if I would be coming.\nI will be in South America in what should be  summer there.\nI do plan to make a trip to Calgary soon.\nIn addition to  other things that Peggy and I have to cover, I plan to host a happy hour in  Calgary to honor Peggy's promotion and Diane and Melinda, also.\nI hosted a  happy hour in Houston for Energy Operations employees who were promoted last  week, and I wanted to do the same thing for the three in Calgary.\n",
 'I will be attending a funeral in Austin on Thursday.\nI can be reached on my  cell phone (713-417-1951) in the morning and afternoon while driving to and  from Austin.\nIf you need immediate information and I can not be reached on  my cell phone, please contact Brent Price at x37647.\nI will be back in the  office on Friday.\n',
 'Please  update my listing for direct reports.\nDo you distribute a copy of  this to my direct reports?\nIf so, please get an updated copy to them as  well.\nThanks!\n',
 'I wanted to extend my thanks in advance to all of you who will join me in the  office on January 1, 2000.\nI appreciate your willingness to devote part of  your holiday weekend to the continuing success story at Enron.\nAs a company, Enron has spent much time and effort to ensure that business  will continue smoothly as we move into the year 2000.\nKen Walther, in  working with many of you, has done an excellent job of preparing a work plan  for January 1.\nYour  work on the first  will be the final step in this  process.\nYour efforts that day will allow all ENA employees to return to the  office on January 4th with confidence in our ability to continue business as  usual.\nI wish each one of you a happy new year.\nI continually feel privileged to  work with this dedicated and talented group of  employees.\nI look forward to  all that we will accomplish in 2000.\n',
 "Three weeks ago I started a 15 minute meeting in my office on Monday mornings  for a key group working on the commercialization effort of mid and back  office services.\nAttendees are my key operations personnel involved, Todd  Busby (for a preview of what's to come), Rahil and Fred Philipson.\nThe  purpose of the meeting is to review progress on items agreed to for the  previous week and to establish priorities for the current week.\nI have been  capturing all of this on the white board in my office to date.\nToday I  decided to recap in writing for everyone.\nThought that you might be  interested.\nOpen the attachment to the e-mail below.\nThis way you will know  more of the details of our efforts each week.\n--Sally\n",
 'Congratulations on the birth of Emma.\nI hope that everyone is doing well.\nEnjoy your time off and the opportunity to hold and hug that new baby.\nI  will look forward to seeing pictures the next time that we get together.\n',
 "I will serve as a representative to the  Associates PRC meeting that will  take place on December 12.\nAs a PRC rep, I have been assigned the Associates  to represent in the meeting as indicated below.\nThe Associates Program has  provided me with your name as the supervisor of record as of October 1 of the  Associate as listed.\nPlease send the following information to me by December 1.\nAssociate's accomplishments for the second half of 2000 (prepared by the  associate or summarized by you)   Description of associate's current responsibilities/assignment (and any  additional rotational assignments during this last six months of the year)   Pre-ranking of the associate from your business unit PRC , or your suggestion  on ranking if no business unit PRC process has been completed (Superior,  Excellent, Strong, Satisfactory, Needs Improvement or Issues)   Any other information that you believe will be helpful in accurately  representing the associate in the PRC process  Recommendation for promotion, if any   I will receive a copy of the Consolidated Supervisor Feedback from the PEP  system through the Associates Program.\nI will be at a management conference Thursday and Friday of this week, then  on vacation until Monday, November 27.\nMy assistant, Patti Thompson, will be  contacting you next week to arrange a time to meet or talk by phone during  the week of November 27 or December 4 to discuss your associate and his/her  performance in more detail.\nI will also contact the Associates and meet with  them individually in preparation for the PRC meeting.\nThanks for your attention to this.\nIf you are not the appropriate PRC  supervisor for the Associate listed above,  please reply by e:mail as soon as  possible and my assistant will research where I should go next for this  input.\n",
 'The floors chosen for these meetings appear to be geared to the IT teams.\nBetween my operations teams dedicated to EA, EGM and EIM, I have roughly 500  employees in the Enron building.\nDo you want all of them to choose one of  the floors noted in your e-mail message, or would it be better to schedule  one or two floor meetings in locations that more easily incorporate this  segment of Net Works?\nI have noted below the approximate number of employees  per floor (including only those floors with a significant number of  operations employees):      29th Floor (trading) 67 employees  EGM risk, vol.\nmgmt., confirms,  settlements and EIM risk     30th Floor (trading) 35 employees  EGM risk, confirms, settlements (various  products)     31st Floor (trading) 52  employees  Power risk, confirms, vol.\nmgnt.,  settlements and DPR           and MPR teams      32nd Floor (trading) 117 employees  Gas risk, logistics (all regions),  operational analysis          37th Floor   148 employees  Gas vol.\nmgmt., settlements, and global  services        Also, given the fact that operations is a relative "newcomer" to Enron  Networks and yet represents a large number of employees in the group, I would  be happy to work with you on remarks for all of the floor meetings to make it  easier for you to be fully inclusive in these sessions.\n--Sally\n',
 'Please put the 17th meeting on my calendar.\nI may or may not attend, but  want to have that on the calendar just in case.\nThanks.\n',
 'Expect Patti to contact you about setting aside 15 minutes each Monday to  meet in my office as a team to quickly prioritize tasks for the week  regarding the commercialization of our services.\nWhile we will certainly  draw upon the knowledge of  others within Operations, we will consider this  to be the core resource team.\nWe want to continue to build momentum for this  effort.\nKnowing that we are all stretched in managing the day-to-day  business, this quick focus each week on the key tasks will keep all of us  informed and in alignment.\nThanks!\n',
 'FYI - See attachment for latest attempt at satisfying the "ill-defined".\nIf  this is not on target, we will keep working until it is!\n- Sally\n',
 'Thought you might like to see this note from Max on the doorstep review in  Monterrey.\nBeth is a great addition and has made a very positive impact  already.\n--Sally\n',
 "An update on two of the items that we discussed before you went out of town:  Due Diligence Teams for Acquisitions Identified  I have worked with my operations controllers in EWS and have identified a  short list of individuals that we could use in the due diligence efforts on  potential acquisitions.\nWe have identified our target teams for due  diligence efforts around commodities.\nWhile each person on the list has  other duties currently, all have back ups that would allow them to be devoted  to projects as they arise.\nI will review this list continually and update it  as I identify other qualified operations personnel who could do an excellent  job as part of a due diligence team.\nI mentioned that Kristin Albrecht had  created a due diligence check list while she was in London on the MG  acquisition.\nWe will hold a session in the next 10 days to review this  checklist so that all are prepared.\nLet me know if you are interested in the  names on my list.\nAlso let me know if there is a pending due diligence  effort.\nDedicated Support Named for Transportation Business  I met with Dan Reck and Chris Kravas week before last and have reviewed the  executive summary from the consulting team.\nI followed up with Brent Price  (my operations controller for EGM) to review his plan for creating an  appropriate infrastructure to support that business.\nCurrently, Todd Hall  and Mike Perun on Brent's team are assessing what needs to be done.\nTodd has  other responsibilities and Dan Reck was concerned about the amount of time  that Todd would have.\nBrent has since recruited Shelley Stubbs to play the  lead role over operations integration for Webmodal.\nShe will be returning to  Houston from the London office by the end of March.\nShe will be able to  split her time starting next week to focus on Webmodal.\nTodd will stay  involved until Shelley is devoted fulltime at the end of March.\nWe will also  keep Mike Perun on the assignment working for Shelley.\nShelley is expected  to be in Houston next week, and I will sit in on meetings with her next week  regarding our plans.\nI will keep you posted.\n",
 "As part of the modelling process, Marc is going to meet with James Scribner  on Tuesday morning at 9:00 am to review our operations pricing model.\nIf you  can join them, you might find it interesting.\nThey plan to meet in James'  office - EB3756.\n--Sally\n",
 "Brent Price, Bob Hall, Leslie Reeves and I would like to invite you to lunch  on Friday, February 9 in recognition of your promotions to Director and  Senior Director.\nWe appreciate your contributions to the continuing success  of Enron's wholesale services business and feel that these promotions are  worthy of celebration.\nPlease RSVP to Patti Thompson (x39106).\nDetails on time and location will  follow.\n",
 'On January 12, I hosted a brainstorming session at the Four Seasons hotel i= n=20 downtown Houston in which we assembled a number of ideas regarding mid and= =20 back office services we could offer to the commodity industry.\nTo complete=  a=20 plan for launching this strategic commercial venture, we are hosting an=20 integrated design session facilitated by Cap Gemini Ernst & Young (CGEY) at= =20 their Accelerated Solutions Environment in Dallas, Texas.\n=20  I am personally extending an invitation to you to participate in this desig= n=20 session.\nThis is a critical two-day event to be held February 12th and 13t= h=20 in Dallas, Texas.\nThis work session is based on a unique approach called = a=20 DesignShop=01v.\nIt is a very focused, activity-driven event that is compos= ed of=20 various modules and exercises performed in small and large groups.\nIf you= =20 have not attended one of the DesignShops related to SAP, you will likely=20 regard this session as different from any working session you have previous= ly=20 experienced.\nThe prior DesignShops held in conjunction with SAP have proven= =20 to be very successful.\nTherefore, we have elected to utilize this same=20 methodology on this very critical and strategic venture.\nA limited number of representatives from Enron will be attending.\nYou were= =20 selected to be one of approximately 30 key individuals to participate in th= e=20 DesignShop.\nYou are being asked to participate in the full two days with as= =20 little distraction or interruption as possible.\nThe quality of our results= =20 depends on each participant being fully engaged and participative for the= =20 entire event.\nAdditionally, you will be relied on in the future to suppor= t=20 and communicate our commercial strategy as it is defined at this session.\n= =20 This date was specifically selected to avoid critical operational periods s= o=20 that your participation can be maximized.\nTherefore, please make all=20 necessary arrangements at the office to minimize your distractions during= =20 these two days.\n',
 'The promotional memo came out a few hours too late today for me to be able to  mention it when we talked this afternoon.\nCongratulations on your promotion  to managing director!\n--Sally\n',
 "I assume that since you didn't respond to my first two emails, none of you require access to stack manager.\nIf this is incorrect, please respond to my previous emails.\nThanks,\n",
 "All,  The below Analyst & Associate recruiting dates require ENA participation at Manager level at above.\nIn order to resource each of your departments it is important to have ENA's involvement and participation in the interviews and debrief sessions on Fantastic Friday and Super Saturday events.\nThese de-brief sessions will allow you the opportunity to select candidates you wish to join your groups.\nThe target  is to assign potential candidates to business units and departments from the outset.\nAs ENA has the highest percentage of A&A rotating in its business unit, the participation of ENA at interview should reflect this.\nTherefore, please encourage your direct reports and managers to participate in the below events in order to secure candidates for your business area.\nAssociate Recruiting:\t\tSaturday November 3\t\t\t\t\t\tTotal - 70 Candidates for Interview Analyst Recruiting:\t\tFriday, November 16\t\t\t\t\t\tTotal - 70 Candidates for Interivew Associate Recruiting:\t\tSaturday, December 1\t\t\t\t\t\tTotal - 70 Candidates for Interview  The above spreadsheet represents ENA's particpation today which I believe highlights the need for much additional support in these efforts.\nPlease confirm by return participation of your respective groups.\nRegards,\n",
 "FYI if you haven't already heard...........A quick update on PJM:  1) GPU: The PA PUC ruled in favor of the First Energy merger, but deferred a rate increase.\nCollaberative meeting are supposed to be taking place over the next month, but Enron's regulatory view is that a setlement will not be able to be reached.\nThe question is if First Energy is still interested in persuing the merger if a rate increase does not occur.\nIf the merger does not occur, I think this increases our chances of a deal to mitigate GPU's risk, if we can work out the credit issues.\nGPU will probably be stalling most activity until a definitive answer is announced.\nThe NJ BPU will determine its verdict on the merger Jun 29.\n2) PPL's (regulated) RFP is due tomorrow.\nEnron will not be quoting, given the fact that the size is HUGE.......46,260,000 PV'd MWH, ancillary and ICAP requirements.\nI believe PPL (unreg) will be quoting on a this, and are talking ot them about taking them out of some of the energy risk, leaving them more merchant MW.\nAlso , the quotes are due tomorrow, but must be held open until July 16 (what a deal!).\n3) NJ Board of Public Utilities (BPU) is looking to hold a joint competitive bid of energy and capacity to all default suppliers.\nThis is expected to be 18,000MW, which includes the load of PSEG, GPU NJ, and Connectiv NJ.\nThe BPU will be reviewing the proposals Aug 1.\nI will be out of the office Wed- Fri, seeing Exelon, GPU, PPL, and UGI.\nJanelle\n",
 "With the formation of the Management Committee we are discontinuing the Enron Executive Committee.\nInstead of weekly Executive Committee meetings with a subset of Enron's Managing Directors, we will hold quarterly meetings which will include all of Enron's Managing Directors.\nThese meetings will allow a wider dissemination of information and views and will enable more substantive discussions about the opportunities and challenges we face.\nThe members of the Management Committee will continue to meet each Monday at 11:00 a.m. (Houston time).\n",
 'When: Tuesday, January 29, 2002 1:00 PM-2:30 PM (GMT-06:00) Central Time (US & Canada).\nWhere: ECS6980  *~*~*~*~*~*~*~*~*~*   As promised, please find the attached agenda for our follow-up meeting regarding CPM and additional P&L requirements.\nSee you at 1:00...  Steve\n',
 'Subject: Access Card Information  Dear Colleagues,  We know you have many questions about your new benefits plan, payroll issues and other changes that will occur over the next few weeks.\nHuman Resources and Communications are preparing a thorough Q&A, which we will send to you tomorrow and will regularly update as more information is available.\nMeanwhile, please read the announcement below from Security about how you can obtain a new UBS Warburg access card that will allow you to enter our new office space after Friday.\nI am confident that you share my enthusiasm about our new opportunity.\nWe look forward to working along side each of you in the coming days.\nDavid Oxley Human Resources\n',
 "FOLLOW ME TO FINANCIAL FREEDOM!!\nI Am looking for people with good work ethics and extrordinary desire to earn at least $10,000 per month working from home!\nNO SPECIAL SKILLS OR EXPERIENCE REQUIRED.\nWe will give you all the training and personal support you will need to ensure your success!\nThis LEGITIMATE HOME-BASED INCOME OPPORTUNITY can put you back in control of your time, your finances, and your life!\nIf you've tried other opportunities in the past that have failed to live up their promises, THIS IS DIFFERENT THEN ANYTHING ELSE YOU'VE SEEN!\nTHIS IS NOT A GET RICH QUICK SCHEME!\nYOUR FINANCIAL PAST DOES NOT HAVE TO BE YOUR FINANCIAL FUTURE!\n",
 "Attached is the current version of TW's Firm Capacity Procedures.\n(Posting requirements are defined in another document.)\nThese procedures outline the definitions of certificated/sustainable, operational/short-term sustainable and operational non-sustainable capacity and how we will determine how much and when capacity is available in each of these categories.\nI thought I would go ahead and distribute this because there have been some questions - though I understand some of the recent FERC rulings may require us to change the procedures as it concerns, among other things, whether operational/short-term sustainable capacity is sold under LFT vs. daily under FTS-1.\n",
 'Of interest - Gas Logistics combined 2001 payroll is $8,209,648.\nThe 2002 Plans were built with a 4.25% combined merit and other which equates to $348,910.\nAt 3.75% the combined merit and other equates to $307,862, a reduction of $41,048.\nOver the next few days, I will be rebuilding the 2002 revised plan for distribution.\nDonna\n',
 'On September 24, 2001, Alice gave each of you a list of your outstanding accounts receivable \tback to January, 1998.\nIn meeting with Alice today, I understand, we have NOT cleaned up very \tmany of these issues.\nAlice will be getting with each one of you AGAIN to review your accounts.\nMy expectation is \tthat there has been some clean up activity before Performance Reviews at which time I will \task Alice for an update.\nAlice, Raetta and Larry are all available as needed to help you in \tthis effort.\nAll clean up should be completed by December 31, 2001.\n',
 'Everyone,  Attached is a proposed EDI confirmation process and timeline for Transwestern EDI confirmations with El Paso.\nPlease review and let me know if there are any changes that need to be made to this document.\nI have also included sections with changes to the current process and proposed system enhancements.\nMary\n',
 'I want to remind everyone when NNG calls on the Carlton Resolution, we can NOT \tallow ANY deliveries at Carlton.\nAt each cycle, please be sure you monitor any deliveries at Carlton \tand let Steve, Gary or Darrell know if you see any nominations.\nAt that \tpoint Carlton Deliveries should be allocated to zero (0).\nIf you have any questions, or we need to discuss further, please let me know.\nThanks.\nLynn\n',
 'All:    As part of the TW Negotiated Rate Settlement Hearing, it has been suggested that the following modification to CAS and other associated systems be made:  EBB sytem that allows a shipper interested in capacity to simply enter a receipt and delivery point; the system will automatically let the interested shipper know how much, if any, capacity is available (advantage: although it doesn\'t provide the IS\'s the "last look" auction their looking for, it at least provides an open process for anybody that is interested to find out if capacity is available (eliminates any claim of "tortious process"); disadvantage: feasibility and cost are unknown at this time).\nThis was drafted by an attorney without considerable consultation with Gas Logistics.\nA settlement offer that includes minor tariff changes will be provided to the parties in the proceeding this week.\nAlthough this will buy some time, a scope and cost estimate needs to be determined so that if the modification above is offered, we know what the cost is.\nAlma:  Please schedule a 1 hour meeting with anyone on the distribution and if anyone else should be included, please let Alma know.\nBrad\n',
 'Effective November 1, 2001, Northern implemented new posting procedures regarding capacity availability.\nThese procedures are attached.\nSeveral changes have been implemented.\nIn summary, the following changes have been incorporated:  The Unsubscribed Capacity Report has been updated to reflect the gas day two (2) days in the future vs fourteen (14) days.\na "new" Short Term Sustainable Capacity (STSC) Report has been posted beginning on the November 1st gas day.\nThis report is displayed on Northern\'s website under the Informational Posting; Capacity; Unsubscribed Capacity   a "new" rolling 30 day Unsubscribed Daily Capacity Report is posted each morning for day-to-day transactions.\nDaily capacity can be posted by point or group but must be identified with an asterisk (*) on the STSC Report at least one business day before being posted on the Unsubscribed Daily Capacity Report.\nPlease take a moment to review these report on the website.\nIf I have left anyone off this distribution that may be affected or interested in the procedures, please forward on.\nIf you have any questions or concerns regarding these procedures please let me know.\nThanks MW\n',
 'Enron Global Technology is in the process of decommissioning the support for all non-standard Internet Email address formats.\nThe only Internet Email address format that will be supported, once this effort is completed, is firstname.lastname@enron.com.\nWe will no longer support Internet Email address formats such as name@enron.com, name@ect.enron.com, name@ei.enron.com  (where "name" is an abbreviation, acronym or alternative to an employees firstname and/or lastname).\nEvery Enron employee has an Internet Email address of firstname.lastname@enron.com and must begin making the necessary arrangements to start using this Internet address format if they are not using it already.\nAny new/existing application systems or business cards that reference a non-supported Internet Email address will need to be changed to reference the only supported firstname.lastname@enron.com Internet address format.\nIt is important to remember to also notify any external contacts who are currently sending Internet email to any non-supported Internet Email addresses.\nTo determine what your supported Internet Email address is, take your name as it appears in Outlook or Lotus Notes and replace any "spaces" that appear in your name with periods and append @enron.com.\nFor example in Outlook, Alan Smith, Robert (firstname = Robert, Lastname = Alan Smith) will have a supported Internet Email address of robert.alan.smith@enron.com.\nIMPORTANT : If you need to update your business card(s) to reflect your supported Internet Email address, please ensure you test & confirm the delivery of Internet email to your supported email address prior to updating your business cards.\nIf you experience any issues with delivery of Internet email to your supported Internet email address, please contact the Resolution Center.\nWe will communicate further details, including the cut-off date, in the coming weeks.\nMeanwhile, it is imperative that you begin making the necessary arrangements to change over to using the firstname.lastname@enron.com Internet Email address format.\nIf you have questions regarding this email, send an Email to enron.messaging.administration@enron.com.\nThank you for participation, cooperation and support.\nEnron Messaging Administration\n',
 'Borderline An Update from Northern Border Pipeline\'s Customer Services and Gas Control Departments  No: 2001-21                                                    Date: October 26, 2001    Web Site Change  On Monday, October 29, the look and feel of Northern Border Pipeline\'s informational posting site will officially change.\nIn addition, the URL tied to the site will be slightly modified.\nThe new main URL will be www.nbpl.enron.com (nbpl versus nbp).\nWe recognize that it may take a bit of time for this subtle abbreviation change to sink in.\nConsequently, our server has been set up to redirect anyone using the previous informational posting web address to the new site.\nBut for those more detailed URL addresses that have been set up in a browser or portal site to link directly to information posted in the old site, this changeover will not be as friendly; be aware that those specific addresses will be retired along with the old site.\nAs for the new web site layout, it has been purposely built under a "simpler is better" philosophy.\nIt will not win any artistic design awards.\nBut for the purpose of providing information, we believe that functionality of an informational posting web site should always overrule show.\nWe hope that you will agree.\nIt also should be noted that the new site design is not totally new and untested; it closely parallels the solution we implemented earlier this year for Midwestern Gas Transmission, our sister pipeline company.\nSo those who have accessed information recently on MGT should be familiar with the layout.\nAs always, we are open to suggestions.\nPlease let us know what you think.\n',
 "There is a problem between PGAS and TMS.\nThe actual volumes for the 26th are not correct in TMS.\nIn doing the Bushton PVR report I found that the actual volume in TMS did not match the actual volume in PGAS for the PVR measured.\nI then began to look at other points, Spearman, Beaver Co's, etc; and found the same problem existed.\nRandy Janzen 3-5962\n",
 "Lynn & Raetta,  In a conference call with Frank Semin, Courtney Barker, Gary Anderson and Ellis Stern today it was discussed on how the end of the month volumes have been estimated in the past dealing with 16 and 31 days charts.\nAlso, it was discussed on how this affects DDVC and other penalties that are billed from a Gas Logistics perspective.\nFrank is needing to respond to MidAmerican on how NNG actualizes daily volume at their untelemetered (chart/index) end user points.\nFrank would like to schedule a meeting with Gas Logistics, Marketing (Dave Neubauer), GMS (Gary Anderson, Ellis Stern) to discuss the end user agreements and the procedures that GMS uses when determining actual flow at the end user points.\nFrank wants all parties within ETS to be aware of some to the issue involved in this process.\nLynn & Raetta,  could you schedule some time to discuss.\nI would like to bring you up to speed on the previous conversations and calls that I have had with Marketing, MidAmerican and GMS on this subject.\nI will be out of the office on Wed and Fri. this week if that helps.\nI'm pretty flexible other than that.\nGive me a call if you have any questions       \t\t\t\t\t\t\tj.  floyd\n",
 'Attention UBS Warburg Energy Users:  Please be aware that IT will begin migrations to UBSW Energy this evening.\nPlease log off of your machines tonight.\nWhen you arrive in the morning, you will login with your Enron ID and password.\nYou will be required to change your password immediately.\nYou will also have an email in your Inbox tomorrow morning explaining your "next steps".\nIf you have any questions, please call 3-1411.\nThanks,\n',
 'We are in the process of confirming that all traders are set up correctly and ready to trade when the system goes live.\nWe need to make sure that your Stack Managers are accessing the correct database.\nIn order to do this, we need to know how you access Stack Manager:  1) Through Terminal Server (the one that opens up a desktop within a desktop and it actually appears that you have two Start buttons).\nor 2) By opening the Stack Manager directly from your "native" desktop.\nPlease reply to this message with either a corresponding "1" or a "2" in the subject field.\nIf you\'re not sure which one you have, please contact myself x39673, Teresa Mandola x39807 or Jennifer McQuade x53614 and we\'ll come by your desk to help you.\nThank you,\n',
 'A new version of CQG has been deployed to all current CQG users.\nWhen you log out and log back in you may not initially see your saved layouts.\nIf this occurs, please follow the below instructions to retrieve your layouts.\nIf you need assistance please contact the resolution center at x31411 and your floor support technician will be able to assist.\nThank You.\n',
 "As you may be aware, Enron Corp. is a member of the Official Unsecured Creditors' Committee appointed in the Pacific Gas and Electric Company bankruptcy case.\nMichael Tribolet with the Risk Assessment and Control Group is Enron's designated representative on the committee and he is being assisted by Lisa Mellencamp in the Enron North America Corp. legal group.\nPlease be advised that they will be restricted from disclosing certain of the information that they receive.\nAttached are Ethical Wall Procedures regarding confidential information that Enron may receive as a member of the committee.\nIt is important that you read the procedures promptly, print the Employee Certification attached and sign and return the Employee Certification to the Compliance Department as directed.\n",
 'The following file contains a graphical view of the North American Gas average deal count by Trader and Product for EOL.\nThis information is for comparative analysis only.\nDo not update links when opening this file.\nIf you have any questions regarding this breakout, please let me know .\nAdam Johnson EnronOnline x54877\n',
 'All:  Attached you will find a list that reflects your seat assignments for Business Continuity Planning (BCP).\nThese seats are located on the 30th and 31st Floors of Enron Center North (ECN).\nAs previously communicated, you will report to these designated seats in the event of an outage in ECS.\nThe exception to this is as follows: If your seat assignment is located on the 31st Floor, you will report to your original location that you occupied prior to your move into ECS.\nThis will hold true until the Monday after Thanksgiving, as we will have the 31st floor seats set up at that time.\nTesting: Once you have moved to ECS, if you would like to test your BCP location, you will be able to test your seat for functionality every Thursday from 3-6pm.\nTesting is not required, but is highly recommended.\nIf anyone has any questions or concerns about these procedures, please feel free to contact me at any time.\nRegards,\n',
 "It's good to hear from you even though you wrote to the wrong nephew.\nHow's everything going in the big H.  School is going pretty well, my classes are going pretty well except one that really sucks bad.\nTell everyone I said Hello.\nI look forward to seeing everyone at Thanksgiving, I'll relay the message to Brad.\nBrandon\n",
 "Below is the Enron 2002 holiday schedule.\nRemember, Enron's offices will be closed in observance of Martin Luther King Day this coming Monday, January 21.\nEnjoy the long weekend!\nNew Year's Day\t \tTuesday, January 1  Martin Luther King Day \tMonday, January 21 President's Day\t\t\tMonday, February 18 Memorial Day\t\t\tMonday, May 27 Independence Day \t\tThursday, July 4 Labor Day \t\t\tMonday, September 2 Thanksgiving Day\t\tThursday, November 28 Thanksgiving Observance \tFriday, November 29\n",
 "Ken Lay is very interested in providing opportunities for the Enron Corp. Board of Directors to become well-acquainted with Enron's management team.\nYou are invited to join Enron's Board on Monday evening, October 8, at the Four Seasons, Austin Room.\nPlease come for cocktails at 6:45 p.m., followed by the Executive Session of the Board at 7:00 p.m.\nThe group invited includes Management Committee members who either head up corporate functions or are the CEOs of business units.\nAn agenda will be provided for you Monday evening but, for your information, the Board's working dinner will include a financial update by Rick Causey, an investor relations update by Mark Koenig, other business, and reports on the day's earlier Committee meetings.\nYour participation is important.\nPlease RSVP to Kelly Johnson at extension 36485 or via email to kelly.johnson@enron.com by Thursday, October 4th at Noon.\nIn addition, the entire Management Committee has previously been invited to join the Board for its open session the following day, Tuesday, October 9, beginning at approximately 9 a.m. in the Boardroom and for a seated lunch in 50M following the session.\nIf you have not responded to Kelly yet, we look forward to hearing from you.\nThanks.\nPaula\n",
 'Ryan,  In the follow up to the meeting we had on Wednesday I would like to reinforce one point I made.\nI feel strongly that I cannot support the valuations my group has produced so far for the LJM/Raptor related transactions without examination of all the related legal documents.\nI feel that we did solid work based on verbal information,  but I cannot guarantee the quality of the final product without looking at the contracts.\nThese transactions are too complex and controversial to bypass due diligence requirements  that you would expect from any professional.\nVince Kaminski\n',
 "This is a reminder of Enron's Email retention policy.\nThe Email retention policy provides as follows:  Message Location - Maximum Retention Inbox - 30 days Sent Mail Folder - 30 days Trash/Deleted Items - Rollover from Inbox for one day Folders - All Email messages placed in folders will be destroyed after one calendar year.\nThis includes public folders in Outlook.\nFurthermore, it is against policy to store Email outside of your Outlook Mailbox and/or your Public Folders.\nPlease do not copy Email onto floppy disks, zip disks, CDs or the network.\nSuch actions are prohibited and will not be supported by the IT Department.\nThere will be no exceptions to this policy.\n",
 "Management Committee Members:  In light of today's meeting being canceled, we would like for you to give consideration to Jeff Huff as a candidate for Commercial Support VP.\nJeff has interviewed with Mark Frevert, Ray Bowen and Steve Kean who have given favorable feedback.\nAt this time, we would like to proceed with an offer.\nPlease contact us with any concerns or questions by the close of business Thursday.\nIf we have no opposing votes, we will proceed.\nBelow are a few points and a resume for your review:  Resume: Currently the second most productive Partner at Diamond-Cluster, a technology consulting firm.\nHe has been working at Enron for the last 2+ years, first for Tom Gros in EBS and Net Works and then for Dan Reck in Freight, developing trading systems.\nThe Job: We are looking to bring Jeff in as VP, Commercial Support.\nThe demands of growing the group require a consistent focus on technology, expenses, front and back office productivity, as well as constant re-analysis of growth strategies.\nJustification: Jeff's capabilities in these areas make him extremely qualified.\nWe rely on him heavily already, but at consulting rates he costs us more than $1.3mm per year and his focus is limited to technology.\nMost importantly, the lead commercial folks in the group are overburdened with administrative issues and spending too little time bringing in earnings.\nThank you.\n",
 "As you know, the Enron Management Conference will be held Wednesday through Friday, November 14-16, 2001, at the Westin La Cantera Resort in San Antonio, Texas.\nThis has been an eventful and challenging year for Enron.\nNow,  more than ever,  it is fitting to bring Enron's leaders together.\nAfter all, it is up to our management team to lead our company through these challenging times.\nTogether, we will define Enron's character and determine Enron's destiny.\nWe have a great program planned for this year's conference.\nI'm delighted that General Norman Schwarzkopf will join us as a keynote speaker on leadership.\nI'm equally pleased to welcome back Gary Hamel, who will help us process the past year and prepare for future success.\nAs I've said before, we are a company that continues to look to the future, and there are many exciting things in store for us.\nI look forward to seeing you at this very important meeting.\nRegards,\n",
 'It is that time again for the mandatory Annual Compliance Meeting.\nThis year it is scheduled for Thursday, October 25, 2001 at the Doubletree Hotel, LaSalle Room B, 8:30 am to 10:30 am.\nThe agenda for the meeting is as follows:  Robert George/Gil Melman\tBoard Seats Richard Lauer\t\t\tECT Securities LP  Cassandra Schultz\t\tRisk Management Policy Bob Bruce\t\t\tChinese Wall Policy Dave Gorte\t\t\tTransaction Approval Process Rick Carson\t\t\tRAC Reporting Tools  As always, attendance is required.\nWe will be starting promptly at 8:30 a.m. and a continental breakfast will be served.\nPlease RSVP your attendance to Donna Wackerle at ext.\n39755 or respond to this email.\nIf you have any questions, please call me at ext.\n31939.\nPlease forward this message to your assistant to ensure it is scheduled on your calendar.\nIf you are aware of anybody else that should attend, please let me know and we will gladly add them to the list.\nWe look forward to seeing you this year!!\nDonna Lowry\n',
 "I'm attaching the final copy of my resume, already critiqued by my advisor and ready to be sent to companies.\nSee what you think when you get a second.\nI added a few projects and computer skills and changed a few classes.\nHope you're having a good day at work.\nCheers loser,\n",
 'Rick:  In addition to our normal activities related to board reporting, PortRAC maintenance, compliance and SWAT work, we have the following major project initiatives underway:  DASH SPENDING CONTROLS - We are leading the team to develop an "AFE-type" cost accumulation system so that every project in Enron will have accurate and timely cost expenditure numbers to ensure that appropriate DASH\'s and approval levels have been obtained.\nBANKRUPTCY REPORTING DATA - We have taken responsibility for developing the reporting function for the new bankruptcy group.\nWe are working with Michael T. and Credit to develop what data we need, where in the organization we get it and what kind of reports we generate with it.\nPOST TRANSACTION REVIEWS -  We will provide the primary resources to perform these Board mandated reviews.\nPaper mills, Garden State and Daishowa will be reviewed this quarter in conjuction with Underwriting.\nEES - We are working with Credit to monitor the EES project list as well as assisting them in some counterparty and credit scoring work related to EES\'s mass marketing effort.\nPortRAC ENHANCEMENTS - We have completed the executive demos with very positive comments about the functionality of the system.\nSome of them (including Louise Kitchen) commented that they missed their hard copy snapshots so we are enhancing PortRAC to make it easier to print an entire snapshot book for a business unit with the "push of a button".\nIf you have any other "big" projects that you want us to tackle, please let me know.\nThanks,     Rick C.\n',
 "As many of you remember, one of our RAC employees was flooded out of their house in June.\nThis flood severely damaged their house and ruined virtually all of their belongings inside the house.\nMany of you generously donated cash, clothing, and toiletries which were immediately forwarded to the family.\nYour generosity and responsiveness in their time of need was greatly appreciated.\nThey have been working hard to rebuild their house since June and are finally close to moving back home.\nWe are seeking your help again in donating ANY home furnishings you can.\nOur goal is to collect as many items as we can.\nIf this family cannot use an item, maybe one of their neighbors can.\nHere are some of the items we have collected so far:  washer & dryer\t\t\tRichard Lauer breakfast room table & chairs \tStephanie McGinnis console TV\t\t\tCassandra Alston CD & tape player\t\tAdam Watts couch & tv stand\t\t\tRick Bittner kitchen housewares galore!\nKaren Barbour Nintendo 64\t\t\tChristine and Stephanie Barbour (Karen's kids) VCR, pictures for walls\t\tStephanie McGinnis boy's bicycle and rollerblades\tLynn Bellinghausen  We will be renting a moving truck on Saturday, November 2nd to pick up donations and deliver them to this RAC family.\nIf you can bring your donations to the office, please call me and I will hold in my garage until our November 2nd delivery date.\nIf you would like for me to pick up your donations at your house, please let me know what your donation will be and your home address so I can map my route and give you an estimated pickup time.\nThank you kindness and I look forward to hearing from you.\nStephanie 3-9283\n",
 "This is a reminder that the ect.enron.com,ei.enron.com,and ees.enron.com Email domains will be decommissioned by close of business Friday, January 18th.\nIf you currently use an Email address of name@ect.enron.com, name@ei.enron.com or name@ees.enron.com, you will need to notify your contacts to send mail to you at firstname.lastname@enron.com.\nThis is the first step of several to standardize everyone's Email address to firstname.lastname@enron.com.\nIf you have questions regarding this email, send an Email to enron.messaging.administration@enron.com.\nThank you for participation, cooperation and support.\nEnron Messaging Administration\n",
 'For the time being, Ken wants to leave the Management Committee extended meeting on the schedule for this Friday, January 11.\nBut, he wanted me to check your schedule for next Thursday, January 17 - probably from 8:00 to 1:00 - to see if that would work.\nWe are losing some people for the 11th.\nI appreciate your assistance.\nRosie\n',
 'Happy new year to all!\nAttached is the money market list as of yesterday 01/07/02.\nPlease feel free to call us with any questions.\nThanks, Julie\n',
 "Yesterday, Enron settled a procedural dispute with Dynegy over Northern Natural Gas.\nOur settlement allows Dynegy to exercise its option to acquire the pipeline, dismisses their Texas lawsuit and extends Enron's right to repurchase until June 30.\nWe reached this settlement as part of our efforts to bring Enron out of bankruptcy.\nWhile we would like to keep Northern Natural, we still have some 9,000 miles of safe, profitable interstate pipelines as a base to rebuild our core businesses.\nThe settlement provides the best opportunity to resolve the pipeline issue quickly and pursue our $10 billion damage claim against Dynegy.\nIt also allows us to avoid the very substantial costs and distractions from protracted litigation in state courts.\nWe want to see a positive future for the employees working with Northern Natural Gas.\nBelow is a copy of a message from Stan Horton further explaining this decision to the employees of Enron Transportation Services.\nKen    Dear ETS Colleague:  On Thursday, Enron entered into a settlement over Dynegy's exercise of its option to acquire the Northern Natural Gas pipeline.\nThe settlement allows Dynegy to exercise the option and assume interim control of the pipeline while Enron pursues its damage claim against Dynegy.\nIn this respect, Enron Corp. has carefully weighed the substantial costs and turmoil that litigating this possession issue would create for the company and the employees of Northern Natural Gas.\nConsequently, Enron Corp. has decided not to contest interim possession and allow the transfer of Northern Natural Gas to Dynegy, while the larger issues affecting its future are resolved.\nThe company has concluded that with this settlement, Enron should be able to resolve the issue more quickly, as well as avoid the legal cost burden and distractions to the business from protracted litigation in state court.\nFor the Northern Natural Gas employees, I believe this decision should allow them to steer clear of the dispute and focus on the day-to-day satisfaction of running a valuable, successful business.\nBeginning immediately we will be working to achieve a smooth transition and to align the appropriate resources to assure continued safe, reliable and efficient operation of Northern Natural Gas.\nOver many years we have run high quality, cost conscious and profitable businesses in ETS.\nKeep up the good work!\nStan\n",
 'David Grant has assembled a team to work on gathering documents in response to the numerous subpoenas the company is receiving from Congress, the SEC and the Department of Justice.\nPlease cooperate with the team if they need your assistance.\nIf you have any questions, please call David Grant at 3-6239.\n',
 "This is a reminder that the ect.enron.com,ei.enron.com,and ees.enron.com Email domains will be decommissioned by close of business Friday, January 18th.\nIf you currently use an Email address of name@ect.enron.com, name@ei.enron.com or name@ees.enron.com, you will need to notify your contacts to send mail to you at firstname.lastname@enron.com.\nThis is the first step of several to standardize everyone's Email address to firstname.lastname@enron.com.\nIf you have questions regarding this email, send an Email to enron.messaging.administration@enron.com.\nThank you for participation, cooperation and support.\nEnron Messaging Administration\n",
 "Today, the Euros are coming and John is going to be running this negotiation - here's the bad news they are not coming until 3:30pm today so we may have to work late.\nBarry Tycholiz will be running this team.\nBarry - talk to Andy on form if you need help - you will also need to think about getting some traders available over week-end.\nThe Schedule outline is based on initial overview discussions/presentations  and then more detailed discussion can occur in individual groups the outline is as follows:  It may be better to split up earlier but I leave all those decisions to Andy.\n4:00\t\tIntroduction\t\t\tJohn Lavorato & Louise Kitchen 4:45\t\tFinancial Overview\t\tWes Colwell 5:15\t\tRisk Overview\t\t\tBuy / Port 5:45\t\tCredit\t\t\t\tBradford 6:15\t\tBack Office\t\t\tBeck/Hall\t 6:45\t\tSystems (EnronOnline)\t\tJay Webb\t 7:15\t            Mid/Back Office Systems\tJay Webb \t\t\tInfrastructure\t\t\tJenny Rub  \t\t Please make yourselves available - the meetings will take place in 2991  Tammie - please organize lunch and refreshments etc on John's card.\nTammie - please check availability.\nThanks for your continued understanding.\n",
 'Market Data has recently made changes to the Reuters Kobra permissioning database.\nIf you no longer have access to information that you previously utilized on your Kobra application, please contact Julie Pechersky at 713 853-9225 and the data will be restored immediately.\nWe appreciate your assistance.\nMarket Data\n',
 "To confirm:  Mark Thomas Mike Presley  both previously on the list for Netco's Market Risk/Research Group have resigned.\nI'm combing the Estate for replacements.\nDP\n",
 "As you know, the FBI is currently conducting an investigation in the building.\nIf you are contacted by the FBI, we'd advise that you contact us before speaking to them.\nI can be reached at 713-345-2569 in Houston or 202-424-7732 in Washington.\n",
 'Dear Richard,  Thanks for speaking with me the other day regarding KWI.\nI am writing to update you on the progress of this search.\nOur client is in the final stages of negotiations with an excellent candidate.\nThanks a lot for\n',
 "Dad, this was sent to me by my friend who is working for PriceWaterhouseCoopers.\nGood for a laugh.\nI've got my reception for making dean's list later this afternoon.\nGotta get my suit out!\nWill probably run later too, as I was too tired yesterday when I got out of class.\nLove ya!\nCheers big ears,\n",
 'Rick, I have 6.5 days of vacation left I have planned to take dec 17 - dec 19 (Mon-Wed).\nI will be back in the office Thurs 12/20 and plan to be available through the holidays and after that as long as needed.\nPat Cini has agreed to be in the office on those days and I will be available via mobile.\nThanks\n',
 "Rick/Jim  1)  It has come to my attention that the relocation of employees to home countries is in jeopardy.\nThird hand, I understand that Prudential has refused to continue to pack, move and pay air fare to people seeking to move due to concern about clawback of payments made by the bankruptcy court.\nMany of those literally have no money.\nIs there any way to get the facts out to everyone and to address these issues?\nThese are questions of legitimate expenses addressing basic human needs like food, clothing and shelter.\n2) I would suggest that we grab(pay)  in-house counsel here that understands the business (Paul Simons?)\nin lieu of paying Weil for what I percieve as little or no value added.\n3) As stated in yesterday's meeting, we will need to rely on EEL employees to do things like maintain books, provide settlements/invoices, accounting and banking among others.\nThey either work for the administrator or have been let go by the administrator.\nSome provision to pay them needs to happen quickly.\n4) FYI - I spoke with David Messer, the head of Sempra Energy Trading, yesterday.\nDavid had been with Drexel during its bankruptcy.\nHe said that all retained employees received an immediate 100% increase in pay (on the day of the filing) and did not intimate that such things as economy class airfares to repatriate employees needed to be reviewed by Congress.\nI realize that everyone is in some level of chaos, but based on what I read in the press, there are lots of decisions being made where the priorities - legally, morally, and ethically - appear to be in an improper order.\nAnything either of you can do to re-order such things would be appreciated.\nTed\n",
 'Points Raised by Group IT and Back-office systems cannot be easily divided between NewCo and OldCo.\nNewCo may have to contract for services from OldCo Need to recreate DPR post petition - must understand current position subsequent to terminations Retention program needs to be addressed as soon as possible Communication plan needs to be developed for OldCo employees describing current and projected benefits and any potential retention plans Financial vehicles - detailed operating procedures need to be presented to business unit leaders so that they can effectively deal with those assets in the vehicles Legal - must determine what we can and cannot do - as limited by the DIP financing and bankruptcy proceedings Must review global list of entities to ensure proper legal and operational shutdown of those entities Identify tax and finance on team matrix Define internal process for approval for disposition of positions, assets and businesses Ensure that everyone understands the  Clarify who is working on ECTRIC and how they will be compensated How can we contract/hire employees who we have been laid off but are now needed for the workout.\nCan we set up a way to have an abbreviated redeployment  Administrative items - consolidation of work space and utilization of cell phones, pda, etc.\nAction Items Business unit plans by next Friday Business unit leader meetings every Tuesday and Thursday @ 9:00 am Address and clear above items - JF   Any questions, give me a call.\nRegards,\n',
 'The DPR for 11/30/01 is now complete and has been published to the ERV.\nFor the last few days, the production of the DPR has been put on hold due to the increased activity around terminations.\nPositions and VAR for the DPR will start to be produced for trading day 12/10/01 and we are planning to produce a full DPR (inclusive of P&L) on a weekly basis.\nPlease call if you have any questions.\nBest regards\n',
 'All,  We had a preliminary meeting on Friday.\nThe attached is a summary of the matrix we developed as well as changes from subsequent e-mails.\nNote, only one name has been placed in the matrix where two may have been suggested - if the name is not correct then please e-mail me back as soon as possible - only person per box please.\nThe names placed in the matrix will be directly responsible to the estate.\nWe need to meet Monday to: (1) agree on the matrix; (2) develop detailed processes for capturing value (trade books, structured deals, hard assets and business sales); (3) understand the approval process required on a go forward basis; (4) develop compensation / retention program for estate, (5) address any administrative concerns.\nIf you have not done so, please check the names in the matrix to ensure that they are correct and please send me any changes as well as their full names to be utilized for future e-mails.\nRegards,\n',
 'Dear Rick,   Thanks for speaking with me today.\nHere is the position description for the KWI President of the Americas Opportunity.\nI feel that this is a tremendous opportunity to be an integral player with a very exciting relatively early stage Applications Software  company, in the very exciting and hot Energy Commodities Sector;  They are already profitable, pre-IPO.\nThis position has a great compensation package.\nPlease get back to me if you have an interest or if you know someone who might be intrigued by this opportunity.\nThanks,\n',
 "As a reminder, the mandatory Annual Compliance Meeting was rescheduled to Thursday, November 8, 2001 from 8:30 - 10:00 am at the Doubletree Hotel, LaSalle Room B.\nThe agenda remains the same:  Robert George/Gil Melman\tBoard Seats Richard Lauer\t\t\tECT Securities LP  David Port\t\t\tRisk Management Policy Bob Bruce\t\t\tChinese Wall Policy Dave Gorte\t\t\tTransaction Approval Process Rick Carson\t\t\tRAC Reporting Tools  Please confirm your attendance at this year's meeting either by responding to this email message or contacting Donna Wackerle at ext.\n39755.\nThank you in advance for your cooperation.\nIf you have any questions, please contact me directly at ext.\n31939.\nI look forward to seeing you this year.\nPLEASE FORWARD THIS MESSAGE TO YOUR ADMINISTRATIVE ASSISTANT TO ENSURE IT IS SCHEDULED ON YOUR CALENDAR.\n",
 "In preparation for Friday's Bank Conference, Cheryl Lipshutz and I are sitting with the banks right now and we understand that you are meeting with them at 2pm this afternoon.\nHere is a list of the initial questions they are posing to the RAC group:  RAC 1.\nDoes VAR analyses take care of the quality and predictability in regard to price risk management?\n(JP) 2.\nIs the risk control and deal approval process going to change?\n(B) 3.\nWhat percent of wholesale power and gas trading business does the top twenty counterparties represent?\n(B) 4.\nHas Enron been asked to raise the amount of collateral posted by any counterparties?\nWhat is the aggregate amount?\n(B) 5.\nHow is the credit downgrades expected to affect Enron's margin requirements?\nHow much extra cash will be needed in the immediate term to cover these requirements?\nWhat would the source be for this cash?\n(B) 6.\nWhat is the sensitivity analysis of the trading portfolios from a liquidity and margining requirement standpoint based upon i) two standard deviations in the relevant underlying commodity price both upward and downward, ii) a one notch credit downgrade by S&P, in addition to the action already taken by Moody's and Fitch, and iii) a combination of the two scenarios?\n(BNP)  What is the availability of sufficient liquidity to accommodate such scenarios?\n(BNP) 7.\nProvide daily average, high and low VAR for 2000 and first quarter 2001 versus month-end values as provided in filings.\n(S) 8.\nHow are VAR limits established?\n(S) 9.\nWhat are the various VAR limits and how often have they been exceeded in the last year?\nHow and when would VAR limits be adjusted?\n(S) 10.\nWhat assumptions underlie VAR calculations?\nDoes VAR include operational risk?\n(S) 11.\nGiven Enron's VAR policy, will VAR grow as trading volumes increase?\n(S) 12.\nWhy is Enron's VAR higher than other traders, including merchant banks?\n(S) 13.\nWhat risk information is distributed?\nHow timely is the information?\n(S) 14.\nWhat financial measures does the company consider important in tracking the success of its trading business?\n(S) 15.\nHow is the VAR model validated?\nIs the model backtested?\nIf so, is it a theoretical backtest where positions are held fixed or an actual backtest where actual P&L is compared to the estimated VAR?\nHow many times last year did the back tested value exceed the VAR?\n(S) 16.\nWhat is the model vetting process?\nWho is responsible for validating traders' models?\nWhat is the time lag between front office development of a model and validation?\nAre there any products that use unvalidated models for trading purposes or P&L?\n(S) 17.\nHow does the company ensure that traders use appropriate marks when marking to market?\n(S) 18.\tWho monitors limits?\n(S) 19.\nHow frequently is the trading operation audited by internal and external auditors?\n(S) 20.\nIs there a formal stress test that estimates the impact of a credit downgrade?\nWhat is the qualitative assessment of such an event?\n(S) 21.\nWhat is the current and year end expected counterparty exposure?\nGross or net of collateral?\n(S) 22.\nWhat is the investment/non-investment grade counterparty exposure split for 2000 and first quarter 2001?\n(S) 23.\nWhat percentage of investment grade counterparty credit risk is BBB+ or below?\n(S) 24.\nHow often does Enron review the credit rating of counterparties?\n(S) 25.\nWhat is the breakdown of liabilities from price risk management activities?\n(H) 26.\nWhich companies are Enron's largest trading partners (share in trading turnover)?\n(H)  27.\nWhat is the total dollar amount Enron would have to post if i) downgraded to BBB- by S&P/Moody's, or ii) downgraded to non-investment grade by S&P/Moody's if called on all trading collateral accounts?\n(B) 28.\nDoes Enron guarantee the obligations of the trading subsidiaries?\n(S&P)\n",
 "As requested the enclosed spreadsheet analyses the trading v origination for Enron Europe for 2000 and 2001, quarter by quarter by commodity.\nThe numbers up until 30/9/01 agree to those submitted by financial control in SAP and from 30/11 to 2/11 the numbers are per the DPR.\nThe origination analysis is for trades greater than $5m except in the structures books where a threshold of $10m has been taken.\nThose items under the 'significant non-recurring items' line can also be thought of as origination and have been separated on the basis that they are typically monetisations or related to the sale of Sutton Bridge.\nThe bulk financial books are theta, rho and drift as well the cost of capital book and  FX differences on the revaluation of the non $ currency P&L.\nAny questions please let me know.\nJames\n",
 "Hey Dad.\nI know you're tied up in meetings, and I know you are probably very bored and anxious.\nBut I just wanted to let you know that at times like this I realize how AWESOME you are.\nI'm sure you have tons of stuff on your mind, as today has definitely not been one of the better ones for our family.\nBut that which does not kill us makes us stronger, and God knows we will be stronger after this.\nThis will all be over soon and we will be able to look back and laugh (as I will also by then have figured out how to get my computer to stop running in safe mode and actually be able to read the e-mails I am typing.)\nA pretty smart guy once told me that when things like this happen, they always seem huge at the time.\nBut in the timeline of your life [        timeline        ] this whole experience will encompass like one/one thousandth of the period at the end of this sentence.\nI miss you and wish I could be there for this whole ordeal.\nBut please try to keep your chin up !\nand your good spirit, because I'm  pretty sure that's all that matters in the end.\nI love you loads and wish you the best of everything.\nCheers big ears,\n",
 'Please let me know this morning if you have any documents that have been request by Legal to be provided to Wilmer, Cutler & Pickering.\nYour assistance is greatly appreciated.\nWe would like to wrap up the RAC efforts today.\n',
 'Due to current conditions the Risk Officers Roundtable meeting that was scheduled to be held in Las Vegas on November 12 & 13, 2001 is being postponed until January 17 & 18, 2002 and will be held in Houston, Texas.\nWe will keep you informed of new developments as they become available.\nSorry for the delay in getting this information to you but please do not hesitate to call me at (713) 237-2570 if you require additional information.\n*******************Internet Email Confidentiality Footer*******************   Privileged/Confidential Information may be contained in this message.\nIf you are not the addressee indicated in this message (or responsible for delivery of the message to such person), you may not copy or deliver this message to anyone.\nIn such case, you should destroy this message and kindly notify the sender by reply email.\nPlease advise immediately if you or your employer do not consent to Internet email for messages of this kind.\nOpinions, conclusions and other information in this message that do not relate to the official business of my firm shall be understood as neither given nor endorsed by it.\n',
 'Rick:  As a follow up to our discussion on headcount reduction, as you know, there are several important fiduciary functions that the Portfolio group performs related to the existing asset portfolio that should be performed until the assets are sold:  Review and audit of contractually required fundings for capital and operating expenditures (we usually recover $$$)) Maintenance of compliance system to ensure compliance with reporting requirements and transaction covenants Maintenance of the PortRAC system that is used for asset management, data rooms and Board reporting Post transaction reviews as directed by Management and the Board  In addition to our obligation to management and shareholders, JEDI II and CalPERS look to RAC to make sure that the Commercial Teams are maximizing value.\nIn my opinion, some staff should be maintained to perform these functions or value and the ability to sell these assets will be compromised.\nI am available to discuss at your convenience.\n',
 "As many of you know, I have a provision in my employment contract which provides for a payment of $20 million per year for the remaining term of my contract in the event of a change of control of Enron.\nThe merger with Dynegy, or a similar transaction with any other company, would trigger this provision on closing.\nAssuming the merger with Dynegy is closed within 6-9 months, as we expect, this provision would entitle me to total payments of slightly more than $60 million.\nMany CEOs have change of control provisions in their employment contracts and mine has been in place since 1989.\nBut given the current circumstances facing the company and our employees, I have been giving a lot of thought these last few days to what to do about this payment.\nInitially, I thought I would use part of the funds for a foundation for our employees and take the remainder in stock and cash.\nHowever, after talking to a number of employees this afternoon, I have decided that the best course of action would be for me to waive my right to any of this payment.\nTherefore, at closing, I will receive no payments under this provision.\nI know this action does not remedy the uncertainty that you and your families face.\nBut please know that I will continue to do everything in my power to serve the best interests of Enron's employees and shareholders.\nI am still very proud of what we have built at Enron, and I want to continue working with all of you to correct the problems and restore Enron to its rightful place in the energy industry.\nThank you.\n",
 'I have an agenda item for "Update on Financings, Liquidity and Credit Ratings".\nPlease advise if for any reason that is not appropriate, otherwise, it will stick.\nMaterials need to be received Friday; otherwise the update will have to be verbal.\nPls.\nadvise on your plans.\nTHX Paula  CONFIDENTIALITY NOTICE  The information contained in this email may be confidential and/or privileged.\nThis email is intended to be reviewed by the individual or organization named above.\nIf you are not the indented recipient, you are hereby notified that any review, dissemination or copying of this email or its attachments, if any, or the information contained herein is prohibited.\nIf you receive this email in error, please immediately notify the sender by return email and delete this email from your system.\nThank you.\n',
 'Please find an aging from this Spring and a recent AR aging.\nLeff is concentrating on the 31days+ ($101 million).\nI do not have the reserve info, although I have asked twice.\nHopefully will get it this coming week.\nTotal  \t  Current  \t  1-30  \t  31-60  \t  61-90  \t  >90  \t \t\t\t\t\t\t\t at 4/16/01\t$339,900,216 \t$143,040,889 \t$107,231,644 \t$44,241,224 \t$16,503,641 \t$28,883,112 \t \t100.00%\t42.10%\t31.50%\t13.00%\t4.90%\t8.50%\t \t\t\t\t\t\t\t at 11/9/01\t  344,114,803 \t  127,687,562 \t  114,870,224 \t    26,107,507 \t    13,485,688 \t    61,963,823 \t \t100.00%\t37.11%\t33.38%\t7.59%\t3.92%\t18.01%\n',
 'The LIBOR and Treasury interest rate curves and the default probs for industrials and utilities have been updated as of 11/16/2001.\nThe file is saved in the following folder:\tO:\\Credit\\$Models\\Default Models  Please call me if you have any questions.\nCindy     Cindy Hudler Enron Corporation Risk Assessment & Control - Underwriting\n',
 "Richard B.\nBuy EVP & Chief Risk Officer Enron Corporation 1400 Smith Street - 50th Floor Houston, Texas 77002-7361  RE:  Reception & Dinner on      October 24, 2001 in Houston, Texas  Dear Mr. Buy:  As  one of our most valued clients, HVB America hopes that you will be able to join us on the evening of Wednesday, October 24, 2001 in Houston, Texas.\nStephen  Bub,  a  member  of  HVB's  Board  of Directors and the CEO of HVB America  and  Asia  will  host  the  event,  which includes a reception and dinner.\nOther  senior  officers  from our Munich and New York offices will attend as well.\nWithin the next 2-3 weeks, we shall provide you with additional details.\nIn the meantime, however, please make a note in your diary.\nSincerely yours,\n",
 "Please see attached clean.\nThe Compare Documents feature won't work (too big or something), but here are the substantive changes:  ?\nI reorganized the Executive Summary  ?\nAs for market risk limit violations and loss notifications, Sr. Mgmt changed so they're no longer going to Skilling for Commodity Group and Business Unit levels, although he still approves those limits.\n?\nClarified employee trading requirements ?\nWe heavily edited the Roles & Responsibilities section to avoid duplication (cut in half ) ?\nAlso, scrubbed the entire body so it should be in good shape now.\nToday, Thursday, we will refine the Glossary and clear any comments from Whalley, Buy, Glisan, etc.. - we should be wrapping up by the end of the day.\nAlso, AA and PWC should be signing off today.\nRegards,\n",
 "Effective immediately, responsibility for the operational, environmental, safety and social audits of Enron facilities is transferred from Enron Transportation Services (ETS) Quality Management to Corporate Public Affairs under Mike Terraso, Enron's vice president of Environment, Health and Safety, and Chief Environmental Officer.\nThe current directors of Facility Audits, Chuck Goode and Steve Allen, will report to Mike and will be responsible for leading the corporate asset operations audits.\nTechnical experts from business unit operations and engineering will continue to serve on the multidisciplinary audit teams.\nAudit responsibility for ETS assets will remain in ETS.\n",
 'Attached are the Enron Broadband notification memos for August 15, 2001.\nThe Office of the Chairman for Enron Broadband Services is responsible for printing out hard copies of these memos, signing and returning the hard copies to Chris Abel at 3560f, who will forward them to RAC to obtain their signature.\nThank You\n',
 "After close discussions with David Port and the RAC-Market Risk group, we have redesigned the Business Unit and Commodity DPR's to follow the new Risk Trading Policy.\nThis new policy took effect Wednesday, the 15th of August, and required a restructuring of the Business Unit structures and associated limits, along with creation of new Concentration limits on the Concentration DPR, formerly the Commodity DPR.\nFor any questions about the new format, please contact Shona Wilson, x39123, or myself, x33102, in the Global Risk Operations group, or David Port, x39823, in the RAC-Market Risk group.\nThank you,\n",
 'Good Afternoon,  This message is the introduce you to our CTO level candidate, Robert.\nRobert is looking for a permenent, full time employment in the U.S. Below is a brief profile of his achievements.\nPlease contact me for further information on his resume, salary requirement and contact information.\nProfile of Robert   Designed and coordinated construction of $1M dedicated computer facility   Designed and supervised buildout of $3M, 40K sq.\nft. office building Designed and developed mission critical intranet-based application combining ERP and CRM functionality to unify sales, invoicing, accounting, customer service and support.\nThis involved defining new business logic and reengineering business practices across departments.\nConducted and supervised emerging technology research, evaluation and implementation  Coordinated, researched and implemented all technology needs for five companies providing venture capital, real estate, internet software development, hosting technology magazine and internet news services.\nDesigned and implemented electronic access security, surveillance, and safety systems.\nDesigned and implemented communication systems incorporating voice, video and unified messaging platforms.\nWith Best Regards,\n',
 'Attached please find the daily log as of 08/20/01.\nPlease note that going forward there will be a change in the format and timing of log issuance.\nGoing forward the action plan and status will no longer be displayed and the log will only be issued once a week as part of the weekly summary distribution.\nThe daily exceptions will still be maintained, but not distributed.\nIf anyone wants information for a specific date, please feel free to contact me and I will forward the log as requested.\nIf you have any comments or concerns, please feel free to call me at ext 54751.\nThank you for time an attention.\nRegards,\n',
 'To confirm the Management Committee meeting for Monday morning, August 27, 2001 at 11:00 a.m. in the boardroom.\nPlease let me know if you will be able to attend and whether in person or by audio or video conference.\nThanks.\n',
 'As discussed during our recent demonstration of our new portfolio tracking system (PortRAC), we have completed a security system that will provide a "firewall" controlling access to each business unit\'s data.\nOur intent is to open up the system to designated members of each business unit or others as approved by the COO or Managing Director of that group.\nIn order to complete the initial setup, we need to receive a listing of approved users for your business unit and their login Id\'s.\nIf you prefer to delegate security approval authority to someone else on your staff, please let us know and we will establish procedures with them.\nIf additional demonstrations of PortRAC are necessary for your group, please let us know.\nThank you for your assistance.\nRick C.\n',
 'This is to confirm a meeting with Stan Horton in EB5020 on Monday, September 10, from 3:30 to 4:15PM.\nDuring the first part of the meeting, Peggy Fowler will call in (on 713/345-7437) to discuss "PGE Risk Management Strategy", and the second part of the meeting will be dedicated to discussing  the "EPA Data Request on EOTT".\nStan is indicating that this meeting should be completed in 45 minutes max.\nPlease confirm your attendance with me via reply e-mail.\nAnd don\'t hesitate to call me if you have any questions or concerns about this meeting.\n',
 'Just a reminder that the mid-year 2001 Consolidated Feedback will be purged from the PEP system on September 15.\nShould you have any questions or concerns, please contact my assistant, Shirley Cox at 51721.\nThank you.\nSheila Walton\n',
 'Attached is a draft of a Watch Report for Principal Investments as of 8/31/01 which reflects a complete format revision.\nThe previous narrative Watch Report had grown to 7 or 8 pages while this new format is a streamlined 2 pages.\nWe would be interested in your comments and suggestions for further improvements.\nThanks for your help!\nRick C.\n',
 "Please see attached file on the Falcon Prospect for use in this afternoon's board meeting at 2:00 pm.\nAn original will be delivered to you shortly.\nThank you.\n",
 'This meeting has been changed from Monday, October 1 to Monday, October 22.\nI will get back to you with the confirmed location.\nPlease contact me if you have any questions.\nThanks,\n',
 'As you are all aware, Enron and UBS have entered into an agreement for the sale of certain assets of the wholesale gas and power trading organization.\nAs part of that agreement, the management of UBS may speak to you over the next several days about an opportunity in that new organization.\nIf so, we encourage you to consider such an offer.\nHowever, if you are not employed by UBS, you remain an Enron employee.\nIf you have specific questions regarding your employment arrangements and job responsibilities please contact Anne Labbe in Human Resources at 5-7809, or feel free to contact either Jim Fallon or Dave Delainey directly.\n',
 "Enron Principal Investments (EPI), which was formed in the 2nd quarter, has completed its integration and the development of its new strategy.\nThis group will be responsible for identifying, closing, managing and exiting all non-E&P equity investments for Enron worldwide.\nKevin Garland will lead EPI, which includes Barbara Paige, Andrew Marsden, Kevin Kuykendall, Steven Sheldon, Michele Nezi Marvin and Mark Gandy.\nAdditionally, Dick Lydecker and the Special Asset Group will continue to report to Kevin.\nEPI will pursue investments related to Enron's core businesses, where Enron has a unique insight into the market, company or technology.\nInitially, this will be geographically focused in North America and Europe.\nThis group will rely heavily on the support and cooperation of the core business units to provide information and market insight.\nEPI may make investments in the form of venture capital, leverage buyouts, growth equity, or private equity in public companies.\nThe group will not make investments in seed stage companies, other funds, subsidiaries of larger corporations, or project equity.\nPlease join me in supporting the efforts of Enron Principal Investments.\n",
 'Rick,  It was good running into you last week.\nI am currently looking for new opportunities.\nIn the last 18 months, I have been working on eCommerce, specifically B2B exchanges and enterprise portals.\nI understand that Enron has several initiatives in this area.\nI was hoping you could give me some direction.\nAttached is my resume.\n<<BV Resume.doc>>   Hope all is well,\n',
 'CORRECTION, PLEASE READ  IMPORTANT  MESSAGE!\nPLEASE READ!\nFILENET SYSTEM OUTAGE  NOVEMBER 16, 2001     The FileNET System is scheduled to be down for monthly offline backups.\nAll users including IPayIt will not be able to access the System after 5:00pm on  Friday November 16th.\nThe FileNet system will not be available for use until Monday morning, November 19th due to additional database management.\nWe apologize for any inconvenience this outage may cause.\nIf you have any questions or concerns about this outage, please feel free to call the Help Desk @ 713-853-1555 Option #1   Envision/Encompass Support Team Document Mgmt and Process Automation 713/853-1555 Opt 1\n',
 "I know that this is a difficult time for all of us.\nWith everything going on inside the company as well as in the world around us, we have been carefully considering whether a holiday celebration is appropriate this year.\nTo be honest, employee feedback has been mixed.\nMany viewed the holiday party as a unique opportunity for us to come together as Enron employees to share the spirit of the season.\nOthers felt a holiday party would be improper given the company's current circumstances.\nAfter weighing these points of view, we have ultimately decided to cancel the all-Enron holiday party that was scheduled for December 8.\nGiven what has transpired over the past month, it could be considered imprudent for Enron to incur the expense of such an event.\nI regret that this action is necessary because I recognize that your hard work throughout the year merits a holiday celebration and so much more.\nWe will attempt to find other, more appropriate ways to recognize your outstanding contributions as we move into the holiday season.\nKen Lay\n",
 'A virus has been detected in the Enron email environment.\nThe offending email has the following characteristics :  The SUBJECT is "Hi"  It contains the following text : How are you ?\nWhen I saw this screen saver, I immediately thought about you  I am in a harry, I promise you will love it!\nIt contains an attachment called "gone.scr" (41 KB) Please DO NOT launch the attachment (as this will launch the virus).\nDelete ALL occurances of this email from your mail box immediately.\nPlease note that opening/previewing the email does not launch the virus.\nFurthermore, it is absolutely against company policy to open any external (non-Enron) mail account from within the Enron environment.\nThis means that you should not open a browser from an Enron PC and go to any sites that offer Email services.\nWhen you do this, you are tracked and IT is aware of your actions.\nIn today\'s case, the virus that was launched caused a the entire global Email system to be shut down for about an hour and a half.\nIt is also against company policy to launch any attachments without saving it to your desktop first so that desktop virus scanning can take place.\nIf you did launch this virus, please call your Resolution Center/Help Desk and have your computer scanned.\nThank you for your assistance.\n',
 "Larry:  I am working with Lou on the Gomez Title V issue.\nWe are preparing a submittal to the TNRCC to void the Title V permit (Permit No.\nO-00754) for the gas processing facilities.\nLou wanted to see if you knew whether the gas processing equipment operated after 1995.\nIf if didn't operate, did it have the potential to operate?\nWas the equipment flanged off, shut down, removed from the site, etc.?\nThanks,\n",
 'Dear Market Participant,  Technical Bulletin # 75  - Procedure to apply for CLR or ELR classification - is being distributed for Market Participant comment.\nThe Technical Bulletin will be posted to the NYISO web site following the comment period.\nPlease note that comments received will be forwarded to the Generation Issues Task Force (GITF) for review and discussion.\nThe identity of the person / company submitting the comment will not be disclosed.\nThe purpose of our Technical Bulletins is to facilitate participation in the NYISO by communicating various NYISO concepts, techniques, and processes to Market Participants before they can be formally documented in a NYISO manual.\nPlease forward comments on this Technical Bulletin, via email, by 5PM on Friday, September 14, 2001 to:  Peter Lemme NYISO Customer Technical Services plemme@nyiso.com  (See attached file: TB 75_A.pdf)  - TB 75_A.pdf\n',
 'LARRY & MATT       THE EMISSIONS FACILITY COMPLIANCE CERTIFICATION REPORT FOR STATION 5 IS DUE JAN. 23, 2002,  BUT THE WAY THE PERMIT READS WE DO HAVE 45 DAYS AFTER JAN. 25, 2002 TO GET IT IN.\nSO WE NEED TO  GET TOGETHER.\nHOW DUES THE 15 OF JAN. AT STATION 5 AROUND 11:00  LOOK FOR YOU GUYS.\nLET ME KNOW.\nTHANKS AND HAVE A HAPPY NEW YEAR   CA\n',
 '"Ruben S. Brown" <rsbrown@ecubedllc.com> writes to the NYISO_TECH_EXCHANGE Discussion List:  Subject: Try Ananova.com for much coverage of today\'s terrorist incidents.\nSorry to impose on this list server, but many of us are involved in today\'s events.\nThe following may be helpful and of interest to some of you.\nMy son Ruben E. Brown, a computer maven at Incert Technology that some of you know from NYISO meetings this Spring, has steered me to the Ananova.com website which has high powered servers covering the Terrorist situation with still relatively few hits.\nIt is constantly feeding AP coverage and is updated much faster than the conventional US sites.\nTimes are London times.\nRS\n',
 "As most of you know, American Airlines Flight 11 from Boston to Los Angeles was hijacked yesterday and then crashed into the north tower of the World Trade Center in New York.\nWe are very sorry to report that we believe an Enron employee was on board that flight.\nNick Humber, a director in Enron Wind's commercial origination group, was listed on the flight's manifest, and although his family has not received official confirmation that he boarded the flight, they have been unable to contact him.\nNick was based in Boston and was traveling to Los Angeles for a meeting.\nWe have talked with Nick's family and offered our full support.\nPlease continue to keep Nick's family and everyone affected by this horrific event in your thoughts and prayers.\n",
 "Due to the overwhelming response from Enron employees and contractors, today's blood drive appointments are completely full, and there are a large number of you who still wish to donate blood.\nWe are working diligently with the M. D. Anderson Blood Bank to schedule another day for blood donations, and you will be notified as soon as that date is secured.\nFor those of you who are interested in giving, please continue to either call the Enron Health Center, ext.\n3-6100, to get your name on the waiting list or go to the donation line in front of the building.\nWe recognize and are grateful to the many of you who are wanting to give blood today, but ask that you be patient and understand our inability to accept walk-in donations at this time.\nThanks again for the tremendous outpouring of concern.\n",
 "MRyanTaber@nyiso.com writes to the NYISO_TECH_EXCHANGE Discussion List:  Solicitation of Credentials from Candidates    for the position of Vice-Chairperson of the NYISO Operating Committee           for a one-year term from December 2001 ?\nNovember 2002       The Nominating Committee of the NYISO Operating Committee is seeking qualified individuals willing to serve as Vice-Chairperson of the Committee.\nThe scope of responsibilities of the Operating Committee can be found in Article 8 of the ISO Agreement.\nAs specified in the Agreement, the Chairperson and Vice-Chairperson will serve a one-year term, and the Vice-Chairperson will become the Chairperson following the completion of the Chairperson's term.\nThe Agreement further specifies that the individuals elected to these positions may not be active in the same sector, nor may they be representatives of members that occupy the Chairperson or Vice Chairperson positions of the Business Issues Committee or Management Committee.\nThese provisions, at this time, preclude representatives of the following companies, their affiliates and representatives in the following sector from consideration for Vice-Chairperson for the upcoming term: ?\nTransmission Owners ?\nNiagara Mohawk ?\nCon Ed Solutions ?\nNew York Power Authority       The Nominating Committee will review the credentials of the presenting candidates and may screen the pool.\nAlthough the Nominating Committee is required (pursuant to the OC By-Laws) to bring at least  one qualified candidate before the Operating Committee for election, the Committee encourages all qualified persons with an interest in this position to submit their credentials.\nThe Nominating Committee requests that interested individuals, who are not representatives of the members or sectors listed above, to present the following material by 5:00 pm, September 7, 2001.  ?\nA current resume ?\nBrief answers to the following questions: 1.\nPlease describe all experience you have had in chairing groups or committees of diverse interests, with a list of such groups.\n2.\nPlease describe the support of your organization for your assuming the position of Vice-Chairperson, and describe your ability to make the necessary time commitment.\n3.\nPlease describe any training or experience you have had in mediation, ADR or consensus building.\n4.\nPlease describe briefly why you would like to have this job.\n5.\nPlease describe briefly your organizations actual and/or potential business interests in the Northeast and New York State, including the sector in which your organization participates for purposes of NYISO governance.\n",
 'At the all-employee meeting two weeks ago, I talked about the major challenges that I believe Enron is currently facing and what we are doing to address these issues.\nI also reviewed with you our vision for Enron to become "The World\'s Leading Company," and what that means to me.\nYour management team and I remain committed to this goal and are confident that by working together, we can achieve this vision.\nAfter the all-employee meeting, a number of you came forward to voice your concerns about what you saw as additional challenges for Enron, and for that, I thank you.\nWe have already begun working on many of the concerns you expressed.\nNow, I would like to hear from more of you about what you see as the most critical issues facing Enron in the next twelve months.\nIn other words, "Lay It on the Line" for me by completing the attached survey.\nI assure you that your individual answers to this survey will remain confidential.\nThe new Management Committee will use this information to help us identify immediate action steps to address your key concerns.\nWe will communicate the results to you, both positive and negative, and what we plan to do about them, as soon as we can.\nThank you in advance for taking the time to help us move Enron toward its new vision of becoming "The World\'s Leading Company."\n',
 '"Robb, Kathy" <KRobb@hunton.com> writes to the NYISO_TECH_EXCHANGE Discussion List:     Here is a draft agenda for the October 5 meeting of the ICAP Working Group.\nPlease forward any additional items to me before 3 pm tomorrow.\nMany thanks.\n',
 "Many of you have requested more time in which to submit your nominations for the 2001 Chairman's Award.\nIn response to your requests, the deadline has been extended to Friday, October 12.\nPlease take this extended opportunity to nominate that special individual who is your everyday hero and a role model who exemplifies Enron's core values of Respect, Integrity, Communication and Excellence.\nThis award represents how important Enron's core values are to the company.\nThe success of this award program is determined by Enron's most valuable asset, you, the employee.\nEmployees at any level can nominate fellow employees from anywhere within the Enron family - from the top down or the bottom up.\nAll of those employees who have been nominated in the past are eligible to be nominated again this year and there is no limit to the number of nominations you may submit.\nSimply complete a nomination form and submit it by Friday, October 12, 2001.\nForms can be obtained by visiting your intranet site or at home.enron.com and in Houston they are available in the elevator lobbies.\nIn addition, this year we have a new way you can nominate that everyday Enron hero.\nSimply pick up the phone and dial 713-345-2492, follow the simple and quick instructions and leave your nomination by phone.\nThe finalists for the award, the Chairman's Roundtable, and the Chairman's Award winner will be honored at Enron's Management Conference in San Antonio on November 15.\nThank you for your participation.\n",
 "ADesell@nyiso.com writes to the NYISO_TECH_EXCHANGE Discussion List:   Due to problems with the NYISO's internal Local Area Network, the Winter 2001/2002 Pre-Capability Period ICAP Auction will be delayed by one day to Thursday, October 18, 2001.\nThe events and dates that follow the October 18, 2001 auction will remain unchanged.\nA revised time line is provided below.\nWinter 2001/2002 - Pre-Capability Period ICAP Auction Events                      Revised Time Line  |--------------------------------+--------------+-----------|\n",
 'This warning is sent automatically to inform you that your mailbox is approaching the maximum size limit.\nYour mailbox size is currently 78217 KB.\nMailbox size limits:  \tWhen your mailbox reaches 75000 KB you will receive this message.To check the size of your mailbox:     Right-click the mailbox (Outlook Today),    Select Properties and click the Folder Size button.\nThis method can be used on individual folders as well.\nTo make more space available, delete any items that are no longer needed such as Sent Items and Journal entries.\nYou must empty the Deleted Items folder after deleting items or the space will not be freed.\nTo turn Journaling off,   click Tools | Options | Journaling Options and de-select all items.\nSee client Help for more information.\n',
 'JCharlton@nyiso.com writes to the NYISO_TECH_EXCHANGE Discussion List:  All ICAP Suppliers submitting GADS Data and/or Equivalent GADS Data should clearly distinguish GADS Data  from Equivalent GADS Data submissions.\nPlease identify the data as GADS Data or Equivalent GADS Data and do not intermingle the two data forms in any data file.\nAttachment K of the NYISO ICAP Manual clearly defines the data requirements for each data type and Attachment J of the NYISO ICAP Manual explains how UCAP (Unforced Capacity) will be calculated using either type of Operating Data.\nCall Jim Pratico (x-6249) or John Charlton (x-6047) if there are any questions on this subject.\n',
 'TTotten@nyiso.com writes to the NYISO_TECH_EXCHANGE Discussion List:  The NYISO is reserving hour-beginning 5 in the 15 July 2001 real-time market to verify prices.\nPursuant to ECA-B the NYISO, there are no hours to reserve at the HQ, NE, OH or PJM external proxy buses.\nPrices in the 16 July 2001 Day-Ahead market are correct.\n',
 'CKing@nyiso.com writes to the NYISO_TECH_EXCHANGE Discussion List:  Joe, Don,  As Joe indicated in his TIE response, voltage limits and voltage-collapse limits are studied off-line using detailed AC power-flow techniques.\nThe resulting limits (in kV) are translated into a MW transfer limit  for the flowgates affected by the original voltage limit.\nTo the extent that these surrogate limits reflect the expected voltage performance of the system, then SCUC/BME and SCD will secure the system accordingly.\nThese rely on DC powerflow techniques, which by their nature are Blind to voltage problems.\nWhen this occurs, OOM is one tool that can be used to secure the system.\nWhen the realtime operation deviates from the conditions assumed in the analysis used to determine the voltage limits, the use of OOM and/or other measures may need to taken by the Operators to secure the system  I hope this clarifys the situation.\nChuck\n',
 'WINDAS 98 BROOKLYN Edition    Dear  Consumas:       It has come ta our attention dat a  coupola copies of the WINDOWS  98/BROOKLYN EDITION may have accidentally bin  shipped outsida Broooklyn.\nIf  ya got one a dese, you may need some help  understandin\' da commands.\nDa Brooklyn edition may  be recognized by da unique openin\' screen.\nIt reads: "WINDAS 98," wit a  background picture of Grand Army Plaza.\nWhen  you start da program,  instead of da usual "harpy, stringy" music, you hear da  teme from da  Godfadda.\nIt is also shipped wit a Sopranos screen sava.\nPlease also  note:  Recycle Bin is labeled "Staten Island."\n* My Computer is called  "My Friggin\' Computa."\nThe Inbox is referred to as "Da Trunk."\nDeleted  Items are referred to as "Wacked," "Erased," or "Rubbed Out."\nDial up  Networking is called "Da Bar."\nControl Panel is known as the "Da Bosses."\nPerformin\' an "illegal operation" is known as "enhancin\' the family   business"  and will actually maximize da program instead of shuttin\' it  down.\nHard Drive is referred to as "Da BQE Rush Hour."\n** Instead of  an error message a "You ain\'t gonna friggin\' believe dis!"\npops  up.\nCHANGES IN TERMINOLOGY IN DA BROOKLYN EDITION:         OK...................Sure ting         Cancel...........Fugetaboutit         Reset.............Start Ova         Yes.................Yeah         No...................Nah         Find................Put a contract out on         Browse..........Get a looksee         Back...............U toin         Help................(Help ain\'t available  -yous\n',
 'barkerde@nmenergy.com writes to the NYISO_TECH_EXCHANGE Discussion List:    Having worked the same shift schedule that the ISO uses, I have something new to ponder.\nAssuming Senior Shift Operator "A" was on day shift Mon/Tues and SSO "B " was on day shift for Wed/Thurs.\nThe results of the Real Time prices/ uplift were dramatically different from SSO "A "to SSO "B"( Mon and Tues were very similar and Wed very different) If all things being nearly the same, could the operating philosophies of the two SSO\'s contributed to a very divergent economic results?\nWhen the ISO does its post mortem (bad choice of words) on the high load days, do they look at the operating philosophies of the operators to see if they impact economics?\nWhen I say "philosophies",  I am  NOT referring to the security decisions only on how the solving of the security constraints could be different enough to have two totally different economic impacts.\nFurther back pedaling, without knowing the outages or Bid stacks etc, I am only asking if the ISO looks at this kind of thing when they do their evaluation.\nPonder away...\n',
 'RBoyle@nyiso.com writes to the NYISO_TECH_EXCHANGE Discussion List:   After reviewing the dates in Attachment A of the ICAP manual, I noticed that there is not enough time between various obligation dates to process information.\nBelow are the changes that are needed.\nTopic               Original Date  New Date Deficiency Auction   8/27/01        8/28/01 Post Results         8/29/01        8/30/01 Certifications      10/19/01       10/23/01 Deficiency Auction  10/22/01       10/25/01 Post Results        10/25/01       10/30/01  Regards,\n',
 'Dear Enron Employees:  I am saddened to inform you that there was an explosion and fire at our Teesside power facility in England at approximately 2:40 p.m. local time.\nAt this point, we know that two employees have died, and at least two others have been seriously injured.\nThe area has been evacuated and the power station is currently off-line.\nThe cause of the incident is not yet known.\nOur hearts and deepest sympathies go out to the families of those affected by this terrible incident.\nJeff Skilling\n',
 'IMPORTANT  MESSAGE!\nPLEASE READ!\nFILENET SYSTEM OUTAGE  \t\t\t\tAUGUST 17 - 19, 2001   The FileNET System is scheduled to be down for maintenance to start the upgrade process to IMS 3.5.\nThis upgrade will be done in several stages, the first stage being the Oracle database.\nFor this upgrade all batches scanned or imported into queues must be cleared from the FileNET System by Friday, August 17th at noon.\nAll users will not be able to access the System after close of business on Friday, and we anticipate users having full access on Monday morning August 20th.\nIf you have any questions or concerns about this outage, please feel free to call the Help Desk @ 713-853-1555 Option #1   Document Management Team Document Mgmt and Process Automation 713/853-1555 Opt 1\n',
 'BKranz@nyiso.com writes to the NYISO_TECH_EXCHANGE Discussion List:  Jim,  Thank you for providing your suggestions for proceeding with the assessment of BME/RT pricing issues assigned to the S&P working group by the BIC Chairperson at the MC last week.\nThe compilation and review of data that you have proposed would take some time and coordination from staff in several departments including Operations.\nDue to the conditions we are experiencing this week, we will be unable to provide this data in time for the next S&P meeting.\nBecause of this, I would propose that we post this list with the meeting materials for the 20th and that we will provide as much information on our assessment of the issue as we can at this meeting.\nRegards,\n',
 'A new class on HTML Basics will be offered on September 14 from 8:30-11:30 am.\nThis class is for beginners.\nThe topics to be included are:  Text Appearance and alignment Paragraphs and Line Breaks Hyperlinks within Web Site Linking with Named Anchors Linking to an Email Address Placing Graphics on a Page Graphics Images with Hyperlinks Arranging Text in Lists Formatting Lists with Symbols and Numbers  You can register for the class at elm.enron.com.\nIf you have difficulty registering, please call ext.\n31816 for assistance.\n',
 'market_relations@nyiso.com writes to the NYISO_TECH_EXCHANGE Discussion List:   Dear Market Participants,  Required maintenance work is scheduled on Wednesday, August 22 and Thursday, August 23 for NYISO servers that host some of the web sites.\nThis work is scheduled to take place between 7 and 8 am on both days.\nAccess to customer statements will be interrupted at times on Thursday morning during that hour.\nIf you access the Bidding and Scheduling pages by directly connecting to an IP address, you should contact your Customer Relations representative for information on how you will be affected.\nOtherwise, if you connect to bidpost.nyiso.com, you should not notice any interruption in service.\nPlease contact Customer Relations if you have any questions.\nRegards,\n',
 'JSavitt@nyiso.com writes to the NYISO_TECH_EXCHANGE Discussion List:  The NYISO is reserving hours-beginning 1 and 7 in the 19 August 2001 real-time market to verify prices.\nThe prices in the 20 August 2001 Day-Ahead Market are correct.\nPursuant to ECA-B the NYISO is reserving the following hours at the following external proxy buses: HQ: 0:00-9:00, 21:00 NE:  0:00-1:00, 4:00-5:00, 21:00 OH: 0:00-1:00, 4:00-5:00, 21:00 PJM:  0:00-1:00, 4:00-5:00, 21:00\n',
 "A meeting has been scheduled on 3/16 with the California Fish and Game to  discuss the following issues:  1)presentaiton of the 1999 and 2000 annual  reports which are required by the facility's 2081 permit.\n2) developing an  agreement with F&G as to how the 41 acre credits held by EOTT will be managed  to ensure compliance with requirements of the F&G.\n3) Presentation of the  results relating to surveys conducted in the path of construction for the  Rogas project.\nThe waiver to lay pipeline above ground for the Rogas constsruction was  approved by the Offfice of the State Fire Marshall, Pipeline Safety  Division.\nThere were 8 city, county, state and federal agencies notified by  application for approval to construct the 9 mile pipline system consisting of  3 piplines.\nThis is the only agency approval received as yet.\nAcre credits were obtained from Aera for the construction of the Rogas  pipeline.\nAera is an oil company with major holdings of acreage available  for purchase.\nIt was felt that due to the time constraints for initiating  this project and the concern with not receiving the credits from the F&G that  EOTT would purchase Aera credits to ensure procurement of the necessary  acreage for the Rogas project.\nThis is a major plus for the project.\nThe rough draft of the baseline noise survey for the turbine installations in  Az.\nwas received.\nSome changes will be made in each document.,  as the  contractor has made some obvious conclusions and asumptions which are not  valid or representative of the mitigation Transwetern will do.\nThe Navajo  Nation has requested that an onsite survey be conducted at the C/S on the  reservation (C/S 3 and 4)  for T&E plants and animals and archeology.\nA  contractor has been notified and surveys will be completed by 3/12.\nThe F-1  environmental report  for the FERC application will be submitted to Donna by  this friday.\nThe air permit applications for C/S 1 and 2 have been started.\nA meeting  with EPA in San Francisco has abeen set to discuss permitting the C/S  facilities on the reservation on 3/20.\nAfter the meeting, applications  should be in front of the Navajo air permitting agency and the EPA within a  week.\nAir permits are expected  within 5-7 months after submittal of the  application.\nDuring a conference call this week, a proposal was submitted to  remove the existing auxillary generators and replace with 2 units at each  location.\nThis will delay submittal of the air applications 3-4 days,  assuming no major issues result.\nOne interesting issue that might develop is  that one of the generators might possibly be a wind turbine.\n",
 'Hazardous waste fees were submitted to the state of Arizona.\nEmissions fees were submitted to the state of New Mexico For C/S\'s 7,8,9,  Atoka No.\n3 and Bloomfield.\nSubmitted to the state of Texas an admisistraitve revision for the "like for  like" replacement of an IC engine at Irion Co. No.\n1 C/S.\nTo meet the  requirements of 2 gms for NOx, a catalytic converter has been installed on  the replacement unit.\nSubmitted to the state of New Mexico notification of a "like for like"  replacement  of an I/C engine at Atoka No.\n2 C/S.\nA revised Title V application was submitted to Region VI, EPA for C/S No.\n6,  Laguna.\nThe emissions inventory for the TW Keystone C/S was submitted to the state of  Texas.\nThe spreadsheet development for the EOTT tanks in the Midland Region has  slowed down.\nSix of 13 teams have responded with tank information.\nA  request was made to Scott Clark, Regional Director,  to assist in notifying  the teams of the importance of submitting this data.\n',
 'Under the regulations of the state of Arizona, facilities which have a  pollution prevention plan (sta.1, sta.\n2 and Needles) are required to have an  annual training to evaluate pollution prevention activiies.\nI have scheduled  with the above three facilities to have pollution training on the following  dates:    Kingman team June 21    Flagstaff team June 22  This training is to be completed by July 1 of every year.\nThis training will  last for approximately 2-3 hours.\nEmployees that works at any of the three  facilities are required to be present for the training.\nYour participation  in this will be greatly appreciated.\n',
 "Transwestern received a Compliance Order from the State of New Mexico, Air  Quality Bureau, for an outstanding turbine replacement activity at the P-1  C/S which occurred in 1996.\nTranswestern had met with the AQB over this  issue in 1996 and assumed that the issue had been resolved, as no further  actions were received from the agency until this Compliance Order was  received.\nThe issue in question was Transwestern's replacement of  interchangeable internal components from a 4700 turbine into the existing  smaller turbine (3505).\nThe larger internal components  (inlet guide  vanes/nozzles) which were placed into the 3505 were mechanically derated to  simulate conditions of the smaller turbine.\nWhen Transwestern received  permit approval from the AQB to operate at the larger turbine capacity,  Transwestern made the upgrade adjustments and then operated at the higher  turbine value 4700.\nThe AQB did not understand that Transwestern could not  make the adjustments to the inlet guide vanes as any such activity by  Transwestern would void the warranty with Soalr Mfg.\nOnly Solar is  authorized to make adjustments to the turbine.\nThis prevents Transwestern  from randomly and arbitrarily manipulating and adjusting horsepowers of this  turbine at their descretion.\nIn the 1996 meeting with the AQB, Transwestern committed to conducting a  emissions test of the 4700 to determine if emissions were more or less than  the permitted values for the 3505.\nIt was shown that emissions from the 4700  were less than that permitted by the AQB for the 3505.\nIt should also be  mentioned that the 3505 was a regerative turbine and the 4700 is a simple  cycle.\nApparently, EPA has mandated that the AQB act on all issues considered to  be outstanding as determined by the EPA.\nDave Nutt has been sent the  Compliance Order to review.\nUnder the conditions of the Order, Transwestern  has 30 days to request another hearing.\nId like to have a group discussion to decide how Transwestern will manage and  handle this issue.\nWould someone contact Anabelle and have her set up a  conference call for sometime next week?\n",
 "The Air Quality Bureau conducted an agency inspection of C/S's 7 Mountainair  and 8 Corona.\nThere were no deficiencies or items of concern identified by  the inspector.\nFacility records were copied from the Air Quality Bureas files in Santa Fe  for the P-1 C/S.\nThe excess emissions semiannual report as required under NSPS for turbines  was submitted for the Bloomfield C/S.\nA custom fuel monitoring schedule  reqeust was submitted to Region VI EPA for  the NNG Plains turbine C/S.\nEmissions fees were submitted for Laguna C/S.\nA meeting will be held with the vice president of development for the Rocky  Mountain Elk Foundation to begin preparation of a MOU between Enron and the  Foundation.\nThe meeting will be held in Albuq.\nduring the 1st or 3rd week in  August.\n",
 'As per your request, an environmental due diligence was completed of the  assets and outstanding issues of Northwest Natural Gas Company (NWNG), a  local distribution company  (LDC), with its corporate headquarters located in  Portand, Oregon.\nThis  due diligence, which was conducted on August 7-9,  2001,  was performed to determine the environmental liabilities and exposures  which may be associated with  NWNG and identify and evaluate the  environmental risks associated with each issue.\nA relative risk number  between 0 and 3 has been assigned to each discipline to evulate the potential  risk impact.\nA rating of "0" indicates that there is no risk associated with  this regulation or issue and a rating of "3" indicates a major problem or an  issue that has a potential long term risk or exposure.\nAn approximate cost   value has also been assigned to each discipline.\nIt is to be understood and  explicitly stated that in the calculation of each cost, conservative  estimates were used to determine a dollar value to repair, remediate or  formally close each issue.\nPresented below, by discipline, are the environmental activities which impact  and affect NWNG.\nThe evualtion and written discussion of each disicpline is  based upon the availability of records, documents and discussions with NWNG  personnel.\nTherefore, this summary report is limited to the availability of  information presented.\nGeneral Pipeline Characteristics ;  This is a dry pipeline system.\nNo pipeline liquids are generated, only small  volumes of compressor oils are collected.\nAll cast iron pipe has been removed from the system.\nThere is still approx.\n100 miles of steel pipe which will be repalced in the near future.\nThe only location where horsepower and compression exists is at Mist Storage,  and underground injection and storage reservoir (10.5 bcf storage capacity).\nthis is a non Title V major source.\nNWNG is planning additional property acquisitions to increase their  underground storage capacity.\nNWNG is planning a 60 mile pipeline construction project to begin in fall of  2002.\nAll environmental studies have been completed and sumbmitted to the  agencies.\nLandslide hazards appear to be the biggest pipeline safety concern.\nNWNG has  completed a study to locate and identify high potential landslide areas.\nEnvironmental Procedures Manual.\nThe NWNG environmental procedures manual   appeared to be comprehensive and in a easily understood format.\nThe topics  covered in the manual addressed all environmenatl issues that the company  appeared to be involved with.\nThe manual addressed waste management,  permitting,  disposal and environmetal stewardship.\nThere was also a written  statement from management supporting and attesting to NWNG\'s commitment to  enhancing and promoting a clean environment in all activities by NWNG.\nRisk: 0  Cost: $0  Notices of Violation (NOV)/Notices of Noncompliance (NON).\nIn a summary  page provided by NWNG, a list of all state and federal agency actions against  the company was available.\nAlthough the company had received a few  notices  (<10), they were of a very minor nature and involved mostly small  recordkeeping and right of way issues.\nThere were no outstanding judgements,  NOVs, NONs or pending agency actions or  issues to be resoved.\nRisk: 0  Cost: $0   PCBs.\nIn interviews with NWNG, they attested to the fact that they have  never used PCBs on their pipeline and that PCBs have never been detected.\nAlthough NWNG is an LDC and receives its gas from Northwest Pipeline Company,  the status of PCBs on the Northwest pipeline system  was unknown.\nRisk:  1  Cost: $0          Mercury.\nMercury was used on the NWNG system, but only in monometers and  not in natural gas metering equipment.\nA decision was made by environmental  management of NWNG in 1986-87 to remove mercury manometers.\nAn investigation  has never been initiated to determine mercury releases from broken manometers  or potential mercury releases from old historic mercury containing equipment  which may have been used.\nRisk:  1  Cost:  $3,000-$40,000  Onsite Disposal.\nOther than the issues surrounding the manufactured gas  plants, in interviews with NWNG\'s environmental management, they were not  aware of any onsite waste disposal of any hazardous, toxic or non hazardous  waste.\nRisk:   1  Cost:   undefined  Hazardous Waste.\nThere is only one location where hazardous waste is  generated and this location is a service center where a small parts washer is  used.\nThis site is classified as a conditionally exempt small quantity  generator.\nThe remainder of the NWNG system is a non generator of hazardous  waste.\nRisk: 0  Cost:  0   NORMS.\nThe environmental management of NWNG has stated that natrually  occurring radioactive materials (NORMS) are not a problem in the pipeline  system.\nTesing has not been completed to verify or confirm this, nor does  NWNG have evidence to determine NORM status from Northwest  Pipeline Company.\nRisk:  1  Cost:  $500  Underground Storage Tanks (UST).\nThere is only one regulated underground  storage tank (UST) remaining on the NWNG system (Albany), and this tank is in  complance with the UST regualtions for monitoring, testing and  recordkeeping.\nAll other underground tanks have been removed.\nAt one of the  tank removal sites, there exists  an active remediation in progress.\nClosure  of this site is expected in the near future.\nRisk: 1  Cost: $500  LNG plants.\nIn interviews with NWNG environmental management, there are no  histoirc or present outstanding environmental issues at the liquified natural  gas (LNG)  plants.\nThe exception to this is a historic site of a  manufactured gas plant (Linnton site) which underlies the LNG plant.\nThis  issue will be addressed under the section of the Linnton Manufactured Gas  Plant.\nRisk: 0  Cost:  $0  Manufactured Gas Plants.\nNWNG owned and operated  a number of manufactured  gas plants (MGPs).\nPresented below are the MGP sites that NWNG owned or had  operating interest in for which there are associated liabilites and risks.\nEugene Water and Electrical Board.\nThe City of Eugene has determined that  a  parcel of property within the city has been contaminated by   numerous  responsible parties of which NWNG owned and operated a MGP during the time  period of 1958-1976.\nThe Eugene Water and Electrical Board  (EWEB), which is  the regulatory agency in Eugene,  has determined that the total cost to clean  the entire area will be approximately $1,300,000, of which  the EWEB has  indicated that NWNGs responsibility will be $93,750.\nNWNG has offered to pay  compensation damages in the amount of $70,000-90,000 to  be relaesed from all  liability and damages associated with the contamination impacts to the City  of Eugene.\nThe environmental management of NWNG  has stated that the EWEB  has verbally and in principal agreed with the NWNG  offer of approximately  $94,000.\nRisk: 1-2 Cost:  $94,000   Salem Site.\nAccording to NWNG management, this historic MGP site has been  remediated and formally closed by the City of Salem, which is the    regulatory agency with jurisdiction over this site.\nNWNG has received  endemnification and written closure from the City of Salem for this feature.\nRisk: 1   Cost: $0   Manufactured Gas Plant.\nThis site, which ceased operation in the early  1900\'s, was dismantled and  abandoned.\nFrom the time the facility ceased   operations, untill the present, a railroad has constructed a steel rail  bridge over the site and the City of Portland and constructed a city park.\nThe site is  immediately adjacent ot he Wilammette River, a major perennial  watercourse in Oregon.\nThere have been no soil, groundwater or river/ river  sediment   studies  completed  to determine potential environmental impacts.\nNWNG environmental personnel have stated that the site was insured by Lloyds  of  London.\nThe insurance policies were not available at the time of this  due diligence to determine policy applicability and coverage amounts for this  site.\nRisks: 2-3 Costs: 0-$300,000,000  Portland Harbor Superfund Site.\nThe Environmetnal Protection Agency has  determined that the Portland Harbor, on the Wilammette River,  has received  contamination of a sufficient nature and magnitude to warrent and classify  the 6.7 miles of the Harbor as a Superfund site.\nThis superfund site extends  for a distance of 6.7 miles and includes the Linnton and Wacker sites,  originally owned by NWNG.\nThe EPA has designated approximately 69 primary  responsible parties  which are directly or indirectly involved in the  contamination of this section of the Willamette River.\nNWNG has been  identified as a contributing member to the contamination.\nLinnton MGP/Wacker Site.\nThe Linnton MGP and Wacker Site, has 47 acres of  water front exposure on the Wilammette River and is included in the  Portland  Harbor Superfund Site.\nThe Linnton facility, which originally included the  Wacker Site,  initiated operation in 1913 and ceased operation in 1956.\nDuring the operation of the  facility operation,  various organic coal tar  wastes, comprised of light non aqueous phase liquids (LNAPLs) and dense non   aqueous phase liquids (DNAPLs) were generated.\nCharacteristically these  waste products include: polynuclear aromatic hydrocarbons (PAHs), BTEX  and  cyanide.\nDuring the early stages of facility operation, these wastes  were  originally directly deposited into the Willammette River, and then later, in   1941 unlined ponds were constructed at the facility.\nPreliminary  investigation reports of the volumes of regulated waste from the facility  operations which  were released either directly or indirectly into the soil  underlying the facility or into the Wilamette  River were in excess of 4.6  million gallons or 23,000 cubic  yards.\nIt was also estimated from these  reports that there is approximately 250,000 cubic yards of tar and tar mixed  with soil underlying the historic tar  ponds.\nNegotiations for cleanup and closure of this site may take up to 20 or more  years.\nNWNG has stated that it has insurance policies from Lloyds of  London   which they feel will cover all costs assciated with NWNG\'s portion  of this superfund responsibility.\nThe policies were not availble during the  due diligence  to verify or confirm the amount of coverage.\nAdditionally,  because the horizontal and vertical extent of the contamination in the  subsurface soil,   groundwater and in the Willamette River sediments has not  been determined, it seems unlikely that insurance coverage can adequatley be  evaluated.\nIt  should also be mentioned that because the proportionate  extent of NWNGs contamination responsibility is not known, adequate insurance  coverage  appears to be somewhat premature.\nRisk:  3  Cost:  $50,000,000-300,000,000\n',
 "The PCB Annual Document Logs for the facilities that generated PCB waste and  stored it at TW's long term storage facility were completed and distributed  to locations and entered into Envisions.\nThe 2rd quarter Transwestern/SoCal PCB mgt.\ncommittee conference call was  completed.\nThis committee meets to discusss PCB management on the SoCal  system and review invoices generated by SoCal during each quarter.\nThis  quarters invoice amount was $280,633.48 of which Transwestern is 86%  responsible or $241,344.79.\nFinal activities are in progress at the Topock Lateral where cleanup of the  1850' pipeline and appurtenances has been completed.\nAnalytical results of  the wipe samples and liquid samples taken showed the cleanup to be  successful.\nAll wipes after the cleaning showed to be less than 1  microgram/100 cm.\nsq.\nAnalytical results of the liquids showed to be less  than 20 ppb.\nThe next phase of the cleanup activities will be in November  when the remaining 11 miles of pipe will be cleaned and have launcher  facilities installed at the mainline interconnect.\n",
 "John, I read Phil's statements concerning the Redrock air permit issue and  would like to shed some additional light concerning the reason why   Transwestern  did not know about the delay in the agencies issance of the air  permits.\nI had met with each agency prior to submitting each application to  ensure that each application contained the correct and proper information  required by the EPA and State of Arizona.\nWhen I told them that we were  expecting the permits by the end of September, each agency indicated that a  September permit issuance would not be a problem, in light of the fact that  energy issues were to be given top priority in the State of Califonia.\nI  phoned the  permit engineer assigned to each application monthly to be kept  aware of possible conflicts and resolve any concerns.\nIn all monthly calls,  both agencies assured me that things were progressing on schedule.\nAs we  approached the anticipated September issuance, calls to the agencies were  conducted weekly and this was when I found out about the 1-4 month additional  time which would be required for the permit issuance.\nI dont know what else  could have been done to track and alleviate problems encountered to ensure  that the permits would be issued in a timely manner.\n",
 "1.\nStatus of Mainline Filter Separator Project.\nEarl Chanley has indicated that the June 1 target date for in service is on  schedule.\nThere will be 2 mainline separators for each mainline system.\nPG&E is also on schedule for June 5 & 7 pipeline tie ins to each bank of  separators.\nThe only outstanding issue is an air permit for the 1200 gallon  tank at the separator installation site.\nThis is a PG&E issue and will not  create a delay of the in-service date.\nAll other permits and approvals,  according to PG&E, are in place.\nPG&E has stated that after operation of the separators, they will want to  discuss maintenance issues with ET&S.\nPost construction of the separators will result in 2-50 ft joints of 34 in.\npipe.\nPG&E will perform wipe tests on each piece to determine reuse and or  disposal.\nIf the pieces test  to be regulated by state and federal, PG&E  will consult their legal group to determine whether they will decon or  dispose as a PCB regulated material.\nIf the decision is to decon, PG&E has  indicated that they will seek another contractor other than Vector to reduce  costs associated with cleaning the pipe.\n2. Review Test Results of Ongoing Gas Sampling.\nUpdate since last sampling discussion in San Francisco.\nGood news is that at  MP 353 (kettleman C/S), latest sampling showed non detect.\nThe third round  of sampling taken at this location is not available.\nAll other samples  collected at suspected liquids locations areas showed PCB liquids results to  be decreasing  toward Hinkley C/S.\nLine 311 is a 12 in.\nline which travels  north to Ridgecrest, Ca  also feeds  IMC Chemical Plant.\nPrevious testing  showed non detect.\nMost recent sample showed 22 ppm.\nSecond sample has  been collected but results are not available.\nSamples are proposed to be  collected at the IMC Chemical Plant.\nThere is a potential for the IMC Plant  to be PG&E's biggest single commercial customer and therefore, this site is  considered to be a sensitive area relating to PCB's.\nKern River Station continues to show PCB concentrations  of 1-3 ppm.\nThe  gas from this location feeds into a portion of the Southern California Gas  Co.  system which is PCB free.\n3.\nDiscuss Future Sampling Process and Frequency.\nWest end of the PG&E system has not been sampled.\nThe east end of the system  has at least 2 rounds of sampling conducted.\nSampling frequency for these  locations is once every two weeks.\nWhen a sampling location is shown  to  have liquids, it is resampled two weeks later and is included into the  sampling program.\nTranswestern has requested to PG&E to increase the collection reservoirs  under the meters and valves to allow greater removal liquids from the  pipeline system.\nAt the present time a small nipple is inserted into the  bottom of the valve and meter body  for the liquids collection.\nBy  increasing the nipple size,  a greater collection container will be produced.\nIt was mutually agreed that until installation and operation of the two the  separators, PG&E will continue to sample each location once every two weeks.\n4. Review Criteria Used to Determine Need for Tap Filter/Separators.\nOriginally 29 locations were identified to receive the small filter  separators.\nThese locations were considered Priority 1 sites.\nThe  determination of a Priority 1 site is based upon the following criteria:  1)  a location where liquids were collected twice and 2)  ppm concentration of  the liquids collected was > 1.0 ppm.\nBased upon these criteria, Ridgecrest and Bakersfield (Kern River Station)  have been added to the list of Priority sites.\nFlow through at the Kern  River location is 300-500 mmscf/day.\nSamples collected at this location have  shown PCB's in the range of 1-4 ppm.\nPG&E's agreement with SoCal at this  location is <1.0 ppm PCB's in the liquid phase.\nPG&E has indicated that  there is some sensitivity at both of these locations due to the large volume  of gas deliveries.\nPG&E and Southwest Gas have been in discussions concerning 5 additional  filter separators on the Southwest Gas system due to substantial customer  load at these locations.\nSouthwest Gas feels it needs additional protection  at these sites.\nPG&E has stated that Southwest Gas is beginning to express  additional concern for PCB's at their interconnect locations.\n5. Review and Discuss List of Proposed Tap Filter/Separators.\na. Siting, Design and Engineering   b.\nCost Estimates   PG&E passed out a booklet pertaining to 9 small filter separator sites, plus  an additional sheet for 16 sites with back-up to be produced in the next  week.\n.\nFour of these separators have been installed.\nA total of 45 filter  separators may be proposed for installation.\nThe cost estimates for the additional small volume  F/S up to the 29  indicated at the last meeting is 1.2 to 1.3 million.\nThe sampling costs have  not been included in this number.\nEstimates are being reviewed on a per sites  basis as PG&E presented.\nOne PG&E customer, a cement plant, has inquired about PG&E deconning portions  of their plant that has PCB's.\nPG&E is in discussions with the cement  company.\nPG&E has informed the cement plant that it will evaluate the  success of the filter separators to be installed on the line feeding the  cement plant prior to committing to any action.\nIf the deconning occurs, it  will be a 2001 project.\n6.\nOngoing Consideration of Additional Customer Protection.\nCompressor Oil Control.\nThe majority of liquids collected at strategic  sampling locations is compressor oils.\nTranswestern has requested access to  the PG&E C/S to study lube oil systems.\nThere are 22 compressors at the  Topock and Hinkley C/S's.\nTranswestern will conduct a  study of technologies  to assist in reducing oil from entering the pipeline system.\nEarl will  coordinate site visits with Glen Riddle.\n7.\nOther Issues or Concerns.\nEarl requested additional information on invoices submitted after January,  2000.  rod will send back up and support data of existing invoices sent to  Transwestern.\nPG&E is considering increasing gas receipts from Transwestern to 250-300  mmscf/day cap by May 15.\nOver time PG&E will look into their C/S  configurations to handle the increased gas flows to 450 mm scf/day.\n8.\nNext Steps.\nThe next meeting was proposed in 45 days.\nThis time period will allow  inspection and operation of the mainline filter separators and collection    additional sampling data at new and suspected sampling sites.\nThe location  of the next meeting was tentatively scheduled for Flagstaff AZ on July 13 as  some of the PG&E meeting attendees will be in Flagstaff during that week on  other business.\n",
 'I received word from the TNRCC that they will allow a portable emissions test  at the Spraberry C/S to confirm that the replacement of the fuel mixers with  carbureators will not cause an increase in emissions.\nI will send out the  letter today to the TNRCC reqesting written approval to do the testing.\nI  would strongly recommend that the Spraberry Team have the sampling ports  installed on the unit that they select to be tested and have this testing  completed ASAP.\nRemember, the unit selected must be tested with the fuel  mixer on and then remove the mixer and conduct a test with the carbureator  on.\nWhoever performs the portable emissions testing will need to ensure that  we follow a portocol that I will submit to the state.\n',
 'Rich, thanx for the sampling update.\nIll pass it along to the apropriate  parties.\nA cursory look at the data shows it to be inconsistently up and  down, as expected, with no glaring increases.\nAnything urgent we need to  discuss?\n',
 'Trade press, recruiting firms and others recently have made numerous calls to Enron employees seeking information about the company, its employees and other matters.\nIn some cases, these callers have used false identities, as in, "I\'m from the SEC and I need you to provide me with?"\nIf you receive a call from someone identifying themselves as part of a government organization, please refer the caller to the legal department.\nPlease refer calls from the trade press and other media inquiries to the Public Relations group.\nAnd otherwise, please treat Enron information as confidential.\nThank you.\n',
 'Casey,  I ran a test deal through on EnronOnline.\nPlease verify that Deal ID 665070.1 in ENPOWER TEST is correct.\nPlease let me know so that we can go ahead and set this up in production.\neol deal #1631717  Thanks,\n',
 'We are continuing work to ensure our new online trading system, UBSWenergy, is ready for launch on the week of Feb. 11, which is the week following the anticipated Enron/UBS Closing Date of Friday, Feb. 8.\nTo assist in this process, we are planning an online trading simulation for Thursday, February 7 from  0900 to 1100 (CST).\nIt is planned to include all  traders, originators, mid/back-office staff and IT teams who would normally be involved with electronic trading.\nPurpose of the simulation - The simulation will test our "live" trading environment (restricted to internal access only) and will:  Test the integrity and functionality of the system and related processes (including credit, risk, legal, operations, etc.)\nProvide an opportunity for traders to verify their products and product setup Demonstrate how the trading system and processes work to UBS staff visiting next week  Nature of the simulation - The simulation will include testing of all processes related to trading and mid/back-office functions:  Credit, Legal, Risk, Operations, and other groups: Profile tests for "external" customers (role-played by Originators) Profile tests for internal users (traders, back-office, etc.)\nData and Process checking as completed transactions flow through Mid/back-Office systems  Traders and Originators: Traders will be managing their individual books and associated products.\nAlthough we may be restricted to certain financial products on launch day, both physical and financial will be available during the simulation.\nEach trader will be asked to manage their individual position and profitability goals for the simulation.\nOriginators and others will be asked to play the roles of counterparties.\nCredit limits, etc.\nwill be tested during the simulation.\nInformation Technology: Will assist in preparing data on the system for the simulation.\nAfter the simulation is over, will work with the relevant groups to test the trade-data in various systems and risk books Will ensure all simulation data is removed from the system after the simulation is complete.\nNext steps   Traders and Originators will be contacted prior to simulation day to ensure they have appropriate access to the system.\nOriginators will be assigned specific roles.\nYou should expect to receive an email and/or handout on or before Wednesday, Feb. 6.\nUBSWenergy personnel will be meeting with back office personnel over the next several days to ensure everything is in place for the simulation.\nSummary  This simulation is an important step towards re-launching our trading business.\nWe appreciate the participation of everyone involved as we prepare for the public launch of UBS Warburg Energy and the UBSWenergy trading platform.\nIf you have any questions, comments, suggestions, or ideas regarding this simulation, please feel free to contact Bob Shults (30397) or myself (31861).\nRegards,\n',
 'Dear Michael Carson,  Your check request, case #020131-4476, was processed on January 31, 2002.\nIt will be sent via mail and should arrive shortly.\nThank you for choosing E*TRADE!\n',
 "With the filing of the Hart-Scott-Rodino application last week, it looks like our updated launch timeline is as follows.\nNote that it is still possible that this timeline could shift:  Week of Jan 28:  We will distribute a packet to each of the Originators/Traders who have volounteered to call customers and assist in getting signed Password Applications.\nThe packets will contain:  Key Messages Frequently Asked Questions (FAQs) Top Counterparty Checklist  External Customer Cover Letter Password Application (PA) Registration Form Fax Cover Sheet for PA/Registration  Electronic Trading Agreement (ETA) Internal online Marketing Contact List  Each person receiving a pack will contact the Master Users at the companies they have volounteered for and send them copies of the Password Application (PA) and Electronic Trading Agreement (ETA).\nDuring this week, we will be working hard to get as many of the PA's returned as possible.\nOnce we have a signed PA, we can send the customer their new User ID, which will allow them to start trading on the day we launch the new site.\nA Splash page will be available at www.UBSWenergy.com or via an automatic redirect from www.enrononline.com.\nThis page will tell customers about the pending launch of www.UBSWenergy.com and provide links to the PA and Registration screens and also to the User Admin screens, which will allow customer Master Users to start setting up their Sub Users.\nThe Splash page will look something like the following:      Week of Feb. 4:  We will send out a mass mailing to approx.\n3,000 individuals at 450 companies inviting them to sign up for the site.\nIncluded in the package will be a simple brochure, copies of the PA and ETA, key messages and a list of Frequently Asked Questions.\nWeek of Feb. 11:  The site will launch, with at least financial products (timing for gas physical and power physical to be determined according to regulatory issues).\nGeneral Terms and Conditions (GTC's) will be available online and must be accepted online before a company can start to trade a particular commodity.\nTrading/Origination Coordination  The Top 50 customers will have at least an initial contact within the first two days of starting the marketing effort and that all customers who previously traded either gas or power will receive a mailing within the first 10 days.\nAn online marketer has been assigned as coordinator for each company and will assist each Trader/Originator in following up with Master Users as necessary to make sure PA's are signed and returned.\nUBSWenergy Marketing Contacts:  For Marketing-specific questions, please use the following contacts.\nFor other questions, please contact Bob Shults (30397) or Dave Forster (31861).\nTeresa Mandola (39807) - Power Jennifer McQuade (53614) - Power Dan Diamond (39673) - Gas\n",
 'Mike,  When you evaluate your curves and scalars for the OG&E area, can you also make sure your Entergy long term curves and scalars are in good shape?\nWe will probably be using those for some load following possibilities and other long term deals such as heat rate options in the Entergy control area.\nI assume the scalars would not be much different for either area, but I wanted to make sure they were both updated.\nThanks.\n',
 'Our natural gas business continues to benefit from effective account management and resource allocation focused on identifying and responding to the needs of our varied customers.\nIn order to keep our organization optimally structured and to facilitate additional growth, we are making the following changes:  Producer/Wellhead Group  The current mid-market, origination and wellhead pricing activity currently within the Central and Eastern Gas Regions will be consolidated with the Derivatives group under Fred Lagrasta.\nThis will create a single business unit focused upon the needs of the producing industry within the Eastern U.S.\nThe producer focus in the Western U.S. and Texas will remain unchanged reporting  to Mark Whitt and Brian Redmond respectively.\nStrategic Asset  Development Laura Luce will move from her role in the Central Region to lead an effort focused strictly on identifying and entering into long-term strategic arrangements within the Central and Eastern Regions.\nThis initiative will focus on a limited number of selected markets that provide strategic opportunities for partnering in asset development, asset management and optimization.\nThis effort will continue to work very closely with the regional leads.\nCentral Origination and Mid-Market Frank Vickers will continue his current role in the Eastern Region and will assume the leadership role for Mid-Market and Origination activity in the Central Region.\nThere will be no changes to the West and Texas Origination groups headed respectively by Barry Tycholiz and Brian Redmond.\nPlease join us in congratulating Fred, Laura and Frank in their new roles.\nLouise & John\n',
 'Terry,  I traded vxmails with David Oxley, and he told me that Michelle is handling these matters.\nPlease let me know if you need further help.\nThanks,\n',
 'As you know, Sarah is on her honeymoon now, so I am trying to tie up all loose ends with regard to the FMLA and Sick Leave Policy.\nI would appreciate it if you would read the following documents and let me know if we have the "go ahead" to proceed.\nWe are beginning to work on a very tight deadline here since we need to give the appropriate notice to all employees.\nAfter reading the FMLA policy, do you think that we need to have links that explain ADA and Workers Comp?\nIf you have any questions, please don\'t hesitate to let me know.\nThanks,\n',
 "Should we get Greg and ENE OTC to send an email out today saying something like:  In light of all of the recent extraordinary business matters that have been facing us we have held of launching the traditional year end PRC process.\nMany of you will recall in our response to the lay it on the line survey we had announced several changes to this process primarily deigned to clarify the purpose of the PRC meetings and streamline the process.\nHowever, given all that has happened in the last 3 weeks and all the critical business matters including the strategic review of our core and non-core businesses, we have concluded that it would be wise not to dictate we follow the previously announced guidelines.\nSpecifically, we will delegate to each of the business unit leads to decide whether they want to use the 360 PEP electronic feedback process and what form they would like to undertake any relative talent discussions.\nPlease look for further details and direction on the above from your BU lead in the next few days.\nWhile we hope you understand that we need to make sure that we channel our efforts appropriately at this difficult time, we would want to make sure that everyone understands that: \t1.\nWe will have a bonus process.\nThis will be conducted largely as in the past, but with a particular emphasis on those employees\t\t \t\tcritical to business operations and ensuring our ability to successfully complete our proposed merger with Dynegy.\n2.\nIf there is a rationalisation of headcount following our strategic business review of core and non-core, this will be conducted\t\t\t appropriately.\nOur PRC process will not be the sole determinant in any such process, many other factors will be considered and as such\t\t\t this will be a separate process.\nNeed help with last 2 bullets!\nQuestion is whether to send now or wait for another 3 weeks.\nWhat d'ya think?\nDavid\n",
 'In my discussions with Andrea Lang today she is very keen to start some dialogue on transition.\nI have expressed my concerns about timing given what we have ahead of us over next 6 weeks but she would like at least provisionally to have a discussion about certain aspects of the transition process sometime in December.\nI will update you, but I have initially (given her intended process plan requirements) indicated that each of you may be involved.\nPlease do not share this widely and bear in mind I may need to change/add to this list once I have a clearly picture of what is needed.\nDavid\n',
 'To the HR Generalist Community:   The Livelink team is making every effort to post up-to-date answers to assist you in addressing employee questions in key topic areas.\nOver the past two days, a significant amount of new information has been posted on the site.\nPlease take a moment to consult this resource.\nWe would like to emphasize that because of the dynamic and sensitive nature of this information, the Livelink resource is for your reference only.\nPlease use discretion in discussing these issues with your clients, and do not share directly via hard or soft copy with those outside the HR community.\nThank you,\n',
 'Tomorrow, generalists will receive a binder outlining the process of how the WARN notifications will occur.\nI assume we need to mark these documents as confidential and proprietary.\nIs there any specific wording you would like on either a introduction page or as a footer on each page?\nPlease let me know so I can include.\nThanks - Tana\n',
 "Michelle;  This is the presentation which was provided to the HR VP's.\nThe HR VPs were tasked with going off to met their BU OTCs and devise plans around the three components.\nWe are currently collating those plans into one document.\nWe'll send that along to you when completed.\nPls call if you have any questions.\n",
 'Michelle-  I hope that this message finds you well and that you are having a great week.\nI spoke with Mark Broadfoot this afternoon and he suggested I try to reach you through e-mail.\nI just would like to inquire with you to see if you have any feedback regarding the PWD sample that Darlene Donlan forwarded back to you last week.\nIf you could please let us know where that stands, or if you have any feedback and/or questions it would be greatly appreciated.\nThanks and have a great evening.\nRespectfully,\n',
 'Michelle/Lizsette;  I was wondering if circumstances with Jonathan Lane (the contract Help desk person whom I mentioned to you a week or so ago) have been resolved?\nWhen we last spoke I mentioned that he went to Valeria Hope\'s group.\nI am not sure of the outcome  of that visit, but I will tell  you that his negative attitude and general dissatisfaction on the team is becoming disruptive to the other help desk members.\nHe is away from his desk often (having "meetings", which may be interviews for other positions), he has shared with the other team members his perceptions of management and his issues with us.\nIf and when I can do so, I would like to terminate him.\nI won\'t until I hear from you all, and we are documenting discussions as you requested.\nI hope this can end soon, though because this is causing real problems here.\nGina\n',
 'Michelle,  As I indicated in my voice mail this morning, I am working with Janice Priddy, Manager of Enron Corporate Payroll, on a significant employment tax refund project.\nWe are in the process of quantifying potential FICA, federal unemployment and state unemployment tax refunds related to both internal and external acquisitions involving employees.\nEssentially, if we are able to determine that the predecessor company had beneficial unemployment tax rates, we may be in a position to either retroactively or prospectively take advantage of those rates.\nIn addition, mid-year transactions may also result in a refund of amounts paid by Enron in excess of certain federal and state wage bases (Enron may be entitled to take credit for those wages paid by the acquired company prior to, but during the same calendar year, as the transaction).\nWe obtained Enron Corporate Data Sheets from Kate Cole and Deborah Korkmas was designated as a legal contact related to several external acquisitions.\nWe have prepared a short, one page questionnaire, which will assist us in determining whether a significant refund opportunity exists related to these particular acquisitions.\nAccording to the Corporate Date Sheets, Deborah is the legal contact for the following acquisitions:  2000 - Garden State Paper Company, LLC (FEIN: 94-3371710) 2000 - KUCC Cleburne, LLC (FEIN: not listed) 2000 - Tenaska IV Partners, Ltd. (FEIN: not listed) 2000 - Harrier Power Corporation (FEIN: not listed)  Please complete the attached questionnaire for each acquisition with as much information as possible.\nIf the acquisition did not involve employees, just complete the top portion of the questionnaire and answer questions 1 and 2.\nIn reference to question 5, since it is unlikely that you have access to such detailed payroll information, if you could provide the states in which the predecessor had employment, we will then be in a position to contact state agencies to gather more detailed information.\nThank you for your assistance in this process.\nIf you have any questions, please call me at (713) 237-5346 or Janice at x37839.\nOnce the questionnaires have been completed, please return them to me via e-mail at alexa.r.cutter@us.andersen.com.\nSincerely,\n',
 'Mark,  As you requested, below is a list of my major accomplishments for the year.\n1.\nResolution/management of pre-litigation and litigation matters,  including:  Dwayne Hart/Utilicorp; Satterwhite; Barrington; Race/Statoil;  Ross Malme; Rick Blandford; West Boettcher; Anita Suson; Charlie Weymms;  Steven Cuneo; others.\n2.\nEfficient management of drafting, negotiating, revising, and completing  several types of contracts in numerous different jurisdictions (e.g., almost  200 employment agreements, 35 separation agreements, and 30 consulting  services agreements).\n3.\nLead attorney on Project One (which involves issues surrounding the  OFCCP\'s "glass ceiling" audit of ENA and all of Enron).\n4.\nLabor and employment transactional support, including:  East Coast Power,  Ecogas, CGas, Project Hurricane, Columbia, Project Grizzly, Las Vegas Cogen,  and other acquisitions that involve the transfer or hiring of personnel.\nMany  of these transactions require extensive legal support relating to personnel  matters after closing.\n5.\nLegal support on labor (union) matters, including successful closing of  project labor agreements for the construction of generation assets (e.g.,  Pittsburg, 2000 peakers, Pastoria), Unfair Labor Practice matters, training  on union-related issues in M&A\'s.\nLet me know if you need any more information, and thanks for your support!\nMichelle\n',
 "Hector,  Where are we with regard to the investigation into this matter?\nI know that  you've got a lot going on, and I didn't want that one to fall through the  cracks.\nThanks a lot!\n",
 "Pat,  Hello!\nI am sending to you a memo from Stuart Zisman here at Enron.\nHe has  a question that I am forwarding to you, since I don't know the answer.\nWould  you please give him an answer today, if possible?\nThanks a lot!\n",
 'Hello!\nAn ENA employee wrote a book that was published in Russia.\nThere have been  three editions, and the publisher wants her to do a 4th.\nThe topic is  technical analysis, which is what she does here at Enron.\nIn this 4th  edition, she will be using public data, her own PC, and working on her own  time.\nHowever, given that she has been at Enron for 6 months, she obviously  would apply some of the knowledge she has gained here in the revision of the  book.\nShe would not divulge any Enron confidential or proprietary  information, however.\nWhat are your thoughts on whether she could be able to do this?\nShe is  willing to let Enron be a co-author, although as a practical matter, I do not  think that would be worthwhile.\nMy opinion at this point is that she can do  it, so long as it is on her own time and using her own resources, and, of  course, provided that she reveals no Enron-specific  information.\nI welcome  your perspective, however, given that this is a new one to me.\nThanks for your thoughts.\n',
 'Dee,  I assume that you will go through these documents for benefits/plan issues  and then send relevant ones to Pat this week.\nIf that is not your plan, let  me know.\nThanks!\n',
 'Good Afternoon Analysts,  Were you unable to attend the Rice MBA Info Session?\nOr, would you like more information?\nPlease visit EB3526A for brochures, applications and other information regarding the Monday, November 5, 2001, Rice MBA Info Session.\n',
 'When: Thursday, November 15, 2001 1:30 PM-2:30 PM (GMT-06:00) Central Time (US & Canada).\nWhere: TBA  *~*~*~*~*~*~*~*~*~*  Hello Warriors,  Many of you expressed interest in an MS Excel session with Eugenio.\nPlease email me at least one topic you would like Eugenio to cover.\nThanks,\n',
 'The Pulp Weekly Meeting scheduled by Rodney Malcolm for every Monday at 9:00am to 10:00am will now be held in video conference room ECS 04075 (new building).\nThe London team will be participating via video conference.\nThanks,\n',
 "Ami/Monika:   Attached you'll find an analysis of a publicly-traded company which should serve as an example for what I'm looking for.\nThanks again for all your help with this.\nKC\n",
 'This is the speadsheet we have been working off of for the 2010 model that Kevin Howard is running.\nPlease let me know if you have questions or would like me to summarize this for you in a more useful format for your reference.\nLindy\n',
 "This is a reminder of Enron's Email retention policy.\nThe Email retention policy provides as follows:  Message Location - Maximum Retention Inbox - 30 days Sent Mail Folder - 30 days Trash/Deleted Items - Rollover from Inbox for one day Folders - All Email messages placed in folders will be destroyed after one calendar year.\nThis includes public folders in Outlook.\nFurthermore, it is against policy to store Email outside of your Outlook Mailbox and/or your Public Folders.\nPlease do not copy Email onto floppy disks, zip disks, CDs or the network.\nSuch actions are prohibited and will not be supported by the IT Department.\nThere will be no exceptions to this policy.\n",
 "Chris,  Per your request, I have included the information on the BPA contracts.\nAll of the values listed below are as of the curves on 12/17/2001.\nI have asked Fran to run the MTM as of the curves yesterday to further update the information.\nFormer Analysis - including deals through 12/31/2001: WAUNA or '97 Letter - $ 22.3 mm (one deal 10/1/2001 thru 12/31/2005 - long position 102 MW) Firm Purchase Agr.\n- $ 55.9 mm (one deal 1/1/2002 thru 12/31/2006 - long position 144 MW) '97 Enabling Agr.\n- $   7.0 mm (longest deal thru 12/31/2003 - net long position of 48 MW) '00 Enabling Agr.\n- $301.8 mm (longest deal thru 12/31/2006 - net short position of 89 MW) TOTAL                      - $387    mm (net long position of 204 MW)   TODAY - No deals ending 12/31/2001; includes one deal ending 1/31/2002 WAUNA or '97 Letter -  TERMINATED (97PB 10123) Firm Purchase Agr.\n-  TERMINATED (98PB 10227) '97 Enabling Agr.\n- $   6.8 mm (longest deal thru 12/31/2003 - net long position of 100 MW) '00 Enabling Agr.\n- $301.2 mm (longest deal thru 12/31/2006 - net short position of 239 MW) TOTAL                      - $308.1 mm (net short position of 139 MW)  Regards,\n",
 'Dear Sean,    I have changed 2 deals that were put in as transmission sales : deals # 894692 and 894962 to Buy Resales.\nPlease make any adjustments necessay to your scheduling sheets, etc.\nThe new B/R deal numbers are 896676.1 and 896677.1 respectively, to replace the above 2 deals.\nThe reason for this change is that the Business Rules of EnPower will not allow the system to recognize a sale of transmission from EPMI to another counterparty.\nPlease contact me with any questions you may have.\nThanks,    Virginia\n',
 'The AT&T cell phone representative is here this morning at 10:00am in Mt.\nHood.\nIf you need to ask questions or set a cellular service up please come see her.\nShe is NOT delivering phones OR new phone numbers today.\nThe phones I believe will be shipped out by FedEx.\nThanks,\n',
 "Yo Sweets McGeets.\nJust a reminder that you were going to call and discontinue your payroll deduction for the Enron fitness center.\nLet's talk insurance stuff tonight as I know you need to make those elections soon.\nWill plan on comparing and contrasting my health plan with Enron's.\nLuv, The Wif\n",
 'Dear Traveler,  We at Expedia.com would like to learn more about your experience booking a hotel on our Web site, as well as your subsequent stay.\nTo take our Expedia Hotel Survey, please click on the URL below.\nThe survey will take about 5 minutes.\nThis Expedia survey is strictly a research project initiated solely by and for Expedia.com.\nYour identity and any information you provide will be kept confidential.\nWe will study results only in the aggregate.\nYour information will never be bought, sold, rented, or used to sell you products or services.\nWe sincerely appreciate your time, and look forward to repaying your effort with information that will make your future Expedia hotel bookings easier, and your stays more enjoyable.\nThank you!\n',
 'The winner of the 9/15 Dave Matthews Tickets accidently bid on both pairs of  tickets I had for sale (9/15 and 9/16) and only wanted one pair.\nHe is  buying the 9/16 tickets (11th row) for $345.\nIf you are interested in the  9/15 tickets (8th row) which are even better seats, I can sell them to you  for $305.\nLet me know asap because I am leaving town around 2pm for the  weekend.\nYou can reach me at work or anytime this weekend on my cell phone.\nIf you are interested please call me at 713-853-5933 (work) or 713-516-8820  (cell) and we will work it out.\nFYI - I am also notifying the person who bid  $305 and promised to give them first look but otherwise the tickets are your  if you want.\nThanks,\n',
 'Sandy   Attatched is a copy of the reading we selected for you to read.\nThanks for  taking part in our celebration!\nIf you have any questions you can reach me  at 713-853-5933 or Zooey at home 713-432-7163 or cell 713-516-8820.\nAs if  that is not enough numbers 6pm is the time the rehersal begins.\nWe are on a  very tight schedule so prompt attence is appreciated.\nThe location is the SE  corner of Kirby and Westheimer.\nIf you are coming from 59 you turn left on  Kirby (north) and go to Westheimer and turn right (east) and it is on your  right.\nAlso, the rehersal dinner is following the rehersal at Buca di Beppo  at around 7:30.\nWe hope you will be able to attend.\n',
 'Colleagues:  Utility Risk Management  positions as of  Sept. 1st are now available at the following level of details:    The position (long, short, and net) in electric utility "x" The position (long, short, and net) per customer in the electric utility "x".\nThe position (long, short, and net) per rate schedule/customer class in electric utility "x".\nAggregates of the above per State, NERC Region, and Customer.\nIf you need any position for a specific utility in your service territory, please contact Bryan Gottfredson 713-345-2430  by email with cc to: Harry Kingerski, Pat Keene and/or Amr Ibrahim and we shall attempt to provide the data in the shortest possible time (currently aiming at within the same business day).\nBest regards\n',
 "Jeff, Here are the two letters that were sent.\nI understand you will be forwarding to Jim Staffus (sp?\n), your VP of gov't affairs.\n<<EnronSecDemand 11-29-01.doc>>  <<EnronSecDemand 12-5-01.doc>>\n",
 "Hello All,  If you're like me and you've never been to one sporting event during your time at Cal, here's your chance (if you have, come along for the company).\nFor those interested, please join me on Jan. 19th.\n@ 5:00pm when Cal will take on Washington State.\nThe tickets look like they are $24.50 per person.\nIf you are interested, please let me know, so I can try to get a block of seats together.\nHappy Holidays!!\nAll the best,\n",
 'EXECUTIVE SUMMARY ?\nSeveral procedural scenarios that might play out regarding the Edison MOU.\n?\nA snapshot analysis of the political dynamics that affect the outcome.\nProcedural Scenarios   Assembly  The Assembly Appropriations Committee\'s plan to take up SB 78XX today will likely be a pro forma hearing moving the bill forward to the full Assembly on a party line vote.\nWhile the controversial land easements amendments had been removed as of Friday\'s draft bill, it is rumored that the amendments may have returned over the weekend.\nIf the problematic "Shaver Lake" provisions are removed from the bill, Assembly members may not hear much vocal public opposition from their constituents about rejecting the bill (although consumer groups are opposed and are trying to generate grass roots opposition).\nIf the Shaver Lake amendments remain, several Central Valley legislators may oppose the plan in committee.\nAssembly Speaker Bob Hertzberg supports this Edison deal, and the business community supports some recent amendments.\nThis likely mitigates concerns from other pro-business Democrats.\nWith or without the Shaver Lake provisions, Hertzberg should get at least 41 Democratic members (and probably a few more), but no more than 2 Republicans (if any) to vote Aye on the bill.\nHertzberg has more than enough votes to spare from his caucus - he needs 41 votes for the bill to pass, and there are 50 Democrats in his caucus.\nIf the vote is close, a personal plea from him and/or the Governor should enable him to get to 41.\nSenate  The bill would next move to the Senate for approval of the Assembly\'s amendments.\nThis is where the prognosticating gets difficult.\nSenate President pro Tem John Burton has said he does not support any amendments to SB 78xx.\nGov.\nDavis and Speaker Hertzberg will likely meet several times with Burton to try to cut a deal, but relations between Davis and Burton are currently frayed (due to a variety of factors), and Burton is not one to back down from a position unless there is something in it for him to change his position.\nThis would lead to one of four scenarios:  ?\nBurton refuses to have the bill heard in the Senate, and no Edison MOU bill is approved before Sept. 15th,  ?\nBurton agrees to let the bill be heard despite his opposition (this option is unlikely),  ?\nBurton comes to a deal with Davis and Hertzberg and brings the bill (as it is passed by the Assembly) for a         vote in the full Senate with his support, ?\nBurton comes to a deal with Davis and Hertzberg, but as part of the deal, he insists on changes in the bill - thereby sending it back to the Assembly for more amendments, and another vote in the Assembly - before a vote in the Senate.\nJohn Burton is considered one of the smartest, and certainly the cleverest politician in California state government today, so it is problematic to guess his next move.\nAdditionally, external factors play into the determination of which of these options will result.\nFor instance, the Governor may be willing to cut a deal with Burton on an unrelated issue that Burton cares more about resolving his way (e.g.\nworkers compensation benefits, drug courts, reapportionment).\nForetelling what will happen in the Senate is extremely difficult.\nBut Davis and Hertzberg will try to cut a deal with him, and given Burton\'s past actions, he may string them along, holding out for several days (maybe even until Sept. 14th) before he agrees to anything.\nGovernor  Assuming the bill escapes the Senate (and more deals may need to be cut to get enough votes) the Governor will almost certainly sign it, regardless of Edison\'s public position.\nThe bill will go into effect 90 days after the Governor signs it.\nConsumer groups have vowed to undo any "Edison bailout" enacted into law by way of the ballot box.\nThat could be either (1) an initiative to pass another bill overturning SB 78xx and replacing it with other provisions, or (2) a referendum to repeal SB 78xx, making it as if the bill was never passed at all.\nInitiative  Once drafted and submitted to the Attorney General, it takes 15 days to receive an official title and summary, and another 25 days if the AG determines that a fiscal estimate is necessary.\nAfter either the 15 or 40 days, the Attorney General sends it to the proponents, the Senate, the Assembly, and the Secretary of State.\nThe day it is mailed is called the Summary Date.\nThat is the day upon which all calculations are made.\nThe proponents are allowed a maximum of 150 days to circulate petitions and collect signatures.\nHowever, the initiative measure must qualify at least 131 days before the statewide election in which it is to be submitted to the voters.\nTherefore it is past the deadline to qualify for the next statewide election, on March 5, 2002 (statewide primaries), and so, could not qualify until the statewide general election on November 5, 2002.\nHowever the window is tight for that election, as well, and a proposal would need to be submitted to the Attorney General by the end of September 2001 to qualify for November 2002.\nThe legislature may conduct public hearings on the proposed initiative, but cannot amend it.\nSo whatever is submitted is what goes on the ballot.\nAn initiative requires the gathering of signatures equal to five percent of the total votes cast for Governor in the preceding gubernatorial election (419,260 signatures).\nThe ability to collect signature is heavily dependent on the amount of money the proponents have to pay signature gatherers.\nIt seems unlikely that the consumer groups will be able to raise that kind of money quickly, but Harvey Rosenfield of the Foundation for Taxpayer & Consumer Rights has been successful at placing pro-consumer initiatives on the ballot before, including Prop.\n9 in 1998, which sought to undo AB 1890 before the public understood its ramifications.\nReferendum  Referenda on the ballot are fairly rare in comparison to initiatives, although a successful referendum was on the March 7, 2000 ballot.\nPrior to that, the last four questions placed before the voters appeared on the June 1982 primary election ballot.\nAll four were defeated.\nSince 1912, there have been approximately 50 attempts to qualify referenda for the ballot.\nOf the 50 attempts, 39 qualified for the ballot, 26 of which prevented legislative statutes from taking effect.\nThe circulation calendar, verification, timing, and the form of petition have different requirements than initiatives.\nFor example, the California Constitution requires that the process must be completed within ninety days of the enactment of the bill that is being referred.\nThe signature requirements are the same for a referendum as an initiative statute, though.\nPolitical Dynamics  Notwithstanding the Governor\'s and Assembly Speaker\'s desire to enact an Edison rescue package, Senate President pro tem John Burton is in the driver\'s seat.\nIn fact, as noted above, there is a perception among some that it is the Governor who needs Burton and not the other way around.\nOne business source close to the negotiations believes Burton is not inclined to ask his members to make a second vote for an Edison bailout.\nIn fact, members of both houses are worried about being perceived as bailing out the hobbled utility, their reluctance fed by generators\' lobbyists who are sharing survey data that indicates voters blame the utilities for the energy mess and oppose any bailout.\nCurrently, due largely to this dynamic and others such as the Shaver Lake issue, there are not 41 votes for an Edison rescue in the Assembly.\nWe believe this will change as the Governor and the Speaker exert their influence, and the bill will pass the Assembly.\nAs difficult as it is to make predictions regarding the Assembly, the state Senate presents an even larger challenge.\nHowever, at this point it is our opinion that the odds of an Edison rescue package being approved by the state Senate are less than 50 percent.\n',
 'Hi Evening MBA students,  If you plan to graduate this semester for a December 2001 degree, will you  please come by the Evening MBA office soon (by Tuesday, September 25 at the  latest) and fill out an Application for Candidacy form?\nWe have your fall transcript to assist you in filling out the form.\nSince  we need your original signature, an office visit is best.\nThanks, congratulations, and see you!\n',
 "To Members of the Haas Community  Yesterday, October 17,  I had lunch in San Francisco with Tom Clausen,  former CEO of the Bank of America, and former President of the World Bank,  and a great fan and supporter of the Haas School.\nHe is the one of the  individuals behind the Bank of America's generous contributions to the Haas  community.\nHis personal gifts and gifts from the Bank of America  Foundation have financed the Bank of America forum, the Bank of America's  discretionary Dean's fund that supports new Haas programs; and the Clausen  Center that supports the International Business Development course and some  of Haas's most loved faculty including Andy Rose and Rich Lyons.\nWe had a  wonderful lunch during which he spoke affectionately of the loyalty and  talent of Haas alumni, the accomplishments of current Haas students, and  the future of business education.\nAfter lunch, as I drove back to the Berkeley campus with Larry Lollar--the\n",
 'Good morning Haas Community, Voice-mail is currently down campus wide.\nThe reason for this is not yet  known.\nI will continue to update you as I receive more information.\nPlease  call me with any concerns.\nTracy Curtis\n',
 "We finally got the website up with photos and tunes.\nHope you have a chance to check it out.\nIt is at www.truebluegrass.com.\nIf you don't wish to receive True Blue mail in the future, please just reply with that info and we'll do our best to see that doesn't happen again.\nThose of you who were at the Freight show last Sunday - thank you.\nYour support was greatly appreciated.\nThe turnout was great at our first Bay Area appearance, and we look forward to doing it again.\nOur next show in the vicinity will be in Davis in January - details to follow at a later date.\nThat's all for now!\n",
 'Attached for your information are the following two filings made at FERC on Monday on behalf of WPTF:   1..  Motion to Intervene and Protest of the Western Power Trading Forum.\nThis was filed in connection witht the ISO status report filing dealing with creditworthiness issues.\n2..  Motion to Intervene and Comments of the Western Power Trading Forum.\nThis was filed in connection with the Reliant and Mirant filing of a joint Section 206 complaint on October 18, 2001.\nMy thanks to those who responded to the drafts with comments and suggestions.\nDan\n',
 'I listed in on this afternoon\'s IEP call re: SCE\'s MOU.\nAccording to Smutney-Jones (who was more than average mad), SCE has reneged on the "pay 10% up front" portion of the deal they struck with SCE.\nAccording to IEP, SCE says that the banks, who are spooked by TURN\'s success in getting a 14-day temporary suspension of the CPUC-SCE settlement, is not interested in allowing SCE to pay any creditors like QFs preferentially.\nSCE said the 5.37 c/kWh commitment is still there, however.\nIEP\'s was also unsuccessful in getting the effective date of 5.37 c/kWh changed in return for the loss of the 10% up front.\nCCC/Jerry Bloom, who represents gas-fired QFs is seperately negotiating with SCE and may be willing to give up 10% in return for commiting to 5.37c/kwh outside of the CPUC.\n(They are concerned with CPUC overturning the IEP-SCE "deal.")\nSeveral parties on the call, including CalEnergy, indicated they may sue SCE outside the CPUC over reneging on this deal.\nAlan Comnes\n',
 'Hello All -- With all the uncertainty this has been a difficult project to concentrate on, however, here is a first stab at establishing criteria for evaluating the prospects for retail service state-by-state, and by major LDC.\nSome of these criteria may be consolidated or eliminated as the matrix progresses.\nI have differentiated between transportation (C&I customers can receive distribution service separate from commodity) as opposed to Customer Choice whereby C&I and Residential customers may have alternative service choices.\nPLEASE LOOK OVER THE MATRIX  with an eye towards changes.\nNothing is set in stone and the simpler and more relevant we make it the better the product.\nThanks all.\n',
 "Today, we announced plans to merge with Dynegy, a major player in the energy marketplace and one of our largest counterparties.\nDynegy is a great company with businesses very similar to our own.\nWe believe merging with Dynegy is the best option to preserve our core businesses that you've worked so hard to build.\nFollowing are the major components of the transaction.\nDeal Terms\n",
 "Hola - lets meet up for lunch at Yank Sing at the  Rincon next Friday.\nA nice long hour and a half  starting at 12:00.\nNow, do you even remember  the last time you did that?\nHit reply and let me know - I'll get us a table.\nYum- I can taste those dumplings already...\nCheers & have a great weekend!\n",
 'Per the attached document, Angela Lewis, a representative from The Japan Partnership, an international executive search firm, will be in the area at 5pm on Sunday, October 7th and is interested in meeting with native Japanese graduating Haas students to discuss career opportunities in Japan.\nIf you are interested in attending this presentation, please respond back to me right away.\nThe volume of responses will determine whether the event will take place or not.\nIt is scheduled to take place in the Faculty Club.\nRegards,\n',
 'Jeff,  Your subscription to California Energy Markets will expire December 21, 2001.\nPlease let me know if you are interested in renewing for the year 2002.\nIf you are interested in renewing please include the following information:  \tDelivery Address (email for online or street for print copy) \tOffice Location (City) \tCompany Number \tCost Center Number\n',
 'You may recall that the last summary included SCE advice letter 1586-E.\nThis was the advice filing that seeksto implement a number of the regulatory components included in the October 2, 2001 Settlement Agreement between the CPUC and SCE.\nThe summary noted that Edison asked for comments to be due on November 28.\nThat request has been denied (see the attached letter), and comments are instead due on December 4.\nHappy Thanksgiving, everyone!\nDan\n',
 "Haas students:  We all know that recruiting is going to be a challenge this year and utilizing all available resources will heighten our chances for success.\nHaas students bring a wealth of contacts to the program and we in the Career Center want to be sure to tap into it to benefit your fellow classmates.\nIf you have a contact that you think would be interested in hearing about the ways that a company can connect with Haas students through either formal or informal recruiting events (on-campus presentations and interviews, job fairs, job postings, student club firm nights, etc.\n), please send us the person's contact info.\nIt might be a hiring manager you worked with or for.\nIt might be someone within the company's human resources department that has not interacted with Haas.\nIt might be a personal contact that has a small business looking for that one key person.\nRegardless, we would appreciate the opportunity to pursue the potential recruiting contact.\nPlease provide the following if available:  Contact name, company, title, phone number, email address, any additional recruiting-related info (type of position (s)he may be interested in recruiting MBA's for, past Haas/MBA hiring, etc.)\nDepending on which industry your contact is in, please email your response to the appropriate account manager as follows:  Rich Wong - technology and entertainment/media - rwong@haas.berkeley.edu Jenny Rowe - consulting, consumer products, healthcare/biotech/medical devices, education, not-for-profit - rowe@haas.berkeley.edu Mark Friedfeld - finance/investment banking, real estate - friedfel@haas.berkeley.edu  On behalf of your Haas schoolmates, thanks for any leads you can provide.\nRegards,\n",
 "Good Evening Committee Members:  Just to keep you apprised, we have planned for a special discussion of the second extraordinary legislative session with Dr. Barbara Barkovich and Derek Naten at tomorrow's committee meeting.\nAs noted before, we are hoping to hear from Kip Lipper in Senator Sher's office at our October 17 Committee Meeting.\nWe will keep you updated in this regard.\n*Please note, our October 3 meeting has been cancelled.\nThe SVMG Annual Planning Conference will be held this year on October 2 and 3 in Half Moon Bay.\nOur Energy Director and Committee Chairs will be participating in this conference.\nThanks.\n",
 "Comrades:   Diane is leaving us, alas, and no amount of begging, pleading, cajolery, whining, bribery or blackmail seems to have dissuaded her from her resolve to go.\nLike so many weeping children, handerchiefs waving in between noseblows and dabbing of eyes, shamelessly clinging to her skirts, we would all go to bid her farewell at the airport, but we dare not lest airport security be thrown into a tizzy by such a demonstration.\nTherefore, we have decided to bid her farewell in a more seemly fashion, in the privacy of our own campus, where we may emote extravagantly without undue and embarassing scrutiny from the outside world.\nThe EMBA office, as frugal as they normally are, along with the Evening MBA Association (your government in action working for YOU) are jointly sponsoring a little whingding where we may laugh through our tears in celebration of Diane's wonderful years and grand successes at Haas, and send her off to Colorado with lots of hugs and kisses.\nTHURSDAY, the 27th  WELLS FARGO ROOM  7:30 until whenever  (tell your professor there are more important things than positive NPV projects)  and, yes, food and drink are provided so that you won't faint in the second half of class from lack of nourishment.\n",
 "Hello Jeff,  We're winding down a large project , about two more weeks, and preping to begin another, but we should have a small window of opportunity to get to your project, if you're still interested in having us do the work.\nSo we need to meet or I need more info from you to get a good idea of exactly what you want.\nPlease let me know.\nThank you!\n",
 'CONFIDENTIAL ATTORNEY CLIENT COMMUNICATION  I\'d like to get some thoughts on this issue and hopefully build a consensus pretty quickly.\nWe are in the process of extending the term of some of our existing CA deals that we executed on the Master in June.\nUnderstanding that "new" deals struck after 9/20 are, and extensions of existing deals may be, at risk, it seems to me we have three basic options in order to effect this extension, and I want to make sure we evaluate and choose the one that minimizes the risk that the extension is invalidated.\nNote that DASR\'s have been submitted for the subject accounts under the original Transactions.\nThe 3 choices I see are:  1.\n.Amend and Restate the existing Transaction Confirmation to add the extension and new price for the extension.\nIn this case, the extension would be wrapped up on one document that is signed after 9/20 but effective in June.\n2.\nSimply amend the existing Transaction to add extended term and price.\nThis would be a separate document.\n3.\nExecute a whole new Transaction for the extended term, which would be effective when signed but the services and price under which would not start until after the expiration of the existing Transaction.\nThe existing Transaction would stay in tact as written.\nIt seems to me that choice number 3 is the safest overall.\nThe amended and restated route has appeal because the whole transaction is dated back to June.\nHowever, if a regulator were to peel it back, the conclusion could be that the deal was struck after Sept 20 and therefore the whole transaction was invalid, including the original structure.\nI think that choice 2, though creating a separate document for the extension, could fall into the same trap.\nIn that sense, choice 3 seems safest because arguably the original transaction is not at risk.\nIf the extension is invalidated, that determination would likely not claw back to the original deal.\nThe commercial teams want to close these extensions in Q3 so they are moving fast.\nPlease let me know your thoughts asap.\nIf we need to have a quick call, I can set something up.\nThanks.\nMDS\n',
 'September 5, 2001 Business World Crisis?\nWhat Crisis?\nBy HOLMAN W. JENKINS, JR.\nThe big news this summer is that Californians haven\'t been reduced to stone-age lifestyles, running naked in the streets and eating each other.\nThe state barely had enough electricity to get through this past winter, when demand was not yet pumped up with air-conditioning.\nYet here they are surviving the summer with nary a blackout.\nGov.\nGray Davis must be some kind of a wizard, pulling 15,000 megawatts from his pointy hat.\nHe gave every indication of being a hapless cluck, but obviously we underestimated him.\nNaah.\nCalifornia\'s summer of surplus demonstrates just how flukey last winter\'s rolling blackouts were.\nPower there was aplenty (or at least enough to get by).\nWhat there wasn\'t was anybody to pay for it, thanks to the political system\'s paralysis as the state\'s private utilities ran out of cash and used up their credit trying to keep the lights on.\nWe won\'t rehearse the central pinion of this catastrophe, a "deregulation" plan that created scarcity pricing in the absence of true scarcity.\nA tweak here and there as late as last fall could have saved the state\'s taxpayers and ratepayers literally billions of dollars at no real cost to anybody.\nInstead, the utilities were allowed simply to run out of money, accumulating $14 billion in unpayable IOUs to generators.\nNow, most of us tend to think of power plants as giant coal or nuclear operations that run 24 hours a day, supplying "baseload" power.\nBut the majority of plants are part-timers, firing up to meet intermediate and peak demand.\nRevving up their turbines means incurring fuel, labor and maintenance costs, which means operators like to get paid.\nThe crisis months saw three distinct waves of blackouts, each related to plants dropping off line simply because they feared not getting paid.\nIn January, it was British Columbia Hydro, the big, government-owned operator of Canadian dams, which had kept California afloat on credit for months.\nIn March it was dozens of small California generators, known as "qualifying facilities," which no longer could meet their own fuel and labor bills because they weren\'t getting paid by their utility customers.\nIn July, it was the federal government imposing impenetrably complex price controls across the West, making it impossible for generators to know what price they were allowed to charge.\nSome shut down rather than take a chance, and since the federal intervention meant the entire region was on the griddle for California\'s mismanagement, the blackouts just happened to land in Nevada.\nThere was no shortage, in other words, no "energy crisis."\nThere was only the unaddressed credit problems of the utilities.\nWe opined in January that Californians would be surprised at how quickly power prices return to normal.\nYup.\nThe state threw open the treasury to pay for the power the utilities could no longer afford and suddenly sellers were everywhere and prices fell.\nIn the teeth of peak air-conditioning season, electricity prices are now back to normal.\nIn retrospect, what\'s amazing is that so many plants not only kept operating month after month despite being stiffed by the state, but produced 62% more power than they had the year before to keep California lit.\nYet they\'ve gotten nothing but abuse from the governor, who is still turning over every legal stone to try to avoid paying the IOUs.\nThere is no question that Western supplies were tighter than usual thanks to low water levels in Northwest river systems.\nBut the evidence shows that Western markets were flexible enough to accommodate the glitches.\nAll they needed was a creditworthy customer to deal with.\n',
 'For questions or comments regarding this report please contact G. Britt Whitman at ex:5-4014 or Kristin Walsh at ex:3-9510.\nEXECUTIVE SUMMRAY ?\nCPUC Settles Filed Rate Doctrine Case with SoCal ?\nCPUC Kills DWR Rate Agreement, Davis May Reconsider Old Senate Bill     CPUC - SoCal Suit In a closed hearing today, the California Public Utilities Commission voted 5-0 to settle its filed rate doctrine case with SoCal Edison.\nThe implications could save SoCal from an otherwise immanent bankruptcy, though bankruptcy remains a real threat.\nUnder the agreement, the CPUC has stipulated the following points, which have not yet been formalized by Administrative Law Judge, Ronald Lew:  ?\nThe CPUC agrees to maintain a level of rates necessary for SoCal to pay off under-collect through 2003.  ?\nAll surplus revenue (revenue above O & M) generated from any source must be applied to SoCal\'s back debt.\n?\nSoCal agrees to pay no dividends on its common stock from now until 2003, or until all back debt has been recovered.\nIf SoCal\'s debt has not been recovered by 2003, the CPUC will extend appropriate rates levels necessary for SoCal to recover its debt through 2004.  Dividend payouts on SoCal common stock will be subject to CPUC approval during this extension.\n?\n100% of any revenue SoCal receives/generates from FERC/generator refunds will be applied to SoCal\'s debt.\n?\nOnce SoCal\'s back debt has been recovered, any surplus revenue generated from the CPUC rate hikes will be refunded to ratepayers.\nCPUC - DWR Rate Agreement The fact that the PUC voted down the DWR rate agreement (by a 4-1 margin) puts Governor Davis and Treasurer Angelides in a very awkward position.\nThis leaves Senator Burton\'s bill, SB 18XX, as the vehicle that sets to payment path for the revenue bonds to repay the General Fund.\nHowever, as late as this morning, Governor Davis vowed (through his spokesman) that SB 18XX was "dead on arrival" and would be vetoed.\nThis move by the PUC puts pressure on Davis to sign SB 18XX in order to protect the bonds and the long-term power contacts he has negotiated.\nHowever, 18XX violates the terms of a number of the long-term power contacts negotiated by the governor earlier this year.\nFor example:   ?\nSB 18XX splits the revenue streams for payment of the General Fund\'s revenue bonds and payment to the DWR for power.\nIt clarifies the funds that will go to repay the General Fund, but is much less clear on the funds to pay the DWR for power.\nSB 18XX leaves the long-term contracts signed by the governor open to review and renegotiation - something that the governor remains publicly unwilling to do.\n?\nSB 18XX also violates the terms of the bridge loan the state negotiated with Shearson Lehman earlier this year.\nThe terms of the bridge loan explicitly state that if 18XX is passed, the banks can accelerate the loan or impose penalty terms of interest on the state.\nThese terms were suggested by the governor as a means of forcing the legislature to support his DWR rate agreement rather than Burton\'s.\nOf course, this effort failed when the legislature easily passed SB 18XX.\nToday\'s PUC action further complicates the situation.\nWhile on the surface this would seem to force the governor\'s hand into signing SB 18XX, that may not, in fact, happen.\nIt would not be out of character for the governor to instead veto SB 18XX, then force either the legislature or the PUC to "play ball" with him in order to repay the General Fund.\nThus, another leverage point has been created.\nWe will continue to monitor the situation to attempt to determine the likelihood of Davis signing or vetoing SB 18XX.\n',
 "Hi, I wanted to let you know that the CADER's DG conference on November 1-2, 2001 in San Diego, will be held as scheduled.\nPlease disregard this message if you have already registered for the conference.\nIf not, I have some good news.\nI am aware of the difficulties in planning your trip and hence, we have extended the early-bird registration until October 15th for your convenience.\nHowever, the group rate at the Hotel will expire on October 8th.\nSo please hurry and make your reservation for the Hotel room.\nThe revised program is posted on the www.cader.org .\nSponsorship has been very good and we have just a couple of exhibit spots left if you are still interested.\nAlso, the attendance is picking up well.\nWe are now already up to 200 attendees.\nSo please hurry and get your registration in at the earliest opportune time.\nFrankly, your early registration will help me immensely in planning and coordinating the conference.\nJoin us for 2  days of comprehensive discussions, questions and answers - your input is essential for a successful DG market.\nThanks, and do not hesitate to call me if you have any questions.\nJairam.\n",
 'You are cordially invited to:  The Fourth Annual Peterson Ethics Lecture Featuring: William Drayton Founder of Ashoka, an organization that supports social entrepreneurship  This Friday, October 12, 4:00 pm, Wells Fargo Room Haas School of Business   About William Drayton: Drayton founded Ashoka in 1980 to use a venture capital model to support  social entrepreneurs, described by Ashoka as practical visionaries who are  committed to social change.\nThe primary activity of the organization is  identifying social entrepreneurs around the globe as candidates for Ashoka  Fellowships, which provide both financial and professional support.\nTo be  chosen, each prospective fellow goes through a rigorous search and  selection process.\nFellows receive a living stipend (typically for three years) and they join  the Global Fellowship -- a worldwide network of social entrepreneurs.\nThis\n',
 'You have received this message because someone has attempted to send you an e-mail from outside of Enron with an attachment type that Enron does not allow into our messaging environment.\nYour e-mail has been quarantined and is being held at the MailSweeper server.\nSender:  sloggans@ahmassoc.com\n',
 'Jeff- Hey there!\nWill you please moderate a panel for me at the CESG Annual Retreat?\nBelow are the details.\nJust let me know.\nThanks,\n',
 'Please look at the "box lunch menu\'s" at the bottom of this e:mail and let me know if you would like me to order you anything for lunch on Friday, November 9.\nThe meeting will be ending at 12:00 (noon) and some will be rushing to catch flights and might not have time for lunch.\nMy original plan was to order box lunches for everyone, but I thought some of you may not be in a rush and have an interest in dining out.\nSo, please let me know either way what you chose to do.\nThanks!\n',
 "Folks- It is October 19th and we have only received registration for our annual retreat from SIX of you.\nA simple plea from us gals.....PLEASE GET YOUR REGISTRATION IN TO US AND MAKE YOUR RESERVATIONS AT VILLAGIO AS SOON AS POSSIBLE.\nThe deadline for registration is OCTOBER 31, 2001!!!!!\nWe have attached a more updated agenda for your review.\nWe are still working on panelists but we have confirmed CPUC President Loretta Lynch as the keynote speaker for Wednesday night's opening reception.\nLastly, we have attached the registration packet again in case your desk ate it.\nThanks for your continued cooperation.\nGive us a call or send us an email with any questions.\nThanks,\n",
 "On Friday (October 19), DWR released a revised revenue requirement.\nThe result was to lower the Customer Revenue Requirement by$2.4 billion from the revenue requirement submitted on August 7th.\nThe stated reasons for the change are:  1.\nReduction in Gas Prices.\nFor example, the August estimate included a fourth quarter 2001 gas price forecast of $7.68 at the Southern California border.\nIn the recent submittal, this was reduced to $3.54.\n2.\nChange in Load because of Direct Access.\nAs a result of the Commission delaying the suspension date from July 1 to September 20th there was a significant bump up in DA load, thus reducing the load fo which DWR must buy.\nFor example, the August submittal contained an estimate of 448 GWh in the fourth quarter 2001 for direct access load.\nThe October 19th submittal factored in a direct access load of 6,571 Gwh for fourth quarter 2001.\n3.\nChanges in Forecast due to DSM.\nDWR has decided not to engage in any demand side and demand bidding programs and has deferred decision on whether to reinstitute the 20/20 program next summer.\nThe result of these decisions was a decrease of $513 million in the revenue requirement, while also increasing the load that DWR must buy for by 1896 Gwhs.\n4.\nChanges to Contracted for Power.\nAn additional 156 MW (which is expected to be available to meet summer 2002 peak) has been contracted for since the August 7th submittal.\n5.\nAdjustments to the calculations of ancillary services costs.\n6.\nChanges in Debt Dervices Costs.\nFor example, on October 11 (the day after the Commission rejected the rate agreement), the interest rate on the interim financing went up from .75% to  2.75%.\n7.\nChanges in Receipt of Funds from UDCs.\nUntil the rate agreement between the Commission and DWR is approved, the UDCs have been withholding on the remittance of DWR's share the revenue receive from the sales of the UDCs own volumes.\nIf any one would like a copy of DWR's entire submittal, let me know.\nJeanne Bennett\n",
 'Wanna sign onto this letter to Loretta?\nAny suggestions?\nWe could make it a CEA thing.\n(I am copying Jeff D. as a courtesy...I think we need this to be just a customer deal).\nDot 498-3319\n',
 'Jeff, received your message for a Tues AM meeting in Sacramento...\nI can make that.\nAlso, I will try to see SMUD while I am there and plan on seeing PG& E back in the city.\nAny word from SOCALED.\nGive me a call this a.m. and we can figure out travel plans.\nBT\n',
 'Order #  013307830292   Dear Jeffrey Dasovich,  Thank you for shopping with Williams-Sonoma.\nPlease see below for the shipping status of each item in your order.\nShip to Name & Address:  Jeffrey Dasovich 101 California St. Suite 1950  (For privacy reasons, the city, state and zip code have been omitted.)\nItem Description                     Item #       Qty      Price  Status        Ship Date    Heirloom Tomato Bowls S/5            83-4006151    1      $49.00  Shipped       11/28/01     FedEx  Tracking Number: 9611804058372116469499\n',
 'I like it.\nGive it one final read through for final refinements.\nThen send  to bay guardian, sf weekly, pacific sun (marin), (and the east bay has a  weekly mag, too, the name of which escapes me--might be out of berkeley).\n',
 'Well, he launched today.\nHave you seen the materials from the press  conference that he launched today?\nI think this is actually a good  thing--makes our proposal look like a much more preferable alternative by\n',
 'Calif DWR Seen Asking PUC To Order 25% Rate Increase Fri By Jason Leopold  07/13/2001 Dow Jones Energy Service (Copyright (c) 2001, Dow Jones & Company, Inc.)  Of DOW JONES NEWSWIRES (This article was originally published earlier Friday.)\nLOS ANGELES -(Dow Jones)- The California Department of Water Resources, the agency purchasing a bulk of the state\'s power needs in lieu of the three investor-owned utilities, is expected to tell state regulators Friday that they need to increase electricity rates by as much as 25%.\nThis is because there are insufficient funds in the current revenue stream to cover a $13.4 billion bond sale, three commissioners with the Public Utilities Commission told Dow Jones Newswires late Thursday.\nPUC President Loretta Lynch is expected to issue a draft decision Friday either endorsing the rate hike request or calling for an audit of the DWR\'s current revenue stream before she makes a decision, aides in her office said.\nIf the PUC determines that there are not enough funds in the current rate structure to cover the bond sale, it will have no choice but to order the rate increase, according to the legislation that put the state in the power buying business.\nBusinesses are expected to bear most of the burden of the rate increase, the second in just two months, if approved by the PUC, the commissioners said.\n"Back in May when we ordered the first rate increase, we said we may be forced to do it again by the summer," one commissioner said.\n"It\'s unfortunate, but it shouldn\'t be a shock to anyone.\nThe state has made an enormous commitment to Wall Street that rates would go up whenever it\'s needed to ensure there is enough money to pay off those bonds."\nLynch and a spokesman for the DWR were unavailable for comment late Thursday.\nSeparately, Assembly Speaker Pro Tem Fred Keeley, D-Boulder Creek, has drafted a proposal expected to be introduced into the Assembly Friday or Saturday that would have large businesses using the most electricity to finance the bulk of the $43 billion in long-term power supply contracts, aides in his office said.\nMoreover, Keeley\'s plan is aimed at reducing rates for consumers who use the least amount of power.\nDetails of the plan are still sketchy, aides said.\nPossible Rate Hike To Generate $2.5B Yearly For State  The 50% rate increase ordered in May is expected to generate $5 billion annually, and if the PUC orders a 25% increase, that is expected to generate $2.5 billion.\nHowever, it is still unclear if that is enough, the commissioners said.\nBusinesses are expected to bear most of the burden of the rate increase, the second in four months, if approved by the PUC, the three commissioners said.\nSince January, the state has spent nearly $8.5 billion buying electricity on behalf of customers of Edison International (EIX) unit Southern California Edison, Sempra Energy (SRE) unit San Diego Gas & Electric and PG&E Corp. (PCG) unit Pacific Gas & Electric.\nThe state has borrowed more than $7 billion from its general fund, which must be repaid by ratepayers at 6% interest, to purchase power.\nIn addition, the state has locked itself into $43 billion in long-term power supply contracts at high prices for as much as 20 years to ensure there is enough power to meet demand.\nFuture rate increases to finance the contracts are likely, state officials have said.\nBut if the PUC orders another rate increase, the money won\'t benefit the utilities, which have billions of dollars in power costs to recover.\nInstead, it will be used to guarantee Wall Street financial institutions that there is sufficient funds in the rate structure to allow $13.4 billion in revenue bonds to be sold.\nThe bonds are expected to be sold in August or September, said state Treasurer Phil Angelides.\nThe commissioners said the PUC and the DWR waited to address another rate hike to see if state officials and generators were successful in coming to terms on $8.9 billion the state says it was overcharged for power since last year.\nAfter two weeks of hearings between generators and a delegation of California utility executives and energy officials, talks broke down Monday.\nGenerators offered the state $716 million in refunds, but Gov.\nGray Davis balked, threatening to sue to recover the full $8.9 billion.\nAny refunds would have been disbursed to the utilities and the DWR, which could have deferred the need for any rate increase, according to Steve Maviglio, press secretary to Davis.\nAn administrative law judge with the Federal Energy Regulatory Commission said Thursday he will recommend that the commission not order cash refunds to California because the state\'s utilities owe far more money to the generators than what he thinks the state is owed.\n',
 'Having failed to resolve either the budget or the energy issues, the  Legislature is likely to postpone its recess and work through the weekend, at  a minimum.\nIn sum, though many claim that the Legislature will "vote for something," it  still doesn\'t appear that the "something" will include a measure that will  keep Edison out of bankruptcy.\nThe Senate and Assembly remain extremely far apart in their approaches to  amending the Governor\'s original MOU (which is dead).\nThe ranks of politicians that view bankruptcy as the best alternative is  growing.\nIn the Senate: SB18XX---Bill to de-link the bonds from the DWR Contracts\n',
 "The Assembly passed the budget late last night.\nThe Assembly recessed without passing out any energy bill.\nThere is some talk of a working group being convened beginning next week  comprised of Legislative staff and industry to continue to try to work out a  deal.\nFor now, however, the free world is safe from the CA Assembly and the  Senate--they've left and all Legislative activity is on hold until the 20th\n",
 "Well sometime between 11 PM last night and this morning, my computer died.\nHowever, I will nonetheless get a draft of the letter out today for  discussion on tomorrow's call.\nGiven the glitch, it will likely be out by  COB today.\nApologies for the delay.\nBest,\n",
 "Hi Gavin:  Could you do me a favor (know you're busy).\nSomeone told me that there's an  article in last Thursday's?\nNYT blaming the California fiasco on former  California Commissioner Dan Fessler, who was responsible (a few years back)  for putting in place the structure we have here.\nHave you seen it?\nIf so  could you forward?\nIf not, could you try and find it and forward.\nVery much  appreciated.\nBest,\n",
 "Well, you two really raised the bar with that celebration.\nIt was just  fantastic.\nPrentice said it's the best birthday she's ever had.\nThanks so  much for everything.\nIt was really neat.\n",
 'For today\'s noon call.\nwhen you open, answer "disable macros" to first  prompt, and "no" to question about links.\nthere are three portfolio  scenarios that i\'d be happy to discuss very quickly during the call.\n',
 'FYI.\nUnder the settlement with SoCal, PG&E and countless others, Altra was  going to provide the platform for the (unregulated) secondary markets in  intrastate storage, capacity and imbalance trading rights.\nAltra declined  and SoCal and PG&E will now look for someone else to provide the service.\n',
 "The Hearings The hearings have transitioned to the more traditional, courtroom-like  environment, with lawyers engaged in detailed cross-examination of utility  witnesses.\nThe hearing focused solely on the utility claims of financial hardship.\nThe hearings went from 9AM-5PM and only managed to make it through two PG&E  witnesses--extensive, detailed questions on PG&E's cash management practices\n",
 "Hi Sue:  A very happy new year to you.\nMr Kean has had me underwater since last  Thursday night, but I'll resurface tomorrow, at which time we can catch up on  a number of things, including bills.\nBut I wanted to forward along Steve's  memo that we discussed just prior to Xmas.\nHope you had a great holiday and  that all is well.\nBest,\n",
 'The Commission voted out the order 5-0, essentially as it appeared  yesterday.\nThree key changes: They clarified that the surcharge applies to Direct Access customers (but the  entire "rate freeze" structure remains intact for now).\nThe Commission reversed itself and chose not to adopt TURN\'s "netting out" of  gen revenues and CTC collections, and said instead that the Commission will  consider it as an option in the next phase (a move likely made in order to  lower chances of a successful utility appeal).\nThe Commission added to the decision language saying that it will study the  pros/cons of securitizating the utilities\' power purchase costs.\nThey will  submit a report on the issue to the Governor and Legislature.\nOn this last point, wire reports are rampant about the possibility that  legislation will be introduced as early as today proposing to securitize the  utilties\' power purchase costs.\nThis action has reportedly been the result  of discussions that occured through the night between the governor\'s office,  the utilities and the ratings agencies in reponse to the fact that the  decision issued by the PUC falls well short of what\'s needed to keep the IOUs  credit worthy and solvent.\nAs a result of those wires stories, the  utilities\' stock has come back (Edison was down as low as 6.25 and is  currently at 10 7/8; PG&E was at 8 7/8 and is currently at 11 7/8).\nWe\'re  working with Sandi McCubbin, who heads-up our legislative activities in  California, to get more info and will report back.\nThe hearing was dominated by highly charged anti-generator, anti-marketer  rhetoric, which is likely to play a prominent role in the press accounts.\nOnly FERC was demonized more.\nEach of the Commissioners, including the most recent "interim" appointee,   made strong statements regarding the undesirability of utility bankruptcy.\nThe Commission left open the possibility of "doing more" at their next  meeting (two weeks from today), which means the negotiations with the  utilities and ratings agencies are likely to continue.\nAnd if an agreement is  reached, it could end up on the next agenda.\n',
 'Tyson has had conversations with the Governor\'s office.\nThe Governor\'s office wants more information about what the meeting would  "look like"/attendees, and has said that the idea sounds like one worth  pursuing (but as we know, talk is very cheap with this Governor).\nIn response, Tyson and her very able helper are taking the 1.5-pager that I  sent around and modifying it to describe the meeting  optics/logistics/attendee attributes, etc.\nThey will forward it to me as soon as they\'ve got it drafted.\nTyson hopes the document will seal the deal on the Governor\'s participation.\nIn the meantime, Tyson is trading calls with Doer and trying to line up other  business face cards to assist in getting the business community to the  table.\nAny help/suggestions we can offer gathering up business folks would  be useful, but seems that Tyson\'s going to have to carry that water.\nTyson said based on her conversations with Summers, he\'s squarely on board.\n',
 "Greetings: My apologies.\nI was out of town over the weekend and while I thought I'd  have network access, I didn't.\nHere's the presentation from the talk I gave  in New York on 01.29.01.\nI'll be updating it, but will work from these  slides (as notes--no formal presentation).\n",
 'Greetings Catherine and Roger:  A PUC staffer has called our outside lawyer saying that a high school in  Ontario, CA called to complain that we\'re turning back the school for credit  issues.\nThe staffer says that "a hospital might also be involved."\nCan you  provide any more information?\nThe PUC staffer does not seem to have much  information, but has nonetheless seems inclined to write us a letter asking  us to explain.\nSort of ironic:  PUC Commissioner Woods states that his goal is to drive all  ESPs from the state, the Legislature passes and the Governor signs a bill  prohibiting Direct Access, and now the PUC is concerned that California might  actually be succeeding in its efforts to kill choice.\n(The PUC is  particularly concerned since they recently passed an order prohibiting gas  customers from returning to the LDC---ironic indeed)\n',
 'Just got a call from a fellow named Jame Edgerly at the Enterprise Zone,  Inc.\nHe told me that Ken Lay (through Ken\'s secretary Vanessa) referred me  to him.\nHe is very interested in getting us to help him work with the  Legislature to establish an "Enterprise Zone" energy tariff to encourage  investment in California\'s Enterprice Zones.\nBefore I launch on the effort,  just wanted to check in and see if this rings a bell with you.\nThanks.\nBest,\n',
 'Enron to cut one-fifth of jobs at broadband unit.\n04/06/2001 Reuters English News Service  (C) Reuters Limited 2001.\nHOUSTON, April 6 (Reuters) - Energy trading giant Enron Corp. said on Friday  it will eliminate some 250, or roughly 20 percent, of the jobs at its  broadband telecommunications unit, detailing a move which it has previously  described as an internal redeployment of staff.\nEnron Broadband Services spokeswoman Kelly Kimberly said the company is  cutting jobs at the unit, which now employs 1,150 people, because it has  completed the build-out of its 18,000-mile (29,000 km) fiber-optic network  and because of slow demand for streaming media products delivered to personal  computers.\n"The network is substantially complete now, so that means fewer people are  required for technical positions," she said.\nThe job cuts also reflect Enron Broadband\'s decision to play a less active  role in the market for streaming media services, such as video of corporate  events delivered to personal computers, where demand had been slower than  expected, she said.\nHowever, Kimberly said Enron Broadband will continue to pursue  entertainment-on-demand services actively.\nKimberly said employees whose jobs are being eliminated will be eligible for  redeployment to other positions at Enron Broadband Services or other Enron  units, although there could be some involuntary terminations.\nPreviously Enron officials had dismissed rumors about job cuts at Enron  Broadband Services and had spoken instead of an internal redeployment of  staff within the unit without detailing its impact on overall employment  there.\nThe company\'s stock, which peaked at just above $90 last year and was trading  in the $80s as recently as mid-February, has recently fallen into the $50s in  line with broader weakness in the stock market and among technology and  telecommunications stocks in particular.\nOn Friday it was up 95 cents at  $56.65.\nSince early last year Enron has been building a high-speed broadband  communications network that it plans to use as a base to build a bandwidth  marketing and trading business similar to its huge natural gas and  electricity trading operation.\nExcitement among investors about the broadband business and about Enron\'s  success in developing a strong Internet-based trading platform for energy and  other commodities drove an 87 percent rise in the company\'s share price last  year, outpacing a gain of 54 percent for the S&P utilities index.\nKimberly said Enron\'s bandwidth trading operation is continuing to perform  strongly, with more than 500 trades carried out in the first quarter,  exceeding the total for all of 2000.\nDespite the jobs cuts at Enron Broadband, she said, the unit is recruiting to  fill some other positions.\n',
 'Greetings Diane:  Could you check the work phone for Joseph Brophy.\nI\'ve got 408.390.5291 on  my list of admitees to call and I\'m getting the "not a valid number"  recording.\nThanks a bunch.\nBest,\n',
 "CLFP proposes the following changes to medium and large commercial and industrial customer tariffs for electric service provided by Pacific Gas and Electric Company and Southern California Edison Company.\nCLFP proposes the Commission establish an optional summer on-peak, peak period consisting of a continuous 3-hour period during the current summer on-peak period for both utilities.\nThe 3-hour period would be selected by the customer.\nSpecifically:   Service Eligibility:  Customers served as medium or large commercial/industrial customers on time-of-use rates and metered accordingly.\nExamples - PG&E's E-19, E-20, etc.\nand SCE's TOU-8, etc.\nCustomer Eligibility:  Electric customers processing, handling, distributing or processing perishable food and agriculture products.\n(As noted below, since no revenue shift occurs within the class, the Commission may consider opening the option to others.)\nCustomer Charge Surcharge:  A surcharge of $130 per meter per month for the initial summer period (2001) to offset the utilities cost for changes to billing procedures.\nIn the case of optimal billing period service customers the surcharge shall correspond with such billing period.\nOptional Summer On-Peak Period:  Any continuous 3-hour period during the summer-on-peak period of time.\nHours may be designated by the customer consistent with metering capabilities of the customer or changes to metering capability.\nThe reason for designation by the food processor or agriculture commodity processing customer is in order to take into account the many factors involved in load shedding.\nLabor, harvesting schedules and coordination with growers, delivery schedules, inspection activity, etc.\nAll bear upon such an effort.\nRate for Optional Summer-On-Peak Period Service:  Energy rates for the 3-hour period would be two times the otherwise applicable charge for summer-on-peak energy.\nThe other 3 hours of the 6-hour on-peak period would be billed at the non-peak rate and equalized for rate/revenue neutrality.\nIn the event partial peak periods are retained, the rate for the non-optioned 3-hour period during the on-peak period would be adjusted to retain revenue neutrality.\nThese rates would apply, as now, workdays of Monday - Friday.\nNotice and Service:  An eligible customer must notify the utility in writing, by fax, email, or hand delivered, to both the appropriate account representative and the customer billing department of the request for optional summer-on-peak period service.\nThe 3-hour period of optional service and the start date for such service shall be specified.\nStart dates should coincide with billing cycles, with a minimum of seven days notice prior to such cycle.\nOptional optimal billing period customers would be treated accordingly, except as currently provided, a two-day advance notice.\nImplementation Issues - TOU Meters and Billing.\nIt appears the number of customer meters and billing changes potentially required by optional summer on-peak period service is relatively small compared to the total number of meters of the utilities.\nIn response to CLFP's data request by PG&E and SCE (attached) the following is observed.\nFor SCE, SIC 20 (food and kindred products) customers account for approximately 163 meters out of about 10,000 meters.\nOf the 163, all but 8 can be managed locally by the Customer Data Acquisition System.\nThe 8 would appear to require a field visit.\nFor PG&E, out of 11,675 TOU meters on E-19 and E-20 service, 354 or 3% of the total are SIC 20.\nOf the 354 nearly half, 175, are hourly interval meters.\nThe remaining 179 presumably would need a field visit for reprogramming.\nConclusion:  Based upon the data supplied, metering and billing changes required by an optional summer on-peak period program for processors of perishable commodities, there does not seem, in CLFP's opinion, to be a significant barrier to establishing the program.\n",
 'Greetings Professor:  Apologies for asking, but something has come up and I wanted to inquire about  the chances of taking the E203 final on a day other than Sunday the 10th of  December.\nPreferably Tu, W, Th, the week of the 11th.\nBest,\n',
 'Last week, I distributed a presentation that the Brattle Group gave before  the California Inquisition (i.e., legislative gas oversight committee looking  into the gas price spikes at the Cal border).\nThe Brattle Group is a consulting firm that Edison has long used to beat up  on SoCalGas (recall that Edison used to be a big gas customer when it owned  power plants).\nEdison "arranged" for the Brattle Group to be the star  witness at the Cal Leg gas hearing.\nTheir job was to set up El Paso and  Dynegy for the hit at hearings that took place the following day.\nTheir  message was simple (and simplistic):  El Paso and Dynegy have market power.\nThey have used the market power to drive up basis and thus the price of gas  at the border (to "obscene" levels).\nThat, in turn, has driven up electricity prices.\nKen Lay is giving a gas talk tomorrow, and Rob Bradley asked that I provide  the alternative view to the Edison/Brattle rant, in the event that he gets  any questions on the topic.\nIt\'s attached.\nApologies, it\'s quick and dirty,  but it provides the basics.\nObviously no need for us to defend El Paso or Dynegy, but might be useful to  offer a more rationale explanation than the one that the California  Legislature is peddling.\nFinally, we were also fingered somewhat as culprits at the hearing (the  California PUC FERC lawyer claimed that ENA and TW colluded to drive up basis  when ENA controlled a portion of  the capacity), but the overriding goal of  the hearing was to go after EP and Dynegy.\nBest,\n',
 'Greetings:  On the call between Ken Lay and Bob Hertzberg, Hertzberb asked us to resend  any thoughts (and any more detail) we have on demand buy-downs.\nI\'ve  combined our on-line auction proposal with the "federal" solution recently  worked up for the Cheney meetings (I tailored it for California  consumption).\nHertzberg wanted it today in advance of meetings that he\'s having in  Washington next week.\nScott Governor will deliver this to Hertzberg\'s office  today.\nSorry for quick turn around, but if folks have comments, could you  send them to me pronto so that Scott can deliver to Hertzberg\'s office before  COB?\nThanks very much.\nBest,\n',
 "Greetings:  Steve Kean and I met today with Jack Stewart, Pres.\nof the California  Manufacturer's and Technology Ass.\nand Alan Zaremberg, CEO of the California  Chamber of Commerce.\nJack Stewart was happy to hear about our efforts and is generally  supportive--particularly regarding direct access--but wants more information\n",
 "Nancy Rivera-Brooks of the LA Times just called.\nSaid she'd heard that Ken  Lay and Governor are in frequent talks discussing the possibility of Enron  buying Edison's transmission system.\nI told her that Enron is not in the  market for transmission systems.\nNext thing you know, we'll want to buy the  nukes.\nBest,\n",
 "FYI:  Just got off the phone with Michael Hoffman, who's one of two key  outside financial advisors to Davis on the electricity crisis.\nThe  administration is trying to get a legally binding agreement between the PUC  and DWR to ensure that the PUC doesn't muck around with the money (via  utility rates) DWR requires to be creditworthy.\nThey were shooting for this  Friday to have a draft of the document read for folks to review, but it now  looks like it won't get resolved until (at the earliest) next week----seems\n",
 'Greetings.\nLet me know when you would like to discuss the "value" that GA  brought to our pipeline group.\n(We discussed it when I was in Houston week  before last.)\nBest,\n',
 'Well, wouldn\'t you know it.\nI couldn\'t find the most recent version in my  email.\nBut here\'s the 10.03 version with a few edits.\nCouple of other  points:  I still very much like the idea of taking the table out and includling as an  attachment.\nI still think that the table doesn\'t explicitly address an option Rick may be  thinking about "Maintain presence with fewer resources."\nThink it\'s  something we need to focus on.\nHave a great weekend.\nSpreadsheet to follow.\n',
 "Bowen called, and unless he has to schedule a call with a judge from Texas at  the same time, we're on for 9:30 AM.\nHe'll call back if there's a problem.\nAlso, he confirmed my recollection on the dedicated transport v. AFTS and  also confirmed that we can change any names we want and that this is the best  time to make sure what we file in good ol' CA is consistent with our other  filings.\nBest,\n",
 "Hi:  I was surprised to see you at the I-House last nite.\nHaven't seen you  for a while.\nWas going to drop by and say hi and catch up but your table was  extremely popular and I didn't want to intrude.\nThis is the first  travel-free week I've had in a long time.\nYou want to try to have lunch?\nOr  we could meet at a non-I-House place during the break and catch up if you  like.\nDying to hear about Montana and your possible new life as a day  student.\nDid you manage to get away last Thursday?\nBest,\n",
 'Greetings:  Due to scheduling conflicts and in the attempt not to waste anyone\'s time,  we\'ll try to conduct some preliminary due diligence via email, voicemail,  etc.\nI\'ve asked GP to get us their audited financial statements for purposes  of credit check.\nHere is some additional information about the project.\nIf  any questions come to mind based on this info, please let me know and we can  forward along to GP for answers.\nAt this point we have tentatively scheduled  a meeting with GP\'s CEO in the S.F.\noffice for Tuesday, June 27th at 10 AM  (PDT).\nA Little Background: Plan to construct an undersea fiber optic (24 fiber) cable linking several of  California\'s major coastal cities (San Diego, L.A., Santa Barbara, San Luis  Obispo, Monterey, S.F.).\nWill use a "festooned" arrangement (i.e., exit sea  at each city point).\nTotal undersea length is ~900 km.\nAt each coastal city, they\'ll have a POP to connect to PSTN.\nAt San Luis Obispo, Santa Barbara and Manhattan Beach, they will deploy two,  separate diverse cable routes from sea to POP.\nWill deploy DWDM.\nPlan includes eventual connections to existing and planned trans-Pacific  systems.\nIn addition to "loops" created in SLO, SB and Manhattan Beach, plan includes  a terrestial leg from S.F.\nto Monterey to create a land/sea loop between SF  and Monterey.\nTotal terrestial piece is ~400 km (which includes S.F.\nto Monterey terrestial  leg).\nEventually, they\'d like to secure terrestial leg from Monterey to San Diego  to create a complete loop.\nHas received environmental permit from State Lands Commission; CLEC  certification from California PUC; and is awaiting environmental permit from  Coastal Commission.\nExpect to have southern portion of system (San Diego to San Luis Obispo)  built and lit by end of Q1 2001.\nNorthern piece likely to take longer due to complications associated with  federal wildlife preserve off of Monterey.\nMay end up bypassing Monterey  altogether.\nThe people behind the build are techno-philes; they admit to being "clueless"  when it comes to marketing the capacity.\nDue to Tyco\'s perceived lack of performance, Tyco is out and Alcatel is in  (per Ethan\'s emails).\nThey are distressed.\nDeutschbank has $8MM in the deal and is pushing on them.\nWilling to part with dark fiber for a deep discount.\nBest,\n',
 'Hi Meg: My understanding is that Peter de Vroede has signed me up with him to room at  the offsite.\nYour records indicate the same?\nThanks.\nBest,\n',
 'Attached is a rough draft of my talking points for a panel I\'ll be on at a  CEM conference in SF on Thursday afternoon.\nHave distributed to Western GA  team (plus Steffes) for comment and thought you may have some, too.\nTopic for panel, "PUC Priorities."\nGoal is to (politely?)\nrefute Loretta  Lynch\'s and Carl Woods\' continued assertions that 1) California\'s move to  deregulate was based solely on ideology with no basis in fact and 2) the  solution is to turn back the clock to command-and-control regulation.\nThe FERC order tomorrow is likely to alter the points somewhat.\nComments are much appreciated.\nBest,\n',
 "I've tried to capture in the document Dave sent around on Friday, the  preliminary conclusions/directions we came up with in today's meeting.\nIf  I've mangled or missed anything, please chime in.\nIf folks have information  (i.e., bullet points) to discuss at Wednesday's meeting regarding the various  issue areas they're thinking about, please foward along to me by COB tomorrow  and I'll compile for distribution first thing Wednesday morning.\nBest,\n",
 "OK, the tours are booked (it ain't much anyway).\nBut you're on the guest  list for a complimentary OPUS tasting (see previous note).\nOPUS is across  the street from and just south of the main Mondavi winery.\nWhen you get  there, check in with the concierge, who will have your name and will set up  with the complimentary tasting.\nIt gets real crowded sometimes, which causes  them to close the gates.\nIf that occurs, you simply need to buzz the  intercom and give them your name and they'll let you in and set you up.\nYou  should really do the tasting----the wine is simply awe-inspiring and it's a\n",
 "I know that this is a difficult time for all of us.\nWith everything going on inside the company as well as in the world around us, we have been carefully considering whether a holiday celebration is appropriate this year.\nTo be honest, employee feedback has been mixed.\nMany viewed the holiday party as a unique opportunity for us to come together as Enron employees to share the spirit of the season.\nOthers felt a holiday party would be improper given the company's current circumstances.\nAfter weighing these points of view, we have ultimately decided to cancel the all-Enron holiday party that was scheduled for December 8.\nGiven what has transpired over the past month, it could be considered imprudent for Enron to incur the expense of such an event.\nI regret that this action is necessary because I recognize that your hard work throughout the year merits a holiday celebration and so much more.\nWe will attempt to find other, more appropriate ways to recognize your outstanding contributions as we move into the holiday season.\nKen Lay\n",
 'System Outage Notification     Outage Description:  All SAP systems (including Prod Interface, all EBP systems, IPayIt and FTP servers) will be shutdown in order to upgrade our storage hardware.\nThis maintenance is required to ensure that sufficient storage is available for the SAP Production systems.\nDate & Time of Outage:   Outage Commences: November 9, 2001 @ 8:00pm CST  Outage Ends: November 12, 2001 @ 2:00am CST     Contacts:  Contact:  Contact Information:\n',
 'GMAT REVIEW AT ENRON  The next GMAT review course at Enron will begin Monday, November 26th: The schedule is:      Course # 7019-00:  Monday nights, Nov 26 - Jan 28 (no class Dec 24 or Dec 31)  This course is identical to the courses that started in October.\nIt is being offered now for the benefit of employees who would like to take the GMAT before January 31 for the purposes of applying to business school.\nCourse details:      - Class is held at Enron in room ECN560 and is restricted to Enron \t\temployees      - Each course is limited to eight students      - Meets once a week for eight weeks      - Hours are 6:00-9:00 PM (first session will run til 10:00 pm to           include initial exam)      - Expect 4-5 hours of homework per week      - Course includes a total of four practice GMAT exams      - Ends the second week of December, allowing employees to take the           GMAT in December and meet a January application deadline.\n- Special discount of $200 off the regular Princeton Review tuition  Enron has allowed this program to be hosted in the Enron Building for convenience of its employees.\nIndividuals are responsible for paying their own fees.\nFinancial support from Enron is at manager\'s discretion and is subject to the usual tuition reimbursement constraints around budget and relevance to organizational performance.\nHOW TO ENROLL:      1.\nPrint out the attached registration form.\n2.\nComplete the form, but please note the following           SPECIFIC INSTRUCTIONS:           A.\nFill out the student information completely, including                your email address.\nB.\nIn the Enrollment section, where it says "Please enroll                me in GMAT Class Size-8 Course # _________",\n',
 "Good Morning-  I've had to take defensive driving for a ticket that I got.\nI have a court  date scheduled for Friday morning  Sept. 29th at 8:00 am to submitt  the  defensive driving certificate.\nI will be arriving late that morning and I  wanted to let you know 1st.\n",
 "Who has the E-schedules for co. 1n2 and 272?\nMarnie is looking for them and  the aren't in the file cabinet.\nCall me and I'll take them to her.\nThanks.\n",
 'Due to a variety of circumstances we did not migrate employees to the UBSWE environment tonight (Monday, February 4, 2002).\nWe will communicate further details of the migration plan on Tuesday, February 5, 2002.\nThank you for your cooperation in advance, please contact the Resolution Center at x 3-1411 should you have any questions.\nUBSW Energy Global Infrastructure\n',
 "Did anyone take care of Powerex cuts on Friday?\nI've entered a sale to Powerex to bookout for two hours in which they cut a preschedule (deal 795777/tag 16EV) and were unable to resupply the entire 25 mw.\nSale is for HE 13 - 13 mw @ $46, and HE 21 - 6 mw @ $31.\nPrices are EPE's incremental costs for those hours, used per Steve at El Paso.\nIf any of you have more information about these cuts and how they should have been handled, please let me know.\nFYI - Cuts were not handled correctly if Real Time Position Manager is not flat when you leave.\n",
 'FERC is holding a week-long conference on Regional Transmission Organizations in Washington  DC.\nThe conferences will generally be broadcast from 7 a.m. to 2 p.m. PDT.\nA copy of the conference agenda and broadcast sound to the conference will be near my desk (behind Tim Belden).\nThe picture will be on the far-right big screen.\nThanks to Dave Steiner for setting this up.\nAlan Comnes\n',
 'Please plan to attend the local UBS HR Presentation given by Gabrielle Hagele and Chris Lue tomorrow, Thursday, 1/24/02 at 9:00 AM in the Mt.\nHood Conference Room.\nThe presentation will detail UBS Benefits and UBS HR Policies.\nTime is also set aside for Question and Answers.\nSeveral UBS HR required forms will be distributed during this meeting.\nThese forms are required to process payroll and enroll in the benefit plans.\nIf you are unable to attend this meeting, please contact me or one of the UBS HR personnel.\nSee you then!\n',
 'As you are all aware, Enron and UBS have entered into an agreement for the sale of certain assets of the wholesale gas and power trading organization.\nAs part of that agreement, the management of UBS may speak to you over the next several days about an opportunity in that new organization.\nIf so, we encourage you to consider such an offer.\nHowever, if you are not employed by UBS, you remain an Enron employee.\nIf you have specific questions regarding your employment arrangements and job responsibilities please contact Anne Labbe in Human Resources at 5-7809, or feel free to contact either Jim Fallon or Dave Delainey directly.\n',
 'Enron announced today that its common stock will now be traded as an Over-the-Counter (OTC) equity security under the symbol "ENRNQ."\nThis follows a decision by the New York Stock Exchange (NYSE) to file an application to delist Enron\'s common stock, which means that Enron\'s common stock and related securities are suspended from trading on the NYSE.\nEnron is considering whether to appeal the NYSE\'s decision.\nThe NYSE has standard criteria for listing stocks, which can be found on their website at www.nyse.com.\nEnron recently fell below the following listing criteria: average closing price of a security less than $1.00 over a consecutive 30 trading-day period.\nQuotation service for Enron\'s stock will now be provided by the National Quotation Bureau, LLC "Pink Sheets."\n',
 "As you know, announcements about the change to our Savings Plan Administrator (401k) have been populating your in-box.\nHere's another one!\nIf you would like to make changes to your allocations or move funds within the Plan, you will need to make these changes TODAY before 1:00 PM (Pacific), 3:00 PM (Central).\nIf you have any questions, you may contact Karla Dobbs, at 713) 345-7880, our contact for the savings plan.\nLet me us if you have any other questions.\nThanks!\n",
 'Following our announcement of an additional of $1 billion credit line, Standard & Poor\'s (S&P) today downgraded Enron\'s long-term credit rating one notch from BBB+ to BBB and short-term rating from A2 to A3.\nWe expected this, because it is not unusual to be downgraded after using assets to secure credit.\nThis is still above investment grade.\nThe ratings of our pipelines Northern Natural Gas and Transwestern have also been lowered from A- to BBB.\nIn S&P\'s words, "Their ratings [are now] in line with those of the parent company to reflect S&P\'s view that Enron\'s pipeline assets have become more strategic to the company."\nS&P also said, "[We continue] to believe that Enron\'s liquidity position is adequate to see the company through the current period of uncertainty, and that the company is working to provide itself with an even greater liquidity cushion through additional bank lines and pending asset sales."\nAs I\'ve said before, building on our liquidity position through additional credit lines maintains our counterparties\' confidence and strengthens our core businesses.\nIt\'s important for you to know that our gas and power numbers - which account for more than 95 percent of our trading activity - indicate that our customer base is not withdrawing, closing out positions, or reducing transaction levels as a result of credit concerns.\nIn fact, EnronOnline trading volumes are currently experiencing above-normal activity.\nWe will continue to update you as new developments arise.\nThank you.\n',
 'Trade press, recruiting firms and others recently have made numerous calls to Enron employees seeking information about the company, its employees and other matters.\nIn some cases, these callers have used false identities, as in, "I\'m from the SEC and I need you to provide me with?"\nIf you receive a call from someone identifying themselves as part of a government organization, please refer the caller to the legal department.\nPlease refer calls from the trade press and other media inquiries to the Public Relations group.\nAnd otherwise, please treat Enron information as confidential.\nThank you.\n',
 'Everyone,   You probably have already heard on the news that there is a new Computer Virus out on the internet that is causing Corporations to experience numerous problems.\nWe have an automated process to update our workstations with the latest virus protection updates.\nHowever, there may be some machines that didn\'t get the update.\nIn order to prevent this virus from infecting your machine, please assist by doing one of the following tasks.\n1.\nLogout of the network and log back in or 2.\nClick on START>PROGRAMS>ACCESSORIES>Norton AntiVirus Corporate Edition and then click the Live Update button.\nThis will pop up a screen where you will have to click the "Next" button and then a "Finish" button.\nThe proper version of the update pattern you need is:   (9/18/2001, version 30918v)  If you have questions or concerns, please direct them to your Resolution Center.\nEnron Global Technology\n',
 'We are short at PGE system for Thursday and Friday, 9/27-28/01.\nHE15-20pdt, we are 25mw short (total of 150mw short each day).\nThis is due to a lending deal done by the NW Cash desk.\nPlease supply Portland at their system in the most cost effective manner possible.\nDeal #791433.1 for both days.\nThanks,\n',
 'CONGRATULATIONS ALL WHO PARTICIPATED IN THE SEPTEMBER BIKE COMMUTE CHALLENGE!!!\nWe had a very successful month - Thanks to all who participated!\nTEAMS 1-6 please join us for lunch in MT HOOD 11:30 -12:30 Wednesday October 3rd for our Awards Ceremony.\n',
 'This warning is sent automatically to inform you that your mailbox is approaching the maximum size limit.\nYour mailbox size is currently 75421 KB.\nMailbox size limits:  \tWhen your mailbox reaches 75000 KB you will receive this message.To check the size of your mailbox:     Right-click the mailbox (Outlook Today),    Select Properties and click the Folder Size button.\nThis method can be used on individual folders as well.\nTo make more space available, delete any items that are no longer needed such as Sent Items and Journal entries.\nYou must empty the Deleted Items folder after deleting items or the space will not be freed.\nTo turn Journaling off,   click Tools | Options | Journaling Options and de-select all items.\nSee client Help for more information.\n',
 'To all whom it may concern -  I will be out of the office Thursday, Oct. 4, through Monday, Oct. 8.\nIf you have anything you need addressed prior to Tuesday morning, please reach me on my cell phone.\nI apologize for any inconvenience this may cause.\n',
 "In case you are interested, the results of the Bike Commute Challenge were given last night at the Bike Commute Hubbub.\nEnron placed Second behind REI of Jantzen Beach.\nThe stats were not given, but when Heather gets back, I am sure that she can get this information and pass it on.\nThanks for everyone's participation!\nLets take first NEXT YEAR!\nMichael S. Tully Trade Floor Support, Portland (503)464-7790 Desk (503)807-7862 Cell michael.tully@enron.com  He who runs behind car, often get exhausted.\n",
 'Clint and I revised all of the LCRA capacity pymts this afternoon, which affected the following deals:  275298\tJan-00\t\t\tmodified option premium 288187\t\tFeb-00\t\t\tmodified option premium 300368\tMar-00\t\t\tmodified option premium 316345\t\tApr-00\t\t\tmodified option premium 331019\t\tMay-00\t\t\tmodified option premium 347153\t\tJun-00\t\t\tmodified option premium 425790\tDec-00 through Feb-01 modified annuity strips 397802\tMar-01 through Dec-02 modified annuity strips  What steps need to be taken now to make sure these changes get pushed through to your systems?\nDoes everything prior to the current month need to be auto-scheduled or is it only annuities (not option premiums)?\nThanks!\n',
 "We have offered re-employment to Dierdre McCaffrey and she has accepted effective today.\nWe need to reinstate her back to December 5, 2001.\nRobert Jones is handling all needed paperwork,etc.\nDierdre was in EGM-Freights Markets prior to being terminated on 12/03/01.\nPrior to EGM, she spent numerous years in various positions in wholesale gas structuring, trading, and origination.\nShe was instrumental in identifying, evaluating, and negotiating most of our gas asset management transactions.\nShe worked with Laura Luce and team on the Peoples' Gas transactions, and she will be critical in ensuring we maintain and optimize these contracts and positions going forward.\nShe will be working with Laura Luce in the Enron Estate.\nThank you.\n",
 'Tim, I would argue that we should pursue this business as long as a) we are  being adequately compensated for the financing and underlying commodity risk;  b) we have very good paper; c) we are dealing with solid credits and are  charging an appropriate risk adjusted cost of capital for the underlying  financing; d) we have the ability to syndicate the capital or funds flow  position if needed to manage cash issues and e) that RAC is comfortable that  we are reaching these goals.\nAny imbedded financing or $5M or more should be DASHED.\nDavid, Joe and Mark  should be your key contacts to ensure we are adequately managing these issues  but I do not see any fatal flaw in the strategy if priced/managed well and we  watch the funds flow issues.\nRegards\n',
 'Guys, can you help Phillip out with this, I assume this has something to do  with the 20/20 deal.\nI believe a reserve should have been set up for this  payment which was only designed to ensure that the transaction was accretive  to NBPL.\nRegards\n',
 "Please be sure your are in attendance or let me know if you can't attend so  that I can make Dave aware.\nThis is a reminder !!!!!\nThere will be a Friday Meeting October 13, 2000.\n",
 "Jeff, I think we should take a quick review of the existing PI portfolio to  see where we are and where we want to go - we have with the completion of  FCEL made a tremedous amount of investment in a very short period of time  >$60 to $80M.\nI would like to  hear how we are moving to monetize more  mature investments and influence/generate value from the earlier stage  investments.\nI don't want to approve any further investments until we have  had such a discussion.\nRegards\n",
 'Guys, I would like to add the following commentary to the DASH which will  better reflect my thinking around this investment.\nThe current text suggests  that there is significant strategic advantage for ENA to be a participant in  the fund.\nI do not think that is the case; however, I do see some merits in  the investment based on the needs of Enron\'s Global Finance group.\nI would  suggest toning down the strategic advantages and add the following:   It is unlikely that given the funds target returns that the it will be an  effective permanent monetization vehicle for ENA\'s strategic and merchant    investments; however, Enron Global Finance believes that the investment is  important for the following reasons:   a) provides an additional "Friend of Enron" to facilitate short to medium  term balance sheet and regulatory solution to highly structured    commodity  and capital transactions in the wholesale group;   b) provides alternative sources of short term capital liquidity and   c) by further developing the relationship with AIG provides collateral  benefits for Enron\'s overall Global Finance capability and business.\nENA would have a requirement that this investments be hedged through Raptor  and be managed by the Enron Global Finance Group.\nRegards\n',
 "Dave has reserved a Plane to take all of you to Las Vegas for the Offsite,  December 13th.\nWe have no idea  what time the PRC will be over; however, at  the conclusion of the PRC everyone should plan to go straight to the Hanger  to board the aircraft.\nI just got confirmation last night that I have the plane, so I really don't  have any details at this point.\nAs soon as I get the information, I will  make packets for each of you with directions to the hanger.\nWe are asking that you make your own reservations for the return since  everyone will be leaving at different times.\nIf you have any questions, please feel free to call me.\nThanks,\n",
 "Dave, I still believe that the most flexible model that provides high ROCE  and has growth not constrained by capital is the one being employed by  Enron.\nI think the cash on cash returns on these Genco's in the short run  will be good; however, I think it will be difficult for these companies to  move quickly to react to market opportunities given their need to protect  their long position (not unlike our friends in the oil & gas producing  sector).\nThe returns and value provided by these companies will be primarily  be based on the timing of new production and their asset base and they will  realize (on a relative basis) very little from the trading.\nIt is not a bad model just a different one.\nEither way, they will be  a strong bid for assets given their story to Wall  Street.\nRegards\n",
 'Joe, thanks for the message.\nIt has been my experience that people who have  had experience in our trading, mid market and structuring groups have a  better overall understanding of how Enron (ECT or ENA) looks at value and  manages risk.\nPersonally, this is the track I took which included a very  solid foundation in accounting, operations, trading, structuring and then  ultimately in origination.\nI hope this helps.\nRegards\n',
 "This is a reminder !!!\nIf you haven't taken the time to update your GIS  information, please do so.\nIt is essential that this function be performed  as soon as possible.\nPlease read the following memo sent to you a few days  ago and if you have any questions regarding this request, please feel free to  call Ted Bland @ 3-5275.\nWith Enron's rapid growth we need to maintain an ability to move employees  between operating companies and new ventures.\nTo do this it is essential to  have one process that will enable us to collect , update and retain employee  data.\nIn the spirit of One Enron, and building on the success of the  year-end Global VP/MD Performance Review Process, the  Enron VP/MD PRC  requests that all Enron Vice Presidents and Managing Directors update their  profiles.\nCurrent responsibilities, employment history, skills and education  need to be completed  via the HR Global Information System.\nHRGIS is  accessible via the HRWEB home page on the intranet.\nJust go to  hrweb.enron.com and look for the HRGIS link.\nOr just type eglobal.enron.com  on the command line of your browser.\nThe target date by which to update these profiles is 7 July.\nIf you would  like to have a hard copy of a template that could be filled out and returned  for input, or If you need any assistance with the HRGIS application please  contact Kathy Schultea at x33841.\nYour  timely response to this request is greatly appreciated.\nThanks,\n",
 "Guys, good job with the California issues - we didn't get everything but we  managed the position in a very effective manner.\nJim, given our view to support the growth of the ISO structures as a  necessary evil and given the socio-political leaning of these entities,  should we be more actively or aggressively supporting or nominating directors  on these boards?\nJim/Rick, we need a full court press on this NEPool ICAP issue - Allegretti  is putting plan in place.\nRegards\n",
 "Ken, in response to your note, I am not aware of any official dialogue with  Mr. Kase Lawal about a potential sale of Mariner or with the economics of the  aborted IPO.\nHis $250 M valuation may have been appropriate 12 to 18 months  ago.\nHowever, Mariner has enjoyed a series of successful wells that are  expected to be booked in reserve reports next March not to mention  significant increases in gas and oil prices.\nOur current valuations, in the  $600M range is a stretch target but not incredibly out of line given reserve  growth and current energy prices.\nOur current goal, is to be able to  demonstrate three to four quarters of increasing operating cashflow and  reserves growth before attempting a private sale mid next year to a  significant E&P concern that desires an offshore division.\nThe  concentration, operating and exploration risk implicit in Mariner make it a  very poor IPO candidate ((ie) I'm not sure that an IPO was ever a viable  strategy to maximize the exit value).\nI would recommend that we not meet to make the following points:  a) Mariner is not on the market at this point in time and  b)  his un-solicited offer does not warrant serious attention.\nOtherwise, we would be glad to speak to him in the future if we decide to  sell tha asset.\nI hope this meets with your approval.\nRegards\n",
 'Guys, I will forward the info as it becomes available.\nThere appears to be  one project in Texas and one in California which are well down the  development road.\nIf interested in these projects, which have to meet a  December 2001 COD in order to get the tax credit, I would suggest that we  purchase the development sites and turbines from Enron Wind and keep the  asset, commodity position, tax credit and possible green credits in ENA.\nThey are Ok with that strategy.\nThis is an opportuntity that needs to  fleshed out fairly quickly - Ben and Dave can you lead this analysis with  close contact with Doug and Tim on the desk.\nWe can get together to discuss  if you like.\nRegards\n',
 'Ray, I am ok with Nick and his group managing if Redmond/Mrha are ok.  Like  Rebox, whoever is technically responsible is highly accountable to ensure  that reporting and procedures are correctly followed and that the project  comes in on time, budget and technically works.\nIn this capacity, I would  like that engineer to report to you or Wayne Mays.\nRegards\n',
 'Rob, I think we should renew the flame for the three year period.\nMy  understanding is that it is $75 K Cdn per year roughly.\nNot paid up-front  and cancellable if Flames leave Calgary or disappear.\nExpense in Canada.\nIt  is your call ultimately.\nRegards\n',
 'Jere, I spoke with Scott on these targets and his belief is that both  himself, Allen and John have significant relationships with these folks which  should help leverage your product into this sector.\nScott and John have  agreed to set up these meetings with the decision makers in these targets  with no delay.\nFrom there, you, John and Scott can determine what deal team  will go speak to them about the opportunities.\nI would expect that we will  be in front of these folks ASAP.\nLets see how the product is embraced by  these customers before we extend the target list and create a more formal  alignment of the groups.\nAs per your earlier e-mail, I assume you are  working on the Reeding & Bates opportunity.\nRegards\n',
 'Mike, I forwarded your interest to Whalley, McConnel and McMahon.\nAny=20 technology effort really should be lead by NetWorks.\nThis is consistent wi= th=20 Skillings strategy and what has been communicated to the analysts.\nYou=20 should receive a call from one of these gentlemen.\nRegards\n',
 'Guys, I appreciate the updates.\nPlease ensure 1) that you, as ENA, are  integrated 2) deliver a very clear expectation with EE&CC with a credible  plan and 3) that you scream bloody murder if a deliverable is missed.\nYou  will need to bird-dog this to closure on an hourly basis to ensure that we  get over the goal line.\nKeep me in the loop daily so that I can keep the pressure on at a senior  level.\nRegards\n',
 "Lew, it looks like I have some appointments I can't get out of on the 24th;  however, we could be out there by noon on the 25th.\nHow does that fit?\nI  did get a call from Mike letting me know that he would be sending over the CA.\nRegards\n",
 'Hey Crystal hope things are well ....  Dawna is fine.\nWe have two girls six (Kassandra) and four (Samantha).\nWe  have been in Houston now three and half years.\nIt has been a good move from  a career point of view.\nObviously, you had heard my move from Pres./CEO of  Enron North America to Chair/CEO of EES.\nI hope life has been as kind to you.\nBest of luck in the future.\nRegards\n',
 'Guys, in addition please incorporate in each teams package - their Direct  Expense/Headcount ratio to plan average, Productivity ratio to plan average  and team ROCE to plan average and any variances from 2000 to 2001 for  income/expenses taking into account our most latest 2000 forecasts by group.\nWes, I assume that you will be putting together a final 2000 i/s package for  me in the next couple of days.\nThanks\n',
 'Personal & Confidential Subject to the Attorney-Client and Attorney Work Product Privileges  Attached for your information is a Memorandum from David Burns (Baker & Botts bankruptcy counsel) that walks through a number of bankruptcy issues and potential planning areas.\nThis also may help us in our analysis of any potential secured loan.\nRobert\n',
 'Dear TI-USA Corporate Supporters:  We are delighted to invite you to the next TI-USA Quarterly Meeting on Friday, June 29, 2001 from 12:00 - 3:00 p.m. at the offices of Weil, Gotshal & Manges, 767 Fifth Avenue, New York.\nWe will meet in conference room 25A and lunch will be served.\nWe hope that you will be able to participate in this informative meeting.\nPlease reply to this email to indicate whether or not you can attend.\nBest regards,\n',
 'Jim,  your resignation pertained to your directorship with the Enron Poland entity which was the marketing and origination entity for Poland.\nYou are still a director for ENS which is the comapny that holds the Polish power plant.\nI have confirmed with the other directors that this meeting is in regard to operational and contractual matters and you need not attend.\nIt would be helpful if you sent an e:mail with your regrets to:    Jacek.Glowacki@enron.com\n',
 'Enron employees not participating in contract parking are eligible to receive Metro Bus Passes or Woodlands Express Passes.\nYou may pick up a bus pass from the Parking & Transportation Desk, on Level 3 of the Enron Building, from 8:30 AM to 4:30 PM.\nAll Metro passes offered through the Enron Parking & Transportation desk will be the Metro 30 Day Zone Pass.\nWhen you use a 30-day zone pass, bus service is divided into four zones w/ unlimited rides.\nThe zone pass is time activated, which means that it will not become active until the first time it is used and will not expire until 30 days after it was used for the first time.\nNew passes will be available to Enron employees upon expiration of the 30 day time period.\nEach zone does have a different fare values based on the distance the bus travels.\nThis is important to any buser who wants to transfer to or travel in a higher-cost zone than the zone pass they have, in this case the difference must be paid in cash.\nIf they are traveling in a lower cost zone, then there is no extra cost.\nParking & Transportation Desk 3-7060\n',
 "Jim, I do not know  if Ben or Kristina have counsel or if any other people who are getting worried  have made decisions yet but there is a former U. S.  Attorney  from Omaha, named Ed Warin at the McGrath North firm  with whom I've worked who is superb.\nI recognize that many of the Texas firms  may be conflicted and people may not be comfortable with all the Washington,  D.C. folks.\nThis guy is an excellent lawyer,  knows his way around and is  very decent to work with.\n",
 "Jim, I am so glad that the 2001 law conference went so well -- we have received many favorable comments from the attendees.\nToday we had a post-conference meeting with the group that worked on the conference, and we went over what worked well and what didn't.\nIt was very productive.\n",
 'This e-mail is to follow up our conversation Friday, June1st regarding a sponsorship for the National Bar Association Convention to be held in Dallas July 28 - August 4, 2001.\nI am sending a packet to you via overnight mail.\nYou should get it tomorrow.\nIt has the levels of sponsorship.\nIf you have questions, please call me at (214) 880-0089, ext.\n2550 or e-mail me at demetris@publicans.com <mailto:demetris@publicans.com> .\nThanks.\n',
 "Steve, I was delighted to receive the news of your being admitted to the  Partnership.\nCongratulations!\nI'm very proud of you.\nAll the best.\nJim\n",
 "I have asked Pat Radford to put the enovate Master Firm and the enovate GISB  in Attorney's Forms.\nUntil she is able to do that, you can find these forms  as follows:  1) The Master Firm is at o/common/legal/sdickso/enovate/enovate master  firm.doc 2) The GISB is at o/common/legal/sdickso/enovate/enovateGISB.doc  Please let me know if you have any problems locating these documents.\nStacy\n",
 'Susan,   I just returned from a four month maternity leave.\nI have not seen executed  documents.\nAttached are the final version of the documents on the system.\nI  will track down the signed versions (if they were returned by EOTT during my  absence) and send you copies.\nStacy\n',
 'Gregg,   Attached are my suggested changes to the above-referenced confidentiality  agreement.\nOne of the changes was to address the enovate employee issue that  we discussed.\nA few of the changes are simply clean-up.\nPlease let me know  if you have any questions.\nStacy\n',
 'Paul,   Please replace both references to "the Southern District of Texas"  with "the  District of Columbia" in the arbitration provision.\nPlease let me know if  this does not work for you.\nStacy\n',
 'As we approach the Thanksgiving Holiday, I want to take this opportunity to wish you and yours a safe and happy Holiday.\nWith the recent events in our nation, giving thanks this year has taken on a whole new meaning.\nThis Thanksgiving we honor the brave, enduring heroes who gave their lives as well as those who are abroad fighting for freedom.\nWe can be thankful for our great nation and for the world coming together.\n',
 'Lindy, Tony and Sam:  Wishing you a happy "Turkey Day!"\nWe will be thinking about you and wishing we could be together.\nI know it will be fun time for your family.\nI was looking at your weather and it looked cool for Houston.\nWe are going to Happy Hollow with Jodeen and her family and looking forward to their good food.\nWe won\'t have leftovers but I don\'t have to cook either so the trade off is pretty good.\nGive Sam hugs and kisses from us.\nLove and miss you!\n',
 "As you know, Enron has signed a merger agreement by which Dynegy will acquire Enron.\nWe expect the transaction to close following shareholder and regulatory approvals and various conditions to closing.\nEven though Enron has entered into this agreement, U.S. and foreign antitrust laws require that Enron and Dynegy continue to operate independently of each other.\nIn particular, to the extent that Enron and Dynegy are competitors in various businesses or markets, their respective activities must be undertaken at arm's length until the transaction has closed.\nTherefore, for antitrust purposes you should treat Dynegy as you would any other unaffiliated company notwithstanding the merger agreement.\nIn addition, all information, documents and communications related to the merger between Enron and Dynegy should be coordinated through and approved by Mark Muller, Lance Schuler, Robert Eickenroht, Mark Haedicke, Rob Walls or Greg Whalley of Enron.\nIt is absolutely critical that this procedure be maintained.\nTo the extent that information is required to be disclosed to Dynegy under the merger agreement, then such disclosure should be approved by one of the foregoing individuals.\nIf you have any questions concerning this notice, please contact Lance Schuler (713/853-5419), Robert Eickenroht (713/853-3155), Mark Haedicke (713/853-6544) or Rob Walls (713/646-6017).\nThank you for your help in this matter.\n",
 "Ladies,  The Holiday Shopping Card is a wonderful holiday tradition.\nThe card entitles the holder to a 20% discount from November 1-November 11 at a range of stores throughout town such as Berings, Macy's, Events, Harold Powell, Banana Republic, Tootsies, JoAnn's, Williams Sonoma, Pottery Barn, Richards Liquors, Children's Collection, Talbots Kids, Zainy Brainy and many, many more.\nThe cards are available for $60.\nThe entire $60 goes to the American Cancer Society and is tax-deductible.\nChecks and credit cards are accepted.\nPlease contact Kimberly Nelson at x33580 if you'd like to purchase a Holiday Card and start your holiday shopping early and benefit a great cause at the same time.\n",
 "Participate in National Fitness Week on eSpeak!\nTuesday, May 15 at 10 a.m. Houston time, join Dr. Joel Bloom, Associate Professor of Health and Human Performance at the University of Houston.\nAsk Dr. Bloom about  topics such as the difference between sports drinks and water, myths about abdominal exercise, to breakfast or not to breakfast and much more!\nRemember:  You don't have to participate in the live event to get your questions answered.\nGo to eSpeak  now and post your questions for Dr. Bloom.\nYou can go to the eSpeak archive later and read the transcript to find your answer.\nCheck out the new postings in the Office of the Chairman category in eMeet.\nWhile you're there, add some thoughts of your own to any of the ongoing discussions.\nVisit eMeet  today!\nDo you know what hollow core fiber is?\nWould you like to know?\nStop by the Idea Vault at the ThinkBank  and find out!\nHaven't been there in a while?\nYou have some catching up to do, then!\nethink.enron.com\n",
 "Amy Oberg's brown bag, Coming Full Circle: A Plausible Future for Power Generation has been cancelled.\nWe apologize for any inconvenience this may cause.\nPlease keep watching for future brown bags.\n",
 '*************************************************************************************************************************************************  You are invited to attend the following presentation:   PSIM: A Power Simulation Tool  PSIM is a proprietary model developed by Enron Research Group.\n?\nIt takes Power, Gas, Weather and demand information into consideration and  \tuses Monte-Carlo simulation to assess the expected deal value and risk distribution.\n?\nIt evaluates complex electricity related contracts such as Full Requirement  and load following contract.\n?\nIt also provides a valuation tool for power assets and asset management deals.\n?\nIt works for both deal specific or portfolio issues.\nIn this presentation we will show how the model can be used to deal with various types  of contracts, explain the model structure and point out further applications.\n',
 'Hello,  Below is invite to Forrester Research\'s complimentary May 2nd energy breakfast.\nLimited availability.\nPlease share with anyone else in your organization interested in attending.\nYou can sign-up via the link below.\nWhen signing up, hit continue if the screen asks for a "reservation code".\nMy contact information is below if you have any questions.\nOnline wholesale trade will reach $3.6 trillion in 2005 -- dominated by\n',
 'Enron has been increasing security at its facilities around the world.\nSom= e of the changes took effect immediately (e.g.\nadditional security personne= l) and some are phasing in.\nWhile not all of the changes will be visible, = there are a few that will have an impact on everyday activities.\nIn all th= e steps we take and recommendations we make, we will be making our faciliti= es and systems more secure and endeavoring to increase your sense of securi= ty, while doing our best to minimize disruption to our day-to-day business.\n',
 'Attached is a revised Credit Watch listing for the week of 10/08/01.\nPlease note that Federal-Mogul Corp. was placed on "NO TRADES".\nIf there are any personnel in your group that were not included in this distribution, please insure that they receive a copy of this report.\nTo add additional people to this distribution, or if this report has been sent to you in error, please contact Veronica Espinoza at x6-6002.\nFor other questions, please contact Jason R. Williams at x5-3923,  Veronica Espinoza at x6-6002 or Darren Vanek at x3-1436.\n',
 '"The future is something which everyone reaches at the rate  of 60 minutes an hour?whatever he does, whoever he be."\n- C.S.\nLewis   Watch the Enron Building lobby on Tuesday, April 24th, from 11:30am to 1:00pm  for information on innovative and futuristic technology!\nFeaturing:  Dr. Peter Bishop, Professor and Chair of the Future Studies Graduate Program at the University of Houston  Mr. Clay Anderson, Astronaut at NASA  Gadgets & Gizmos by Oxford Technologies Robotic Display by Students from Yates High School  Special Afternoon Workshop - 1:30pm to 3:30pm "Images of Enron in 2020" with Dr. Peter Bishop & Amy Oberg  Join Amy Oberg with EES and Dr. Peter Bishop, Chair & Professor of the University of Houston\'s Future Program,  to imagine Enron in the year 2020.\nAttendees will actively engage in this participatory workshop with the final summary  to be shared with Mr. Skilling\'s office.\n"Futures tools" will be utilized to consider Enron\'s characteristics, culture,  businesses and the world environment and participants will explore how the future might play out for Enron.\nThe results of this session will be shared with Mr. Skilling\'s office.\nRSVP to Jessica at x31918 - space is limited   Word of the Day prescience \\PREE-shuns; PREE-shee-uns\\, noun: Knowledge of events before they take place; foresight.\n',
 'As the United States begins to recover from the tragic events of September 11, it is important that Enron and its employees also begin the task of returning to "business as usual."\nAs a company with a global presence, returning to normal business practices necessarily involves travel.\nThe FAA has already implemented strengthened security measures for U.S. airports and air carriers to ensure air transportation is safe, secure, and ready to meet the needs of the traveling public.\nWe encourage all employees to return to their regular travel schedules.\nWe have no reason to believe that international travel is inherently unsafe at this time, although we strongly recommend -- in conjunction with the U.S. Department of State -- that all travel to Afghanistan, Yemen, Pakistan, Indonesia, Iran, Iraq, Sudan, Somalia, Tajikistan, Turkmenistan, Georgia, and the Kyrgyz Republic be canceled.\nIn addition, we recommend that planned travel to Egypt, Israel, Gaza/West Bank, Jordan, Lebanon, Saudi Arabia, Syria, and Algeria be very carefully considered.\n',
 "As you know, this is an unprecedented time in Enron's history.\nWe must adapt our employee programs to fit the immediate needs of our company during this time of transition.\nIt is especially difficult to announce the immediate suspension of the following programs.\n?\nClickAtHome - Enron has suspended the ClickAtHome program.\nThe program will no longer accept new participants, PC orders, or Internet service orders.\nOrders submitted and confirmed prior to November 20, 2001 will be honored.\nEnron will also discontinue subsidized Internet service.\nEffective January 1, 2002, employees who are currently subscribers to subsidized Internet service will be switched to the regular commercial rate of their service provider and be responsible for the entire cost of the service.\n?\nMatching Gifts and Volunteer Incentive Program (VIP) - Enron's Matching Gift program and VIP grants have been suspended indefinitely.\nAs we consider the immediate needs of all employees during this trying time, it is appropriate that we discontinue the dollar for dollar match for charitable contributions as well as cash donations recognizing employees' volunteer hours with non-profit organizations.\nMatching Gift or VIP submissions received prior to November 20 will be honored.\nWe regret that we have had to make these changes.\nWe must continue to look for ways to reduce operating expenses through this transition period.\n",
 '~   Please forward this to your admin.\nGood Morning,       Tom Donohoe moved his PC this morning and it does not seem to be the correct PC.\nI was wondering if maybe there was a move that he did not know about?\nThank you,\n',
 'Thursday, May 10 at 10 a.m. Houston time, join Billy Lemmons on eSpeak.\nBilly, vice president of the Associate/Analyst Program will answer your questions in an "open mike" event.\nHave a question, but you can\'t make the live event?\nPre-submit your questions now on eSpeak , and come back to read the transcript later.\n',
 'Please find attached the latest, and what should be the final for the immediate period of time, copy of the marketing list.\nPlease filter the PA column by your name to double-check against the list you are currently working off of.\nThere are some smaller subsids of larger companies previously assigned now listed.\nI pulled these subs in from the credit pre-approval list.\nI will be passing out draft contracts folders for these counterparties tomorrow to the people responsible for the respective parent companies.\nThere are some companies on your lists that do not have draft packets.\nThese companies have NOT been pre-approved by credit, but credit is working on them now.\nContinue to call these customers regarding password applications, but do not promise that the ISDA documents, etc.\nare immediately forthcoming until we receive those worksheets from credit.\nPlease continue to pass on both the pa information and the draft packets as you receive the correct contact info.\nIf you have any questions at all, please call me at 5-3614 or come by my desk at 06541 in the rotunda.\nThank you,\n',
 "How was your holiday?\nYou missed some beautiful weather.\nMy best friend's  stag was on saturday and I still feel like shit.\nI guess I deserve it for  drinking 200 beers.\nFrom what I recall I had a good time though.\nTonight I am  going to bed at 8pm.\nI can't wait.\nChris\n",
 "Varsity called and the water pump needs to be replaced.\nIt is going to be $700.\nI told them to go ahead and fix it.\nHope that's OK.  Chris\n",
 'Kathy,  Could we sit down for about a half an hour this afternoon.\nI Have some  questions about how our new FX book is going to work and how to transfer  current positions into this book.\nLet me know when you have a few minutes ( any time after 2pm).\nChris\n',
 "Margaret,  Thank you for all you help getting my Visa application prepared.\nDo you know  what documentation I need to have with me at the border?\nI was planning on  bringing the following:  Passport Driver's License Birth Certificate University Transcripts  Is there anything else that I need to bring?\nChris Dorland\n",
 'All  A reminder that you are scheduled to interview for the Trading Track Thursday,  November 1st, from 2.00 pm onwards.\nResumes and schedules will be forwarded to you shortly.\nRegards,\n',
 'I would like to introduce Intercontinental Staffing Group.\nOur offices in Houston and London are primarily focused on serving the energy trading industry, bringing together top energy trading talent with the worlds leading energy trading companies.\nOur search consultants have past experience in either trading or brokering energy products.\nThis gives us a distinct advantage with respect to our knowledge of and exposure to the energy trading industry.\nWe are currently working on filling several trading and marketing/origination positions throughout the US.\nIf you have an interest or know of someone who is looking for a new career opportunity, please contact me at the phone number listed below or feel free to email me at possibilities@istaffinggroup.com <mailto:possibilities@istaffinggroup.com>.\nWe do offer a referral fee if we are successful in placing one of your recommendations.\nThank you for your time.\nI look forward to speaking with you.\nSincerely,\n',
 'All,  You are all confirmed as interviewers for the Trading Track -  November 1st.\nWe have 33 candidates to be interviewed (a combination of both internal and external candidates).\nYou will each receive your resumes tomorrow and interview location information (as before it will take place at the Allen Center).\nThe interviews will commence at 2.00 pm and finish at 5.:30.\nA de-brief, will follow directly afterwards at the Double Tree Hotel (Dover Room) where you will decide on those candidates to be hired into the ENA Trading Track.\nPlease allow 1/1.5 hours for the de-brief.\nRegards,\n',
 'I am pleased to announce the following organizational changes within EGM Operations & Accounting effective immediately:  Todd Hall will be relocating to London and will assume responsibility for all EGM operational activities in London including Risk Management, Confirmations, Coordination & Settlements and Trade Accounting.\nTodd will be working closely with the EGM business unit heads in London to ensure their businesses are being supported in an effective and efficient manner.\nCindy Horn will assume the role of EGM IT & Remote Office Controller.\nShe will be responsible for the oversight and coordination of all IT projects affecting the Operations group.\nHer duties will include monitoring and reporting project timelines and expenses and ensuring IT is being utilized in the most cost-effective manner within Operations.\nCindy will also manage the operational activities of the Singapore and Tokyo offices and coordinate with the Sydney office in regards to EGM operations.\nMichelle Bruce will assume responsibility for Risk Management in the Houston office for Crude & Products, Coal and Weather.\nShe will also continue to manage the Confirmation, Coordination & Settlements and Trade Accounting functions in Houston.\nPlease join me in congratulating these individuals on their new assignments.\n',
 'PG&E GTN will be performing unscheduled maintenance at unit 7C to replace the main lube/oil pump.\nBeginning with the Evening cycle for gas day Friday, November 2, 2001 the capacity will be restated to 1970 MMcf/d through Station 7, which approximates 2250 MMcf/d at Kingsgate.\nOff-line deliveries upstream of Station 7 and receipts downstream of Station 7 will not be affected.\nPG&E GTN anticipates to be back to normal stated capacity beginning with gas day Saturday, November 3, 2001.\n',
 "Hi Frank,  Just thought I'd send you an email to give you the details we discussed today.\nWe bought 51,042 mmbtu from Puget Sound in May 2001 at Kingsgate.\nThey seem to think that they bought part/most of that gas back from us at Kingsgate.\nHowever, I do not see a deal showing this purchase from Puget.\nCan you ck to see if you did in fact sell this gas back to Puget?\nThe sitara # of the purchase from Puget is 623949.\nLet me know if you need anything else from me.\nYour prompt attention to this matter would be greatly appreciated.\nThanks\n",
 "I have someone that works for me that's applied for a position at Duke.\nShe doesn't know anyone there and neither do I, so I was wandering if any of you had a contact there.\nAny help is appreciated.\nThanks and good luck to everyone.\ndc\n",
 'LAST CALL for signing up for Fundamentals of Electricity.\nAs a result of several calls,   we have extended the registration deadline  until this  Wednesday, January 23rd, 2002.\nTo register for this informative class, fill out the registration form and fax it to (713) 856-6199  to my attention by this Wednesday!\nThanks, \tLana Moore \tNESA  <<521_Electricity.pdf>>   - 521_Electricity.pdf\n',
 "Please review/comment on the attached presentation  Gary - can you and JD take ownership of this.\nOnce we incorporate everyone's comments, we can set up a meeting with Air Products, Dow, and others to discuss.\nThanks,\n",
 'When: Monday, November 19, 2001 12:00 AM to Tuesday, November 20, 2001 12:00 AM (GMT-06:00) Central Time (US & Canada).\nWhere: Raveno ?\n(get directions)  *~*~*~*~*~*~*~*~*~*  Darren Farmer, George Smith, Charlie Muzzy\n',
 'Julie,   In Sitara, the following purchases expire with no evergreen flag.\nPlease let  me know if this is correct for these contracts.\nDeal 138094  -  ERAC     expires 10/31/00 Deal 113858  -  Teco Gas Processing     expires 12/31/00  D\n',
 'An adjustment is required on the Tufco contract for July 2000.\nThe volume  for the 23rd was overstated by 5,000.\nThis resulted in revisions on the 23rd  and 28th.\nPlease see the attached Tufco.\nIf you have any questions, give me  a call @ 36905.\nD\n',
 "B,   I have had the following problems with the recruiting process recently:  1)  After leaving Toni a message stating that I wanted to offer a postion to  Liz Bellamy, additional interviews were being set up for other groups to  interview her.\nLiz had shown up on Dave Baumbach's schedule 2 or 3 times,  even after his manager, Steve Venturatos, interviewed her for me.\nPat Clynes  fond that this was happening while I was out of the office and immediately  called Toni to get it straightened out.\nToni called me at home, which is  good, but whe was not logged into the system, so she was not prepared to  discuss information with me.\n2)  At first, Toni was not very responsive to colls/voice mails.\nThis has  improved over the last week.\nShe has called me a couple of times awaiting my  decision on salary concerns.\nSo, I think that she is trying to stay on top  of this now.\nOtherwise, I have had limited intreraciton with recruiting.\nD\n",
 'I need a number where you can be reached on Friday evening.\nI will be  getting the schedule after work on Friday and will call and let you know when  and where our games will be.\nD\n',
 "AC,   You may need to fax a copy of the invitation for the July trip to Tim.\nWhen  I talked to him today, he hadn't seen anything.\n(My fault, I turned the  names in late.)\nThe real invitaion should be delivered to him soon.\nD\n",
 'Megan,   Can you forward your calculations on the Pan Energy swap for September 2000  to me?\nMy contact over there called me regarding some discrepancies  beginning that month.\nI may be able to help reconcile some of this.\nD\n',
 "Just one more e-mail ... sorry!\nI've been getting some questions about what people need to provide me tomorrow.\nHere's the scoop!\nI need:  1.\nYour collection envelope with:  \tThe $$ or checks inside.\nThe list of names who donated, and the donation from each.\nYour signature in the Release at the bottom of the list of donations (and date).\n2.\nYou do NOT need to get the GIS number for yourself or your donators ... Sue Wadsworth has kindly agreed to look all those numbers up and record them.\n3.\nI will take your envelopes, use it to fill out the prize summary form for each of you, and then turn it over to Sue Wadsworth for processing.\nIf you have any other questions, please don't hesitate to call or e-mail me.\nLeesa Ext.\n3-6030 leesa.white@enron.com\n",
 'Mary,  I apologize for the late notice on this, but here are the days I am planning to be out for the CPA Exam:  Wednesday\tOct. 31\t\tVacation Thursday\tNov. 1\t\tVacation Friday\t\tNov. 2\t\t9-8-1 Day Monday \tNov. 5\t\tComp.\nDay Tuesday\tNov. 6\t\tComp.\nDay Wednesday\tNov. 7\t\tDay one of the exam Thursday\tNov. 8\t\tDay two of the exam  I will be in on Friday, Nov. 9 to prepare for October close.\nLet me know if this will cause any issues.\nTodd Richards\n',
 "eSource Presents Lexis-Nexis Training  Basic  Lexis-Nexis Basic is geared to the novice or prospective user.\nYou will learn the basics of getting around Nexis.com.\nWe will talk about news and company information available on Lexis-Nexis.\nAttend our Lexis-Nexis Basics Clinic:  \t\t\t\t November 6\t  1:00 - 2:00 PM \tEB572 \t   Due Diligence  This session will focus on the specific company, public records, and other sources available on Lexis-Nexis that help you find all possible aspects of a company's business and strengths or liabilities.\nAttend our Lexis-Nexis Due Diligence Clinic:   November 6\t  2:30 - 4:00 PM \tEB572   Seats fill up fast!\nTo reserve a seat, please call Stephanie E. Taylor at 5-7928.\nThe cost is $100.00 per person.\nNo-shows will be charged $200.00.\n* Please bring your Lexis-Nexis login ID and password.\nIf you don't have one, a guest ID will be provided.\n* * *   eSource presents free Lexis-Nexis Online Training   Using Placeware, an interactive web learning tool, you can participate in this training session from anywhere in the world.\nBasics  Lexis-Nexis Basic is geared to the novice or prospective user.\nYou will learn the basics of getting around Nexis.com and of the news and company information available on Lexis-Nexis.\nAttend our Lexis-Nexis Basics Online Clinic:   November 14\t10:00 AM Central Standard Time\n",
 'Tom,   Here are the fault paretos of fault counts for all sites for May 2002  (may2002paretos_faults.pdf).\nFor readability only the top 30 faults for each  site are displayed.\nBoth Texas sites had VERY high numbers of "wind  deviation" faults.\nI am also attaching a file (from a different work request) that has a pareto  (by site) of the mean number of faults per turbine (may2002mean_faults.pdf),  which shows that the Texas sites have the highest mean faults per turbine.\nThis also has boxplots of the number of faults by site to show the outliers.\nI will do the June data, if still desired, when the data upload is completed.\nAs always, if you have questions or comments let me know.\nMark\n',
 'Tom,   Maybe I mis-interpreted again, but here are the graphs for site total (the  boxplots are still by turbine).\nThis is for May.\nI will wait to see if this  is more like what you need before continuing with the earlier months.\nMark\n',
 'All -   The below interviews have been rescheduled from Monday, October 29 to Thursday, November 1 in the afternoon (2:00 pm onward).\nPlease mark your calendars accordingly.\nLet me know if you have any questions.\nKind regards,\n',
 "Effective Monday, October 22, 2001 the following changes will be made to the Autohedge functionality on EnronOnline.\nThe volume on the hedge will now respect the minimum volume and volume increment settings on the parent product.\nSee rules below:   ?\nIf the transaction volume on the child is less than half of the parent's minimum volume no hedge will occur.\n?\nIf the transaction volume on the child is more than half the parent's minimum volume but less than half the volume increment on the parent, the hedge will volume will be the parent's minimum volume.\n?\nFor all other volumes, the same rounding rules will apply based on the volume increment on the parent product.\nPlease see example below:  Parent's Settings: Minimum: \t5000 Increment:  1000  Volume on Autohedge transaction\t\t\tVolume Hedged 1      - 2499\t\t\t\t\t\t\t0 2500 - 5499\t\t\t\t\t\t\t5000 5500 - 6499\t\t\t\t\t\t\t6000\n",
 'Good Afternoon!\nPlease send me the results of your phone interviews.\nI need to begin to contact these candidates to arrange their transportation to Houston.\nPlease e-mail a yes or no for your candidates.\nJohn Arnold - Michael Scarlata/Donald Timpanaro/Jeffrey Zaun John Forney/Frank Ermis - Brandon Cochran/Ruben Lorenzo/Nicholas Watson Dana Davis - Carl Zavaretti/Sam Zhou/Yvan Go Doug Gilbert-Smith - Augustin Leon/Brian McNamara/Zoya Raynes   Thank you!!\n!\n',
 'Lou, do we have any sort of policy on requests like this?\nLee Huber made the  same request last year and we gave her the chair (she only wanted one,  however).\nNorma, any thoughts?\n',
 'Here are the stray facts I mentioned:   Sulfur River system:  1200 miles of gathering in East Texas and some  treating/processing   approx.\n170 mmcf/d of throughput currently; significant growth expected  from new drilling [?]\nEBITDA:  $40mm/yr    Rex Kouri (sp?)\nis the founding equity in Sulfur River  (I haven\'t heard  of him, but they acted like I should have)     An outfit named "Energy Spectrum" put $30 mm in equity into Sulfur River a  few years ago and thinks now would be a good time to cash out    $90 mm in debt    $1/mmbtu gath/proc.\nmargins   The guys I talked to said the Sulfur River assets, coupled with the Koch  upstream assets in the area, would make an interesting combined play.\nKoch was asking $200 mil.\nfor their gathering assets a year ago or so--I\n',
 "As I mentioned in my voice mail, please check up on the signing bonus we  agreed to pay Tony Pryor.\nHe didn't get it and we need to get that fixed  asap.\nI'll be at 37555 tomorrow and back in Omaha Monday.\nIf you learn  something tomorrow and can't get ahold of me, please leave me a voice mail.\nThanks.\nDF\n",
 'Sounds like "hiccup."\nAnyway, I got an email from George Briden asking what  is up with our response on this power plant.\nAny problems or is it just time  lag on studying our facility needs?\nLet me know if you want me to call him  back or help in any way.\nThanks.\nDF\n',
 "Mike, here are two draft sets of talking points covering Stan's initial phone  call with Ted Davis to discuss whether a settlement meeting would be useful  and the subsequent settlement meeting itself.\nPlease give me any comments  you have and I'll send to Stan or have available to hand to him at our  meeting, which I understand is scheduled for 9 am on Tuesday.\nI'll  be  calling in from Arizona.\nNote there is at least one issue we ought to think  about a bit more--whether to have Stan imply there may be other goodies\n",
 'I heard a great report the other day from David Hill that you guys made it  through the Oriskany without any interesting pyrotechnics!\nWhat a  disappointment that must have been for Karol Lynn and CNG!\nSounds like a  pretty boring operation up there, otherwise I might be tempted to drop by and  see the show.\nAlso heard that the knuckleheads from Bath got thrown out of  court on their antitrust suit.\nShit, all you needed to do all along was get  rid of me and things started falling into place!!!\nBest wishes for continued success--and Siguaw, stay the hell out of trouble!\n',
 "How about Thursday or Friday, June 1 or 2 for a round of golf?\nI'm in HOU  all wk and the end of the wk looks pretty light.\nI'd be happy to venture out  west to your Katy/San Antonio nick of the woods if you guys are available.\nHill, are you gonna be in Houston around then?\nIf so, can you sneak the  clubs past your wife?\nPlease advise.\nDF    PS:  I met with Paul Bieniawski and his new storage group today.\nDo you guys  know how he parted terms with the Frogs?\n",
 "I don't think I gave you George Briden's number in my voice mail today.\nIts  401-934-1433.\nJust out of curiosity, please let me know if they are as eager  to move forward as George said they were.\nThanks.\nDF\n",
 "Steve filled in the detail for me on the LG&E issue mentioned in the Law  bullets this morning.\nA valve was left open between an LG&E facility and  Northern for an approximate 3 month period (I'm not sure how recent).\nLG&E's  gas loss data indicates that the amount of gas that inadvertently got into  Northern was approx.\n180,000 MMBtu, with a value of about $500,000.\nRockey  and Steve have talked to LG&E and it does not appear that we have any good  arguments for avoiding the liability.\nThe unexpected (and unmetered)  deliveries from LG&E presumably reduced our lost and unaccounted for balance  during the referenced 3 month period.\nAccordingly, I assume the cost of  replacing that gas should be accounted for in Northern's PRA and so should  not affect earnings.\nI'm not sure what the timetable is for resolving this  matter.\nDF\n",
 'Speak of the devil.\nTino called, all full of optimism and questions.\nThey  have pitched the DOE a deal in which Dennis builds three 50 Mw turbines on  the Isleta, and a 7 mile power line to DOE\'s distribution lines.\nThe project  will apparently be 100%debt financed, with DOE agreeing to pay a firm demand  charge rate of between 8 and 9 cents/kwh.\nThat rate is supposedly high  enough to service the debt on a 10 year amort.\nbasis (remember, DOE can only  sign 10 year contracts).\nDOE is interested, says Tino, because of the  redundant, dedicated facilities and enhanced reliability, and because Dennis  and Tino pitched DOE on all the $$$$ DOE will make from the surplus power  sales.\nDennis apparently pitched them a "share the upside" deal under which  DOE keeps most of the revenue from surplus sales.\nTino showed DOE the July  spot prices at 4 Corners, which Tino said included many days over $200/Mwh  and they got all excited.\nDOE has done a similar share the upside deal at  one of its facilities in Calif. Tino says and they have occasionally come out  net positive on elec.\ncosts in some months so they like the approach.\nTino  had two questions: 1.\nDoes TW have 30-40,000/d of permian capacity available starting sometime  in 2001 or 2002?\n(I realize we have probably answered this question about 5  times, but lets do it again for him).\n2.\nIs there someone at ENA Tino can talk to about a getting a quote for long  term and/or short term power purchase prices for Four Corners delivery?\nIf  he can get something the DOE thinks is a good price, they m ay just sell all  the surplus power forward.\nIf not, they\'ll just hang on to it and sell it  into the cash market in monthly and daily deals.\nThanks.\nDF\n',
 "Maria informed me that you left your shootin' irons in Texas when you moved  up here.\nWhat were you thinking?\nI'm organizing a pheasant hunting trip in  late October out in Western S. D.  Probably leave here Friday , Oct 27 and  return Sun PM.\nAny interest?\nDF\n",
 "Today, Enron hosted a conference call to give investors a current overview = of the company.\nHere's an update of what we discussed during the call.\nWe told investors that we're doing everything we can to protect their inter= ests and to regain their confidence.\nOur focus remains on our credit qualit= y, balance sheet and liquidity, which are essential for our continued succe= ss and expansion of our wholesale businesses.\nIt took more than a few weeks to get where we are today.\nHere's a snapshot = of significant events that led to our current situation:\n",
 'In light of numerous construction delays, increased sponsor contributions,  unusual central bank exposures etc.\nwe would like to conduct a comprehensive  review of our insurance coverages  for the Cuiaba I Project.\nI am availble  at your convenience to begin meeting for the exchange of info which will be  required to fulfill this endeavor.\nI will be the point person on behalf of  the project.\nMy Assistant, Blanca Bollom can make all of the meeting  arrangements.\nPlease let us know who should attend.\n',
 'Bob:  here is our list of West desk applications for Windows 2000.\nDartPlus via Citrix Northwest Passage via Citrix Northwest Passage via Internet Kern River via Citrix Internet Explorer for Williams Field Services and Questar (internet) Cig via Internet Cig dialup Pacific Gas Trail PG&E Inside Tracc Williston Basin Pipeline via internet EL Paso Passport Transwestern Hottap via Internet Gas Select via Citrix  If we think of any more I will let you know.\nThanks.\n',
 "Hey guys:  just to follow up after our discussion this morning on unfinaled  invoices, the following will be our procedures.\n10th day of month:  invoices sent out 1st business day after 10th:  we will get the unfinaled invoice report from  settlements and start working on clearing all discrepancies.\nWe will have  all discrepancies cleared by the 5th work day after the 10th.\n25th day of month:  purchase stuff goes out.\n1st work day after 25th:  unfinaled invoice report from settlements, same  timetable to clear all discrepancies.\nRemember:  a discrepancy will consist of anything that could hold an invoice  from going out the door.\nWe need to be very receptive to other groups in helping them clear these up.\nWe know more about these deals than anyone, so let's be helpful.\nLet's also try to clear these up in a way so as to avoid causing these  problems in the future, if we can.\nThanks in advance for everyone's help.\n",
 'Attached is the game schedule for the Chargers.\nPlease let me know if you have any questions or concerns.\nThanks.\n(See attached file: Chargers Game Schedule.doc)\n',
 'Below are the arrival and departure dates that I have reserved for you at the San Luis Resort in Galveston for the 2nd Annual Accounting Leadership Conference.\nArrival\t\t\t\tDeparture \t9/19\t\t\t\t9/21   The 2nd Annual Accounting Leadership Conference has been scheduled for September 20-21, 2001 at the San Luis Resort in Galveston.\nIn addition to communication and networking, this year the focus of the conference will be on leadership: \trefining the direction and objectives for Global Accounting \tdefining and agreeing on priorities \timproving leadership skills   In addition, the format of the conference has changed from last year.\nThe conference will be more participatory.\nWhile there will be a few speakers/presentations, you will spend more time in working sessions focused on the topics above.\nThe meeting will begin at 9AM on Thursday.\nThe meeting should adjourn by 3:00 on Friday.\nThere is no organized dinner or activity for Wednesday night.\nThe San Luis Resort is located at 5222 Seawall Boulevard, Galveston, Texas.\n',
 'Attached are the files for the PGG 3rd current estimate.\nPlease take a look at the comments and footnotes.\nWe are assuming the goodwill transfer to ENA as of 7/1, and have given them the amortization to include in their forecast.\nLet me know if you have any questions.\n',
 "Tracy,  could you please send me the info for TW Commercial for the 3rd CE and also the TW 2002 plan detail.\nPlease send me any updates as they occur also.\nI'm receiving the detailed info from Steve Gilbert, but he doesn't always have the TW info, so it would be easier if you just sent it directly to me.\nPlease call if any questions.\nthanks   Mary Kay\n",
 'Per our telephone conversations, property tax information for the budget process is only needed for the calendar years 2001 and 2002.\nIn order to complete the property tax portion of this process and provide the cash flow analysis for Northern Natural Gas Company and Transwestern Pipeline Company, the Property Tax Department needs the following information for the calendar year 2001:  (1) Net Utility Operating Income (Net Income before Interest & Taxes)  (2) Capital Expenditures (Income Enhancement/Marketing Projects only): preferably by state, if not; total by company  In order to provide the required information in a timely manner, please forward the aforementioned information to my attention as soon as it becomes available.\nIf you have any other questions or comments, please advise.\n',
 "Tracy  Per our conversation earlier this week, EOTT's projection for 2002 Net Income is $26.9 million.\nMy understanding is that this is all that will be required from us in connection with the 2002 Plan process at Enron.\nPlease advise if this is not correct..\nI'll be out of the office next week.\nIf anything further is required, during that time, please contact John as soon as possible.\nGiven the internet problems we've had lately, please acknowledge receipt of this email by sending me a reply.\nThanks Karl\n",
 "In September, you used the services of the ETS Solution Center, and we invite you to share your thoughts and suggestions on your experience with us.\nIf you would like to share your thoughts but remain anonymous, you can access the information below by going to www.ets.enron.com, selecting the Solution Center page, and clicking on 'Click Here' by the Questions & Comments title.\nOtherwise, please take a moment to complete all or any part of the questionnaire below:  General Comments   Suggestions   Was the Help Desk staff courteous and helpful?\nPoor\t___1  ___2  ___3  ___4  ___5   Excellent\n",
 'I just wanted to close the loop on the question of deferring the $.7million UCU credit to 2002.\nThe last we talked, it was decided that we could not defer the credit because of cash target concerns.\nIf this is still the directive, we will see a positive variance to Third Current Estimate in October of $1.2 million.\nWould you confirm that this is still our decision?\nIf so, we will include the earnings upside  in our Quarter Forecast next week.\nThanks\n',
 "I would like to have a meeting on October 31st (maybe later if that date won't work), either in the AM or the PM, but probably about 3 hours or so.\nI would like to discuss organizations and how we are going to provide the support the EGS organization requires both at Stan's level and at each level in the organization.\nI would also like to discuss the top 3-5 concerns you have for your business and your people.\nYou should decide if there are people in your organization that are needed to discuss basic functions of Planning, Accounting, Finance and Tax and feel free to include them in this process, but I would like to keep the group to Director level or above.\nPlease let Kathy know who they are.\nI would like to know if you are available or have a preference for morning or afternoon.\nThanks.\n",
 "Steve,  Please find attached the preliminary 2002 EREC earnings and cash flow plans.\nThis is a preliminary draft only.\nAs discussed with Tod, the operating cost line has been adjusted at a summary level to achieve the IBIT target agreed to during Friday's review with Stan Horton.\nThe actual adjustments made to arrive at the final plan will involve different timing and P&L lines.\nPlease contact me at (661) 823-6467 if you have any concerns.\nThank you.\n",
 'Please find attached files.\nThe actual through July will tie to the Gary Zahn "Functional Income Statement" schedule.\nHopefully, this should help in verifying actual data back to January the BUCS will be providing for the upcoming forecast.\nCall if you have any questions.\n',
 'If you are a participant in the Enron Corp. Savings Plan, please read this very important message.\nWe understand that you are concerned about the timing of the move to a new Savings Plan administrator and the restricted access to your investment funds during the upcoming transition period scheduled to take place beginning at 3:00PM CST on October 26 and ending at 8:00AM CST on November 20.\nWe have been working with Hewitt and Northern Trust since July.\nWe understand your concerns and are committed to making this transition period as short as possible without jeopardizing the reconciliation of both the Plan in total or your account in particular.\nRemember that the Enron Corp. Savings Plan is an investment vehicle for your long-term financial goals.\nThe Enron plan will continue to offer a variety of investment opportunities with different levels of risk.\nAs always, we advise you to review your overall investment strategy and carefully weigh the potential earnings of each investment choice against its risk before making investment decisions that are aligned with your long-term financial plans and your risk tolerance.\nFor that reason, it is critical that ALL trades among your investment funds be completed by 3:00 PM CST Friday, October 26 before the transition period begins.\n',
 'Please find attached files.\nThe first worksheet in each file (Backup) has the Regulatory Assets and Liabilities data along with other Balance Sheet support.\nEach item has two parts, Current and Noncurrent.\nClick in the box labeled "Print Backup Pages" (top left corner of the worksheet) and 9 pages should print (5 assets and 4 liabilities) on legal paper.\nCall me if you have any questions.\n',
 'Tracy,  Attached is a schedule taking you from an IBIT of 15.0 to (35.9) for EEOS.\nLet me know if this is what you need.\nThanks,\n',
 'Just wanted to follow up on one thing from our conversation on Friday.\nIn Sept, you need the 3rd current estimate, but are ok with us providing it to you the week of the 17th, rather than the 13th.\nAnd this will be the 3rd current estimate, not just the normal cash flow forecast?\nThen in October, we are back to the normal cash flow forecast, correct?\nLet me know, thanks!\n',
 'Here is the Open Ticket Remedy Report for Property.\nDue to the focus on this meeting, we may or may not have time to review questions on this report.\nPlease review for accuracy and bring your comments/questions to the meeting.\nThx,       Ron\n',
 'I have been asked to pursue an effort to apply a drag reducing agent (DRA) to the La Plata to Bloomfield pipeline with the intent of increasing the San Juan lateral capacity.\nI would appreciate it if you or your representative could participate in a conference call to initate this effort.\nThe desire is to have this done in the September - November time frame as December is a tariff month.\nA launcher and receiver as well as other facilities to make the line piggable would have to be installed, cleaning pig runs completed and the DRA applied.\nPlease let me know by noon Wednesday if you cannot make either of these times:  2:00 p.m., Thursday, 08/30 2:00 p.m., Friday, 08/31  I will send a note by end of day Wednesday confirming the time and giving the dialing information.\nThanks for your help on this.\nJohn Sturn Optimization Team\n',
 "The La Plata DRA conference call has been scheduled for 9:00 a.m., CST, Friday, 08/31.\nThe dial in information is below.\nThe purpose of the call is to review all we know about now about applying a drag reducing agent to the La Plata to Bloomfield line and decide whether it is beneficial to pursue.\nIf it is decided to pursue the DRA application a work plan will be made.\nThe agenda is:  Project benefits Project requirements Facility modifications Application requirements Schedule Pursue project?\nSchedule Responsibilites  Thanks for everyone's efforts in scheduling this call.\nJohn   Per your request, I have scheduled a conference call on the above referenced subject for tomorrow, Friday, August 31 at 9:00am (Omaha time).\n",
 "Just wanted to see how things were going.\nI heard that Vicki had her baby recently!\nIs there a way I can contact her while she's on maternity leave?\n(or is she checking her work email at home?)\nWhen I talked to you (long time ago) you said you were going to be writing me a novel email.\nWhat happened?\nProbably go lost in the mail, huh?\nSomeone said that Dick Jenkins had moved to another group, is that true?\nI guess there have been a lot of changes since I left.\nAnyways- I hope all is well and I hope to hear from you soon!\n-Angie\n",
 'Thanks for your help today.\nJill is trying to execute this deal first thing in the morning.\nI still do not know what meter number Cabot would nom to on CNG.\n',
 'Hello All,  what an exciting game last night!\nNo excess injections for the rest of the week.\nThat means no IAS payback either.\nIT between Niagara and Leidy is available for 80,000dth.\nIAS or excess withdrawals 60,000dth system wide.\nHave a great Tuesday.\n',
 'Effective immediately Sean Riordan @X5-4298 will be responsible for Deal Validation issues.\nHe is taking over all my current duties as I will be moving to a new group.\nI will be helping Sean with Deal Validation issues until 10/19/2001.\nPlease let your group know that they should now be calling Sean for assistance.\n',
 'COLUMBIA GULF TRANSMISSION COMPANY                         NOTICE TO ALL INTERESTED PARTIES                                 OCTOBER 08, 2001  Notice ID: 3168 5 - NO RESPONSE REQUIRED  The fall issue of the Columbia Gulf customer newsletter, The Columbia Edge, is now available online.\nTo view it, click the link, which you can find on the Navigator homepage.\nIn this issue, The Edge takes a look at preparations for winter operations, reviews some of the steps Columbia Gulf takes to ensure the safety and reliability of our system, profiles CGT customer, BGE, and much more.\n',
 'Chris, Enclosed is the spreadsheet I spoke with you about yesterday concerning the price changes needed in Sitara for 5 months.\nI appreciate your help in changing these prices.\nThanks,\n',
 'Get ready.\nBeginning in November, electronic pay stubs will be available to all employees who have their paychecks direct deposited into their bank account.\nElectronic pay stubs are an easy, fast, and efficient way for you to get your payroll information.\nThey will also help Enron to realize a considerable savings in time and dollars spent over traditional printed pay stubs.\nIf you prefer to receive a hardcopy of your pay stub, click on the link below to complete a request form.\nThis form must be submitted to Payroll by October 15, 2001.\nUnless you submit a form your pay stub information will default to electronic viewing.\nPlease click on the link below.\n',
 "Hi - hope everyone is doing well.\nWould most of you prefer to have our meeting re-scheduled via conference call, or to meet in person, possibly Tuesday evening (10/16) or Wednesday morning (10/17) after the customer meeting?\nLet me know and we'll go with the majority.\nThanks!\n!\n",
 'Hi guys, I spoke with the attorney for DRI, a producer on TCO.\nHe said that he would convince his client not to file a motion in the bankruptcy court for amounts owed for post petition production volumes delivered to ENA,IF ENA sends him a letter by next Friday, 6/28/02, stating definitively that ENA will pay DRI for such volumes and a date certain by which the payment will be made to DRI.\nShemin\n',
 'Just thinking about you and my enron friends.\nI finally sold my enron stock last week for $5.25.\nPG&E National Energy Group and any other company referenced herein that uses the PG&E name or logo are not the same company as Pacific Gas and Electric Company, the regulated California utility.\nNeither PG&E National Energy Group nor these other referenced companies are regulated by the California Public Utilities Commission.\nCustomers of Pacific Gas and Electric Company do not have to buy products from these companies in order to continue to receive quality regulated services from the utility.\n',
 "All,  At todays Legal Staff Meeting Sara asked that forward to all members of the EWS/EES Legal Department the Indices or Tables of Contents for the Master Netting Agreements & Payment Netting Agreements, which are housed in notebooks in my office.\nTherefore, attached are the following:  1.\nMASTER NETTING AGREEMENTS FOR ENRON'S DOMESTIC AFFILIATES 2.\nNETTING AGREEMENTS FOR ENRON'S DOMESTIC AFFILIATES (Liquids Group) 3.\nMASTER NETTING AGREEMENTS FOR ENRON CAPITAL & TRADE RESOURCES LIMITED (LONDON OFFICE)  It is my understanding that Enron Power Marketing, Inc. entered into Netting Agreements for payment with various counterparties; however, I do not possess copies of those agreements.\nThe attachments may be a good indictor of what agreements are out there with respect to netting, however, if you need a hard copy of a particular agreement or agreements, just let me know.\n",
 'Team,    I have created a group calendar for us (attached below).\nIf you know of any additional time that you will be out of the office 1/2 day or more in July or you have anything else you would like added, please advise by  close of business today, so that I can print the calendars and distribute.\nMany Thanks!\nHeather\n',
 "Attached are copies of the letters sent to Enron by The Central Pacific Group.\nThis is one of the small Appalachian producers supplying Enron on Dominion and other pipes.\nI'm wondering if we can use one of these letters as a valid termination of the gas purchase contract and what would the effective date of that termination be?\nLet me know or just give me a call.\nAlso, I'm trying to estimate the number of hours required to work on the Dominion producers.\nI'll like to chat with you about that as well.\nThanks.\n",
 'We received a prior period adjustment (December activity) on the  JanuaryTransco invoices for CES.\nIts a credit of $6,432.31.\nIts releated to  the Lilco capacity CES Retail receives each month.\nThis credit should be  passed through to CES.\nHow is that being handled?\n',
 'Do we still need to be transporting Bridgeport CNG produciton gas through  Coronado to CGAS?\nAND if YES, will this gas always need to go through  Coronado?\nI thought that was just a seasonal thing\n',
 "I've gone through most of the CES stuff for Jan.\nI'm missing several demand  charge contracts and commodity for CES on Trco.\nI think you need to call me.\n",
 "I faxed a copy of the PSNC invoice for March to Brian Perrone.\nI show this  as a purchase from CES at St 85.\nAlso, I believe March is the last month CES  is taking the gas from CES.\nBrian, I'm tossing my copy, let me know if you have questions.\nThanks.\n",
 'Look guys - I suspect these are deal entry problems as opposed to deal  valuation problems.\nPlease take a look.\nShould I just enter these deals in Sitara for now (just  for April) and let you know what the new deal numbers are?\n',
 'We borrowed (deal227922) about 22,000 dt from CNG for the 28th and we will  pay it back (deal 227926) on the 29th.\nENA will pay CNG $.03 times the daily  balance on the 28th.\nThis gets confusing because we already have a parking  deal from the weekend that comes out in April.\n',
 "What's this - according to Navigator, we only have this contract for 1 day on  Feb 23rd?\nI just entered it in the ces retail sheet.\nMDQ = 5000 and the  rate is $.01?\nWho did this deal?\nThe receipt points are Exxon-Chalkley, NGPL, and Tenn-Egan.\nThe delivery  point is Rayne.\nIt looks like we nominated gas on this contract.\nI'm  setting up this up in Sitara and on our 2000tran02.xls worksheet and I  entered it in Sitara deal 223022.\nJesse, this will need to be scheduled in Unify.\n",
 "I don't know if you ever got copies of the invoices.\nEverything given to me  for you guys was actually wholesale stuff.\nHowever, I getting copies as I  work on actualizing the demand charge sheet for Jan.\nI will make copies an  send them to Brian.\nBrian, what is your mailing address?\n",
 "I just  changed the demand charge on the Penn Fuel capacity from 6.53 to  6.423 (deal 205687).\nI changed the price on the Penn Fuel released demand  from 6.449 to 6.423 (deal 205672).\nWe were billed 6.423 in January.\nThat's  an odd rate when everthing else was 6.50.\n",
 'I wish I could write such sweet words.\nThere are starting to be way to many  Driscoll\'s, I think there was a Mark and Mike that I came close to sending  this to.\nCollards is green, my dog\'s name is Blue    and I\'m so lucky to have a sweet thang like you.\nYer hair is like cornsilk a-flappin in the breeze,    Softer than Blue\'s and without all them fleas.\nYou move like the bass which excite me in May.\nYou ain\'t got no scales but I luv you anyway.\nYe\'re as satisfy\'n as okry jist a-fry\'n in the pan.\nYe\'re as fragrant as "snuff" right out of the can.\nYou got some a yer teeth, for which I am proud;    I hold my head high when we\'re in a crowd.\nOn special occasions, when you shave under yer arms,    well, I\'m in hawg heaven, and awed by yer charms.\nStill them fellers at work,they all want to know,    What I did to deserve such a purdy, young doe.\nLike a good roll of duct tape ye\'re there fer yer man,    To patch up life\'s troubles and to fix what you can.\nYe\'re as cute as a junebug a-buzzin\' overhead.\nNot like them mean far ants dun found in my bed.\nCut from the best cloth like a plaid flannel shirt,    You spark up my life like a load of fresh dirt.\nWhen you hold me real tight like a padded gunrack,    My life is complete;there ain\'t nuthin\' I lack.\nYer complexion is perfect like the best vinyl sidin\'.\nCuz despite all them years,yer age, yup it keeps hidin\'.\nMe \'n\' you\'s like a Moon Pie with a RC cold drank,    We two go together like a skunk goes with stank.\nSome men, they buy chocolate fer Valentine\'s Day;    They git it at Wal-Mart, it\'s romantic that way.\nSome men, they git roses fer that special day,    From the cooler at Kroger.\n"That\'s impressive," I say.\nSome men buy fine diamonds from a flea market booth.\n"Diamonds is ferever," they explains, suave and couth.\nBut fer this man, honey,these just won\'t do.\nCuz ye\'re way too special,you sweet thang you.\nI got you a gift,without taste or odor,    More useful than diamonds...it\'s a new trollin\' motor!\n',
 "I don't think this is very usefull but you guys will know best.\nMARQ CAPACITY AVAILABLE                               Received 2/29/00 9:20 am                                                       Posted 2/29/00 9:30 am     CNG Transmission will accept bids for the following MARQ capacity,  which is available for service commencing March 2,2000.\nReceipt Point:  1,779 Dths/day at Meter #60004      Name - Aggregation Point #1       721 Dth/day at Meter #50004      Name - Finnefrock Aggregation Point   Rate:  Maximum Demand   Effective Tariff Max (Currently $6.2500)   Primary Term: Commencing March 2, 2000 through March 31, 2000  MARQ:  2,500 DT/Day  Bids will be evaluated using the Net Revenue criteria of Section 23.3.B.2  of CNG's FERC Gas Tariff.\nSubject to the open-access requirements of Parts  161 and 284 of the Commission's regulations, unless mutually agreed otherwise  in consideration of relevant operational and market factors, CNG reserves the  right to reject any bids at less than its maximum applicable rates.\nCNG also reserves the right to reject contingent bids and bids from any party  that does not qualify for service in accordance with all applicable  provisions  of CNG's FERC Gas Tariff.\nBids for this capacity must be submitted to CNG by fax at (304) 623-8530,  during the period from 10:00 AM (EST) February 29, 2000, through 10:00 AM  (EST)  on March 1, 2000.\n",
 "I understand we have the CES Cove Point  storage contracts set up as CES-Cove  Point in global.\nWhat is the status of the paperwork and who is following up  on it.\nWhent I look on Cove Point's website, I show that Enron North America  now has 3 storage contracts.\n",
 'I created a purchase from CES (deal 149778) to replace the CPR STORAGE deal.\nVictor, please move the daily volumes to deal 149778.\nAs far as I can tell,  ENA should not be billing CES for their storage gas.\nSo, we should show a  purchase from CES for the storage gas.\nOf course it will get much more  complicated once we resolve all of the retail issues.\n',
 "Mary downloaded the purchases and the sales to excel.\nI spot checked some of  the deals and they look good to me.\nThere are 2 small deals that are  missing, deals 480324 and 480325.\nThese deals are related to the CGLF NYMX  purchase.\nI had the buy/sale on CGLF.\nI didn't enter the buy/sale on CGAS  until this afternoon.\nAlvin should have these tracked and balance early next  week.\nThe dollar impact should be very small.\nRemember, I'm out next week.\n",
 'Per Steve Gillespie - this is our operational flexibility with the Penn Fuel  asset management deal for January.\nSteve, I am assuming all of the numbers  shown below are citygate numbers.\nCGAS   TCO - Penn Fuel baseoaded 5000 ENA has 2610 to use without recall  no daily  swing.\nTetco  use 9448 have daily swing of 11,256  declined monthly swing of 3500  need to notiy day  before flow usually by 10:00  sgilles@colum\n',
 "Linda, Sylvia,  I need you to set up the Transco contracts as outlined  below.\nAs agent for CES unless specified otherwise, Firmness = Firm, Service Type =  Transportation-Release   K# K Type  Rate Term    Comment  1.1703 TRANSP FT-R 1 month then evergreen  ENA's .7537 contract  2.1439 TRANSP FTL-R 1 month then evergreen  ENA's 2.2390 contract, we need  to create new Rate Sched  2.7425 TRANSP FTS-R 1 month then evergreen  Special z4 to z4 contract.\nENA  does not have one like this.\n2.7423 TRANSP FTCH-R  1 month then evergreen ENA's 2.7055, also used for z4  to z4  2.7479 Storage WSR 1 month then evergreen  Washington Storage.\n2.7502 Storage ESR 1 month then evergreen  Eminence Storage     2.1432 TRANSP FT-R 1 month then evergreen  As agent for CEM.\nENA's .7537  contract.\nWe will be billed commodity on the 4 contracts listed above.\nWe will be  billed demand on the contracts listed below.\n3.3053 CAPACI FT-R 1/1/00 - 1/31/00   schedule on 1.1703  3.3096 CAPACI FT-R 1/1/00 - 1/31/00   schedule on 1.1703  3.3039 CAPACI FT-R 1/1/00-  1/31/00   schedule on 1.1703  3.3109 CAPACI FTS-R 1/1/00 - 1/31/00   schedule on 2.7425  3.3085 CAPACI FTCH-R 1/1/00 - 1/31/00   schedule on 2.7423  3.3114 Storage ESR 1/1/00 - 1/31/00   schedule on 2.7502  3.3115 Storage WSR 1/1/00 - 1/31/00   schedule on 2.7479  2.4899 CAPACI FTL-R 1/1/00 - 5/31/08   schedule on 2.1439  2.7160 CAPACI FTL-R 1/1/00 - 5/31/08   schedule on 2.1439  2.8607 CAPACI FTL-R 1/1/00 - 5/31/08   schedule on 2.1439  3.3014 CAPACI FT-R 1/1/00 - 1/31/00   schedule on 1.1703   3.3022 CAPACI FT-R 1/1/00 - 1/31/00   CEM capacity.\nschedule on 2.1432  I'm sure I made a few typo's.\nthanks\n",
 'I believe the EOG volumes listed below are ANR citygate deliveries.\nHunter, Dan and I will be entering all the physical retail volumes in Sitara  for the East Desk.\nLet me know who you want us to give this information to  on the Central Desk.\n',
 "I have 2 storage questions for now.\n1.\nCove Point LNG - it's my understanding that this is a LNG peaking  facility.\nThe current balance is 1,500,000 dth.\nDid you have a withdrawal  schedule or were you going to use this as peaking gas?\n2.\nTCO contract 63304 - has capacity of 7 BCF, and I think your current  storage balance is about 5 BCF.\nWhat is your withdrawal schedule for Jan??\nthanks\n",
 'Please give my EOL id the ability to trade Canadian Gas products.\nMy ID is  ADM81300.\nCall me at 3-4743 if you have any questions.\nThanks\n',
 'On the 8th, we went short on TP2 at St 65.\nI created deal 665147 as a TP2  buy from Gulf 1 at St 65.\nI entered the price as Z3 GD.\nPlease let me know  if you want to adjust it.\nthanks\n',
 'The East Desk is having a meeting tomorrow at the same time to discuss the  split out of the East Desk into 11 new books.\nI need to attend the East Desk  meeting first.\nPlease take my name off the list for the Thursday meeting.\nThanks\n',
 'Bookout purchase deal 551027 with sales deals 380492, 376880, and 551007.\nI created a sale to New Power (deal 597332) for gas they take out of our pool  into their pool.\nI created the following purchases from New Power Deal Volume  Comment 597271 3674  EES supply at AO6 597290 4100  EOG supply at Broad Run 597293 3674  EES supply at Delmnt 597316 6160  Dynegy supply at Monclova  We should be hooking all these deals up to our transport.\nLet me know if you have question.\n',
 'We made 1 big change that will impact tonights P&L.\nWe chanbed the volume on  deal 549411 from 72,000 per day to 106,000 per day.\nThis is and CGAS index  sale.\n',
 "I updated the worksheet with a little more info and I added Trco and Tetco  Marktet area information.\nI did this quickly so let me know if something  doesn't look right.\nOn Monday, we will show you a bid for the Tetco and Trco  volumes.\nAlso, the Tetco and Trco volumes are monthly and the CGAS volumes are daily.\n",
 'I entered deal 454356 in Sitara.\nENA inherited this deal from CES.\nThis is  a sale to Nashville Gas Company at CGLF Mainline.\nI entered all the pricing  and volume terms on the comments.\nP.S.\nNashville is in the process of assigning this deal to Sempra.\n',
 "I added a demand charge of $1,193,725 to deal 523459 for Dec 2000.\nI don't  think this should show up in the current month P&L, at least not from this  deal ticket.\nLet me know if there are any problems.\nThis demand charge is for the Market East and for the $10,000/month  scheduling fee.\nWe are still working on the East demand charges for New  Power.\n",
 "Also, there is 5000/day of Leach to BG&E space at max rate for a term of  11/1/99 - 4/30/01.\nIs this considered retail or wholesale?\nI don't see any matching CGLG space to go with it.\nIs that correct?\n",
 'Attached are the purchases and sales with New Power for the month of  November.\nThe invoices are on their way, I think it would be easier to sort  and review the data in excel.\nLet me know if you have any questions.\n',
 "Don't forget to chat with VNG about Nabisco.\nVNG should have released 700 dth of CGAS capacity to Nabisco effective  11/1/2000 - 10/31/2001.\nNabisco was not set up as a prearranged bidder at  the time.\nDuring Nov bidweek for Dec, Nabisco asked me to release the  capacity.\nSince the term was less than 1 year, I couldn't release the  capacity non-biddable.\nI spoke to Jeff Huston about it early last week and  he said he would get back to me.\nDick suggested I tell you.\nTAGG - you're  it, I will await your command.\nMr. Scott Goodell said we could release the  capacity for 1 year eff 1/1/2001 and then recall Nov and Dec.\n",
 "I need the WSS meter number.\nI would like to get that from VNG.\nI'm sure we  don't have that set up in our system.\n",
 'AND, I want to hold back $79,000 of revenue on deal #401601.\nThe customer price is $5.7025 which is based on the following  Sales Price  $5.4850 Transport to Stoi $.1526  (I included $.0147 too much by accident) Storge Injection  $.0249 Capacity Demand $.0400  Total Price  $5.7025  We will overinject in October by about 362,000 dth to max out storage by Oct  31.\nSince we will not estimate the transport expense until Oct, I want to  hold back roughly 362,000 dth x $.2175 = $79,000.00  (close enough).\nThanks\n',
 'I changed deals 268090 and 268093 effective 9/7/2000.\nWe plan to have  storage maxed out by 9/30/2000 and there will be no injections for October.\nComments, questions??\nWill this cause any problems with the Choice program  in October?\n',
 "With the change in segmentation rules on Transco, it has become much more  critical to know the primary receipt and delivery points for the capacity we  are buying.\nMr. Goodell said that Tennessee's EBB will indicate if the  points on the capacity you are buying are secondary or primary.\nI would  prefer to know the actual primary points on the contract, especially the  delivery points.\nI just bought some Z6-Z6 capacity from Penn Fuel for the balance of the  month.\nSteve Gillespie verified that Penn Fuel released the primary receipt  and delivery point on the contract.\nBut, I'm taking Penn Fuel's word for it  and I am unable to verify the information myself.\nIt could have a big impact  on what we flow in Z6.\nColleen, can we do anything about this through the regulatory process?\nLet  me know if you need specific capacity examples.\n",
 'I made a few small changes to the storage balances on CGAS.\nI had to create  a new deal ticket starting Sep 1st because the name changed from CES to "The  New Power Company".\nJoanne,  I made a change to Aug 31st.\nKyle, I think you need to change tagg.\nLet me know if anyone has questions.\n',
 'I changed the demand charge for Equitrans k#270 on the Aug and Sep  worksheet.\nWould you let me know what the capacity deal tickets are and I  will change Sitara as well.\nthanks\n',
 'Wade, please forward this to the person that pays Statoil.\nAND I just faxed  you a copy of the invoice Kara faxed me.\nI believe Heidi Boyd told me that  ENA was not  making payments to Statoil so CES made the payments.\nLet me  know what you find out.\nPlease include Scott Goodell on all responses.\n',
 'Hey Team.\nI need the following services set up on National Fuel.\nIAS  <== we just created k# A02353 ISS  <== I think we already have this set up on k#H02262 FSS  <== Nat Fuel has not assigned this contract to us yet.\nBelieve me, this all happened really fast.\nI just sent some of the paperwork  to legal and I need it back by Monday morning.\n',
 'We currently have the following transport contracts on CNG for July.\nk#  MDQ  Comment 5A2500  15000  Oak to BG&E  5A2551  4003  Corn to BG&E 5A2551  383  Lebanon to BG&E  5A2526  3947  Corn to Leidy  Total  23,333 dt   Angie and Beavy are working on the fuel waivers for July.\nAnd we can still  take 7950 dth from Cornwell.\n',
 'I just found somehting that will probably stick out when you run the new  demand charges.\nThe TETCO demand charges on the ECT Trans worksheet were not  subtotaled.\nThe total demand for these charges was $18,424.\n',
 "Please check on the purchase from AEC Marketing.\nThe daily volume is 9189,  the deal number is 227196.\nI'm trying to find out if we get reimbursed for  the transport demand charge we pay National Fuel each month.\nThanks\n",
 'Would you please write a description on how Consumers Energy works on the  billing for title transfers?\nI need to explain this to Doug Kenny still.\nThanks.\n',
 'I am taking off half a day PM on Dec 29th and Jan 1st - 3rd.\nPlease put this on Dicks calendar and the desk calendar.\nthanks\n',
 'As of start of business, Wednesday, February 6th, you will have been migrated to the UBSW Energy environment.\nHere are a couple of quick tips and reminders to get you going:  ?\nYou will log in with your Enron NT ID, this will not change  ?\nYou will be asked to change your password, follow the standard Enron rules  ?\nYour desktop will look the same  ?\nEmail will not be affected until Day 1, on which you will have your new UBSWE email address  ?\nAll compliant data and email should be copied to the UBSWE environment no later than Midnight (CST), Thursday, February 7, 2002 (see Data Migration Protocol email for compliancy direction)  ?\nNo data or emails are to be deleted from the system   If you have any questions or concerns, please contact the Resolution Center at x 3-1411\n',
 'Due to a variety of circumstances we did not migrate employees to the UBSWE environment tonight (Monday, February 4, 2002).\nWe will communicate further details of the migration plan on Tuesday, February 5, 2002.\nThank you for your cooperation in advance, please contact the Resolution Center at x 3-1411 should you have any questions.\nUBSW Energy Global Infrastructure\n',
 'Attention UBS Warburg Energy Users:  Please be aware that IT will begin migrations to UBSW Energy this evening.\nPlease log off of your machines tonight.\nWhen you arrive in the morning, you will login with your Enron ID and password.\nYou will be required to change your password immediately.\nYou will also have an email in your Inbox tomorrow morning explaining your "next steps".\nIf you have any questions, please call 3-1411.\nThanks,\n',
 'The contacts we previously had listed for TXU - Master User have changed.\nAll three companies TXU Electric Company, TXU Energy Trading Canada Limited and TXU Energy Trading Company will all be handled by Michael Adams, Risk Control for TXU Energy Trading Company.\nOn first pass they indicated they would be signing up and look forward to trading online.\nHe would prefer to see the information emailed to him including the ETA.\nHere is all of his information:\n',
 'As you are all aware, Enron and UBS have entered into an agreement for the sale of certain assets of the wholesale gas and power trading organization.\nAs part of that agreement, the management of UBS may speak to you over the next several days about an opportunity in that new organization.\nIf so, we encourage you to consider such an offer.\nHowever, if you are not employed by UBS, you remain an Enron employee.\nIf you have specific questions regarding your employment arrangements and job responsibilities please contact Anne Labbe in Human Resources at 5-7809, or feel free to contact either Jim Fallon or Dave Delainey directly.\n',
 'As of start of business, Wednesday, February 6th, you will have been migrated to the UBSW Energy environment.\nHere are a couple of quick tips and reminders to get you going:  ?\nYou will log in with your Enron NT ID, this will not change  ?\nYou will be asked to change your password, follow the standard Enron rules  ?\nYour desktop will look the same  ?\nEmail will not be affected until Day 1, on which you will have your new UBSWE email address  ?\nAll compliant data and email should be copied to the UBSWE environment no later than Midnight (CST), Thursday, February 7, 2002 (see Data Migration Protocol email for compliancy direction)  ?\nNo data or emails are to be deleted from the system   If you have any questions or concerns, please contact the Resolution Center at x 3-1411\n',
 "OK you slackers (excluding Shaw), I'll give you another chance to respond.\nLunch this week or next, let me know what's good.\nIf meeting after work is better for you, let me know.\nCertainly all of you can stop shredding documents for 5 minutes to respond.\nSchroeder\n",
 'FYI,       If your cellular phone bill was submitted for payment prior to December 17th, it was covered under pre-petition.\nMeaning that the invoices were processed and placed in the system, but not paid.\nLet me know if you have any questions.\nThank you,\n',
 'I know that each of you are interested in an Excel class (along with a lot of the floor).\nAs you know, I have started a class with a couple of participants as a test.\nIf the class goes well, I plan to start another class in 2-4 months  (I anticipate each class will last approximately 3 months).\nIf you are still interested when/if I begin another class, you will have first shot at "enrollment".\nRight now I am thinking a class would be 5-7 participants.\nAll of this, of course, depends on whether my two current students feel the class is worthwhile.\nI believe it will be.\nI will keep you up to date.\nI feel I have some specific knowledge that, if I do a good job of relaying to you, will provide a boost to your effectiveness as you move up and through the organization.\nThat is certainly my goal for you.\nPlease feel free to ask questions on the status of the class.\nI certainly hope this works out because teaching is one of the things I really enjoy.\nI apologize to you again for not opening up the initial class to more participants the first time around.\nThanks for your interest.\nGreg\n',
 "It's official!\nDawn and Gary Wilson are the proud parents of a beautiful baby girl.\nShe was born at 10:41am on 9-20-01, and weighed in at 6lbs, 13oz.\nThey named her Grace Elizabeth.\nMom and baby are doing great and the proud  father delivered the news at 1:00pm.\nDawn is registered at Texas Womens Hospital under the last name of Kenne.\nI'm sure you will all join me in wishing the new family lots of joy!\nThanks,\n",
 "Leaving here around 6am for Baton Rouge  to attend a wedding.\nStaying at Barrys' Sat, Sun and Mon.\nStaying at  Carlos Tues nite.\nReturning on Wednesday.\nMike Newsome will be spending  nite here  Wed nite and I am taking him to airport on Thursday.\nHappy  New Year to all the Girons.\nMOM\n",
 'The curve files for Netco will need to be modified before they are used in the new environment.\n1)   On the Publish tab in the Curve File sheet.\nChange the environment name on the 5th row to ermtp Change the service name on the 5th row to 7525 Change the Network Address on the 5th row to ;239.44.16.1;       2) Then hit the   button on the publish sheet and save the new file.\nIf the sheet does not have the button, just save the file, close it, and bring it back up.\n3)\tSave your curves as normal  4)\tAny questions or problems, please give me a call\n',
 'HI:  Thank you for a productive meeting this morning!\nPer our discussion, we will need Risk and Credit Aggregation to pull the same Post IDs in order to have counterparties $ exposure to reconcile.\nIn addition, corporations and its divisions should be matched to arrive to the similar counterparty list, as well as the decision should be made on whether to include ENA Affiliates for this particular exercise.\n',
 'I will be out of the office for the rest of the week, and will return on Monday.\nIrena will be here should you need anything.\nHave a great weekend everyone!\nAlex Villarreal\n',
 "Questions:  What does being short/long a position mean?\nWhat is curve shift?\nWhat affects curve shift?\nWhat are the basic components of a P&L?\nWhat is a swap?\nWhat are different types of swaps?\nWhat is basis?\nWhat is MTM value?\nWhat is Accrual value?\nWhat do you consider stress in the workplace?\nHow do you handle stress?\nExamples of a stressful situation?\nWhat do you consider long work hours?\nSome aren't technical.\nI don't have any problem solving questions.\nDG\n",
 'I am still trying to recruit.\nIt seems everyone is out of town that  weekend.\nWhen is the deadline?\nLet me know.\nOh, I almost forgot,  Congratulations!!\nDG\n',
 "Mike,  The reason my mistake was not caught on the benchmark signoff procedure is  that the postid in question did not have a net position.\nThe procedure  Rahmann showed you is where we check GERMS positions to the position reports  we run using Excel queries.\nIf a postid has a net position and is not  officialized, it will be caught using this procedure.\nIt will not, however,  if the postid does not have a position.\nI understand the importance of  officializing postid's, as does the entire West desk.\nThanks.\nDG    3-9573\n",
 'Regina,  As we discussed yesterday, I need access to West deals in Sitara.\nAt a  mininum I still need access to all Chicago/Midwest deals also.\nThanks.\nDG    3-9573\n',
 "John,  My name is Adrian Clark, I am an executive recruiter in the energy industry.\nOne of my industry sources gave me your name but was not specific as to what you do for Enron.\nMy firm, First Call Associates, is currently doing a search for qualified front office personnel to present to our clients.\nI would like to know more about your background so I can discuss potential new job opportunities if you are interested.\nIf the timing is not right for you at this time, I've included my contact information for future reference.\nYou can find more information about my firm at www.firstcallassociates.com.\nWe are very familiar with the nuances of the energy trading business and have built relationships with many energy companies in North America enabling us to present qualified employees for their consideration.\nBe assured that any information we discuss will be completely confidential.\nMy apologies for sending this to your email at work but I have not been able to reach you by telephone during business hours.\n",
 'AUSTIN-BRAZOS-BURLESON-COLORADO-FORT BEND-GRIMES-HARRIS-HOUSTON- LIBERTY-MADISON-MONTGOMERY-POLK-SAN JACINTO-TRINITY-WALKER-WALLER- WASHINGTON-WHARTON- INCLUDING THE CITIES OF...BRENHAM...BRYAN/COLLEGE STATION... CALDWELL...COLDSPRING...COLUMBUS...CONROE...CROCKETT...EL CAMPO... WHARTON...GROVETON...TRINITY...HEMPSTEAD...HOUSTON...PASADENA... HUNTSVILLE...LIBERTY...LIVINGSTON...CORRIGAN...MADISONVILLE... NAVASOTA...RICHMOND...SUGARLAND...SEALY...BELLVILLE 525 AM CST TUE JAN 1 2002   ...WINTER STORM WATCH TODAY AND TONIGHT...   LIGHT RAIN WILL DEVELOP OVER SOUTHEAST TEXAS TODAY.\nTHE RAIN WILL CHANGE OVER TO SNOW AS THE DEPTH OF THE ARCTIC COLD AIR INCREASES OVER THE REGION.\nCOLD AIR WILL DRAIN SOUTHWARD AS THE PRECIPITATION CONTINUES TO DEVELOP.\nSNOW WILL BE POSSIBLE OVER AREAS NORTH OF A LINE FROM BRENHAM TO LIVINGSTON THIS MORNING.\nSNOW SHOULD BE ON THE INCREASE THIS AFTERNOON AS FAR SOUTH AS THE INTERSTATE 10 CORRIDOR.\nSLEET WILL BE POSSIBLE SOUTH OF INTERSTATE 10 MAINLY LATE THIS AFTERNOON.\nEXACT SNOW AND SLEET AMOUNTS ARE DIFFICULT TO PINPOINT AT THIS TIME.\nONE TO TWO INCHES COULD ACCUMULATE BY WEDNESDAY MORNING FOR AREAS GENERALLY ALONG AND NORTH OF A BELLVILLE TO HUNTSVILLE TO LIVINGSTON LINE...AMOUNTS OF 1 INCH OR LESS SOUTH TO INTERSTATE 10... NO SIGINFICANT ACCUMULATIONS ARE EXPECTED OVER THE COASTAL COUNTIES.\nTHE SNOW SHOULD COME TO END LATE TONIGHT OR EARLY WEDNESDAY MORNING.\nAS THE TEMPERATURES FALL THE THREAT OF WATER BEGINNING TO FREEZE ON ROADWAYS WILL INCREASE THROUGHOUT THE AFTERNOON FROM NORTH TO SOUTH...BY EVENING WATER ON ROADWAYS MAY FREEZE AS FAR SOUTH AS A WHARTON TO HOUSTON TO WINNIE LINE...ESPECIALLY ON ELEVATED ROADWAYS AND BRIDGES.\nPERSONS WITH AUTOMATIC SPRINKLERS SHOULD TURN THEM OFF TO AVOID SPRAYING WATER ON TO THE ROADWAYS IN TURN AGGRAVATING THE THREAT OF ICY ROADWAYS.\nMOTORISTS SHOULD BE ALERT FOR DETERIORATING DRIVING CONDITIONS THROUGHOUT THE DAY AND NIGHT.\nEVEN IN METRO HOUSTON...DRIVING COULD BECOME DANGEROUS.\nANY LIQUID LEFT ON ROADS WILL FREEZE...ESPECIALLY ON LIGHTLY TRAVELLED SECONDARY ROADS.\nTHE INCLEMENT WEATHER IS BEING CAUSED BY A STRONG UPPER LEVEL STORM SYSTEM THAT IS FORECAST TO CROSS THE REGION THIS AFTERNOON AND TONIGHT.\nTHE SYSTEM IS FAST MOVING AND SHOULD BE EAST OF THE AREA BY WEDNESDAY MORNING.\nTEMPERATURES WILL RISE ABOVE FREEZING OVER THE ENTIRE AREA WEDNESDAY MORNING...ALLOWING ANY ACCUMULATED SNOW AND SLEET TO MELT.\nVERY COLD TEMPERATURES ARE EXPECTED WEDNESDAY NIGHT.\nANY WET AREAS LEFT ON ROADS WILL FREEZE HARD AS TEMPERATURES FALL INTO THE 16 TO 25 INLAND AND NEAR 30 ON THE IMMEDIATE COAST.\nYOU MAY WISH TO CONSIDER MAKING PREPARATIONS TO WRAP EXPOSED PIPES AND ARRANGE FOR PETS AND PORTABLE PLANTS TO BE BROUGHT INSIDE.\nSTAY TUNED TO NOAA WEATHER RADIO AND LOCAL MEDIA FOR THE LATEST FORECAST FROM THE NATIONAL WEATHER SERVICE.\nA WINTER STORM WARNING MAY BE ISSUED LATE TODAY IF THE THREAT OF SIGNIFICANT WINTER WEATHER INCREASES.\n',
 "Please make certain that all physical positions are loaded correctly in NCD  for term.\nHave Patti Sullivan load all transport from the transport model in  sitara so that the physical index positions will be recognized in NCD.\nThis  would include SJ/Perm to Socal through OCT, Baja through MAR 20001 (100,000/d  short PG&E Topock, 20,000/d long KRS, and 80,0000/d long Citygate), Kingsgate  to Malin(Barry), Steve South's latest transport deal from Kingsgate/Stanfield  to Malin, and any SJ to Waha transport.\nAnne, did you get a ticket from Steve on the transport mentioned above?\nKing/Stan to Malin.\nAlso, let me know what the status of the transport deal from Kingsagte to  Malin with Barry.\nIs the gd index for Perm position loading correctly in NCD for Apr-Oct?\nMo, please carry out the physical positions in NCD through Mar 2001.\nThanks!\n",
 'Take a look at the rates for Cayman.\nWe should try to get a corporate  conference rate.\nI will have Ina look into that possibility.\nCancun is not  an option in March and April - all booked.\nMike\n',
 "I have asked Bob Badeer to help us research what the utilization rate of gas  fired plants in the west was last year and what, if any, the impact of lower  hydro and even warmer temps would mean to gas consumption in 2001.\nWe need  to account for any political changes in air pollution credits this year that  may increase gas consumption in 2001.\nLet's discuss in the afternoon.\n3:30 meeting.\nGrigsby\n",
 "Bobby,  You love my glasses, don't you?\nLet me know when you can send those down to  me.\nMail to the office senor.\nYou are the King.\nGrigsby\n",
 "I received an email this morning regarding the reports viewer.\nI agree with  restriciting the access to these sensitive reports, but I don't agree with  removing myself from those allowed to review positions.\nI not only run one  of the largest financial books on the floor, but I also manage the West  physical book.\nPhillip Allen passed on the IM WEST physical book to me two  months ago.\nWhile Phillip acts as manager of the sub books in the west, I am  managing all physical positions.\nMike Grigsby\n",
 'Good morning.\nAny news on the spread products for the west?\nThe titles are  Baja and Redwood spreads.\nCall me to discuss.\nDale is aware of these.\nThanks,\n',
 'I logged into the trading cluster and it appears that it is quite similar to  general cluster.\nCan we please load the programs that I emialed you  earlier?\nI am going to be out of the office in the next few weeks and I will  need access to all trading apps.\nThank you for your assistance.\nSincerely,\n',
 'Matt, your new responsibility for 7:30 meeting will be to go over all gen  outages in the west by region and fuel type, and to discuss the previous days  gen numbers and load forecasts.\nIncluding pricing info and heat rates from  the Portland guys and/or Megawatt Daily will also help.\nEffective on  Thursday.\nThanks,\n',
 'Personal & Confidential  Marc:  Attached are revised clean and blacklined drafts of the Form 8-K and Press Release for your consideration.\nThe blacklined versions reflect changes to your prior drafts.\nI am still awaiting comments from our commercial personnel, but I wanted to forward the drafts to you so that you could begin your review.\nTherefore, the drafts may be subject to further comment.\nI will try to obtain any final comments from our working group as soon as possible.\nRegards,\n',
 'CUIABA Furnas: Nothing particularly new to report since last week, other than it appears we are likely to get the consent documents signed Tuesday or Wednesday.\nThese documents reflect a resolution to the consent issue and the Resolution 49 regulatory issues that changed some of the risks under the PPA.\nAs reported last week, one of the reasons Furnas/Electrobras have agreed to sign is because the two difficult issues regarding (i) the validity of the Electrobras guaranty following privatization; and (ii) political force majeure allowing a "put" option for Brazilian governmental acts, were deleted from the Furnas consent documents and will be negotiated separately with the Brazilian government over the next two weeks.\nThese issues must also be resolved for financing.\nGT11/12:  Repairs still on schedule to meet requirements under the PPA for the changeover to gas by year end.\nSiemens and our engineers will meet with the underwriters in London tomorrow to discuss the root cause of the failures.\nStill no written confirmation of coverage, but we currently do not anticipate a problem.\nShell:  Preparing for mediation to be held in Toronto November 5-7.\nANNEX V  After reporting last week that the cost pass through suits had been filed, I learned that Orlando Gonzales made the commercial decision to hold off on those suits because of significant progress he made in negotiations with the Brazilian government for resolution of these issues and Annex V.  Elektro received some of the information from ASMAE for calculating its numbers; however, as of Friday it had not received the information for the rationing period, the relevant period for calculating the set off.\nI talked with Vasco this morning and he believed this information was received today and will confirm.\nIf the information is not forthcoming, we are prepared to file a suit to compel it.\nI will stay in touch with Orlando this week to determine if and when we can file these suits without interfering with his negotiations.\nRegards,\n',
 "Mark - I just wanted to update you regarding this Thursday's program with  the ADL and Judge Bobby DeLaughter.\nThose in the legal profession can receive 1 CLE for attendance.\nThanks for sending out the memo last week to Enron's legal team.\nLaura\n",
 "Could I ask the two of you to please insure that there is a refreshed view on the legal risks relative to both our and El Paso's litigation on East Coast Power.\nIf this has already been covered, then I apologize.\nI just want to make sure Louise has the best data points for making a decision on my proposal of this morning.\nThanks,\n",
 "Management Committee Members:  In light of today's meeting being canceled, we would like for you to give consideration to Jeff Huff as a candidate for Commercial Support VP.\nJeff has interviewed with Mark Frevert, Ray Bowen and Steve Kean who have given favorable feedback.\nAt this time, we would like to proceed with an offer.\nPlease contact us with any concerns or questions by the close of business Thursday.\nIf we have no opposing votes, we will proceed.\nBelow are a few points and a resume for your review:  Resume: Currently the second most productive Partner at Diamond-Cluster, a technology consulting firm.\nHe has been working at Enron for the last 2+ years, first for Tom Gros in EBS and Net Works and then for Dan Reck in Freight, developing trading systems.\nThe Job: We are looking to bring Jeff in as VP, Commercial Support.\nThe demands of growing the group require a consistent focus on technology, expenses, front and back office productivity, as well as constant re-analysis of growth strategies.\nJustification: Jeff's capabilities in these areas make him extremely qualified.\nWe rely on him heavily already, but at consulting rates he costs us more than $1.3mm per year and his focus is limited to technology.\nMost importantly, the lead commercial folks in the group are overburdened with administrative issues and spending too little time bringing in earnings.\nThank you.\n",
 'Shigeki Kawano, who has been the head of our office in Tokyo since it opened in April 2000, has resigned from that position effective December 31.\nHis immediate plans are not yet determined, but we hope that whatever his next endeavor is he will have an opportunity to remain involved in ISDA activities.\nWe have enjoyed having him as a colleague and appreciate his efforts on behalf of the Association.\nI am sure that each of you join me in wishing him well in the future.\nBob\n',
 'Rex: Would you take exception to my pulling Gil into some of our M&A activities?\nA number of them (for example, NEPCO) fall within the Dick Lydecker world and I would think this makes sense as we organize our efforts to sell investments/assets/businesses..\nPlease advise.\nJordan\n',
 'Plans for the reporting of the consolidated DPR are:  For trading date Friday, December 28th - No DPR For trading date Monday, December 31st - Our goal is to publish this in preliminary form by the end of the day Monday, 1/1/02.\nPlease call me if you have questions or comments about this reporting schedule.\nI wish you all a happy New Year.\nRegards\n',
 "The FBI has uncorroborated evidence of possible terrorist attacks against the United States.\nReportedly, unspecified groups are targeting suspension bridges on the West Coast beginning Friday, Nov. 2 and continuing through Wednesday, Nov. 7, 2001.\nNo further information about this alleged attack is known at this time.\nThe FBI is attempting to verify the validity of this report.\nIn the meantime, California officials are increasing security at the state's suspension bridges, and the National Guard has been authorized to assign troops to protect the bridges.\nWe shared this information with our West Coast employees earlier in the day.\nIn the current circumstances, we are likely to see these bulletins fairly frequently.\nWe don't want to alarm you, but we do want to keep you informed, so we will continue to disseminate this information.\n",
 'Mark,  Great news about the deal.\nCan I please be provided with copies of the Dynegy documents?\nSenior management here, and elsewhere no doubt, have lots of questions about constraints on the business going forward, what could prevent merger taking place etc.\netc.\nIs it planned that summaries of key provisions be prepared centrally and circulated?\nThanks.\n',
 'Attached is the latest report on the DYNEGY/ENRON deal from CS First Boston Research.\nPlease feel free to contact us if there is anything we can help you with.\nThanks,\n',
 'Mark:  \tI did not want to make a big deal of this at the OGC Meeting, but if a legal transition team is formed, I would like to be considered for membership.\nI feel that my strengths are what may be needed on such  a committee.\nThanks,\n',
 "David,  Late last week, I received a call from Kristen Kracraft, who does employment law at Dynegy.\nShe indicated that they would like for there to be a protocol for how to handle things if there is a desire to allow the hiring of employees from Dynegy to Enron or vice versa.\nOf course, such hiring would have to be coordinated at the top of the company to avoid any type of free-for-all.\nAt a minimum, I would think that you and Andrea Lang would have to be the ones who make the decisions.\nWith that thought, I have asked Tim O'Rourke's team to work on such a protocol.\nIn the meantime, Kristen mentioned that one person in Rick Shapiro's group wants to go to Dynegy.\nShe understood that Shapiro had said it was ok.  Do you know about that?\nIf not, should you give Andrea a call about it?\nI am concerned about the floodgate effect, so I believe we should proceed with extreme caution.\nLet me know your thoughts on this.\nMichelle\n",
 'Keith:  Lance Schuler asked me to send you the attached draft letter in hopes that we could discuss these points today.\nI understand Lance suggested an 11:30 meeting.\nPlease let me know if that will work for you.\nThanks.\n',
 'Mark;  I have already spoken with Brett Wiggs about the SA legal group but both Orlando Gonzalez and John Novak are no longer at V&E offices.\nThey have also checked out at the hotel.\nIf Novak calls you, I will be available on my cell (011-55-11-9233-7436) or home (011-55-11-3062-5608).\nRgds,  Sami\n',
 "Dear Mr Mark E  Haedicke  From 4-7 February 2002, be at Asia's largest dedicated senior management level forum dedicated to power industry professionals.\nNow into its 5th year, Asia Power 2002 is Asia's largest market place for the power industry.\nAsia Power is your best marketing and sales opportunity in 2002.\nThis is the annual meeting place where the power generation and electricity industry networks, learns and does business.\nEnergy market specialists, regulators, utilities, government ministers, heads of project finance, consultants, lawyers and developers all convene at Asia Power.\nIf you want to be among the best and you have the authority to make the difference, then you must be at Asia Power 2002 - Where Asia's power brokers and elite converge!\nTo secure your place, call Suzanne Voo NOW on +65 322 2755, mailto: suzanne.voo@terrapinn.com or visit www.utiliconforum.com/asiapower_2002.\nSee you in February next year!\nBest regards\n",
 'I would like to change our policy regarding taping telephone trades.\nI  propose the following:  1.\nRetention Period  -- change the retention period from 4 months to 2\n',
 'I spoke to Dr. Emilio Pinto, at the Sao Paulo lawfirm of Tozzini Freire about  joining ISDA.\nHe and his firm are doing a lot of work for Enron.\nHe is  familiar with ISDA and said he was interested in joining.\nI told him he  would get a call and some materials that he could present to his Executive  Committee.\nI reviewed with him the cost of $10,000.\nPlease give him a call  at 011-551-1-2322100.\nI think he could help build membership in ISDA in  Brazil and eventually become a rep office for ISDA in South America.\nHe goes  by Emilio.\nI am working on a lawfirm in Argentina.\nLet  me know if you have  any questions.\nRegards,\n',
 'Wes, I am forwarding the monthly report on Legal.\nIt seems to be  inconsistent with the legal budget numbers in the QBRs.\nOverall, it shows  Legal is slightly over budget for the year.\nCould you have someone compare  the numbers and let me know if the monthly report is correct.\nMark\n',
 'Jim, I am looking for weather data by region for 98 and 99.\nI believe that  there was a lot of extreme weather this year and I am looking to support  that.\nThis is background info to support the arguments for standardized  power contracts,  which are nearly agreed to.\nLet me know what there is and  who I should talk to.\nThanks for your help.\nMark\n',
 'Please work with Richard Sanders to decide on the distribution list which  should include all MDs and Robert Knight.\nI want to get it out by  Wednesday.\nMark\n',
 'Effective today, there is a new legal review procedure for physical power  contracts that are individually negotiated, with a term longer than one  year.\nPlease notify me (Janette will maintain a list of contracts,  counterparties and status) when drafting starts on such power contracts and  provide me with a draft with sufficient time to make comments prior to  closing.\nMy objective is to insure a consistent approach on these power  contracts.\nThanks for your cooperation in this matter.\nPlease forward this  memo on to the lawyers on your team.\nMark Haedicke\n',
 'The attached report summarizes current significant legal activities of EWS  Legal as of October 15, 2000.\nThis report does not attempt to list all  transactions or include reference to on-going maintenance of completed  transactions.\nPlease let me know if you have any questions.\n',
 'Many of you have received requests for feedback through the Performance  Evaluation Program ("PEP") system.\nThis feedback is used by the Performance  Review Committee in conducting its evaluations and also is used in preparing  the written performance reviews.\nPlease take the time to complete the forms and provide candid, accurate  feedback when it is requested.\nThe deadline for completing evaluation forms is November 17th.\nMark Haedicke and Michelle Cash\n',
 'Jane:  ISDA is planning an energy seminar in Tokyo in mid-May.\nWe have heard there  may be an energy seminar in March or April in Tokyo.\nHave you heard of the  earlier seminar?\nWe are trying to decide whether it makes sense to go  forward on the May seminar.\nCould you look into this and talk to the traders.\nThanks for your help.\nRegards,\n',
 'Janette:  Please make contact with the gem broker below and set a time where I can meet  him and look at some topaz, emeralds and opals.\nI want to look at loose  stones.\nI may need to talk to him before I go.\nMark\n',
 'Over the past several months, we have reviewed in detail our trading  contracts and the companies through which we conduct our trading business in  California.\nIn order to reduce Enron\'s non-market risks ( e.g.\nlegal, credit  and regulatory) in the volatile commodity markets in California or any "  future California", we propose the following changes:  1.\nMandatory Uniform Set-Off Provisions in All Trading Contracts for All  Commodities -- set-off language varies commodity by commodity in trading\n',
 'This is a notice to inform you that the server where your Outlook mailbox resides is scheduled for an outage tonight.\nYour mailbox will be temporarily unavailable starting anytime after 8pm and may continue to be unavailable until 12 a.m., when all server maintenance work have been completed.\nOutlook Web Access (OWA) will also be unavailable during this time.\nBlackberry users:  Message delivery may be delayed for a few minutes.\nIf you have any questions, please call the Resolution Center at x31411.\n',
 'The Teams intent as commissioned by John Keller and Jerry Martin was to outline roles and responsibilities as they relate  to the ETS Project Processes.\nThe Team has worked fervently over the last several months with the intent of improving our current process.\nPlease review the attached document with your respective Team members and provide   comments by December 5th.\nPlease direct your responses or questions to Dennis Alters (713) 853 6586.\nDennis will  coordinate with the appropriate Team members for response.\nThanks,   \t\t\t\t      "The ETS Project Process Team"\n',
 "Dick Lydecker and I had a conversation today (Monday, Oct. 22) with Noel Watson, the Chairman and CEO of Jacobs, concerning interest in NEPCO.\nNoel had been out of the office most of last week due to the death of his mother in law.\nWe discussed the potential of Jacobs acquiring NEPCO over a period of time.\nNoel listened, but it was difficult to determine his interest.\nWe outlined a program where Jacobs, after a confidentiality agreement is in place, would send a couple of people to meet with Dick and I for a one day summary review of NEPCO.\nIf there is interest from that review, then we would proceed to a management introduction and due diligence.\nNoel stated he would keep our approach in confidence, but needed to review the opportunity with a couple of people and would get back to us next Monday, Oct. 29.\nFrom past experience, I know Joe Jacobs, the founder, will be involved in any acquisition decision and I am sure that is the focus of Noel's review.\nI am sure Noel will also test his sources on NEPCO.\nIn a side note, Jacobs shares have been doing very well as of late and are almost back to their historic high.\nKeith Dodson\n",
 'In reference to recent developments and financings, attached for your review is a consolidated listing by business entity of the Enron Corp. credit support that is held or in process.\nAlso, I have included the unsecured trading positions.\nIf there are any questions or additional information is needed, please advise.\nRegards.\n',
 'Stan:  I spoke to Mike Miller regarding the opportunity in Enron Wind.\nHe is interested in the position and would be willing to meet with you as early as next Monday.\nMike can be reached at x36556 or his cell (713) 628-5958.\nHope this helps.\nKevin\n',
 'Rod:  As we discussed here are the bulletts that summarize what we heard from our consultants.\nOverall demand picture  Believe it will be 2006 before the California market will get back to 2000/2001 demand levels            2002           demand down approximately 900 mmcf/d           2003      demand will be flat           2004      growth in demand will begin           2005-2006 return to 2001 demand levels  Reasoning:     2001 was a dry year - the lack of hydro generation created an additional    600 mmcf/d demand for gas in California    Anticipated generation capacity overbuild in California - new more    efficient power plants with better heat rates will displace older gas    fired generation, reducing the amount of gas required to generate a MW    of electricity on the margin    California electricity rate increases have curtailed demand for power    and subsequently, gas  Gas transmission capacity into the state  Over the next two to three years there will be an additional 2.0 Bcf/d of transmission capacity into California     800 mmcf/d in 2002    900 mmcf/d in 2003 (Kern River expansion)    300 mmcf/d                 (El Paso conversion of All American oil line    and power up)  San Juan basin gas  San Juan basin production is declining     first half of 2001 vs. first half of 2000 production off by    approximately 200 mmcf/d    Rockies gas will not replace declining production in the San Juan    San Juan gas will move closer to Permian pricing    The consultants believe that the combination of these factors will put decontracting pressure on existing transmission into the state of California, and especially the El Paso and Transwestern lines.\nHowever, the "wild card" in their view is unforeseen California power demand growth.\nAs we discussed, JPMorgan would like to hear your views on the above issues.\nPlease give me a call when you have had sufficient time to digest and we can set up a conference call to make the most efficient use of your time.\nThanks Rod  Brent  Also, when you have had a chance to look at sales gas volume growth please e-mail the volume numbers to me...thanks\n',
 'A mandatory meeting requested by Ray Bowen has been scheduled for today at 2:00 PM in EB 2021 to discuss cash forecasting requirements.\nWe apologize for the short notice.\nThank you,\n',
 'Hello Stanley and Jim   Attached please find the weekly report for October 21, 2001.\nPlease let us know if you have any questions.\nSaludos, Elio\n',
 'We would like to file both the accounting and legal responses by the end of the week.\nCan you let me know the latest status of the responses related to EGP Fuels.\nThanks.\n',
 'In reviewing my outstanding file folder, the following counterparties are still unfinished, yet in the Financial Lotus Notes Database their documents have been executed.\nPlease let me know when we can expect to receive the executed documents for final processing.\n?\nEnron Metall Recycling  GmbH & Co. KG/RMT, CP #92854 ?\nEnron Metals & Commodity Limited/RMT, CP #80550 ?\nGrupo Minsa, S.A. de C.V./ENA, CP #100027 ?\nQuark power LLC/ENA, CP #103757 ?\nSmith Barney AAA Energy Fund L.P./ENA, CP #77297 ?\nXL Trading Partners Ltd/ENA, CP #89395   Thanks,\n',
 'Marie - Here is the document with your most recent changes incorporated.\nWe should probably think about preparing a deemed ISDA with the same concepts included.\nThanks.\n',
 'Marie - per our conversation last week, attached are the proposed Schedule and Credit Annex Paragraph 13 for your review.\nPlease call me after you have had the chance to take a look at it.\nI can be reached at 315-460-3344.\nPatty Snyder  (See attached file: ENRON - Para13(nmemdrft8-7-01).doc)(See attached file: ENRON - SCHEDULE(nmemdrft8-7-01).doc)   - ENRON - Para13(nmemdrft8-7-01).doc   - ENRON - SCHEDULE(nmemdrft8-7-01).doc\n',
 'We have received an executed First Amendment to Master Agreement by and between Kerr-McGee Energy Services Corporation (f/k/a HS Energy Services, Inc.) ("Kerr-McGee") and Enron North America Corp. dated effective as of November 1, 2001, which amends a) the cross-default threshold for Kerr-McGee, b) the collateral threshold for Kerr-McGee, c) the delivery and return amounts, d) the material adverse change clause for Kerr-McGee, and e) provides for a new Credit Support Provider for Kerr Mc-Gee, as well as a new Guaranty from such Credit Support Provider (such Guaranty has also been received).\nCopies will be distributed.\nStephanie Panus\n',
 'Hi, Marie, hope all is well.\nIn order to complete our conflicts checks on two counterparties, we need to know exactly which Williams and British Energy Power and Energy Trading Limited entities/subsidiaries will be involved in the Master Netting Agreements.\nPlease let me know.\nAlso, going forward, we will need this type of information for any new counterparties added to the current list.\nThanks and please call with any questions.\nBest Regards,\n',
 'Marie, \tSince Jay is out this week, I\'ll be "working" on the master netting for Forest Oil and Noble Affiliates.\nWhen these are ready to go out please send a copy to me so I can advise the counterparties.\nThank you.\nMax\n',
 'You know, you have to WRITE emails to GET emails...and I would hardly call your last two, WRITING..they were just acknowlegements of your existence, not your normal informative form of communication.\nWELL???\n?\n',
 'After much success last year with our AskWhy advertising campaign and Public Relations efforts, Enron continues to explore new ways to exponentially increase its\' brand awareness not only through television, but also by exploring new mediums.\nOne approach is through customer relationship marketing (CRM), where we will seek opportunities that allow our commercial teams to directly interact with important CXOs and existing customers.\nTo this end, we are proud to announce our participation in the Frank Gehry Architect Exhibition at the Guggenheim Museum in New York City, which will be open to the public from May 18 through August 31.\nFrank Gehry is a world-renowned architect who has designed the unique building at the end of our "Ode to Why" commercial and his art dominates skylines around the world.\nWith this exhibition, Gehry\'s evolving genius comes to life.\nFor years, his inspiration has long been hidden in sketches and models unseen by anyone but his closest collaborators.\nBy challenging the conventional, he has redefined his industry just as Enron has in business.\nThrough Enron\'s association with this world-class exhibit, we will subtly push our brand attributes forward, as we strive to be the "Leading Company in the World."\nAll employees are invited to visit this exhibition FREE OF CHARGE with an Enron ID Badge beginning May 18.\nFor more details, please visit home.enron.com.\n',
 'During our United Way 2000 Campaign that was held last fall, you were kind enough to pledge a contribution to the United Way.\nOur records indicate that your preference was to pay by check.\nIf you have already paid your contribution, thank you!\nIf you have not, we wanted to provide you with the information that you need in order to send in your contribution.\nAll checks should be made out to the United Way of the Texas Gulf Coast.\nThey can be sent interoffice mail in a confidential envelope to the attention of Zulie Flores, EB 1612.\nIf for some reason, you do not know the amount that you pledged, you can call Zulie at  3-3908 and she will be able to assist you.\nWe had such a successful campaign last year and it was due in large part to your generosity.\nThank you for your support of this very important program - you did make a difference!\n',
 'GMAT REVIEW AT ENRON  The next GMAT review course at Enron will begin the week of October 15th.\nTwo schedules are being offered: \tCourse # 7129-00:  Tuesdays, Oct 16 - Dec 11 (no class Nov 20) \tCourse # 7129-01:  Thursdays, Oct 18 - Dec 13 (no class Nov 22) PLEASE NOTE that the two schedules are not interchangeable; employees should enroll in their preferred schedule and stick to that schedule.\nCourse details: \t- Class is held at Enron in room ECN560 and is restricted to Enron employees \t- Each course is limited to eight students \t- Meets once a week for eight weeks \t- Hours are 6:00-9:00 PM (first session will run til 10:00 pm to \t\tinclude initial exam) \t- Expect 4-5 hours of homework per week \t- Course includes a total of four practice GMAT exams \t- Ends the second week of December, allowing employees to take the \t\tGMAT in December and meet a January application deadline.\n- Special discount of $200 off the regular Princeton Review tuition Enron has allowed this program to be hosted in the Enron Building for convenience of its employees.\nIndividuals are responsible for paying their own fees.\nFinancial support from Enron is at manager\'s discretion and is subject to the usual tuition reimbursement constraints around budget and relevance to organizational performance.\nHOW TO ENROLL: \t1.\nPrint out the attached registration form.\n2.\nComplete the form, but please note the following  \t\tSPECIFIC INSTRUCTIONS: \t\tA.\nFill out the student information completely, including \t\t\tyour email address.\nB.\nIn the Enrollment section, where it says "Please enroll \t\t\tme in GMAT Class Size-8 Course # _________",\n',
 "Juan,  FYI .\n.\n.\nJoe and I swapped days, Joe picked up Nov 4 and I picked up Dec 14.\nI know you don't care but I wanted to let you know.\nThe schedule has been changed to reflect this.\nSeely\n",
 "When: Thursday, November 01, 2001 9:00 AM-2:00 PM (GMT-06:00) Central Time (US & Canada).\nWhere: EB3127 for Nov. 1st from  9:00 am - 2:00 pm  *~*~*~*~*~*~*~*~*~*    AGENDA: 9:00A  to 11:00A Kevin Burns will be here from OATI to provide specifications and describe in more detail the functionality of Web Trader.\n11:30 to 2:00 PM  Our goal is to have representatives from the 24-Hour Group and the IT Group bring specific questions for Kevin.\nLet's determine if WebTrader can be flexible enough to replace the P&L (Delphi) application, interact with Enpower, and provide a good detailed database for historical information.\nMost importantly, is this application fast and efficient enough to add value to the 24-hour group.\nCall me with any questions or to discuss.\n853-0421  Thanks,\n",
 "The Corporate Internal Communications team would like to thank each of the 5,142 employees who took the time to complete our survey.\nAs promised, here are the numerical results.\nWe will cover the survey in its entirety - including some of your individual comments and the steps we're taking to enhance our programs - in the August issue of Enron Business.\nWatch for it!\nSurvey respondent demographics:  Houston office\t54.4% U.S.\nDomestic, non-Houston\t24.9% International office\t20.7%  Do you believe Enron's corporate internal communications programs (eBiz, eThink, Enron Business, ETV, floor meetings, etc.)\nare generally effective and useful?\nYes\t83.3% No\t16.7%  Do you believe the information you receive in eBiz, Enron Business, eSpeak, ETV and at employee meetings is credible?\nYes\t90.9% No\t9.1%  Have you ever used the following tools as an information or research resource?\n(Check all that apply.)\neBiz\t43.2% Enron Business\t\t34.2% eSpeak transcripts\t23.5%  Do you read eBiz (Enron's corporate online informal news source)?\nYes\t64.7% No\t35.3%  If yes, which of the following eBiz features do you read?\n(Check all that apply.)\nBusiness articles\t58.3% In Layman's Terms\t35.2% Short Cuts\t32.9% The Last Word\t31.2%  If no, I don't read eBiz because:  I don't have time\t66.1% I get my Enron information from other sources\t30.9% I don't find the content credible\t3.1%   eBiz is posted fortnightly - every two weeks.\nHow frequently would you like to get eBiz?\nMonthly\t26.9% Every two weeks (as is)\t58.0% Weekly\t11.5% Daily (email format)\t3.6%  How do you generally read Enron Business (Enron's all-employee print and online in-depth publication)?\nPrint\t39.7% Online\t23.4% Both\t12.9%  If you read Enron Business, what do you think of the new design?\nLike it\t94.7% Don't like it\t5.3%  Do you ever share the print version of Enron Business with your spouse or family?\nYes\t43.4% No\t56.6%  Which of the following Enron Business features do you read?\n(Check all that apply.)\nBusiness articles\t63.6% The Insider\t\t41.1% Extreme Enron\t\t38.5% Community stories\t38.2% Generally Speaking?\n36.3% Back page (contests)\t32.6%  Which of these eThink tools do you use?\neSpeak\t31.2% eMeet\t4.2% The ThinkBank\t7.7%  What speakers would you like to see featured on eSpeak?\n(Check all that apply.)\nKen Lay/Jeff Skilling\t52.8% Business unit CEOs\t52.2% Subject matter experts\t55.6% External speakers\t37.2%  How many all-employee meetings have you attended (or watched via IPTV or video teleconference) in the last year?\n0\t32.5% 1\t36.6% 2\t30.9%  If you have attended an all-employee meeting, did you find it to be informative and beneficial?\nYes\t86.6% No\t13.4%  Do you think all-employee meetings should be held more than twice a year?\n(i.e., quarterly)?\nYes\t44.6% No\t55.4%  What information do you want covered at an all-employee meeting?\n(Check all that apply.)\nBusiness strategy\t78.7% Financial and operating results\t69.1% Human Resource issues\t55.4% Competitor information\t49.6%  For Houston office only: Irrespective of technical problems, what do you think of ETV (elevator television) as a communication medium?\nLike it\t90.9% Don't like it\t9.1%  Would you use ETV to advertise one of your Enron projects or campaigns?\nYes\t69.6% No\t30.4%  If you have used ETV to advertise, did you find it effective?\nYes\t9.1% No\t3.3% Haven't used it\t87.6%  Which ETV segments do you like?\n(Check all that apply.)\nEnron announcements\t39.4% Streaming cable news\t34.8% Rebroadcast interviews with Ken and/or Jeff with CNN, CNBC, Bloomberg, etc.\n32.5% The Building Guy\t29.8% Vision & Values ads\t13.8%\n",
 'I am pleased to announce the formation of the Enron Management Committee.\nThe Management Committee comprises our business unit and function leadership and will focus on the key management, strategy, and policy issues facing Enron.\nThe Management Committee will supplant the former Policy Committee and will include the following individuals:  Ken Lay - Chairman and CEO, Enron Corp. Ray Bowen - COO, Enron Industrial Markets Michael Brown - COO, Enron Europe Rick Buy - Exec VP & Chief Risk Officer, Enron Corp. Rick Causey - Exec VP & Chief Accounting Officer, Enron Corp. Dave Delainey - Chairman and CEO, Enron Energy Services Jim Derrick - Exec VP & General Counsel, Enron Corp. Janet Dietrich - President, Enron Energy Services Jim Fallon - President & CEO, Enron Broadband Services Andy Fastow - Exec VP & CFO, Enron Corp. Mark Frevert - Chairman & CEO, Enron Wholesale Services Ben Glisan - Managing Director & Treasurer, Enron Corp. Mark Haedicke - Managing Director & General Counsel, Enron Wholesale Services Kevin Hannon - CEO, Enron Global Assets & Services Stan Horton - Chairman & CEO, Enron Transportation Services Jim Hughes - President & COO, Enron Global Assets & Services Steve Kean - Exec.\nVP & Chief of Staff, Enron Corp. Louise Kitchen - COO, Enron Americas Mark Koenig - Exec VP, Investor Relations, Enron Corp. John Lavorato - President & CEO, Enron Americas Mike McConnell - President & CEO, Enron Global Markets Jeff McMahon - President & CEO, Enron Industrial Markets Jeff Shankman - COO, Enron Global Markets John Sherriff - President & CEO, Enron Europe Greg Whalley - President & COO, Enron Wholesale Services   \tAfter we convene the Management Committee later this week, I will make a further announcement regarding the Executive Committee.\n',
 'Attached is my summary of requests for rehearing that have been filed in the various Southeastern RTO proceedings.\nIf you would like more information, let me know.\nSusan Lindberg x30596\n',
 'Everyone,   You probably have already heard on the news that there is a new Computer Virus out on the internet that is causing Corporations to experience numerous problems.\nWe have an automated process to update our workstations with the latest virus protection updates.\nHowever, there may be some machines that didn\'t get the update.\nIn order to prevent this virus from infecting your machine, please assist by doing one of the following tasks.\n1.\nLogout of the network and log back in or 2.\nClick on START>PROGRAMS>ACCESSORIES>Norton AntiVirus Corporate Edition and then click the Live Update button.\nThis will pop up a screen where you will have to click the "Next" button and then a "Finish" button.\nThe proper version of the update pattern you need is:   (9/18/2001, version 30918v)  If you have questions or concerns, please direct them to your Resolution Center.\nEnron Global Technology\n',
 'i just heard that scooter is working at dynegy.\ne-mail me back.\nfor instant  messenger go to netscape or to aol and you can get hooked up.\nits no biggie\n',
 'I have added a folder in excel to keep track of vacation and customer outings  etc..  You can find this folder in m:\\electric\\24hr\\juanh\\sevacation.\nThat  is all!\n!\n',
 'Sequent has provided notice to terminate the Asset deal on Oct 31, 2002.\nThe deal would have automatically extended to Oct 31, 2003 had notice not been provided.\nFYI  Frank\n',
 "Today we announced the appointment of Jeff McMahon as Enron's chief financial officer.\nIn my continued discussions with the financial community yesterday and today, it became clear that this move was required to restore investor confidence.\nJeff has unparalleled qualifications and a deep and thorough understanding of Enron.\nHe is already on the job and hard at work on the issues before us.\nAndy Fastow will be on a leave of absence from the company.\nJeff had been serving as chairman and CEO of Enron Industrial Markets.\nHe joined Enron in 1994 and spent three years in the London office as chief financial officer for Enron's European operations.\nUpon returning to the U.S., Jeff was executive vice president of finance and treasurer for Enron Corp.\nIn 2000, he was named president and chief operating officer of Enron Net Works.\nI know all of you are concerned about the continuing decline in our share price.\nI am too, and we are working very hard to turn it around.\nAppointing Jeff as CFO is one important step in that process.\nBut most of the solution involves just continuing to do our jobs with excellence.\nThe fundamentals of our business are strong, and I think the market will begin to see that as we continue to perform.\nPlease join me in giving Jeff your full support, and thank you for all of your continued hard work.\n",
 "Dear Members:  NESA is pleased to be holding its 3rd Annual Benefit Golf Tournament on Monday, March 18th, 2002 at the prestigious Champions Golf Club.\nProceeds will again benefit The Sunshine Kids Foundation.\nThis is your opportunity to secure a corporate ($2000) or individual ($500) sponsorship which includes a foursome or a single tee time, respectively for this outstanding tournament and great cause.\nAttached are registration forms.\nNESA has been proud to donate over $50,000 in the last two years to local charities through this tournament, and we need your help to continue to do so.\nIf you have any questions, please feel free to email me or call me at 713/856-6525.\nDon't forget about our mixer on Thursday, January 31st at the Boaka Bar downtown.\nNo cover, first drink free - can't beat it!\nRSVP to me if you can make it.\nVisit their website for directions at www.mercuryroom.com/boaka/boaka.html\n",
 "COLUMBIA GAS TRANSMISSION CORPORATION                         NOTICE TO ALL INTERESTED PARTIES                                 OCTOBER 24, 2001  Notice ID: 3205 5 - NO RESPONSE REQUIRED   NOTE:  The following is being provided by Columbia as notice to all of its shippers of potential outages or reductions in available capacity in the identified portions of the system due to construction activities, routine maintenance, modifications, tests or repairs undertaken to protect the integrity and performance capability of its storage and transmission facilities.\nThe information provided below is subject to change for numerous reasons, including but not limited to, third-party controlled events and decisions, weather, work schedules, equipment availability, force majeure events, etc.\nThus, while Columbia is willing to provide this notice and update it periodically as necessary, Columbia is unable to represent and warrant that the specific activities will occur, or that they will occur on or near the specified dates.\nSUBJECT:   LINE SM-123  Due to long wall mining, effective October 26, 2001, Line 123 will be out of service.\nTherefore, 0 non-firm capacity is available at the following receipt points until further notice.\nThe following receipt points will be affected:     Equitable Gas:    Beaver Creek      (H1)                      Hi Hat            (F3)     CNR Pipeline:     Boldman           (CNR02)                      Conoway           (CNR03)                      Johns Creek       (CNR08)                      Canada            (CNR09)                      Canada            (CNR10)                      Stafford          (CNR11)                      Thacker/Majestic  (CNR12)                      Briar Mtn.\n(CNR13)                      Huff Creek        (CNR14)     Conoco:           Grant             (P1)  The same is true with respect to any Appalachian production flowing directly into Columbia's Line KA between Columbia's Boldman Compressor Station and Columbia's Huff Creek Compressor Station as well as production flowing into Columbia's Lines SM-116, KA-15, PM-3 and PM-17.\nIf you have any questions, feel free to contact your Customer Services Team.\n",
 'Get ready.\nBeginning in November, electronic pay stubs will be available to all employees who have their paychecks direct deposited into their bank account.\nElectronic pay stubs are an easy, fast, and efficient way for you to get your payroll information.\nThey will also help Enron to realize a considerable savings in time and dollars spent over traditional printed pay stubs.\nIf you prefer to receive a hardcopy of your pay stub, click on the link below to complete a request form.\nThis form must be submitted to Payroll by October 15, 2001.\nUnless you submit a form your pay stub information will default to electronic viewing.\nPlease click on the link below.\n',
 'Attached is a FERC proforma tariff.\nHowever, each transmission provider will have its own version approved by the Federal Energy Regulatory Commission (FERC) and it could contain substantial changes.\nAlso, the ISO tariffs are quite different and have numerous other rules.\n',
 'Ed, Eric,  I have confirmed with Jeff Hodge regarding the termination of this contract.\nAt this time, the contract is effectively terminated as Bankruptcy causes a triggering event to terminate, although no notice has been received by ENA from the Counterparty with respect to a termination payment.\nAfter talking to Jeff, he explained (as stated in the contract) that the Affected Party shall pay the Termination Payment to the Notifying Party.\nSince ENA is the Affected Party, no payment would need to be made, as the contract is in the money to ENA.\n**With respect to ENA sending a Termination Payment Notice to the Counterparty, please ensure no notice is generated to affect the timing/value of the potential asset sale of which Fred Mitro is involved.\nThank you,\n',
 "Jeff,  I am an Enron Wholesale Services attorney who is advising on ENA gas transportation matters.\nElizabeth Sager suggested that I contact you about assisting me with the preparation of a Motion to Reject the bulk of the executory transportation service agreements that ENA has with interstate pipeline companies.\nThe attached spreadsheet summarizes the terms of said transportation agreements; please note that the first sheet of the spreadsheet file describes the 5 transportation contracts that ENA wishes to assume; the remainer are out of the money transportation and storage arrangements that ENA desires to reject.\nPlease review the attached and let me know if it contains sufficient information with which to proceed with the preparation of the Motion.\nI imagine you will have plenty of questions.\n.\n.\n.\nI myself have a number of questions regarding the agency relationships shown on the spreadsheet, as well as ENA's right or need to reject those Service Agreements under which ENA has heretofore released pipeline capacity to third parties.\nI look forward to speaking with you about these matters as well as determing the timeframe for rejecting these contracts.\n",
 'As we discussed, Enron North America Corp. (ENA) desires to re-establish its account with Paribas.\nThe purpose of this account would be to sell no more than 2,500 NYMEX natural gas futures contracts to hedge natural gas storage inventory for the months of February, March and April, 2002.\nENA is willing to post margin or otherwise to meet necessary credit requirements.\n',
 "Dear Patrick:  Yesterday I spoke with the Office of Conservation at the Louisiana Dept.\nof Natural Resources about the Crawfish Plant.\nAs you may recall from our phone conversation several weeks ago, we (LRCI, Inc.) have been assessed with a civil penalty for failure to file an R6 report in July.\nLa.\nfaxed me a copy of the June report, and it shows a balance of 29 barrels of oil at the plant.\nWe can't close out the filings with the state until the R6 report shows a balance of zero barrels.\nI've spoken with Annette Thompson in accounting, the specialist who signed the June, 2001 R6 report, and she said she's in the process of determining exactly how to report the disposition of those last 29 barrels of oil.\nIn the meantime, I've prepared a payment request form to go through the ipayit system for a check in the amount of $250.00, the civil penalty.\nThis can accompany our final filing when it's ready.\nWhen the check comes back for coding, should I sent it along to you for approval under your work order (WBS element) number?\nPlease tell me what that is so I can input the information.\nMany thanks.\nI'll call you when the check and final R6 form (from Annette Thompson), and the change of filing status form for the Crawfish Plant are ready.\nBest wishes,\n",
 'See the attached memo which represents an attempt to regroup after the hectic last few weeks.\nAttached below are the attachments referenced in the memo.\n(And once again, your favorite forms!)\n',
 "February 4, 2002  NESA Members: Attached is our Northeast Spring Membership Mixer to be held at MacMenamin's South Street Seaport - NYC!\n>  <<NE Notice April 2002.doc>>  Other great upcoming events:  Feb. 20, 2002 - Storage Ecomonics Brown Bag Mar.\n12-13, 2002 - Nominations thru Allocation Technical Training Mar.\n18, 2002 - Charity Golf Tournament\n",
 "I talked with Kevin Levy about the changes that Enron North America Corp. requested for the confidentiality agreement.\nHe agreed to all the changes that were on ENA's draft, with one exception, ENA's proposed two year term of the agreement.\nSince the pipeline will not be built for several years, ENA has agreed to stay with a three year term for the agreement.\nPlease make the necessary changes and e-mail the revised confidentiality agreement to me.\nI will get the necessary ENA approvals and signatures on Monday and hopefully can fax to your office the signed agreement.\nPlease let me know what fax number to use?\nIf you have any questions, please give me a call.\nI will be back in the office on Monday.\nThanks for the quick turn-around on the agreement,\n",
 "I am coming in this weekend to box up for the big move........\nPlease go through the large black file cabinet and the beige and purge, anything you don't want.\nThere will be dumpsters along the floor tomorrow afternoon.\nI have your move packets and I will issue them later next week.\nThere is a 6 Box MAXIMUM......\nIf you have more than that, the movers will only move 6 boxes.\nThere will be 2 sets of drawers.\nIf you have any other questions, please ask me.\n",
 'As requested:     As there we no comments in Sitara to let us know this deal was an option, the deal has been confirmed as a regular forward.\nPlease let me know if you need us to send out a revision.\nRegards,\n',
 'John,   I still have not received written confirmation that the gas being supplied  to the Trust is 100% West Virginia Production.\nYou have assured me  verbally that such is the case.\nHowever, I am sure that you understand  that it is not the least bit unreasonable to have such a certification in  writing.\nI need such a written certification ASAP since  Mountaineer/Allegheny needs proof in order to provide the WV transportation  rate.\nPlease fax me such a certification today if at all possible.\nIf that  is not possible,  please send me an email stating that such a certification  will be signed in the next day or two.\nI am attaching the memo that I faxed and emailed to you about a week ago  that I thought would facilitate getting the certification ASAP.\nThanks very much and regards,\n',
 'Version 2.0 of the ClickAtHome Portal is now available!\nLog into www.clickathome.net now, from work or home!\nAccess the PEP System through the portal!\nChoose your reviewers and fill out your evaluations in the comfort and privacy of your home!\nOutlook Web Access and eHRonline will be available SOON!\nThe ClickAtHome portal is fully customizable for you!\nYOU choose the content on each page, as well as the look and feel!\nNote: the ClickAtHome portal must be launched through an Internet Explorer browser, 5.0 or higher.\n',
 'Given the growth in EES it has become apparent that it is time to consolidate the risk functions between EES and EWS.\nThis will provide EES with the systems, resources and risk expertise of the wholesale energy groups necessary for it to continue to grow and take advantage of current market opportunities.\nWith this in mind and in agreement with the management of EES, two new risk groups inside Enron Americas will be formed to provide EES with pricing, structuring, retail and wholesale commodity risk management, logistics and back-office services.\nThese groups main function is to provide these services to EES.\nWe have asked Rogers Herndon, currently Vice President-Trading in the Eastern Power Group to manage this function in the Eastern Interconnect (this includes both gas and power).\nRogers will continue to report to Kevin Presto.\nWe have asked Don Black, formerly Vice President-EES Risk Management and Sourcing, to manage this function in the Western U.S.  Don will manage this group from Houston and will report to Tim Belden.\nThese groups will work very closely with EES to pursue shared goals while ensuring close coordination with the wholesale gas and power trading organizations.\nThese changes are effective immediately.\nPlease congratulate Rogers and Don on their new roles.\nJohn Lavorato & Louise Kitchen\n',
 'COLUMBIA GAS TRANSMISSION CORPORATION                         NOTICE TO ALL INTERESTED PARTIES                                 NOVEMBER 27, 2001  Notice ID: 3297 5 - NO RESPONSE REQUIRED  SUBJECT:  SECONDARY POINT PRIORITY ALLOCATION  Following is the current secondary point priority allocation methodology.\nPlease contact your Customer Services Represesentative or Account Manager with any questions.\nOperating Area 1    Market Area 33 - Market Areas 17, 19, 30, 31    Market Area 34 - Market Areas 17, 19, 30, 31, 33  Operating Area 2    Market Area 20 - Market Areas 19, 23, 25, 26, 28, 29, 30, 31, 35  Operating Area 3    Market Areas 15, 16, 17, 18, 19 - None  Operating Area 4    Market Area 21 - Market Areas 19, 23, 25, 26, 28, 29, 30, 31, 35    Market Area 22 - Market Areas 19, 23, 25, 26, 28, 29, 30, 31, 35    Market Area 23 - Market Areas 19, 25, 26, 28, 29, 30, 31, 35    Market Area 24 - Market Areas 17, 19, 28, 29, 30, 31    Market Area 25 - Market Areas 19, 26, 35    Market Area 29 - Market Areas 17, 19, 28, 30, 31  Operating Area 5    Market Area 2 - Market Areas 7, 8    Market Area 7 - Market Area 8  Operating Area 6    Market Areas 10, 11, 12, 13, 14 - None  Operating Area 7    Market Areas 1, 3, 4, 5, 6, 8, 9 - None  Operating Area 8    Market Area 26 - Market Areas 19, 35    Market Area 27 - Market Areas 19, 26, 35    Market Area 32 - Market Area 19    Market Area 35 - Market Area 19    Market Areas 36, 38, 39 - Market Area 35    Market Area 40 - None  Operating Area 10    Market Area 28 - Market Areas 17, 19, 30, 31    Market Area 30 - Market Areas 17, 19, 31    Market Area 31 - Market Areas 17, 19  The points available on a secondary priority basis are subject to change due to system operations or flexibility considerations.\n',
 'I just got off the phone with Darren Vanek.\nWe have been talking  about what is needed for about a month now.\nAlmost two weeks ago he said  he wanted a contract that allowed him to call for a letter of credit if one were  needed in the future and that would suffice.\nApparently, a paralegal, is involved in generating such a contract and she  was out all of last week.\nDarren said that he has no control over when the  contract actually gets sent to me.\nPlease do what you can to expedite the  emailing of that contract to me so that I can order gas beyond Dec. 2001.\nThanks and regards,\n',
 'Feast your eyes on Enron Business\' cool and colorful new look.\nYou\'ll find it in your mailbox at home and online at home.enron.com under Publications, Enron Business, and "Volume 2, 2001".\n(And if you\'re in Houston, you might find a few extra copies at the Plaza Java in the lobby of the Enron Building.)\nIn this issue: ?\nEnron Direct plays hard to win small customers ?\nExtreme Enron debuts with exciting stories about employees who ride the edge ?\nMeteorologists brew science with good business ?\nEnron\'s new Vision - how will we do it?\n?\nEnron fights to keep the California energy crisis from spreading ?\nDriving business profits where you\'d least expect them ?\nThe Insider: Sprechen Zie security?\n?\nAssisting earthquake victims in India ?\nFind out who won the Word Search - and enter our Cartoon Craziness Contest for a chance to win a $200 American Express gift certificate!\nDon\'t dally - the deadline for entries is Friday, May 11\n',
 "This NetClub offer includes: 1) Lucky Fares 52 / including Amtrak Connections* 2) Icelandair Holidays 3) Icelandair Reservations - Business Class Special (Philadelphia to Europe w/Amtrak - Icelandair) 4) Cellhire USA - Now you can stay in touch... 5) Icelandair/Hertz Car Rental, Icelandair Hotels, Radisson Hotels.\n6) British Booking Center - Harry's Magical Ride Around Britain, plus more!\n7) icelandtotal.com - All You Want To Know About Iceland.\n",
 'Enron employees not participating in contract parking are eligible to receive Metro Bus Passes or Woodlands Express Passes.\nYou may pick up a bus pass from the Parking & Transportation Desk, on Level 3 of the Enron Building, from 8:30 AM to 4:30 PM.\nAll Metro passes offered through the Enron Parking & Transportation desk will be the Metro 30 Day Zone Pass.\nWhen you use a 30-day zone pass, bus service is divided into four zones w/ unlimited rides.\nThe zone pass is time activated, which means that it will not become active until the first time it is used and will not expire until 30 days after it was used for the first time.\nNew passes will be available to Enron employees upon expiration of the 30 day time period.\nEach zone does have a different fare values based on the distance the bus travels.\nThis is important to any buser who wants to transfer to or travel in a higher-cost zone than the zone pass they have, in this case the difference must be paid in cash.\nIf they are traveling in a lower cost zone, then there is no extra cost.\nParking & Transportation Desk 3-7060\n',
 'Morning sunshine..all is well here in London...doing alot of looking around and am totally overwhelmed with the sense of world history with each step taken and each sight seen...looked at 16 flats to try and find a place to live on friday, only one is a real candidate with possibly one other..will know more today on that front...you need to do one thing when you pack for your trip to London.BRING YOUR WALLET.\nive lived in chicago, miami, houston, kansas city, seattle and spent alot of time in both  san fran and las vegas..im here to tell you no TWO of those cities combined are as expensive as London standing alone..its unreal!!!\nIt seems to me we might have a shot at closing on that friday Nov.2...give me a few more days to get things cleared up and Ill let you know...if your dying to hear my sexy voice u can dial direct just as you read it..011447786844020..it is my new mobile phone..hope all is well..S\n',
 'All -   The below interviews have been rescheduled from Monday, October 29 to Thursday, November 1 in the afternoon (2:00 pm onward).\nPlease mark your calendars accordingly.\nLet me know if you have any questions.\nKind regards,\n',
 'Here are our numbers.\nIf someone in the fundy group could send me your numbers, I would like to know where the discrepancies are.\nThanks.\n',
 'Today we released additional information about our related party and off-balance sheet transactions.\nWe have made this information available both on our website and in a Form 8-K filing with the Securities and Exchange Commission (SEC).\nThe information provides further details about:\n',
 "Please respond by COB Thursday, Sept. 27th.\nAttached for your review and comments is Draft No.4 of the subject comments that we are preparing to file following two technical conferences on El Paso's proposal to allocate defined receipt point rights to the firm shippers on its system as required by FERC.\nTwo of the discussion areas are still being developed in response to information we received from El Paso this morning, and these will be forwarded for review later, along with any changes resulting from comments.\nThanks.\n",
 'Hey there!\nIt was really good to talk to you last night.\nI had a dream about you last night...\nI hope you feel more rested today after a night at home.\nListed below is a bunch of christmas ideas.\n1.Rubber floor mats for Jeep Cherokee \t(River Oaks Jeep or www.jeep.com)- Interior color of my car is a dark charcoal gray...\nAlmost black.\n(not sure on price...)\n',
 "We plan to complete a teaser letter for bidders and a revised Information Memorandum over the next 2-3 days.\nOur target is to send the teaser out on Monday with the IM to follow.\nBoth will contain revised year-end '01 numbers and '02 projections, which I know you wanted to review before they are released.\nI will e-mail you the draft teaser as soon as it is available (probably Saturday) - hopefully, we can chat over the weekend, or at the latest, Monday morning.\nAdam\n",
 "Dear Stan,  Given the current state of affairs here in the D.C. office, I am forwarding my resume for your review.\nThe lion's share of my legal experience has been with Enron's regulated pipelines, both domestic and overseas.\nI appreciate your keeping me in mind should needs or opportunities arise in the pipeline group, whether these be as an employee or on a contract basis.\nThanks for your consideration!\n",
 "Thank you for agreeing to be a speaker at INGAA's Annual Security Analysts  Conference, scheduled for July 12-14 at the Broadmoor in Colorado Springs,  Colorado.\nINGAA hosts this conference every year as a forum for the 25-30 top natural  gas analysts to meet with CEO's and other industry leaders.\nYou will be participating on a panel on natural gas supply, scheduled for  8:15 to 10:00 a.m. Friday, July 13.\nAs a panelist, we would like to hear  your views on the natural gas demand and deregulation, and you are more than  welcome to join us for the entire meeting if your schedule allows.\nYou will be receiving a complete packet of material details from INGAA.\nDon't hesitate to call me if you have any additional questions.\nStan 713/853-6177\n",
 "I checked with Rick Buy's group on where they were on The RAROC analysis of  your proposed broadband project.\nThey aren't doing anything according to Rod  who checked for me.\nIt seems to me that we need to do several things to  either kick this into gear or to put it on hold pending completion of a  sale.\n1.\nWe need to find out from Mark Metts if this deal adds any value to the  transactions being proposed.\nI will talk with Mitch and Mark about this  issue.\n2.\nWe need to determine EBS interest in this business..ie are they a buyer  or seller of Portland metro dark fiber.\nIf they want to be in this business  wouldn't it make to develop this project as EBS and not to include it in a  sale?\n3.\nA project of this size will take Jeff's approval.\nThe projected Phase I  capital is above my threshold.\nI will talk with Kevin Hannon and Mitch and then get back with you.\nSound  like a plan?\n",
 "This is to advise you that we have available, for your business or personal  use, Stan's four (4) WNBA Comets tickets.\nThese seats are in Section 104,  Row D, Seats 1-4.\nTheir schedule is listed below.\nPlease let me know if  you are interested in any of these games.\nThey will be distributed on a  business basis first, then personal use.\nPreseason Game A: Saturday, May 12 @ 7:30PM vs. Miami SOL Preseason Game B: Thursday, May 24 @ 7:30PM vs. Detroit SHOCK Game 1:  Monday, May 28 @ 2:00PM vs. Los Angeles SPARKS Game 3:  Monday, June 11 @ 7:00PM vs. Los Angeles SPARKS Game 4:  Thursday, June 14 @ 7:30PM vs. Portland FIRE Game 5:  Sunday, June 17 @ 1:00PM vs. Utah STARZZ Game 6:  Tuesday, June 19 @ 7:30PM vs. Washington MYSTICS Game 7:  Saturday, June 23 @ 3:00PM vs. Sacramento MONARCHS Game 8:  Monday, July 2 @ 7:30PM vs. Portland FIRE Game 9:  Friday, July 6 @ 7:30PM  vs. Indiana FEVER Game 10:  Sunday, July 8 @ 1:00PM vs. Cleveland ROCKERS Game 11:  Tuesday, July 24 @ 7:30PM vs. Utah STARZZ Game 12:  Saturday, July 28 @ 12:30PM vs. New York LIBERTY Game 13:  Monday, July 30 @ 7:30PM vs. Seattle STORM Game 14:  Friday, August 3 @ 7:30PM vs. Orlando MIRACLE Game 15:  Monday, August 6 @ 7:00PM vs. Phoenix MERCURY Game 16:  Monday, August 13 @ 7:30PM vs. Minnesota LYNX  Please note that date and time are subject to change; please check local  listings.\nThanks,\n",
 "This is to advise you that we have canceled next Wednesday's ETS Half Day  Staff Meeting.\nOur next meeting is scheduled for Wednesday, August 15,  from 8:30AM to 1:00PM in 49C2.\nWe are taking a summer break to accommodate  vacation schedules.\nDon't hesitate to call me if you have any questions or concerns with this  notice.\nThanks,\n",
 'Wayne,  I have modified the above contract as we discussed.\nThe "Customer\'s Agent"  language is contained in Appendix "1".\nPlease have the contract signed by  JER Partners, a J.E.\nRobert Company and fax it back to me.\nI will then have  it signed by Houston Pipe Line Company.\nI have left the attachment at the  end as originally drafted until I am able to talk to Gary Lamphier.\nIf it is  truly correct that there are no minimum quantity obligations under the deal,  then Gary may have to reprice the $0.09 discount for the 1000/d.\nI will  leave that up to Gary and you to resolve.\n',
 'This warning is sent automatically to inform you that your mailbox is approaching the maximum size limit.\nYour mailbox size is currently 76150 KB.\nMailbox size limits:  \tWhen your mailbox reaches 75000 KB you will receive this message.To check the size of your mailbox:     Right-click the mailbox (Outlook Today),    Select Properties and click the Folder Size button.\nThis method can be used on individual folders as well.\nTo make more space available, delete any items that are no longer needed such as Sent Items and Journal entries.\nYou must empty the Deleted Items folder after deleting items or the space will not be freed.\nTo turn Journaling off,   click Tools | Options | Journaling Options and de-select all items.\nSee client Help for more information.\n',
 'Notice # 01-390 November 19, 2001  TRANSPORTATION UPDATE   SHUTTLE SERVICE   Effective Wednesday, November 21, 2002, the two vans running from One North End Avenue to the Staten Island Ferry and the Bowling Green area have been cancelled.\nThe Battery Park City Authority (B.P.C.A.)\nis running free shuttle buses Southbound leaving Chambers Street and Northbound leaving Bowling Green.\nInformation on these shuttle buses have been posted in the lobby and near the elevators in the building.\nThe hours of operation are as follows:  Southbound Leaving Chambers Street\t\tNorthbound Leaving Bowling Green Weekdays\t6:00 a.m. - 11:00 p.m.\t\t6:14 a.m. - 11:14 p.m. Saturday\t7:00 a.m. - Midnight\t\t7:14 a.m. - 12:15 a.m. Sunday\t7:00 a.m. - 11:00 p.m.\t\t7:14 a.m. - 11:14 p.m.\nThese shuttle buses effectively replicate the coverage provided by the vans.\n',
 'We have received an executed Second Amendment to ISDA Master Agreement dated as of October 3, 2001 between Bank of America, N.A.\nand Enron North America Corp., which amendment amends the Part 4(c)(ii) of the Schedule which states that Bank of America is a multibranch party and may act through the Offices set forth on Appendix A - Amendments.\nCopies will be distributed.\n',
 "Attached please find the report listing the Global Contracts group's assignments, terminations, and expirations for the month of November 2001.\nPlease call me if you have any questions.\nThanks,\n",
 'Just a quick note in response to several emails regarding this Friday.\nYES INDEED, Friday Night WINE BAR at Christopher\'s will be in full swing this Friday night from 6 until 10 PM.\nAs always, we will be showcasing 45 wines by the glass and our Chef will be offering 5 special "Plats du Jour".\nOur wines by the glass are offered at retail prices ranging from $4 to $15, and our "Plats" range from $10 to $22.50.\nNo reservations are required, but get here early for the best seating.\nOr, come in around 9 PM for later seating.\nSee y\'all there.\nChristopher "BEST WINE STORE" Houston Press 2001\n',
 'Tana, Wendi Lebrocq called re: Ameren Energy, Inc., as agent for Central Illinois Public Services Co. and as agent for Union Electric Company.\nI put them on "T" for US physical natural gas only.\nI think Wendi said they would appear on tonight\'s list.\nStephanie\n',
 'Please check your records and let me know if you have any kind of documentation evidencing a merger indicating that Mercator Energy Incorporated merged with and into Energy West Incorporated?\nI am unable to find anything to substantiate this information.\nThanks for your help.\n',
 'There are Unresolved/Open items in the vendor payables system (iPayIt) and employee reimbursement system (XMS).\nEmployees are strongly encouraged to resolve items in their inboxes.\nPlease either process and approve, or reject these outstanding business expenses in your inboxes by 2:00 p.m. Monday, December 3, 2001.\n',
 'Hi Tana,  Last time we spoke I was with the Legal team.\nI have since moved over to support the Power Trading team and looking after EOL, which will be fully handed over to me from Justin Timothy once access to the appropriate systems has been finalised.\nI have a query on Global Counterparty ID# 115322, NTT Communications, Taka Maeda, which was originally processed on 7 June 01.\nCould you please advise where we are with this one.\nPlease do not hesitate to contact me should there be any problems.\nThank you and regards,\n',
 "Just checking on my customers in the Pa Database and saw that Credit approved this Sabic Americas, Inc. 10/5, but that Status still says Credit Reviewing- just wanted to make sure this one didn't get stuck and moves on through to legal....\nPlease let me know, as I have a meeting scheduled with this customer on October 17 and would like to be able to show him the system with his permanent ID.\nThanks,\n",
 'We have received an executed financial Master Agreement:  Type of Contract:\t\tISDA Master Agreement (Multicurrency-Cross Border)  Effective Date:\t\t\tJuly 5, 2001  Enron Entity:\t\t\tEnron North America Corp.  Counterparty:\t\t\tDoublewood XLIM Fund Ltd. (The)  Transactions Covered:\t\tApproved for all products with the exception of:   Foreign Exchange  Confirming Entity:\t\tEnron North America Corp.  Governing Law:\t\t\tNew York  Special Handling Requirements:   (a) ENA is Calculation Agent, unless a Potential Event of Default or an Event of Default exists with respect to ENA, then Counterparty will act as Calculation Agent or will appoint a third party to act as such.\n(b)  Counterparty has three (3) Local Business Days to accept or dispute a Confirmation.\nCopies will be distributed.\n',
 'This is an automatically generated Delivery Status Notification.\nYour message has been successfully relayed to the following recipients, but the requested delivery status notifications may not be generated by the destination.\nwhitfield@blackstone.com\n',
 "When: Wednesday, October 17, 2001 11:30 AM-12:30 PM (GMT-06:00) Central Time (US & Canada).\nWhere: Lunch someplace - maybe bouray's burritos?\n*~*~*~*~*~*~*~*~*~*  Shall we meet downstairs at 11:30 and decide from there where to go?.\n",
 "Tana,  I was thinking of you today because I just got my issue of Texas Monthly and both of your Houston employers were subjects of stories.\nYou might be interested.\nHow have you been?\nI really appreciate your putting me up for the weekend.\nI would very gladly return the favor if I can.\nWhich reminds me.\nDo you want to come here this summer to see the Vatican exhibit?\nThe tickets are free, you just need to reserve them.\nThere is an 800 number for info.\nWhen I find it again I can send it to you.\nThere is also a website,under the auspices of Texas Tech museum.\nThat's all for now.\nTake care.\nKathy\n",
 'Tana/Mark, Columbia Gulf has requested the following changes to their NDA.\nThe legal entity name should read "Columbia Gulf Transmission Company."\nThey would also like to add point number 9 which states, " The execution of this agreement relative to confidential information does not obligate either party to enter into any other agreement or any transaction as that term is referenced herein."\nAs long as you don\'t have any issues with the changes, please forward a copy to Jim Hart at Columbia.\nThey are scheduled to come over for a demo next week.\nThanks,\n',
 'Tana, attached is the Master Firm Gas P/S Agreement with Dynegy Canada Marketing and Trade, a division of Dynegy Canada Inc. (formerly Novagas Clearinghouse Limited Partnership):  \t  It appears that around March 13, 2000, we sent Dynegy Canada Inc. an Amended and Restated Master Firm Gas P/S Agreement to replace the original agreement, but it was never signed up.\nThe following is the Master Firm Gas P/S Agreement with BP Canada Energy Company (formerly Amoco Canada Petroleum Company):   \t  I will fax to you the execution pages for each agreement.\nTake care, Sharon\n',
 'Tana -  We need to pull together all of the contracts with the following:  \tAmerada Hess Corporation \tHess Energy Services Company, LLC \tHess Energy Trading Company (UK) Limited \tHess Energy Trading Company LLC   We need to pull together a Master Netting agreement with them ASAP.\nPlease call me (53923) with any questions.\nThanks,\n',
 'Tana  I would like an NDA for @theMoment, Inc. , located in San Mateo, CA.\nI am targeting this company to be a licensor of our Market Manager Software.\nPlease send the information to\n',
 'Tana,  We received the original termination letter from Kase and Company, are you still keeping the originals or shall I pass this on to someone else?\nThanks.\nMake It A Great Day!!\nLorie E. Hernandez Specialist - E-Commerce Transaction Development\n',
 "Mr. Dixon:  Pursuant to Carol St. Clair's request, I am attaching our preliminary list of the agreements to be under the BP Master Netting Agreement.\nSince we don't own 100% of EOTT, any master netting agreement involving EOTT will not be under this master netting agreement.\nPlease let us know if you have any questions or need anything else.\n",
 "FYI -   A new (shell) Master Financial Agreement has been established in Global Contracts for EOL purposes until the executed originals are received from legal.\nI have updated this contract number in EOL's Profile Manager.\nPlease call me at 5-4435 if you have any questions.\nCounterparty: Public Utility District No.\n1 of Franklin County CP ID Number: 52127 Contract Number: 96086520 Profile Manager Updated On: 10/30/01     Thanks,\n",
 'We have received an executed Amendment Agreement dated October 9, 2001 to the ISDA Master Agreement between Enron North America Corp. ("ENA") and Royal Bank of Canada ("RBC") dated as of February 15, 1995.\nThis Amendment revises (1) certain definitions in the Credit Support Annex and (2) the notification information for ENA and RBC.\nCopies will be distributed\n',
 'We have received an executed Assignment Agreement dated as of October 9, 2001 among National Westminster Bank plc ("NWB"), The Royal Bank of Scotland plc ("RBS") and Enron North America Corp. ("ENA").\nEffective as of October 26, 2001 (the "Commencement Date"), NWB assigned all of its right, title and interest in the transactions under the ISDA Master Agreement dated January 1, 1994 to RBS.\nAll assigned transactions shall be governed by the terms and conditions under the ISDA Master Agreement between ENA and RBS dated December 10, 1999.\nThis Assignment Agreement also amends the notice provisions in the Schedule to the ISDA Master Agreement between ENA and RBS.\nCopies will be distributed.\n',
 'Attached are clean and redline versions of the "without margining" master netting agreement.\nThe redline is    just for your review to discern the changes.\nI have also included a clean version without the user notes.\nI will distribute a process memo tomorrow.\nPlease note that even though this does not include margining provisions, the agreement still provides for the reciprocal grant of the security interest in each Group\'s own payments (see 6 b) and thus, you still need to coordinate with Lech Kalembka at Cadwalader for its perfection.\n',
 '1.\nSend forms of agreements to counterparty as a first step to get the process moving forward.\nIf you do not have a contact at the counterparty call the credit hotline at 31803 and ask for Jay Williams or another credit person who can help you get the contact name and number.\nCredit is working diligently to get specific legal entity names to us as well.\n2.\nAt the end of each day send a status update, including specifics of steps taken, to me and Carol St. Clair, cc Louise Kitchen, Bill Bradford and Tanya Rohauer.\nCarol and I will summarize for Louise, Bill and Tanya, but copy them in case they are interested in any particular party on an urgent basis.\nManagement has asked that we contact the counterparties at least each day and keep this moving to closure of each agreement as quickly as possible.\n',
 'I will be out of the office in New York next week for my wedding there.\nIf anyone needs to reach me on Monday or Tuesday, you can call me at 1-646-698-0601.\nI will forward my cell phone number to Keegan once the phone is turned on Tuesday.\nKind Regards,\n',
 'Hi Tana,  Here is a resolution for Enron Canada Corp. which Peter will be looking for this morning.\nCould you please print it out for him when he shows up at your desk?\nThanks,\n',
 'Martin Gas Sales would like to pursue getting an ISDA in place so that they can trade financial LPGs on EnronOnline.\nCould someone please call Tom Redd at 903-983-1551 to start the process.\nThank you,\n',
 'We have received the Confidentiality Agreement with Novo MediaGroup, Inc.  dated  May 2, 2000.\nCopies will be distributed to Dave Samuels and Bob  Shults.\nI am also attaching an updated list of the EnronOnline Confidentiality  Agreements.\n',
 'We have received the executed ISDA Master Agreement (Multicurrency-Cross  Border) effective as of 06/29/99.\nCopies will be distributed.\nIMPORTANT:  All confirmations for this counterparty must contain the  following representation:  "Each party represents that it is in compliance with the terms, conditions  and limitations set forth in the board resolutions or other guidelines that  are applicable to such party\'s execution and performance of this  Transaction."\n',
 "I understand that you are the Keyspan man!!\nWe are being asked to look at combined physical/financial guaranty for  Keyspan with the guarantor being KeySpan Corporation d/b/a KeySpan Energy and  the guaranteed parties being KeySpan Ravenswood Inc. and KeySpan Ravenswood  Services.\nI have never seen this counterparty as a financial entity before.\nWe've got Keyspan Energy Management, Inc. as a counterparty we sent a draft  master to about a year ago.\nWill these Ravenswood entities trade financial  with us?\nDo we need to add Keyspan Energy Management to the guaranty if that  is indeed the Keyspan entity we are trading with?\nBy the way, what kind of boondoggle trip is this you are on?\nYou Credit guys  live high on the hog!\nYou must have a bigger budget than us!\n",
 'I had a conversation with Ed Staub over at Duke today, and he now wants to  get an agreement in place between Duke and ENA.\nI mentioned to him our  agreement between ENA and ECC that would allow us to trade both entities  under the same master, and he was not interested in trading in that manner,  he wants separate agreements in place with both companies, obviously,  mirroring the terms of the master we are putting in place with ECC, just  changing it for any cross-border issues.\nI told him I would run it by our  Credit Dept.\n',
 'We have finally received the executed Termination Agreement for the two Koch  physical trades done in error on EOL (which have already rolled off the  books!).\nThe deal nos.\nare EOL Nos.\n103992 and 104018.\nI am sending the  original to Bob Bowen.\n',
 'I need to send out the attached memo ASAP to all employees of Enron North  America and its trading affiliate offices.\nThis includes Houston, Calgary,  London, Denver, New York, Oslo, Singapore, Portland, Australia, Buenos Aires,  and any other offices where we might have trading affiliates.\nCan someone  with your team get back to me ASAP so we can be clear about who we send this  to.\nThanks!\n',
 "Below is my listing of the remaining projects.\n1.\nFinish painting sunroom.\n2.\nPaint bedroom furniture.\n3.\nReplace two front door thresholds.\n4.\nPut mailbox in Nancy & Peter's front door.\nThey have the hardware.\n5.\nSheetrock over their livingroom bookcase at Nancy & Peter's.\n6.\nPaint outdoor pipes same color as house.\n7.\nI spoke to Bob Goss, they took the light fixture cover out of my back  stairwell (it's in the ceiling) and lost it.\nBob asked if you could replace  it for him and send him the bill.\n8.\nAdditional plumbing (1) airconditioning pipe, and (2) washing machine  hoses in back of garage, and cover open drain near door to garage bathroom  plumbing.\nThat should do it!\n",
 'Mike,  Mary Cook is a new attorney that joined our Group yesterday.\nCan you get her  full access to the referenced database, and let us know when such access is  granted.\nThanks!\n',
 "I discussed this w/Frank, and wanted to make the other two of you aware,   since this is a Bermuda corporation, they are only allowed to trade the US  segment of bandwidth.\nSince this is the only segment we are trading online  yet, this isn't an issue.\nBut as we move forward and add more segments we  are going to have to keep in mind that although a counterparty may have been  open for US, we need to consider if they can trade other country based  segments as we add them in the future.\n",
 'We have received the following executed ISDA Master Agreement:  Type of Contract: ISDA Master Agreement (Multicurrency-Cross Border)  Effective Date:  05/15/00  Executed Date:  06/09/00  Enron Entity:  Enron North America Corp.  Counterparty:  Pacific Gas & Electric Company  Transactions Covered: All products covered except pulp & paper and FX  ALL PARTIES PLEASE NOTE:    1.\nDIVISION TRADING.\nThis counterparty may elect to do additional financial  trading under two divisions, its Core Procurement Department or its  California Gas Transmission Department.\nIf the Counterparty does elect to  trade under these divisions, such trades should also be done under this  master agreement.\nNo other divisions should be approved for any financial  trading for Pacific Gas & Electric Company without prior approval from  Legal.\nHowever, for regulatory purposes, payments cannot be netted between  Pacific Gas & Electric Company and any/either of the two divisions.\nAll  payments must be treated separately.\nIt is critical that the  PAYMENT/SETTLEMENT GROUP captures this correctly.\n(CREDIT, the agreement does provide for closeout netting.)\n2.\nCanadian and US Trades:  All financial trades with this counterparty,  whether entered in with Houston or Calgary traders must be done under this  master agreement.\nTHE CONFIRMATION DESK needs to make note of this.\n3.\nGLOBAL CONTRACTS:  When we open them up to trade online, we need to make  sure that all of the financial products go under this master agreement.\nUnder no circumstance should they see a GTC if they transact any financial  product.\n3.\nONLINE TRADING:  It is critical that  the above information is captured  correctly before we can open them up for online trading.\nI will verbally  confirm with each of the Online Team, Confirmation Desk, Global Contracts,  and Payments/Settlements that we have this setup correctly before Legal  approves them to trade online.\n',
 'Mark asked me to get your input regarding a Canadian form question.\nWe have  the following language in the Canadian ISDA Agreements:  Limitation of Rate.\nNotwithstanding any provision to the contrary contained  in this Agreement, in no event shall the Default Rate, Non-default Rate, or  Termination Rate exceed the maximum non-usurious interest rate, if any, that  at any time or from time to time may be contracted for, taken, reserved,  charged, or received on the subject indebtedness under the law applicable to  such party.\nFor the purpose of disclosure pursuant to the Interest Act  (Canada), the yearly rate of interest to which any rate of interest payable  under this Agreement that is calculated on any basis other than a full  calendar year is equivalent may be determined by multiplying such rate by a  fraction the numerator of which is the actual number of days in the calendar  year in which such yearly rate of interest is to be ascertained and the  denominator of which is the number of days comprising such other basis.\nDo we need to have the highlighted language exactly as it is, or can we have  a general statement to the effect that the interest rate shall not exceed the  maximun non-usurious rate and interest shall be paid on the actual number of  days elapsed, based on a 365/366 day year?\nIs there some special magic to  the above highlighted language?\nThanks for your help.\n',
 'Attached is that RUSH guaranty Stuart Zisman called about.\nWe need to get it  signed today.\nWe will also need the Certificate with respect to the  incumbency of the officer signing the guaranty.\nThanks!\n',
 'Mr. Faragalla,  I am checking on your review of the Confdientiality Agreement referenced in  our earlier email below.\nWhen might we expect to hear some comments from  you?\nPlease let me know.\n',
 "I need to hear back from anyone whose group may be trading with this  counterparty.\nHere's my issue.\nWe have been negotiating an amendment to the Password Application with this  counterparty.\nThe absolutely refuse to see a GTC.\nI don't know if any of  you are trading gas, crude or power with them, but if you are, do you have a  master, or would the counterparty see a GTC.\nI'm trying to figure out what  we have before we talk to them.\nThanks!\n",
 "On the referenced list, Credit shows River Trading Company as an amended  counterparty, but I didn't have them at all so I treated them like a new  counterparty.\nOn the 8/8/00 List, Braintree is a division, and I would like it to read:   City of Braintree, Massachusetts Electric Light Department.\nthe name on Spinnaker is wrong, Credit will be correcting it to read  Spinnaker Exploration Company L.L.C.\n",
 "In the future, if we have a city or a county come through, we need to  identify the state they are located in as part of the counterparty name.\nThe  City of Huntsville is an example where I took it to be the the City of  Huntsville, TX, and, per my conversation with Tom today, it appears they are  the City of Huntsville, AL.\nThis isn't going to be a problem with my  financial approval, since I shut down all cities for financial unless we have  a master in place, but it might be a problem for power.\nThe same would apply  to counties.\nSo, if we get cities and counties in, let's try and make the state part of  the counterparty name.\nLeslie, do you have any problem w/Huntsville, let me know?\n",
 "Oh guru of all things Canadian...\nI'm working on comments to an ISDA that Hydro-Quebec sent us for an  affiliate, HQ Energy Services (U.S.) Inc., which is a Delaware corporation.\nIs there anything special about Hydro-Quebec being the Guarantor, or just the  usual considerations having a governmental entity as the guarantor?\nBy the way, I hope you're coming up for the Legal Conference.\nThere are many  problems at Enron that need our help in getting sorted out, those kinds of  problems that lots of margaritas seem to bring out!\nI'm counting on you!\n",
 "I have two Australian counterparties on the referenced list, State  Electricity Commission of Victoria and Straits Resources Limited, and I  haven't heard from you, and I need to get that list out.\nWhen you send your  approval, can you be specific as to whether they are approval for Australian  products only, or all products.\nThanks!\n",
 'The ISDA Multicurrency Agreement Schedule has been approved and moved into  the attorney forms bank.\nIt is located at o:legal\\atty.fms\\swaps\\current  forms\\isda-multicurrency.doc.\nThe old ISDA Multicurrency Agreement Schedule is located at  o:legal\\atty.fms\\swaps\\old forms\\old2101a#4.doc.\n',
 'The revised form of ISDA exhibit.doc (which contains the credit support annex  and letter of credit forms) has been moved into the attorney forms bank under  atty.fms/current forms/isdaexh.doc.\nThe old form of ISDAexh.doc is now under  "old forms" in the attorney forms bank as atty.fms/old forms/oldISDAexh.doc.\nAgain, per my last email, the revised Multicurrency Schedule is already in  attorney forms.\nYou may want to circulate blacklined drafts.\nThe Index to  the swap forms is now also located in the attorney forms bank for your  reference for the most current forms.\nIt is called "formlist.doc."\nLondon and Singapore, FYI, in addition to making changes to the ISDA  collateral annex, we made changes to the MAC definitions (which we inserted  into ISDAexh.doc for ease of the paralegals) and made changes to the letter  of credit terms, as well as the form of Letter of Credit.\nWe also added in  an alternative "Credit Support Amount" provision on the front page of the  ISDA credit support annex to deal with situations when we do not want to  return the Credit Support Amount during the term of the Master Agreement.\nWe moved the guaranty forms (Enron Corp. and Counterparty) as a separate  document(s) in the attorney forms bank, atty.fms/current forms/guaranty.doc.\nThe guaranty form was revised to (1) make it cover both confirms and masters  so we don\'t need two separate forms on an ongoing basis, and (2) we changed  the procedures for timing of demands made on Enron (deleting the 15 day  period).\nWe are also discussing adding an assignment provision to the Enron  Corp. guaranty with Clement and will keep you posted.\nWe are close to finalizing changes to the Industrial Master, as well as  making changes to the Omnibus form of confirmation.\nAlso, by the end of the day I will have moved our standard forms of  Secretary\'s Certificates into the attorney forms bank.\n',
 'Taffy,  these are all finance deals that Sara worked on.\nCan you work with  her to get copies of the ISDA Masters for this guy in the Audit group.\nCheck  Lotus Notes to see if we have blue files, and if not, check w/Sara.\n',
 'Per our conversation, attached is the form of ISDA Agreement, with Enron  guaranty attached to it.\nAs we discussed, Cadwalader will issue an  enforceability opinion with respect to the Enron Corp. guaranty, so we need  to provide them with an opinion with respect to Enron Corp. general corporate  matters.\nThanks for your help!\n',
 'At the request of Dovie Keprta, I am attaching our proposed form of  Non-Disclosure Agreement.\nPlease call me at (713) 853-3399 or Dovie at (713)  345-8664 with any questions or comments you might have.\nIf the enclosed  meets with your approval, please have the agreement executed by an authorized  officer of webMethods and return the copy to me for execution by Enron.\n',
 "Justy,  We are going to be trading with Deutsche Bank out of their New York and  London branch offices online.\nPer my conv.\nw/the online team, we going to  have to have them come in thru both Houston and London as a counterparty (we  haven't solved multibranch customers online).\nWith Edmund out, I need  someone to email me your Electronic Trading Agreement and Password  Application so we can send them to the lawyer we are negotiating the ISDA  Master with.\nCan you have someone there send me the docs.\nMuch thanks...\n",
 "Primagaz Trading Paris is a French counterparty that had come thru London.\nCredit doesn't want them to trade US products.\nI've never looked at it  before, so I had to treat it as a new cpy.\n",
 'We have received the fully executed Unanimous Written Consent of Managers of  EnronOnline, LLC  dated 11/6/00, effective as of 10/11/00, which appoints  Amita Gosalia, Dale Neuner and Sheri Thomas as agents and attorneys-in-fact  to execute Password Applications on behalf of EOL.\nThis resolution will  expire one year from the date of its effectiveness.\nWhen you execute, please  sign as "Agent and Attorney-in-Fact".\nThe original will be filed in the  minute book of EnronOnline maintained in the Corporate Secretary\'s Office on  the 48th floor, and a copy will be provided to Lisa Lees and Amita Gosalia.\n',
 "At the request of Dovie Keprta in our eMarket Services Group, I am enclosing  a draft of our proposed form of Non-Disclosure Agreement for David Endicott's  review.\nI am also attaching a blacklined draft showing the changes from the  NDA you executed with Enron Broadband Services.\nPlease call me at (713)  853-3399 or Leslie Hansen, Senior Counsel at (713) 853-6121 with any  questions or comments you might have.\nWe look forward to hearing from you.\nTana Jones Senior Legal Specialist\n",
 "We have received the following executed NDA's:  Between Amerex Power, Ltd. and Enron North America Corp., Enron Net Works LLC  and EnronOnlie, LLC dated 11/09/00.\nBetween Amerex Natural Gas I, Ltd. and Enron North America Corp., Enron Net  Works LLC and EnronOnlie, LLC dated 11/09/00.\nCopies will be sent to Dave Samuels.\n",
 "This Counterparty is on the 11/9/00 EOL List.\nWe have received documentation  that reflects that Calpine Power Services Company, an entity where we have an  ISDA Master in place, has merged with and into Calpine Energy Services, L.P.,  an entity where we don't have an ISDA in place with.\nIs Credit OK with this  merger?\n",
 'At the request of Bob Shults, I am attaching our proposed form of  Non-Disclosure Agreement.\nIf the enclosed meets with your approval, please  sign the NDA and return it to me via fax (713) 646-3490.\nIf you have any  comments or questions, please do not hesitate to call me at (713) 853-3399.\nTana L. Jones Senior Legal Specialist\n',
 'Matt,  Can you let me know if the following products are approved for trading for  Singapore counterparties, and what restrictions, if any, they might have  (like the eligible swap participant rules in the U.S.):  Commodity Derivatives (energy commodity, metals) Weather Derivatives Credit Derivatives  Further, would there be any limitation for a Singapore counterparty to trade  any of the products we offer, physical or financial online?\nI am going to  attach to this one of our recent excel spreadsheets showing all the products  we trade.\nAre there any counterparties that are problematic for derivatives in  Singapore?\nFor instance, here in the U.S., we flag governmental entities for  no trading until we have a master in place, or upfront due diligence required  before we can approve mutual funds or hedge funds, etc.\nThanks!\n',
 "For those of you keeping track, Carrizo makes 475 master swap agreements.\nConferring with Team Swap, we have at least 20 masters out or going out for  sigature this week (including the 9 Merit Energy Partner masters).\nUnlike  the media in the Presidential Election, I hesitate to call this one an early  win (especially after seeing the Board in Marie's office!\n), but I must say,  Team Swap is looking strong.\n",
 'The referenced Counterparty wants to trade physical power.\nLeslie has signed  off on them from a Legal standpoint, but Credit still has concerns and has  assigned them no power headroom.\nI spoke to Jeff Mansfield in their Legal  Dept.\nand he is going to have his Credit guy call Ed Sacks tomorrow.\n',
 "Mark,  David Portz, Elizabeth Sager and I were looking at this slide and we're not  so sure it's correct.\nWe think it should reflect two huge power price  spikes, the recent ones of this year, and the big one of last year.\nWe don't  think the attached slide correctly reflects the two price spikes.\nCan you  take a look at it and get back to me...thanks for your help!\n",
 "The mad cow disease must have extended to England's venerable sheep, thus  causing a lack of worsted wool, hence, no new trousers which, I'm sure, is  the only reason we haven't gotten a fashion bulletin from you in quite some  time.\nThe men's fashion news here in the United States says that the current  fashion in ladies pedal pushers (or knee length trousers) has now extended to  the gents and is becoming quite the rage.\nFashion trends are quite slow in  reaching the outbacks here in Texas, but I can see fashionable young swains  in London and New York showing off their knees and ankles.\nHas this trend  crossed the Atlantic?!\nHas Justin bought a pair in red?\nWe miss our Tim from Texas....stay in touch!\n",
 'Last week I left taped to your chair the referenced form of confirm that Bob  Bowen needed you to sign off on.\nHe says he never hear back.\nCan you call  him and give him the sign off.\nThanks!\n',
 'Please find attached form of Deemed ISDA.\nWhen you fax it to the  counterparty can you please attach to the back of the fax  IRS Forms 1001 and  W-8.\nMuch thanks!\n',
 'Pam,  Peter Keohane, our Calgary attorney, is working on a termination of some  trades between ECT and Paribas and needs you to fax or send him the following  confirmations ASAP, Deal nos.\nEA7484.3 and EB3772.3.\nThanks yet again!\n',
 'At the request of Michael Bridges, I am attaching our proposed form of Letter  of Interest.\nIf the agreement meets with your approval, please return a copy  to me via fax no.\n(713) 646-3490.\nIf you have any comments or questions you  would like to discuss, please do not hesitate to call me at (713) 853-3399,  Mike at (713) 345-4079 or Bob Shults at (713) 853-0397.\nWe look forward to  hearing from you.\n',
 "Per our conversation, can you get Bill added as a VP of Enron North America.\nHe didn't want to fuss Enron Canada or EPMI right now.\nThanks for your help!\n",
 'As a follow-up to my email regarding the execution of the 12/29/00 ISDA  Master Agreement between Deutsche Bank AG and Enron North America Corp.,  please be further advised:  Effective 6/4/99, Bankers Trust Company was acquired by Deutsche Bank AG.\nAll financial trading should now be transacted under the above Deutsche Bank  ISDA Master Agreement.\nNo further financial trading should be done in the  name of Bankers Trust Company, and the 4/16/91 ISDA Interest Rate and  Currency Exchange Agreement with Bankers Trust Company should be inactivated.\nAll outstanding Bankers Trust Company financial trades were assigned to  Deutsche Bank AG in the ISDA Master Agreement, and all the Bankers Trust  Company trades should be moved to Deutsche Bank.\n',
 'Things may come in a little differently because of Profile Manager (my direct  input into the EOL System).\nI will now only see amendments to counterparties  that have already been approved, thru Profile Manager, they will not be  coming in thru the spreadsheets any more.\nSo, on amendments that affect  power, I am going to have to send you an email about the change.\nFor the above counterparty, we originally had them open for power sales  only.\nNow, Credit is coming back thru wanting to open them up for the bid  and the offer.\nDo you want to change the earlier approval from power sales  only, or open them up all the way?\n',
 'At the request of Paul Finken, I am attaching our proposed form of  Non-Disclosure Agreement.\nIf the enclosed meets with your approval, please  execute the agreement and return it to me via fax no.\n(713) 646-3490.\nI will  then have it executed by an officer of Enron.\nIf you have any comments or  questions please do not hesitate to call me at (713) 853-3399, or Mark  Greenberg, Senior Counsel, at (713) 345-8897.\nWe look forward to hearing  from you.\n',
 "Per our meeting, attached are the current forms of MAC Clauses.\nI have added  at the end of the list, the Event of Default for change in ownership because  I know that one comes up frequently.\nAlso, I don't know if you want to also  suggest that the other trading groups work from our guaranty forms as well as  our LC form.\nThe Legal heads of each of the trading groups are:  Mark Taylor:  Financial Trading Jeff Hodge:  Physical Gas Trading Elizabeth Sager:  Physical Power Trading Alan Aronowitz:  Physical Global Markets (Liquids, Plastics, Coal, Emissions  & Metals) Julie Murray:  Physical Industrial Markets (Pulp & Paper, Steel)\n",
 "We just opened the above counterparty to trade UK financial crude products  online.\nSince the Enron counterparty for these products is ECTRIC we will  need to get a master in place between ECTRIC and Counterparty.\nJustin Boyd  in London has graciously agreed to let us handle drafting and negotiation of  the master.\nCould you please provide us with credit for this master.\nI  don't know if we can just mirror the credit terms in the old master or not.\nSince the old master is a Local Currency Master, we cannot do a simple dupe  and change it for UK issues.\nI would suggest unless we really have problems  with issues, we more or less try to sign the same paper whenever possible.\nOf course, send the credit worksheet for the new master to the paralegals for  the rotation.\n",
 'At the request of Mike Bridges, I am attaching our proposed form of  Non-Disclosure Agreement.\nIf the enclosed meets with your approval, please  execute the agreement and return it to me via fax no.\n(713) 646-3490.\nI will  then have it executed by Enron.\nIf you have any comments or questions please  do not hesitate to call me at (713) 853-3399, or Mark Greenberg, Senior  Counsel, at (713) 345-8897.\nWe look forward to hearing from you.\n',
 "The above counterparty on the 3/7/01 list is ID#93394.\nWe had a counterparty  on the pre-approval list that was called International Paper Company and was  ID#1836.\nWas that one in error?\nAre they the same, different?\nWhat's the  scoop?\nThanks for your help!\n",
 'At the request of Daniel Diamond, I am attaching our proposed form of  Non-Disclosure Agreement.\nIf the enclosed meets with your approval, please  execute the agreement and return it to me via fax no.\n(713) 646-3490.\nI will  then have it executed by Enron.\nIf you have any comments or questions please  call Mark Greenberg, Senior Counsel, at (713) 345-8897.\nWe look forward to  hearing from you.\n',
 'We have received the above executed ISDA Master Agreements  (Multicurrency-Cross Border) with the two referenced counterparties executed  05/25/99, effective as of 11/16/98.\nCopies will be distributed.\nI have also received in the originally signed confirmations and will be  sending them down to Laurel Adams.\n',
 "As an introduction:  The referenced counterparty is trying to straighten out  the online products it wants to trade with us (it's open for some, but not  all of the products it wants to trade).\nWhen I looked at Profile Manager to see what they had already been approved  to trade, I noticed that this counterparty was opened to trade many of the  European products, including specifically European physical power products  (which is unusual for a US based counterparty to trade).\nBefore I go in and change the profile for this counterparty, I wanted to  check with you and see if London had specifically opened them to trade the  products they were opened to trade (especially physical power).\nWhat I usually do when I am approving US based counterparties, is that with  respect to Non Us & Canadian products, as long as they are an Eligible Swap  Participant I open them up for all products except European physical power,  which I never open them for.\nAlso, Credit Derivatives, I never open anyone  up for unless we really mean it.\nSo, my question to you is did London actively approve the non US & Canadian  based products (especially physical power).\nIf you didn't, then I am going  to take this as an oversight of the pre-approval process and shut them down  for European physical power.\n",
 'At the request of Bob Shults, I am attaching our proposed form of  Non-Disclosure Agreement.\nI am not sure if we have the correct legal name  of your company, so can you please verify that for me.\nIf you have any  comments or questions please call Mark Greenberg, Senior Counsel, at (713)  345-8897 or me at (713) 853-3399.\nWe look forward to hearing from you.\n',
 "Would you like to set up this meeting or would you like me to?\nI would like  to get this Koch thing resolved ASAP, so I think the sooner, the better.\nFrom Legal's side, both Mary Cook and I need to be included, I spoke to  Credit and both Walter Guidroz and Tom Moran would like to be included,  probably Joe Hunter from the Confirm Desk as well, and anyone else you're  aware of.\nLet me know how you think we should proceed.\n",
 'Per my discussion with Mark Taylor and our conversation today, attached is  the form of Termination Agreement that should be used when terminating  EnronOnline mistake or "oops" trades.\nThe trades should continue to be  initially run past the Legal Department to determine whether there are any  unusual circumstances surrounding the trades, but absent unusual  circumstances, Legal will then pass the trades on to the Confirmation Desk  for preparation of the Termination Letter and further handling.\nThese same  procedure should apply to physical as well as financial transactions.\nSince this is a contract, the agreement will require the initials of a lawyer  and signature of a VP or above for the relevant company.\nThe Termination  Letter should be brought to the appropriate Legal Group for signature.\nThe current policy with respect to mistake trades is that the trade should be  terminated.\nReverse trades should not be entered into.\nIf you have any questions, please call.\n',
 'Per my voicemail, attached is the assignment of the FPL trade.\nIf you could  please attach as Exhibit A, the specifics of the trade and then fax the  assignment to the counterparty.\nWhen the counterparty faxes the signed  Assignment back we will have to have it initialled by a lawyer since it is a  contract, and send it up to me and I will get someone to sign it.\n',
 "Below are the training preferences for our three Houston traders.\nIf you  could sign them up I'd appreciate it .\nI'll let you know as soon as I hear  from the two Portland lads.\nThanks for your help, it was fun chatting with you!\n",
 'Debbie Brackett and I met this week and reviewed the various Koch Hydrocarbon  Company Divisions and have developed the following game plan to resolve the  division issue with respect to this counterparty:  The following entities exist in GCP:  1.\nKoch Hydrocarbon Co. (GCP #36680):  We would like this entity to remain  OPEN and to be renamed "Koch Industries, Inc., acting through its Koch  Hydrocarbon Company Division".\n2.\nKoch Hydrocarbon Company (GCP #57853):  We would like all future trading  with this entity SUSPENDED.\nThere appears to be one trade under this entity  and this trade should me moved to GCP 36680.\n3.\nKoch Hydrocarbons Inc. (GCP #26197):  We would like all future trading  with this entity SUSPENDED.\nThere appear to be no trades under this entity.\nWith respect to the current financial trading being done by Koch Industries,  Inc. (GCP #126) (not under a master agreement), I spoke to the Legal  Department at Koch and we will be entering into a side letter agreement with  Koch that will put all financial trades done by Koch Industries, Inc. under  the existing ISDA Master Agreement we have with Koch Industries, Inc. acting  through its Koch Hydrocarbon Company Division.\nI will let you all know when  such side letter agreement has been executed.\nAs soon as GCP #36680 has been renamed we can re-submit them to EnronOnline  and open them up for trading.\n',
 'At the request of Dan Diamond, I am attaching our proposed form of  Non-Disclosure Agreement.\nIf the enclosed meets with your approval, please  execute the agreement and return it to me via fax no.\n(713) 646-3490.\nI will  then have it executed by Enron.\nIf you have any comments or questions please  call Mark Greenberg, Senior Counsel, at (713) 345-8897 or me at (713)  853-3399.\nWe look forward to hearing from you.\n',
 "Checking your mail, a Confidentiality  Agreement came in from Greg Bruch, I  gave him a call to see what his timing was, he said ite wasn't urgent, but if  we could get an attorney looking at it, to get it final maybe next week.\nIt  is counterparty's form, they would be the disclosing party, for a potential  fiber source deal.\nI am going to pass the agreement on to Carol for review,  and will leave you a copy.\n",
 "Attached is the list for 1/24/00.\nFor the list dated 1/25/00 which only had one amended counterparty, First  Energy Corp., I have a change in my earlier approval, from the Power Group.\nI don't have a code for this, so I'll just tell you, for this Counterparty  Enron call SELL power only to them pursuant to an on-line GTC.\nThis  Counterparty cannot sell to us via EOL.\n",
 'We have received the executed Amendment to ISDA Master Agreement between ENA  and the referenced Counterparty dated January 13, 2000.\nThis Amendment  amends the Threshold levels in the Credit Support Annex.\nCopies will be  distributed.\n',
 'As a follow-up to our conversation in London when you said I should bring to  your attention any concerns I might have with financial trading issues, the  following has recently come up as an issue here in Houston (and does so from  time to time).\nWe will, in fact, be discussing it at our group meeting next  week.\nI spoke to Edmund about it when I was there in London, but in light  of the recent Canadian form problems and the resulting concerns of Mark  Haedicke with the integrity of our forms, I thought I should bring this your  attention.\nOne of our continuing concerns on the financial trading side is that every  financial trading lawyer/paralegal work from the centrally approved forms.\nThe Houston forms are currently located in a "read-only" directory.\nWe need  to be careful that users copy the forms out of the directory each time they  use the form.\nCopying the form into a personal directory for ease of use  creates issues with people working from outdated base forms, or having forms  evolve without  approval.\nAnother way forms get changed without going through the approval process is  when an attorney tells the paralegals to make a change in every swap  agreement they approve.\nIt counts as a form change, not a negotiation  change, if you make it in every agreement.\nUltimately our goal is to centralize the forms in a database easily  accessible to all of us on a global basis (this is a central and critical  component of the Fishkin Project).\nThanks for your attention to this.\n',
 'We have received the executed ISDA Master Agreement (Multicurrency-Cross  Border) executed 04/08/99, effective as of 06/09/98.\nCopies will be  distributed.\nWe also received the originally executed Confirmation, Deal # EM3927.1,2 &  3.\nI will sent it down to the Confirmation Desk.\n',
 'Per Lotus Notes it appears that the above counterparty was acquired by Duke.\nI have sitting in my files the originals of both theirs and our guarantees.\nDo we want to keep these in place, mutually cancel them or what?\nWe sent  execution documents to the counterparty and never heard back and put it on  the inactive status.\n',
 "Hello Vince,  We've now got some slick results on rigorous and replicable avg temp forecasting models for twelve major U.S. cities, with implications for weather derivative demand and supply (although they are not yet written up formally).\nWill you be in Phila anytime soon?\nI would like to sit down with you for a couple of hours to show you the results and discuss.\nAre you still interested in pursuing a joint project?\nI am excited about this.\nAll the best,\n",
 'Dear Mr. Kaminsky,  As a first year MBA student at Rice University I am searching for a summer internship.\nPeter Veruki informed me that you were impressed with the Rice ALP students working at Enron and may have further opportunities available for this summer.\nSimilar to the Enron ALP, I worked on an Action Learning Project with Phillips Petroleum which involved a pension fund analysis along with recommendations delivered to senior management.\nPrior to beginning my studies at Rice,  I worked as a programmer with El Paso Energy, working on a proprietary energy trading system I would like to speak with you concerning opportunities at Enron for this summer.\nPlease call me at your earliest convenience.\nI can be reached at home at (281) 480-4894.\nI have attached my resume for your consideration.\nThank you,\n',
 'Guys  Next week we\'re planning on recalibrating the dummified regression models ("placement models") built earlier this year and last for the Enron Credit pricing system.\nThese basically have the objective of predicting a 5-yr CDS price for an illiquid name, based on available data.\nThis data consists of: Credit Ratings, Outlook and Watch Equity based data - eg, EDF, 90d Volatility, Beta, Market Cap, Dividend yield, PE ratio Financial ratios - eg, EBITDA interest coverage, Current ratio, EPS, Debt to Assets Descriptive Info - Country and Industry  I\'ve outlined the methodology used for the models thus far in the attached docs:      We\'re kicking off this effort next week with a brainstorming session with the trading desk, to outline areas of deficiency and proposed model improvements.\nFrom the quantitative side we\'d appreciate greatly if any or all of you could read these docs and offer any suggestions for improvement of the models.\nAny ideas on statistical techniques or the overall methodology will be welcome.\nI\'d also be happy to set up meetings or just talk on the phone if any further explanation is required.\nRegards\n',
 'Our natural gas business continues to benefit from effective account management and resource allocation focused on identifying and responding to the needs of our varied customers.\nIn order to keep our organization optimally structured and to facilitate additional growth, we are making the following changes:  Producer/Wellhead Group  The current mid-market, origination and wellhead pricing activity currently within the Central and Eastern Gas Regions will be consolidated with the Derivatives group under Fred Lagrasta.\nThis will create a single business unit focused upon the needs of the producing industry within the Eastern U.S.\nThe producer focus in the Western U.S. and Texas will remain unchanged reporting  to Mark Whitt and Brian Redmond respectively.\nStrategic Asset  Development Laura Luce will move from her role in the Central Region to lead an effort focused strictly on identifying and entering into long-term strategic arrangements within the Central and Eastern Regions.\nThis initiative will focus on a limited number of selected markets that provide strategic opportunities for partnering in asset development, asset management and optimization.\nThis effort will continue to work very closely with the regional leads.\nCentral Origination and Mid-Market Frank Vickers will continue his current role in the Eastern Region and will assume the leadership role for Mid-Market and Origination activity in the Central Region.\nThere will be no changes to the West and Texas Origination groups headed respectively by Barry Tycholiz and Brian Redmond.\nPlease join us in congratulating Fred, Laura and Frank in their new roles.\nLouise & John\n',
 'We are planning a party!\nIt has been a while since the group has had a party,  and my daughter is going to be a year old.\nSo we are  planning a party for November 11th, and Vandhana  and I would like to invite everyone in Research and  their family.\nAs yet we do not have the venue fixed, but please  keep November 11 (Sunday) free.\nPlease RSVP so that we can plan on the numbers.\nRegards,\n',
 "with enron europe reducing headcount it was raised that tony hamilton should be reassigned to egm.\nI'm not sure who should be his manager but can one of you let Lucy know who that is going to be.\nJeff please comment if you don't want this move to happen.\nTony is the meterologist that was hired for Europe.\n",
 'Dear Madam, dear  Sir,     Time is  passing...\nApplications of Physics in Financial Analysis 3  (APFA3)  ... will soon take place in the Museum of  London, UK, from 5 to 7 December 2001.\nThe provisional  programme of speakers and events can now be consulted on-line at:  www.eps.org/apfa/  We also have the  pleasure to announce the additional invited talk from Dr. Hans-Peter Deutsch  of Arthur Andersen, entitled "Second Order Approximations for Fast  Value-at-Risk Computations".\nIf you are not yet registered, you can  register on-line.\nWe remain at your disposal for further information.\nBest Regards,\n',
 'Dear Vince & Ozzie:  For the Research support of the EAM organization, we were planning till recently for a team of 4 to 5 people for 2002.\nOver the last four to five months, requests for our support have gone up, primarily for consumption risk, physical options and value-at-risk.\nHowever, given the challenges we are facing now, I would like to reduce the Research staff for EAM to a core team of 3 people with a budget allocation of roughly $750,000.\nPlease note that this includes not only the salaries and bonuses, but also the overhead and other expenses as well.\nThe breakdown of the support levels for individual groups (with agreement from the group heads) is as follows:  EAM Fundamentals (Steve Meyers)\t0.4 FTE \t\tCurve and Model Development Group (Mauricio Quintana) \t\tProject Valuation Group (Steve Kromer) DSM Desk\t0.6 FTE \t\tPricing and Risk Premiums (Ravi Duggirala) DSM VAR and risk controls (Vladi Gorny)\t0.5 FTE Consumption/SiteProfile Desk (Mallik AVS)\t1.25FTE \t\tConsumption Premium Models  \t\tSupport for SiteProfile Issues (load shaping, asset profiling, etc.)\nOther Short Term Requests\t0.25FTE \t(Examples from last year: Insurance Model for Rick Jones, Business Assurance data analysis, etc.)\nI would really appreciate if both of you can approve or provide your feedback on this.\nThanks,\n',
 "Folks, Here's some preliminary comments on the model we are using for Argentina.\nPlease correct me on any misunderstandings!\nModReg was written by consultants in Buenos Aires.\nDocumentation is available in Spanish only.\nAll data input is by means of text files, which require column orientated input, ie numbers must go into specific columns.\nDetailed documentation has been provided specifying the data format for each file.\nA weekly time step is used, with five load blocks per week, and a time horizon of one year, typically.\nEach model run requires about 6 hours of processing.\nModReg is a modified version of the model used by the grid operator.\nIt is coded in Fortran and requires a CPLEX licence.\nCPLEX is a powerful linear programming solver, developed by ILOG.\nAs the model is written in Fortran, the very good higher level interface to CPLEX is not available, so the code will have to access CPLEX at a lower level.\nWe have no documentation describing how the model algorithms.\nSource code is not available at present.\nModReg appears to model around 30 busses and 71 lines.\nLines are characterised by from bus number, to bus number, maximum MW capacity in each direction, a percentage  loss factor, cost of transmission in each direction, and some other details.\nDemand data is specified by week and load block for each bus.\nThermal plants have a heat rate and maintenance schedule specified, with the possibility of multiple fuels.\nI understand that hydro generation schedules for each historical inflow condition are an input to the model as they are calculated elsewhere.\nFrom the above it appears that we have an unsatisfactory situation: \tModReg is difficult to use \twe do not know in detail what the model does \twe do not have documentation describing the algorithm  \tbecause source code is not available, we are completely dependent on the consultants.\nIf Enron is to continue modeling Argentina, we should as a minimum have a model that we understand, is reasonably easy to use, and is documented.\nA graphical user interface is really needed to make ModReg easier to use.\nDocumentation is of course essential.\nWe should not use a model developed by consultants without documentation.\nThese steps would enable us to have more confidence in model results, and shortens the learning curve to enable more people to use model.\nSDDP is likely to be a suitable replacement.\nIt would require reseroir inflow data rather than the calculated generations.\nThe regional loads etc could be modeled using the DC loadflow feature, with zero impedance lines.\nTransmission losses in SDDP are a quadratic function of power flows, so some guesses would have to be made for line resistence values.\nSetting up an SDDP model to represent all the aspects included in ModReg would be a time consuming job, that would require a good undertanding of the data for both models.\nSome direct cut and paste of data from one model's files to the others will be possible with a suitable column oriented text editor.\nHowever the end result would be a model with the desirable attributes of documention, GUI interface, and flexible output.\nTom Halliburton\n",
 "Dear prospect sponsors: In behalf of the Rice MBA students interested in th= e Energy Industry I want to thank you for your interest in the Energy Club = and present to you the club's program for the academic year 2001-2002.\nWe = have a great number of opportunities and the attached program provides an o= verview of the topics for the academic year 2001-2002.\nI would like to tak= e this opportunity to present to you how the club intends to involve and ed= ucate the students' body on the Energy Industry, and I would also like to p= resent the format we will use for this end.\nWe have three levels that built=  one upon the other.\nThe first level is a general understanding of the Ene= rgy industry, (see Energy 101 event).\nThe second level it refers to the op= portunities available for MBAs in the Energy industry, (see rest of the pro= gram), and the third will focus on the opportunities/profiles in demand now= , (no identified yet).\nThe format is a roundtable presentation in which r= epresentatives from different companies bring they perspective and work exp= erience, relative to the topic of the meeting.\nEach roundtable has or will=  have a leader and moderator; the leader is responsible for organizing the = event and it is your reference.\nPlease contact the person associated to th= e event if you are interested in participating in that specific roundtable.=  If there is no name feel free to e-mail me.\nThe Energy club heavily depen= ds on your participation and your support will definitely bring value to al= l students in different ways.\nYou will also attract more talents, help stu= dents to take a better-informed decision with regard to the professional fu= ture, and establish a more intimate relationship, mutually beneficial for s= tudents and companies.\nNext step.\nThis coming Friday we are hosting the En= ergy 101 roundtable.\nIn this case the leader, Craig Parks, will have in th= e panel students with relevant work experience in the Energy Industry.\nPle= ase see the attached file if interested.\nNext week I am going to submit th= e Program to all first and second year students, I aspect to have the list = of the moderators by the end of the next week.\nI will promptly notify all = of you.\nIf you are not interested in receiving further information about th= e Energy Club please e-mail me and I will withdraw your name from the list.=   If you believe in this initiative an admiring comment is welcomed.\nI wil= l collect all your feedback and implement them if possible in this same aca= demic year or leave them as guides for the next year.\nThanks in advance for=\n",
 "Vasant,  I had a chance to speak today with a representative from Estima, the maker of RATS.\nEvidently, our current license is as follows:  \t\tVersion:  RATS 4.0 (original license cost of $ 1,200.00) \t\tMax.\nNo.\nof Users: 4  The following options outline the costs of upgrading the software:  Option 1  Version:  RATS 5.0 Users: Site license for Houston/unlimited  \tRATS 5.0\t$ 5,100.00 \tCATS module\t$ 1,200.00    \t(cointegration module) \tX-11 module\t$ 1,200.00    \t(RATS implementation of Census Bureau's seasonal adjustment--aids in \t\t\t$ 7,500.00       \tadjusting quarterly and monthly data as well as options for identifying \t\t\t\t\ttrading days and holidays in time series)\n",
 "Hi Vince,  I saw that you will be featured on the finance panel for the leadership conference at Sloan.\nI plan on attending, and will enjoy seeing you again.\nI don't know if your schedule is too full but it would be great to catch up if you have any time.\nThe first semester here in school roars on.\nWe had our first midterm today (accounting).\nFor me, it feels like school will be over very quickly.\nNot surprisingly for Charlotte and the boys, it probably can't be over soon enough.\nI hope things are well with you and everyone else in Research.\nGive my regards to everyone.\n",
 "Hi, Vince,  This is Slav Fain - Oracle DBA  and I hope you remember me.\nWe've met at the infosession in Berkley and have talked about Houston, rotation program or other possible openings Enron might have.\nToday I've saw an add for the Junior DBA position in Houston and I was wondering  if it might be in your company.\nI beleive I told you, that I'm pretty open for different position.\nI was doing a lot of development projects in Berkley and enjoyed it.\nI've also found DBA work also very challenging and rewarding.\nI would be very intersted in joining the rotation program to see different possibilities and aspects of IT department.\nI'm opening for relocation and I think with knowledge, experience and my enthusiasm to learn and ability to work under tight timeline - I think I can be a good match for Enron.\nHope to hear from you soon.\nSlav\n",
 'Vince , take care and may God Bless you and your family.\nJust in case we miss each other on tomorrow , it was a great pleasure working with you and I somehow feel that you will make it alright.\nOnce again , God Bless You and thank you for being a wonderful man.\nKevin Moore\n',
 "Jeff,  A few comments on the model:  1.\nWe have a few reservations about some features of the model but would like  to discuss it internally and make the improvements without giving the benefit of  our insights to the consultant.\nIn general, the model is not unreasonable but the devil is always in the  details and in the inputs and calibration.\nThe same model may produce drastically different results  depending on the quality of inputs.\n2.\nWe don't have a separate pool of programmers in the Research  Group.\nWe  were told that you would provide an IT resource.\nAlex would supervise this person.\nVince\n",
 "Anita,  Shirley is out sick today.\nCan you, please, confirm my lunch with Bjorn Hagelman (Enron), 11.30 today (Friday).\nPlease, ask him if he wants me to make reservations?\nIf the answer is Yes, please, make a reservation for 2 at Damian's, 11:45.\nVince\n",
 "Norma,  I am sending you preliminary rankings for my entire group, based on the results of a meeting we held on Tuesday.\nWe have ranked Shalesh Ganjoo and Clayton, in case it's still our responsibility.\nVince  Permanent goup members, manager and below:  Superior:  1.\nMartin Lin 2.\nJoe Hrgovcic 3.\nTom Haliburton 4.\nJose Marquez  Excellent  1.\nPaulo Issler 2.\nRobert Lee 3.\nChonawee Supatgiat 4.\nAmitava Dhar 5.\nAlex Huang 6.\nKevin Kindall 7.\nPraveen Mellacheruvu 8.\nShanhe Green 9.\nStephen Bennett  Strong  1.\nLance Cunningham 2.\nClayton Vernon 3.\nYouyi Feng 4.\nYana Kristal 5.\nSevil Yaman  Permanent goup members, directors:  Superior  1.\nKrishnarao Pinnamaneni  Excellent  1.\nOsman Sezgen 2.\nTanya Tamarchenko 3.\nZimin Lu  Satisfactory  1.\nMaureen Raymond   Associates, analysts  Superior  1.\nShalesh Ganjoo 2.\nGwyn Koepke    Excellent  1.\nHector Campos 2.\nKate Lucas 3.\nSun Li 4.\nRoman Zadorozhny 5.\nCharles Weldon\n",
 'John,  The outline of a message to Nesbitt.\nDale,  Thanks for your message.\nIn our phone conversation before the meeting  you  mentioned  another contractual arrangement under which we could work with  your  company  employees on a case-study.\nThe cost of a weekly project  would be $12,000 that would be applied to the  purchase price should we go ahead and decide to acquire the software.\nThis project would allow us  to evaluate the model and come up with an estimate of the manpower necessary to support  the model  internally.\nPlease, let me know more about this option.\nVince\n',
 "Shalesh,  Please, look into it.\nCan we give them this information?\nI see a remote possibility of a gain for Enron: it's in our interest to  support the growth of this market and part of the process is development of the infrastructure for this market and maintaining public interest.\nVince\n",
 'Hello Charlene,  I am forwarding you a resume of a student from Berkeley.\nWe would  like very much to have him as a summer intern with my group.\nPlease, let me know if your program can accommodate him.\nVince\n',
 'Elena,  Please, review the energy related info in this database (if any) and talk to  me  about it.\nI would like to do some research in this area and ask you to write a summary  report.\nNothing urgent.\nVince\n',
 "I shall interview this candidate next week (a very preliminary interview) to evaluate his potential and determine if he fits Enron's culture.\nDo you see a need for a person with his skills in your area (litigation  support)?\nVince\n",
 'Greg,  Blake Johnson sent me this proposal (I think some of his friends are the founders of this group).\nIt looks like a good project for Brad Romine to evaluate it.\nVince\n',
 'This is the list of projects for the members of the "quant" team.\nIf you are working on different project, please, ignore this message.\nPlease, develop in a spreadsheet solutions/examples for the following:  1.\nBlack-Scholes formula 2.\nBlack\'s formula 3.\nDevelop a spreadsheet to simulate price trajectory using:  a. GBM  b. GBM + jump (Formula 2.16 in the book, Figure 2.7)  c. Mean reversion + jump (Formula 2.17, Figure 2.8) 4.\nSchwartz Single Factor Model (Formula 6.12) 5.\nDevelop models corresponding to the Figures 7.1, 7.3, 7.5, 7.6, 7.8  Vince\n',
 'Chris,  We shall try to call you around 5:00 p.m. our time on Monday.\nWhat is the best phone number we can use to reach you?\nVince\n',
 'Krishna,  Any update on payments to Stanford?\nWe can ask for a letter to requesting a donation.\nI would use it as a basis for cutting a check.\nPlease, talk to Hill about it.\nVince\n',
 "Mark,  Did you have a chance to review the E&P company model (the old cash flow mode) and determine if it can be used by Fred Lagrasta' group.\nPlease, let me know.\nVince\n",
 'Joe,  This is a message from the Japanese guy interested in energy risk management.\nPlease, let me know if you want somebody from your organization at the  meeting.\nHe will be here next Monday at 3:00 p.m.   Vince\n',
 'Lynn,  I am forwarding you the resume of a very bright and motivated young man who attended a lecture I gave recently at LSU.\nI think we should consider him for an analyst position.\nVince\n',
 'Rebecca,  I share some of your concerns regarding Mr. Sud.\nHe is retired and he chose to contact us rather indirectly (or on the spur of the moment).\nI understand  that things are done differently in different cultures but I  did not meet him and could not form my judgment based on personal observations.\nHowever, the information  he gave us seems to be too important not to convey to you and not to act upon.\nVince Kaminski\n',
 'Christie, Karen and Mike,  This is info about Texas Finance Festival,  a great opportunity to establish  closer ties with Texas business schools.\nYou can contact John directly if you are  interested in attending.\nVince\n',
 "Steve--touching back to a conversation we had two weeks ago, I have set an appointment to meet with Norm Coleman here in Minnesota to go over energy issues and Enron interests.\nAs a Mayor he has been heavily supported by Xcel (old NSP).\nMy sense is that he is going to line up along the lines of the Bush administration energy plan.\nI'll send an e mail out to all on this list once I have met with him to keep everyone in the loop.\n",
 'This is a friendly reminder of the HR-Bi-Weekly Leadership Meeting tomorrow (Tuesday, October 23, 2001) at 8:30 am.\nThis meeting will be in 16C1.\nIf you are unable to attend, please let me know.\nP.S.\nA light breakfast will be served.\n* Note to Jon, what # do we call you at ??\nThank you, Zulie 853-3908\n',
 'Enron employees not participating in contract parking are eligible to receive Metro Bus Passes or Woodlands Express Passes.\nYou may pick up a bus pass from the Parking & Transportation Desk, on Level 3 of the Enron Building, from 8:30 AM to 4:30 PM.\nAll Metro passes offered through the Enron Parking & Transportation desk will be the Metro 30 Day Zone Pass.\nWhen you use a 30-day zone pass, bus service is divided into four zones w/ unlimited rides.\nThe zone pass is time activated, which means that it will not become active until the first time it is used and will not expire until 30 days after it was used for the first time.\nNew passes will be available to Enron employees upon expiration of the 30 day time period.\nEach zone does have a different fare values based on the distance the bus travels.\nThis is important to any buser who wants to transfer to or travel in a higher-cost zone than the zone pass they have, in this case the difference must be paid in cash.\nIf they are traveling in a lower cost zone, then there is no extra cost.\nParking & Transportation Desk 3-7060\n',
 'Sherrie and Rosie:  Jeff and Ken both received notes from Tom Delay about  designating portions of their contributions for use  in Texas.\nMr. DeLay  would like them to make that designation using the letter below (note that it  will need to be modified to be from each individually rather than a joint  letter).\nIt is, of course, up to Ken and Jeff whether to make the  designation.\n',
 "The Governor's advisors will not be prepared to discuss the credit issues on  Friday.\nA new dial in number has been set up for a conference call amongst  the sellers.\nThe time and participant codes remain the same - only the dial in # has  changed.\n",
 'calendar.\nAlso, I would like you to set up a meeting with me, Cindy Olson, Beth Tilney,  Kelly Kimberly, Mark koenig, Rick Causey, and Rick Buy.\nI was thinking the  easiest way to get us all together would be to get a room at a restaurant for  6 or 6:30 some evening.\nI have contacted Beth and Cindy already, so they  know what it is about, and I will leave messages for the others.\nI just need  to check schedules for now.\nAlso,  I think it would be a good idea to have a get together after work once  a month or so for the Public Affairs organization.\nNothing fancy .\n.\n.\nCadillac Bar or something similar.\n.\n.\nspouses and significant others  invited.\nTalk it over with a couple of people in the group and let me know  what you come up with.\n',
 "Attached is some background information for today's Corp. Policy Committee  meeting.\nI will bring hard copies to the meeting.\nPlease note:  tabs C and D are not included in the email attachment, but will  be included in the hard copies.\n",
 "I agree with John's recommendations.\nWe have been doing surprisingly well in the press.\nAnd, for the most part,  those who write bad stuff are doing so based on ideology ... we are not going  to convert them.\n",
 "As I promised this morning at the executive committee meeting, below are some  talking points for your use.\nOverall message:  the market is working, regulation is not.\nIn California, peak demand rose by 10% over the last 4 years while new  capacity grew by only 2%.\nBut, as you would expect, the market responded by  proposing 8,000MW of new generation - - more than enough to offset the peak  demand growth.\nThe regulatory process, at both the state and local level,  has failed to site this new generation.\nThe problem is regulation, not  deregulation.\nWhen San Diego customers began experiencing the effects of higher prices,  Enron responded with a fixed price which would have shielded San Diego  customers from price volatility and provided prices below their current  summer levels (Enron's price was about $55/MWH).\nAfter publication of  Enron's offer, nine other companies made offers.\nAgain, the market responded  where regulation failed.\nSan Diego has not accepted any of these offers  because of regulatory/legislative restrictions on its ability to buy outside  of the PX (i.e.\nthe spot market).\nIn markets where siting is easier, suppliers have moved to build additional  generation.\nEnron built 3 plants in response to the 1998 price spikes.\nThose plants were planned, sited and built in less that 12 months - - in time  for the summer of 1999.\nWhere regulatory hurdles are lower, the market  responds.\nThe solution to current pricing and reliability issues is more competition  not reregulation.\nPolicy makers should:  Open the transmission grid so that power can get from where it is to where it  is needed.\nExpedite interconnection of new generation.\nExpedite siting of new facilities.\nGive customers a choice, so that they have better access to demand side  solutions.\nAlso attached is a more detailed discussion of California, prepared by Jeff  Dasovich of our San Francisco office.\n",
 'I\'m looking forward to your discussion regarding the "reregulation threat" at  the next meeting.\nBelow are some of my observations:  While it\'s premature to say we have an energy crisis, we are witnessing the  triple threat of high summer gasoline prices, spiking electricity prices, and  high natural gas prices for the upcoming heating season (I\'ll send along some  of the data).\nThere is at least the potential for this to become a prominent national  political issue:  Gore has focussed relentlessly on Bush\'s ties to "big oil"  (which includes us by the way, though we produce nary a drop); and  Congressional republicans have blamed the current administration for failing  to have a coherent energy policy (though, at least so far, the dominant  characteristic of the administration\'s policy has been a republicanesque  reliance on the market).\nNotwithstanding the issue\'s potential to become political fodder and its  prominence in the popular press, many Americans seem blissfully ignorant, at  least on the electricity issue.\nWe did some focus group testing recently in  Southern California -- a mere 15 minutes from the epicenter of the San Diego\n',
 'Steve Kean asked that you review this memo to Ken Lay.\nPlease let me know  as soon as possible if you have any changes.\nAfter your review/comments - I will forward it to Ken Lay.\nThanks.\n',
 'I am recommending Linda Robertson (currently Assistant Secretary for the  Department of the Treasury) for the position Vice President and General  Manager of Federal Government Affairs.\nLinda would head our Washington, D.C.  office, replacing Joe Hillings who will be retiring early next year.\nLinda has interviewed with Ken Lay, Tom White, Mike McConnell and Jeff  Shankman, who join me in this recommendation.\nAttached are biographical information on Linda and a National Journal  article identifying Linda among the "Washington 100".\nWe have conducted extensive reference checks on Linda.\nIncluded among those  was Secretary Summers who said:  "Nobody I know has the determination she has to get objectives met."\n"Far more capacity to grasp the details than anyone I\'ve seen."\nOn Monday, I will seek Executive Committee approval to extend the offer to  Linda.\n',
 'Bill:  Steve Kean would like the attached memo and attached org chart to go out=20 company wide.\nSubject: Public Affairs Organizational Announcement  Text:=20   =20  I am pleased to announce the following changes in the government and=20 regulatory affairs organization:  Rick Shapiro =01) Managing Director of Government Affairs for the Americas.=  =20 Rick is currently leading the government and regulatory affairs teams for t= he=20 US and Canada.\nHe will now assume responsibility for North and South=20 America.\nRicardo Charvel (Senior Director of Government Affairs for=20 Mexico),  Jose Bestard (Vice President of Government Affairs for South=20 America), and Joe Hillings (Vice President of Federal Government Affairs)= =20 will now report to Rick.\nRick and his team will support Enron=01,s North= =20 American business units as well as the Caribbean and Southern Cone regions.\nMark Schroeder =01) Vice President Government Affairs for Europe, Asia and= =20 Africa.\nMark is currently leading the government and regulatory affairs=20 teams for Enron Europe.\nHe will now assume the additional responsibility o= f=20 supporting the APACHI and India organizations.\nJane Wilson will now focus= =20 her attention on Enron India and will report to Mark as will our government= =20 and regulatory affairs teams serving the APACHI region.\nMike Terraso =01) Vice President  Environment, Health & Safety and Chief=20 Environmental Officer.\nMike is currently serving as Vice President of=20 Environment, Health and Safety for the gas pipeline group.\nMike has=20 increasingly become involved in environmental issues facing Enron=01,s=20 businesses around the world.\nMike will retain his current responsibilities= =20 and will assume leadership of the environmental affairs team.\nJohn Hardy =01) Vice President Global Project Finance.\nJohn will report=20 directly to me and will continue his current responsibilities representing= =20 Enron before US and multilateral project finance agencies.\nPlease join in me in congratulating these individuals on their=20 responsibilities.\nAttached is a revised organization chart reflecting these changes.\n',
 "Joe:   Steve asked that I pass the following request along to you.\nKathy Cash, reporter for McGraw Hill, called wanting Steve's comments on the  regional market/policy info released by FERC today.\nPlease follow up.\nHer number is 202/383-2274.\nThanks.\nJoyce for Steve\n",
 'Want to have fun?\nWant to get on a game show?\nWant to help Millions?\nTomorrow you will receive an email that allows you to answer 15 questions via  email responses (about United Way, Enron, and other fun items).\nParticipation with correct answers puts you in the drawing for the employees  to represent Corp. in a "Who wants to be a Millionaire?"\ngame that will be  played to benefit United Way on August 9.\nThe lucky and smart  representatives will be playing for great prizes.\nI encourage your participation in the game, but more importantly, encourage  your generous participation in Enron\'s United Way campaign.\nThanks for your  help and HAVE FUN!\n',
 "Do we have someone who works for us now who was at Transredes when the  government owned it and could help us do a comparison between our respective  environmental records?\nIt seems to me that even though we are having our  share of problems, we have probably had fewer problems than the government  did and have probably been more responsive and thorough in our clean up  efforts.\nObviously, we would need to be judicious about how we used such  information (we don't want to aggravate the government), but having such an  analysis may be helpful in showing the progress made and in discouraging  overly punitive action by the government.\nWhat do you think?\n",
 'PRIVILEGED AND CONFIDENTIAL - -  Seeking Advice of Counsel - -   Attached is a draft public statement for your review and comment.\nThe groundrules for using these statements are as follows:  All press inquiries should be directed to Eric Thode.\nWe will use the more "basic statement" unless press inquiries are specific  and informed by knowledgeable industry participants.\nWe will use only those parts of the more detailed statement which are  necessary.\nThe document begins with a background piece to briefly educate Enron  personnel who may not be aware of Project Stanley but may be called upon to  respond to regulators\' or customers\' inquiries.\nAleck - - please get Seabrou\'s help filling in the blanks.\nRichard - - feel free to forward to outside counsel as you see fit.\n',
 'The real time weighted average price for fixed price products for May can be found on the Fundy site under Price Data/EOM Price Index.\nLet me know if you have any questions.\nNote: If the product has not traded it will not show in the list.\nThanks to Colin Tonks and Lindon Chiu for your help.\n',
 'BUSINESS HIGHLIGHTS  Enron Industrial Markets Metal Bulletin - Iron and Steel Awards for 2000 Pushiest Entrant: Enron, the US commodity trading company, which promised it would revolutionize the steel business by offering futures in hot rolled coil via its online market place.\nThe EIM Fundamentals Analysis group is excited to announce that Dave Allan has joined as a Director, responsible for all Forest Products lines.\nHe comes to EIM with 20 years of experience in the Forest Products industry, of which 14 were spent at Abitibi and 6 with Pulp and Paper Week.\nPlease join us in welcoming Dave.\nThe Siebel Team ("The Force") continues to work towards program implementation of its customer management system in early May, with training to begin at the end of April.\nStay tuned for updates.\nEnron Global LNG Enron Global LNG is positioning itself to be a creator and leader of a global wholesale LNG market.\nThe rising prices of natural gas in the United States and concerns over future energy supplies have created a bullish outlook for LNG in the U.S. and around the globe.\nLNG has played a major role in serving energy needs in many parts of the world, but its place in the U.S. energy picture has been limited.\nAn LNG market that spans the globe can supply vast amounts of otherwise stranded gas to the world\'s growing appetite for cleaner burning fuels.\nEnron Global LNG sees great opportunity for Enron\'s wholesale energy business model to help shape yet another energy market.\nIN THE NEWS  Enron Corp. Says First-Quarter Profit Rose 20 Percent  Houston, April 17 (Bloomberg) -- Enron Corp., the largest energy trader, said first-quarter profit rose 20 percent as sales almost quadrupled.\nProfit from operations rose to $406 million, or 47 cents, from $338 million, or 40 cents, in the year-earlier period.\nEnron raised its 2001 profit forecast to $1.75 to $1.80 a share, from its January projection of $1.70 to $1.75.\n',
 "To further the process of reaching the stated objectives of increasing Enron America's Velocity of Capital and associated Return on Invested Capital, we have decided to create a Capital Book.\nThe Capital Book will have no profit target associated with it and will be managed by Joe Deffner.\nThe purpose of creating this book is to ensure that all transactions within Enron Americas, with any form of capital requirement, are structured correctly and are allocated the appropriate cost of capital charge.\nThe previous numbers used in the Business Plans at the beginning of this year will remain for all transactions in place and where we hold assets.\nTherefore, on any assets currently held within each business area, the capital charge will remain at 15%.\nInternal ownership of these assets will be maintained by the originating Business Unit subject to the Internal Ownership Policy outlined below.\nThe cost of capital associated with all transactions in Enron Americas will be set by Joe.\nThis process is separate and apart from the current RAC process for transactions which will continue unchanged.\nCapital investments on balance sheet will continue to accrue a capital charge at the previously established rate of 15%.\nTransactions which are structured off credit will receive a pure market pass through of the actually incurred cost of capital as opposed to the previous 15% across the board charge.\nTransactions which are structured off balance sheet, but on credit will be priced based upon the financial impact on Enron America's overall credit capacity.\n",
 '"It\'s a Girl" performed by Weave Dance Company  Weave Dance Co. will perform May 24-26 at 8:00 p.m. at Stages Repertory Theater, 3201 Allen Parkway at Waugh, Call 713-52STAGE for tickets.\nThis performance, called "It\'s a Girl!"\ncelebrates pregnancy and motherhood.\nDonations to the Houston Area Women\'s Center will be collected at the performance.\nAny of the following items are welcome:  non-perishable, pre-packaged healthy food snacks such as granola bars and boxed juices, baby supplies such as formula, diapers, wet wipes, baby lotion, baby shampoo, pacifiers, socks, plastic bottles, diaper bags, crib sheets for portable cribs and swim suits and flip flops for children age 4 and older.\nStar Wars: Films (May 4-25) See all four completed films of the legendary Star Wars saga on the big screen!\nThe MFAH presents special editions of Episodes IV-VI and Episode I in the newly renovated Brown Auditorium with Dolby Digital dts sound and stadium seating.\nStar Wars: Episode IV-A New Hope Directed by George Lucas (USA, 1977, 125 min.)\nFriday, May 4, 7:30 p.m. Saturday, May 5, 11:00 a.m.  Star Wars: Episode V-The Empire Strikes Back Directed by Irvin Kershner (USA, 1980, 120 min.)\nFriday, May 11, 7:30 p.m. Saturday, May 12, 11:00 a.m.  Star Wars: Episode VI-Return of the Jedi Directed by Richard Marquand (USA, 1983, 132 min.)\nFriday, May 18, 7:30 p.m. Saturday, May 19, 11:00 a.m.  Star Wars: Episode I-The Phantom Menace Directed by George Lucas (USA, 1999, 133 min.)\nFriday, May 25, 7:30 p.m. Saturday, May 26, 11:00 a.m.  Tickets go on sale at the Brown Auditorium ticket booth 30 minutes before show time.\nThe ticket booth is located on the lower level of the Caroline Wiess Law building.\nGeneral admission is $5.\nMatinee admission (show times before 5:00 p.m.) is $4.\nEnron employees with ID receive a $1 discount.\nDiscount passes (10 admissions) are $40 for nonmembers and $35 for members.\nChildren 5 and under are free.\nFilms are screened in Brown Auditorium in the museum\'s Caroline Wiess Law building, 1001 Bissonnet.\nFree parking is available.\nFor more information, please call 713-639-7515 or visit our website at www.mfah.org.\nMark Your Calendars!...Bring Your Child To Work Day will be Friday, June 29th.\nMore details to come...See Volunteer section below to for volunteer opportunities!\nJoin us in Dublin or Honolulu ----Joints in Motion is a marathon training program for walkers and runners that is aligned with a fundraising effort for the Arthritis Foundation - Please call for more information at\n',
 'The information contained herein is based on sources that we believe to be reliable, but we do not represent that it is accurate or complete.\nNothing contained herein should be considered as an offer to sell or a solicitation of an offer to buy any financial instruments discussed herein.\nAny opinions expressed herein are solely those of the author.\nAs such, they may differ in material respects from those of, or expressed or published by on behalf of Carr Futures or its officers, directors, employees or affiliates.\n?\n2001 Carr Futures   The charts are now in the most recent version of Adobe Acrobat 4.0 and they should print clearly from Adobe Acrobat Reader 3.0 or higher.\nAdobe Acrobat Reader 4.0 may be downloaded for FREE from www.adobe.com.\n(See attached file: ng_rpt.pdf)(See attached file: ho_rpt.pdf)(See attached file: hu_rpt.pdf)(See attached file: cl_rpt.pdf)\n',
 'Attention supervisors and managers!\nWould you like to improve your ability to lead and manage your team?\nThe EWS Development Center would like to invite you to The Managers Level Impact and Influence Program.\n',
 "Dear Peter, Pick Your Playground!\nWe have the cure for the summertime blues, and we'd like to share it  with you: Get out and play!\nIsn't that what summer's all about?\nThe  kids in your life would agree, and so would the kid inside you.\nNow  that you're an adult, you may not get three months of summer vacation.\nBut on the other hand, the world's your playground.\nSo go ahead--pick\n",
 'MARK YOUR LUNCH CALENDARS NOW !\nYou are invited to attend the EWS Brown Bag Lunch Series  Featuring:  MICHAEL L. MILLER  Topic:  Principal Investments  Thursday, May 17, 2001 11:30 a.m. - 12:30 p.m. EB 5 C2  You bring your lunch,\t\t\t\t\t\t\t\t\t\tLimited Seating We provide drinks and dessert.\nRSVP  e-mail Kathie Grabstald \t\t\t\t\t\t\t\t\t\t\t\t\t      or call x 3-9610\n',
 "eSource Presents Lexis-Nexis Training  Basic  Lexis-Nexis Basic is geared to the novice or prospective user.\nYou will learn the basics of getting around Nexis.com.\nWe will talk about news and company information available on Lexis-Nexis.\nAttend our Lexis-Nexis Basics Clinic:  \t\t\t\t November 6\t  1:00 - 2:00 PM \tEB572 \t   Due Diligence  This session will focus on the specific company, public records, and other sources available on Lexis-Nexis that help you find all possible aspects of a company's business and strengths or liabilities.\nAttend our Lexis-Nexis Due Diligence Clinic:   November 6\t  2:30 - 4:00 PM \tEB572   Seats fill up fast!\nTo reserve a seat, please call Stephanie E. Taylor at 5-7928.\nThe cost is $100.00 per person.\nNo-shows will be charged $200.00.\n* Please bring your Lexis-Nexis login ID and password.\nIf you don't have one, a guest ID will be provided.\n* * *   eSource presents free Lexis-Nexis Online Training   Using Placeware, an interactive web learning tool, you can participate in this training session from anywhere in the world.\nBasics  Lexis-Nexis Basic is geared to the novice or prospective user.\nYou will learn the basics of getting around Nexis.com and of the news and company information available on Lexis-Nexis.\nAttend our Lexis-Nexis Basics Online Clinic:   November 14\t10:00 AM Central Standard Time\n",
 "eSource presents Lexis-Nexis training  ADVANCED  This session will cover advanced searching tips.\nIt will also cover using Smart Indexing to narrow your search results.\nFind out how to customize your desktop for easier searching.\nAttend our Lexis-Nexis Advanced Clinic:  \t\t\t\t May.\n18     8:30 - 10:00 AM   \tEB572    PUBLIC RECORDS  Lexis-Nexis is the premier provider of public record information.\nWe will learn about materials available to you including Secretary of State Filings and DBA's, UCC filings, Bankruptcies, and Property Records.\nIf you are doing due diligence on companies, especially smaller ones, this is a session you will want  to attend.\nAttend our Lexis-Nexis Public Records Clinic:   May.\n18    10:30 AM -12:00 NOON \t    EB572\n",
 "Please respond to Sivy on Stocks SIVY ON STOCKS from money.com May 7, 2001  Higher Flyer  Top techs such as Nokia may not look cheap by traditional valuation measures.\nBut they may still be good buys.\nBy Michael Sivy  Value is a relative term.\nEvery once in a while, you get a chance to buy shares in a company with annual earnings growth of more than 20 percent at a price/earnings ratio of 16 or less.\nBut that doesn't happen very often.\nMost of the time, conservative investors are lucky to find 14 percent growth at a 16 P/E.\nSlightly more aggressive investors might be happy with 18 percent growers at P/Es in the low 20s.\nThe most successful growth stocks, however, may never fall all the way down to those cheap valuations.\nBut that doesn't mean you shouldn't buy them.\nIn fact, there are good reasons to devote at least a part of your portfolio to those kinds of high flyers.\nFor one thing, those companies are typically among the world's most successful.\nIn addition, they receive ongoing support and sponsorship from Wall Street analysts.\nAs long as they continue to meet expectations, they will hold up fairly well in temporary market downturns.\nAnd they will be among the first stocks to bounce back.\nA perfect case in point looks to be Nokia [NOK].\nThe Finnish giant is the most successful firm in one of the world's most rapidly growing industries.\nAnd since 1997, Nokia's share of the global wireless-phone handset market has risen from less than 20 percent to 35 percent, helping the company nearly double earnings per share since 1998.\nOf course, no company can increase its market share indefinitely, but there are several factors that should help sustain Nokia's superior profit growth.\nSince most everyone who would use a cell phone already has one, the bulk of the sales of cell phones using existing technology is replacement business.\nAnd when existing users switch phones, they tend to maintain brand loyalty -- if they change providers at all, they migrate toward the\n",
 "Please respond to feedbackRomance in Paradise!\nDear Peter, Everyone has their own definition of paradise.\nFor some it's  unspoiled beaches and lush tropical jungle.\nFor others it's a more  developed resort.\nFor others, it's not about the outdoors at all--if\n",
 'Dale,  Here are the confirms for the Gas Daily option products that I need created.\nThe product has no special requirements for setting the strike etc.\nif there are any questions please call me asap.\nI would like to have these  products online by the October expiry which is next wWednesday.\nPlease let me know when it will be possible  Thanks\n',
 'Louise,  I received the attached questions from Gas Daily regarding our disaster  preparedness.\nJeff Shankman asked me to forward them to you.\nI would also be interested to  know what disaster plans have been made for EOL .\nThanks\n',
 'David Grant has assembled a team to work on gathering documents in response to the numerous subpoenas the company is receiving from Congress, the SEC and the Department of Justice.\nPlease cooperate with the team if they need your assistance.\nIf you have any questions, please call David Grant at 3-6239.\n',
 'Kam: I had issues.\nThe Trade Type Distribution by Transactions(57,619) does not equal the total number of transactions by tenor(57,583) or by MTM(57,583) due to duplicates.\nFor example,  deal # EX2226.1 is listed as a Forward and a Flex Price.\nSubsequently, this deal is counted twice under the Trade Type distribution and only once in the tenor and MTM sections.\nI made a cell note in the attached spreadsheet - Cell H49 of FormB - that lists all the duplicates.\nLet me know what you think and I can wrap this up Monday a.m. Have a good weekend.\nThanks,\n',
 'Sanjeev -    We need counterparty to counterparty deals moved to bankruptcy with the following book names:   FT-Can-Gone FT-Cand-Termin/or Term   On the ENA side, we need this moved to Bankruptcy.\nIf you need anymore information, please give me a call.\nThanks\n',
 'Good morning to you.\nSonny P. said they were in Houston this  weekend because Stan/Staci had moved into a new house.\nI told him so did  you.\nHe sent this reply.\nHope you have a good day and have a  happy Thanksgiving tomorrow.\nI love you!\nYo Mama.\nYes, you have to make  reservations when you go to Huntsville State Park.....its a very nice  place.....we are staying here Thanksgivning...well, we are having a Hardee  family reunion at the civic center in Poynor....Patti and family are here  now....Stan moved near Beltway 8 and I10......in the Spring Branch Memorial  school district......off Gessner.,,.12330 Old Oaks St.  You take the Toll  Road Beltway 8 to the west and get off on I10 and and go towards the city and  stay on the feeder road about 1/2 mile and get off on Gessner...and go about 4  blocks to Old Oaks.\nSounds like its not too far from Jeff....they need to  give each other a holler...Stans work number is 713-228-6601 and home number  713-467-6754.\nYou might want to forward this to Jeff....if you do...then    HI JEFF...bet you could not hit one as far as you did in Big Sandy  that time...hahahhaa\n',
 'Louise -  I spoke with Dave last night and he would like to propose the following changes.\nStephanie Sever\t\tfrom $6,500\tto $7,000\t Christopher Walker\tfrom $2,000\tto $4,000\t(Jennifer Denny highly recommends, contributions not reflected in mid-year rating) Fraisy George\t\tfrom $2,479\tto $3,000\t(used to be in call center, nature of job changed and has increased responsibility from mid-year) Adam Johnson \t\tfrom $2,000\tto $6,000\t(Jennifer Denny highly recommends, would take him over anyone else at his level, feels should be compensated for \t\t\t\t\t\t\this contributions)  Please let me know your thoughts.\nAmy\n',
 'Dear Colleagues,  We know you have many questions about your new benefits plan, payroll issues and other changes that will occur over the next few weeks.\nHuman Resources and Communications are preparing a thorough Q&A, which we will send to you tomorrow and will regularly update as more information is available.\nMeanwhile, please read the announcement below from Security about how you can obtain a new UBS Warburg access card that will allow you to enter our new office space after Friday.\nI am confident that you share my enthusiasm about our new opportunity.\nWe look forward to working along side each of you in the coming days.\nDavid Oxley Head, Human Resources\n',
 'The following reports have been waiting for your approval for more than 4 days.\nPlease review.\nOwner: Kevin M Presto Report Name: Stamford Trip Days In Mgr.\nQueue: 5\n',
 'Enron employees not participating in contract parking are eligible to receive Metro Bus Passes or Woodlands Express Passes.\nYou may pick up a bus pass from the Parking & Transportation Desk, on Level 3 of the Enron Building, from 8:30 AM to 4:30 PM.\nAll Metro passes offered through the Enron Parking & Transportation desk will be the Metro 30 Day Zone Pass.\nWhen you use a 30-day zone pass, bus service is divided into four zones w/ unlimited rides.\nThe zone pass is time activated, which means that it will not become active until the first time it is used and will not expire until 30 days after it was used for the first time.\nNew passes will be available to Enron employees upon expiration of the 30 day time period.\nEach zone does have a different fare values based on the distance the bus travels.\nThis is important to any buser who wants to transfer to or travel in a higher-cost zone than the zone pass they have, in this case the difference must be paid in cash.\nIf they are traveling in a lower cost zone, then there is no extra cost.\nParking & Transportation Desk 3-7060\n',
 "i'm sorry if i am not being understanding about this situation, but i if you  really look back at the last 5 jobs you've had, i think i have been more than  understanding about letting you do whatever you wanted to do.\nit really  hurts me that your pride in this situation is more important to you than  spending time with your pregnant wife and your daughter.\ni can't talk to you  about this anymore if you are unwilling to understand my point of view.\nonce  again, if the situation were different, i would tell you to do whatever you  wanted.\nbut, this time it's different and i hope you can see that.\ni love  you!\ntori\n",
 'i need to send jennifer a shower invitation and i have your address but i  lost the zip code - duh.\ncan you forward me your zip code?\n?\n',
 "eSource Presents Lexis-Nexis Training  Basic  Lexis-Nexis Basic is geared to the novice or prospective user.\nYou will learn the basics of getting around Nexis.com.\nWe will talk about news and company information available on Lexis-Nexis.\nAttend our Lexis-Nexis Basics Clinic:  \t\t\t\t November 6\t  1:00 - 2:00 PM \tEB572 \t   Due Diligence  This session will focus on the specific company, public records, and other sources available on Lexis-Nexis that help you find all possible aspects of a company's business and strengths or liabilities.\nAttend our Lexis-Nexis Due Diligence Clinic:   November 6\t  2:30 - 4:00 PM \tEB572   Seats fill up fast!\nTo reserve a seat, please call Stephanie E. Taylor at 5-7928.\nThe cost is $100.00 per person.\nNo-shows will be charged $200.00.\n* Please bring your Lexis-Nexis login ID and password.\nIf you don't have one, a guest ID will be provided.\n* * *   eSource presents free Lexis-Nexis Online Training   Using Placeware, an interactive web learning tool, you can participate in this training session from anywhere in the world.\nBasics  Lexis-Nexis Basic is geared to the novice or prospective user.\nYou will learn the basics of getting around Nexis.com and of the news and company information available on Lexis-Nexis.\nAttend our Lexis-Nexis Basics Online Clinic:   November 14\t10:00 AM Central Standard Time\n",
 "Attached is a contact list for Operations, giving home and cell numbers for the Head of Operations for EA, EGM, EIM, EES, EBS and EEL.\nAlso listed are the lead risk and settlements personnel for each business unit.\nMy numbers are listed as well, so feel to call me this weekend if needed.\nMore detailed contact lists for gas risk, power risk and settlements have been sent to Geoff Storey, as requested by Louise and John.\nThe IT Help desk (x31411) will be running as usual 24 hours a day.\nThe Help Desk has appropriate contact numbers for DBA's for all operating systems.\nIf system problems are encountered, please call the Help Desk.\nIf potential system problems are not resolved promptly, you can also contact Jenny Rub, VP of IT Infrastructure at 713-851-5456 (cell phone),  281-463-4421(home phone) or  877-345-3812  (pager).\n",
 'TD Waterhouse is now accepting Conditional Offers to purchase shares of Anthem, Inc., which is expected to price on 10/29/2001.\nTo read the preliminary prospectus filed with the SEC and place a Conditional Offer, follow these steps: - Login to your account - Click on Trading > IPO Center > IPO Offerings  In the list of Current Offerings, select the offering you want and then click on the "Continue" button.\nImportant Information - Reaffirming Your Conditional Offer  Once the registration statement is declared effective by the SEC, we will contact you via e-mail to notify you of the effectiveness of the registration statement and the price as determined by the managing underwriter.\nThis normally occurs on the day prior to the first day of trading.\nIf you still wish to participate, you will be required to respond to us by 3:00 am ET of the following business day to reaffirm your previously submitted Conditional Offer.\nPlease note that the e-mail notification will likely be sent after the market closes.\nPlease ensure that you have provided an e-mail address that you are able to access after that time.\nYou may change your e-mail address at anytime via the "Update E-mail" function within the IPO Center.\nIf it is not possible to check your e-mail after market hours, you may reaffirm your Conditional Offer following effectiveness by going to the "IPO Order Status" within the IPO Center, choosing the Conditional Offer you want to reaffirm, and clicking "Reaffirm Conditional Offer".\nIf you fail to reaffirm your Conditional Offer within the specified period, your Conditional Offer will automatically be cancelled.\nConditional Offers are accepted once reaffirmed, at the offering price, determined by the managing underwriter after the registration statement becomes effective.\nPlease note that reaffirming a Conditional Offer does not guarantee an allocation of shares.\nThank you,\n',
 'EXECUTIVE SUMMARY Senator Keeley Spearheads a New "Plan B" State to Offer Little Aid in PG&E Bankruptcy  Keeley\'s Collective "Plan B" Sources report that additional details for the Plan B have just been ironed=  out on the Assembly side.\nThe Assembly is working to announce a plan "as = soon as possible"; this announcement could come this afternoon.\nIf it is n= ot this afternoon, it will be later this week.\nSources Report the Republi= cans were working with Keeley, but then felt shut out of the process, so th= ey developed a plan of their own (a lightly publicized point last week).\nH= owever, sources believe that the Plan B is very likely to have enough Repub= lican support to pass the Assembly.\nThe Senate will likely be a much tough= er fight, but opposition to the plan remains pessimistic that they will be = able to stop it.\nThe Senate appears likely to broaden the base of people w= ho would have to pay the dedicated rate component, which will be unpopular.=   Borrowing from elements of the Joe Nation and Florez "Plan B\'s," Keeley\'s=  new plan is said to: Set up a dedicated rate component for SoCal to deal with part of their unde= rcollect.\nThis dedicated rate component would apply more to "high-end cust= omers."\nWhere the line would be drawn between who would pay and who would = not is still subject to negotiation.\nThe size of the dedicated rate compon= ent is also subject to negotiation.\nSoCal has suggested $3M for 10 to 12 y= ears.\nNote, sources report that at this time, a dedicated rate component f= or SoCal to pay for power going forward is NOT included in the Plan B that = will be announced.\nThe Assembly is not certain whether this additional ded= icated rate component will be needed.\nIf the bond issuance is enough to co= ver the cost of power purchases, no dedicated rate component for forward pu= rchases will be needed.\nBy 2003 and 2004, enough additional generation sho= uld be online that power prices should be low.\nTherefore, the key question=  becomes what will be the cost of power in 2002?\nIf the cost of power is h= igh, rates may have to be increased at that time for SoCal to continue oper= ating.\nThe state would make a secured loan (secured against the transmission asset= s) to SoCal to pay back the remainder of the undercollect.\nThis loan would=  be paid back by SoCal granting the government a lower rate of return on th= e transmission system for a period of 10 to 15 years.\nThis provides an inc= entive for SoCal to sell its transmission system to the state, since it wou= ld not be making as much money from the system.\nWere this to happen, the v= alue would be credited toward the loan.\nIn return, the state would receive the withdrawal with prejudice of the fil= ed rate doctrine case.\nAlso, SoCal would reduce the price of native power = generation.\nFinally, business customers (including those that would have t= o pay the dedicated rate component) would have the right to apply for direc= t access to power.\nIf this plan is passed, (better than 50/50 chance -as reported earlier) the=\n',
 'Please note that the company number for Enron Energia Industrial de Mexico B.V. has changed from 45B to 1627.\nThis is in order to accommodate the functional currency change from Eurodollars to USD.\nPlease share this information with other interested parties.\n',
 'I thought I would try to summarize our meeting this week and document a list  of agreed apon tasks.\n1.\nThe Unify system is on the brink of disaster and everyone agrees that we  have huge business risk if it blows up.\n',
 "Rick Buy  I'm expecting more details from Bill re.\nPerry Gas but I'm quite pissed about  this.\nI will deal with my traders when I have the details.\nOn the Retail  side, I think this is the problem in trying to set up a separate Wholesale  trading group in retail which is clearly happening.\nThis wouldn't of  happened it they were trading through us.\n",
 "PW line has a deficit of about $2.1 million.\nWe are on day 3.\nWe might have to fund the account around $2 million if it doesn't cure itself by  tomorrow.\nCan we use the Enron line again now that it is paid-off or would  you rather use one of the other lines?\nBA has approximately $5.9  million available, which has the most availability of all the lines.\nPlease advise.\n- Beau\n",
 "Ken,  We met when you were up at Sun Microsystems meeting with Scott and several CEOs.\nI talked with you during and after the event.\nI'm still working with the Governor's office to try to put in place a responsible panel for evaluating Calif energy policy.\nIts very frustrating dealing with these guys...with the lone exception of Freeman in the Governor's office who has been the most supportive, reasonable, and responsive of all the folks I've talked with.\nI met with Senators Bingaman and Reid last night and discussed with them accelerating the move from a fossil-fuel economy to a renewable/hydrogen powered economy.\nI, along with many experts in alternative energy, believe the time is now to start the transition.\nReid has been a long-time hydrogen proponent, and Bingaman was surprised on how economically it can be done to convert.\nIn addition, Gephardt is already very supportive of this move, as I'm sure Daschle will be as well (I had dinner with Daschle last night, but we didn't discuss this issue, but I will when I meet with him again in DC next week).\nThere's no question that it's the right move for the country.\nBut it's the antithesis of the current Bush energy plan.\nWill you join with me in supporting making this happen?\nIf so, I will call you to discuss next steps in formulating a responsible energy policy for America.\nP.S.\nYou may find the attached letter from NRDC president to Secretary Whitman of interest.\nSteve Kirsch CEO Propel    - WhitmanLetter.5.22.01.doc\n",
 'Dear members and prospective members, It gives the Indo-American Chamber great pleasure to announce that Dr. John Lienhard as our February speaker.\nDr. Lienhard is a M D Anderson Professor of  Mechanical Engineering and History at the Unv.\nOf Houston where he has taught since 1980.\nHe is the author and voice of more than 1,400 episodes of The Engines of Our Ingenuity, a daily public radio series about machines and the people who created them.\nA popular speaker , Dr. Lienhard averages 50 speaking engagements in a year.\nYou can view  Dr. Lienhard\'s profile and home page clicking on the links below.Dr.\nLienhard Bio Dr. Lienhard\'s Radio program homepage   Event Topic: Innovation, A Dangerous Guest---- "Do you really want creative   people in your organization"\n',
 'Dear Fam,  Sally informed me today that John Brindle, a former head of Enron security, is now involved and will be handling all airline reservations (through Gordon Bethune at Continental airlines), ground transportation and hotel reservations (Four Seasons or Park Hyatt) for us.\nHe has suggested that we use "assumed" names for all reservations being made.\nJohn feels strongly that there could be a risk and a small unit will attract less attention and be easier to maneuver,  also it will allow for less media coverage...which is a good thing.\nApparently, he will be giving a detailed report to Rosalee on Friday of this week.\nI talked with Ken about it tonight and as much as we would love to have you there for moral support we do not want to do anything that would put you in harm\'s way or create a media spectacle for him.\nSo, unfortunately, the prudent thing to do is have you stay in Houston and pray for him in your safe environments.\nFor your information, our plan is to go up to DC on Thursday, January 31 and back on Tuesday morning, February 5.\nKen gives his testimony at the SEC hearings on Monday morning, February 4, and I am told that it will go on until late in the day.\nThese hearings are on TV and transcripts can be read on the internet.\nI will try and get all of that info to you prior to 2/4.\nThe following is also from Sally:  "John has asked if the kids would have an interest in meeting with him for 20-30 minutes to hear his suggestions for ways in which to best help the situation, and ideas on keeping their families safe on a daily basis?\nI expect this would need to be done during the weekday.\nI would also suggest it be held maybe at the ROCC 12th floor conference rm.\nor at the Huntingdon and for the kids and spouses only, no children as it would only distract from his limited time.\nThen, if anyone feels the need to interact with him on a more detailed basis they could arrange it with him, at their expense.\nHe did express concerns that due to KLL\'s high profile, kidnapping is not out of the realm of possibility but he has numerous suggestions for circumventing this."\nLet us know your thoughts.\nLove, Mom/Linda\n',
 "Please open the attached file to read the complete text of the following items:  07:41AM EDT  5-JUN-01 SG COWEN SECURITIES INC. (RICHARD CHU) HWP HWP/EXPECT CONSTRUCTIVE ANALYST MEETING TOMORROW; MAINTAIN BUY  09:04AM EDT  5-JUN-01 THOMAS WEISEL PARTNERS LLC (ERIC M. ROSS) INTC (TWP): 2QFY01 (JUNE) GUIDANCE LIKELY TO BE LOWERED  08:58AM EDT  5-JUN-01 PRUDENTIAL SECURITIES (K.ALEXY) AAPL CPQ CMP PREVIEW MAY MONTHLY MONITOR REPORT  08:53AM EDT  5-JUN-01 BEAR STEARNS (J. NEFF/HAND/BOBBA) HWP GTW DELL: STORAGE CONFERENCE CALL WITH DELL  09:46AM EDT  5-JUN-01 J.P. MORGAN (WILLIAM A. LEWIS) CPQ EMC BRCD FIBRE CHANNEL STEPS FORWARD WITH INTEROPERABILITY   <<6.05.01 Analyst Reports.doc>> The analyst reports provided are reports prepared by independent analysts who monitor and track Compaq's performance.\nThese reports are not prepared by or at the direction of Compaq and as a result, Compaq is not endorsing or verifying the information contained in these reports or endorsing any of these analysts.\nThese reports are being provided solely for business reasons and as a result, do not distribute these reports to other individuals outside of Compaq.\nIf other individuals are interested in receiving the reports provided herein, please contact Elizabeth Davis in Compaq's Investor Relations Department at elizabeth.davis@compaq.com.\n",
 "Ken, this is Pat Koenig.\nI just wanted to send you a quick email and let you know you have my admiration and support ( I know it isn't much).\nYou have made Enron a great company, and no matter how bad the press gets I will always be proud to say my husband works for Enron and he works for the best, Ken Lay.\nPat\n",
 'Dear Mr. Lay,  These are difficult times for Enron.\nI know that you, members of your Management Team and the Board of Directors are working diligently to turn the tide that has resulted in the significant deterioration of our stock price.\nIn this regard, I request that you and the Board of Directors give consideration to extending for one year all options that your employees are currently vested in and are coming to the end of their term within the next 12 months, commencing November 1, 2001.\nMany of us do not have the opportunity to receive the numbers of options that senior management has, and that is expected.\nBut, this so sudden drop in stock price has placed many if not all current options underwater.\nA decision by the Board of Directors, in favor of this type of supportive action would go a long way for your employees morale and commitment to the company.\nThank you,  Doug\n',
 'A new Kudlow Commentary has been published on Kudlow.com.\nAs a subscriber, you may click the hyperlink below, login, and view the latest commentary.\nAOL Users please note, you may need to copy and paste the hyperlink into your web browser.\nThank You,\n',
 'Mr. Oxley, as head of Human Resources for Enron North America, I would really appreciate your assistance.\nI have met with various HR reps during my nearly eight-year tenure with Enron to understand the qualifications required for an administrative assistant to move into an exempt role.\nFrom those meetings, however, I received severely conflicting information and left with a feeling that there are no rules, or that the rules are made and changed from person to person.\nThat being said, does HR follow a set of rules that are standard for all non-exempt promotions to exempt roles?\nIn addition, are qualifications to meet those standards changed with each individual?\nYour assistance would be greatly appreciated.\nThank you.\nLa Donna x34379\n',
 'Dear Kenneth  We are currently out of stock of the Adidas style #671521 in size 10.5.\nPlease contact us to have us try to special order of cancel the order for you.\nSpecial ordering takes an extra 10-15 days.\nOur number is 1-800-961-3030 ext 371.\nThe number you gave is a fax number 713-953-6464 if you can furnish us with another number that would be great.\nThaqnk you  Sandra\n',
 'Ken,  I feel terrible in writing this email to inform you that I am leaving Enron.\nThe timing of my departure is purely coincidental to the timing of the recent events.\nIt has been a special and rewarding privilege to work at Enron over the past three and a half years.\nThe integrity and high purpose you stand for is a personal inspiration to me.\nSeeing your leadership first-hand has been a real treat.\nReceiving the Chairman\'s Award last year was an incredible honor.\nIt is difficult for me to feel truly deserving of it because of the sheer numbers of amazingly dedicated, yet unrecognized heroes I have met at Enron.\nI have the greatest admiration of them and draw my inspiration from them.\nOne regret in leaving is that there will be those at Enron who will use my departure as more negative fodder to taint the company image.\nI wouldn\'t ever wish that on you, especially in light of the recent challenges you are experiencing.\nSo I apologize if that does come to pass.\nOne factor in my departure has been my disappointment with personnel abuses I\'ve observed with EES\' origination management.\nThere is a general feeling  of despair because the management chain looks the other way and the concept  of an "open door" is political suicide.\nH.R.\nis as much at fault in my  opinion because they side with management as opposed to taking an objective  view and judgement of the abuses.\nMy words and credibility may not carry  any weight as I too have been victimized by the character assassination  that is all too common at EES.\nThough my emotions run high when I think about the injustices to good employees  (and lost potential benefit to Enron), I leave with no bad feelings toward the company and am proud to have been a part of Enron.\nThe shift in EES\' business model had resulted in my taking on a new role this past spring.\nBeing based outside of Houston (in the Chicago area), my career opportunities are limited.\nAnd as much as I tried, I was feeling stale and unfulfilled in this new role and decided that it would be better for me to move on.\nKen, I believe in you and wish you success and redemption through this difficult  time.\nI wish that I could have done more.\nIf I can ever help, I hope that you won\'t hesitate to ask.\nThank you again.\nRespectfully,\n',
 'Today we released additional information about our related party and off-balance sheet transactions.\nWe have made this information available both on our website and in a Form 8-K filing with the Securities and Exchange Commission (SEC).\nThe information provides further details about:\n',
 "Dear Ken:       Chad asked me to respond to your letter since I manage our relationship with RFF.\nWe have had a very good relationship with RFF over many years and are strongly supportive of their work.\nChad has asked me to continue as the primary interface with RFF and Paul Portney.\nPlease convey this message to Lesli Creedon, RFF's Director of Development.\nWith best reagrds,\n",
 "Rosalee,  Attached are the talking points I've prepared as well as Chairman Greenspan's bio, should Ken wish to review it.\nKaren Denne and I will wait outside the Alice Pratt Brown building to be sure Ken gets in without any problem.\nAs I mentioned on our call earlier, I have spoken to W.O.\nKing and informed him that Linda and Liz would be attending.\nPlease let me know if there is anything else I can do.\nTalking Points for Ken Lay:    Chairman Greenspan's Bio:\n",
 "Dear Mr. Lay, I just want to send you a note to say thank you for all you've done for Enron.\nI've been with Enron for 15 years (straight out of college).\nI may have been impacted financially with what is currently going on but I certainly don't blame you nor anyone for that matter.\nIt just is.\nThanks to Enron, I have had a very good job for the last 15 years.\nThis might be the only company I've known but I do have friends that work at other company and this I know.\nNot all companies give employees bonuses, stock options, ESOP, upward mobility, matching retirement funds, cash accounts, competitive salary, challenging work environment, on-site health care, on-site workout place, subsidized cafeteria, matching gift giving, involvement in charitable work and community, and many other good things.\nI know that you and Enron have always care for the employees and for the community.\n",
 "Update on Mail Distribution:  On Campus Mail Distribution Resumes  On-campus mail distribution resumed this afternoon (11/14/01).\nInitial distribution may be slow but is expected to pick up as mail that had been stored in a secured campus facility is processed.\nPending the reopening of the University's Main Post Office in the Administration Building, the mail sorting and distribution activity is taking place at an alternate site in the University Service Center.\nUniversity facilities that receive mail directly from the United States Post Office will continue to receive and process mail.\nThe test results were negative for the East (Divinity) Campus mail facility and mail distribution for that Campus resumed this afternoon.\nThe West (Law) Campus is processing mail from an alternate location while they await the results of tests taken at their main processing location.\nWith the exception of Meridian Hill Hall, for which results are pending, the off-campus dormitories also received negative test results and this afternoon reactivated distribution from their usual locations.\n# # #\n",
 'Dear Mr. Lay,  Just wanted to drop you a note to find out if Enron Corp. is interested in forming a collaboration with our company.\nGlobalVision International, Inc. is a software and Internet localization and translation specialist.\nWe partner with our clients to enable them reach their global markets.\nWe are staffed and equipped to convert your products and Internet pages from English to Japanese, French, German, Spanish, Italian, Chinese, Korean, Russian, Arabic and other languages.\nIf there is interest on your part, please do not hesitate to forward this message, or to contact us as listed below.\nSincerely,\n',
 "FOR IMMEDIATE RELEASE                  NEWPOWER LAUNCHES ONLINE ENERGY SAVING CENTER   Residential Consumers And Small Businesses Can Learn How to Reduce Energy       Usage And Costs; Purchase Full Line Of Energy Efficient Products    PURCHASE, NY, October 29, 2001 ?\nThe New Power Company, the first national  residential and small business energy provider, today announced that it has  launched the Energy Saving Center, a group of online tools to help  residential consumers and small commercial businesses reduce energy usage  and costs.\nThe Energy Saving Center can be found on www.newpower.com    Key elements of the NewPower Energy Saving Center are the Home and Business  Analyzers.\nThese on-line audit tools, which are free to all  www.newpower.com visitors, provide a top-to-bottom analysis of energy  usage, and offer specific recommendations on behavior modification and  products that can save energy.\nThe products can then be purchased through  the Energy Efficient Products On-line Store    The Home Analyzer allows residential consumers to learn how much money  people in homes similar to theirs spend on energy.\nThey can also uncover  specific energy saving opportunities in their own homes.\nUsing the  Business Analyzer, small businesses can choose to analyze one facility or  multiple sites.\nThe tool examines each aspect of a business' energy use  (including which appliances or systems use the most energy), and provides  customized analyses, recommendations, and a means to track their progress.\nThe NewPower Energy Saving Center is just one way that energy restructuring  is leading to technological innovation and efficiency.\nCompetition among  energy marketers ?\nlike NewPower ?\nencourages cost savings and new and  better ways to consume electricity and natural gas.\n# # #  About NewPower Holdings, Inc. NewPower Holdings, Inc. (NYSE: NPW), through its subsidiary, The New Power Company, www.newpower.com, is the first national provider of electricity and natural gas to residential and small commercial customers in the United States.\nThe Company offers consumers in restructured retail energy markets competitive energy prices, pricing choices, improved customer service and other innovative products, services and incentives.\nCautionary Statement This press release contains certain forward-looking statements within the meaning of the Private Securities Litigation Reform Act of 1995, Section 27A of the Securities Act of 1933, and Section 21E of the Securities Exchange Act of 1934.\nThese statements involve risks and uncertainties and may differ materially from actual future events or results.\nAlthough we believe that our expectations are based on reasonable assumptions, we can give no assurance that our goals will be achieved.\nThe Company undertakes no obligation to publicly release any revisions to these forward-looking statements to reflect events or circumstances after the date hereof or to reflect the occurrence of unanticipated events.\nImportant factors that could cause actual results to differ from estimates or projections contained in the forward-looking statements include our limited operating history; delays or changes in the rules for the restructuring of the electric and natural gas markets; our ability to attract and retain customers; our ability to manage our energy requirements and sell energy at a sufficient margin given the volatility in prices for electricity and natural gas; the effect of commodity volatility on collateral requirements and liquidity; our dependence on third parties to provide critical functions to us and to our customers; and conditions of the capital markets affecting the availability of capital.\nReaders are referred to the Company's Annual Report on Form 10-K for the year ending December 31, 2000 and our Registration Statement on Form S-1 (No.\n333.41412) on file with the Securities and Exchange Commission for a discussion of factors that could cause actual results to differ materially from these forward-looking statements.\n",
 'Trade press, recruiting firms and others recently have made numerous calls to Enron employees seeking information about the company, its employees and other matters.\nIn some cases, these callers have used false identities, as in, "I\'m from the SEC and I need you to provide me with?"\nIf you receive a call from someone identifying themselves as part of a government organization, please refer the caller to the legal department.\nPlease refer calls from the trade press and other media inquiries to the Public Relations group.\nAnd otherwise, please treat Enron information as confidential.\nThank you.\n',
 "Jeff McMahon has proposed that Ben Glisan is the most appropriate person to provide brief summaries to the BoD on Chewco, Whitewing and Marlin, if Ken would like these topics presented to the BoD.\nBoth Jeff and Ben will be standing by for today's meeting in case they are needed.\nJoe Dilg will attend the full meeting, most likely via teleconference.\nFollowing is a revised note to Ken.\nThanks.\n",
 'Dear Kenneth ,  I would like to inform you of an exceptional candidate ("AJM") who is seeking a mid-to-executive level Marketing/Business Development opportunity.\nBelow is a brief profile of an individual who has demonstrated upward mobility in his career path and loyalty as an employee.\nHis solid experience and education credentials are stellar.\nProfessional Summary: Harvard MBA with over 15 years of corporate strategy, marketing, business development, and finance experience in the information technology industry with recent management positions at Microsoft Corporation and AT Kearney.v  Executive Bio: Prior to joining a startup, AJM was a senior executive at Microsoft Corporation and managed the development and marketing of Microsoft\'s Biz Talk Server 2000 product, an XML integration server.\nIn addition, he marketed the BackOffice Server product with more than $1 billion in sales.\nPrior to working at Microsoft, AJM worked as a management consultant with A.T. Kearney.\nAt Kearney, he advised global Fortune 500 companies on strategic and management issues.\nHis clients included financial institutions, high technology companies and IT service providers.\nFunctionally, he has been involved in developing business strategy, market entry plans, new product development, sales force effectiveness, and re-engineering companies.\nIndustry Disciplines: \tIndustries Experience -Information Technology; the Internet (Enterprise Applications & Infrastructure); Financial\n',
 "I can only imagine the extreme pressure and stress you are under right now.\nI just want to say that we have every confidence in you  and the management team you are forming.\nWE will get through this, just as our country will get through the international situation.\nEveryone needs a word of encouragement every now and then; I wanted to say we are behind you, respect you and your leadership.\nWe are trying to do our part in staying focused on our responsibilities, and in some small way contribute to correcting Enron's reversal of fortunes.\nThanks, Ken, for your dedication and inspiration.\n",
 'MV_Logo_AdizesToPrime_smaller.jpgAdizes_logo_smaller.jpg=09   =09    In this uncertain world, how do we set priorities?\nThe Wall Street Jo= urnal posed this issue in its September 25th edition:    "Managing Employee= s who are both traumatized and experiencing a sea  change in their attitude= s toward their work poses immediate and long-term challenges for bosses.\nIn=  the next few weeks, bosses must ask themselves what level of performance t= hey can expect of employees who have been deeply shaken by the Sept. 11 ter= rorist attacks.\nAnd over the coming months, they must figure out how to fos= ter both teamwork and commitment among those they supervise -- qualities th=\n',
 'POWER BRIEFS FRIDAY, MAY 25, 2001    NEWPOWER IN THE NEWS  -  =20 PULLING PLUG ON TXU IS A BRIGHT IDEA - [Fort Worth Star-Telegram, May 17.]\n=  NewPower, 43 percent owned by the Houston energy powerhouse Enron, is the = price leader [for householders] who keep the home lights fully ablaze.\nReli= ant Energy, corporate kin to Houston Power and Light, is the price leader f= or frugal homeowners?New Power offers power users a choice of locking in po= wer rates at 8.3 cents for two years subject to a $7.50 monthly service fee= , or accepting a guarantee that their power bills will always be less than = TXU\'s comparable bite for the same period.\nFor the moment, the low-price gu= arantee plan sports the lowest rates?\n"We\'re trying to figure out what custo= mers want," says Gael Doar, a NewPower spokeswoman.\n"The whole thing about = energy restructuring is that you have a choice."\nTo date, the PUC has recru= ited 17 percent of the 90,000 volunteers it hopes will become TXU exes this=  summer.\nOne result is sweeter deals.\nNew Power will toss in free electri= city this December and next to folks who sign up by May 31.\nOn Wednesday, =\n',
 "Kenneth,  I'm an associate in EES, and I have been working in Enron for two an a half years.\nFirst I would like apologies if this causes any inconveniences, but I am writing this email to you because I'm quite concern about the latest news about the partnership/CFO  that came out in the last week or so.\nMe and many of my fellow A/A co-workers as well as other employees do not know what is going on, and speaking for myself, if it's possible for you to let me and everyone else know what the situation is and how are you taking measures to reassure confidence in the marketplace I would greatly appreciate your time.\nI assure you that many of my fellow A/A co-workers have confidence in the future of Enron, and I expect that greener pastures will be in front of us very soon.\nMany thanks in advance, Carlos Vicens #35643\n",
 'Attached are the Friday peer group reports.\nDO NOT UPDATE LINKS WHEN THE FILE IS OPENED!\nPlease call if you have any questions.\nInvestor Relations\n',
 'Mom & Ken,   The Astros playoff tickets were much appreciated.\nI had a great time  even though the outcome of the two games was not as we would have liked.\nHeather & I took her Dad and Josh (two baseball die-hards) to one of the  games and I took some friends to the other.\nEveryone was thrilled to be  able to go and extremely thankful for the tickets.\nThanks again for your  generousity and more importantly, not objecting to me being out of the  office for a few hours to attend the game.\n',
 "Ken: DELIGHTED to read the several good news developments regarding Enron's success in lining up buyers for various properties.\nI could see your fine hand in directing the success and anticipated success.\nBest wishes.\nJoe\n",
 "KUDLOW'S TAKE by Lawrence Kudlow   DECLARING WAR ON RECESSION Why isn't the administration endorsing bold measures?\nOctober 1, 2001 8:00 a.m.   Crucial to winning the global war against terrorism is a bold plan to wage war on the domestic recession.\nBut Washington has no such plan.\nRespected policymakers look timid, cautious, and out of touch with the reality of a declining economy.\nVeteran graybeards advise Congress to do nothing, seemingly deaf to an economic call to arms.\nThe latest unemployment claims report ratcheted up nearly 60,000 to 450,000 - a nine-year high.\nThis implies a huge drop in jobs and a big jump in unemployment is on the way.\nA just published and miserable durable-goods report says the technology sector is evaporating in cyberspace.\nOver the three months ending in August, a composite high-tech index for shipments dropped 50.1% at an annual rate.\nTechnology was the biggest contributor to the economic boom of the 1990s.\nNow it is the biggest drag.\nEven consumers are suffering from terrorist aftershock as weekly chain-store sales are turning negative.\nSomething has got to be done, but Washington isn't doing it.\nThe Bush administration's economic officials have been ineffectual.\nThere is no action-plan script, no talking points, no communication strategy.\nIn short, there's no leadership on the domestic economic front.\nThe administration is performing brilliantly in the early stages of the war against terrorism.\nBut thus far, it has shown no similar instincts in the war against domestic recession.\nIf the domestic slump is left unattended, the nation will eventually become demoralized.\nWithout economic vitality at home, it will be all the more difficult to maintain our edge overseas.\nRising unemployment drains the spirit, but we need exactly that spirit to conquer our enemies.\nThe economy needs a jolt.\nIt needs risk-taking.\nBut policymakers seem unwilling to take risks.\nRobert Rubin and Alan Greenspan - who keep telling us that too much stimulus will cause inflation - are providing more status-quo thinking at the very moment we need leaders who can size up the current situation and then think outside the box to provide solutions.\nMr. Rubin's arguments about budget surpluses and long-term bond rates are red herrings at best.\nActually, as the recession-driven federal budget moves into deficit, Treasury market interest rates are dropping to 40-year lows, undercutting Rubin's entire argument on the need to maintain budget surpluses at any economic cost.\nHe has never understood that growth produces surpluses, rather than the other way around.\nThe former Clinton Treasury man tells us that demand-side consumer tax rebates are okay while supply-side tax cuts on successful high-end earners and capital investments are not.\nGo figure.\nThis is not economic analysis.\nIt's a plain vanilla, liberal-redistribution agenda.\nMr. Greenspan, meanwhile, says that capital-gains tax cuts are not the best way to deal with the economy's short-term problem.\nYet it is exactly the deflation of capital asset values through the stock-market decline and the deepening slump in business profits that cries out for new incentive rewards for capital investment.\nInstead of pompous proclamations, let's do an historical scrub of the after-effects of cap-gains relief.\nIf we do, it will show that faster economic growth, rising stock markets, and stronger budget revenues always follow lower tax-rates on capital investment.\nJack Kemp and Sen. Zell Miller have it exactly right in their editorial proposal to slash cap gains, accelerate the depreciation of investment in plant, equipment, and technology, and make the phased-in personal tax-rate reductions effective immediately.\nTheir monetary view that the Federal Reserve should abandon its interest rate target in favor of larger emergency cash injections is also correct.\nSo, why aren't administration economists endorsing these bold measures?\nWhy aren't they making the case that it's business that creates jobs, and that business desperately needs a fresh capital infusion?\nNo amount of consumer tax rebates will stop the unemployment rate from rising if capital-starved and profit-losing businesses don't get immediate relief from a permanent reduction of tax-rates.\nBush policymakers should also make the case that the twin crises of war and recession will require a temporary budget deficit of roughly 1.5% of GDP ($150 billion) to finance tax-cuts, defense, and infrastructure-rebuilding policies that are necessary to re-ignite economic growth.\nThe public is four-square behind the president in the global war against terrorism.\nIt will also stand four-square behind the president in the war against recession.\nIndeed, the public knows that a strong domestic economy is vital to the war effort.\nSince President Bush's spectacular speech rallying the nation for the global war against terrorism, the Dow Jones stock index has appreciated 7%, or roughly 600 points.\nIf the president rallies the nation with a war plan to end recession, the market will rise exponentially, signaling economic recovery and the revival of the American spirit.\n",
 'Dear Ken, I apologize for bothering you with this kind of a nuisance, however I hope  you can help my friend.\nI called you a year ago about  problems dealing with the Houston Pipeline group.\nI am appealing to you again.\nI was contacted to provide nitrogen gas for a  pipeline pigging project last year on a 20" line that goes south from Corpus  Christi.\nRusty Bellflower told me I was  going to provide the nitrogen and then after my group was mobilized on short  notice over a weekend, they cancelled - did not even call us, just never called  back.\nI spent a week on the project and my subcontractor was out his  mobilization cost, and after more than a year, they finally paid a part of our  cost.\nDuring the negotiation for the nitrogen set up, I  visited the pipeline site, and saw some oil on the ground.\nI mentioned to the  HPL rep Rusty Bellflower, that I had a biological product that is excellent for  eliminating oil.\nHe called in a big rush on a Friday afternoon and said for me  to hot shot 10 or so drums of the stuff to a site on the beach (10 pigs or  something) where they would put the chemical into the 20" pipeline.\nHe even gave  me a PO number (X000496) A week later he called and said they decided not to use  the chemical.\nI told him we were going to charge for restocking and the cost for  hot shot services.\nRusty said that if we charged them anything we  could be sure that we would never work for HPL or Enron again.\nThat is my experience with HPL.\nNow my friend Jay Pope with Coastline Resources is  also having trouble on his part of the pipeline work.\nNick Cocavessis of HPL  contacted Jay and asked Jay to bid the pigging job.\nA few things went wrong, but  most of them were a result of bad decisions on the part of the HPL personnel.\nWhy did they call a small outfit like Coastline in the first place?\nIt looks  like they called them so they could muscle them around at the end of the job.\nJay Pope has been able to reduce the balance due to the subcontractors to  $2,780,000.\nEnron is offering $2,550,000.\nEnron attorney (Andy  Edison) said "Tell Jay he\'ll just have to chiselanother $ 230,000.00 out  of the sub\'s"   I am a stockholder in Enron, but I do not see the  sense in beating up contractors.\nIs there anything you can do to get the old HPL  group to settle with Jay?\nThank you for looking at this.\n',
 "Hello everyone,  I am writing to confirm your participation in the RFF Council & Board of Directors meetings on Wednesday, October 10 and Thursday, October 11, respectively.\nIn light of the events of September 11 and subsequent travel difficulties, we thought we'd double check with our out-of-town Directors on their attendance.\nWe hope you are still able to join us.\nIf your plans have changed in any way, please let me know at your earliest convenience.\nWe look forward to seeing you!\nRegards,\n",
 "Ken - Michael will be talking with this reporter tomorrow but he'd be grateful if you could make 10 minutes to be our Board Voice for this important interview in the Wall Street Journal.\nI know you are only available today at 4:30 p.m. so i am waiting for a response.\nHere is the background on the interview.\nLet me know if you have any concerns or questions.\nThank you in advance.\n-- Grace Trent\n",
 "The Management Committee is invited to join the Enron Corp. Board of Directors on Tuesday, October 9th, for it's open Board session and lunch.\nAmong other agenda items, management briefings will be made for both Enron Americas and Enron Energy Services.\nPlease come to EB5001 at 8:45 a.m. on Oct. 9.\nA seated lunch will be held in the 50M dining room following the meeting.\nYour participation in important.\nPlease RSVP to Kelly Johnson at ext.\n36485 or via email at kelly.johnson@enron.com by Noon on October 2, 2001.\nThanks.\n",
 "Dear Subscriber: Attached in a PDF file is your 9/21 issue of The Desk.\nEnjoy.\nAnd while you're at it, trade on the ICE today.\nSee Page 1 for details.\nRegards,\n",
 "Media reports out of France indicate that explosions have just taken place at two chemical plants in the southern city of Tououse.\nThe main explosion reportedly took place at a plant that manufactures fuel for Arianespace, the European Space Agency's commercial arm.\nExplosions have also been reported at a plant owned by Groupe SNPE, which manufactures propellants and explosives.\nThe incidents are reported to have involved deaths at the scene.\nWe have yet to acquire independent confirmation of the explosions, or whether terrorism is suspected.\nWe are in touch with military and intelligence sources, and will provide updates.\n",
 "Enron Principal Investments (EPI), which was formed in the 2nd quarter, has completed its integration and the development of its new strategy.\nThis group will be responsible for identifying, closing, managing and exiting all non-E&P equity investments for Enron worldwide.\nKevin Garland will lead EPI, which includes Barbara Paige, Andrew Marsden, Kevin Kuykendall, Steven Sheldon, Michele Nezi Marvin and Mark Gandy.\nAdditionally, Dick Lydecker and the Special Asset Group will continue to report to Kevin.\nEPI will pursue investments related to Enron's core businesses, where Enron has a unique insight into the market, company or technology.\nInitially, this will be geographically focused in North America and Europe.\nThis group will rely heavily on the support and cooperation of the core business units to provide information and market insight.\nEPI may make investments in the form of venture capital, leverage buyouts, growth equity, or private equity in public companies.\nThe group will not make investments in seed stage companies, other funds, subsidiaries of larger corporations, or project equity.\nPlease join me in supporting the efforts of Enron Principal Investments.\n",
 "We learned today that the Court of Appeals for the Federal Circuit has modified its opinion of August 9, 2000 in which it found the 2003 Prozac patent invalid for double patenting.\nIn essence, the Court has again ruled that the patent is invalid for double patenting, but has used a different analysis to reach this conclusion.\nWe intend to seek legal review of today's decision.\nAlthough it is possible that the legal review process could delay Barr from entering the market on August 3, we continue to plan for Barr launching generic fluoxetine at that time.\n",
 "Thank you for indicating your preferences for personal follow-up calls to The Center's funds solicitation letter.\nUnfortunately, Ben Love's health precludes him from making any follow-up calls on this campaign.\nCould I ask each of you very busy gentlemen to commit to call 11 folks as follow-up to The Center's funds solicitation letter?\nI will compile the list and adjust any duplications and forward it again to each of you.\nPlease indicate your preferences on this form and return it to me by e-mail or by fax (or please feel free to call).\nThank you for your\n",
 "Just a note to check on all our beloveds on this horrible day.\nWe are glued   to the tv while we carry on our daily activities in Columbia.\nActually I   told John I hope they don't call in the WWII Submariners for active duty or   he is in trouble.\nActually there are very few of them left and I doubt this   war will be fought in the water.\nWe have had several calls this morning to inquire if we are o.k.\nYes we are   fine, except devastated about what is happening to the Country.\nOn a routine note, we have painters painting our garage, workers putting on   new siding at our rental house across the street, A furnace man putting in a   new energy efficient furnace also in the rental house.\nMost of these workers   are in good spirits..some mostly unaware of what is going on.\nThe furnace   man thought the answer to our problems was that everybody should carry more   guns.\nLife goes on at many different levels.\nStay safe all of you.\nStay off the planes and out of government buildings.\nLove Bonnie\n",
 "Mr. Lay-  With all that is going on, a quick note to let you know that you still have an employee who is confident something good will prevail and not all may be lost.\nThough I have only been with the company for almost 2 years, I personally feel you are doing all you can to salvage what is possible.\nYour reputation precedes you and the many years you spent building this company up.\nI feel deep down that you wouldn't have done anything to jeapordize your name despite what the media and finance markets read.\nResponsibility is to be shared.\nUnfortunately, you have been left to do the clean up.\nI do believe in my heart of hearts that once Jeff Skilling and Andy Fastow were in the positions they were, greed took over.\nUnfortunately, they took advantage of your position and possibly lost sight of dealings going on with the presumption that these men were of the utmost, outstanding character.\nPlease view this email as simply a boost to your morale and not anything more than to simply advise you of what possibly many employees feel but have yet to convey.\nThanks -\n",
 "Dear Ken,  I am a second year associate with RAC underwriting group.\nIn the past few days, I have been watching fellow staff packing their personal items in an anticipation of a massive layoff while some have commence a lawsuit against the company (perhaps understandably).\nI believe that we all owe it to you the leaders and the company to offer ideas and suggestions on how best to handle the situation no matter how stupid such ideas may sound.\nThe chance is that you have probably thought about and reject this idea, but I wonder how hopeless it will be to convince our creditors/debt holders to convert significant portion (if not all) of their debts holding to preferred equity (with option to convert to common).\nThis no doubt will improve our credit rating, save us cash on interest payment, and give us room to borrow.\nCreditors can be offer a better conversion ratio which will be defensible even in the event of bankruptcy as long as they make some cash infusion at the same time.\nI know that banks generally do not like the idea of equity investment, but given the present situation, that might not be a bad idea as long as it is in attempt to safeguard their investments.\nI know it is a tough time and you have a lot of better things to do rather than reading emails, however, I will be pitching my ideas to you from time to time (as long as I'm around).\nI have absolute confidence in the ability of our leaders and I have no doubt that you all are doing your utmost best to improve the situation.\nBest Regards,\n",
 'Hello Mr. Kenneth Lay,  I hope you don\'t mind an email from someone who is not very high in the decision-making level of Enron but I have such strong need  to share my thoughts and visions with you.\nFirst, I am so happy that we are not going to be acquired by Dynegy.\nEnron is an entity that deserves to live on.\nSecond, I have a vision that we (Enron) become a "Wiser & Quieter" Enron.\nI wish I can do something to help raise the "millions/billions" of dollars needed to survive in the shortrun, but all I can do is continue working on my project as I have done before....\nI personally do not mind the company shrinking to a very modest level in the next 12-48 months, selling off core businesses, and adopting a more cautious role to ALL spending.\nEven if we are layed-off we can always  come back in the future.\nThird, I just want to share an imagery of Enron being strong again in the future... Not with the previous ostentatiousness that prevailed in "the old days" but with  a newly developed sense of Wisdom and Maturity.\n...And there will be articles in the Wall Street Journal about how the Enron giant  has slowly but consistently lifted itself out of the gutter to become a  "Wiser & Quieter Enron".\nIf there is anything I can do to help you in this endeavor please let me know.\nI have no strong family obligations that prevent me from working long hours on some additional short-term projects to help out my Enron.\nBest Wishes!\n',
 "Mr. Lay,  It seems to have become fashionable to bash you and the other executives as things have become challenging at Enron.\nI just wanted to let you know that there are some people who still care about Enron and are still thankful for what you have done over the past 15 years.\nI have been completely distraught at the speed with which my coworkers have thrown in the towel and have essentially given up.\nI urge you to continue to fight for Enron.\nTrue, it may take another 15 years to get back to a leading company, but do not give up the fight.\nYou have made Enron a wonderful place to work and I know that Enron will survive.\nIt would be a tragedy if the innovative thinking made famous by Enron were to be discarded and corporate America returned to a status quo mentality.\nI have been informed that I am on the list of those to be laid off because I am in a non-core business, and I agree.\nI loved having the job, but desperate times call for desperate measures and I understand the need to focus.\nI am tired of my fellow coworkers quitting, complaining, and giving up.\nThere are plenty of people that will join you in the fight, I hope that you are able to weed out the quitters and get a group of people together who will fight for the Enron way of doing business.\nI applaud you for your accomplishments over the past 15 years in building an incredible company - a company that will survive, a company that will once again thrive, and a company that will prosper well into the future.\nGood luck and please don't give up, Zach Streight\n",
 'Ken,   Just a note to tell you that I hope you  and your family are weathering this storm.\nYou are a superior executive, a  friend to many and a philanthropist of the first order.\nWe are all  cheering for you.\nLucie\n',
 'Hank McKinnell of Pfizer has called Bill Esrey and advised him that Bill Gates has indicated a desire to become a member of The Business Council.\nAs you will recall, we had asked Bill once before but he declined.\nApparently he has had a change of heart.\nTechnically, Gates is not the Chairman of Microsoft.\nWe could invite him to join as a Graduate member or, in view of the special "circumstances" we could elect him as an Active member.\nIt is, obviously, an issue for the committee to decide.\nPlease let me know your thoughts as soon as possible.\nWe would like to extend our invitation this year in time for him to attend in February.\nPhil\n',
 "Dr. Lay,  Sir, I am almost positive that all avenues have been pursued to get Enron out of the hole we are in.\nHowever, I wanted to inquire if a reverse stock split (perhaps a 12 to 1 or 15 to 1) was a possible option.\nMy knoweledge in terms of Enron's debt and who we are indebted to is limited to what I have heard through the media, but as I see it, many creditors are at a great risk to lose billions of dollars.\nWould banks such as JP Morgan or Citigroup or others potentially affected such as Janus Funds or Lehman Brothers be willing to invest in equity rather than pump in more debt?\nFrom my understanding, we need an immediate $4 billion, and I think this may be a potential solution to get instant cash, and then we can turn our interests to building customer and investor confidence.\nI hope I am not wasting your time with this, but this is not the time for any of us involved with this company to remain silent.\nThank you for your time.\nSincerely,\n",
 "Dear Mr Lay,   I don't know if this will get to you personally or if someone filters your email, but I sincerely hope you get a chance to read this.\nI haven't been with Enron very long.\nI was hired in August and left my old job in Austin because I wanted the experience of working for a great company.\nI want you to know that I do not regret my decision to come here.\nI have never worked for a company that treats people with such dignity.\nIt amazes me that throughout all of this, I knew that you would do everything you could to make sure that the employees are okay.\nI can't say that I would have felt that way at any other job I have had.\nI know now that good companies are out there, and have no doubt that I will have a chance to experience that again.\nThe past few months must have been a nightmare for you.\nI cannot imagine what it feels like to build a company to greatness and watch it disintegrate because of the greed of a few.\nI'm sure that no words can console you, but I want you to know that most of the employees I have talked to do not blame you.\nWhatever happens next week, I want you to know that you are in my prayers.\nDebbie Riall\n",
 'I was told by you that our expenses were going to get paid ( as per your voice mail ).\nHowever, I was laid off from Enron Europe last Friday with another 800 people and we were told that our expenses were not going to be repaid by the company.\nCan you please explain the conflict between the two messages and let me know who will reimburse me.\nI am owed ?7000 from Enron    Chris\n',
 'Dear Mr. Lay,  I went home yesterday along with the other 3,999 employees who lost their jobs at Enron.\nEven though we had weeks to prepare for the worst, when the layoffs occurred, it really hit me hard.\nI cried a great deal, not only about the uncertainty of my future, but for the loss of relationships and friendships that I had established over the last five years I spent at Enron.\nThe hardest aspect of yesterday was saying "goodbye" to my friends and co-workers.\nWe\'ve all made a resolution to stay in touch and hopefully we will all pick up the pieces and carry on with our lives.\nI appreciate the efforts that were made to get us some severance, but as you are well aware, gave so much of ourselves to the company and lost so much in return..\nI\'m sure I\'m not alone in encouraging you and Enron management to continue to push for additional severance for those of us who lost our jobs.\nThis is a hard time to hit the street looking for a job, while Continential, Compaq and now Enron have downsized and the holidays are upon us.\nI know you have probably received this kind of message  many times in the last few weeks, but I hope you will continue to do the right thing for the employees.\nWe need the additional severance to be able to ensure food on the table and roofs over our heads until we can land on our feet after this free fall.\nI will never regret my 5 years at Enron.\nThey are an important part of my past.\nI appreciate your consideration of this request.\nSincerely,\n',
 'Dear Ken .\n.\n.\nI\'m truly heartbroken at the "perfect storm" which seems to have engulfed Enron.\nI\'m sure that last few months have been unbelievably stressful for you personally.\nYI wanted you to know that you can call on me, anytime, anywhere and under any circumstances if I can be of any help whatsoever--no compensation expected.\nIt is my hope that\n',
 "InJesus  POWERED\tSubscribe   UnSubscribe   Archive  \t   Group:\t Encouragement Ministry \t Title:\t Encouragement Email\t Author:\t \t  Encouragement Email  Hello Friend,  This is Dwayne Savaya.\nYour e-mail address was in my address book from a forward I received.\nI am starting an Inspirational and Encouragement Mailing list.\nWe all need some encouragement from time to time so that is why I am starting this new Ministry.\nIf you would like to be on it or know someone that would, just send an email to me with a SUBSCRIBE heading.\nThese will be stories and poems to encourage and inspire you in your daily walk with the Lord.\nThis is completely free and you can unsubscribe at anytime.\nThere is so much garbage being sent to us these days and I feel its time to start enjoying the email we receive and at least get something out of it like encouragement and inspiration.\nI don't want to clutter your E-mail box because I know you have a life and don't want to read mail all day long, so I will send you inspirational and encouraging stories and poems 2 to 3 times a week.\nI hope this will bring encouragement to many in this world full of trials and troubles.\nI believe we need to spend more time thinking of life in a positive way and not worry about every problem that comes our way and simple stories of encouragement can do alot to help us have a better outlook on life.\nAll Glory and Honor belongs to the Lord for the things He is doing.\nTo Subscribe send Email to --- Godswork@minister.com\n",
 'Endurance, Encouragement, Hope and Bring Home Good Fruit  I heard these words today in our Homily at church.\nThey seemed to jump out at me with the current situation we have all been faced with at Enron.\nYou have endured through a tremendous storm.\nAlthough your colleagues have disappeared leaving you to hold the bag, although you are at the center of intense criticism and accusations from investors, shareholders and employees and although the media has been brutal, you have endured.\nYour endurance, I believe, gives us the endurance, the encouragement and the hope that Enron will stabilize and be as strong as it ever was and with a much stronger foundation.\nTurmoil serves only to strengthen and bring a community together.\nIt was true on September 11th and it can be true at Enron.\nWe have been shaken, but we cannot give up.\nWith hope anything is possible.\nEnron has been my home for 20 years.\nI was there when we became Enron.\nThe last week was extremely difficult for all, "the straw that broke the camels back" for me was when I came in to workout on Friday morning at 5:30 a.m. and the Body Shop was closed.\nA note on the front door, "the Body Shop would be shutting down at 7:30 p.m. Thursday evening".\nI had been so strong up to this point.\nAfter I found a place to shower, I cried for two hours.\nA culmination of events finally broke me.\nI had been so optimistic.\nI am blessed "for the moment", I still have a job.\nI believe I would be blessed even if I didn\'t have a job.\nI have not given up.\nAs long as we have you and "you can endure", I know we will all make it through this storm.\nMay God Bless You  Nelda Shealy\n',
 'Will do, Ken.\nSo, I guess asking you to submit a piece for the End of Year = Issue is totally out of the question?\nIn any event, that request is below.=20 Regards,\n',
 'Industry Policy Task Force Kick-Off Meeting  Initiating Pro-Active Budget, Advocacy, Educational, and Corporate Energy Management Actions   Guest Speaker  Theo Johnson  Manager, Best Practices Program U.S. DOE, Office of Industrial Technologies  Task Force Scope, Issues and Strategies, and Mechanics  *\tEducation of media and policymakers on the benefits of industrial energy-efficiency policies *\tAdvocacy in support of restoration/increase in the Office of Industrial Technologies (OIT) budget *\tPromotion of best corporate energy management practices by industry   Thursday, May 24, 2001 9:45 a.m. - 1:30 p.m. (after Associates Breakfast)  2nd Floor Conference Room Dewey-Ballantine 1775 Pennsylvania Avenue, NW Washington, DC (2nd block south from Farragut West 18th Street Exit) (Enter on 18th Street)  If you have not already been contacted, please RSVP by May 22, 2001 to Natasha Ewell at (202) 530-2208 or newell@ase.org <mailto:newell@ase.org> The Task Force will start promptly at 9:45 a.m.\nLunch will be provided.\nConference call arrangements will also be available.\n',
 'Dear Ken:   When the timing is right, I would like to visit  with you (and Linda if appropriate) to discuss my idea of writing a scholarly  but lively history of Enron.\nMy working title is Ambition: The Rise and  Fall of Enron.\nPerhaps the "Fall" is premature, but it will be revised  accordingly if a stunning comeback is achieved.\nOne of the advantages of a  longer book is that the last chapter will be on industry developments a year or  two out to see there things really land with or without Enron.\nWhat I have in mind is a two-year research and  writing project--or longer.\nIt would develop your history through  Transco and then begin when John Duncan recruited you to Enron.\nThe  history, unlike the books we are likely to see in the next year,  would fully develop a number of energy, political economy, and corporate  culture themes.\nI will, of course, bring in all the recent and  forthcoming events as the climax, but the buildup is what will distinguish  the book.\nI anticipate it would be akin to "The Prize," but instead of the  "epic quest for oil, money, and power" the Enron story would be the "epic"  or "fatal" quest to create the world\'s leading company.\n',
 "This is the 3rd time that I have attempted to get an answer to the following question:  Has or was more than one petition been filed before the bankruptcy court for severance or financial relief for terminated employees.\nAt the time of the terminations, we were told in a group meeting that the $4500 requested and approved by the judge was the first of several petitions before the bankruptcy judge for severance on behalf of the terminated employees.\nTo date, we have had no response to indicate what, if any, other petitions are before the court.\nAn answer to this question will influence our actions on individual claims to the court as well as class action and individual lawsuits.\nWould someone within the organization please give us the courtesy of a response via e-mail or FAQ's?\nSince primarily lower level employees were affected by the terminations, it would seem that some goodwill and positive PR could be generated by attempting to show that you did not totally desert us in the process of lining your pockets.\n===== Sincerely,\n",
 'Ms. Peppers, I am very sorry, but I must once again reschedule the  appointment that you have with Mr. Lay.\nHe will be out of town the entire  week of September 26.\nThe first available time to reschedule is October 19, 2000.\nWould an  afternoon appointment work for you - about 2:00 p.m.?\nI look forward to hearing from you.\nRosalee\n',
 "As you may be aware, Enron Corp. is a member of the Official Unsecured Creditors' Committee appointed in the Pacific Gas and Electric Company bankruptcy case.\nMichael Tribolet with the Risk Assessment and Control Group is Enron's designated representative on the committee and he is being assisted by Lisa Mellencamp in the Enron North America Corp. legal group.\nPlease be advised that they will be restricted from disclosing certain of the information that they receive.\nAttached are Ethical Wall Procedures regarding confidential information that Enron may receive as a member of the committee.\nIt is important that you read the procedures promptly, print the Employee Certification attached and sign and return the Employee Certification to the Compliance Department as directed.\n",
 'How is the rains and flooding down there?\nWill you have  problem getting out of Houston tomorrow?\nWe will try to give you a call  tonight.\nDad\n',
 'The SuperHotOffers.com Newsletter has moved!!\nIn an effort to provide our subscribers with the best offers possible  we have decided to move our newsletters to the best possible service we  could find.\nThere were just too many times we would find ourselves  receiving mail from our subscribers saying that they had not received  their newsletter or were having difficulties unsubscribing.\nAs our  subscribers are our most valued asset we had to think of you first.\nOur transfer has been a smooth one and we look forward to delivering  the valuable offers and savings we always have, but this time without  the hassle!\nNow we realize that maybe you may not be interested in receiving our  newsletter any longer.\nIf that is the case, simply click the below  link and well make sure you are taken off of our list.\nIts that easy!Please Remove Me  While we hate to see you go, we also value your perception of us.\nOne  of the reasons we have moved are the easy unsubscribe options available  with this service.\nOur desire is to have the cleanest email newsletter  in the industry and if you no longer want to receive our newsletter we  respect your choice.\nThank you for all of your support and we look forward to bringing you only the best special offers and fantastic values we can in 2002!\nThank You,\n',
 "It appears that the following email may not have been clear.\nYou have to copy all documents yourself.\nThis is my cheat sheet if it helps:    H Drives: 1.\nEach person will have to move any data over personally from the old H drive (which is now Z:) drive to their new H drive.\n2.\nThe Z: drive (old H:) will be removed from UBS employees on Thursday night.\nO Drives: 1.\nFor the old O or M drives go to O:\\ESTATE\\ O (or M ?\npending location of data) and copy to the new common O.\nThe Estate O and M will be removed from UBS employees on Thursday night.\nDo not delete anything and only copy information which is complies with the policy.\nPlease make sure that those people who are not in the office are contacted and comply.\nLouise      To:\t\tAll Enron Employees Transferring to UBS Warburg Energy (or its affiliates)  Under the terms of the various agreements among certain Enron entities and UBS AG, certain Enron data and documents may be provided to UBS.\nTo ensure compliance with those agreements, Enron's document retention policy, as well as directives of various investigative agencies, the attached protocol regarding the process for migration of any information or data to UBS has been developed.\nPlease review the protocol carefully.\nThen, complete the attached Certification and return it, with attachments, to Linda Guinn at EB 3829a no later than February 11, 2002.\nQuestions about this matter may be directed to Michelle Cash at (713) 853-6401 or Francisco Pinto-Leite at (713) 345-7942 .\nProtocol Document and Data Copy Instructions      Certification Document\n",
 "PLEASE READ THIS IMPORTANT INFORMATION CONCERNING THE ENRON STOCK FUND IN THE ENRON CORP. SAVINGS AND ESOP PLANS  On Friday, January 11, trading of Enron stock was suspended on the New York Stock Exchange (NYSE).\nAll Savings and ESOP Plan transactions, including 401(k) payroll contributions,  involving this fund were placed in a pending status until trading resumed.\nAs announced by Enron's Office of the Chair on Wednesday, January 16, Enron stock would now be traded Over The Counter (OTC).\nUpon receiving this information, work began immediately to develop a process that allows for OTC trades in the plans.\nOn Thursday, January 17, Enron initiated a process to facilitate OTC trades of Enron stock inside the 401(k) and ESOP and all pending transactions were processed using Thursday's closing price.\nNow that trading has resumed, we urge you to review your investment elections to ensure that they are consistent with your investment goals.\nAs things change, we will continue to update you.\nEnron Benefits Department\n",
 "Andy -  Per our conversation, can you please provide me with an Index quote for the following volume requirements.\nIt's on Michcon, 1 year starting July.\nThanks so much.\n",
 "Per discussions in Shelley's introductory meeting this morning, please mark your calendars to reflect a Strategy Meeting on Thursday of this week, March 28, 2:00 - 3:30 pm in ECN-39C1.\nPlease let me know if there are any conflicts.\nThanks in advance,\n",
 "As you know, Enron has signed a merger agreement by which Dynegy will acquire Enron.\nWe expect the transaction to close following shareholder and regulatory approvals and various conditions to closing.\nEven though Enron has entered into this agreement, U.S. and foreign antitrust laws require that Enron and Dynegy continue to operate independently of each other.\nIn particular, to the extent that Enron and Dynegy are competitors in various businesses or markets, their respective activities must be undertaken at arm's length until the transaction has closed.\nTherefore, for antitrust purposes you should treat Dynegy as you would any other unaffiliated company notwithstanding the merger agreement.\nIn addition, all information, documents and communications related to the merger between Enron and Dynegy should be coordinated through and approved by Mark Muller, Lance Schuler, Robert Eickenroht, Mark Haedicke, Rob Walls or Greg Whalley of Enron.\nIt is absolutely critical that this procedure be maintained.\nTo the extent that information is required to be disclosed to Dynegy under the merger agreement, then such disclosure should be approved by one of the foregoing individuals.\nIf you have any questions concerning this notice, please contact Lance Schuler (713/853-5419), Robert Eickenroht (713/853-3155), Mark Haedicke (713/853-6544) or Rob Walls (713/646-6017).\nThank you for your help in this matter.\n",
 'Completed an IT agreement with CIMA Energy, who owns 5000/day production on  the Crawford lateral.\nGas will be transported to both the Willi Wick Farm  Tap in the Texas panhandle area as well as to the West Texas pool.\nThe  agreement is at 0.065 cents, plus fuel for 14 months beginning Sept 2000.\nThis new shipper on TW will generate additional revenue (currently shipped  under a Duke FT for 0.02).\n',
 'FYI...I spoke with Craig Carley at Reliant this morning.\nOn contract #22538,  there was not a discount requested therefore September was at Max Rate.\nFor  October, I told him the spreads are still above Max Rate and he is in  agreement.\nNovember...hmmm...above Max Rate?!?\n!\n',
 "The following items were presented in this week's corporate change control....  Feb. 13 From 5:00 p.m.  through 2/14 at 6:00 a.m., the Envision team will perform hardware maintenance on the Envision system.\nThis outage will affect corporate-wide applications accessing the Envision web query, FileNet Panagon IDM Desktop, FileNet IDM for R3, Panagon Capture professional.\nUsers will be able to access IBuyit and IPayit from SAP but will not be able to view invoices.\nFeb. 14\t At 12:00 noon, Enron Network Services will disable advertisement of the 172.29.0.0 networks on the OmahaCisco router.\nThis is to prevent unwanted traffic from routing through Northern Border.\nNo impact is expected.\nFeb. 15 Beginning today, the Application Scripting team will modify the script for Instant messanger to allow parameters.\nNo impact is expected.\nFeb. 15 From 10:30 - 11:00 p.m., Enron Network Services will fail over Internet traffic to the primary firewall.\nThis change will result in a 10-15 second outage for Internet traffic and access to servers on the 192.189.171.0 and 65.201.84.0 DMZ segments.\nThis change will be coordinated with HotTap and will not take place until processing is completed.\nSupport staff with application servers on the DMZ should plan on testing their applications after this change.\n",
 'Based upon our understanding of the request from TW Marketing, here is our suggested position on the posting and awarding of potential take-away capacity at SoCal Needles from approximately 1/1/02 to 5/31/02.\nTW would post on its website a notice in the capacity section that, based on information provided by SoCal regarding an expansion on their system, the take-away capacity at SoCal Needless may be increased by __Dth/day for the period of approximately 1/1/02 to 5/31/02.\nShippers would be advised that the actual start date would depend on SoCal completing their system modifications.\nThe posting would say that TW would accept requests for such capacity during a stated period of time (a minimum of 3 business days).\nTW would award the capacity to the shipper(s) willing to provide the greatest cost commitment.\nThe greatest cost commitment would be defined as those revenues above and beyond the current revenues which Transwestern already receives from reservation charges being paid prior to the bid period.\n',
 "The following items were discussed in this week's ETS and Corporate Change Control Items... Sept. 24\t From 12:00 a.m. through 10/07 at 11:45 p.m., Enron Network Services is implementing a moratorium on all network changes one week prior through one week after the first move of users to Enron Center South.\nThis moratorium will probably be limited to routing changes, no new networks, no changes to existing networks, etc.\nNo impact to ETS networks is expected.\nOct. 4\t\t From 9:00 a.m. - 6:00 p.m., the EDI team will replace the backup EDI server located in Omaha.\nThe existing server will be de-commissioned.\nThe new server will take over the dns and IP address of the old server.\nNo impact is expected as this server is used for disaster recovery.\nOct. 4\t\t From 11:00 p.m. through 10/5 at 2:00 a.m., the Unix team will rename the edinet.enron.com and ecnet.enron.com systems.\nDuring last Saturday's EDI change, the DNS entries were changes but the actual servers were not changed to reflect their new names.\nThey will also install patches to the machines during the maintenance.\nThis change will result in a total disruption of service to EDI Web access only.\nEDI will not be affected.\nOct. 5\t\t From 4:00 - 6:00 p.m., the Monitoring group will bring up the new ITContacts site and disable the old.\nWe are currently not using this site but there are plans to access it in the future.\nNo impact is expected.\nOct. 5\t\t From 7:00 - 8:00 p.m., the Corp server team will perform maintenance on the HR-DB-4 server to add more disk space.\nThis change will result in a disruption of service to all HR Global applications including eHRonline, GCS, GIS, expertfinder, etc.\nOct. 5\t\t From 9:00 - 11:00 p.m., Enron Network Services will split the two 8 port gig channels from ECS to ECN into four 4 port gig channels.\nThis change will fully mesh the ECS core.\nNo impact is expected.\nOct. 5\t\t From 9:00 - 11:45 p.m., the Messaging team will Test Upgrade functions of XTND 2.6.\nThis change affects PDA users who log into XTND.\nNo impact to ETS users is expected.\nX-tend Connect Proxy servers will be unavailable on 10/5/01 from 9:00-11:45pm.\nPalm Pilot users who use X-tend Connect Proxy to sync with Outlook will be unable to do so during this time.\nOct. 5\t\t From 9:00 p.m. through 10/6 at 1:00 a.m., the Messaging team will reboot all Corp and EI Notes servers.\nNo impact to ETS users is expected.\nOct. 5\t\t From 10:00 - 10:15, Enron Network Services will migrate the following Corp servers on the 172.16.63.0 network:  foglight, charon, hyperion, perch, diablo, vision, ricky, dbadmin, worf, riker, europa, titania, pandora, ferrari, pluto, hades, opal, cyclopes, astral, and modena.\nNo impact to ETS is expected.\n",
 'Late on October 25th, we received information about a nonspecific threat to the Enron Center.\nWe communicated with law enforcement officials who found the threat unsubstantiated and without merit.\nNonetheless we take all threats seriously and have increased the security presence at the Enron Center still further.\nOnce again, if you observe suspicious behavior, please call security at 3-6200.\n',
 'All LIM MIMIC & Excel Add-in Users within Enron,                 This past week LIM software was upgraded to reflect LIM latest versions.\nIf you are experiencing problems with MIMIC or the XMIM Excel Addin, please restart your machine for the latest changes to take effect, then follow the instructions for your specific application.\nMIMIC:                      Under Start > Programs > Business Applications > LIM, Use the latest MIMIC version which is MIMIC 1.2.7                    Excel Addin:                          Please reinstall your add-in, running the XMIM Excel User (installation) under Start > Programs > Business Applications > LIM     If problems persist, please contact the Enron - LIM Helpdesk at extension 33923 or 713-853-3923.\n',
 'I will be walking in the Juvenile Diabetes walk on October 28 and am soliciting sponsors.\nIf you would like to donate to this cause, please let me know.\nFor a donation of $25 or more, you will get an Enron JDRF Team T-shirt with our "Mission Possible" theme.\nAs we all know, Juvenile Diabetes is a disease that affects many children and adults alike.\nInsulin is not a cure, only a drug that keeps them alive until a cure is found and a cure is within walking distance.\nPlease help if you can.\nThanks,\n',
 "Per Jan's recent Commission meeting summary I just noticed the Commission had added a discussion item on OFOs.\nThey didn't get to this at yesterday's meeting, but will take up on Oct. 11.\nHelp Joe -- what is this about?\nIs there some possibility of the FERC curbing our ability to use OFOs?\nThis is an absolutely critical tool for us to keep -- even though we seldom use.\nWhere/when can we make our case.\n",
 'Ultraviolet high voltage traps work very well.\nIf the problem is severe put in more than one.\nPlace at least 20 feet away from the area you normally use and install in an elevated location.\nLeave on 24 hours a day.\nHarry Kirmon\n',
 'Due to the holidays and vacation schedules, we will hold off having any further weekly project meetings until Monday, January 7 at 3:30pm.\nPlan on meeting in ECN 15c1.\nthanks for your patience and have a wonderful Christmas.\nKevin Hyatt\n',
 'To make use of office supplies that have been left at vacated workspaces, Enron Property and Services Corp is asking for your assistance.\nEPSC will remove extra supplies from identified areas and place in a central location where they may be utilized by everyone.\nPlease identify areas in your business units that have been vacated and can be checked by EPSC.\nOnce areas have been idenitified please call the Help Desk at x36300, option 2.\nTo obtain office supplies that have been accumulated by EPSC, please email your needs to the following address:\t Facilities Help Desk 1.\nYou will be contacted about available items.\nIf you have any questions please call Richard Hensch at x35522.\n',
 'Our natural gas business continues to benefit from effective account management and resource allocation focused on identifying and responding to the needs of our varied customers.\nIn order to keep our organization optimally structured and to facilitate additional growth, we are making the following changes:  Producer/Wellhead Group  The current mid-market, origination and wellhead pricing activity currently within the Central and Eastern Gas Regions will be consolidated with the Derivatives group under Fred Lagrasta.\nThis will create a single business unit focused upon the needs of the producing industry within the Eastern U.S.\nThe producer focus in the Western U.S. and Texas will remain unchanged reporting  to Mark Whitt and Brian Redmond respectively.\nStrategic Asset  Development Laura Luce will move from her role in the Central Region to lead an effort focused strictly on identifying and entering into long-term strategic arrangements within the Central and Eastern Regions.\nThis initiative will focus on a limited number of selected markets that provide strategic opportunities for partnering in asset development, asset management and optimization.\nThis effort will continue to work very closely with the regional leads.\nCentral Origination and Mid-Market Frank Vickers will continue his current role in the Eastern Region and will assume the leadership role for Mid-Market and Origination activity in the Central Region.\nThere will be no changes to the West and Texas Origination groups headed respectively by Barry Tycholiz and Brian Redmond.\nPlease join us in congratulating Fred, Laura and Frank in their new roles.\nLouise & John\n',
 "I hate to do this, and do not want to put anyone out, but I need some help.\nThe mosquitoes are terrible.\nIt is hurting me to look at Kendall (my son) any more, as the number of bites on him have gone into the double digits.\nI cannot imagine that we are the only ones suffering from these nasty little pests, and I want to do something about it.\nIf any of you have time tomorrow, can you do me this - can you call Harris County Mosquito Control and help me complain?\nI figure that if a whole load of us start calling, they won't be able to ignore us.\nTheir number is 713-440-4800.\nI get a recording when I call, but their hours are 8 - 5, so maybe we can talk to a live person tomorrow.\nThank you for helping me, and ultimately helping everyone.\nBest Regards,\n",
 'Teb, This is the ratings outline printed for you before I left.\nI thought you might want the file in case you wanted to make changes.\nJeanette\n',
 "Rob,   As requested, attached below is a summary of current CPUC proceedings which are important to Transwestern.\nOur focus has been on these five proceedings as in each instance the outcome potentially impacts take-away capacity at the border and end-user rates and terms and conditions of service in our market area.\nThe proceedings included are:  I99-07-003\tGIR/SoCal Unbundling  I00-11-02\tAdequacy of SoCal System  A01-09-024\tSoCalGas BCAP A01-10-005\tSDG&E BCAP  (consolidated w/SoCal)  A01-10-011\tPG&E Gas Accord  I have included the purpose of each proceeding, Transwestern's participation and position when taken, status of each proceeding and key dates for upcoming events.\nPlease feel free to call me to discuss any of the proceedings or to answer any questions.\nOn my next trip to Houston, I'll schedule some time to review these proceedings with anyone interested in further discussion.\nGlen\n",
 '<bigger>Amy,   Sorry I\'m just now getting around responding to your comments of December 26:   >Most Montrose neighborhoods have a very unfortunate layout (with respect to theft and >vandalism) - almost every street is a cross street, so that people can get in and out of the >neighborhood very easily.\n<bigger>    </bigger>>This has been discussed with the Mayor\'s office in past years, but the "need for alternate >routes out of downtown" so far has overshadowed issues such as this.\n</bigger>  I know that 1990\'s planners--like the people who designed the\n',
 'Please look at the attached.\nIf there are some things missing, please let me know.\nIf some things on the list are not applicable, please note that too.\nJust send your deletions/additions to me via email.\nIf you can get this to me by the end of the day Wednesday, that would allow us to proceed with Questar all the sooner.\nThanks,\n',
 'Effective 2/1/02 a new company will go into effect called ENNG.\nThe company code is 179E.\nThe primary purpose of this company is to account for the payroll of the Enron employees who are currently on company 0179, and who will remain Enron employees after the 2/1/02 transition of Northern Natural Gas to Dynegy.\nWith respect to coding invoices, recording time and other similar transactions on Northern Natural Gas (0179) please note the following that are effective 2/1/02:   If you have expenses that you normally would charge to a 0179 FAR order or project, continue using the same codes.\nNo changes here.\nIf you have expenses that you normally would charge to a 0179 cost center, use the same cost center number except replace the first digit with a 5.\nFor example, if you would have charged 111222, charge 511222 instead.\nThese "5" series cost centers have been set up on company 179E, but their payroll and expenses flow into company 0179.\nYou will not be able to code direct to a 0179 cost center after January business (1/31/02).\nIf you are becoming a Dynegy employee on 2/1/02, your time entry for January and corrections to any prior period must be entered before noon on 2/1/02.\nAfter noon on 2/1/02 do not enter your time into eHRonline or the SAP timekeeping application.\nDuring the next week or two we will be working with Dynegy on an alternative for capturing and accounting for your time and payroll expenses.\nIf you are currently a 0179 employee and are continuing as an Enron employee, your time entry for January and corrections to any prior period must be entered before noon on 2/1/02.\nAfter noon on 2/1/02 continue entering your time as you ordinarily would.\nUnless you exception code to FAR orders or projects, your hours will automatically go into the appropriate "5" series cost center on company 179E.\nIf you have any questions or need additional information concerning these coding changes please contact Trey Meerbott at (713) 853-7003.\n',
 "The following items were presented in this week's corporate change control....  Feb. 2 From 6:00 - 9:00 a.m., the Envision team will re-index the databases.\nThis outage will affect corporate-wide applications accessing the Envision web query, FileNet Panagon IDM Desktop, FileNet IDM for R3, Panagon Capture professional.\nUsers will be able to access IBuyit and IPayit from SAP but will not be able to view invoices.\nFeb. 16 From 10:30 - 11:30 p.m., the Omaha Infrastructure team will reconfigure the power connections for the Omaha Inverse MUX.\nThis change will result in a total disruption of IP communication between Omaha and Houston.\nThe outage should only last for a few minutes.\nThe maintenance time will be coordinated with the HotTap helpdesk to ensure processing has been completed.\nAll support staff whose applications are affected by this outage should communicate this change to their customers.\nPlease ensure they are aware of the possibility of an extended outage in the event the Inverse MUX does not properly re-establish communications.\nLAT and DecNet communications for gas control will not be affected by this maintenance.\n",
 'My spotted-blond, male dog slipped out through an unattended door.\nHis name is ponyboy and my tenant estimates it was about 5:00 PM yesterday.\nSomeone told me that he thought he had seen him get hit by car @ taft.\nSearching for him has not turned up any clues.\nI will be posting signs today, Please let me know if you have any info.\nI truly love that dog.\nI adopted him moments before he was to be terminated and he is just the greatest little "crazy" dog I\'ve ever known.\nthanx\n',
 'Phillip,  I apologize that it has taken me so long to send you an e-mail like you asked us to, but I just wanted to send some suggestions/thoughts about things on the East Desk.\n1.\nI really like the idea of weekly meetings.\nEspecially in the new building where we will be spaced out and not all sitting together, I think it would be good for team unity.\nEven if the meeting is only 10 minutes long, it gives the group a chance to talk about what everyone is working on and projects that we can work with others on.\nAlso, with people joining East and leaving East, the meetings could give us a chance to get to know each other better.\nI realize that meetings are not necessary every week, but 2 or 3 a month have very helpful and beneficial for me.\n2.\nWe were all going to give a small "lesson" on an area of our jobs that we have a strong knowledge about and present it to the others in our group.\nJeff has already given a lesson on NX3 Basis positions.\nAlthough the lessons may be a little nerve wracking, I think they would be very useful to continue.\nFor example, the subjects of Liquidation, Storage, and OA are all areas I would like to know more about.\nThat\'s it really.\nThank you for all of your help so far with the Gulf4/5 "merger".\nI am really excited about our new group and I can\'t wait to move to the new building.\nThanks,\n',
 "It's clear the Ebay made the error in this  matter.\nThey are not being forthcoming about it however.\nI'am  continuing to communicate with them but they are being less that  honest.\nI am not going to pay what I did not bid.\nSince Ebay is the culprit here we are caught in the middle   I'd refrain from leaving any negative at my site, until this  matter can be resolved, since I would have to respond in  kind.\n",
 "Question for NetCo employees: The new corp id's xfer to UBS is being considered for this Sunday.\nHence, no start menu access to estate.\nYou will still have access to NT estate drive data to copy.\nDoes anyone have the need to retain a estate id for support estate application during the last week?\nExceptions have to be authorized.\nWanted to get a preliminary need analysis...\nThis was sent by an IT manager, let me know your thoughts... O\n",
 'We have discovered a problem with physical positions in TDS.\nChanged deals potentially can double up the deals volume in TDS.\nThe TDS group worked late Monday to try and resolve the issue, but failed.\nPlease let your traders know that the physical positions cannot be completely relied on.\nI have also left a message on you phones to get this message to you.\nThanks\n',
 'Attached are the spreadsheets you requested.\nThe first tab - 100 is the same  sheet as the one we discussed earlier.\nThe second tab 60.40 is the sheet  that assumes Tom only gets 40% and Sharpe gets the asset deals.\nThe third  tab is the revised summary sheet for all months if the 60.40 split is the  route we choose to go.\nPlease feel free to give me a call with any  questions.\nThanks.\nPL\n',
 "Per your request, attached is the hedge strip file that we use to calculate  your bench every night.\nOn one of the tabs R2, you will find your positions  and a conversion factor.\nI have tied these to the benchmark groups  conversion factor numbers.\nLet me know if we need some of these points  changed, i.e.\nCGPR-DAWN's conversion factor is 0.\nShout with any questions.\nThanks.\n",
 'Attached is the updated scores.\nPlease check your scores to verify  accuracy.\nAs the scores stand now, Joey will win no matter what and the  second place race is between Chuck and Wolfe.\nIf Arizona loses, Wolfe takes  second and if Arizona wins, it goes to the tiebreaker.\nThe rest of us are  out of it.\nIf you have 0 all the way out, it means you do not have any teams  remaining.\nBy the way - nice score Lenhart(we will see if we can get you a  charitable deduction for your $10).\nPL\n',
 'Sam- Here is a little something about my grandfather:   Dr Walter Herschel Burgess was a 1950 graduate of Alabama Polytechnic  Institute, now Auburn University.\nHe practied vetinary medicine for 38 years  in Haleyville, Alabama.\nDr. Burgess was blessed with 3 children, 2  grandchildren and one great grandchild.\nDr. Burgess was an avid golfer and  tremendous football fan.\nHe held Auburn football season tickets for 50  years.\nDr. Burgess recently received the golden eagle from Auburn University  in recognition of 50 years of alumni service.\nDr Burgess was a World War II  veteran.\nDr. Burgess loved Auburn and sent all three of his children and  both grandchildren to school on the plains.\nDue to his love for Auburn that  he instilled in his family, there will definitely be a forth generation  Auburn graduate in the Burgess family.\nDr. Burgess was also a proud member  of the OTS vetinary fraternity at Auburn University.\nDr. Burgess was born in  Cullman County, Alabama and was a 50 year resident of Haleyville, Alabama.\nPlease feel free to take some liberties and rearrange or omit some of the  things I stated above.\nThanks again Sam for all of your help with this and  the recognition this newsletter will give my grandfather.\nAuburn is very  fortunate to have such a great person raising money for the most important  school within the University.\nTalk to you soon.\nPL\n',
 'FYI, make sure the tab on your P&L file has been changed to match this=20 email.\nThis is really important since we are moving books around tonight.\n= =20 Thanks.\n',
 'Can you please set this new location up, Nipsco/NGPL, with curves the same as  the original point, NGPL/Nipsco.\nI believe they are as follows: gas daily  should be GDP-CHI.\nGATE, the intramonth should be NGI/CHI.\nGATE, and the Mid  should be NGI/CHI./NIPSCO.\nPlease shout with any questions.\nThanks for your help.\nPL\n',
 'Jim, Please adjust the sithe storage account to a price of $0, instead of wacog.\nThis adjustment should not have to go back any further than 11/99.\nThe  Pipeline is Union Gas Limited and the storage contract number is 96041510.\nPlease shout with any questions.\nJennifer, this should eliminate the current  outstanding variances and create a variances for all past months that have  been cleaned up.\nThe P&L impact of the new variances should be minimal due  to the small volume nature of these transactions in the past.\nI believe the  variances will be a gain.\nThanks for you help guys.\n',
 "Northern Gas Company is requesting a letter proposal for peaking gas for December 2001 through February 2002.\nThis proposal could be for the Casper Pooling point #18106 or any other mutually agreeable points into NGC's system.\nThe volumes should be a max volume of 15,000 to 20,000/d.\nNGC would like to receive this proposal by November 7th and we will notify suppliers on November 9th or 12th.\nIf you have questions let me know.\nThanks, Lorraine\n",
 'RE:  NOTICE TO CLAY BASIN CAPACITY HOLDERS  Questar Pipeline Company (Questar) is planning to perform Clay Basin inventory verification and deliverability tests beginning April 2, 2002.\nThese tests will involve a 14-day shut-in of Clay Basin for reservoir gas inventory verification followed immediately by a 2-day field deliverability test.\nD  uring the 14-day shut-in, Clay Basin customers will not be able to utilize their storage service.\nHowever, in order to facilitate the 2-day deliverability test, an Operational Flow Order (OFO) will be issued and storage capacity holders will be required to take a pro-rata share of their withdrawal capacity from a total volume of 300,000 dth in a 32-hour period.\nQuestar will work with storage customers to facilitate transportation of their gas supply during this time period.\nQuestar is interested in finding ways to minimize the impact of this testing on its shippers.\nPlease contact your Questar marketing repesentative to discuss the testing process.\n',
 "Here's the worksheet I sent to Nicole for February.\nThe volumes come right off the CIG invoice for each contract, are input on the right side of the CIG worksheet and are totaled on the summary at the left.\nThe numbers in blue are inputs from the invoices.\n",
 'Hello Paul,   Orbitz would like to assist with the preparation for your journey to San Antonio on December 21.\nImportant information for your day of travel  * You have e-tickets for this trip.\nImportant: You will need a printed copy of your e-ticket itinerary and a government-issued photo ID for the check-in procedures at the airport.\nWe suggest printing this email for this purpose.\nIf you are not checking luggage, you may proceed directly to the gate.\n* Your Orbitz record locator is OM7JOI.\n* The confirmed traveler(s) for this trip are: PAUL LUCCI, ticket number 0051505151355   * If you are checking baggage, please make sure that every bag is labeled with your name and home address.\nWe recommend getting to the airport at least 2 hours prior to departure for security and luggage check in.\nFriday, December 21 * Arrive at Denver International (DEN) two hours before your scheduled departure time for domestic flights, or three hours before your scheduled departure time for international flights.\n* If you have no luggage to check in, proceed directly to the gate.\n* At 4:35 PM MST your flight, Continental Airlines (CO) 1098, will depart for Houston George Bush International (IAH).\nYour approximate travel time is 2 hours and 17 minutes.\nA Dinner will be served during your flight.\n* You are scheduled to arrive at Houston George Bush International (IAH) at 7:52 PM CST.\nPlease check the monitors in the terminal for the gate of your connecting flight and for possible changes of departure time.\n* At 8:29 PM CST your flight, Continental Airlines  (CO) 1687, will depart for International (SAT).\nYour approximate travel time is 56 minutes.\nIt is unknown whether a meal will be served during your flight.\n* You are scheduled to arrive at International (SAT) at 9:25 PM CST.\nFollow the signs for luggage and transportation.\nEnjoy your time in San Antonio!\nWednesday, December 26 * Arrive at International (SAT) two hours before your scheduled departure time for domestic flights, or three hours before your scheduled departure time for international flights.\n* If you have no luggage to check in, proceed directly to the gate.\n* At 6:56 PM CST your flight, Continental Airlines (CO) 778, will depart for Houston George Bush International (IAH).\nYour approximate travel time is 55 minutes.\nIt is unknown whether a meal will be served during your flight.\n* You are scheduled to arrive at Houston George Bush International (IAH) at 7:51 PM CST.\nPlease check the monitors in the terminal for the gate of your connecting flight and for possible changes of departure time.\n* At 8:33 PM CST your flight, Continental Airlines  (CO) 722, will depart for Denver International (DEN).\nYour approximate travel time is 2 hours and 24 minutes.\nIt is unknown whether a meal will be served during your flight.\n* You are scheduled to arrive at Denver International (DEN) at 9:57 PM MST.\nFollow the signs for luggage and transportation.\n',
 "As you know, Enron has signed a merger agreement by which Dynegy will acquire Enron.\nWe expect the transaction to close following shareholder and regulatory approvals and various conditions to closing.\nEven though Enron has entered into this agreement, U.S. and foreign antitrust laws require that Enron and Dynegy continue to operate independently of each other.\nIn particular, to the extent that Enron and Dynegy are competitors in various businesses or markets, their respective activities must be undertaken at arm's length until the transaction has closed.\nTherefore, for antitrust purposes you should treat Dynegy as you would any other unaffiliated company notwithstanding the merger agreement.\nIn addition, all information, documents and communications related to the merger between Enron and Dynegy should be coordinated through and approved by Mark Muller, Lance Schuler, Robert Eickenroht, Mark Haedicke, Rob Walls or Greg Whalley of Enron.\nIt is absolutely critical that this procedure be maintained.\nTo the extent that information is required to be disclosed to Dynegy under the merger agreement, then such disclosure should be approved by one of the foregoing individuals.\nIf you have any questions concerning this notice, please contact Lance Schuler (713/853-5419), Robert Eickenroht (713/853-3155), Mark Haedicke (713/853-6544) or Rob Walls (713/646-6017).\nThank you for your help in this matter.\n",
 "It appears that the following email may not have been clear.\nYou have to copy all documents yourself.\nThis is my cheat sheet if it helps:    H Drives: 1.\nEach person will have to move any data over personally from the old H drive (which is now Z:) drive to their new H drive.\n2.\nThe Z: drive (old H:) will be removed from UBS employees on Thursday night.\nO Drives: 1.\nFor the old O or M drives go to O:\\ESTATE\\ O (or M ?\npending location of data) and copy to the new common O.\nThe Estate O and M will be removed from UBS employees on Thursday night.\nDo not delete anything and only copy information which is complies with the policy.\nPlease make sure that those people who are not in the office are contacted and comply.\nLouise      To:\t\tAll Enron Employees Transferring to UBS Warburg Energy (or its affiliates)  Under the terms of the various agreements among certain Enron entities and UBS AG, certain Enron data and documents may be provided to UBS.\nTo ensure compliance with those agreements, Enron's document retention policy, as well as directives of various investigative agencies, the attached protocol regarding the process for migration of any information or data to UBS has been developed.\nPlease review the protocol carefully.\nThen, complete the attached Certification and return it, with attachments, to Linda Guinn at EB 3829a no later than February 11, 2002.\nQuestions about this matter may be directed to Michelle Cash at (713) 853-6401 or Francisco Pinto-Leite at (713) 345-7942 .\nProtocol Document and Data Copy Instructions      Certification Document\n",
 "In anticipation of the imminent closing of the UBSW Energy transaction, please have all outstanding employee expenses in your possession filed through Enron's XMS system as soon as possible.\nNote to approvers - please approve these expense reports quickly.\nEnron will process and pay all pre-closing expenses.\nAfter transaction closing,  payments  for expenses submitted before closing (and put into Enron's XMS system) will be sent to your last known address or direct deposited into your account.\nEnron has committed to processing and paying any expenses incurred prior to transaction closing.\nIf not completed this week, pre-closing expenses should be submitted on a  hard copy expense report form which will be available at  www.enron.com.\nThere will be a series of e-mails coming out over the next few days highlighting the Travel & Entertainment policies of UBSW Energy and the procedures for processing and payment.\nIf you have any questions, please contact Hope Vargas (3-5280) or Georganne Hodges (3-0430).\n",
 'REMINDER!!!\nYou are enrolled in the following class.\nBasics of Risk Management November 15 & 16, 2001 in EB552 8:00 am - 5:00 pm (1st day) 8:00 am - 12:00 pm (2nd day)   Please be on time.\nLast day to cancel is today.\nIf you cannot attend, please let me know, so that your company and cost center does not get charged.\n',
 'Due to current business circumstances, on November 28, 2001, Enron\'s Board of Directors adopted an amendment to the Enron Corp. Savings Plan.\nThe amendment includes the following changes, which became effective on November 29:  ?\nSavings Plan contributions that are deducted from your November 30 paycheck will be matched by Enron in cash rather than Enron stock.\nThe cash match will be placed into the Fidelity Freedom 2000 fund, the default fund for the Plan.\n?\nAfter November 30, Enron will no longer match your savings plan contributions.\nAs an exception, the company will continue the union matching contributions to the Plan.\n?\nThe Savings Plan has always permitted employees to place their contributions in Enron stock or one or more alternative investment options.\nEffective immediately, diversification within the Plan will ALSO be allowed, regardless of your age, from COMPANY contribution accounts.\nThis removes the restriction for all employees under the age of 50 to diversify the company contributions held in their account.\nThese accounts include all prior company contributions, QNEC, and company match accounts.\nTo move funds: On the Web, choose "Savings Plan--Restricted Employer Acct Transfer/Reallocation" from the drop down menu.\n',
 'Dear Lori,  Just a quick question:  Shayne Newell here (working on the petition) had the company name quoted to her (at a meeting regarding assets in the company) as:  Enron Capital & Trade Resources Investment Corp.  Is there another entity out there with that name rather than Enron Capital & Trade Resources International Corp.?\nThanks!\nJayne\n',
 "Kay,  did you know that the Deerfield option agreements are not held by deerfield (they are held by lauderdale), & that the permits are held by a lauderdale subsidiary?\nBart wants to know if it makes sense to file for deerfield & not for the other LLC's where the project assets are held.\nCan you answer this because bart is standing over my shoulder.\nK\n",
 'Lisa,  Here is the discussion draft of change order #3 for your review, comment,  changes, etc.\nOnce it is finalized ENA would appreciate receiving a note  requesting that the change order be executed, with the change order  initialled by the appropriate person at ESA.\nThanks,\n',
 "Hi Heather,  Here's a form of LOI we can use.\nNancy W. called and is ready to discuss the PPA.\nWe can call her after our  meeting, or before if you have the time.\nKay\n",
 "I changed the plant stuff around, swapping most of them for Facility.\nI  think it is a bit more clear now.\nLet me know what else needs to be done.\nI'll be leaving in around 1230 to buy a bribe, I mean pumpkin, but we won't  be gone long.\nKay\n",
 "Hi John,  Sorry I missed your call last week.\nI was out ill.\nI'll give you a call  once I dig out from under the paper.\nKay\n",
 "Gentlemen,  Here's the most recent version of the equipment contract.\nI am including a  ComparRite redline version, comparing this version to the Oct 11 version sent  by Enron.\nI look forward to speaking with you soon,  Kay\n",
 'Please tell Paul it will probaby be 315 or so before we call, and confirm the  correct number.\nAlso, please let Lisa Bills know where we will be meeting, as  she is planning on coming late to the meeting.\nThanks,\n',
 "Gentlemen,  Attached are GE's comments which I just received.\nThey are concerned that we  tried to improve the contract.\nOh well.\nI hope to get this resolved today so we can wrap it up early next week.\nTalk to you soon,  Kay\n",
 "Here's how it is shaping up:  We have a fence appointment for noon, the Wednesday before Thanksgiving.\nThat is the first opening, but there is always a chance of a cancellation.\nJust in case there is an earlier opening, the utility people will be out  tomorrow.\nTherefore, we need to have BOTH dogs put up tomorrow, and the gate  open.\nWe have a noon appointment with John Foster THIS Wednesday.\nThere is a $20  consulting fee.\nThis is the same day Michael's class sings in chapel at 115,  so this isn't too bad.\nI have a 130 staff meeting, but maybe I can miss it.\nThe work will NOT be done that day, as far as I know.\nIf we have  a hope of leaving town the week of Thanksgiving, we need a\n",
 "Mike Sandridge and I finally spoke on the phone.\nHere are the issues which  need to be addressed to keep things moving:  1.\nWhich transformers go where?\n2.\nHow do we deal with the two cancelled units and any cancellation charges?\n3.\nABB has not had a good experience with an Enron LLC arrangement, and the  contract allows for them to request payment security.\nUnless they are  convinced that they aren't at risk, they will want some form of payment  security.\nThe contract does allow for the equipment to be paid off (except  retainage) to facilitate the assignment.\nMike is available Thursday to discuss these issues, and how to get the break  out contracts closed.\nI'm available any time.\nKay\n",
 "I've heard that the turbines are supposed to be moved out of WestLB today.\nThe contract with GE is not quite finished, although it is close.\nKay\n",
 'Here\'s a new one.\nMichael told me he was hungry (big surprise).\nI said,  "Michael, do you want some turkey?"\nHe said "No Mom, did you forget that I\'m  a vegetarian?"\nI had to leave the room as I couldn\'t keep from laughing!\nKay\n',
 'Fuel cells kindle investor energy By Beverly Goodman Redherring.com, November 27, 2000  Companies with no earnings.\nMarket capitalizations in the billions even  though revenue hovers in the tens of millions.\nAnalyst optimism bordering on  the feverish.\nWe know -- this probably sounds all too familiar.\nBut this time\n',
 "The sailing might be fun, and the price is right.\n=09  =09 =09  =09 =09  =09 =09The Main Bed & Breakfast Inn=20 =09 =09General Information=20 Welcome to The Main Bed and Breakfast Inn, located in Palacios on the sceni= c=20 Texas Gulf Coast.\nNick and Kathy Nichols are the innkeepers, and your hosts= =20 for enjoying the sights of Tres Palacios and Matagorda Bays.\nThe Inn is a= =20 German Gothic-style stone house, built in 1917.\nFrom it=01,s spacious front= =20 porch to the sun room at the rear of the house, particular attention has be= en=20 given to preserve the character and authenticity of the structure.\nGracious= =20 archways join the foyer, living and dining rooms, polished hardwood floors= =20 run throughout the main floor, and attractive, comfortable furnishings=20 complete the scene.\nThe modern conveniences include central air conditionin= g=20 and televisions in each room.\nSix accommodations are available to guests: t= wo=20 rooms in the main house, each with private baths and private entrances.\nOne= =20 is appointed with the innkeepers memorabilia of their home in Colorado, the= =20 other with momento=01,s from their life at sea.\nTwo bungalows are available= ,=20 separate from the main house.\nThese have accommodations for families,=20 including a full kitchen and tiled shower.\nEach bungalow is air conditioned= =20 and has a television.\nA one-bedroom apartment with a spacious living room a= nd=20 full kitchen, can accomodate family groups of four.\nThe last accommodation= =20 available is our sailboat, Papillon, which is described below.\nWhether you= =01,re=20 looking for a place to relax (try our pecan tree-canopied back yard) or pla= y=20 (the beach, seawall and fishing piers make for a good time), The Main Bed &= =20 Breakfast Inn will make your stay in Palacios a memorable one.\nCome see us!= =20 =09 =09Room Rates (USD American Dollars)=20 =09  =09 =09All Occupancy Rates are subject to change=20 =09State and Local taxes may apply=20 =09Types of Accommodations: 2 rooms, 2 bungalows=20 =09There are 4 guest accommodations (4 with private bathrooms)=20 =09The rate for double occupancy is between $60.00 and $65.00=20 =09Other Types of Accommodations: Sailboat.\nThe fifth room available to gue= sts=20 is abourd the Nichol's sailing yacht, Papillon, berthed at a marina just=20 blocks from the Inn.\nThis 37-foot vessel has v-berth, head, full galley and= =20 saloon atractively arranged within its 12-foot beam.\nA night aboard Papillo= n=20 includes a delicious gourmet breakfast.\nDay or night sails on Matagorda Bay= =20 or the Gulf of Mexico are also available, with Captain Nick at the helm.\nTh= e=20 rate for this special accommodation is $9 5=20 =09 =09 =09 =09 =09\n",
 "Hi Rob,  We are considering assigning a couple of the LM's to an Enron LLC, then  selling the equity.\nI've taken a stab at the assignment & assumption  agreement.\nIs this ok?\nHas WestLB signed of on this form yet?\nThis is the same transaction I called you about this am.\nAny thoughts on the  notice question?\nThanks,\n",
 "Here's the consent form for the equipment going into TurboPark.\nIf you have  any questions, please call me at home tomorrow (Friday) morning at 713 973  6325.\nThanks,\n",
 "Dave Onuscheck left me a voice mail message that Frank had not yet reviewed  the change order.\nDave predicted it would be tomorrow am.\nThat's getting  close., but if it is done by then we probably won't be subjected to bodily  harm.\nKay\n",
 "Good morning!\nI'm soliciting commitments for those wanting to go to the Nutcracker this  year.\nI was thinking of trying to get tickets to a daytime performance.\nAny  interest?\nThe Sugar Plum Fairy\n",
 "Mitch,  Here's a first draft.\nPlease suggest any additional complaints/shortfalls  which we need to raise.\nIt is better to be all inclusive than leave  something out.\nRichard, any ideas or comments?\nKay\n",
 "Good morning.\nI didn't wake Paige up this am.\nI told Michael he could wake her up when he  wanted to, which I presume didn't take long.\nIt feels good to be back.\nLast week really wasn't a very good week to take  off, and I was really stressed.\nIt helps knowing that I have a holiday in two  weeks!\nI'm glad, since Michael is off then as well.\nDid you make friends with your venison (or was is pork)?\nLove,\n",
 "Here's a set of CA I revised docs.\nIf these are ok, we will get CA II lined  up as well.\nI'm on the road tomorrow, but should be back in the office on Wednesday am.\nKay\n",
 'Lisa,  GE is asking for fully executed copies of thedocuments they signed in  connection with the TurboPark transaction.\nIf I can get copies I will be  glad to make distribution.\nKay\n',
 "Hi there.\nIs this required by our agreement, or just a nice touch?\nWe have a fairly  long list of people who we would have to track down, and it seems to me that  these people can be replaced (or have been) without the formality of  resigning.\nI'll send you the list separately.\nThanks,\n",
 "There's a monthly birthday party thing at 300 up here.\nI know you don't  always get the word, so here's the word.\nHow's your brother?\nckm\n",
 "I ran a redline from the last version I had electronically.\nI've forwarded the current version to Herman for his review and approval.\nDue to some of the changes, Enron may need some revisions as well.\nKay\n",
 "Hi John,  Mark and I are still working at the hotel, waiting to hear from the=20 counterparty.\n=20  Could you forward this to Jon?\nI don't have his email address.\nThanks,\n",
 'Here\'s what Eric wrote:   I revised the contract you sent me to make it site specific.\nThose changes  are redlined.\nPlease note that I have reinserted sections 10.4.1 and 10.4.3  as well as the defined terms that go with them.\nThese were related to  exhaust temperature and energy.\nI know this is a simple cycle plant and they  typically aren\'t required, but I wanted to see if GE would guarantee it  anyway.\nIt maybe helpful in the future if Austin Energy goes combined  cycle.\nIf for some reason GE\'s lawyers specifically want to leave that out,  then they will probably also want to delete sections 10.4.2 and 10.4.4 (and  their defined terms) since those also talk about specific exhaust  guarantees.\nLet me know what they decide.\nExhibit A (site basis conditions) which I also revised was not attached to  your file.\n(It\'s right behind the sign-off pages in my hard copy.)\nI  therefor hand marked up a copy and scanned it.\nIt is now attached as a  separate word file.\nExhibit F is "boiler plate" and shouldn\'t change.\nExhibit "U" is not in my  hard copy.\nMy copy only goes up to Exhibit "T."   If you get something from  GE on Exhibit "U", send it to me and I will be glad to review it.\n',
 "Hi Sharon,  Michael will pass on next week's appointment.\nHe and I have the day off  together, so I'm making some special rodeo plans.\nHis winter report from his teachers was good.\nHe is meeting or exceeding  expectations in all categories.\nWe recently visited at school and watched  him for about an hour, and he was attending very well, sitting still (well,  relative to the other kids), following instructions, raising his hand to be  called upon, etc.\nYou should have heard him speak Spanish - it was so cute.\nWe visited in the am, and I haven't seen him in the afternoon without meds.\nThe class schedule hasn't required an afternoon dose as of yet.\nHope all is well with you.\nKay\n",
 'Mercury\'s Mountaineer debuted several years ago as an upscale version of the  best-selling Ford Explorer sport-utility vehicle.\nThe problem was, Ford\'s  Explorer could be just as luxurious as the Mountaineer and, in some cases,  was even more expensive.\nFor 2002, Mercury has attempted to further  distinguish their sport-ute from the popular Explorer.\nThe result is a fine  SUV, with improved handling characteristics and generous feature content.\nThis near-luxury sport-ute comes with either a 4.0-liter V6 making 210  horsepower or a 4.6-liter V8 pumping out 240 ponies.\nBoth engines come mated  to a five-speed automatic transmission.\nThe new V8 offers copious and refined  power delivery, but unimpressive mileage numbers.\nMountaineer has been redesigned inside and out, and the results are pleasing.\nNow easily distinguishable from the Explorer from the A-pillars forward, its  "New Edge" theme makes use of a satin-finish grille and bold headlamps.\nMeanwhile, the interior gets satin-aluminum trim accents, lending a  distinctive, high-tech flavor to this former Explorer clone.\nImprovements to the Mountaineer are much more than cosmetic, however.\nAn  all-new independent rear suspension featuring a unique porthole-in-frame  design debuts this year.\nThis setup allows the rear floor to drop 7 inches -  thereby making room for a third-row seat - while increasing ground clearance  to 9.2 inches.\nAt the same time, ride and handling have been dramatically  improved.\nThe Mountaineer now feels more stable on the road and exhibits  flatter cornering characteristics.\nA 2.5-inch wider stance improves handling  even more, while increasing interior room.\nNoise, vibration and harshness (NVH) have also been improved in the 2002  Mountaineer.\nA 50-percent reduction of air leakage into the truck\'s cabin and  a refined automatic transmission make for a more serene driving environment,  although some vibration from the available all-wheel-drive system does  intrude through the floor.\nNew convenience features in the Mountaineer include a standard six-way power  adjustable driver\'s seat, along with optional adjustable pedals, heated front  seats and heated exterior mirrors.\nAmong the Mountaineer\'s new safety  features are optional side curtain airbags, a stiffer body shell and a lower  front bumper for improved crash compatibility with other vehicles.\nLater in  the model year, rollover protection sensors, and a new AdvanceTrac  traction/stability control system will also be available.\nThe Mountaineer\'s strengths lie in its feature content, powerful engine  choices and improved rear suspension.\nThere are plenty of SUVs on the market,  but if you want an Explorer, yet can\'t stomach the thought of owning the  golden retriever of sport-utility vehicles, the Mountaineer just might float  your boat.\n',
 "Karen,  Fred Mitro forwarded an email you sent him concerning a legal question.\nPlease be advised that Enron policy requires that all outside legal advice be  coordinated through an inhouse lawyer, and certainly any legal advice given  to Enron employees must be given to Enron counsel as well.\nThis requires  some discipline on the part of our outside counsel, but we find it works in  everyone's best interest.\nThank you for your attention to this very important policy.\nKay\n",
 "We had the legal call on Wednesday.\nIt was Mike, Kent and me.\nYou didn't  miss much.\nThey are waiting on us, and I didn't want to give them anything  we hadn't discussed internally.\nI asked Rose to have the Coyote Springs contract OBS'ed (off balance  sheet-ed).\nShe should have something shortly.\nBy the way, the contact sheet that Steve distributed was the one we prepared.\nI'll catch you up on other stuff when you have time.\nNothing urgent...  Kay\n",
 "The outside lawyer for Northwestern, Marguerite Kahn, would like to speak  with you concerning the structure of the LLC, specifically including the  promissory notes.\nGuess I didn't explain it all that well.\nI asked her just  to call you directly, and gave her your number.\nThanks,\n",
 'I am selling my Bayou II kayak by Dagger.\nIt is a two person, enclosed  style, kayak perfect for enjoyable kayaking with a special friend or family  member.\nEspecially good for fishing because one person can paddle and  position the boat while the other fishes.\n',
 'Here is the current draft for your review.\nIn addition to the changes which  were made, there were some valid comments made by Beck and Christi, which I  think need to be addressed, but can be addressed in the definitive agreements.\nPlease revise carefully and let me know if you have any comments.\nKay\n',
 'Hi Karen,  Could I get a copy of whatever the latest version is of the GE consent for  Pastoria?\nWe have a potential deal coming up to move some frames out of  TurboPark, so I would like to see the current state-of-the-are version.\nThanks,\n',
 'Attached is a slightly revised turbine contract.\nThe performance values have  been modified, as I believe the previous draft had site-specific numbers.\nIt  is redlined against the version you received last Friday.\nKay\n',
 "Here's a starting point.\nI've tried to bracket stuff with open issues like  this [ ], but I'm sure there are more questions than [ ]s.  I'm really  unclear on the financial aspect of the deal.\nReagan, I didn't stop to put the exhibits you sent in, as I thought it was  better to get the doc in your hands (and Mr. Fairley's) for a detailed review.\nKay\n",
 "my printer just froze, and I want to look at the doc to finish the  reorganization.\nCould you pretty please fax me the first 14 pages (I have  the last).\nAlso, could you look at the stuff I've highlighted in yellow.\nI haven't put all your comments in, but I will in a minute.\nDon't get  discouraged, the draft is closer to finished than it looks, it is just the  changes are in my head.\nIt won't take too terribly long now.\nI've set up the exhibits as a separate document to make it easier to move  around the doc.\nI think it would be kind of strange to send a draft without the most basic of  commercial terms included.\nStranger things have happened of course!\nMany thanks.\nKay\n",
 "Nothing from Ben yet.\nIf I don't hear from him in the next couple of hours,  then I think we should be ready with an extension letter, giving them a  couple of days extra for free.\nBen indicated to  me last week that he would  give them some time once they asked.\nMK called with questions on the assignment - nothing serious.\nKay\n",
 "Hi Bruce,  There's a Christie Patrick who is a VP of Government Affairs.\nI'm wondering  if this isn't the same person you referenced.\nI don't know her.\nRegards,\n",
 'Hi there,  I suggest a brief status call tomorrow at 100 central to assess where we are  and what we need to finish.\nHow does this time work for everyone?\nThanks,\n',
 'Hi Matt and Ed,  I need the corp docs for Salmon Energy.\nDo one of you gentlemen have this?\nWe are getting close to closing.\nThanks,\n',
 "I've made a list of issues Heather and I have discussed based on VEPCO's=20 suggested revisions.\nSome of the issues are commercial, some legal, some= =20 just reminders.\nComments are appreciated.\n1.\nTerm.\nWhat will we accept?\n2.\nAvailability:  single computation despite source of power (market or=20 facility).\nIs forced outage the correct concept since we want to have some= =20 discretion, and LD structure should apply even if power coming from the=20 market?\nNote VEPCO=01,s insertion of a new event of default under 7.1 for= =20 failure to deliver energy when the Facility is not in a forced outage.\n=20 Liquidated damages language still ok?\nLD=01,s should apply regardless of= =20 scheduled source of power =01) no cost of cover for market power.\n3.\nOur position is that Contract Capacity set at contract signing, then=20 adjusted (if necessary) based on performance tests, not subject to adjustme= nt=20 after that time: ditto for the demand charge.\nWhat is the right number for= =20 the Capacity?\nIs there a benefit to Enron to have a correction curve exhib= it?\n4.\nFailure to complete facility suggested as a termination event.\nIs=20 September long enough?\n5.\nWe need to be able to supply from either or both sources (market and=20 facility) during a day, but this doesn=01,t give us right to change during = the=20 day after the schedule is set.\n6.\nNote the Start Up definition (as suggested by VEPCO) and how it is=20 applied.\nReject 50% requirement at this point, subject to their explanatio= n.  7.\nNote: construction of the facility now required (2.3).=20  8.\nDefine commercial operation.\n9.\nConfirm that Enron has sufficient protection from interconnection=20 failures/delays.\n10.\nDay ahead scheduling (3.4)  Are we ready to commit?\n11.\nNumber of start ups.\n(2.3 e)  12.\nForce majeure =01) consistency with interconnection agreement, relief f= or=20 certain equipment failures.\nIs concept logically developed throughout the= =20 document?\nNote distinction between market and facility power in force=20 majeure language.\n13.\nDispute resolution:  arbitration vs. litigation/venue.\nVirginia law?\n14.\nChange in law.\nCounter with CIL as termination event?\n15.\nExhibit A =01) Heather is working on this.\nKay\n",
 'Nearly final docs.\nThe change they want in the LLC is the addition of a statement indicating  that for tax purposes this is a  single member LLC, or something like that.\nThe promissory note is felt to be necessary due to the adjustment mechanism  for any change orders.\nHas something to do with them getting all the basis.\nKay\n',
 "Attached is the King & Spalding power transaction deal team.\nI'll update the  information I have for A &K and B &P, since some of the designated lawyers on  their lists are no longer there.\nKay\n",
 "I wanted to review where I think we are in this transaction.\n1.\nEscrow account.\nWe are still awaiting  closure on the issue of the  lender's security interest in the escrow account.\nA proposal was discussed  with them to ensure that we could still close the transaction even if Delta  had defaulted under their loan arrangement.\nIndications were that this  approach was generally acceptable, and Delta/Hancock are to send a letter  agreement concerning this approach.\nThis has not yet been received.\nThis  prevents the establishment of the escrow account.\nWe have sent the escrow  agreement to the bank, but Delta has not completely signed off on the  agreement.\n2.\nGE turbine contract.\nDelta sent requested changes yesterday, and these  were forwarded to GE.\nI have not received a response from GE.\n3.\nMiscellaneous docs.\nEnron has responded to all the documents requested  by Hancock.\nWe are awaiting responses to our drafts.\n4.\nGE consent.\nHancock requested some changes to the current draft, and a  new letter agreement.\nGE hasn't responded to the requests yet.\nGE has dealt  directly with Freshfields, so it is possible that there are discussions we  aren't involved in.\nI've left Lee a message concernig the GE items and the timing of signing.\nCarolyn, please correct/add anything you think is important.\nKay\n",
 "I spoke with Kent Shoemaker, and he has a conflict at 930 Houston time  today.\nI suggested to him that Enron go forward with the call as an internal  call, and we can conference him in after 1000 (when he's available), if we  have anything noteworthy to report.\nIf that is acceptable, I will go to Sheila's office at 930, and we can call  Scott and Rose.\nHow does that sound?\nKay\n",
 "Hi Ed,  Here's the language they offered:  M. Each of the Cities has obligated itself to be responsible for and to pay= =20 to, or on behalf of, MDEA, if required, that proportion of the minimum=20 monthly fee which that City=01,s hourly demand was coincident with Entergy= =01,s=20 peak hour demand in the year 2000 bears to the sum of both Cities=01, hourl= y=20 demand during such hour; provided however, that each City has further=20 obligated itself to be responsible for and to pay that portion of EMPI=01,s= =20 monthly fee which the economic benefit to that City from transactions bears= =20 to the total economic benefit to both Cities from such transactions during= =20 the month.\nIt is a bit cumbersome, but I think I like it.\nWhat do you think?\nI'll forward the entire doc soon.\nKay\n",
 "Gentlemen,  I'm with EWS Legal, and I'm working with John Llodra (East Power origination)  concerning a confidentiality agreement with Ameresco.\nThe proposed  transaction is described as follows:   A potential power plant site development and asset management services  related to the Island End Generation Project, a nominal  365 MW combined  cycle power generation facility, proposed to be located in Everett,  Massachusetts.\nThe current draft of the CA contains this language:   From the time of the signing of this Agreement until October 1, 2001 neither  Party shall pursue the Proposed Transaction without  the participation of the  other Party, unless the other Party consents in writing or notifies the other  Party that it does not intend to   pursue the Proposed Transaction.\nIn accordance with policy, this issue is being submitted to you for your  review.\nJohn can be contacted at 978 449 9936.\nMy extension is 57566.\nThank you,\n",
 "Hi Rebecca,  I'm trying to locate the sig pages for the NW guaranty.\nThese were the docs  that I approved after I had approved the letter agreement.\nThese signed  pages weren't with the letter agreements and change orders you brought me.\nTo you remember if you brought them to me before?\nI haven't really searched  - I thought I would ask first.\nThanks,\n",
 "Here's a rough cut.\nLet me know what you think.\nThe fuel cells will be subjected to testing after installation to ensure that  each fuel cell meets the performance criteria prior to CRRA accepting the  units.\nThese tests will measure heat rate, electrical output, air emissions,  noise levels and water consumption, and will last at least one hour each.\nIn  addition, a seventy-two hour test will be run to ascertain that each unit is  capable of producing the required output without outages.\nThe final test  protocol will establish the number of tests to be performed.\nHeather:  There was a proposed ASME standard relating to the testing of fuel  cells, but I don't know if it has been adopted yet.\nIf it has been, we could  make reference to that fact that the tests will be conducted in conformance  with ASME PT-50, or whatever it is.\nI'm sure Ric knows.\nKay\n",
 'Hi there,  I need to get with Lee Johnson on another deal, and I know he will ask about  LV CoGen.\nAnything I should tell him?\nThanks,\n',
 'Hello.\nI gave the Matagorda County Fair & Livestock Association $2050, and filled  out the form for the match.\nPlease advise if this has been paid, as they are  sending me a bill for the $2050, plus a finance charge.\nThank you,\n',
 "I haven't read this yet, so it is not ready to be sent to TECO.\nJust wanted  to give you a look as soon as possible.\nKay\n",
 'In an effort to pull the pieces together, a meeting has been scheduled to  discuss the draft energy and capacity contract (formerly the PPA).\nIt is  scheduled for Thursday, August 24th, at 900am.\nWe are still in the process  of locating a conference room, so the location is TBD.\nThanks,\n',
 'Looks like Thursday at 300pm is working out for most people to meet to  discuss the VEPCO PPA.\nThe meeting will be held in EB38C1.\nPlease let me know if you have any questions or comments.\nKay\n',
 "Just a reminder that until the finance arrangements are fixed and the rules  are clear, Enron can't incur any hard costs related to the Virginia Power  deal.\nThis means Enron can't obligate itself to purchase any equipment or  materials, or enter into any services agreements except for studies, etc.\nI will try to get some clarification on what can be done at this point, and  will pass it along as soon as possible.\nKay\n",
 "Hi Ben,  I've started a draft of the ESA document, and I wanted to get your comments  before I go much further.\nBasically, I want to make sure  I'm on the right  track.\nI'll make it look pretty as we go along.\nGetting the deal points are most  important at this point.\nThanks,\n",
 'Is everyone available on Friday to discuss where we are and where we are  headed with the CPCN process?\nWe need to discuss whether the petition  can/should be amended to allow for a broader certificate.\nThanks,\n',
 "Ben,  Here's a draft of an MOU for the sale of the LMs and ABB equipment to ESA.\nOne issue is when this transaction can close.\nSince the equipment is owned  by WestLB and since the feeling is we don't want to involve WestLB in the  transaction, the actual transfer would take place at the termination of the  WestLB facility.\nIf another approach is preferred, we will need to circle  back with Lisa.\nA second issue I see is with the concept that GE will need to look to both  ENA (or WestLB's successor) for some of the payments, but look to ESA for  payment for changes, storage, etc.\nAs far as I know, this concept hasn't  been addressed with GE.\nI re-calculated the overhead charge, so you might want to check it out.\nI look forward to your comments.\nKay\n",
 "Hi Allyson,  What is your impression of why the NC attorney general's office has  intervened in the CPCN proceeding?\nIs this typical?\nDoes the AG's office  (or any other intervenor) have any special rights to discover any of the  confidential information we file?\nThanks,\n",
 "Gentlemen,  I have made changes to the consolidation agreement, which I hope all will  find acceptable:    (It does need a date or two.)\nAs for the termination agreement, here's what I suggest:    Do we want to address the purchaser's parent guaranty in both of the  contracts, or just the consolidation agreement?\nI would suggest that we make  the guaranty a deliverable 30 days after execution of the contracts, which  gives us time to get the Mitsui assignment done, as we expect to assign the  contracts immediately.\nThat way, Mitsui can provide the guaranty, if  necessary.\nIf ENA does provide the guaranty, we would want to have the  ability to have it replaced with a suitable substitute guaranty from Mitsui.\nSorry I missed your call.\nIt was a day of meetings.\nI will be on the road  tomorrow, but will check my voice mail.\nKay\n",
 "How about meeting in advance of tomorrow's 130 phone call to discuss the  approach we want to take with GE?\nI'm suggesting 400 this afternoon.\nPlease let me know how this works for you.\nThanks,\n",
 "How close did I get?\n10.2 Effect of Force Majeure.\nIn the event of a Force Majeure event=20 affecting Seller=01,s ability to Deliver Scheduled Energy from the Facility= , the=20 following shall occur: =20 (a) Seller shall as soon as reasonably practicable use commercially=20 reasonable efforts to fulfill its obligations to deliver Scheduled Energy= =20 from Market Sources until notice is provided pursuant to Section 10.2(b)=20 below.\ndo we want to delete this?\nGary didn't seem to like it.\n(b) Not later than ten (10) Days following the onset of the Force Majeure= =20 event, Seller shall (i) issue a notice to Buyer stating whether Seller will= =20 continue to fulfill its obligations to Buyer hereunder from Market Sources= =20 until the Force Majeure event is terminated or (ii) declare Force Majeure a= nd=20 relieve Buyer from its obligation to pay the Demand Charge during the time= =20 that Seller is unable to meet its obligations hereunder, computed on a dail= y=20 basis.\nIf Buyer does not Schedule Energy during the ten (10) day evaluatio= n=20 period and Seller declares Force Majuere, then  Buyer=01,s relief of the=20 obligation to pay the Demand Charge shall commence as of the date of the=20 Force Majeure event.\n(c) If, during the ten (10) day evaluation period referenced above, Buyer= =20 Schedules Energy and Seller continues to Deliver Energy, but then declares= =20 Force Majeure, Buyer=01,s relief from the obligation to pay the Demand Char= ge=20 shall commence on the date of the declaration of Force Majeure and not on t= he=20 date of onset of the Force Majeure event.\nIf, during the ten (10) day=20 evaluation period Buyer Schedules Energy and Seller initially Delivers Ener= gy=20 but subsequently fails to Deliver, Buyer shall be relieved of the obligatio= n=20 to pay the Demand Charge from the date Seller fails to Deliver Energy, and= =20 not on the date of onset of the Force Majeure event.\nSuch relief from the= =20 Demand Charge shall be computed on a daily basis.\n=20 In the event of a Force Majeure affecting Buyer=01,s ability to receive Ene= rgy=20 from Seller, payment of the Demand Charge shall continue.\n10.3 Termination Due to Force Majeure.\nIf an event of Force Majeure continu= es=20 in effect for twelve (12) consecutive Months, then the Party not declaring= =20 Force Majeure may terminate this Agreement upon providing written notice of= =20 such termination to the other Party (but if such event of Force  Majeure=20 terminates before any such termination notice is provided, then this=20 Agreement shall continue in full force and effect).\n",
 "I still have to fix the liquidated damages/termination stuff, but here's a  redline for you to look at.\nI picked up the comments from others (Terry,  Christi) and these should be lined as well.\nI should be done soon.\n",
 "Mike,  Here's a revised version of the option agreement.\nI changed the shipping  dates, quantity (10), Outside Exercise Date, and the amount of the option  payment.\nI did not change the prices, since I had not discussed this with  Ben, and couldn't get the numbers to work.\nHave there been some changes to the data sheets?\nIt appears to me that there  might be a version which reflects the inclusion of the low sound option.\nIn  the last draft we did not include the low sound option because the impact on  the load losses had not been agreed, so the prices did not reflect the option.\nPlease call or email me if you have any questions or comments.\nKay\n",
 "Here's the latest revision inserting the drawing numbers.\nIs it ready to go  to GE?\nScott, payment for change orders is addressed in the contract.\n",
 "Hi Scott,  Here's a revised draft for your review and comment.\nI've taken out the  balance of plant warranty because you raised a valid point about them knowing  what BOP entails.\nSo now it is just a warranty.\nI've also been more explicit  about our fee.\nI think there's a bit of confusion embedded in the document because of the  uncertainty about who is doing what, but I haven't come up with a simple fix  yet.\n",
 "Kent,  Here's a revised letter agreement.\nIt is being reviewed internally, but I  wanted to get it to you today anyway, as I will be out of the office  beginning tomorrow around 1100.\nKay\n",
 'Hi Ben,  Janet has requested that we set you up with signature authority for  development documents.\nHow do you want you name to read on the corporate  documents?\nThanks,\n',
 'We are getting ready for the launch of "NetcoOnline" and have been preparing new documentation, a refreshed site design and cleaned products to reflect our Gas and Power focus.\nThe following timetable could change, but the general sequence should apply in any case:  Week of Jan 14:  Upon approval by the new buyer of the PA and ETA formats, we will contact the Master Users at our Top 50 customers and send them copies of the final PA and ETA forms with our new buyer\'s name filled in.\nDuring this week, we will be working hard to get as many of the PA\'s returned as possible.\nOnce we have an approved PA, we can send the customer their new User ID, which will allow them to start trading on the day we launch "NetCoOnline".\nA Splash page will be available within two business days of knowing our new company name, on a web page reached via an automatic redirect from www.enrononline.com.\nThis page will tell customers about the pending launch of "NetCoOnline" and provide links to the PA and Registration screens and also to the User Admin screens, which will allow customer Master Users to start setting up their Sub users.\nThe Splash page will look something like the following:      A Press Release will be issued which will include the planned launch date of "NetcoOnline"  Week of Jan. 21:  If all goes well, "NetcoOnline" will be launched on Tuesday, January 22, with at least financial products (timing for gas physical and power physical to be determined according to regulatory issues).\nWe will send out a mass mailing to approx.\n3,000 individuals at 450 companies inviting them to sign up for NetcoOnline.\nIncluded in the package will be a simple brochure, copies of the PA and ETA, key messages and a list of Frequently Asked Questions.\nGeneral Terms and Conditions (GTC\'s) will be available online and must be accepted online before a company can start to trade a particular commodity.\nTrading/Origination Coordination  Certain individuals in the Trading and Origination groups will be contacting customers on our Top 50 list to introduce the new company and begin the process of getting signed PA\'s.\nThe NetcoOnline marketing team will work with Trading and Origination groups to make sure that all Master Users that previously had EnronOnline North American Gas and Power execution rights are contacted within one week of the PA and ETA being approved by the new buyer.\nNetcoOnline Marketing will follow up with the Master Users to make sure PA\'s are signed and returned.\nNetcoOnline Marketing Contacts:  For Marketing-specific questions, please use the following contacts.\nFor other questions, please contact Bob Shults (30397) or Dave Forster (31861).\nTeresa Mandola (39807) - Power Kara Boudreau (30570) - Gas Jennifer McQuade (53614) - Power Dan Diamond (39673) - Gas   Definitions: \t Password Application (PA) - Only document where a physical signature is required  by an authorized person (Master User)  Electronic Trading Agreement (ETA) - Must be accepted online by the Master User before they can proceed into NetcoOnline  Master User - Typically the company authorized signatory that signed the Password Application.\nEstablishes transaction rights for each trader (sub-users)  Sub-User - Trader, assigned either execute or read only status   General Terms & Conditions (GTC) - Document that governs online trades unless a Master Agreement is in place  Master Agreement - Document that governs online and offline trades and supersedes the GTC\n',
 'There is a potential that counterparties will allow us to promote a small group of individuals simultaneous to deal closure.\nTo facilitate that process, please provide a list of those individuals you would like to promote along with a brief explanation to your HR generalist no later than 12:00 pm on Thursday, January 10, 2002.\nPlease keep in mind that the nominee should have been in his or her current role for at least a year and received a 3 or better rating during the mid-year PRC process.\nListed below are your HR contacts.\nGas Trading and Gas Origination\t\t\t\t\tJeanie Slone Power Trading and Origination/EOL\t\t\t\tAmy FitzPatrick Tax/Accounting/Legal/Credit/Treasury/IT Infrastructure\t\tSarah Zarkowsky IT Development\t\t\t\t\t\t\tMandy Curless GRA/Weather\t\t\t\t\t\t\tAnne Labbe Settlements/Risk/Volume Management/Document/Energy Ops\tTana Cashion  Your HR representative will be contacting you in the next day to review your employee lists as well as discuss any promotions.\n',
 "This is a reminder that the ect.enron.com,ei.enron.com,and ees.enron.com Email domains will be decommissioned by close of business Friday, January 18th.\nIf you currently use an Email address of name@ect.enron.com, name@ei.enron.com or name@ees.enron.com, you will need to notify your contacts to send mail to you at firstname.lastname@enron.com.\nThis is the first step of several to standardize everyone's Email address to firstname.lastname@enron.com.\nIf you have questions regarding this email, send an Email to enron.messaging.administration@enron.com.\nThank you for participation, cooperation and support.\nEnron Messaging Administration\n",
 'The following file contains a graphical view of the North American Gas average deal count by Trader and Product for EOL.\nThis information is for comparative analysis only.\nDo not update links when opening this file.\nIf you have any questions regarding this breakout, please let me know .\nThanks,\n',
 'Tom,   I have included the information that I received from the potential candidates regarding their Roll-off Dates.\nBy in large, all seem to be willing to be flexible with regards to a start date if it could be negotiated with their current rotational head.\nName                                           Roll-off  Date                                                 Notes          Cornett, Justin                               June                                                               N/A Feitler, Eric                                   August                                                            N/A Jacobellis, Steven                          End of July/Start of August                               N/A Khoja, Ali                                      Mid June                                                         Considering an option to stay with EBS as a Manager, but would entertain                                                                                                                           an opportunity in the Texas Gas Trading area.\nSingh, Inderpal                              June                                                                Technically finished with his current rotation, but in the midst of a deal scheduled                                                                                                                            to close the third week of June.\nWilliams, Bryan                            Start of July                                                       N/A   Regards,\n',
 "REUTERS TO PROVIDE ITS CUSTOMERS WITH ENRONONLINE REAL-TIME QUOTES  Effective June 4, 2001, Reuters has launched a new EnronOnline Real-Time Quotes service benefiting commodity traders and industry analysts.\nSubscribers to this service will be able to view bids, offers and midpoints as well as high, low and closing midpoint and change from previous day indications for numerous commodity products available on EnronOnline.\nSubscribers will be able to integrate EnronOnline Real-Time Quotes with Reuters' news, data and analytical tools to view real-time prices and charts as well as create option models, position reports and other analysis.\nInitially, the  quotes will be available for power, natural gas, crude oil and refined products, metals, bandwidth, coal, seafreight, emission allowances and weather derivatives markets in North America and Europe.\nFor more information, visit www.reuters.com/enrononlinequotes or call Reuters at 1-800-226-3955.\nPlease forward this e-mail to others who may benefit from this service.\nDisclaimer All prices presented by Reuters through the EnronOnline Real-Time Quotes service shall not constitute or be deemed, for any purposes, to be an offer by EnronOnline or Enron to enter into any transaction on those or any other terms, and are not available through or deemed to be an offer within any trading products that may be offered by Reuters in association with the EnronOnline Real-Time Quotes service.\nAny use of the EnronOnline.com website is expressly subject to the terms and conditions contained within the EnronOnline.com website, including the registration process detailed therein.\nBy presenting this information within the Reuters site, EnronOnline.com is not representing or indicating automatic qualification for access to or use of the EnronOnline.com website for commodity trading.\n",
 "Dear Subscriber:   In our continuous commitment to enhance the services we offer you, Factiva is proud to announce the expanded availability of the Financial Times (FT).\nCommencing June 16, the full text from all editions of the FT, including FT.com, will be accessible to all Publications Library and CustomClips customers.\nThe FT will continue to be unavailable in Business Newsstand.\nThe rollout of the full text of the FT complements Factiva's compelling content set of top must-read global business sources including The Wall Street Journal and Dow Jones, Reuters and AP Newswires.\nIn addition, this unique source combination will be offered at launch in Factiva.com, our new flagship product.\nThe full text will replace the FT Abstracts.\nIn order to provide you with uninterrupted coverage, the full text of all articles from June 1 on will be made available.\nThe FT abstract archive to date will continue to be accessible to you as well.\nThis change will require no action on your part.\nThe full text of the FT will have the same source codes that were previously applied to the FT Abstracts.\nThis means your CustomClips folders and saved searches will automatically get this expanded content - and it will be available on day of publication to provide you with the most up-to-date global business information.\nIf you have any questions, please contact your account executive.\nRegards,\n",
 'Due to a variety of circumstances we did not migrate employees to the UBSWE environment tonight (Monday, February 4, 2002).\nWe will communicate further details of the migration plan on Tuesday, February 5, 2002.\nThank you for your cooperation in advance, please contact the Resolution Center at x 3-1411 should you have any questions.\nUBSW Energy Global Infrastructure\n',
 "Tom, does your group have any dealings with Acacia Natural Gas?\nIt's a Texas intrastate owned by Mitchell.\nThey have made a filing for approval of Section 311 rates for interruptible service and they have set up their Operating Conditions so their affiliate will get higher priority over other parties who are paying the same rate (priority within the same rate will be based on whoever has the earliest transportation agreement).\nWould appreciate hearing from you in the next day or so.\nComments are due on the filing by Nov. 7th, and if we want to protest, we'll have to get our facts together.\nThanks.\n",
 'All  A reminder that you are scheduled to interview for the Trading Track Thursday,  November 1st, from 2.00 pm onwards.\nResumes and schedules will be forwarded to you shortly.\nRegards,\n',
 'Our natural gas business continues to benefit from effective account management and resource allocation focused on identifying and responding to the needs of our varied customers.\nIn order to keep our organization optimally structured and to facilitate additional growth, we are making the following changes:  Producer/Wellhead Group  The current mid-market, origination and wellhead pricing activity currently within the Central and Eastern Gas Regions will be consolidated with the Derivatives group under Fred Lagrasta.\nThis will create a single business unit focused upon the needs of the producing industry within the Eastern U.S.\nThe producer focus in the Western U.S. and Texas will remain unchanged reporting  to Mark Whitt and Brian Redmond respectively.\nStrategic Asset  Development Laura Luce will move from her role in the Central Region to lead an effort focused strictly on identifying and entering into long-term strategic arrangements within the Central and Eastern Regions.\nThis initiative will focus on a limited number of selected markets that provide strategic opportunities for partnering in asset development, asset management and optimization.\nThis effort will continue to work very closely with the regional leads.\nCentral Origination and Mid-Market Frank Vickers will continue his current role in the Eastern Region and will assume the leadership role for Mid-Market and Origination activity in the Central Region.\nThere will be no changes to the West and Texas Origination groups headed respectively by Barry Tycholiz and Brian Redmond.\nPlease join us in congratulating Fred, Laura and Frank in their new roles.\nLouise & John\n',
 'We are continuing work to ensure our new online trading system, UBSWenergy, is ready for launch on the week of Feb. 11, which is the week following the anticipated Enron/UBS Closing Date of Friday, Feb. 8.\nTo assist in this process, we are planning an online trading simulation for Thursday, February 7 from  0900 to 1100 (CST).\nIt is planned to include all  traders, originators, mid/back-office staff and IT teams who would normally be involved with electronic trading.\nPurpose of the simulation - The simulation will test our "live" trading environment (restricted to internal access only) and will:  Test the integrity and functionality of the system and related processes (including credit, risk, legal, operations, etc.)\nProvide an opportunity for traders to verify their products and product setup Demonstrate how the trading system and processes work to UBS staff visiting next week  Nature of the simulation - The simulation will include testing of all processes related to trading and mid/back-office functions:  Credit, Legal, Risk, Operations, and other groups: Profile tests for "external" customers (role-played by Originators) Profile tests for internal users (traders, back-office, etc.)\nData and Process checking as completed transactions flow through Mid/back-Office systems  Traders and Originators: Traders will be managing their individual books and associated products.\nAlthough we may be restricted to certain financial products on launch day, both physical and financial will be available during the simulation.\nEach trader will be asked to manage their individual position and profitability goals for the simulation.\nOriginators and others will be asked to play the roles of counterparties.\nCredit limits, etc.\nwill be tested during the simulation.\nInformation Technology: Will assist in preparing data on the system for the simulation.\nAfter the simulation is over, will work with the relevant groups to test the trade-data in various systems and risk books Will ensure all simulation data is removed from the system after the simulation is complete.\nNext steps   Traders and Originators will be contacted prior to simulation day to ensure they have appropriate access to the system.\nOriginators will be assigned specific roles.\nYou should expect to receive an email and/or handout on or before Wednesday, Feb. 6.\nUBSWenergy personnel will be meeting with back office personnel over the next several days to ensure everything is in place for the simulation.\nSummary  This simulation is an important step towards re-launching our trading business.\nWe appreciate the participation of everyone involved as we prepare for the public launch of UBS Warburg Energy and the UBSWenergy trading platform.\nIf you have any questions, comments, suggestions, or ideas regarding this simulation, please feel free to contact Bob Shults (30397) or myself (31861).\nRegards,\n',
 'The following reports have been waiting for your approval for more than 4 days.\nPlease review.\nOwner: V. Charles Weldon Report Name: CWeldon 101901 Days In Mgr.\nQueue: 4\n',
 'When: Thursday, October 18, 2001 9:00 AM-11:00 AM (GMT-06:00) Central Time (US & Canada).\nWhere: EB 30C1  *~*~*~*~*~*~*~*~*~*  On behalf of Linda Roberts,  \tA meeting has been scheduled to discuss Texas General Land Office Management Proposal.\nThis meeting will take place as follows: \t\t\t\t\t\t \t\t\t\t\t\tThursday, October 18, 2001 \t\t\t\t\t              9:00 AM - 11:00 AM \t\t\t\t\t\t\tEnron Corp. \t\t\t\t\t\t\t1400 Smith \t\t\t\t\t\t  Houston, TX  77002 \t\t\t\t\t\t              EB 30C1  \tIf you have any questions, please contact Linda Roberts @ (713) 345-4972.\nThank you,\n',
 'Please plan to attend the Enron Americas Staff Meeting with Louise and John on Tuesday, October 16th.\nThe details are listed below:  Time:\t\t4:00-5:00 p.m.\nLocation:\tEB30C1\n',
 'Eric, Jon, Andy, Matt, Frank & Dutch, You have been selected by Lavorato to review and validate gas curves for your region from 12/01/01 forward.\nYou will soon receive an announcement about a meeting which will take place Monday, February 4th at 10:00 AM.\nAt the meeting you will get instructions from representatives of Price Waterhouse Coopers about the validation process and the timing.\nIf you cannot make it, please get with Lavorato to decide who should attend in your absence.\nIf you have any questions, please ask.\nRegards,\n',
 "Happy New Year from Inside FERC,  Monday (Dec. 31) is the last business day of 2001, and it's the final deadline for Inside FERC's Gas Market Report's January 2002 bidweek spot-price survey.\n* * * PLEASE NOTE THAT THE KDOOL@MH.COM E-MAIL ADDRESS IS NOW DEFUNCT.\nALL E-MAIL SENT TO IT WILL BE LOST.\nPLEASE CHANGE YOUR ADDRESS BOOKS TO Kelley_Doolan@platts.com.\n* * *  If you are done with your January business today (Friday, Dec. 28), feel free to send your final prices today before the close of business.\nAttached is an Excel workbook (IFMONTH2.XLS) to report your price data in.\nPlease take a moment to review the instructions at the top of the file.\nThey specify what kinds of deals to report and -- more importantly -- what deals\n",
 "FOLLOW ME TO FINANCIAL FREEDOM!!\nI Am looking for people with good work ethics and extrordinary desire to earn at least $10,000 per month working from home!\nNO SPECIAL SKILLS OR EXPERIENCE REQUIRED.\nWe will give you all the training and personal support you will need to ensure your success!\nThis LEGITIMATE HOME-BASED INCOME OPPORTUNITY can put you back in control of your time, your finances, and your life!\nIf you've tried other opportunities in the past that have failed to live up their promises, THIS IS DIFFERENT THEN ANYTHING ELSE YOU'VE SEEN!\nTHIS IS NOT A GET RICH QUICK SCHEME!\nYOUR FINANCIAL PAST DOES NOT HAVE TO BE YOUR FINANCIAL FUTURE!\n",
 'In order for UBS Warburg to timely process your paycheck, I am requesting that all employee\'s accepting offers return any outstanding forms to my new desk location at  05852 on the 5th floor of ECS (Look for the Hamburg Flag) by noon this Friday  2/01/02.\nThis will prevent any benefit deductions from having to be "Double Deducted" on future checks.\nPlease attach a deposit slip or voided check stub to your direct deposit form.\nAttached below are the forms needed for payroll/benefits, in case you did not turn these in at Orientation.\nLastly, please verify that your EHRonline home address is showing your current home address because all live checks will be mailed to your home residence.\nThanks, Tony Jarrett\n',
 'Per our phone conversation, I have verified that David Baumbach and Michael Olsen are included in the Energy Operations headcount.\nLaura is reserving a conference room on February 6th for our plan meeting.\nThanks\n',
 'Here is the change to get Texas power and gas closer together.\nThe change is to give gas seats 369-385 (16 seats) and power trading and gas/power marketing to take over seats 670-690 (17 seats).\nLet me know if there is a problem.\n- Mike\n',
 'Tom -  (Not sure if this is the same number that you were already given....)  Per our payroll group, they recommended you call 1-800-332-7979 option 3.\nThey should be able to assist with your question on 1099R form.\nKind regards -\n',
 'UBS will be holding benefits presentations at 2:00 pm, 3:00 pm and 4:00 pm today in ECS06980.\nPlease encourage your employees to attend if they did not attend on Friday.\nAny questions, please let me or Jeanie know.\nA\n',
 'I am pleased to announce the following organizational changes within EGM Operations & Accounting effective immediately:  Todd Hall will be relocating to London and will assume responsibility for all EGM operational activities in London including Risk Management, Confirmations, Coordination & Settlements and Trade Accounting.\nTodd will be working closely with the EGM business unit heads in London to ensure their businesses are being supported in an effective and efficient manner.\nCindy Horn will assume the role of EGM IT & Remote Office Controller.\nShe will be responsible for the oversight and coordination of all IT projects affecting the Operations group.\nHer duties will include monitoring and reporting project timelines and expenses and ensuring IT is being utilized in the most cost-effective manner within Operations.\nCindy will also manage the operational activities of the Singapore and Tokyo offices and coordinate with the Sydney office in regards to EGM operations.\nMichelle Bruce will assume responsibility for Risk Management in the Houston office for Crude & Products, Coal and Weather.\nShe will also continue to manage the Confirmation, Coordination & Settlements and Trade Accounting functions in Houston.\nPlease join me in congratulating these individuals on their new assignments.\n',
 "This is a reminder that the ect.enron.com,ei.enron.com,and ees.enron.com Email domains will be decommissioned by close of business Friday, January 18th.\nIf you currently use an Email address of name@ect.enron.com, name@ei.enron.com or name@ees.enron.com, you will need to notify your contacts to send mail to you at firstname.lastname@enron.com.\nThis is the first step of several to standardize everyone's Email address to firstname.lastname@enron.com.\nIf you have questions regarding this email, send an Email to enron.messaging.administration@enron.com.\nThank you for participation, cooperation and support.\nEnron Messaging Administration\n",
 'The information contained herein is based on sources that we believe to be reliable, but we do not represent that it is accurate or complete.\nNothing contained herein should be considered as an offer to sell or a solicitation of an offer to buy any financial instruments discussed herein.\nAny opinions expressed herein are solely those of the author.\nAs such, they may differ in material respects from those of, or expressed or published by on behalf of Carr Futures or its officers, directors, employees or affiliates.\n?\n2001 Carr Futures   The charts are now in the most recent version of Adobe Acrobat 4.0 and they should print clearly from Adobe Acrobat Reader 3.0 or higher.\nAdobe Acrobat Reader 4.0 may be downloaded for FREE from www.adobe.com.\n(See attached file: APIMAIL.pdf)  (See attached file: TotalGasolineStocks.pdf)(See attached file: Padd I Gasoline Stocks.pdf)(See attached file: Padd II Crude Stocks.pdf)(See attached file: TotalCrudeStocks.pdf)(See attached file: TotalDistillateStocks.pdf)(See attached file: Padd I Distillate Stocks.pdf)  - APIMAIL.pdf   - TotalGasolineStocks.pdf   - Padd I Gasoline Stocks.pdf   - Padd II Crude Stocks.pdf   - TotalCrudeStocks.pdf   - TotalDistillateStocks.pdf   - Padd I Distillate Stocks.pdf\n',
 'Due to a variety of circumstances we did not migrate employees to the UBSWE environment tonight (Monday, February 4, 2002).\nWe will communicate further details of the migration plan on Tuesday, February 5, 2002.\nThank you for your cooperation in advance, please contact the Resolution Center at x 3-1411 should you have any questions.\nUBSW Energy Global Infrastructure\n',
 'We are continuing work to ensure our new online trading system, UBSWenergy, is ready for launch on the week of Feb. 11, which is the week following the anticipated Enron/UBS Closing Date of Friday, Feb. 8.\nTo assist in this process, we are planning an online trading simulation for Thursday, February 7 from  0900 to 1100 (CST).\nIt is planned to include all  traders, originators, mid/back-office staff and IT teams who would normally be involved with electronic trading.\nPurpose of the simulation - The simulation will test our "live" trading environment (restricted to internal access only) and will:  Test the integrity and functionality of the system and related processes (including credit, risk, legal, operations, etc.)\nProvide an opportunity for traders to verify their products and product setup Demonstrate how the trading system and processes work to UBS staff visiting next week  Nature of the simulation - The simulation will include testing of all processes related to trading and mid/back-office functions:  Credit, Legal, Risk, Operations, and other groups: Profile tests for "external" customers (role-played by Originators) Profile tests for internal users (traders, back-office, etc.)\nData and Process checking as completed transactions flow through Mid/back-Office systems  Traders and Originators: Traders will be managing their individual books and associated products.\nAlthough we may be restricted to certain financial products on launch day, both physical and financial will be available during the simulation.\nEach trader will be asked to manage their individual position and profitability goals for the simulation.\nOriginators and others will be asked to play the roles of counterparties.\nCredit limits, etc.\nwill be tested during the simulation.\nInformation Technology: Will assist in preparing data on the system for the simulation.\nAfter the simulation is over, will work with the relevant groups to test the trade-data in various systems and risk books Will ensure all simulation data is removed from the system after the simulation is complete.\nNext steps   Traders and Originators will be contacted prior to simulation day to ensure they have appropriate access to the system.\nOriginators will be assigned specific roles.\nYou should expect to receive an email and/or handout on or before Wednesday, Feb. 6.\nUBSWenergy personnel will be meeting with back office personnel over the next several days to ensure everything is in place for the simulation.\nSummary  This simulation is an important step towards re-launching our trading business.\nWe appreciate the participation of everyone involved as we prepare for the public launch of UBS Warburg Energy and the UBSWenergy trading platform.\nIf you have any questions, comments, suggestions, or ideas regarding this simulation, please feel free to contact Bob Shults (30397) or myself (31861).\nRegards,\n',
 'The decision to close the Body Shop came after the December 15 payroll run, so you will incur a deduction on your December 15 paycheck.\nHowever, Payroll will refund those charges on your December 31 paycheck.\nAs a reminder the Body Shop will be open from 8:00 a.m. - 5:00 p.m. today through Friday, December 14, to allow members to retrieve personal items from lockers.\nThank you.\n',
 'I had a great time working with the best option trading team in the energy industry.\nWhat I have learned from you will benefit me a lot in my future career.\nI will start looking for a new job.\nIf your friends in other trading house are looking for a junior trader, please let me know.\nDeep in my heart I want to be part of your team.\nCount me in when the new company starts hiring people.\nSincerely\n',
 'A virus has been detected in the Enron email environment.\nThe offending email has the following characteristics :  The SUBJECT is "Hi"  It contains the following text : How are you ?\nWhen I saw this screen saver, I immediately thought about you  I am in a harry, I promise you will love it!\nIt contains an attachment called "gone.scr" (41 KB) Please DO NOT launch the attachment (as this will launch the virus).\nDelete ALL occurances of this email from your mail box immediately.\nPlease note that opening/previewing the email does not launch the virus.\nFurthermore, it is absolutely against company policy to open any external (non-Enron) mail account from within the Enron environment.\nThis means that you should not open a browser from an Enron PC and go to any sites that offer Email services.\nWhen you do this, you are tracked and IT is aware of your actions.\nIn today\'s case, the virus that was launched caused a the entire global Email system to be shut down for about an hour and a half.\nIt is also against company policy to launch any attachments without saving it to your desktop first so that desktop virus scanning can take place.\nIf you did launch this virus, please call your Resolution Center/Help Desk and have your computer scanned.\nThank you for your assistance.\n',
 'Please review the home addresss and phone number shown on this eMail.\nDO NOT RESPOND if the information is correct.\nHowever, if incorrect then reply to this eMail with the correct information so you HR records can be updated accordingly.\nYour home information is important in case the Company needs to forward critical materials to you or contact you regarding important Company information.\n',
 'Many of you have asked whether you should come into the office next week, especially if there is no guarantee of being paid for time worked after today.\nWe want to encourage you to come to work.\nWe continue to consider every option available to us as a company; and unfortunately, restructuring through bankruptcy is one of those options.\nYour continued efforts during these trying times are critical to the company as we go through this decision making process.\nI still cannot say with certainty if or when we will file for bankruptcy.\nBut you should be aware that, in general, the bankruptcy code provides protection for employee salaries and wages earned within 90 days of a petition filing to the extent of $4,650 per employee.\nI want you to know that if we file a bankruptcy petition, we intend to seek approval by the bankruptcy court to exercise that protection immediately and pay you for your time worked prior to any petition filing according to our regular payroll practices.\nAdditionally, Enron would be obligated and will pay salaries and wages earned after a bankruptcy filing.\nFor Enron, where our value is directly tied to our employees, making sure that we meet these obligations will be a high priority.\nWe are continuing to evaluate the ongoing resource needs of the company for each potential option we might pursue.\nOf course, until we finalize those business decisions, we cannot make that determination.\nI know that this prolonged process is agonizing for you.\nI can only continue to assure you that we will notify you of your employment status as soon as we are able to do so.\nWhile terminated employees will tap into their own network of contacts as they look for new employment, we hope to do what we can to assist them.\nWe will tap into the contacts we have as a company to aid terminated employees in their job search.\nWe have already been in touch with several employers and many are interested in Enron alumni.\nWe will share more information on these efforts soon.\nI appreciate your continued patience and cooperation.\nKen\n',
 'Dwarf Sues to Overturn Dwarf-Tossing Ban=09=09=09=09  =09=09=09=09 November 29, 2001 10:51 AM ET =09=09=09=09 TAMPA, Fla. (Reuters) - A radio broadcaster known as "Dave the Dwarf" has s= ued to overturn Florida\'s ban on "dwarf tossing," saying he should be allow= ed to decide for himself whether to participate in the barroom contests.\n"= Dwarf tossing" is a contest in which dwarfs don harnesses and allow bar pat= rons to hurl them through the air onto mattresses.\nFlorida banned it in 19= 89 amid intense lobbying from the advocacy group Little People of America, = which said the contests were demeaning and encouraged people to treat dwarf= s as objects.\nBars that allow the contests can be stripped of their liquor = licenses.\nDavid Flood, a dwarf who is 38 inches (96.5 cm) tall, filed suit=  on Wednesday in U.S. District Court in Tampa, challenging the ban as uncon= stitutional.\nHe said it illegally singles out people with dwarfism.\n"As so= on as you have a physical handicap ... all of the sudden they treat you lik= e you don\'t have a mind of your own," Flood told the Tampa Tribune.\n"Just b= ecause I\'m 3-foot-2 doesn\'t mean I can\'t make decisions."\nFlood, 37, works=  as "Dave the Dwarf" on the morning radio show on Tampa station WFLZ.\n=09= =09=09=09\n',
 '=                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                    IntercontinentalExchange                =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                             =20                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                    Firm Physical Natural Gas Price Bulletin                =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                             =20                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                    For Natural Gas Delivered on Thursday, November  29, 200= 1                                                                          =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                   =20                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                    (Trade Date of Wednesday, November  28, = 2001)                                                                      =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                           =20 Click here to access index history .\n=                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                     =20                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                    * volume represents sell-side only *    =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                                                                            =                           =20 Region     HubHighLowWtd Avg IndexChange ($)Vol (mmBtu)Hub Name LOUISIANA     ANR SE          $2.4200          $2.2800          $2.3548+    .4895    =      228,200American Natural Resources Pipeline Co. - SE  Transmission Pool=     Columbia Onshore          $2.4400          $2.2600          $2.3683+   =  .6257         267,600Columbia Gulf Transmission Co. - Onshore Pool     Hen= ry Hub          $2.5500          $1.9750          $2.3571+    .4581       1= ,044,800Henry Hub tailgate - Louisiana     NGPL LA          $2.5000        =   $2.2700          $2.3806+    .4607         210,500Natural Gas Pipeline Co= .\nof America, Louisiana Pool     Tenn 500L          $2.3900          $2.110= 0          $2.2778+    .4366         251,400Tennessee Gas Pipeline Co.-Zone=  L, 500 Leg Pool     Tenn 800L          $2.3800          $2.1100          $= 2.2764+    .5072         197,800Tennessee Gas Pipeline Co.-Zone L, 800 Leg = Pool     TETCO ELA          $2.4000          $2.2500          $2.3196+    .= 4865         249,100Texas Eastern - East LA     TETCO WLA          $2.3600 =          $2.1200          $2.3047+    .4824         169,400Texas Eastern - = West LA     Transco 65          $2.4025          $2.1200          $2.2974+ =    .4937         375,600Transco - Station 65     Trunkline ELA          $2.= 4100          $2.3000          $2.3509+    .5316          54,500Trunkline G= as Company - East Louisiana Pool     TxGas SL          $2.4400          $2.= 0050          $2.3463+    .5026         185,400Texas Gas Transmission Corp.=\n',
 ...]
>>> enron_emails['test']['email_body'][0]
"Phillip,   Could you please do me a favor?\nI would like  to read your current title policy to see what it says about easements.\nYou  should have received a copy during your closing.\nI don't know how many  pages it will be but let me know how you want to handle getting a copy  made.\nI'll be happy to make the copy, or whatever makes it easy for  you.\nThanks,\n"
>>> print(enron_emails['test']['email_body'][0])
>>> print(enron_emails['test'].columns)
>>> print(enron_emails['test'].data.columns)
>>> enron_emails['test'].data.column_names
['email_body', 'subject_line']
>>> %run ch08/rnn_from_scratch_name_nationality.py
>>> from nlpia2.string_normalizers import *
>>> hist -o -p
>>> hist -o -p -f ch08/hh_datasets_descriptions_email.hist.md
```
