>>> ls -hal
>>> ls models
>>> ls -hal models
>>> rm models/model_epochs_12_rnn_type_GRU_hidden_size_200_batch_size_20_bptt_35_num_layers_2
>>> import torch
>>> torch.load('models/model_epochs_12_rnn_type_GRU_hidden_size_200_batch_size_20_bptt_35_num_layers_1')
>>> torch.load('models/model_epochs_12_rnn_type_GRU_hidden_size_200_batch_size_20_bptt_35_num_layers_1', map_location=torch.device('cpu'))
RNNModel(
  (drop): Dropout(p=0.5, inplace=False)
  (encoder): Embedding(33278, 200)
  (rnn): GRU(200, 200, dropout=0.5)
  (decoder): Linear(in_features=200, out_features=33278, bias=True)
)
>>> model = _
>>> more generate.py
>>> import argparse
... import torch
... 
... import data
...
>>>     args = parse_args()
...     corpus = data.Corpus(args.data)
... 
...     token_id = corpus.dictionary(args.prompt) if args.prompt else torch.randint
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cuda" if args.cuda else "cpu")
... 
...     with open(args.checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...     model.eval()
...
>>>     corpus = data.Corpus(args.data)
... 
...     token_id = corpus.dictionary(args.prompt) if args.prompt else torch.randint
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cuda" if args.cuda else "cpu")
... 
...     with open(args.checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus(args.data)
... 
...     prompt = ''
...     token_id = corpus.dictionary(prompt) if prompt else torch.randint(len(corpus.dicitonary))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cuda" if args.cuda else "cpu")
... 
...     with open(args.checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus(args.data)
... 
...     prompt = ''
...     token_id = corpus.dictionary(prompt) if prompt else torch.randint(len(corpus.dicitonary))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>> checkpoint = 'models/model_epochs_12_rnn_type_GRU_hidden_size_200_batch_size_20_bptt_35_num_layers_1'
>>> checkpoint
'models/model_epochs_12_rnn_type_GRU_hidden_size_200_batch_size_20_bptt_35_num_layers_1'
>>>     corpus = data.Corpus(args.data)
... 
...     prompt = ''
...     token_id = corpus.dictionary(prompt) if prompt else torch.randint(len(corpus.dicitonary))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus()
... 
...     prompt = ''
...     token_id = corpus.dictionary(prompt) if prompt else torch.randint(len(corpus.dicitonary))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus('data/wikitext-2')
... 
...     prompt = ''
...     token_id = corpus.dictionary(prompt) if prompt else torch.randint(len(corpus.dicitonary))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus('data/wikitext-2')
... 
...     prompt = ''
...     token_id = corpus.dictionary(prompt) if prompt else torch.randint(len(corpus.dictionary))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus('data/wikitext-2')
... 
...     prompt = ''
...     token_id = corpus.dictionary(prompt) if prompt else torch.randint(len(corpus.dictionary), size=(,))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus('data/wikitext-2')
... 
...     prompt = ''
...     token_id = corpus.dictionary(prompt) if prompt else torch.randint(len(corpus.dictionary), size=(1,))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(args.seed)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus('data/wikitext-2')
... 
...     prompt = 'Hello'
...     token_id = corpus.dictionary(prompt) if prompt else torch.randint(len(corpus.dictionary), size=(1,))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(1111)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>> corpus.dictionary.word2idx
{'<eos>': 0,
 '=': 1,
 'Valkyria': 2,
 'Chronicles': 3,
 'III': 4,
 'Senjō': 5,
 'no': 6,
 '3': 7,
 ':': 8,
 '<unk>': 9,
 '(': 10,
 'Japanese': 11,
 '戦場のヴァルキュリア3': 12,
 ',': 13,
 'lit': 14,
 '.': 15,
 'of': 16,
 'the': 17,
 'Battlefield': 18,
 ')': 19,
 'commonly': 20,
 'referred': 21,
 'to': 22,
 'as': 23,
 'outside': 24,
 'Japan': 25,
 'is': 26,
 'a': 27,
 'tactical': 28,
 'role': 29,
 '@-@': 30,
 'playing': 31,
 'video': 32,
 'game': 33,
 'developed': 34,
 'by': 35,
 'Sega': 36,
 'and': 37,
 'Media.Vision': 38,
 'for': 39,
 'PlayStation': 40,
 'Portable': 41,
 'Released': 42,
 'in': 43,
 'January': 44,
 '2011': 45,
 'it': 46,
 'third': 47,
 'series': 48,
 'same': 49,
 'fusion': 50,
 'real': 51,
 'time': 52,
 'gameplay': 53,
 'its': 54,
 'predecessors': 55,
 'story': 56,
 'runs': 57,
 'parallel': 58,
 'first': 59,
 'follows': 60,
 '"': 61,
 'Nameless': 62,
 'penal': 63,
 'military': 64,
 'unit': 65,
 'serving': 66,
 'nation': 67,
 'Gallia': 68,
 'during': 69,
 'Second': 70,
 'Europan': 71,
 'War': 72,
 'who': 73,
 'perform': 74,
 'secret': 75,
 'black': 76,
 'operations': 77,
 'are': 78,
 'pitted': 79,
 'against': 80,
 'Imperial': 81,
 'Raven': 82,
 'The': 83,
 'began': 84,
 'development': 85,
 '2010': 86,
 'carrying': 87,
 'over': 88,
 'large': 89,
 'portion': 90,
 'work': 91,
 'done': 92,
 'on': 93,
 'II': 94,
 'While': 95,
 'retained': 96,
 'standard': 97,
 'features': 98,
 'also': 99,
 'underwent': 100,
 'multiple': 101,
 'adjustments': 102,
 'such': 103,
 'making': 104,
 'more': 105,
 'newcomers': 106,
 'Character': 107,
 'designer': 108,
 'Honjou': 109,
 'composer': 110,
 'Hitoshi': 111,
 'Sakimoto': 112,
 'both': 113,
 'returned': 114,
 'from': 115,
 'previous': 116,
 'entries': 117,
 'along': 118,
 'with': 119,
 'director': 120,
 'Takeshi': 121,
 'Ozawa': 122,
 'A': 123,
 'team': 124,
 'writers': 125,
 'handled': 126,
 'script': 127,
 "'s": 128,
 'opening': 129,
 'theme': 130,
 'was': 131,
 'sung': 132,
 'May': 133,
 "'n": 134,
 'It': 135,
 'met': 136,
 'positive': 137,
 'sales': 138,
 'praised': 139,
 'western': 140,
 'critics': 141,
 'After': 142,
 'release': 143,
 'received': 144,
 'downloadable': 145,
 'content': 146,
 'an': 147,
 'expanded': 148,
 'edition': 149,
 'November': 150,
 'that': 151,
 'year': 152,
 'adapted': 153,
 'into': 154,
 'manga': 155,
 'original': 156,
 'animation': 157,
 'Due': 158,
 'low': 159,
 'not': 160,
 'localized': 161,
 'but': 162,
 'fan': 163,
 'translation': 164,
 'compatible': 165,
 'released': 166,
 '2014': 167,
 'would': 168,
 'return': 169,
 'franchise': 170,
 'Azure': 171,
 'Revolution': 172,
 '4': 173,
 'Gameplay': 174,
 'As': 175,
 'games': 176,
 'where': 177,
 'players': 178,
 'take': 179,
 'control': 180,
 'part': 181,
 'missions': 182,
 'enemy': 183,
 'forces': 184,
 'Stories': 185,
 'told': 186,
 'through': 187,
 'comic': 188,
 'book': 189,
 'like': 190,
 'panels': 191,
 'animated': 192,
 'character': 193,
 'portraits': 194,
 'characters': 195,
 'speaking': 196,
 'partially': 197,
 'voiced': 198,
 'speech': 199,
 'bubbles': 200,
 'text': 201,
 'player': 202,
 'progresses': 203,
 'linear': 204,
 'gradually': 205,
 'unlocked': 206,
 'maps': 207,
 'can': 208,
 'be': 209,
 'freely': 210,
 'replayed': 211,
 'they': 212,
 'route': 213,
 'each': 214,
 'location': 215,
 'map': 216,
 'varies': 217,
 'depending': 218,
 'individual': 219,
 'approach': 220,
 'when': 221,
 'one': 222,
 'option': 223,
 'selected': 224,
 'other': 225,
 'sealed': 226,
 'off': 227,
 'Outside': 228,
 'rest': 229,
 'camp': 230,
 'units': 231,
 'customized': 232,
 'growth': 233,
 'occurs': 234,
 'Alongside': 235,
 'main': 236,
 'specific': 237,
 'sub': 238,
 'relating': 239,
 'different': 240,
 'squad': 241,
 'members': 242,
 'completion': 243,
 'additional': 244,
 'episodes': 245,
 'some': 246,
 'them': 247,
 'having': 248,
 'higher': 249,
 'difficulty': 250,
 'than': 251,
 'those': 252,
 'found': 253,
 'There': 254,
 'love': 255,
 'simulation': 256,
 'elements': 257,
 'related': 258,
 'two': 259,
 'although': 260,
 'very': 261,
 'minor': 262,
 'battle': 263,
 'system': 264,
 'carried': 265,
 'directly': 266,
 'During': 267,
 'select': 268,
 'using': 269,
 'top': 270,
 'down': 271,
 'perspective': 272,
 'battlefield': 273,
 'once': 274,
 'moves': 275,
 'around': 276,
 'person': 277,
 'only': 278,
 'act': 279,
 'per': 280,
 'turn': 281,
 'granted': 282,
 'turns': 283,
 'at': 284,
 'expense': 285,
 "'": 286,
 'Each': 287,
 'has': 288,
 'field': 289,
 'distance': 290,
 'movement': 291,
 'limited': 292,
 'their': 293,
 'Action': 294,
 'Up': 295,
 'nine': 296,
 'assigned': 297,
 'single': 298,
 'mission': 299,
 'will': 300,
 'call': 301,
 'out': 302,
 'if': 303,
 'something': 304,
 'happens': 305,
 'health': 306,
 'points': 307,
 'HP': 308,
 'getting': 309,
 'or': 310,
 'being': 311,
 'knocked': 312,
 'attacks': 313,
 'Potentials': 314,
 'skills': 315,
 'unique': 316,
 'They': 317,
 'divided': 318,
 'Personal': 319,
 'Potential': 320,
 'which': 321,
 'innate': 322,
 'remain': 323,
 'unaltered': 324,
 'unless': 325,
 'otherwise': 326,
 'dictated': 327,
 'either': 328,
 'help': 329,
 'impede': 330,
 'Battle': 331,
 'grown': 332,
 'throughout': 333,
 'always': 334,
 'grant': 335,
 'To': 336,
 'learn': 337,
 'Masters': 338,
 'Table': 339,
 'grid': 340,
 'based': 341,
 'skill': 342,
 'table': 343,
 'used': 344,
 'acquire': 345,
 'link': 346,
 'Characters': 347,
 'have': 348,
 'Special': 349,
 'temporary': 350,
 'Kurt': 351,
 'activate': 352,
 'Direct': 353,
 'Command': 354,
 'move': 355,
 'without': 356,
 'his': 357,
 'Point': 358,
 'gauge': 359,
 'shift': 360,
 'her': 361,
 'Form': 362,
 'become': 363,
 'while': 364,
 'Imca': 365,
 'target': 366,
 'heavy': 367,
 'weapon': 368,
 'Troops': 369,
 'five': 370,
 'classes': 371,
 'Scouts': 372,
 'Engineers': 373,
 'Armored': 374,
 'Soldier': 375,
 'switch': 376,
 'changing': 377,
 'Changing': 378,
 'class': 379,
 'does': 380,
 'greatly': 381,
 'affect': 382,
 'stats': 383,
 'gained': 384,
 'With': 385,
 'victory': 386,
 'experience': 387,
 'awarded': 388,
 'distributed': 389,
 'attributes': 390,
 'shared': 391,
 'entire': 392,
 'feature': 393,
 'differing': 394,
 'early': 395,
 'method': 396,
 'distributing': 397,
 'types': 398,
 'Plot': 399,
 'takes': 400,
 'place': 401,
 'Gallian': 402,
 'Army': 403,
 'Squad': 404,
 '422': 405,
 'known': 406,
 'composed': 407,
 'criminals': 408,
 'foreign': 409,
 'offenders': 410,
 'whose': 411,
 'names': 412,
 'erased': 413,
 'records': 414,
 'officially': 415,
 'numbers': 416,
 'most': 417,
 'dangerous': 418,
 'Regular': 419,
 'Militia': 420,
 'do': 421,
 'nevertheless': 422,
 'up': 423,
 'task': 424,
 'exemplified': 425,
 'motto': 426,
 'meaning': 427,
 'Always': 428,
 'Ready': 429,
 'three': 430,
 'Irving': 431,
 'army': 432,
 'officer': 433,
 'falsely': 434,
 'accused': 435,
 'treason': 436,
 'wishes': 437,
 'redeem': 438,
 'himself': 439,
 ';': 440,
 'Ace': 441,
 'female': 442,
 'Darcsen': 443,
 'weapons': 444,
 'specialist': 445,
 'seeks': 446,
 'revenge': 447,
 'destroyed': 448,
 'home': 449,
 'Riela': 450,
 'seemingly': 451,
 'young': 452,
 'woman': 453,
 'unknowingly': 454,
 'descendant': 455,
 'Together': 456,
 'fellow': 457,
 'these': 458,
 'tasked': 459,
 'fight': 460,
 'mysterious': 461,
 'Calamity': 462,
 'consisting': 463,
 'mostly': 464,
 'soldiers': 465,
 'exist': 466,
 'upper': 467,
 'echelons': 468,
 'exploit': 469,
 'concept': 470,
 'plausible': 471,
 'order': 472,
 'send': 473,
 'make': 474,
 'lose': 475,
 'face': 476,
 'war': 477,
 'times': 478,
 'this': 479,
 'works': 480,
 'advantage': 481,
 'successful': 482,
 'incursion': 483,
 'territory': 484,
 'orders': 485,
 'cause': 486,
 'certain': 487,
 '422nd': 488,
 'great': 489,
 'distress': 490,
 'One': 491,
 'member': 492,
 'becomes': 493,
 'so': 494,
 'enraged': 495,
 'he': 496,
 'abandons': 497,
 'post': 498,
 'defects': 499,
 'ranks': 500,
 'attached': 501,
 'ideal': 502,
 'independence': 503,
 'proposed': 504,
 'leader': 505,
 'Dahau': 506,
 'At': 507,
 'within': 508,
 'erase': 509,
 'protect': 510,
 'own': 511,
 'interests': 512,
 'allies': 513,
 'enemies': 514,
 'combined': 515,
 'presence': 516,
 'traitor': 517,
 'desperately': 518,
 'keep': 519,
 'themselves': 520,
 'alive': 521,
 'effort': 522,
 'This': 523,
 'continues': 524,
 'until': 525,
 'commanding': 526,
 'Ramsey': 527,
 'Crowe': 528,
 'had': 529,
 'been': 530,
 'kept': 531,
 'under': 532,
 'house': 533,
 'arrest': 534,
 'escorted': 535,
 'capital': 536,
 'city': 537,
 'present': 538,
 'evidence': 539,
 'weary': 540,
 'expose': 541,
 'General': 542,
 'Treason': 543,
 'due': 544,
 'events': 545,
 'partly': 546,
 'major': 547,
 'losses': 548,
 'manpower': 549,
 'suffers': 550,
 'towards': 551,
 'end': 552,
 'Empire': 553,
 'offered': 554,
 'formal': 555,
 'position': 556,
 'rather': 557,
 'serve': 558,
 'anonymous': 559,
 'shadow': 560,
 'force': 561,
 'short': 562,
 'lived': 563,
 'however': 564,
 'following': 565,
 'Maximilian': 566,
 'defeat': 567,
 'ancient': 568,
 'super': 569,
 'benefactor': 570,
 'Without': 571,
 'support': 572,
 'chance': 573,
 'prove': 574,
 'last': 575,
 'card': 576,
 'creating': 577,
 'new': 578,
 'armed': 579,
 'invading': 580,
 'just': 581,
 'nations': 582,
 'cease': 583,
 'fire': 584,
 'certainly': 585,
 'wreck': 586,
 'newfound': 587,
 'peace': 588,
 'decides': 589,
 'again': 590,
 'asking': 591,
 'list': 592,
 'all': 593,
 'command': 594,
 'killed': 595,
 'action': 596,
 'Now': 597,
 'owing': 598,
 'allegiance': 599,
 'none': 600,
 'confronts': 601,
 'destroys': 602,
 'then': 603,
 'goes': 604,
 'separate': 605,
 'ways': 606,
 'begin': 607,
 'lives': 608,
 'Development': 609,
 'Concept': 610,
 'after': 611,
 'finished': 612,
 'full': 613,
 'beginning': 614,
 'shortly': 615,
 'took': 616,
 'approximately': 617,
 'staff': 618,
 'look': 619,
 'popular': 620,
 'response': 621,
 'what': 622,
 'wanted': 623,
 'next': 624,
 'Like': 625,
 'predecessor': 626,
 'wanting': 627,
 'refine': 628,
 'mechanics': 629,
 'created': 630,
 'come': 631,
 'revolutionary': 632,
 'idea': 633,
 'warrant': 634,
 'entry': 635,
 'Speaking': 636,
 'interview': 637,
 'stated': 638,
 'considered': 639,
 'true': 640,
 'sequel': 641,
 'required': 642,
 'amount': 643,
 'trial': 644,
 'error': 645,
 'platform': 646,
 'gave': 647,
 'improve': 648,
 'upon': 649,
 'best': 650,
 'parts': 651,
 'In': 652,
 'addition': 653,
 'scenario': 654,
 'written': 655,
 'Hiroyuki': 656,
 'Its': 657,
 'darker': 658,
 'somber': 659,
 'majority': 660,
 'material': 661,
 'design': 662,
 'improvements': 663,
 'were': 664,
 'made': 665,
 'graphics': 666,
 'layouts': 667,
 'structure': 668,
 'number': 669,
 'playable': 670,
 'upgrade': 671,
 'involved': 672,
 'models': 673,
 'body': 674,
 'achieve': 675,
 'cooperative': 676,
 'incorporated': 677,
 'second': 678,
 'removed': 679,
 'memory': 680,
 'space': 681,
 'needed': 682,
 'adjusted': 683,
 'settings': 684,
 'ease': 685,
 'play': 686,
 'could': 687,
 'appeal': 688,
 'retaining': 689,
 'essential': 690,
 'components': 691,
 'newer': 692,
 'systems': 693,
 'decided': 694,
 'designs': 695,
 'worked': 696,
 'When': 697,
 'faced': 698,
 'problem': 699,
 'uniforms': 700,
 'essentially': 701,
 'individuality': 702,
 'despite': 703,
 'him': 704,
 'needing': 705,
 'create': 706,
 'identify': 707,
 'maintaining': 708,
 'sense': 709,
 'reality': 710,
 'world': 711,
 'color': 712,
 'engine': 713,
 'anime': 714,
 'produced': 715,
 'Production': 716,
 'I.G.': 717,
 'Music': 718,
 'music': 719,
 'originally': 720,
 'heard': 721,
 'about': 722,
 'project': 723,
 'thought': 724,
 'light': 725,
 'tone': 726,
 'similar': 727,
 'themes': 728,
 'much': 729,
 'expected': 730,
 'An': 731,
 'designed': 732,
 'vision': 733,
 'rejected': 734,
 'He': 735,
 'seven': 736,
 'production': 737,
 'need': 738,
 'initially': 739,
 'recorded': 740,
 'orchestra': 741,
 'guitar': 742,
 'bass': 743,
 'synthesizer': 744,
 'before': 745,
 'segments': 746,
 'piece': 747,
 'incorporating': 748,
 'hopeful': 749,
 'tune': 750,
 'played': 751,
 'ending': 752,
 'modern': 753,
 'divorced': 754,
 'fantasy': 755,
 'musical': 756,
 'instruments': 757,
 'constructed': 758,
 'working': 759,
 'synthesized': 760,
 'felt': 761,
 'incorporate': 762,
 'live': 763,
 'arranged': 764,
 'several': 765,
 'later': 766,
 'tracks': 767,
 'song': 768,
 'If': 769,
 'You': 770,
 'Wish': 771,
 '...': 772,
 'Kimi': 773,
 'singer': 774,
 'reason': 775,
 'fought': 776,
 'particular': 777,
 'wish': 778,
 'precious': 779,
 'responsibility': 780,
 'duty': 781,
 'lyrics': 782,
 'singles': 783,
 'Release': 784,
 'September': 785,
 'teaser': 786,
 'website': 787,
 'revealed': 788,
 'hinting': 789,
 'issue': 790,
 'Famitsu': 791,
 'listed': 792,
 'arriving': 793,
 'public': 794,
 'appearance': 795,
 'Tokyo': 796,
 'Game': 797,
 'Show': 798,
 'TGS': 799,
 'demo': 800,
 'available': 801,
 'journalists': 802,
 'attendees': 803,
 'publicity': 804,
 'details': 805,
 'too': 806,
 'potential': 807,
 'still': 808,
 'flux': 809,
 'reveal': 810,
 'promote': 811,
 'detail': 812,
 'leading': 813,
 'episodic': 814,
 'Flash': 815,
 'visual': 816,
 'novel': 817,
 '27': 818,
 'said': 819,
 'capacity': 820,
 'DLC': 821,
 'plans': 822,
 'finalized': 823,
 'Multiple': 824,
 'featuring': 825,
 'between': 826,
 'February': 827,
 'April': 828,
 'Extra': 829,
 'Edition': 830,
 '23': 831,
 'sold': 832,
 'lower': 833,
 'price': 834,
 'chosen': 835,
 'pre': 836,
 'bonus': 837,
 'People': 838,
 'owned': 839,
 'transfer': 840,
 'save': 841,
 'data': 842,
 'versions': 843,
 'Unlike': 844,
 'west': 845,
 'According': 846,
 'poor': 847,
 'general': 848,
 'unpopularity': 849,
 'PSP': 850,
 'unofficial': 851,
 'patch': 852,
 '2012': 853,
 'copy': 854,
 'download': 855,
 'apply': 856,
 'translated': 857,
 'English': 858,
 'Reception': 859,
 'On': 860,
 'day': 861,
 'topped': 862,
 'exclusive': 863,
 'multi': 864,
 'charts': 865,
 'By': 866,
 '102': 867,
 '@,@': 868,
 'coming': 869,
 'overall': 870,
 'Last': 871,
 'Story': 872,
 'Wii': 873,
 '152': 874,
 '500': 875,
 'enjoyed': 876,
 'particularly': 877,
 'pleased': 878,
 'gaming': 879,
 'site': 880,
 'Watch': 881,
 'negatively': 882,
 'noting': 883,
 'pacing': 884,
 'recycled': 885,
 'generally': 886,
 'entertaining': 887,
 'putting': 888,
 'spikes': 889,
 'writer': 890,
 'Play': 891,
 'Test': 892,
 'article': 893,
 'provided': 894,
 'profound': 895,
 'feeling': 896,
 'closure': 897,
 'annoying': 898,
 'limitations': 899,
 'aspects': 900,
 'special': 901,
 'abilities': 902,
 'positively': 903,
 'noted': 904,
 'Official': 905,
 'Magazine': 906,
 '-': 907,
 'UK': 908,
 'moral': 909,
 'standing': 910,
 'art': 911,
 'style': 912,
 'latter': 913,
 'continued': 914,
 'quality': 915,
 'tweaks': 916,
 'balance': 917,
 'criticism': 918,
 'affected': 919,
 'Heath': 920,
 'Hindman': 921,
 'non': 922,
 'removal': 923,
 'praising': 924,
 'returning': 925,
 'serious': 926,
 'Points': 927,
 'criticized': 928,
 'review': 929,
 'awkward': 930,
 'cutscenes': 931,
 'seemed': 932,
 'include': 933,
 'scene': 934,
 'good': 935,
 'issues': 936,
 'occasional': 937,
 'problems': 938,
 'AI': 939,
 'preview': 940,
 'Ryan': 941,
 'Geddes': 942,
 'IGN': 943,
 'left': 944,
 'excited': 945,
 'go': 946,
 'completing': 947,
 'enjoying': 948,
 'improved': 949,
 'visuals': 950,
 'Kotaku': 951,
 'Richard': 952,
 'highly': 953,
 'citing': 954,
 'form': 955,
 'His': 956,
 'criticisms': 957,
 'length': 958,
 'repetition': 959,
 'expressing': 960,
 'regret': 961,
 'Legacy': 962,
 'featured': 963,
 'Nintendo': 964,
 '3DS': 965,
 'crossover': 966,
 'Project': 967,
 'X': 968,
 'Zone': 969,
 'representing': 970,
 'develop': 971,
 'forms': 972,
 'Adaptations': 973,
 'episode': 974,
 'Taken': 975,
 'Sake': 976,
 'Network': 977,
 'planned': 978,
 'availability': 979,
 'period': 980,
 'extended': 981,
 'stoppage': 982,
 'summer': 983,
 'DVD': 984,
 'June': 985,
 '29': 986,
 'August': 987,
 '31': 988,
 'Black': 989,
 'Blue': 990,
 'editions': 991,
 'purchase': 992,
 'set': 993,
 'half': 994,
 'detailing': 995,
 'rivals': 996,
 'announced': 997,
 '1': 998,
 'Pictures': 999,
 ...}
>>>     corpus = data.Corpus('data/wikitext-2')
... 
...     prompt = 'Hello'
...     token_id = corpus.dictionary.idx2word(prompt) if prompt else torch.randint(len(corpus.dictionary), size=(1,))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(1111)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus('data/wikitext-2')
... 
...     prompt = 'Hello'
...     token_id = corpus.dictionary.word2idx(prompt) if prompt else torch.randint(len(corpus.dictionary), size=(1,))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(1111)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus('data/wikitext-2')
... 
...     prompt = 'Hello'
...     token_id = corpus.dictionary.word2idx[prompt] if prompt else torch.randint(len(corpus.dictionary), size=(1,))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(1111)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     corpus = data.Corpus('data/wikitext-2')
... 
...     prompt = 'He'
...     token_id = corpus.dictionary.word2idx[prompt] if prompt else torch.randint(len(corpus.dictionary), size=(1,))
...     # Set the random seed manually for reproducibility.
...     torch.manual_seed(1111)
... 
...     device = torch.device("cpu")
... 
...     with open(checkpoint, 'rb') as f:
...         model = torch.load(f, map_location=device)
...
>>>     model.eval()
RNNModel(
  (drop): Dropout(p=0.5, inplace=False)
  (encoder): Embedding(33278, 200)
  (rnn): GRU(200, 200, dropout=0.5)
  (decoder): Linear(in_features=200, out_features=33278, bias=True)
)
>>>     model.eval?
>>> more generate.py
>>> hidden = model.init_hidden()
>>> hidden = model.init_hidden(1)
>>> input = torch.randint(len(corpus.dictionary), (1, 1), dtype=torch.long).to(device)
>>> word = prompt
>>> word
'He'
>>> output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<EOS>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(args.temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...
>>> temperature = 0.01
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<EOS>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...
>>> word_weights
tensor([0., 0., 0.,  ..., 0., 0., 0.], grad_fn=<ExpBackward0>)
>>> sum(word_weights)
tensor(0., grad_fn=<AddBackward0>)
>>> input_tens
tensor([[425]])
>>> output
tensor([[ -6.7713,  -8.4733, -12.5531,  ..., -14.7583, -14.4768, -14.6837]],
       grad_fn=<LogSoftmaxBackward0>)
>>> output.exp()
tensor([[1.1462e-03, 2.0898e-04, 3.5341e-06,  ..., 3.8954e-07, 5.1619e-07,
         4.1970e-07]], grad_fn=<ExpBackward0>)
>>> output.squeeze().exp()
tensor([1.1462e-03, 2.0898e-04, 3.5341e-06,  ..., 3.8954e-07, 5.1619e-07,
        4.1970e-07], grad_fn=<ExpBackward0>)
>>> output.squeeze().div(temperature).exp()
tensor([0., 0., 0.,  ..., 0., 0., 0.], grad_fn=<ExpBackward0>)
>>> temperature = 1
>>> output.squeeze().div(temperature).exp()
tensor([1.1462e-03, 2.0898e-04, 3.5341e-06,  ..., 3.8954e-07, 5.1619e-07,
        4.1970e-07], grad_fn=<ExpBackward0>)
>>> output.squeeze().div(.1).exp()
tensor([3.9147e-30, 1.5886e-37, 0.0000e+00,  ..., 0.0000e+00, 0.0000e+00,
        0.0000e+00], grad_fn=<ExpBackward0>)
>>> temperature = 0.2
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<EOS>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...
>>> temperature = 0.2
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<EOS>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...     if len(words) > max_words:
...         break
...
>>> word = prompt = 'He'
... temperature = 0.2
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<EOS>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...     if len(words) > max_words:
...         break
...
>>> word = prompt = 'He'
... temperature = 0.2
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<EOS>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...     if len(output_words) > max_words:
...         break
...
>>> output_words
['He',
 "'s",
 'first',
 'game',
 ',',
 'the',
 'game',
 'was',
 'the',
 'first',
 'time',
 'of',
 'the',
 'game',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'game',
 'was',
 'the',
 'first',
 'time',
 'of',
 'the',
 'game',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'game',
 'was',
 'a',
 'first',
 'down',
 'on',
 'the',
 'first',
 'time',
 'of',
 'the',
 'game',
 ',',
 'and',
 'the',
 'first',
 'time',
 'in',
 'the',
 'first',
 'half',
 'of',
 'the',
 'season',
 '.',
 'The',
 'game',
 'was',
 'also',
 'known',
 'as',
 'the',
 'first',
 'time',
 'in',
 'the',
 'game',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'game',
 'was',
 'also',
 'known',
 'as',
 'the',
 'first',
 'time',
 'of',
 'the',
 'game',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'game',
 'was',
 'a',
 'first',
 'game',
 'in',
 'the',
 'second',
 'quarter',
 ',',
 'and',
 'the',
 'first',
 'time',
 'in',
 'the',
 'game',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'game',
 'was',
 'a',
 'second',
 '@-@',
 'game',
 '@-@',
 'game',
 '@-@',
 'game',
 '@-@',
 'game',
 '@-@',
 'yard',
 'line',
 ',',
 'and',
 'the',
 'second',
 '@-@',
 'game',
 '@-@',
 'game',
 '@-@',
 'yard',
 '<unk>',
 '@-@',
 'yard',
 'field',
 ',',
 'a',
 'total',
 'of',
 'the',
 'ball',
 '.',
 'The',
 'game',
 'was',
 'also',
 'used',
 'for',
 'the',
 'first',
 'time',
 ',',
 'and',
 'the',
 'second',
 'half',
 'of',
 'the',
 'game',
 '.',
 'The',
 'game',
 'was',
 'also',
 'used',
 'in',
 'the',
 'game',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '<unk>',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'was',
 'also',
 'known',
 'as',
 'the',
 '<unk>',
 'of',
 'the',
 '<unk>',
 'of',
 'the',
 'Year',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'game',
 "'s",
 'first',
 'time',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'was',
 'also',
 'used',
 'in',
 'the',
 'United',
 'States',
 '.',
 'The',
 'kakapo',
 'was',
 'also',
 'known',
 'as',
 'the',
 '<unk>',
 'of',
 'the',
 'Republic',
 'of',
 'Ireland',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'was',
 'a',
 'first',
 '@-@',
 'game',
 '@-@',
 'game',
 'game',
 ',',
 'which',
 'was',
 'also',
 'known',
 'as',
 'the',
 '<unk>',
 'of',
 'the',
 '<unk>',
 '.',
 'The',
 'kakapo',
 'was',
 'also',
 'known',
 'as',
 'the',
 '<unk>',
 ',',
 'and',
 'the',
 '<unk>',
 'of',
 'the',
 'Republic',
 'of',
 'Ireland',
 '.',
 'The',
 'kakapo',
 'was',
 'also',
 'known',
 'as',
 'the',
 '<unk>',
 'of',
 'the',
 'United',
 'States',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'was',
 'also',
 'known',
 'as',
 'the',
 '<unk>',
 'of',
 'the',
 'Republic',
 'of',
 'the',
 'city',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'was',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'is',
 'a',
 'large',
 '@-@',
 'scale',
 'species',
 'of',
 'the',
 '<unk>',
 '.',
 'The',
 'kakapo',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'of',
 'the',
 '<unk>',
 'is',
 'a',
 '<unk>',
 'of',
 '<unk>',
 '.',
 'The',
 'kakapo',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 'common',
 'starling',
 '.',
 'The',
 'kakapo',
 'is',
 'a',
 'small',
 'species',
 'of',
 'the',
 '<unk>',
 ',',
 'and',
 'the',
 '<unk>',
 '<unk>',
 '(',
 '<unk>',
 ')',
 '.',
 'The',
 '<unk>',
 'is',
 'a',
 '<unk>',
 'of',
 'the',
 '<unk>',
 ',',
 'and',
 'the',
 '<unk>',
 'of',
 'the',
 '<unk>',
 '.',
 'The',
 '<unk>',
 'is',
 'a',
 'common',
 'starling',
 'and',
 '<unk>',
 ',',
 'and',
 'the',
 '<unk>',
 'of',
 'the',
 '<unk>',
 '(',
 '<unk>',
 ')',
 ',',
 'and',
 '<unk>',
 '<unk>',
 ',',
 'and',
 '<unk>',
 '<unk>',
 '.',
 'The',
 '<unk>',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'of',
 '<unk>',
 '.',
 'The',
 'female',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 '<unk>',
 'of',
 'the',
 '<unk>',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '<unk>',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 'common',
 'species',
 'of',
 'the',
 '<unk>',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'is',
 'a',
 'common',
 'species',
 'of',
 'the',
 '<unk>',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<unk>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 'large',
 '<unk>',
 ',',
 'and',
 'the',
 '<unk>',
 '<unk>',
 '(',
 '<unk>',
 ')',
 ',',
 'and',
 'the',
 '<unk>',
 'of',
 '<unk>',
 '.',
 'The',
 '<unk>',
 'is',
 'the',
 'first',
 'of',
 'the',
 '<unk>',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 '<unk>',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 '<unk>',
 '.',
 'The',
 '<unk>',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 '<unk>',
 'is',
 'a',
 '<unk>',
 '.',
 'The',
 '<unk>',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'is',
 'a',
 'common',
 'species',
 ',',
 'and',
 'the',
 '<unk>',
 'of',
 'the',
 '<unk>',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 '<unk>',
 'of',
 '<unk>',
 '.',
 'The',
 '<unk>',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 '<unk>',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 '<unk>',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '<unk>',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 'large',
 '@-@',
 'shaped',
 '<unk>',
 ',',
 'which',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'is',
 'a',
 '<unk>',
 'of',
 '<unk>',
 '.',
 'The',
 'common',
 'starling',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 'of',
 'the',
 '<unk>',
 'is',
 'a',
 '<unk>',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<unk>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'is',
 'a',
 'large',
 '@-@',
 'shaped',
 '<unk>',
 ',',
 'which',
 'is',
 'a',
 '<unk>',
 'of',
 'the',
 '<unk>',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '=',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 '<unk>',
 '(',
 '<unk>',
 ')',
 ',',
 'and',
 '<unk>',
 '<unk>',
 '(',
 '<unk>',
 ')',
 ',',
 'and',
 '<unk>',
 '(',
 '<unk>',
 ')',
 ',',
 'and',
 '<unk>',
 '(',
 '<unk>',
 ')',
 ',',
 'and',
 '<unk>',
 '<unk>',
 '(',
 '<unk>',
 ')',
 ',',
 'and',
 '<unk>',
 '<unk>',
 ',',
 'and',
 '<unk>',
 ',',
 '<unk>',
 ',',
 'and',
 '<unk>',
 '.',
 'The',
 'common',
 'starling',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'which',
 'is',
 'a',
 'common',
 'starling',
 ',',
 'and',
 'the',
 '<unk>',
 '<unk>',
 '(',
 '<unk>',
 ')',
 ',',
 'and',
 '<unk>',
 '(',
 '<unk>',
 ')',
 '.',
 '<eos>',
 '<eos>',
 '=',
 '=',
 '=',
 '<unk>',
 '=',
 '=',
 '=',
 '<eos>',
 '<eos>',
 'The',
 'kakapo',
 'is',
 'a',
 'common',
 'starling',
 ',',
 ...]
>>> word = prompt = 'He'
... temperature = 0.2
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<eos>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...     if len(output_words) > max_words:
...         break
...
>>> IDX_UNK = corpus.dictionary.word2idx['<unk>']
>>> IDX_EOS = corpus.dictionary.word2idx['<eos>']
>>> corpus
<data.Corpus at 0x7f4bafa76460>
>>> for doc in corpus:
...     print(doc)
...     break
...
>>> for doc in corpus.train:
...     print(doc)
...     break
...
>>> for i, doc in enumerate(corpus.train):
...     print(i, doc)
...     if i > 100:
...         break
...
>>> for i, doc in enumerate(corpus.train):
...     print(i, corpus.dictionary.idx2word[doc])
...     if i > 100:
...         break
...
>>> hist
>>> IDX_UNK = corpus.dictionary.word2idx['<unk>']
... IDX_EOS = corpus.dictionary.word2idx['<eos>']
... word = prompt = 'He'
... temperature = 0.2
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<eos>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     if word_idx == IDX_UNK:
...         continue
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...     if len(output_words) > max_words or word_idx == IDX_EOS:
...         break
...
>>> IDX_UNK = corpus.dictionary.word2idx['<unk>']
... IDX_EOS = corpus.dictionary.word2idx['<eos>']
... word = prompt = 'He'
... temperature = 0.2
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<eos>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     # if word_idx == IDX_UNK:
...     #     continue
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...     if len(output_words) > max_words or word_idx == IDX_EOS:
...         break
...
>>> ' '.join([w for w in output_words if w != '<unk>'])
'He of the of the ( ) is a common species of the , which is a common starling . The common starling is a common species of the , and the of the . <eos>'
>>> IDX_UNK = corpus.dictionary.word2idx['<unk>']
... IDX_EOS = corpus.dictionary.word2idx['<eos>']
... word = prompt = 'He'
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<eos>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     # if word_idx == IDX_UNK:
...     #     continue
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...     if len(output_words) > max_words or word_idx == IDX_EOS:
...         break
...
>>> ' '.join([w for w in output_words if w != '<unk>'])
'He species of the kakapo is a common starling , and the is a . The is a common starling , and the of the is a , and the of the . The is a common starling , and the is a of . The is a common starling , and the is a . The female is a common starling , and the is a , and a female , and the , and , and . The is a common starling , and the of the is a . The common starling is a common starling , and the of the is . The is a common starling , and the is a . The is a common starling , and the is a . The is a common starling , and the is a of the . <eos>'
>>> temperature = 1.0
>>> IDX_UNK = corpus.dictionary.word2idx['<unk>']
... IDX_EOS = corpus.dictionary.word2idx['<eos>']
... word = prompt = 'He'
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<eos>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     # if word_idx == IDX_UNK:
...     #     continue
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...     if len(output_words) > max_words or word_idx == IDX_EOS:
...         break
...
>>> ' '.join([w for w in output_words if w != '<unk>'])
'He of the nucleus , it , habitat their exact inscription , the closing starling sometimes composed of other types or . <eos>'
>>> IDX_UNK = corpus.dictionary.word2idx['<unk>']
... IDX_EOS = corpus.dictionary.word2idx['<eos>']
... 
... output_words = []
... output_words.append(word)
... max_words = 1024
... input_tens = torch.randint(corpus.dictionary.word2idx[word], (1, 1), dtype=torch.long).to(device)
... while word and word not in {'<eos>'}:
...     output, hidden = model(input_tens, hidden)
...     word_weights = output.squeeze().div(temperature).exp().cpu()
...     word_idx = torch.multinomial(word_weights, 1)[0]
...     # if word_idx == IDX_UNK:
...     #     continue
...     input_tens.fill_(word_idx)
...     word = corpus.dictionary.idx2word[word_idx]
...     output_words.append(word)
...     if len(output_words) > max_words or word_idx == IDX_EOS:
...         break
...
>>> word
'<eos>'
>>> hist -o -p -f rnn_word_generate.hist.md
