# AUTOGENERATED! DO NOT EDIT! File to edit: 01_contacts.ipynb (unless otherwise specified).

__all__ = ['create_contact', 'contact_exists', 'get_contact', 'delete_contact']

# Cell
#export
import time
import os
import json
import requests
from dotenv import load_dotenv
from .search import hubspot_search
load_dotenv()

# Cell


def create_contact(contact=None, hapikey=None):
    """
    Create a contact.
    """
    if contact is None:
        contact = dict(email='sometestuser@example.com')
    if hapikey is None:
        hapikey = os.environ.get('HUBSPOT_API_KEY','demo')
    endpoint = 'https://api.hubapi.com/contacts/v1/contact/'
    url = f'{endpoint}?hapikey={hapikey}'
    headers = {
        "Content-Type": "application/json"
    }
    data = json.dumps({"properties": [{"property": k,"value": contact[k]} for k in contact]})
    r = requests.post(url=url, data=data, headers=headers)
    return r.json()

# Cell


def contact_exists(value, property='email', operator='EQ', hapikey=None) -> bool:
    """
    Check if a contact exists.
    """
    r = hubspot_search(value, property=property, operator=operator, hapikey=hapikey)
    if r['total'] > 0:
        return True
    else:
        return False

# Cell


def get_contact(value, property='email', operator='EQ', hapikey=None):
    """
    Get contact.
    """
    if hapikey is None:
        hapikey = os.environ.get('HUBSPOT_API_KEY','demo')
    r = hubspot_search(value, property=property, operator=operator, hapikey=hapikey)
    if r['total'] > 0:
        contact = r['results'][0]
        return contact
    else:
        return None

# Cell


def delete_contact(vid=None, hapikey=None):
    """
    Delete a contact.
    """
    if hapikey is None:
        hapikey = os.environ.get('HUBSPOT_API_KEY','demo')
    endpoint = f'https://api.hubapi.com/contacts/v1/contact/vid/{vid}'
    url = f'{endpoint}?hapikey={hapikey}'
    headers = {
        "Content-Type": "application/json"
    }
    r = requests.delete(url=url, headers=headers)
    return r.json()