# Generated by Django 3.1.14 on 2022-05-18 21:18

import django.contrib.gis.db.models.fields
import django.db.models.deletion
import django_countries.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("stores", "0013_auto_20220518_1539"),
    ]

    operations = [
        migrations.CreateModel(
            name="ImmutableAddress",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("address_line", models.CharField(max_length=250)),
                (
                    "postal_code",
                    models.CharField(
                        help_text="The address postal/zip code.", max_length=64
                    ),
                ),
                (
                    "city",
                    models.CharField(help_text="The address city.", max_length=120),
                ),
                (
                    "region",
                    models.CharField(
                        blank=True,
                        help_text="The address region, province, or state.",
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "country",
                    django_countries.fields.CountryField(
                        help_text="The address country.", max_length=2
                    ),
                ),
                (
                    "location",
                    django.contrib.gis.db.models.fields.PointField(
                        blank=True, null=True, srid=4326
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
            ],
            options={
                "verbose_name": "address",
                "verbose_name_plural": "addresses",
            },
        ),
        migrations.AlterModelOptions(
            name="address",
            options={"verbose_name": "Address", "verbose_name_plural": "Addresses"},
        ),
        migrations.RemoveField(
            model_name="address",
            name="created_at",
        ),
        migrations.RemoveField(
            model_name="address",
            name="updated_at",
        ),
        migrations.AddField(
            model_name="order",
            name="immutable_shipping_address",
            field=models.ForeignKey(
                default=0,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="orders",
                to="stores.immutableaddress",
            ),
            preserve_default=False,
        ),
    ]
