# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Endpoint(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'uri': 'str',
        'provider_name': 'str',
        'phone_number': 'str',
        'dtmf': 'str',
        'language': 'str',
        'audio_config': 'AudioConfig',
        'timezone_offset': 'float',
        'idle_timeout': 'float',
        'transport_config': 'str'
    }

    attribute_map = {
        'type': 'type',
        'uri': 'uri',
        'provider_name': 'providerName',
        'phone_number': 'phoneNumber',
        'dtmf': 'dtmf',
        'language': 'language',
        'audio_config': 'audioConfig',
        'timezone_offset': 'timezoneOffset',
        'idle_timeout': 'idleTimeout',
        'transport_config': 'transportConfig'
    }

    def __init__(self, type=None, uri=None, provider_name=None, phone_number=None, dtmf=None, language=None, audio_config=None, timezone_offset=0, idle_timeout=None, transport_config=None):  # noqa: E501
        """Endpoint - a model defined in Swagger"""  # noqa: E501
        self._type = None
        self._uri = None
        self._provider_name = None
        self._phone_number = None
        self._dtmf = None
        self._language = None
        self._audio_config = None
        self._timezone_offset = None
        self._idle_timeout = None
        self._transport_config = None
        self.discriminator = None
        if type is not None:
            self.type = type
        if uri is not None:
            self.uri = uri
        if provider_name is not None:
            self.provider_name = provider_name
        if phone_number is not None:
            self.phone_number = phone_number
        if dtmf is not None:
            self.dtmf = dtmf
        if language is not None:
            self.language = language
        if audio_config is not None:
            self.audio_config = audio_config
        if timezone_offset is not None:
            self.timezone_offset = timezone_offset
        if idle_timeout is not None:
            self.idle_timeout = idle_timeout
        if transport_config is not None:
            self.transport_config = transport_config

    @property
    def type(self):
        """Gets the type of this Endpoint.  # noqa: E501


        :return: The type of this Endpoint.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Endpoint.


        :param type: The type of this Endpoint.  # noqa: E501
        :type: str
        """
        allowed_values = ["sip", "pstn"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def uri(self):
        """Gets the uri of this Endpoint.  # noqa: E501

        SIP URI to connect to  # noqa: E501

        :return: The uri of this Endpoint.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this Endpoint.

        SIP URI to connect to  # noqa: E501

        :param uri: The uri of this Endpoint.  # noqa: E501
        :type: str
        """

        self._uri = uri

    @property
    def provider_name(self):
        """Gets the provider_name of this Endpoint.  # noqa: E501

        The name of the meeting platform to connect to  # noqa: E501

        :return: The provider_name of this Endpoint.  # noqa: E501
        :rtype: str
        """
        return self._provider_name

    @provider_name.setter
    def provider_name(self, provider_name):
        """Sets the provider_name of this Endpoint.

        The name of the meeting platform to connect to  # noqa: E501

        :param provider_name: The provider_name of this Endpoint.  # noqa: E501
        :type: str
        """

        self._provider_name = provider_name

    @property
    def phone_number(self):
        """Gets the phone_number of this Endpoint.  # noqa: E501

        Phone number to be used to dial in to in E.164 format i.e. special characters like () or - and leading + or international access codes like 001 or 00 must be omitted. For e.g. - US number should look like 14082924837, whereas UK number should look like 447082924837  # noqa: E501

        :return: The phone_number of this Endpoint.  # noqa: E501
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """Sets the phone_number of this Endpoint.

        Phone number to be used to dial in to in E.164 format i.e. special characters like () or - and leading + or international access codes like 001 or 00 must be omitted. For e.g. - US number should look like 14082924837, whereas UK number should look like 447082924837  # noqa: E501

        :param phone_number: The phone_number of this Endpoint.  # noqa: E501
        :type: str
        """

        self._phone_number = phone_number

    @property
    def dtmf(self):
        """Gets the dtmf of this Endpoint.  # noqa: E501

        DTMF sequence to be sent after call is received  # noqa: E501

        :return: The dtmf of this Endpoint.  # noqa: E501
        :rtype: str
        """
        return self._dtmf

    @dtmf.setter
    def dtmf(self, dtmf):
        """Sets the dtmf of this Endpoint.

        DTMF sequence to be sent after call is received  # noqa: E501

        :param dtmf: The dtmf of this Endpoint.  # noqa: E501
        :type: str
        """

        self._dtmf = dtmf

    @property
    def language(self):
        """Gets the language of this Endpoint.  # noqa: E501

        Language code as per the BCP 47 specification  # noqa: E501

        :return: The language of this Endpoint.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this Endpoint.

        Language code as per the BCP 47 specification  # noqa: E501

        :param language: The language of this Endpoint.  # noqa: E501
        :type: str
        """

        self._language = language

    @property
    def audio_config(self):
        """Gets the audio_config of this Endpoint.  # noqa: E501


        :return: The audio_config of this Endpoint.  # noqa: E501
        :rtype: AudioConfig
        """
        return self._audio_config

    @audio_config.setter
    def audio_config(self, audio_config):
        """Sets the audio_config of this Endpoint.


        :param audio_config: The audio_config of this Endpoint.  # noqa: E501
        :type: AudioConfig
        """

        self._audio_config = audio_config

    @property
    def timezone_offset(self):
        """Gets the timezone_offset of this Endpoint.  # noqa: E501

        Number of minutes that needs to be added or removed from the UTC time. Positive or negative numbers are accepted. For example, for PST timezone, the value should be -480 and for IST timezone, the value should be 330  # noqa: E501

        :return: The timezone_offset of this Endpoint.  # noqa: E501
        :rtype: float
        """
        return self._timezone_offset

    @timezone_offset.setter
    def timezone_offset(self, timezone_offset):
        """Sets the timezone_offset of this Endpoint.

        Number of minutes that needs to be added or removed from the UTC time. Positive or negative numbers are accepted. For example, for PST timezone, the value should be -480 and for IST timezone, the value should be 330  # noqa: E501

        :param timezone_offset: The timezone_offset of this Endpoint.  # noqa: E501
        :type: float
        """

        self._timezone_offset = timezone_offset

    @property
    def idle_timeout(self):
        """Gets the idle_timeout of this Endpoint.  # noqa: E501

        The timeout value in seconds for Symbl to leave the meeting if no one is speaking. -1 for no timeout which is the default value if not specified.  # noqa: E501

        :return: The idle_timeout of this Endpoint.  # noqa: E501
        :rtype: float
        """
        return self._idle_timeout

    @idle_timeout.setter
    def idle_timeout(self, idle_timeout):
        """Sets the idle_timeout of this Endpoint.

        The timeout value in seconds for Symbl to leave the meeting if no one is speaking. -1 for no timeout which is the default value if not specified.  # noqa: E501

        :param idle_timeout: The idle_timeout of this Endpoint.  # noqa: E501
        :type: float
        """

        self._idle_timeout = idle_timeout

    @property
    def transport_config(self):
        """Gets the transport_config of this Endpoint.  # noqa: E501

        The transport-layer protocols name and value pairs separated by semi-colons to use for making the SIP requests  # noqa: E501

        :return: The transport_config of this Endpoint.  # noqa: E501
        :rtype: str
        """
        return self._transport_config

    @transport_config.setter
    def transport_config(self, transport_config):
        """Sets the transport_config of this Endpoint.

        The transport-layer protocols name and value pairs separated by semi-colons to use for making the SIP requests  # noqa: E501

        :param transport_config: The transport_config of this Endpoint.  # noqa: E501
        :type: str
        """

        self._transport_config = transport_config

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Endpoint, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Endpoint):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
