# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Word(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'word': 'str',
        'start_time': 'date',
        'end_time': 'date',
        'speaker_tag': 'float'
    }

    attribute_map = {
        'word': 'word',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'speaker_tag': 'speakerTag'
    }

    def __init__(self, word=None, start_time=None, end_time=None, speaker_tag=None):  # noqa: E501
        """Word - a model defined in Swagger"""  # noqa: E501
        self._word = None
        self._start_time = None
        self._end_time = None
        self._speaker_tag = None
        self.discriminator = None
        if word is not None:
            self.word = word
        if start_time is not None:
            self.start_time = start_time
        if end_time is not None:
            self.end_time = end_time
        if speaker_tag is not None:
            self.speaker_tag = speaker_tag

    @property
    def word(self):
        """Gets the word of this Word.  # noqa: E501


        :return: The word of this Word.  # noqa: E501
        :rtype: str
        """
        return self._word

    @word.setter
    def word(self, word):
        """Sets the word of this Word.


        :param word: The word of this Word.  # noqa: E501
        :type: str
        """

        self._word = word

    @property
    def start_time(self):
        """Gets the start_time of this Word.  # noqa: E501


        :return: The start_time of this Word.  # noqa: E501
        :rtype: date
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this Word.


        :param start_time: The start_time of this Word.  # noqa: E501
        :type: date
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this Word.  # noqa: E501


        :return: The end_time of this Word.  # noqa: E501
        :rtype: date
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this Word.


        :param end_time: The end_time of this Word.  # noqa: E501
        :type: date
        """

        self._end_time = end_time

    @property
    def speaker_tag(self):
        """Gets the speaker_tag of this Word.  # noqa: E501


        :return: The speaker_tag of this Word.  # noqa: E501
        :rtype: float
        """
        return self._speaker_tag

    @speaker_tag.setter
    def speaker_tag(self, speaker_tag):
        """Sets the speaker_tag of this Word.


        :param speaker_tag: The speaker_tag of this Word.  # noqa: E501
        :type: float
        """

        self._speaker_tag = speaker_tag

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Word, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Word):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
