# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/021_data.tabular.ipynb.

# %% auto 0
__all__ = ['get_tabular_ds', 'get_tabular_dls', 'preprocess_df']

# %% ../../nbs/021_data.tabular.ipynb 3
from fastai.tabular.all import *
from ..imports import *
from ..utils import *

# %% ../../nbs/021_data.tabular.ipynb 4
@delegates(TabularPandas.__init__)
def get_tabular_ds(df, procs=[Categorify, FillMissing, Normalize], cat_names=None, cont_names=None, y_names=None, groupby=None,
                   y_block=None, splits=None, do_setup=True, inplace=False, reduce_memory=True, device=None, **kwargs):
    device = ifnone(device, default_device())
    groupby = str2list(groupby)
    cat_names = str2list(cat_names)
    cont_names = str2list(cont_names)
    y_names = str2list(y_names)
    cols = []
    for _cols in [groupby, cat_names, cont_names, y_names]:
        if _cols is not None: cols.extend(_cols)
    cols = list(set(cols))
    if y_names is None: y_block = None
    elif y_block is None:
        num_cols = df._get_numeric_data().columns
        y_block = CategoryBlock() if any([True for n in y_names if n not in num_cols]) else RegressionBlock()
    else: y_block = None
    pd.options.mode.chained_assignment=None
    to = TabularPandas(df[cols], procs=procs, cat_names=cat_names, cont_names=cont_names, y_names=y_names, y_block=y_block,
                       splits=splits, do_setup=do_setup, inplace=inplace, reduce_memory=reduce_memory, device=device)
    setattr(to, "groupby", groupby)
    return to

# %% ../../nbs/021_data.tabular.ipynb 5
@delegates(DataLoaders.__init__)
def get_tabular_dls(df, procs=[Categorify, FillMissing, Normalize], cat_names=None, cont_names=None, y_names=None, bs=64, 
                    y_block=None, splits=None, do_setup=True, inplace=False, reduce_memory=True, device=None, **kwargs):
    to = get_tabular_ds(df, procs=procs, cat_names=cat_names, cont_names=cont_names, y_names=y_names, 
                        y_block=y_block, splits=splits, do_setup=do_setup, inplace=inplace, reduce_memory=reduce_memory, device=device, **kwargs)
    if splits is not None: bs = min(len(splits[0]), bs)
    else: bs = min(len(df), bs)
    return to.dataloaders(device=device, bs=bs, **kwargs)

# %% ../../nbs/021_data.tabular.ipynb 6
def preprocess_df(df, procs=[Categorify, FillMissing, Normalize], cat_names=None, cont_names=None, y_names=None, sample_col=None, reduce_memory=True):
    cat_names = str2list(cat_names)
    cont_names = str2list(cont_names)
    y_names = str2list(y_names)
    cols = []
    for _cols in [cat_names, cont_names, y_names]:
        if _cols is not None: cols.extend(_cols)
    cols = list(set(cols))
    pd.options.mode.chained_assignment=None
    to = TabularPandas(df[cols], procs=procs, cat_names=cat_names, cont_names=cont_names, y_names=y_names, reduce_memory=reduce_memory)
    procs = to.procs
    if sample_col is not None:
        sample_col = str2list(sample_col)
        to = pd.concat([df[sample_col], to.cats, to.conts, to.ys], axis=1)
    else: 
        to = pd.concat([to.cats, to.conts, to.ys], axis=1)
    return to, procs
