"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleLabel = exports.renderAmazonLinuxUserData = void 0;
const core_1 = require("@aws-cdk/core");
// tslint:disable-next-line:max-line-length
function renderAmazonLinuxUserData(scope, clusterName, spotFleet, options = {}) {
    const stack = core_1.Stack.of(scope);
    // determine logical id of ASG so we can signal cloudformation
    // const cfn = spotFleet.node.defaultChild as autoscaling.CfnAutoScalingGroup;
    // const asgLogicalId = cfn.logicalId;
    const spotFleetLogicalId = spotFleet.node.id;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods === undefined ? true : options.useMaxPods}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    // const lifecycleLabel = autoScalingGroup.spotPrice ? LifecycleLabel.SPOT : LifecycleLabel.ON_DEMAND;
    const lifecycleLabel = LifecycleLabel.SPOT;
    // const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const withTaints = '--register-with-taints=spotInstance=true:PreferNoSchedule';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${spotFleetLogicalId} --region ${stack.region}`,
    ];
}
exports.renderAmazonLinuxUserData = renderAmazonLinuxUserData;
/**
 * The lifecycle label for node selector
 */
var LifecycleLabel;
(function (LifecycleLabel) {
    /**
     * on-demand instances
     */
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    /**
     * spot instances
     */
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
//# sourceMappingURL=data:application/json;base64,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