## Project Summary
`AbStochKin` is an agent-based (or particle-based) Monte-Carlo simulator of the time 
evolution of systems composed of species that participate in coupled processes. 
The population of a species is considered as composed of distinct individuals, 
termed *agents*, or *particles*. 
This allows for the specification of the kinetic parameters describing 
the propensity of *each agent* to participate in a given process. 

Although the algorithm was originally conceived for simulating biochemical 
systems, it is applicable to other disciplines where there is a need to model 
how populations change over time and to study the effects of heterogeneity, 
or diversity, in the composition of species populations on the dynamics of a system.

## Documentation
The documentation of all public classes, methods, and functions in the project 
can be found [here](abstochkin.html). 

A monograph detailing the theoretical underpinnings of the *Agent-based Kinetics* 
algorithm and a multitude of case studies highlighting its use can be found 
[here](Agent-basedKinetics_monograph.pdf).