window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"abstochkin": {"fullname": "abstochkin", "modulename": "abstochkin", "kind": "module", "doc": "<p>Agent-based (or Particle-based) Stochastic Kinetics.</p>\n"}, "abstochkin.agentstatedata": {"fullname": "abstochkin.agentstatedata", "modulename": "abstochkin.agentstatedata", "kind": "module", "doc": "<p>Class for storing the state of all agents of a certain species during an\nAbStochKin simulation.</p>\n"}, "abstochkin.agentstatedata.AgentStateData": {"fullname": "abstochkin.agentstatedata.AgentStateData", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData", "kind": "class", "doc": "<p>Class for storing the state of all agents of a certain species during an\nAbStochKin simulation.</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>p_init</strong> (int):\nThe initial population size of the species whose data is\nrepresented in an <code>AgentStateData</code> object.</li>\n<li><strong>max_agents</strong> (int):\nThe maximum number of agents for the species whose data\nis represented in an <code>AgentStateData</code> object.</li>\n<li><strong>reps</strong> (int):\nThe number of times the AbStochKin algorithm will repeat a simulation.\nThis will be the length of the <code>asv</code> list.</li>\n<li><p><strong>fill_state</strong> (int):</p></li>\n<li><p><strong>asv_ini</strong> (numpy.ndarray):\nAgent-State Vector (asv) is a species-specific 2-row vector to monitor\nagent state according to Markov's property. This array is the initial\nasv, i.e., at <code>t=0</code>. The array shape is <code>(2, max_agents)</code></p></li>\n<li><strong>asv</strong> (list of numpy.ndarray):\nA list of length <code>reps</code> with copies of <code>asv_ini</code>. Each simulation run\nuses its corresponding entry in <code>asv</code> to monitor the state of all\nagents.</li>\n</ul>\n"}, "abstochkin.agentstatedata.AgentStateData.__init__": {"fullname": "abstochkin.agentstatedata.AgentStateData.__init__", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">p_init</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">max_agents</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">reps</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">fill_state</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span>)</span>"}, "abstochkin.agentstatedata.AgentStateData.p_init": {"fullname": "abstochkin.agentstatedata.AgentStateData.p_init", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.p_init", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, "abstochkin.agentstatedata.AgentStateData.max_agents": {"fullname": "abstochkin.agentstatedata.AgentStateData.max_agents", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.max_agents", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, "abstochkin.agentstatedata.AgentStateData.reps": {"fullname": "abstochkin.agentstatedata.AgentStateData.reps", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.reps", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, "abstochkin.agentstatedata.AgentStateData.fill_state": {"fullname": "abstochkin.agentstatedata.AgentStateData.fill_state", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.fill_state", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, "abstochkin.agentstatedata.AgentStateData.asv_ini": {"fullname": "abstochkin.agentstatedata.AgentStateData.asv_ini", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.asv_ini", "kind": "variable", "doc": "<p></p>\n", "annotation": ": numpy.ndarray"}, "abstochkin.agentstatedata.AgentStateData.asv": {"fullname": "abstochkin.agentstatedata.AgentStateData.asv", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.asv", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[numpy.ndarray]"}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"fullname": "abstochkin.agentstatedata.AgentStateData.apply_markov_property", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.apply_markov_property", "kind": "function", "doc": "<p>The future state of the system depends only on its current state.\nThis method is called at the end of each time step in an AbStochKin\nsimulation. Therefore, the new agent-state vector becomes the\ncurrent state.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">r</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"fullname": "abstochkin.agentstatedata.AgentStateData.cleanup_asv", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.cleanup_asv", "kind": "function", "doc": "<p>Empty the contents of the array <code>asv</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"fullname": "abstochkin.agentstatedata.AgentStateData.get_vals_o1", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.get_vals_o1", "kind": "function", "doc": "<p>Get random values in [0,1) at a given time step for agents of a given\nstate. Agents of other states have a value of zero.</p>\n\n<p>Get probability values at a given time step for agents of a given state.\nAgents of other states have a transition probability of zero.</p>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>Note that only elements of the <code>asv</code> that have the same state in the\nprevious and current time steps are considered. This is to ensure that\nagents that have already transitioned to a different state in the\ncurrent time step are not reconsidered for a possible transition.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">r</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">random</span><span class=\"o\">.</span><span class=\"n\">_generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">p_vals</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">state</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"fullname": "abstochkin.agentstatedata.AgentStateData.get_vals_o2", "modulename": "abstochkin.agentstatedata", "qualname": "AgentStateData.get_vals_o2", "kind": "function", "doc": "<p>Get random values in [0,1) at a given time step for interactions between\nagents of a given state. Agents of other states have a value of zero.</p>\n\n<p>Get probability values at a given time step for interactions between\nagents of a given state. Interactions of agents in other states\nhave a transition probability of zero.</p>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>Note that only elements of the <code>asv</code> that have the same state in the\nprevious and current time steps are considered. This is to ensure that\nagents that have already transitioned to a different state in the\ncurrent time step are not reconsidered for a possible transition.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span>,</span><span class=\"param\">\t<span class=\"n\">r</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">random</span><span class=\"o\">.</span><span class=\"n\">_generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">p_vals</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">state</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.base": {"fullname": "abstochkin.base", "modulename": "abstochkin.base", "kind": "module", "doc": "<p>Base class, AbStochKin, for initializing and storing all data for\nperforming stochastic simulations using the Agent-based Kinetics\nmethod. A simulation project can be initialized and run as shown in\nthe examples below.</p>\n\n<h6 id=\"example\">Example</h6>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">abstochkin</span> <span class=\"kn\">import</span> <span class=\"n\">AbStochKin</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sim</span> <span class=\"o\">=</span> <span class=\"n\">AbStochKin</span><span class=\"p\">()</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sim</span><span class=\"o\">.</span><span class=\"n\">add_process_from_str</span><span class=\"p\">(</span><span class=\"s1\">&#39;A -&gt; &#39;</span><span class=\"p\">,</span> <span class=\"mf\">0.2</span><span class=\"p\">)</span>  <span class=\"c1\"># degradation process</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sim</span><span class=\"o\">.</span><span class=\"n\">simulate</span><span class=\"p\">(</span><span class=\"n\">p0</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;A&#39;</span><span class=\"p\">:</span> <span class=\"mi\">100</span><span class=\"p\">},</span><span class=\"n\">t_max</span><span class=\"o\">=</span><span class=\"mi\">20</span><span class=\"p\">,</span><span class=\"n\">plot_backend</span><span class=\"o\">=</span><span class=\"n\">plotly</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># All data for the above simulation is stored in `sim.sims[0]`.</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Now set up a new simulation without actually running it.</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sim</span><span class=\"o\">.</span><span class=\"n\">simulate</span><span class=\"p\">(</span><span class=\"n\">p0</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;A&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">},</span><span class=\"n\">t_max</span><span class=\"o\">=</span><span class=\"mi\">10</span><span class=\"p\">,</span><span class=\"n\">n</span><span class=\"o\">=</span><span class=\"mi\">50</span><span class=\"p\">,</span><span class=\"n\">run</span><span class=\"o\">=</span><span class=\"kc\">False</span><span class=\"p\">,</span><span class=\"n\">plot_backend</span><span class=\"o\">=</span><span class=\"n\">plotly</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># All data for the new simulation is stored in `sim.sims[1]`.</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># The simulation can then be manually run using methods</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># documented in the class `Simulation`.</span>\n</code></pre>\n</div>\n"}, "abstochkin.base.AbStochKin": {"fullname": "abstochkin.base.AbStochKin", "modulename": "abstochkin.base", "qualname": "AbStochKin", "kind": "class", "doc": "<p>Base class for Agent-based Kinetics (AbStochKin) simulator.</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>volume : float, default</strong> (None, optional):\nThe volume <em>in liters</em> of the compartment in which the processes\nare taking place.</li>\n<li><strong>volume_unit : str, default</strong> ('L', optional):\nA string of the volume unit. The default value is 'L' for liters.</li>\n<li><strong>time_unit : str, default</strong> ('sec', optional):\nA string of the time unit to be used for describing the kinetics\nof the given processes.</li>\n<li><strong>processes</strong> (list):\nA list of the processes that the AbStochKin object has.</li>\n<li><strong>het_processes</strong> (list):\nA list of the processes where population heterogeneity in one\nof the parameters is to be modeled. This list is a subset of\nthe <code>processes</code> attribute.</li>\n<li><strong>sims</strong> (list):\nA list of all simulations performed for the given set of processes.\nEach member of the list is an object of the <code>Simulation</code> class and\ncontains all data for that simulation.</li>\n</ul>\n"}, "abstochkin.base.AbStochKin.__init__": {"fullname": "abstochkin.base.AbStochKin.__init__", "modulename": "abstochkin.base", "qualname": "AbStochKin.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">volume_unit</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;L&#39;</span>, </span><span class=\"param\"><span class=\"n\">time_unit</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;sec&#39;</span></span>)</span>"}, "abstochkin.base.AbStochKin.volume": {"fullname": "abstochkin.base.AbStochKin.volume", "modulename": "abstochkin.base", "qualname": "AbStochKin.volume", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.base.AbStochKin.volume_unit": {"fullname": "abstochkin.base.AbStochKin.volume_unit", "modulename": "abstochkin.base", "qualname": "AbStochKin.volume_unit", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.base.AbStochKin.time_unit": {"fullname": "abstochkin.base.AbStochKin.time_unit", "modulename": "abstochkin.base", "qualname": "AbStochKin.time_unit", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.base.AbStochKin.processes": {"fullname": "abstochkin.base.AbStochKin.processes", "modulename": "abstochkin.base", "qualname": "AbStochKin.processes", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.base.AbStochKin.het_processes": {"fullname": "abstochkin.base.AbStochKin.het_processes", "modulename": "abstochkin.base", "qualname": "AbStochKin.het_processes", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.base.AbStochKin.sims": {"fullname": "abstochkin.base.AbStochKin.sims", "modulename": "abstochkin.base", "qualname": "AbStochKin.sims", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.base.AbStochKin.add_processes_from_file": {"fullname": "abstochkin.base.AbStochKin.add_processes_from_file", "modulename": "abstochkin.base", "qualname": "AbStochKin.add_processes_from_file", "kind": "function", "doc": "<p>Add a batch of processes from a text file.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filename</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.base.AbStochKin.extract_process_from_str": {"fullname": "abstochkin.base.AbStochKin.extract_process_from_str", "modulename": "abstochkin.base", "qualname": "AbStochKin.extract_process_from_str", "kind": "function", "doc": "<p>Extract a process and all of its specified parameters from a string.</p>\n\n<p>This functions parses a string specifying all values and parameters\nneeded to define a process. It then creates a Process object\nbased on the extracted data.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">process_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.base.AbStochKin.add_process_from_str": {"fullname": "abstochkin.base.AbStochKin.add_process_from_str", "modulename": "abstochkin.base", "qualname": "AbStochKin.add_process_from_str", "kind": "function", "doc": "<p>Add a process by specifying a string: 'reactants -> products'.\nAdditional arguments determine if a specialized process\n(such as a reversible, regulated, or Michaelis-Menten process)\nis to be defined.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">process_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.base.AbStochKin.add_process": {"fullname": "abstochkin.base.AbStochKin.add_process", "modulename": "abstochkin.base", "qualname": "AbStochKin.add_process", "kind": "function", "doc": "<p>Add a process by using a dictionary for the reactants and products.\nAdditional arguments determine if a specialized process\n(such as a reversible, regulated, or Michaelis-Menten process)\nis to be defined.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">reactants</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">products</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.base.AbStochKin.del_process_from_str": {"fullname": "abstochkin.base.AbStochKin.del_process_from_str", "modulename": "abstochkin.base", "qualname": "AbStochKin.del_process_from_str", "kind": "function", "doc": "<p>Delete a process by specifying a string: 'reactants -> products'.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">process_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.base.AbStochKin.del_process": {"fullname": "abstochkin.base.AbStochKin.del_process", "modulename": "abstochkin.base", "qualname": "AbStochKin.del_process", "kind": "function", "doc": "<p>Delete a process by using a dictionary for the reactants and products.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">reactants</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">products</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.base.AbStochKin.simulate": {"fullname": "abstochkin.base.AbStochKin.simulate", "modulename": "abstochkin.base", "qualname": "AbStochKin.simulate", "kind": "function", "doc": "<p>Start an AbStochKin simulation by creating an instance of the class\n<code>Simulation</code>. The resulting object is appended to the list\nin the class attribute <code>AbStochKin.sims</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>p0 : dict[str</strong> (int]):\nDictionary specifying the initial population sizes of all\nspecies in the given processes.</li>\n<li><strong>t_max</strong> (float or int):\nNumerical value of the end of simulated time in the units\nspecified in the class attribute <code>AbStochKin.time_unit</code>.</li>\n<li><strong>dt : float, default</strong> (0.1, optional):\nThe duration of the time interval that the simulation's\nalgorithm considers. The current implementation only\nsupports a fixed time step interval whose value is <code>dt</code>.</li>\n<li><strong>n : int, default</strong> (100, optional):\nThe number of repetitions of the simulation to be performed.</li>\n<li><strong>random_seed : int, default</strong> (19, optional):\nA number used to seed the random number generator.</li>\n<li><strong>solve_odes : bool, default</strong> (True, optional):\nSpecify whether to numerically solve the system of\nODEs defined from the given set of processes.</li>\n<li><strong>ode_method : str, default</strong> (RK45, optional):\nAvailable ODE methods: RK45, RK23, DOP853, Radau, BDF, LSODA.</li>\n<li><strong>run : bool, default</strong> (True, optional):\nSpecify whether to run an AbStochKin simulation.</li>\n<li><strong>show_plots : bool, default</strong> (True, optional):\nSpecify whether to graph the results of the AbStochKin simulation.</li>\n<li><strong>plot_backend : str, default</strong> ('matplotlib', optional):\n<code>Matplotlib</code> and <code>Plotly</code> are currently supported.</li>\n<li><strong>multithreading : bool, default</strong> (True, optional):\nSpecify whether to parallelize the simulation\nusing multithreading. If <code>False</code>, the ensemble\nof simulations is run sequentially.</li>\n<li><strong>max_agents_by_species : None or dict, default</strong> (dict):\nSpecification of the maximum number of agents that each\nspecies should have when running the simulation.\nIf <code>None</code>, that a default approach will\nbe taken by the class <code>Simulation</code> and the number\nfor each species will be automatically determined\n(see method <code>Simulation._setup_runtime_data()</code> for details).\nThe entries in the dictionary should be\n<code>species name (string): number (int)</code>.</li>\n<li><strong>max_agents_multiplier : float or int, default</strong> (2):\nThis parameter is used to calculate the maximum number of\nagents of each species that the simulation engine allocates\nmemory for. This be determined by multiplying the maximum value\nof the ODE time trajectory for this species by the\nmultiplier value specified here.</li>\n<li><strong>_return_simulation</strong> (bool):\nDetermines if the <code>self.simulate</code> method returns a <code>Simulation</code>\nobject or appends it to the list <code>self.sims</code>.\nReturning a <code>Simulation</code> object is needed when calling the method\n<code>simulate_series_in_parallel</code>.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">p0</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">t_max</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">dt</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.01</span>,</span><span class=\"param\">\t<span class=\"n\">n</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">random_seed</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">19</span>,</span><span class=\"param\">\t<span class=\"n\">solve_odes</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">ode_method</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;RK45&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">run</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">show_plots</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">plot_backend</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;matplotlib&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;plotly&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;matplotlib&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">multithreading</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">max_agents_by_species</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">max_agents_multiplier</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"n\">_return_simulation</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"fullname": "abstochkin.base.AbStochKin.simulate_series_in_parallel", "modulename": "abstochkin.base", "qualname": "AbStochKin.simulate_series_in_parallel", "kind": "function", "doc": "<p>Perform a series of simulations in parallel by initializing\nseparate processes. Each process runs a simulation and appends\na <code>Simulation</code> object in the list <code>self.sims</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>series_kwargs</strong> (list of dict):\nA list containing dictionaries of the keyword arguments for\nperforming each simulation in the series. The number of elements\nin the list is the number of simulations that will be run.</li>\n<li><strong>max_workers : int, default</strong> (None):\nThe maximum number of processes to be used for performing\nthe given series of simulations. If None, then as many worker\nprocesses will be created as the machine has processors.</li>\n</ul>\n\n<h6 id=\"examples\">Examples</h6>\n\n<ul>\n<li>Run a series of simulations by varying the initial population size of A.\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span> <span class=\"kn\">from</span> <span class=\"nn\">abstochkin</span> <span class=\"kn\">import</span> <span class=\"n\">AbStochKin</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span> <span class=\"n\">sim</span> <span class=\"o\">=</span> <span class=\"n\">AbStochKin</span><span class=\"p\">()</span>\n<span class=\"gp\">&gt;&gt;&gt; </span> <span class=\"n\">sim</span><span class=\"o\">.</span><span class=\"n\">add_process_from_str</span><span class=\"p\">(</span><span class=\"s2\">&quot;A -&gt; B&quot;</span><span class=\"p\">,</span> <span class=\"mf\">0.3</span><span class=\"p\">,</span> <span class=\"n\">catalyst</span><span class=\"o\">=</span><span class=\"s1\">&#39;E&#39;</span><span class=\"p\">,</span> <span class=\"n\">Km</span><span class=\"o\">=</span><span class=\"mi\">10</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span> <span class=\"n\">series_kwargs</span> <span class=\"o\">=</span> <span class=\"p\">[{</span><span class=\"s2\">&quot;p0&quot;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;A&#39;</span><span class=\"p\">:</span> <span class=\"n\">i</span><span class=\"p\">,</span> <span class=\"s1\">&#39;B&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;E&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">},</span> <span class=\"s2\">&quot;t_max&quot;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">}</span> <span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"mi\">40</span><span class=\"p\">,</span> <span class=\"mi\">51</span><span class=\"p\">)]</span>\n<span class=\"gp\">&gt;&gt;&gt; </span> <span class=\"n\">sim</span><span class=\"o\">.</span><span class=\"n\">simulate_series_in_parallel</span><span class=\"p\">(</span><span class=\"n\">series_kwargs</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">series_kwargs</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"o\">...</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">max_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.de_calcs": {"fullname": "abstochkin.de_calcs", "modulename": "abstochkin.de_calcs", "kind": "module", "doc": "<p>Perform deterministic calculations on a set of processes.\nConstruct the ordinary differential equations (ODEs)\ndescribing the system and obtain a numerical solution.</p>\n"}, "abstochkin.de_calcs.DEcalcs": {"fullname": "abstochkin.de_calcs.DEcalcs", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs", "kind": "class", "doc": "<p>Perform deterministic calculations given the processes specified\nin an AbStochKin simulation object.</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>p0 : dict[str</strong> (int]):\nDictionary specifying the initial population sizes of all\nspecies in the given processes.</li>\n<li><strong>t_min</strong> (float or int):\nNumerical value of the start of simulated time in the units\nspecified in the class attribute <code>time_unit</code>.</li>\n<li><strong>t_max</strong> (float or int):\nNumerical value of the end of simulated time in the units\nspecified in the class attribute <code>time_unit</code>.</li>\n<li><strong>processes</strong> (list of Process objects):\nA list of all the processes that define the system of ODEs.\nEach process is a <code>Process</code> object.</li>\n<li><strong>ode_method</strong> (str):\nMethod for the ODE solver to use.</li>\n<li><strong>time_unit</strong> (str):\nA string of the time unit to be used for describing the\nkinetics of the given processes.</li>\n</ul>\n"}, "abstochkin.de_calcs.DEcalcs.__init__": {"fullname": "abstochkin.de_calcs.DEcalcs.__init__", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">p0</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">t_min</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">t_max</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">processes</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">ode_method</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">time_unit</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, "abstochkin.de_calcs.DEcalcs.p0": {"fullname": "abstochkin.de_calcs.DEcalcs.p0", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.p0", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.t_min": {"fullname": "abstochkin.de_calcs.DEcalcs.t_min", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.t_min", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.t_max": {"fullname": "abstochkin.de_calcs.DEcalcs.t_max", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.t_max", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.processes": {"fullname": "abstochkin.de_calcs.DEcalcs.processes", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.processes", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.ode_method": {"fullname": "abstochkin.de_calcs.DEcalcs.ode_method", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.ode_method", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.time_unit": {"fullname": "abstochkin.de_calcs.DEcalcs.time_unit", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.time_unit", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.odes": {"fullname": "abstochkin.de_calcs.DEcalcs.odes", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.odes", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"fullname": "abstochkin.de_calcs.DEcalcs.odes_sol", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.odes_sol", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"fullname": "abstochkin.de_calcs.DEcalcs.species_with_ode", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.species_with_ode", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.jac": {"fullname": "abstochkin.de_calcs.DEcalcs.jac", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.jac", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.fixed_pts": {"fullname": "abstochkin.de_calcs.DEcalcs.fixed_pts", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.fixed_pts", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"fullname": "abstochkin.de_calcs.DEcalcs.setup_ODEs", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.setup_ODEs", "kind": "function", "doc": "<p>Set up the system of ODEs to be used for computing the\ndeterministic trajectory of all the species in the given processes.\nThe equations consist of sympy objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>agent_based : bool, default</strong> (True):\nIf True, set up the agent-based (or microscopic) form of ODEs.\nFor instance, for the process <code>2X -&gt; Y</code>, the ODE for species\n<code>X</code> would include an <code>X(X - 1)</code> term instead\nof <code>X^2</code> (the canonical form). If False, the canonical form\nof the ODEs is constructed.</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>The rate constant, <code>k</code>, for a given process is taken to be the mean\nof <code>k</code>, unless <code>k</code> was defined to be normally-distributed,\nin which case <code>k</code> is a 2-tuple and <code>k[0]</code> is the specified mean.</p>\n\n<p>Implementation note: Building up the ODE expressions by separately iterating\nover the processes for products and reactants. This is to properly\nhandle 0th order processes for product species. For example, for the\n0th order process ' --> X' with rate constant k1, the ODE is dX/dt = k1.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">agent_based</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"fullname": "abstochkin.de_calcs.DEcalcs.get_term_multiplier", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.get_term_multiplier", "kind": "function", "doc": "<p>Generate the multiplicative term (or terms) needed for generating the\ncorrect algebraic expressions for specialized processes\n(such as Michaelis-Menten and regulated processes).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">proc</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"fullname": "abstochkin.de_calcs.DEcalcs.solve_ODEs", "modulename": "abstochkin.de_calcs", "qualname": "DEcalcs.solve_ODEs", "kind": "function", "doc": "<p>Solve system of ordinary differential equations (ODEs).</p>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>Using the solver <code>scipy.integrate.solve_ivp</code>,\nwhose method can be one of the following:</p>\n\n<ul>\n<li>RK45 : Explicit Runge-Kutta method of order 5(4).</li>\n<li>RK23 : Explicit Runge-Kutta method of order 3(2).</li>\n<li>DOP853 : Explicit Runge-Kutta method of order 8.</li>\n<li>Radau : Implicit Runge-Kutta method of the Radau IIA family of order 5</li>\n<li>BDF : Implicit multistep variable-order (1 to 5) method based on a\nbackward differentiation formula for the derivative approximation.</li>\n<li>LSODA : Adams/BDF method with automatic stiffness detection and switching.</li>\n</ul>\n\n<h6 id=\"documentation\">Documentation</h6>\n\n<p><a href=\"https://docs.scipy.org/doc/scipy/reference/generated/scipy.integrate.solve_ivp.html\">https://docs.scipy.org/doc/scipy/reference/generated/scipy.integrate.solve_ivp.html</a></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.graphing": {"fullname": "abstochkin.graphing", "modulename": "abstochkin.graphing", "kind": "module", "doc": "<p>Graphing for AbStochKin simulations.</p>\n"}, "abstochkin.graphing.Graph": {"fullname": "abstochkin.graphing.Graph", "modulename": "abstochkin.graphing", "qualname": "Graph", "kind": "class", "doc": "<p>Graphing class for displaying the results of AbStochKin simulations.</p>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>To successfully use the LaTeX engine for rendering text on Linux,\nrun the following command in a terminal: <code>sudo apt install cm-super</code>.</p>\n"}, "abstochkin.graphing.Graph.__init__": {"fullname": "abstochkin.graphing.Graph.__init__", "modulename": "abstochkin.graphing", "qualname": "Graph.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">nrows</span><span class=\"o\">=</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">ncols</span><span class=\"o\">=</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">figsize</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"mi\">5</span><span class=\"p\">)</span>,</span><span class=\"param\">\t<span class=\"n\">dpi</span><span class=\"o\">=</span><span class=\"mi\">300</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">backend</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;matplotlib&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;plotly&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;matplotlib&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "abstochkin.graphing.Graph.backend": {"fullname": "abstochkin.graphing.Graph.backend", "modulename": "abstochkin.graphing", "qualname": "Graph.backend", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.graphing.Graph.setup_spines_ticks": {"fullname": "abstochkin.graphing.Graph.setup_spines_ticks", "modulename": "abstochkin.graphing", "qualname": "Graph.setup_spines_ticks", "kind": "function", "doc": "<p>Set up the spines and ticks in a <code>matplotlib</code> graph.\nMake only the left and bottom spines/axes visible on the graph\nand place major ticks on them. Also set the minor ticks.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">ax_loc</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.graphing.Graph.plot_ODEs": {"fullname": "abstochkin.graphing.Graph.plot_ODEs", "modulename": "abstochkin.graphing", "qualname": "Graph.plot_ODEs", "kind": "function", "doc": "<p>Plot the deterministic trajectories of all species obtained\nby obtaining the solution to a system of ODEs.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>de_data</strong> (DEcalcs object):\nData structure containing all the data related to\nsolving the system of ODEs.</li>\n<li><strong>num_pts : int, default</strong> (1000, optional):\nNumber of points used to calculate DE curves at.\nUsed to approximate a smooth/continuous curve.</li>\n<li><strong>species : sequence of strings, default</strong> ((), optional):\nAn iterable sequence of strings specifying the species\nnames to plot. If no species are specified (the default),\nthen all species trajectories are plotted.</li>\n<li><strong>show_plot : bool, default</strong> (True, optional):\nIf True, show the plot.</li>\n<li><strong>ax_loc</strong> (tuple, optional):\nIf the figure is made up of subplots, specify the location\nof the axis to draw the data at.\nEx: for two subplots, the possible values of <code>ax_loc</code>\nare (0, ) and (1, ). That's because the <code>self.ax</code> object is\na 1-D array. For figures with multiple rows and columns of\nsubplots, a 2-D tuple is needed.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">de_data</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">num_pts</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1000</span>,</span><span class=\"param\">\t<span class=\"n\">species</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">show_plot</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">ax_loc</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.graphing.Graph.plot_trajectories": {"fullname": "abstochkin.graphing.Graph.plot_trajectories", "modulename": "abstochkin.graphing", "qualname": "Graph.plot_trajectories", "kind": "function", "doc": "<p>Graph simulation time trajectories.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">time</span>,</span><span class=\"param\">\t<span class=\"n\">data</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">species</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">show_plot</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">ax_loc</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.graphing.Graph.plot_avg_std": {"fullname": "abstochkin.graphing.Graph.plot_avg_std", "modulename": "abstochkin.graphing", "qualname": "Graph.plot_avg_std", "kind": "function", "doc": "<p>Graph simulation average trajectories and\n1-standard-deviation envelopes.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">time</span>,</span><span class=\"param\">\t<span class=\"n\">data</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">species</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">show_plot</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">ax_loc</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.graphing.Graph.plot_eta": {"fullname": "abstochkin.graphing.Graph.plot_eta", "modulename": "abstochkin.graphing", "qualname": "Graph.plot_eta", "kind": "function", "doc": "<p>Graph the coefficient of variation.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">time</span>,</span><span class=\"param\">\t<span class=\"n\">data</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">species</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">show_plot</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">ax_loc</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.graphing.Graph.plot_het_metrics": {"fullname": "abstochkin.graphing.Graph.plot_het_metrics", "modulename": "abstochkin.graphing", "qualname": "Graph.plot_het_metrics", "kind": "function", "doc": "<p>Graph species- and process-specific metrics of population heterogeneity.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">time</span>,</span><span class=\"param\">\t<span class=\"n\">proc_str</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">proc_data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">het_attr</span><span class=\"o\">=</span><span class=\"s1\">&#39;k&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">show_plot</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">ax_loc</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.graphing.Graph.savefig": {"fullname": "abstochkin.graphing.Graph.savefig", "modulename": "abstochkin.graphing", "qualname": "Graph.savefig", "kind": "function", "doc": "<p>Save the figure as a file.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filename</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">image_format</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;svg&#39;</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.het_calcs": {"fullname": "abstochkin.het_calcs", "modulename": "abstochkin.het_calcs", "kind": "module", "doc": "<p>Some functions for calculating metrics of population heterogeneity.</p>\n"}, "abstochkin.het_calcs.ProcessClasses": {"fullname": "abstochkin.het_calcs.ProcessClasses", "modulename": "abstochkin.het_calcs", "qualname": "ProcessClasses", "kind": "variable", "doc": "<p></p>\n", "default_value": "abstochkin.process.Process | abstochkin.process.ReversibleProcess | abstochkin.process.MichaelisMentenProcess | abstochkin.process.RegulatedProcess | abstochkin.process.RegulatedMichaelisMentenProcess"}, "abstochkin.het_calcs.get_het_processes": {"fullname": "abstochkin.het_calcs.get_het_processes", "modulename": "abstochkin.het_calcs", "qualname": "get_het_processes", "kind": "function", "doc": "<p>Filter the heterogeneous processes from a given list of processes.\nA process is heterogeneous if any of its parameters are defined as such.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">processes</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">Process</span> <span class=\"o\">|</span> <span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">ReversibleProcess</span> <span class=\"o\">|</span> <span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">MichaelisMentenProcess</span> <span class=\"o\">|</span> <span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">RegulatedProcess</span> <span class=\"o\">|</span> <span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">RegulatedMichaelisMentenProcess</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">Process</span> <span class=\"o\">|</span> <span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">ReversibleProcess</span> <span class=\"o\">|</span> <span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">MichaelisMentenProcess</span> <span class=\"o\">|</span> <span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">RegulatedProcess</span> <span class=\"o\">|</span> <span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">RegulatedMichaelisMentenProcess</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "abstochkin.het_calcs.richness": {"fullname": "abstochkin.het_calcs.richness", "modulename": "abstochkin.het_calcs", "qualname": "richness", "kind": "function", "doc": "<p>Calculate the species richness, or how many subspecies\na species population comprises.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">arr</span><span class=\"p\">:</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "abstochkin.het_calcs.idx_het": {"fullname": "abstochkin.het_calcs.idx_het", "modulename": "abstochkin.het_calcs", "qualname": "idx_het", "kind": "function", "doc": "<p>Calculate the Index of Heterogeneity (\u03c8), defined as the probability\nthat two randomly chosen agents (without replacement) from a species\npopulation belong to different subspecies.</p>\n\n<ul>\n<li>A homogeneous population returns 0.</li>\n<li>A heterogeneous population with two distinct subspecies of equal\nfractional abundance (\u03c7=0.5) <em>approaches</em> 0.5 as the population\nsize increases.</li>\n<li>A fully heterogeneous population returns 1.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">arr</span><span class=\"p\">:</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "abstochkin.het_calcs.info_het": {"fullname": "abstochkin.het_calcs.info_het", "modulename": "abstochkin.het_calcs", "qualname": "info_het", "kind": "function", "doc": "<p>Information-theoretic measure of population heterogeneity.</p>\n\n<ul>\n<li>A homogeneous population returns 0.</li>\n<li>A heterogeneous population with two distinct subspecies of equal\nfractional abundance (\u03c7=0.5) returns ln(2). Note that this is\ntrue regardless of the population size.</li>\n<li>For a fully heterogeneous population, the measure increases\nwith population size and has no upper limit.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">arr</span><span class=\"p\">:</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "abstochkin.process": {"fullname": "abstochkin.process", "modulename": "abstochkin.process", "kind": "module", "doc": "<p>Define a process of the form Reactants -> Products.</p>\n"}, "abstochkin.process.Process": {"fullname": "abstochkin.process.Process", "modulename": "abstochkin.process", "qualname": "Process", "kind": "class", "doc": "<p>Define a unidirectional process: Reactants -> Products, where the\nReactants and Products are specified using standard chemical notation.\nThat is, stoichiometric coefficients (integers) and species names are\nspecified. For example: 2A + B -> C.</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>reactants</strong> (dict):\nThe reactants of a given process are specified with\nkey-value pairs describing each species name and its\nstoichiometric coefficient, respectively.</li>\n<li><strong>products</strong> (dict):\nThe products of a given process are specified with\nkey-value pairs describing each species name and its\nstoichiometric coefficient, respectively.</li>\n<li><strong>k</strong> (float, int, list of floats, tuple of floats):\nThe <em>microscopic</em> rate constant(s) for the given process. The data\ntype of <code>k</code> determines the \"structure\" of the population as follows:\n    - A homogeneous population: if <code>k</code> is a single value (float or int),\n      then the population is assumed to be homogeneous with all agents\n      of the reactant species having kinetics defined by this value.\n    - A heterogeneous population with a distinct number of subspecies\n      (each with a corresponding <code>k</code> value): if <code>k</code> is a list of floats,\n      then the population is assumed to be heterogeneous with a number\n      of subspecies equal to the length of the list.\n    - A heterogeneous population with normally-distributed <code>k</code> values:\n      If <code>k</code> is a tuple whose length is 2, then the population is\n      assumed to be heterogeneous with a normally distributed <code>k</code> value.\n      The two entries in the tuple represent the mean and standard\n      deviation (in that order) of the desired normal distribution.</li>\n<li><strong>volume : float, default</strong> (None, optional):\nThe volume <em>in liters</em> of the compartment in which the processes\nare taking place.</li>\n<li><strong>order</strong> (int):\nThe order of the process (or the molecularity of an elementary process).\nIt is the sum of the stoichiometric coefficients of the reactants.</li>\n<li><strong>species</strong> (set of strings):\nA set of all species in a process.</li>\n<li><strong>reacts_</strong> (list of strings):\nA list containing all the reactants in a process.</li>\n<li><strong>prods_</strong> (list of strings):\nA list containing all the products in a process.</li>\n</ul>\n\n<h6 id=\"methods\">Methods</h6>\n\n<p>from_string\n    Class method for creating a Process object from a string.</p>\n"}, "abstochkin.process.Process.__init__": {"fullname": "abstochkin.process.Process.__init__", "modulename": "abstochkin.process", "qualname": "Process.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">reactants</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">products</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "abstochkin.process.Process.reactants": {"fullname": "abstochkin.process.Process.reactants", "modulename": "abstochkin.process", "qualname": "Process.reactants", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.Process.products": {"fullname": "abstochkin.process.Process.products", "modulename": "abstochkin.process", "qualname": "Process.products", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.Process.k": {"fullname": "abstochkin.process.Process.k", "modulename": "abstochkin.process", "qualname": "Process.k", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.Process.volume": {"fullname": "abstochkin.process.Process.volume", "modulename": "abstochkin.process", "qualname": "Process.volume", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.Process.order": {"fullname": "abstochkin.process.Process.order", "modulename": "abstochkin.process", "qualname": "Process.order", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.Process.is_heterogeneous": {"fullname": "abstochkin.process.Process.is_heterogeneous", "modulename": "abstochkin.process", "qualname": "Process.is_heterogeneous", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.Process.species": {"fullname": "abstochkin.process.Process.species", "modulename": "abstochkin.process", "qualname": "Process.species", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.Process.reacts_": {"fullname": "abstochkin.process.Process.reacts_", "modulename": "abstochkin.process", "qualname": "Process.reacts_", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.Process.prods_": {"fullname": "abstochkin.process.Process.prods_", "modulename": "abstochkin.process", "qualname": "Process.prods_", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.Process.from_string": {"fullname": "abstochkin.process.Process.from_string", "modulename": "abstochkin.process", "qualname": "Process.from_string", "kind": "function", "doc": "<p>Create a process from a string.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>proc_str</strong> (str):\nA string describing the process in standard chemical notation\n(e.g., 'A + B -> C')</li>\n<li><strong>k</strong> (float or int or list of floats or 2-tuple of floats):\nThe rate constant for the given process. If <code>k</code> is a float or\nint, then the process is homogeneous. If <code>k</code> is a list, then\nthe population of the reactants constsists of distinct subspecies\nor subinteractions depending on the order. If <code>k</code> is a 2-tuple,\nthen the constant is normally-distributed with a mean and standard\ndeviation specified in the tuple's elements.</li>\n<li><strong>volume : float, default</strong> (None, optional):\nThe volume <em>in liters</em> of the compartment in which the processes\nare taking place.</li>\n<li><strong>sep : str, default</strong> ('->'):\nSpecifies the characters that distinguish the reactants from the\nproducts. The default is '->'. The code also treats <code>--&gt;</code> as a\ndefault, if it's present in <code>proc_str</code>.</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<ul>\n<li>Species names should not contain spaces, dashes, and\nshould start with a non-numeric character.</li>\n<li>Zeroth order processes should be specified by an empty space or 'None'.</li>\n</ul>\n\n<h6 id=\"examples\">Examples</h6>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Process</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;2A + B -&gt; X&quot;</span><span class=\"p\">,</span> <span class=\"mf\">0.3</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Process</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot; -&gt; Y&quot;</span><span class=\"p\">,</span> <span class=\"mf\">0.1</span><span class=\"p\">)</span>  <span class=\"c1\"># for a 0th order (birth) process.</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Process</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;Protein_X -&gt; None&quot;</span><span class=\"p\">,</span> <span class=\"mf\">0.15</span><span class=\"p\">)</span>  <span class=\"c1\"># for a 1st order degradation process.</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">proc_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;-&gt;&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.process.ReversibleProcess": {"fullname": "abstochkin.process.ReversibleProcess", "modulename": "abstochkin.process", "qualname": "ReversibleProcess", "kind": "class", "doc": "<p>Define a reversible process.</p>\n\n<p>The class-specific attributes are listed below.</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>k_rev</strong> (float or int or list of floats or 2-tuple of floats):\nThe <em>microscopic</em> rate constant for the reverse process.</li>\n<li><strong>is_heterogeneous_rev</strong> (bool):\nDenotes if the parameter <code>k_rev</code> exhibits heterogeneity\n(distinct subspecies/interactions or normally-distributed).</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>A <code>ReversibleProcess</code> object gets split into two <code>Process</code> objects\n(forward and reverse process) when the algorithm runs.</p>\n", "bases": "Process"}, "abstochkin.process.ReversibleProcess.__init__": {"fullname": "abstochkin.process.ReversibleProcess.__init__", "modulename": "abstochkin.process", "qualname": "ReversibleProcess.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">reactants</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">products</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">k_rev</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "abstochkin.process.ReversibleProcess.k_rev": {"fullname": "abstochkin.process.ReversibleProcess.k_rev", "modulename": "abstochkin.process", "qualname": "ReversibleProcess.k_rev", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"fullname": "abstochkin.process.ReversibleProcess.is_heterogeneous_rev", "modulename": "abstochkin.process", "qualname": "ReversibleProcess.is_heterogeneous_rev", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.ReversibleProcess.order_rev": {"fullname": "abstochkin.process.ReversibleProcess.order_rev", "modulename": "abstochkin.process", "qualname": "ReversibleProcess.order_rev", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.ReversibleProcess.from_string": {"fullname": "abstochkin.process.ReversibleProcess.from_string", "modulename": "abstochkin.process", "qualname": "ReversibleProcess.from_string", "kind": "function", "doc": "<p>Create a reversible process from a string.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>proc_str</strong> (str):\nA string describing the process in standard chemical notation\n(e.g., 'A + B &lt;-> C')</li>\n<li><strong>k</strong> (float or int or list of floats or 2-tuple of floats):\nThe <em>microscopic</em> rate constant for the forward process.</li>\n<li><strong>k_rev</strong> (float or int or list of floats or 2-tuple of floats):\nThe <em>microscopic</em> rate constant for the reverse process.</li>\n<li><strong>volume : float, default</strong> (None, optional):\nThe volume <em>in liters</em> of the compartment in which the processes\nare taking place.</li>\n<li><strong>sep : str, default</strong> ('&lt;->'):\nSpecifies the characters that distinguish the reactants from the\nproducts. The default is '&lt;->'. The code also treats <code>&lt;--&gt;</code> as a\ndefault, if it's present in <code>proc_str</code>.</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<ul>\n<li>Species names should not contain spaces, dashes, and\nshould start with a non-numeric character.</li>\n</ul>\n\n<h6 id=\"examples\">Examples</h6>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">ReversibleProcess</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;2A + B &lt;-&gt; X&quot;</span><span class=\"p\">,</span> <span class=\"mf\">0.3</span><span class=\"p\">,</span> <span class=\"n\">k_rev</span><span class=\"o\">=</span><span class=\"mf\">0.2</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">proc_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">k_rev</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&lt;-&gt;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.process.MichaelisMentenProcess": {"fullname": "abstochkin.process.MichaelisMentenProcess", "modulename": "abstochkin.process", "qualname": "MichaelisMentenProcess", "kind": "class", "doc": "<p>Define a process that obeys Michaelis-Menten kinetics.</p>\n\n<p>The class-specific attributes are listed below.</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>catalyst</strong> (str):\nName of the species acting as a catalyst for this process.</li>\n<li><strong>Km</strong> (float or int or list of floats or 2-tuple of floats):\n<em>Microscopic</em> Michaelis constant. Corresponds to the number\nof <code>catalyst</code> agents that would produce half-maximal activity.\nHeterogeneity in this parameter is determined by the type of <code>Km</code>,\nusing the same rules as for parameter <code>k</code>.</li>\n<li><strong>is_heterogeneous_Km</strong> (bool):\nDenotes if the parameter <code>Km</code> exhibits heterogeneity\n(distinct subspecies/interactions or normally-distributed).</li>\n</ul>\n", "bases": "Process"}, "abstochkin.process.MichaelisMentenProcess.__init__": {"fullname": "abstochkin.process.MichaelisMentenProcess.__init__", "modulename": "abstochkin.process", "qualname": "MichaelisMentenProcess.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">reactants</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">products</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">catalyst</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">Km</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "abstochkin.process.MichaelisMentenProcess.catalyst": {"fullname": "abstochkin.process.MichaelisMentenProcess.catalyst", "modulename": "abstochkin.process", "qualname": "MichaelisMentenProcess.catalyst", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.MichaelisMentenProcess.Km": {"fullname": "abstochkin.process.MichaelisMentenProcess.Km", "modulename": "abstochkin.process", "qualname": "MichaelisMentenProcess.Km", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"fullname": "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km", "modulename": "abstochkin.process", "qualname": "MichaelisMentenProcess.is_heterogeneous_Km", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.MichaelisMentenProcess.from_string": {"fullname": "abstochkin.process.MichaelisMentenProcess.from_string", "modulename": "abstochkin.process", "qualname": "MichaelisMentenProcess.from_string", "kind": "function", "doc": "<p>Create a Michaelis-Menten process from a string.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>proc_str</strong> (str):\nA string describing the process in standard chemical notation\n(e.g., 'A + B -> C')</li>\n<li><strong>k</strong> (float or int or list of floats or 2-tuple of floats):\nThe <em>microscopic</em> rate constant for the given process. If <code>k</code> is a\nfloat or int, then the process is homogeneous. If <code>k</code> is a list, then\nthe population of the reactants constsists of distinct subspecies\nor subinteractions depending on the order. If <code>k</code> is a 2-tuple,\nthen the constant is normally-distributed with a mean and standard\ndeviation specified in the tuple's elements.</li>\n<li><strong>catalyst</strong> (str):\nName of species acting as a catalyst.</li>\n<li><strong>Km</strong> (float or int or list of floats or 2-tuple of floats):\n<em>Microscopic</em> Michaelis constant for the process.\nHeterogeneity in this parameter is determined by the type of <code>Km</code>,\nusing the same rules as for parameter <code>k</code>.</li>\n<li><strong>volume : float, default</strong> (None, optional):\nThe volume <em>in liters</em> of the compartment in which the processes\nare taking place.</li>\n<li><strong>sep : str, default</strong> ('->'):\nSpecifies the characters that distinguish the reactants from the\nproducts. The default is '->'. The code also treats <code>--&gt;</code> as a\ndefault, if it's present in <code>proc_str</code>.</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<ul>\n<li>Species names should not contain spaces, dashes, and\nshould start with a non-numeric character.</li>\n<li>Zeroth order processes should be specified by an empty space or 'None'.</li>\n</ul>\n\n<h6 id=\"examples\">Examples</h6>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">MichaelisMentenProcess</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;A -&gt; X&quot;</span><span class=\"p\">,</span> <span class=\"n\">k</span><span class=\"o\">=</span><span class=\"mf\">0.3</span><span class=\"p\">,</span> <span class=\"n\">catalyst</span><span class=\"o\">=</span><span class=\"s1\">&#39;E&#39;</span><span class=\"p\">,</span> <span class=\"n\">Km</span><span class=\"o\">=</span><span class=\"mi\">10</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">MichaelisMentenProcess</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;A -&gt; X&quot;</span><span class=\"p\">,</span> <span class=\"n\">k</span><span class=\"o\">=</span><span class=\"mf\">0.3</span><span class=\"p\">,</span> <span class=\"n\">catalyst</span><span class=\"o\">=</span><span class=\"s1\">&#39;alpha&#39;</span><span class=\"p\">,</span> <span class=\"n\">Km</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">1</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">proc_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">catalyst</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">Km</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;-&gt;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.process.RegulatedProcess": {"fullname": "abstochkin.process.RegulatedProcess", "modulename": "abstochkin.process", "qualname": "RegulatedProcess", "kind": "class", "doc": "<p>Define a process that is regulated.</p>\n\n<p>This class allows a Process to be defined in terms of how it is regulated.\nIf there is only one regulating species, then the parameters have the same\ntype as would be expected for a homogeneous/heterogeneous process.\nIf there are multiple regulating species, then all parameters are a list\nof their expected type, with the length of the list being equal to the\nnumber of regulating species.</p>\n\n<p>The class-specific attributes (except for <code>k</code>, which requires some\nadditional notes) are listed below.</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>k</strong> (float or int or list of floats or 2-tuple of floats):\nThe <em>microscopic</em> rate constant for the given process. It is the <em>basal</em>\nrate constant in the case of activation (or the minimum <code>k</code> value)\nand the maximum rate constant in the case of repression.</li>\n<li><strong>regulating_species</strong> (str or list of str):\nName of the regulating species. Multiple species can be specified as\ncomma-separated in a string or a list of strings with the species names.</li>\n<li><p><strong>alpha</strong> (float or int or list[float or int]):\nParameter denoting the degree of activation/repression.</p>\n\n<pre><code>- 0 &lt;= alpha &lt; 1: repression\n- alpha = 1: no regulation\n- alpha &gt; 1: activation\n</code></pre>\n\n<p>alpha is a multiplier: in the case of activation, the maximum \nrate constant value will be <code>alpha * k</code>. \nIn the case of repression, the minimum \nrate constant value will be <code>alpha * k</code>.</p></li>\n<li><strong>K50</strong> (float or int or list of floats or 2-tuple of floats or list[float or int or list of floats or 2-tuple of floats]):\n<em>Microscopic</em> constant that corresponds to the number of\n<code>regulating_species</code> agents that would produce \nhalf-maximal activation/repression. \nHeterogeneity in this parameter is determined by the type of <code>K50</code>,\nusing the same rules as for parameter <code>k</code>.</li>\n<li><strong>nH</strong> (float or int or list[float or int]):\nHill coefficient for the given process. Indicates the degree of \ncooperativity in the regulatory interaction.</li>\n<li><strong>is_heterogeneous_K50</strong> (bool or list of bool):\nDenotes if the parameter <code>K50</code> exhibits heterogeneity\n(distinct subspecies/interactions or normally-distributed).</li>\n<li><strong>regulation_type</strong> (str or list of str):\nThe type of regulation for this process based on the value of alpha:\n'activation' or 'repression' or 'no regulation'.</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>Allowing a 0th order process to be regulated. However, heterogeneity\nin <code>k</code> and <code>K50</code> (or any other parameters) is not allowed for such\na process.</p>\n", "bases": "Process"}, "abstochkin.process.RegulatedProcess.__init__": {"fullname": "abstochkin.process.RegulatedProcess.__init__", "modulename": "abstochkin.process", "qualname": "RegulatedProcess.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">reactants</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">products</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">regulating_species</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">alpha</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">K50</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">nH</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "abstochkin.process.RegulatedProcess.alpha": {"fullname": "abstochkin.process.RegulatedProcess.alpha", "modulename": "abstochkin.process", "qualname": "RegulatedProcess.alpha", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.RegulatedProcess.K50": {"fullname": "abstochkin.process.RegulatedProcess.K50", "modulename": "abstochkin.process", "qualname": "RegulatedProcess.K50", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.RegulatedProcess.nH": {"fullname": "abstochkin.process.RegulatedProcess.nH", "modulename": "abstochkin.process", "qualname": "RegulatedProcess.nH", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.RegulatedProcess.from_string": {"fullname": "abstochkin.process.RegulatedProcess.from_string", "modulename": "abstochkin.process", "qualname": "RegulatedProcess.from_string", "kind": "function", "doc": "<p>Create a regulated process from a string.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>proc_str</strong> (str):\nA string describing the process in standard chemical notation\n(e.g., 'A + B -> C')</li>\n<li><strong>k</strong> (float or int or list of floats or 2-tuple of floats):\nThe <em>microscopic</em> rate constant for the given process. It is the <em>basal</em>\nrate constant in the case of activation (or the minimum <code>k</code> value) \nand the maximum rate constant in the case of repression. \nIf <code>k</code> is a float or int, then the process is homogeneous. \nIf <code>k</code> is a list, then the population of the reactants \nconstsists of distinct subspecies or subinteractions \ndepending on the order. If <code>k</code> is a 2-tuple,\nthen the constant is normally-distributed with a mean and standard\ndeviation specified in the tuple's elements. Note that <code>k</code> cannot\nbe zero for this form of regulation.</li>\n<li><strong>regulating_species</strong> (str or list of str):\nName of the regulating species.</li>\n<li><p><strong>alpha</strong> (float or int or list[float or int]):\nParameter denoting the degree of activation/repression.</p>\n\n<pre><code>- 0 &lt;= alpha &lt; 1: repression\n- alpha = 1: no regulation\n- alpha &gt; 1: activation\n</code></pre>\n\n<p>alpha is a multiplier: in the case of activation, the maximum \nrate constant value will be <code>alpha * k</code>. \nIn the case of repression, the minimum \nrate constant value will be <code>alpha * k</code>.</p></li>\n<li><strong>K50</strong> (float or int or list of floats or 2-tuple of floats or list of each of the previous types):\n<em>Microscopic</em> constant that corresponds to the number of\n<code>regulating_species</code> agents that would produce \nhalf-maximal activation/repression. \nHeterogeneity in this parameter is determined by the type of <code>K50</code>,\nusing the same rules as for parameter <code>k</code>.</li>\n<li><strong>nH</strong> (float or int or list[float or int]):\nHill coefficient for the given process. Indicates the degree of \ncooperativity in the regulatory interaction.</li>\n<li><strong>volume : float, default</strong> (None, optional):\nThe volume <em>in liters</em> of the compartment in which the processes\nare taking place.</li>\n<li><strong>sep : str, default</strong> ('->'):\nSpecifies the characters that distinguish the reactants from the\nproducts. The default is '->'. The code also treats <code>--&gt;</code> as a\ndefault, if it's present in <code>proc_str</code>.</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<ul>\n<li>Species names should not contain spaces, dashes, and\nshould start with a non-numeric character.</li>\n<li>Zeroth order processes should be specified by an empty space or 'None'.</li>\n</ul>\n\n<h6 id=\"examples\">Examples</h6>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">RegulatedProcess</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;A -&gt; X&quot;</span><span class=\"p\">,</span> <span class=\"n\">k</span><span class=\"o\">=</span><span class=\"mf\">0.2</span><span class=\"p\">,</span> <span class=\"n\">regulating_species</span><span class=\"o\">=</span><span class=\"s1\">&#39;X&#39;</span><span class=\"p\">,</span> <span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"n\">K50</span><span class=\"o\">=</span><span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"n\">nH</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">RegulatedProcess</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;A -&gt; X&quot;</span><span class=\"p\">,</span> <span class=\"n\">k</span><span class=\"o\">=</span><span class=\"mf\">0.3</span><span class=\"p\">,</span> <span class=\"n\">regulating_species</span><span class=\"o\">=</span><span class=\"s1\">&#39;X&#39;</span><span class=\"p\">,</span> <span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"mf\">0.5</span><span class=\"p\">,</span> <span class=\"n\">K50</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">],</span> <span class=\"n\">nH</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">RegulatedProcess</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;A + B -&gt; X&quot;</span><span class=\"p\">,</span> <span class=\"n\">k</span><span class=\"o\">=</span><span class=\"mf\">0.5</span><span class=\"p\">,</span> <span class=\"n\">regulating_species</span><span class=\"o\">=</span><span class=\"s1\">&#39;B, X&#39;</span><span class=\"p\">,</span> <span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">],</span> <span class=\"n\">K50</span><span class=\"o\">=</span><span class=\"p\">[(</span><span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"mi\">5</span><span class=\"p\">),</span> <span class=\"p\">[</span><span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">]],</span> <span class=\"n\">nH</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">proc_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">regulating_species</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">alpha</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">K50</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">nH</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;-&gt;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"fullname": "abstochkin.process.RegulatedMichaelisMentenProcess", "modulename": "abstochkin.process", "qualname": "RegulatedMichaelisMentenProcess", "kind": "class", "doc": "<p>Define a process that is regulated and obeys Michaelis-Menten kinetics.</p>\n\n<p>This class allows a Michaelis-Menten Process to be defined\nin terms of how it is regulated.\nIf there is only one regulating species, then the parameters have the same\ntype as would be expected for a homogeneous/heterogeneous process.\nIf there are multiple regulating species, then all parameters are a list\nof their expected type, with the length of the list being equal to the\nnumber of regulating species.</p>\n\n<p>The class-specific attributes (except for <code>k</code>, which requires some\nadditional notes) are listed below.</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>k</strong> (float or int or list of floats or 2-tuple of floats):\nThe <em>microscopic</em> rate constant for the given process. It is the <em>basal</em>\nrate constant in the case of activation (or the minimum <code>k</code> value)\nand the maximum rate constant in the case of repression.</li>\n<li><strong>regulating_species</strong> (str or list of str):\nName of the regulating species. Multiple species can be specified as\ncomma-separated in a string or a list of strings with the species names.</li>\n<li><p><strong>alpha</strong> (float or int or list[float or int]):\nParameter denoting the degree of activation/repression.</p>\n\n<pre><code>- 0 &lt;= alpha &lt; 1: repression\n- alpha = 1: no regulation\n- alpha &gt; 1: activation\n</code></pre>\n\n<p>alpha is a multiplier: in the case of activation, the maximum\nrate constant value will be <code>alpha * k</code>.\nIn the case of repression, the minimum\nrate constant value will be <code>alpha * k</code>.</p></li>\n<li><strong>K50</strong> (float or int or list of floats or 2-tuple of floats or list[float or int or list of floats or 2-tuple of floats]):\n<em>Microscopic</em> constant that corresponds to the number of\n<code>regulating_species</code> agents that would produce\nhalf-maximal activation/repression.\nHeterogeneity in this parameter is determined by the type of <code>K50</code>,\nusing the same rules as for parameter <code>k</code>.</li>\n<li><strong>nH</strong> (float or int or list[float or int]):\nHill coefficient for the given process. Indicates the degree of\ncooperativity in the regulatory interaction.</li>\n<li><strong>is_heterogeneous_K50</strong> (bool or list of bool):\nDenotes if the parameter <code>K50</code> exhibits heterogeneity\n(distinct subspecies/interactions or normally-distributed).</li>\n<li><strong>regulation_type</strong> (str or list of str):\nThe type of regulation for this process based on the value of alpha:\n'activation' or 'repression' or 'no regulation'.</li>\n<li><strong>catalyst</strong> (str):\nName of the species acting as a catalyst for this process.</li>\n<li><strong>Km</strong> (float or int or list of floats or 2-tuple of floats):\n<em>Microscopic</em> Michaelis constant. Corresponds to the number\nof <code>catalyst</code> agents that would produce half-maximal activity.\nHeterogeneity in this parameter is determined by the type of <code>K50</code>,\nusing the same rules as for parameter <code>k</code>.</li>\n<li><strong>is_heterogeneous_Km</strong> (bool):\nDenotes if the parameter <code>Km</code> exhibits heterogeneity\n(distinct subspecies/interactions or normally-distributed).</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>Currently only implemented for 1st order processes. 0th order processes\ncannot obey Michaelis-Menten kinetics and 2nd order Michaelis-Menten\nprocesses are not implemented yet.</p>\n", "bases": "RegulatedProcess"}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"fullname": "abstochkin.process.RegulatedMichaelisMentenProcess.__init__", "modulename": "abstochkin.process", "qualname": "RegulatedMichaelisMentenProcess.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">reactants</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">products</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">regulating_species</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">alpha</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">K50</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">nH</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">catalyst</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">Km</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst": {"fullname": "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst", "modulename": "abstochkin.process", "qualname": "RegulatedMichaelisMentenProcess.catalyst", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.RegulatedMichaelisMentenProcess.Km": {"fullname": "abstochkin.process.RegulatedMichaelisMentenProcess.Km", "modulename": "abstochkin.process", "qualname": "RegulatedMichaelisMentenProcess.Km", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"fullname": "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km", "modulename": "abstochkin.process", "qualname": "RegulatedMichaelisMentenProcess.is_heterogeneous_Km", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"fullname": "abstochkin.process.RegulatedMichaelisMentenProcess.from_string", "modulename": "abstochkin.process", "qualname": "RegulatedMichaelisMentenProcess.from_string", "kind": "function", "doc": "<p>Create a regulated Michaelis-Menten process from a string.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>proc_str</strong> (str):\nA string describing the process in standard chemical notation\n(e.g., 'A + B -> C')</li>\n<li><strong>k</strong> (float or int or list of floats or 2-tuple of floats):\nThe <em>microscopic</em> rate constant for the given process. It is the <em>basal</em>\nrate constant in the case of activation (or the minimum <code>k</code> value)\nand the maximum rate constant in the case of repression.\nIf <code>k</code> is a float or int, then the process is homogeneous.\nIf <code>k</code> is a list, then the population of the reactants\nconstsists of distinct subspecies or subinteractions\ndepending on the order. If <code>k</code> is a 2-tuple,\nthen the constant is normally-distributed with a mean and standard\ndeviation specified in the tuple's elements. Note that <code>k</code> cannot\nbe zero for this form of regulation.</li>\n<li><strong>regulating_species</strong> (str or list of str):\nName of the regulating species.</li>\n<li><p><strong>alpha</strong> (float or int or list[float or int]):\nParameter denoting the degree of activation/repression.</p>\n\n<ul>\n<li>0 &lt;= alpha &lt; 1: repression</li>\n<li>alpha = 1: no regulation</li>\n<li>alpha &gt; 1: activation</li>\n</ul>\n\n<p>alpha is a multiplier: in the case of activation, the maximum\nrate constant value will be <code>alpha * k</code>.\nIn the case of repression, the minimum\nrate constant value will be <code>alpha * k</code>.</p></li>\n<li><strong>K50</strong> (float or int or list of floats or 2-tuple of floats or list of each of the previous types):\n<em>Microscopic</em> constant that corresponds to the number of\n<code>regulating_species</code> agents that would produce\nhalf-maximal activation/repression.\nHeterogeneity in this parameter is determined by the type of <code>K50</code>,\nusing the same rules as for parameter <code>k</code>.</li>\n<li><strong>nH</strong> (float or int or list[float or int]):\nHill coefficient for the given process. Indicates the degree of\ncooperativity in the regulatory interaction.</li>\n<li><strong>catalyst</strong> (str):\nName of species acting as a catalyst.</li>\n<li><strong>Km</strong> (float or int or list of floats or 2-tuple of floats):\n<em>Microscopic</em> Michaelis constant for the process.\nHeterogeneity in this parameter is determined by the type of <code>Km</code>,\nusing the same rules as for parameter <code>k</code>.</li>\n<li><strong>volume : float, default</strong> (None, optional):\nThe volume <em>in liters</em> of the compartment in which the processes\nare taking place.</li>\n<li><strong>sep : str, default</strong> ('->'):\nSpecifies the characters that distinguish the reactants from the\nproducts. The default is '->'. The code also treats <code>--&gt;</code> as a\ndefault, if it's present in <code>proc_str</code>.</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<ul>\n<li>Species names should not contain spaces, dashes, and\nshould start with a non-numeric character.</li>\n<li>Zeroth order processes should be specified by an empty space or 'None'.</li>\n</ul>\n\n<h6 id=\"examples\">Examples</h6>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">RegulatedMichaelisMentenProcess</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;A -&gt; X&quot;</span><span class=\"p\">,</span> <span class=\"n\">k</span><span class=\"o\">=</span><span class=\"mf\">0.2</span><span class=\"p\">,</span> <span class=\"n\">regulating_species</span><span class=\"o\">=</span><span class=\"s1\">&#39;X&#39;</span><span class=\"p\">,</span> <span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"n\">K50</span><span class=\"o\">=</span><span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"n\">nH</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">catalyst</span><span class=\"o\">=</span><span class=\"s1\">&#39;E&#39;</span><span class=\"p\">,</span> <span class=\"n\">Km</span><span class=\"o\">=</span><span class=\"mi\">15</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">RegulatedMichaelisMentenProcess</span><span class=\"o\">.</span><span class=\"n\">from_string</span><span class=\"p\">(</span><span class=\"s2\">&quot;A -&gt; X&quot;</span><span class=\"p\">,</span> <span class=\"n\">k</span><span class=\"o\">=</span><span class=\"mf\">0.3</span><span class=\"p\">,</span> <span class=\"n\">regulating_species</span><span class=\"o\">=</span><span class=\"s1\">&#39;A&#39;</span><span class=\"p\">,</span> <span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"mf\">0.5</span><span class=\"p\">,</span> <span class=\"n\">K50</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">],</span> <span class=\"n\">nH</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"n\">catalyst</span><span class=\"o\">=</span><span class=\"s1\">&#39;C&#39;</span><span class=\"p\">,</span> <span class=\"n\">Km</span><span class=\"o\">=</span><span class=\"mi\">5</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">proc_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">regulating_species</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">alpha</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">K50</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">nH</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">catalyst</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">Km</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;-&gt;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "abstochkin.process.NullSpeciesNameError": {"fullname": "abstochkin.process.NullSpeciesNameError", "modulename": "abstochkin.process", "qualname": "NullSpeciesNameError", "kind": "class", "doc": "<p>Error when the species name is an empty string.</p>\n", "bases": "builtins.Exception"}, "abstochkin.process.update_all_species": {"fullname": "abstochkin.process.update_all_species", "modulename": "abstochkin.process", "qualname": "update_all_species", "kind": "function", "doc": "<p>Categorize all species in a list of processes.</p>\n\n<p>Extract all species from a list of processes. Then categorize each of them\nas a reactant or product and list the process(es) it takes part in.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>procs</strong> (tuple):\nA tuple of objects of type <code>Process</code> or its subclasses.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>tuple</strong>: all_species : set of strings\nA set of all species present in the processes.\nprocs_by_reactant : dict\nA dictionary whose keys are the species that are\nreactants in one or more processes. The value for each\nkey is a list of processes.\nprocs_by_product : dict\nA dictionary whose keys are the species that are\nproducts in one or more processes. The value for each\nkey is a list of processes.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">procs</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">abstochkin</span><span class=\"o\">.</span><span class=\"n\">process</span><span class=\"o\">.</span><span class=\"n\">Process</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">set</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "abstochkin.simulation": {"fullname": "abstochkin.simulation", "modulename": "abstochkin.simulation", "kind": "module", "doc": "<p>Perform an Agent-based Kinetics simulation.</p>\n\n<p>This module contains the code for the class <code>Simulation</code>,\nwhich, along with the <code>SimulationMethodsMixin</code> class,\ndoes everything that is needed to run an\nAgent-based Kinetics simulation and store its results.</p>\n\n<p>The class <code>AgentStateData</code> is used by a <code>Simulation</code>\nobject to store and handle some of the necessary runtime data.</p>\n"}, "abstochkin.simulation.Simulation": {"fullname": "abstochkin.simulation.Simulation", "modulename": "abstochkin.simulation", "qualname": "Simulation", "kind": "class", "doc": "<p>Run an Agent-based Kinetics simulation.</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>p0 : dict[str</strong> (int]):\nDictionary specifying the initial population sizes of all\nspecies in the given processes.</li>\n<li><strong>t_max</strong> (float or int):\nNumerical value of the end of simulated time in the units\nspecified in the class attribute <code>AbStochKin.time_unit</code>.</li>\n<li><strong>dt</strong> (float):\nThe duration of the time interval that the simulation's\nalgorithm considers. The current implementation only\nsupports a fixed time step interval whose value is <code>dt</code>.</li>\n<li><strong>n</strong> (int):\nThe number of repetitions of the simulation to be\nperformed.</li>\n<li><strong>random_state</strong> (float or int):\nA number used to seed the random number generator.</li>\n<li><strong>use_multithreading</strong> (bool):\nSpecify whether to parallelize the simulation\nusing multithreading. If <code>False</code>, the ensemble\nof simulations is run sequentially.</li>\n<li><strong>max_agents</strong> (dict):\nSpecification of the maximum number of agents that each\nspecies should have when running the simulation. An\nempty dictionary signifies that a default approach will\nbe taken and the number for each species will be\nautomatically determined (see method <code>_setup_runtime_data()</code>\nfor details). The entries in the dictionary should be\n<code>species name (string): number (int)</code>.</li>\n<li><strong>max_agents_multiplier</strong> (float or int):\nSet the number of possible agents for each species to be the\nmaximum value of the ODE solution for the species\ntimes <code>max_agents_multiplier</code>.</li>\n<li><strong>time_unit</strong> (str):\nA string of the time unit to be used for describing the\nkinetics of the given processes.</li>\n</ul>\n", "bases": "abstochkin._simulation_methods.SimulationMethodsMixin"}, "abstochkin.simulation.Simulation.__init__": {"fullname": "abstochkin.simulation.Simulation.__init__", "modulename": "abstochkin.simulation", "qualname": "Simulation.__init__", "kind": "function", "doc": "<p>The parameters below are not class attributes, but are part of a\n<code>Simulation</code> object's initialization to trigger specific actions\nto be automatically performed. Note that these actions can also\nbe performed manually by calling the appropriate methods once a\nclass object has been instantiated.</p>\n\n<h6 id=\"other-parameters\">Other Parameters</h6>\n\n<ul>\n<li><strong>do_solve_ODEs</strong> (bool):\nIf <code>True</code>, attempt to numerically solve the system\nof ODEs defined from the given set of processes.\nIf <code>False</code>, do not attempt to solve the ODEs and\ndo not run the simulation.</li>\n<li><strong>ODE_method</strong> (str):\nMethod to use when attempting to solve the system\nof ODEs (if <code>do_solve_ODEs</code> is <code>True</code>).\nAvailable ODE methods: RK45, RK23, DOP853, Radau,\nBDF, LSODA.</li>\n<li><strong>do_run</strong> (bool):\nSpecify whether to run the AbStochKin simulation.\nIf <code>False</code>, then a <code>Simulation</code> object is created but\nthe simulation is not run. A user can then manually\nrun it by calling the class method <code>run_simulation()</code>.</li>\n<li><strong>show_graphs</strong> (bool):\nSpecify whether to show graphs of the results.</li>\n<li><strong>graph_backend</strong> (str):\n<code>Matplotlib</code> and <code>Plotly</code> are currently supported.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">p0</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">t_max</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">dt</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">n</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">processes</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">random_state</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">do_solve_ODEs</span><span class=\"p\">:</span> <span class=\"nb\">bool</span>,</span><span class=\"param\">\t<span class=\"n\">ODE_method</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">do_run</span><span class=\"p\">:</span> <span class=\"nb\">bool</span>,</span><span class=\"param\">\t<span class=\"n\">show_graphs</span><span class=\"p\">:</span> <span class=\"nb\">bool</span>,</span><span class=\"param\">\t<span class=\"n\">graph_backend</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;matplotlib&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;plotly&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">use_multithreading</span><span class=\"p\">:</span> <span class=\"nb\">bool</span>,</span><span class=\"param\">\t<span class=\"n\">max_agents</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">max_agents_multiplier</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">time_unit</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, "abstochkin.simulation.Simulation.p0": {"fullname": "abstochkin.simulation.Simulation.p0", "modulename": "abstochkin.simulation", "qualname": "Simulation.p0", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.t_min": {"fullname": "abstochkin.simulation.Simulation.t_min", "modulename": "abstochkin.simulation", "qualname": "Simulation.t_min", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.t_max": {"fullname": "abstochkin.simulation.Simulation.t_max", "modulename": "abstochkin.simulation", "qualname": "Simulation.t_max", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.dt": {"fullname": "abstochkin.simulation.Simulation.dt", "modulename": "abstochkin.simulation", "qualname": "Simulation.dt", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.n": {"fullname": "abstochkin.simulation.Simulation.n", "modulename": "abstochkin.simulation", "qualname": "Simulation.n", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.random_state": {"fullname": "abstochkin.simulation.Simulation.random_state", "modulename": "abstochkin.simulation", "qualname": "Simulation.random_state", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.use_multithreading": {"fullname": "abstochkin.simulation.Simulation.use_multithreading", "modulename": "abstochkin.simulation", "qualname": "Simulation.use_multithreading", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.max_agents": {"fullname": "abstochkin.simulation.Simulation.max_agents", "modulename": "abstochkin.simulation", "qualname": "Simulation.max_agents", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"fullname": "abstochkin.simulation.Simulation.max_agents_multiplier", "modulename": "abstochkin.simulation", "qualname": "Simulation.max_agents_multiplier", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.time_unit": {"fullname": "abstochkin.simulation.Simulation.time_unit", "modulename": "abstochkin.simulation", "qualname": "Simulation.time_unit", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.streams": {"fullname": "abstochkin.simulation.Simulation.streams", "modulename": "abstochkin.simulation", "qualname": "Simulation.streams", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.de_calcs": {"fullname": "abstochkin.simulation.Simulation.de_calcs", "modulename": "abstochkin.simulation", "qualname": "Simulation.de_calcs", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.graph_backend": {"fullname": "abstochkin.simulation.Simulation.graph_backend", "modulename": "abstochkin.simulation", "qualname": "Simulation.graph_backend", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.total_time": {"fullname": "abstochkin.simulation.Simulation.total_time", "modulename": "abstochkin.simulation", "qualname": "Simulation.total_time", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.t_steps": {"fullname": "abstochkin.simulation.Simulation.t_steps", "modulename": "abstochkin.simulation", "qualname": "Simulation.t_steps", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.time": {"fullname": "abstochkin.simulation.Simulation.time", "modulename": "abstochkin.simulation", "qualname": "Simulation.time", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.trans_p": {"fullname": "abstochkin.simulation.Simulation.trans_p", "modulename": "abstochkin.simulation", "qualname": "Simulation.trans_p", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.k_vals": {"fullname": "abstochkin.simulation.Simulation.k_vals", "modulename": "abstochkin.simulation", "qualname": "Simulation.k_vals", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.Km_vals": {"fullname": "abstochkin.simulation.Simulation.Km_vals", "modulename": "abstochkin.simulation", "qualname": "Simulation.Km_vals", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.K50_vals": {"fullname": "abstochkin.simulation.Simulation.K50_vals", "modulename": "abstochkin.simulation", "qualname": "Simulation.K50_vals", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.k_het_metrics": {"fullname": "abstochkin.simulation.Simulation.k_het_metrics", "modulename": "abstochkin.simulation", "qualname": "Simulation.k_het_metrics", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.Km_het_metrics": {"fullname": "abstochkin.simulation.Simulation.Km_het_metrics", "modulename": "abstochkin.simulation", "qualname": "Simulation.Km_het_metrics", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.K50_het_metrics": {"fullname": "abstochkin.simulation.Simulation.K50_het_metrics", "modulename": "abstochkin.simulation", "qualname": "Simulation.K50_het_metrics", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.algo_sequence": {"fullname": "abstochkin.simulation.Simulation.algo_sequence", "modulename": "abstochkin.simulation", "qualname": "Simulation.algo_sequence", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.progress_bar": {"fullname": "abstochkin.simulation.Simulation.progress_bar", "modulename": "abstochkin.simulation", "qualname": "Simulation.progress_bar", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.graphs": {"fullname": "abstochkin.simulation.Simulation.graphs", "modulename": "abstochkin.simulation", "qualname": "Simulation.graphs", "kind": "variable", "doc": "<p></p>\n"}, "abstochkin.simulation.Simulation.run_simulation": {"fullname": "abstochkin.simulation.Simulation.run_simulation", "modulename": "abstochkin.simulation", "qualname": "Simulation.run_simulation", "kind": "function", "doc": "<p>Run an ensemble of simulations and compute statistics\nof simulation data.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.simulation.Simulation.graph_results": {"fullname": "abstochkin.simulation.Simulation.graph_results", "modulename": "abstochkin.simulation", "qualname": "Simulation.graph_results", "kind": "function", "doc": "<p>Make graphs of the results.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>species_to_show : <code>None</code> or list of string(s), default</strong> (<code>None</code>):\nIf <code>None</code>, data for all species are plotted.</li>\n<li><p><strong>graphs_to_show : <code>None</code> or string or list of string(s), default</strong> (<code>None</code>):\nIf <code>None</code>, all graphs are shown. If a string is given then the\ngraph that matches the string is shown. A list of strings shows\nall the graphs specified in the list.\nGraph specifications:</p>\n\n<p>'avg' : Plot the average trajectories and their\n    one-standard deviation envelopes. The ODE\n    trajectories are also shown.\n'traj' : Plot the species trajectories of individual\n    simulations.\n'ode' : Plot the deterministic species trajectories,\n    obtained by numerically solving the ODEs.\n'eta' : Plot the coefficient of variation (CoV) and\n    the CoV assuming that all processes a species\n    participates in obey Poisson statistics.\n'het' : Plot species- and process-specific metrics\n    of heterogeneity (<code>k</code> and <code>\u03c8</code>) and their\n    one-standard deviation envelopes.</p></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span>, </span><span class=\"param\"><span class=\"n\">graphs_to_show</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">species_to_show</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.utils": {"fullname": "abstochkin.utils", "modulename": "abstochkin.utils", "kind": "module", "doc": "<p>Some utility functions on generating random number streams, measuring a\nfunction's runtime, calculating a statistic measuring the goodness of fit\nwhen comparing time series data, and performing unit conversion of\nkinetic parameters.</p>\n"}, "abstochkin.utils.rng_streams": {"fullname": "abstochkin.utils.rng_streams", "modulename": "abstochkin.utils", "qualname": "rng_streams", "kind": "function", "doc": "<p>Generate independent streams of random numbers spawned from the\nsame initial seed.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>n</strong> (int):\nnumber of generators/streams to generate.</li>\n<li><strong>random_state</strong> (int, optional):\ninitial seed from which n new seeds are spawned.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>list[PCG64DXSM Generator objects]</strong>: List of <code>n</code> generators of independent streams of random numbers</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>See <a href=\"https://numpy.org/doc/stable/reference/random/parallel.html\">https://numpy.org/doc/stable/reference/random/parallel.html</a> for more info.</p>\n\n<p>On PCG64DXSM:\n    - <a href=\"https://numpy.org/doc/stable/reference/random/upgrading-pcg64.html#upgrading-pcg64\">https://numpy.org/doc/stable/reference/random/upgrading-pcg64.html#upgrading-pcg64</a>\n    - <a href=\"https://numpy.org/doc/stable/reference/random/bit_generators/pcg64dxsm.html\">https://numpy.org/doc/stable/reference/random/bit_generators/pcg64dxsm.html</a></p>\n\n<h6 id=\"examples\">Examples</h6>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">rng</span> <span class=\"o\">=</span> <span class=\"n\">rng_streams</span><span class=\"p\">(</span><span class=\"mi\">5</span><span class=\"p\">)</span>  <span class=\"c1\"># make 5 random number generators</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">a</span> <span class=\"o\">=</span> <span class=\"n\">rng</span><span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">integers</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">100</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">n</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">random_state</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.utils.measure_runtime": {"fullname": "abstochkin.utils.measure_runtime", "modulename": "abstochkin.utils", "qualname": "measure_runtime", "kind": "function", "doc": "<p>Decorator for measuring the duration of a function's execution.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fcn</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "abstochkin.utils.r_squared": {"fullname": "abstochkin.utils.r_squared", "modulename": "abstochkin.utils", "qualname": "r_squared", "kind": "function", "doc": "<p>Compute the coefficient of determination, $R^2$.</p>\n\n<p>In the case of comparing the average AbStochKin-simulated species\ntrajectory to its deterministic trajectory. Since the latter is only\nmeaningful for a homogeneous population, R\u00b2 should be\nclose to <code>1</code> for a simulated homogeneous process.\nFor a heterogeneous process, it can be interpreted as how close\nthe simulated trajectory is to the deterministic trajectory of a\n<em>homogeneous</em> process. In this case, $R^2$ would not be expected\nto be close to $1$ and the importance of looking at this metric\nis questionable.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>actual</strong> (numpy.array):\nActual data obtained through a simulation.</li>\n<li><strong>theoretical</strong> (numpy.array):\nTheoretical data to compare the actual data to.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>float</strong>: The coefficient of determination, $R^2$.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">actual</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">built</span><span class=\"o\">-</span><span class=\"ow\">in</span> <span class=\"n\">function</span> <span class=\"n\">array</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">theoretical</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">built</span><span class=\"o\">-</span><span class=\"ow\">in</span> <span class=\"n\">function</span> <span class=\"n\">array</span><span class=\"o\">&gt;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "abstochkin.utils.macro_to_micro": {"fullname": "abstochkin.utils.macro_to_micro", "modulename": "abstochkin.utils", "qualname": "macro_to_micro", "kind": "function", "doc": "<p>Convert a kinetic parameter value from macroscopic to microscopic form.</p>\n\n<p>The ABK algorithm uses microscopic kinetic constants, thus necessitating\nthe conversion of any molar quantities to their microscopic counterpart.\nFor a kinetic parameter, the microscopic form is interpreted as the number\nof transition events per second (or whatever the time unit may be).\nFor a molar quantity, its microscopic form is the number of particles in\nthe given volume.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>macro_val</strong> (float or int):\nThe value of the parameter to be converted, expressed in terms of\nmolar quantities.</li>\n<li><strong>volume</strong> (float or int):\nThe volume, in liters, in which the process that the given parameter\nvalue is a descriptor of.</li>\n<li><strong>order : int, default</strong> (0):\nThe order of the process whose kinetic parameter is to be converted.\nThe default value of 0 is for parameters (such as Km or K50) whose\nunits are molarity.</li>\n<li><strong>inverse : bool, default</strong> (False):\nPerform the inverse of this operation. That is, convert\nfrom microscopic to macroscopic form.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>float</strong>: A kinetic parameter is returned in units of reciprocal seconds.\nA molar quantity is returned as the number of particles in the\ngiven volume.</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<ul>\n<li>A kinetic parameter for a 1st order process will remain unchanged\nbecause its units are already reciprocal seconds.</li>\n</ul>\n\n<h6 id=\"reference\">Reference</h6>\n\n<p>Plakantonakis, Alex. \u201cAgent-based Kinetics: A Nonspatial Stochastic Method\nfor Simulating the Dynamics of Heterogeneous Populations.\u201d\nOSF Preprints, 26 July 2019. Web. Section 2.1.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">macro_val</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">volume</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">order</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">inverse</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"abstochkin": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "abstochkin.agentstatedata": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 19}, "abstochkin.agentstatedata.AgentStateData": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 217}, "abstochkin.agentstatedata.AgentStateData.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 3}, "abstochkin.agentstatedata.AgentStateData.p_init": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.agentstatedata.AgentStateData.max_agents": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.agentstatedata.AgentStateData.reps": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.agentstatedata.AgentStateData.fill_state": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.agentstatedata.AgentStateData.asv_ini": {"qualname": 3, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.agentstatedata.AgentStateData.asv": {"qualname": 2, "fullname": 4, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 40}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 12}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 111}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 91, "bases": 0, "doc": 117}, "abstochkin.base": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 371}, "abstochkin.base.AbStochKin": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 198}, "abstochkin.base.AbStochKin.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 3}, "abstochkin.base.AbStochKin.volume": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.base.AbStochKin.volume_unit": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.base.AbStochKin.time_unit": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.base.AbStochKin.processes": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.base.AbStochKin.het_processes": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.base.AbStochKin.sims": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.base.AbStochKin.add_processes_from_file": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 12}, "abstochkin.base.AbStochKin.extract_process_from_str": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 44}, "abstochkin.base.AbStochKin.add_process_from_str": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 110, "bases": 0, "doc": 33}, "abstochkin.base.AbStochKin.add_process": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 120, "bases": 0, "doc": 35}, "abstochkin.base.AbStochKin.del_process_from_str": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 13}, "abstochkin.base.AbStochKin.del_process": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 120, "bases": 0, "doc": 15}, "abstochkin.base.AbStochKin.simulate": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 310, "bases": 0, "doc": 523}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 410}, "abstochkin.de_calcs": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 25}, "abstochkin.de_calcs.DEcalcs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 180}, "abstochkin.de_calcs.DEcalcs.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 86, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.p0": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.t_min": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.t_max": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.processes": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.ode_method": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.time_unit": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.odes": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.jac": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.fixed_pts": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 210}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 26}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 140}, "abstochkin.graphing": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "abstochkin.graphing.Graph": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 43}, "abstochkin.graphing.Graph.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 116, "bases": 0, "doc": 3}, "abstochkin.graphing.Graph.backend": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.graphing.Graph.setup_spines_ticks": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 37}, "abstochkin.graphing.Graph.plot_ODEs": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 123, "bases": 0, "doc": 207}, "abstochkin.graphing.Graph.plot_trajectories": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 109, "bases": 0, "doc": 7}, "abstochkin.graphing.Graph.plot_avg_std": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 109, "bases": 0, "doc": 12}, "abstochkin.graphing.Graph.plot_eta": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 109, "bases": 0, "doc": 8}, "abstochkin.graphing.Graph.plot_het_metrics": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 118, "bases": 0, "doc": 12}, "abstochkin.graphing.Graph.savefig": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 9}, "abstochkin.het_calcs": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "abstochkin.het_calcs.ProcessClasses": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 19, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.het_calcs.get_het_processes": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 194, "bases": 0, "doc": 26}, "abstochkin.het_calcs.richness": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 15}, "abstochkin.het_calcs.idx_het": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 76}, "abstochkin.het_calcs.info_het": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 70}, "abstochkin.process": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "abstochkin.process.Process": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 418}, "abstochkin.process.Process.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 142, "bases": 0, "doc": 3}, "abstochkin.process.Process.reactants": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.Process.products": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.Process.k": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.Process.volume": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.Process.order": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.Process.is_heterogeneous": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.Process.species": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.Process.reacts_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.Process.prods_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.Process.from_string": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 147, "bases": 0, "doc": 388}, "abstochkin.process.ReversibleProcess": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 106}, "abstochkin.process.ReversibleProcess.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 189, "bases": 0, "doc": 3}, "abstochkin.process.ReversibleProcess.k_rev": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.ReversibleProcess.order_rev": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.ReversibleProcess.from_string": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 202, "bases": 0, "doc": 270}, "abstochkin.process.MichaelisMentenProcess": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 133}, "abstochkin.process.MichaelisMentenProcess.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 235, "bases": 0, "doc": 3}, "abstochkin.process.MichaelisMentenProcess.catalyst": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.MichaelisMentenProcess.Km": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.MichaelisMentenProcess.from_string": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 254, "bases": 0, "doc": 471}, "abstochkin.process.RegulatedProcess": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 486}, "abstochkin.process.RegulatedProcess.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 392, "bases": 0, "doc": 3}, "abstochkin.process.RegulatedProcess.alpha": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.RegulatedProcess.K50": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.RegulatedProcess.nH": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.RegulatedProcess.from_string": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 425, "bases": 0, "doc": 827}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 594}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 475, "bases": 0, "doc": 3}, "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.RegulatedMichaelisMentenProcess.Km": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 522, "bases": 0, "doc": 818}, "abstochkin.process.NullSpeciesNameError": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 12}, "abstochkin.process.update_all_species": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 60, "bases": 0, "doc": 156}, "abstochkin.simulation": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 73}, "abstochkin.simulation.Simulation": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 311}, "abstochkin.simulation.Simulation.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 214, "bases": 0, "doc": 230}, "abstochkin.simulation.Simulation.p0": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.t_min": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.t_max": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.dt": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.n": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.random_state": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.use_multithreading": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.max_agents": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.time_unit": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.streams": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.de_calcs": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.graph_backend": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.total_time": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.t_steps": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.time": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.trans_p": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.k_vals": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.Km_vals": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.K50_vals": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.k_het_metrics": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.Km_het_metrics": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.K50_het_metrics": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.algo_sequence": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.progress_bar": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.graphs": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "abstochkin.simulation.Simulation.run_simulation": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 14}, "abstochkin.simulation.Simulation.graph_results": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 197}, "abstochkin.utils": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 36}, "abstochkin.utils.rng_streams": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 206}, "abstochkin.utils.measure_runtime": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 13}, "abstochkin.utils.r_squared": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 155}, "abstochkin.utils.macro_to_micro": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 178, "bases": 0, "doc": 296}}, "length": 140, "save": true}, "index": {"qualname": {"root": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.base.AbStochKin.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.Process.reacts_": {"tf": 1}, "abstochkin.process.Process.prods_": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 12, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1}}, "df": 3, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.reps": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.asv": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 12}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {"abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.asv": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}}, "df": 3}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.__init__": {"tf": 1}, "abstochkin.base.AbStochKin.volume": {"tf": 1}, "abstochkin.base.AbStochKin.volume_unit": {"tf": 1}, "abstochkin.base.AbStochKin.time_unit": {"tf": 1}, "abstochkin.base.AbStochKin.processes": {"tf": 1}, "abstochkin.base.AbStochKin.het_processes": {"tf": 1}, "abstochkin.base.AbStochKin.sims": {"tf": 1}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 16}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}}, "df": 3}}, "v": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.process.RegulatedProcess.alpha": {"tf": 1}}, "df": 1}}}, "l": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}}, "df": 1}, "g": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.simulation.Simulation.algo_sequence": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1, "i": {"docs": {"abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1}}, "df": 1, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1}, "abstochkin.base.AbStochKin.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 11}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 1}}, "s": {"docs": {"abstochkin.process.Process.is_heterogeneous": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}}, "df": 4}}, "p": {"0": {"docs": {"abstochkin.de_calcs.DEcalcs.p0": {"tf": 1}, "abstochkin.simulation.Simulation.p0": {"tf": 1}}, "df": 2}, "docs": {"abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1}, "abstochkin.simulation.Simulation.trans_p": {"tf": 1}}, "df": 2, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.Process.reactants": {"tf": 1}, "abstochkin.process.Process.products": {"tf": 1}, "abstochkin.process.Process.k": {"tf": 1}, "abstochkin.process.Process.volume": {"tf": 1}, "abstochkin.process.Process.order": {"tf": 1}, "abstochkin.process.Process.is_heterogeneous": {"tf": 1}, "abstochkin.process.Process.species": {"tf": 1}, "abstochkin.process.Process.reacts_": {"tf": 1}, "abstochkin.process.Process.prods_": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}}, "df": 17, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.processes": {"tf": 1}, "abstochkin.base.AbStochKin.het_processes": {"tf": 1}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.processes": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}}, "df": 5}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.ProcessClasses": {"tf": 1}}, "df": 1}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.products": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"abstochkin.process.Process.prods_": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.progress_bar": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}}, "df": 5}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1}}, "df": 5}, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1}, "abstochkin.simulation.Simulation.t_min": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.simulation.Simulation.use_multithreading": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "r": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.reps": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.reactants": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"abstochkin.process.Process.reacts_": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {"abstochkin.process.ReversibleProcess.k_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.order_rev": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.k_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.order_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.alpha": {"tf": 1}, "abstochkin.process.RegulatedProcess.K50": {"tf": 1}, "abstochkin.process.RegulatedProcess.nH": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}}, "df": 6}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.richness": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.simulation.Simulation.random_state": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation.Simulation.run_simulation": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1}}, "df": 1}, "e": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 9}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1}, "abstochkin.simulation.Simulation.random_state": {"tf": 1}}, "df": 2}}}, "r": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.streams": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {"abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.t_steps": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.sims": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.p0": {"tf": 1}, "abstochkin.simulation.Simulation.t_min": {"tf": 1}, "abstochkin.simulation.Simulation.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.dt": {"tf": 1}, "abstochkin.simulation.Simulation.n": {"tf": 1}, "abstochkin.simulation.Simulation.random_state": {"tf": 1}, "abstochkin.simulation.Simulation.use_multithreading": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1}, "abstochkin.simulation.Simulation.time_unit": {"tf": 1}, "abstochkin.simulation.Simulation.streams": {"tf": 1}, "abstochkin.simulation.Simulation.de_calcs": {"tf": 1}, "abstochkin.simulation.Simulation.graph_backend": {"tf": 1}, "abstochkin.simulation.Simulation.total_time": {"tf": 1}, "abstochkin.simulation.Simulation.t_steps": {"tf": 1}, "abstochkin.simulation.Simulation.time": {"tf": 1}, "abstochkin.simulation.Simulation.trans_p": {"tf": 1}, "abstochkin.simulation.Simulation.k_vals": {"tf": 1}, "abstochkin.simulation.Simulation.Km_vals": {"tf": 1}, "abstochkin.simulation.Simulation.K50_vals": {"tf": 1}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.algo_sequence": {"tf": 1}, "abstochkin.simulation.Simulation.progress_bar": {"tf": 1}, "abstochkin.simulation.Simulation.graphs": {"tf": 1}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 30}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 2}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation.Simulation.algo_sequence": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1}}, "df": 1, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}, "abstochkin.process.Process.species": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 3}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.MichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.de_calcs": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}}, "df": 4}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.graphing.Graph.backend": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}, "abstochkin.simulation.Simulation.graph_backend": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 12, "s": {"docs": {"abstochkin.simulation.Simulation.graphs": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.simulation.Simulation.k_vals": {"tf": 1}, "abstochkin.simulation.Simulation.Km_vals": {"tf": 1}, "abstochkin.simulation.Simulation.K50_vals": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.volume": {"tf": 1}, "abstochkin.base.AbStochKin.volume_unit": {"tf": 1}, "abstochkin.process.Process.volume": {"tf": 1}}, "df": 3}}}}}}, "o": {"1": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}}, "df": 1}, "2": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}}, "df": 2, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.odes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 5}}}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.process.Process.order": {"tf": 1}, "abstochkin.process.ReversibleProcess.order_rev": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.volume_unit": {"tf": 1}, "abstochkin.base.AbStochKin.time_unit": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1}, "abstochkin.simulation.Simulation.time_unit": {"tf": 1}}, "df": 4}}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation.Simulation.use_multithreading": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.t_min": {"tf": 1}, "abstochkin.simulation.Simulation.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.t_steps": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.time_unit": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1}, "abstochkin.simulation.Simulation.time_unit": {"tf": 1}, "abstochkin.simulation.Simulation.total_time": {"tf": 1}, "abstochkin.simulation.Simulation.time": {"tf": 1}}, "df": 5}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.trans_p": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.simulation.Simulation.total_time": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.het_processes": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1}}, "df": 8, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.is_heterogeneous": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}}, "df": 4}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.graphing.Graph.plot_eta": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation.Simulation.de_calcs": {"tf": 1}}, "df": 1, "l": {"docs": {"abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.p0": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.processes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.jac": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 16}}}}}}, "t": {"docs": {"abstochkin.simulation.Simulation.dt": {"tf": 1}}, "df": 1}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.de_calcs.DEcalcs.jac": {"tf": 1}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.graphing.Graph.backend": {"tf": 1}, "abstochkin.simulation.Simulation.graph_backend": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {"abstochkin.simulation.Simulation.progress_bar": {"tf": 1}}, "df": 1}}}, "k": {"5": {"0": {"docs": {"abstochkin.process.RegulatedProcess.K50": {"tf": 1}, "abstochkin.simulation.Simulation.K50_vals": {"tf": 1}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {"abstochkin.process.Process.k": {"tf": 1}, "abstochkin.process.ReversibleProcess.k_rev": {"tf": 1}, "abstochkin.simulation.Simulation.k_vals": {"tf": 1}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1}}, "df": 4, "m": {"docs": {"abstochkin.process.MichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.simulation.Simulation.Km_vals": {"tf": 1}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1}}, "df": 6}}, "n": {"docs": {"abstochkin.simulation.Simulation.n": {"tf": 1}}, "df": 1, "h": {"docs": {"abstochkin.process.RegulatedProcess.nH": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.process.NullSpeciesNameError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}, "fullname": {"root": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.base.AbStochKin.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.Process.reacts_": {"tf": 1}, "abstochkin.process.Process.prods_": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 12, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin": {"tf": 1}, "abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.reps": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.asv": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.__init__": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.volume": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.volume_unit": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.time_unit": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.processes": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.het_processes": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.sims": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_process": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.del_process": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.p0": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.processes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.jac": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.graphing.Graph.backend": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}, "abstochkin.het_calcs": {"tf": 1}, "abstochkin.het_calcs.ProcessClasses": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.Process.reactants": {"tf": 1}, "abstochkin.process.Process.products": {"tf": 1}, "abstochkin.process.Process.k": {"tf": 1}, "abstochkin.process.Process.volume": {"tf": 1}, "abstochkin.process.Process.order": {"tf": 1}, "abstochkin.process.Process.is_heterogeneous": {"tf": 1}, "abstochkin.process.Process.species": {"tf": 1}, "abstochkin.process.Process.reacts_": {"tf": 1}, "abstochkin.process.Process.prods_": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.k_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.order_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.alpha": {"tf": 1}, "abstochkin.process.RegulatedProcess.K50": {"tf": 1}, "abstochkin.process.RegulatedProcess.nH": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.p0": {"tf": 1}, "abstochkin.simulation.Simulation.t_min": {"tf": 1}, "abstochkin.simulation.Simulation.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.dt": {"tf": 1}, "abstochkin.simulation.Simulation.n": {"tf": 1}, "abstochkin.simulation.Simulation.random_state": {"tf": 1}, "abstochkin.simulation.Simulation.use_multithreading": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1}, "abstochkin.simulation.Simulation.time_unit": {"tf": 1}, "abstochkin.simulation.Simulation.streams": {"tf": 1}, "abstochkin.simulation.Simulation.de_calcs": {"tf": 1}, "abstochkin.simulation.Simulation.graph_backend": {"tf": 1}, "abstochkin.simulation.Simulation.total_time": {"tf": 1}, "abstochkin.simulation.Simulation.t_steps": {"tf": 1}, "abstochkin.simulation.Simulation.time": {"tf": 1}, "abstochkin.simulation.Simulation.trans_p": {"tf": 1}, "abstochkin.simulation.Simulation.k_vals": {"tf": 1}, "abstochkin.simulation.Simulation.Km_vals": {"tf": 1}, "abstochkin.simulation.Simulation.K50_vals": {"tf": 1}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.algo_sequence": {"tf": 1}, "abstochkin.simulation.Simulation.progress_bar": {"tf": 1}, "abstochkin.simulation.Simulation.graphs": {"tf": 1}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.measure_runtime": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 140}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1}}, "df": 3, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.reps": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.asv": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}}, "df": 13}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {"abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.asv": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}}, "df": 3}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}}, "df": 3}}, "v": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.process.RegulatedProcess.alpha": {"tf": 1}}, "df": 1}}}, "l": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}}, "df": 1}, "g": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.simulation.Simulation.algo_sequence": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1, "i": {"docs": {"abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1}}, "df": 1, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1}, "abstochkin.base.AbStochKin.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 11}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 1}}, "s": {"docs": {"abstochkin.process.Process.is_heterogeneous": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}}, "df": 4}}, "p": {"0": {"docs": {"abstochkin.de_calcs.DEcalcs.p0": {"tf": 1}, "abstochkin.simulation.Simulation.p0": {"tf": 1}}, "df": 2}, "docs": {"abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1}, "abstochkin.simulation.Simulation.trans_p": {"tf": 1}}, "df": 2, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.process": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.Process.reactants": {"tf": 1.4142135623730951}, "abstochkin.process.Process.products": {"tf": 1.4142135623730951}, "abstochkin.process.Process.k": {"tf": 1.4142135623730951}, "abstochkin.process.Process.volume": {"tf": 1.4142135623730951}, "abstochkin.process.Process.order": {"tf": 1.4142135623730951}, "abstochkin.process.Process.is_heterogeneous": {"tf": 1.4142135623730951}, "abstochkin.process.Process.species": {"tf": 1.4142135623730951}, "abstochkin.process.Process.reacts_": {"tf": 1.4142135623730951}, "abstochkin.process.Process.prods_": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.k_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.order_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.alpha": {"tf": 1}, "abstochkin.process.RegulatedProcess.K50": {"tf": 1}, "abstochkin.process.RegulatedProcess.nH": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 44, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.processes": {"tf": 1}, "abstochkin.base.AbStochKin.het_processes": {"tf": 1}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.processes": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}}, "df": 5}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.ProcessClasses": {"tf": 1}}, "df": 1}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.products": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"abstochkin.process.Process.prods_": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.progress_bar": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}}, "df": 5}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1}}, "df": 5}, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1}, "abstochkin.simulation.Simulation.t_min": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.simulation.Simulation.use_multithreading": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "r": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.reps": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.reactants": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"abstochkin.process.Process.reacts_": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {"abstochkin.process.ReversibleProcess.k_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.order_rev": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.k_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.order_rev": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.alpha": {"tf": 1}, "abstochkin.process.RegulatedProcess.K50": {"tf": 1}, "abstochkin.process.RegulatedProcess.nH": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}}, "df": 6}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.richness": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.simulation.Simulation.random_state": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation.Simulation.run_simulation": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1}}, "df": 1}, "e": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 9}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1}, "abstochkin.simulation.Simulation.random_state": {"tf": 1}}, "df": 2}}}, "r": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.streams": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {"abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.t_steps": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.sims": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.p0": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.t_min": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.t_max": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.dt": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.n": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.random_state": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.use_multithreading": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.max_agents": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.time_unit": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.streams": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.de_calcs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_backend": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.total_time": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.t_steps": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.time": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.trans_p": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.k_vals": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.Km_vals": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.K50_vals": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.algo_sequence": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.progress_bar": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graphs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 31}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 2}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation.Simulation.algo_sequence": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1}}, "df": 1, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}, "abstochkin.process.Process.species": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 3}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.p0": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.processes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.jac": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.het_calcs": {"tf": 1}, "abstochkin.het_calcs.ProcessClasses": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.simulation.Simulation.de_calcs": {"tf": 1}}, "df": 24}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.MichaelisMentenProcess.catalyst": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst": {"tf": 1}}, "df": 2}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}}, "df": 4}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.graphing.Graph.backend": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}, "abstochkin.simulation.Simulation.graph_backend": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 12, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.graphing.Graph.backend": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 11}}}, "s": {"docs": {"abstochkin.simulation.Simulation.graphs": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.simulation.Simulation.k_vals": {"tf": 1}, "abstochkin.simulation.Simulation.Km_vals": {"tf": 1}, "abstochkin.simulation.Simulation.K50_vals": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.volume": {"tf": 1}, "abstochkin.base.AbStochKin.volume_unit": {"tf": 1}, "abstochkin.process.Process.volume": {"tf": 1}}, "df": 3}}}}}}, "o": {"1": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}}, "df": 1}, "2": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}}, "df": 2, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.odes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 5}}}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.process.Process.order": {"tf": 1}, "abstochkin.process.ReversibleProcess.order_rev": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.__init__": {"tf": 1}, "abstochkin.base.AbStochKin.volume": {"tf": 1}, "abstochkin.base.AbStochKin.volume_unit": {"tf": 1}, "abstochkin.base.AbStochKin.time_unit": {"tf": 1}, "abstochkin.base.AbStochKin.processes": {"tf": 1}, "abstochkin.base.AbStochKin.het_processes": {"tf": 1}, "abstochkin.base.AbStochKin.sims": {"tf": 1}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 17}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.graphing.Graph.backend": {"tf": 1}, "abstochkin.simulation.Simulation.graph_backend": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {"abstochkin.simulation.Simulation.progress_bar": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.volume_unit": {"tf": 1}, "abstochkin.base.AbStochKin.time_unit": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1}, "abstochkin.simulation.Simulation.time_unit": {"tf": 1}}, "df": 4}}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation.Simulation.use_multithreading": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.measure_runtime": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 5}}}}}, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.t_min": {"tf": 1}, "abstochkin.simulation.Simulation.t_max": {"tf": 1}, "abstochkin.simulation.Simulation.t_steps": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.time_unit": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1}, "abstochkin.simulation.Simulation.time_unit": {"tf": 1}, "abstochkin.simulation.Simulation.total_time": {"tf": 1}, "abstochkin.simulation.Simulation.time": {"tf": 1}}, "df": 5}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.trans_p": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.simulation.Simulation.total_time": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.het_processes": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.het_calcs": {"tf": 1}, "abstochkin.het_calcs.ProcessClasses": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.info_het": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1}}, "df": 11, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.is_heterogeneous": {"tf": 1}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}}, "df": 4}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.graphing.Graph.plot_eta": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.p0": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.processes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.jac": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.de_calcs": {"tf": 1}}, "df": 18, "l": {"docs": {"abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.p0": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.processes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.jac": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 16}}}}}}, "t": {"docs": {"abstochkin.simulation.Simulation.dt": {"tf": 1}}, "df": 1}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.de_calcs.DEcalcs.jac": {"tf": 1}}, "df": 1}}}, "k": {"5": {"0": {"docs": {"abstochkin.process.RegulatedProcess.K50": {"tf": 1}, "abstochkin.simulation.Simulation.K50_vals": {"tf": 1}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {"abstochkin.process.Process.k": {"tf": 1}, "abstochkin.process.ReversibleProcess.k_rev": {"tf": 1}, "abstochkin.simulation.Simulation.k_vals": {"tf": 1}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1}}, "df": 4, "m": {"docs": {"abstochkin.process.MichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.Km": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1}, "abstochkin.simulation.Simulation.Km_vals": {"tf": 1}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1}}, "df": 6}}, "n": {"docs": {"abstochkin.simulation.Simulation.n": {"tf": 1}}, "df": 1, "h": {"docs": {"abstochkin.process.RegulatedProcess.nH": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.process.NullSpeciesNameError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}, "annotation": {"root": {"docs": {"abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.reps": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.asv": {"tf": 1}}, "df": 6, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.reps": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1}}, "df": 4}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.asv": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.asv": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "default_value": {"root": {"docs": {"abstochkin.het_calcs.ProcessClasses": {"tf": 2}}, "df": 1, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.het_calcs.ProcessClasses": {"tf": 2.23606797749979}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.ProcessClasses": {"tf": 2.449489742783178}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.ProcessClasses": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.ProcessClasses": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.ProcessClasses": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.ProcessClasses": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}, "signature": {"root": {"0": {"1": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}, "docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 3}, "1": {"0": {"0": {"0": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}, "docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "9": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}, "docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}, "2": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}, "3": {"0": {"0": {"docs": {"abstochkin.graphing.Graph.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "9": {"docs": {"abstochkin.base.AbStochKin.__init__": {"tf": 2}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.8284271247461903}, "abstochkin.graphing.Graph.__init__": {"tf": 2.449489742783178}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.savefig": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 2}}, "df": 11}, "docs": {}, "df": 0}, "5": {"docs": {"abstochkin.graphing.Graph.__init__": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 6}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 4.242640687119285}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 3.1622776601683795}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 8.366600265340756}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 8.660254037844387}, "abstochkin.base.AbStochKin.__init__": {"tf": 7.0710678118654755}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 4.242640687119285}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 4.242640687119285}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 9.695359714832659}, "abstochkin.base.AbStochKin.add_process": {"tf": 10.14889156509222}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 9.16515138991168}, "abstochkin.base.AbStochKin.del_process": {"tf": 10.14889156509222}, "abstochkin.base.AbStochKin.simulate": {"tf": 15.652475842498529}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 8.06225774829855}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 8.246211251235321}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 4.242640687119285}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 3.1622776601683795}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 3.1622776601683795}, "abstochkin.graphing.Graph.__init__": {"tf": 9.746794344808963}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 3.7416573867739413}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 10.14889156509222}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 9.643650760992955}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 9.643650760992955}, "abstochkin.graphing.Graph.plot_eta": {"tf": 9.643650760992955}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 9.746794344808963}, "abstochkin.graphing.Graph.savefig": {"tf": 6.324555320336759}, "abstochkin.het_calcs.get_het_processes": {"tf": 12.68857754044952}, "abstochkin.het_calcs.richness": {"tf": 5}, "abstochkin.het_calcs.idx_het": {"tf": 5}, "abstochkin.het_calcs.info_het": {"tf": 5}, "abstochkin.process.Process.__init__": {"tf": 11}, "abstochkin.process.Process.from_string": {"tf": 11.135528725660043}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 12.649110640673518}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 13}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 14.106735979665885}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 14.628738838327793}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 18.24828759089466}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 18.973665961010276}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 20.074859899884732}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 21.02379604162864}, "abstochkin.process.update_all_species": {"tf": 7.14142842854285}, "abstochkin.simulation.Simulation.__init__": {"tf": 12.806248474865697}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 3.1622776601683795}, "abstochkin.simulation.Simulation.graph_results": {"tf": 5.5677643628300215}, "abstochkin.utils.rng_streams": {"tf": 4.69041575982343}, "abstochkin.utils.measure_runtime": {"tf": 3.1622776601683795}, "abstochkin.utils.r_squared": {"tf": 7.3484692283495345}, "abstochkin.utils.macro_to_micro": {"tf": 12.288205727444508}}, "df": 48, "p": {"0": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}, "docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 3, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 7, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 3.4641016151377544}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}}, "df": 5, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}}, "s": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}}, "df": 7}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}}, "df": 6, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}}, "df": 1}}, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 2}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 2}, "abstochkin.base.AbStochKin.add_process": {"tf": 2}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.del_process": {"tf": 2}, "abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 2}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 3.1622776601683795}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 3.872983346207417}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 3.605551275463989}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 4.358898943540674}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 4.123105625617661}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.7320508075688772}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 2.449489742783178}}, "df": 26}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.7320508075688772}}, "df": 5}, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}, "x": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}}, "df": 6}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.het_calcs.get_het_processes": {"tf": 3.1622776601683795}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 2}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}}, "df": 7}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {"abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 5}}}}}, "k": {"4": {"5": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "u": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.__init__": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.__init__": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 2}, "abstochkin.base.AbStochKin.add_process": {"tf": 2}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.del_process": {"tf": 2}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 2.23606797749979}, "abstochkin.process.Process.from_string": {"tf": 2.23606797749979}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 3}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 3}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 3}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 3}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 4.123105625617661}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 4.123105625617661}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 4.58257569495584}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 4.58257569495584}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.7320508075688772}, "abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 3}}, "df": 22}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 5}}}, "r": {"docs": {"abstochkin.base.AbStochKin.__init__": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.savefig": {"tf": 1.4142135623730951}, "abstochkin.process.Process.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 25, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.savefig": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 28}}, "c": {"docs": {"abstochkin.base.AbStochKin.__init__": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}, "t": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 8}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 10}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 5}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 5}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.__init__": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 14}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.__init__": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.__init__": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {"abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "t": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 6}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 2}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 12}}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.__init__": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}}, "l": {"docs": {"abstochkin.base.AbStochKin.__init__": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.8284271247461903}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 26}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}}, "df": 6}}, "t": {"docs": {"abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 2}}, "t": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.__init__": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 7}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1.4142135623730951}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 21}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}}, "df": 7}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 1}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}}}}}}}, "k": {"5": {"0": {"docs": {"abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}, "docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 15, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}}, "df": 9}}}}}, "m": {"docs": {"abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.add_process": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.del_process": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.process.Process.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 13}}}, "t": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2}, "p": {"docs": {}, "df": 0, "i": {"docs": {"abstochkin.graphing.Graph.__init__": {"tf": 1}}, "df": 1}}, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}}, "df": 5}}}, "o": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 1}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 2.23606797749979}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 2}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 8}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}}, "df": 3}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.NullSpeciesNameError": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.NullSpeciesNameError": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation.Simulation": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation.Simulation": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation.Simulation": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation": {"tf": 1}}, "df": 1}}}}}}}}}, "doc": {"root": {"0": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.info_het": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 17, "t": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 4}}}, "1": {"0": {"0": {"0": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}, "docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 3}, "docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 6}, "5": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 3}, "9": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}, "docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 17, "s": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 3}}}, "2": {"0": {"1": {"9": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"abstochkin.base": {"tf": 1}}, "df": 1}, "6": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}, "docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 18, "x": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}, "a": {"docs": {"abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}}, "df": 3}, "n": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 1}}}, "3": {"9": {"docs": {"abstochkin.base": {"tf": 2.449489742783178}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 2.8284271247461903}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.8284271247461903}}, "df": 5}, "docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 7}, "4": {"0": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}, "docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}, "5": {"0": {"docs": {"abstochkin.base": {"tf": 1}}, "df": 1}, "1": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}, "docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.idx_het": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 6}, "8": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}, "docs": {"abstochkin": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData": {"tf": 8.06225774829855}, "abstochkin.agentstatedata.AgentStateData.__init__": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.p_init": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.max_agents": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.reps": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.fill_state": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.asv_ini": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.asv": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 2.23606797749979}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 3.605551275463989}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 3.605551275463989}, "abstochkin.base": {"tf": 14.45683229480096}, "abstochkin.base.AbStochKin": {"tf": 7.3484692283495345}, "abstochkin.base.AbStochKin.__init__": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.volume": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.volume_unit": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.time_unit": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.processes": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.het_processes": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.sims": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 2.449489742783178}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 2}, "abstochkin.base.AbStochKin.add_process": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 2}, "abstochkin.base.AbStochKin.del_process": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate": {"tf": 11.874342087037917}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 14.866068747318506}, "abstochkin.de_calcs": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs": {"tf": 7.211102550927978}, "abstochkin.de_calcs.DEcalcs.__init__": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.p0": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.t_min": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.t_max": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.processes": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.ode_method": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.time_unit": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.odes": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.odes_sol": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.species_with_ode": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.jac": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.fixed_pts": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 6.6332495807108}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 6.48074069840786}, "abstochkin.graphing": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph": {"tf": 3.1622776601683795}, "abstochkin.graphing.Graph.__init__": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.backend": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 2.23606797749979}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 6.782329983125268}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.savefig": {"tf": 1.7320508075688772}, "abstochkin.het_calcs": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.ProcessClasses": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.get_het_processes": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.richness": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.idx_het": {"tf": 4.47213595499958}, "abstochkin.het_calcs.info_het": {"tf": 4.123105625617661}, "abstochkin.process": {"tf": 2}, "abstochkin.process.Process": {"tf": 9.327379053088816}, "abstochkin.process.Process.__init__": {"tf": 1.7320508075688772}, "abstochkin.process.Process.reactants": {"tf": 1.7320508075688772}, "abstochkin.process.Process.products": {"tf": 1.7320508075688772}, "abstochkin.process.Process.k": {"tf": 1.7320508075688772}, "abstochkin.process.Process.volume": {"tf": 1.7320508075688772}, "abstochkin.process.Process.order": {"tf": 1.7320508075688772}, "abstochkin.process.Process.is_heterogeneous": {"tf": 1.7320508075688772}, "abstochkin.process.Process.species": {"tf": 1.7320508075688772}, "abstochkin.process.Process.reacts_": {"tf": 1.7320508075688772}, "abstochkin.process.Process.prods_": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 12.489995996796797}, "abstochkin.process.ReversibleProcess": {"tf": 6.082762530298219}, "abstochkin.process.ReversibleProcess.__init__": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess.k_rev": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess.is_heterogeneous_rev": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess.order_rev": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 10.583005244258363}, "abstochkin.process.MichaelisMentenProcess": {"tf": 6.324555320336759}, "abstochkin.process.MichaelisMentenProcess.__init__": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.catalyst": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.Km": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 14.142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 10.04987562112089}, "abstochkin.process.RegulatedProcess.__init__": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.alpha": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.K50": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.nH": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 19.28730152198591}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 11.180339887498949}, "abstochkin.process.RegulatedMichaelisMentenProcess.__init__": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.catalyst": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.Km": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.is_heterogeneous_Km": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 18.275666882497067}, "abstochkin.process.NullSpeciesNameError": {"tf": 1.7320508075688772}, "abstochkin.process.update_all_species": {"tf": 5.830951894845301}, "abstochkin.simulation": {"tf": 4.123105625617661}, "abstochkin.simulation.Simulation": {"tf": 8.94427190999916}, "abstochkin.simulation.Simulation.__init__": {"tf": 7.745966692414834}, "abstochkin.simulation.Simulation.p0": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.t_min": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.t_max": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.dt": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.n": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.random_state": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.use_multithreading": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.max_agents": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.max_agents_multiplier": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.time_unit": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.streams": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.de_calcs": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.graph_backend": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.total_time": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.t_steps": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.time": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.trans_p": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.k_vals": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.Km_vals": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.K50_vals": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.k_het_metrics": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.Km_het_metrics": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.K50_het_metrics": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.algo_sequence": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.progress_bar": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.graphs": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.graph_results": {"tf": 7.0710678118654755}, "abstochkin.utils": {"tf": 1.7320508075688772}, "abstochkin.utils.rng_streams": {"tf": 10.816653826391969}, "abstochkin.utils.measure_runtime": {"tf": 1.7320508075688772}, "abstochkin.utils.r_squared": {"tf": 6.244997998398398}, "abstochkin.utils.macro_to_micro": {"tf": 8}}, "df": 140, "a": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 2}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 2.8284271247461903}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2.8284271247461903}, "abstochkin.base": {"tf": 2.23606797749979}, "abstochkin.base.AbStochKin": {"tf": 2.449489742783178}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 2.23606797749979}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 2}, "abstochkin.base.AbStochKin.add_process": {"tf": 2}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.del_process": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.23606797749979}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 2.8284271247461903}, "abstochkin.de_calcs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 2}, "abstochkin.graphing.Graph.savefig": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 2}, "abstochkin.het_calcs.info_het": {"tf": 1.7320508075688772}, "abstochkin.process": {"tf": 1}, "abstochkin.process.Process": {"tf": 4.58257569495584}, "abstochkin.process.Process.from_string": {"tf": 3.4641016151377544}, "abstochkin.process.ReversibleProcess": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 3.605551275463989}, "abstochkin.process.RegulatedProcess": {"tf": 3}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 3.7416573867739413}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 3.872983346207417}, "abstochkin.process.update_all_species": {"tf": 3}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 2}, "abstochkin.simulation.Simulation.__init__": {"tf": 2}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.7320508075688772}, "abstochkin.utils": {"tf": 1.4142135623730951}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.measure_runtime": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 2.23606797749979}, "abstochkin.utils.macro_to_micro": {"tf": 3}}, "df": 47, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 9, "s": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 2.23606797749979}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 2.23606797749979}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2.23606797749979}, "abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 2.23606797749979}}, "df": 13, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.base": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.7320508075688772}, "abstochkin.process.Process": {"tf": 2}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 2}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2}}, "df": 15, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 5}}}}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 3}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 8}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 3.1622776601683795}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 3}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.simulation": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1}}, "df": 17, "d": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 2.23606797749979}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2.23606797749979}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 35}, "y": {"docs": {"abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 3}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base": {"tf": 2}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.23606797749979}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.graphing": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 13}}}}}}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 2}}}}}}}, "k": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 6, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 4, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 10}}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 20, "v": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 2.6457513110645907}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 4}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.process.Process": {"tf": 1.7320508075688772}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.r_squared": {"tf": 1.7320508075688772}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}}, "df": 4, "/": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 4}}}, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.process.Process": {"tf": 2.23606797749979}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 2}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.7320508075688772}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 21}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 3}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 4}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 3}}}}}, "g": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}}}}}}}}}, "x": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.7320508075688772}}, "df": 1, "i": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 7, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}}, "df": 2, "d": {"docs": {"abstochkin": {"tf": 1.4142135623730951}, "abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 11}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.23606797749979}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.simulation.Simulation": {"tf": 2.449489742783178}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 2}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 21, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 6}, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.23606797749979}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 20}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 2.23606797749979}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.7320508075688772}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 10}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "f": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 2.449489742783178}, "abstochkin.process.ReversibleProcess": {"tf": 2}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.MichaelisMentenProcess": {"tf": 2}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 3}, "abstochkin.process.RegulatedProcess": {"tf": 5}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 4.242640687119285}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 5.291502622129181}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 4.58257569495584}, "abstochkin.process.update_all_species": {"tf": 2}, "abstochkin.simulation.Simulation": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.7320508075688772}, "abstochkin.utils.macro_to_micro": {"tf": 2}}, "df": 22, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 2.23606797749979}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 2}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 10}}}, "g": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}}}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "f": {"docs": {"abstochkin.agentstatedata": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData": {"tf": 3.1622776601683795}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 2.6457513110645907}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2.6457513110645907}, "abstochkin.base.AbStochKin": {"tf": 3.4641016151377544}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 4}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 3}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 3.1622776601683795}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 2.6457513110645907}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 2.6457513110645907}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 3.1622776601683795}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.het_calcs": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.idx_het": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.info_het": {"tf": 1.7320508075688772}, "abstochkin.process": {"tf": 1}, "abstochkin.process.Process": {"tf": 4.58257569495584}, "abstochkin.process.Process.from_string": {"tf": 2.23606797749979}, "abstochkin.process.ReversibleProcess": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.MichaelisMentenProcess": {"tf": 2.23606797749979}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 3}, "abstochkin.process.RegulatedProcess": {"tf": 5}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 4.47213595499958}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 5.477225575051661}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 4.898979485566356}, "abstochkin.process.update_all_species": {"tf": 3}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 3.605551275463989}, "abstochkin.simulation.Simulation.__init__": {"tf": 2.23606797749979}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2.6457513110645907}, "abstochkin.utils": {"tf": 1.4142135623730951}, "abstochkin.utils.rng_streams": {"tf": 2.23606797749979}, "abstochkin.utils.measure_runtime": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 2.23606797749979}, "abstochkin.utils.macro_to_micro": {"tf": 3.4641016151377544}}, "df": 45}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.7320508075688772}}, "df": 11, "s": {"docs": {"abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 5}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 2, "s": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 14, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 9}}, "e": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 6}, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 4}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate": {"tf": 3}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 2}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 10}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 6, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 2.23606797749979}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 8}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "f": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}, "p": {"0": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 5}, "docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.utils.macro_to_micro": {"tf": 2.6457513110645907}}, "df": 9, "s": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 21}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process": {"tf": 1.4142135623730951}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.het_calcs": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 2.23606797749979}, "abstochkin.het_calcs.info_het": {"tf": 2.449489742783178}, "abstochkin.process.Process": {"tf": 2.6457513110645907}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 17, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 3}}}}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 5, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.add_process": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.process": {"tf": 1}, "abstochkin.process.Process": {"tf": 3.1622776601683795}, "abstochkin.process.Process.from_string": {"tf": 3}, "abstochkin.process.ReversibleProcess": {"tf": 2}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 2}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedProcess": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.7320508075688772}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 26, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin": {"tf": 2.8284271247461903}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.7320508075688772}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 2.23606797749979}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 2.6457513110645907}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 20}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"abstochkin.process.update_all_species": {"tf": 1.7320508075688772}}, "df": 1}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process": {"tf": 1}, "abstochkin.process.Process": {"tf": 2.23606797749979}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 13}}, "e": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}, "s": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 6}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.utils": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 2}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2.23606797749979}}, "df": 4, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 8}}, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "g": {"6": {"4": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 1, "d": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 14, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin": {"tf": 1}, "abstochkin.base": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 3}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base": {"tf": 1}}, "df": 3}}}, "e": {"docs": {"abstochkin.simulation": {"tf": 1.4142135623730951}}, "df": 1, "d": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.process.Process": {"tf": 2}}, "df": 1}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 2.23606797749979}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 2}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 2}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 7, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}}, "df": 2}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.utils": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.simulation.Simulation.run_simulation": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 2}}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 7}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 8}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 5, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 2}}}, "r": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 2}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 2}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedProcess": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 15, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 2.23606797749979}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2.23606797749979}}, "df": 17, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 6}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1.7320508075688772}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 2}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.6457513110645907}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 2.23606797749979}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 2.449489742783178}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 3}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 2.449489742783178}, "abstochkin.simulation.Simulation": {"tf": 2.449489742783178}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2.449489742783178}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 23}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 8, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2, "s": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 2}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 14}, "s": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}, "y": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 7}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}}, "df": 3}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1, "/": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4, "s": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.base": {"tf": 2.449489742783178}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.7320508075688772}}, "df": 2, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base": {"tf": 2.449489742783178}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 3.7416573867739413}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.simulation": {"tf": 2}, "abstochkin.simulation.Simulation": {"tf": 2.23606797749979}, "abstochkin.simulation.Simulation.__init__": {"tf": 2.449489742783178}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 15, "s": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 2}, "abstochkin.graphing": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 9}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 3, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.7320508075688772}}, "df": 4}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 3, "[": {"0": {"docs": {"abstochkin.base": {"tf": 1}}, "df": 1}, "1": {"docs": {"abstochkin.base": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 3}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 4, "n": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.7320508075688772}}, "df": 2}, "s": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 8}}}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 8}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 9}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 10, "u": {"docs": {}, "df": 0, "p": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2}}}, "c": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 3, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 3}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 2.8284271247461903}, "abstochkin.utils": {"tf": 1}}, "df": 3}}}}, "p": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}, "d": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 8, "/": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 6}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}, "m": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.__init__": {"tf": 2.23606797749979}}, "df": 3, "r": {"docs": {"abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 3}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.het_calcs": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.utils": {"tf": 1}}, "df": 5}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1.4142135623730951}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "k": {"1": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}}, "df": 1}, "5": {"0": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 5}, "docs": {}, "df": 0}, "docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 2}, "abstochkin.process.Process": {"tf": 2.8284271247461903}, "abstochkin.process.Process.from_string": {"tf": 2}, "abstochkin.process.ReversibleProcess": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedProcess": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 3.4641016151377544}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 3.4641016151377544}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 12, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.utils": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 2.449489742783178}}, "df": 2, "s": {"docs": {"abstochkin": {"tf": 1}, "abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 10}}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}}, "df": 2, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"abstochkin.process.update_all_species": {"tf": 1.4142135623730951}}, "df": 1}}}, "m": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 2}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 6}, "[": {"0": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 2}}, "df": 1}}}}}, "c": {"docs": {"abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 6, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.7320508075688772}}, "df": 15}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.r_squared": {"tf": 1.7320508075688772}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5, "s": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.simulation": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 2}}, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.de_calcs": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.8284271247461903}}, "df": 11, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 7}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 2}}}, "e": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"abstochkin.simulation.Simulation.run_simulation": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.richness": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 8, "s": {"docs": {"abstochkin.process.Process": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation": {"tf": 1}}, "df": 6}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}}}}}}}, "v": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 1}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 5, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.het_calcs": {"tf": 1}, "abstochkin.utils": {"tf": 1}}, "df": 2}}}}}}}}}, "n": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 6, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}}, "df": 5}}}}}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.update_all_species": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 6}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5, "s": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}}, "df": 1}, "d": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}}, "df": 2}}}}}}}, "m": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 6}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5, "s": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.7320508075688772}, "abstochkin.base": {"tf": 2}, "abstochkin.base.AbStochKin": {"tf": 2.23606797749979}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 3}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.het_calcs": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 3}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 2.23606797749979}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.measure_runtime": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.7320508075688772}, "abstochkin.utils.macro_to_micro": {"tf": 2.23606797749979}}, "df": 37, "m": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.7320508075688772}, "abstochkin.process": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 2}}, "df": 5, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1}, "e": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 2}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.het_calcs.get_het_processes": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}}, "df": 2, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"abstochkin.utils": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils": {"tf": 1}, "abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 2, "s": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.het_calcs": {"tf": 1}, "abstochkin.utils": {"tf": 1}}, "df": 3}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 2.23606797749979}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 17}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 2}}}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 6}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.simulation.Simulation": {"tf": 2}, "abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 16, "s": {"docs": {"abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 2}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.449489742783178}}, "df": 10}}}}}}, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 6, "h": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 3.4641016151377544}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 2.23606797749979}, "abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 2}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2}, "abstochkin.base": {"tf": 2.449489742783178}, "abstochkin.base.AbStochKin": {"tf": 4}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 6}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 3.1622776601683795}, "abstochkin.de_calcs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs": {"tf": 3.872983346207417}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 4.242640687119285}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 2}, "abstochkin.graphing.Graph": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 2}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 3.605551275463989}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.savefig": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.info_het": {"tf": 1.4142135623730951}, "abstochkin.process": {"tf": 1}, "abstochkin.process.Process": {"tf": 5.385164807134504}, "abstochkin.process.Process.from_string": {"tf": 4.123105625617661}, "abstochkin.process.ReversibleProcess": {"tf": 2.23606797749979}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 3.605551275463989}, "abstochkin.process.MichaelisMentenProcess": {"tf": 2.449489742783178}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 4.47213595499958}, "abstochkin.process.RegulatedProcess": {"tf": 5.385164807134504}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 5.916079783099616}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 5.830951894845301}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 6.164414002968976}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 2.449489742783178}, "abstochkin.simulation": {"tf": 2.23606797749979}, "abstochkin.simulation.Simulation": {"tf": 5.0990195135927845}, "abstochkin.simulation.Simulation.__init__": {"tf": 3.3166247903554}, "abstochkin.simulation.Simulation.graph_results": {"tf": 3.4641016151377544}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.measure_runtime": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 3}, "abstochkin.utils.macro_to_micro": {"tf": 4.358898943540674}}, "df": 49, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}}, "df": 2, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 14}, "m": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 2}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 4}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.simulation": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 19}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 2}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 24}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 2}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.23606797749979}, "abstochkin.de_calcs.DEcalcs": {"tf": 2.449489742783178}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 2.449489742783178}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 10, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1.7320508075688772}}, "df": 1}}}}, "o": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 3}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 2}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 2.449489742783178}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 2}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 2.23606797749979}, "abstochkin.simulation.Simulation.__init__": {"tf": 2.8284271247461903}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 2.6457513110645907}, "abstochkin.utils.macro_to_micro": {"tf": 2.23606797749979}}, "df": 28}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 2}}}}}}}}}, "j": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 2}}, "df": 3}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2}}, "df": 4}}}}}}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 5}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 7}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 3}, "s": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.add_processes_from_file": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}}, "df": 2, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.update_all_species": {"tf": 1.7320508075688772}}, "df": 13}}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}}, "df": 5}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.Process": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 8, "s": {"docs": {"abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}}, "df": 1, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.agentstatedata": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 3}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.base": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 2}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.7320508075688772}}, "df": 13}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}}}, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}}, "df": 1, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 4}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin": {"tf": 2}, "abstochkin.base.AbStochKin.simulate": {"tf": 3.4641016151377544}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 2}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 2}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 2}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 14}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.process": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 8, "d": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 10}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 10}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}}, "df": 2, "d": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 8}, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 6}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}}, "df": 4}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 2}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.7320508075688772}}, "df": 6}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}}}}}, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 10}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 11}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 2.23606797749979}}, "df": 1, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}}}}}}, "p": {"8": {"5": {"3": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}}, "df": 2}, "x": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}}, "df": 2, "n": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.7320508075688772}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2}, "abstochkin.base": {"tf": 2}, "abstochkin.base.AbStochKin": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.449489742783178}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 2.449489742783178}, "abstochkin.de_calcs.DEcalcs": {"tf": 2.449489742783178}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.process.Process": {"tf": 2.6457513110645907}, "abstochkin.process.Process.from_string": {"tf": 2.23606797749979}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 2}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedProcess": {"tf": 3}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 3.3166247903554}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 3}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 3.4641016151377544}, "abstochkin.process.update_all_species": {"tf": 2.23606797749979}, "abstochkin.simulation.Simulation": {"tf": 2}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 2.449489742783178}}, "df": 26, "i": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}}, "df": 1, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 6, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 2}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.449489742783178}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.8284271247461903}, "abstochkin.simulation.Simulation": {"tf": 2.449489742783178}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 18, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 2}}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.Process": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 1}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 2.23606797749979}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin": {"tf": 2}, "abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.23606797749979}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 2.449489742783178}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 3}, "abstochkin.process.Process.from_string": {"tf": 2.449489742783178}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2.6457513110645907}, "abstochkin.process.RegulatedProcess": {"tf": 2.8284271247461903}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 3}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 3}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 3.1622776601683795}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 1.7320508075688772}, "abstochkin.utils.macro_to_micro": {"tf": 2.8284271247461903}}, "df": 33}, "t": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 14, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 9}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "f": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.7320508075688772}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 2}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 2}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.7320508075688772}}, "df": 20}, "v": {"docs": {}, "df": 0, "p": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 7}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 13}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 3}}}}, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.utils": {"tf": 1}}, "df": 6}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 9}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 2.8284271247461903}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1}}, "df": 15, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 7}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "b": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}, "r": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}}, "df": 4}}}}}}}, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}}, "df": 1}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 2}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 1}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 2}}}}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.Process": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process": {"tf": 1}, "abstochkin.process.Process": {"tf": 2.449489742783178}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 13}}}}, "s": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}}, "df": 4, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}}, "df": 2}}}}}}}}}}}, "e": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}}, "df": 2}}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 7, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.23606797749979}}, "df": 4}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 4}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 5}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.process.Process": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.info_het": {"tf": 1.4142135623730951}, "abstochkin.process.update_all_species": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 7}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 2.449489742783178}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1}}, "df": 9, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils": {"tf": 1}}, "df": 4}}}}, "s": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}}, "df": 2}, "g": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 2}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 6}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 2}}, "df": 6, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.23606797749979}}, "df": 10}}}, "k": {"2": {"3": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "4": {"5": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.richness": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1.7320508075688772}}, "df": 1}}, "^": {"2": {"docs": {"abstochkin.utils.r_squared": {"tf": 1.7320508075688772}}, "df": 1}, "docs": {}, "df": 0}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 2}}, "df": 6, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}}, "df": 8}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}}}, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "y": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.het_calcs.richness": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 3}}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}, "y": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.simulation": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 2}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 2.6457513110645907}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.7320508075688772}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 9, "s": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1, "s": {"docs": {"abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.het_calcs": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 3}}}}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 7}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 6, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.het_calcs.info_het": {"tf": 1.4142135623730951}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils": {"tf": 1.4142135623730951}, "abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 2}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.add_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 7, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.utils.macro_to_micro": {"tf": 2.449489742783178}}, "df": 11}}}}}}}}}, "n": {"docs": {"abstochkin.de_calcs.DEcalcs": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 4}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}}, "df": 6}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}}, "df": 3}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1.7320508075688772}}, "df": 4, "u": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 2.6457513110645907}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 2.6457513110645907}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 14, "s": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 1.4142135623730951}}, "df": 2}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 4, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 3}}}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.simulation": {"tf": 1}}, "df": 5}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.simulation": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "o": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 6, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 2}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 11, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 7, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 15}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 6}}}}}}, "w": {"docs": {"abstochkin.base": {"tf": 1}}, "df": 1}, "n": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5, "e": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2.449489742783178}}, "df": 10}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 10}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 10, "s": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 9}}}}, "h": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}}, "df": 4}}, "l": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 4}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin": {"tf": 2.8284271247461903}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 2}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.process.Process": {"tf": 2.6457513110645907}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess": {"tf": 3}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 3.1622776601683795}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.update_all_species": {"tf": 2.23606797749979}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 19, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 4}}, "[": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 4}}}}}, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "g": {"6": {"4": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 8}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"abstochkin.graphing.Graph": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {"abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 1}, "t": {"docs": {"abstochkin.process.ReversibleProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 5}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 2}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedProcess": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}, "abstochkin.process.update_all_species": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.7320508075688772}, "abstochkin.utils.macro_to_micro": {"tf": 2}}, "df": 13, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}}, "df": 5}}}}, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 2}}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin": {"tf": 2}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.utils.macro_to_micro": {"tf": 2}}, "df": 8}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}}, "df": 7, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.7320508075688772}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1.4142135623730951}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1.7320508075688772}, "abstochkin.simulation.Simulation": {"tf": 1.7320508075688772}}, "df": 11}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 3}}}}}, "d": {"docs": {"abstochkin.agentstatedata.AgentStateData.apply_markov_property": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 4}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.run_simulation": {"tf": 1}}, "df": 3}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.agentstatedata.AgentStateData.cleanup_asv": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.NullSpeciesNameError": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 7}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 7}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}}}}}}}}, "x": {"docs": {"abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}}, "df": 3, "s": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 8}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}, "abstochkin.process.update_all_species": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.base.AbStochKin.extract_process_from_str": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 3}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}}, "df": 4}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.utils.measure_runtime": {"tf": 1}}, "df": 1}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 5}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.process.NullSpeciesNameError": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"abstochkin.process.update_all_species": {"tf": 1}}, "df": 1}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.simulation": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {"abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 4, "s": {"docs": {"abstochkin.agentstatedata.AgentStateData": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 2}, "d": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1.4142135623730951}, "abstochkin.simulation": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}}, "df": 8}, "r": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.base": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.add_process": {"tf": 1}, "abstochkin.base.AbStochKin.del_process": {"tf": 1}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.process.Process": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 13}}}}, "p": {"docs": {"abstochkin.base": {"tf": 1}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.7320508075688772}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1}, "abstochkin.graphing.Graph.plot_ODEs": {"tf": 1}}, "df": 4, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.het_calcs.info_het": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin": {"tf": 2}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 2}, "abstochkin.simulation.Simulation": {"tf": 1.7320508075688772}, "abstochkin.utils": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 6, "s": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 4}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.utils": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"abstochkin.process.ReversibleProcess": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1}}, "df": 3, "s": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 1, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "g": {"6": {"4": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}}, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.de_calcs.DEcalcs.get_term_multiplier": {"tf": 1}, "abstochkin.utils": {"tf": 1}}, "df": 2}}}}}}}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 2}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2}, "abstochkin.base.AbStochKin": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate": {"tf": 1.4142135623730951}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.de_calcs.DEcalcs": {"tf": 1.7320508075688772}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.get_het_processes": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.7320508075688772}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1.7320508075688772}}, "df": 19}}}}, "t": {"docs": {"abstochkin.base": {"tf": 5.830951894845301}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 4.358898943540674}, "abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 3.605551275463989}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 2.23606797749979}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 3}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 3.7416573867739413}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 3.1622776601683795}, "abstochkin.utils.rng_streams": {"tf": 2.449489742783178}}, "df": 11}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.graphing.Graph.setup_spines_ticks": {"tf": 1.4142135623730951}, "abstochkin.graphing.Graph.plot_trajectories": {"tf": 1}, "abstochkin.graphing.Graph.plot_avg_std": {"tf": 1}, "abstochkin.graphing.Graph.plot_eta": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1.4142135623730951}}, "df": 8, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.graphing": {"tf": 1}, "abstochkin.graphing.Graph": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"abstochkin.simulation.Simulation.__init__": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 2}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 2}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 2}, "abstochkin.base.AbStochKin.simulate": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.simulation.Simulation": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.process.Process": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.simulation.Simulation.__init__": {"tf": 1}}, "df": 4}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.simulation": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.base.AbStochKin": {"tf": 1}, "abstochkin.graphing.Graph.plot_het_metrics": {"tf": 1}, "abstochkin.het_calcs": {"tf": 1}, "abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1.7320508075688772}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 2}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.simulation.Simulation.graph_results": {"tf": 1}}, "df": 13}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.get_het_processes": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.idx_het": {"tf": 1.4142135623730951}, "abstochkin.het_calcs.info_het": {"tf": 1.4142135623730951}, "abstochkin.process.Process": {"tf": 2}, "abstochkin.process.ReversibleProcess": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1.4142135623730951}, "abstochkin.utils.r_squared": {"tf": 1}, "abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 10}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.base.AbStochKin.simulate": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.de_calcs.DEcalcs.solve_ODEs": {"tf": 1}, "abstochkin.utils.rng_streams": {"tf": 1.4142135623730951}}, "df": 2, "#": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"abstochkin.utils.rng_streams": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"abstochkin.het_calcs.richness": {"tf": 1}, "abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.het_calcs.idx_het": {"tf": 1}, "abstochkin.het_calcs.info_het": {"tf": 1}, "abstochkin.process.Process": {"tf": 1.4142135623730951}, "abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.utils.r_squared": {"tf": 1.7320508075688772}}, "df": 8, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"abstochkin.process.RegulatedProcess": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"abstochkin.agentstatedata.AgentStateData.get_vals_o1": {"tf": 1.4142135623730951}, "abstochkin.agentstatedata.AgentStateData.get_vals_o2": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4, "t": {"docs": {}, "df": 0, "h": {"docs": {"abstochkin.process.Process.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 1}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1}}, "df": 4}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.base.AbStochKin.simulate_series_in_parallel": {"tf": 2.449489742783178}, "abstochkin.process.Process.from_string": {"tf": 2.449489742783178}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 2}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 2}}, "df": 6}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"abstochkin.utils.r_squared": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1}}}, "y": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "y": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}, "abstochkin.process.Process.from_string": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "t": {"docs": {"abstochkin.process.RegulatedMichaelisMentenProcess": {"tf": 1}}, "df": 1}}}, "x": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 2}, "abstochkin.process.Process.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.ReversibleProcess.from_string": {"tf": 1}, "abstochkin.process.MichaelisMentenProcess.from_string": {"tf": 1.4142135623730951}, "abstochkin.process.RegulatedProcess.from_string": {"tf": 2.449489742783178}, "abstochkin.process.RegulatedMichaelisMentenProcess.from_string": {"tf": 1.7320508075688772}}, "df": 6, "^": {"2": {"docs": {"abstochkin.de_calcs.DEcalcs.setup_ODEs": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"abstochkin.utils.macro_to_micro": {"tf": 1}}, "df": 1}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();