"""
Predicting the 1st and 2nd moments (mean and standard deviation) of the
trajectory of a species undergoing a 1st order process using combinatorics.

The arrays are the output of the MATLAB function `Het_o1_Predict.m`.
See explanation in section 4.4.1 of my write-up describing the AbStochKin
method and the code for the function in the link below.

References
----------
- Plakantonakis, Alex. 2019. “Agent-based Kinetics: A Nonspatial Stochastic
  Method for Simulating the Dynamics of Heterogeneous Populations.”
  OSF Preprints. July 26. doi:10.31219/osf.io/x6h9b.
- See code: https://github.com/alexplaka/ABK/blob/master/Heterogeneous_Pops/1_BasicKinetics/1st%20order/Distinct_Subspecies/Het_o1_Predict.m
"""

#  Copyright (c) 2024-2025, Alex Plakantonakis.
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

from numpy import array

""" 
Process: A -> B, k = [0.3, 0.1], Distinct subspecies, 
p0={'A': 10, 'B': 0}, t_max=10, dt=0.1.
The following results refer to the trajectory of species A.
"""
sim2a_theory_avg = array(
    [10, 9.80247683648838, 9.60981603445502, 9.42188359409868, 9.23854937934740, 9.05968700462886,
     8.88517372497761, 8.71489032938068, 8.54872103726594, 8.38655339804041, 8.22827819358839,
     8.07378934364228, 7.92298381394094, 7.77576152709363, 7.63202527606931, 7.49168064023416,
     7.35463590386176, 7.22080197704325, 7.09009231892631, 6.96242286321450, 6.83771194586004,
     6.71588023488543, 6.59685066227089, 6.48054835784695, 6.36690058513263, 6.25583667906210,
     6.14728798554395, 6.04118780279897, 5.93747132442403, 5.83607558413102, 5.73693940211158,
     5.64000333297945, 5.54520961524402, 5.45250212226986, 5.36182631467844, 5.27312919414935,
     5.18635925857985, 5.10146645856272, 5.01840215514330, 4.93711907881825, 4.85757128973921,
     4.77971413908590, 4.70350423157413, 4.62889938906534, 4.55585861524496, 4.48434206133833,
     4.41431099283341, 4.34572775718069, 4.27855575244132, 4.21275939685570, 4.14830409930532,
     4.08515623064137, 4.02328309585480, 3.96265290706284, 3.90323475728802, 3.84499859500620,
     3.78791519944112, 3.73195615658330, 3.67709383591199, 3.62330136779958, 3.57055262157806,
     3.51882218424836, 3.46808533981336, 3.41831804921634, 3.36949693086699, 3.32159924173765,
     3.27460285901296, 3.22848626227673, 3.18322851622008, 3.13880925385547, 3.09520866022196,
     3.05240745656687, 3.01038688499017, 2.96912869353766, 2.92861512172996, 2.88882888651440,
     2.84975316862724, 2.81137159935437, 2.77366824767858, 2.73662760780207, 2.70023458703317,
     2.66447449402657, 2.62933302736660, 2.59479626448354, 2.56085065089306, 2.52748298974940,
     2.49468043170297, 2.46243046505348, 2.43072090618984, 2.39953989030846, 2.36887586240175,
     2.33871756850882, 2.30905404722077, 2.27987462143301, 2.25116889033730, 2.22292672164670,
     2.19513824404623, 2.16779383986294, 2.14088413794875, 2.11440000676982, 2.08833254769653]
)

sim2a_theory_std = array(
    [0, 0.438931432040800, 0.609316547541286, 0.732604851963895, 0.830559053939839,
     0.911816215605146, 0.980912794817476, 1.04060802097204, 1.09274202509293, 1.13862244801080,
     1.17922273033061, 1.21529366054931, 1.24743065090141, 1.27611658619019, 1.30175034151919,
     1.32466646297191, 1.34514916965286, 1.36344257758250, 1.37975833403768, 1.39428143072738,
     1.40717470703563, 1.41858239214762, 1.42863292942097, 1.43744125619573, 1.44511066451373,
     1.45173433511673, 1.45739661372228, 1.46217408180797, 1.46613646192395, 1.46934738854330,
     1.47186506872523, 1.47374285177778, 1.47502972321815, 1.47577073533015, 1.47600738428315,
     1.47577794194363, 1.47511774905927, 1.47405947533767, 1.47263335101310, 1.47086737374233,
     1.46878749405965, 1.46641778212053, 1.46378057805161, 1.46089662788385, 1.45778520676234,
     1.45446423088935, 1.45095035945846, 1.44725908766999, 1.44340483177627, 1.43940100698413,
     1.43526009893983, 1.43099372943282, 1.42661271687954, 1.42212713208302, 1.41754634970727,
     1.41287909585697, 1.40813349211012, 1.40331709631383, 1.39843694042142, 1.39349956561993,
     1.38851105497241, 1.38347706377681, 1.37840284782412, 1.37329328972075, 1.36815292342471,
     1.36298595713183, 1.35779629463541, 1.35258755527234, 1.34736309255849, 1.34212601160776,
     1.33687918542086, 1.33162527012327, 1.32636671922487, 1.32110579696839, 1.31584459082832,
     1.31058502321713, 1.30532886245154, 1.30007773302735, 1.29483312524798, 1.28959640424836,
     1.28436881845317, 1.27915150750519, 1.27394550969741, 1.26875176894003, 1.26357114129144,
     1.25840440108025, 1.25325224664360, 1.24811530570548, 1.24299414041704, 1.23788925207952,
     1.23280108556926, 1.22773003348266, 1.22267644001826, 1.21764060461166, 1.21262278533837,
     1.20762320209831, 1.20264203959543, 1.19767945012450, 1.19273555617678, 1.18781045287550,
     1.18290421025125]
)

""" 
Process: A -> , k = [0.5, 0.2], Distinct subspecies, 
p0={'A': 16}, t_max=20, dt=0.1 
"""
sim2b_theory_avg = array(
    [16, 15.4514247824598, 14.9250148575062, 14.4197800800744, 13.9347767957170, 13.4691056088590,
     13.0219092591911, 12.5923706009401, 12.1797106800147, 11.7831869042644, 11.4020913023251,
     11.0357488667438, 10.6835159772847, 10.3447789005167, 10.0189523619777, 9.70547818738214,
     9.40382400952770, 9.11348203769057, 8.83396788649294, 8.56481946133513, 8.30559589765731,
     8.05587655140974, 7.81526003824914, 7.58336331908770, 7.35982082974718, 7.14428365258190,
     6.93641872803408, 6.73590810415909, 6.54244822232340, 6.35574923727317, 6.17553436993975,
     6.00153929137120, 5.83351153630168, 5.67120994490018, 5.51440413134631, 5.36287397793504,
     5.21640915345266, 5.07480865467759, 4.93788036986041, 4.80544066313373, 4.67731397883034,
     4.55333246475041, 4.43333561345653, 4.31716992073024, 4.20468856035167, 4.09575107441968,
     3.99022307845832, 3.88797598059254, 3.78888671411620, 3.69283748280612, 3.59971551836278,
     3.50941284939389, 3.42182608138505, 3.33685618712382, 3.25440830707746, 3.17439155923831,
     3.09671885798604, 3.02130674152916, 2.94807520751207, 2.87694755639645, 2.80785024224057,
     2.74071273052126, 2.67546736266093, 2.61204922693452, 2.55039603545243, 2.49044800692589,
     2.43214775493672, 2.37544018144933, 2.32027237531108, 2.26659351550260, 2.21435477891140,
     2.16350925241018, 2.11401184903531, 2.06581922806810, 2.01888971883323, 1.97318324803550,
     1.92866127046702, 1.88528670292282, 1.84302386117255, 1.80183839984216, 1.76169725506712,
     1.72256858978486, 1.68442174154124, 1.64722717269100, 1.61095642287910, 1.57558206369387,
     1.54107765538957, 1.50741770557981, 1.47457762980895, 1.44253371391193, 1.41126307807863,
     1.38074364254186, 1.35095409481243, 1.32187385838833, 1.29348306286863, 1.26576251540605,
     1.23869367343497, 1.21225861861542, 1.18644003193576, 1.16122116991956, 1.13658584188558,
     1.11251838821102, 1.08900365955154, 1.06602699697330, 1.04357421295474, 1.02163157321731,
     1.00018577934693, 0.979223952169524, 0.958733615845404, 0.938702682649616, 0.919119438406386,
     0.899972528547472, 0.881250944765887, 0.862944012237418, 0.845041377384071, 0.827532996154507,
     0.810409122797898, 0.793660299108649, 0.777277344120564, 0.761251344230013, 0.745573643728631,
     0.730235835727013, 0.715229753451737, 0.700547461898872, 0.686181249827933, 0.672123622081012,
     0.658367292212490, 0.644905175415489, 0.631730381731789, 0.618836209532653, 0.606216139258491,
     0.593863827405948, 0.581773100751472, 0.569937950800970, 0.558352528455612, 0.547011138884327,
     0.535908236593982, 0.525038420688608, 0.514396430309514, 0.503977140248419, 0.493775556726180,
     0.483786813329971, 0.474006167102134, 0.464428994774226, 0.455050789140083, 0.445867155561998,
     0.436873808604399, 0.428066568789647, 0.419441359470843, 0.410994203816738, 0.402721221904094,
     0.394618627913032, 0.386682727421112, 0.378909914792086, 0.371296670655448, 0.363839559473068,
     0.356535227189381, 0.349380398961749, 0.342371876967764, 0.335506538286411, 0.328781332850150,
     0.322193281465081, 0.315739473896527, 0.309417067017442, 0.303223283017187, 0.297155407668333,
     0.291210788649235, 0.285386833920218, 0.279681010151339, 0.274090841199736, 0.268613906634694,
     0.263247840308623, 0.257990328972227, 0.252839110932203, 0.247791974749910, 0.242846757979474,
     0.238001345943900, 0.233253670547787, 0.228601709125332, 0.224043483322342, 0.219577058011034,
     0.215200540236458, 0.210912078193425, 0.206709860232851, 0.202592113896515, 0.198557104979206,
     0.194603136617354, 0.190728548403195, 0.186931715523629, 0.183211047922918, 0.179564989488426,
     0.175992017258628, 0.172490640652646, 0.169059400720606, 0.165696869414126, 0.162401648876282,
     0.159172370750420, 0.156007695507207, 0.152906311789342, 0.149866935773357, 0.146888310547973]
)

sim2b_theory_std = array(
    [0, 0.725541125611369, 0.995107060466143, 1.18231587187355, 1.32478908347769, 1.43771148236789,
     1.52918059165868, 1.60418771936590, 1.66609923788751, 1.71732903596568, 1.75968616652696,
     1.79457204605817, 1.82310042168219, 1.84617446967581, 1.86453858625863, 1.87881447126627,
     1.88952705014280, 1.89712358752534, 1.90198810013125, 1.90445243875303, 1.90480495558484,
     1.90329738557940, 1.90015038297045, 1.89555802882164, 1.88969153980943, 1.88270234881243,
     1.87472468555940, 1.86587775512796, 1.85626758963712, 1.84598863207874, 1.83512509865110,
     1.82375215660229, 1.81193694726086, 1.79973947835790, 1.78721340528679, 1.77440671747560,
     1.76136234330601, 1.74811868471304, 1.73471009087778, 1.72116727890168, 1.70751770818467,
     1.69378591421975, 1.67999380670802, 1.66616093620626, 1.65230473295370, 1.63844072103355,
     1.62458271062038, 1.61074297072007, 1.59693238450518, 1.58316058909710, 1.56943610143168,
     1.55576643164785, 1.54215818528124, 1.52861715539798, 1.51514840567921, 1.50175634536094,
     1.48844479683332, 1.47521705662085, 1.46207595039184, 1.44902388257614, 1.43606288111344,
     1.42319463780242, 1.41042054467201, 1.39774172675855, 1.38515907163067, 1.37267325597442,
     1.36028476951894, 1.34799393655673, 1.33580093528828, 1.32370581519954, 1.31170851266020,
     1.29980886491363, 1.28800662261311, 1.27630146104426, 1.26469299016100, 1.25318076354986,
     1.24176428642715, 1.23044302276349, 1.21921640162162, 1.20808382278482, 1.19704466174699,
     1.18609827412754, 1.17524399956947, 1.16448116517261, 1.15380908850978, 1.14322708026847,
     1.13273444655724, 1.12233049091161, 1.11201451603162, 1.10178582527940, 1.09164372396290,
     1.08158752042932, 1.07161652698897, 1.06173006068914, 1.05192744395467, 1.04220800511108,
     1.03257107880394, 1.02301600632703, 1.01354213587070, 1.00414882270021, 0.994835429273409,
     0.985601325305639, 0.976445887789191, 0.967368500973759, 0.958368556313703, 0.949445452387174,
     0.940598594791733, 0.931827396020519, 0.923131275322512, 0.914509658550068, 0.905961977996604,
     0.897487672226700, 0.889086185901021, 0.880756969597681, 0.872499479631888, 0.864313177875155,
     0.856197531575340, 0.848152013178560, 0.840176100153846, 0.832269274821298, 0.824431024184342,
     0.816660839766626, 0.808958217453942, 0.801322657341510, 0.793753663586877, 0.786250744268616,
     0.778813411250924, 0.771441180054243, 0.764133569731866, 0.756890102752581, 0.749710304889262,
     0.742593705113360, 0.735539835495194, 0.728548231109910, 0.721618429948991, 0.714749972837169,
     0.707942403354562, 0.701195267763876, 0.694508114942527, 0.687880496319434, 0.681311965816368,
     0.674802079793629, 0.668350396999879, 0.661956478525944, 0.655619887762393, 0.649340190360716,
     0.643116954197916, 0.636949749344342, 0.630838148034588, 0.624781724641281, 0.618780055651602,
     0.612832719646373, 0.606939297281562, 0.601099371272041, 0.595312526377470, 0.589578349390148,
     0.583896429124717, 0.578266356409567, 0.572687724079831, 0.567160126971859, 0.561683161919031,
     0.556256427748828, 0.550879525281041, 0.545552057327023, 0.540273628689893, 0.535043846165602,
     0.529862318544768, 0.524728656615215, 0.519642473165125, 0.514603382986741, 0.509611002880548,
     0.504664951659873, 0.499764850155834, 0.494910321222592, 0.490100989742852, 0.485336482633549,
     0.480616428851693, 0.475940459400312, 0.471308207334463, 0.466719307767266, 0.462173397875930,
     0.457670116907734, 0.453209106185941, 0.448790009115601, 0.444412471189233, 0.440076139992357,
     0.435780665208847, 0.431525698626097, 0.427310894139965, 0.423135907759501, 0.419000397611422,
     0.414904023944336, 0.410846449132689, 0.406827337680439, 0.402846356224438, 0.398903173537516,
     0.394997460531255, 0.391128890258461, 0.387297137915312, 0.383501880843187, 0.379742798530169]
)

""" 
Process: A -> B, k = (0.3, 0.1), Normally-distributed k, 
p0={'A': 10, 'B': 0}, t_max=10, dt=0.1
Using this particular sample of k values for the calculation: 
k_vals = [0.2629975230675996, 0.3994078692032213, 0.341585748064632, 
          0.23818362912835933, 0.3672140801569663, 0.1549950494114751, 
          0.3593484635769356, 0.24381702764559043, 0.3631453096950567, 
          0.3439090651876601]
with sample mean=0.30746038 and std=0.07374513
"""
sim3a_theory_avg = array(
    [10, 9.69748229077177, 9.40463037153876, 9.12112336642901, 8.84665134079830, 8.58091492096610,
     8.32362492735359, 8.07450202054666, 7.83327635982355, 7.59968727370342, 7.37348294208807,
     7.15442008958441, 6.94226368961004, 6.73678667889851, 6.53776968203476, 6.34500074566425,
     6.15827508203228, 5.97739482152215, 5.80216877387275, 5.63241219776766, 5.46794657849877,
     5.30859941341801, 5.15420400490133, 5.00459926055853, 4.85962950043234, 4.71914427093925,
     4.58299816531345, 4.45105065032370, 4.32316589904132, 4.19921262944518, 4.07906394865754,
     3.96259720261155, 3.84969383095875, 3.74023922703136, 3.63412260268110, 3.53123685782230,
     3.43147845451352, 3.33474729541753, 3.24094660648544, 3.14998282371612, 3.06176548384727,
     2.97620711883993, 2.89322315402276, 2.81273180976744, 2.73465400657095, 2.65891327342507,
     2.58543565935750, 2.51414964803327, 2.44498607530899, 2.37787804963629, 2.31276087521449,
     2.24957197779622, 2.18825083305279, 2.12873889740981, 2.07097954126653, 2.01491798451528,
     1.96050123428082, 1.90767802480168, 1.85639875937879, 1.80661545431904, 1.75828168480420,
     1.71135253261789, 1.66578453566574, 1.62153563922632, 1.57856514887236, 1.53683368500409,
     1.49630313893854, 1.45693663050071, 1.41869846706417, 1.38155410399082, 1.34547010642110,
     1.31041411236772, 1.27635479706764, 1.24326183854864, 1.21110588436826, 1.17985851948455,
     1.14949223521930, 1.11998039927592, 1.09129722677552, 1.06341775227583, 1.03631780273904,
     1.00997397141571, 0.984363592613096, 0.959464717317360, 0.935256089640173, 0.911717124061246,
     0.888827883439369, 0.866569057765462, 0.844921943632060, 0.823868424394586, 0.803390951000591,
     0.783472523463998, 0.764096672962178, 0.745247444534459, 0.726909380361417, 0.709067503605027,
     0.691707302790438, 0.674814716710803, 0.658376119837260, 0.642378308216754, 0.626808485841029]
)

sim3a_theory_std = array(
    [0, 0.541157942963976, 0.746979939985309, 0.893027681024157, 1.00666527752514,
     1.09883209767374, 1.17531325090104, 1.23965008712615, 1.29421840420822, 1.34071566703410,
     1.38041166453681, 1.41428995778202, 1.44313346201165, 1.46757913367050, 1.48815448895383,
     1.50530289211398, 1.51940160954026, 1.53077503861314, 1.53970462081505, 1.54643641682490,
     1.55118699538499, 1.55414808155312, 1.55549027587137, 1.55536606662259, 1.55391229647086,
     1.55125220248828, 1.54749711865989, 1.54274790845983, 1.53709617941119, 1.53062531994816,
     1.52341139022043, 1.51552389190861, 1.50702643708940, 1.49797733230274, 1.48843009094043,
     1.47843388469056, 1.46803394287935, 1.45727190704044, 1.44618614682417, 1.43481204237370,
     1.42318223749041, 1.41132686725182, 1.39927376320096, 1.38704863877518, 1.37467525726583,
     1.36217558428584, 1.34956992645632, 1.33687705779995, 1.32411433513823, 1.31129780362778,
     1.29844229343220, 1.28556150840697, 1.27266810757220, 1.25977378005944, 1.24688931414188,
     1.23402466089026, 1.22118899293834, 1.20839075879110, 1.19563773306324, 1.18293706299699,
     1.17029531157264, 1.15771849749493, 1.14521213231101, 1.13278125489134, 1.12043046348342,
     1.10816394552913, 1.09598550541888, 1.08389859034077, 1.07190631436872, 1.06001148092157,
     1.04821660371333, 1.03652392630528, 1.02493544036099, 1.01345290269734, 1.00207785121701,
     0.990811619801142, 0.979655352234577, 0.968610015230702, 0.957676410617431, 0.946855186741476,
     0.936146849143591, 0.925551770553626, 0.915070200250599, 0.904702272829730, 0.894448016415315,
     0.884307360355580, 0.874280142433044, 0.864366115621627, 0.854564954419499, 0.844876260784715,
     0.835299569698794, 0.825834354381712, 0.816480031180193, 0.807235964149694, 0.798101469349163,
     0.789075818866350, 0.780158244590319, 0.771347941746699, 0.762644072210218, 0.754045767608129,
     0.745552132227264]
)

""" 
Process: A -> , k = (0.2, 0.05), Normally-distributed k, 
p0={'A': 15, 'B': 0}, t_max=20, dt=0.1
Using this particular sample of k values for the calculation: 
k_vals = [0.18149876153379982, 0.24970393460161067, 0.220792874032316, 
          0.16909181456417968, 0.23360704007848318, 0.12749752470573755, 
          0.22967423178846783, 0.17190851382279523, 0.23157265484752837, 
          0.22195453259383008, 0.16163755970441251, 0.2264184374403467, 
          0.21709638367570885, 0.16769284548012403, 0.3000575277606583]
with sample mean=0.20734698 and std=0.0419861
"""
sim3b_theory_avg = array(
    [15, 14.6923112991170, 14.3911876380188, 14.0964838243168, 13.8080579835265, 13.5257714809347,
     13.2494888453584, 12.9790776947491, 12.7144086635951, 12.4553553320787, 12.2017941569443,
     11.9536044040342, 11.7106680824526, 11.4728698803150, 11.2400971020467, 11.0122396071894,
     10.7891897506802, 10.5708423245665, 10.3570945011210, 10.1478457773222, 9.94299792066710,
     9.74245491628336, 9.54612291530836, 9.35391018450456, 9.16572705708056, 8.98148588468815,
     8.80110099056669, 8.62448862380641, 8.45156691470347, 8.28225583117971, 8.11647713624136,
     7.95415434645102, 7.79521269138817, 7.63957907407418, 7.48718203233803, 7.33795170110008,
     7.19181977555117, 7.04871947520540, 6.90858550880528, 6.77135404005851, 6.63696265418597,
     6.50535032526150, 6.37645738432398, 6.25022548824298, 6.12659758931982, 6.00551790560609,
     5.88693189192212, 5.77078621155878, 5.65702870864571, 5.54560838117006, 5.43647535462989,
     5.32958085630701, 5.22487719014414, 5.12231771221205, 5.02185680675212, 4.92344986278070,
     4.82705325124170, 4.73262430269403, 4.64012128552132, 4.54950338465106, 4.46073068077115,
     4.37376413003172, 4.28856554422073, 4.20509757140195, 4.12332367700416, 4.04320812535081,
     3.96471596161963, 3.88781299422188, 3.81246577759115, 3.73864159537199, 3.66630844399885,
     3.59543501665590, 3.52599068760876, 3.45794549689922, 3.39127013539433, 3.32593593018138,
     3.26191483030061, 3.19917939280756, 3.13770276915727, 3.07745869190266, 3.01842146169967,
     2.96056593461181, 2.90386750970717, 2.84830211694078, 2.79384620531573, 2.74047673131632,
     2.68817114760697, 2.63690739199041, 2.58666387661926, 2.53741947745479, 2.48915352396720,
     2.44184578907172, 2.39547647929480, 2.35002622516529, 2.30547607182495, 2.26180746985347,
     2.21900226630275, 2.17704269593559, 2.13591137266406, 2.09559128118271, 2.05606576879226,
     2.01731853740916, 1.97933363575671, 1.94209545173353, 1.90558870495518, 1.86979843946498,
     1.83471001660997, 1.80030910807818, 1.76658168909357, 1.73351403176483, 1.70109269858449,
     1.66930453607488, 1.63813666857753, 1.60757649218266, 1.57761166879542, 1.54823012033592,
     1.51942002306973, 1.49116980206596, 1.46346812577990, 1.43630390075738, 1.40966626645803,
     1.38354459019463, 1.35792846218600, 1.33280769072061, 1.30817229742865, 1.28401251265966,
     1.26031877096374, 1.23708170667359, 1.21429214958521, 1.19194112073504, 1.17001982827125,
     1.14851966341697, 1.12743219652351, 1.10674917321135, 1.08646251059697, 1.06656429360354,
     1.04704677135351, 1.02790235364135, 1.00912360748440, 0.990703253750270, 0.972634163858874,
     0.954909356557502, 0.937521994767201, 0.920465382498870, 0.903732961837474, 0.887318309992832,
     0.871215136415456, 0.855417279975973, 0.839918706206678, 0.824713504603818, 0.809795885989217,
     0.795160179929906, 0.780800832214440, 0.766712402384627, 0.752889561321403, 0.739327088883638,
     0.726019871598672, 0.712962900403424, 0.700151268434911, 0.687580168869096, 0.675244892806936,
     0.663140827206607, 0.651263452860835, 0.639608342418339, 0.628171158448385, 0.616947651547486,
     0.605933658487302, 0.595125100402815, 0.584517981019874, 0.574108384921240, 0.563892475850245,
     0.553866495051255, 0.544026759646084, 0.534369661045580, 0.524891663395581, 0.515589302056481,
     0.506459182115662, 0.497497976932045, 0.488702426712058, 0.480069337116321, 0.471595577896353,
     0.463278081560648, 0.455113842069462, 0.447099913557665, 0.439233409085060, 0.431511499413526,
     0.423931411810422, 0.416490428877649, 0.409185887405819, 0.402015177252960, 0.394975740247228,
     0.388065069113087, 0.381280706420447, 0.374620243556243, 0.368081319717975, 0.361661620928712,
     0.355358879073092, 0.349170870953864, 0.343095417368506, 0.337130382205491,
     0.331273671559762])

sim3b_theory_std = array(
    [0, 0.548747356347334, 0.763629265083642, 0.920323301323201, 1.04577689778050,
     1.15064213550105, 1.24049214544301, 1.31870413387624, 1.38752258104680, 1.44853747999758,
     1.50292921865179, 1.55160609973208, 1.59528712944473, 1.63455464569047, 1.66988927397693,
     1.70169400038552, 1.73031126081176, 1.75603539036904, 1.77912189733300, 1.79979450730268,
     1.81825060607195, 1.83466550955735, 1.84919585928276, 1.86198235560451, 1.87315198220402,
     1.88281983473149, 1.89109063781263, 1.89806001408131, 1.90381555394995, 1.90843772380929,
     1.91200064212076, 1.91457274665402, 1.91621737138145, 1.91699324788966, 1.91695494332727,
     1.91615324468091, 1.91463549740998, 1.91244590506791, 1.90962579541247, 1.90621385759868,
     1.90224635431016, 1.89775731208033, 1.89277869255975, 1.88734054707570, 1.88147115648915,
     1.87519715807136, 1.86854366088334, 1.86153435094113, 1.85419158728082, 1.84653648989290,
     1.83858902037340, 1.83036805603416, 1.82189145812504, 1.81317613474315, 1.80423809893776,
     1.79509252246123, 1.78575378556624, 1.77623552320591, 1.76655066795481, 1.75671148993543,
     1.74672963400555, 1.73661615443532, 1.72638154728092, 1.71603578064043, 1.70558832296042,
     1.69504816954550, 1.68442386740871, 1.67372353858841, 1.66295490204564, 1.65212529424605,
     1.64124168852122, 1.63031071329630, 1.61933866926325, 1.60833154557255, 1.59729503511019,
     1.58623454892149, 1.57515522983805, 1.56406196536012, 1.55295939984231, 1.54185194602717,
     1.53074379596741, 1.51963893137514, 1.50854113343282, 1.49745399209908, 1.48638091493932,
     1.47532513550948, 1.46428972131914, 1.45327758139828, 1.44229147349057, 1.43133401089429,
     1.42040766897073, 1.40951479133859, 1.39865759577165, 1.38783817981596, 1.37705852614155,
     1.36632050764315, 1.35562589230300, 1.34497634782833, 1.33437344607534, 1.32381866727064,
     1.31331340404052, 1.30285896525791, 1.29245657971609, 1.28210739963799, 1.27181250402911,
     1.26157290188178, 1.25138953523814, 1.24126328211859, 1.23119495932223, 1.22118532510541,
     1.21123508174432, 1.20134487798682, 1.19151531139900, 1.18174693061123, 1.17204023746836,
     1.16239568908855, 1.15281369983489, 1.14329464320368, 1.13383885363341, 1.12444662823763,
     1.11511822846550, 1.10585388169298, 1.09665378274780, 1.08751809537122, 1.07844695361925,
     1.06944046320595, 1.06049870279146, 1.05162172521702, 1.04280955868935, 1.03406220791643,
     1.02537965519699, 1.01676186146538, 1.00820876729395, 0.999720293854577, 0.991296343841192,
     0.982936802354761, 0.974641537752449, 0.966410402462349, 0.958243233765255, 0.950139854544798,
     0.942100074007266, 0.934123688372353, 0.926210481535996, 0.918360225706461, 0.910572682014750,
     0.902847601100372, 0.895184723673453, 0.887583781054169, 0.880044495690374, 0.872566581654320,
     0.865149745119284, 0.857793684816923, 0.850498092476093, 0.843262653243882, 0.836087046089568,
     0.828970944192144, 0.821914015312093, 0.814915922147994, 0.807976322678585, 0.801094870490826,
     0.794271215094523, 0.787505002224031, 0.780795874127532, 0.774143469844385, 0.767547425470992,
     0.761007374415635, 0.754522947642715, 0.748093773906777, 0.741719479976750, 0.735399690850747,
     0.729134029961806, 0.722922119374913, 0.716763579975639, 0.710658031650723, 0.704605093460893,
     0.698604383806238, 0.692655520584403, 0.686758121341891, 0.680911803418727, 0.675116184086742,
     0.669370880681723, 0.663675510729650, 0.658029692067268, 0.652433042957185, 0.646885182197723,
     0.641385729227711, 0.635934304226419, 0.630530528208823, 0.625174023116355, 0.619864411903351,
     0.614601318619317, 0.609384368487207, 0.604213187977847, 0.599087404880657, 0.594006648370817,
     0.588970549073002, 0.583978739121837, 0.579030852219170, 0.574126523688317, 0.569265390525368,
     0.564447091447683])
