# SOIL SDK

The SOIL SDK allows users to develop and test applications that run on top of SOIL and modules and data structures that run in it.

# Documentation

The main documentation page is here: [https://developer.amalfianalytics.com/](https://developer.amalfianalytics.com/)

## Build Documentation

```
cd docs/website
yarn install
yarn build
```

Update autogenerated sdk documentation
```
cd ../..
pydoc-markdown
```

Update autogenerated library documentation
```
pydoc-markdown --search-path $LIBRARY_PATH/ehra pydoc-markdown-library.yml
```

## Development

Local install:
```
rm -rf build/ ; rm -rf dist/ ; python setup.py sdist bdist_wheel && pip install dist/soil-sdk-*
```


# Roadmap
**Done**
* Run pipelines - Done
* Upload modules and data structures to the cloud - Done
* Upload data - Done
* soil cli with operations: login, init and run
* Logging API - Done
* Documentation - Done
* Expose parallelization API (be able to split modules in tasks)
* Federated learning API

**Upcoming**

* Multiple soil apps in the same machine.
* Autoinstall server dependencies (remote_requirements)

# Similar tools

* https://github.com/pditommaso/awesome-pipeline
* https://snakemake.readthedocs.io/en/stable/index.html
* https://workflowhub.org/
