import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/group#id DataIonoscloudGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/group#name DataIonoscloudGroup#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/group#timeouts DataIonoscloudGroup#timeouts}
    */
    readonly timeouts?: DataIonoscloudGroupTimeouts;
}
export interface DataIonoscloudGroupUsers {
}
export declare function dataIonoscloudGroupUsersToTerraform(struct?: DataIonoscloudGroupUsers): any;
export declare class DataIonoscloudGroupUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudGroupUsers | undefined;
    set internalValue(value: DataIonoscloudGroupUsers | undefined);
    get administrator(): cdktf.IResolvable;
    get email(): string;
    get firstName(): string;
    get forceSecAuth(): cdktf.IResolvable;
    get id(): string;
    get lastName(): string;
}
export declare class DataIonoscloudGroupUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudGroupUsersOutputReference;
}
export interface DataIonoscloudGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/group#create DataIonoscloudGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/group#default DataIonoscloudGroup#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/group#delete DataIonoscloudGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/group#update DataIonoscloudGroup#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudGroupTimeoutsToTerraform(struct?: DataIonoscloudGroupTimeoutsOutputReference | DataIonoscloudGroupTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/group ionoscloud_group}
*/
export declare class DataIonoscloudGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/group ionoscloud_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudGroupConfig);
    get accessActivityLog(): cdktf.IResolvable;
    get createBackupUnit(): cdktf.IResolvable;
    get createDatacenter(): cdktf.IResolvable;
    get createInternetAccess(): cdktf.IResolvable;
    get createK8SCluster(): cdktf.IResolvable;
    get createPcc(): cdktf.IResolvable;
    get createSnapshot(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get reserveIp(): cdktf.IResolvable;
    get s3Privilege(): cdktf.IResolvable;
    private _users;
    get users(): DataIonoscloudGroupUsersList;
    private _timeouts;
    get timeouts(): DataIonoscloudGroupTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-ionoscloud-group.d.ts.map