import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NatgatewayRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#datacenter_id NatgatewayRule#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#id NatgatewayRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the NAT gateway rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#name NatgatewayRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#natgateway_id NatgatewayRule#natgateway_id}
    */
    readonly natgatewayId: string;
    /**
    * Protocol of the NAT gateway rule. Defaults to ALL. If protocol is 'ICMP' then targetPortRange start and end cannot be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#protocol NatgatewayRule#protocol}
    */
    readonly protocol?: string;
    /**
    * Public IP address of the NAT gateway rule. Specifies the address used for masking outgoing packets source address field. Should be one of the customer reserved IP address already configured on the NAT gateway resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#public_ip NatgatewayRule#public_ip}
    */
    readonly publicIp: string;
    /**
    * Source subnet of the NAT gateway rule. For SNAT rules it specifies which packets this translation rule applies to based on the packets source IP address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#source_subnet NatgatewayRule#source_subnet}
    */
    readonly sourceSubnet: string;
    /**
    * Target or destination subnet of the NAT gateway rule. For SNAT rules it specifies which packets this translation rule applies to based on the packets destination IP address. If none is provided, rule will match any address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#target_subnet NatgatewayRule#target_subnet}
    */
    readonly targetSubnet?: string;
    /**
    * Type of the NAT gateway rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#type NatgatewayRule#type}
    */
    readonly type?: string;
    /**
    * target_port_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#target_port_range NatgatewayRule#target_port_range}
    */
    readonly targetPortRange?: NatgatewayRuleTargetPortRange;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#timeouts NatgatewayRule#timeouts}
    */
    readonly timeouts?: NatgatewayRuleTimeouts;
}
export interface NatgatewayRuleTargetPortRange {
    /**
    * Target port range end associated with the NAT gateway rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#end NatgatewayRule#end}
    */
    readonly end?: number;
    /**
    * Target port range start associated with the NAT gateway rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#start NatgatewayRule#start}
    */
    readonly start?: number;
}
export declare function natgatewayRuleTargetPortRangeToTerraform(struct?: NatgatewayRuleTargetPortRangeOutputReference | NatgatewayRuleTargetPortRange): any;
export declare class NatgatewayRuleTargetPortRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NatgatewayRuleTargetPortRange | undefined;
    set internalValue(value: NatgatewayRuleTargetPortRange | undefined);
    private _end?;
    get end(): number;
    set end(value: number);
    resetEnd(): void;
    get endInput(): number | undefined;
    private _start?;
    get start(): number;
    set start(value: number);
    resetStart(): void;
    get startInput(): number | undefined;
}
export interface NatgatewayRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#create NatgatewayRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#default NatgatewayRule#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#delete NatgatewayRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule#update NatgatewayRule#update}
    */
    readonly update?: string;
}
export declare function natgatewayRuleTimeoutsToTerraform(struct?: NatgatewayRuleTimeoutsOutputReference | NatgatewayRuleTimeouts | cdktf.IResolvable): any;
export declare class NatgatewayRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NatgatewayRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NatgatewayRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule ionoscloud_natgateway_rule}
*/
export declare class NatgatewayRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_natgateway_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway_rule ionoscloud_natgateway_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NatgatewayRuleConfig
    */
    constructor(scope: Construct, id: string, config: NatgatewayRuleConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _natgatewayId?;
    get natgatewayId(): string;
    set natgatewayId(value: string);
    get natgatewayIdInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _publicIp?;
    get publicIp(): string;
    set publicIp(value: string);
    get publicIpInput(): string | undefined;
    private _sourceSubnet?;
    get sourceSubnet(): string;
    set sourceSubnet(value: string);
    get sourceSubnetInput(): string | undefined;
    private _targetSubnet?;
    get targetSubnet(): string;
    set targetSubnet(value: string);
    resetTargetSubnet(): void;
    get targetSubnetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _targetPortRange;
    get targetPortRange(): NatgatewayRuleTargetPortRangeOutputReference;
    putTargetPortRange(value: NatgatewayRuleTargetPortRange): void;
    resetTargetPortRange(): void;
    get targetPortRangeInput(): NatgatewayRuleTargetPortRange | undefined;
    private _timeouts;
    get timeouts(): NatgatewayRuleTimeoutsOutputReference;
    putTimeouts(value: NatgatewayRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NatgatewayRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=natgateway-rule.d.ts.map