import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::ApiGateway::Account`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-account.html
 * @external
 */
export interface CfnAccountProps {
    /**
     * `AWS::ApiGateway::Account.CloudWatchRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-account.html#cfn-apigateway-account-cloudwatchrolearn
     * @external
     */
    readonly cloudWatchRoleArn?: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::Account`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-account.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Account
 */
export declare class CfnAccount extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::Account";
    /**
     * `AWS::ApiGateway::Account.CloudWatchRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-account.html#cfn-apigateway-account-cloudwatchrolearn
     * @external
     */
    cloudWatchRoleArn: string | undefined;
    /**
     * Create a new `AWS::ApiGateway::Account`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnAccountProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::ApiKey`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html
 * @external
 */
export interface CfnApiKeyProps {
    /**
     * `AWS::ApiGateway::ApiKey.CustomerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-customerid
     * @external
     */
    readonly customerId?: string;
    /**
     * `AWS::ApiGateway::ApiKey.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGateway::ApiKey.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::ApiKey.GenerateDistinctId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-generatedistinctid
     * @external
     */
    readonly generateDistinctId?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::ApiKey.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::ApiGateway::ApiKey.StageKeys`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-stagekeys
     * @external
     */
    readonly stageKeys?: Array<CfnApiKey.StageKeyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::ApiKey.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ApiGateway::ApiKey.Value`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-value
     * @external
     */
    readonly value?: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::ApiKey`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html
 * @external
 * @cloudformationResource AWS::ApiGateway::ApiKey
 */
export declare class CfnApiKey extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::ApiKey";
    /**
     * `AWS::ApiGateway::ApiKey.CustomerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-customerid
     * @external
     */
    customerId: string | undefined;
    /**
     * `AWS::ApiGateway::ApiKey.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGateway::ApiKey.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::ApiKey.GenerateDistinctId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-generatedistinctid
     * @external
     */
    generateDistinctId: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::ApiKey.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::ApiGateway::ApiKey.StageKeys`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-stagekeys
     * @external
     */
    stageKeys: Array<CfnApiKey.StageKeyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::ApiKey.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ApiGateway::ApiKey.Value`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-value
     * @external
     */
    value: string | undefined;
    /**
     * Create a new `AWS::ApiGateway::ApiKey`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnApiKeyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGateway::ApiKey`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html
 * @external
 * @cloudformationResource AWS::ApiGateway::ApiKey
 */
export declare namespace CfnApiKey {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html
     * @external
     */
    interface StageKeyProperty {
        /**
         * `CfnApiKey.StageKeyProperty.RestApiId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
         * @external
         */
        readonly restApiId?: string;
        /**
         * `CfnApiKey.StageKeyProperty.StageName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
         * @external
         */
        readonly stageName?: string;
    }
}
/**
 * Properties for defining a `AWS::ApiGateway::Authorizer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html
 * @external
 */
export interface CfnAuthorizerProps {
    /**
     * `AWS::ApiGateway::Authorizer.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-restapiid
     * @external
     */
    readonly restApiId: string;
    /**
     * `AWS::ApiGateway::Authorizer.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::ApiGateway::Authorizer.AuthorizerCredentials`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizercredentials
     * @external
     */
    readonly authorizerCredentials?: string;
    /**
     * `AWS::ApiGateway::Authorizer.AuthorizerResultTtlInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizerresultttlinseconds
     * @external
     */
    readonly authorizerResultTtlInSeconds?: number;
    /**
     * `AWS::ApiGateway::Authorizer.AuthorizerUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizeruri
     * @external
     */
    readonly authorizerUri?: string;
    /**
     * `AWS::ApiGateway::Authorizer.AuthType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authtype
     * @external
     */
    readonly authType?: string;
    /**
     * `AWS::ApiGateway::Authorizer.IdentitySource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource
     * @external
     */
    readonly identitySource?: string;
    /**
     * `AWS::ApiGateway::Authorizer.IdentityValidationExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identityvalidationexpression
     * @external
     */
    readonly identityValidationExpression?: string;
    /**
     * `AWS::ApiGateway::Authorizer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::ApiGateway::Authorizer.ProviderARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-providerarns
     * @external
     */
    readonly providerArns?: string[];
}
/**
 * A CloudFormation `AWS::ApiGateway::Authorizer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Authorizer
 */
export declare class CfnAuthorizer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::Authorizer";
    /**
     * `AWS::ApiGateway::Authorizer.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-restapiid
     * @external
     */
    restApiId: string;
    /**
     * `AWS::ApiGateway::Authorizer.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type
     * @external
     */
    type: string;
    /**
     * `AWS::ApiGateway::Authorizer.AuthorizerCredentials`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizercredentials
     * @external
     */
    authorizerCredentials: string | undefined;
    /**
     * `AWS::ApiGateway::Authorizer.AuthorizerResultTtlInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizerresultttlinseconds
     * @external
     */
    authorizerResultTtlInSeconds: number | undefined;
    /**
     * `AWS::ApiGateway::Authorizer.AuthorizerUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizeruri
     * @external
     */
    authorizerUri: string | undefined;
    /**
     * `AWS::ApiGateway::Authorizer.AuthType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authtype
     * @external
     */
    authType: string | undefined;
    /**
     * `AWS::ApiGateway::Authorizer.IdentitySource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource
     * @external
     */
    identitySource: string | undefined;
    /**
     * `AWS::ApiGateway::Authorizer.IdentityValidationExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identityvalidationexpression
     * @external
     */
    identityValidationExpression: string | undefined;
    /**
     * `AWS::ApiGateway::Authorizer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::ApiGateway::Authorizer.ProviderARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-providerarns
     * @external
     */
    providerArns: string[] | undefined;
    /**
     * Create a new `AWS::ApiGateway::Authorizer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAuthorizerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::BasePathMapping`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html
 * @external
 */
export interface CfnBasePathMappingProps {
    /**
     * `AWS::ApiGateway::BasePathMapping.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-domainname
     * @external
     */
    readonly domainName: string;
    /**
     * `AWS::ApiGateway::BasePathMapping.BasePath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-basepath
     * @external
     */
    readonly basePath?: string;
    /**
     * `AWS::ApiGateway::BasePathMapping.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-restapiid
     * @external
     */
    readonly restApiId?: string;
    /**
     * `AWS::ApiGateway::BasePathMapping.Stage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-stage
     * @external
     */
    readonly stage?: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::BasePathMapping`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html
 * @external
 * @cloudformationResource AWS::ApiGateway::BasePathMapping
 */
export declare class CfnBasePathMapping extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::BasePathMapping";
    /**
     * `AWS::ApiGateway::BasePathMapping.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-domainname
     * @external
     */
    domainName: string;
    /**
     * `AWS::ApiGateway::BasePathMapping.BasePath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-basepath
     * @external
     */
    basePath: string | undefined;
    /**
     * `AWS::ApiGateway::BasePathMapping.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-restapiid
     * @external
     */
    restApiId: string | undefined;
    /**
     * `AWS::ApiGateway::BasePathMapping.Stage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-stage
     * @external
     */
    stage: string | undefined;
    /**
     * Create a new `AWS::ApiGateway::BasePathMapping`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBasePathMappingProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::ClientCertificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html
 * @external
 */
export interface CfnClientCertificateProps {
    /**
     * `AWS::ApiGateway::ClientCertificate.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html#cfn-apigateway-clientcertificate-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGateway::ClientCertificate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html#cfn-apigateway-clientcertificate-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ApiGateway::ClientCertificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html
 * @external
 * @cloudformationResource AWS::ApiGateway::ClientCertificate
 */
export declare class CfnClientCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::ClientCertificate";
    /**
     * `AWS::ApiGateway::ClientCertificate.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html#cfn-apigateway-clientcertificate-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGateway::ClientCertificate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html#cfn-apigateway-clientcertificate-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ApiGateway::ClientCertificate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnClientCertificateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 * @external
 */
export interface CfnDeploymentProps {
    /**
     * `AWS::ApiGateway::Deployment.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid
     * @external
     */
    readonly restApiId: string;
    /**
     * `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
     * @external
     */
    readonly deploymentCanarySettings?: CfnDeployment.DeploymentCanarySettingsProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Deployment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGateway::Deployment.StageDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
     * @external
     */
    readonly stageDescription?: CfnDeployment.StageDescriptionProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Deployment.StageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename
     * @external
     */
    readonly stageName?: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Deployment
 */
export declare class CfnDeployment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::Deployment";
    /**
     * `AWS::ApiGateway::Deployment.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid
     * @external
     */
    restApiId: string;
    /**
     * `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
     * @external
     */
    deploymentCanarySettings: CfnDeployment.DeploymentCanarySettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Deployment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGateway::Deployment.StageDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
     * @external
     */
    stageDescription: CfnDeployment.StageDescriptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Deployment.StageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename
     * @external
     */
    stageName: string | undefined;
    /**
     * Create a new `AWS::ApiGateway::Deployment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeploymentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGateway::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Deployment
 */
export declare namespace CfnDeployment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html
     * @external
     */
    interface AccessLogSettingProperty {
        /**
         * `CfnDeployment.AccessLogSettingProperty.DestinationArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-destinationarn
         * @external
         */
        readonly destinationArn?: string;
        /**
         * `CfnDeployment.AccessLogSettingProperty.Format`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-format
         * @external
         */
        readonly format?: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Deployment
 */
export declare namespace CfnDeployment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html
     * @external
     */
    interface CanarySettingProperty {
        /**
         * `CfnDeployment.CanarySettingProperty.PercentTraffic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-percenttraffic
         * @external
         */
        readonly percentTraffic?: number;
        /**
         * `CfnDeployment.CanarySettingProperty.StageVariableOverrides`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-stagevariableoverrides
         * @external
         */
        readonly stageVariableOverrides?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnDeployment.CanarySettingProperty.UseStageCache`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-usestagecache
         * @external
         */
        readonly useStageCache?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Deployment
 */
export declare namespace CfnDeployment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html
     * @external
     */
    interface DeploymentCanarySettingsProperty {
        /**
         * `CfnDeployment.DeploymentCanarySettingsProperty.PercentTraffic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-percenttraffic
         * @external
         */
        readonly percentTraffic?: number;
        /**
         * `CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-stagevariableoverrides
         * @external
         */
        readonly stageVariableOverrides?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-usestagecache
         * @external
         */
        readonly useStageCache?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Deployment
 */
export declare namespace CfnDeployment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html
     * @external
     */
    interface MethodSettingProperty {
        /**
         * `CfnDeployment.MethodSettingProperty.CacheDataEncrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
         * @external
         */
        readonly cacheDataEncrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.MethodSettingProperty.CacheTtlInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
         * @external
         */
        readonly cacheTtlInSeconds?: number;
        /**
         * `CfnDeployment.MethodSettingProperty.CachingEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
         * @external
         */
        readonly cachingEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.MethodSettingProperty.DataTraceEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
         * @external
         */
        readonly dataTraceEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.MethodSettingProperty.HttpMethod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
         * @external
         */
        readonly httpMethod?: string;
        /**
         * `CfnDeployment.MethodSettingProperty.LoggingLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
         * @external
         */
        readonly loggingLevel?: string;
        /**
         * `CfnDeployment.MethodSettingProperty.MetricsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
         * @external
         */
        readonly metricsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.MethodSettingProperty.ResourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
         * @external
         */
        readonly resourcePath?: string;
        /**
         * `CfnDeployment.MethodSettingProperty.ThrottlingBurstLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
         * @external
         */
        readonly throttlingBurstLimit?: number;
        /**
         * `CfnDeployment.MethodSettingProperty.ThrottlingRateLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
         * @external
         */
        readonly throttlingRateLimit?: number;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Deployment
 */
export declare namespace CfnDeployment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html
     * @external
     */
    interface StageDescriptionProperty {
        /**
         * `CfnDeployment.StageDescriptionProperty.AccessLogSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-accesslogsetting
         * @external
         */
        readonly accessLogSetting?: CfnDeployment.AccessLogSettingProperty | cdk.IResolvable;
        /**
         * `CfnDeployment.StageDescriptionProperty.CacheClusterEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
         * @external
         */
        readonly cacheClusterEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.StageDescriptionProperty.CacheClusterSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
         * @external
         */
        readonly cacheClusterSize?: string;
        /**
         * `CfnDeployment.StageDescriptionProperty.CacheDataEncrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
         * @external
         */
        readonly cacheDataEncrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.StageDescriptionProperty.CacheTtlInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
         * @external
         */
        readonly cacheTtlInSeconds?: number;
        /**
         * `CfnDeployment.StageDescriptionProperty.CachingEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
         * @external
         */
        readonly cachingEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.StageDescriptionProperty.CanarySetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-canarysetting
         * @external
         */
        readonly canarySetting?: CfnDeployment.CanarySettingProperty | cdk.IResolvable;
        /**
         * `CfnDeployment.StageDescriptionProperty.ClientCertificateId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
         * @external
         */
        readonly clientCertificateId?: string;
        /**
         * `CfnDeployment.StageDescriptionProperty.DataTraceEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
         * @external
         */
        readonly dataTraceEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.StageDescriptionProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnDeployment.StageDescriptionProperty.DocumentationVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
         * @external
         */
        readonly documentationVersion?: string;
        /**
         * `CfnDeployment.StageDescriptionProperty.LoggingLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
         * @external
         */
        readonly loggingLevel?: string;
        /**
         * `CfnDeployment.StageDescriptionProperty.MethodSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
         * @external
         */
        readonly methodSettings?: Array<CfnDeployment.MethodSettingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDeployment.StageDescriptionProperty.MetricsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
         * @external
         */
        readonly metricsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.StageDescriptionProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
        /**
         * `CfnDeployment.StageDescriptionProperty.ThrottlingBurstLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
         * @external
         */
        readonly throttlingBurstLimit?: number;
        /**
         * `CfnDeployment.StageDescriptionProperty.ThrottlingRateLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
         * @external
         */
        readonly throttlingRateLimit?: number;
        /**
         * `CfnDeployment.StageDescriptionProperty.TracingEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-tracingenabled
         * @external
         */
        readonly tracingEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeployment.StageDescriptionProperty.Variables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
         * @external
         */
        readonly variables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ApiGateway::DocumentationPart`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html
 * @external
 */
export interface CfnDocumentationPartProps {
    /**
     * `AWS::ApiGateway::DocumentationPart.Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-location
     * @external
     */
    readonly location: CfnDocumentationPart.LocationProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::DocumentationPart.Properties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-properties
     * @external
     */
    readonly properties: string;
    /**
     * `AWS::ApiGateway::DocumentationPart.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-restapiid
     * @external
     */
    readonly restApiId: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::DocumentationPart`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html
 * @external
 * @cloudformationResource AWS::ApiGateway::DocumentationPart
 */
export declare class CfnDocumentationPart extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::DocumentationPart";
    /**
     * `AWS::ApiGateway::DocumentationPart.Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-location
     * @external
     */
    location: CfnDocumentationPart.LocationProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::DocumentationPart.Properties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-properties
     * @external
     */
    properties: string;
    /**
     * `AWS::ApiGateway::DocumentationPart.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-restapiid
     * @external
     */
    restApiId: string;
    /**
     * Create a new `AWS::ApiGateway::DocumentationPart`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDocumentationPartProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGateway::DocumentationPart`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html
 * @external
 * @cloudformationResource AWS::ApiGateway::DocumentationPart
 */
export declare namespace CfnDocumentationPart {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html
     * @external
     */
    interface LocationProperty {
        /**
         * `CfnDocumentationPart.LocationProperty.Method`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
         * @external
         */
        readonly method?: string;
        /**
         * `CfnDocumentationPart.LocationProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnDocumentationPart.LocationProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
         * @external
         */
        readonly path?: string;
        /**
         * `CfnDocumentationPart.LocationProperty.StatusCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
         * @external
         */
        readonly statusCode?: string;
        /**
         * `CfnDocumentationPart.LocationProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * Properties for defining a `AWS::ApiGateway::DocumentationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html
 * @external
 */
export interface CfnDocumentationVersionProps {
    /**
     * `AWS::ApiGateway::DocumentationVersion.DocumentationVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
     * @external
     */
    readonly documentationVersion: string;
    /**
     * `AWS::ApiGateway::DocumentationVersion.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
     * @external
     */
    readonly restApiId: string;
    /**
     * `AWS::ApiGateway::DocumentationVersion.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::DocumentationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html
 * @external
 * @cloudformationResource AWS::ApiGateway::DocumentationVersion
 */
export declare class CfnDocumentationVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::DocumentationVersion";
    /**
     * `AWS::ApiGateway::DocumentationVersion.DocumentationVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
     * @external
     */
    documentationVersion: string;
    /**
     * `AWS::ApiGateway::DocumentationVersion.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
     * @external
     */
    restApiId: string;
    /**
     * `AWS::ApiGateway::DocumentationVersion.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::ApiGateway::DocumentationVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDocumentationVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::DomainName`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
 * @external
 */
export interface CfnDomainNameProps {
    /**
     * `AWS::ApiGateway::DomainName.CertificateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-certificatearn
     * @external
     */
    readonly certificateArn?: string;
    /**
     * `AWS::ApiGateway::DomainName.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-domainname
     * @external
     */
    readonly domainName?: string;
    /**
     * `AWS::ApiGateway::DomainName.EndpointConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-endpointconfiguration
     * @external
     */
    readonly endpointConfiguration?: CfnDomainName.EndpointConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::DomainName.MutualTlsAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-mutualtlsauthentication
     * @external
     */
    readonly mutualTlsAuthentication?: CfnDomainName.MutualTlsAuthenticationProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::DomainName.RegionalCertificateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-regionalcertificatearn
     * @external
     */
    readonly regionalCertificateArn?: string;
    /**
     * `AWS::ApiGateway::DomainName.SecurityPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-securitypolicy
     * @external
     */
    readonly securityPolicy?: string;
    /**
     * `AWS::ApiGateway::DomainName.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ApiGateway::DomainName`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
 * @external
 * @cloudformationResource AWS::ApiGateway::DomainName
 */
export declare class CfnDomainName extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::DomainName";
    /**
     * @external
     * @cloudformationAttribute DistributionDomainName
     */
    readonly attrDistributionDomainName: string;
    /**
     * @external
     * @cloudformationAttribute DistributionHostedZoneId
     */
    readonly attrDistributionHostedZoneId: string;
    /**
     * @external
     * @cloudformationAttribute RegionalDomainName
     */
    readonly attrRegionalDomainName: string;
    /**
     * @external
     * @cloudformationAttribute RegionalHostedZoneId
     */
    readonly attrRegionalHostedZoneId: string;
    /**
     * `AWS::ApiGateway::DomainName.CertificateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-certificatearn
     * @external
     */
    certificateArn: string | undefined;
    /**
     * `AWS::ApiGateway::DomainName.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-domainname
     * @external
     */
    domainName: string | undefined;
    /**
     * `AWS::ApiGateway::DomainName.EndpointConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-endpointconfiguration
     * @external
     */
    endpointConfiguration: CfnDomainName.EndpointConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::DomainName.MutualTlsAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-mutualtlsauthentication
     * @external
     */
    mutualTlsAuthentication: CfnDomainName.MutualTlsAuthenticationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::DomainName.RegionalCertificateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-regionalcertificatearn
     * @external
     */
    regionalCertificateArn: string | undefined;
    /**
     * `AWS::ApiGateway::DomainName.SecurityPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-securitypolicy
     * @external
     */
    securityPolicy: string | undefined;
    /**
     * `AWS::ApiGateway::DomainName.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ApiGateway::DomainName`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDomainNameProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGateway::DomainName`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
 * @external
 * @cloudformationResource AWS::ApiGateway::DomainName
 */
export declare namespace CfnDomainName {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-endpointconfiguration.html
     * @external
     */
    interface EndpointConfigurationProperty {
        /**
         * `CfnDomainName.EndpointConfigurationProperty.Types`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-endpointconfiguration.html#cfn-apigateway-domainname-endpointconfiguration-types
         * @external
         */
        readonly types?: string[];
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::DomainName`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
 * @external
 * @cloudformationResource AWS::ApiGateway::DomainName
 */
export declare namespace CfnDomainName {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-mutualtlsauthentication.html
     * @external
     */
    interface MutualTlsAuthenticationProperty {
        /**
         * `CfnDomainName.MutualTlsAuthenticationProperty.TruststoreUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-mutualtlsauthentication.html#cfn-apigateway-domainname-mutualtlsauthentication-truststoreuri
         * @external
         */
        readonly truststoreUri?: string;
        /**
         * `CfnDomainName.MutualTlsAuthenticationProperty.TruststoreVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-mutualtlsauthentication.html#cfn-apigateway-domainname-mutualtlsauthentication-truststoreversion
         * @external
         */
        readonly truststoreVersion?: string;
    }
}
/**
 * Properties for defining a `AWS::ApiGateway::GatewayResponse`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html
 * @external
 */
export interface CfnGatewayResponseProps {
    /**
     * `AWS::ApiGateway::GatewayResponse.ResponseType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetype
     * @external
     */
    readonly responseType: string;
    /**
     * `AWS::ApiGateway::GatewayResponse.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-restapiid
     * @external
     */
    readonly restApiId: string;
    /**
     * `AWS::ApiGateway::GatewayResponse.ResponseParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responseparameters
     * @external
     */
    readonly responseParameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::GatewayResponse.ResponseTemplates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetemplates
     * @external
     */
    readonly responseTemplates?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::GatewayResponse.StatusCode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-statuscode
     * @external
     */
    readonly statusCode?: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::GatewayResponse`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html
 * @external
 * @cloudformationResource AWS::ApiGateway::GatewayResponse
 */
export declare class CfnGatewayResponse extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::GatewayResponse";
    /**
     * `AWS::ApiGateway::GatewayResponse.ResponseType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetype
     * @external
     */
    responseType: string;
    /**
     * `AWS::ApiGateway::GatewayResponse.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-restapiid
     * @external
     */
    restApiId: string;
    /**
     * `AWS::ApiGateway::GatewayResponse.ResponseParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responseparameters
     * @external
     */
    responseParameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::GatewayResponse.ResponseTemplates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetemplates
     * @external
     */
    responseTemplates: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::GatewayResponse.StatusCode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-statuscode
     * @external
     */
    statusCode: string | undefined;
    /**
     * Create a new `AWS::ApiGateway::GatewayResponse`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGatewayResponseProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::Method`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 * @external
 */
export interface CfnMethodProps {
    /**
     * `AWS::ApiGateway::Method.HttpMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     * @external
     */
    readonly httpMethod: string;
    /**
     * `AWS::ApiGateway::Method.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     * @external
     */
    readonly resourceId: string;
    /**
     * `AWS::ApiGateway::Method.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     * @external
     */
    readonly restApiId: string;
    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     * @external
     */
    readonly apiKeyRequired?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Method.AuthorizationScopes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     * @external
     */
    readonly authorizationScopes?: string[];
    /**
     * `AWS::ApiGateway::Method.AuthorizationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     * @external
     */
    readonly authorizationType?: string;
    /**
     * `AWS::ApiGateway::Method.AuthorizerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     * @external
     */
    readonly authorizerId?: string;
    /**
     * `AWS::ApiGateway::Method.Integration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     * @external
     */
    readonly integration?: CfnMethod.IntegrationProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     * @external
     */
    readonly methodResponses?: Array<CfnMethod.MethodResponseProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Method.OperationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     * @external
     */
    readonly operationName?: string;
    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     * @external
     */
    readonly requestModels?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     * @external
     */
    readonly requestParameters?: {
        [key: string]: (boolean | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Method.RequestValidatorId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     * @external
     */
    readonly requestValidatorId?: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::Method`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Method
 */
export declare class CfnMethod extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::Method";
    /**
     * `AWS::ApiGateway::Method.HttpMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     * @external
     */
    httpMethod: string;
    /**
     * `AWS::ApiGateway::Method.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     * @external
     */
    resourceId: string;
    /**
     * `AWS::ApiGateway::Method.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     * @external
     */
    restApiId: string;
    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     * @external
     */
    apiKeyRequired: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Method.AuthorizationScopes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     * @external
     */
    authorizationScopes: string[] | undefined;
    /**
     * `AWS::ApiGateway::Method.AuthorizationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     * @external
     */
    authorizationType: string | undefined;
    /**
     * `AWS::ApiGateway::Method.AuthorizerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     * @external
     */
    authorizerId: string | undefined;
    /**
     * `AWS::ApiGateway::Method.Integration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     * @external
     */
    integration: CfnMethod.IntegrationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     * @external
     */
    methodResponses: Array<CfnMethod.MethodResponseProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Method.OperationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     * @external
     */
    operationName: string | undefined;
    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     * @external
     */
    requestModels: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     * @external
     */
    requestParameters: {
        [key: string]: (boolean | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Method.RequestValidatorId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     * @external
     */
    requestValidatorId: string | undefined;
    /**
     * Create a new `AWS::ApiGateway::Method`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMethodProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGateway::Method`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Method
 */
export declare namespace CfnMethod {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html
     * @external
     */
    interface IntegrationProperty {
        /**
         * `CfnMethod.IntegrationProperty.CacheKeyParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         * @external
         */
        readonly cacheKeyParameters?: string[];
        /**
         * `CfnMethod.IntegrationProperty.CacheNamespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         * @external
         */
        readonly cacheNamespace?: string;
        /**
         * `CfnMethod.IntegrationProperty.ConnectionId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectionid
         * @external
         */
        readonly connectionId?: string;
        /**
         * `CfnMethod.IntegrationProperty.ConnectionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectiontype
         * @external
         */
        readonly connectionType?: string;
        /**
         * `CfnMethod.IntegrationProperty.ContentHandling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         * @external
         */
        readonly contentHandling?: string;
        /**
         * `CfnMethod.IntegrationProperty.Credentials`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         * @external
         */
        readonly credentials?: string;
        /**
         * `CfnMethod.IntegrationProperty.IntegrationHttpMethod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         * @external
         */
        readonly integrationHttpMethod?: string;
        /**
         * `CfnMethod.IntegrationProperty.IntegrationResponses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         * @external
         */
        readonly integrationResponses?: Array<CfnMethod.IntegrationResponseProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnMethod.IntegrationProperty.PassthroughBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         * @external
         */
        readonly passthroughBehavior?: string;
        /**
         * `CfnMethod.IntegrationProperty.RequestParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         * @external
         */
        readonly requestParameters?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnMethod.IntegrationProperty.RequestTemplates`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         * @external
         */
        readonly requestTemplates?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnMethod.IntegrationProperty.TimeoutInMillis`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-timeoutinmillis
         * @external
         */
        readonly timeoutInMillis?: number;
        /**
         * `CfnMethod.IntegrationProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnMethod.IntegrationProperty.Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         * @external
         */
        readonly uri?: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::Method`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Method
 */
export declare namespace CfnMethod {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html
     * @external
     */
    interface IntegrationResponseProperty {
        /**
         * `CfnMethod.IntegrationResponseProperty.ContentHandling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         * @external
         */
        readonly contentHandling?: string;
        /**
         * `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         * @external
         */
        readonly responseParameters?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         * @external
         */
        readonly responseTemplates?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnMethod.IntegrationResponseProperty.SelectionPattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         * @external
         */
        readonly selectionPattern?: string;
        /**
         * `CfnMethod.IntegrationResponseProperty.StatusCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         * @external
         */
        readonly statusCode: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::Method`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Method
 */
export declare namespace CfnMethod {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html
     * @external
     */
    interface MethodResponseProperty {
        /**
         * `CfnMethod.MethodResponseProperty.ResponseModels`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         * @external
         */
        readonly responseModels?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnMethod.MethodResponseProperty.ResponseParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         * @external
         */
        readonly responseParameters?: {
            [key: string]: (boolean | cdk.IResolvable);
        } | cdk.IResolvable;
        /**
         * `CfnMethod.MethodResponseProperty.StatusCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         * @external
         */
        readonly statusCode: string;
    }
}
/**
 * Properties for defining a `AWS::ApiGateway::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html
 * @external
 */
export interface CfnModelProps {
    /**
     * `AWS::ApiGateway::Model.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-restapiid
     * @external
     */
    readonly restApiId: string;
    /**
     * `AWS::ApiGateway::Model.ContentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-contenttype
     * @external
     */
    readonly contentType?: string;
    /**
     * `AWS::ApiGateway::Model.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGateway::Model.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::ApiGateway::Model.Schema`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-schema
     * @external
     */
    readonly schema?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApiGateway::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Model
 */
export declare class CfnModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::Model";
    /**
     * `AWS::ApiGateway::Model.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-restapiid
     * @external
     */
    restApiId: string;
    /**
     * `AWS::ApiGateway::Model.ContentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-contenttype
     * @external
     */
    contentType: string | undefined;
    /**
     * `AWS::ApiGateway::Model.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGateway::Model.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::ApiGateway::Model.Schema`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-schema
     * @external
     */
    schema: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApiGateway::Model`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::RequestValidator`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html
 * @external
 */
export interface CfnRequestValidatorProps {
    /**
     * `AWS::ApiGateway::RequestValidator.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-restapiid
     * @external
     */
    readonly restApiId: string;
    /**
     * `AWS::ApiGateway::RequestValidator.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::ApiGateway::RequestValidator.ValidateRequestBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-validaterequestbody
     * @external
     */
    readonly validateRequestBody?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::RequestValidator.ValidateRequestParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-validaterequestparameters
     * @external
     */
    readonly validateRequestParameters?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApiGateway::RequestValidator`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html
 * @external
 * @cloudformationResource AWS::ApiGateway::RequestValidator
 */
export declare class CfnRequestValidator extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::RequestValidator";
    /**
     * `AWS::ApiGateway::RequestValidator.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-restapiid
     * @external
     */
    restApiId: string;
    /**
     * `AWS::ApiGateway::RequestValidator.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::ApiGateway::RequestValidator.ValidateRequestBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-validaterequestbody
     * @external
     */
    validateRequestBody: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::RequestValidator.ValidateRequestParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-validaterequestparameters
     * @external
     */
    validateRequestParameters: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApiGateway::RequestValidator`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRequestValidatorProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::Resource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html
 * @external
 */
export interface CfnResourceProps {
    /**
     * `AWS::ApiGateway::Resource.ParentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-parentid
     * @external
     */
    readonly parentId: string;
    /**
     * `AWS::ApiGateway::Resource.PathPart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-pathpart
     * @external
     */
    readonly pathPart: string;
    /**
     * `AWS::ApiGateway::Resource.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-restapiid
     * @external
     */
    readonly restApiId: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::Resource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Resource
 */
export declare class CfnResource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::Resource";
    /**
     * `AWS::ApiGateway::Resource.ParentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-parentid
     * @external
     */
    parentId: string;
    /**
     * `AWS::ApiGateway::Resource.PathPart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-pathpart
     * @external
     */
    pathPart: string;
    /**
     * `AWS::ApiGateway::Resource.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-restapiid
     * @external
     */
    restApiId: string;
    /**
     * Create a new `AWS::ApiGateway::Resource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::RestApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 * @external
 */
export interface CfnRestApiProps {
    /**
     * `AWS::ApiGateway::RestApi.ApiKeySourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype
     * @external
     */
    readonly apiKeySourceType?: string;
    /**
     * `AWS::ApiGateway::RestApi.BinaryMediaTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes
     * @external
     */
    readonly binaryMediaTypes?: string[];
    /**
     * `AWS::ApiGateway::RestApi.Body`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body
     * @external
     */
    readonly body?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::RestApi.BodyS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
     * @external
     */
    readonly bodyS3Location?: CfnRestApi.S3LocationProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::RestApi.CloneFrom`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom
     * @external
     */
    readonly cloneFrom?: string;
    /**
     * `AWS::ApiGateway::RestApi.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGateway::RestApi.EndpointConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
     * @external
     */
    readonly endpointConfiguration?: CfnRestApi.EndpointConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::RestApi.FailOnWarnings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
     * @external
     */
    readonly failOnWarnings?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::RestApi.MinimumCompressionSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize
     * @external
     */
    readonly minimumCompressionSize?: number;
    /**
     * `AWS::ApiGateway::RestApi.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::ApiGateway::RestApi.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
     * @external
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::RestApi.Policy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy
     * @external
     */
    readonly policy?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::RestApi.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ApiGateway::RestApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 * @external
 * @cloudformationResource AWS::ApiGateway::RestApi
 */
export declare class CfnRestApi extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::RestApi";
    /**
     * @external
     * @cloudformationAttribute RootResourceId
     */
    readonly attrRootResourceId: string;
    /**
     * `AWS::ApiGateway::RestApi.ApiKeySourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype
     * @external
     */
    apiKeySourceType: string | undefined;
    /**
     * `AWS::ApiGateway::RestApi.BinaryMediaTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes
     * @external
     */
    binaryMediaTypes: string[] | undefined;
    /**
     * `AWS::ApiGateway::RestApi.Body`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body
     * @external
     */
    body: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::RestApi.BodyS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
     * @external
     */
    bodyS3Location: CfnRestApi.S3LocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::RestApi.CloneFrom`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom
     * @external
     */
    cloneFrom: string | undefined;
    /**
     * `AWS::ApiGateway::RestApi.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGateway::RestApi.EndpointConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
     * @external
     */
    endpointConfiguration: CfnRestApi.EndpointConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::RestApi.FailOnWarnings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
     * @external
     */
    failOnWarnings: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::RestApi.MinimumCompressionSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize
     * @external
     */
    minimumCompressionSize: number | undefined;
    /**
     * `AWS::ApiGateway::RestApi.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::ApiGateway::RestApi.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
     * @external
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::RestApi.Policy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy
     * @external
     */
    policy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::RestApi.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ApiGateway::RestApi`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnRestApiProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGateway::RestApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 * @external
 * @cloudformationResource AWS::ApiGateway::RestApi
 */
export declare namespace CfnRestApi {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
     * @external
     */
    interface EndpointConfigurationProperty {
        /**
         * `CfnRestApi.EndpointConfigurationProperty.Types`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
         * @external
         */
        readonly types?: string[];
        /**
         * `CfnRestApi.EndpointConfigurationProperty.VpcEndpointIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-vpcendpointids
         * @external
         */
        readonly vpcEndpointIds?: string[];
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::RestApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 * @external
 * @cloudformationResource AWS::ApiGateway::RestApi
 */
export declare namespace CfnRestApi {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnRestApi.S3LocationProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
         * @external
         */
        readonly bucket?: string;
        /**
         * `CfnRestApi.S3LocationProperty.ETag`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
         * @external
         */
        readonly eTag?: string;
        /**
         * `CfnRestApi.S3LocationProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnRestApi.S3LocationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * Properties for defining a `AWS::ApiGateway::Stage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
 * @external
 */
export interface CfnStageProps {
    /**
     * `AWS::ApiGateway::Stage.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-restapiid
     * @external
     */
    readonly restApiId: string;
    /**
     * `AWS::ApiGateway::Stage.AccessLogSetting`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-accesslogsetting
     * @external
     */
    readonly accessLogSetting?: CfnStage.AccessLogSettingProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Stage.CacheClusterEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclusterenabled
     * @external
     */
    readonly cacheClusterEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Stage.CacheClusterSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclustersize
     * @external
     */
    readonly cacheClusterSize?: string;
    /**
     * `AWS::ApiGateway::Stage.CanarySetting`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-canarysetting
     * @external
     */
    readonly canarySetting?: CfnStage.CanarySettingProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Stage.ClientCertificateId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-clientcertificateid
     * @external
     */
    readonly clientCertificateId?: string;
    /**
     * `AWS::ApiGateway::Stage.DeploymentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-deploymentid
     * @external
     */
    readonly deploymentId?: string;
    /**
     * `AWS::ApiGateway::Stage.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGateway::Stage.DocumentationVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-documentationversion
     * @external
     */
    readonly documentationVersion?: string;
    /**
     * `AWS::ApiGateway::Stage.MethodSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-methodsettings
     * @external
     */
    readonly methodSettings?: Array<CfnStage.MethodSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Stage.StageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-stagename
     * @external
     */
    readonly stageName?: string;
    /**
     * `AWS::ApiGateway::Stage.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ApiGateway::Stage.TracingEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tracingenabled
     * @external
     */
    readonly tracingEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::Stage.Variables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-variables
     * @external
     */
    readonly variables?: {
        [key: string]: (string);
    } | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApiGateway::Stage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Stage
 */
export declare class CfnStage extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::Stage";
    /**
     * `AWS::ApiGateway::Stage.RestApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-restapiid
     * @external
     */
    restApiId: string;
    /**
     * `AWS::ApiGateway::Stage.AccessLogSetting`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-accesslogsetting
     * @external
     */
    accessLogSetting: CfnStage.AccessLogSettingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Stage.CacheClusterEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclusterenabled
     * @external
     */
    cacheClusterEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Stage.CacheClusterSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclustersize
     * @external
     */
    cacheClusterSize: string | undefined;
    /**
     * `AWS::ApiGateway::Stage.CanarySetting`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-canarysetting
     * @external
     */
    canarySetting: CfnStage.CanarySettingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Stage.ClientCertificateId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-clientcertificateid
     * @external
     */
    clientCertificateId: string | undefined;
    /**
     * `AWS::ApiGateway::Stage.DeploymentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-deploymentid
     * @external
     */
    deploymentId: string | undefined;
    /**
     * `AWS::ApiGateway::Stage.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGateway::Stage.DocumentationVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-documentationversion
     * @external
     */
    documentationVersion: string | undefined;
    /**
     * `AWS::ApiGateway::Stage.MethodSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-methodsettings
     * @external
     */
    methodSettings: Array<CfnStage.MethodSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Stage.StageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-stagename
     * @external
     */
    stageName: string | undefined;
    /**
     * `AWS::ApiGateway::Stage.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ApiGateway::Stage.TracingEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tracingenabled
     * @external
     */
    tracingEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::Stage.Variables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-variables
     * @external
     */
    variables: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApiGateway::Stage`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStageProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGateway::Stage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Stage
 */
export declare namespace CfnStage {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
     * @external
     */
    interface AccessLogSettingProperty {
        /**
         * `CfnStage.AccessLogSettingProperty.DestinationArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         * @external
         */
        readonly destinationArn?: string;
        /**
         * `CfnStage.AccessLogSettingProperty.Format`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         * @external
         */
        readonly format?: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::Stage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Stage
 */
export declare namespace CfnStage {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html
     * @external
     */
    interface CanarySettingProperty {
        /**
         * `CfnStage.CanarySettingProperty.DeploymentId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
         * @external
         */
        readonly deploymentId?: string;
        /**
         * `CfnStage.CanarySettingProperty.PercentTraffic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
         * @external
         */
        readonly percentTraffic?: number;
        /**
         * `CfnStage.CanarySettingProperty.StageVariableOverrides`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
         * @external
         */
        readonly stageVariableOverrides?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnStage.CanarySettingProperty.UseStageCache`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
         * @external
         */
        readonly useStageCache?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::Stage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
 * @external
 * @cloudformationResource AWS::ApiGateway::Stage
 */
export declare namespace CfnStage {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html
     * @external
     */
    interface MethodSettingProperty {
        /**
         * `CfnStage.MethodSettingProperty.CacheDataEncrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
         * @external
         */
        readonly cacheDataEncrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnStage.MethodSettingProperty.CacheTtlInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
         * @external
         */
        readonly cacheTtlInSeconds?: number;
        /**
         * `CfnStage.MethodSettingProperty.CachingEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
         * @external
         */
        readonly cachingEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnStage.MethodSettingProperty.DataTraceEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
         * @external
         */
        readonly dataTraceEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnStage.MethodSettingProperty.HttpMethod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
         * @external
         */
        readonly httpMethod?: string;
        /**
         * `CfnStage.MethodSettingProperty.LoggingLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
         * @external
         */
        readonly loggingLevel?: string;
        /**
         * `CfnStage.MethodSettingProperty.MetricsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
         * @external
         */
        readonly metricsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnStage.MethodSettingProperty.ResourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
         * @external
         */
        readonly resourcePath?: string;
        /**
         * `CfnStage.MethodSettingProperty.ThrottlingBurstLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
         * @external
         */
        readonly throttlingBurstLimit?: number;
        /**
         * `CfnStage.MethodSettingProperty.ThrottlingRateLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
         * @external
         */
        readonly throttlingRateLimit?: number;
    }
}
/**
 * Properties for defining a `AWS::ApiGateway::UsagePlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html
 * @external
 */
export interface CfnUsagePlanProps {
    /**
     * `AWS::ApiGateway::UsagePlan.ApiStages`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-apistages
     * @external
     */
    readonly apiStages?: Array<CfnUsagePlan.ApiStageProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::UsagePlan.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGateway::UsagePlan.Quota`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-quota
     * @external
     */
    readonly quota?: CfnUsagePlan.QuotaSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::UsagePlan.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ApiGateway::UsagePlan.Throttle`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-throttle
     * @external
     */
    readonly throttle?: CfnUsagePlan.ThrottleSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGateway::UsagePlan.UsagePlanName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-usageplanname
     * @external
     */
    readonly usagePlanName?: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::UsagePlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html
 * @external
 * @cloudformationResource AWS::ApiGateway::UsagePlan
 */
export declare class CfnUsagePlan extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::UsagePlan";
    /**
     * `AWS::ApiGateway::UsagePlan.ApiStages`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-apistages
     * @external
     */
    apiStages: Array<CfnUsagePlan.ApiStageProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::UsagePlan.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGateway::UsagePlan.Quota`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-quota
     * @external
     */
    quota: CfnUsagePlan.QuotaSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::UsagePlan.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ApiGateway::UsagePlan.Throttle`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-throttle
     * @external
     */
    throttle: CfnUsagePlan.ThrottleSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGateway::UsagePlan.UsagePlanName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-usageplanname
     * @external
     */
    usagePlanName: string | undefined;
    /**
     * Create a new `AWS::ApiGateway::UsagePlan`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnUsagePlanProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGateway::UsagePlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html
 * @external
 * @cloudformationResource AWS::ApiGateway::UsagePlan
 */
export declare namespace CfnUsagePlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html
     * @external
     */
    interface ApiStageProperty {
        /**
         * `CfnUsagePlan.ApiStageProperty.ApiId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
         * @external
         */
        readonly apiId?: string;
        /**
         * `CfnUsagePlan.ApiStageProperty.Stage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
         * @external
         */
        readonly stage?: string;
        /**
         * `CfnUsagePlan.ApiStageProperty.Throttle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-throttle
         * @external
         */
        readonly throttle?: {
            [key: string]: (CfnUsagePlan.ThrottleSettingsProperty | cdk.IResolvable);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::UsagePlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html
 * @external
 * @cloudformationResource AWS::ApiGateway::UsagePlan
 */
export declare namespace CfnUsagePlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html
     * @external
     */
    interface QuotaSettingsProperty {
        /**
         * `CfnUsagePlan.QuotaSettingsProperty.Limit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
         * @external
         */
        readonly limit?: number;
        /**
         * `CfnUsagePlan.QuotaSettingsProperty.Offset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
         * @external
         */
        readonly offset?: number;
        /**
         * `CfnUsagePlan.QuotaSettingsProperty.Period`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
         * @external
         */
        readonly period?: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGateway::UsagePlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html
 * @external
 * @cloudformationResource AWS::ApiGateway::UsagePlan
 */
export declare namespace CfnUsagePlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html
     * @external
     */
    interface ThrottleSettingsProperty {
        /**
         * `CfnUsagePlan.ThrottleSettingsProperty.BurstLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
         * @external
         */
        readonly burstLimit?: number;
        /**
         * `CfnUsagePlan.ThrottleSettingsProperty.RateLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
         * @external
         */
        readonly rateLimit?: number;
    }
}
/**
 * Properties for defining a `AWS::ApiGateway::UsagePlanKey`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html
 * @external
 */
export interface CfnUsagePlanKeyProps {
    /**
     * `AWS::ApiGateway::UsagePlanKey.KeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-keyid
     * @external
     */
    readonly keyId: string;
    /**
     * `AWS::ApiGateway::UsagePlanKey.KeyType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-keytype
     * @external
     */
    readonly keyType: string;
    /**
     * `AWS::ApiGateway::UsagePlanKey.UsagePlanId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-usageplanid
     * @external
     */
    readonly usagePlanId: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::UsagePlanKey`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html
 * @external
 * @cloudformationResource AWS::ApiGateway::UsagePlanKey
 */
export declare class CfnUsagePlanKey extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::UsagePlanKey";
    /**
     * `AWS::ApiGateway::UsagePlanKey.KeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-keyid
     * @external
     */
    keyId: string;
    /**
     * `AWS::ApiGateway::UsagePlanKey.KeyType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-keytype
     * @external
     */
    keyType: string;
    /**
     * `AWS::ApiGateway::UsagePlanKey.UsagePlanId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-usageplanid
     * @external
     */
    usagePlanId: string;
    /**
     * Create a new `AWS::ApiGateway::UsagePlanKey`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUsagePlanKeyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGateway::VpcLink`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html
 * @external
 */
export interface CfnVpcLinkProps {
    /**
     * `AWS::ApiGateway::VpcLink.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::ApiGateway::VpcLink.TargetArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-targetarns
     * @external
     */
    readonly targetArns: string[];
    /**
     * `AWS::ApiGateway::VpcLink.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::ApiGateway::VpcLink`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html
 * @external
 * @cloudformationResource AWS::ApiGateway::VpcLink
 */
export declare class CfnVpcLink extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGateway::VpcLink";
    /**
     * `AWS::ApiGateway::VpcLink.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-name
     * @external
     */
    name: string;
    /**
     * `AWS::ApiGateway::VpcLink.TargetArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-targetarns
     * @external
     */
    targetArns: string[];
    /**
     * `AWS::ApiGateway::VpcLink.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::ApiGateway::VpcLink`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVpcLinkProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
