"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Amplifybackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Amplifybackend extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'amplifybackend';
        this.accessLevelList = {
            Write: [
                'CloneBackend',
                'CreateBackend',
                'CreateBackendAPI',
                'CreateBackendAuth',
                'CreateBackendConfig',
                'CreateBackendStorage',
                'CreateToken',
                'DeleteBackend',
                'DeleteBackendAPI',
                'DeleteBackendAuth',
                'DeleteBackendStorage',
                'DeleteToken',
                'GenerateBackendAPIModels',
                'ImportBackendAuth',
                'ImportBackendStorage',
                'RemoveAllBackends',
                'RemoveBackendConfig',
                'UpdateBackendAPI',
                'UpdateBackendAuth',
                'UpdateBackendConfig',
                'UpdateBackendJob',
                'UpdateBackendStorage'
            ],
            Read: [
                'GetBackend',
                'GetBackendAPI',
                'GetBackendAPIModels',
                'GetBackendAuth',
                'GetBackendJob',
                'GetBackendStorage',
                'GetToken'
            ],
            List: [
                'ListBackendJobs',
                'ListS3Buckets'
            ]
        };
    }
    /**
     * Grants permission to clone an existing Amplify Admin backend environment into a new Amplify Admin backend enviroment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-clone.html#CloneBackend
     */
    toCloneBackend() {
        return this.to('CloneBackend');
    }
    /**
     * Grants permission to create a new Amplify Admin backend environment by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html#CreateBackend
     */
    toCreateBackend() {
        return this.to('CreateBackend');
    }
    /**
     * Grants permission to create an API for an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html#CreateBackendAPI
     */
    toCreateBackendAPI() {
        return this.to('CreateBackendAPI');
    }
    /**
     * Grants permission to create an auth resource for an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html#CreateBackendAuth
     */
    toCreateBackendAuth() {
        return this.to('CreateBackendAuth');
    }
    /**
     * Grants permission to create a new Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html#CreateBackendConfig
     */
    toCreateBackendConfig() {
        return this.to('CreateBackendConfig');
    }
    /**
     * Grants permission to create a backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#CreateBackendStorage
     */
    toCreateBackendStorage() {
        return this.to('CreateBackendStorage');
    }
    /**
     * Grants permission to create an Amplify Admin challenge token by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge.html#CreateToken
     */
    toCreateToken() {
        return this.to('CreateToken');
    }
    /**
     * Grants permission to delete an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-remove.html#DeleteBackend
     */
    toDeleteBackend() {
        return this.to('DeleteBackend');
    }
    /**
     * Grants permission to delete an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-remove.html#DeleteBackendAPI
     */
    toDeleteBackendAPI() {
        return this.to('DeleteBackendAPI');
    }
    /**
     * Grants permission to delete an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-remove.html#DeleteBackendAuth
     */
    toDeleteBackendAuth() {
        return this.to('DeleteBackendAuth');
    }
    /**
     * Grants permission to delete a backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#DeleteBackendStorage
     */
    toDeleteBackendStorage() {
        return this.to('DeleteBackendStorage');
    }
    /**
     * Grants permission to delete an Amplify Admin challenge token by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid-remove.html#DeleteToken
     */
    toDeleteToken() {
        return this.to('DeleteToken');
    }
    /**
     * Grants permission to generate models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-generatemodels.html#GenerateBackendAPIModels
     */
    toGenerateBackendAPIModels() {
        return this.to('GenerateBackendAPIModels');
    }
    /**
     * Grants permission to retrieve an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-details.html#GetBackend
     */
    toGetBackend() {
        return this.to('GetBackend');
    }
    /**
     * Grants permission to retrieve an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html#GetBackendAPI
     */
    toGetBackendAPI() {
        return this.to('GetBackendAPI');
    }
    /**
     * Grants permission to retrieve models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-getmodels.html#GetBackendAPIModels
     */
    toGetBackendAPIModels() {
        return this.to('GetBackendAPIModels');
    }
    /**
     * Grants permission to retrieve an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-details.html#GetBackendAuth
     */
    toGetBackendAuth() {
        return this.to('GetBackendAuth');
    }
    /**
     * Grants permission to retrieve a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#GetBackendJob
     */
    toGetBackendJob() {
        return this.to('GetBackendJob');
    }
    /**
     * Grants permission to retrieve an existing backend storage resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#GetBackendStorage
     */
    toGetBackendStorage() {
        return this.to('GetBackendStorage');
    }
    /**
     * Grants permission to retrieve an Amplify Admin challenge token by appId
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid.html#GetToken
     */
    toGetToken() {
        return this.to('GetToken');
    }
    /**
     * Grants permission to import an existing auth resource of an Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#ImportBackendAuth
     */
    toImportBackendAuth() {
        return this.to('ImportBackendAuth');
    }
    /**
     * Grants permission to import an existing backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#ImportBackendStorage
     */
    toImportBackendStorage() {
        return this.to('ImportBackendStorage');
    }
    /**
     * Grants permission to retrieve the jobs of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html#ListBackendJobs
     */
    toListBackendJobs() {
        return this.to('ListBackendJobs');
    }
    /**
     * Grants permission to retrieve s3 buckets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#ListS3Buckets
     */
    toListS3Buckets() {
        return this.to('ListS3Buckets');
    }
    /**
     * Grants permission to delete all existing Amplify Admin backend environments by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-remove.html#RemoveAllBackends
     */
    toRemoveAllBackends() {
        return this.to('RemoveAllBackends');
    }
    /**
     * Grants permission to delete an Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-remove.html#RemoveBackendConfig
     */
    toRemoveBackendConfig() {
        return this.to('RemoveBackendConfig');
    }
    /**
     * Grants permission to update an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname.html#UpdateBackendAPI
     */
    toUpdateBackendAPI() {
        return this.to('UpdateBackendAPI');
    }
    /**
     * Grants permission to update an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#UpdateBackendAuth
     */
    toUpdateBackendAuth() {
        return this.to('UpdateBackendAuth');
    }
    /**
     * Grants permission to update an Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-update.html#UpdateBackendConfig
     */
    toUpdateBackendConfig() {
        return this.to('UpdateBackendConfig');
    }
    /**
     * Grants permission to update a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#UpdateBackendJob
     */
    toUpdateBackendJob() {
        return this.to('UpdateBackendJob');
    }
    /**
     * Grants permission to update a backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#UpdateBackendStorage
     */
    toUpdateBackendStorage() {
        return this.to('UpdateBackendStorage');
    }
    /**
     * Adds a resource of type backend to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBackend(appId, account, region, partition) {
        return this.on(`arn:${partition || Amplifybackend.defaultPartition}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}`);
    }
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEnvironment(appId, account, region, partition) {
        return this.on(`arn:${partition || Amplifybackend.defaultPartition}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/environments`);
    }
    /**
     * Adds a resource of type api to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApi(appId, account, region, partition) {
        return this.on(`arn:${partition || Amplifybackend.defaultPartition}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/api`);
    }
    /**
     * Adds a resource of type auth to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAuth(appId, account, region, partition) {
        return this.on(`arn:${partition || Amplifybackend.defaultPartition}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/auth`);
    }
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onJob(appId, account, region, partition) {
        return this.on(`arn:${partition || Amplifybackend.defaultPartition}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/job`);
    }
    /**
     * Adds a resource of type config to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConfig(appId, account, region, partition) {
        return this.on(`arn:${partition || Amplifybackend.defaultPartition}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/config`);
    }
    /**
     * Adds a resource of type token to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-token.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onToken(appId, account, region, partition) {
        return this.on(`arn:${partition || Amplifybackend.defaultPartition}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/token`);
    }
    /**
     * Adds a resource of type storage to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onStorage(appId, account, region, partition) {
        return this.on(`arn:${partition || Amplifybackend.defaultPartition}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/storage`);
    }
}
exports.Amplifybackend = Amplifybackend;
_a = JSII_RTTI_SYMBOL_1;
Amplifybackend[_a] = { fqn: "iam-floyd.Amplifybackend", version: "0.502.0" };
//# sourceMappingURL=data:application/json;base64,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