"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Athena = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [athena](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonathena.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Athena extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [athena](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonathena.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'athena';
        this.accessLevelList = {
            Read: [
                'BatchGetNamedQuery',
                'BatchGetPreparedStatement',
                'BatchGetQueryExecution',
                'GetCalculationExecution',
                'GetCalculationExecutionCode',
                'GetCalculationExecutionStatus',
                'GetDataCatalog',
                'GetDatabase',
                'GetNamedQuery',
                'GetNotebookMetadata',
                'GetPreparedStatement',
                'GetQueryExecution',
                'GetQueryResults',
                'GetQueryResultsStream',
                'GetQueryRuntimeStatistics',
                'GetSession',
                'GetSessionStatus',
                'GetTableMetadata',
                'GetWorkGroup',
                'ListEngineVersions',
                'ListQueryExecutions',
                'ListTableMetadata',
                'ListTagsForResource'
            ],
            Write: [
                'CreateDataCatalog',
                'CreateNamedQuery',
                'CreateNotebook',
                'CreatePreparedStatement',
                'CreatePresignedNotebookUrl',
                'CreateWorkGroup',
                'DeleteDataCatalog',
                'DeleteNamedQuery',
                'DeleteNotebook',
                'DeletePreparedStatement',
                'DeleteWorkGroup',
                'ExportNotebook',
                'ImportNotebook',
                'StartCalculationExecution',
                'StartQueryExecution',
                'StartSession',
                'StopCalculationExecution',
                'StopQueryExecution',
                'TerminateSession',
                'UpdateDataCatalog',
                'UpdateNamedQuery',
                'UpdateNotebook',
                'UpdateNotebookMetadata',
                'UpdatePreparedStatement',
                'UpdateWorkGroup'
            ],
            List: [
                'ListApplicationDPUSizes',
                'ListCalculationExecutions',
                'ListDataCatalogs',
                'ListDatabases',
                'ListExecutors',
                'ListNamedQueries',
                'ListNotebookMetadata',
                'ListNotebookSessions',
                'ListPreparedStatements',
                'ListSessions',
                'ListWorkGroups'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to get information about one or more named queries
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_BatchGetNamedQuery.html
     */
    toBatchGetNamedQuery() {
        return this.to('BatchGetNamedQuery');
    }
    /**
     * Grants permission to get information about one or more prepared statements
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_BatchGetPreparedStatement.html
     */
    toBatchGetPreparedStatement() {
        return this.to('BatchGetPreparedStatement');
    }
    /**
     * Grants permission to get information about one or more query executions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_BatchGetQueryExecution.html
     */
    toBatchGetQueryExecution() {
        return this.to('BatchGetQueryExecution');
    }
    /**
     * Grants permission to create a datacatalog
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_CreateDataCatalog.html
     */
    toCreateDataCatalog() {
        return this.to('CreateDataCatalog');
    }
    /**
     * Grants permission to create a named query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_CreateNamedQuery.html
     */
    toCreateNamedQuery() {
        return this.to('CreateNamedQuery');
    }
    /**
     * Grants permission to create a notebook
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_CreateNotebook.html
     */
    toCreateNotebook() {
        return this.to('CreateNotebook');
    }
    /**
     * Grants permission to create a prepared statement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_CreatePreparedStatement.html
     */
    toCreatePreparedStatement() {
        return this.to('CreatePreparedStatement');
    }
    /**
     * Grants permission to create a presigned notebook url
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_CreatePresignedNotebookUrl.html
     */
    toCreatePresignedNotebookUrl() {
        return this.to('CreatePresignedNotebookUrl');
    }
    /**
     * Grants permission to create a workgroup
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_CreateWorkGroup.html
     */
    toCreateWorkGroup() {
        return this.to('CreateWorkGroup');
    }
    /**
     * Grants permission to delete a datacatalog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_DeleteDataCatalog.html
     */
    toDeleteDataCatalog() {
        return this.to('DeleteDataCatalog');
    }
    /**
     * Grants permission to delete a named query specified
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_DeleteNamedQuery.html
     */
    toDeleteNamedQuery() {
        return this.to('DeleteNamedQuery');
    }
    /**
     * Grants permission to delete a notebook
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_DeleteNotebook.html
     */
    toDeleteNotebook() {
        return this.to('DeleteNotebook');
    }
    /**
     * Grants permission to delete a prepared statement specified
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_DeletePreparedStatement.html
     */
    toDeletePreparedStatement() {
        return this.to('DeletePreparedStatement');
    }
    /**
     * Grants permission to delete a workgroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_DeleteWorkGroup.html
     */
    toDeleteWorkGroup() {
        return this.to('DeleteWorkGroup');
    }
    /**
     * Grants permission to export a notebook
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ExportNotebook.html
     */
    toExportNotebook() {
        return this.to('ExportNotebook');
    }
    /**
     * Grants permission to get a calculation execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetCalculationExecution.html
     */
    toGetCalculationExecution() {
        return this.to('GetCalculationExecution');
    }
    /**
     * Grants permission to get a calculation execution code
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetCalculationExecutionCode.html
     */
    toGetCalculationExecutionCode() {
        return this.to('GetCalculationExecutionCode');
    }
    /**
     * Grants permission to get a calculation execution status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetCalculationExecutionStatus.html
     */
    toGetCalculationExecutionStatus() {
        return this.to('GetCalculationExecutionStatus');
    }
    /**
     * Grants permission to get a datacatalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetDataCatalog.html
     */
    toGetDataCatalog() {
        return this.to('GetDataCatalog');
    }
    /**
     * Grants permission to get a database for a given datacatalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetDatabase.html
     */
    toGetDatabase() {
        return this.to('GetDatabase');
    }
    /**
     * Grants permission to get information about the specified named query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetNamedQuery.html
     */
    toGetNamedQuery() {
        return this.to('GetNamedQuery');
    }
    /**
     * Grants permission to get notebook metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetNotebookMetadata.html
     */
    toGetNotebookMetadata() {
        return this.to('GetNotebookMetadata');
    }
    /**
     * Grants permission to get information about the specified prepared statement
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetPreparedStatement.html
     */
    toGetPreparedStatement() {
        return this.to('GetPreparedStatement');
    }
    /**
     * Grants permission to get information about the specified query execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetQueryExecution.html
     */
    toGetQueryExecution() {
        return this.to('GetQueryExecution');
    }
    /**
     * Grants permission to get the query results
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetQueryResults.html
     */
    toGetQueryResults() {
        return this.to('GetQueryResults');
    }
    /**
     * Grants permission to get the query results stream
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/ug/connect-with-previous-jdbc.html#jdbc-prev-version-policies
     */
    toGetQueryResultsStream() {
        return this.to('GetQueryResultsStream');
    }
    /**
     * Grants permission to get runtime statistics for the specified query execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetQueryRuntimeStatistics.html
     */
    toGetQueryRuntimeStatistics() {
        return this.to('GetQueryRuntimeStatistics');
    }
    /**
     * Grants permission to get a session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetSession.html
     */
    toGetSession() {
        return this.to('GetSession');
    }
    /**
     * Grants permission to get a session status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetSessionStatus.html
     */
    toGetSessionStatus() {
        return this.to('GetSessionStatus');
    }
    /**
     * Grants permission to get a metadata about a table for a given datacatalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetTableMetadata.html
     */
    toGetTableMetadata() {
        return this.to('GetTableMetadata');
    }
    /**
     * Grants permission to get a workgroup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_GetWorkGroup.html
     */
    toGetWorkGroup() {
        return this.to('GetWorkGroup');
    }
    /**
     * Grants permission to import a notebook
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ImportNotebook.html
     */
    toImportNotebook() {
        return this.to('ImportNotebook');
    }
    /**
     * Grants permission to return a list of ApplicationRuntimeIds
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListApplicationDPUSizes.html
     */
    toListApplicationDPUSizes() {
        return this.to('ListApplicationDPUSizes');
    }
    /**
     * Grants permission to return a list of calculation executions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListCalculationExecutions.html
     */
    toListCalculationExecutions() {
        return this.to('ListCalculationExecutions');
    }
    /**
     * Grants permission to return a list of datacatalogs for the specified AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListDataCatalogs.html
     */
    toListDataCatalogs() {
        return this.to('ListDataCatalogs');
    }
    /**
     * Grants permission to return a list of databases for a given datacatalog
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListDatabases.html
     */
    toListDatabases() {
        return this.to('ListDatabases');
    }
    /**
     * Grants permission to return a list of athena engine versions for the specified AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListEngineVersions.html
     */
    toListEngineVersions() {
        return this.to('ListEngineVersions');
    }
    /**
     * Grants permission to return a list of executors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListExecutors.html
     */
    toListExecutors() {
        return this.to('ListExecutors');
    }
    /**
     * Grants permission to return a list of named queries in Amazon Athena for the specified AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListNamedQueries.html
     */
    toListNamedQueries() {
        return this.to('ListNamedQueries');
    }
    /**
     * Grants permission to return a list of notebooks for a given workgroup
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListNotebookMetadata.html
     */
    toListNotebookMetadata() {
        return this.to('ListNotebookMetadata');
    }
    /**
     * Grants permission to return a list of sessions for a given notebook
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListNotebookSessions.html
     */
    toListNotebookSessions() {
        return this.to('ListNotebookSessions');
    }
    /**
     * Grants permission to return a list of prepared statements for the specified workgroup
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListPreparedStatements.html
     */
    toListPreparedStatements() {
        return this.to('ListPreparedStatements');
    }
    /**
     * Grants permission to return a list of query executions for the specified AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListQueryExecutions.html
     */
    toListQueryExecutions() {
        return this.to('ListQueryExecutions');
    }
    /**
     * Grants permission to return a list of sessions for a given workgroup
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListSessions.html
     */
    toListSessions() {
        return this.to('ListSessions');
    }
    /**
     * Grants permission to return a list of table metadata in a database for a given datacatalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListTableMetadata.html
     */
    toListTableMetadata() {
        return this.to('ListTableMetadata');
    }
    /**
     * Grants permission to return a list of tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to return a list of workgroups for the specified AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_ListWorkGroups.html
     */
    toListWorkGroups() {
        return this.to('ListWorkGroups');
    }
    /**
     * Grants permission to start a calculation execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_StartCalculationExecution.html
     */
    toStartCalculationExecution() {
        return this.to('StartCalculationExecution');
    }
    /**
     * Grants permission to start a query execution using an SQL query provided as a string
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_StartQueryExecution.html
     */
    toStartQueryExecution() {
        return this.to('StartQueryExecution');
    }
    /**
     * Grants permission to start a session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_StartSession.html
     */
    toStartSession() {
        return this.to('StartSession');
    }
    /**
     * Grants permission to stop a calculation execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_StopCalculationExecution.html
     */
    toStopCalculationExecution() {
        return this.to('StopCalculationExecution');
    }
    /**
     * Grants permission to stop the specified query execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_StopQueryExecution.html
     */
    toStopQueryExecution() {
        return this.to('StopQueryExecution');
    }
    /**
     * Grants permission to add a tag to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to terminate a session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_TerminateSession.html
     */
    toTerminateSession() {
        return this.to('TerminateSession');
    }
    /**
     * Grants permission to remove a tag from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a datacatalog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_UpdateDataCatalog.html
     */
    toUpdateDataCatalog() {
        return this.to('UpdateDataCatalog');
    }
    /**
     * Grants permission to update a named query specified
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_UpdateNamedQuery.html
     */
    toUpdateNamedQuery() {
        return this.to('UpdateNamedQuery');
    }
    /**
     * Grants permission to update a notebook
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_UpdateNotebook.html
     */
    toUpdateNotebook() {
        return this.to('UpdateNotebook');
    }
    /**
     * Grants permission to update notebook metadata
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_UpdateNotebookMetadata.html
     */
    toUpdateNotebookMetadata() {
        return this.to('UpdateNotebookMetadata');
    }
    /**
     * Grants permission to update a prepared statement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_UpdatePreparedStatement.html
     */
    toUpdatePreparedStatement() {
        return this.to('UpdatePreparedStatement');
    }
    /**
     * Grants permission to update a workgroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/athena/latest/APIReference/API_UpdateWorkGroup.html
     */
    toUpdateWorkGroup() {
        return this.to('UpdateWorkGroup');
    }
    /**
     * Adds a resource of type datacatalog to the statement
     *
     * https://docs.aws.amazon.com/athena/latest/ug/datacatalogs-example-policies.html
     *
     * @param dataCatalogName - Identifier for the dataCatalogName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDatacatalog(dataCatalogName, account, region, partition) {
        return this.on(`arn:${partition || Athena.defaultPartition}:athena:${region || '*'}:${account || '*'}:datacatalog/${dataCatalogName}`);
    }
    /**
     * Adds a resource of type workgroup to the statement
     *
     * https://docs.aws.amazon.com/athena/latest/ug/example-policies-workgroup.html
     *
     * @param workGroupName - Identifier for the workGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkgroup(workGroupName, account, region, partition) {
        return this.on(`arn:${partition || Athena.defaultPartition}:athena:${region || '*'}:${account || '*'}:workgroup/${workGroupName}`);
    }
}
exports.Athena = Athena;
_a = JSII_RTTI_SYMBOL_1;
Athena[_a] = { fqn: "iam-floyd.Athena", version: "0.502.0" };
//# sourceMappingURL=data:application/json;base64,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